/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.hapi.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IContextValidationSupport;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.dstu3.hapi.ctx.IValidationSupport;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingValidationSupport
implements IValidationSupport {
    private static final Logger ourLog = LoggerFactory.getLogger(CachingValidationSupport.class);
    private final IValidationSupport myWrap;
    private final Cache<String, Object> myCache;

    public CachingValidationSupport(IValidationSupport theWrap) {
        this.myWrap = theWrap;
        this.myCache = Caffeine.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).build();
    }

    public ValueSet.ValueSetExpansionComponent expandValueSet(FhirContext theContext, ValueSet.ConceptSetComponent theInclude) {
        return this.myWrap.expandValueSet(theContext, theInclude);
    }

    public List<IBaseResource> fetchAllConformanceResources(FhirContext theContext) {
        return this.loadFromCache("fetchAllConformanceResources", t -> this.myWrap.fetchAllConformanceResources(theContext));
    }

    public List<StructureDefinition> fetchAllStructureDefinitions(FhirContext theContext) {
        return this.loadFromCache("fetchAllStructureDefinitions", t -> this.myWrap.fetchAllStructureDefinitions(theContext));
    }

    public CodeSystem fetchCodeSystem(FhirContext theContext, String uri) {
        return this.myWrap.fetchCodeSystem(theContext, uri);
    }

    public ValueSet fetchValueSet(FhirContext theContext, String uri) {
        return this.myWrap.fetchValueSet(theContext, uri);
    }

    public <T extends IBaseResource> T fetchResource(FhirContext theContext, Class<T> theClass, String theUri) {
        return (T)this.loadFromCache("fetchResource " + theClass.getName() + " " + theUri, t -> this.myWrap.fetchResource(theContext, theClass, theUri));
    }

    public StructureDefinition fetchStructureDefinition(FhirContext theCtx, String theUrl) {
        return this.myWrap.fetchStructureDefinition(theCtx, theUrl);
    }

    public boolean isCodeSystemSupported(FhirContext theContext, String theSystem) {
        return this.myWrap.isCodeSystemSupported(theContext, theSystem);
    }

    public IValidationSupport.CodeValidationResult validateCode(FhirContext theContext, String theCodeSystem, String theCode, String theDisplay) {
        return this.myWrap.validateCode(theContext, theCodeSystem, theCode, theDisplay);
    }

    public IContextValidationSupport.LookupCodeResult lookupCode(FhirContext theContext, String theSystem, String theCode) {
        return this.myWrap.lookupCode(theContext, theSystem, theCode);
    }

    public StructureDefinition generateSnapshot(StructureDefinition theInput, String theUrl, String theName) {
        return this.myWrap.generateSnapshot(theInput, theUrl, theName);
    }

    private <T> @Nullable T loadFromCache(String theKey, Function<String, T> theLoader) {
        ourLog.trace("Loading: {}", (Object)theKey);
        Function<String, Optional> loaderWrapper = key -> {
            ourLog.trace("Loading {} from cache", (Object)theKey);
            return Optional.ofNullable(theLoader.apply(theKey));
        };
        Optional result = (Optional)this.myCache.get((Object)theKey, loaderWrapper);
        return result.orElse(null);
    }

    public void flushCaches() {
        this.myCache.invalidateAll();
    }
}

