/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.hapi.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IContextValidationSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.hapi.ctx.IValidationSupport;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationSupportChain
implements IValidationSupport {
    private static final Logger ourLog = LoggerFactory.getLogger(ValidationSupportChain.class);
    private List<IValidationSupport> myChain = new ArrayList<IValidationSupport>();

    public ValidationSupportChain() {
    }

    public ValidationSupportChain(IValidationSupport ... theValidationSupportModules) {
        this();
        for (IValidationSupport next : theValidationSupportModules) {
            if (next == null) continue;
            this.myChain.add(next);
        }
    }

    public void addValidationSupport(IValidationSupport theValidationSupport) {
        this.myChain.add(theValidationSupport);
    }

    public ValueSet.ValueSetExpansionComponent expandValueSet(FhirContext theCtx, ValueSet.ConceptSetComponent theInclude) {
        for (IValidationSupport next : this.myChain) {
            ValueSet.ValueSetExpansionComponent expansion;
            if (StringUtils.isNotBlank((CharSequence)theInclude.getSystem()) && next.isCodeSystemSupported(theCtx, theInclude.getSystem()) && (expansion = next.expandValueSet(theCtx, theInclude)) != null) {
                return expansion;
            }
            ValueSet.ValueSetExpansionComponent retVal = next.expandValueSet(theCtx, theInclude);
            if (retVal == null || retVal.getContains().size() <= 0) continue;
            return retVal;
        }
        return this.myChain.get(0).expandValueSet(theCtx, theInclude);
    }

    public List<IBaseResource> fetchAllConformanceResources(FhirContext theContext) {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        for (IValidationSupport next : this.myChain) {
            List candidates = next.fetchAllConformanceResources(theContext);
            if (candidates == null) continue;
            retVal.addAll(candidates);
        }
        return retVal;
    }

    public List<StructureDefinition> fetchAllStructureDefinitions(FhirContext theContext) {
        ArrayList<StructureDefinition> retVal = new ArrayList<StructureDefinition>();
        HashSet<String> urls = new HashSet<String>();
        for (IValidationSupport nextSupport : this.myChain) {
            List list = nextSupport.fetchAllStructureDefinitions(theContext);
            if (list == null) continue;
            for (StructureDefinition next : list) {
                if (!StringUtils.isBlank((CharSequence)next.getUrl()) && !urls.add(next.getUrl())) continue;
                retVal.add(next);
            }
        }
        return retVal;
    }

    public CodeSystem fetchCodeSystem(FhirContext theCtx, String theSystem) {
        for (IValidationSupport next : this.myChain) {
            CodeSystem retVal;
            if (!next.isCodeSystemSupported(theCtx, theSystem) || (retVal = next.fetchCodeSystem(theCtx, theSystem)) == null) continue;
            return retVal;
        }
        return null;
    }

    public ValueSet fetchValueSet(FhirContext theCtx, String uri) {
        for (IValidationSupport next : this.myChain) {
            ValueSet retVal = next.fetchValueSet(theCtx, uri);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public <T extends IBaseResource> T fetchResource(FhirContext theContext, Class<T> theClass, String theUri) {
        for (IValidationSupport next : this.myChain) {
            IBaseResource retVal = next.fetchResource(theContext, theClass, theUri);
            if (retVal == null) continue;
            return (T)retVal;
        }
        return null;
    }

    public StructureDefinition fetchStructureDefinition(FhirContext theCtx, String theUrl) {
        for (IValidationSupport next : this.myChain) {
            StructureDefinition retVal = next.fetchStructureDefinition(theCtx, theUrl);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public boolean isCodeSystemSupported(FhirContext theCtx, String theSystem) {
        for (IValidationSupport next : this.myChain) {
            if (!next.isCodeSystemSupported(theCtx, theSystem)) continue;
            return true;
        }
        return false;
    }

    public IValidationSupport.CodeValidationResult validateCode(FhirContext theCtx, String theCodeSystem, String theCode, String theDisplay) {
        ourLog.debug("Validating code {} in chain with {} items", (Object)theCode, (Object)this.myChain.size());
        for (IValidationSupport next : this.myChain) {
            if (next.isCodeSystemSupported(theCtx, theCodeSystem)) {
                IValidationSupport.CodeValidationResult result = next.validateCode(theCtx, theCodeSystem, theCode, theDisplay);
                if (result == null) continue;
                ourLog.debug("Chain item {} returned outcome {}", (Object)next, (Object)result.isOk());
                return result;
            }
            ourLog.debug("Chain item {} does not support code system {}", (Object)next, (Object)theCodeSystem);
        }
        return this.myChain.get(0).validateCode(theCtx, theCodeSystem, theCode, theDisplay);
    }

    public IContextValidationSupport.LookupCodeResult lookupCode(FhirContext theContext, String theSystem, String theCode) {
        for (IValidationSupport next : this.myChain) {
            if (!next.isCodeSystemSupported(theContext, theSystem)) continue;
            return next.lookupCode(theContext, theSystem, theCode);
        }
        return null;
    }

    public StructureDefinition generateSnapshot(StructureDefinition theInput, String theUrl, String theProfileName) {
        IValidationSupport next;
        StructureDefinition outcome = null;
        Iterator<IValidationSupport> iterator = this.myChain.iterator();
        while (iterator.hasNext() && (outcome = (next = iterator.next()).generateSnapshot(theInput, theUrl, theProfileName)) == null) {
        }
        return outcome;
    }
}

