/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.hapi.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu2.model.Bundle;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.IdType;
import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.instance.hapi.validation.FhirInstanceValidator;
import org.hl7.fhir.instance.hapi.validation.IValidationSupport;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class DefaultProfileValidationSupport
implements IValidationSupport {
    private Map<String, ValueSet> myDefaultValueSets;
    private Map<String, ValueSet> myCodeSystems;
    private static final Set<String> ourResourceNames;
    private static final FhirContext ourHl7OrgCtx;

    @Override
    public List<StructureDefinition> allStructures() {
        ArrayList<StructureDefinition> retVal = new ArrayList<StructureDefinition>();
        for (String next : ourResourceNames) {
            StructureDefinition profile = FhirInstanceValidator.loadProfileOrReturnNull(null, ourHl7OrgCtx, next);
            retVal.add(profile);
        }
        return retVal;
    }

    @Override
    public ValueSet.ValueSetExpansionComponent expandValueSet(FhirContext theContext, ValueSet.ConceptSetComponent theInclude) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueSet fetchCodeSystem(FhirContext theContext, String theSystem) {
        DefaultProfileValidationSupport defaultProfileValidationSupport = this;
        synchronized (defaultProfileValidationSupport) {
            Map<String, ValueSet> valueSets = this.myCodeSystems;
            if (valueSets == null) {
                valueSets = new HashMap<String, ValueSet>();
                this.loadValueSets(theContext, valueSets, "/org/hl7/fhir/instance/model/valueset/valuesets.xml");
                this.loadValueSets(theContext, valueSets, "/org/hl7/fhir/instance/model/valueset/v2-tables.xml");
                this.loadValueSets(theContext, valueSets, "/org/hl7/fhir/instance/model/valueset/v3-codesystems.xml");
                this.myCodeSystems = valueSets;
            }
            return valueSets.get(theSystem);
        }
    }

    @Override
    public <T extends IBaseResource> T fetchResource(FhirContext theContext, Class<T> theClass, String theUri) {
        if (theUri.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
            return (T)FhirInstanceValidator.loadProfileOrReturnNull(null, theContext, theUri.substring("http://hl7.org/fhir/StructureDefinition/".length()));
        }
        if (theUri.startsWith("http://hl7.org/fhir/ValueSet/")) {
            Map<String, ValueSet> defaultValueSets = this.myDefaultValueSets;
            if (defaultValueSets == null) {
                InputStreamReader reader;
                String path = theContext.getVersion().getPathToSchemaDefinitions().replace("/schema", "/valueset") + "/valuesets.xml";
                InputStream valuesetText = DefaultProfileValidationSupport.class.getResourceAsStream(path);
                if (valuesetText == null) {
                    return null;
                }
                try {
                    reader = new InputStreamReader(valuesetText, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new InternalErrorException("UTF-8 encoding not supported on this platform", (Throwable)e);
                }
                defaultValueSets = new HashMap<String, ValueSet>();
                FhirContext ctx = FhirInstanceValidator.getHl7OrgDstu2Ctx(theContext);
                Bundle bundle = (Bundle)ctx.newXmlParser().parseResource(Bundle.class, (Reader)reader);
                for (Bundle.BundleEntryComponent next : bundle.getEntry()) {
                    IdType nextId = new IdType(next.getFullUrl());
                    if (nextId.isEmpty() || !nextId.getValue().startsWith("http://hl7.org/fhir/ValueSet/")) continue;
                    defaultValueSets.put(nextId.toVersionless().getValue(), (ValueSet)next.getResource());
                }
                this.myDefaultValueSets = defaultValueSets;
            }
            return (T)((IBaseResource)defaultValueSets.get(theUri));
        }
        return null;
    }

    public void flush() {
        this.myDefaultValueSets = null;
        this.myCodeSystems = null;
    }

    @Override
    public boolean isCodeSystemSupported(FhirContext theContext, String theSystem) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadValueSets(FhirContext theContext, Map<String, ValueSet> theValueSets, String theFile) {
        block8: {
            InputStream valuesetText = DefaultProfileValidationSupport.class.getResourceAsStream(theFile);
            try {
                if (valuesetText == null) break block8;
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader(valuesetText, "UTF-8");
                    FhirContext ctx = FhirInstanceValidator.getHl7OrgDstu2Ctx(theContext);
                    Bundle bundle = (Bundle)ctx.newXmlParser().parseResource(Bundle.class, (Reader)reader);
                    for (Bundle.BundleEntryComponent next : bundle.getEntry()) {
                        ValueSet nextValueSet = (ValueSet)next.getResource();
                        String system = nextValueSet.getCodeSystem().getSystem();
                        if (!StringUtils.isNotBlank((CharSequence)system)) continue;
                        theValueSets.put(system, nextValueSet);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    try {
                        throw new InternalErrorException("UTF-8 encoding not supported on this platform", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            finally {
                IOUtils.closeQuietly((InputStream)valuesetText);
            }
        }
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCode(FhirContext theContext, String theCodeSystem, String theCode, String theDisplay) {
        ValueSet vs = this.fetchCodeSystem(theContext, theCodeSystem);
        if (vs != null) {
            for (ValueSet.ConceptDefinitionComponent nextConcept : vs.getCodeSystem().getConcept()) {
                if (!nextConcept.getCode().equals(theCode)) continue;
                ValueSet.ConceptDefinitionComponent component = new ValueSet.ConceptDefinitionComponent(new CodeType(theCode));
                return new IValidationSupport.CodeValidationResult(component);
            }
        }
        return new IValidationSupport.CodeValidationResult(ValidationMessage.IssueSeverity.WARNING, "Unknown code: " + theCodeSystem + " / " + theCode);
    }

    static {
        ourHl7OrgCtx = FhirContext.forDstu2Hl7Org();
        ourResourceNames = FhirContext.forDstu2().getResourceNames();
    }
}

