/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.hapi.validation;

import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import ca.uhn.fhir.validation.IResourceLoader;
import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.IValidatorModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu2.model.Questionnaire;
import org.hl7.fhir.dstu2.model.QuestionnaireResponse;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu2.utils.IWorkerContext;
import org.hl7.fhir.instance.hapi.validation.BaseValidatorBridge;
import org.hl7.fhir.instance.hapi.validation.WorkerContext;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.validation.QuestionnaireResponseValidator;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirQuestionnaireResponseValidator
extends BaseValidatorBridge
implements IValidatorModule {
    private static final Logger ourLog = LoggerFactory.getLogger(FhirQuestionnaireResponseValidator.class);
    private IResourceLoader myResourceLoader;
    private IWorkerContext myWorkerContext;

    private List<ValidationMessage> doValidate(IValidationContext<?> theValCtx, QuestionnaireResponse theResource) {
        WorkerContext workerCtx = new WorkerContext();
        ArrayList<ValidationMessage> retVal = new ArrayList<ValidationMessage>();
        if (!this.loadReferences((IBaseResource)theResource, workerCtx, theValCtx, retVal)) {
            return retVal;
        }
        QuestionnaireResponseValidator val = new QuestionnaireResponseValidator(this.myWorkerContext);
        val.validate(retVal, theResource);
        return retVal;
    }

    private boolean loadReferences(IBaseResource theResource, WorkerContext theWorkerCtx, IValidationContext<?> theValCtx, ArrayList<ValidationMessage> theMessages) {
        List refs = theValCtx.getFhirContext().newTerser().getAllResourceReferences(theResource);
        ArrayList<IBaseResource> newResources = new ArrayList<IBaseResource>();
        for (ResourceReferenceInfo nextRefInfo : refs) {
            IBaseResource resource;
            IIdType nextRef = nextRefInfo.getResourceReference().getReferenceElement();
            String resourceType = nextRef.getResourceType();
            if (nextRef.isLocal()) {
                resource = nextRefInfo.getResourceReference().getResource();
                if (resource instanceof ValueSet) {
                    theWorkerCtx.getValueSets().put(nextRef.getValue(), (ValueSet)resource);
                    newResources.add(resource);
                    continue;
                }
                if (resource instanceof Questionnaire) {
                    theWorkerCtx.getQuestionnaires().put(nextRef.getValue(), (Questionnaire)resource);
                    newResources.add(resource);
                    continue;
                }
                if (resource != null) continue;
                theMessages.add(new ValidationMessage(ValidationMessage.Source.QuestionnaireResponseValidator, ValidationMessage.IssueType.INVALID, "", "Invalid reference '" + nextRef.getValue() + "' - No contained resource with this ID found", ValidationMessage.IssueSeverity.FATAL));
                continue;
            }
            if (StringUtils.isBlank((CharSequence)resourceType)) {
                theMessages.add(new ValidationMessage(ValidationMessage.Source.QuestionnaireResponseValidator, ValidationMessage.IssueType.INVALID, "", "Invalid reference '" + nextRef.getValue() + "' - Does not identify resource type", ValidationMessage.IssueSeverity.FATAL));
                continue;
            }
            if ("ValueSet".equals(resourceType)) {
                if (theWorkerCtx.getValueSets().containsKey(nextRef.getValue())) continue;
                resource = this.tryToLoad(ValueSet.class, nextRef, theMessages);
                if (resource == null) {
                    return false;
                }
                theWorkerCtx.getValueSets().put(nextRef.getValue(), (ValueSet)resource);
                newResources.add(resource);
                continue;
            }
            if (!"Questionnaire".equals(resourceType) || theWorkerCtx.getQuestionnaires().containsKey(nextRef.getValue())) continue;
            resource = this.tryToLoad(Questionnaire.class, nextRef, theMessages);
            if (resource == null) {
                return false;
            }
            theWorkerCtx.getQuestionnaires().put(nextRef.getValue(), (Questionnaire)resource);
            newResources.add(resource);
        }
        for (IBaseResource nextAddedResource : newResources) {
            boolean outcome = this.loadReferences(nextAddedResource, theWorkerCtx, theValCtx, theMessages);
            if (outcome) continue;
            return false;
        }
        return true;
    }

    public void setResourceLoader(IResourceLoader theResourceLoader) {
        this.myResourceLoader = theResourceLoader;
    }

    public void setWorkerContext(IWorkerContext theWorkerContext) {
        this.myWorkerContext = theWorkerContext;
    }

    private <T extends IBaseResource> T tryToLoad(Class<T> theType, IIdType theReference, List<ValidationMessage> theMessages) {
        if (this.myResourceLoader == null) {
            theMessages.add(new ValidationMessage().setLevel(ValidationMessage.IssueSeverity.FATAL).setMessage("No resource loader present, could not load " + theReference));
            return null;
        }
        try {
            IBaseResource retVal = this.myResourceLoader.load(theType, theReference);
            if (retVal == null) {
                throw new IllegalStateException("ResourceLoader returned null. This is a bug with the resourceloader. Reference was: " + theReference);
            }
            return (T)retVal;
        }
        catch (ResourceNotFoundException e) {
            theMessages.add(new ValidationMessage().setLevel(ValidationMessage.IssueSeverity.FATAL).setMessage("Reference could not be found: " + theReference));
            return null;
        }
    }

    @Override
    protected List<ValidationMessage> validate(IValidationContext<?> theCtx) {
        Object resource = theCtx.getResource();
        if (!(theCtx.getResource() instanceof IBaseResource)) {
            ourLog.debug("Not validating object of type {}", theCtx.getResource().getClass());
            return Collections.emptyList();
        }
        if (resource instanceof QuestionnaireResponse) {
            return this.doValidate(theCtx, (QuestionnaireResponse)resource);
        }
        RuntimeResourceDefinition def = theCtx.getFhirContext().getResourceDefinition((IBaseResource)resource);
        if (!"QuestionnaireResponse".equals(def.getName())) {
            return Collections.emptyList();
        }
        IParser p = theCtx.getFhirContext().newJsonParser();
        String string = p.encodeResourceToString((IBaseResource)resource);
        QuestionnaireResponse qa = (QuestionnaireResponse)p.parseResource(QuestionnaireResponse.class, string);
        return this.doValidate(theCtx, qa);
    }
}

