/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.validation;

import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.exceptions.DefinitionException;

public interface ExtensionLocatorService {
    public ExtensionLocationResponse locateExtension(String var1);

    public static class ExtensionLocationResponse {
        private Status status;
        private StructureDefinition definition;
        private String message;
        private String url;

        public ExtensionLocationResponse(String url, Status status, StructureDefinition definition, String message) {
            this.url = url;
            this.status = status;
            this.definition = definition;
            this.message = message;
        }

        public Status getStatus() {
            return this.status;
        }

        public StructureDefinition getDefinition() {
            return this.definition;
        }

        public String getMessage() {
            return this.message;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public ExtensionLocationResponse clone(String url) throws DefinitionException {
            if (!this.url.endsWith(url.substring(0, url.lastIndexOf(".")))) {
                throw new DefinitionException("the relative URL " + url + " cannot be used in the context " + this.url);
            }
            return new ExtensionLocationResponse(this.url + "." + url.substring(url.lastIndexOf(".") + 1), this.status, this.definition, this.message);
        }
    }

    public static enum Status {
        Located,
        NotAllowed,
        Unknown;

    }
}

