/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.hapi.validation;

import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.IValidatorModule;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.common.hapi.validation.ValidatorWrapper;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.ParserType;
import org.hl7.fhir.r5.hapi.ctx.DefaultProfileValidationSupport;
import org.hl7.fhir.r5.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.r5.hapi.ctx.IValidationSupport;
import org.hl7.fhir.r5.hapi.validation.BaseValidatorBridge;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.TypeDetails;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.INarrativeGenerator;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.utilities.TerminologyServiceOptions;
import org.hl7.fhir.utilities.TranslationServices;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class FhirInstanceValidator
extends BaseValidatorBridge
implements IValidatorModule {
    private boolean myAnyExtensionsAllowed = true;
    private IResourceValidator.BestPracticeWarningLevel myBestPracticeWarningLevel;
    private IValidationSupport myValidationSupport;
    private boolean noTerminologyChecks = false;
    private volatile WorkerContextWrapper myWrappedWorkerContext;
    private boolean errorForUnknownProfiles;
    private List<String> myExtensionDomains = Collections.emptyList();

    public FhirInstanceValidator() {
        this((IValidationSupport)new DefaultProfileValidationSupport());
    }

    public FhirInstanceValidator(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
    }

    public FhirInstanceValidator setCustomExtensionDomains(List<String> extensionDomains) {
        this.myExtensionDomains = extensionDomains;
        return this;
    }

    public FhirInstanceValidator setCustomExtensionDomains(String ... extensionDomains) {
        this.myExtensionDomains = Arrays.asList(extensionDomains);
        return this;
    }

    public IResourceValidator.BestPracticeWarningLevel getBestPracticeWarningLevel() {
        return this.myBestPracticeWarningLevel;
    }

    public void setBestPracticeWarningLevel(IResourceValidator.BestPracticeWarningLevel theBestPracticeWarningLevel) {
        Validate.notNull((Object)theBestPracticeWarningLevel);
        this.myBestPracticeWarningLevel = theBestPracticeWarningLevel;
    }

    public IValidationSupport getValidationSupport() {
        return this.myValidationSupport;
    }

    public void setValidationSupport(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
        this.myWrappedWorkerContext = null;
    }

    public boolean isAnyExtensionsAllowed() {
        return this.myAnyExtensionsAllowed;
    }

    public void setAnyExtensionsAllowed(boolean theAnyExtensionsAllowed) {
        this.myAnyExtensionsAllowed = theAnyExtensionsAllowed;
    }

    public boolean isErrorForUnknownProfiles() {
        return this.errorForUnknownProfiles;
    }

    public void setErrorForUnknownProfiles(boolean errorForUnknownProfiles) {
        this.errorForUnknownProfiles = errorForUnknownProfiles;
    }

    public boolean isNoTerminologyChecks() {
        return this.noTerminologyChecks;
    }

    public void setNoTerminologyChecks(boolean theNoTerminologyChecks) {
        this.noTerminologyChecks = theNoTerminologyChecks;
    }

    public List<String> getExtensionDomains() {
        return this.myExtensionDomains;
    }

    @Override
    protected List<ValidationMessage> validate(IValidationContext<?> theValidationCtx) {
        WorkerContextWrapper wrappedWorkerContext = this.myWrappedWorkerContext;
        if (wrappedWorkerContext == null) {
            HapiWorkerContext workerContext = new HapiWorkerContext(theValidationCtx.getFhirContext(), this.myValidationSupport);
            wrappedWorkerContext = new WorkerContextWrapper(workerContext);
        }
        this.myWrappedWorkerContext = wrappedWorkerContext;
        return new ValidatorWrapper().setAnyExtensionsAllowed(this.isAnyExtensionsAllowed()).setBestPracticeWarningLevel(this.getBestPracticeWarningLevel()).setErrorForUnknownProfiles(this.isErrorForUnknownProfiles()).setExtensionDomains(this.getExtensionDomains()).setNoTerminologyChecks(this.isNoTerminologyChecks()).validate(wrappedWorkerContext, theValidationCtx);
    }

    private static class ResourceKey {
        private final int myHashCode;
        private String myResourceName;
        private String myUri;

        private ResourceKey(String theResourceName, String theUri) {
            this.myResourceName = theResourceName;
            this.myUri = theUri;
            this.myHashCode = new HashCodeBuilder(17, 37).append((Object)this.myResourceName).append((Object)this.myUri).toHashCode();
        }

        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (theO == null || this.getClass() != theO.getClass()) {
                return false;
            }
            ResourceKey that = (ResourceKey)theO;
            return new EqualsBuilder().append((Object)this.myResourceName, (Object)that.myResourceName).append((Object)this.myUri, (Object)that.myUri).isEquals();
        }

        public String getResourceName() {
            return this.myResourceName;
        }

        public String getUri() {
            return this.myUri;
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }

    public static class NullEvaluationContext
    implements FHIRPathEngine.IEvaluationContext {
        public Base resolveConstant(Object appContext, String name, boolean beforeContext) throws PathEngineException {
            return null;
        }

        public TypeDetails resolveConstantType(Object appContext, String name) throws PathEngineException {
            return null;
        }

        public boolean log(String argument, List<Base> focus) {
            return false;
        }

        public FHIRPathEngine.IEvaluationContext.FunctionDetails resolveFunction(String functionName) {
            return null;
        }

        public TypeDetails checkFunction(Object appContext, String functionName, List<TypeDetails> parameters) throws PathEngineException {
            return null;
        }

        public List<Base> executeFunction(Object appContext, String functionName, List<List<Base>> parameters) {
            return null;
        }

        public Base resolveReference(Object appContext, String url) throws FHIRException {
            return null;
        }

        public boolean conformsToProfile(Object appContext, Base item, String url) throws FHIRException {
            return false;
        }

        public ValueSet resolveValueSet(Object appContext, String url) {
            return null;
        }
    }

    private static class WorkerContextWrapper
    implements IWorkerContext {
        private final HapiWorkerContext myWrap;
        private volatile List<StructureDefinition> myAllStructures;
        private LoadingCache<ResourceKey, Resource> myFetchResourceCache;
        private Parameters myExpansionProfile;

        WorkerContextWrapper(HapiWorkerContext theWorkerContext) {
            this.myWrap = theWorkerContext;
            long timeoutMillis = 10000L;
            if (System.getProperties().containsKey("TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS")) {
                timeoutMillis = Long.parseLong(System.getProperty("TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS"));
            }
            this.myFetchResourceCache = Caffeine.newBuilder().expireAfterWrite(timeoutMillis, TimeUnit.MILLISECONDS).maximumSize(10000L).build((CacheLoader)new CacheLoader<ResourceKey, Resource>(){

                public Resource load(ResourceKey key) throws Exception {
                    Resource fetched;
                    switch (key.getResourceName()) {
                        case "StructureDefinition": {
                            fetched = myWrap.fetchResource(StructureDefinition.class, key.getUri());
                            break;
                        }
                        case "ValueSet": {
                            fetched = myWrap.fetchResource(ValueSet.class, key.getUri());
                            break;
                        }
                        case "CodeSystem": {
                            fetched = myWrap.fetchResource(CodeSystem.class, key.getUri());
                            break;
                        }
                        case "Questionnaire": {
                            fetched = myWrap.fetchResource(Questionnaire.class, key.getUri());
                            break;
                        }
                        case "ImplementationGuide": {
                            fetched = myWrap.fetchResource(ImplementationGuide.class, key.getUri());
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Don't know how to fetch " + key.getResourceName());
                        }
                    }
                    if (fetched == null) {
                        return null;
                    }
                    try {
                        return fetched;
                    }
                    catch (FHIRException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
            });
        }

        public List<MetadataResource> allConformanceResources() {
            throw new UnsupportedOperationException();
        }

        public void generateSnapshot(StructureDefinition p) throws FHIRException {
        }

        public Parameters getExpansionParameters() {
            return this.myExpansionProfile;
        }

        public void setExpansionProfile(Parameters expParameters) {
            this.myExpansionProfile = expParameters;
        }

        public List<StructureDefinition> allStructures() {
            List<StructureDefinition> retVal = this.myAllStructures;
            if (retVal == null) {
                retVal = new ArrayList<StructureDefinition>();
                for (StructureDefinition next : this.myWrap.allStructures()) {
                    try {
                        retVal.add(next);
                    }
                    catch (FHIRException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
                this.myAllStructures = retVal;
            }
            return retVal;
        }

        public List<StructureDefinition> getStructures() {
            return this.allStructures();
        }

        public void cacheResource(Resource res) {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        private IWorkerContext.ValidationResult convertValidationResult(@Nullable IWorkerContext.ValidationResult theResult) {
            IWorkerContext.ValidationResult retVal = null;
            if (theResult != null) {
                ValidationMessage.IssueSeverity issueSeverity = theResult.getSeverity();
                String message = theResult.getMessage();
                CodeSystem.ConceptDefinitionComponent conceptDefinition = null;
                if (theResult.asConceptDefinition() != null) {
                    try {
                        conceptDefinition = theResult.asConceptDefinition();
                    }
                    catch (FHIRException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
                retVal = new IWorkerContext.ValidationResult(issueSeverity, message, conceptDefinition);
            }
            if (retVal == null) {
                retVal = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Validation failed");
            }
            return retVal;
        }

        public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet source, boolean cacheOk, boolean heiarchical) {
            ValueSet convertedSource;
            try {
                convertedSource = source;
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
            ValueSetExpander.ValueSetExpansionOutcome expanded = this.myWrap.expandVS(convertedSource, cacheOk, heiarchical);
            ValueSet convertedResult = null;
            if (expanded.getValueset() != null) {
                try {
                    convertedResult = expanded.getValueset();
                }
                catch (FHIRException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            String error = expanded.getError();
            ValueSetExpander.TerminologyServiceErrorClass result = null;
            return new ValueSetExpander.ValueSetExpansionOutcome(convertedResult, error, result);
        }

        public ValueSetExpander.ValueSetExpansionOutcome expandVS(ElementDefinition.ElementDefinitionBindingComponent binding, boolean cacheOk, boolean heiarchical) {
            throw new UnsupportedOperationException();
        }

        public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent inc, boolean heirarchical) throws TerminologyServiceException {
            ValueSet.ConceptSetComponent convertedInc = null;
            if (inc != null) {
                try {
                    convertedInc = inc;
                }
                catch (FHIRException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            ValueSetExpander.ValueSetExpansionOutcome expansion = this.myWrap.expandVS(convertedInc, heirarchical);
            ValueSet valueSetExpansion = null;
            if (expansion != null) {
                try {
                    valueSetExpansion = expansion.getValueset();
                }
                catch (FHIRException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            ValueSetExpander.ValueSetExpansionOutcome outcome = new ValueSetExpander.ValueSetExpansionOutcome(valueSetExpansion);
            return outcome;
        }

        public CodeSystem fetchCodeSystem(String system) {
            CodeSystem fetched = this.myWrap.fetchCodeSystem(system);
            if (fetched == null) {
                return null;
            }
            try {
                return fetched;
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }

        public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
            ResourceKey key = new ResourceKey(class_.getSimpleName(), uri);
            Resource retVal = (Resource)this.myFetchResourceCache.get((Object)key);
            return (T)retVal;
        }

        public Resource fetchResourceById(String type, String uri) {
            throw new UnsupportedOperationException();
        }

        public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri) throws FHIRException {
            T retVal = this.fetchResource(class_, uri);
            if (retVal == null) {
                throw new FHIRException("Can not find resource of type " + class_.getSimpleName() + " with uri " + uri);
            }
            return retVal;
        }

        public List<ConceptMap> findMapsForSource(String url) {
            throw new UnsupportedOperationException();
        }

        public String getAbbreviation(String name) {
            return this.myWrap.getAbbreviation(name);
        }

        public INarrativeGenerator getNarrativeGenerator(String prefix, String basePath) {
            throw new UnsupportedOperationException();
        }

        public IParser getParser(ParserType type) {
            throw new UnsupportedOperationException();
        }

        public IParser getParser(String type) {
            throw new UnsupportedOperationException();
        }

        public List<String> getResourceNames() {
            return this.myWrap.getResourceNames();
        }

        public Set<String> getResourceNamesAsSet() {
            return new HashSet<String>(this.myWrap.getResourceNames());
        }

        public StructureMap getTransform(String url) {
            throw new UnsupportedOperationException();
        }

        public String getOverrideVersionNs() {
            return null;
        }

        public void setOverrideVersionNs(String value) {
        }

        public StructureDefinition fetchTypeDefinition(String typeName) {
            return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
        }

        public List<String> getTypeNames() {
            return this.myWrap.getTypeNames();
        }

        public UcumService getUcumService() {
            throw new UnsupportedOperationException();
        }

        public void setUcumService(UcumService ucumService) {
            throw new UnsupportedOperationException();
        }

        public String getVersion() {
            return this.myWrap.getVersion();
        }

        public boolean hasCache() {
            return this.myWrap.hasCache();
        }

        public <T extends Resource> boolean hasResource(Class<T> class_, String uri) {
            throw new UnsupportedOperationException();
        }

        public boolean isNoTerminologyServer() {
            return this.myWrap.isNoTerminologyServer();
        }

        public List<StructureMap> listTransforms() {
            throw new UnsupportedOperationException();
        }

        public IParser newJsonParser() {
            throw new UnsupportedOperationException();
        }

        public IResourceValidator newValidator() {
            throw new UnsupportedOperationException();
        }

        public IParser newXmlParser() {
            throw new UnsupportedOperationException();
        }

        public String oid2Uri(String code) {
            return this.myWrap.oid2Uri(code);
        }

        public IWorkerContext.ILoggingService getLogger() {
            return null;
        }

        public void setLogger(IWorkerContext.ILoggingService logger) {
            throw new UnsupportedOperationException();
        }

        public boolean supportsSystem(String system) {
            return this.myWrap.supportsSystem(system);
        }

        public TranslationServices translator() {
            throw new UnsupportedOperationException();
        }

        public Set<String> typeTails() {
            return this.myWrap.typeTails();
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, String system, String code, String display) {
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(theOptions, system, code, display);
            return this.convertValidationResult(result);
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, String system, String code, String display, ValueSet vs) {
            ValueSet convertedVs = null;
            try {
                if (vs != null) {
                    convertedVs = vs;
                }
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(theOptions, system, code, display, convertedVs);
            return this.convertValidationResult(result);
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, String code, ValueSet vs) {
            ValueSet convertedVs = null;
            try {
                if (vs != null) {
                    convertedVs = vs;
                }
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(theOptions, null, code, null, convertedVs);
            return this.convertValidationResult(result);
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, Coding code, ValueSet vs) {
            Coding convertedCode = null;
            ValueSet convertedVs = null;
            try {
                if (code != null) {
                    convertedCode = code;
                }
                if (vs != null) {
                    convertedVs = vs;
                }
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(theOptions, convertedCode, convertedVs);
            return this.convertValidationResult(result);
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, CodeableConcept code, ValueSet vs) {
            CodeableConcept convertedCode = null;
            ValueSet convertedVs = null;
            try {
                if (code != null) {
                    convertedCode = code;
                }
                if (vs != null) {
                    convertedVs = vs;
                }
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(theOptions, convertedCode, convertedVs);
            return this.convertValidationResult(result);
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, String system, String code, String display, ValueSet.ConceptSetComponent vsi) {
            ValueSet.ConceptSetComponent conceptSetComponent = null;
            if (vsi != null) {
                try {
                    conceptSetComponent = vsi;
                }
                catch (FHIRException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(theOptions, system, code, display, conceptSetComponent);
            return this.convertValidationResult(result);
        }
    }
}

