/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.formats;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.ParserBase;
import org.hl7.fhir.dstu2016may.formats.ParserType;
import org.hl7.fhir.dstu2016may.formats.RdfGenerator;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public abstract class RdfParserBase
extends ParserBase
implements IParser {
    private String url;

    protected abstract void composeResource(RdfGenerator.Complex var1, Resource var2) throws IOException;

    @Override
    public ParserType getType() {
        return ParserType.RDF_TURTLE;
    }

    @Override
    public Resource parse(InputStream input) throws IOException, FHIRFormatError {
        throw new Error("Parsing not implemented yet");
    }

    @Override
    public Type parseType(InputStream input, String knownType) throws IOException, FHIRFormatError {
        throw new Error("Parsing not implemented yet");
    }

    @Override
    public void compose(OutputStream stream, Resource resource) throws IOException {
        RdfGenerator ttl = new RdfGenerator(stream);
        ttl.prefix("fhir", "http://hl7.org/fhir/");
        ttl.prefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        RdfGenerator.Section section = ttl.section("resource");
        RdfGenerator.Subject subject = this.url != null ? section.triple("<" + this.url + ">", "a", "fhir:" + resource.getResourceType().toString()) : section.triple("_", "a", "fhir:" + resource.getResourceType().toString());
        this.composeResource(subject, resource);
        try {
            ttl.commit(false);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void compose(OutputStream stream, Type type, String rootName) throws IOException {
        throw new Error("Not supported in RDF");
    }

    protected String ttlLiteral(String value) {
        return "\"" + RdfGenerator.escape(value, true) + "\"";
    }

    protected void composeXhtml(RdfGenerator.Complex t, String string, String string2, XhtmlNode div, int i) {
    }

    protected void decorateCode(RdfGenerator.Complex t, Enumeration<? extends Enum> value) {
    }

    protected void decorateCode(RdfGenerator.Complex t, CodeType value) {
    }

    protected void decorateCoding(RdfGenerator.Complex t, Coding element) {
        if (!element.hasSystem()) {
            return;
        }
        if ("http://snomed.info/sct".equals(element.getSystem())) {
            t.prefix("sct", "http://snomed.info/sct/");
            t.predicate("a", "sct:" + element.getCode());
        } else if ("http://snomed.info/sct".equals(element.getSystem())) {
            t.prefix("loinc", "http://loinc.org/rdf#");
            t.predicate("a", "loinc:" + element.getCode());
        }
    }

    protected void decorateCodeableConcept(RdfGenerator.Complex t, CodeableConcept element) {
        for (Coding c : element.getCoding()) {
            this.decorateCoding(t, c);
        }
    }
}

