/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ModuleDefinition", profile="http://hl7.org/fhir/Profile/ModuleDefinition")
public class ModuleDefinition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Logical identifier", formalDefinition="A logical identifier for the module such as the CMS or NQF identifiers for a measure artifact.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The version of the module, if any", formalDefinition="The version of the module, if any. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge modules, refer to the Decision Support Service specification.")
    protected StringType version;
    @Child(name="model", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="", formalDefinition="A model reference used by the content.")
    protected List<ModuleDefinitionModelComponent> model;
    @Child(name="library", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A library referenced by the module", formalDefinition="A library referenced by the module. The reference must consist of either an id, or a document reference.")
    protected List<ModuleDefinitionLibraryComponent> library;
    @Child(name="codeSystem", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="", formalDefinition="A code system definition used within the knowledge module.")
    protected List<ModuleDefinitionCodeSystemComponent> codeSystem;
    @Child(name="valueSet", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="", formalDefinition="A value set definition used by the knowledge module.")
    protected List<ModuleDefinitionValueSetComponent> valueSet;
    @Child(name="parameter", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="", formalDefinition="Parameters to the module.")
    protected List<ModuleDefinitionParameterComponent> parameter;
    @Child(name="data", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Describes a required data item", formalDefinition="Describes a required data item for evaluation in terms of the type of data, and optional code- or date-based filters of the data.")
    protected List<ModuleDefinitionDataComponent> data;
    private static final long serialVersionUID = -1288058693L;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ModuleDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ModuleDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public ModuleDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public ModuleDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public List<ModuleDefinitionModelComponent> getModel() {
        if (this.model == null) {
            this.model = new ArrayList<ModuleDefinitionModelComponent>();
        }
        return this.model;
    }

    public boolean hasModel() {
        if (this.model == null) {
            return false;
        }
        for (ModuleDefinitionModelComponent item : this.model) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ModuleDefinitionModelComponent addModel() {
        ModuleDefinitionModelComponent t = new ModuleDefinitionModelComponent();
        if (this.model == null) {
            this.model = new ArrayList<ModuleDefinitionModelComponent>();
        }
        this.model.add(t);
        return t;
    }

    public ModuleDefinition addModel(ModuleDefinitionModelComponent t) {
        if (t == null) {
            return this;
        }
        if (this.model == null) {
            this.model = new ArrayList<ModuleDefinitionModelComponent>();
        }
        this.model.add(t);
        return this;
    }

    public List<ModuleDefinitionLibraryComponent> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<ModuleDefinitionLibraryComponent>();
        }
        return this.library;
    }

    public boolean hasLibrary() {
        if (this.library == null) {
            return false;
        }
        for (ModuleDefinitionLibraryComponent item : this.library) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ModuleDefinitionLibraryComponent addLibrary() {
        ModuleDefinitionLibraryComponent t = new ModuleDefinitionLibraryComponent();
        if (this.library == null) {
            this.library = new ArrayList<ModuleDefinitionLibraryComponent>();
        }
        this.library.add(t);
        return t;
    }

    public ModuleDefinition addLibrary(ModuleDefinitionLibraryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.library == null) {
            this.library = new ArrayList<ModuleDefinitionLibraryComponent>();
        }
        this.library.add(t);
        return this;
    }

    public List<ModuleDefinitionCodeSystemComponent> getCodeSystem() {
        if (this.codeSystem == null) {
            this.codeSystem = new ArrayList<ModuleDefinitionCodeSystemComponent>();
        }
        return this.codeSystem;
    }

    public boolean hasCodeSystem() {
        if (this.codeSystem == null) {
            return false;
        }
        for (ModuleDefinitionCodeSystemComponent item : this.codeSystem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ModuleDefinitionCodeSystemComponent addCodeSystem() {
        ModuleDefinitionCodeSystemComponent t = new ModuleDefinitionCodeSystemComponent();
        if (this.codeSystem == null) {
            this.codeSystem = new ArrayList<ModuleDefinitionCodeSystemComponent>();
        }
        this.codeSystem.add(t);
        return t;
    }

    public ModuleDefinition addCodeSystem(ModuleDefinitionCodeSystemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.codeSystem == null) {
            this.codeSystem = new ArrayList<ModuleDefinitionCodeSystemComponent>();
        }
        this.codeSystem.add(t);
        return this;
    }

    public List<ModuleDefinitionValueSetComponent> getValueSet() {
        if (this.valueSet == null) {
            this.valueSet = new ArrayList<ModuleDefinitionValueSetComponent>();
        }
        return this.valueSet;
    }

    public boolean hasValueSet() {
        if (this.valueSet == null) {
            return false;
        }
        for (ModuleDefinitionValueSetComponent item : this.valueSet) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ModuleDefinitionValueSetComponent addValueSet() {
        ModuleDefinitionValueSetComponent t = new ModuleDefinitionValueSetComponent();
        if (this.valueSet == null) {
            this.valueSet = new ArrayList<ModuleDefinitionValueSetComponent>();
        }
        this.valueSet.add(t);
        return t;
    }

    public ModuleDefinition addValueSet(ModuleDefinitionValueSetComponent t) {
        if (t == null) {
            return this;
        }
        if (this.valueSet == null) {
            this.valueSet = new ArrayList<ModuleDefinitionValueSetComponent>();
        }
        this.valueSet.add(t);
        return this;
    }

    public List<ModuleDefinitionParameterComponent> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<ModuleDefinitionParameterComponent>();
        }
        return this.parameter;
    }

    public boolean hasParameter() {
        if (this.parameter == null) {
            return false;
        }
        for (ModuleDefinitionParameterComponent item : this.parameter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ModuleDefinitionParameterComponent addParameter() {
        ModuleDefinitionParameterComponent t = new ModuleDefinitionParameterComponent();
        if (this.parameter == null) {
            this.parameter = new ArrayList<ModuleDefinitionParameterComponent>();
        }
        this.parameter.add(t);
        return t;
    }

    public ModuleDefinition addParameter(ModuleDefinitionParameterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.parameter == null) {
            this.parameter = new ArrayList<ModuleDefinitionParameterComponent>();
        }
        this.parameter.add(t);
        return this;
    }

    public List<ModuleDefinitionDataComponent> getData() {
        if (this.data == null) {
            this.data = new ArrayList<ModuleDefinitionDataComponent>();
        }
        return this.data;
    }

    public boolean hasData() {
        if (this.data == null) {
            return false;
        }
        for (ModuleDefinitionDataComponent item : this.data) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ModuleDefinitionDataComponent addData() {
        ModuleDefinitionDataComponent t = new ModuleDefinitionDataComponent();
        if (this.data == null) {
            this.data = new ArrayList<ModuleDefinitionDataComponent>();
        }
        this.data.add(t);
        return t;
    }

    public ModuleDefinition addData(ModuleDefinitionDataComponent t) {
        if (t == null) {
            return this;
        }
        if (this.data == null) {
            this.data = new ArrayList<ModuleDefinitionDataComponent>();
        }
        this.data.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("identifier", "Identifier", "A logical identifier for the module such as the CMS or NQF identifiers for a measure artifact.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("version", "string", "The version of the module, if any. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge modules, refer to the Decision Support Service specification.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property("model", "", "A model reference used by the content.", 0, Integer.MAX_VALUE, this.model));
        childrenList.add(new Property("library", "", "A library referenced by the module. The reference must consist of either an id, or a document reference.", 0, Integer.MAX_VALUE, this.library));
        childrenList.add(new Property("codeSystem", "", "A code system definition used within the knowledge module.", 0, Integer.MAX_VALUE, this.codeSystem));
        childrenList.add(new Property("valueSet", "", "A value set definition used by the knowledge module.", 0, Integer.MAX_VALUE, this.valueSet));
        childrenList.add(new Property("parameter", "", "Parameters to the module.", 0, Integer.MAX_VALUE, this.parameter));
        childrenList.add(new Property("data", "", "Describes a required data item for evaluation in terms of the type of data, and optional code- or date-based filters of the data.", 0, Integer.MAX_VALUE, this.data));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.version;
                }
                return baseArray;
            }
            case 104069929: {
                return this.model == null ? new Base[]{} : this.model.toArray(new Base[this.model.size()]);
            }
            case 166208699: {
                return this.library == null ? new Base[]{} : this.library.toArray(new Base[this.library.size()]);
            }
            case -916511108: {
                return this.codeSystem == null ? new Base[]{} : this.codeSystem.toArray(new Base[this.codeSystem.size()]);
            }
            case -1410174671: {
                return this.valueSet == null ? new Base[]{} : this.valueSet.toArray(new Base[this.valueSet.size()]);
            }
            case 1954460585: {
                return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
            }
            case 3076010: {
                return this.data == null ? new Base[]{} : this.data.toArray(new Base[this.data.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 351608024: {
                this.version = this.castToString(value);
                break;
            }
            case 104069929: {
                this.getModel().add((ModuleDefinitionModelComponent)value);
                break;
            }
            case 166208699: {
                this.getLibrary().add((ModuleDefinitionLibraryComponent)value);
                break;
            }
            case -916511108: {
                this.getCodeSystem().add((ModuleDefinitionCodeSystemComponent)value);
                break;
            }
            case -1410174671: {
                this.getValueSet().add((ModuleDefinitionValueSetComponent)value);
                break;
            }
            case 1954460585: {
                this.getParameter().add((ModuleDefinitionParameterComponent)value);
                break;
            }
            case 3076010: {
                this.getData().add((ModuleDefinitionDataComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("version")) {
            this.version = this.castToString(value);
        } else if (name.equals("model")) {
            this.getModel().add((ModuleDefinitionModelComponent)value);
        } else if (name.equals("library")) {
            this.getLibrary().add((ModuleDefinitionLibraryComponent)value);
        } else if (name.equals("codeSystem")) {
            this.getCodeSystem().add((ModuleDefinitionCodeSystemComponent)value);
        } else if (name.equals("valueSet")) {
            this.getValueSet().add((ModuleDefinitionValueSetComponent)value);
        } else if (name.equals("parameter")) {
            this.getParameter().add((ModuleDefinitionParameterComponent)value);
        } else if (name.equals("data")) {
            this.getData().add((ModuleDefinitionDataComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                throw new FHIRException("Cannot make property version as it is not a complex type");
            }
            case 104069929: {
                return this.addModel();
            }
            case 166208699: {
                return this.addLibrary();
            }
            case -916511108: {
                return this.addCodeSystem();
            }
            case -1410174671: {
                return this.addValueSet();
            }
            case 1954460585: {
                return this.addParameter();
            }
            case 3076010: {
                return this.addData();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            return this.addIdentifier();
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.version");
        }
        if (name.equals("model")) {
            return this.addModel();
        }
        if (name.equals("library")) {
            return this.addLibrary();
        }
        if (name.equals("codeSystem")) {
            return this.addCodeSystem();
        }
        if (name.equals("valueSet")) {
            return this.addValueSet();
        }
        if (name.equals("parameter")) {
            return this.addParameter();
        }
        if (name.equals("data")) {
            return this.addData();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ModuleDefinition";
    }

    @Override
    public ModuleDefinition copy() {
        ModuleDefinition dst = new ModuleDefinition();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        StringType stringType = dst.version = this.version == null ? null : this.version.copy();
        if (this.model != null) {
            dst.model = new ArrayList<ModuleDefinitionModelComponent>();
            for (ModuleDefinitionModelComponent moduleDefinitionModelComponent : this.model) {
                dst.model.add(moduleDefinitionModelComponent.copy());
            }
        }
        if (this.library != null) {
            dst.library = new ArrayList<ModuleDefinitionLibraryComponent>();
            for (ModuleDefinitionLibraryComponent moduleDefinitionLibraryComponent : this.library) {
                dst.library.add(moduleDefinitionLibraryComponent.copy());
            }
        }
        if (this.codeSystem != null) {
            dst.codeSystem = new ArrayList<ModuleDefinitionCodeSystemComponent>();
            for (ModuleDefinitionCodeSystemComponent moduleDefinitionCodeSystemComponent : this.codeSystem) {
                dst.codeSystem.add(moduleDefinitionCodeSystemComponent.copy());
            }
        }
        if (this.valueSet != null) {
            dst.valueSet = new ArrayList<ModuleDefinitionValueSetComponent>();
            for (ModuleDefinitionValueSetComponent moduleDefinitionValueSetComponent : this.valueSet) {
                dst.valueSet.add(moduleDefinitionValueSetComponent.copy());
            }
        }
        if (this.parameter != null) {
            dst.parameter = new ArrayList<ModuleDefinitionParameterComponent>();
            for (ModuleDefinitionParameterComponent moduleDefinitionParameterComponent : this.parameter) {
                dst.parameter.add(moduleDefinitionParameterComponent.copy());
            }
        }
        if (this.data != null) {
            dst.data = new ArrayList<ModuleDefinitionDataComponent>();
            for (ModuleDefinitionDataComponent moduleDefinitionDataComponent : this.data) {
                dst.data.add(moduleDefinitionDataComponent.copy());
            }
        }
        return dst;
    }

    protected ModuleDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ModuleDefinition)) {
            return false;
        }
        ModuleDefinition o = (ModuleDefinition)other;
        return ModuleDefinition.compareDeep(this.identifier, o.identifier, true) && ModuleDefinition.compareDeep(this.version, o.version, true) && ModuleDefinition.compareDeep(this.model, o.model, true) && ModuleDefinition.compareDeep(this.library, o.library, true) && ModuleDefinition.compareDeep(this.codeSystem, o.codeSystem, true) && ModuleDefinition.compareDeep(this.valueSet, o.valueSet, true) && ModuleDefinition.compareDeep(this.parameter, o.parameter, true) && ModuleDefinition.compareDeep(this.data, o.data, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ModuleDefinition)) {
            return false;
        }
        ModuleDefinition o = (ModuleDefinition)other;
        return ModuleDefinition.compareValues(this.version, o.version, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty() || this.model != null && !this.model.isEmpty() || this.library != null && !this.library.isEmpty() || this.codeSystem != null && !this.codeSystem.isEmpty() || this.valueSet != null && !this.valueSet.isEmpty() || this.parameter != null && !this.parameter.isEmpty() || this.data != null && !this.data.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ModuleDefinition;
    }

    @Block
    public static class ModuleDefinitionDataDateFilterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="path", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The date-valued attribute of the filter", formalDefinition="The date-valued attribute of the filter. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant. The path must resolve to an element of type dateTime, Period, Schedule, or Timing.")
        protected StringType path;
        @Child(name="value", type={DateTimeType.class, Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The value of the filter, as a Period or dateTime value", formalDefinition="The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime.")
        protected Type value;
        private static final long serialVersionUID = 1791957163L;

        public ModuleDefinitionDataDateFilterComponent() {
        }

        public ModuleDefinitionDataDateFilterComponent(StringType path) {
            this.path = path;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionDataDateFilterComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public ModuleDefinitionDataDateFilterComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public ModuleDefinitionDataDateFilterComponent setPath(String value) {
            if (this.path == null) {
                this.path = new StringType();
            }
            this.path.setValue(value);
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this.value instanceof DateTimeType;
        }

        public Period getValuePeriod() throws FHIRException {
            if (!(this.value instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Period)this.value;
        }

        public boolean hasValuePeriod() {
            return this.value instanceof Period;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ModuleDefinitionDataDateFilterComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("path", "string", "The date-valued attribute of the filter. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant. The path must resolve to an element of type dateTime, Period, Schedule, or Timing.", 0, Integer.MAX_VALUE, this.path));
            childrenList.add(new Property("value[x]", "dateTime|Period", "The value of the filter. If period is specified, the filter will return only those data items that fall within the bounds determined by the Period, inclusive of the period boundaries. If dateTime is specified, the filter will return only those data items that are equal to the specified dateTime.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = this.castToString(value);
                    break;
                }
                case 111972721: {
                    this.value = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = this.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    throw new FHIRException("Cannot make property path as it is not a complex type");
                }
                case -1410166417: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.path");
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ModuleDefinitionDataDateFilterComponent copy() {
            ModuleDefinitionDataDateFilterComponent dst = new ModuleDefinitionDataDateFilterComponent();
            this.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionDataDateFilterComponent)) {
                return false;
            }
            ModuleDefinitionDataDateFilterComponent o = (ModuleDefinitionDataDateFilterComponent)other;
            return ModuleDefinitionDataDateFilterComponent.compareDeep(this.path, o.path, true) && ModuleDefinitionDataDateFilterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionDataDateFilterComponent)) {
                return false;
            }
            ModuleDefinitionDataDateFilterComponent o = (ModuleDefinitionDataDateFilterComponent)other;
            return ModuleDefinitionDataDateFilterComponent.compareValues(this.path, o.path, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.path != null && !this.path.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ModuleDefinition.data.dateFilter";
        }
    }

    @Block
    public static class ModuleDefinitionDataCodeFilterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="path", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The code-valued attribute of the filter", formalDefinition="The code-valued attribute of the filter. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant. The path must resolve to an element of type code, Coding, or CodeableConcept.")
        protected StringType path;
        @Child(name="valueSet", type={StringType.class, ValueSet.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The valueset for the code filter", formalDefinition="The valueset for the code filter. The valueSet or codeableConcept elements are exclusive. If valueSet is specified, the filter will return only those data items for which the value of the code-valued element specified in the path is a member of the specified valueset.")
        protected Type valueSet;
        @Child(name="codeableConcept", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The codeableConcepts for the filter", formalDefinition="The codeable concept for the code filter. Only one of valueSet or codeableConcept may be specified. If codeableConcepts are given, the filter will return only those data items for which the code-valued attribute specified by the path has a value that is one of the specified codeable concepts.")
        protected List<CodeableConcept> codeableConcept;
        private static final long serialVersionUID = -666343535L;

        public ModuleDefinitionDataCodeFilterComponent() {
        }

        public ModuleDefinitionDataCodeFilterComponent(StringType path) {
            this.path = path;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionDataCodeFilterComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public ModuleDefinitionDataCodeFilterComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public ModuleDefinitionDataCodeFilterComponent setPath(String value) {
            if (this.path == null) {
                this.path = new StringType();
            }
            this.path.setValue(value);
            return this;
        }

        public Type getValueSet() {
            return this.valueSet;
        }

        public StringType getValueSetStringType() throws FHIRException {
            if (!(this.valueSet instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.valueSet.getClass().getName() + " was encountered");
            }
            return (StringType)this.valueSet;
        }

        public boolean hasValueSetStringType() {
            return this.valueSet instanceof StringType;
        }

        public Reference getValueSetReference() throws FHIRException {
            if (!(this.valueSet instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.valueSet.getClass().getName() + " was encountered");
            }
            return (Reference)this.valueSet;
        }

        public boolean hasValueSetReference() {
            return this.valueSet instanceof Reference;
        }

        public boolean hasValueSet() {
            return this.valueSet != null && !this.valueSet.isEmpty();
        }

        public ModuleDefinitionDataCodeFilterComponent setValueSet(Type value) {
            this.valueSet = value;
            return this;
        }

        public List<CodeableConcept> getCodeableConcept() {
            if (this.codeableConcept == null) {
                this.codeableConcept = new ArrayList<CodeableConcept>();
            }
            return this.codeableConcept;
        }

        public boolean hasCodeableConcept() {
            if (this.codeableConcept == null) {
                return false;
            }
            for (CodeableConcept item : this.codeableConcept) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCodeableConcept() {
            CodeableConcept t = new CodeableConcept();
            if (this.codeableConcept == null) {
                this.codeableConcept = new ArrayList<CodeableConcept>();
            }
            this.codeableConcept.add(t);
            return t;
        }

        public ModuleDefinitionDataCodeFilterComponent addCodeableConcept(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.codeableConcept == null) {
                this.codeableConcept = new ArrayList<CodeableConcept>();
            }
            this.codeableConcept.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("path", "string", "The code-valued attribute of the filter. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant. The path must resolve to an element of type code, Coding, or CodeableConcept.", 0, Integer.MAX_VALUE, this.path));
            childrenList.add(new Property("valueSet[x]", "string|Reference(ValueSet)", "The valueset for the code filter. The valueSet or codeableConcept elements are exclusive. If valueSet is specified, the filter will return only those data items for which the value of the code-valued element specified in the path is a member of the specified valueset.", 0, Integer.MAX_VALUE, this.valueSet));
            childrenList.add(new Property("codeableConcept", "CodeableConcept", "The codeable concept for the code filter. Only one of valueSet or codeableConcept may be specified. If codeableConcepts are given, the filter will return only those data items for which the code-valued attribute specified by the path has a value that is one of the specified codeable concepts.", 0, Integer.MAX_VALUE, this.codeableConcept));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case -1410174671: {
                    Base[] baseArray;
                    if (this.valueSet == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.valueSet;
                    }
                    return baseArray;
                }
                case -156504159: {
                    return this.codeableConcept == null ? new Base[]{} : this.codeableConcept.toArray(new Base[this.codeableConcept.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = this.castToString(value);
                    break;
                }
                case -1410174671: {
                    this.valueSet = (Type)value;
                    break;
                }
                case -156504159: {
                    this.getCodeableConcept().add(this.castToCodeableConcept(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = this.castToString(value);
            } else if (name.equals("valueSet[x]")) {
                this.valueSet = (Type)value;
            } else if (name.equals("codeableConcept")) {
                this.getCodeableConcept().add(this.castToCodeableConcept(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    throw new FHIRException("Cannot make property path as it is not a complex type");
                }
                case -1438410321: {
                    return this.getValueSet();
                }
                case -156504159: {
                    return this.addCodeableConcept();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.path");
            }
            if (name.equals("valueSetString")) {
                this.valueSet = new StringType();
                return this.valueSet;
            }
            if (name.equals("valueSetReference")) {
                this.valueSet = new Reference();
                return this.valueSet;
            }
            if (name.equals("codeableConcept")) {
                return this.addCodeableConcept();
            }
            return super.addChild(name);
        }

        @Override
        public ModuleDefinitionDataCodeFilterComponent copy() {
            ModuleDefinitionDataCodeFilterComponent dst = new ModuleDefinitionDataCodeFilterComponent();
            this.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            Type type = dst.valueSet = this.valueSet == null ? null : this.valueSet.copy();
            if (this.codeableConcept != null) {
                dst.codeableConcept = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.codeableConcept) {
                    dst.codeableConcept.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionDataCodeFilterComponent)) {
                return false;
            }
            ModuleDefinitionDataCodeFilterComponent o = (ModuleDefinitionDataCodeFilterComponent)other;
            return ModuleDefinitionDataCodeFilterComponent.compareDeep(this.path, o.path, true) && ModuleDefinitionDataCodeFilterComponent.compareDeep(this.valueSet, o.valueSet, true) && ModuleDefinitionDataCodeFilterComponent.compareDeep(this.codeableConcept, o.codeableConcept, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionDataCodeFilterComponent)) {
                return false;
            }
            ModuleDefinitionDataCodeFilterComponent o = (ModuleDefinitionDataCodeFilterComponent)other;
            return ModuleDefinitionDataCodeFilterComponent.compareValues(this.path, o.path, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.path != null && !this.path.isEmpty() || this.valueSet != null && !this.valueSet.isEmpty() || this.codeableConcept != null && !this.codeableConcept.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ModuleDefinition.data.codeFilter";
        }
    }

    @Block
    public static class ModuleDefinitionDataComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of the required data", formalDefinition="The type of the required data, specified as the type name of a resource. For profiles, this value is set to the type of the base resource of the profile.")
        protected CodeType type;
        @Child(name="profile", type={StructureDefinition.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The profile of the required data", formalDefinition="The profile of the required data, specified as the uri of the profile definition.")
        protected Reference profile;
        protected StructureDefinition profileTarget;
        @Child(name="mustSupport", type={StringType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates that specific structure elements are referenced by the knowledge module", formalDefinition="Indicates that specific elements of the type are referenced by the knowledge module and must be supported by the consumer in order to obtain an effective evaluation. This does not mean that a value is required for this element, only that the consuming system must understand the element and be able to provide values for it if they are available.")
        protected List<StringType> mustSupport;
        @Child(name="codeFilter", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="Code filters for the required data, if any.")
        protected List<ModuleDefinitionDataCodeFilterComponent> codeFilter;
        @Child(name="dateFilter", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="Date filters for the required data, if any.")
        protected List<ModuleDefinitionDataDateFilterComponent> dateFilter;
        private static final long serialVersionUID = -777236908L;

        public ModuleDefinitionDataComponent() {
        }

        public ModuleDefinitionDataComponent(CodeType type) {
            this.type = type;
        }

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionDataComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ModuleDefinitionDataComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public ModuleDefinitionDataComponent setType(String value) {
            if (this.type == null) {
                this.type = new CodeType();
            }
            this.type.setValue(value);
            return this;
        }

        public Reference getProfile() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionDataComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new Reference();
                }
            }
            return this.profile;
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public ModuleDefinitionDataComponent setProfile(Reference value) {
            this.profile = value;
            return this;
        }

        public StructureDefinition getProfileTarget() {
            if (this.profileTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionDataComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profileTarget = new StructureDefinition();
                }
            }
            return this.profileTarget;
        }

        public ModuleDefinitionDataComponent setProfileTarget(StructureDefinition value) {
            this.profileTarget = value;
            return this;
        }

        public List<StringType> getMustSupport() {
            if (this.mustSupport == null) {
                this.mustSupport = new ArrayList<StringType>();
            }
            return this.mustSupport;
        }

        public boolean hasMustSupport() {
            if (this.mustSupport == null) {
                return false;
            }
            for (StringType item : this.mustSupport) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addMustSupportElement() {
            StringType t = new StringType();
            if (this.mustSupport == null) {
                this.mustSupport = new ArrayList<StringType>();
            }
            this.mustSupport.add(t);
            return t;
        }

        public ModuleDefinitionDataComponent addMustSupport(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.mustSupport == null) {
                this.mustSupport = new ArrayList<StringType>();
            }
            this.mustSupport.add(t);
            return this;
        }

        public boolean hasMustSupport(String value) {
            if (this.mustSupport == null) {
                return false;
            }
            for (StringType v : this.mustSupport) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<ModuleDefinitionDataCodeFilterComponent> getCodeFilter() {
            if (this.codeFilter == null) {
                this.codeFilter = new ArrayList<ModuleDefinitionDataCodeFilterComponent>();
            }
            return this.codeFilter;
        }

        public boolean hasCodeFilter() {
            if (this.codeFilter == null) {
                return false;
            }
            for (ModuleDefinitionDataCodeFilterComponent item : this.codeFilter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ModuleDefinitionDataCodeFilterComponent addCodeFilter() {
            ModuleDefinitionDataCodeFilterComponent t = new ModuleDefinitionDataCodeFilterComponent();
            if (this.codeFilter == null) {
                this.codeFilter = new ArrayList<ModuleDefinitionDataCodeFilterComponent>();
            }
            this.codeFilter.add(t);
            return t;
        }

        public ModuleDefinitionDataComponent addCodeFilter(ModuleDefinitionDataCodeFilterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.codeFilter == null) {
                this.codeFilter = new ArrayList<ModuleDefinitionDataCodeFilterComponent>();
            }
            this.codeFilter.add(t);
            return this;
        }

        public List<ModuleDefinitionDataDateFilterComponent> getDateFilter() {
            if (this.dateFilter == null) {
                this.dateFilter = new ArrayList<ModuleDefinitionDataDateFilterComponent>();
            }
            return this.dateFilter;
        }

        public boolean hasDateFilter() {
            if (this.dateFilter == null) {
                return false;
            }
            for (ModuleDefinitionDataDateFilterComponent item : this.dateFilter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ModuleDefinitionDataDateFilterComponent addDateFilter() {
            ModuleDefinitionDataDateFilterComponent t = new ModuleDefinitionDataDateFilterComponent();
            if (this.dateFilter == null) {
                this.dateFilter = new ArrayList<ModuleDefinitionDataDateFilterComponent>();
            }
            this.dateFilter.add(t);
            return t;
        }

        public ModuleDefinitionDataComponent addDateFilter(ModuleDefinitionDataDateFilterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.dateFilter == null) {
                this.dateFilter = new ArrayList<ModuleDefinitionDataDateFilterComponent>();
            }
            this.dateFilter.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "code", "The type of the required data, specified as the type name of a resource. For profiles, this value is set to the type of the base resource of the profile.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("profile", "Reference(StructureDefinition)", "The profile of the required data, specified as the uri of the profile definition.", 0, Integer.MAX_VALUE, this.profile));
            childrenList.add(new Property("mustSupport", "string", "Indicates that specific elements of the type are referenced by the knowledge module and must be supported by the consumer in order to obtain an effective evaluation. This does not mean that a value is required for this element, only that the consuming system must understand the element and be able to provide values for it if they are available.", 0, Integer.MAX_VALUE, this.mustSupport));
            childrenList.add(new Property("codeFilter", "", "Code filters for the required data, if any.", 0, Integer.MAX_VALUE, this.codeFilter));
            childrenList.add(new Property("dateFilter", "", "Date filters for the required data, if any.", 0, Integer.MAX_VALUE, this.dateFilter));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.profile;
                    }
                    return baseArray;
                }
                case -1402857082: {
                    return this.mustSupport == null ? new Base[]{} : this.mustSupport.toArray(new Base[this.mustSupport.size()]);
                }
                case -1303674939: {
                    return this.codeFilter == null ? new Base[]{} : this.codeFilter.toArray(new Base[this.codeFilter.size()]);
                }
                case 149531846: {
                    return this.dateFilter == null ? new Base[]{} : this.dateFilter.toArray(new Base[this.dateFilter.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCode(value);
                    break;
                }
                case -309425751: {
                    this.profile = this.castToReference(value);
                    break;
                }
                case -1402857082: {
                    this.getMustSupport().add(this.castToString(value));
                    break;
                }
                case -1303674939: {
                    this.getCodeFilter().add((ModuleDefinitionDataCodeFilterComponent)value);
                    break;
                }
                case 149531846: {
                    this.getDateFilter().add((ModuleDefinitionDataDateFilterComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCode(value);
            } else if (name.equals("profile")) {
                this.profile = this.castToReference(value);
            } else if (name.equals("mustSupport")) {
                this.getMustSupport().add(this.castToString(value));
            } else if (name.equals("codeFilter")) {
                this.getCodeFilter().add((ModuleDefinitionDataCodeFilterComponent)value);
            } else if (name.equals("dateFilter")) {
                this.getDateFilter().add((ModuleDefinitionDataDateFilterComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case -309425751: {
                    return this.getProfile();
                }
                case -1402857082: {
                    throw new FHIRException("Cannot make property mustSupport as it is not a complex type");
                }
                case -1303674939: {
                    return this.addCodeFilter();
                }
                case 149531846: {
                    return this.addDateFilter();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.type");
            }
            if (name.equals("profile")) {
                this.profile = new Reference();
                return this.profile;
            }
            if (name.equals("mustSupport")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.mustSupport");
            }
            if (name.equals("codeFilter")) {
                return this.addCodeFilter();
            }
            if (name.equals("dateFilter")) {
                return this.addDateFilter();
            }
            return super.addChild(name);
        }

        @Override
        public ModuleDefinitionDataComponent copy() {
            ModuleDefinitionDataComponent dst = new ModuleDefinitionDataComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            Reference reference = dst.profile = this.profile == null ? null : this.profile.copy();
            if (this.mustSupport != null) {
                dst.mustSupport = new ArrayList<StringType>();
                for (StringType stringType : this.mustSupport) {
                    dst.mustSupport.add(stringType.copy());
                }
            }
            if (this.codeFilter != null) {
                dst.codeFilter = new ArrayList<ModuleDefinitionDataCodeFilterComponent>();
                for (ModuleDefinitionDataCodeFilterComponent moduleDefinitionDataCodeFilterComponent : this.codeFilter) {
                    dst.codeFilter.add(moduleDefinitionDataCodeFilterComponent.copy());
                }
            }
            if (this.dateFilter != null) {
                dst.dateFilter = new ArrayList<ModuleDefinitionDataDateFilterComponent>();
                for (ModuleDefinitionDataDateFilterComponent moduleDefinitionDataDateFilterComponent : this.dateFilter) {
                    dst.dateFilter.add(moduleDefinitionDataDateFilterComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionDataComponent)) {
                return false;
            }
            ModuleDefinitionDataComponent o = (ModuleDefinitionDataComponent)other;
            return ModuleDefinitionDataComponent.compareDeep(this.type, o.type, true) && ModuleDefinitionDataComponent.compareDeep(this.profile, o.profile, true) && ModuleDefinitionDataComponent.compareDeep(this.mustSupport, o.mustSupport, true) && ModuleDefinitionDataComponent.compareDeep(this.codeFilter, o.codeFilter, true) && ModuleDefinitionDataComponent.compareDeep(this.dateFilter, o.dateFilter, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionDataComponent)) {
                return false;
            }
            ModuleDefinitionDataComponent o = (ModuleDefinitionDataComponent)other;
            return ModuleDefinitionDataComponent.compareValues(this.type, o.type, true) && ModuleDefinitionDataComponent.compareValues(this.mustSupport, o.mustSupport, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.profile != null && !this.profile.isEmpty() || this.mustSupport != null && !this.mustSupport.isEmpty() || this.codeFilter != null && !this.codeFilter.isEmpty() || this.dateFilter != null && !this.dateFilter.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ModuleDefinition.data";
        }
    }

    @Block
    public static class ModuleDefinitionParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The name of the parameter.")
        protected CodeType name;
        @Child(name="use", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="Whether the parameter is input or output for the module.")
        protected CodeType use;
        @Child(name="documentation", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="A brief description of the parameter.")
        protected StringType documentation;
        @Child(name="type", type={CodeType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The type of the parameter.")
        protected CodeType type;
        @Child(name="profile", type={StructureDefinition.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The profile of the parameter, if any.")
        protected Reference profile;
        protected StructureDefinition profileTarget;
        private static final long serialVersionUID = 1572548838L;

        public ModuleDefinitionParameterComponent() {
        }

        public ModuleDefinitionParameterComponent(CodeType name, CodeType use, CodeType type) {
            this.name = name;
            this.use = use;
            this.type = type;
        }

        public CodeType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionParameterComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new CodeType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ModuleDefinitionParameterComponent setNameElement(CodeType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ModuleDefinitionParameterComponent setName(String value) {
            if (this.name == null) {
                this.name = new CodeType();
            }
            this.name.setValue(value);
            return this;
        }

        public CodeType getUseElement() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionParameterComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new CodeType();
                }
            }
            return this.use;
        }

        public boolean hasUseElement() {
            return this.use != null && !this.use.isEmpty();
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public ModuleDefinitionParameterComponent setUseElement(CodeType value) {
            this.use = value;
            return this;
        }

        public String getUse() {
            return this.use == null ? null : (String)this.use.getValue();
        }

        public ModuleDefinitionParameterComponent setUse(String value) {
            if (this.use == null) {
                this.use = new CodeType();
            }
            this.use.setValue(value);
            return this;
        }

        public StringType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionParameterComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new StringType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public ModuleDefinitionParameterComponent setDocumentationElement(StringType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public ModuleDefinitionParameterComponent setDocumentation(String value) {
            if (Utilities.noString((String)value)) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new StringType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionParameterComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ModuleDefinitionParameterComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public ModuleDefinitionParameterComponent setType(String value) {
            if (this.type == null) {
                this.type = new CodeType();
            }
            this.type.setValue(value);
            return this;
        }

        public Reference getProfile() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionParameterComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new Reference();
                }
            }
            return this.profile;
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public ModuleDefinitionParameterComponent setProfile(Reference value) {
            this.profile = value;
            return this;
        }

        public StructureDefinition getProfileTarget() {
            if (this.profileTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionParameterComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profileTarget = new StructureDefinition();
                }
            }
            return this.profileTarget;
        }

        public ModuleDefinitionParameterComponent setProfileTarget(StructureDefinition value) {
            this.profileTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "code", "The name of the parameter.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("use", "code", "Whether the parameter is input or output for the module.", 0, Integer.MAX_VALUE, this.use));
            childrenList.add(new Property("documentation", "string", "A brief description of the parameter.", 0, Integer.MAX_VALUE, this.documentation));
            childrenList.add(new Property("type", "code", "The type of the parameter.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("profile", "Reference(StructureDefinition)", "The profile of the parameter, if any.", 0, Integer.MAX_VALUE, this.profile));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.use;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.documentation;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.type;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.profile;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToCode(value);
                    break;
                }
                case 116103: {
                    this.use = this.castToCode(value);
                    break;
                }
                case 1587405498: {
                    this.documentation = this.castToString(value);
                    break;
                }
                case 3575610: {
                    this.type = this.castToCode(value);
                    break;
                }
                case -309425751: {
                    this.profile = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToCode(value);
            } else if (name.equals("use")) {
                this.use = this.castToCode(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToString(value);
            } else if (name.equals("type")) {
                this.type = this.castToCode(value);
            } else if (name.equals("profile")) {
                this.profile = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case 116103: {
                    throw new FHIRException("Cannot make property use as it is not a complex type");
                }
                case 1587405498: {
                    throw new FHIRException("Cannot make property documentation as it is not a complex type");
                }
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case -309425751: {
                    return this.getProfile();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.name");
            }
            if (name.equals("use")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.use");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.documentation");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.type");
            }
            if (name.equals("profile")) {
                this.profile = new Reference();
                return this.profile;
            }
            return super.addChild(name);
        }

        @Override
        public ModuleDefinitionParameterComponent copy() {
            ModuleDefinitionParameterComponent dst = new ModuleDefinitionParameterComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.use = this.use == null ? null : this.use.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.profile = this.profile == null ? null : this.profile.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionParameterComponent)) {
                return false;
            }
            ModuleDefinitionParameterComponent o = (ModuleDefinitionParameterComponent)other;
            return ModuleDefinitionParameterComponent.compareDeep(this.name, o.name, true) && ModuleDefinitionParameterComponent.compareDeep(this.use, o.use, true) && ModuleDefinitionParameterComponent.compareDeep(this.documentation, o.documentation, true) && ModuleDefinitionParameterComponent.compareDeep(this.type, o.type, true) && ModuleDefinitionParameterComponent.compareDeep(this.profile, o.profile, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionParameterComponent)) {
                return false;
            }
            ModuleDefinitionParameterComponent o = (ModuleDefinitionParameterComponent)other;
            return ModuleDefinitionParameterComponent.compareValues(this.name, o.name, true) && ModuleDefinitionParameterComponent.compareValues(this.use, o.use, true) && ModuleDefinitionParameterComponent.compareValues(this.documentation, o.documentation, true) && ModuleDefinitionParameterComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.use != null && !this.use.isEmpty() || this.documentation != null && !this.documentation.isEmpty() || this.type != null && !this.type.isEmpty() || this.profile != null && !this.profile.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ModuleDefinition.parameter";
        }
    }

    @Block
    public static class ModuleDefinitionValueSetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The local name for the value set.")
        protected StringType name;
        @Child(name="identifier", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The value set uri.")
        protected StringType identifier;
        @Child(name="version", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The version of the value set, if any.")
        protected StringType version;
        @Child(name="codeSystem", type={StringType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The code systems in use within the value set. These must refer to previously defined code systems within this knowledge module or a referenced library.")
        protected List<StringType> codeSystem;
        private static final long serialVersionUID = 338950096L;

        public ModuleDefinitionValueSetComponent() {
        }

        public ModuleDefinitionValueSetComponent(StringType name, StringType identifier) {
            this.name = name;
            this.identifier = identifier;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionValueSetComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ModuleDefinitionValueSetComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ModuleDefinitionValueSetComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getIdentifierElement() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionValueSetComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new StringType();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifierElement() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public ModuleDefinitionValueSetComponent setIdentifierElement(StringType value) {
            this.identifier = value;
            return this;
        }

        public String getIdentifier() {
            return this.identifier == null ? null : (String)this.identifier.getValue();
        }

        public ModuleDefinitionValueSetComponent setIdentifier(String value) {
            if (this.identifier == null) {
                this.identifier = new StringType();
            }
            this.identifier.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionValueSetComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ModuleDefinitionValueSetComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ModuleDefinitionValueSetComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public List<StringType> getCodeSystem() {
            if (this.codeSystem == null) {
                this.codeSystem = new ArrayList<StringType>();
            }
            return this.codeSystem;
        }

        public boolean hasCodeSystem() {
            if (this.codeSystem == null) {
                return false;
            }
            for (StringType item : this.codeSystem) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addCodeSystemElement() {
            StringType t = new StringType();
            if (this.codeSystem == null) {
                this.codeSystem = new ArrayList<StringType>();
            }
            this.codeSystem.add(t);
            return t;
        }

        public ModuleDefinitionValueSetComponent addCodeSystem(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.codeSystem == null) {
                this.codeSystem = new ArrayList<StringType>();
            }
            this.codeSystem.add(t);
            return this;
        }

        public boolean hasCodeSystem(String value) {
            if (this.codeSystem == null) {
                return false;
            }
            for (StringType v : this.codeSystem) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "The local name for the value set.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("identifier", "string", "The value set uri.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("version", "string", "The version of the value set, if any.", 0, Integer.MAX_VALUE, this.version));
            childrenList.add(new Property("codeSystem", "string", "The code systems in use within the value set. These must refer to previously defined code systems within this knowledge module or a referenced library.", 0, Integer.MAX_VALUE, this.codeSystem));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.version;
                    }
                    return baseArray;
                }
                case -916511108: {
                    return this.codeSystem == null ? new Base[]{} : this.codeSystem.toArray(new Base[this.codeSystem.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1618432855: {
                    this.identifier = this.castToString(value);
                    break;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    break;
                }
                case -916511108: {
                    this.getCodeSystem().add(this.castToString(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("identifier")) {
                this.identifier = this.castToString(value);
            } else if (name.equals("version")) {
                this.version = this.castToString(value);
            } else if (name.equals("codeSystem")) {
                this.getCodeSystem().add(this.castToString(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1618432855: {
                    throw new FHIRException("Cannot make property identifier as it is not a complex type");
                }
                case 351608024: {
                    throw new FHIRException("Cannot make property version as it is not a complex type");
                }
                case -916511108: {
                    throw new FHIRException("Cannot make property codeSystem as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.name");
            }
            if (name.equals("identifier")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.identifier");
            }
            if (name.equals("version")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.version");
            }
            if (name.equals("codeSystem")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.codeSystem");
            }
            return super.addChild(name);
        }

        @Override
        public ModuleDefinitionValueSetComponent copy() {
            ModuleDefinitionValueSetComponent dst = new ModuleDefinitionValueSetComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            StringType stringType = dst.version = this.version == null ? null : this.version.copy();
            if (this.codeSystem != null) {
                dst.codeSystem = new ArrayList<StringType>();
                for (StringType i : this.codeSystem) {
                    dst.codeSystem.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionValueSetComponent)) {
                return false;
            }
            ModuleDefinitionValueSetComponent o = (ModuleDefinitionValueSetComponent)other;
            return ModuleDefinitionValueSetComponent.compareDeep(this.name, o.name, true) && ModuleDefinitionValueSetComponent.compareDeep(this.identifier, o.identifier, true) && ModuleDefinitionValueSetComponent.compareDeep(this.version, o.version, true) && ModuleDefinitionValueSetComponent.compareDeep(this.codeSystem, o.codeSystem, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionValueSetComponent)) {
                return false;
            }
            ModuleDefinitionValueSetComponent o = (ModuleDefinitionValueSetComponent)other;
            return ModuleDefinitionValueSetComponent.compareValues(this.name, o.name, true) && ModuleDefinitionValueSetComponent.compareValues(this.identifier, o.identifier, true) && ModuleDefinitionValueSetComponent.compareValues(this.version, o.version, true) && ModuleDefinitionValueSetComponent.compareValues(this.codeSystem, o.codeSystem, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty() || this.codeSystem != null && !this.codeSystem.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ModuleDefinition.valueSet";
        }
    }

    @Block
    public static class ModuleDefinitionCodeSystemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The local name for the code system.")
        protected StringType name;
        @Child(name="identifier", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The code system uri.")
        protected StringType identifier;
        @Child(name="version", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The code system version, if any.")
        protected StringType version;
        private static final long serialVersionUID = -862601139L;

        public ModuleDefinitionCodeSystemComponent() {
        }

        public ModuleDefinitionCodeSystemComponent(StringType name, StringType identifier) {
            this.name = name;
            this.identifier = identifier;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionCodeSystemComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ModuleDefinitionCodeSystemComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ModuleDefinitionCodeSystemComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getIdentifierElement() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionCodeSystemComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new StringType();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifierElement() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public ModuleDefinitionCodeSystemComponent setIdentifierElement(StringType value) {
            this.identifier = value;
            return this;
        }

        public String getIdentifier() {
            return this.identifier == null ? null : (String)this.identifier.getValue();
        }

        public ModuleDefinitionCodeSystemComponent setIdentifier(String value) {
            if (this.identifier == null) {
                this.identifier = new StringType();
            }
            this.identifier.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionCodeSystemComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ModuleDefinitionCodeSystemComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ModuleDefinitionCodeSystemComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "The local name for the code system.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("identifier", "string", "The code system uri.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("version", "string", "The code system version, if any.", 0, Integer.MAX_VALUE, this.version));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.version;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1618432855: {
                    this.identifier = this.castToString(value);
                    break;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("identifier")) {
                this.identifier = this.castToString(value);
            } else if (name.equals("version")) {
                this.version = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1618432855: {
                    throw new FHIRException("Cannot make property identifier as it is not a complex type");
                }
                case 351608024: {
                    throw new FHIRException("Cannot make property version as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.name");
            }
            if (name.equals("identifier")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.identifier");
            }
            if (name.equals("version")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.version");
            }
            return super.addChild(name);
        }

        @Override
        public ModuleDefinitionCodeSystemComponent copy() {
            ModuleDefinitionCodeSystemComponent dst = new ModuleDefinitionCodeSystemComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.version = this.version == null ? null : this.version.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionCodeSystemComponent)) {
                return false;
            }
            ModuleDefinitionCodeSystemComponent o = (ModuleDefinitionCodeSystemComponent)other;
            return ModuleDefinitionCodeSystemComponent.compareDeep(this.name, o.name, true) && ModuleDefinitionCodeSystemComponent.compareDeep(this.identifier, o.identifier, true) && ModuleDefinitionCodeSystemComponent.compareDeep(this.version, o.version, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionCodeSystemComponent)) {
                return false;
            }
            ModuleDefinitionCodeSystemComponent o = (ModuleDefinitionCodeSystemComponent)other;
            return ModuleDefinitionCodeSystemComponent.compareValues(this.name, o.name, true) && ModuleDefinitionCodeSystemComponent.compareValues(this.identifier, o.identifier, true) && ModuleDefinitionCodeSystemComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ModuleDefinition.codeSystem";
        }
    }

    @Block
    public static class ModuleDefinitionLibraryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The local name for the library", formalDefinition="The local name for the library reference. If no local name is provided, the name of the referenced library is assumed.")
        protected StringType name;
        @Child(name="identifier", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The identifier of the library.")
        protected StringType identifier;
        @Child(name="version", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The version of the library.")
        protected StringType version;
        @Child(name="document", type={Attachment.class, ModuleDefinition.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="A reference to the library.")
        protected Type document;
        private static final long serialVersionUID = 1633488790L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionLibraryComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ModuleDefinitionLibraryComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ModuleDefinitionLibraryComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getIdentifierElement() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionLibraryComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new StringType();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifierElement() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public ModuleDefinitionLibraryComponent setIdentifierElement(StringType value) {
            this.identifier = value;
            return this;
        }

        public String getIdentifier() {
            return this.identifier == null ? null : (String)this.identifier.getValue();
        }

        public ModuleDefinitionLibraryComponent setIdentifier(String value) {
            if (Utilities.noString((String)value)) {
                this.identifier = null;
            } else {
                if (this.identifier == null) {
                    this.identifier = new StringType();
                }
                this.identifier.setValue(value);
            }
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionLibraryComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ModuleDefinitionLibraryComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ModuleDefinitionLibraryComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public Type getDocument() {
            return this.document;
        }

        public Attachment getDocumentAttachment() throws FHIRException {
            if (!(this.document instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.document.getClass().getName() + " was encountered");
            }
            return (Attachment)this.document;
        }

        public boolean hasDocumentAttachment() {
            return this.document instanceof Attachment;
        }

        public Reference getDocumentReference() throws FHIRException {
            if (!(this.document instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.document.getClass().getName() + " was encountered");
            }
            return (Reference)this.document;
        }

        public boolean hasDocumentReference() {
            return this.document instanceof Reference;
        }

        public boolean hasDocument() {
            return this.document != null && !this.document.isEmpty();
        }

        public ModuleDefinitionLibraryComponent setDocument(Type value) {
            this.document = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "The local name for the library reference. If no local name is provided, the name of the referenced library is assumed.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("identifier", "string", "The identifier of the library.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("version", "string", "The version of the library.", 0, Integer.MAX_VALUE, this.version));
            childrenList.add(new Property("document[x]", "Attachment|Reference(ModuleDefinition)", "A reference to the library.", 0, Integer.MAX_VALUE, this.document));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.version;
                    }
                    return baseArray;
                }
                case 861720859: {
                    Base[] baseArray;
                    if (this.document == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.document;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1618432855: {
                    this.identifier = this.castToString(value);
                    break;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    break;
                }
                case 861720859: {
                    this.document = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("identifier")) {
                this.identifier = this.castToString(value);
            } else if (name.equals("version")) {
                this.version = this.castToString(value);
            } else if (name.equals("document[x]")) {
                this.document = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1618432855: {
                    throw new FHIRException("Cannot make property identifier as it is not a complex type");
                }
                case 351608024: {
                    throw new FHIRException("Cannot make property version as it is not a complex type");
                }
                case 506673541: {
                    return this.getDocument();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.name");
            }
            if (name.equals("identifier")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.identifier");
            }
            if (name.equals("version")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.version");
            }
            if (name.equals("documentAttachment")) {
                this.document = new Attachment();
                return this.document;
            }
            if (name.equals("documentReference")) {
                this.document = new Reference();
                return this.document;
            }
            return super.addChild(name);
        }

        @Override
        public ModuleDefinitionLibraryComponent copy() {
            ModuleDefinitionLibraryComponent dst = new ModuleDefinitionLibraryComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.version = this.version == null ? null : this.version.copy();
            dst.document = this.document == null ? null : this.document.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionLibraryComponent)) {
                return false;
            }
            ModuleDefinitionLibraryComponent o = (ModuleDefinitionLibraryComponent)other;
            return ModuleDefinitionLibraryComponent.compareDeep(this.name, o.name, true) && ModuleDefinitionLibraryComponent.compareDeep(this.identifier, o.identifier, true) && ModuleDefinitionLibraryComponent.compareDeep(this.version, o.version, true) && ModuleDefinitionLibraryComponent.compareDeep(this.document, o.document, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionLibraryComponent)) {
                return false;
            }
            ModuleDefinitionLibraryComponent o = (ModuleDefinitionLibraryComponent)other;
            return ModuleDefinitionLibraryComponent.compareValues(this.name, o.name, true) && ModuleDefinitionLibraryComponent.compareValues(this.identifier, o.identifier, true) && ModuleDefinitionLibraryComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty() || this.document != null && !this.document.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ModuleDefinition.library";
        }
    }

    @Block
    public static class ModuleDefinitionModelComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The name of the model.")
        protected StringType name;
        @Child(name="identifier", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The identifier of the model.")
        protected StringType identifier;
        @Child(name="version", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="The version of the model.")
        protected StringType version;
        private static final long serialVersionUID = -862601139L;

        public ModuleDefinitionModelComponent() {
        }

        public ModuleDefinitionModelComponent(StringType identifier) {
            this.identifier = identifier;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionModelComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ModuleDefinitionModelComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ModuleDefinitionModelComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getIdentifierElement() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionModelComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new StringType();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifierElement() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public ModuleDefinitionModelComponent setIdentifierElement(StringType value) {
            this.identifier = value;
            return this;
        }

        public String getIdentifier() {
            return this.identifier == null ? null : (String)this.identifier.getValue();
        }

        public ModuleDefinitionModelComponent setIdentifier(String value) {
            if (this.identifier == null) {
                this.identifier = new StringType();
            }
            this.identifier.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ModuleDefinitionModelComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ModuleDefinitionModelComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ModuleDefinitionModelComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "The name of the model.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("identifier", "string", "The identifier of the model.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("version", "string", "The version of the model.", 0, Integer.MAX_VALUE, this.version));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.version;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    break;
                }
                case -1618432855: {
                    this.identifier = this.castToString(value);
                    break;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("identifier")) {
                this.identifier = this.castToString(value);
            } else if (name.equals("version")) {
                this.version = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    throw new FHIRException("Cannot make property name as it is not a complex type");
                }
                case -1618432855: {
                    throw new FHIRException("Cannot make property identifier as it is not a complex type");
                }
                case 351608024: {
                    throw new FHIRException("Cannot make property version as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.name");
            }
            if (name.equals("identifier")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.identifier");
            }
            if (name.equals("version")) {
                throw new FHIRException("Cannot call addChild on a primitive type ModuleDefinition.version");
            }
            return super.addChild(name);
        }

        @Override
        public ModuleDefinitionModelComponent copy() {
            ModuleDefinitionModelComponent dst = new ModuleDefinitionModelComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.version = this.version == null ? null : this.version.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionModelComponent)) {
                return false;
            }
            ModuleDefinitionModelComponent o = (ModuleDefinitionModelComponent)other;
            return ModuleDefinitionModelComponent.compareDeep(this.name, o.name, true) && ModuleDefinitionModelComponent.compareDeep(this.identifier, o.identifier, true) && ModuleDefinitionModelComponent.compareDeep(this.version, o.version, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ModuleDefinitionModelComponent)) {
                return false;
            }
            ModuleDefinitionModelComponent o = (ModuleDefinitionModelComponent)other;
            return ModuleDefinitionModelComponent.compareValues(this.name, o.name, true) && ModuleDefinitionModelComponent.compareValues(this.identifier, o.identifier, true) && ModuleDefinitionModelComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ModuleDefinition.model";
        }
    }
}

