/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="OperationOutcome", profile="http://hl7.org/fhir/Profile/OperationOutcome")
public class OperationOutcome
extends DomainResource
implements IBaseOperationOutcome {
    @Child(name="issue", type={}, order=0, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A single issue associated with the action", formalDefinition="An error, warning or information message that results from a system action.")
    protected List<OperationOutcomeIssueComponent> issue;
    private static final long serialVersionUID = -152150052L;

    public List<OperationOutcomeIssueComponent> getIssue() {
        if (this.issue == null) {
            this.issue = new ArrayList<OperationOutcomeIssueComponent>();
        }
        return this.issue;
    }

    public boolean hasIssue() {
        if (this.issue == null) {
            return false;
        }
        for (OperationOutcomeIssueComponent item : this.issue) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OperationOutcomeIssueComponent addIssue() {
        OperationOutcomeIssueComponent t = new OperationOutcomeIssueComponent();
        if (this.issue == null) {
            this.issue = new ArrayList<OperationOutcomeIssueComponent>();
        }
        this.issue.add(t);
        return t;
    }

    public OperationOutcome addIssue(OperationOutcomeIssueComponent t) {
        if (t == null) {
            return this;
        }
        if (this.issue == null) {
            this.issue = new ArrayList<OperationOutcomeIssueComponent>();
        }
        this.issue.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("issue", "", "An error, warning or information message that results from a system action.", 0, Integer.MAX_VALUE, this.issue));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 100509913: {
                return this.issue == null ? new Base[]{} : this.issue.toArray(new Base[this.issue.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 100509913: {
                this.getIssue().add((OperationOutcomeIssueComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("issue")) {
            this.getIssue().add((OperationOutcomeIssueComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 100509913: {
                return this.addIssue();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("issue")) {
            return this.addIssue();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "OperationOutcome";
    }

    @Override
    public OperationOutcome copy() {
        OperationOutcome dst = new OperationOutcome();
        this.copyValues(dst);
        if (this.issue != null) {
            dst.issue = new ArrayList<OperationOutcomeIssueComponent>();
            for (OperationOutcomeIssueComponent i : this.issue) {
                dst.issue.add(i.copy());
            }
        }
        return dst;
    }

    protected OperationOutcome typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof OperationOutcome)) {
            return false;
        }
        OperationOutcome o = (OperationOutcome)other;
        return OperationOutcome.compareDeep(this.issue, o.issue, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof OperationOutcome)) {
            return false;
        }
        OperationOutcome o = (OperationOutcome)other;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && (this.issue == null || this.issue.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.OperationOutcome;
    }

    @Block
    public static class OperationOutcomeIssueComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="severity", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
        @Description(shortDefinition="fatal | error | warning | information", formalDefinition="Indicates whether the issue indicates a variation from successful processing.")
        protected Enumeration<IssueSeverity> severity;
        @Child(name="code", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Error or warning code", formalDefinition="Describes the type of the issue. The system that creates an OperationOutcome SHALL choose the most applicable code from the IssueType value set, and may additional provide its own code for the error in the details element.")
        protected Enumeration<IssueType> code;
        @Child(name="details", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Additional details about the error", formalDefinition="Additional details about the error. This may be a text description of the error, or a system code that identifies the error.")
        protected CodeableConcept details;
        @Child(name="diagnostics", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Additional diagnostic information about the issue", formalDefinition="Additional diagnostic information about the issue.  Typically, this may be a description of how a value is erroneous, or a stack dump to help trace the issue.")
        protected StringType diagnostics;
        @Child(name="location", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="XPath of element(s) related to issue", formalDefinition="A simple XPath limited to element names, repetition indicators and the default child access that identifies one of the elements in the resource that caused this issue to be raised.")
        protected List<StringType> location;
        @Child(name="expression", type={StringType.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="FluentPath of element(s) related to issue", formalDefinition="A simple FluentPath limited to element names, repetition indicators and the default child access that identifies one of the elements in the resource that caused this issue to be raised.")
        protected List<StringType> expression;
        private static final long serialVersionUID = -1681095438L;

        public OperationOutcomeIssueComponent() {
        }

        public OperationOutcomeIssueComponent(Enumeration<IssueSeverity> severity, Enumeration<IssueType> code) {
            this.severity = severity;
            this.code = code;
        }

        public Enumeration<IssueSeverity> getSeverityElement() {
            if (this.severity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationOutcomeIssueComponent.severity");
                }
                if (Configuration.doAutoCreate()) {
                    this.severity = new Enumeration<IssueSeverity>(new IssueSeverityEnumFactory());
                }
            }
            return this.severity;
        }

        public boolean hasSeverityElement() {
            return this.severity != null && !this.severity.isEmpty();
        }

        public boolean hasSeverity() {
            return this.severity != null && !this.severity.isEmpty();
        }

        public OperationOutcomeIssueComponent setSeverityElement(Enumeration<IssueSeverity> value) {
            this.severity = value;
            return this;
        }

        public IssueSeverity getSeverity() {
            return this.severity == null ? null : (IssueSeverity)((Object)this.severity.getValue());
        }

        public OperationOutcomeIssueComponent setSeverity(IssueSeverity value) {
            if (this.severity == null) {
                this.severity = new Enumeration<IssueSeverity>(new IssueSeverityEnumFactory());
            }
            this.severity.setValue((Object)value);
            return this;
        }

        public Enumeration<IssueType> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationOutcomeIssueComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<IssueType>(new IssueTypeEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public OperationOutcomeIssueComponent setCodeElement(Enumeration<IssueType> value) {
            this.code = value;
            return this;
        }

        public IssueType getCode() {
            return this.code == null ? null : (IssueType)((Object)this.code.getValue());
        }

        public OperationOutcomeIssueComponent setCode(IssueType value) {
            if (this.code == null) {
                this.code = new Enumeration<IssueType>(new IssueTypeEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public CodeableConcept getDetails() {
            if (this.details == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationOutcomeIssueComponent.details");
                }
                if (Configuration.doAutoCreate()) {
                    this.details = new CodeableConcept();
                }
            }
            return this.details;
        }

        public boolean hasDetails() {
            return this.details != null && !this.details.isEmpty();
        }

        public OperationOutcomeIssueComponent setDetails(CodeableConcept value) {
            this.details = value;
            return this;
        }

        public StringType getDiagnosticsElement() {
            if (this.diagnostics == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OperationOutcomeIssueComponent.diagnostics");
                }
                if (Configuration.doAutoCreate()) {
                    this.diagnostics = new StringType();
                }
            }
            return this.diagnostics;
        }

        public boolean hasDiagnosticsElement() {
            return this.diagnostics != null && !this.diagnostics.isEmpty();
        }

        public boolean hasDiagnostics() {
            return this.diagnostics != null && !this.diagnostics.isEmpty();
        }

        public OperationOutcomeIssueComponent setDiagnosticsElement(StringType value) {
            this.diagnostics = value;
            return this;
        }

        public String getDiagnostics() {
            return this.diagnostics == null ? null : (String)this.diagnostics.getValue();
        }

        public OperationOutcomeIssueComponent setDiagnostics(String value) {
            if (Utilities.noString((String)value)) {
                this.diagnostics = null;
            } else {
                if (this.diagnostics == null) {
                    this.diagnostics = new StringType();
                }
                this.diagnostics.setValue(value);
            }
            return this;
        }

        public List<StringType> getLocation() {
            if (this.location == null) {
                this.location = new ArrayList<StringType>();
            }
            return this.location;
        }

        public boolean hasLocation() {
            if (this.location == null) {
                return false;
            }
            for (StringType item : this.location) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addLocationElement() {
            StringType t = new StringType();
            if (this.location == null) {
                this.location = new ArrayList<StringType>();
            }
            this.location.add(t);
            return t;
        }

        public OperationOutcomeIssueComponent addLocation(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.location == null) {
                this.location = new ArrayList<StringType>();
            }
            this.location.add(t);
            return this;
        }

        public boolean hasLocation(String value) {
            if (this.location == null) {
                return false;
            }
            for (StringType v : this.location) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<StringType> getExpression() {
            if (this.expression == null) {
                this.expression = new ArrayList<StringType>();
            }
            return this.expression;
        }

        public boolean hasExpression() {
            if (this.expression == null) {
                return false;
            }
            for (StringType item : this.expression) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addExpressionElement() {
            StringType t = new StringType();
            if (this.expression == null) {
                this.expression = new ArrayList<StringType>();
            }
            this.expression.add(t);
            return t;
        }

        public OperationOutcomeIssueComponent addExpression(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.expression == null) {
                this.expression = new ArrayList<StringType>();
            }
            this.expression.add(t);
            return this;
        }

        public boolean hasExpression(String value) {
            if (this.expression == null) {
                return false;
            }
            for (StringType v : this.expression) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("severity", "code", "Indicates whether the issue indicates a variation from successful processing.", 0, Integer.MAX_VALUE, this.severity));
            childrenList.add(new Property("code", "code", "Describes the type of the issue. The system that creates an OperationOutcome SHALL choose the most applicable code from the IssueType value set, and may additional provide its own code for the error in the details element.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("details", "CodeableConcept", "Additional details about the error. This may be a text description of the error, or a system code that identifies the error.", 0, Integer.MAX_VALUE, this.details));
            childrenList.add(new Property("diagnostics", "string", "Additional diagnostic information about the issue.  Typically, this may be a description of how a value is erroneous, or a stack dump to help trace the issue.", 0, Integer.MAX_VALUE, this.diagnostics));
            childrenList.add(new Property("location", "string", "A simple XPath limited to element names, repetition indicators and the default child access that identifies one of the elements in the resource that caused this issue to be raised.", 0, Integer.MAX_VALUE, this.location));
            childrenList.add(new Property("expression", "string", "A simple FluentPath limited to element names, repetition indicators and the default child access that identifies one of the elements in the resource that caused this issue to be raised.", 0, Integer.MAX_VALUE, this.expression));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1478300413: {
                    Base[] baseArray;
                    if (this.severity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.severity;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case 1557721666: {
                    Base[] baseArray;
                    if (this.details == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.details;
                    }
                    return baseArray;
                }
                case -740386388: {
                    Base[] baseArray;
                    if (this.diagnostics == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.diagnostics;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    return this.location == null ? new Base[]{} : this.location.toArray(new Base[this.location.size()]);
                }
                case -1795452264: {
                    return this.expression == null ? new Base[]{} : this.expression.toArray(new Base[this.expression.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1478300413: {
                    this.severity = new IssueSeverityEnumFactory().fromType(value);
                    break;
                }
                case 3059181: {
                    this.code = new IssueTypeEnumFactory().fromType(value);
                    break;
                }
                case 1557721666: {
                    this.details = this.castToCodeableConcept(value);
                    break;
                }
                case -740386388: {
                    this.diagnostics = this.castToString(value);
                    break;
                }
                case 1901043637: {
                    this.getLocation().add(this.castToString(value));
                    break;
                }
                case -1795452264: {
                    this.getExpression().add(this.castToString(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("severity")) {
                this.severity = new IssueSeverityEnumFactory().fromType(value);
            } else if (name.equals("code")) {
                this.code = new IssueTypeEnumFactory().fromType(value);
            } else if (name.equals("details")) {
                this.details = this.castToCodeableConcept(value);
            } else if (name.equals("diagnostics")) {
                this.diagnostics = this.castToString(value);
            } else if (name.equals("location")) {
                this.getLocation().add(this.castToString(value));
            } else if (name.equals("expression")) {
                this.getExpression().add(this.castToString(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1478300413: {
                    throw new FHIRException("Cannot make property severity as it is not a complex type");
                }
                case 3059181: {
                    throw new FHIRException("Cannot make property code as it is not a complex type");
                }
                case 1557721666: {
                    return this.getDetails();
                }
                case -740386388: {
                    throw new FHIRException("Cannot make property diagnostics as it is not a complex type");
                }
                case 1901043637: {
                    throw new FHIRException("Cannot make property location as it is not a complex type");
                }
                case -1795452264: {
                    throw new FHIRException("Cannot make property expression as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("severity")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationOutcome.severity");
            }
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationOutcome.code");
            }
            if (name.equals("details")) {
                this.details = new CodeableConcept();
                return this.details;
            }
            if (name.equals("diagnostics")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationOutcome.diagnostics");
            }
            if (name.equals("location")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationOutcome.location");
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a primitive type OperationOutcome.expression");
            }
            return super.addChild(name);
        }

        @Override
        public OperationOutcomeIssueComponent copy() {
            OperationOutcomeIssueComponent dst = new OperationOutcomeIssueComponent();
            this.copyValues(dst);
            dst.severity = this.severity == null ? null : this.severity.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.details = this.details == null ? null : this.details.copy();
            StringType stringType = dst.diagnostics = this.diagnostics == null ? null : this.diagnostics.copy();
            if (this.location != null) {
                dst.location = new ArrayList<StringType>();
                for (StringType i : this.location) {
                    dst.location.add(i.copy());
                }
            }
            if (this.expression != null) {
                dst.expression = new ArrayList<StringType>();
                for (StringType i : this.expression) {
                    dst.expression.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof OperationOutcomeIssueComponent)) {
                return false;
            }
            OperationOutcomeIssueComponent o = (OperationOutcomeIssueComponent)other;
            return OperationOutcomeIssueComponent.compareDeep(this.severity, o.severity, true) && OperationOutcomeIssueComponent.compareDeep(this.code, o.code, true) && OperationOutcomeIssueComponent.compareDeep(this.details, o.details, true) && OperationOutcomeIssueComponent.compareDeep(this.diagnostics, o.diagnostics, true) && OperationOutcomeIssueComponent.compareDeep(this.location, o.location, true) && OperationOutcomeIssueComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof OperationOutcomeIssueComponent)) {
                return false;
            }
            OperationOutcomeIssueComponent o = (OperationOutcomeIssueComponent)other;
            return OperationOutcomeIssueComponent.compareValues(this.severity, o.severity, true) && OperationOutcomeIssueComponent.compareValues(this.code, o.code, true) && OperationOutcomeIssueComponent.compareValues(this.diagnostics, o.diagnostics, true) && OperationOutcomeIssueComponent.compareValues(this.location, o.location, true) && OperationOutcomeIssueComponent.compareValues(this.expression, o.expression, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.severity != null && !this.severity.isEmpty() || this.code != null && !this.code.isEmpty() || this.details != null && !this.details.isEmpty() || this.diagnostics != null && !this.diagnostics.isEmpty() || this.location != null && !this.location.isEmpty() || this.expression != null && !this.expression.isEmpty());
        }

        @Override
        public String fhirType() {
            return "OperationOutcome.issue";
        }
    }

    public static class IssueTypeEnumFactory
    implements EnumFactory<IssueType> {
        @Override
        public IssueType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("invalid".equals(codeString)) {
                return IssueType.INVALID;
            }
            if ("structure".equals(codeString)) {
                return IssueType.STRUCTURE;
            }
            if ("required".equals(codeString)) {
                return IssueType.REQUIRED;
            }
            if ("value".equals(codeString)) {
                return IssueType.VALUE;
            }
            if ("invariant".equals(codeString)) {
                return IssueType.INVARIANT;
            }
            if ("security".equals(codeString)) {
                return IssueType.SECURITY;
            }
            if ("login".equals(codeString)) {
                return IssueType.LOGIN;
            }
            if ("unknown".equals(codeString)) {
                return IssueType.UNKNOWN;
            }
            if ("expired".equals(codeString)) {
                return IssueType.EXPIRED;
            }
            if ("forbidden".equals(codeString)) {
                return IssueType.FORBIDDEN;
            }
            if ("suppressed".equals(codeString)) {
                return IssueType.SUPPRESSED;
            }
            if ("processing".equals(codeString)) {
                return IssueType.PROCESSING;
            }
            if ("not-supported".equals(codeString)) {
                return IssueType.NOTSUPPORTED;
            }
            if ("duplicate".equals(codeString)) {
                return IssueType.DUPLICATE;
            }
            if ("not-found".equals(codeString)) {
                return IssueType.NOTFOUND;
            }
            if ("too-long".equals(codeString)) {
                return IssueType.TOOLONG;
            }
            if ("code-invalid".equals(codeString)) {
                return IssueType.CODEINVALID;
            }
            if ("extension".equals(codeString)) {
                return IssueType.EXTENSION;
            }
            if ("too-costly".equals(codeString)) {
                return IssueType.TOOCOSTLY;
            }
            if ("business-rule".equals(codeString)) {
                return IssueType.BUSINESSRULE;
            }
            if ("conflict".equals(codeString)) {
                return IssueType.CONFLICT;
            }
            if ("incomplete".equals(codeString)) {
                return IssueType.INCOMPLETE;
            }
            if ("transient".equals(codeString)) {
                return IssueType.TRANSIENT;
            }
            if ("lock-error".equals(codeString)) {
                return IssueType.LOCKERROR;
            }
            if ("no-store".equals(codeString)) {
                return IssueType.NOSTORE;
            }
            if ("exception".equals(codeString)) {
                return IssueType.EXCEPTION;
            }
            if ("timeout".equals(codeString)) {
                return IssueType.TIMEOUT;
            }
            if ("throttled".equals(codeString)) {
                return IssueType.THROTTLED;
            }
            if ("informational".equals(codeString)) {
                return IssueType.INFORMATIONAL;
            }
            throw new IllegalArgumentException("Unknown IssueType code '" + codeString + "'");
        }

        public Enumeration<IssueType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("invalid".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.INVALID);
            }
            if ("structure".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.STRUCTURE);
            }
            if ("required".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.REQUIRED);
            }
            if ("value".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.VALUE);
            }
            if ("invariant".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.INVARIANT);
            }
            if ("security".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.SECURITY);
            }
            if ("login".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.LOGIN);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.UNKNOWN);
            }
            if ("expired".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.EXPIRED);
            }
            if ("forbidden".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.FORBIDDEN);
            }
            if ("suppressed".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.SUPPRESSED);
            }
            if ("processing".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.PROCESSING);
            }
            if ("not-supported".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.NOTSUPPORTED);
            }
            if ("duplicate".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.DUPLICATE);
            }
            if ("not-found".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.NOTFOUND);
            }
            if ("too-long".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.TOOLONG);
            }
            if ("code-invalid".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.CODEINVALID);
            }
            if ("extension".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.EXTENSION);
            }
            if ("too-costly".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.TOOCOSTLY);
            }
            if ("business-rule".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.BUSINESSRULE);
            }
            if ("conflict".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.CONFLICT);
            }
            if ("incomplete".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.INCOMPLETE);
            }
            if ("transient".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.TRANSIENT);
            }
            if ("lock-error".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.LOCKERROR);
            }
            if ("no-store".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.NOSTORE);
            }
            if ("exception".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.EXCEPTION);
            }
            if ("timeout".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.TIMEOUT);
            }
            if ("throttled".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.THROTTLED);
            }
            if ("informational".equals(codeString)) {
                return new Enumeration<IssueType>(this, IssueType.INFORMATIONAL);
            }
            throw new FHIRException("Unknown IssueType code '" + codeString + "'");
        }

        @Override
        public String toCode(IssueType code) {
            if (code == IssueType.INVALID) {
                return "invalid";
            }
            if (code == IssueType.STRUCTURE) {
                return "structure";
            }
            if (code == IssueType.REQUIRED) {
                return "required";
            }
            if (code == IssueType.VALUE) {
                return "value";
            }
            if (code == IssueType.INVARIANT) {
                return "invariant";
            }
            if (code == IssueType.SECURITY) {
                return "security";
            }
            if (code == IssueType.LOGIN) {
                return "login";
            }
            if (code == IssueType.UNKNOWN) {
                return "unknown";
            }
            if (code == IssueType.EXPIRED) {
                return "expired";
            }
            if (code == IssueType.FORBIDDEN) {
                return "forbidden";
            }
            if (code == IssueType.SUPPRESSED) {
                return "suppressed";
            }
            if (code == IssueType.PROCESSING) {
                return "processing";
            }
            if (code == IssueType.NOTSUPPORTED) {
                return "not-supported";
            }
            if (code == IssueType.DUPLICATE) {
                return "duplicate";
            }
            if (code == IssueType.NOTFOUND) {
                return "not-found";
            }
            if (code == IssueType.TOOLONG) {
                return "too-long";
            }
            if (code == IssueType.CODEINVALID) {
                return "code-invalid";
            }
            if (code == IssueType.EXTENSION) {
                return "extension";
            }
            if (code == IssueType.TOOCOSTLY) {
                return "too-costly";
            }
            if (code == IssueType.BUSINESSRULE) {
                return "business-rule";
            }
            if (code == IssueType.CONFLICT) {
                return "conflict";
            }
            if (code == IssueType.INCOMPLETE) {
                return "incomplete";
            }
            if (code == IssueType.TRANSIENT) {
                return "transient";
            }
            if (code == IssueType.LOCKERROR) {
                return "lock-error";
            }
            if (code == IssueType.NOSTORE) {
                return "no-store";
            }
            if (code == IssueType.EXCEPTION) {
                return "exception";
            }
            if (code == IssueType.TIMEOUT) {
                return "timeout";
            }
            if (code == IssueType.THROTTLED) {
                return "throttled";
            }
            if (code == IssueType.INFORMATIONAL) {
                return "informational";
            }
            return "?";
        }

        @Override
        public String toSystem(IssueType code) {
            return code.getSystem();
        }
    }

    public static enum IssueType {
        INVALID,
        STRUCTURE,
        REQUIRED,
        VALUE,
        INVARIANT,
        SECURITY,
        LOGIN,
        UNKNOWN,
        EXPIRED,
        FORBIDDEN,
        SUPPRESSED,
        PROCESSING,
        NOTSUPPORTED,
        DUPLICATE,
        NOTFOUND,
        TOOLONG,
        CODEINVALID,
        EXTENSION,
        TOOCOSTLY,
        BUSINESSRULE,
        CONFLICT,
        INCOMPLETE,
        TRANSIENT,
        LOCKERROR,
        NOSTORE,
        EXCEPTION,
        TIMEOUT,
        THROTTLED,
        INFORMATIONAL,
        NULL;


        public static IssueType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("invalid".equals(codeString)) {
                return INVALID;
            }
            if ("structure".equals(codeString)) {
                return STRUCTURE;
            }
            if ("required".equals(codeString)) {
                return REQUIRED;
            }
            if ("value".equals(codeString)) {
                return VALUE;
            }
            if ("invariant".equals(codeString)) {
                return INVARIANT;
            }
            if ("security".equals(codeString)) {
                return SECURITY;
            }
            if ("login".equals(codeString)) {
                return LOGIN;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if ("expired".equals(codeString)) {
                return EXPIRED;
            }
            if ("forbidden".equals(codeString)) {
                return FORBIDDEN;
            }
            if ("suppressed".equals(codeString)) {
                return SUPPRESSED;
            }
            if ("processing".equals(codeString)) {
                return PROCESSING;
            }
            if ("not-supported".equals(codeString)) {
                return NOTSUPPORTED;
            }
            if ("duplicate".equals(codeString)) {
                return DUPLICATE;
            }
            if ("not-found".equals(codeString)) {
                return NOTFOUND;
            }
            if ("too-long".equals(codeString)) {
                return TOOLONG;
            }
            if ("code-invalid".equals(codeString)) {
                return CODEINVALID;
            }
            if ("extension".equals(codeString)) {
                return EXTENSION;
            }
            if ("too-costly".equals(codeString)) {
                return TOOCOSTLY;
            }
            if ("business-rule".equals(codeString)) {
                return BUSINESSRULE;
            }
            if ("conflict".equals(codeString)) {
                return CONFLICT;
            }
            if ("incomplete".equals(codeString)) {
                return INCOMPLETE;
            }
            if ("transient".equals(codeString)) {
                return TRANSIENT;
            }
            if ("lock-error".equals(codeString)) {
                return LOCKERROR;
            }
            if ("no-store".equals(codeString)) {
                return NOSTORE;
            }
            if ("exception".equals(codeString)) {
                return EXCEPTION;
            }
            if ("timeout".equals(codeString)) {
                return TIMEOUT;
            }
            if ("throttled".equals(codeString)) {
                return THROTTLED;
            }
            if ("informational".equals(codeString)) {
                return INFORMATIONAL;
            }
            throw new FHIRException("Unknown IssueType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INVALID: {
                    return "invalid";
                }
                case STRUCTURE: {
                    return "structure";
                }
                case REQUIRED: {
                    return "required";
                }
                case VALUE: {
                    return "value";
                }
                case INVARIANT: {
                    return "invariant";
                }
                case SECURITY: {
                    return "security";
                }
                case LOGIN: {
                    return "login";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case EXPIRED: {
                    return "expired";
                }
                case FORBIDDEN: {
                    return "forbidden";
                }
                case SUPPRESSED: {
                    return "suppressed";
                }
                case PROCESSING: {
                    return "processing";
                }
                case NOTSUPPORTED: {
                    return "not-supported";
                }
                case DUPLICATE: {
                    return "duplicate";
                }
                case NOTFOUND: {
                    return "not-found";
                }
                case TOOLONG: {
                    return "too-long";
                }
                case CODEINVALID: {
                    return "code-invalid";
                }
                case EXTENSION: {
                    return "extension";
                }
                case TOOCOSTLY: {
                    return "too-costly";
                }
                case BUSINESSRULE: {
                    return "business-rule";
                }
                case CONFLICT: {
                    return "conflict";
                }
                case INCOMPLETE: {
                    return "incomplete";
                }
                case TRANSIENT: {
                    return "transient";
                }
                case LOCKERROR: {
                    return "lock-error";
                }
                case NOSTORE: {
                    return "no-store";
                }
                case EXCEPTION: {
                    return "exception";
                }
                case TIMEOUT: {
                    return "timeout";
                }
                case THROTTLED: {
                    return "throttled";
                }
                case INFORMATIONAL: {
                    return "informational";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INVALID: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case STRUCTURE: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case REQUIRED: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case VALUE: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case INVARIANT: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case SECURITY: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case LOGIN: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case EXPIRED: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case FORBIDDEN: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case SUPPRESSED: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case PROCESSING: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case NOTSUPPORTED: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case DUPLICATE: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case NOTFOUND: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case TOOLONG: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case CODEINVALID: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case EXTENSION: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case TOOCOSTLY: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case BUSINESSRULE: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case CONFLICT: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case INCOMPLETE: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case TRANSIENT: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case LOCKERROR: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case NOSTORE: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case EXCEPTION: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case TIMEOUT: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case THROTTLED: {
                    return "http://hl7.org/fhir/issue-type";
                }
                case INFORMATIONAL: {
                    return "http://hl7.org/fhir/issue-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INVALID: {
                    return "Content invalid against the specification or a profile.";
                }
                case STRUCTURE: {
                    return "A structural issue in the content such as wrong namespace, or unable to parse the content completely, or invalid json syntax.";
                }
                case REQUIRED: {
                    return "A required element is missing.";
                }
                case VALUE: {
                    return "An element value is invalid.";
                }
                case INVARIANT: {
                    return "A content validation rule failed - e.g. a schematron rule.";
                }
                case SECURITY: {
                    return "An authentication/authorization/permissions issue of some kind.";
                }
                case LOGIN: {
                    return "The client needs to initiate an authentication process.";
                }
                case UNKNOWN: {
                    return "The user or system was not able to be authenticated (either there is no process, or the proferred token is unacceptable).";
                }
                case EXPIRED: {
                    return "User session expired; a login may be required.";
                }
                case FORBIDDEN: {
                    return "The user does not have the rights to perform this action.";
                }
                case SUPPRESSED: {
                    return "Some information was not or may not have been returned due to business rules, consent or privacy rules, or access permission constraints.  This information may be accessible through alternate processes.";
                }
                case PROCESSING: {
                    return "Processing issues. These are expected to be final e.g. there is no point resubmitting the same content unchanged.";
                }
                case NOTSUPPORTED: {
                    return "The resource or profile is not supported.";
                }
                case DUPLICATE: {
                    return "An attempt was made to create a duplicate record.";
                }
                case NOTFOUND: {
                    return "The reference provided was not found. In a pure RESTful environment, this would be an HTTP 404 error, but this code may be used where the content is not found further into the application architecture.";
                }
                case TOOLONG: {
                    return "Provided content is too long (typically, this is a denial of service protection type of error).";
                }
                case CODEINVALID: {
                    return "The code or system could not be understood, or it was not valid in the context of a particular ValueSet.code.";
                }
                case EXTENSION: {
                    return "An extension was found that was not acceptable, could not be resolved, or a modifierExtension was not recognized.";
                }
                case TOOCOSTLY: {
                    return "The operation was stopped to protect server resources; e.g. a request for a value set expansion on all of SNOMED CT.";
                }
                case BUSINESSRULE: {
                    return "The content/operation failed to pass some business rule, and so could not proceed.";
                }
                case CONFLICT: {
                    return "Content could not be accepted because of an edit conflict (i.e. version aware updates) (In a pure RESTful environment, this would be an HTTP 404 error, but this code may be used where the conflict is discovered further into the application architecture.)";
                }
                case INCOMPLETE: {
                    return "Not all data sources typically accessed could be reached, or responded in time, so the returned information may not be complete.";
                }
                case TRANSIENT: {
                    return "Transient processing issues. The system receiving the error may be able to resubmit the same content once an underlying issue is resolved.";
                }
                case LOCKERROR: {
                    return "A resource/record locking failure (usually in an underlying database).";
                }
                case NOSTORE: {
                    return "The persistent store is unavailable; e.g. the database is down for maintenance or similar action.";
                }
                case EXCEPTION: {
                    return "An unexpected internal error has occurred.";
                }
                case TIMEOUT: {
                    return "An internal timeout has occurred.";
                }
                case THROTTLED: {
                    return "The system is not prepared to handle this request due to load management.";
                }
                case INFORMATIONAL: {
                    return "A message unrelated to the processing success of the completed operation (examples of the latter include things like reminders of password expiry, system maintenance times, etc.).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INVALID: {
                    return "Invalid Content";
                }
                case STRUCTURE: {
                    return "Structural Issue";
                }
                case REQUIRED: {
                    return "Required element missing";
                }
                case VALUE: {
                    return "Element value invalid";
                }
                case INVARIANT: {
                    return "Validation rule failed";
                }
                case SECURITY: {
                    return "Security Problem";
                }
                case LOGIN: {
                    return "Login Required";
                }
                case UNKNOWN: {
                    return "Unknown User";
                }
                case EXPIRED: {
                    return "Session Expired";
                }
                case FORBIDDEN: {
                    return "Forbidden";
                }
                case SUPPRESSED: {
                    return "Information  Suppressed";
                }
                case PROCESSING: {
                    return "Processing Failure";
                }
                case NOTSUPPORTED: {
                    return "Content not supported";
                }
                case DUPLICATE: {
                    return "Duplicate";
                }
                case NOTFOUND: {
                    return "Not Found";
                }
                case TOOLONG: {
                    return "Content Too Long";
                }
                case CODEINVALID: {
                    return "Invalid Code";
                }
                case EXTENSION: {
                    return "Unacceptable Extension";
                }
                case TOOCOSTLY: {
                    return "Operation Too Costly";
                }
                case BUSINESSRULE: {
                    return "Business Rule Violation";
                }
                case CONFLICT: {
                    return "Edit Version Conflict";
                }
                case INCOMPLETE: {
                    return "Incomplete Results";
                }
                case TRANSIENT: {
                    return "Transient Issue";
                }
                case LOCKERROR: {
                    return "Lock Error";
                }
                case NOSTORE: {
                    return "No Store Available";
                }
                case EXCEPTION: {
                    return "Exception";
                }
                case TIMEOUT: {
                    return "Timeout";
                }
                case THROTTLED: {
                    return "Throttled";
                }
                case INFORMATIONAL: {
                    return "Informational Note";
                }
            }
            return "?";
        }
    }

    public static class IssueSeverityEnumFactory
    implements EnumFactory<IssueSeverity> {
        @Override
        public IssueSeverity fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("fatal".equals(codeString)) {
                return IssueSeverity.FATAL;
            }
            if ("error".equals(codeString)) {
                return IssueSeverity.ERROR;
            }
            if ("warning".equals(codeString)) {
                return IssueSeverity.WARNING;
            }
            if ("information".equals(codeString)) {
                return IssueSeverity.INFORMATION;
            }
            throw new IllegalArgumentException("Unknown IssueSeverity code '" + codeString + "'");
        }

        public Enumeration<IssueSeverity> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("fatal".equals(codeString)) {
                return new Enumeration<IssueSeverity>(this, IssueSeverity.FATAL);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<IssueSeverity>(this, IssueSeverity.ERROR);
            }
            if ("warning".equals(codeString)) {
                return new Enumeration<IssueSeverity>(this, IssueSeverity.WARNING);
            }
            if ("information".equals(codeString)) {
                return new Enumeration<IssueSeverity>(this, IssueSeverity.INFORMATION);
            }
            throw new FHIRException("Unknown IssueSeverity code '" + codeString + "'");
        }

        @Override
        public String toCode(IssueSeverity code) {
            if (code == IssueSeverity.FATAL) {
                return "fatal";
            }
            if (code == IssueSeverity.ERROR) {
                return "error";
            }
            if (code == IssueSeverity.WARNING) {
                return "warning";
            }
            if (code == IssueSeverity.INFORMATION) {
                return "information";
            }
            return "?";
        }

        @Override
        public String toSystem(IssueSeverity code) {
            return code.getSystem();
        }
    }

    public static enum IssueSeverity {
        FATAL,
        ERROR,
        WARNING,
        INFORMATION,
        NULL;


        public static IssueSeverity fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("fatal".equals(codeString)) {
                return FATAL;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if ("warning".equals(codeString)) {
                return WARNING;
            }
            if ("information".equals(codeString)) {
                return INFORMATION;
            }
            throw new FHIRException("Unknown IssueSeverity code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case FATAL: {
                    return "fatal";
                }
                case ERROR: {
                    return "error";
                }
                case WARNING: {
                    return "warning";
                }
                case INFORMATION: {
                    return "information";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case FATAL: {
                    return "http://hl7.org/fhir/issue-severity";
                }
                case ERROR: {
                    return "http://hl7.org/fhir/issue-severity";
                }
                case WARNING: {
                    return "http://hl7.org/fhir/issue-severity";
                }
                case INFORMATION: {
                    return "http://hl7.org/fhir/issue-severity";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case FATAL: {
                    return "The issue caused the action to fail, and no further checking could be performed.";
                }
                case ERROR: {
                    return "The issue is sufficiently important to cause the action to fail.";
                }
                case WARNING: {
                    return "The issue is not important enough to cause the action to fail, but may cause it to be performed suboptimally or in a way that is not as desired.";
                }
                case INFORMATION: {
                    return "The issue has no relation to the degree of success of the action.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case FATAL: {
                    return "Fatal";
                }
                case ERROR: {
                    return "Error";
                }
                case WARNING: {
                    return "Warning";
                }
                case INFORMATION: {
                    return "Information";
                }
            }
            return "?";
        }
    }
}

