/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="ParameterDefinition")
public class ParameterDefinition
extends Type
implements ICompositeType {
    @Child(name="name", type={CodeType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Parameter name", formalDefinition="The name of the parameter.")
    protected CodeType name;
    @Child(name="use", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="", formalDefinition="Whether the parameter is input or output for the module.")
    protected CodeType use;
    @Child(name="min", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Minimum cardinality", formalDefinition="The minimum number of times this parameter SHALL appear in the request or response.")
    protected IntegerType min;
    @Child(name="max", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Maximum cardinality (a number of *)", formalDefinition="The maximum number of times this element is permitted to appear in the request or response.")
    protected StringType max;
    @Child(name="documentation", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A brief description of the parameter", formalDefinition="A brief discussion of what the parameter is for and how it is used by the module.")
    protected StringType documentation;
    @Child(name="type", type={CodeType.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="", formalDefinition="The type of the parameter.")
    protected CodeType type;
    @Child(name="profile", type={StructureDefinition.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The profile of the parameter, any", formalDefinition="If specified, this indicates a profile that the input data must conform to, or that the output data will conform to.")
    protected Reference profile;
    protected StructureDefinition profileTarget;
    private static final long serialVersionUID = -1284894445L;

    public ParameterDefinition() {
    }

    public ParameterDefinition(CodeType use, CodeType type) {
        this.use = use;
        this.type = type;
    }

    public CodeType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ParameterDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new CodeType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public ParameterDefinition setNameElement(CodeType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public ParameterDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new CodeType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public CodeType getUseElement() {
        if (this.use == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ParameterDefinition.use");
            }
            if (Configuration.doAutoCreate()) {
                this.use = new CodeType();
            }
        }
        return this.use;
    }

    public boolean hasUseElement() {
        return this.use != null && !this.use.isEmpty();
    }

    public boolean hasUse() {
        return this.use != null && !this.use.isEmpty();
    }

    public ParameterDefinition setUseElement(CodeType value) {
        this.use = value;
        return this;
    }

    public String getUse() {
        return this.use == null ? null : (String)this.use.getValue();
    }

    public ParameterDefinition setUse(String value) {
        if (this.use == null) {
            this.use = new CodeType();
        }
        this.use.setValue(value);
        return this;
    }

    public IntegerType getMinElement() {
        if (this.min == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ParameterDefinition.min");
            }
            if (Configuration.doAutoCreate()) {
                this.min = new IntegerType();
            }
        }
        return this.min;
    }

    public boolean hasMinElement() {
        return this.min != null && !this.min.isEmpty();
    }

    public boolean hasMin() {
        return this.min != null && !this.min.isEmpty();
    }

    public ParameterDefinition setMinElement(IntegerType value) {
        this.min = value;
        return this;
    }

    public int getMin() {
        return this.min == null || this.min.isEmpty() ? 0 : (Integer)this.min.getValue();
    }

    public ParameterDefinition setMin(int value) {
        if (this.min == null) {
            this.min = new IntegerType();
        }
        this.min.setValue((Object)value);
        return this;
    }

    public StringType getMaxElement() {
        if (this.max == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ParameterDefinition.max");
            }
            if (Configuration.doAutoCreate()) {
                this.max = new StringType();
            }
        }
        return this.max;
    }

    public boolean hasMaxElement() {
        return this.max != null && !this.max.isEmpty();
    }

    public boolean hasMax() {
        return this.max != null && !this.max.isEmpty();
    }

    public ParameterDefinition setMaxElement(StringType value) {
        this.max = value;
        return this;
    }

    public String getMax() {
        return this.max == null ? null : (String)this.max.getValue();
    }

    public ParameterDefinition setMax(String value) {
        if (Utilities.noString((String)value)) {
            this.max = null;
        } else {
            if (this.max == null) {
                this.max = new StringType();
            }
            this.max.setValue(value);
        }
        return this;
    }

    public StringType getDocumentationElement() {
        if (this.documentation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ParameterDefinition.documentation");
            }
            if (Configuration.doAutoCreate()) {
                this.documentation = new StringType();
            }
        }
        return this.documentation;
    }

    public boolean hasDocumentationElement() {
        return this.documentation != null && !this.documentation.isEmpty();
    }

    public boolean hasDocumentation() {
        return this.documentation != null && !this.documentation.isEmpty();
    }

    public ParameterDefinition setDocumentationElement(StringType value) {
        this.documentation = value;
        return this;
    }

    public String getDocumentation() {
        return this.documentation == null ? null : (String)this.documentation.getValue();
    }

    public ParameterDefinition setDocumentation(String value) {
        if (Utilities.noString((String)value)) {
            this.documentation = null;
        } else {
            if (this.documentation == null) {
                this.documentation = new StringType();
            }
            this.documentation.setValue(value);
        }
        return this;
    }

    public CodeType getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ParameterDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeType();
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public ParameterDefinition setTypeElement(CodeType value) {
        this.type = value;
        return this;
    }

    public String getType() {
        return this.type == null ? null : (String)this.type.getValue();
    }

    public ParameterDefinition setType(String value) {
        if (this.type == null) {
            this.type = new CodeType();
        }
        this.type.setValue(value);
        return this;
    }

    public Reference getProfile() {
        if (this.profile == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ParameterDefinition.profile");
            }
            if (Configuration.doAutoCreate()) {
                this.profile = new Reference();
            }
        }
        return this.profile;
    }

    public boolean hasProfile() {
        return this.profile != null && !this.profile.isEmpty();
    }

    public ParameterDefinition setProfile(Reference value) {
        this.profile = value;
        return this;
    }

    public StructureDefinition getProfileTarget() {
        if (this.profileTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ParameterDefinition.profile");
            }
            if (Configuration.doAutoCreate()) {
                this.profileTarget = new StructureDefinition();
            }
        }
        return this.profileTarget;
    }

    public ParameterDefinition setProfileTarget(StructureDefinition value) {
        this.profileTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("name", "code", "The name of the parameter.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property("use", "code", "Whether the parameter is input or output for the module.", 0, Integer.MAX_VALUE, this.use));
        childrenList.add(new Property("min", "integer", "The minimum number of times this parameter SHALL appear in the request or response.", 0, Integer.MAX_VALUE, this.min));
        childrenList.add(new Property("max", "string", "The maximum number of times this element is permitted to appear in the request or response.", 0, Integer.MAX_VALUE, this.max));
        childrenList.add(new Property("documentation", "string", "A brief discussion of what the parameter is for and how it is used by the module.", 0, Integer.MAX_VALUE, this.documentation));
        childrenList.add(new Property("type", "code", "The type of the parameter.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("profile", "Reference(StructureDefinition)", "If specified, this indicates a profile that the input data must conform to, or that the output data will conform to.", 0, Integer.MAX_VALUE, this.profile));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.name;
                }
                return baseArray;
            }
            case 116103: {
                Base[] baseArray;
                if (this.use == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.use;
                }
                return baseArray;
            }
            case 108114: {
                Base[] baseArray;
                if (this.min == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.min;
                }
                return baseArray;
            }
            case 107876: {
                Base[] baseArray;
                if (this.max == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.max;
                }
                return baseArray;
            }
            case 1587405498: {
                Base[] baseArray;
                if (this.documentation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.documentation;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.type;
                }
                return baseArray;
            }
            case -309425751: {
                Base[] baseArray;
                if (this.profile == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.profile;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3373707: {
                this.name = this.castToCode(value);
                break;
            }
            case 116103: {
                this.use = this.castToCode(value);
                break;
            }
            case 108114: {
                this.min = this.castToInteger(value);
                break;
            }
            case 107876: {
                this.max = this.castToString(value);
                break;
            }
            case 1587405498: {
                this.documentation = this.castToString(value);
                break;
            }
            case 3575610: {
                this.type = this.castToCode(value);
                break;
            }
            case -309425751: {
                this.profile = this.castToReference(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("name")) {
            this.name = this.castToCode(value);
        } else if (name.equals("use")) {
            this.use = this.castToCode(value);
        } else if (name.equals("min")) {
            this.min = this.castToInteger(value);
        } else if (name.equals("max")) {
            this.max = this.castToString(value);
        } else if (name.equals("documentation")) {
            this.documentation = this.castToString(value);
        } else if (name.equals("type")) {
            this.type = this.castToCode(value);
        } else if (name.equals("profile")) {
            this.profile = this.castToReference(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3373707: {
                throw new FHIRException("Cannot make property name as it is not a complex type");
            }
            case 116103: {
                throw new FHIRException("Cannot make property use as it is not a complex type");
            }
            case 108114: {
                throw new FHIRException("Cannot make property min as it is not a complex type");
            }
            case 107876: {
                throw new FHIRException("Cannot make property max as it is not a complex type");
            }
            case 1587405498: {
                throw new FHIRException("Cannot make property documentation as it is not a complex type");
            }
            case 3575610: {
                throw new FHIRException("Cannot make property type as it is not a complex type");
            }
            case -309425751: {
                return this.getProfile();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type ParameterDefinition.name");
        }
        if (name.equals("use")) {
            throw new FHIRException("Cannot call addChild on a primitive type ParameterDefinition.use");
        }
        if (name.equals("min")) {
            throw new FHIRException("Cannot call addChild on a primitive type ParameterDefinition.min");
        }
        if (name.equals("max")) {
            throw new FHIRException("Cannot call addChild on a primitive type ParameterDefinition.max");
        }
        if (name.equals("documentation")) {
            throw new FHIRException("Cannot call addChild on a primitive type ParameterDefinition.documentation");
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a primitive type ParameterDefinition.type");
        }
        if (name.equals("profile")) {
            this.profile = new Reference();
            return this.profile;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ParameterDefinition";
    }

    @Override
    public ParameterDefinition copy() {
        ParameterDefinition dst = new ParameterDefinition();
        this.copyValues(dst);
        dst.name = this.name == null ? null : this.name.copy();
        dst.use = this.use == null ? null : this.use.copy();
        dst.min = this.min == null ? null : this.min.copy();
        dst.max = this.max == null ? null : this.max.copy();
        dst.documentation = this.documentation == null ? null : this.documentation.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.profile = this.profile == null ? null : this.profile.copy();
        return dst;
    }

    @Override
    protected ParameterDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ParameterDefinition)) {
            return false;
        }
        ParameterDefinition o = (ParameterDefinition)other;
        return ParameterDefinition.compareDeep(this.name, o.name, true) && ParameterDefinition.compareDeep(this.use, o.use, true) && ParameterDefinition.compareDeep(this.min, o.min, true) && ParameterDefinition.compareDeep(this.max, o.max, true) && ParameterDefinition.compareDeep(this.documentation, o.documentation, true) && ParameterDefinition.compareDeep(this.type, o.type, true) && ParameterDefinition.compareDeep(this.profile, o.profile, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ParameterDefinition)) {
            return false;
        }
        ParameterDefinition o = (ParameterDefinition)other;
        return ParameterDefinition.compareValues(this.name, o.name, true) && ParameterDefinition.compareValues(this.use, o.use, true) && ParameterDefinition.compareValues(this.min, o.min, true) && ParameterDefinition.compareValues(this.max, o.max, true) && ParameterDefinition.compareValues(this.documentation, o.documentation, true) && ParameterDefinition.compareValues(this.type, o.type, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.use != null && !this.use.isEmpty() || this.min != null && !this.min.isEmpty() || this.max != null && !this.max.isEmpty() || this.documentation != null && !this.documentation.isEmpty() || this.type != null && !this.type.isEmpty() || this.profile != null && !this.profile.isEmpty());
    }
}

