/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Medication;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.Substance;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="SupplyRequest", profile="http://hl7.org/fhir/Profile/SupplyRequest")
public class SupplyRequest
extends DomainResource {
    @Child(name="patient", type={Patient.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient for whom the item is supplied", formalDefinition="A link to a resource representing the person whom the ordered item is for.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="source", type={Practitioner.class, Organization.class, Patient.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who initiated this order", formalDefinition="The Practitioner , Organization or Patient who initiated this order for the supply.")
    protected Reference source;
    protected Resource sourceTarget;
    @Child(name="date", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the request was made", formalDefinition="When the request was made.")
    protected DateTimeType date;
    @Child(name="identifier", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="Unique identifier for this supply request.")
    protected Identifier identifier;
    @Child(name="status", type={CodeType.class}, order=4, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="requested | completed | failed | cancelled", formalDefinition="Status of the supply request.")
    protected Enumeration<SupplyRequestStatus> status;
    @Child(name="kind", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The kind of supply (central, non-stock, etc.)", formalDefinition="Category of supply, e.g.  central, non-stock, etc. This is used to support work flows associated with the supply process.")
    protected CodeableConcept kind;
    @Child(name="orderedItem", type={Medication.class, Substance.class, Device.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Medication, Substance, or Device requested to be supplied", formalDefinition="The item that is requested to be supplied.")
    protected Reference orderedItem;
    protected Resource orderedItemTarget;
    @Child(name="supplier", type={Organization.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who is intended to fulfill the request", formalDefinition="Who is intended to fulfill the request.")
    protected List<Reference> supplier;
    protected List<Organization> supplierTarget;
    @Child(name="reason", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Why the supply item was requested", formalDefinition="Why the supply item was requested.")
    protected Type reason;
    @Child(name="when", type={}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the request should be fulfilled", formalDefinition="When the request should be fulfilled.")
    protected SupplyRequestWhenComponent when;
    private static final long serialVersionUID = 1649766198L;
    @SearchParamDefinition(name="patient", path="SupplyRequest.patient", description="Patient for whom the item is supplied", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("SupplyRequest:patient").toLocked();
    @SearchParamDefinition(name="source", path="SupplyRequest.source", description="Who initiated this order", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("SupplyRequest:source").toLocked();
    @SearchParamDefinition(name="status", path="SupplyRequest.status", description="requested | completed | failed | cancelled", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="SupplyRequest.date", description="When the request was made", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="SupplyRequest.identifier", description="Unique identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="supplier", path="SupplyRequest.supplier", description="Who is intended to fulfill the request", type="reference")
    public static final String SP_SUPPLIER = "supplier";
    public static final ReferenceClientParam SUPPLIER = new ReferenceClientParam("supplier");
    public static final Include INCLUDE_SUPPLIER = new Include("SupplyRequest:supplier").toLocked();
    @SearchParamDefinition(name="kind", path="SupplyRequest.kind", description="The kind of supply (central, non-stock, etc.)", type="token")
    public static final String SP_KIND = "kind";
    public static final TokenClientParam KIND = new TokenClientParam("kind");

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public SupplyRequest setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public SupplyRequest setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new Reference();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public SupplyRequest setSource(Reference value) {
        this.source = value;
        return this;
    }

    public Resource getSourceTarget() {
        return this.sourceTarget;
    }

    public SupplyRequest setSourceTarget(Resource value) {
        this.sourceTarget = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public SupplyRequest setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public SupplyRequest setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public SupplyRequest setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Enumeration<SupplyRequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<SupplyRequestStatus>(new SupplyRequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public SupplyRequest setStatusElement(Enumeration<SupplyRequestStatus> value) {
        this.status = value;
        return this;
    }

    public SupplyRequestStatus getStatus() {
        return this.status == null ? null : (SupplyRequestStatus)((Object)this.status.getValue());
    }

    public SupplyRequest setStatus(SupplyRequestStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<SupplyRequestStatus>(new SupplyRequestStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getKind() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new CodeableConcept();
            }
        }
        return this.kind;
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public SupplyRequest setKind(CodeableConcept value) {
        this.kind = value;
        return this;
    }

    public Reference getOrderedItem() {
        if (this.orderedItem == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.orderedItem");
            }
            if (Configuration.doAutoCreate()) {
                this.orderedItem = new Reference();
            }
        }
        return this.orderedItem;
    }

    public boolean hasOrderedItem() {
        return this.orderedItem != null && !this.orderedItem.isEmpty();
    }

    public SupplyRequest setOrderedItem(Reference value) {
        this.orderedItem = value;
        return this;
    }

    public Resource getOrderedItemTarget() {
        return this.orderedItemTarget;
    }

    public SupplyRequest setOrderedItemTarget(Resource value) {
        this.orderedItemTarget = value;
        return this;
    }

    public List<Reference> getSupplier() {
        if (this.supplier == null) {
            this.supplier = new ArrayList<Reference>();
        }
        return this.supplier;
    }

    public boolean hasSupplier() {
        if (this.supplier == null) {
            return false;
        }
        for (Reference item : this.supplier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupplier() {
        Reference t = new Reference();
        if (this.supplier == null) {
            this.supplier = new ArrayList<Reference>();
        }
        this.supplier.add(t);
        return t;
    }

    public SupplyRequest addSupplier(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supplier == null) {
            this.supplier = new ArrayList<Reference>();
        }
        this.supplier.add(t);
        return this;
    }

    public List<Organization> getSupplierTarget() {
        if (this.supplierTarget == null) {
            this.supplierTarget = new ArrayList<Organization>();
        }
        return this.supplierTarget;
    }

    public Organization addSupplierTarget() {
        Organization r = new Organization();
        if (this.supplierTarget == null) {
            this.supplierTarget = new ArrayList<Organization>();
        }
        this.supplierTarget.add(r);
        return r;
    }

    public Type getReason() {
        return this.reason;
    }

    public CodeableConcept getReasonCodeableConcept() throws FHIRException {
        if (!(this.reason instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.reason;
    }

    public boolean hasReasonCodeableConcept() {
        return this.reason instanceof CodeableConcept;
    }

    public Reference getReasonReference() throws FHIRException {
        if (!(this.reason instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (Reference)this.reason;
    }

    public boolean hasReasonReference() {
        return this.reason instanceof Reference;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public SupplyRequest setReason(Type value) {
        this.reason = value;
        return this;
    }

    public SupplyRequestWhenComponent getWhen() {
        if (this.when == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.when");
            }
            if (Configuration.doAutoCreate()) {
                this.when = new SupplyRequestWhenComponent();
            }
        }
        return this.when;
    }

    public boolean hasWhen() {
        return this.when != null && !this.when.isEmpty();
    }

    public SupplyRequest setWhen(SupplyRequestWhenComponent value) {
        this.when = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "A link to a resource representing the person whom the ordered item is for.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property(SP_SOURCE, "Reference(Practitioner|Organization|Patient)", "The Practitioner , Organization or Patient who initiated this order for the supply.", 0, Integer.MAX_VALUE, this.source));
        childrenList.add(new Property(SP_DATE, "dateTime", "When the request was made.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this supply request.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_STATUS, "code", "Status of the supply request.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_KIND, "CodeableConcept", "Category of supply, e.g.  central, non-stock, etc. This is used to support work flows associated with the supply process.", 0, Integer.MAX_VALUE, this.kind));
        childrenList.add(new Property("orderedItem", "Reference(Medication|Substance|Device)", "The item that is requested to be supplied.", 0, Integer.MAX_VALUE, this.orderedItem));
        childrenList.add(new Property(SP_SUPPLIER, "Reference(Organization)", "Who is intended to fulfill the request.", 0, Integer.MAX_VALUE, this.supplier));
        childrenList.add(new Property("reason[x]", "CodeableConcept|Reference(Any)", "Why the supply item was requested.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property("when", "", "When the request should be fulfilled.", 0, Integer.MAX_VALUE, this.when));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.patient;
                }
                return baseArray;
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.source;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.date;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.identifier;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case 3292052: {
                Base[] baseArray;
                if (this.kind == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.kind;
                }
                return baseArray;
            }
            case 2129914144: {
                Base[] baseArray;
                if (this.orderedItem == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.orderedItem;
                }
                return baseArray;
            }
            case -1663305268: {
                return this.supplier == null ? new Base[]{} : this.supplier.toArray(new Base[this.supplier.size()]);
            }
            case -934964668: {
                Base[] baseArray;
                if (this.reason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.reason;
                }
                return baseArray;
            }
            case 3648314: {
                Base[] baseArray;
                if (this.when == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.when;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case -896505829: {
                this.source = this.castToReference(value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                break;
            }
            case -892481550: {
                this.status = new SupplyRequestStatusEnumFactory().fromType(value);
                break;
            }
            case 3292052: {
                this.kind = this.castToCodeableConcept(value);
                break;
            }
            case 2129914144: {
                this.orderedItem = this.castToReference(value);
                break;
            }
            case -1663305268: {
                this.getSupplier().add(this.castToReference(value));
                break;
            }
            case -934964668: {
                this.reason = (Type)value;
                break;
            }
            case 3648314: {
                this.when = (SupplyRequestWhenComponent)value;
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_SOURCE)) {
            this.source = this.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new SupplyRequestStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_KIND)) {
            this.kind = this.castToCodeableConcept(value);
        } else if (name.equals("orderedItem")) {
            this.orderedItem = this.castToReference(value);
        } else if (name.equals(SP_SUPPLIER)) {
            this.getSupplier().add(this.castToReference(value));
        } else if (name.equals("reason[x]")) {
            this.reason = (Type)value;
        } else if (name.equals("when")) {
            this.when = (SupplyRequestWhenComponent)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -791418107: {
                return this.getPatient();
            }
            case -896505829: {
                return this.getSource();
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case -1618432855: {
                return this.getIdentifier();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 3292052: {
                return this.getKind();
            }
            case 2129914144: {
                return this.getOrderedItem();
            }
            case -1663305268: {
                return this.addSupplier();
            }
            case -669418564: {
                return this.getReason();
            }
            case 3648314: {
                return this.getWhen();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type SupplyRequest.date");
        }
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type SupplyRequest.status");
        }
        if (name.equals(SP_KIND)) {
            this.kind = new CodeableConcept();
            return this.kind;
        }
        if (name.equals("orderedItem")) {
            this.orderedItem = new Reference();
            return this.orderedItem;
        }
        if (name.equals(SP_SUPPLIER)) {
            return this.addSupplier();
        }
        if (name.equals("reasonCodeableConcept")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("reasonReference")) {
            this.reason = new Reference();
            return this.reason;
        }
        if (name.equals("when")) {
            this.when = new SupplyRequestWhenComponent();
            return this.when;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SupplyRequest";
    }

    @Override
    public SupplyRequest copy() {
        SupplyRequest dst = new SupplyRequest();
        this.copyValues(dst);
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.source = this.source == null ? null : this.source.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.kind = this.kind == null ? null : this.kind.copy();
        Reference reference = dst.orderedItem = this.orderedItem == null ? null : this.orderedItem.copy();
        if (this.supplier != null) {
            dst.supplier = new ArrayList<Reference>();
            for (Reference i : this.supplier) {
                dst.supplier.add(i.copy());
            }
        }
        dst.reason = this.reason == null ? null : this.reason.copy();
        dst.when = this.when == null ? null : this.when.copy();
        return dst;
    }

    protected SupplyRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof SupplyRequest)) {
            return false;
        }
        SupplyRequest o = (SupplyRequest)other;
        return SupplyRequest.compareDeep(this.patient, o.patient, true) && SupplyRequest.compareDeep(this.source, o.source, true) && SupplyRequest.compareDeep(this.date, o.date, true) && SupplyRequest.compareDeep(this.identifier, o.identifier, true) && SupplyRequest.compareDeep(this.status, o.status, true) && SupplyRequest.compareDeep(this.kind, o.kind, true) && SupplyRequest.compareDeep(this.orderedItem, o.orderedItem, true) && SupplyRequest.compareDeep(this.supplier, o.supplier, true) && SupplyRequest.compareDeep(this.reason, o.reason, true) && SupplyRequest.compareDeep(this.when, o.when, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof SupplyRequest)) {
            return false;
        }
        SupplyRequest o = (SupplyRequest)other;
        return SupplyRequest.compareValues(this.date, o.date, true) && SupplyRequest.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.source != null && !this.source.isEmpty() || this.date != null && !this.date.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.status != null && !this.status.isEmpty() || this.kind != null && !this.kind.isEmpty() || this.orderedItem != null && !this.orderedItem.isEmpty() || this.supplier != null && !this.supplier.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.when != null && !this.when.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SupplyRequest;
    }

    @Block
    public static class SupplyRequestWhenComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Fulfilment code", formalDefinition="Code indicating when the request should be fulfilled.")
        protected CodeableConcept code;
        @Child(name="schedule", type={Timing.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Formal fulfillment schedule", formalDefinition="Formal fulfillment schedule.")
        protected Timing schedule;
        private static final long serialVersionUID = 307115287L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupplyRequestWhenComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SupplyRequestWhenComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Timing getSchedule() {
            if (this.schedule == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupplyRequestWhenComponent.schedule");
                }
                if (Configuration.doAutoCreate()) {
                    this.schedule = new Timing();
                }
            }
            return this.schedule;
        }

        public boolean hasSchedule() {
            return this.schedule != null && !this.schedule.isEmpty();
        }

        public SupplyRequestWhenComponent setSchedule(Timing value) {
            this.schedule = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "CodeableConcept", "Code indicating when the request should be fulfilled.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("schedule", "Timing", "Formal fulfillment schedule.", 0, Integer.MAX_VALUE, this.schedule));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -697920873: {
                    Base[] baseArray;
                    if (this.schedule == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.schedule;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    break;
                }
                case -697920873: {
                    this.schedule = this.castToTiming(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("schedule")) {
                this.schedule = this.castToTiming(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -697920873: {
                    return this.getSchedule();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("schedule")) {
                this.schedule = new Timing();
                return this.schedule;
            }
            return super.addChild(name);
        }

        @Override
        public SupplyRequestWhenComponent copy() {
            SupplyRequestWhenComponent dst = new SupplyRequestWhenComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.schedule = this.schedule == null ? null : this.schedule.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SupplyRequestWhenComponent)) {
                return false;
            }
            SupplyRequestWhenComponent o = (SupplyRequestWhenComponent)other;
            return SupplyRequestWhenComponent.compareDeep(this.code, o.code, true) && SupplyRequestWhenComponent.compareDeep(this.schedule, o.schedule, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SupplyRequestWhenComponent)) {
                return false;
            }
            SupplyRequestWhenComponent o = (SupplyRequestWhenComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.schedule != null && !this.schedule.isEmpty());
        }

        @Override
        public String fhirType() {
            return "SupplyRequest.when";
        }
    }

    public static class SupplyRequestStatusEnumFactory
    implements EnumFactory<SupplyRequestStatus> {
        @Override
        public SupplyRequestStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("requested".equals(codeString)) {
                return SupplyRequestStatus.REQUESTED;
            }
            if ("completed".equals(codeString)) {
                return SupplyRequestStatus.COMPLETED;
            }
            if ("failed".equals(codeString)) {
                return SupplyRequestStatus.FAILED;
            }
            if ("cancelled".equals(codeString)) {
                return SupplyRequestStatus.CANCELLED;
            }
            throw new IllegalArgumentException("Unknown SupplyRequestStatus code '" + codeString + "'");
        }

        public Enumeration<SupplyRequestStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("requested".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.REQUESTED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.COMPLETED);
            }
            if ("failed".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.FAILED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.CANCELLED);
            }
            throw new FHIRException("Unknown SupplyRequestStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(SupplyRequestStatus code) {
            if (code == SupplyRequestStatus.REQUESTED) {
                return "requested";
            }
            if (code == SupplyRequestStatus.COMPLETED) {
                return "completed";
            }
            if (code == SupplyRequestStatus.FAILED) {
                return "failed";
            }
            if (code == SupplyRequestStatus.CANCELLED) {
                return "cancelled";
            }
            return "?";
        }

        @Override
        public String toSystem(SupplyRequestStatus code) {
            return code.getSystem();
        }
    }

    public static enum SupplyRequestStatus {
        REQUESTED,
        COMPLETED,
        FAILED,
        CANCELLED,
        NULL;


        public static SupplyRequestStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("requested".equals(codeString)) {
                return REQUESTED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("failed".equals(codeString)) {
                return FAILED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            throw new FHIRException("Unknown SupplyRequestStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REQUESTED: {
                    return "requested";
                }
                case COMPLETED: {
                    return "completed";
                }
                case FAILED: {
                    return "failed";
                }
                case CANCELLED: {
                    return "cancelled";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REQUESTED: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case FAILED: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REQUESTED: {
                    return "Supply has been requested, but not dispensed.";
                }
                case COMPLETED: {
                    return "Supply has been received by the requestor.";
                }
                case FAILED: {
                    return "The supply will not be completed because the supplier was unable or unwilling to supply the item.";
                }
                case CANCELLED: {
                    return "The orderer of the supply cancelled the request.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REQUESTED: {
                    return "Requested";
                }
                case COMPLETED: {
                    return "Received";
                }
                case FAILED: {
                    return "Failed";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
            }
            return "?";
        }
    }
}

