/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ActionPrecheckBehavior {
    YES,
    NO,
    NULL;


    public static ActionPrecheckBehavior fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("yes".equals(codeString)) {
            return YES;
        }
        if ("no".equals(codeString)) {
            return NO;
        }
        throw new FHIRException("Unknown ActionPrecheckBehavior code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case YES: {
                return "yes";
            }
            case NO: {
                return "no";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/action-precheck-behavior";
    }

    public String getDefinition() {
        switch (this) {
            case YES: {
                return "An action with this behavior is one of the most frequent action that is, or should be, included by an end user, for the particular context in which the action occurs. The system displaying the action to the end user should consider \"pre-checking\" such an action as a convenience for the user";
            }
            case NO: {
                return "An action with this behavior is one of the less frequent actions included by the end user, for the particular context in which the action occurs. The system displaying the actions to the end user would typically not \"pre-check\" such an action";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case YES: {
                return "Yes";
            }
            case NO: {
                return "No";
            }
        }
        return "?";
    }
}

