/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AllergyIntoleranceStatus {
    ACTIVE,
    UNCONFIRMED,
    CONFIRMED,
    INACTIVE,
    RESOLVED,
    REFUTED,
    ENTEREDINERROR,
    NULL;


    public static AllergyIntoleranceStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("unconfirmed".equals(codeString)) {
            return UNCONFIRMED;
        }
        if ("confirmed".equals(codeString)) {
            return CONFIRMED;
        }
        if ("inactive".equals(codeString)) {
            return INACTIVE;
        }
        if ("resolved".equals(codeString)) {
            return RESOLVED;
        }
        if ("refuted".equals(codeString)) {
            return REFUTED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown AllergyIntoleranceStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case UNCONFIRMED: {
                return "unconfirmed";
            }
            case CONFIRMED: {
                return "confirmed";
            }
            case INACTIVE: {
                return "inactive";
            }
            case RESOLVED: {
                return "resolved";
            }
            case REFUTED: {
                return "refuted";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/allergy-intolerance-status";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "An active record of a reaction to the identified Substance.";
            }
            case UNCONFIRMED: {
                return "A low level of certainty about the propensity for a reaction to the identified Substance.";
            }
            case CONFIRMED: {
                return "A high level of certainty about the propensity for a reaction to the identified Substance, which may include clinical evidence by testing or rechallenge.";
            }
            case INACTIVE: {
                return "An inactive record of a reaction to the identified Substance.";
            }
            case RESOLVED: {
                return "A reaction to the identified Substance has been clinically reassessed by testing or rechallenge and considered to be resolved.";
            }
            case REFUTED: {
                return "A propensity for a reaction to the identified Substance has been disproven with a high level of clinical certainty, which may include testing or rechallenge, and is refuted.";
            }
            case ENTEREDINERROR: {
                return "The statement was entered in error and is not valid.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case UNCONFIRMED: {
                return "Unconfirmed";
            }
            case CONFIRMED: {
                return "Confirmed";
            }
            case INACTIVE: {
                return "Inactive";
            }
            case RESOLVED: {
                return "Resolved";
            }
            case REFUTED: {
                return "Refuted";
            }
            case ENTEREDINERROR: {
                return "Entered In Error";
            }
        }
        return "?";
    }
}

