/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.CdsRuleParticipant;

public class CdsRuleParticipantEnumFactory
implements EnumFactory<CdsRuleParticipant> {
    @Override
    public CdsRuleParticipant fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("patient".equals(codeString)) {
            return CdsRuleParticipant.PATIENT;
        }
        if ("person".equals(codeString)) {
            return CdsRuleParticipant.PERSON;
        }
        if ("practitioner".equals(codeString)) {
            return CdsRuleParticipant.PRACTITIONER;
        }
        if ("related-person".equals(codeString)) {
            return CdsRuleParticipant.RELATEDPERSON;
        }
        throw new IllegalArgumentException("Unknown CdsRuleParticipant code '" + codeString + "'");
    }

    @Override
    public String toCode(CdsRuleParticipant code) {
        if (code == CdsRuleParticipant.PATIENT) {
            return "patient";
        }
        if (code == CdsRuleParticipant.PERSON) {
            return "person";
        }
        if (code == CdsRuleParticipant.PRACTITIONER) {
            return "practitioner";
        }
        if (code == CdsRuleParticipant.RELATEDPERSON) {
            return "related-person";
        }
        return "?";
    }

    @Override
    public String toSystem(CdsRuleParticipant code) {
        return code.getSystem();
    }
}

