/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum GoalStatus {
    PROPOSED,
    PLANNED,
    ACCEPTED,
    REJECTED,
    INPROGRESS,
    ACHIEVED,
    SUSTAINING,
    ONHOLD,
    CANCELLED,
    NULL;


    public static GoalStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposed".equals(codeString)) {
            return PROPOSED;
        }
        if ("planned".equals(codeString)) {
            return PLANNED;
        }
        if ("accepted".equals(codeString)) {
            return ACCEPTED;
        }
        if ("rejected".equals(codeString)) {
            return REJECTED;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("achieved".equals(codeString)) {
            return ACHIEVED;
        }
        if ("sustaining".equals(codeString)) {
            return SUSTAINING;
        }
        if ("on-hold".equals(codeString)) {
            return ONHOLD;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        throw new FHIRException("Unknown GoalStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROPOSED: {
                return "proposed";
            }
            case PLANNED: {
                return "planned";
            }
            case ACCEPTED: {
                return "accepted";
            }
            case REJECTED: {
                return "rejected";
            }
            case INPROGRESS: {
                return "in-progress";
            }
            case ACHIEVED: {
                return "achieved";
            }
            case SUSTAINING: {
                return "sustaining";
            }
            case ONHOLD: {
                return "on-hold";
            }
            case CANCELLED: {
                return "cancelled";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/goal-status";
    }

    public String getDefinition() {
        switch (this) {
            case PROPOSED: {
                return "A goal is proposed for this patient";
            }
            case PLANNED: {
                return "A goal is planned for this patient";
            }
            case ACCEPTED: {
                return "A proposed goal was accepted";
            }
            case REJECTED: {
                return "A proposed goal was rejected";
            }
            case INPROGRESS: {
                return "The goal is being sought but has not yet been reached.  (Also applies if goal was reached in the past but there has been regression and goal is being sought again)";
            }
            case ACHIEVED: {
                return "The goal has been met and no further action is needed";
            }
            case SUSTAINING: {
                return "The goal has been met, but ongoing activity is needed to sustain the goal objective";
            }
            case ONHOLD: {
                return "The goal remains a long term objective but is no longer being actively pursued for a temporary period of time.";
            }
            case CANCELLED: {
                return "The goal is no longer being sought";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROPOSED: {
                return "Proposed";
            }
            case PLANNED: {
                return "Planned";
            }
            case ACCEPTED: {
                return "Accepted";
            }
            case REJECTED: {
                return "Rejected";
            }
            case INPROGRESS: {
                return "In Progress";
            }
            case ACHIEVED: {
                return "Achieved";
            }
            case SUSTAINING: {
                return "Sustaining";
            }
            case ONHOLD: {
                return "On Hold";
            }
            case CANCELLED: {
                return "Cancelled";
            }
        }
        return "?";
    }
}

