/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ModuleMetadataResourceType {
    DOCUMENTATION,
    JUSTIFICATION,
    CITATION,
    PREDECESSOR,
    SUCCESSOR,
    DERIVEDFROM,
    NULL;


    public static ModuleMetadataResourceType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("documentation".equals(codeString)) {
            return DOCUMENTATION;
        }
        if ("justification".equals(codeString)) {
            return JUSTIFICATION;
        }
        if ("citation".equals(codeString)) {
            return CITATION;
        }
        if ("predecessor".equals(codeString)) {
            return PREDECESSOR;
        }
        if ("successor".equals(codeString)) {
            return SUCCESSOR;
        }
        if ("derived-from".equals(codeString)) {
            return DERIVEDFROM;
        }
        throw new FHIRException("Unknown ModuleMetadataResourceType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DOCUMENTATION: {
                return "documentation";
            }
            case JUSTIFICATION: {
                return "justification";
            }
            case CITATION: {
                return "citation";
            }
            case PREDECESSOR: {
                return "predecessor";
            }
            case SUCCESSOR: {
                return "successor";
            }
            case DERIVEDFROM: {
                return "derived-from";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/module-metadata-resource-type";
    }

    public String getDefinition() {
        switch (this) {
            case DOCUMENTATION: {
                return "Additional documentation for the module. This would include additional instructions on usage as well additional information on clinical context or appropriateness";
            }
            case JUSTIFICATION: {
                return "A summary of the justification for the artifact including supporting evidence, relevant guidelines, or other clinically important information. This information is intended to provide a way to make the justification for the module available to the consumer of interventions or results produced by the artifact";
            }
            case CITATION: {
                return "Bibliographic citation for papers, references, or other relevant material for the module. This is intended to allow for citation of related material, but that was not necessarily specifically prepared in connection with this module";
            }
            case PREDECESSOR: {
                return "The previous version of the module";
            }
            case SUCCESSOR: {
                return "The next version of the module";
            }
            case DERIVEDFROM: {
                return "The module is derived from the resource. This is intended to capture the relationship when a particular module is based on the content of another module, but is modified to capture either a different set of overall requirements, or a more specific set of requirements such as those involved in a particular institution or clinical setting";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DOCUMENTATION: {
                return "Documentation";
            }
            case JUSTIFICATION: {
                return "Justification";
            }
            case CITATION: {
                return "Citation";
            }
            case PREDECESSOR: {
                return "Predecessor";
            }
            case SUCCESSOR: {
                return "Successor";
            }
            case DERIVEDFROM: {
                return "Derived From";
            }
        }
        return "?";
    }
}

