/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NehtaNehtaUnstableStable {
    UNSTABLE,
    STABLE,
    NOTTESTED,
    NULL;


    public static NehtaNehtaUnstableStable fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("unstable".equals(codeString)) {
            return UNSTABLE;
        }
        if ("stable".equals(codeString)) {
            return STABLE;
        }
        if ("not_tested".equals(codeString)) {
            return NOTTESTED;
        }
        throw new FHIRException("Unknown NehtaNehtaUnstableStable code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case UNSTABLE: {
                return "unstable";
            }
            case STABLE: {
                return "stable";
            }
            case NOTTESTED: {
                return "not_tested";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/nehta-unstable-stable";
    }

    public String getDefinition() {
        switch (this) {
            case UNSTABLE: {
                return "Unstable";
            }
            case STABLE: {
                return "Stable";
            }
            case NOTTESTED: {
                return "Not tested";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case UNSTABLE: {
                return "Unstable";
            }
            case STABLE: {
                return "Stable";
            }
            case NOTTESTED: {
                return "Not tested";
            }
        }
        return "?";
    }
}

