/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum OccurrenceCodes {
    _1001,
    _1002,
    NULL;


    public static OccurrenceCodes fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("1001".equals(codeString)) {
            return _1001;
        }
        if ("1002".equals(codeString)) {
            return _1002;
        }
        throw new FHIRException("Unknown OccurrenceCodes code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _1001: {
                return "1001";
            }
            case _1002: {
                return "1002";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-claimoccurrance";
    }

    public String getDefinition() {
        switch (this) {
            case _1001: {
                return "Occurrance 1001 description.";
            }
            case _1002: {
                return "Occurrance 1002 description.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _1001: {
                return "Occurrance 1001";
            }
            case _1002: {
                return "Occurrance 1002";
            }
        }
        return "?";
    }
}

