/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.utils.IWorkerContext;
import org.hl7.fhir.dstu2016may.utils.ProfileUtilities;
import org.stringtemplate.v4.ST;

public class ShExGenerator {
    private static String SHEX_TEMPLATE = "$header$\n\n$shapeDefinitions$";
    private static String HEADER_TEMPLATE = "PREFIX fhir: <http://hl7.org/fhir/> \nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \nBASE <http://hl7.org/fhir/shape/>\n";
    private static String SHAPE_DEFINITION_TEMPLATE = "<$id$> {\n$resourceDecl$\t$elements$\n}\n";
    private static String RESOURCE_DECL_TEMPLATE = "\n\ta [fhir:$id$],\n\tfhir:nodeRole [fhir:treeRoot],\n";
    private static String ELEMENT_TEMPLATE = "fhir:$id$ $defn$$card$";
    private static String SIMPLE_ELEMENT_TEMPLATE = "@<$typ$>";
    private static String PRIMITIVE_ELEMENT_TEMPLATE = "xsd:$typ$";
    private static String ALTERNATIVE_TEMPLATE = "\n\t(\t$altEntries$\n\t)";
    private static String REFERENCE_TEMPLATE = "@<$ref$Reference>";
    private static String CHOICE_TEMPLATE = "\n(\t$choiceEntries$\n\t)$card$";
    private static String TYPED_REFERENCE_TEMPLATE = "\n<$refType$Reference> {\n\ta [fhir:$refType$Reference]?,\n\tfhir:uri.id @<id>?,\n\tfhir:uri.extension @<Extension>*,\n\tfhir:uri.value (xsd:anyURI OR @<$refType$>)\n}";
    private static String XML_DEFN_TYPE = "http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-type";
    private IWorkerContext context;
    private LinkedList<Pair<StructureDefinition, ElementDefinition>> typeReferences;
    private HashSet<String> references;

    public ShExGenerator(IWorkerContext context) {
        this.context = context;
        this.typeReferences = new LinkedList();
        this.references = new HashSet();
    }

    public String generate(HTMLLinkPolicy links, StructureDefinition structure) {
        ArrayList<StructureDefinition> list = new ArrayList<StructureDefinition>();
        list.add(structure);
        this.typeReferences.clear();
        this.references.clear();
        return this.generate(links, list);
    }

    private ST tmplt(String template) {
        return new ST(template, '$', '$');
    }

    public String generate(HTMLLinkPolicy links, List<StructureDefinition> structures) {
        ST shex_def = this.tmplt(SHEX_TEMPLATE);
        shex_def.add("header", (Object)this.genHeader());
        Collections.sort(structures, new SortById());
        StringBuilder shapeDefinitions = new StringBuilder();
        for (StructureDefinition sd : structures) {
            shapeDefinitions.append(this.genShapeDefinition(sd, true));
        }
        HashSet<String> seen = new HashSet<String>();
        while (!this.typeReferences.isEmpty()) {
            Pair<StructureDefinition, ElementDefinition> sded = this.typeReferences.poll();
            StructureDefinition sd = (StructureDefinition)sded.getLeft();
            ElementDefinition ed = (ElementDefinition)sded.getRight();
            if (seen.contains(ed.getPath())) break;
            seen.add(ed.getPath());
            shapeDefinitions.append("\n" + this.genElementReference(sd, ed));
        }
        for (String r : this.references) {
            shapeDefinitions.append("\n" + this.genReferenceEntry(r) + "\n");
        }
        shex_def.add("shapeDefinitions", (Object)shapeDefinitions);
        return shex_def.render();
    }

    private String genHeader() {
        return HEADER_TEMPLATE;
    }

    private String genShapeDefinition(StructureDefinition sd, boolean isResource) {
        ST resource_decl = this.tmplt(RESOURCE_DECL_TEMPLATE);
        ST struct_def = this.tmplt(SHAPE_DEFINITION_TEMPLATE);
        resource_decl.add("id", (Object)sd.getId());
        struct_def.add("resourceDecl", (Object)(isResource ? resource_decl.render() : ""));
        struct_def.add("id", (Object)sd.getId());
        ArrayList<String> elements = new ArrayList<String>();
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (StringUtils.countMatches((CharSequence)ed.getPath(), (CharSequence)".") != 1) continue;
            elements.add(this.genElementDefinition(sd, ed));
        }
        struct_def.add("elements", (Object)StringUtils.join(elements, (String)",\n\t"));
        return struct_def.render();
    }

    private String genElementDefinition(StructureDefinition sd, ElementDefinition ed) {
        String defn;
        String id;
        ST element_def = this.tmplt(ELEMENT_TEMPLATE);
        String string = id = ed.hasBase() ? ed.getBase().getPath() : ed.getPath();
        String card = "*".equals(ed.getMax()) ? (ed.getMin() == 0 ? "*" : "+") : "?";
        element_def.add("id", (Object)id);
        element_def.add("card", (Object)card);
        List<ElementDefinition> children = ProfileUtilities.getChildList(sd, ed);
        if (children.size() > 0) {
            this.typeReferences.add((Pair<StructureDefinition, ElementDefinition>)new ImmutablePair((Object)sd, (Object)ed));
            ST anon_link = this.tmplt(SIMPLE_ELEMENT_TEMPLATE);
            anon_link.add("typ", (Object)id);
            defn = anon_link.render();
        } else if (ed.getType().size() == 1) {
            defn = this.genTypeRef(ed.getType().get(0));
        } else {
            if (id.endsWith("[x]")) {
                return this.genChoiceTypes(ed, id, card);
            }
            defn = this.genAlternativeTypes(ed, id, card);
        }
        element_def.add("defn", (Object)defn);
        return element_def.render();
    }

    private String genTypeRef(ElementDefinition.TypeRefComponent typ) {
        ST single_entry = this.tmplt(SIMPLE_ELEMENT_TEMPLATE);
        if (typ.getProfile().size() > 0) {
            if (typ.getProfile().size() != 1) {
                throw new AssertionError((Object)"Can't handle multiple profiles");
            }
            single_entry.add("typ", (Object)this.getProfiledType(typ));
        } else {
            if (typ.getCode() == null) {
                ST primitive_entry = this.tmplt(PRIMITIVE_ELEMENT_TEMPLATE);
                primitive_entry.add("typ", (Object)"string");
                return primitive_entry.render();
            }
            single_entry.add("typ", (Object)typ.getCode());
        }
        return single_entry.render();
    }

    private String genAlternativeTypes(ElementDefinition ed, String id, String card) {
        ST shex_alt = this.tmplt(ALTERNATIVE_TEMPLATE);
        ArrayList<String> altEntries = new ArrayList<String>();
        shex_alt.add("id", (Object)id);
        for (ElementDefinition.TypeRefComponent typ : ed.getType()) {
            altEntries.add(this.genAltEntry(id, typ));
        }
        shex_alt.add("altEntries", (Object)StringUtils.join(altEntries, (String)" OR\n\t\t"));
        shex_alt.add("card", (Object)card);
        return shex_alt.render();
    }

    private String genReference(String id, ElementDefinition.TypeRefComponent typ) {
        String ref;
        ST shex_ref = this.tmplt(REFERENCE_TEMPLATE);
        if (typ.getProfile().size() > 0) {
            String[] els = ((String)typ.getProfile().get(0).getValue()).split("/");
            ref = els[els.length - 1];
        } else {
            ref = "";
        }
        shex_ref.add("id", (Object)id);
        shex_ref.add("ref", (Object)ref);
        this.references.add(ref);
        return shex_ref.render();
    }

    private String genAltEntry(String id, ElementDefinition.TypeRefComponent typ) {
        if (!typ.getCode().equals("Reference")) {
            throw new AssertionError((Object)("We do not handle " + typ.getCode() + " alternatives"));
        }
        return this.genReference(id, typ);
    }

    private String getProfiledType(ElementDefinition.TypeRefComponent typ) {
        return typ.getProfile().get(0).fhirType();
    }

    private String genChoiceTypes(ElementDefinition ed, String id, String card) {
        ST shex_choice = this.tmplt(CHOICE_TEMPLATE);
        ArrayList<String> choiceEntries = new ArrayList<String>();
        String base = id.replace("[x]", "");
        for (ElementDefinition.TypeRefComponent typ : ed.getType()) {
            choiceEntries.add(this.genChoiceEntry(base, typ));
        }
        shex_choice.add("choiceEntries", (Object)StringUtils.join(choiceEntries, (String)" |\n\t\t"));
        shex_choice.add("card", (Object)card);
        return shex_choice.render();
    }

    private String genChoiceEntry(String base, ElementDefinition.TypeRefComponent typ) {
        ST shex_choice_entry = this.tmplt(ELEMENT_TEMPLATE);
        String ext = typ.getCode();
        shex_choice_entry.add("id", (Object)(base + ext));
        shex_choice_entry.add("card", (Object)"");
        shex_choice_entry.add("defn", (Object)this.genTypeRef(typ));
        return shex_choice_entry.render();
    }

    private String genElementReference(StructureDefinition sd, ElementDefinition ed) {
        ST element_reference = this.tmplt(SHAPE_DEFINITION_TEMPLATE);
        element_reference.add("resourceDecl", (Object)"");
        element_reference.add("id", (Object)ed.getPath());
        ArrayList<String> elements = new ArrayList<String>();
        for (ElementDefinition child : ProfileUtilities.getChildList(sd, ed)) {
            elements.add(this.genElementDefinition(sd, child));
        }
        element_reference.add("elements", (Object)StringUtils.join(elements, (String)",\n\t"));
        return element_reference.render();
    }

    private String genReferenceEntry(String refType) {
        ST typed_ref = this.tmplt(TYPED_REFERENCE_TEMPLATE);
        typed_ref.add("refType", (Object)refType);
        return typed_ref.render();
    }

    public class SortById
    implements Comparator<StructureDefinition> {
        @Override
        public int compare(StructureDefinition arg0, StructureDefinition arg1) {
            return arg0.getId().compareTo(arg1.getId());
        }
    }

    public static enum HTMLLinkPolicy {
        NONE,
        EXTERNAL,
        INTERNAL;

    }
}

