/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.ConceptMap;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.ExpressionNode;
import org.hl7.fhir.dstu2016may.model.IdType;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceFactory;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.StructureMap;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.dstu2016may.utils.FHIRLexer;
import org.hl7.fhir.dstu2016may.utils.FHIRPathEngine;
import org.hl7.fhir.dstu2016may.utils.IWorkerContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

public class StructureMapUtilities {
    public static final String MAP_WHERE_CHECK = "map.where.check";
    public static final String MAP_WHERE_EXPRESSION = "map.where.expression";
    public static final String MAP_EXPRESSION = "map.transform.expression";
    private IWorkerContext worker;
    private FHIRPathEngine fpe;
    private Map<String, StructureMap> library;
    private ITransformerServices services;

    public StructureMapUtilities(IWorkerContext worker, Map<String, StructureMap> library, ITransformerServices services) {
        this.worker = worker;
        this.library = library;
        this.services = services;
        this.fpe = new FHIRPathEngine(worker);
    }

    public String render(StructureMap map) throws FHIRException {
        StringBuilder b = new StringBuilder();
        b.append("map \"");
        b.append(map.getUrl());
        b.append("\" = \"");
        b.append(Utilities.escapeJava((String)map.getName()));
        b.append("\"\r\n\r\n");
        this.renderUses(b, map);
        this.renderImports(b, map);
        for (StructureMap.StructureMapGroupComponent g : map.getGroup()) {
            this.renderGroup(b, g);
        }
        return b.toString();
    }

    private void renderUses(StringBuilder b, StructureMap map) {
        for (StructureMap.StructureMapStructureComponent s : map.getStructure()) {
            b.append("uses \"");
            b.append(s.getUrl());
            b.append("\" as ");
            b.append(s.getMode().toCode());
            b.append("\r\n");
            this.renderDoco(b, s.getDocumentation());
        }
        if (map.hasStructure()) {
            b.append("\r\n");
        }
    }

    private void renderImports(StringBuilder b, StructureMap map) {
        for (UriType s : map.getImport()) {
            b.append("imports \"");
            b.append((String)s.getValue());
            b.append("\"\r\n");
        }
        if (map.hasImport()) {
            b.append("\r\n");
        }
    }

    private void renderGroup(StringBuilder b, StructureMap.StructureMapGroupComponent g) throws FHIRException {
        b.append("group ");
        b.append(g.getName());
        if (g.hasExtends()) {
            b.append(" extends ");
            b.append(g.getExtends());
        }
        if (g.hasDocumentation()) {
            this.renderDoco(b, g.getDocumentation());
        }
        b.append("\r\n");
        for (StructureMap.StructureMapGroupInputComponent gi : g.getInput()) {
            b.append("  input ");
            b.append(gi.getName());
            if (gi.hasType()) {
                b.append(" : ");
                b.append(gi.getType());
            }
            b.append(" as ");
            b.append(gi.getMode().toCode());
            b.append(";\r\n");
        }
        if (g.hasInput()) {
            b.append("\r\n");
        }
        for (StructureMap.StructureMapGroupRuleComponent r : g.getRule()) {
            this.renderRule(b, r, 2);
        }
        b.append("\r\nendgroup\r\n");
    }

    private void renderRule(StringBuilder b, StructureMap.StructureMapGroupRuleComponent r, int indent) throws FHIRException {
        for (int i = 0; i < indent; ++i) {
            b.append(' ');
        }
        b.append(r.getName());
        b.append(": for ");
        boolean first = true;
        for (StructureMap.StructureMapGroupRuleSourceComponent rs : r.getSource()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            this.renderSource(b, rs);
        }
        if (r.getTarget().size() > 1) {
            b.append(" make ");
            first = true;
            for (StructureMap.StructureMapGroupRuleTargetComponent rt : r.getTarget()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append("\r\n");
                for (int i = 0; i < indent + 4; ++i) {
                    b.append(' ');
                }
                this.renderTarget(b, rt);
            }
        } else if (r.hasTarget()) {
            b.append(" make ");
            this.renderTarget(b, r.getTarget().get(0));
        }
        if (r.hasRule()) {
            b.append(" then {");
            this.renderDoco(b, r.getDocumentation());
            for (int i = 0; i < indent; ++i) {
                b.append(' ');
            }
            b.append("}\r\n");
        } else {
            if (r.hasDependent()) {
                first = true;
                for (StructureMap.StructureMapGroupRuleDependentComponent rd : r.getDependent()) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(", ");
                    }
                    b.append(rd.getName());
                    b.append("(");
                    boolean ifirst = true;
                    for (StringType rdp : rd.getVariable()) {
                        if (ifirst) {
                            ifirst = false;
                        } else {
                            b.append(", ");
                        }
                        b.append(rd.getVariable());
                    }
                }
            }
            this.renderDoco(b, r.getDocumentation());
            b.append("\r\n");
        }
    }

    private void renderSource(StringBuilder b, StructureMap.StructureMapGroupRuleSourceComponent rs) {
        if (!rs.getRequired()) {
            b.append("optional ");
        }
        b.append(rs.getContext());
        if (rs.hasElement()) {
            b.append('.');
            b.append(rs.getElement());
        }
        if (rs.hasListMode()) {
            b.append(" ");
            if (rs.getListMode() == StructureMap.StructureMapListMode.SHARE) {
                b.append("only_one");
            } else {
                b.append(rs.getListMode().toCode());
            }
        }
        if (rs.hasVariable()) {
            b.append(" as ");
            b.append(rs.getVariable());
        }
        if (rs.hasCondition()) {
            b.append(" where ");
            b.append(rs.getCondition());
        }
        if (rs.hasCheck()) {
            b.append(" check ");
            b.append(rs.getCheck());
        }
    }

    private void renderTarget(StringBuilder b, StructureMap.StructureMapGroupRuleTargetComponent rt) throws FHIRException {
        b.append(rt.getContext());
        if (rt.hasElement()) {
            b.append('.');
            b.append(rt.getElement());
        }
        if (rt.hasTransform()) {
            b.append(" = ");
            if (rt.getTransform() == StructureMap.StructureMapTransform.COPY && rt.getParameter().size() == 1) {
                this.renderTransformParam(b, rt.getParameter().get(0));
            } else if (rt.getTransform() == StructureMap.StructureMapTransform.EVALUATE && rt.getParameter().size() == 2) {
                b.append(rt.getTransform().toCode());
                b.append("(");
                b.append(((IdType)rt.getParameter().get(0).getValue()).asStringValue());
                b.append(((StringType)rt.getParameter().get(1).getValue()).asStringValue());
                b.append(")");
            } else {
                b.append(rt.getTransform().toCode());
                b.append("(");
                boolean first = true;
                for (StructureMap.StructureMapGroupRuleTargetParameterComponent rtp : rt.getParameter()) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(", ");
                    }
                    this.renderTransformParam(b, rtp);
                }
                b.append(")");
            }
        }
        if (rt.hasVariable()) {
            b.append(" as ");
            b.append(rt.getVariable());
        }
        for (Enumeration<StructureMap.StructureMapListMode> lm : rt.getListMode()) {
            b.append(" ");
            b.append(((StructureMap.StructureMapListMode)((Object)lm.getValue())).toCode());
            if (lm.getValue() != StructureMap.StructureMapListMode.SHARE) continue;
            b.append(" ");
            b.append(rt.getListRuleId());
        }
    }

    private void renderTransformParam(StringBuilder b, StructureMap.StructureMapGroupRuleTargetParameterComponent rtp) throws FHIRException {
        if (rtp.hasValueBooleanType()) {
            b.append(rtp.getValueBooleanType().asStringValue());
        } else if (rtp.hasValueDecimalType()) {
            b.append(rtp.getValueDecimalType().asStringValue());
        } else if (rtp.hasValueIdType()) {
            b.append(rtp.getValueIdType().asStringValue());
        } else if (rtp.hasValueDecimalType()) {
            b.append(rtp.getValueDecimalType().asStringValue());
        } else if (rtp.hasValueIntegerType()) {
            b.append(rtp.getValueIntegerType().asStringValue());
        } else {
            b.append(Utilities.escapeJava((String)rtp.getValueStringType().asStringValue()));
        }
    }

    private void renderDoco(StringBuilder b, String doco) {
        if (Utilities.noString((String)doco)) {
            return;
        }
        b.append(" // ");
        b.append(doco.replace("\r\n", " ").replace("\r", " ").replace("\n", " "));
    }

    public StructureMap parse(String text) throws FHIRException {
        FHIRLexer lexer = new FHIRLexer(text);
        if (lexer.done()) {
            throw lexer.error("Map Input cannot be empty");
        }
        lexer.skipComments();
        lexer.token("map");
        StructureMap result = new StructureMap();
        result.setUrl(lexer.readConstant("url"));
        result.setId(this.tail(result.getUrl()));
        lexer.token("=");
        result.setName(lexer.readConstant("name"));
        lexer.skipComments();
        while (lexer.hasToken("conceptmap")) {
            this.parseConceptMap(result, lexer);
        }
        while (lexer.hasToken("uses")) {
            this.parseUses(result, lexer);
        }
        while (lexer.hasToken("imports")) {
            this.parseImports(result, lexer);
        }
        this.parseGroup(result, lexer);
        while (!lexer.done()) {
            this.parseGroup(result, lexer);
        }
        return result;
    }

    private String tail(String url) {
        return url.substring(url.lastIndexOf("/") + 1);
    }

    private void parseConceptMap(StructureMap result, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        lexer.token("conceptmap");
        ConceptMap map = new ConceptMap();
        String id = lexer.readConstant("map id");
        if (!id.startsWith("#")) {
            lexer.error("Concept Map identifier must start with #");
        }
        map.setId(id.substring(1));
        result.getContained().add(map);
        lexer.token("{");
        lexer.skipComments();
        HashMap<String, String> prefixes = new HashMap<String, String>();
        while (lexer.hasToken("prefix")) {
            lexer.token("prefix");
            String n = lexer.take();
            lexer.token("=");
            String v = lexer.readConstant("prefix url");
            prefixes.put(n, v);
        }
        while (!lexer.hasToken("}")) {
            ConceptMap.SourceElementComponent e = map.addElement();
            e.setSystem(this.readPrefix(prefixes, lexer));
            lexer.token(":");
            e.setCode(lexer.take());
            ConceptMap.TargetElementComponent tgt = e.addTarget();
            tgt.setEquivalence(this.readEquivalence(lexer));
            if (tgt.getEquivalence() != Enumerations.ConceptMapEquivalence.UNMATCHED) {
                tgt.setSystem(this.readPrefix(prefixes, lexer));
                lexer.token(":");
                tgt.setCode(lexer.take());
            }
            if (!lexer.hasComment()) continue;
            tgt.setComments(lexer.take().substring(2).trim());
        }
        lexer.token("}");
    }

    private String readPrefix(Map<String, String> prefixes, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        String prefix = lexer.take();
        if (!prefixes.containsKey(prefix)) {
            throw lexer.error("Unknown prefix '" + prefix + "'");
        }
        return prefixes.get(prefix);
    }

    private Enumerations.ConceptMapEquivalence readEquivalence(FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        String token = lexer.take();
        if (token.equals("=")) {
            return Enumerations.ConceptMapEquivalence.EQUAL;
        }
        if (token.equals("==")) {
            return Enumerations.ConceptMapEquivalence.EQUIVALENT;
        }
        if (token.equals("!=")) {
            return Enumerations.ConceptMapEquivalence.DISJOINT;
        }
        if (token.equals("--")) {
            return Enumerations.ConceptMapEquivalence.UNMATCHED;
        }
        if (token.equals("<=")) {
            return Enumerations.ConceptMapEquivalence.WIDER;
        }
        if (token.equals("<-")) {
            return Enumerations.ConceptMapEquivalence.SUBSUMES;
        }
        if (token.equals(">=")) {
            return Enumerations.ConceptMapEquivalence.NARROWER;
        }
        if (token.equals(">-")) {
            return Enumerations.ConceptMapEquivalence.SPECIALIZES;
        }
        if (token.equals("~")) {
            return Enumerations.ConceptMapEquivalence.INEXACT;
        }
        throw lexer.error("Unknown equivalence token '" + token + "'");
    }

    private void parseUses(StructureMap result, FHIRLexer lexer) throws FHIRException {
        lexer.token("uses");
        StructureMap.StructureMapStructureComponent st = result.addStructure();
        st.setUrl(lexer.readConstant("url"));
        lexer.token("as");
        st.setMode(StructureMap.StructureMapModelMode.fromCode(lexer.take()));
        lexer.skipToken(";");
        if (lexer.hasComment()) {
            st.setDocumentation(lexer.take().substring(2).trim());
        }
        lexer.skipComments();
    }

    private void parseImports(StructureMap result, FHIRLexer lexer) throws FHIRException {
        lexer.token("imports");
        result.addImport(lexer.readConstant("url"));
        lexer.skipToken(";");
        if (lexer.hasComment()) {
            lexer.next();
        }
        lexer.skipComments();
    }

    private void parseGroup(StructureMap result, FHIRLexer lexer) throws FHIRException {
        lexer.token("group");
        StructureMap.StructureMapGroupComponent group = result.addGroup();
        group.setName(lexer.take());
        if (lexer.hasToken("extends")) {
            lexer.next();
            group.setExtends(lexer.take());
        }
        lexer.skipComments();
        while (lexer.hasToken("input")) {
            this.parseInput(group, lexer);
        }
        while (!lexer.hasToken("endgroup")) {
            if (lexer.done()) {
                throw lexer.error("premature termination expecting 'endgroup'");
            }
            this.parseRule(group.getRule(), lexer);
        }
        lexer.next();
        lexer.skipComments();
    }

    private void parseInput(StructureMap.StructureMapGroupComponent group, FHIRLexer lexer) throws FHIRException {
        lexer.token("input");
        StructureMap.StructureMapGroupInputComponent input = group.addInput();
        input.setName(lexer.take());
        if (lexer.hasToken(":")) {
            lexer.token(":");
            input.setType(lexer.take());
        }
        lexer.token("as");
        input.setMode(StructureMap.StructureMapInputMode.fromCode(lexer.take()));
        if (lexer.hasComment()) {
            input.setDocumentation(lexer.take().substring(2).trim());
        }
        lexer.skipToken(";");
        lexer.skipComments();
    }

    private void parseRule(List<StructureMap.StructureMapGroupRuleComponent> list, FHIRLexer lexer) throws FHIRException {
        StructureMap.StructureMapGroupRuleComponent rule = new StructureMap.StructureMapGroupRuleComponent();
        list.add(rule);
        rule.setName(lexer.takeDottedToken());
        lexer.token(":");
        lexer.token("for");
        boolean done = false;
        while (!done) {
            this.parseSource(rule, lexer);
            done = !lexer.hasToken(",");
            if (done) continue;
            lexer.next();
        }
        if (lexer.hasToken("make")) {
            lexer.token("make");
            done = false;
            while (!done) {
                this.parseTarget(rule, lexer);
                done = !lexer.hasToken(",");
                if (done) continue;
                lexer.next();
            }
        }
        if (lexer.hasToken("then")) {
            lexer.token("then");
            if (lexer.hasToken("{")) {
                lexer.token("{");
                if (lexer.hasComment()) {
                    rule.setDocumentation(lexer.take().substring(2).trim());
                }
                lexer.skipComments();
                while (!lexer.hasToken("}")) {
                    if (lexer.done()) {
                        throw lexer.error("premature termination expecting '}' in nested group");
                    }
                    this.parseRule(rule.getRule(), lexer);
                }
                lexer.token("}");
            } else {
                done = false;
                while (!done) {
                    this.parseRuleReference(rule, lexer);
                    done = !lexer.hasToken(",");
                    if (done) continue;
                    lexer.next();
                }
            }
        } else if (lexer.hasComment()) {
            rule.setDocumentation(lexer.take().substring(2).trim());
        }
        lexer.skipComments();
    }

    private void parseRuleReference(StructureMap.StructureMapGroupRuleComponent rule, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        StructureMap.StructureMapGroupRuleDependentComponent ref = rule.addDependent();
        ref.setName(lexer.take());
        lexer.token("(");
        boolean done = false;
        while (!done) {
            ref.addVariable(lexer.take());
            done = !lexer.hasToken(",");
            if (done) continue;
            lexer.next();
        }
        lexer.token(")");
    }

    private void parseSource(StructureMap.StructureMapGroupRuleComponent rule, FHIRLexer lexer) throws FHIRException {
        ExpressionNode node;
        StructureMap.StructureMapGroupRuleSourceComponent source = rule.addSource();
        if (lexer.hasToken("optional")) {
            lexer.next();
        } else {
            source.setRequired(true);
        }
        source.setContext(lexer.take());
        if (lexer.hasToken(".")) {
            lexer.token(".");
            source.setElement(lexer.take());
        }
        if (Utilities.existsInList((String)lexer.getCurrent(), (String[])new String[]{"first", "last", "only_one"})) {
            if (lexer.getCurrent().equals("only_one")) {
                source.setListMode(StructureMap.StructureMapListMode.SHARE);
                lexer.take();
            } else {
                source.setListMode(StructureMap.StructureMapListMode.fromCode(lexer.take()));
            }
        }
        if (lexer.hasToken("as")) {
            lexer.take();
            source.setVariable(lexer.take());
        }
        if (lexer.hasToken("where")) {
            lexer.take();
            node = this.fpe.parse(lexer);
            source.setUserData(MAP_WHERE_EXPRESSION, node);
            source.setCondition(node.toString());
        }
        if (lexer.hasToken("check")) {
            lexer.take();
            node = this.fpe.parse(lexer);
            source.setUserData(MAP_WHERE_CHECK, node);
            source.setCheck(node.toString());
        }
    }

    private void parseTarget(StructureMap.StructureMapGroupRuleComponent rule, FHIRLexer lexer) throws FHIRException {
        StructureMap.StructureMapGroupRuleTargetComponent target = rule.addTarget();
        target.setContext(lexer.take());
        if (lexer.hasToken(".")) {
            lexer.token(".");
            target.setElement(lexer.take());
        }
        if (lexer.hasToken("=")) {
            lexer.token("=");
            boolean isConstant = lexer.isConstant(true);
            String name = lexer.take();
            if (lexer.hasToken("(")) {
                target.setTransform(StructureMap.StructureMapTransform.fromCode(name));
                lexer.token("(");
                if (target.getTransform() == StructureMap.StructureMapTransform.EVALUATE) {
                    this.parseParameter(target, lexer);
                    lexer.token(",");
                    ExpressionNode node = this.fpe.parse(lexer);
                    target.setUserData(MAP_EXPRESSION, node);
                    target.addParameter().setValue(new StringType(node.toString()));
                } else {
                    while (!lexer.hasToken(")")) {
                        this.parseParameter(target, lexer);
                        if (lexer.hasToken(")")) continue;
                        lexer.token(",");
                    }
                }
                lexer.token(")");
            } else {
                target.setTransform(StructureMap.StructureMapTransform.COPY);
                if (!isConstant) {
                    String id = name;
                    while (lexer.hasToken(".")) {
                        id = id + lexer.take() + lexer.take();
                    }
                    target.addParameter().setValue(new IdType(id));
                } else {
                    target.addParameter().setValue(this.readConstant(name, lexer));
                }
            }
        }
        if (lexer.hasToken("as")) {
            lexer.take();
            target.setVariable(lexer.take());
        }
        while (Utilities.existsInList((String)lexer.getCurrent(), (String[])new String[]{"first", "last", "share", "only_one"})) {
            if (lexer.getCurrent().equals("share")) {
                target.addListMode(StructureMap.StructureMapListMode.SHARE);
                lexer.next();
                target.setListRuleId(lexer.take());
            } else if (lexer.getCurrent().equals("first")) {
                target.addListMode(StructureMap.StructureMapListMode.FIRST);
            } else {
                target.addListMode(StructureMap.StructureMapListMode.LAST);
            }
            lexer.next();
        }
    }

    private void parseParameter(StructureMap.StructureMapGroupRuleTargetComponent target, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        if (!lexer.isConstant(true)) {
            target.addParameter().setValue(new IdType(lexer.take()));
        } else if (lexer.isStringConstant()) {
            target.addParameter().setValue(new StringType(lexer.readConstant("??")));
        } else {
            target.addParameter().setValue(this.readConstant(lexer.take(), lexer));
        }
    }

    private Type readConstant(String s, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        if (Utilities.isInteger((String)s)) {
            return new IntegerType(s);
        }
        if (Utilities.isDecimal((String)s, (boolean)false)) {
            return new DecimalType(s);
        }
        if (Utilities.existsInList((String)s, (String[])new String[]{"true", "false"})) {
            return new BooleanType(s.equals("true"));
        }
        return new StringType(lexer.processConstant(s));
    }

    private void log(String cnt) {
        System.out.println(cnt);
    }

    protected void getChildrenByName(Base item, String name, List<Base> result) throws FHIRException {
        for (Base v : item.listChildrenByName(name, true)) {
            if (v == null) continue;
            result.add(v);
        }
    }

    public Base transform(Base source, StructureMap map) {
        return null;
    }

    public void transform(Object appInfo, Base source, StructureMap map, Base target) throws Exception {
        TransformContext context = new TransformContext(appInfo);
        Variables vars = new Variables();
        vars.add(VariableMode.INPUT, "src", source);
        vars.add(VariableMode.OUTPUT, "tgt", target);
        this.executeGroup("", context, map, vars, map.getGroup().get(0));
    }

    private void executeGroup(String indent, TransformContext context, StructureMap map, Variables vars, StructureMap.StructureMapGroupComponent group) throws Exception {
        this.log(indent + "Group : " + group.getName());
        for (StructureMap.StructureMapGroupRuleComponent r : group.getRule()) {
            this.executeRule(indent + "  ", context, map, vars, group, r);
        }
    }

    private void executeRule(String indent, TransformContext context, StructureMap map, Variables vars, StructureMap.StructureMapGroupComponent group, StructureMap.StructureMapGroupRuleComponent rule) throws Exception {
        this.log(indent + "rule : " + rule.getName());
        Variables srcVars = vars.copy();
        if (rule.getSource().size() != 1) {
            throw new Exception("not handled yet");
        }
        List<Variables> source = this.analyseSource(context, srcVars, rule.getSource().get(0));
        if (source != null) {
            for (Variables v : source) {
                for (StructureMap.StructureMapGroupRuleTargetComponent t : rule.getTarget()) {
                    this.processTarget(context, v, map, t);
                }
                if (rule.hasRule()) {
                    for (StructureMap.StructureMapGroupRuleComponent childrule : rule.getRule()) {
                        this.executeRule(indent + "  ", context, map, v, group, childrule);
                    }
                    continue;
                }
                if (!rule.hasDependent()) continue;
                for (StructureMap.StructureMapGroupRuleDependentComponent dependent : rule.getDependent()) {
                    this.executeDependency(indent + "  ", context, map, v, group, dependent);
                }
            }
        }
    }

    private void executeDependency(String indent, TransformContext context, StructureMap map, Variables vin, StructureMap.StructureMapGroupComponent group, StructureMap.StructureMapGroupRuleDependentComponent dependent) throws Exception {
        StructureMap targetMap = null;
        StructureMap.StructureMapGroupComponent target = null;
        for (StructureMap.StructureMapGroupComponent grp : map.getGroup()) {
            if (!grp.getName().equals(dependent.getName())) continue;
            if (targetMap == null) {
                targetMap = map;
                target = grp;
                continue;
            }
            throw new FHIRException("Multiple possible matches for rule '" + dependent.getName() + "'");
        }
        for (UriType imp : map.getImport()) {
            StructureMap impMap = this.library.get(imp.getValue());
            if (impMap == null) {
                throw new FHIRException("Unable to find map " + (String)imp.getValue() + " (Known Maps = " + Utilities.listCanonicalUrls(this.library.keySet()) + ")");
            }
            for (StructureMap.StructureMapGroupComponent grp : impMap.getGroup()) {
                if (!grp.getName().equals(dependent.getName())) continue;
                if (targetMap == null) {
                    targetMap = impMap;
                    target = grp;
                    continue;
                }
                throw new FHIRException("Multiple possible matches for rule '" + dependent.getName() + "'");
            }
        }
        if (target == null) {
            throw new FHIRException("No matches found for rule '" + dependent.getName() + "'");
        }
        if (target.getInput().size() != dependent.getVariable().size()) {
            throw new FHIRException("Rule '" + dependent.getName() + "' has " + Integer.toString(target.getInput().size()) + " but the invocation has " + Integer.toString(dependent.getVariable().size()) + " variables");
        }
        Variables v = new Variables();
        for (int i = 0; i < target.getInput().size(); ++i) {
            StructureMap.StructureMapGroupInputComponent input = target.getInput().get(i);
            StringType var = dependent.getVariable().get(i);
            VariableMode mode = input.getMode() == StructureMap.StructureMapInputMode.SOURCE ? VariableMode.INPUT : VariableMode.OUTPUT;
            Base vv = vin.get(mode, (String)var.getValue());
            if (vv == null) {
                throw new FHIRException("Rule '" + dependent.getName() + "' " + mode.toString() + " variable '" + input.getName() + "' has no value");
            }
            v.add(mode, input.getName(), vv);
        }
        this.executeGroup(indent + "  ", context, targetMap, v, target);
    }

    private List<Variables> analyseSource(TransformContext context, Variables vars, StructureMap.StructureMapGroupRuleSourceComponent src) throws Exception {
        ExpressionNode expr;
        Base b = vars.get(VariableMode.INPUT, src.getContext());
        if (b == null) {
            throw new FHIRException("Unknown input variable " + src.getContext());
        }
        if (src.hasCondition()) {
            expr = (ExpressionNode)src.getUserData(MAP_WHERE_EXPRESSION);
            if (expr == null) {
                expr = this.fpe.parse(src.getCondition());
                src.setUserData(MAP_WHERE_EXPRESSION, expr);
            }
            if (!this.fpe.evaluateToBoolean(null, b, expr)) {
                return null;
            }
        }
        if (src.hasCheck()) {
            expr = (ExpressionNode)src.getUserData(MAP_WHERE_CHECK);
            if (expr == null) {
                expr = this.fpe.parse(src.getCondition());
                src.setUserData(MAP_WHERE_CHECK, expr);
            }
            if (!this.fpe.evaluateToBoolean(null, b, expr)) {
                throw new Exception("Check condition failed");
            }
        }
        ArrayList<Base> items = new ArrayList<Base>();
        if (!src.hasElement()) {
            items.add(b);
        } else {
            this.getChildrenByName(b, src.getElement(), items);
        }
        ArrayList<Variables> result = new ArrayList<Variables>();
        for (Base r : items) {
            Variables v = vars.copy();
            if (src.hasVariable()) {
                v.add(VariableMode.INPUT, src.getVariable(), r);
            }
            result.add(v);
        }
        return result;
    }

    private void processTarget(TransformContext context, Variables vars, StructureMap map, StructureMap.StructureMapGroupRuleTargetComponent tgt) throws Exception {
        Base dest = vars.get(VariableMode.OUTPUT, tgt.getContext());
        if (dest == null) {
            throw new Exception("target context not known: " + tgt.getContext());
        }
        if (!tgt.hasElement()) {
            throw new Exception("Not supported yet");
        }
        Base v = null;
        if (tgt.hasTransform()) {
            v = this.runTransform(context, map, tgt, vars);
            if (v != null) {
                dest.setProperty(tgt.getElement().hashCode(), tgt.getElement(), v);
            }
        } else {
            v = dest.makeProperty(tgt.getElement().hashCode(), tgt.getElement());
        }
        if (tgt.hasVariable() && v != null) {
            vars.add(VariableMode.OUTPUT, tgt.getVariable(), v);
        }
    }

    private Base runTransform(TransformContext context, StructureMap map, StructureMap.StructureMapGroupRuleTargetComponent tgt, Variables vars) throws FHIRException {
        switch (tgt.getTransform()) {
            case CREATE: {
                return ResourceFactory.createResourceOrType(this.getParamString(vars, tgt.getParameter().get(0)));
            }
            case COPY: {
                return this.getParam(vars, tgt.getParameter().get(0));
            }
            case EVALUATE: {
                List<Base> v;
                ExpressionNode expr = (ExpressionNode)tgt.getUserData(MAP_EXPRESSION);
                if (expr == null) {
                    expr = this.fpe.parse(this.getParamString(vars, tgt.getParameter().get(1)));
                    tgt.setUserData(MAP_WHERE_EXPRESSION, expr);
                }
                if ((v = this.fpe.evaluate(null, null, this.getParam(vars, tgt.getParameter().get(0)), expr)).size() != 1) {
                    throw new FHIRException("evaluation of " + expr.toString() + " returned " + Integer.toString(v.size()) + " objects");
                }
                return v.get(0);
            }
            case TRUNCATE: {
                String src = this.getParamString(vars, tgt.getParameter().get(0));
                String len = this.getParamString(vars, tgt.getParameter().get(1));
                if (Utilities.isInteger((String)len)) {
                    int l = Integer.parseInt(len);
                    if (src.length() > l) {
                        src = src.substring(0, l);
                    }
                }
                return new StringType(src);
            }
            case ESCAPE: {
                throw new Error("Transform " + tgt.getTransform().toCode() + " not supported yet");
            }
            case CAST: {
                throw new Error("Transform " + tgt.getTransform().toCode() + " not supported yet");
            }
            case APPEND: {
                throw new Error("Transform " + tgt.getTransform().toCode() + " not supported yet");
            }
            case TRANSLATE: {
                return this.translate(context, map, vars, tgt.getParameter());
            }
            case REFERENCE: {
                throw new Error("Transform " + tgt.getTransform().toCode() + " not supported yet");
            }
            case DATEOP: {
                throw new Error("Transform " + tgt.getTransform().toCode() + " not supported yet");
            }
            case UUID: {
                return new IdType(UUID.randomUUID().toString());
            }
            case POINTER: {
                Base b = this.getParam(vars, tgt.getParameter().get(0));
                if (b instanceof Resource) {
                    return new UriType("urn:uuid:" + ((Resource)b).getId());
                }
                throw new FHIRException("Transform engine cannot point at an element of type " + b.fhirType());
            }
        }
        throw new Error("Transform Unknown: " + tgt.getTransform().toCode());
    }

    private String getParamString(Variables vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter) {
        Base b = this.getParam(vars, parameter);
        if (b == null || !b.hasPrimitiveValue()) {
            return null;
        }
        return b.primitiveValue();
    }

    private Base getParam(Variables vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter) {
        Type p = parameter.getValue();
        if (!(p instanceof IdType)) {
            return p;
        }
        Base b = vars.get(VariableMode.INPUT, ((IdType)p).asStringValue());
        if (b == null) {
            b = vars.get(VariableMode.OUTPUT, ((IdType)p).asStringValue());
        }
        return b;
    }

    private Base translate(TransformContext context, StructureMap map, Variables vars, List<StructureMap.StructureMapGroupRuleTargetParameterComponent> parameter) throws FHIRException {
        Base src = this.getParam(vars, parameter.get(0));
        String id = this.getParamString(vars, parameter.get(1));
        String fld = this.getParamString(vars, parameter.get(2));
        return this.translate(context, map, src, id, fld);
    }

    public Base translate(TransformContext context, StructureMap map, Base source, String conceptMapUrl, String fieldToReturn) throws FHIRException {
        Base[] b;
        Coding src = new Coding();
        if (source.isPrimitive()) {
            src.setCode(source.primitiveValue());
        } else if ("Coding".equals(source.fhirType())) {
            b = source.getProperty("system".hashCode(), "system", true);
            if (b.length == 1) {
                src.setSystem(b[0].primitiveValue());
            }
            if ((b = source.getProperty("code".hashCode(), "code", true)).length == 1) {
                src.setCode(b[0].primitiveValue());
            }
        } else if ("CE".equals(source.fhirType())) {
            b = source.getProperty("codeSystem".hashCode(), "codeSystem", true);
            if (b.length == 1) {
                src.setSystem(b[0].primitiveValue());
            }
            if ((b = source.getProperty("code".hashCode(), "code", true)).length == 1) {
                src.setCode(b[0].primitiveValue());
            }
        } else {
            throw new FHIRException("Unable to translate source " + source.fhirType());
        }
        if (conceptMapUrl.equals("http://hl7.org/fhir/ConceptMap/special-oid2uri")) {
            String uri = this.worker.oid2Uri(src.getCode());
            if (uri == null) {
                uri = "urn:oid:" + src.getCode();
            }
            if ("uri".equals(fieldToReturn)) {
                return new UriType(uri);
            }
            throw new FHIRException("Error in return code");
        }
        ConceptMap cmap = null;
        if (conceptMapUrl.startsWith("#")) {
            for (Resource r : map.getContained()) {
                if (!(r instanceof ConceptMap) || !((ConceptMap)r).getId().equals(conceptMapUrl.substring(1))) continue;
                cmap = (ConceptMap)r;
            }
        } else {
            cmap = this.worker.fetchResource(ConceptMap.class, conceptMapUrl);
        }
        Coding outcome = null;
        boolean done = false;
        String message = null;
        if (cmap == null) {
            if (this.services == null) {
                message = "No map found for " + conceptMapUrl;
            } else {
                outcome = this.services.translate(context.appInfo, src, conceptMapUrl);
                done = true;
            }
        } else {
            ArrayList<ConceptMap.SourceElementComponent> list = new ArrayList<ConceptMap.SourceElementComponent>();
            for (ConceptMap.SourceElementComponent e : cmap.getElement()) {
                if (!src.hasSystem() && src.getCode().equals(e.getCode())) {
                    list.add(e);
                    continue;
                }
                if (!src.hasSystem() || !src.getSystem().equals(e.getSystem()) || !src.getCode().equals(e.getCode())) continue;
                list.add(e);
            }
            if (list.size() == 0) {
                done = true;
            } else if (((ConceptMap.SourceElementComponent)list.get(0)).getTarget().size() == 0) {
                message = "Concept map " + conceptMapUrl + " found no translation for " + src.getCode();
            } else {
                for (ConceptMap.TargetElementComponent tgt : ((ConceptMap.SourceElementComponent)list.get(0)).getTarget()) {
                    if (tgt.getEquivalence() == Enumerations.ConceptMapEquivalence.EQUAL || tgt.getEquivalence() == Enumerations.ConceptMapEquivalence.EQUIVALENT || tgt.getEquivalence() == Enumerations.ConceptMapEquivalence.WIDER) {
                        if (done) {
                            message = "Concept map " + conceptMapUrl + " found multiple matches for " + src.getCode();
                            done = false;
                            continue;
                        }
                        done = true;
                        outcome = new Coding().setCode(tgt.getCode()).setSystem(tgt.getSystem());
                        continue;
                    }
                    if (tgt.getEquivalence() != Enumerations.ConceptMapEquivalence.UNMATCHED) continue;
                    done = true;
                }
                if (!done) {
                    message = "Concept map " + conceptMapUrl + " found no usable translation for " + src.getCode();
                }
            }
        }
        if (!done) {
            throw new FHIRException(message);
        }
        if (outcome == null) {
            return null;
        }
        if ("code".equals(fieldToReturn)) {
            return new CodeType(outcome.getCode());
        }
        return outcome;
    }

    public Map<String, StructureMap> getLibrary() {
        return this.library;
    }

    public class TransformContext {
        private Object appInfo;

        public TransformContext(Object appInfo) {
            this.appInfo = appInfo;
        }

        public Object getAppInfo() {
            return this.appInfo;
        }
    }

    public class Variables {
        private List<Variable> list = new ArrayList<Variable>();

        public void add(VariableMode mode, String name, Base object) {
            Variable vv = null;
            for (Variable v : this.list) {
                if (v.mode != mode || !v.getName().equals(name)) continue;
                vv = v;
            }
            if (vv != null) {
                this.list.remove(vv);
            }
            this.list.add(new Variable(mode, name, object));
        }

        public Variables copy() {
            Variables result = new Variables();
            result.list.addAll(this.list);
            return result;
        }

        public Base get(VariableMode mode, String name) {
            for (Variable v : this.list) {
                if (v.mode != mode || !v.getName().equals(name)) continue;
                return v.getObject();
            }
            return null;
        }
    }

    public class Variable {
        private VariableMode mode;
        private String name;
        private Base object;

        public Variable(VariableMode mode, String name, Base object) {
            this.mode = mode;
            this.name = name;
            this.object = object;
        }

        public VariableMode getMode() {
            return this.mode;
        }

        public String getName() {
            return this.name;
        }

        public Base getObject() {
            return this.object;
        }
    }

    public static enum VariableMode {
        INPUT,
        OUTPUT;

    }

    public static interface ITransformerServices {
        public Coding translate(Object var1, Coding var2, String var3) throws FHIRException;
    }
}

