/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.utils.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.JsonParser;
import org.hl7.fhir.dstu2016may.formats.ParserBase;
import org.hl7.fhir.dstu2016may.formats.XmlParser;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.utils.ResourceUtilities;
import org.hl7.fhir.dstu2016may.utils.client.EFhirClientException;
import org.hl7.fhir.dstu2016may.utils.client.ResourceAddress;
import org.hl7.fhir.dstu2016may.utils.client.ResourceFormat;
import org.hl7.fhir.dstu2016may.utils.client.ResourceRequest;

public class ClientUtils {
    public static String DEFAULT_CHARSET = "UTF-8";
    public static final String HEADER_LOCATION = "location";

    public static <T extends Resource> ResourceRequest<T> issueOptionsRequest(URI optionsUri, String resourceFormat, HttpHost proxy) {
        HttpOptions options = new HttpOptions(optionsUri);
        return ClientUtils.issueResourceRequest(resourceFormat, (HttpUriRequest)options, proxy);
    }

    public static <T extends Resource> ResourceRequest<T> issueGetResourceRequest(URI resourceUri, String resourceFormat, HttpHost proxy) {
        HttpGet httpget = new HttpGet(resourceUri);
        return ClientUtils.issueResourceRequest(resourceFormat, (HttpUriRequest)httpget, proxy);
    }

    public static <T extends Resource> ResourceRequest<T> issuePutRequest(URI resourceUri, byte[] payload, String resourceFormat, List<Header> headers, HttpHost proxy) {
        HttpPut httpPut = new HttpPut(resourceUri);
        return ClientUtils.issueResourceRequest(resourceFormat, (HttpUriRequest)httpPut, payload, headers, proxy);
    }

    public static <T extends Resource> ResourceRequest<T> issuePutRequest(URI resourceUri, byte[] payload, String resourceFormat, HttpHost proxy) {
        HttpPut httpPut = new HttpPut(resourceUri);
        return ClientUtils.issueResourceRequest(resourceFormat, (HttpUriRequest)httpPut, payload, null, proxy);
    }

    public static <T extends Resource> ResourceRequest<T> issuePostRequest(URI resourceUri, byte[] payload, String resourceFormat, List<Header> headers, HttpHost proxy) {
        HttpPost httpPost = new HttpPost(resourceUri);
        return ClientUtils.issueResourceRequest(resourceFormat, (HttpUriRequest)httpPost, payload, headers, proxy);
    }

    public static <T extends Resource> ResourceRequest<T> issuePostRequest(URI resourceUri, byte[] payload, String resourceFormat, HttpHost proxy) {
        return ClientUtils.issuePostRequest(resourceUri, payload, resourceFormat, null, proxy);
    }

    public static Bundle issueGetFeedRequest(URI resourceUri, String resourceFormat, HttpHost proxy) {
        HttpGet httpget = new HttpGet(resourceUri);
        ClientUtils.configureFhirRequest((HttpRequest)httpget, resourceFormat);
        HttpResponse response = ClientUtils.sendRequest((HttpUriRequest)httpget, proxy);
        return (Bundle)ClientUtils.unmarshalReference(response, resourceFormat);
    }

    public static Bundle postBatchRequest(URI resourceUri, byte[] payload, String resourceFormat, HttpHost proxy) {
        HttpPost httpPost = new HttpPost(resourceUri);
        ClientUtils.configureFhirRequest((HttpRequest)httpPost, resourceFormat);
        HttpResponse response = ClientUtils.sendPayload((HttpEntityEnclosingRequestBase)httpPost, payload, proxy);
        return ClientUtils.unmarshalFeed(response, resourceFormat);
    }

    public static boolean issueDeleteRequest(URI resourceUri, HttpHost proxy) {
        HttpDelete deleteRequest = new HttpDelete(resourceUri);
        HttpResponse response = ClientUtils.sendRequest((HttpUriRequest)deleteRequest, proxy);
        int responseStatusCode = response.getStatusLine().getStatusCode();
        boolean deletionSuccessful = false;
        if (responseStatusCode == 204) {
            deletionSuccessful = true;
        }
        return deletionSuccessful;
    }

    protected static <T extends Resource> ResourceRequest<T> issueResourceRequest(String resourceFormat, HttpUriRequest request, HttpHost proxy) {
        return ClientUtils.issueResourceRequest(resourceFormat, request, null, proxy);
    }

    protected static <T extends Resource> ResourceRequest<T> issueResourceRequest(String resourceFormat, HttpUriRequest request, byte[] payload, HttpHost proxy) {
        return ClientUtils.issueResourceRequest(resourceFormat, request, payload, null, proxy);
    }

    protected static <T extends Resource> ResourceRequest<T> issueResourceRequest(String resourceFormat, HttpUriRequest request, byte[] payload, List<Header> headers, HttpHost proxy) {
        ClientUtils.configureFhirRequest((HttpRequest)request, resourceFormat, headers);
        HttpResponse response = null;
        if (request instanceof HttpEntityEnclosingRequest && payload != null) {
            response = ClientUtils.sendPayload((HttpEntityEnclosingRequestBase)request, payload, proxy);
        } else {
            if (request instanceof HttpEntityEnclosingRequest && payload == null) {
                throw new EFhirClientException("PUT and POST requests require a non-null payload");
            }
            response = ClientUtils.sendRequest(request, proxy);
        }
        T resource = ClientUtils.unmarshalReference(response, resourceFormat);
        return new ResourceRequest<T>(resource, response.getStatusLine().getStatusCode(), ClientUtils.getLocationHeader(response));
    }

    protected static void configureFhirRequest(HttpRequest request, String format) {
        ClientUtils.configureFhirRequest(request, format, null);
    }

    protected static void configureFhirRequest(HttpRequest request, String format, List<Header> headers) {
        request.addHeader("User-Agent", "Java FHIR Client for FHIR");
        if (format != null) {
            request.addHeader("Accept", format);
            request.addHeader("Content-Type", format + ";charset=" + DEFAULT_CHARSET);
        }
        request.addHeader("Accept-Charset", DEFAULT_CHARSET);
        if (headers != null) {
            for (Header header : headers) {
                request.addHeader(header);
            }
        }
    }

    protected static HttpResponse sendPayload(HttpEntityEnclosingRequestBase request, byte[] payload, HttpHost proxy) {
        HttpResponse response = null;
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            if (proxy != null) {
                httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
            request.setEntity((HttpEntity)new ByteArrayEntity(payload));
            response = httpclient.execute((HttpUriRequest)request);
        }
        catch (IOException ioe) {
            throw new EFhirClientException("Error sending HTTP Post/Put Payload", ioe);
        }
        return response;
    }

    protected static HttpResponse sendRequest(HttpUriRequest request, HttpHost proxy) {
        HttpResponse response = null;
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpParams params = httpclient.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)5000);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)5000);
            if (proxy != null) {
                httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
            response = httpclient.execute(request);
        }
        catch (IOException ioe) {
            throw new EFhirClientException("Error sending Http Request", ioe);
        }
        return response;
    }

    protected static <T extends Resource> T unmarshalReference(HttpResponse response, String format) {
        Resource resource = null;
        OperationOutcome error = null;
        InputStream instream = null;
        HttpEntity entity = response.getEntity();
        if (entity != null && entity.getContentLength() != 0L) {
            try {
                instream = entity.getContent();
                resource = ClientUtils.getParser(format).parse(instream);
                if (resource instanceof OperationOutcome && ClientUtils.hasError((OperationOutcome)resource)) {
                    error = (OperationOutcome)resource;
                }
            }
            catch (IOException ioe) {
                throw new EFhirClientException("Error unmarshalling entity from Http Response", ioe);
            }
            catch (Exception e) {
                throw new EFhirClientException("Error parsing response message", e);
            }
            finally {
                try {
                    instream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (error != null) {
            throw new EFhirClientException("Error unmarshalling resource: " + ResourceUtilities.getErrorDescription(error), error);
        }
        return (T)resource;
    }

    protected static Bundle unmarshalFeed(HttpResponse response, String format) {
        Bundle feed = null;
        InputStream instream = null;
        HttpEntity entity = response.getEntity();
        String contentType = response.getHeaders("Content-Type")[0].getValue();
        OperationOutcome error = null;
        try {
            if (entity != null) {
                instream = entity.getContent();
                if (contentType.contains(ResourceFormat.RESOURCE_XML.getHeader()) || contentType.contains("text/xml+fhir")) {
                    Resource rf = ClientUtils.getParser(format).parse(instream);
                    if (rf instanceof Bundle) {
                        feed = (Bundle)rf;
                    } else if (rf instanceof OperationOutcome && ClientUtils.hasError((OperationOutcome)rf)) {
                        error = (OperationOutcome)rf;
                    } else {
                        throw new EFhirClientException("Error unmarshalling feed from Http Response: a resource was returned instead");
                    }
                }
                instream.close();
            }
        }
        catch (IOException ioe) {
            throw new EFhirClientException("Error unmarshalling feed from Http Response", ioe);
        }
        catch (Exception e) {
            throw new EFhirClientException("Error parsing response message", e);
        }
        finally {
            try {
                instream.close();
            }
            catch (IOException iOException) {}
        }
        if (error != null) {
            throw new EFhirClientException("Error unmarshalling feed: " + ResourceUtilities.getErrorDescription(error), error);
        }
        return feed;
    }

    private static boolean hasError(OperationOutcome oo) {
        for (OperationOutcome.OperationOutcomeIssueComponent t : oo.getIssue()) {
            if (t.getSeverity() != OperationOutcome.IssueSeverity.ERROR && t.getSeverity() != OperationOutcome.IssueSeverity.FATAL) continue;
            return true;
        }
        return false;
    }

    protected static String getLocationHeader(HttpResponse response) {
        String location = null;
        if (response.getHeaders(HEADER_LOCATION).length > 0) {
            location = response.getHeaders(HEADER_LOCATION)[0].getValue();
        } else if (response.getHeaders("content-location").length > 0) {
            location = response.getHeaders("content-location")[0].getValue();
        }
        return location;
    }

    public static HttpURLConnection buildConnection(URI baseServiceUri, String tail) {
        try {
            HttpURLConnection client = (HttpURLConnection)baseServiceUri.resolve(tail).toURL().openConnection();
            return client;
        }
        catch (MalformedURLException mue) {
            throw new EFhirClientException("Invalid Service URL", mue);
        }
        catch (IOException ioe) {
            throw new EFhirClientException("Unable to establish connection to server: " + baseServiceUri.toString() + tail, ioe);
        }
    }

    public static HttpURLConnection buildConnection(URI baseServiceUri, ResourceType resourceType, String id) {
        return ClientUtils.buildConnection(baseServiceUri, ResourceAddress.buildRelativePathFromResourceType(resourceType, id));
    }

    public static <T extends Resource> byte[] getResourceAsByteArray(T resource, boolean pretty, boolean isJson) {
        ByteArrayOutputStream baos = null;
        byte[] byteArray = null;
        try {
            baos = new ByteArrayOutputStream();
            ParserBase parser = null;
            parser = isJson ? new JsonParser() : new XmlParser();
            parser.setOutputStyle(pretty ? IParser.OutputStyle.PRETTY : IParser.OutputStyle.NORMAL);
            parser.compose(baos, resource);
            baos.close();
            byteArray = baos.toByteArray();
            baos.close();
        }
        catch (Exception e) {
            try {
                baos.close();
            }
            catch (Exception ex) {
                throw new EFhirClientException("Error closing output stream", ex);
            }
            throw new EFhirClientException("Error converting output stream to byte array", e);
        }
        return byteArray;
    }

    public static byte[] getFeedAsByteArray(Bundle feed, boolean pretty, boolean isJson) {
        ByteArrayOutputStream baos = null;
        byte[] byteArray = null;
        try {
            baos = new ByteArrayOutputStream();
            ParserBase parser = null;
            parser = isJson ? new JsonParser() : new XmlParser();
            parser.setOutputStyle(pretty ? IParser.OutputStyle.PRETTY : IParser.OutputStyle.NORMAL);
            parser.compose(baos, feed);
            baos.close();
            byteArray = baos.toByteArray();
            baos.close();
        }
        catch (Exception e) {
            try {
                baos.close();
            }
            catch (Exception ex) {
                throw new EFhirClientException("Error closing output stream", ex);
            }
            throw new EFhirClientException("Error converting output stream to byte array", e);
        }
        return byteArray;
    }

    public static Calendar getLastModifiedResponseHeaderAsCalendarObject(URLConnection serverConnection) {
        String dateTime = null;
        try {
            dateTime = serverConnection.getHeaderField("Last-Modified");
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            Date lastModifiedTimestamp = format.parse(dateTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(lastModifiedTimestamp);
            return calendar;
        }
        catch (ParseException pe) {
            throw new EFhirClientException("Error parsing Last-Modified response header " + dateTime, pe);
        }
    }

    protected static IParser getParser(String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            format = ResourceFormat.RESOURCE_XML.getHeader();
        }
        if (format.equalsIgnoreCase("json") || format.equalsIgnoreCase(ResourceFormat.RESOURCE_JSON.getHeader()) || format.equalsIgnoreCase(ResourceFormat.RESOURCE_JSON.getHeader())) {
            return new JsonParser();
        }
        if (format.equalsIgnoreCase("xml") || format.equalsIgnoreCase(ResourceFormat.RESOURCE_XML.getHeader()) || format.equalsIgnoreCase(ResourceFormat.RESOURCE_XML.getHeader())) {
            return new XmlParser();
        }
        throw new EFhirClientException("Invalid format: " + format);
    }

    protected static String writeInputStreamAsString(InputStream instream) {
        String value = null;
        try {
            value = IOUtils.toString((InputStream)instream, (String)"UTF-8");
            System.out.println(value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }

    public static Bundle issuePostFeedRequest(URI resourceUri, Map<String, String> parameters, String resourceName, Resource resource, String resourceFormat) throws IOException {
        HttpPost httppost = new HttpPost(resourceUri);
        String boundary = "----WebKitFormBoundarykbMUo6H8QaUnYtRy";
        httppost.addHeader("Content-Type", "multipart/form-data; boundary=" + boundary);
        httppost.addHeader("Accept", resourceFormat);
        ClientUtils.configureFhirRequest((HttpRequest)httppost, null);
        HttpResponse response = ClientUtils.sendPayload((HttpEntityEnclosingRequestBase)httppost, ClientUtils.encodeFormSubmission(parameters, resourceName, resource, boundary));
        return ClientUtils.unmarshalFeed(response, resourceFormat);
    }

    private static byte[] encodeFormSubmission(Map<String, String> parameters, String resourceName, Resource resource, String boundary) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)b, "UTF-8");
        for (String name : parameters.keySet()) {
            w.write("--");
            w.write(boundary);
            w.write("\r\nContent-Disposition: form-data; name=\"" + name + "\"\r\n\r\n");
            w.write(parameters.get(name) + "\r\n");
        }
        w.write("--");
        w.write(boundary);
        w.write("\r\nContent-Disposition: form-data; name=\"" + resourceName + "\"\r\n\r\n");
        w.close();
        JsonParser json = new JsonParser();
        json.setOutputStyle(IParser.OutputStyle.NORMAL);
        json.compose(b, resource);
        b.close();
        w = new OutputStreamWriter((OutputStream)b, "UTF-8");
        w.write("\r\n--");
        w.write(boundary);
        w.write("--");
        w.close();
        return b.toByteArray();
    }

    protected static HttpResponse sendPayload(HttpEntityEnclosingRequestBase request, byte[] payload) {
        HttpResponse response = null;
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            request.setEntity((HttpEntity)new ByteArrayEntity(payload));
            response = httpclient.execute((HttpUriRequest)request);
        }
        catch (IOException ioe) {
            throw new EFhirClientException("Error sending HTTP Post/Put Payload: " + ioe.getMessage(), ioe);
        }
        return response;
    }
}

