package org.hl7.fhir.dstu2016may.model.codesystems;




/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Sun, May 8, 2016 03:05+1000 for FHIR v1.4.0


import org.hl7.fhir.exceptions.FHIRException;

public enum AnzscoOccupations {

        /**
         * Managers not further defined
         */
        _100000, 
        /**
         * Chief Executives, General Managers and Legislators not further defined
         */
        _111000, 
        /**
         * Chief Executive or Managing Director
         */
        _111111, 
        /**
         * General Managers not further defined
         */
        _111200, 
        /**
         * Corporate General Manager
         */
        _111211, 
        /**
         * Defence Force Senior Officer
         */
        _111212, 
        /**
         * Legislators not further defined
         */
        _111300, 
        /**
         * Local Government Legislator
         */
        _111311, 
        /**
         * Member of Parliament
         */
        _111312, 
        /**
         * Legislators not elsewhere classified
         */
        _111399, 
        /**
         * Farmers and Farm Managers not further defined
         */
        _121000, 
        /**
         * Aquaculture Farmer
         */
        _121111, 
        /**
         * Crop Farmers not further defined
         */
        _121200, 
        /**
         * Cotton Grower
         */
        _121211, 
        /**
         * Flower Grower
         */
        _121212, 
        /**
         * Fruit or Nut Grower
         */
        _121213, 
        /**
         * Grain, Oilseed or Pasture Grower
         */
        _121214, 
        /**
         * Grape Grower
         */
        _121215, 
        /**
         * Mixed Crop Farmer
         */
        _121216, 
        /**
         * Sugar Cane Grower
         */
        _121217, 
        /**
         * Turf Grower
         */
        _121218, 
        /**
         * Vegetable Grower
         */
        _121221, 
        /**
         * Crop Farmers not elsewhere classified
         */
        _121299, 
        /**
         * Livestock Farmers not further defined
         */
        _121300, 
        /**
         * Apiarist
         */
        _121311, 
        /**
         * Beef Cattle Farmer
         */
        _121312, 
        /**
         * Dairy Cattle Farmer
         */
        _121313, 
        /**
         * Deer Farmer
         */
        _121314, 
        /**
         * Goat Farmer
         */
        _121315, 
        /**
         * Horse Breeder
         */
        _121316, 
        /**
         * Mixed Livestock Farmer
         */
        _121317, 
        /**
         * Pig Farmer
         */
        _121318, 
        /**
         * Poultry Farmer
         */
        _121321, 
        /**
         * Sheep Farmer
         */
        _121322, 
        /**
         * Livestock Farmers not elsewhere classified
         */
        _121399, 
        /**
         * Mixed Crop and Livestock Farmer
         */
        _121411, 
        /**
         * Specialist Managers not further defined
         */
        _130000, 
        /**
         * Advertising and Sales Managers not further defined
         */
        _131100, 
        /**
         * Advertising and Public Relations Manager
         */
        _131111, 
        /**
         * Sales and Marketing Manager
         */
        _131112, 
        /**
         * Business Administration Managers not further defined
         */
        _132000, 
        /**
         * Corporate Services Manager
         */
        _132111, 
        /**
         * Finance Manager
         */
        _132211, 
        /**
         * Human Resource Manager
         */
        _132311, 
        /**
         * Policy and Planning Manager
         */
        _132411, 
        /**
         * Research and Development Manager
         */
        _132511, 
        /**
         * Construction, Distribution and Production Managers not further defined
         */
        _133000, 
        /**
         * Construction Managers not further defined
         */
        _133100, 
        /**
         * Construction Project Manager
         */
        _133111, 
        /**
         * Project Builder
         */
        _133112, 
        /**
         * Engineering Manager
         */
        _133211, 
        /**
         * Importers, Exporters and Wholesalers not further defined
         */
        _133300, 
        /**
         * Importer or Exporter
         */
        _133311, 
        /**
         * Wholesaler
         */
        _133312, 
        /**
         * Manufacturer
         */
        _133411, 
        /**
         * Production Managers not further defined
         */
        _133500, 
        /**
         * Production Manager (Forestry)
         */
        _133511, 
        /**
         * Production Manager (Manufacturing)
         */
        _133512, 
        /**
         * Production Manager (Mining)
         */
        _133513, 
        /**
         * Supply and Distribution Manager
         */
        _133611, 
        /**
         * Education, Health and Welfare Services Managers not further defined
         */
        _134000, 
        /**
         * Child Care Centre Manager
         */
        _134111, 
        /**
         * Health and Welfare Services Managers not further defined
         */
        _134200, 
        /**
         * Medical Administrator
         */
        _134211, 
        /**
         * Nursing Clinical Director
         */
        _134212, 
        /**
         * Primary Health Organization Manager
         */
        _134213, 
        /**
         * Welfare Centre Manager
         */
        _134214, 
        /**
         * Health and Welfare Services Managers not elsewhere classified
         */
        _134299, 
        /**
         * School Principal
         */
        _134311, 
        /**
         * Other Education Managers not further defined
         */
        _134400, 
        /**
         * Faculty Head
         */
        _134411, 
        /**
         * Regional Education Manager
         */
        _134412, 
        /**
         * Education Managers not elsewhere classified
         */
        _134499, 
        /**
         * ICT Managers not further defined
         */
        _135100, 
        /**
         * Chief Information Officer
         */
        _135111, 
        /**
         * ICT Project Manager
         */
        _135112, 
        /**
         * ICT Managers not elsewhere classified
         */
        _135199, 
        /**
         * Miscellaneous Specialist Managers not further defined
         */
        _139000, 
        /**
         * Commissioned Officers (Management) not further defined
         */
        _139100, 
        /**
         * Commissioned Defence Force Officer
         */
        _139111, 
        /**
         * Commissioned Fire Officer
         */
        _139112, 
        /**
         * Commissioned Police Officer
         */
        _139113, 
        /**
         * Senior Non-commissioned Defence Force Member
         */
        _139211, 
        /**
         * Other Specialist Managers not further defined
         */
        _139900, 
        /**
         * Arts Administrator or Manager
         */
        _139911, 
        /**
         * Environmental Manager
         */
        _139912, 
        /**
         * Laboratory Manager
         */
        _139913, 
        /**
         * Quality Assurance Manager
         */
        _139914, 
        /**
         * Sports Administrator
         */
        _139915, 
        /**
         * Specialist Managers not elsewhere classified
         */
        _139999, 
        /**
         * Hospitality, Retail and Service Managers not further defined
         */
        _140000, 
        /**
         * Accommodation and Hospitality Managers not further defined
         */
        _141000, 
        /**
         * Cafe or Restaurant Manager
         */
        _141111, 
        /**
         * Caravan Park and Camping Ground Manager
         */
        _141211, 
        /**
         * Hotel or Motel Manager
         */
        _141311, 
        /**
         * Licensed Club Manager
         */
        _141411, 
        /**
         * Other Accommodation and Hospitality Managers not further defined
         */
        _141900, 
        /**
         * Bed and Breakfast Operator
         */
        _141911, 
        /**
         * Accommodation and Hospitality Managers not elsewhere classified
         */
        _141999, 
        /**
         * Retail Managers not further defined
         */
        _142100, 
        /**
         * Retail Manager (General)
         */
        _142111, 
        /**
         * Antique Dealer
         */
        _142112, 
        /**
         * Betting Agency Manager
         */
        _142113, 
        /**
         * Hair or Beauty Salon Manager
         */
        _142114, 
        /**
         * Post Office Manager
         */
        _142115, 
        /**
         * Travel Agency Manager
         */
        _142116, 
        /**
         * Miscellaneous Hospitality, Retail and Service Managers not further defined
         */
        _149000, 
        /**
         * Amusement, Fitness and Sports Centre Managers not further defined
         */
        _149100, 
        /**
         * Amusement Centre Manager
         */
        _149111, 
        /**
         * Fitness Centre Manager
         */
        _149112, 
        /**
         * Sports Centre Manager
         */
        _149113, 
        /**
         * Call or Contact Centre and Customer Service Managers not further defined
         */
        _149200, 
        /**
         * Call or Contact Centre Manager
         */
        _149211, 
        /**
         * Customer Service Manager
         */
        _149212, 
        /**
         * Conference and Event Organizer
         */
        _149311, 
        /**
         * Transport Services Managers not further defined
         */
        _149400, 
        /**
         * Fleet Manager
         */
        _149411, 
        /**
         * Railway Station Manager
         */
        _149412, 
        /**
         * Transport Company Manager
         */
        _149413, 
        /**
         * Other Hospitality, Retail and Service Managers not further defined
         */
        _149900, 
        /**
         * Boarding Kennel or Cattery Operator
         */
        _149911, 
        /**
         * Cinema or Theatre Manager
         */
        _149912, 
        /**
         * Facilities Manager
         */
        _149913, 
        /**
         * Financial Institution Branch Manager
         */
        _149914, 
        /**
         * Hospitality, Retail and Service Managers not elsewhere classified
         */
        _149999, 
        /**
         * Professionals not further defined
         */
        _200000, 
        /**
         * Arts and Media Professionals not further defined
         */
        _210000, 
        /**
         * Arts Professionals not further defined
         */
        _211000, 
        /**
         * Actors, Dancers and Other Entertainers not further defined
         */
        _211100, 
        /**
         * Actor
         */
        _211111, 
        /**
         * Dancer or Choreographer
         */
        _211112, 
        /**
         * Entertainer or Variety Artist
         */
        _211113, 
        /**
         * Actors, Dancers and Other Entertainers not elsewhere classified
         */
        _211199, 
        /**
         * Music Professionals not further defined
         */
        _211200, 
        /**
         * Composer
         */
        _211211, 
        /**
         * Music Director
         */
        _211212, 
        /**
         * Musician (Instrumental)
         */
        _211213, 
        /**
         * Singer
         */
        _211214, 
        /**
         * Music Professionals not elsewhere classified
         */
        _211299, 
        /**
         * Photographer
         */
        _211311, 
        /**
         * Visual Arts and Crafts Professionals not further defined
         */
        _211400, 
        /**
         * Painter (Visual Arts)
         */
        _211411, 
        /**
         * Potter or Ceramic Artist
         */
        _211412, 
        /**
         * Sculptor
         */
        _211413, 
        /**
         * Visual Arts and Crafts Professionals not elsewhere classified
         */
        _211499, 
        /**
         * Media Professionals not further defined
         */
        _212000, 
        /**
         * Artistic Directors, and Media Producers and Presenters not further defined
         */
        _212100, 
        /**
         * Artistic Director
         */
        _212111, 
        /**
         * Media Producer (excluding Video)
         */
        _212112, 
        /**
         * Radio Presenter
         */
        _212113, 
        /**
         * Television Presenter
         */
        _212114, 
        /**
         * Authors, and Book and Script Editors not further defined
         */
        _212200, 
        /**
         * Author
         */
        _212211, 
        /**
         * Book or Script Editor
         */
        _212212, 
        /**
         * Film, Television, Radio and Stage Directors not further defined
         */
        _212300, 
        /**
         * Art Director (Film, Television or Stage)
         */
        _212311, 
        /**
         * Director (Film, Television, Radio or Stage)
         */
        _212312, 
        /**
         * Director of Photography
         */
        _212313, 
        /**
         * Film and Video Editor
         */
        _212314, 
        /**
         * Program Director (Television or Radio)
         */
        _212315, 
        /**
         * Stage Manager
         */
        _212316, 
        /**
         * Technical Director
         */
        _212317, 
        /**
         * Video Producer
         */
        _212318, 
        /**
         * Film, Television, Radio and Stage Directors not elsewhere classified
         */
        _212399, 
        /**
         * Journalists and Other Writers not further defined
         */
        _212400, 
        /**
         * Copywriter
         */
        _212411, 
        /**
         * Newspaper or Periodical Editor
         */
        _212412, 
        /**
         * Print Journalist
         */
        _212413, 
        /**
         * Radio Journalist
         */
        _212414, 
        /**
         * Technical Writer
         */
        _212415, 
        /**
         * Television Journalist
         */
        _212416, 
        /**
         * Journalists and Other Writers not elsewhere classified
         */
        _212499, 
        /**
         * Business, Human Resource and Marketing Professionals not further defined
         */
        _220000, 
        /**
         * Accountants, Auditors and Company Secretaries not further defined
         */
        _221000, 
        /**
         * Accountants not further defined
         */
        _221100, 
        /**
         * Accountant (General)
         */
        _221111, 
        /**
         * Management Accountant
         */
        _221112, 
        /**
         * Taxation Accountant
         */
        _221113, 
        /**
         * Auditors, Company Secretaries and Corporate Treasurers not further defined
         */
        _221200, 
        /**
         * Company Secretary
         */
        _221211, 
        /**
         * Corporate Treasurer
         */
        _221212, 
        /**
         * External Auditor
         */
        _221213, 
        /**
         * Internal Auditor
         */
        _221214, 
        /**
         * Financial Brokers and Dealers, and Investment Advisers not further defined
         */
        _222000, 
        /**
         * Financial Brokers not further defined
         */
        _222100, 
        /**
         * Commodities Trader
         */
        _222111, 
        /**
         * Finance Broker
         */
        _222112, 
        /**
         * Insurance Broker
         */
        _222113, 
        /**
         * Financial Brokers not elsewhere classified
         */
        _222199, 
        /**
         * Financial Dealers not further defined
         */
        _222200, 
        /**
         * Financial Market Dealer
         */
        _222211, 
        /**
         * Futures Trader
         */
        _222212, 
        /**
         * Stockbroking Dealer
         */
        _222213, 
        /**
         * Financial Dealers not elsewhere classified
         */
        _222299, 
        /**
         * Financial Investment Advisers and Managers not further defined
         */
        _222300, 
        /**
         * Financial Investment Adviser
         */
        _222311, 
        /**
         * Financial Investment Manager
         */
        _222312, 
        /**
         * Human Resource and Training Professionals not further defined
         */
        _223000, 
        /**
         * Human Resource Professionals not further defined
         */
        _223100, 
        /**
         * Human Resource Adviser
         */
        _223111, 
        /**
         * Recruitment Consultant
         */
        _223112, 
        /**
         * Workplace Relations Adviser
         */
        _223113, 
        /**
         * ICT Trainer
         */
        _223211, 
        /**
         * Training and Development Professional
         */
        _223311, 
        /**
         * Information and Organization Professionals not further defined
         */
        _224000, 
        /**
         * Actuaries, Mathematicians and Statisticians not further defined
         */
        _224100, 
        /**
         * Actuary
         */
        _224111, 
        /**
         * Mathematician
         */
        _224112, 
        /**
         * Statistician
         */
        _224113, 
        /**
         * Archivists, Curators and Records Managers not further defined
         */
        _224200, 
        /**
         * Archivist
         */
        _224211, 
        /**
         * Gallery or Museum Curator
         */
        _224212, 
        /**
         * Health Information Manager
         */
        _224213, 
        /**
         * Records Manager
         */
        _224214, 
        /**
         * Economist
         */
        _224311, 
        /**
         * Intelligence and Policy Analysts not further defined
         */
        _224400, 
        /**
         * Intelligence Officer
         */
        _224411, 
        /**
         * Policy Analyst
         */
        _224412, 
        /**
         * Land Economists and Valuers not further defined
         */
        _224500, 
        /**
         * Land Economist
         */
        _224511, 
        /**
         * Valuer
         */
        _224512, 
        /**
         * Librarian
         */
        _224611, 
        /**
         * Management and Organization Analysts not further defined
         */
        _224700, 
        /**
         * Management Consultant
         */
        _224711, 
        /**
         * Organization and Methods Analyst
         */
        _224712, 
        /**
         * Other Information and Organization Professionals not further defined
         */
        _224900, 
        /**
         * Electorate Officer
         */
        _224911, 
        /**
         * Liaison Officer
         */
        _224912, 
        /**
         * Migration Agent
         */
        _224913, 
        /**
         * Patents Examiner
         */
        _224914, 
        /**
         * Information and Organization Professionals not elsewhere classified
         */
        _224999, 
        /**
         * Sales, Marketing and Public Relations Professionals not further defined
         */
        _225000, 
        /**
         * Advertising and Marketing Professionals not further defined
         */
        _225100, 
        /**
         * Advertising Specialist
         */
        _225111, 
        /**
         * Market Research Analyst
         */
        _225112, 
        /**
         * Marketing Specialist
         */
        _225113, 
        /**
         * ICT Sales Professionals not further defined
         */
        _225200, 
        /**
         * ICT Account Manager
         */
        _225211, 
        /**
         * ICT Business Development Manager
         */
        _225212, 
        /**
         * ICT Sales Representative
         */
        _225213, 
        /**
         * Public Relations Professional
         */
        _225311, 
        /**
         * Technical Sales Representatives not further defined
         */
        _225400, 
        /**
         * Sales Representative (Industrial Products)
         */
        _225411, 
        /**
         * Sales Representative (Medical and Pharmaceutical Products)
         */
        _225412, 
        /**
         * Technical Sales Representatives not elsewhere classified
         */
        _225499, 
        /**
         * Design, Engineering, Science and Transport Professionals not further defined
         */
        _230000, 
        /**
         * Air and Marine Transport Professionals not further defined
         */
        _231000, 
        /**
         * Air Transport Professionals not further defined
         */
        _231100, 
        /**
         * Aeroplane Pilot
         */
        _231111, 
        /**
         * Air Traffic Controller
         */
        _231112, 
        /**
         * Flying Instructor
         */
        _231113, 
        /**
         * Helicopter Pilot
         */
        _231114, 
        /**
         * Air Transport Professionals not elsewhere classified
         */
        _231199, 
        /**
         * Marine Transport Professionals not further defined
         */
        _231200, 
        /**
         * Master Fisher
         */
        _231211, 
        /**
         * Ship's Engineer
         */
        _231212, 
        /**
         * Ship's Master
         */
        _231213, 
        /**
         * Ship's Officer
         */
        _231214, 
        /**
         * Ship's Surveyor
         */
        _231215, 
        /**
         * Marine Transport Professionals not elsewhere classified
         */
        _231299, 
        /**
         * Architects, Designers, Planners and Surveyors not further defined
         */
        _232000, 
        /**
         * Architects and Landscape Architects not further defined
         */
        _232100, 
        /**
         * Architect
         */
        _232111, 
        /**
         * Landscape Architect
         */
        _232112, 
        /**
         * Cartographers and Surveyors not further defined
         */
        _232200, 
        /**
         * Cartographer
         */
        _232211, 
        /**
         * Surveyor
         */
        _232212, 
        /**
         * Fashion, Industrial and Jewellery Designers not further defined
         */
        _232300, 
        /**
         * Fashion Designer
         */
        _232311, 
        /**
         * Industrial Designer
         */
        _232312, 
        /**
         * Jewellery Designer
         */
        _232313, 
        /**
         * Graphic and Web Designers, and Illustrators not further defined
         */
        _232400, 
        /**
         * Graphic Designer
         */
        _232411, 
        /**
         * Illustrator
         */
        _232412, 
        /**
         * Multimedia Designer
         */
        _232413, 
        /**
         * Web Designer
         */
        _232414, 
        /**
         * Interior Designer
         */
        _232511, 
        /**
         * Urban and Regional Planner
         */
        _232611, 
        /**
         * Engineering Professionals not further defined
         */
        _233000, 
        /**
         * Chemical and Materials Engineers not further defined
         */
        _233100, 
        /**
         * Chemical Engineer
         */
        _233111, 
        /**
         * Materials Engineer
         */
        _233112, 
        /**
         * Civil Engineering Professionals not further defined
         */
        _233200, 
        /**
         * Civil Engineer
         */
        _233211, 
        /**
         * Geotechnical Engineer
         */
        _233212, 
        /**
         * Quantity Surveyor
         */
        _233213, 
        /**
         * Structural Engineer
         */
        _233214, 
        /**
         * Transport Engineer
         */
        _233215, 
        /**
         * Electrical Engineer
         */
        _233311, 
        /**
         * Electronics Engineer
         */
        _233411, 
        /**
         * Industrial, Mechanical and Production Engineers not further defined
         */
        _233500, 
        /**
         * Industrial Engineer
         */
        _233511, 
        /**
         * Mechanical Engineer
         */
        _233512, 
        /**
         * Production or Plant Engineer
         */
        _233513, 
        /**
         * Mining Engineers not further defined
         */
        _233600, 
        /**
         * Mining Engineer (excluding Petroleum)
         */
        _233611, 
        /**
         * Petroleum Engineer
         */
        _233612, 
        /**
         * Other Engineering Professionals not further defined
         */
        _233900, 
        /**
         * Aeronautical Engineer
         */
        _233911, 
        /**
         * Agricultural Engineer
         */
        _233912, 
        /**
         * Biomedical Engineer
         */
        _233913, 
        /**
         * Engineering Technologist
         */
        _233914, 
        /**
         * Environmental Engineer
         */
        _233915, 
        /**
         * Naval Architect
         */
        _233916, 
        /**
         * Engineering Professionals not elsewhere classified
         */
        _233999, 
        /**
         * Natural and Physical Science Professionals not further defined
         */
        _234000, 
        /**
         * Agricultural and Forestry Scientists not further defined
         */
        _234100, 
        /**
         * Agricultural Consultant
         */
        _234111, 
        /**
         * Agricultural Scientist
         */
        _234112, 
        /**
         * Forester
         */
        _234113, 
        /**
         * Chemists, and Food and Wine Scientists not further defined
         */
        _234200, 
        /**
         * Chemist
         */
        _234211, 
        /**
         * Food Technologist
         */
        _234212, 
        /**
         * Wine Maker
         */
        _234213, 
        /**
         * Environmental Scientists not further defined
         */
        _234300, 
        /**
         * Conservation Officer
         */
        _234311, 
        /**
         * Environmental Consultant
         */
        _234312, 
        /**
         * Environmental Research Scientist
         */
        _234313, 
        /**
         * Park Ranger
         */
        _234314, 
        /**
         * Environmental Scientists not elsewhere classified
         */
        _234399, 
        /**
         * Geologists and Geophysicists not further defined
         */
        _234400, 
        /**
         * Geologist
         */
        _234411, 
        /**
         * Geophysicist
         */
        _234412, 
        /**
         * Life Scientists not further defined
         */
        _234500, 
        /**
         * Life Scientist (General)
         */
        _234511, 
        /**
         * Anatomist or Physiologist
         */
        _234512, 
        /**
         * Biochemist
         */
        _234513, 
        /**
         * Biotechnologist
         */
        _234514, 
        /**
         * Botanist
         */
        _234515, 
        /**
         * Marine Biologist
         */
        _234516, 
        /**
         * Microbiologist
         */
        _234517, 
        /**
         * Zoologist
         */
        _234518, 
        /**
         * Life Scientists not elsewhere classified
         */
        _234599, 
        /**
         * Medical Laboratory Scientist
         */
        _234611, 
        /**
         * Veterinarian
         */
        _234711, 
        /**
         * Other Natural and Physical Science Professionals not further defined
         */
        _234900, 
        /**
         * Conservator
         */
        _234911, 
        /**
         * Metallurgist
         */
        _234912, 
        /**
         * Meteorologist
         */
        _234913, 
        /**
         * Physicist
         */
        _234914, 
        /**
         * Natural and Physical Science Professionals not elsewhere classified
         */
        _234999, 
        /**
         * Education Professionals not further defined
         */
        _240000, 
        /**
         * School Teachers not further defined
         */
        _241000, 
        /**
         * Early Childhood (Pre-primary School) Teacher
         */
        _241111, 
        /**
         * Primary School Teacher
         */
        _241213, 
        /**
         * Middle School Teacher
         */
        _241311, 
        /**
         * Secondary School Teacher
         */
        _241411, 
        /**
         * Special Education Teachers not further defined
         */
        _241500, 
        /**
         * Special Needs Teacher
         */
        _241511, 
        /**
         * Teacher of the Hearing Impaired
         */
        _241512, 
        /**
         * Teacher of the Sight Impaired
         */
        _241513, 
        /**
         * Special Education Teachers not elsewhere classified
         */
        _241599, 
        /**
         * Tertiary Education Teachers not further defined
         */
        _242000, 
        /**
         * University Lecturers and Tutors not further defined
         */
        _242100, 
        /**
         * University Lecturer
         */
        _242111, 
        /**
         * University Tutor
         */
        _242112, 
        /**
         * Vocational Education Teacher
         */
        _242211, 
        /**
         * Miscellaneous Education Professionals not further defined
         */
        _249000, 
        /**
         * Education Advisers and Reviewers not further defined
         */
        _249100, 
        /**
         * Education Adviser
         */
        _249111, 
        /**
         * Education Reviewer
         */
        _249112, 
        /**
         * Private Tutors and Teachers not further defined
         */
        _249200, 
        /**
         * Art Teacher (Private Tuition)
         */
        _249211, 
        /**
         * Dance Teacher (Private Tuition)
         */
        _249212, 
        /**
         * Drama Teacher (Private Tuition)
         */
        _249213, 
        /**
         * Music Teacher (Private Tuition)
         */
        _249214, 
        /**
         * Private Tutors and Teachers not elsewhere classified
         */
        _249299, 
        /**
         * Teacher of English to Speakers of Other Languages
         */
        _249311, 
        /**
         * Health Professionals not further defined
         */
        _250000, 
        /**
         * Health Diagnostic and Promotion Professionals not further defined
         */
        _251000, 
        /**
         * Dietitian
         */
        _251111, 
        /**
         * Medical Imaging Professionals not further defined
         */
        _251200, 
        /**
         * Medical Diagnostic Radiographer
         */
        _251211, 
        /**
         * Medical Radiation Therapist
         */
        _251212, 
        /**
         * Nuclear Medicine Technologist
         */
        _251213, 
        /**
         * Sonographer
         */
        _251214, 
        /**
         * Occupational and Environmental Health Professionals not further defined
         */
        _251300, 
        /**
         * Environmental Health Officer
         */
        _251311, 
        /**
         * Occupational Health and Safety Adviser
         */
        _251312, 
        /**
         * Optometrists and Orthoptists not further defined
         */
        _251400, 
        /**
         * Optometrist
         */
        _251411, 
        /**
         * Orthoptist
         */
        _251412, 
        /**
         * Pharmacists not further defined
         */
        _251500, 
        /**
         * Hospital Pharmacist
         */
        _251511, 
        /**
         * Industrial Pharmacist
         */
        _251512, 
        /**
         * Retail Pharmacist
         */
        _251513, 
        /**
         * Other Health Diagnostic and Promotion Professionals not further defined
         */
        _251900, 
        /**
         * Health Promotion Officer
         */
        _251911, 
        /**
         * Orthotist or Prosthetist
         */
        _251912, 
        /**
         * Health Diagnostic and Promotion Professionals not elsewhere classified
         */
        _251999, 
        /**
         * Health Therapy Professionals not further defined
         */
        _252000, 
        /**
         * Chiropractors and Osteopaths not further defined
         */
        _252100, 
        /**
         * Chiropractor
         */
        _252111, 
        /**
         * Osteopath
         */
        _252112, 
        /**
         * Complementary Health Therapists not further defined
         */
        _252200, 
        /**
         * Acupuncturist
         */
        _252211, 
        /**
         * Homoeopath
         */
        _252212, 
        /**
         * Naturopath
         */
        _252213, 
        /**
         * Traditional Chinese Medicine Practitioner
         */
        _252214, 
        /**
         * Complementary Health Therapists not elsewhere classified
         */
        _252299, 
        /**
         * Dental Practitioners not further defined
         */
        _252300, 
        /**
         * Dental Specialist
         */
        _252311, 
        /**
         * Dentist
         */
        _252312, 
        /**
         * Occupational Therapist
         */
        _252411, 
        /**
         * Physiotherapist
         */
        _252511, 
        /**
         * Podiatrist
         */
        _252611, 
        /**
         * Speech Professionals and Audiologists not further defined
         */
        _252700, 
        /**
         * Audiologist
         */
        _252711, 
        /**
         * Speech Pathologist
         */
        _252712, 
        /**
         * Medical Practitioners not further defined
         */
        _253000, 
        /**
         * Generalist Medical Practitioners not further defined
         */
        _253100, 
        /**
         * General Medical Practitioner
         */
        _253111, 
        /**
         * Resident Medical Officer
         */
        _253112, 
        /**
         * Anaesthetist
         */
        _253211, 
        /**
         * Internal Medicine Specialists not further defined
         */
        _253300, 
        /**
         * Specialist Physician (General Medicine)
         */
        _253311, 
        /**
         * Cardiologist
         */
        _253312, 
        /**
         * Clinical Haematologist
         */
        _253313, 
        /**
         * Clinical Oncologist
         */
        _253314, 
        /**
         * Endocrinologist
         */
        _253315, 
        /**
         * Gastroenterologist
         */
        _253316, 
        /**
         * Intensive Care Specialist
         */
        _253317, 
        /**
         * Neurologist
         */
        _253318, 
        /**
         * Paediatrician
         */
        _253321, 
        /**
         * Renal Medicine Specialist
         */
        _253322, 
        /**
         * Rheumatologist
         */
        _253323, 
        /**
         * Thoracic Medicine Specialist
         */
        _253324, 
        /**
         * Internal Medicine Specialists not elsewhere classified
         */
        _253399, 
        /**
         * Psychiatrist
         */
        _253411, 
        /**
         * Surgeons not further defined
         */
        _253500, 
        /**
         * Surgeon (General)
         */
        _253511, 
        /**
         * Cardiothoracic Surgeon
         */
        _253512, 
        /**
         * Neurosurgeon
         */
        _253513, 
        /**
         * Orthopaedic Surgeon
         */
        _253514, 
        /**
         * Otorhinolaryngologist
         */
        _253515, 
        /**
         * Paediatric Surgeon
         */
        _253516, 
        /**
         * Plastic and Reconstructive Surgeon
         */
        _253517, 
        /**
         * Urologist
         */
        _253518, 
        /**
         * Vascular Surgeon
         */
        _253521, 
        /**
         * Other Medical Practitioners not further defined
         */
        _253900, 
        /**
         * Dermatologist
         */
        _253911, 
        /**
         * Emergency Medicine Specialist
         */
        _253912, 
        /**
         * Obstetrician and Gynaecologist
         */
        _253913, 
        /**
         * Ophthalmologist
         */
        _253914, 
        /**
         * Pathologist
         */
        _253915, 
        /**
         * Radiologist
         */
        _253916, 
        /**
         * Medical Practitioners not elsewhere classified
         */
        _253999, 
        /**
         * Midwifery and Nursing Professionals not further defined
         */
        _254000, 
        /**
         * Midwife
         */
        _254111, 
        /**
         * Nurse Educators and Researchers not further defined
         */
        _254200, 
        /**
         * Nurse Educator
         */
        _254211, 
        /**
         * Nurse Researcher
         */
        _254212, 
        /**
         * Nurse Manager
         */
        _254311, 
        /**
         * Registered Nurses not further defined
         */
        _254400, 
        /**
         * Nurse Practitioner
         */
        _254411, 
        /**
         * Registered Nurse (Aged Care)
         */
        _254412, 
        /**
         * Registered Nurse (Child and Family Health)
         */
        _254413, 
        /**
         * Registered Nurse (Community Health)
         */
        _254414, 
        /**
         * Registered Nurse (Critical Care and Emergency)
         */
        _254415, 
        /**
         * Registered Nurse (Developmental Disability)
         */
        _254416, 
        /**
         * Registered Nurse (Disability and Rehabilitation)
         */
        _254417, 
        /**
         * Registered Nurse (Medical)
         */
        _254418, 
        /**
         * Registered Nurse (Medical Practice)
         */
        _254421, 
        /**
         * Registered Nurse (Mental Health)
         */
        _254422, 
        /**
         * Registered Nurse (Perioperative)
         */
        _254423, 
        /**
         * Registered Nurse (Surgical)
         */
        _254424, 
        /**
         * Registered Nurses not elsewhere classified
         */
        _254499, 
        /**
         * ICT Professionals not further defined
         */
        _260000, 
        /**
         * Business and Systems Analysts, and Programmers not further defined
         */
        _261000, 
        /**
         * ICT Business and Systems Analysts not further defined
         */
        _261100, 
        /**
         * ICT Business Analyst
         */
        _261111, 
        /**
         * Systems Analyst
         */
        _261112, 
        /**
         * Multimedia Specialists and Web Developers not further defined
         */
        _261200, 
        /**
         * Multimedia Specialist
         */
        _261211, 
        /**
         * Web Developer
         */
        _261212, 
        /**
         * Software and Applications Programmers not further defined
         */
        _261300, 
        /**
         * Analyst Programmer
         */
        _261311, 
        /**
         * Developer Programmer
         */
        _261312, 
        /**
         * Software Engineer
         */
        _261313, 
        /**
         * Software and Applications Programmers not elsewhere classified
         */
        _261399, 
        /**
         * Database and Systems Administrators, and ICT Security Specialists not further defined
         */
        _262100, 
        /**
         * Database Administrator
         */
        _262111, 
        /**
         * ICT Security Specialist
         */
        _262112, 
        /**
         * Systems Administrator
         */
        _262113, 
        /**
         * ICT Network and Support Professionals not further defined
         */
        _263000, 
        /**
         * Computer Network Professionals not further defined
         */
        _263100, 
        /**
         * Computer Network and Systems Engineer
         */
        _263111, 
        /**
         * Network Administrator
         */
        _263112, 
        /**
         * Network Analyst
         */
        _263113, 
        /**
         * ICT Support and Test Engineers not further defined
         */
        _263200, 
        /**
         * ICT Quality Assurance Engineer
         */
        _263211, 
        /**
         * ICT Support Engineer
         */
        _263212, 
        /**
         * ICT Systems Test Engineer
         */
        _263213, 
        /**
         * ICT Support and Test Engineers not elsewhere classified
         */
        _263299, 
        /**
         * Telecommunications Engineering Professionals not further defined
         */
        _263300, 
        /**
         * Telecommunications Engineer
         */
        _263311, 
        /**
         * Telecommunications Network Engineer
         */
        _263312, 
        /**
         * Legal, Social and Welfare Professionals not further defined
         */
        _270000, 
        /**
         * Legal Professionals not further defined
         */
        _271000, 
        /**
         * Barrister
         */
        _271111, 
        /**
         * Judicial and Other Legal Professionals not further defined
         */
        _271200, 
        /**
         * Judge
         */
        _271211, 
        /**
         * Magistrate
         */
        _271212, 
        /**
         * Tribunal Member
         */
        _271213, 
        /**
         * Judicial and Other Legal Professionals not elsewhere classified
         */
        _271299, 
        /**
         * Solicitor
         */
        _271311, 
        /**
         * Social and Welfare Professionals not further defined
         */
        _272000, 
        /**
         * Counsellors not further defined
         */
        _272100, 
        /**
         * Careers Counsellor
         */
        _272111, 
        /**
         * Drug and Alcohol Counsellor
         */
        _272112, 
        /**
         * Family and Marriage Counsellor
         */
        _272113, 
        /**
         * Rehabilitation Counsellor
         */
        _272114, 
        /**
         * Student Counsellor
         */
        _272115, 
        /**
         * Counsellors not elsewhere classified
         */
        _272199, 
        /**
         * Minister of Religion
         */
        _272211, 
        /**
         * Psychologists not further defined
         */
        _272300, 
        /**
         * Clinical Psychologist
         */
        _272311, 
        /**
         * Educational Psychologist
         */
        _272312, 
        /**
         * Organizational Psychologist
         */
        _272313, 
        /**
         * Psychotherapist
         */
        _272314, 
        /**
         * Psychologists not elsewhere classified
         */
        _272399, 
        /**
         * Social Professionals not further defined
         */
        _272400, 
        /**
         * Historian
         */
        _272411, 
        /**
         * Interpreter
         */
        _272412, 
        /**
         * Translator
         */
        _272413, 
        /**
         * Social Professionals not elsewhere classified
         */
        _272499, 
        /**
         * Social Worker
         */
        _272511, 
        /**
         * Welfare, Recreation and Community Arts Workers not further defined
         */
        _272600, 
        /**
         * Community Arts Worker
         */
        _272611, 
        /**
         * Recreation Officer
         */
        _272612, 
        /**
         * Welfare Worker
         */
        _272613, 
        /**
         * Technicians and Trades Workers not further defined
         */
        _300000, 
        /**
         * Engineering, ICT and Science Technicians not further defined
         */
        _310000, 
        /**
         * Agricultural, Medical and Science Technicians not further defined
         */
        _311000, 
        /**
         * Agricultural Technician
         */
        _311111, 
        /**
         * Medical Technicians not further defined
         */
        _311200, 
        /**
         * Anaesthetic Technician
         */
        _311211, 
        /**
         * Cardiac Technician
         */
        _311212, 
        /**
         * Medical Laboratory Technician
         */
        _311213, 
        /**
         * Operating Theatre Technician
         */
        _311214, 
        /**
         * Pharmacy Technician
         */
        _311215, 
        /**
         * Medical Technicians not elsewhere classified
         */
        _311299, 
        /**
         * Primary Products Inspectors not further defined
         */
        _311300, 
        /**
         * Fisheries Officer
         */
        _311311, 
        /**
         * Meat Inspector
         */
        _311312, 
        /**
         * Quarantine Officer
         */
        _311313, 
        /**
         * Primary Products Inspectors not elsewhere classified
         */
        _311399, 
        /**
         * Science Technicians not further defined
         */
        _311400, 
        /**
         * Chemistry Technician
         */
        _311411, 
        /**
         * Earth Science Technician
         */
        _311412, 
        /**
         * Life Science Technician
         */
        _311413, 
        /**
         * School Laboratory Technician
         */
        _311414, 
        /**
         * Science Technicians not elsewhere classified
         */
        _311499, 
        /**
         * Building and Engineering Technicians not further defined
         */
        _312000, 
        /**
         * Architectural, Building and Surveying Technicians not further defined
         */
        _312100, 
        /**
         * Architectural Draftsperson
         */
        _312111, 
        /**
         * Building Associate
         */
        _312112, 
        /**
         * Building Inspector
         */
        _312113, 
        /**
         * Construction Estimator
         */
        _312114, 
        /**
         * Plumbing Inspector
         */
        _312115, 
        /**
         * Surveying or Cartographic Technician
         */
        _312116, 
        /**
         * Civil Engineering Draftspersons and Technicians not further defined
         */
        _312200, 
        /**
         * Civil Engineering Draftsperson
         */
        _312211, 
        /**
         * Civil Engineering Technician
         */
        _312212, 
        /**
         * Electrical Engineering Draftspersons and Technicians not further defined
         */
        _312300, 
        /**
         * Electrical Engineering Draftsperson
         */
        _312311, 
        /**
         * Electrical Engineering Technician
         */
        _312312, 
        /**
         * Electronic Engineering Draftspersons and Technicians not further defined
         */
        _312400, 
        /**
         * Electronic Engineering Draftsperson
         */
        _312411, 
        /**
         * Electronic Engineering Technician
         */
        _312412, 
        /**
         * Mechanical Engineering Draftspersons and Technicians not further defined
         */
        _312500, 
        /**
         * Mechanical Engineering Draftsperson
         */
        _312511, 
        /**
         * Mechanical Engineering Technician
         */
        _312512, 
        /**
         * Safety Inspector
         */
        _312611, 
        /**
         * Other Building and Engineering Technicians not further defined
         */
        _312900, 
        /**
         * Maintenance Planner
         */
        _312911, 
        /**
         * Metallurgical or Materials Technician
         */
        _312912, 
        /**
         * Mine Deputy
         */
        _312913, 
        /**
         * Building and Engineering Technicians not elsewhere classified
         */
        _312999, 
        /**
         * ICT and Telecommunications Technicians not further defined
         */
        _313000, 
        /**
         * ICT Support Technicians not further defined
         */
        _313100, 
        /**
         * Hardware Technician
         */
        _313111, 
        /**
         * ICT Customer Support Officer
         */
        _313112, 
        /**
         * Web Administrator
         */
        _313113, 
        /**
         * ICT Support Technicians not elsewhere classified
         */
        _313199, 
        /**
         * Telecommunications Technical Specialists not further defined
         */
        _313200, 
        /**
         * Radiocommunications Technician
         */
        _313211, 
        /**
         * Telecommunications Field Engineer
         */
        _313212, 
        /**
         * Telecommunications Network Planner
         */
        _313213, 
        /**
         * Telecommunications Technical Officer or Technologist
         */
        _313214, 
        /**
         * Automotive and Engineering Trades Workers not further defined
         */
        _320000, 
        /**
         * Automotive Electricians and Mechanics not further defined
         */
        _321000, 
        /**
         * Automotive Electrician
         */
        _321111, 
        /**
         * Motor Mechanics not further defined
         */
        _321200, 
        /**
         * Motor Mechanic (General)
         */
        _321211, 
        /**
         * Diesel Motor Mechanic
         */
        _321212, 
        /**
         * Motorcycle Mechanic
         */
        _321213, 
        /**
         * Small Engine Mechanic
         */
        _321214, 
        /**
         * Fabrication Engineering Trades Workers not further defined
         */
        _322000, 
        /**
         * Metal Casting, Forging and Finishing Trades Workers not further defined
         */
        _322100, 
        /**
         * Blacksmith
         */
        _322111, 
        /**
         * Electroplater
         */
        _322112, 
        /**
         * Farrier
         */
        _322113, 
        /**
         * Metal Casting Trades Worker
         */
        _322114, 
        /**
         * Metal Polisher
         */
        _322115, 
        /**
         * Sheetmetal Trades Worker
         */
        _322211, 
        /**
         * Structural Steel and Welding Trades Workers not further defined
         */
        _322300, 
        /**
         * Metal Fabricator
         */
        _322311, 
        /**
         * Pressure Welder
         */
        _322312, 
        /**
         * Welder (First Class)
         */
        _322313, 
        /**
         * Mechanical Engineering Trades Workers not further defined
         */
        _323000, 
        /**
         * Aircraft Maintenance Engineers not further defined
         */
        _323100, 
        /**
         * Aircraft Maintenance Engineer (Avionics)
         */
        _323111, 
        /**
         * Aircraft Maintenance Engineer (Mechanical)
         */
        _323112, 
        /**
         * Aircraft Maintenance Engineer (Structures)
         */
        _323113, 
        /**
         * Metal Fitters and Machinists not further defined
         */
        _323200, 
        /**
         * Fitter (General)
         */
        _323211, 
        /**
         * Fitter and Turner
         */
        _323212, 
        /**
         * Fitter-Welder
         */
        _323213, 
        /**
         * Metal Machinist (First Class)
         */
        _323214, 
        /**
         * Textile, Clothing and Footwear Mechanic
         */
        _323215, 
        /**
         * Metal Fitters and Machinists not elsewhere classified
         */
        _323299, 
        /**
         * Precision Metal Trades Workers not further defined
         */
        _323300, 
        /**
         * Engraver
         */
        _323311, 
        /**
         * Gunsmith
         */
        _323312, 
        /**
         * Locksmith
         */
        _323313, 
        /**
         * Precision Instrument Maker and Repairer
         */
        _323314, 
        /**
         * Saw Maker and Repairer
         */
        _323315, 
        /**
         * Watch and Clock Maker and Repairer
         */
        _323316, 
        /**
         * Toolmakers and Engineering Patternmakers not further defined
         */
        _323400, 
        /**
         * Engineering Patternmaker
         */
        _323411, 
        /**
         * Toolmaker
         */
        _323412, 
        /**
         * Panelbeaters, and Vehicle Body Builders, Trimmers and Painters not further defined
         */
        _324000, 
        /**
         * Panelbeater
         */
        _324111, 
        /**
         * Vehicle Body Builders and Trimmers not further defined
         */
        _324200, 
        /**
         * Vehicle Body Builder
         */
        _324211, 
        /**
         * Vehicle Trimmer
         */
        _324212, 
        /**
         * Vehicle Painter
         */
        _324311, 
        /**
         * Construction Trades Workers not further defined
         */
        _330000, 
        /**
         * Bricklayers, and Carpenters and Joiners not further defined
         */
        _331000, 
        /**
         * Bricklayers and Stonemasons not further defined
         */
        _331100, 
        /**
         * Bricklayer
         */
        _331111, 
        /**
         * Stonemason
         */
        _331112, 
        /**
         * Carpenter and Joiner
         */
        _331211, 
        /**
         * Carpenter
         */
        _331212, 
        /**
         * Joiner
         */
        _331213, 
        /**
         * Floor Finishers and Painting Trades Workers not further defined
         */
        _332000, 
        /**
         * Floor Finisher
         */
        _332111, 
        /**
         * Painting Trades Worker
         */
        _332211, 
        /**
         * Glaziers, Plasterers and Tilers not further defined
         */
        _333000, 
        /**
         * Glazier
         */
        _333111, 
        /**
         * Plasterers not further defined
         */
        _333200, 
        /**
         * Fibrous Plasterer
         */
        _333211, 
        /**
         * Solid Plasterer
         */
        _333212, 
        /**
         * Roof Tiler
         */
        _333311, 
        /**
         * Wall and Floor Tiler
         */
        _333411, 
        /**
         * Plumbers not further defined
         */
        _334100, 
        /**
         * Plumber (General)
         */
        _334111, 
        /**
         * Airconditioning and Mechanical Services Plumber
         */
        _334112, 
        /**
         * Drainer
         */
        _334113, 
        /**
         * Gasfitter
         */
        _334114, 
        /**
         * Roof Plumber
         */
        _334115, 
        /**
         * Electrotechnology and Telecommunications Trades Workers not further defined
         */
        _340000, 
        /**
         * Electricians not further defined
         */
        _341100, 
        /**
         * Electrician (General)
         */
        _341111, 
        /**
         * Electrician (Special Class)
         */
        _341112, 
        /**
         * Lift Mechanic
         */
        _341113, 
        /**
         * Electronics and Telecommunications Trades Workers not further defined
         */
        _342000, 
        /**
         * Airconditioning and Refrigeration Mechanic
         */
        _342111, 
        /**
         * Electrical Distribution Trades Workers not further defined
         */
        _342200, 
        /**
         * Electrical Linesworker
         */
        _342211, 
        /**
         * Technical Cable Jointer
         */
        _342212, 
        /**
         * Electronics Trades Workers not further defined
         */
        _342300, 
        /**
         * Business Machine Mechanic
         */
        _342311, 
        /**
         * Communications Operator
         */
        _342312, 
        /**
         * Electronic Equipment Trades Worker
         */
        _342313, 
        /**
         * Electronic Instrument Trades Worker (General)
         */
        _342314, 
        /**
         * Electronic Instrument Trades Worker (Special Class)
         */
        _342315, 
        /**
         * Telecommunications Trades Workers not further defined
         */
        _342400, 
        /**
         * Cabler (Data and Telecommunications)
         */
        _342411, 
        /**
         * Telecommunications Cable Jointer
         */
        _342412, 
        /**
         * Telecommunications Linesworker
         */
        _342413, 
        /**
         * Telecommunications Technician
         */
        _342414, 
        /**
         * Food Trades Workers not further defined
         */
        _351000, 
        /**
         * Bakers and Pastrycooks not further defined
         */
        _351100, 
        /**
         * Baker
         */
        _351111, 
        /**
         * Pastrycook
         */
        _351112, 
        /**
         * Butcher or Smallgoods Maker
         */
        _351211, 
        /**
         * Chef
         */
        _351311, 
        /**
         * Cook
         */
        _351411, 
        /**
         * Skilled Animal and Horticultural Workers not further defined
         */
        _360000, 
        /**
         * Animal Attendants and Trainers, and Shearers not further defined
         */
        _361000, 
        /**
         * Animal Attendants and Trainers not further defined
         */
        _361100, 
        /**
         * Dog Handler or Trainer
         */
        _361111, 
        /**
         * Horse Trainer
         */
        _361112, 
        /**
         * Pet Groomer
         */
        _361113, 
        /**
         * Zookeeper
         */
        _361114, 
        /**
         * Animal Attendants and Trainers not elsewhere classified
         */
        _361199, 
        /**
         * Shearer
         */
        _361211, 
        /**
         * Veterinary Nurse
         */
        _361311, 
        /**
         * Horticultural Trades Workers not further defined
         */
        _362000, 
        /**
         * Florist
         */
        _362111, 
        /**
         * Gardeners not further defined
         */
        _362200, 
        /**
         * Gardener (General)
         */
        _362211, 
        /**
         * Arborist
         */
        _362212, 
        /**
         * Landscape Gardener
         */
        _362213, 
        /**
         * Greenkeeper
         */
        _362311, 
        /**
         * Nurseryperson
         */
        _362411, 
        /**
         * Other Technicians and Trades Workers not further defined
         */
        _390000, 
        /**
         * Hairdresser
         */
        _391111, 
        /**
         * Printing Trades Workers not further defined
         */
        _392000, 
        /**
         * Binders, Finishers and Screen Printers not further defined
         */
        _392100, 
        /**
         * Binder and Finisher
         */
        _392111, 
        /**
         * Screen Printer
         */
        _392112, 
        /**
         * Graphic Pre-press Trades Worker
         */
        _392211, 
        /**
         * Printers not further defined
         */
        _392300, 
        /**
         * Printing Machinist
         */
        _392311, 
        /**
         * Small Offset Printer
         */
        _392312, 
        /**
         * Textile, Clothing and Footwear Trades Workers not further defined
         */
        _393000, 
        /**
         * Canvas and Leather Goods Makers not further defined
         */
        _393100, 
        /**
         * Canvas Goods Maker
         */
        _393111, 
        /**
         * Leather Goods Maker
         */
        _393112, 
        /**
         * Sail Maker
         */
        _393113, 
        /**
         * Shoemaker
         */
        _393114, 
        /**
         * Clothing Trades Workers not further defined
         */
        _393200, 
        /**
         * Apparel Cutter
         */
        _393211, 
        /**
         * Clothing Patternmaker
         */
        _393212, 
        /**
         * Dressmaker or Tailor
         */
        _393213, 
        /**
         * Clothing Trades Workers not elsewhere classified
         */
        _393299, 
        /**
         * Upholsterer
         */
        _393311, 
        /**
         * Wood Trades Workers not further defined
         */
        _394000, 
        /**
         * Cabinetmaker
         */
        _394111, 
        /**
         * Wood Machinists and Other Wood Trades Workers not further defined
         */
        _394200, 
        /**
         * Furniture Finisher
         */
        _394211, 
        /**
         * Picture Framer
         */
        _394212, 
        /**
         * Wood Machinist
         */
        _394213, 
        /**
         * Wood Turner
         */
        _394214, 
        /**
         * Wood Machinists and Other Wood Trades Workers not elsewhere classified
         */
        _394299, 
        /**
         * Miscellaneous Technicians and Trades Workers not further defined
         */
        _399000, 
        /**
         * Boat Builders and Shipwrights not further defined
         */
        _399100, 
        /**
         * Boat Builder and Repairer
         */
        _399111, 
        /**
         * Shipwright
         */
        _399112, 
        /**
         * Chemical, Gas, Petroleum and Power Generation Plant Operators not further defined
         */
        _399200, 
        /**
         * Chemical Plant Operator
         */
        _399211, 
        /**
         * Gas or Petroleum Operator
         */
        _399212, 
        /**
         * Power Generation Plant Operator
         */
        _399213, 
        /**
         * Gallery, Library and Museum Technicians not further defined
         */
        _399300, 
        /**
         * Gallery or Museum Technician
         */
        _399311, 
        /**
         * Library Technician
         */
        _399312, 
        /**
         * Jeweller
         */
        _399411, 
        /**
         * Performing Arts Technicians not further defined
         */
        _399500, 
        /**
         * Broadcast Transmitter Operator
         */
        _399511, 
        /**
         * Camera Operator (Film, Television or Video)
         */
        _399512, 
        /**
         * Light Technician
         */
        _399513, 
        /**
         * Make Up Artist
         */
        _399514, 
        /**
         * Musical Instrument Maker or Repairer
         */
        _399515, 
        /**
         * Sound Technician
         */
        _399516, 
        /**
         * Television Equipment Operator
         */
        _399517, 
        /**
         * Performing Arts Technicians not elsewhere classified
         */
        _399599, 
        /**
         * Signwriter
         */
        _399611, 
        /**
         * Other Miscellaneous Technicians and Trades Workers not further defined
         */
        _399900, 
        /**
         * Diver
         */
        _399911, 
        /**
         * Interior Decorator
         */
        _399912, 
        /**
         * Optical Dispenser
         */
        _399913, 
        /**
         * Optical Mechanic
         */
        _399914, 
        /**
         * Photographer's Assistant
         */
        _399915, 
        /**
         * Plastics Technician
         */
        _399916, 
        /**
         * Wool Classer
         */
        _399917, 
        /**
         * Technicians and Trades Workers not elsewhere classified
         */
        _399999, 
        /**
         * Community and Personal Service Workers not further defined
         */
        _400000, 
        /**
         * Health and Welfare Support Workers not further defined
         */
        _411000, 
        /**
         * Ambulance Officers and Paramedics not further defined
         */
        _411100, 
        /**
         * Ambulance Officer
         */
        _411111, 
        /**
         * Intensive Care Ambulance Paramedic
         */
        _411112, 
        /**
         * Dental Hygienists, Technicians and Therapists not further defined
         */
        _411200, 
        /**
         * Dental Hygienist
         */
        _411211, 
        /**
         * Dental Prosthetist
         */
        _411212, 
        /**
         * Dental Technician
         */
        _411213, 
        /**
         * Dental Therapist
         */
        _411214, 
        /**
         * Diversional Therapist
         */
        _411311, 
        /**
         * Enrolled and Mothercraft Nurses not further defined
         */
        _411400, 
        /**
         * Enrolled Nurse
         */
        _411411, 
        /**
         * Mothercraft Nurse
         */
        _411412, 
        /**
         * Aboriginal and Torres Strait Islander Health Worker
         */
        _411511, 
        /**
         * Massage Therapist
         */
        _411611, 
        /**
         * Welfare Support Workers not further defined
         */
        _411700, 
        /**
         * Community Worker
         */
        _411711, 
        /**
         * Disabilities Services Officer
         */
        _411712, 
        /**
         * Family Support Worker
         */
        _411713, 
        /**
         * Parole or Probation Officer
         */
        _411714, 
        /**
         * Residential Care Officer
         */
        _411715, 
        /**
         * Youth Worker
         */
        _411716, 
        /**
         * Carers and Aides not further defined
         */
        _420000, 
        /**
         * Child Carers not further defined
         */
        _421100, 
        /**
         * Child Care Worker
         */
        _421111, 
        /**
         * Family Day Care Worker
         */
        _421112, 
        /**
         * Nanny
         */
        _421113, 
        /**
         * Out of School Hours Care Worker
         */
        _421114, 
        /**
         * Education Aides not further defined
         */
        _422100, 
        /**
         * Aboriginal and Torres Strait Islander Education Worker
         */
        _422111, 
        /**
         * Integration Aide
         */
        _422112, 
        /**
         * Preschool Aide
         */
        _422115, 
        /**
         * Teachers' Aide
         */
        _422116, 
        /**
         * Personal Carers and Assistants not further defined
         */
        _423000, 
        /**
         * Aged or Disabled Carer
         */
        _423111, 
        /**
         * Dental Assistant
         */
        _423211, 
        /**
         * Nursing Support and Personal Care Workers not further defined
         */
        _423300, 
        /**
         * Hospital Orderly
         */
        _423311, 
        /**
         * Nursing Support Worker
         */
        _423312, 
        /**
         * Personal Care Assistant
         */
        _423313, 
        /**
         * Therapy Aide
         */
        _423314, 
        /**
         * Special Care Workers not further defined
         */
        _423400, 
        /**
         * Child or Youth Residential Care Assistant
         */
        _423411, 
        /**
         * Hostel Parent
         */
        _423412, 
        /**
         * Refuge Worker
         */
        _423413, 
        /**
         * Hospitality Workers not further defined
         */
        _431000, 
        /**
         * Bar Attendants and Baristas not further defined
         */
        _431100, 
        /**
         * Bar Attendant
         */
        _431111, 
        /**
         * Barista
         */
        _431112, 
        /**
         * Cafe Worker
         */
        _431211, 
        /**
         * Gaming Worker
         */
        _431311, 
        /**
         * Hotel Service Manager
         */
        _431411, 
        /**
         * Waiter
         */
        _431511, 
        /**
         * Other Hospitality Workers not further defined
         */
        _431900, 
        /**
         * Bar Useful or Busser
         */
        _431911, 
        /**
         * Doorperson or Luggage Porter
         */
        _431912, 
        /**
         * Hospitality Workers not elsewhere classified
         */
        _431999, 
        /**
         * Protective Service Workers not further defined
         */
        _440000, 
        /**
         * Defence Force Members, Fire Fighters and Police not further defined
         */
        _441000, 
        /**
         * Defence Force Member - Other Ranks
         */
        _441111, 
        /**
         * Fire and Emergency Workers not further defined
         */
        _441200, 
        /**
         * Emergency Service Worker
         */
        _441211, 
        /**
         * Fire Fighter
         */
        _441212, 
        /**
         * Police not further defined
         */
        _441300, 
        /**
         * Detective
         */
        _441311, 
        /**
         * Police Officer
         */
        _441312, 
        /**
         * Prison and Security Officers not further defined
         */
        _442000, 
        /**
         * Prison Officer
         */
        _442111, 
        /**
         * Security Officers and Guards not further defined
         */
        _442200, 
        /**
         * Alarm, Security or Surveillance Monitor
         */
        _442211, 
        /**
         * Armoured Car Escort
         */
        _442212, 
        /**
         * Crowd Controller
         */
        _442213, 
        /**
         * Private Investigator
         */
        _442214, 
        /**
         * Retail Loss Prevention Officer
         */
        _442215, 
        /**
         * Security Consultant
         */
        _442216, 
        /**
         * Security Officer
         */
        _442217, 
        /**
         * Security Officers and Guards not elsewhere classified
         */
        _442299, 
        /**
         * Sports and Personal Service Workers not further defined
         */
        _450000, 
        /**
         * Personal Service and Travel Workers not further defined
         */
        _451000, 
        /**
         * Beauty Therapist
         */
        _451111, 
        /**
         * Driving Instructor
         */
        _451211, 
        /**
         * Funeral Workers not further defined
         */
        _451300, 
        /**
         * Funeral Director
         */
        _451311, 
        /**
         * Funeral Workers not elsewhere classified
         */
        _451399, 
        /**
         * Gallery, Museum and Tour Guides not further defined
         */
        _451400, 
        /**
         * Gallery or Museum Guide
         */
        _451411, 
        /**
         * Tour Guide
         */
        _451412, 
        /**
         * Personal Care Consultants not further defined
         */
        _451500, 
        /**
         * Natural Remedy Consultant
         */
        _451511, 
        /**
         * Weight Loss Consultant
         */
        _451512, 
        /**
         * Tourism and Travel Advisers not further defined
         */
        _451600, 
        /**
         * Tourist Information Officer
         */
        _451611, 
        /**
         * Travel Consultant
         */
        _451612, 
        /**
         * Travel Attendants not further defined
         */
        _451700, 
        /**
         * Flight Attendant
         */
        _451711, 
        /**
         * Travel Attendants not elsewhere classified
         */
        _451799, 
        /**
         * Other Personal Service Workers not further defined
         */
        _451800, 
        /**
         * Civil Celebrant
         */
        _451811, 
        /**
         * Hair or Beauty Salon Assistant
         */
        _451812, 
        /**
         * Sex Worker or Escort
         */
        _451813, 
        /**
         * Personal Service Workers not elsewhere classified
         */
        _451899, 
        /**
         * Sports and Fitness Workers not further defined
         */
        _452000, 
        /**
         * Fitness Instructor
         */
        _452111, 
        /**
         * Outdoor Adventure Guides not further defined
         */
        _452200, 
        /**
         * Bungy Jump Master
         */
        _452211, 
        /**
         * Fishing Guide
         */
        _452212, 
        /**
         * Hunting Guide
         */
        _452213, 
        /**
         * Mountain or Glacier Guide
         */
        _452214, 
        /**
         * Outdoor Adventure Instructor
         */
        _452215, 
        /**
         * Trekking Guide
         */
        _452216, 
        /**
         * Whitewater Rafting Guide
         */
        _452217, 
        /**
         * Outdoor Adventure Guides not elsewhere classified
         */
        _452299, 
        /**
         * Sports Coaches, Instructors and Officials not further defined
         */
        _452300, 
        /**
         * Diving Instructor (Open Water)
         */
        _452311, 
        /**
         * Gymnastics Coach or Instructor
         */
        _452312, 
        /**
         * Horse Riding Coach or Instructor
         */
        _452313, 
        /**
         * Snowsport Instructor
         */
        _452314, 
        /**
         * Swimming Coach or Instructor
         */
        _452315, 
        /**
         * Tennis Coach
         */
        _452316, 
        /**
         * Other Sports Coach or Instructor
         */
        _452317, 
        /**
         * Dog or Horse Racing Official
         */
        _452318, 
        /**
         * Sports Development Officer
         */
        _452321, 
        /**
         * Sports Umpire
         */
        _452322, 
        /**
         * Other Sports Official
         */
        _452323, 
        /**
         * Sportspersons not further defined
         */
        _452400, 
        /**
         * Footballer
         */
        _452411, 
        /**
         * Golfer
         */
        _452412, 
        /**
         * Jockey
         */
        _452413, 
        /**
         * Lifeguard
         */
        _452414, 
        /**
         * Sportspersons not elsewhere classified
         */
        _452499, 
        /**
         * Clerical and Administrative Workers not further defined
         */
        _500000, 
        /**
         * Office Managers and Program Administrators not further defined
         */
        _510000, 
        /**
         * Contract, Program and Project Administrators not further defined
         */
        _511100, 
        /**
         * Contract Administrator
         */
        _511111, 
        /**
         * Program or Project Administrator
         */
        _511112, 
        /**
         * Office and Practice Managers not further defined
         */
        _512000, 
        /**
         * Office Manager
         */
        _512111, 
        /**
         * Practice Managers not further defined
         */
        _512200, 
        /**
         * Health Practice Manager
         */
        _512211, 
        /**
         * Practice Managers not elsewhere classified
         */
        _512299, 
        /**
         * Personal Assistants and Secretaries not further defined
         */
        _521000, 
        /**
         * Personal Assistant
         */
        _521111, 
        /**
         * Secretaries not further defined
         */
        _521200, 
        /**
         * Secretary (General)
         */
        _521211, 
        /**
         * Legal Secretary
         */
        _521212, 
        /**
         * General Clerical Workers not further defined
         */
        _530000, 
        /**
         * General Clerk
         */
        _531111, 
        /**
         * Keyboard Operators not further defined
         */
        _532100, 
        /**
         * Data Entry Operator
         */
        _532111, 
        /**
         * Machine Shorthand Reporter
         */
        _532112, 
        /**
         * Word Processing Operator
         */
        _532113, 
        /**
         * Inquiry Clerks and Receptionists not further defined
         */
        _540000, 
        /**
         * Call or Contact Centre Information Clerks not further defined
         */
        _541000, 
        /**
         * Call or Contact Centre Workers not further defined
         */
        _541100, 
        /**
         * Call or Contact Centre Team Leader
         */
        _541111, 
        /**
         * Call or Contact Centre Operator
         */
        _541112, 
        /**
         * Inquiry Clerk
         */
        _541211, 
        /**
         * Receptionists not further defined
         */
        _542100, 
        /**
         * Receptionist (General)
         */
        _542111, 
        /**
         * Admissions Clerk
         */
        _542112, 
        /**
         * Hotel or Motel Receptionist
         */
        _542113, 
        /**
         * Medical Receptionist
         */
        _542114, 
        /**
         * Numerical Clerks not further defined
         */
        _550000, 
        /**
         * Accounting Clerks and Bookkeepers not further defined
         */
        _551000, 
        /**
         * Accounting Clerks not further defined
         */
        _551100, 
        /**
         * Accounts Clerk
         */
        _551111, 
        /**
         * Cost Clerk
         */
        _551112, 
        /**
         * Bookkeeper
         */
        _551211, 
        /**
         * Payroll Clerk
         */
        _551311, 
        /**
         * Financial and Insurance Clerks not further defined
         */
        _552000, 
        /**
         * Bank Worker
         */
        _552111, 
        /**
         * Credit or Loans Officer
         */
        _552211, 
        /**
         * Insurance, Money Market and Statistical Clerks not further defined
         */
        _552300, 
        /**
         * Bookmaker
         */
        _552311, 
        /**
         * Insurance Consultant
         */
        _552312, 
        /**
         * Money Market Clerk
         */
        _552313, 
        /**
         * Statistical Clerk
         */
        _552314, 
        /**
         * Clerical and Office Support Workers not further defined
         */
        _561000, 
        /**
         * Betting Clerks not further defined
         */
        _561100, 
        /**
         * Betting Agency Counter Clerk
         */
        _561111, 
        /**
         * Bookmaker's Clerk
         */
        _561112, 
        /**
         * Telephone Betting Clerk
         */
        _561113, 
        /**
         * Betting Clerks not elsewhere classified
         */
        _561199, 
        /**
         * Couriers and Postal Deliverers not further defined
         */
        _561200, 
        /**
         * Courier
         */
        _561211, 
        /**
         * Postal Delivery Officer
         */
        _561212, 
        /**
         * Filing or Registry Clerk
         */
        _561311, 
        /**
         * Mail Sorters not further defined
         */
        _561400, 
        /**
         * Mail Clerk
         */
        _561411, 
        /**
         * Postal Sorting Officer
         */
        _561412, 
        /**
         * Survey Interviewer
         */
        _561511, 
        /**
         * Switchboard Operator
         */
        _561611, 
        /**
         * Other Clerical and Office Support Workers not further defined
         */
        _561900, 
        /**
         * Classified Advertising Clerk
         */
        _561911, 
        /**
         * Meter Reader
         */
        _561912, 
        /**
         * Parking Inspector
         */
        _561913, 
        /**
         * Clerical and Office Support Workers not elsewhere classified
         */
        _561999, 
        /**
         * Other Clerical and Administrative Workers not further defined
         */
        _590000, 
        /**
         * Logistics Clerks not further defined
         */
        _591000, 
        /**
         * Purchasing and Supply Logistics Clerks not further defined
         */
        _591100, 
        /**
         * Order Clerk
         */
        _591111, 
        /**
         * Production Clerk
         */
        _591112, 
        /**
         * Purchasing Officer
         */
        _591113, 
        /**
         * Sales Clerk
         */
        _591114, 
        /**
         * Stock Clerk
         */
        _591115, 
        /**
         * Warehouse Administrator
         */
        _591116, 
        /**
         * Transport and Despatch Clerks not further defined
         */
        _591200, 
        /**
         * Despatching and Receiving Clerk
         */
        _591211, 
        /**
         * Import-Export Clerk
         */
        _591212, 
        /**
         * Miscellaneous Clerical and Administrative Workers not further defined
         */
        _599000, 
        /**
         * Conveyancers and Legal Executives not further defined
         */
        _599100, 
        /**
         * Conveyancer
         */
        _599111, 
        /**
         * Legal Executive
         */
        _599112, 
        /**
         * Court and Legal Clerks not further defined
         */
        _599200, 
        /**
         * Clerk of Court
         */
        _599211, 
        /**
         * Court Bailiff or Sheriff
         */
        _599212, 
        /**
         * Court Orderly
         */
        _599213, 
        /**
         * Law Clerk
         */
        _599214, 
        /**
         * Trust Officer
         */
        _599215, 
        /**
         * Debt Collector
         */
        _599311, 
        /**
         * Human Resource Clerk
         */
        _599411, 
        /**
         * Inspectors and Regulatory Officers not further defined
         */
        _599500, 
        /**
         * Customs Officer
         */
        _599511, 
        /**
         * Immigration Officer
         */
        _599512, 
        /**
         * Motor Vehicle Licence Examiner
         */
        _599513, 
        /**
         * Noxious Weeds and Pest Inspector
         */
        _599514, 
        /**
         * Social Security Assessor
         */
        _599515, 
        /**
         * Taxation Inspector
         */
        _599516, 
        /**
         * Train Examiner
         */
        _599517, 
        /**
         * Transport Operations Inspector
         */
        _599518, 
        /**
         * Water Inspector
         */
        _599521, 
        /**
         * Inspectors and Regulatory Officers not elsewhere classified
         */
        _599599, 
        /**
         * Insurance Investigators, Loss Adjusters and Risk Surveyors not further defined
         */
        _599600, 
        /**
         * Insurance Investigator
         */
        _599611, 
        /**
         * Insurance Loss Adjuster
         */
        _599612, 
        /**
         * Insurance Risk Surveyor
         */
        _599613, 
        /**
         * Library Assistant
         */
        _599711, 
        /**
         * Other Miscellaneous Clerical and Administrative Workers not further defined
         */
        _599900, 
        /**
         * Coding Clerk
         */
        _599911, 
        /**
         * Production Assistant (Film, Television, Radio or Stage)
         */
        _599912, 
        /**
         * Proof Reader
         */
        _599913, 
        /**
         * Radio Despatcher
         */
        _599914, 
        /**
         * Clerical and Administrative Workers not elsewhere classified
         */
        _599999, 
        /**
         * Sales Workers not further defined
         */
        _600000, 
        /**
         * Sales Representatives and Agents not further defined
         */
        _610000, 
        /**
         * Insurance Agents and Sales Representatives not further defined
         */
        _611000, 
        /**
         * Auctioneers, and Stock and Station Agents not further defined
         */
        _611100, 
        /**
         * Auctioneer
         */
        _611111, 
        /**
         * Stock and Station Agent
         */
        _611112, 
        /**
         * Insurance Agent
         */
        _611211, 
        /**
         * Sales Representatives not further defined
         */
        _611300, 
        /**
         * Sales Representative (Building and Plumbing Supplies)
         */
        _611311, 
        /**
         * Sales Representative (Business Services)
         */
        _611312, 
        /**
         * Sales Representative (Motor Vehicle Parts and Accessories)
         */
        _611313, 
        /**
         * Sales Representative (Personal and Household Goods)
         */
        _611314, 
        /**
         * Sales Representatives not elsewhere classified
         */
        _611399, 
        /**
         * Real Estate Sales Agents not further defined
         */
        _612100, 
        /**
         * Business Broker
         */
        _612111, 
        /**
         * Property Manager
         */
        _612112, 
        /**
         * Real Estate Agency Principal
         */
        _612113, 
        /**
         * Real Estate Agent
         */
        _612114, 
        /**
         * Real Estate Representative
         */
        _612115, 
        /**
         * Sales Assistants and Salespersons not further defined
         */
        _621000, 
        /**
         * Sales Assistant (General)
         */
        _621111, 
        /**
         * ICT Sales Assistant
         */
        _621211, 
        /**
         * Motor Vehicle and Vehicle Parts Salespersons not further defined
         */
        _621300, 
        /**
         * Motor Vehicle or Caravan Salesperson
         */
        _621311, 
        /**
         * Motor Vehicle Parts Interpreter
         */
        _621312, 
        /**
         * Pharmacy Sales Assistant
         */
        _621411, 
        /**
         * Retail Supervisor
         */
        _621511, 
        /**
         * Service Station Attendant
         */
        _621611, 
        /**
         * Street Vendors and Related Salespersons not further defined
         */
        _621700, 
        /**
         * Cash Van Salesperson
         */
        _621711, 
        /**
         * Door-to-door Salesperson
         */
        _621712, 
        /**
         * Street Vendor
         */
        _621713, 
        /**
         * Other Sales Assistants and Salespersons not further defined
         */
        _621900, 
        /**
         * Materials Recycler
         */
        _621911, 
        /**
         * Rental Salesperson
         */
        _621912, 
        /**
         * Sales Assistants and Salespersons not elsewhere classified
         */
        _621999, 
        /**
         * Sales Support Workers not further defined
         */
        _630000, 
        /**
         * Checkout Operators and Office Cashiers not further defined
         */
        _631100, 
        /**
         * Checkout Operator
         */
        _631111, 
        /**
         * Office Cashier
         */
        _631112, 
        /**
         * Miscellaneous Sales Support Workers not further defined
         */
        _639000, 
        /**
         * Models and Sales Demonstrators not further defined
         */
        _639100, 
        /**
         * Model
         */
        _639111, 
        /**
         * Sales Demonstrator
         */
        _639112, 
        /**
         * Retail and Wool Buyers not further defined
         */
        _639200, 
        /**
         * Retail Buyer
         */
        _639211, 
        /**
         * Wool Buyer
         */
        _639212, 
        /**
         * Telemarketer
         */
        _639311, 
        /**
         * Ticket Salespersons not further defined
         */
        _639400, 
        /**
         * Ticket Seller
         */
        _639411, 
        /**
         * Transport Conductor
         */
        _639412, 
        /**
         * Visual Merchandiser
         */
        _639511, 
        /**
         * Other Sales Support Worker
         */
        _639911, 
        /**
         * Machinery Operators and Drivers not further defined
         */
        _700000, 
        /**
         * Machine and Stationary Plant Operators not further defined
         */
        _710000, 
        /**
         * Machine Operators not further defined
         */
        _711000, 
        /**
         * Clay, Concrete, Glass and Stone Processing Machine Operators not further defined
         */
        _711100, 
        /**
         * Clay Products Machine Operator
         */
        _711111, 
        /**
         * Concrete Products Machine Operator
         */
        _711112, 
        /**
         * Glass Production Machine Operator
         */
        _711113, 
        /**
         * Stone Processing Machine Operator
         */
        _711114, 
        /**
         * Clay, Concrete, Glass and Stone Processing Machine Operators not elsewhere classified
         */
        _711199, 
        /**
         * Industrial Spraypainter
         */
        _711211, 
        /**
         * Paper and Wood Processing Machine Operators not further defined
         */
        _711300, 
        /**
         * Paper Products Machine Operator
         */
        _711311, 
        /**
         * Wood Processing Machine Operator
         */
        _711312, 
        /**
         * Photographic Developer and Printer
         */
        _711411, 
        /**
         * Plastics and Rubber Production Machine Operators not further defined
         */
        _711500, 
        /**
         * Plastic Cablemaking Machine Operator
         */
        _711511, 
        /**
         * Plastic Compounding and Reclamation Machine Operator
         */
        _711512, 
        /**
         * Plastics Fabricator or Welder
         */
        _711513, 
        /**
         * Plastics Production Machine Operator (General)
         */
        _711514, 
        /**
         * Reinforced Plastic and Composite Production Worker
         */
        _711515, 
        /**
         * Rubber Production Machine Operator
         */
        _711516, 
        /**
         * Plastics and Rubber Production Machine Operators not elsewhere classified
         */
        _711599, 
        /**
         * Sewing Machinist
         */
        _711611, 
        /**
         * Textile and Footwear Production Machine Operators not further defined
         */
        _711700, 
        /**
         * Footwear Production Machine Operator
         */
        _711711, 
        /**
         * Hide and Skin Processing Machine Operator
         */
        _711712, 
        /**
         * Knitting Machine Operator
         */
        _711713, 
        /**
         * Textile Dyeing and Finishing Machine Operator
         */
        _711714, 
        /**
         * Weaving Machine Operator
         */
        _711715, 
        /**
         * Yarn Carding and Spinning Machine Operator
         */
        _711716, 
        /**
         * Textile and Footwear Production Machine Operators not elsewhere classified
         */
        _711799, 
        /**
         * Other Machine Operators not further defined
         */
        _711900, 
        /**
         * Chemical Production Machine Operator
         */
        _711911, 
        /**
         * Motion Picture Projectionist
         */
        _711912, 
        /**
         * Sand Blaster
         */
        _711913, 
        /**
         * Sterilisation Technician
         */
        _711914, 
        /**
         * Machine Operators not elsewhere classified
         */
        _711999, 
        /**
         * Stationary Plant Operators not further defined
         */
        _712000, 
        /**
         * Crane, Hoist or Lift Operator
         */
        _712111, 
        /**
         * Drillers, Miners and Shot Firers not further defined
         */
        _712200, 
        /**
         * Driller
         */
        _712211, 
        /**
         * Miner
         */
        _712212, 
        /**
         * Shot Firer
         */
        _712213, 
        /**
         * Engineering Production Systems Worker
         */
        _712311, 
        /**
         * Other Stationary Plant Operators not further defined
         */
        _712900, 
        /**
         * Boiler or Engine Operator
         */
        _712911, 
        /**
         * Bulk Materials Handling Plant Operator
         */
        _712912, 
        /**
         * Cement Production Plant Operator
         */
        _712913, 
        /**
         * Concrete Batching Plant Operator
         */
        _712914, 
        /**
         * Concrete Pump Operator
         */
        _712915, 
        /**
         * Paper and Pulp Mill Operator
         */
        _712916, 
        /**
         * Railway Signal Operator
         */
        _712917, 
        /**
         * Train Controller
         */
        _712918, 
        /**
         * Waste Water or Water Plant Operator
         */
        _712921, 
        /**
         * Weighbridge Operator
         */
        _712922, 
        /**
         * Stationary Plant Operators not elsewhere classified
         */
        _712999, 
        /**
         * Mobile Plant Operators not further defined
         */
        _721000, 
        /**
         * Agricultural, Forestry and Horticultural Plant Operators not further defined
         */
        _721100, 
        /**
         * Agricultural and Horticultural Mobile Plant Operator
         */
        _721111, 
        /**
         * Logging Plant Operator
         */
        _721112, 
        /**
         * Earthmoving Plant Operators not further defined
         */
        _721200, 
        /**
         * Earthmoving Plant Operator (General)
         */
        _721211, 
        /**
         * Backhoe Operator
         */
        _721212, 
        /**
         * Bulldozer Operator
         */
        _721213, 
        /**
         * Excavator Operator
         */
        _721214, 
        /**
         * Grader Operator
         */
        _721215, 
        /**
         * Loader Operator
         */
        _721216, 
        /**
         * Forklift Driver
         */
        _721311, 
        /**
         * Other Mobile Plant Operators not further defined
         */
        _721900, 
        /**
         * Aircraft Baggage Handler and Airline Ground Crew
         */
        _721911, 
        /**
         * Linemarker
         */
        _721912, 
        /**
         * Paving Plant Operator
         */
        _721913, 
        /**
         * Railway Track Plant Operator
         */
        _721914, 
        /**
         * Road Roller Operator
         */
        _721915, 
        /**
         * Streetsweeper Operator
         */
        _721916, 
        /**
         * Mobile Plant Operators not elsewhere classified
         */
        _721999, 
        /**
         * Road and Rail Drivers not further defined
         */
        _730000, 
        /**
         * Automobile, Bus and Rail Drivers not further defined
         */
        _731000, 
        /**
         * Automobile Drivers not further defined
         */
        _731100, 
        /**
         * Chauffeur
         */
        _731111, 
        /**
         * Taxi Driver
         */
        _731112, 
        /**
         * Automobile Drivers not elsewhere classified
         */
        _731199, 
        /**
         * Bus and Coach Drivers not further defined
         */
        _731200, 
        /**
         * Bus Driver
         */
        _731211, 
        /**
         * Charter and Tour Bus Driver
         */
        _731212, 
        /**
         * Passenger Coach Driver
         */
        _731213, 
        /**
         * Train and Tram Drivers not further defined
         */
        _731300, 
        /**
         * Train Driver
         */
        _731311, 
        /**
         * Tram Driver
         */
        _731312, 
        /**
         * Delivery Driver
         */
        _732111, 
        /**
         * Truck Drivers not further defined
         */
        _733100, 
        /**
         * Truck Driver (General)
         */
        _733111, 
        /**
         * Aircraft Refueller
         */
        _733112, 
        /**
         * Furniture Removalist
         */
        _733113, 
        /**
         * Tanker Driver
         */
        _733114, 
        /**
         * Tow Truck Driver
         */
        _733115, 
        /**
         * Storeperson
         */
        _741111, 
        /**
         * Labourers not further defined
         */
        _800000, 
        /**
         * Cleaners and Laundry Workers not further defined
         */
        _811000, 
        /**
         * Car Detailer
         */
        _811111, 
        /**
         * Commercial Cleaner
         */
        _811211, 
        /**
         * Domestic Cleaner
         */
        _811311, 
        /**
         * Housekeepers not further defined
         */
        _811400, 
        /**
         * Commercial Housekeeper
         */
        _811411, 
        /**
         * Domestic Housekeeper
         */
        _811412, 
        /**
         * Laundry Workers not further defined
         */
        _811500, 
        /**
         * Laundry Worker (General)
         */
        _811511, 
        /**
         * Drycleaner
         */
        _811512, 
        /**
         * Ironer or Presser
         */
        _811513, 
        /**
         * Other Cleaners not further defined
         */
        _811600, 
        /**
         * Carpet Cleaner
         */
        _811611, 
        /**
         * Window Cleaner
         */
        _811612, 
        /**
         * Cleaners not elsewhere classified
         */
        _811699, 
        /**
         * Construction and Mining Labourers not further defined
         */
        _821000, 
        /**
         * Building and Plumbing Labourers not further defined
         */
        _821100, 
        /**
         * Builder's Labourer
         */
        _821111, 
        /**
         * Drainage, Sewerage and Stormwater Labourer
         */
        _821112, 
        /**
         * Earthmoving Labourer
         */
        _821113, 
        /**
         * Plumber's Assistant
         */
        _821114, 
        /**
         * Concreter
         */
        _821211, 
        /**
         * Fencer
         */
        _821311, 
        /**
         * Insulation and Home Improvement Installers not further defined
         */
        _821400, 
        /**
         * Building Insulation Installer
         */
        _821411, 
        /**
         * Home Improvement Installer
         */
        _821412, 
        /**
         * Paving and Surfacing Labourer
         */
        _821511, 
        /**
         * Railway Track Worker
         */
        _821611, 
        /**
         * Structural Steel Construction Workers not further defined
         */
        _821700, 
        /**
         * Construction Rigger
         */
        _821711, 
        /**
         * Scaffolder
         */
        _821712, 
        /**
         * Steel Fixer
         */
        _821713, 
        /**
         * Structural Steel Erector
         */
        _821714, 
        /**
         * Other Construction and Mining Labourers not further defined
         */
        _821900, 
        /**
         * Crane Chaser
         */
        _821911, 
        /**
         * Driller's Assistant
         */
        _821912, 
        /**
         * Lagger
         */
        _821913, 
        /**
         * Mining Support Worker
         */
        _821914, 
        /**
         * Surveyor's Assistant
         */
        _821915, 
        /**
         * Factory Process Workers not further defined
         */
        _830000, 
        /**
         * Food Process Workers not further defined
         */
        _831000, 
        /**
         * Food and Drink Factory Workers not further defined
         */
        _831100, 
        /**
         * Baking Factory Worker
         */
        _831111, 
        /**
         * Brewery Worker
         */
        _831112, 
        /**
         * Confectionery Maker
         */
        _831113, 
        /**
         * Dairy Products Maker
         */
        _831114, 
        /**
         * Fruit and Vegetable Factory Worker
         */
        _831115, 
        /**
         * Grain Mill Worker
         */
        _831116, 
        /**
         * Sugar Mill Worker
         */
        _831117, 
        /**
         * Winery Cellar Hand
         */
        _831118, 
        /**
         * Food and Drink Factory Workers not elsewhere classified
         */
        _831199, 
        /**
         * Meat Boners and Slicers, and Slaughterers not further defined
         */
        _831200, 
        /**
         * Meat Boner and Slicer
         */
        _831211, 
        /**
         * Slaughterer
         */
        _831212, 
        /**
         * Meat, Poultry and Seafood Process Workers not further defined
         */
        _831300, 
        /**
         * Meat Process Worker
         */
        _831311, 
        /**
         * Poultry Process Worker
         */
        _831312, 
        /**
         * Seafood Process Worker
         */
        _831313, 
        /**
         * Packers and Product Assemblers not further defined
         */
        _832000, 
        /**
         * Packers not further defined
         */
        _832100, 
        /**
         * Chocolate Packer
         */
        _832111, 
        /**
         * Container Filler
         */
        _832112, 
        /**
         * Fruit and Vegetable Packer
         */
        _832113, 
        /**
         * Meat Packer
         */
        _832114, 
        /**
         * Seafood Packer
         */
        _832115, 
        /**
         * Packers not elsewhere classified
         */
        _832199, 
        /**
         * Product Assembler
         */
        _832211, 
        /**
         * Miscellaneous Factory Process Workers not further defined
         */
        _839000, 
        /**
         * Metal Engineering Process Worker
         */
        _839111, 
        /**
         * Plastics and Rubber Factory Workers not further defined
         */
        _839200, 
        /**
         * Plastics Factory Worker
         */
        _839211, 
        /**
         * Rubber Factory Worker
         */
        _839212, 
        /**
         * Product Quality Controllers not further defined
         */
        _839300, 
        /**
         * Product Examiner
         */
        _839311, 
        /**
         * Product Grader
         */
        _839312, 
        /**
         * Product Tester
         */
        _839313, 
        /**
         * Timber and Wood Process Workers not further defined
         */
        _839400, 
        /**
         * Paper and Pulp Mill Worker
         */
        _839411, 
        /**
         * Sawmill or Timber Yard Worker
         */
        _839412, 
        /**
         * Wood and Wood Products Factory Worker
         */
        _839413, 
        /**
         * Other Factory Process Workers not further defined
         */
        _839900, 
        /**
         * Cement and Concrete Plant Worker
         */
        _839911, 
        /**
         * Chemical Plant Worker
         */
        _839912, 
        /**
         * Clay Processing Factory Worker
         */
        _839913, 
        /**
         * Fabric and Textile Factory Worker
         */
        _839914, 
        /**
         * Footwear Factory Worker
         */
        _839915, 
        /**
         * Glass Processing Worker
         */
        _839916, 
        /**
         * Hide and Skin Processing Worker
         */
        _839917, 
        /**
         * Factory Process Workers not elsewhere classified
         */
        _839999, 
        /**
         * Farm, Forestry and Garden Workers not further defined
         */
        _841000, 
        /**
         * Aquaculture Worker
         */
        _841111, 
        /**
         * Crop Farm Workers not further defined
         */
        _841200, 
        /**
         * Fruit or Nut Farm Worker
         */
        _841211, 
        /**
         * Fruit or Nut Picker
         */
        _841212, 
        /**
         * Grain, Oilseed or Pasture Farm Worker
         */
        _841213, 
        /**
         * Vegetable Farm Worker
         */
        _841214, 
        /**
         * Vegetable Picker
         */
        _841215, 
        /**
         * Vineyard Worker
         */
        _841216, 
        /**
         * Crop Farm Workers not elsewhere classified
         */
        _841299, 
        /**
         * Forestry and Logging Workers not further defined
         */
        _841300, 
        /**
         * Forestry Worker
         */
        _841311, 
        /**
         * Logging Assistant
         */
        _841312, 
        /**
         * Tree Faller
         */
        _841313, 
        /**
         * Garden and Nursery Labourers not further defined
         */
        _841400, 
        /**
         * Garden Labourer
         */
        _841411, 
        /**
         * Horticultural Nursery Assistant
         */
        _841412, 
        /**
         * Livestock Farm Workers not further defined
         */
        _841500, 
        /**
         * Beef Cattle Farm Worker
         */
        _841511, 
        /**
         * Dairy Cattle Farm Worker
         */
        _841512, 
        /**
         * Mixed Livestock Farm Worker
         */
        _841513, 
        /**
         * Poultry Farm Worker
         */
        _841514, 
        /**
         * Sheep Farm Worker
         */
        _841515, 
        /**
         * Stablehand
         */
        _841516, 
        /**
         * Wool Handler
         */
        _841517, 
        /**
         * Livestock Farm Workers not elsewhere classified
         */
        _841599, 
        /**
         * Mixed Crop and Livestock Farm Worker
         */
        _841611, 
        /**
         * Other Farm, Forestry and Garden Workers not further defined
         */
        _841900, 
        /**
         * Hunter-Trapper
         */
        _841911, 
        /**
         * Pest or Weed Controller
         */
        _841912, 
        /**
         * Farm, Forestry and Garden Workers not elsewhere classified
         */
        _841999, 
        /**
         * Food Preparation Assistants not further defined
         */
        _851000, 
        /**
         * Fast Food Cook
         */
        _851111, 
        /**
         * Food Trades Assistants not further defined
         */
        _851200, 
        /**
         * Pastrycook's Assistant
         */
        _851211, 
        /**
         * Food Trades Assistants not elsewhere classified
         */
        _851299, 
        /**
         * Kitchenhand
         */
        _851311, 
        /**
         * Other Labourers not further defined
         */
        _890000, 
        /**
         * Freight Handlers and Shelf Fillers not further defined
         */
        _891000, 
        /**
         * Freight and Furniture Handlers not further defined
         */
        _891100, 
        /**
         * Freight Handler (Rail or Road)
         */
        _891111, 
        /**
         * Truck Driver's Offsider
         */
        _891112, 
        /**
         * Waterside Worker
         */
        _891113, 
        /**
         * Shelf Filler
         */
        _891211, 
        /**
         * Miscellaneous Labourers not further defined
         */
        _899000, 
        /**
         * Caretaker
         */
        _899111, 
        /**
         * Deck and Fishing Hands not further defined
         */
        _899200, 
        /**
         * Deck Hand
         */
        _899211, 
        /**
         * Fishing Hand
         */
        _899212, 
        /**
         * Handyperson
         */
        _899311, 
        /**
         * Motor Vehicle Parts and Accessories Fitters not further defined
         */
        _899400, 
        /**
         * Motor Vehicle Parts and Accessories Fitter (General)
         */
        _899411, 
        /**
         * Autoglazier
         */
        _899412, 
        /**
         * Exhaust and Muffler Fitter
         */
        _899413, 
        /**
         * Radiator Fitter
         */
        _899414, 
        /**
         * Tyre Fitter
         */
        _899415, 
        /**
         * Printing Assistants and Table Workers not further defined
         */
        _899500, 
        /**
         * Printer's Assistant
         */
        _899511, 
        /**
         * Printing Table Worker
         */
        _899512, 
        /**
         * Recycling or Rubbish Collector
         */
        _899611, 
        /**
         * Vending Machine Attendant
         */
        _899711, 
        /**
         * Other Miscellaneous Labourers not further defined
         */
        _899900, 
        /**
         * Bicycle Mechanic
         */
        _899911, 
        /**
         * Car Park Attendant
         */
        _899912, 
        /**
         * Crossing Supervisor
         */
        _899913, 
        /**
         * Electrical or Telecommunications Trades Assistant
         */
        _899914, 
        /**
         * Leaflet or Newspaper Deliverer
         */
        _899915, 
        /**
         * Mechanic's Assistant
         */
        _899916, 
        /**
         * Railways Assistant
         */
        _899917, 
        /**
         * Sign Erector
         */
        _899918, 
        /**
         * Ticket Collector or Usher
         */
        _899921, 
        /**
         * Trolley Collector
         */
        _899922, 
        /**
         * Labourers not elsewhere classified
         */
        _899999, 
        /**
         * added to help the parsers
         */
        NULL;
        public static AnzscoOccupations fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString))
                return null;
        if ("100000".equals(codeString))
          return _100000;
        if ("111000".equals(codeString))
          return _111000;
        if ("111111".equals(codeString))
          return _111111;
        if ("111200".equals(codeString))
          return _111200;
        if ("111211".equals(codeString))
          return _111211;
        if ("111212".equals(codeString))
          return _111212;
        if ("111300".equals(codeString))
          return _111300;
        if ("111311".equals(codeString))
          return _111311;
        if ("111312".equals(codeString))
          return _111312;
        if ("111399".equals(codeString))
          return _111399;
        if ("121000".equals(codeString))
          return _121000;
        if ("121111".equals(codeString))
          return _121111;
        if ("121200".equals(codeString))
          return _121200;
        if ("121211".equals(codeString))
          return _121211;
        if ("121212".equals(codeString))
          return _121212;
        if ("121213".equals(codeString))
          return _121213;
        if ("121214".equals(codeString))
          return _121214;
        if ("121215".equals(codeString))
          return _121215;
        if ("121216".equals(codeString))
          return _121216;
        if ("121217".equals(codeString))
          return _121217;
        if ("121218".equals(codeString))
          return _121218;
        if ("121221".equals(codeString))
          return _121221;
        if ("121299".equals(codeString))
          return _121299;
        if ("121300".equals(codeString))
          return _121300;
        if ("121311".equals(codeString))
          return _121311;
        if ("121312".equals(codeString))
          return _121312;
        if ("121313".equals(codeString))
          return _121313;
        if ("121314".equals(codeString))
          return _121314;
        if ("121315".equals(codeString))
          return _121315;
        if ("121316".equals(codeString))
          return _121316;
        if ("121317".equals(codeString))
          return _121317;
        if ("121318".equals(codeString))
          return _121318;
        if ("121321".equals(codeString))
          return _121321;
        if ("121322".equals(codeString))
          return _121322;
        if ("121399".equals(codeString))
          return _121399;
        if ("121411".equals(codeString))
          return _121411;
        if ("130000".equals(codeString))
          return _130000;
        if ("131100".equals(codeString))
          return _131100;
        if ("131111".equals(codeString))
          return _131111;
        if ("131112".equals(codeString))
          return _131112;
        if ("132000".equals(codeString))
          return _132000;
        if ("132111".equals(codeString))
          return _132111;
        if ("132211".equals(codeString))
          return _132211;
        if ("132311".equals(codeString))
          return _132311;
        if ("132411".equals(codeString))
          return _132411;
        if ("132511".equals(codeString))
          return _132511;
        if ("133000".equals(codeString))
          return _133000;
        if ("133100".equals(codeString))
          return _133100;
        if ("133111".equals(codeString))
          return _133111;
        if ("133112".equals(codeString))
          return _133112;
        if ("133211".equals(codeString))
          return _133211;
        if ("133300".equals(codeString))
          return _133300;
        if ("133311".equals(codeString))
          return _133311;
        if ("133312".equals(codeString))
          return _133312;
        if ("133411".equals(codeString))
          return _133411;
        if ("133500".equals(codeString))
          return _133500;
        if ("133511".equals(codeString))
          return _133511;
        if ("133512".equals(codeString))
          return _133512;
        if ("133513".equals(codeString))
          return _133513;
        if ("133611".equals(codeString))
          return _133611;
        if ("134000".equals(codeString))
          return _134000;
        if ("134111".equals(codeString))
          return _134111;
        if ("134200".equals(codeString))
          return _134200;
        if ("134211".equals(codeString))
          return _134211;
        if ("134212".equals(codeString))
          return _134212;
        if ("134213".equals(codeString))
          return _134213;
        if ("134214".equals(codeString))
          return _134214;
        if ("134299".equals(codeString))
          return _134299;
        if ("134311".equals(codeString))
          return _134311;
        if ("134400".equals(codeString))
          return _134400;
        if ("134411".equals(codeString))
          return _134411;
        if ("134412".equals(codeString))
          return _134412;
        if ("134499".equals(codeString))
          return _134499;
        if ("135100".equals(codeString))
          return _135100;
        if ("135111".equals(codeString))
          return _135111;
        if ("135112".equals(codeString))
          return _135112;
        if ("135199".equals(codeString))
          return _135199;
        if ("139000".equals(codeString))
          return _139000;
        if ("139100".equals(codeString))
          return _139100;
        if ("139111".equals(codeString))
          return _139111;
        if ("139112".equals(codeString))
          return _139112;
        if ("139113".equals(codeString))
          return _139113;
        if ("139211".equals(codeString))
          return _139211;
        if ("139900".equals(codeString))
          return _139900;
        if ("139911".equals(codeString))
          return _139911;
        if ("139912".equals(codeString))
          return _139912;
        if ("139913".equals(codeString))
          return _139913;
        if ("139914".equals(codeString))
          return _139914;
        if ("139915".equals(codeString))
          return _139915;
        if ("139999".equals(codeString))
          return _139999;
        if ("140000".equals(codeString))
          return _140000;
        if ("141000".equals(codeString))
          return _141000;
        if ("141111".equals(codeString))
          return _141111;
        if ("141211".equals(codeString))
          return _141211;
        if ("141311".equals(codeString))
          return _141311;
        if ("141411".equals(codeString))
          return _141411;
        if ("141900".equals(codeString))
          return _141900;
        if ("141911".equals(codeString))
          return _141911;
        if ("141999".equals(codeString))
          return _141999;
        if ("142100".equals(codeString))
          return _142100;
        if ("142111".equals(codeString))
          return _142111;
        if ("142112".equals(codeString))
          return _142112;
        if ("142113".equals(codeString))
          return _142113;
        if ("142114".equals(codeString))
          return _142114;
        if ("142115".equals(codeString))
          return _142115;
        if ("142116".equals(codeString))
          return _142116;
        if ("149000".equals(codeString))
          return _149000;
        if ("149100".equals(codeString))
          return _149100;
        if ("149111".equals(codeString))
          return _149111;
        if ("149112".equals(codeString))
          return _149112;
        if ("149113".equals(codeString))
          return _149113;
        if ("149200".equals(codeString))
          return _149200;
        if ("149211".equals(codeString))
          return _149211;
        if ("149212".equals(codeString))
          return _149212;
        if ("149311".equals(codeString))
          return _149311;
        if ("149400".equals(codeString))
          return _149400;
        if ("149411".equals(codeString))
          return _149411;
        if ("149412".equals(codeString))
          return _149412;
        if ("149413".equals(codeString))
          return _149413;
        if ("149900".equals(codeString))
          return _149900;
        if ("149911".equals(codeString))
          return _149911;
        if ("149912".equals(codeString))
          return _149912;
        if ("149913".equals(codeString))
          return _149913;
        if ("149914".equals(codeString))
          return _149914;
        if ("149999".equals(codeString))
          return _149999;
        if ("200000".equals(codeString))
          return _200000;
        if ("210000".equals(codeString))
          return _210000;
        if ("211000".equals(codeString))
          return _211000;
        if ("211100".equals(codeString))
          return _211100;
        if ("211111".equals(codeString))
          return _211111;
        if ("211112".equals(codeString))
          return _211112;
        if ("211113".equals(codeString))
          return _211113;
        if ("211199".equals(codeString))
          return _211199;
        if ("211200".equals(codeString))
          return _211200;
        if ("211211".equals(codeString))
          return _211211;
        if ("211212".equals(codeString))
          return _211212;
        if ("211213".equals(codeString))
          return _211213;
        if ("211214".equals(codeString))
          return _211214;
        if ("211299".equals(codeString))
          return _211299;
        if ("211311".equals(codeString))
          return _211311;
        if ("211400".equals(codeString))
          return _211400;
        if ("211411".equals(codeString))
          return _211411;
        if ("211412".equals(codeString))
          return _211412;
        if ("211413".equals(codeString))
          return _211413;
        if ("211499".equals(codeString))
          return _211499;
        if ("212000".equals(codeString))
          return _212000;
        if ("212100".equals(codeString))
          return _212100;
        if ("212111".equals(codeString))
          return _212111;
        if ("212112".equals(codeString))
          return _212112;
        if ("212113".equals(codeString))
          return _212113;
        if ("212114".equals(codeString))
          return _212114;
        if ("212200".equals(codeString))
          return _212200;
        if ("212211".equals(codeString))
          return _212211;
        if ("212212".equals(codeString))
          return _212212;
        if ("212300".equals(codeString))
          return _212300;
        if ("212311".equals(codeString))
          return _212311;
        if ("212312".equals(codeString))
          return _212312;
        if ("212313".equals(codeString))
          return _212313;
        if ("212314".equals(codeString))
          return _212314;
        if ("212315".equals(codeString))
          return _212315;
        if ("212316".equals(codeString))
          return _212316;
        if ("212317".equals(codeString))
          return _212317;
        if ("212318".equals(codeString))
          return _212318;
        if ("212399".equals(codeString))
          return _212399;
        if ("212400".equals(codeString))
          return _212400;
        if ("212411".equals(codeString))
          return _212411;
        if ("212412".equals(codeString))
          return _212412;
        if ("212413".equals(codeString))
          return _212413;
        if ("212414".equals(codeString))
          return _212414;
        if ("212415".equals(codeString))
          return _212415;
        if ("212416".equals(codeString))
          return _212416;
        if ("212499".equals(codeString))
          return _212499;
        if ("220000".equals(codeString))
          return _220000;
        if ("221000".equals(codeString))
          return _221000;
        if ("221100".equals(codeString))
          return _221100;
        if ("221111".equals(codeString))
          return _221111;
        if ("221112".equals(codeString))
          return _221112;
        if ("221113".equals(codeString))
          return _221113;
        if ("221200".equals(codeString))
          return _221200;
        if ("221211".equals(codeString))
          return _221211;
        if ("221212".equals(codeString))
          return _221212;
        if ("221213".equals(codeString))
          return _221213;
        if ("221214".equals(codeString))
          return _221214;
        if ("222000".equals(codeString))
          return _222000;
        if ("222100".equals(codeString))
          return _222100;
        if ("222111".equals(codeString))
          return _222111;
        if ("222112".equals(codeString))
          return _222112;
        if ("222113".equals(codeString))
          return _222113;
        if ("222199".equals(codeString))
          return _222199;
        if ("222200".equals(codeString))
          return _222200;
        if ("222211".equals(codeString))
          return _222211;
        if ("222212".equals(codeString))
          return _222212;
        if ("222213".equals(codeString))
          return _222213;
        if ("222299".equals(codeString))
          return _222299;
        if ("222300".equals(codeString))
          return _222300;
        if ("222311".equals(codeString))
          return _222311;
        if ("222312".equals(codeString))
          return _222312;
        if ("223000".equals(codeString))
          return _223000;
        if ("223100".equals(codeString))
          return _223100;
        if ("223111".equals(codeString))
          return _223111;
        if ("223112".equals(codeString))
          return _223112;
        if ("223113".equals(codeString))
          return _223113;
        if ("223211".equals(codeString))
          return _223211;
        if ("223311".equals(codeString))
          return _223311;
        if ("224000".equals(codeString))
          return _224000;
        if ("224100".equals(codeString))
          return _224100;
        if ("224111".equals(codeString))
          return _224111;
        if ("224112".equals(codeString))
          return _224112;
        if ("224113".equals(codeString))
          return _224113;
        if ("224200".equals(codeString))
          return _224200;
        if ("224211".equals(codeString))
          return _224211;
        if ("224212".equals(codeString))
          return _224212;
        if ("224213".equals(codeString))
          return _224213;
        if ("224214".equals(codeString))
          return _224214;
        if ("224311".equals(codeString))
          return _224311;
        if ("224400".equals(codeString))
          return _224400;
        if ("224411".equals(codeString))
          return _224411;
        if ("224412".equals(codeString))
          return _224412;
        if ("224500".equals(codeString))
          return _224500;
        if ("224511".equals(codeString))
          return _224511;
        if ("224512".equals(codeString))
          return _224512;
        if ("224611".equals(codeString))
          return _224611;
        if ("224700".equals(codeString))
          return _224700;
        if ("224711".equals(codeString))
          return _224711;
        if ("224712".equals(codeString))
          return _224712;
        if ("224900".equals(codeString))
          return _224900;
        if ("224911".equals(codeString))
          return _224911;
        if ("224912".equals(codeString))
          return _224912;
        if ("224913".equals(codeString))
          return _224913;
        if ("224914".equals(codeString))
          return _224914;
        if ("224999".equals(codeString))
          return _224999;
        if ("225000".equals(codeString))
          return _225000;
        if ("225100".equals(codeString))
          return _225100;
        if ("225111".equals(codeString))
          return _225111;
        if ("225112".equals(codeString))
          return _225112;
        if ("225113".equals(codeString))
          return _225113;
        if ("225200".equals(codeString))
          return _225200;
        if ("225211".equals(codeString))
          return _225211;
        if ("225212".equals(codeString))
          return _225212;
        if ("225213".equals(codeString))
          return _225213;
        if ("225311".equals(codeString))
          return _225311;
        if ("225400".equals(codeString))
          return _225400;
        if ("225411".equals(codeString))
          return _225411;
        if ("225412".equals(codeString))
          return _225412;
        if ("225499".equals(codeString))
          return _225499;
        if ("230000".equals(codeString))
          return _230000;
        if ("231000".equals(codeString))
          return _231000;
        if ("231100".equals(codeString))
          return _231100;
        if ("231111".equals(codeString))
          return _231111;
        if ("231112".equals(codeString))
          return _231112;
        if ("231113".equals(codeString))
          return _231113;
        if ("231114".equals(codeString))
          return _231114;
        if ("231199".equals(codeString))
          return _231199;
        if ("231200".equals(codeString))
          return _231200;
        if ("231211".equals(codeString))
          return _231211;
        if ("231212".equals(codeString))
          return _231212;
        if ("231213".equals(codeString))
          return _231213;
        if ("231214".equals(codeString))
          return _231214;
        if ("231215".equals(codeString))
          return _231215;
        if ("231299".equals(codeString))
          return _231299;
        if ("232000".equals(codeString))
          return _232000;
        if ("232100".equals(codeString))
          return _232100;
        if ("232111".equals(codeString))
          return _232111;
        if ("232112".equals(codeString))
          return _232112;
        if ("232200".equals(codeString))
          return _232200;
        if ("232211".equals(codeString))
          return _232211;
        if ("232212".equals(codeString))
          return _232212;
        if ("232300".equals(codeString))
          return _232300;
        if ("232311".equals(codeString))
          return _232311;
        if ("232312".equals(codeString))
          return _232312;
        if ("232313".equals(codeString))
          return _232313;
        if ("232400".equals(codeString))
          return _232400;
        if ("232411".equals(codeString))
          return _232411;
        if ("232412".equals(codeString))
          return _232412;
        if ("232413".equals(codeString))
          return _232413;
        if ("232414".equals(codeString))
          return _232414;
        if ("232511".equals(codeString))
          return _232511;
        if ("232611".equals(codeString))
          return _232611;
        if ("233000".equals(codeString))
          return _233000;
        if ("233100".equals(codeString))
          return _233100;
        if ("233111".equals(codeString))
          return _233111;
        if ("233112".equals(codeString))
          return _233112;
        if ("233200".equals(codeString))
          return _233200;
        if ("233211".equals(codeString))
          return _233211;
        if ("233212".equals(codeString))
          return _233212;
        if ("233213".equals(codeString))
          return _233213;
        if ("233214".equals(codeString))
          return _233214;
        if ("233215".equals(codeString))
          return _233215;
        if ("233311".equals(codeString))
          return _233311;
        if ("233411".equals(codeString))
          return _233411;
        if ("233500".equals(codeString))
          return _233500;
        if ("233511".equals(codeString))
          return _233511;
        if ("233512".equals(codeString))
          return _233512;
        if ("233513".equals(codeString))
          return _233513;
        if ("233600".equals(codeString))
          return _233600;
        if ("233611".equals(codeString))
          return _233611;
        if ("233612".equals(codeString))
          return _233612;
        if ("233900".equals(codeString))
          return _233900;
        if ("233911".equals(codeString))
          return _233911;
        if ("233912".equals(codeString))
          return _233912;
        if ("233913".equals(codeString))
          return _233913;
        if ("233914".equals(codeString))
          return _233914;
        if ("233915".equals(codeString))
          return _233915;
        if ("233916".equals(codeString))
          return _233916;
        if ("233999".equals(codeString))
          return _233999;
        if ("234000".equals(codeString))
          return _234000;
        if ("234100".equals(codeString))
          return _234100;
        if ("234111".equals(codeString))
          return _234111;
        if ("234112".equals(codeString))
          return _234112;
        if ("234113".equals(codeString))
          return _234113;
        if ("234200".equals(codeString))
          return _234200;
        if ("234211".equals(codeString))
          return _234211;
        if ("234212".equals(codeString))
          return _234212;
        if ("234213".equals(codeString))
          return _234213;
        if ("234300".equals(codeString))
          return _234300;
        if ("234311".equals(codeString))
          return _234311;
        if ("234312".equals(codeString))
          return _234312;
        if ("234313".equals(codeString))
          return _234313;
        if ("234314".equals(codeString))
          return _234314;
        if ("234399".equals(codeString))
          return _234399;
        if ("234400".equals(codeString))
          return _234400;
        if ("234411".equals(codeString))
          return _234411;
        if ("234412".equals(codeString))
          return _234412;
        if ("234500".equals(codeString))
          return _234500;
        if ("234511".equals(codeString))
          return _234511;
        if ("234512".equals(codeString))
          return _234512;
        if ("234513".equals(codeString))
          return _234513;
        if ("234514".equals(codeString))
          return _234514;
        if ("234515".equals(codeString))
          return _234515;
        if ("234516".equals(codeString))
          return _234516;
        if ("234517".equals(codeString))
          return _234517;
        if ("234518".equals(codeString))
          return _234518;
        if ("234599".equals(codeString))
          return _234599;
        if ("234611".equals(codeString))
          return _234611;
        if ("234711".equals(codeString))
          return _234711;
        if ("234900".equals(codeString))
          return _234900;
        if ("234911".equals(codeString))
          return _234911;
        if ("234912".equals(codeString))
          return _234912;
        if ("234913".equals(codeString))
          return _234913;
        if ("234914".equals(codeString))
          return _234914;
        if ("234999".equals(codeString))
          return _234999;
        if ("240000".equals(codeString))
          return _240000;
        if ("241000".equals(codeString))
          return _241000;
        if ("241111".equals(codeString))
          return _241111;
        if ("241213".equals(codeString))
          return _241213;
        if ("241311".equals(codeString))
          return _241311;
        if ("241411".equals(codeString))
          return _241411;
        if ("241500".equals(codeString))
          return _241500;
        if ("241511".equals(codeString))
          return _241511;
        if ("241512".equals(codeString))
          return _241512;
        if ("241513".equals(codeString))
          return _241513;
        if ("241599".equals(codeString))
          return _241599;
        if ("242000".equals(codeString))
          return _242000;
        if ("242100".equals(codeString))
          return _242100;
        if ("242111".equals(codeString))
          return _242111;
        if ("242112".equals(codeString))
          return _242112;
        if ("242211".equals(codeString))
          return _242211;
        if ("249000".equals(codeString))
          return _249000;
        if ("249100".equals(codeString))
          return _249100;
        if ("249111".equals(codeString))
          return _249111;
        if ("249112".equals(codeString))
          return _249112;
        if ("249200".equals(codeString))
          return _249200;
        if ("249211".equals(codeString))
          return _249211;
        if ("249212".equals(codeString))
          return _249212;
        if ("249213".equals(codeString))
          return _249213;
        if ("249214".equals(codeString))
          return _249214;
        if ("249299".equals(codeString))
          return _249299;
        if ("249311".equals(codeString))
          return _249311;
        if ("250000".equals(codeString))
          return _250000;
        if ("251000".equals(codeString))
          return _251000;
        if ("251111".equals(codeString))
          return _251111;
        if ("251200".equals(codeString))
          return _251200;
        if ("251211".equals(codeString))
          return _251211;
        if ("251212".equals(codeString))
          return _251212;
        if ("251213".equals(codeString))
          return _251213;
        if ("251214".equals(codeString))
          return _251214;
        if ("251300".equals(codeString))
          return _251300;
        if ("251311".equals(codeString))
          return _251311;
        if ("251312".equals(codeString))
          return _251312;
        if ("251400".equals(codeString))
          return _251400;
        if ("251411".equals(codeString))
          return _251411;
        if ("251412".equals(codeString))
          return _251412;
        if ("251500".equals(codeString))
          return _251500;
        if ("251511".equals(codeString))
          return _251511;
        if ("251512".equals(codeString))
          return _251512;
        if ("251513".equals(codeString))
          return _251513;
        if ("251900".equals(codeString))
          return _251900;
        if ("251911".equals(codeString))
          return _251911;
        if ("251912".equals(codeString))
          return _251912;
        if ("251999".equals(codeString))
          return _251999;
        if ("252000".equals(codeString))
          return _252000;
        if ("252100".equals(codeString))
          return _252100;
        if ("252111".equals(codeString))
          return _252111;
        if ("252112".equals(codeString))
          return _252112;
        if ("252200".equals(codeString))
          return _252200;
        if ("252211".equals(codeString))
          return _252211;
        if ("252212".equals(codeString))
          return _252212;
        if ("252213".equals(codeString))
          return _252213;
        if ("252214".equals(codeString))
          return _252214;
        if ("252299".equals(codeString))
          return _252299;
        if ("252300".equals(codeString))
          return _252300;
        if ("252311".equals(codeString))
          return _252311;
        if ("252312".equals(codeString))
          return _252312;
        if ("252411".equals(codeString))
          return _252411;
        if ("252511".equals(codeString))
          return _252511;
        if ("252611".equals(codeString))
          return _252611;
        if ("252700".equals(codeString))
          return _252700;
        if ("252711".equals(codeString))
          return _252711;
        if ("252712".equals(codeString))
          return _252712;
        if ("253000".equals(codeString))
          return _253000;
        if ("253100".equals(codeString))
          return _253100;
        if ("253111".equals(codeString))
          return _253111;
        if ("253112".equals(codeString))
          return _253112;
        if ("253211".equals(codeString))
          return _253211;
        if ("253300".equals(codeString))
          return _253300;
        if ("253311".equals(codeString))
          return _253311;
        if ("253312".equals(codeString))
          return _253312;
        if ("253313".equals(codeString))
          return _253313;
        if ("253314".equals(codeString))
          return _253314;
        if ("253315".equals(codeString))
          return _253315;
        if ("253316".equals(codeString))
          return _253316;
        if ("253317".equals(codeString))
          return _253317;
        if ("253318".equals(codeString))
          return _253318;
        if ("253321".equals(codeString))
          return _253321;
        if ("253322".equals(codeString))
          return _253322;
        if ("253323".equals(codeString))
          return _253323;
        if ("253324".equals(codeString))
          return _253324;
        if ("253399".equals(codeString))
          return _253399;
        if ("253411".equals(codeString))
          return _253411;
        if ("253500".equals(codeString))
          return _253500;
        if ("253511".equals(codeString))
          return _253511;
        if ("253512".equals(codeString))
          return _253512;
        if ("253513".equals(codeString))
          return _253513;
        if ("253514".equals(codeString))
          return _253514;
        if ("253515".equals(codeString))
          return _253515;
        if ("253516".equals(codeString))
          return _253516;
        if ("253517".equals(codeString))
          return _253517;
        if ("253518".equals(codeString))
          return _253518;
        if ("253521".equals(codeString))
          return _253521;
        if ("253900".equals(codeString))
          return _253900;
        if ("253911".equals(codeString))
          return _253911;
        if ("253912".equals(codeString))
          return _253912;
        if ("253913".equals(codeString))
          return _253913;
        if ("253914".equals(codeString))
          return _253914;
        if ("253915".equals(codeString))
          return _253915;
        if ("253916".equals(codeString))
          return _253916;
        if ("253999".equals(codeString))
          return _253999;
        if ("254000".equals(codeString))
          return _254000;
        if ("254111".equals(codeString))
          return _254111;
        if ("254200".equals(codeString))
          return _254200;
        if ("254211".equals(codeString))
          return _254211;
        if ("254212".equals(codeString))
          return _254212;
        if ("254311".equals(codeString))
          return _254311;
        if ("254400".equals(codeString))
          return _254400;
        if ("254411".equals(codeString))
          return _254411;
        if ("254412".equals(codeString))
          return _254412;
        if ("254413".equals(codeString))
          return _254413;
        if ("254414".equals(codeString))
          return _254414;
        if ("254415".equals(codeString))
          return _254415;
        if ("254416".equals(codeString))
          return _254416;
        if ("254417".equals(codeString))
          return _254417;
        if ("254418".equals(codeString))
          return _254418;
        if ("254421".equals(codeString))
          return _254421;
        if ("254422".equals(codeString))
          return _254422;
        if ("254423".equals(codeString))
          return _254423;
        if ("254424".equals(codeString))
          return _254424;
        if ("254499".equals(codeString))
          return _254499;
        if ("260000".equals(codeString))
          return _260000;
        if ("261000".equals(codeString))
          return _261000;
        if ("261100".equals(codeString))
          return _261100;
        if ("261111".equals(codeString))
          return _261111;
        if ("261112".equals(codeString))
          return _261112;
        if ("261200".equals(codeString))
          return _261200;
        if ("261211".equals(codeString))
          return _261211;
        if ("261212".equals(codeString))
          return _261212;
        if ("261300".equals(codeString))
          return _261300;
        if ("261311".equals(codeString))
          return _261311;
        if ("261312".equals(codeString))
          return _261312;
        if ("261313".equals(codeString))
          return _261313;
        if ("261399".equals(codeString))
          return _261399;
        if ("262100".equals(codeString))
          return _262100;
        if ("262111".equals(codeString))
          return _262111;
        if ("262112".equals(codeString))
          return _262112;
        if ("262113".equals(codeString))
          return _262113;
        if ("263000".equals(codeString))
          return _263000;
        if ("263100".equals(codeString))
          return _263100;
        if ("263111".equals(codeString))
          return _263111;
        if ("263112".equals(codeString))
          return _263112;
        if ("263113".equals(codeString))
          return _263113;
        if ("263200".equals(codeString))
          return _263200;
        if ("263211".equals(codeString))
          return _263211;
        if ("263212".equals(codeString))
          return _263212;
        if ("263213".equals(codeString))
          return _263213;
        if ("263299".equals(codeString))
          return _263299;
        if ("263300".equals(codeString))
          return _263300;
        if ("263311".equals(codeString))
          return _263311;
        if ("263312".equals(codeString))
          return _263312;
        if ("270000".equals(codeString))
          return _270000;
        if ("271000".equals(codeString))
          return _271000;
        if ("271111".equals(codeString))
          return _271111;
        if ("271200".equals(codeString))
          return _271200;
        if ("271211".equals(codeString))
          return _271211;
        if ("271212".equals(codeString))
          return _271212;
        if ("271213".equals(codeString))
          return _271213;
        if ("271299".equals(codeString))
          return _271299;
        if ("271311".equals(codeString))
          return _271311;
        if ("272000".equals(codeString))
          return _272000;
        if ("272100".equals(codeString))
          return _272100;
        if ("272111".equals(codeString))
          return _272111;
        if ("272112".equals(codeString))
          return _272112;
        if ("272113".equals(codeString))
          return _272113;
        if ("272114".equals(codeString))
          return _272114;
        if ("272115".equals(codeString))
          return _272115;
        if ("272199".equals(codeString))
          return _272199;
        if ("272211".equals(codeString))
          return _272211;
        if ("272300".equals(codeString))
          return _272300;
        if ("272311".equals(codeString))
          return _272311;
        if ("272312".equals(codeString))
          return _272312;
        if ("272313".equals(codeString))
          return _272313;
        if ("272314".equals(codeString))
          return _272314;
        if ("272399".equals(codeString))
          return _272399;
        if ("272400".equals(codeString))
          return _272400;
        if ("272411".equals(codeString))
          return _272411;
        if ("272412".equals(codeString))
          return _272412;
        if ("272413".equals(codeString))
          return _272413;
        if ("272499".equals(codeString))
          return _272499;
        if ("272511".equals(codeString))
          return _272511;
        if ("272600".equals(codeString))
          return _272600;
        if ("272611".equals(codeString))
          return _272611;
        if ("272612".equals(codeString))
          return _272612;
        if ("272613".equals(codeString))
          return _272613;
        if ("300000".equals(codeString))
          return _300000;
        if ("310000".equals(codeString))
          return _310000;
        if ("311000".equals(codeString))
          return _311000;
        if ("311111".equals(codeString))
          return _311111;
        if ("311200".equals(codeString))
          return _311200;
        if ("311211".equals(codeString))
          return _311211;
        if ("311212".equals(codeString))
          return _311212;
        if ("311213".equals(codeString))
          return _311213;
        if ("311214".equals(codeString))
          return _311214;
        if ("311215".equals(codeString))
          return _311215;
        if ("311299".equals(codeString))
          return _311299;
        if ("311300".equals(codeString))
          return _311300;
        if ("311311".equals(codeString))
          return _311311;
        if ("311312".equals(codeString))
          return _311312;
        if ("311313".equals(codeString))
          return _311313;
        if ("311399".equals(codeString))
          return _311399;
        if ("311400".equals(codeString))
          return _311400;
        if ("311411".equals(codeString))
          return _311411;
        if ("311412".equals(codeString))
          return _311412;
        if ("311413".equals(codeString))
          return _311413;
        if ("311414".equals(codeString))
          return _311414;
        if ("311499".equals(codeString))
          return _311499;
        if ("312000".equals(codeString))
          return _312000;
        if ("312100".equals(codeString))
          return _312100;
        if ("312111".equals(codeString))
          return _312111;
        if ("312112".equals(codeString))
          return _312112;
        if ("312113".equals(codeString))
          return _312113;
        if ("312114".equals(codeString))
          return _312114;
        if ("312115".equals(codeString))
          return _312115;
        if ("312116".equals(codeString))
          return _312116;
        if ("312200".equals(codeString))
          return _312200;
        if ("312211".equals(codeString))
          return _312211;
        if ("312212".equals(codeString))
          return _312212;
        if ("312300".equals(codeString))
          return _312300;
        if ("312311".equals(codeString))
          return _312311;
        if ("312312".equals(codeString))
          return _312312;
        if ("312400".equals(codeString))
          return _312400;
        if ("312411".equals(codeString))
          return _312411;
        if ("312412".equals(codeString))
          return _312412;
        if ("312500".equals(codeString))
          return _312500;
        if ("312511".equals(codeString))
          return _312511;
        if ("312512".equals(codeString))
          return _312512;
        if ("312611".equals(codeString))
          return _312611;
        if ("312900".equals(codeString))
          return _312900;
        if ("312911".equals(codeString))
          return _312911;
        if ("312912".equals(codeString))
          return _312912;
        if ("312913".equals(codeString))
          return _312913;
        if ("312999".equals(codeString))
          return _312999;
        if ("313000".equals(codeString))
          return _313000;
        if ("313100".equals(codeString))
          return _313100;
        if ("313111".equals(codeString))
          return _313111;
        if ("313112".equals(codeString))
          return _313112;
        if ("313113".equals(codeString))
          return _313113;
        if ("313199".equals(codeString))
          return _313199;
        if ("313200".equals(codeString))
          return _313200;
        if ("313211".equals(codeString))
          return _313211;
        if ("313212".equals(codeString))
          return _313212;
        if ("313213".equals(codeString))
          return _313213;
        if ("313214".equals(codeString))
          return _313214;
        if ("320000".equals(codeString))
          return _320000;
        if ("321000".equals(codeString))
          return _321000;
        if ("321111".equals(codeString))
          return _321111;
        if ("321200".equals(codeString))
          return _321200;
        if ("321211".equals(codeString))
          return _321211;
        if ("321212".equals(codeString))
          return _321212;
        if ("321213".equals(codeString))
          return _321213;
        if ("321214".equals(codeString))
          return _321214;
        if ("322000".equals(codeString))
          return _322000;
        if ("322100".equals(codeString))
          return _322100;
        if ("322111".equals(codeString))
          return _322111;
        if ("322112".equals(codeString))
          return _322112;
        if ("322113".equals(codeString))
          return _322113;
        if ("322114".equals(codeString))
          return _322114;
        if ("322115".equals(codeString))
          return _322115;
        if ("322211".equals(codeString))
          return _322211;
        if ("322300".equals(codeString))
          return _322300;
        if ("322311".equals(codeString))
          return _322311;
        if ("322312".equals(codeString))
          return _322312;
        if ("322313".equals(codeString))
          return _322313;
        if ("323000".equals(codeString))
          return _323000;
        if ("323100".equals(codeString))
          return _323100;
        if ("323111".equals(codeString))
          return _323111;
        if ("323112".equals(codeString))
          return _323112;
        if ("323113".equals(codeString))
          return _323113;
        if ("323200".equals(codeString))
          return _323200;
        if ("323211".equals(codeString))
          return _323211;
        if ("323212".equals(codeString))
          return _323212;
        if ("323213".equals(codeString))
          return _323213;
        if ("323214".equals(codeString))
          return _323214;
        if ("323215".equals(codeString))
          return _323215;
        if ("323299".equals(codeString))
          return _323299;
        if ("323300".equals(codeString))
          return _323300;
        if ("323311".equals(codeString))
          return _323311;
        if ("323312".equals(codeString))
          return _323312;
        if ("323313".equals(codeString))
          return _323313;
        if ("323314".equals(codeString))
          return _323314;
        if ("323315".equals(codeString))
          return _323315;
        if ("323316".equals(codeString))
          return _323316;
        if ("323400".equals(codeString))
          return _323400;
        if ("323411".equals(codeString))
          return _323411;
        if ("323412".equals(codeString))
          return _323412;
        if ("324000".equals(codeString))
          return _324000;
        if ("324111".equals(codeString))
          return _324111;
        if ("324200".equals(codeString))
          return _324200;
        if ("324211".equals(codeString))
          return _324211;
        if ("324212".equals(codeString))
          return _324212;
        if ("324311".equals(codeString))
          return _324311;
        if ("330000".equals(codeString))
          return _330000;
        if ("331000".equals(codeString))
          return _331000;
        if ("331100".equals(codeString))
          return _331100;
        if ("331111".equals(codeString))
          return _331111;
        if ("331112".equals(codeString))
          return _331112;
        if ("331211".equals(codeString))
          return _331211;
        if ("331212".equals(codeString))
          return _331212;
        if ("331213".equals(codeString))
          return _331213;
        if ("332000".equals(codeString))
          return _332000;
        if ("332111".equals(codeString))
          return _332111;
        if ("332211".equals(codeString))
          return _332211;
        if ("333000".equals(codeString))
          return _333000;
        if ("333111".equals(codeString))
          return _333111;
        if ("333200".equals(codeString))
          return _333200;
        if ("333211".equals(codeString))
          return _333211;
        if ("333212".equals(codeString))
          return _333212;
        if ("333311".equals(codeString))
          return _333311;
        if ("333411".equals(codeString))
          return _333411;
        if ("334100".equals(codeString))
          return _334100;
        if ("334111".equals(codeString))
          return _334111;
        if ("334112".equals(codeString))
          return _334112;
        if ("334113".equals(codeString))
          return _334113;
        if ("334114".equals(codeString))
          return _334114;
        if ("334115".equals(codeString))
          return _334115;
        if ("340000".equals(codeString))
          return _340000;
        if ("341100".equals(codeString))
          return _341100;
        if ("341111".equals(codeString))
          return _341111;
        if ("341112".equals(codeString))
          return _341112;
        if ("341113".equals(codeString))
          return _341113;
        if ("342000".equals(codeString))
          return _342000;
        if ("342111".equals(codeString))
          return _342111;
        if ("342200".equals(codeString))
          return _342200;
        if ("342211".equals(codeString))
          return _342211;
        if ("342212".equals(codeString))
          return _342212;
        if ("342300".equals(codeString))
          return _342300;
        if ("342311".equals(codeString))
          return _342311;
        if ("342312".equals(codeString))
          return _342312;
        if ("342313".equals(codeString))
          return _342313;
        if ("342314".equals(codeString))
          return _342314;
        if ("342315".equals(codeString))
          return _342315;
        if ("342400".equals(codeString))
          return _342400;
        if ("342411".equals(codeString))
          return _342411;
        if ("342412".equals(codeString))
          return _342412;
        if ("342413".equals(codeString))
          return _342413;
        if ("342414".equals(codeString))
          return _342414;
        if ("351000".equals(codeString))
          return _351000;
        if ("351100".equals(codeString))
          return _351100;
        if ("351111".equals(codeString))
          return _351111;
        if ("351112".equals(codeString))
          return _351112;
        if ("351211".equals(codeString))
          return _351211;
        if ("351311".equals(codeString))
          return _351311;
        if ("351411".equals(codeString))
          return _351411;
        if ("360000".equals(codeString))
          return _360000;
        if ("361000".equals(codeString))
          return _361000;
        if ("361100".equals(codeString))
          return _361100;
        if ("361111".equals(codeString))
          return _361111;
        if ("361112".equals(codeString))
          return _361112;
        if ("361113".equals(codeString))
          return _361113;
        if ("361114".equals(codeString))
          return _361114;
        if ("361199".equals(codeString))
          return _361199;
        if ("361211".equals(codeString))
          return _361211;
        if ("361311".equals(codeString))
          return _361311;
        if ("362000".equals(codeString))
          return _362000;
        if ("362111".equals(codeString))
          return _362111;
        if ("362200".equals(codeString))
          return _362200;
        if ("362211".equals(codeString))
          return _362211;
        if ("362212".equals(codeString))
          return _362212;
        if ("362213".equals(codeString))
          return _362213;
        if ("362311".equals(codeString))
          return _362311;
        if ("362411".equals(codeString))
          return _362411;
        if ("390000".equals(codeString))
          return _390000;
        if ("391111".equals(codeString))
          return _391111;
        if ("392000".equals(codeString))
          return _392000;
        if ("392100".equals(codeString))
          return _392100;
        if ("392111".equals(codeString))
          return _392111;
        if ("392112".equals(codeString))
          return _392112;
        if ("392211".equals(codeString))
          return _392211;
        if ("392300".equals(codeString))
          return _392300;
        if ("392311".equals(codeString))
          return _392311;
        if ("392312".equals(codeString))
          return _392312;
        if ("393000".equals(codeString))
          return _393000;
        if ("393100".equals(codeString))
          return _393100;
        if ("393111".equals(codeString))
          return _393111;
        if ("393112".equals(codeString))
          return _393112;
        if ("393113".equals(codeString))
          return _393113;
        if ("393114".equals(codeString))
          return _393114;
        if ("393200".equals(codeString))
          return _393200;
        if ("393211".equals(codeString))
          return _393211;
        if ("393212".equals(codeString))
          return _393212;
        if ("393213".equals(codeString))
          return _393213;
        if ("393299".equals(codeString))
          return _393299;
        if ("393311".equals(codeString))
          return _393311;
        if ("394000".equals(codeString))
          return _394000;
        if ("394111".equals(codeString))
          return _394111;
        if ("394200".equals(codeString))
          return _394200;
        if ("394211".equals(codeString))
          return _394211;
        if ("394212".equals(codeString))
          return _394212;
        if ("394213".equals(codeString))
          return _394213;
        if ("394214".equals(codeString))
          return _394214;
        if ("394299".equals(codeString))
          return _394299;
        if ("399000".equals(codeString))
          return _399000;
        if ("399100".equals(codeString))
          return _399100;
        if ("399111".equals(codeString))
          return _399111;
        if ("399112".equals(codeString))
          return _399112;
        if ("399200".equals(codeString))
          return _399200;
        if ("399211".equals(codeString))
          return _399211;
        if ("399212".equals(codeString))
          return _399212;
        if ("399213".equals(codeString))
          return _399213;
        if ("399300".equals(codeString))
          return _399300;
        if ("399311".equals(codeString))
          return _399311;
        if ("399312".equals(codeString))
          return _399312;
        if ("399411".equals(codeString))
          return _399411;
        if ("399500".equals(codeString))
          return _399500;
        if ("399511".equals(codeString))
          return _399511;
        if ("399512".equals(codeString))
          return _399512;
        if ("399513".equals(codeString))
          return _399513;
        if ("399514".equals(codeString))
          return _399514;
        if ("399515".equals(codeString))
          return _399515;
        if ("399516".equals(codeString))
          return _399516;
        if ("399517".equals(codeString))
          return _399517;
        if ("399599".equals(codeString))
          return _399599;
        if ("399611".equals(codeString))
          return _399611;
        if ("399900".equals(codeString))
          return _399900;
        if ("399911".equals(codeString))
          return _399911;
        if ("399912".equals(codeString))
          return _399912;
        if ("399913".equals(codeString))
          return _399913;
        if ("399914".equals(codeString))
          return _399914;
        if ("399915".equals(codeString))
          return _399915;
        if ("399916".equals(codeString))
          return _399916;
        if ("399917".equals(codeString))
          return _399917;
        if ("399999".equals(codeString))
          return _399999;
        if ("400000".equals(codeString))
          return _400000;
        if ("411000".equals(codeString))
          return _411000;
        if ("411100".equals(codeString))
          return _411100;
        if ("411111".equals(codeString))
          return _411111;
        if ("411112".equals(codeString))
          return _411112;
        if ("411200".equals(codeString))
          return _411200;
        if ("411211".equals(codeString))
          return _411211;
        if ("411212".equals(codeString))
          return _411212;
        if ("411213".equals(codeString))
          return _411213;
        if ("411214".equals(codeString))
          return _411214;
        if ("411311".equals(codeString))
          return _411311;
        if ("411400".equals(codeString))
          return _411400;
        if ("411411".equals(codeString))
          return _411411;
        if ("411412".equals(codeString))
          return _411412;
        if ("411511".equals(codeString))
          return _411511;
        if ("411611".equals(codeString))
          return _411611;
        if ("411700".equals(codeString))
          return _411700;
        if ("411711".equals(codeString))
          return _411711;
        if ("411712".equals(codeString))
          return _411712;
        if ("411713".equals(codeString))
          return _411713;
        if ("411714".equals(codeString))
          return _411714;
        if ("411715".equals(codeString))
          return _411715;
        if ("411716".equals(codeString))
          return _411716;
        if ("420000".equals(codeString))
          return _420000;
        if ("421100".equals(codeString))
          return _421100;
        if ("421111".equals(codeString))
          return _421111;
        if ("421112".equals(codeString))
          return _421112;
        if ("421113".equals(codeString))
          return _421113;
        if ("421114".equals(codeString))
          return _421114;
        if ("422100".equals(codeString))
          return _422100;
        if ("422111".equals(codeString))
          return _422111;
        if ("422112".equals(codeString))
          return _422112;
        if ("422115".equals(codeString))
          return _422115;
        if ("422116".equals(codeString))
          return _422116;
        if ("423000".equals(codeString))
          return _423000;
        if ("423111".equals(codeString))
          return _423111;
        if ("423211".equals(codeString))
          return _423211;
        if ("423300".equals(codeString))
          return _423300;
        if ("423311".equals(codeString))
          return _423311;
        if ("423312".equals(codeString))
          return _423312;
        if ("423313".equals(codeString))
          return _423313;
        if ("423314".equals(codeString))
          return _423314;
        if ("423400".equals(codeString))
          return _423400;
        if ("423411".equals(codeString))
          return _423411;
        if ("423412".equals(codeString))
          return _423412;
        if ("423413".equals(codeString))
          return _423413;
        if ("431000".equals(codeString))
          return _431000;
        if ("431100".equals(codeString))
          return _431100;
        if ("431111".equals(codeString))
          return _431111;
        if ("431112".equals(codeString))
          return _431112;
        if ("431211".equals(codeString))
          return _431211;
        if ("431311".equals(codeString))
          return _431311;
        if ("431411".equals(codeString))
          return _431411;
        if ("431511".equals(codeString))
          return _431511;
        if ("431900".equals(codeString))
          return _431900;
        if ("431911".equals(codeString))
          return _431911;
        if ("431912".equals(codeString))
          return _431912;
        if ("431999".equals(codeString))
          return _431999;
        if ("440000".equals(codeString))
          return _440000;
        if ("441000".equals(codeString))
          return _441000;
        if ("441111".equals(codeString))
          return _441111;
        if ("441200".equals(codeString))
          return _441200;
        if ("441211".equals(codeString))
          return _441211;
        if ("441212".equals(codeString))
          return _441212;
        if ("441300".equals(codeString))
          return _441300;
        if ("441311".equals(codeString))
          return _441311;
        if ("441312".equals(codeString))
          return _441312;
        if ("442000".equals(codeString))
          return _442000;
        if ("442111".equals(codeString))
          return _442111;
        if ("442200".equals(codeString))
          return _442200;
        if ("442211".equals(codeString))
          return _442211;
        if ("442212".equals(codeString))
          return _442212;
        if ("442213".equals(codeString))
          return _442213;
        if ("442214".equals(codeString))
          return _442214;
        if ("442215".equals(codeString))
          return _442215;
        if ("442216".equals(codeString))
          return _442216;
        if ("442217".equals(codeString))
          return _442217;
        if ("442299".equals(codeString))
          return _442299;
        if ("450000".equals(codeString))
          return _450000;
        if ("451000".equals(codeString))
          return _451000;
        if ("451111".equals(codeString))
          return _451111;
        if ("451211".equals(codeString))
          return _451211;
        if ("451300".equals(codeString))
          return _451300;
        if ("451311".equals(codeString))
          return _451311;
        if ("451399".equals(codeString))
          return _451399;
        if ("451400".equals(codeString))
          return _451400;
        if ("451411".equals(codeString))
          return _451411;
        if ("451412".equals(codeString))
          return _451412;
        if ("451500".equals(codeString))
          return _451500;
        if ("451511".equals(codeString))
          return _451511;
        if ("451512".equals(codeString))
          return _451512;
        if ("451600".equals(codeString))
          return _451600;
        if ("451611".equals(codeString))
          return _451611;
        if ("451612".equals(codeString))
          return _451612;
        if ("451700".equals(codeString))
          return _451700;
        if ("451711".equals(codeString))
          return _451711;
        if ("451799".equals(codeString))
          return _451799;
        if ("451800".equals(codeString))
          return _451800;
        if ("451811".equals(codeString))
          return _451811;
        if ("451812".equals(codeString))
          return _451812;
        if ("451813".equals(codeString))
          return _451813;
        if ("451899".equals(codeString))
          return _451899;
        if ("452000".equals(codeString))
          return _452000;
        if ("452111".equals(codeString))
          return _452111;
        if ("452200".equals(codeString))
          return _452200;
        if ("452211".equals(codeString))
          return _452211;
        if ("452212".equals(codeString))
          return _452212;
        if ("452213".equals(codeString))
          return _452213;
        if ("452214".equals(codeString))
          return _452214;
        if ("452215".equals(codeString))
          return _452215;
        if ("452216".equals(codeString))
          return _452216;
        if ("452217".equals(codeString))
          return _452217;
        if ("452299".equals(codeString))
          return _452299;
        if ("452300".equals(codeString))
          return _452300;
        if ("452311".equals(codeString))
          return _452311;
        if ("452312".equals(codeString))
          return _452312;
        if ("452313".equals(codeString))
          return _452313;
        if ("452314".equals(codeString))
          return _452314;
        if ("452315".equals(codeString))
          return _452315;
        if ("452316".equals(codeString))
          return _452316;
        if ("452317".equals(codeString))
          return _452317;
        if ("452318".equals(codeString))
          return _452318;
        if ("452321".equals(codeString))
          return _452321;
        if ("452322".equals(codeString))
          return _452322;
        if ("452323".equals(codeString))
          return _452323;
        if ("452400".equals(codeString))
          return _452400;
        if ("452411".equals(codeString))
          return _452411;
        if ("452412".equals(codeString))
          return _452412;
        if ("452413".equals(codeString))
          return _452413;
        if ("452414".equals(codeString))
          return _452414;
        if ("452499".equals(codeString))
          return _452499;
        if ("500000".equals(codeString))
          return _500000;
        if ("510000".equals(codeString))
          return _510000;
        if ("511100".equals(codeString))
          return _511100;
        if ("511111".equals(codeString))
          return _511111;
        if ("511112".equals(codeString))
          return _511112;
        if ("512000".equals(codeString))
          return _512000;
        if ("512111".equals(codeString))
          return _512111;
        if ("512200".equals(codeString))
          return _512200;
        if ("512211".equals(codeString))
          return _512211;
        if ("512299".equals(codeString))
          return _512299;
        if ("521000".equals(codeString))
          return _521000;
        if ("521111".equals(codeString))
          return _521111;
        if ("521200".equals(codeString))
          return _521200;
        if ("521211".equals(codeString))
          return _521211;
        if ("521212".equals(codeString))
          return _521212;
        if ("530000".equals(codeString))
          return _530000;
        if ("531111".equals(codeString))
          return _531111;
        if ("532100".equals(codeString))
          return _532100;
        if ("532111".equals(codeString))
          return _532111;
        if ("532112".equals(codeString))
          return _532112;
        if ("532113".equals(codeString))
          return _532113;
        if ("540000".equals(codeString))
          return _540000;
        if ("541000".equals(codeString))
          return _541000;
        if ("541100".equals(codeString))
          return _541100;
        if ("541111".equals(codeString))
          return _541111;
        if ("541112".equals(codeString))
          return _541112;
        if ("541211".equals(codeString))
          return _541211;
        if ("542100".equals(codeString))
          return _542100;
        if ("542111".equals(codeString))
          return _542111;
        if ("542112".equals(codeString))
          return _542112;
        if ("542113".equals(codeString))
          return _542113;
        if ("542114".equals(codeString))
          return _542114;
        if ("550000".equals(codeString))
          return _550000;
        if ("551000".equals(codeString))
          return _551000;
        if ("551100".equals(codeString))
          return _551100;
        if ("551111".equals(codeString))
          return _551111;
        if ("551112".equals(codeString))
          return _551112;
        if ("551211".equals(codeString))
          return _551211;
        if ("551311".equals(codeString))
          return _551311;
        if ("552000".equals(codeString))
          return _552000;
        if ("552111".equals(codeString))
          return _552111;
        if ("552211".equals(codeString))
          return _552211;
        if ("552300".equals(codeString))
          return _552300;
        if ("552311".equals(codeString))
          return _552311;
        if ("552312".equals(codeString))
          return _552312;
        if ("552313".equals(codeString))
          return _552313;
        if ("552314".equals(codeString))
          return _552314;
        if ("561000".equals(codeString))
          return _561000;
        if ("561100".equals(codeString))
          return _561100;
        if ("561111".equals(codeString))
          return _561111;
        if ("561112".equals(codeString))
          return _561112;
        if ("561113".equals(codeString))
          return _561113;
        if ("561199".equals(codeString))
          return _561199;
        if ("561200".equals(codeString))
          return _561200;
        if ("561211".equals(codeString))
          return _561211;
        if ("561212".equals(codeString))
          return _561212;
        if ("561311".equals(codeString))
          return _561311;
        if ("561400".equals(codeString))
          return _561400;
        if ("561411".equals(codeString))
          return _561411;
        if ("561412".equals(codeString))
          return _561412;
        if ("561511".equals(codeString))
          return _561511;
        if ("561611".equals(codeString))
          return _561611;
        if ("561900".equals(codeString))
          return _561900;
        if ("561911".equals(codeString))
          return _561911;
        if ("561912".equals(codeString))
          return _561912;
        if ("561913".equals(codeString))
          return _561913;
        if ("561999".equals(codeString))
          return _561999;
        if ("590000".equals(codeString))
          return _590000;
        if ("591000".equals(codeString))
          return _591000;
        if ("591100".equals(codeString))
          return _591100;
        if ("591111".equals(codeString))
          return _591111;
        if ("591112".equals(codeString))
          return _591112;
        if ("591113".equals(codeString))
          return _591113;
        if ("591114".equals(codeString))
          return _591114;
        if ("591115".equals(codeString))
          return _591115;
        if ("591116".equals(codeString))
          return _591116;
        if ("591200".equals(codeString))
          return _591200;
        if ("591211".equals(codeString))
          return _591211;
        if ("591212".equals(codeString))
          return _591212;
        if ("599000".equals(codeString))
          return _599000;
        if ("599100".equals(codeString))
          return _599100;
        if ("599111".equals(codeString))
          return _599111;
        if ("599112".equals(codeString))
          return _599112;
        if ("599200".equals(codeString))
          return _599200;
        if ("599211".equals(codeString))
          return _599211;
        if ("599212".equals(codeString))
          return _599212;
        if ("599213".equals(codeString))
          return _599213;
        if ("599214".equals(codeString))
          return _599214;
        if ("599215".equals(codeString))
          return _599215;
        if ("599311".equals(codeString))
          return _599311;
        if ("599411".equals(codeString))
          return _599411;
        if ("599500".equals(codeString))
          return _599500;
        if ("599511".equals(codeString))
          return _599511;
        if ("599512".equals(codeString))
          return _599512;
        if ("599513".equals(codeString))
          return _599513;
        if ("599514".equals(codeString))
          return _599514;
        if ("599515".equals(codeString))
          return _599515;
        if ("599516".equals(codeString))
          return _599516;
        if ("599517".equals(codeString))
          return _599517;
        if ("599518".equals(codeString))
          return _599518;
        if ("599521".equals(codeString))
          return _599521;
        if ("599599".equals(codeString))
          return _599599;
        if ("599600".equals(codeString))
          return _599600;
        if ("599611".equals(codeString))
          return _599611;
        if ("599612".equals(codeString))
          return _599612;
        if ("599613".equals(codeString))
          return _599613;
        if ("599711".equals(codeString))
          return _599711;
        if ("599900".equals(codeString))
          return _599900;
        if ("599911".equals(codeString))
          return _599911;
        if ("599912".equals(codeString))
          return _599912;
        if ("599913".equals(codeString))
          return _599913;
        if ("599914".equals(codeString))
          return _599914;
        if ("599999".equals(codeString))
          return _599999;
        if ("600000".equals(codeString))
          return _600000;
        if ("610000".equals(codeString))
          return _610000;
        if ("611000".equals(codeString))
          return _611000;
        if ("611100".equals(codeString))
          return _611100;
        if ("611111".equals(codeString))
          return _611111;
        if ("611112".equals(codeString))
          return _611112;
        if ("611211".equals(codeString))
          return _611211;
        if ("611300".equals(codeString))
          return _611300;
        if ("611311".equals(codeString))
          return _611311;
        if ("611312".equals(codeString))
          return _611312;
        if ("611313".equals(codeString))
          return _611313;
        if ("611314".equals(codeString))
          return _611314;
        if ("611399".equals(codeString))
          return _611399;
        if ("612100".equals(codeString))
          return _612100;
        if ("612111".equals(codeString))
          return _612111;
        if ("612112".equals(codeString))
          return _612112;
        if ("612113".equals(codeString))
          return _612113;
        if ("612114".equals(codeString))
          return _612114;
        if ("612115".equals(codeString))
          return _612115;
        if ("621000".equals(codeString))
          return _621000;
        if ("621111".equals(codeString))
          return _621111;
        if ("621211".equals(codeString))
          return _621211;
        if ("621300".equals(codeString))
          return _621300;
        if ("621311".equals(codeString))
          return _621311;
        if ("621312".equals(codeString))
          return _621312;
        if ("621411".equals(codeString))
          return _621411;
        if ("621511".equals(codeString))
          return _621511;
        if ("621611".equals(codeString))
          return _621611;
        if ("621700".equals(codeString))
          return _621700;
        if ("621711".equals(codeString))
          return _621711;
        if ("621712".equals(codeString))
          return _621712;
        if ("621713".equals(codeString))
          return _621713;
        if ("621900".equals(codeString))
          return _621900;
        if ("621911".equals(codeString))
          return _621911;
        if ("621912".equals(codeString))
          return _621912;
        if ("621999".equals(codeString))
          return _621999;
        if ("630000".equals(codeString))
          return _630000;
        if ("631100".equals(codeString))
          return _631100;
        if ("631111".equals(codeString))
          return _631111;
        if ("631112".equals(codeString))
          return _631112;
        if ("639000".equals(codeString))
          return _639000;
        if ("639100".equals(codeString))
          return _639100;
        if ("639111".equals(codeString))
          return _639111;
        if ("639112".equals(codeString))
          return _639112;
        if ("639200".equals(codeString))
          return _639200;
        if ("639211".equals(codeString))
          return _639211;
        if ("639212".equals(codeString))
          return _639212;
        if ("639311".equals(codeString))
          return _639311;
        if ("639400".equals(codeString))
          return _639400;
        if ("639411".equals(codeString))
          return _639411;
        if ("639412".equals(codeString))
          return _639412;
        if ("639511".equals(codeString))
          return _639511;
        if ("639911".equals(codeString))
          return _639911;
        if ("700000".equals(codeString))
          return _700000;
        if ("710000".equals(codeString))
          return _710000;
        if ("711000".equals(codeString))
          return _711000;
        if ("711100".equals(codeString))
          return _711100;
        if ("711111".equals(codeString))
          return _711111;
        if ("711112".equals(codeString))
          return _711112;
        if ("711113".equals(codeString))
          return _711113;
        if ("711114".equals(codeString))
          return _711114;
        if ("711199".equals(codeString))
          return _711199;
        if ("711211".equals(codeString))
          return _711211;
        if ("711300".equals(codeString))
          return _711300;
        if ("711311".equals(codeString))
          return _711311;
        if ("711312".equals(codeString))
          return _711312;
        if ("711411".equals(codeString))
          return _711411;
        if ("711500".equals(codeString))
          return _711500;
        if ("711511".equals(codeString))
          return _711511;
        if ("711512".equals(codeString))
          return _711512;
        if ("711513".equals(codeString))
          return _711513;
        if ("711514".equals(codeString))
          return _711514;
        if ("711515".equals(codeString))
          return _711515;
        if ("711516".equals(codeString))
          return _711516;
        if ("711599".equals(codeString))
          return _711599;
        if ("711611".equals(codeString))
          return _711611;
        if ("711700".equals(codeString))
          return _711700;
        if ("711711".equals(codeString))
          return _711711;
        if ("711712".equals(codeString))
          return _711712;
        if ("711713".equals(codeString))
          return _711713;
        if ("711714".equals(codeString))
          return _711714;
        if ("711715".equals(codeString))
          return _711715;
        if ("711716".equals(codeString))
          return _711716;
        if ("711799".equals(codeString))
          return _711799;
        if ("711900".equals(codeString))
          return _711900;
        if ("711911".equals(codeString))
          return _711911;
        if ("711912".equals(codeString))
          return _711912;
        if ("711913".equals(codeString))
          return _711913;
        if ("711914".equals(codeString))
          return _711914;
        if ("711999".equals(codeString))
          return _711999;
        if ("712000".equals(codeString))
          return _712000;
        if ("712111".equals(codeString))
          return _712111;
        if ("712200".equals(codeString))
          return _712200;
        if ("712211".equals(codeString))
          return _712211;
        if ("712212".equals(codeString))
          return _712212;
        if ("712213".equals(codeString))
          return _712213;
        if ("712311".equals(codeString))
          return _712311;
        if ("712900".equals(codeString))
          return _712900;
        if ("712911".equals(codeString))
          return _712911;
        if ("712912".equals(codeString))
          return _712912;
        if ("712913".equals(codeString))
          return _712913;
        if ("712914".equals(codeString))
          return _712914;
        if ("712915".equals(codeString))
          return _712915;
        if ("712916".equals(codeString))
          return _712916;
        if ("712917".equals(codeString))
          return _712917;
        if ("712918".equals(codeString))
          return _712918;
        if ("712921".equals(codeString))
          return _712921;
        if ("712922".equals(codeString))
          return _712922;
        if ("712999".equals(codeString))
          return _712999;
        if ("721000".equals(codeString))
          return _721000;
        if ("721100".equals(codeString))
          return _721100;
        if ("721111".equals(codeString))
          return _721111;
        if ("721112".equals(codeString))
          return _721112;
        if ("721200".equals(codeString))
          return _721200;
        if ("721211".equals(codeString))
          return _721211;
        if ("721212".equals(codeString))
          return _721212;
        if ("721213".equals(codeString))
          return _721213;
        if ("721214".equals(codeString))
          return _721214;
        if ("721215".equals(codeString))
          return _721215;
        if ("721216".equals(codeString))
          return _721216;
        if ("721311".equals(codeString))
          return _721311;
        if ("721900".equals(codeString))
          return _721900;
        if ("721911".equals(codeString))
          return _721911;
        if ("721912".equals(codeString))
          return _721912;
        if ("721913".equals(codeString))
          return _721913;
        if ("721914".equals(codeString))
          return _721914;
        if ("721915".equals(codeString))
          return _721915;
        if ("721916".equals(codeString))
          return _721916;
        if ("721999".equals(codeString))
          return _721999;
        if ("730000".equals(codeString))
          return _730000;
        if ("731000".equals(codeString))
          return _731000;
        if ("731100".equals(codeString))
          return _731100;
        if ("731111".equals(codeString))
          return _731111;
        if ("731112".equals(codeString))
          return _731112;
        if ("731199".equals(codeString))
          return _731199;
        if ("731200".equals(codeString))
          return _731200;
        if ("731211".equals(codeString))
          return _731211;
        if ("731212".equals(codeString))
          return _731212;
        if ("731213".equals(codeString))
          return _731213;
        if ("731300".equals(codeString))
          return _731300;
        if ("731311".equals(codeString))
          return _731311;
        if ("731312".equals(codeString))
          return _731312;
        if ("732111".equals(codeString))
          return _732111;
        if ("733100".equals(codeString))
          return _733100;
        if ("733111".equals(codeString))
          return _733111;
        if ("733112".equals(codeString))
          return _733112;
        if ("733113".equals(codeString))
          return _733113;
        if ("733114".equals(codeString))
          return _733114;
        if ("733115".equals(codeString))
          return _733115;
        if ("741111".equals(codeString))
          return _741111;
        if ("800000".equals(codeString))
          return _800000;
        if ("811000".equals(codeString))
          return _811000;
        if ("811111".equals(codeString))
          return _811111;
        if ("811211".equals(codeString))
          return _811211;
        if ("811311".equals(codeString))
          return _811311;
        if ("811400".equals(codeString))
          return _811400;
        if ("811411".equals(codeString))
          return _811411;
        if ("811412".equals(codeString))
          return _811412;
        if ("811500".equals(codeString))
          return _811500;
        if ("811511".equals(codeString))
          return _811511;
        if ("811512".equals(codeString))
          return _811512;
        if ("811513".equals(codeString))
          return _811513;
        if ("811600".equals(codeString))
          return _811600;
        if ("811611".equals(codeString))
          return _811611;
        if ("811612".equals(codeString))
          return _811612;
        if ("811699".equals(codeString))
          return _811699;
        if ("821000".equals(codeString))
          return _821000;
        if ("821100".equals(codeString))
          return _821100;
        if ("821111".equals(codeString))
          return _821111;
        if ("821112".equals(codeString))
          return _821112;
        if ("821113".equals(codeString))
          return _821113;
        if ("821114".equals(codeString))
          return _821114;
        if ("821211".equals(codeString))
          return _821211;
        if ("821311".equals(codeString))
          return _821311;
        if ("821400".equals(codeString))
          return _821400;
        if ("821411".equals(codeString))
          return _821411;
        if ("821412".equals(codeString))
          return _821412;
        if ("821511".equals(codeString))
          return _821511;
        if ("821611".equals(codeString))
          return _821611;
        if ("821700".equals(codeString))
          return _821700;
        if ("821711".equals(codeString))
          return _821711;
        if ("821712".equals(codeString))
          return _821712;
        if ("821713".equals(codeString))
          return _821713;
        if ("821714".equals(codeString))
          return _821714;
        if ("821900".equals(codeString))
          return _821900;
        if ("821911".equals(codeString))
          return _821911;
        if ("821912".equals(codeString))
          return _821912;
        if ("821913".equals(codeString))
          return _821913;
        if ("821914".equals(codeString))
          return _821914;
        if ("821915".equals(codeString))
          return _821915;
        if ("830000".equals(codeString))
          return _830000;
        if ("831000".equals(codeString))
          return _831000;
        if ("831100".equals(codeString))
          return _831100;
        if ("831111".equals(codeString))
          return _831111;
        if ("831112".equals(codeString))
          return _831112;
        if ("831113".equals(codeString))
          return _831113;
        if ("831114".equals(codeString))
          return _831114;
        if ("831115".equals(codeString))
          return _831115;
        if ("831116".equals(codeString))
          return _831116;
        if ("831117".equals(codeString))
          return _831117;
        if ("831118".equals(codeString))
          return _831118;
        if ("831199".equals(codeString))
          return _831199;
        if ("831200".equals(codeString))
          return _831200;
        if ("831211".equals(codeString))
          return _831211;
        if ("831212".equals(codeString))
          return _831212;
        if ("831300".equals(codeString))
          return _831300;
        if ("831311".equals(codeString))
          return _831311;
        if ("831312".equals(codeString))
          return _831312;
        if ("831313".equals(codeString))
          return _831313;
        if ("832000".equals(codeString))
          return _832000;
        if ("832100".equals(codeString))
          return _832100;
        if ("832111".equals(codeString))
          return _832111;
        if ("832112".equals(codeString))
          return _832112;
        if ("832113".equals(codeString))
          return _832113;
        if ("832114".equals(codeString))
          return _832114;
        if ("832115".equals(codeString))
          return _832115;
        if ("832199".equals(codeString))
          return _832199;
        if ("832211".equals(codeString))
          return _832211;
        if ("839000".equals(codeString))
          return _839000;
        if ("839111".equals(codeString))
          return _839111;
        if ("839200".equals(codeString))
          return _839200;
        if ("839211".equals(codeString))
          return _839211;
        if ("839212".equals(codeString))
          return _839212;
        if ("839300".equals(codeString))
          return _839300;
        if ("839311".equals(codeString))
          return _839311;
        if ("839312".equals(codeString))
          return _839312;
        if ("839313".equals(codeString))
          return _839313;
        if ("839400".equals(codeString))
          return _839400;
        if ("839411".equals(codeString))
          return _839411;
        if ("839412".equals(codeString))
          return _839412;
        if ("839413".equals(codeString))
          return _839413;
        if ("839900".equals(codeString))
          return _839900;
        if ("839911".equals(codeString))
          return _839911;
        if ("839912".equals(codeString))
          return _839912;
        if ("839913".equals(codeString))
          return _839913;
        if ("839914".equals(codeString))
          return _839914;
        if ("839915".equals(codeString))
          return _839915;
        if ("839916".equals(codeString))
          return _839916;
        if ("839917".equals(codeString))
          return _839917;
        if ("839999".equals(codeString))
          return _839999;
        if ("841000".equals(codeString))
          return _841000;
        if ("841111".equals(codeString))
          return _841111;
        if ("841200".equals(codeString))
          return _841200;
        if ("841211".equals(codeString))
          return _841211;
        if ("841212".equals(codeString))
          return _841212;
        if ("841213".equals(codeString))
          return _841213;
        if ("841214".equals(codeString))
          return _841214;
        if ("841215".equals(codeString))
          return _841215;
        if ("841216".equals(codeString))
          return _841216;
        if ("841299".equals(codeString))
          return _841299;
        if ("841300".equals(codeString))
          return _841300;
        if ("841311".equals(codeString))
          return _841311;
        if ("841312".equals(codeString))
          return _841312;
        if ("841313".equals(codeString))
          return _841313;
        if ("841400".equals(codeString))
          return _841400;
        if ("841411".equals(codeString))
          return _841411;
        if ("841412".equals(codeString))
          return _841412;
        if ("841500".equals(codeString))
          return _841500;
        if ("841511".equals(codeString))
          return _841511;
        if ("841512".equals(codeString))
          return _841512;
        if ("841513".equals(codeString))
          return _841513;
        if ("841514".equals(codeString))
          return _841514;
        if ("841515".equals(codeString))
          return _841515;
        if ("841516".equals(codeString))
          return _841516;
        if ("841517".equals(codeString))
          return _841517;
        if ("841599".equals(codeString))
          return _841599;
        if ("841611".equals(codeString))
          return _841611;
        if ("841900".equals(codeString))
          return _841900;
        if ("841911".equals(codeString))
          return _841911;
        if ("841912".equals(codeString))
          return _841912;
        if ("841999".equals(codeString))
          return _841999;
        if ("851000".equals(codeString))
          return _851000;
        if ("851111".equals(codeString))
          return _851111;
        if ("851200".equals(codeString))
          return _851200;
        if ("851211".equals(codeString))
          return _851211;
        if ("851299".equals(codeString))
          return _851299;
        if ("851311".equals(codeString))
          return _851311;
        if ("890000".equals(codeString))
          return _890000;
        if ("891000".equals(codeString))
          return _891000;
        if ("891100".equals(codeString))
          return _891100;
        if ("891111".equals(codeString))
          return _891111;
        if ("891112".equals(codeString))
          return _891112;
        if ("891113".equals(codeString))
          return _891113;
        if ("891211".equals(codeString))
          return _891211;
        if ("899000".equals(codeString))
          return _899000;
        if ("899111".equals(codeString))
          return _899111;
        if ("899200".equals(codeString))
          return _899200;
        if ("899211".equals(codeString))
          return _899211;
        if ("899212".equals(codeString))
          return _899212;
        if ("899311".equals(codeString))
          return _899311;
        if ("899400".equals(codeString))
          return _899400;
        if ("899411".equals(codeString))
          return _899411;
        if ("899412".equals(codeString))
          return _899412;
        if ("899413".equals(codeString))
          return _899413;
        if ("899414".equals(codeString))
          return _899414;
        if ("899415".equals(codeString))
          return _899415;
        if ("899500".equals(codeString))
          return _899500;
        if ("899511".equals(codeString))
          return _899511;
        if ("899512".equals(codeString))
          return _899512;
        if ("899611".equals(codeString))
          return _899611;
        if ("899711".equals(codeString))
          return _899711;
        if ("899900".equals(codeString))
          return _899900;
        if ("899911".equals(codeString))
          return _899911;
        if ("899912".equals(codeString))
          return _899912;
        if ("899913".equals(codeString))
          return _899913;
        if ("899914".equals(codeString))
          return _899914;
        if ("899915".equals(codeString))
          return _899915;
        if ("899916".equals(codeString))
          return _899916;
        if ("899917".equals(codeString))
          return _899917;
        if ("899918".equals(codeString))
          return _899918;
        if ("899921".equals(codeString))
          return _899921;
        if ("899922".equals(codeString))
          return _899922;
        if ("899999".equals(codeString))
          return _899999;
        throw new FHIRException("Unknown AnzscoOccupations code '"+codeString+"'");
        }
        public String toCode() {
          switch (this) {
            case _100000: return "100000";
            case _111000: return "111000";
            case _111111: return "111111";
            case _111200: return "111200";
            case _111211: return "111211";
            case _111212: return "111212";
            case _111300: return "111300";
            case _111311: return "111311";
            case _111312: return "111312";
            case _111399: return "111399";
            case _121000: return "121000";
            case _121111: return "121111";
            case _121200: return "121200";
            case _121211: return "121211";
            case _121212: return "121212";
            case _121213: return "121213";
            case _121214: return "121214";
            case _121215: return "121215";
            case _121216: return "121216";
            case _121217: return "121217";
            case _121218: return "121218";
            case _121221: return "121221";
            case _121299: return "121299";
            case _121300: return "121300";
            case _121311: return "121311";
            case _121312: return "121312";
            case _121313: return "121313";
            case _121314: return "121314";
            case _121315: return "121315";
            case _121316: return "121316";
            case _121317: return "121317";
            case _121318: return "121318";
            case _121321: return "121321";
            case _121322: return "121322";
            case _121399: return "121399";
            case _121411: return "121411";
            case _130000: return "130000";
            case _131100: return "131100";
            case _131111: return "131111";
            case _131112: return "131112";
            case _132000: return "132000";
            case _132111: return "132111";
            case _132211: return "132211";
            case _132311: return "132311";
            case _132411: return "132411";
            case _132511: return "132511";
            case _133000: return "133000";
            case _133100: return "133100";
            case _133111: return "133111";
            case _133112: return "133112";
            case _133211: return "133211";
            case _133300: return "133300";
            case _133311: return "133311";
            case _133312: return "133312";
            case _133411: return "133411";
            case _133500: return "133500";
            case _133511: return "133511";
            case _133512: return "133512";
            case _133513: return "133513";
            case _133611: return "133611";
            case _134000: return "134000";
            case _134111: return "134111";
            case _134200: return "134200";
            case _134211: return "134211";
            case _134212: return "134212";
            case _134213: return "134213";
            case _134214: return "134214";
            case _134299: return "134299";
            case _134311: return "134311";
            case _134400: return "134400";
            case _134411: return "134411";
            case _134412: return "134412";
            case _134499: return "134499";
            case _135100: return "135100";
            case _135111: return "135111";
            case _135112: return "135112";
            case _135199: return "135199";
            case _139000: return "139000";
            case _139100: return "139100";
            case _139111: return "139111";
            case _139112: return "139112";
            case _139113: return "139113";
            case _139211: return "139211";
            case _139900: return "139900";
            case _139911: return "139911";
            case _139912: return "139912";
            case _139913: return "139913";
            case _139914: return "139914";
            case _139915: return "139915";
            case _139999: return "139999";
            case _140000: return "140000";
            case _141000: return "141000";
            case _141111: return "141111";
            case _141211: return "141211";
            case _141311: return "141311";
            case _141411: return "141411";
            case _141900: return "141900";
            case _141911: return "141911";
            case _141999: return "141999";
            case _142100: return "142100";
            case _142111: return "142111";
            case _142112: return "142112";
            case _142113: return "142113";
            case _142114: return "142114";
            case _142115: return "142115";
            case _142116: return "142116";
            case _149000: return "149000";
            case _149100: return "149100";
            case _149111: return "149111";
            case _149112: return "149112";
            case _149113: return "149113";
            case _149200: return "149200";
            case _149211: return "149211";
            case _149212: return "149212";
            case _149311: return "149311";
            case _149400: return "149400";
            case _149411: return "149411";
            case _149412: return "149412";
            case _149413: return "149413";
            case _149900: return "149900";
            case _149911: return "149911";
            case _149912: return "149912";
            case _149913: return "149913";
            case _149914: return "149914";
            case _149999: return "149999";
            case _200000: return "200000";
            case _210000: return "210000";
            case _211000: return "211000";
            case _211100: return "211100";
            case _211111: return "211111";
            case _211112: return "211112";
            case _211113: return "211113";
            case _211199: return "211199";
            case _211200: return "211200";
            case _211211: return "211211";
            case _211212: return "211212";
            case _211213: return "211213";
            case _211214: return "211214";
            case _211299: return "211299";
            case _211311: return "211311";
            case _211400: return "211400";
            case _211411: return "211411";
            case _211412: return "211412";
            case _211413: return "211413";
            case _211499: return "211499";
            case _212000: return "212000";
            case _212100: return "212100";
            case _212111: return "212111";
            case _212112: return "212112";
            case _212113: return "212113";
            case _212114: return "212114";
            case _212200: return "212200";
            case _212211: return "212211";
            case _212212: return "212212";
            case _212300: return "212300";
            case _212311: return "212311";
            case _212312: return "212312";
            case _212313: return "212313";
            case _212314: return "212314";
            case _212315: return "212315";
            case _212316: return "212316";
            case _212317: return "212317";
            case _212318: return "212318";
            case _212399: return "212399";
            case _212400: return "212400";
            case _212411: return "212411";
            case _212412: return "212412";
            case _212413: return "212413";
            case _212414: return "212414";
            case _212415: return "212415";
            case _212416: return "212416";
            case _212499: return "212499";
            case _220000: return "220000";
            case _221000: return "221000";
            case _221100: return "221100";
            case _221111: return "221111";
            case _221112: return "221112";
            case _221113: return "221113";
            case _221200: return "221200";
            case _221211: return "221211";
            case _221212: return "221212";
            case _221213: return "221213";
            case _221214: return "221214";
            case _222000: return "222000";
            case _222100: return "222100";
            case _222111: return "222111";
            case _222112: return "222112";
            case _222113: return "222113";
            case _222199: return "222199";
            case _222200: return "222200";
            case _222211: return "222211";
            case _222212: return "222212";
            case _222213: return "222213";
            case _222299: return "222299";
            case _222300: return "222300";
            case _222311: return "222311";
            case _222312: return "222312";
            case _223000: return "223000";
            case _223100: return "223100";
            case _223111: return "223111";
            case _223112: return "223112";
            case _223113: return "223113";
            case _223211: return "223211";
            case _223311: return "223311";
            case _224000: return "224000";
            case _224100: return "224100";
            case _224111: return "224111";
            case _224112: return "224112";
            case _224113: return "224113";
            case _224200: return "224200";
            case _224211: return "224211";
            case _224212: return "224212";
            case _224213: return "224213";
            case _224214: return "224214";
            case _224311: return "224311";
            case _224400: return "224400";
            case _224411: return "224411";
            case _224412: return "224412";
            case _224500: return "224500";
            case _224511: return "224511";
            case _224512: return "224512";
            case _224611: return "224611";
            case _224700: return "224700";
            case _224711: return "224711";
            case _224712: return "224712";
            case _224900: return "224900";
            case _224911: return "224911";
            case _224912: return "224912";
            case _224913: return "224913";
            case _224914: return "224914";
            case _224999: return "224999";
            case _225000: return "225000";
            case _225100: return "225100";
            case _225111: return "225111";
            case _225112: return "225112";
            case _225113: return "225113";
            case _225200: return "225200";
            case _225211: return "225211";
            case _225212: return "225212";
            case _225213: return "225213";
            case _225311: return "225311";
            case _225400: return "225400";
            case _225411: return "225411";
            case _225412: return "225412";
            case _225499: return "225499";
            case _230000: return "230000";
            case _231000: return "231000";
            case _231100: return "231100";
            case _231111: return "231111";
            case _231112: return "231112";
            case _231113: return "231113";
            case _231114: return "231114";
            case _231199: return "231199";
            case _231200: return "231200";
            case _231211: return "231211";
            case _231212: return "231212";
            case _231213: return "231213";
            case _231214: return "231214";
            case _231215: return "231215";
            case _231299: return "231299";
            case _232000: return "232000";
            case _232100: return "232100";
            case _232111: return "232111";
            case _232112: return "232112";
            case _232200: return "232200";
            case _232211: return "232211";
            case _232212: return "232212";
            case _232300: return "232300";
            case _232311: return "232311";
            case _232312: return "232312";
            case _232313: return "232313";
            case _232400: return "232400";
            case _232411: return "232411";
            case _232412: return "232412";
            case _232413: return "232413";
            case _232414: return "232414";
            case _232511: return "232511";
            case _232611: return "232611";
            case _233000: return "233000";
            case _233100: return "233100";
            case _233111: return "233111";
            case _233112: return "233112";
            case _233200: return "233200";
            case _233211: return "233211";
            case _233212: return "233212";
            case _233213: return "233213";
            case _233214: return "233214";
            case _233215: return "233215";
            case _233311: return "233311";
            case _233411: return "233411";
            case _233500: return "233500";
            case _233511: return "233511";
            case _233512: return "233512";
            case _233513: return "233513";
            case _233600: return "233600";
            case _233611: return "233611";
            case _233612: return "233612";
            case _233900: return "233900";
            case _233911: return "233911";
            case _233912: return "233912";
            case _233913: return "233913";
            case _233914: return "233914";
            case _233915: return "233915";
            case _233916: return "233916";
            case _233999: return "233999";
            case _234000: return "234000";
            case _234100: return "234100";
            case _234111: return "234111";
            case _234112: return "234112";
            case _234113: return "234113";
            case _234200: return "234200";
            case _234211: return "234211";
            case _234212: return "234212";
            case _234213: return "234213";
            case _234300: return "234300";
            case _234311: return "234311";
            case _234312: return "234312";
            case _234313: return "234313";
            case _234314: return "234314";
            case _234399: return "234399";
            case _234400: return "234400";
            case _234411: return "234411";
            case _234412: return "234412";
            case _234500: return "234500";
            case _234511: return "234511";
            case _234512: return "234512";
            case _234513: return "234513";
            case _234514: return "234514";
            case _234515: return "234515";
            case _234516: return "234516";
            case _234517: return "234517";
            case _234518: return "234518";
            case _234599: return "234599";
            case _234611: return "234611";
            case _234711: return "234711";
            case _234900: return "234900";
            case _234911: return "234911";
            case _234912: return "234912";
            case _234913: return "234913";
            case _234914: return "234914";
            case _234999: return "234999";
            case _240000: return "240000";
            case _241000: return "241000";
            case _241111: return "241111";
            case _241213: return "241213";
            case _241311: return "241311";
            case _241411: return "241411";
            case _241500: return "241500";
            case _241511: return "241511";
            case _241512: return "241512";
            case _241513: return "241513";
            case _241599: return "241599";
            case _242000: return "242000";
            case _242100: return "242100";
            case _242111: return "242111";
            case _242112: return "242112";
            case _242211: return "242211";
            case _249000: return "249000";
            case _249100: return "249100";
            case _249111: return "249111";
            case _249112: return "249112";
            case _249200: return "249200";
            case _249211: return "249211";
            case _249212: return "249212";
            case _249213: return "249213";
            case _249214: return "249214";
            case _249299: return "249299";
            case _249311: return "249311";
            case _250000: return "250000";
            case _251000: return "251000";
            case _251111: return "251111";
            case _251200: return "251200";
            case _251211: return "251211";
            case _251212: return "251212";
            case _251213: return "251213";
            case _251214: return "251214";
            case _251300: return "251300";
            case _251311: return "251311";
            case _251312: return "251312";
            case _251400: return "251400";
            case _251411: return "251411";
            case _251412: return "251412";
            case _251500: return "251500";
            case _251511: return "251511";
            case _251512: return "251512";
            case _251513: return "251513";
            case _251900: return "251900";
            case _251911: return "251911";
            case _251912: return "251912";
            case _251999: return "251999";
            case _252000: return "252000";
            case _252100: return "252100";
            case _252111: return "252111";
            case _252112: return "252112";
            case _252200: return "252200";
            case _252211: return "252211";
            case _252212: return "252212";
            case _252213: return "252213";
            case _252214: return "252214";
            case _252299: return "252299";
            case _252300: return "252300";
            case _252311: return "252311";
            case _252312: return "252312";
            case _252411: return "252411";
            case _252511: return "252511";
            case _252611: return "252611";
            case _252700: return "252700";
            case _252711: return "252711";
            case _252712: return "252712";
            case _253000: return "253000";
            case _253100: return "253100";
            case _253111: return "253111";
            case _253112: return "253112";
            case _253211: return "253211";
            case _253300: return "253300";
            case _253311: return "253311";
            case _253312: return "253312";
            case _253313: return "253313";
            case _253314: return "253314";
            case _253315: return "253315";
            case _253316: return "253316";
            case _253317: return "253317";
            case _253318: return "253318";
            case _253321: return "253321";
            case _253322: return "253322";
            case _253323: return "253323";
            case _253324: return "253324";
            case _253399: return "253399";
            case _253411: return "253411";
            case _253500: return "253500";
            case _253511: return "253511";
            case _253512: return "253512";
            case _253513: return "253513";
            case _253514: return "253514";
            case _253515: return "253515";
            case _253516: return "253516";
            case _253517: return "253517";
            case _253518: return "253518";
            case _253521: return "253521";
            case _253900: return "253900";
            case _253911: return "253911";
            case _253912: return "253912";
            case _253913: return "253913";
            case _253914: return "253914";
            case _253915: return "253915";
            case _253916: return "253916";
            case _253999: return "253999";
            case _254000: return "254000";
            case _254111: return "254111";
            case _254200: return "254200";
            case _254211: return "254211";
            case _254212: return "254212";
            case _254311: return "254311";
            case _254400: return "254400";
            case _254411: return "254411";
            case _254412: return "254412";
            case _254413: return "254413";
            case _254414: return "254414";
            case _254415: return "254415";
            case _254416: return "254416";
            case _254417: return "254417";
            case _254418: return "254418";
            case _254421: return "254421";
            case _254422: return "254422";
            case _254423: return "254423";
            case _254424: return "254424";
            case _254499: return "254499";
            case _260000: return "260000";
            case _261000: return "261000";
            case _261100: return "261100";
            case _261111: return "261111";
            case _261112: return "261112";
            case _261200: return "261200";
            case _261211: return "261211";
            case _261212: return "261212";
            case _261300: return "261300";
            case _261311: return "261311";
            case _261312: return "261312";
            case _261313: return "261313";
            case _261399: return "261399";
            case _262100: return "262100";
            case _262111: return "262111";
            case _262112: return "262112";
            case _262113: return "262113";
            case _263000: return "263000";
            case _263100: return "263100";
            case _263111: return "263111";
            case _263112: return "263112";
            case _263113: return "263113";
            case _263200: return "263200";
            case _263211: return "263211";
            case _263212: return "263212";
            case _263213: return "263213";
            case _263299: return "263299";
            case _263300: return "263300";
            case _263311: return "263311";
            case _263312: return "263312";
            case _270000: return "270000";
            case _271000: return "271000";
            case _271111: return "271111";
            case _271200: return "271200";
            case _271211: return "271211";
            case _271212: return "271212";
            case _271213: return "271213";
            case _271299: return "271299";
            case _271311: return "271311";
            case _272000: return "272000";
            case _272100: return "272100";
            case _272111: return "272111";
            case _272112: return "272112";
            case _272113: return "272113";
            case _272114: return "272114";
            case _272115: return "272115";
            case _272199: return "272199";
            case _272211: return "272211";
            case _272300: return "272300";
            case _272311: return "272311";
            case _272312: return "272312";
            case _272313: return "272313";
            case _272314: return "272314";
            case _272399: return "272399";
            case _272400: return "272400";
            case _272411: return "272411";
            case _272412: return "272412";
            case _272413: return "272413";
            case _272499: return "272499";
            case _272511: return "272511";
            case _272600: return "272600";
            case _272611: return "272611";
            case _272612: return "272612";
            case _272613: return "272613";
            case _300000: return "300000";
            case _310000: return "310000";
            case _311000: return "311000";
            case _311111: return "311111";
            case _311200: return "311200";
            case _311211: return "311211";
            case _311212: return "311212";
            case _311213: return "311213";
            case _311214: return "311214";
            case _311215: return "311215";
            case _311299: return "311299";
            case _311300: return "311300";
            case _311311: return "311311";
            case _311312: return "311312";
            case _311313: return "311313";
            case _311399: return "311399";
            case _311400: return "311400";
            case _311411: return "311411";
            case _311412: return "311412";
            case _311413: return "311413";
            case _311414: return "311414";
            case _311499: return "311499";
            case _312000: return "312000";
            case _312100: return "312100";
            case _312111: return "312111";
            case _312112: return "312112";
            case _312113: return "312113";
            case _312114: return "312114";
            case _312115: return "312115";
            case _312116: return "312116";
            case _312200: return "312200";
            case _312211: return "312211";
            case _312212: return "312212";
            case _312300: return "312300";
            case _312311: return "312311";
            case _312312: return "312312";
            case _312400: return "312400";
            case _312411: return "312411";
            case _312412: return "312412";
            case _312500: return "312500";
            case _312511: return "312511";
            case _312512: return "312512";
            case _312611: return "312611";
            case _312900: return "312900";
            case _312911: return "312911";
            case _312912: return "312912";
            case _312913: return "312913";
            case _312999: return "312999";
            case _313000: return "313000";
            case _313100: return "313100";
            case _313111: return "313111";
            case _313112: return "313112";
            case _313113: return "313113";
            case _313199: return "313199";
            case _313200: return "313200";
            case _313211: return "313211";
            case _313212: return "313212";
            case _313213: return "313213";
            case _313214: return "313214";
            case _320000: return "320000";
            case _321000: return "321000";
            case _321111: return "321111";
            case _321200: return "321200";
            case _321211: return "321211";
            case _321212: return "321212";
            case _321213: return "321213";
            case _321214: return "321214";
            case _322000: return "322000";
            case _322100: return "322100";
            case _322111: return "322111";
            case _322112: return "322112";
            case _322113: return "322113";
            case _322114: return "322114";
            case _322115: return "322115";
            case _322211: return "322211";
            case _322300: return "322300";
            case _322311: return "322311";
            case _322312: return "322312";
            case _322313: return "322313";
            case _323000: return "323000";
            case _323100: return "323100";
            case _323111: return "323111";
            case _323112: return "323112";
            case _323113: return "323113";
            case _323200: return "323200";
            case _323211: return "323211";
            case _323212: return "323212";
            case _323213: return "323213";
            case _323214: return "323214";
            case _323215: return "323215";
            case _323299: return "323299";
            case _323300: return "323300";
            case _323311: return "323311";
            case _323312: return "323312";
            case _323313: return "323313";
            case _323314: return "323314";
            case _323315: return "323315";
            case _323316: return "323316";
            case _323400: return "323400";
            case _323411: return "323411";
            case _323412: return "323412";
            case _324000: return "324000";
            case _324111: return "324111";
            case _324200: return "324200";
            case _324211: return "324211";
            case _324212: return "324212";
            case _324311: return "324311";
            case _330000: return "330000";
            case _331000: return "331000";
            case _331100: return "331100";
            case _331111: return "331111";
            case _331112: return "331112";
            case _331211: return "331211";
            case _331212: return "331212";
            case _331213: return "331213";
            case _332000: return "332000";
            case _332111: return "332111";
            case _332211: return "332211";
            case _333000: return "333000";
            case _333111: return "333111";
            case _333200: return "333200";
            case _333211: return "333211";
            case _333212: return "333212";
            case _333311: return "333311";
            case _333411: return "333411";
            case _334100: return "334100";
            case _334111: return "334111";
            case _334112: return "334112";
            case _334113: return "334113";
            case _334114: return "334114";
            case _334115: return "334115";
            case _340000: return "340000";
            case _341100: return "341100";
            case _341111: return "341111";
            case _341112: return "341112";
            case _341113: return "341113";
            case _342000: return "342000";
            case _342111: return "342111";
            case _342200: return "342200";
            case _342211: return "342211";
            case _342212: return "342212";
            case _342300: return "342300";
            case _342311: return "342311";
            case _342312: return "342312";
            case _342313: return "342313";
            case _342314: return "342314";
            case _342315: return "342315";
            case _342400: return "342400";
            case _342411: return "342411";
            case _342412: return "342412";
            case _342413: return "342413";
            case _342414: return "342414";
            case _351000: return "351000";
            case _351100: return "351100";
            case _351111: return "351111";
            case _351112: return "351112";
            case _351211: return "351211";
            case _351311: return "351311";
            case _351411: return "351411";
            case _360000: return "360000";
            case _361000: return "361000";
            case _361100: return "361100";
            case _361111: return "361111";
            case _361112: return "361112";
            case _361113: return "361113";
            case _361114: return "361114";
            case _361199: return "361199";
            case _361211: return "361211";
            case _361311: return "361311";
            case _362000: return "362000";
            case _362111: return "362111";
            case _362200: return "362200";
            case _362211: return "362211";
            case _362212: return "362212";
            case _362213: return "362213";
            case _362311: return "362311";
            case _362411: return "362411";
            case _390000: return "390000";
            case _391111: return "391111";
            case _392000: return "392000";
            case _392100: return "392100";
            case _392111: return "392111";
            case _392112: return "392112";
            case _392211: return "392211";
            case _392300: return "392300";
            case _392311: return "392311";
            case _392312: return "392312";
            case _393000: return "393000";
            case _393100: return "393100";
            case _393111: return "393111";
            case _393112: return "393112";
            case _393113: return "393113";
            case _393114: return "393114";
            case _393200: return "393200";
            case _393211: return "393211";
            case _393212: return "393212";
            case _393213: return "393213";
            case _393299: return "393299";
            case _393311: return "393311";
            case _394000: return "394000";
            case _394111: return "394111";
            case _394200: return "394200";
            case _394211: return "394211";
            case _394212: return "394212";
            case _394213: return "394213";
            case _394214: return "394214";
            case _394299: return "394299";
            case _399000: return "399000";
            case _399100: return "399100";
            case _399111: return "399111";
            case _399112: return "399112";
            case _399200: return "399200";
            case _399211: return "399211";
            case _399212: return "399212";
            case _399213: return "399213";
            case _399300: return "399300";
            case _399311: return "399311";
            case _399312: return "399312";
            case _399411: return "399411";
            case _399500: return "399500";
            case _399511: return "399511";
            case _399512: return "399512";
            case _399513: return "399513";
            case _399514: return "399514";
            case _399515: return "399515";
            case _399516: return "399516";
            case _399517: return "399517";
            case _399599: return "399599";
            case _399611: return "399611";
            case _399900: return "399900";
            case _399911: return "399911";
            case _399912: return "399912";
            case _399913: return "399913";
            case _399914: return "399914";
            case _399915: return "399915";
            case _399916: return "399916";
            case _399917: return "399917";
            case _399999: return "399999";
            case _400000: return "400000";
            case _411000: return "411000";
            case _411100: return "411100";
            case _411111: return "411111";
            case _411112: return "411112";
            case _411200: return "411200";
            case _411211: return "411211";
            case _411212: return "411212";
            case _411213: return "411213";
            case _411214: return "411214";
            case _411311: return "411311";
            case _411400: return "411400";
            case _411411: return "411411";
            case _411412: return "411412";
            case _411511: return "411511";
            case _411611: return "411611";
            case _411700: return "411700";
            case _411711: return "411711";
            case _411712: return "411712";
            case _411713: return "411713";
            case _411714: return "411714";
            case _411715: return "411715";
            case _411716: return "411716";
            case _420000: return "420000";
            case _421100: return "421100";
            case _421111: return "421111";
            case _421112: return "421112";
            case _421113: return "421113";
            case _421114: return "421114";
            case _422100: return "422100";
            case _422111: return "422111";
            case _422112: return "422112";
            case _422115: return "422115";
            case _422116: return "422116";
            case _423000: return "423000";
            case _423111: return "423111";
            case _423211: return "423211";
            case _423300: return "423300";
            case _423311: return "423311";
            case _423312: return "423312";
            case _423313: return "423313";
            case _423314: return "423314";
            case _423400: return "423400";
            case _423411: return "423411";
            case _423412: return "423412";
            case _423413: return "423413";
            case _431000: return "431000";
            case _431100: return "431100";
            case _431111: return "431111";
            case _431112: return "431112";
            case _431211: return "431211";
            case _431311: return "431311";
            case _431411: return "431411";
            case _431511: return "431511";
            case _431900: return "431900";
            case _431911: return "431911";
            case _431912: return "431912";
            case _431999: return "431999";
            case _440000: return "440000";
            case _441000: return "441000";
            case _441111: return "441111";
            case _441200: return "441200";
            case _441211: return "441211";
            case _441212: return "441212";
            case _441300: return "441300";
            case _441311: return "441311";
            case _441312: return "441312";
            case _442000: return "442000";
            case _442111: return "442111";
            case _442200: return "442200";
            case _442211: return "442211";
            case _442212: return "442212";
            case _442213: return "442213";
            case _442214: return "442214";
            case _442215: return "442215";
            case _442216: return "442216";
            case _442217: return "442217";
            case _442299: return "442299";
            case _450000: return "450000";
            case _451000: return "451000";
            case _451111: return "451111";
            case _451211: return "451211";
            case _451300: return "451300";
            case _451311: return "451311";
            case _451399: return "451399";
            case _451400: return "451400";
            case _451411: return "451411";
            case _451412: return "451412";
            case _451500: return "451500";
            case _451511: return "451511";
            case _451512: return "451512";
            case _451600: return "451600";
            case _451611: return "451611";
            case _451612: return "451612";
            case _451700: return "451700";
            case _451711: return "451711";
            case _451799: return "451799";
            case _451800: return "451800";
            case _451811: return "451811";
            case _451812: return "451812";
            case _451813: return "451813";
            case _451899: return "451899";
            case _452000: return "452000";
            case _452111: return "452111";
            case _452200: return "452200";
            case _452211: return "452211";
            case _452212: return "452212";
            case _452213: return "452213";
            case _452214: return "452214";
            case _452215: return "452215";
            case _452216: return "452216";
            case _452217: return "452217";
            case _452299: return "452299";
            case _452300: return "452300";
            case _452311: return "452311";
            case _452312: return "452312";
            case _452313: return "452313";
            case _452314: return "452314";
            case _452315: return "452315";
            case _452316: return "452316";
            case _452317: return "452317";
            case _452318: return "452318";
            case _452321: return "452321";
            case _452322: return "452322";
            case _452323: return "452323";
            case _452400: return "452400";
            case _452411: return "452411";
            case _452412: return "452412";
            case _452413: return "452413";
            case _452414: return "452414";
            case _452499: return "452499";
            case _500000: return "500000";
            case _510000: return "510000";
            case _511100: return "511100";
            case _511111: return "511111";
            case _511112: return "511112";
            case _512000: return "512000";
            case _512111: return "512111";
            case _512200: return "512200";
            case _512211: return "512211";
            case _512299: return "512299";
            case _521000: return "521000";
            case _521111: return "521111";
            case _521200: return "521200";
            case _521211: return "521211";
            case _521212: return "521212";
            case _530000: return "530000";
            case _531111: return "531111";
            case _532100: return "532100";
            case _532111: return "532111";
            case _532112: return "532112";
            case _532113: return "532113";
            case _540000: return "540000";
            case _541000: return "541000";
            case _541100: return "541100";
            case _541111: return "541111";
            case _541112: return "541112";
            case _541211: return "541211";
            case _542100: return "542100";
            case _542111: return "542111";
            case _542112: return "542112";
            case _542113: return "542113";
            case _542114: return "542114";
            case _550000: return "550000";
            case _551000: return "551000";
            case _551100: return "551100";
            case _551111: return "551111";
            case _551112: return "551112";
            case _551211: return "551211";
            case _551311: return "551311";
            case _552000: return "552000";
            case _552111: return "552111";
            case _552211: return "552211";
            case _552300: return "552300";
            case _552311: return "552311";
            case _552312: return "552312";
            case _552313: return "552313";
            case _552314: return "552314";
            case _561000: return "561000";
            case _561100: return "561100";
            case _561111: return "561111";
            case _561112: return "561112";
            case _561113: return "561113";
            case _561199: return "561199";
            case _561200: return "561200";
            case _561211: return "561211";
            case _561212: return "561212";
            case _561311: return "561311";
            case _561400: return "561400";
            case _561411: return "561411";
            case _561412: return "561412";
            case _561511: return "561511";
            case _561611: return "561611";
            case _561900: return "561900";
            case _561911: return "561911";
            case _561912: return "561912";
            case _561913: return "561913";
            case _561999: return "561999";
            case _590000: return "590000";
            case _591000: return "591000";
            case _591100: return "591100";
            case _591111: return "591111";
            case _591112: return "591112";
            case _591113: return "591113";
            case _591114: return "591114";
            case _591115: return "591115";
            case _591116: return "591116";
            case _591200: return "591200";
            case _591211: return "591211";
            case _591212: return "591212";
            case _599000: return "599000";
            case _599100: return "599100";
            case _599111: return "599111";
            case _599112: return "599112";
            case _599200: return "599200";
            case _599211: return "599211";
            case _599212: return "599212";
            case _599213: return "599213";
            case _599214: return "599214";
            case _599215: return "599215";
            case _599311: return "599311";
            case _599411: return "599411";
            case _599500: return "599500";
            case _599511: return "599511";
            case _599512: return "599512";
            case _599513: return "599513";
            case _599514: return "599514";
            case _599515: return "599515";
            case _599516: return "599516";
            case _599517: return "599517";
            case _599518: return "599518";
            case _599521: return "599521";
            case _599599: return "599599";
            case _599600: return "599600";
            case _599611: return "599611";
            case _599612: return "599612";
            case _599613: return "599613";
            case _599711: return "599711";
            case _599900: return "599900";
            case _599911: return "599911";
            case _599912: return "599912";
            case _599913: return "599913";
            case _599914: return "599914";
            case _599999: return "599999";
            case _600000: return "600000";
            case _610000: return "610000";
            case _611000: return "611000";
            case _611100: return "611100";
            case _611111: return "611111";
            case _611112: return "611112";
            case _611211: return "611211";
            case _611300: return "611300";
            case _611311: return "611311";
            case _611312: return "611312";
            case _611313: return "611313";
            case _611314: return "611314";
            case _611399: return "611399";
            case _612100: return "612100";
            case _612111: return "612111";
            case _612112: return "612112";
            case _612113: return "612113";
            case _612114: return "612114";
            case _612115: return "612115";
            case _621000: return "621000";
            case _621111: return "621111";
            case _621211: return "621211";
            case _621300: return "621300";
            case _621311: return "621311";
            case _621312: return "621312";
            case _621411: return "621411";
            case _621511: return "621511";
            case _621611: return "621611";
            case _621700: return "621700";
            case _621711: return "621711";
            case _621712: return "621712";
            case _621713: return "621713";
            case _621900: return "621900";
            case _621911: return "621911";
            case _621912: return "621912";
            case _621999: return "621999";
            case _630000: return "630000";
            case _631100: return "631100";
            case _631111: return "631111";
            case _631112: return "631112";
            case _639000: return "639000";
            case _639100: return "639100";
            case _639111: return "639111";
            case _639112: return "639112";
            case _639200: return "639200";
            case _639211: return "639211";
            case _639212: return "639212";
            case _639311: return "639311";
            case _639400: return "639400";
            case _639411: return "639411";
            case _639412: return "639412";
            case _639511: return "639511";
            case _639911: return "639911";
            case _700000: return "700000";
            case _710000: return "710000";
            case _711000: return "711000";
            case _711100: return "711100";
            case _711111: return "711111";
            case _711112: return "711112";
            case _711113: return "711113";
            case _711114: return "711114";
            case _711199: return "711199";
            case _711211: return "711211";
            case _711300: return "711300";
            case _711311: return "711311";
            case _711312: return "711312";
            case _711411: return "711411";
            case _711500: return "711500";
            case _711511: return "711511";
            case _711512: return "711512";
            case _711513: return "711513";
            case _711514: return "711514";
            case _711515: return "711515";
            case _711516: return "711516";
            case _711599: return "711599";
            case _711611: return "711611";
            case _711700: return "711700";
            case _711711: return "711711";
            case _711712: return "711712";
            case _711713: return "711713";
            case _711714: return "711714";
            case _711715: return "711715";
            case _711716: return "711716";
            case _711799: return "711799";
            case _711900: return "711900";
            case _711911: return "711911";
            case _711912: return "711912";
            case _711913: return "711913";
            case _711914: return "711914";
            case _711999: return "711999";
            case _712000: return "712000";
            case _712111: return "712111";
            case _712200: return "712200";
            case _712211: return "712211";
            case _712212: return "712212";
            case _712213: return "712213";
            case _712311: return "712311";
            case _712900: return "712900";
            case _712911: return "712911";
            case _712912: return "712912";
            case _712913: return "712913";
            case _712914: return "712914";
            case _712915: return "712915";
            case _712916: return "712916";
            case _712917: return "712917";
            case _712918: return "712918";
            case _712921: return "712921";
            case _712922: return "712922";
            case _712999: return "712999";
            case _721000: return "721000";
            case _721100: return "721100";
            case _721111: return "721111";
            case _721112: return "721112";
            case _721200: return "721200";
            case _721211: return "721211";
            case _721212: return "721212";
            case _721213: return "721213";
            case _721214: return "721214";
            case _721215: return "721215";
            case _721216: return "721216";
            case _721311: return "721311";
            case _721900: return "721900";
            case _721911: return "721911";
            case _721912: return "721912";
            case _721913: return "721913";
            case _721914: return "721914";
            case _721915: return "721915";
            case _721916: return "721916";
            case _721999: return "721999";
            case _730000: return "730000";
            case _731000: return "731000";
            case _731100: return "731100";
            case _731111: return "731111";
            case _731112: return "731112";
            case _731199: return "731199";
            case _731200: return "731200";
            case _731211: return "731211";
            case _731212: return "731212";
            case _731213: return "731213";
            case _731300: return "731300";
            case _731311: return "731311";
            case _731312: return "731312";
            case _732111: return "732111";
            case _733100: return "733100";
            case _733111: return "733111";
            case _733112: return "733112";
            case _733113: return "733113";
            case _733114: return "733114";
            case _733115: return "733115";
            case _741111: return "741111";
            case _800000: return "800000";
            case _811000: return "811000";
            case _811111: return "811111";
            case _811211: return "811211";
            case _811311: return "811311";
            case _811400: return "811400";
            case _811411: return "811411";
            case _811412: return "811412";
            case _811500: return "811500";
            case _811511: return "811511";
            case _811512: return "811512";
            case _811513: return "811513";
            case _811600: return "811600";
            case _811611: return "811611";
            case _811612: return "811612";
            case _811699: return "811699";
            case _821000: return "821000";
            case _821100: return "821100";
            case _821111: return "821111";
            case _821112: return "821112";
            case _821113: return "821113";
            case _821114: return "821114";
            case _821211: return "821211";
            case _821311: return "821311";
            case _821400: return "821400";
            case _821411: return "821411";
            case _821412: return "821412";
            case _821511: return "821511";
            case _821611: return "821611";
            case _821700: return "821700";
            case _821711: return "821711";
            case _821712: return "821712";
            case _821713: return "821713";
            case _821714: return "821714";
            case _821900: return "821900";
            case _821911: return "821911";
            case _821912: return "821912";
            case _821913: return "821913";
            case _821914: return "821914";
            case _821915: return "821915";
            case _830000: return "830000";
            case _831000: return "831000";
            case _831100: return "831100";
            case _831111: return "831111";
            case _831112: return "831112";
            case _831113: return "831113";
            case _831114: return "831114";
            case _831115: return "831115";
            case _831116: return "831116";
            case _831117: return "831117";
            case _831118: return "831118";
            case _831199: return "831199";
            case _831200: return "831200";
            case _831211: return "831211";
            case _831212: return "831212";
            case _831300: return "831300";
            case _831311: return "831311";
            case _831312: return "831312";
            case _831313: return "831313";
            case _832000: return "832000";
            case _832100: return "832100";
            case _832111: return "832111";
            case _832112: return "832112";
            case _832113: return "832113";
            case _832114: return "832114";
            case _832115: return "832115";
            case _832199: return "832199";
            case _832211: return "832211";
            case _839000: return "839000";
            case _839111: return "839111";
            case _839200: return "839200";
            case _839211: return "839211";
            case _839212: return "839212";
            case _839300: return "839300";
            case _839311: return "839311";
            case _839312: return "839312";
            case _839313: return "839313";
            case _839400: return "839400";
            case _839411: return "839411";
            case _839412: return "839412";
            case _839413: return "839413";
            case _839900: return "839900";
            case _839911: return "839911";
            case _839912: return "839912";
            case _839913: return "839913";
            case _839914: return "839914";
            case _839915: return "839915";
            case _839916: return "839916";
            case _839917: return "839917";
            case _839999: return "839999";
            case _841000: return "841000";
            case _841111: return "841111";
            case _841200: return "841200";
            case _841211: return "841211";
            case _841212: return "841212";
            case _841213: return "841213";
            case _841214: return "841214";
            case _841215: return "841215";
            case _841216: return "841216";
            case _841299: return "841299";
            case _841300: return "841300";
            case _841311: return "841311";
            case _841312: return "841312";
            case _841313: return "841313";
            case _841400: return "841400";
            case _841411: return "841411";
            case _841412: return "841412";
            case _841500: return "841500";
            case _841511: return "841511";
            case _841512: return "841512";
            case _841513: return "841513";
            case _841514: return "841514";
            case _841515: return "841515";
            case _841516: return "841516";
            case _841517: return "841517";
            case _841599: return "841599";
            case _841611: return "841611";
            case _841900: return "841900";
            case _841911: return "841911";
            case _841912: return "841912";
            case _841999: return "841999";
            case _851000: return "851000";
            case _851111: return "851111";
            case _851200: return "851200";
            case _851211: return "851211";
            case _851299: return "851299";
            case _851311: return "851311";
            case _890000: return "890000";
            case _891000: return "891000";
            case _891100: return "891100";
            case _891111: return "891111";
            case _891112: return "891112";
            case _891113: return "891113";
            case _891211: return "891211";
            case _899000: return "899000";
            case _899111: return "899111";
            case _899200: return "899200";
            case _899211: return "899211";
            case _899212: return "899212";
            case _899311: return "899311";
            case _899400: return "899400";
            case _899411: return "899411";
            case _899412: return "899412";
            case _899413: return "899413";
            case _899414: return "899414";
            case _899415: return "899415";
            case _899500: return "899500";
            case _899511: return "899511";
            case _899512: return "899512";
            case _899611: return "899611";
            case _899711: return "899711";
            case _899900: return "899900";
            case _899911: return "899911";
            case _899912: return "899912";
            case _899913: return "899913";
            case _899914: return "899914";
            case _899915: return "899915";
            case _899916: return "899916";
            case _899917: return "899917";
            case _899918: return "899918";
            case _899921: return "899921";
            case _899922: return "899922";
            case _899999: return "899999";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getSystem() {
          return "http://www.abs.gov.au/ausstats/abs@.nsf/mf/1220.0";
        }
        public String getDefinition() {
          switch (this) {
            case _100000: return "Managers not further defined";
            case _111000: return "Chief Executives, General Managers and Legislators not further defined";
            case _111111: return "Chief Executive or Managing Director";
            case _111200: return "General Managers not further defined";
            case _111211: return "Corporate General Manager";
            case _111212: return "Defence Force Senior Officer";
            case _111300: return "Legislators not further defined";
            case _111311: return "Local Government Legislator";
            case _111312: return "Member of Parliament";
            case _111399: return "Legislators not elsewhere classified";
            case _121000: return "Farmers and Farm Managers not further defined";
            case _121111: return "Aquaculture Farmer";
            case _121200: return "Crop Farmers not further defined";
            case _121211: return "Cotton Grower";
            case _121212: return "Flower Grower";
            case _121213: return "Fruit or Nut Grower";
            case _121214: return "Grain, Oilseed or Pasture Grower";
            case _121215: return "Grape Grower";
            case _121216: return "Mixed Crop Farmer";
            case _121217: return "Sugar Cane Grower";
            case _121218: return "Turf Grower";
            case _121221: return "Vegetable Grower";
            case _121299: return "Crop Farmers not elsewhere classified";
            case _121300: return "Livestock Farmers not further defined";
            case _121311: return "Apiarist";
            case _121312: return "Beef Cattle Farmer";
            case _121313: return "Dairy Cattle Farmer";
            case _121314: return "Deer Farmer";
            case _121315: return "Goat Farmer";
            case _121316: return "Horse Breeder";
            case _121317: return "Mixed Livestock Farmer";
            case _121318: return "Pig Farmer";
            case _121321: return "Poultry Farmer";
            case _121322: return "Sheep Farmer";
            case _121399: return "Livestock Farmers not elsewhere classified";
            case _121411: return "Mixed Crop and Livestock Farmer";
            case _130000: return "Specialist Managers not further defined";
            case _131100: return "Advertising and Sales Managers not further defined";
            case _131111: return "Advertising and Public Relations Manager";
            case _131112: return "Sales and Marketing Manager";
            case _132000: return "Business Administration Managers not further defined";
            case _132111: return "Corporate Services Manager";
            case _132211: return "Finance Manager";
            case _132311: return "Human Resource Manager";
            case _132411: return "Policy and Planning Manager";
            case _132511: return "Research and Development Manager";
            case _133000: return "Construction, Distribution and Production Managers not further defined";
            case _133100: return "Construction Managers not further defined";
            case _133111: return "Construction Project Manager";
            case _133112: return "Project Builder";
            case _133211: return "Engineering Manager";
            case _133300: return "Importers, Exporters and Wholesalers not further defined";
            case _133311: return "Importer or Exporter";
            case _133312: return "Wholesaler";
            case _133411: return "Manufacturer";
            case _133500: return "Production Managers not further defined";
            case _133511: return "Production Manager (Forestry)";
            case _133512: return "Production Manager (Manufacturing)";
            case _133513: return "Production Manager (Mining)";
            case _133611: return "Supply and Distribution Manager";
            case _134000: return "Education, Health and Welfare Services Managers not further defined";
            case _134111: return "Child Care Centre Manager";
            case _134200: return "Health and Welfare Services Managers not further defined";
            case _134211: return "Medical Administrator";
            case _134212: return "Nursing Clinical Director";
            case _134213: return "Primary Health Organization Manager";
            case _134214: return "Welfare Centre Manager";
            case _134299: return "Health and Welfare Services Managers not elsewhere classified";
            case _134311: return "School Principal";
            case _134400: return "Other Education Managers not further defined";
            case _134411: return "Faculty Head";
            case _134412: return "Regional Education Manager";
            case _134499: return "Education Managers not elsewhere classified";
            case _135100: return "ICT Managers not further defined";
            case _135111: return "Chief Information Officer";
            case _135112: return "ICT Project Manager";
            case _135199: return "ICT Managers not elsewhere classified";
            case _139000: return "Miscellaneous Specialist Managers not further defined";
            case _139100: return "Commissioned Officers (Management) not further defined";
            case _139111: return "Commissioned Defence Force Officer";
            case _139112: return "Commissioned Fire Officer";
            case _139113: return "Commissioned Police Officer";
            case _139211: return "Senior Non-commissioned Defence Force Member";
            case _139900: return "Other Specialist Managers not further defined";
            case _139911: return "Arts Administrator or Manager";
            case _139912: return "Environmental Manager";
            case _139913: return "Laboratory Manager";
            case _139914: return "Quality Assurance Manager";
            case _139915: return "Sports Administrator";
            case _139999: return "Specialist Managers not elsewhere classified";
            case _140000: return "Hospitality, Retail and Service Managers not further defined";
            case _141000: return "Accommodation and Hospitality Managers not further defined";
            case _141111: return "Cafe or Restaurant Manager";
            case _141211: return "Caravan Park and Camping Ground Manager";
            case _141311: return "Hotel or Motel Manager";
            case _141411: return "Licensed Club Manager";
            case _141900: return "Other Accommodation and Hospitality Managers not further defined";
            case _141911: return "Bed and Breakfast Operator";
            case _141999: return "Accommodation and Hospitality Managers not elsewhere classified";
            case _142100: return "Retail Managers not further defined";
            case _142111: return "Retail Manager (General)";
            case _142112: return "Antique Dealer";
            case _142113: return "Betting Agency Manager";
            case _142114: return "Hair or Beauty Salon Manager";
            case _142115: return "Post Office Manager";
            case _142116: return "Travel Agency Manager";
            case _149000: return "Miscellaneous Hospitality, Retail and Service Managers not further defined";
            case _149100: return "Amusement, Fitness and Sports Centre Managers not further defined";
            case _149111: return "Amusement Centre Manager";
            case _149112: return "Fitness Centre Manager";
            case _149113: return "Sports Centre Manager";
            case _149200: return "Call or Contact Centre and Customer Service Managers not further defined";
            case _149211: return "Call or Contact Centre Manager";
            case _149212: return "Customer Service Manager";
            case _149311: return "Conference and Event Organizer";
            case _149400: return "Transport Services Managers not further defined";
            case _149411: return "Fleet Manager";
            case _149412: return "Railway Station Manager";
            case _149413: return "Transport Company Manager";
            case _149900: return "Other Hospitality, Retail and Service Managers not further defined";
            case _149911: return "Boarding Kennel or Cattery Operator";
            case _149912: return "Cinema or Theatre Manager";
            case _149913: return "Facilities Manager";
            case _149914: return "Financial Institution Branch Manager";
            case _149999: return "Hospitality, Retail and Service Managers not elsewhere classified";
            case _200000: return "Professionals not further defined";
            case _210000: return "Arts and Media Professionals not further defined";
            case _211000: return "Arts Professionals not further defined";
            case _211100: return "Actors, Dancers and Other Entertainers not further defined";
            case _211111: return "Actor";
            case _211112: return "Dancer or Choreographer";
            case _211113: return "Entertainer or Variety Artist";
            case _211199: return "Actors, Dancers and Other Entertainers not elsewhere classified";
            case _211200: return "Music Professionals not further defined";
            case _211211: return "Composer";
            case _211212: return "Music Director";
            case _211213: return "Musician (Instrumental)";
            case _211214: return "Singer";
            case _211299: return "Music Professionals not elsewhere classified";
            case _211311: return "Photographer";
            case _211400: return "Visual Arts and Crafts Professionals not further defined";
            case _211411: return "Painter (Visual Arts)";
            case _211412: return "Potter or Ceramic Artist";
            case _211413: return "Sculptor";
            case _211499: return "Visual Arts and Crafts Professionals not elsewhere classified";
            case _212000: return "Media Professionals not further defined";
            case _212100: return "Artistic Directors, and Media Producers and Presenters not further defined";
            case _212111: return "Artistic Director";
            case _212112: return "Media Producer (excluding Video)";
            case _212113: return "Radio Presenter";
            case _212114: return "Television Presenter";
            case _212200: return "Authors, and Book and Script Editors not further defined";
            case _212211: return "Author";
            case _212212: return "Book or Script Editor";
            case _212300: return "Film, Television, Radio and Stage Directors not further defined";
            case _212311: return "Art Director (Film, Television or Stage)";
            case _212312: return "Director (Film, Television, Radio or Stage)";
            case _212313: return "Director of Photography";
            case _212314: return "Film and Video Editor";
            case _212315: return "Program Director (Television or Radio)";
            case _212316: return "Stage Manager";
            case _212317: return "Technical Director";
            case _212318: return "Video Producer";
            case _212399: return "Film, Television, Radio and Stage Directors not elsewhere classified";
            case _212400: return "Journalists and Other Writers not further defined";
            case _212411: return "Copywriter";
            case _212412: return "Newspaper or Periodical Editor";
            case _212413: return "Print Journalist";
            case _212414: return "Radio Journalist";
            case _212415: return "Technical Writer";
            case _212416: return "Television Journalist";
            case _212499: return "Journalists and Other Writers not elsewhere classified";
            case _220000: return "Business, Human Resource and Marketing Professionals not further defined";
            case _221000: return "Accountants, Auditors and Company Secretaries not further defined";
            case _221100: return "Accountants not further defined";
            case _221111: return "Accountant (General)";
            case _221112: return "Management Accountant";
            case _221113: return "Taxation Accountant";
            case _221200: return "Auditors, Company Secretaries and Corporate Treasurers not further defined";
            case _221211: return "Company Secretary";
            case _221212: return "Corporate Treasurer";
            case _221213: return "External Auditor";
            case _221214: return "Internal Auditor";
            case _222000: return "Financial Brokers and Dealers, and Investment Advisers not further defined";
            case _222100: return "Financial Brokers not further defined";
            case _222111: return "Commodities Trader";
            case _222112: return "Finance Broker";
            case _222113: return "Insurance Broker";
            case _222199: return "Financial Brokers not elsewhere classified";
            case _222200: return "Financial Dealers not further defined";
            case _222211: return "Financial Market Dealer";
            case _222212: return "Futures Trader";
            case _222213: return "Stockbroking Dealer";
            case _222299: return "Financial Dealers not elsewhere classified";
            case _222300: return "Financial Investment Advisers and Managers not further defined";
            case _222311: return "Financial Investment Adviser";
            case _222312: return "Financial Investment Manager";
            case _223000: return "Human Resource and Training Professionals not further defined";
            case _223100: return "Human Resource Professionals not further defined";
            case _223111: return "Human Resource Adviser";
            case _223112: return "Recruitment Consultant";
            case _223113: return "Workplace Relations Adviser";
            case _223211: return "ICT Trainer";
            case _223311: return "Training and Development Professional";
            case _224000: return "Information and Organization Professionals not further defined";
            case _224100: return "Actuaries, Mathematicians and Statisticians not further defined";
            case _224111: return "Actuary";
            case _224112: return "Mathematician";
            case _224113: return "Statistician";
            case _224200: return "Archivists, Curators and Records Managers not further defined";
            case _224211: return "Archivist";
            case _224212: return "Gallery or Museum Curator";
            case _224213: return "Health Information Manager";
            case _224214: return "Records Manager";
            case _224311: return "Economist";
            case _224400: return "Intelligence and Policy Analysts not further defined";
            case _224411: return "Intelligence Officer";
            case _224412: return "Policy Analyst";
            case _224500: return "Land Economists and Valuers not further defined";
            case _224511: return "Land Economist";
            case _224512: return "Valuer";
            case _224611: return "Librarian";
            case _224700: return "Management and Organization Analysts not further defined";
            case _224711: return "Management Consultant";
            case _224712: return "Organization and Methods Analyst";
            case _224900: return "Other Information and Organization Professionals not further defined";
            case _224911: return "Electorate Officer";
            case _224912: return "Liaison Officer";
            case _224913: return "Migration Agent";
            case _224914: return "Patents Examiner";
            case _224999: return "Information and Organization Professionals not elsewhere classified";
            case _225000: return "Sales, Marketing and Public Relations Professionals not further defined";
            case _225100: return "Advertising and Marketing Professionals not further defined";
            case _225111: return "Advertising Specialist";
            case _225112: return "Market Research Analyst";
            case _225113: return "Marketing Specialist";
            case _225200: return "ICT Sales Professionals not further defined";
            case _225211: return "ICT Account Manager";
            case _225212: return "ICT Business Development Manager";
            case _225213: return "ICT Sales Representative";
            case _225311: return "Public Relations Professional";
            case _225400: return "Technical Sales Representatives not further defined";
            case _225411: return "Sales Representative (Industrial Products)";
            case _225412: return "Sales Representative (Medical and Pharmaceutical Products)";
            case _225499: return "Technical Sales Representatives not elsewhere classified";
            case _230000: return "Design, Engineering, Science and Transport Professionals not further defined";
            case _231000: return "Air and Marine Transport Professionals not further defined";
            case _231100: return "Air Transport Professionals not further defined";
            case _231111: return "Aeroplane Pilot";
            case _231112: return "Air Traffic Controller";
            case _231113: return "Flying Instructor";
            case _231114: return "Helicopter Pilot";
            case _231199: return "Air Transport Professionals not elsewhere classified";
            case _231200: return "Marine Transport Professionals not further defined";
            case _231211: return "Master Fisher";
            case _231212: return "Ship's Engineer";
            case _231213: return "Ship's Master";
            case _231214: return "Ship's Officer";
            case _231215: return "Ship's Surveyor";
            case _231299: return "Marine Transport Professionals not elsewhere classified";
            case _232000: return "Architects, Designers, Planners and Surveyors not further defined";
            case _232100: return "Architects and Landscape Architects not further defined";
            case _232111: return "Architect";
            case _232112: return "Landscape Architect";
            case _232200: return "Cartographers and Surveyors not further defined";
            case _232211: return "Cartographer";
            case _232212: return "Surveyor";
            case _232300: return "Fashion, Industrial and Jewellery Designers not further defined";
            case _232311: return "Fashion Designer";
            case _232312: return "Industrial Designer";
            case _232313: return "Jewellery Designer";
            case _232400: return "Graphic and Web Designers, and Illustrators not further defined";
            case _232411: return "Graphic Designer";
            case _232412: return "Illustrator";
            case _232413: return "Multimedia Designer";
            case _232414: return "Web Designer";
            case _232511: return "Interior Designer";
            case _232611: return "Urban and Regional Planner";
            case _233000: return "Engineering Professionals not further defined";
            case _233100: return "Chemical and Materials Engineers not further defined";
            case _233111: return "Chemical Engineer";
            case _233112: return "Materials Engineer";
            case _233200: return "Civil Engineering Professionals not further defined";
            case _233211: return "Civil Engineer";
            case _233212: return "Geotechnical Engineer";
            case _233213: return "Quantity Surveyor";
            case _233214: return "Structural Engineer";
            case _233215: return "Transport Engineer";
            case _233311: return "Electrical Engineer";
            case _233411: return "Electronics Engineer";
            case _233500: return "Industrial, Mechanical and Production Engineers not further defined";
            case _233511: return "Industrial Engineer";
            case _233512: return "Mechanical Engineer";
            case _233513: return "Production or Plant Engineer";
            case _233600: return "Mining Engineers not further defined";
            case _233611: return "Mining Engineer (excluding Petroleum)";
            case _233612: return "Petroleum Engineer";
            case _233900: return "Other Engineering Professionals not further defined";
            case _233911: return "Aeronautical Engineer";
            case _233912: return "Agricultural Engineer";
            case _233913: return "Biomedical Engineer";
            case _233914: return "Engineering Technologist";
            case _233915: return "Environmental Engineer";
            case _233916: return "Naval Architect";
            case _233999: return "Engineering Professionals not elsewhere classified";
            case _234000: return "Natural and Physical Science Professionals not further defined";
            case _234100: return "Agricultural and Forestry Scientists not further defined";
            case _234111: return "Agricultural Consultant";
            case _234112: return "Agricultural Scientist";
            case _234113: return "Forester";
            case _234200: return "Chemists, and Food and Wine Scientists not further defined";
            case _234211: return "Chemist";
            case _234212: return "Food Technologist";
            case _234213: return "Wine Maker";
            case _234300: return "Environmental Scientists not further defined";
            case _234311: return "Conservation Officer";
            case _234312: return "Environmental Consultant";
            case _234313: return "Environmental Research Scientist";
            case _234314: return "Park Ranger";
            case _234399: return "Environmental Scientists not elsewhere classified";
            case _234400: return "Geologists and Geophysicists not further defined";
            case _234411: return "Geologist";
            case _234412: return "Geophysicist";
            case _234500: return "Life Scientists not further defined";
            case _234511: return "Life Scientist (General)";
            case _234512: return "Anatomist or Physiologist";
            case _234513: return "Biochemist";
            case _234514: return "Biotechnologist";
            case _234515: return "Botanist";
            case _234516: return "Marine Biologist";
            case _234517: return "Microbiologist";
            case _234518: return "Zoologist";
            case _234599: return "Life Scientists not elsewhere classified";
            case _234611: return "Medical Laboratory Scientist";
            case _234711: return "Veterinarian";
            case _234900: return "Other Natural and Physical Science Professionals not further defined";
            case _234911: return "Conservator";
            case _234912: return "Metallurgist";
            case _234913: return "Meteorologist";
            case _234914: return "Physicist";
            case _234999: return "Natural and Physical Science Professionals not elsewhere classified";
            case _240000: return "Education Professionals not further defined";
            case _241000: return "School Teachers not further defined";
            case _241111: return "Early Childhood (Pre-primary School) Teacher";
            case _241213: return "Primary School Teacher";
            case _241311: return "Middle School Teacher";
            case _241411: return "Secondary School Teacher";
            case _241500: return "Special Education Teachers not further defined";
            case _241511: return "Special Needs Teacher";
            case _241512: return "Teacher of the Hearing Impaired";
            case _241513: return "Teacher of the Sight Impaired";
            case _241599: return "Special Education Teachers not elsewhere classified";
            case _242000: return "Tertiary Education Teachers not further defined";
            case _242100: return "University Lecturers and Tutors not further defined";
            case _242111: return "University Lecturer";
            case _242112: return "University Tutor";
            case _242211: return "Vocational Education Teacher";
            case _249000: return "Miscellaneous Education Professionals not further defined";
            case _249100: return "Education Advisers and Reviewers not further defined";
            case _249111: return "Education Adviser";
            case _249112: return "Education Reviewer";
            case _249200: return "Private Tutors and Teachers not further defined";
            case _249211: return "Art Teacher (Private Tuition)";
            case _249212: return "Dance Teacher (Private Tuition)";
            case _249213: return "Drama Teacher (Private Tuition)";
            case _249214: return "Music Teacher (Private Tuition)";
            case _249299: return "Private Tutors and Teachers not elsewhere classified";
            case _249311: return "Teacher of English to Speakers of Other Languages";
            case _250000: return "Health Professionals not further defined";
            case _251000: return "Health Diagnostic and Promotion Professionals not further defined";
            case _251111: return "Dietitian";
            case _251200: return "Medical Imaging Professionals not further defined";
            case _251211: return "Medical Diagnostic Radiographer";
            case _251212: return "Medical Radiation Therapist";
            case _251213: return "Nuclear Medicine Technologist";
            case _251214: return "Sonographer";
            case _251300: return "Occupational and Environmental Health Professionals not further defined";
            case _251311: return "Environmental Health Officer";
            case _251312: return "Occupational Health and Safety Adviser";
            case _251400: return "Optometrists and Orthoptists not further defined";
            case _251411: return "Optometrist";
            case _251412: return "Orthoptist";
            case _251500: return "Pharmacists not further defined";
            case _251511: return "Hospital Pharmacist";
            case _251512: return "Industrial Pharmacist";
            case _251513: return "Retail Pharmacist";
            case _251900: return "Other Health Diagnostic and Promotion Professionals not further defined";
            case _251911: return "Health Promotion Officer";
            case _251912: return "Orthotist or Prosthetist";
            case _251999: return "Health Diagnostic and Promotion Professionals not elsewhere classified";
            case _252000: return "Health Therapy Professionals not further defined";
            case _252100: return "Chiropractors and Osteopaths not further defined";
            case _252111: return "Chiropractor";
            case _252112: return "Osteopath";
            case _252200: return "Complementary Health Therapists not further defined";
            case _252211: return "Acupuncturist";
            case _252212: return "Homoeopath";
            case _252213: return "Naturopath";
            case _252214: return "Traditional Chinese Medicine Practitioner";
            case _252299: return "Complementary Health Therapists not elsewhere classified";
            case _252300: return "Dental Practitioners not further defined";
            case _252311: return "Dental Specialist";
            case _252312: return "Dentist";
            case _252411: return "Occupational Therapist";
            case _252511: return "Physiotherapist";
            case _252611: return "Podiatrist";
            case _252700: return "Speech Professionals and Audiologists not further defined";
            case _252711: return "Audiologist";
            case _252712: return "Speech Pathologist";
            case _253000: return "Medical Practitioners not further defined";
            case _253100: return "Generalist Medical Practitioners not further defined";
            case _253111: return "General Medical Practitioner";
            case _253112: return "Resident Medical Officer";
            case _253211: return "Anaesthetist";
            case _253300: return "Internal Medicine Specialists not further defined";
            case _253311: return "Specialist Physician (General Medicine)";
            case _253312: return "Cardiologist";
            case _253313: return "Clinical Haematologist";
            case _253314: return "Clinical Oncologist";
            case _253315: return "Endocrinologist";
            case _253316: return "Gastroenterologist";
            case _253317: return "Intensive Care Specialist";
            case _253318: return "Neurologist";
            case _253321: return "Paediatrician";
            case _253322: return "Renal Medicine Specialist";
            case _253323: return "Rheumatologist";
            case _253324: return "Thoracic Medicine Specialist";
            case _253399: return "Internal Medicine Specialists not elsewhere classified";
            case _253411: return "Psychiatrist";
            case _253500: return "Surgeons not further defined";
            case _253511: return "Surgeon (General)";
            case _253512: return "Cardiothoracic Surgeon";
            case _253513: return "Neurosurgeon";
            case _253514: return "Orthopaedic Surgeon";
            case _253515: return "Otorhinolaryngologist";
            case _253516: return "Paediatric Surgeon";
            case _253517: return "Plastic and Reconstructive Surgeon";
            case _253518: return "Urologist";
            case _253521: return "Vascular Surgeon";
            case _253900: return "Other Medical Practitioners not further defined";
            case _253911: return "Dermatologist";
            case _253912: return "Emergency Medicine Specialist";
            case _253913: return "Obstetrician and Gynaecologist";
            case _253914: return "Ophthalmologist";
            case _253915: return "Pathologist";
            case _253916: return "Radiologist";
            case _253999: return "Medical Practitioners not elsewhere classified";
            case _254000: return "Midwifery and Nursing Professionals not further defined";
            case _254111: return "Midwife";
            case _254200: return "Nurse Educators and Researchers not further defined";
            case _254211: return "Nurse Educator";
            case _254212: return "Nurse Researcher";
            case _254311: return "Nurse Manager";
            case _254400: return "Registered Nurses not further defined";
            case _254411: return "Nurse Practitioner";
            case _254412: return "Registered Nurse (Aged Care)";
            case _254413: return "Registered Nurse (Child and Family Health)";
            case _254414: return "Registered Nurse (Community Health)";
            case _254415: return "Registered Nurse (Critical Care and Emergency)";
            case _254416: return "Registered Nurse (Developmental Disability)";
            case _254417: return "Registered Nurse (Disability and Rehabilitation)";
            case _254418: return "Registered Nurse (Medical)";
            case _254421: return "Registered Nurse (Medical Practice)";
            case _254422: return "Registered Nurse (Mental Health)";
            case _254423: return "Registered Nurse (Perioperative)";
            case _254424: return "Registered Nurse (Surgical)";
            case _254499: return "Registered Nurses not elsewhere classified";
            case _260000: return "ICT Professionals not further defined";
            case _261000: return "Business and Systems Analysts, and Programmers not further defined";
            case _261100: return "ICT Business and Systems Analysts not further defined";
            case _261111: return "ICT Business Analyst";
            case _261112: return "Systems Analyst";
            case _261200: return "Multimedia Specialists and Web Developers not further defined";
            case _261211: return "Multimedia Specialist";
            case _261212: return "Web Developer";
            case _261300: return "Software and Applications Programmers not further defined";
            case _261311: return "Analyst Programmer";
            case _261312: return "Developer Programmer";
            case _261313: return "Software Engineer";
            case _261399: return "Software and Applications Programmers not elsewhere classified";
            case _262100: return "Database and Systems Administrators, and ICT Security Specialists not further defined";
            case _262111: return "Database Administrator";
            case _262112: return "ICT Security Specialist";
            case _262113: return "Systems Administrator";
            case _263000: return "ICT Network and Support Professionals not further defined";
            case _263100: return "Computer Network Professionals not further defined";
            case _263111: return "Computer Network and Systems Engineer";
            case _263112: return "Network Administrator";
            case _263113: return "Network Analyst";
            case _263200: return "ICT Support and Test Engineers not further defined";
            case _263211: return "ICT Quality Assurance Engineer";
            case _263212: return "ICT Support Engineer";
            case _263213: return "ICT Systems Test Engineer";
            case _263299: return "ICT Support and Test Engineers not elsewhere classified";
            case _263300: return "Telecommunications Engineering Professionals not further defined";
            case _263311: return "Telecommunications Engineer";
            case _263312: return "Telecommunications Network Engineer";
            case _270000: return "Legal, Social and Welfare Professionals not further defined";
            case _271000: return "Legal Professionals not further defined";
            case _271111: return "Barrister";
            case _271200: return "Judicial and Other Legal Professionals not further defined";
            case _271211: return "Judge";
            case _271212: return "Magistrate";
            case _271213: return "Tribunal Member";
            case _271299: return "Judicial and Other Legal Professionals not elsewhere classified";
            case _271311: return "Solicitor";
            case _272000: return "Social and Welfare Professionals not further defined";
            case _272100: return "Counsellors not further defined";
            case _272111: return "Careers Counsellor";
            case _272112: return "Drug and Alcohol Counsellor";
            case _272113: return "Family and Marriage Counsellor";
            case _272114: return "Rehabilitation Counsellor";
            case _272115: return "Student Counsellor";
            case _272199: return "Counsellors not elsewhere classified";
            case _272211: return "Minister of Religion";
            case _272300: return "Psychologists not further defined";
            case _272311: return "Clinical Psychologist";
            case _272312: return "Educational Psychologist";
            case _272313: return "Organizational Psychologist";
            case _272314: return "Psychotherapist";
            case _272399: return "Psychologists not elsewhere classified";
            case _272400: return "Social Professionals not further defined";
            case _272411: return "Historian";
            case _272412: return "Interpreter";
            case _272413: return "Translator";
            case _272499: return "Social Professionals not elsewhere classified";
            case _272511: return "Social Worker";
            case _272600: return "Welfare, Recreation and Community Arts Workers not further defined";
            case _272611: return "Community Arts Worker";
            case _272612: return "Recreation Officer";
            case _272613: return "Welfare Worker";
            case _300000: return "Technicians and Trades Workers not further defined";
            case _310000: return "Engineering, ICT and Science Technicians not further defined";
            case _311000: return "Agricultural, Medical and Science Technicians not further defined";
            case _311111: return "Agricultural Technician";
            case _311200: return "Medical Technicians not further defined";
            case _311211: return "Anaesthetic Technician";
            case _311212: return "Cardiac Technician";
            case _311213: return "Medical Laboratory Technician";
            case _311214: return "Operating Theatre Technician";
            case _311215: return "Pharmacy Technician";
            case _311299: return "Medical Technicians not elsewhere classified";
            case _311300: return "Primary Products Inspectors not further defined";
            case _311311: return "Fisheries Officer";
            case _311312: return "Meat Inspector";
            case _311313: return "Quarantine Officer";
            case _311399: return "Primary Products Inspectors not elsewhere classified";
            case _311400: return "Science Technicians not further defined";
            case _311411: return "Chemistry Technician";
            case _311412: return "Earth Science Technician";
            case _311413: return "Life Science Technician";
            case _311414: return "School Laboratory Technician";
            case _311499: return "Science Technicians not elsewhere classified";
            case _312000: return "Building and Engineering Technicians not further defined";
            case _312100: return "Architectural, Building and Surveying Technicians not further defined";
            case _312111: return "Architectural Draftsperson";
            case _312112: return "Building Associate";
            case _312113: return "Building Inspector";
            case _312114: return "Construction Estimator";
            case _312115: return "Plumbing Inspector";
            case _312116: return "Surveying or Cartographic Technician";
            case _312200: return "Civil Engineering Draftspersons and Technicians not further defined";
            case _312211: return "Civil Engineering Draftsperson";
            case _312212: return "Civil Engineering Technician";
            case _312300: return "Electrical Engineering Draftspersons and Technicians not further defined";
            case _312311: return "Electrical Engineering Draftsperson";
            case _312312: return "Electrical Engineering Technician";
            case _312400: return "Electronic Engineering Draftspersons and Technicians not further defined";
            case _312411: return "Electronic Engineering Draftsperson";
            case _312412: return "Electronic Engineering Technician";
            case _312500: return "Mechanical Engineering Draftspersons and Technicians not further defined";
            case _312511: return "Mechanical Engineering Draftsperson";
            case _312512: return "Mechanical Engineering Technician";
            case _312611: return "Safety Inspector";
            case _312900: return "Other Building and Engineering Technicians not further defined";
            case _312911: return "Maintenance Planner";
            case _312912: return "Metallurgical or Materials Technician";
            case _312913: return "Mine Deputy";
            case _312999: return "Building and Engineering Technicians not elsewhere classified";
            case _313000: return "ICT and Telecommunications Technicians not further defined";
            case _313100: return "ICT Support Technicians not further defined";
            case _313111: return "Hardware Technician";
            case _313112: return "ICT Customer Support Officer";
            case _313113: return "Web Administrator";
            case _313199: return "ICT Support Technicians not elsewhere classified";
            case _313200: return "Telecommunications Technical Specialists not further defined";
            case _313211: return "Radiocommunications Technician";
            case _313212: return "Telecommunications Field Engineer";
            case _313213: return "Telecommunications Network Planner";
            case _313214: return "Telecommunications Technical Officer or Technologist";
            case _320000: return "Automotive and Engineering Trades Workers not further defined";
            case _321000: return "Automotive Electricians and Mechanics not further defined";
            case _321111: return "Automotive Electrician";
            case _321200: return "Motor Mechanics not further defined";
            case _321211: return "Motor Mechanic (General)";
            case _321212: return "Diesel Motor Mechanic";
            case _321213: return "Motorcycle Mechanic";
            case _321214: return "Small Engine Mechanic";
            case _322000: return "Fabrication Engineering Trades Workers not further defined";
            case _322100: return "Metal Casting, Forging and Finishing Trades Workers not further defined";
            case _322111: return "Blacksmith";
            case _322112: return "Electroplater";
            case _322113: return "Farrier";
            case _322114: return "Metal Casting Trades Worker";
            case _322115: return "Metal Polisher";
            case _322211: return "Sheetmetal Trades Worker";
            case _322300: return "Structural Steel and Welding Trades Workers not further defined";
            case _322311: return "Metal Fabricator";
            case _322312: return "Pressure Welder";
            case _322313: return "Welder (First Class)";
            case _323000: return "Mechanical Engineering Trades Workers not further defined";
            case _323100: return "Aircraft Maintenance Engineers not further defined";
            case _323111: return "Aircraft Maintenance Engineer (Avionics)";
            case _323112: return "Aircraft Maintenance Engineer (Mechanical)";
            case _323113: return "Aircraft Maintenance Engineer (Structures)";
            case _323200: return "Metal Fitters and Machinists not further defined";
            case _323211: return "Fitter (General)";
            case _323212: return "Fitter and Turner";
            case _323213: return "Fitter-Welder";
            case _323214: return "Metal Machinist (First Class)";
            case _323215: return "Textile, Clothing and Footwear Mechanic";
            case _323299: return "Metal Fitters and Machinists not elsewhere classified";
            case _323300: return "Precision Metal Trades Workers not further defined";
            case _323311: return "Engraver";
            case _323312: return "Gunsmith";
            case _323313: return "Locksmith";
            case _323314: return "Precision Instrument Maker and Repairer";
            case _323315: return "Saw Maker and Repairer";
            case _323316: return "Watch and Clock Maker and Repairer";
            case _323400: return "Toolmakers and Engineering Patternmakers not further defined";
            case _323411: return "Engineering Patternmaker";
            case _323412: return "Toolmaker";
            case _324000: return "Panelbeaters, and Vehicle Body Builders, Trimmers and Painters not further defined";
            case _324111: return "Panelbeater";
            case _324200: return "Vehicle Body Builders and Trimmers not further defined";
            case _324211: return "Vehicle Body Builder";
            case _324212: return "Vehicle Trimmer";
            case _324311: return "Vehicle Painter";
            case _330000: return "Construction Trades Workers not further defined";
            case _331000: return "Bricklayers, and Carpenters and Joiners not further defined";
            case _331100: return "Bricklayers and Stonemasons not further defined";
            case _331111: return "Bricklayer";
            case _331112: return "Stonemason";
            case _331211: return "Carpenter and Joiner";
            case _331212: return "Carpenter";
            case _331213: return "Joiner";
            case _332000: return "Floor Finishers and Painting Trades Workers not further defined";
            case _332111: return "Floor Finisher";
            case _332211: return "Painting Trades Worker";
            case _333000: return "Glaziers, Plasterers and Tilers not further defined";
            case _333111: return "Glazier";
            case _333200: return "Plasterers not further defined";
            case _333211: return "Fibrous Plasterer";
            case _333212: return "Solid Plasterer";
            case _333311: return "Roof Tiler";
            case _333411: return "Wall and Floor Tiler";
            case _334100: return "Plumbers not further defined";
            case _334111: return "Plumber (General)";
            case _334112: return "Airconditioning and Mechanical Services Plumber";
            case _334113: return "Drainer";
            case _334114: return "Gasfitter";
            case _334115: return "Roof Plumber";
            case _340000: return "Electrotechnology and Telecommunications Trades Workers not further defined";
            case _341100: return "Electricians not further defined";
            case _341111: return "Electrician (General)";
            case _341112: return "Electrician (Special Class)";
            case _341113: return "Lift Mechanic";
            case _342000: return "Electronics and Telecommunications Trades Workers not further defined";
            case _342111: return "Airconditioning and Refrigeration Mechanic";
            case _342200: return "Electrical Distribution Trades Workers not further defined";
            case _342211: return "Electrical Linesworker";
            case _342212: return "Technical Cable Jointer";
            case _342300: return "Electronics Trades Workers not further defined";
            case _342311: return "Business Machine Mechanic";
            case _342312: return "Communications Operator";
            case _342313: return "Electronic Equipment Trades Worker";
            case _342314: return "Electronic Instrument Trades Worker (General)";
            case _342315: return "Electronic Instrument Trades Worker (Special Class)";
            case _342400: return "Telecommunications Trades Workers not further defined";
            case _342411: return "Cabler (Data and Telecommunications)";
            case _342412: return "Telecommunications Cable Jointer";
            case _342413: return "Telecommunications Linesworker";
            case _342414: return "Telecommunications Technician";
            case _351000: return "Food Trades Workers not further defined";
            case _351100: return "Bakers and Pastrycooks not further defined";
            case _351111: return "Baker";
            case _351112: return "Pastrycook";
            case _351211: return "Butcher or Smallgoods Maker";
            case _351311: return "Chef";
            case _351411: return "Cook";
            case _360000: return "Skilled Animal and Horticultural Workers not further defined";
            case _361000: return "Animal Attendants and Trainers, and Shearers not further defined";
            case _361100: return "Animal Attendants and Trainers not further defined";
            case _361111: return "Dog Handler or Trainer";
            case _361112: return "Horse Trainer";
            case _361113: return "Pet Groomer";
            case _361114: return "Zookeeper";
            case _361199: return "Animal Attendants and Trainers not elsewhere classified";
            case _361211: return "Shearer";
            case _361311: return "Veterinary Nurse";
            case _362000: return "Horticultural Trades Workers not further defined";
            case _362111: return "Florist";
            case _362200: return "Gardeners not further defined";
            case _362211: return "Gardener (General)";
            case _362212: return "Arborist";
            case _362213: return "Landscape Gardener";
            case _362311: return "Greenkeeper";
            case _362411: return "Nurseryperson";
            case _390000: return "Other Technicians and Trades Workers not further defined";
            case _391111: return "Hairdresser";
            case _392000: return "Printing Trades Workers not further defined";
            case _392100: return "Binders, Finishers and Screen Printers not further defined";
            case _392111: return "Binder and Finisher";
            case _392112: return "Screen Printer";
            case _392211: return "Graphic Pre-press Trades Worker";
            case _392300: return "Printers not further defined";
            case _392311: return "Printing Machinist";
            case _392312: return "Small Offset Printer";
            case _393000: return "Textile, Clothing and Footwear Trades Workers not further defined";
            case _393100: return "Canvas and Leather Goods Makers not further defined";
            case _393111: return "Canvas Goods Maker";
            case _393112: return "Leather Goods Maker";
            case _393113: return "Sail Maker";
            case _393114: return "Shoemaker";
            case _393200: return "Clothing Trades Workers not further defined";
            case _393211: return "Apparel Cutter";
            case _393212: return "Clothing Patternmaker";
            case _393213: return "Dressmaker or Tailor";
            case _393299: return "Clothing Trades Workers not elsewhere classified";
            case _393311: return "Upholsterer";
            case _394000: return "Wood Trades Workers not further defined";
            case _394111: return "Cabinetmaker";
            case _394200: return "Wood Machinists and Other Wood Trades Workers not further defined";
            case _394211: return "Furniture Finisher";
            case _394212: return "Picture Framer";
            case _394213: return "Wood Machinist";
            case _394214: return "Wood Turner";
            case _394299: return "Wood Machinists and Other Wood Trades Workers not elsewhere classified";
            case _399000: return "Miscellaneous Technicians and Trades Workers not further defined";
            case _399100: return "Boat Builders and Shipwrights not further defined";
            case _399111: return "Boat Builder and Repairer";
            case _399112: return "Shipwright";
            case _399200: return "Chemical, Gas, Petroleum and Power Generation Plant Operators not further defined";
            case _399211: return "Chemical Plant Operator";
            case _399212: return "Gas or Petroleum Operator";
            case _399213: return "Power Generation Plant Operator";
            case _399300: return "Gallery, Library and Museum Technicians not further defined";
            case _399311: return "Gallery or Museum Technician";
            case _399312: return "Library Technician";
            case _399411: return "Jeweller";
            case _399500: return "Performing Arts Technicians not further defined";
            case _399511: return "Broadcast Transmitter Operator";
            case _399512: return "Camera Operator (Film, Television or Video)";
            case _399513: return "Light Technician";
            case _399514: return "Make Up Artist";
            case _399515: return "Musical Instrument Maker or Repairer";
            case _399516: return "Sound Technician";
            case _399517: return "Television Equipment Operator";
            case _399599: return "Performing Arts Technicians not elsewhere classified";
            case _399611: return "Signwriter";
            case _399900: return "Other Miscellaneous Technicians and Trades Workers not further defined";
            case _399911: return "Diver";
            case _399912: return "Interior Decorator";
            case _399913: return "Optical Dispenser";
            case _399914: return "Optical Mechanic";
            case _399915: return "Photographer's Assistant";
            case _399916: return "Plastics Technician";
            case _399917: return "Wool Classer";
            case _399999: return "Technicians and Trades Workers not elsewhere classified";
            case _400000: return "Community and Personal Service Workers not further defined";
            case _411000: return "Health and Welfare Support Workers not further defined";
            case _411100: return "Ambulance Officers and Paramedics not further defined";
            case _411111: return "Ambulance Officer";
            case _411112: return "Intensive Care Ambulance Paramedic";
            case _411200: return "Dental Hygienists, Technicians and Therapists not further defined";
            case _411211: return "Dental Hygienist";
            case _411212: return "Dental Prosthetist";
            case _411213: return "Dental Technician";
            case _411214: return "Dental Therapist";
            case _411311: return "Diversional Therapist";
            case _411400: return "Enrolled and Mothercraft Nurses not further defined";
            case _411411: return "Enrolled Nurse";
            case _411412: return "Mothercraft Nurse";
            case _411511: return "Aboriginal and Torres Strait Islander Health Worker";
            case _411611: return "Massage Therapist";
            case _411700: return "Welfare Support Workers not further defined";
            case _411711: return "Community Worker";
            case _411712: return "Disabilities Services Officer";
            case _411713: return "Family Support Worker";
            case _411714: return "Parole or Probation Officer";
            case _411715: return "Residential Care Officer";
            case _411716: return "Youth Worker";
            case _420000: return "Carers and Aides not further defined";
            case _421100: return "Child Carers not further defined";
            case _421111: return "Child Care Worker";
            case _421112: return "Family Day Care Worker";
            case _421113: return "Nanny";
            case _421114: return "Out of School Hours Care Worker";
            case _422100: return "Education Aides not further defined";
            case _422111: return "Aboriginal and Torres Strait Islander Education Worker";
            case _422112: return "Integration Aide";
            case _422115: return "Preschool Aide";
            case _422116: return "Teachers' Aide";
            case _423000: return "Personal Carers and Assistants not further defined";
            case _423111: return "Aged or Disabled Carer";
            case _423211: return "Dental Assistant";
            case _423300: return "Nursing Support and Personal Care Workers not further defined";
            case _423311: return "Hospital Orderly";
            case _423312: return "Nursing Support Worker";
            case _423313: return "Personal Care Assistant";
            case _423314: return "Therapy Aide";
            case _423400: return "Special Care Workers not further defined";
            case _423411: return "Child or Youth Residential Care Assistant";
            case _423412: return "Hostel Parent";
            case _423413: return "Refuge Worker";
            case _431000: return "Hospitality Workers not further defined";
            case _431100: return "Bar Attendants and Baristas not further defined";
            case _431111: return "Bar Attendant";
            case _431112: return "Barista";
            case _431211: return "Cafe Worker";
            case _431311: return "Gaming Worker";
            case _431411: return "Hotel Service Manager";
            case _431511: return "Waiter";
            case _431900: return "Other Hospitality Workers not further defined";
            case _431911: return "Bar Useful or Busser";
            case _431912: return "Doorperson or Luggage Porter";
            case _431999: return "Hospitality Workers not elsewhere classified";
            case _440000: return "Protective Service Workers not further defined";
            case _441000: return "Defence Force Members, Fire Fighters and Police not further defined";
            case _441111: return "Defence Force Member - Other Ranks";
            case _441200: return "Fire and Emergency Workers not further defined";
            case _441211: return "Emergency Service Worker";
            case _441212: return "Fire Fighter";
            case _441300: return "Police not further defined";
            case _441311: return "Detective";
            case _441312: return "Police Officer";
            case _442000: return "Prison and Security Officers not further defined";
            case _442111: return "Prison Officer";
            case _442200: return "Security Officers and Guards not further defined";
            case _442211: return "Alarm, Security or Surveillance Monitor";
            case _442212: return "Armoured Car Escort";
            case _442213: return "Crowd Controller";
            case _442214: return "Private Investigator";
            case _442215: return "Retail Loss Prevention Officer";
            case _442216: return "Security Consultant";
            case _442217: return "Security Officer";
            case _442299: return "Security Officers and Guards not elsewhere classified";
            case _450000: return "Sports and Personal Service Workers not further defined";
            case _451000: return "Personal Service and Travel Workers not further defined";
            case _451111: return "Beauty Therapist";
            case _451211: return "Driving Instructor";
            case _451300: return "Funeral Workers not further defined";
            case _451311: return "Funeral Director";
            case _451399: return "Funeral Workers not elsewhere classified";
            case _451400: return "Gallery, Museum and Tour Guides not further defined";
            case _451411: return "Gallery or Museum Guide";
            case _451412: return "Tour Guide";
            case _451500: return "Personal Care Consultants not further defined";
            case _451511: return "Natural Remedy Consultant";
            case _451512: return "Weight Loss Consultant";
            case _451600: return "Tourism and Travel Advisers not further defined";
            case _451611: return "Tourist Information Officer";
            case _451612: return "Travel Consultant";
            case _451700: return "Travel Attendants not further defined";
            case _451711: return "Flight Attendant";
            case _451799: return "Travel Attendants not elsewhere classified";
            case _451800: return "Other Personal Service Workers not further defined";
            case _451811: return "Civil Celebrant";
            case _451812: return "Hair or Beauty Salon Assistant";
            case _451813: return "Sex Worker or Escort";
            case _451899: return "Personal Service Workers not elsewhere classified";
            case _452000: return "Sports and Fitness Workers not further defined";
            case _452111: return "Fitness Instructor";
            case _452200: return "Outdoor Adventure Guides not further defined";
            case _452211: return "Bungy Jump Master";
            case _452212: return "Fishing Guide";
            case _452213: return "Hunting Guide";
            case _452214: return "Mountain or Glacier Guide";
            case _452215: return "Outdoor Adventure Instructor";
            case _452216: return "Trekking Guide";
            case _452217: return "Whitewater Rafting Guide";
            case _452299: return "Outdoor Adventure Guides not elsewhere classified";
            case _452300: return "Sports Coaches, Instructors and Officials not further defined";
            case _452311: return "Diving Instructor (Open Water)";
            case _452312: return "Gymnastics Coach or Instructor";
            case _452313: return "Horse Riding Coach or Instructor";
            case _452314: return "Snowsport Instructor";
            case _452315: return "Swimming Coach or Instructor";
            case _452316: return "Tennis Coach";
            case _452317: return "Other Sports Coach or Instructor";
            case _452318: return "Dog or Horse Racing Official";
            case _452321: return "Sports Development Officer";
            case _452322: return "Sports Umpire";
            case _452323: return "Other Sports Official";
            case _452400: return "Sportspersons not further defined";
            case _452411: return "Footballer";
            case _452412: return "Golfer";
            case _452413: return "Jockey";
            case _452414: return "Lifeguard";
            case _452499: return "Sportspersons not elsewhere classified";
            case _500000: return "Clerical and Administrative Workers not further defined";
            case _510000: return "Office Managers and Program Administrators not further defined";
            case _511100: return "Contract, Program and Project Administrators not further defined";
            case _511111: return "Contract Administrator";
            case _511112: return "Program or Project Administrator";
            case _512000: return "Office and Practice Managers not further defined";
            case _512111: return "Office Manager";
            case _512200: return "Practice Managers not further defined";
            case _512211: return "Health Practice Manager";
            case _512299: return "Practice Managers not elsewhere classified";
            case _521000: return "Personal Assistants and Secretaries not further defined";
            case _521111: return "Personal Assistant";
            case _521200: return "Secretaries not further defined";
            case _521211: return "Secretary (General)";
            case _521212: return "Legal Secretary";
            case _530000: return "General Clerical Workers not further defined";
            case _531111: return "General Clerk";
            case _532100: return "Keyboard Operators not further defined";
            case _532111: return "Data Entry Operator";
            case _532112: return "Machine Shorthand Reporter";
            case _532113: return "Word Processing Operator";
            case _540000: return "Inquiry Clerks and Receptionists not further defined";
            case _541000: return "Call or Contact Centre Information Clerks not further defined";
            case _541100: return "Call or Contact Centre Workers not further defined";
            case _541111: return "Call or Contact Centre Team Leader";
            case _541112: return "Call or Contact Centre Operator";
            case _541211: return "Inquiry Clerk";
            case _542100: return "Receptionists not further defined";
            case _542111: return "Receptionist (General)";
            case _542112: return "Admissions Clerk";
            case _542113: return "Hotel or Motel Receptionist";
            case _542114: return "Medical Receptionist";
            case _550000: return "Numerical Clerks not further defined";
            case _551000: return "Accounting Clerks and Bookkeepers not further defined";
            case _551100: return "Accounting Clerks not further defined";
            case _551111: return "Accounts Clerk";
            case _551112: return "Cost Clerk";
            case _551211: return "Bookkeeper";
            case _551311: return "Payroll Clerk";
            case _552000: return "Financial and Insurance Clerks not further defined";
            case _552111: return "Bank Worker";
            case _552211: return "Credit or Loans Officer";
            case _552300: return "Insurance, Money Market and Statistical Clerks not further defined";
            case _552311: return "Bookmaker";
            case _552312: return "Insurance Consultant";
            case _552313: return "Money Market Clerk";
            case _552314: return "Statistical Clerk";
            case _561000: return "Clerical and Office Support Workers not further defined";
            case _561100: return "Betting Clerks not further defined";
            case _561111: return "Betting Agency Counter Clerk";
            case _561112: return "Bookmaker's Clerk";
            case _561113: return "Telephone Betting Clerk";
            case _561199: return "Betting Clerks not elsewhere classified";
            case _561200: return "Couriers and Postal Deliverers not further defined";
            case _561211: return "Courier";
            case _561212: return "Postal Delivery Officer";
            case _561311: return "Filing or Registry Clerk";
            case _561400: return "Mail Sorters not further defined";
            case _561411: return "Mail Clerk";
            case _561412: return "Postal Sorting Officer";
            case _561511: return "Survey Interviewer";
            case _561611: return "Switchboard Operator";
            case _561900: return "Other Clerical and Office Support Workers not further defined";
            case _561911: return "Classified Advertising Clerk";
            case _561912: return "Meter Reader";
            case _561913: return "Parking Inspector";
            case _561999: return "Clerical and Office Support Workers not elsewhere classified";
            case _590000: return "Other Clerical and Administrative Workers not further defined";
            case _591000: return "Logistics Clerks not further defined";
            case _591100: return "Purchasing and Supply Logistics Clerks not further defined";
            case _591111: return "Order Clerk";
            case _591112: return "Production Clerk";
            case _591113: return "Purchasing Officer";
            case _591114: return "Sales Clerk";
            case _591115: return "Stock Clerk";
            case _591116: return "Warehouse Administrator";
            case _591200: return "Transport and Despatch Clerks not further defined";
            case _591211: return "Despatching and Receiving Clerk";
            case _591212: return "Import-Export Clerk";
            case _599000: return "Miscellaneous Clerical and Administrative Workers not further defined";
            case _599100: return "Conveyancers and Legal Executives not further defined";
            case _599111: return "Conveyancer";
            case _599112: return "Legal Executive";
            case _599200: return "Court and Legal Clerks not further defined";
            case _599211: return "Clerk of Court";
            case _599212: return "Court Bailiff or Sheriff";
            case _599213: return "Court Orderly";
            case _599214: return "Law Clerk";
            case _599215: return "Trust Officer";
            case _599311: return "Debt Collector";
            case _599411: return "Human Resource Clerk";
            case _599500: return "Inspectors and Regulatory Officers not further defined";
            case _599511: return "Customs Officer";
            case _599512: return "Immigration Officer";
            case _599513: return "Motor Vehicle Licence Examiner";
            case _599514: return "Noxious Weeds and Pest Inspector";
            case _599515: return "Social Security Assessor";
            case _599516: return "Taxation Inspector";
            case _599517: return "Train Examiner";
            case _599518: return "Transport Operations Inspector";
            case _599521: return "Water Inspector";
            case _599599: return "Inspectors and Regulatory Officers not elsewhere classified";
            case _599600: return "Insurance Investigators, Loss Adjusters and Risk Surveyors not further defined";
            case _599611: return "Insurance Investigator";
            case _599612: return "Insurance Loss Adjuster";
            case _599613: return "Insurance Risk Surveyor";
            case _599711: return "Library Assistant";
            case _599900: return "Other Miscellaneous Clerical and Administrative Workers not further defined";
            case _599911: return "Coding Clerk";
            case _599912: return "Production Assistant (Film, Television, Radio or Stage)";
            case _599913: return "Proof Reader";
            case _599914: return "Radio Despatcher";
            case _599999: return "Clerical and Administrative Workers not elsewhere classified";
            case _600000: return "Sales Workers not further defined";
            case _610000: return "Sales Representatives and Agents not further defined";
            case _611000: return "Insurance Agents and Sales Representatives not further defined";
            case _611100: return "Auctioneers, and Stock and Station Agents not further defined";
            case _611111: return "Auctioneer";
            case _611112: return "Stock and Station Agent";
            case _611211: return "Insurance Agent";
            case _611300: return "Sales Representatives not further defined";
            case _611311: return "Sales Representative (Building and Plumbing Supplies)";
            case _611312: return "Sales Representative (Business Services)";
            case _611313: return "Sales Representative (Motor Vehicle Parts and Accessories)";
            case _611314: return "Sales Representative (Personal and Household Goods)";
            case _611399: return "Sales Representatives not elsewhere classified";
            case _612100: return "Real Estate Sales Agents not further defined";
            case _612111: return "Business Broker";
            case _612112: return "Property Manager";
            case _612113: return "Real Estate Agency Principal";
            case _612114: return "Real Estate Agent";
            case _612115: return "Real Estate Representative";
            case _621000: return "Sales Assistants and Salespersons not further defined";
            case _621111: return "Sales Assistant (General)";
            case _621211: return "ICT Sales Assistant";
            case _621300: return "Motor Vehicle and Vehicle Parts Salespersons not further defined";
            case _621311: return "Motor Vehicle or Caravan Salesperson";
            case _621312: return "Motor Vehicle Parts Interpreter";
            case _621411: return "Pharmacy Sales Assistant";
            case _621511: return "Retail Supervisor";
            case _621611: return "Service Station Attendant";
            case _621700: return "Street Vendors and Related Salespersons not further defined";
            case _621711: return "Cash Van Salesperson";
            case _621712: return "Door-to-door Salesperson";
            case _621713: return "Street Vendor";
            case _621900: return "Other Sales Assistants and Salespersons not further defined";
            case _621911: return "Materials Recycler";
            case _621912: return "Rental Salesperson";
            case _621999: return "Sales Assistants and Salespersons not elsewhere classified";
            case _630000: return "Sales Support Workers not further defined";
            case _631100: return "Checkout Operators and Office Cashiers not further defined";
            case _631111: return "Checkout Operator";
            case _631112: return "Office Cashier";
            case _639000: return "Miscellaneous Sales Support Workers not further defined";
            case _639100: return "Models and Sales Demonstrators not further defined";
            case _639111: return "Model";
            case _639112: return "Sales Demonstrator";
            case _639200: return "Retail and Wool Buyers not further defined";
            case _639211: return "Retail Buyer";
            case _639212: return "Wool Buyer";
            case _639311: return "Telemarketer";
            case _639400: return "Ticket Salespersons not further defined";
            case _639411: return "Ticket Seller";
            case _639412: return "Transport Conductor";
            case _639511: return "Visual Merchandiser";
            case _639911: return "Other Sales Support Worker";
            case _700000: return "Machinery Operators and Drivers not further defined";
            case _710000: return "Machine and Stationary Plant Operators not further defined";
            case _711000: return "Machine Operators not further defined";
            case _711100: return "Clay, Concrete, Glass and Stone Processing Machine Operators not further defined";
            case _711111: return "Clay Products Machine Operator";
            case _711112: return "Concrete Products Machine Operator";
            case _711113: return "Glass Production Machine Operator";
            case _711114: return "Stone Processing Machine Operator";
            case _711199: return "Clay, Concrete, Glass and Stone Processing Machine Operators not elsewhere classified";
            case _711211: return "Industrial Spraypainter";
            case _711300: return "Paper and Wood Processing Machine Operators not further defined";
            case _711311: return "Paper Products Machine Operator";
            case _711312: return "Wood Processing Machine Operator";
            case _711411: return "Photographic Developer and Printer";
            case _711500: return "Plastics and Rubber Production Machine Operators not further defined";
            case _711511: return "Plastic Cablemaking Machine Operator";
            case _711512: return "Plastic Compounding and Reclamation Machine Operator";
            case _711513: return "Plastics Fabricator or Welder";
            case _711514: return "Plastics Production Machine Operator (General)";
            case _711515: return "Reinforced Plastic and Composite Production Worker";
            case _711516: return "Rubber Production Machine Operator";
            case _711599: return "Plastics and Rubber Production Machine Operators not elsewhere classified";
            case _711611: return "Sewing Machinist";
            case _711700: return "Textile and Footwear Production Machine Operators not further defined";
            case _711711: return "Footwear Production Machine Operator";
            case _711712: return "Hide and Skin Processing Machine Operator";
            case _711713: return "Knitting Machine Operator";
            case _711714: return "Textile Dyeing and Finishing Machine Operator";
            case _711715: return "Weaving Machine Operator";
            case _711716: return "Yarn Carding and Spinning Machine Operator";
            case _711799: return "Textile and Footwear Production Machine Operators not elsewhere classified";
            case _711900: return "Other Machine Operators not further defined";
            case _711911: return "Chemical Production Machine Operator";
            case _711912: return "Motion Picture Projectionist";
            case _711913: return "Sand Blaster";
            case _711914: return "Sterilisation Technician";
            case _711999: return "Machine Operators not elsewhere classified";
            case _712000: return "Stationary Plant Operators not further defined";
            case _712111: return "Crane, Hoist or Lift Operator";
            case _712200: return "Drillers, Miners and Shot Firers not further defined";
            case _712211: return "Driller";
            case _712212: return "Miner";
            case _712213: return "Shot Firer";
            case _712311: return "Engineering Production Systems Worker";
            case _712900: return "Other Stationary Plant Operators not further defined";
            case _712911: return "Boiler or Engine Operator";
            case _712912: return "Bulk Materials Handling Plant Operator";
            case _712913: return "Cement Production Plant Operator";
            case _712914: return "Concrete Batching Plant Operator";
            case _712915: return "Concrete Pump Operator";
            case _712916: return "Paper and Pulp Mill Operator";
            case _712917: return "Railway Signal Operator";
            case _712918: return "Train Controller";
            case _712921: return "Waste Water or Water Plant Operator";
            case _712922: return "Weighbridge Operator";
            case _712999: return "Stationary Plant Operators not elsewhere classified";
            case _721000: return "Mobile Plant Operators not further defined";
            case _721100: return "Agricultural, Forestry and Horticultural Plant Operators not further defined";
            case _721111: return "Agricultural and Horticultural Mobile Plant Operator";
            case _721112: return "Logging Plant Operator";
            case _721200: return "Earthmoving Plant Operators not further defined";
            case _721211: return "Earthmoving Plant Operator (General)";
            case _721212: return "Backhoe Operator";
            case _721213: return "Bulldozer Operator";
            case _721214: return "Excavator Operator";
            case _721215: return "Grader Operator";
            case _721216: return "Loader Operator";
            case _721311: return "Forklift Driver";
            case _721900: return "Other Mobile Plant Operators not further defined";
            case _721911: return "Aircraft Baggage Handler and Airline Ground Crew";
            case _721912: return "Linemarker";
            case _721913: return "Paving Plant Operator";
            case _721914: return "Railway Track Plant Operator";
            case _721915: return "Road Roller Operator";
            case _721916: return "Streetsweeper Operator";
            case _721999: return "Mobile Plant Operators not elsewhere classified";
            case _730000: return "Road and Rail Drivers not further defined";
            case _731000: return "Automobile, Bus and Rail Drivers not further defined";
            case _731100: return "Automobile Drivers not further defined";
            case _731111: return "Chauffeur";
            case _731112: return "Taxi Driver";
            case _731199: return "Automobile Drivers not elsewhere classified";
            case _731200: return "Bus and Coach Drivers not further defined";
            case _731211: return "Bus Driver";
            case _731212: return "Charter and Tour Bus Driver";
            case _731213: return "Passenger Coach Driver";
            case _731300: return "Train and Tram Drivers not further defined";
            case _731311: return "Train Driver";
            case _731312: return "Tram Driver";
            case _732111: return "Delivery Driver";
            case _733100: return "Truck Drivers not further defined";
            case _733111: return "Truck Driver (General)";
            case _733112: return "Aircraft Refueller";
            case _733113: return "Furniture Removalist";
            case _733114: return "Tanker Driver";
            case _733115: return "Tow Truck Driver";
            case _741111: return "Storeperson";
            case _800000: return "Labourers not further defined";
            case _811000: return "Cleaners and Laundry Workers not further defined";
            case _811111: return "Car Detailer";
            case _811211: return "Commercial Cleaner";
            case _811311: return "Domestic Cleaner";
            case _811400: return "Housekeepers not further defined";
            case _811411: return "Commercial Housekeeper";
            case _811412: return "Domestic Housekeeper";
            case _811500: return "Laundry Workers not further defined";
            case _811511: return "Laundry Worker (General)";
            case _811512: return "Drycleaner";
            case _811513: return "Ironer or Presser";
            case _811600: return "Other Cleaners not further defined";
            case _811611: return "Carpet Cleaner";
            case _811612: return "Window Cleaner";
            case _811699: return "Cleaners not elsewhere classified";
            case _821000: return "Construction and Mining Labourers not further defined";
            case _821100: return "Building and Plumbing Labourers not further defined";
            case _821111: return "Builder's Labourer";
            case _821112: return "Drainage, Sewerage and Stormwater Labourer";
            case _821113: return "Earthmoving Labourer";
            case _821114: return "Plumber's Assistant";
            case _821211: return "Concreter";
            case _821311: return "Fencer";
            case _821400: return "Insulation and Home Improvement Installers not further defined";
            case _821411: return "Building Insulation Installer";
            case _821412: return "Home Improvement Installer";
            case _821511: return "Paving and Surfacing Labourer";
            case _821611: return "Railway Track Worker";
            case _821700: return "Structural Steel Construction Workers not further defined";
            case _821711: return "Construction Rigger";
            case _821712: return "Scaffolder";
            case _821713: return "Steel Fixer";
            case _821714: return "Structural Steel Erector";
            case _821900: return "Other Construction and Mining Labourers not further defined";
            case _821911: return "Crane Chaser";
            case _821912: return "Driller's Assistant";
            case _821913: return "Lagger";
            case _821914: return "Mining Support Worker";
            case _821915: return "Surveyor's Assistant";
            case _830000: return "Factory Process Workers not further defined";
            case _831000: return "Food Process Workers not further defined";
            case _831100: return "Food and Drink Factory Workers not further defined";
            case _831111: return "Baking Factory Worker";
            case _831112: return "Brewery Worker";
            case _831113: return "Confectionery Maker";
            case _831114: return "Dairy Products Maker";
            case _831115: return "Fruit and Vegetable Factory Worker";
            case _831116: return "Grain Mill Worker";
            case _831117: return "Sugar Mill Worker";
            case _831118: return "Winery Cellar Hand";
            case _831199: return "Food and Drink Factory Workers not elsewhere classified";
            case _831200: return "Meat Boners and Slicers, and Slaughterers not further defined";
            case _831211: return "Meat Boner and Slicer";
            case _831212: return "Slaughterer";
            case _831300: return "Meat, Poultry and Seafood Process Workers not further defined";
            case _831311: return "Meat Process Worker";
            case _831312: return "Poultry Process Worker";
            case _831313: return "Seafood Process Worker";
            case _832000: return "Packers and Product Assemblers not further defined";
            case _832100: return "Packers not further defined";
            case _832111: return "Chocolate Packer";
            case _832112: return "Container Filler";
            case _832113: return "Fruit and Vegetable Packer";
            case _832114: return "Meat Packer";
            case _832115: return "Seafood Packer";
            case _832199: return "Packers not elsewhere classified";
            case _832211: return "Product Assembler";
            case _839000: return "Miscellaneous Factory Process Workers not further defined";
            case _839111: return "Metal Engineering Process Worker";
            case _839200: return "Plastics and Rubber Factory Workers not further defined";
            case _839211: return "Plastics Factory Worker";
            case _839212: return "Rubber Factory Worker";
            case _839300: return "Product Quality Controllers not further defined";
            case _839311: return "Product Examiner";
            case _839312: return "Product Grader";
            case _839313: return "Product Tester";
            case _839400: return "Timber and Wood Process Workers not further defined";
            case _839411: return "Paper and Pulp Mill Worker";
            case _839412: return "Sawmill or Timber Yard Worker";
            case _839413: return "Wood and Wood Products Factory Worker";
            case _839900: return "Other Factory Process Workers not further defined";
            case _839911: return "Cement and Concrete Plant Worker";
            case _839912: return "Chemical Plant Worker";
            case _839913: return "Clay Processing Factory Worker";
            case _839914: return "Fabric and Textile Factory Worker";
            case _839915: return "Footwear Factory Worker";
            case _839916: return "Glass Processing Worker";
            case _839917: return "Hide and Skin Processing Worker";
            case _839999: return "Factory Process Workers not elsewhere classified";
            case _841000: return "Farm, Forestry and Garden Workers not further defined";
            case _841111: return "Aquaculture Worker";
            case _841200: return "Crop Farm Workers not further defined";
            case _841211: return "Fruit or Nut Farm Worker";
            case _841212: return "Fruit or Nut Picker";
            case _841213: return "Grain, Oilseed or Pasture Farm Worker";
            case _841214: return "Vegetable Farm Worker";
            case _841215: return "Vegetable Picker";
            case _841216: return "Vineyard Worker";
            case _841299: return "Crop Farm Workers not elsewhere classified";
            case _841300: return "Forestry and Logging Workers not further defined";
            case _841311: return "Forestry Worker";
            case _841312: return "Logging Assistant";
            case _841313: return "Tree Faller";
            case _841400: return "Garden and Nursery Labourers not further defined";
            case _841411: return "Garden Labourer";
            case _841412: return "Horticultural Nursery Assistant";
            case _841500: return "Livestock Farm Workers not further defined";
            case _841511: return "Beef Cattle Farm Worker";
            case _841512: return "Dairy Cattle Farm Worker";
            case _841513: return "Mixed Livestock Farm Worker";
            case _841514: return "Poultry Farm Worker";
            case _841515: return "Sheep Farm Worker";
            case _841516: return "Stablehand";
            case _841517: return "Wool Handler";
            case _841599: return "Livestock Farm Workers not elsewhere classified";
            case _841611: return "Mixed Crop and Livestock Farm Worker";
            case _841900: return "Other Farm, Forestry and Garden Workers not further defined";
            case _841911: return "Hunter-Trapper";
            case _841912: return "Pest or Weed Controller";
            case _841999: return "Farm, Forestry and Garden Workers not elsewhere classified";
            case _851000: return "Food Preparation Assistants not further defined";
            case _851111: return "Fast Food Cook";
            case _851200: return "Food Trades Assistants not further defined";
            case _851211: return "Pastrycook's Assistant";
            case _851299: return "Food Trades Assistants not elsewhere classified";
            case _851311: return "Kitchenhand";
            case _890000: return "Other Labourers not further defined";
            case _891000: return "Freight Handlers and Shelf Fillers not further defined";
            case _891100: return "Freight and Furniture Handlers not further defined";
            case _891111: return "Freight Handler (Rail or Road)";
            case _891112: return "Truck Driver's Offsider";
            case _891113: return "Waterside Worker";
            case _891211: return "Shelf Filler";
            case _899000: return "Miscellaneous Labourers not further defined";
            case _899111: return "Caretaker";
            case _899200: return "Deck and Fishing Hands not further defined";
            case _899211: return "Deck Hand";
            case _899212: return "Fishing Hand";
            case _899311: return "Handyperson";
            case _899400: return "Motor Vehicle Parts and Accessories Fitters not further defined";
            case _899411: return "Motor Vehicle Parts and Accessories Fitter (General)";
            case _899412: return "Autoglazier";
            case _899413: return "Exhaust and Muffler Fitter";
            case _899414: return "Radiator Fitter";
            case _899415: return "Tyre Fitter";
            case _899500: return "Printing Assistants and Table Workers not further defined";
            case _899511: return "Printer's Assistant";
            case _899512: return "Printing Table Worker";
            case _899611: return "Recycling or Rubbish Collector";
            case _899711: return "Vending Machine Attendant";
            case _899900: return "Other Miscellaneous Labourers not further defined";
            case _899911: return "Bicycle Mechanic";
            case _899912: return "Car Park Attendant";
            case _899913: return "Crossing Supervisor";
            case _899914: return "Electrical or Telecommunications Trades Assistant";
            case _899915: return "Leaflet or Newspaper Deliverer";
            case _899916: return "Mechanic's Assistant";
            case _899917: return "Railways Assistant";
            case _899918: return "Sign Erector";
            case _899921: return "Ticket Collector or Usher";
            case _899922: return "Trolley Collector";
            case _899999: return "Labourers not elsewhere classified";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getDisplay() {
          switch (this) {
            case _100000: return "Managers nfd";
            case _111000: return "Chief Executives, General Managers and Legislators nfd";
            case _111111: return "Chief Executive or Managing Director";
            case _111200: return "General Managers nfd";
            case _111211: return "Corporate General Manager";
            case _111212: return "Defence Force Senior Officer";
            case _111300: return "Legislators nfd";
            case _111311: return "Local Government Legislator";
            case _111312: return "Member of Parliament";
            case _111399: return "Legislators nec";
            case _121000: return "Farmers and Farm Managers nfd";
            case _121111: return "Aquaculture Farmer";
            case _121200: return "Crop Farmers nfd";
            case _121211: return "Cotton Grower";
            case _121212: return "Flower Grower";
            case _121213: return "Fruit or Nut Grower";
            case _121214: return "Grain, Oilseed or Pasture Grower";
            case _121215: return "Grape Grower";
            case _121216: return "Mixed Crop Farmer";
            case _121217: return "Sugar Cane Grower";
            case _121218: return "Turf Grower";
            case _121221: return "Vegetable Grower";
            case _121299: return "Crop Farmers nec";
            case _121300: return "Livestock Farmers nfd";
            case _121311: return "Apiarist";
            case _121312: return "Beef Cattle Farmer";
            case _121313: return "Dairy Cattle Farmer";
            case _121314: return "Deer Farmer";
            case _121315: return "Goat Farmer";
            case _121316: return "Horse Breeder";
            case _121317: return "Mixed Livestock Farmer";
            case _121318: return "Pig Farmer";
            case _121321: return "Poultry Farmer";
            case _121322: return "Sheep Farmer";
            case _121399: return "Livestock Farmers nec";
            case _121411: return "Mixed Crop and Livestock Farmer";
            case _130000: return "Specialist Managers nfd";
            case _131100: return "Advertising and Sales Managers nfd";
            case _131111: return "Advertising and Public Relations Manager";
            case _131112: return "Sales and Marketing Manager";
            case _132000: return "Business Administration Managers nfd";
            case _132111: return "Corporate Services Manager";
            case _132211: return "Finance Manager";
            case _132311: return "Human Resource Manager";
            case _132411: return "Policy and Planning Manager";
            case _132511: return "Research and Development Manager";
            case _133000: return "Construction, Distribution and Production Managers nfd";
            case _133100: return "Construction Managers nfd";
            case _133111: return "Construction Project Manager";
            case _133112: return "Project Builder";
            case _133211: return "Engineering Manager";
            case _133300: return "Importers, Exporters and Wholesalers nfd";
            case _133311: return "Importer or Exporter";
            case _133312: return "Wholesaler";
            case _133411: return "Manufacturer";
            case _133500: return "Production Managers nfd";
            case _133511: return "Production Manager (Forestry)";
            case _133512: return "Production Manager (Manufacturing)";
            case _133513: return "Production Manager (Mining)";
            case _133611: return "Supply and Distribution Manager";
            case _134000: return "Education, Health and Welfare Services Managers nfd";
            case _134111: return "Child Care Centre Manager";
            case _134200: return "Health and Welfare Services Managers nfd";
            case _134211: return "Medical Administrator";
            case _134212: return "Nursing Clinical Director";
            case _134213: return "Primary Health Organization Manager";
            case _134214: return "Welfare Centre Manager";
            case _134299: return "Health and Welfare Services Managers nec";
            case _134311: return "School Principal";
            case _134400: return "Other Education Managers nfd";
            case _134411: return "Faculty Head";
            case _134412: return "Regional Education Manager";
            case _134499: return "Education Managers nec";
            case _135100: return "ICT Managers nfd";
            case _135111: return "Chief Information Officer";
            case _135112: return "ICT Project Manager";
            case _135199: return "ICT Managers nec";
            case _139000: return "Miscellaneous Specialist Managers nfd";
            case _139100: return "Commissioned Officers (Management) nfd";
            case _139111: return "Commissioned Defence Force Officer";
            case _139112: return "Commissioned Fire Officer";
            case _139113: return "Commissioned Police Officer";
            case _139211: return "Senior Non-commissioned Defence Force Member";
            case _139900: return "Other Specialist Managers nfd";
            case _139911: return "Arts Administrator or Manager";
            case _139912: return "Environmental Manager";
            case _139913: return "Laboratory Manager";
            case _139914: return "Quality Assurance Manager";
            case _139915: return "Sports Administrator";
            case _139999: return "Specialist Managers nec";
            case _140000: return "Hospitality, Retail and Service Managers nfd";
            case _141000: return "Accommodation and Hospitality Managers nfd";
            case _141111: return "Cafe or Restaurant Manager";
            case _141211: return "Caravan Park and Camping Ground Manager";
            case _141311: return "Hotel or Motel Manager";
            case _141411: return "Licensed Club Manager";
            case _141900: return "Other Accommodation and Hospitality Managers nfd";
            case _141911: return "Bed and Breakfast Operator";
            case _141999: return "Accommodation and Hospitality Managers nec";
            case _142100: return "Retail Managers nfd";
            case _142111: return "Retail Manager (General)";
            case _142112: return "Antique Dealer";
            case _142113: return "Betting Agency Manager";
            case _142114: return "Hair or Beauty Salon Manager";
            case _142115: return "Post Office Manager";
            case _142116: return "Travel Agency Manager";
            case _149000: return "Miscellaneous Hospitality, Retail and Service Managers nfd";
            case _149100: return "Amusement, Fitness and Sports Centre Managers nfd";
            case _149111: return "Amusement Centre Manager";
            case _149112: return "Fitness Centre Manager";
            case _149113: return "Sports Centre Manager";
            case _149200: return "Call or Contact Centre and Customer Service Managers nfd";
            case _149211: return "Call or Contact Centre Manager";
            case _149212: return "Customer Service Manager";
            case _149311: return "Conference and Event Organizer";
            case _149400: return "Transport Services Managers nfd";
            case _149411: return "Fleet Manager";
            case _149412: return "Railway Station Manager";
            case _149413: return "Transport Company Manager";
            case _149900: return "Other Hospitality, Retail and Service Managers nfd";
            case _149911: return "Boarding Kennel or Cattery Operator";
            case _149912: return "Cinema or Theatre Manager";
            case _149913: return "Facilities Manager";
            case _149914: return "Financial Institution Branch Manager";
            case _149999: return "Hospitality, Retail and Service Managers nec";
            case _200000: return "Professionals nfd";
            case _210000: return "Arts and Media Professionals nfd";
            case _211000: return "Arts Professionals nfd";
            case _211100: return "Actors, Dancers and Other Entertainers nfd";
            case _211111: return "Actor";
            case _211112: return "Dancer or Choreographer";
            case _211113: return "Entertainer or Variety Artist";
            case _211199: return "Actors, Dancers and Other Entertainers nec";
            case _211200: return "Music Professionals nfd";
            case _211211: return "Composer";
            case _211212: return "Music Director";
            case _211213: return "Musician (Instrumental)";
            case _211214: return "Singer";
            case _211299: return "Music Professionals nec";
            case _211311: return "Photographer";
            case _211400: return "Visual Arts and Crafts Professionals nfd";
            case _211411: return "Painter (Visual Arts)";
            case _211412: return "Potter or Ceramic Artist";
            case _211413: return "Sculptor";
            case _211499: return "Visual Arts and Crafts Professionals nec";
            case _212000: return "Media Professionals nfd";
            case _212100: return "Artistic Directors, and Media Producers and Presenters nfd";
            case _212111: return "Artistic Director";
            case _212112: return "Media Producer (excluding Video)";
            case _212113: return "Radio Presenter";
            case _212114: return "Television Presenter";
            case _212200: return "Authors, and Book and Script Editors nfd";
            case _212211: return "Author";
            case _212212: return "Book or Script Editor";
            case _212300: return "Film, Television, Radio and Stage Directors nfd";
            case _212311: return "Art Director (Film, Television or Stage)";
            case _212312: return "Director (Film, Television, Radio or Stage)";
            case _212313: return "Director of Photography";
            case _212314: return "Film and Video Editor";
            case _212315: return "Program Director (Television or Radio)";
            case _212316: return "Stage Manager";
            case _212317: return "Technical Director";
            case _212318: return "Video Producer";
            case _212399: return "Film, Television, Radio and Stage Directors nec";
            case _212400: return "Journalists and Other Writers nfd";
            case _212411: return "Copywriter";
            case _212412: return "Newspaper or Periodical Editor";
            case _212413: return "Print Journalist";
            case _212414: return "Radio Journalist";
            case _212415: return "Technical Writer";
            case _212416: return "Television Journalist";
            case _212499: return "Journalists and Other Writers nec";
            case _220000: return "Business, Human Resource and Marketing Professionals nfd";
            case _221000: return "Accountants, Auditors and Company Secretaries nfd";
            case _221100: return "Accountants nfd";
            case _221111: return "Accountant (General)";
            case _221112: return "Management Accountant";
            case _221113: return "Taxation Accountant";
            case _221200: return "Auditors, Company Secretaries and Corporate Treasurers nfd";
            case _221211: return "Company Secretary";
            case _221212: return "Corporate Treasurer";
            case _221213: return "External Auditor";
            case _221214: return "Internal Auditor";
            case _222000: return "Financial Brokers and Dealers, and Investment Advisers nfd";
            case _222100: return "Financial Brokers nfd";
            case _222111: return "Commodities Trader";
            case _222112: return "Finance Broker";
            case _222113: return "Insurance Broker";
            case _222199: return "Financial Brokers nec";
            case _222200: return "Financial Dealers nfd";
            case _222211: return "Financial Market Dealer";
            case _222212: return "Futures Trader";
            case _222213: return "Stockbroking Dealer";
            case _222299: return "Financial Dealers nec";
            case _222300: return "Financial Investment Advisers and Managers nfd";
            case _222311: return "Financial Investment Adviser";
            case _222312: return "Financial Investment Manager";
            case _223000: return "Human Resource and Training Professionals nfd";
            case _223100: return "Human Resource Professionals nfd";
            case _223111: return "Human Resource Adviser";
            case _223112: return "Recruitment Consultant";
            case _223113: return "Workplace Relations Adviser";
            case _223211: return "ICT Trainer";
            case _223311: return "Training and Development Professional";
            case _224000: return "Information and Organization Professionals nfd";
            case _224100: return "Actuaries, Mathematicians and Statisticians nfd";
            case _224111: return "Actuary";
            case _224112: return "Mathematician";
            case _224113: return "Statistician";
            case _224200: return "Archivists, Curators and Records Managers nfd";
            case _224211: return "Archivist";
            case _224212: return "Gallery or Museum Curator";
            case _224213: return "Health Information Manager";
            case _224214: return "Records Manager";
            case _224311: return "Economist";
            case _224400: return "Intelligence and Policy Analysts nfd";
            case _224411: return "Intelligence Officer";
            case _224412: return "Policy Analyst";
            case _224500: return "Land Economists and Valuers nfd";
            case _224511: return "Land Economist";
            case _224512: return "Valuer";
            case _224611: return "Librarian";
            case _224700: return "Management and Organization Analysts nfd";
            case _224711: return "Management Consultant";
            case _224712: return "Organization and Methods Analyst";
            case _224900: return "Other Information and Organization Professionals nfd";
            case _224911: return "Electorate Officer";
            case _224912: return "Liaison Officer";
            case _224913: return "Migration Agent";
            case _224914: return "Patents Examiner";
            case _224999: return "Information and Organization Professionals nec";
            case _225000: return "Sales, Marketing and Public Relations Professionals nfd";
            case _225100: return "Advertising and Marketing Professionals nfd";
            case _225111: return "Advertising Specialist";
            case _225112: return "Market Research Analyst";
            case _225113: return "Marketing Specialist";
            case _225200: return "ICT Sales Professionals nfd";
            case _225211: return "ICT Account Manager";
            case _225212: return "ICT Business Development Manager";
            case _225213: return "ICT Sales Representative";
            case _225311: return "Public Relations Professional";
            case _225400: return "Technical Sales Representatives nfd";
            case _225411: return "Sales Representative (Industrial Products)";
            case _225412: return "Sales Representative (Medical and Pharmaceutical Products)";
            case _225499: return "Technical Sales Representatives nec";
            case _230000: return "Design, Engineering, Science and Transport Professionals nfd";
            case _231000: return "Air and Marine Transport Professionals nfd";
            case _231100: return "Air Transport Professionals nfd";
            case _231111: return "Aeroplane Pilot";
            case _231112: return "Air Traffic Controller";
            case _231113: return "Flying Instructor";
            case _231114: return "Helicopter Pilot";
            case _231199: return "Air Transport Professionals nec";
            case _231200: return "Marine Transport Professionals nfd";
            case _231211: return "Master Fisher";
            case _231212: return "Ship's Engineer";
            case _231213: return "Ship's Master";
            case _231214: return "Ship's Officer";
            case _231215: return "Ship's Surveyor";
            case _231299: return "Marine Transport Professionals nec";
            case _232000: return "Architects, Designers, Planners and Surveyors nfd";
            case _232100: return "Architects and Landscape Architects nfd";
            case _232111: return "Architect";
            case _232112: return "Landscape Architect";
            case _232200: return "Cartographers and Surveyors nfd";
            case _232211: return "Cartographer";
            case _232212: return "Surveyor";
            case _232300: return "Fashion, Industrial and Jewellery Designers nfd";
            case _232311: return "Fashion Designer";
            case _232312: return "Industrial Designer";
            case _232313: return "Jewellery Designer";
            case _232400: return "Graphic and Web Designers, and Illustrators nfd";
            case _232411: return "Graphic Designer";
            case _232412: return "Illustrator";
            case _232413: return "Multimedia Designer";
            case _232414: return "Web Designer";
            case _232511: return "Interior Designer";
            case _232611: return "Urban and Regional Planner";
            case _233000: return "Engineering Professionals nfd";
            case _233100: return "Chemical and Materials Engineers nfd";
            case _233111: return "Chemical Engineer";
            case _233112: return "Materials Engineer";
            case _233200: return "Civil Engineering Professionals nfd";
            case _233211: return "Civil Engineer";
            case _233212: return "Geotechnical Engineer";
            case _233213: return "Quantity Surveyor";
            case _233214: return "Structural Engineer";
            case _233215: return "Transport Engineer";
            case _233311: return "Electrical Engineer";
            case _233411: return "Electronics Engineer";
            case _233500: return "Industrial, Mechanical and Production Engineers nfd";
            case _233511: return "Industrial Engineer";
            case _233512: return "Mechanical Engineer";
            case _233513: return "Production or Plant Engineer";
            case _233600: return "Mining Engineers nfd";
            case _233611: return "Mining Engineer (excluding Petroleum)";
            case _233612: return "Petroleum Engineer";
            case _233900: return "Other Engineering Professionals nfd";
            case _233911: return "Aeronautical Engineer";
            case _233912: return "Agricultural Engineer";
            case _233913: return "Biomedical Engineer";
            case _233914: return "Engineering Technologist";
            case _233915: return "Environmental Engineer";
            case _233916: return "Naval Architect";
            case _233999: return "Engineering Professionals nec";
            case _234000: return "Natural and Physical Science Professionals nfd";
            case _234100: return "Agricultural and Forestry Scientists nfd";
            case _234111: return "Agricultural Consultant";
            case _234112: return "Agricultural Scientist";
            case _234113: return "Forester";
            case _234200: return "Chemists, and Food and Wine Scientists nfd";
            case _234211: return "Chemist";
            case _234212: return "Food Technologist";
            case _234213: return "Wine Maker";
            case _234300: return "Environmental Scientists nfd";
            case _234311: return "Conservation Officer";
            case _234312: return "Environmental Consultant";
            case _234313: return "Environmental Research Scientist";
            case _234314: return "Park Ranger";
            case _234399: return "Environmental Scientists nec";
            case _234400: return "Geologists and Geophysicists nfd";
            case _234411: return "Geologist";
            case _234412: return "Geophysicist";
            case _234500: return "Life Scientists nfd";
            case _234511: return "Life Scientist (General)";
            case _234512: return "Anatomist or Physiologist";
            case _234513: return "Biochemist";
            case _234514: return "Biotechnologist";
            case _234515: return "Botanist";
            case _234516: return "Marine Biologist";
            case _234517: return "Microbiologist";
            case _234518: return "Zoologist";
            case _234599: return "Life Scientists nec";
            case _234611: return "Medical Laboratory Scientist";
            case _234711: return "Veterinarian";
            case _234900: return "Other Natural and Physical Science Professionals nfd";
            case _234911: return "Conservator";
            case _234912: return "Metallurgist";
            case _234913: return "Meteorologist";
            case _234914: return "Physicist";
            case _234999: return "Natural and Physical Science Professionals nec";
            case _240000: return "Education Professionals nfd";
            case _241000: return "School Teachers nfd";
            case _241111: return "Early Childhood (Pre-primary School) Teacher";
            case _241213: return "Primary School Teacher";
            case _241311: return "Middle School Teacher";
            case _241411: return "Secondary School Teacher";
            case _241500: return "Special Education Teachers nfd";
            case _241511: return "Special Needs Teacher";
            case _241512: return "Teacher of the Hearing Impaired";
            case _241513: return "Teacher of the Sight Impaired";
            case _241599: return "Special Education Teachers nec";
            case _242000: return "Tertiary Education Teachers nfd";
            case _242100: return "University Lecturers and Tutors nfd";
            case _242111: return "University Lecturer";
            case _242112: return "University Tutor";
            case _242211: return "Vocational Education Teacher";
            case _249000: return "Miscellaneous Education Professionals nfd";
            case _249100: return "Education Advisers and Reviewers nfd";
            case _249111: return "Education Adviser";
            case _249112: return "Education Reviewer";
            case _249200: return "Private Tutors and Teachers nfd";
            case _249211: return "Art Teacher (Private Tuition)";
            case _249212: return "Dance Teacher (Private Tuition)";
            case _249213: return "Drama Teacher (Private Tuition)";
            case _249214: return "Music Teacher (Private Tuition)";
            case _249299: return "Private Tutors and Teachers nec";
            case _249311: return "Teacher of English to Speakers of Other Languages";
            case _250000: return "Health Professionals nfd";
            case _251000: return "Health Diagnostic and Promotion Professionals nfd";
            case _251111: return "Dietitian";
            case _251200: return "Medical Imaging Professionals nfd";
            case _251211: return "Medical Diagnostic Radiographer";
            case _251212: return "Medical Radiation Therapist";
            case _251213: return "Nuclear Medicine Technologist";
            case _251214: return "Sonographer";
            case _251300: return "Occupational and Environmental Health Professionals nfd";
            case _251311: return "Environmental Health Officer";
            case _251312: return "Occupational Health and Safety Adviser";
            case _251400: return "Optometrists and Orthoptists nfd";
            case _251411: return "Optometrist";
            case _251412: return "Orthoptist";
            case _251500: return "Pharmacists nfd";
            case _251511: return "Hospital Pharmacist";
            case _251512: return "Industrial Pharmacist";
            case _251513: return "Retail Pharmacist";
            case _251900: return "Other Health Diagnostic and Promotion Professionals nfd";
            case _251911: return "Health Promotion Officer";
            case _251912: return "Orthotist or Prosthetist";
            case _251999: return "Health Diagnostic and Promotion Professionals nec";
            case _252000: return "Health Therapy Professionals nfd";
            case _252100: return "Chiropractors and Osteopaths nfd";
            case _252111: return "Chiropractor";
            case _252112: return "Osteopath";
            case _252200: return "Complementary Health Therapists nfd";
            case _252211: return "Acupuncturist";
            case _252212: return "Homoeopath";
            case _252213: return "Naturopath";
            case _252214: return "Traditional Chinese Medicine Practitioner";
            case _252299: return "Complementary Health Therapists nec";
            case _252300: return "Dental Practitioners nfd";
            case _252311: return "Dental Specialist";
            case _252312: return "Dentist";
            case _252411: return "Occupational Therapist";
            case _252511: return "Physiotherapist";
            case _252611: return "Podiatrist";
            case _252700: return "Speech Professionals and Audiologists nfd";
            case _252711: return "Audiologist";
            case _252712: return "Speech Pathologist";
            case _253000: return "Medical Practitioners nfd";
            case _253100: return "Generalist Medical Practitioners nfd";
            case _253111: return "General Medical Practitioner";
            case _253112: return "Resident Medical Officer";
            case _253211: return "Anaesthetist";
            case _253300: return "Internal Medicine Specialists nfd";
            case _253311: return "Specialist Physician (General Medicine)";
            case _253312: return "Cardiologist";
            case _253313: return "Clinical Haematologist";
            case _253314: return "Clinical Oncologist";
            case _253315: return "Endocrinologist";
            case _253316: return "Gastroenterologist";
            case _253317: return "Intensive Care Specialist";
            case _253318: return "Neurologist";
            case _253321: return "Paediatrician";
            case _253322: return "Renal Medicine Specialist";
            case _253323: return "Rheumatologist";
            case _253324: return "Thoracic Medicine Specialist";
            case _253399: return "Internal Medicine Specialists nec";
            case _253411: return "Psychiatrist";
            case _253500: return "Surgeons nfd";
            case _253511: return "Surgeon (General)";
            case _253512: return "Cardiothoracic Surgeon";
            case _253513: return "Neurosurgeon";
            case _253514: return "Orthopaedic Surgeon";
            case _253515: return "Otorhinolaryngologist";
            case _253516: return "Paediatric Surgeon";
            case _253517: return "Plastic and Reconstructive Surgeon";
            case _253518: return "Urologist";
            case _253521: return "Vascular Surgeon";
            case _253900: return "Other Medical Practitioners nfd";
            case _253911: return "Dermatologist";
            case _253912: return "Emergency Medicine Specialist";
            case _253913: return "Obstetrician and Gynaecologist";
            case _253914: return "Ophthalmologist";
            case _253915: return "Pathologist";
            case _253916: return "Radiologist";
            case _253999: return "Medical Practitioners nec";
            case _254000: return "Midwifery and Nursing Professionals nfd";
            case _254111: return "Midwife";
            case _254200: return "Nurse Educators and Researchers nfd";
            case _254211: return "Nurse Educator";
            case _254212: return "Nurse Researcher";
            case _254311: return "Nurse Manager";
            case _254400: return "Registered Nurses nfd";
            case _254411: return "Nurse Practitioner";
            case _254412: return "Registered Nurse (Aged Care)";
            case _254413: return "Registered Nurse (Child and Family Health)";
            case _254414: return "Registered Nurse (Community Health)";
            case _254415: return "Registered Nurse (Critical Care and Emergency)";
            case _254416: return "Registered Nurse (Developmental Disability)";
            case _254417: return "Registered Nurse (Disability and Rehabilitation)";
            case _254418: return "Registered Nurse (Medical)";
            case _254421: return "Registered Nurse (Medical Practice)";
            case _254422: return "Registered Nurse (Mental Health)";
            case _254423: return "Registered Nurse (Perioperative)";
            case _254424: return "Registered Nurse (Surgical)";
            case _254499: return "Registered Nurses nec";
            case _260000: return "ICT Professionals nfd";
            case _261000: return "Business and Systems Analysts, and Programmers nfd";
            case _261100: return "ICT Business and Systems Analysts nfd";
            case _261111: return "ICT Business Analyst";
            case _261112: return "Systems Analyst";
            case _261200: return "Multimedia Specialists and Web Developers nfd";
            case _261211: return "Multimedia Specialist";
            case _261212: return "Web Developer";
            case _261300: return "Software and Applications Programmers nfd";
            case _261311: return "Analyst Programmer";
            case _261312: return "Developer Programmer";
            case _261313: return "Software Engineer";
            case _261399: return "Software and Applications Programmers nec";
            case _262100: return "Database and Systems Administrators, and ICT Security Specialists nfd";
            case _262111: return "Database Administrator";
            case _262112: return "ICT Security Specialist";
            case _262113: return "Systems Administrator";
            case _263000: return "ICT Network and Support Professionals nfd";
            case _263100: return "Computer Network Professionals nfd";
            case _263111: return "Computer Network and Systems Engineer";
            case _263112: return "Network Administrator";
            case _263113: return "Network Analyst";
            case _263200: return "ICT Support and Test Engineers nfd";
            case _263211: return "ICT Quality Assurance Engineer";
            case _263212: return "ICT Support Engineer";
            case _263213: return "ICT Systems Test Engineer";
            case _263299: return "ICT Support and Test Engineers nec";
            case _263300: return "Telecommunications Engineering Professionals nfd";
            case _263311: return "Telecommunications Engineer";
            case _263312: return "Telecommunications Network Engineer";
            case _270000: return "Legal, Social and Welfare Professionals nfd";
            case _271000: return "Legal Professionals nfd";
            case _271111: return "Barrister";
            case _271200: return "Judicial and Other Legal Professionals nfd";
            case _271211: return "Judge";
            case _271212: return "Magistrate";
            case _271213: return "Tribunal Member";
            case _271299: return "Judicial and Other Legal Professionals nec";
            case _271311: return "Solicitor";
            case _272000: return "Social and Welfare Professionals nfd";
            case _272100: return "Counsellors nfd";
            case _272111: return "Careers Counsellor";
            case _272112: return "Drug and Alcohol Counsellor";
            case _272113: return "Family and Marriage Counsellor";
            case _272114: return "Rehabilitation Counsellor";
            case _272115: return "Student Counsellor";
            case _272199: return "Counsellors nec";
            case _272211: return "Minister of Religion";
            case _272300: return "Psychologists nfd";
            case _272311: return "Clinical Psychologist";
            case _272312: return "Educational Psychologist";
            case _272313: return "Organizational Psychologist";
            case _272314: return "Psychotherapist";
            case _272399: return "Psychologists nec";
            case _272400: return "Social Professionals nfd";
            case _272411: return "Historian";
            case _272412: return "Interpreter";
            case _272413: return "Translator";
            case _272499: return "Social Professionals nec";
            case _272511: return "Social Worker";
            case _272600: return "Welfare, Recreation and Community Arts Workers nfd";
            case _272611: return "Community Arts Worker";
            case _272612: return "Recreation Officer";
            case _272613: return "Welfare Worker";
            case _300000: return "Technicians and Trades Workers nfd";
            case _310000: return "Engineering, ICT and Science Technicians nfd";
            case _311000: return "Agricultural, Medical and Science Technicians nfd";
            case _311111: return "Agricultural Technician";
            case _311200: return "Medical Technicians nfd";
            case _311211: return "Anaesthetic Technician";
            case _311212: return "Cardiac Technician";
            case _311213: return "Medical Laboratory Technician";
            case _311214: return "Operating Theatre Technician";
            case _311215: return "Pharmacy Technician";
            case _311299: return "Medical Technicians nec";
            case _311300: return "Primary Products Inspectors nfd";
            case _311311: return "Fisheries Officer";
            case _311312: return "Meat Inspector";
            case _311313: return "Quarantine Officer";
            case _311399: return "Primary Products Inspectors nec";
            case _311400: return "Science Technicians nfd";
            case _311411: return "Chemistry Technician";
            case _311412: return "Earth Science Technician";
            case _311413: return "Life Science Technician";
            case _311414: return "School Laboratory Technician";
            case _311499: return "Science Technicians nec";
            case _312000: return "Building and Engineering Technicians nfd";
            case _312100: return "Architectural, Building and Surveying Technicians nfd";
            case _312111: return "Architectural Draftsperson";
            case _312112: return "Building Associate";
            case _312113: return "Building Inspector";
            case _312114: return "Construction Estimator";
            case _312115: return "Plumbing Inspector";
            case _312116: return "Surveying or Cartographic Technician";
            case _312200: return "Civil Engineering Draftspersons and Technicians nfd";
            case _312211: return "Civil Engineering Draftsperson";
            case _312212: return "Civil Engineering Technician";
            case _312300: return "Electrical Engineering Draftspersons and Technicians nfd";
            case _312311: return "Electrical Engineering Draftsperson";
            case _312312: return "Electrical Engineering Technician";
            case _312400: return "Electronic Engineering Draftspersons and Technicians nfd";
            case _312411: return "Electronic Engineering Draftsperson";
            case _312412: return "Electronic Engineering Technician";
            case _312500: return "Mechanical Engineering Draftspersons and Technicians nfd";
            case _312511: return "Mechanical Engineering Draftsperson";
            case _312512: return "Mechanical Engineering Technician";
            case _312611: return "Safety Inspector";
            case _312900: return "Other Building and Engineering Technicians nfd";
            case _312911: return "Maintenance Planner";
            case _312912: return "Metallurgical or Materials Technician";
            case _312913: return "Mine Deputy";
            case _312999: return "Building and Engineering Technicians nec";
            case _313000: return "ICT and Telecommunications Technicians nfd";
            case _313100: return "ICT Support Technicians nfd";
            case _313111: return "Hardware Technician";
            case _313112: return "ICT Customer Support Officer";
            case _313113: return "Web Administrator";
            case _313199: return "ICT Support Technicians nec";
            case _313200: return "Telecommunications Technical Specialists nfd";
            case _313211: return "Radiocommunications Technician";
            case _313212: return "Telecommunications Field Engineer";
            case _313213: return "Telecommunications Network Planner";
            case _313214: return "Telecommunications Technical Officer or Technologist";
            case _320000: return "Automotive and Engineering Trades Workers nfd";
            case _321000: return "Automotive Electricians and Mechanics nfd";
            case _321111: return "Automotive Electrician";
            case _321200: return "Motor Mechanics nfd";
            case _321211: return "Motor Mechanic (General)";
            case _321212: return "Diesel Motor Mechanic";
            case _321213: return "Motorcycle Mechanic";
            case _321214: return "Small Engine Mechanic";
            case _322000: return "Fabrication Engineering Trades Workers nfd";
            case _322100: return "Metal Casting, Forging and Finishing Trades Workers nfd";
            case _322111: return "Blacksmith";
            case _322112: return "Electroplater";
            case _322113: return "Farrier";
            case _322114: return "Metal Casting Trades Worker";
            case _322115: return "Metal Polisher";
            case _322211: return "Sheetmetal Trades Worker";
            case _322300: return "Structural Steel and Welding Trades Workers nfd";
            case _322311: return "Metal Fabricator";
            case _322312: return "Pressure Welder";
            case _322313: return "Welder (First Class)";
            case _323000: return "Mechanical Engineering Trades Workers nfd";
            case _323100: return "Aircraft Maintenance Engineers nfd";
            case _323111: return "Aircraft Maintenance Engineer (Avionics)";
            case _323112: return "Aircraft Maintenance Engineer (Mechanical)";
            case _323113: return "Aircraft Maintenance Engineer (Structures)";
            case _323200: return "Metal Fitters and Machinists nfd";
            case _323211: return "Fitter (General)";
            case _323212: return "Fitter and Turner";
            case _323213: return "Fitter-Welder";
            case _323214: return "Metal Machinist (First Class)";
            case _323215: return "Textile, Clothing and Footwear Mechanic";
            case _323299: return "Metal Fitters and Machinists nec";
            case _323300: return "Precision Metal Trades Workers nfd";
            case _323311: return "Engraver";
            case _323312: return "Gunsmith";
            case _323313: return "Locksmith";
            case _323314: return "Precision Instrument Maker and Repairer";
            case _323315: return "Saw Maker and Repairer";
            case _323316: return "Watch and Clock Maker and Repairer";
            case _323400: return "Toolmakers and Engineering Patternmakers nfd";
            case _323411: return "Engineering Patternmaker";
            case _323412: return "Toolmaker";
            case _324000: return "Panelbeaters, and Vehicle Body Builders, Trimmers and Painters nfd";
            case _324111: return "Panelbeater";
            case _324200: return "Vehicle Body Builders and Trimmers nfd";
            case _324211: return "Vehicle Body Builder";
            case _324212: return "Vehicle Trimmer";
            case _324311: return "Vehicle Painter";
            case _330000: return "Construction Trades Workers nfd";
            case _331000: return "Bricklayers, and Carpenters and Joiners nfd";
            case _331100: return "Bricklayers and Stonemasons nfd";
            case _331111: return "Bricklayer";
            case _331112: return "Stonemason";
            case _331211: return "Carpenter and Joiner";
            case _331212: return "Carpenter";
            case _331213: return "Joiner";
            case _332000: return "Floor Finishers and Painting Trades Workers nfd";
            case _332111: return "Floor Finisher";
            case _332211: return "Painting Trades Worker";
            case _333000: return "Glaziers, Plasterers and Tilers nfd";
            case _333111: return "Glazier";
            case _333200: return "Plasterers nfd";
            case _333211: return "Fibrous Plasterer";
            case _333212: return "Solid Plasterer";
            case _333311: return "Roof Tiler";
            case _333411: return "Wall and Floor Tiler";
            case _334100: return "Plumbers nfd";
            case _334111: return "Plumber (General)";
            case _334112: return "Airconditioning and Mechanical Services Plumber";
            case _334113: return "Drainer";
            case _334114: return "Gasfitter";
            case _334115: return "Roof Plumber";
            case _340000: return "Electrotechnology and Telecommunications Trades Workers nfd";
            case _341100: return "Electricians nfd";
            case _341111: return "Electrician (General)";
            case _341112: return "Electrician (Special Class)";
            case _341113: return "Lift Mechanic";
            case _342000: return "Electronics and Telecommunications Trades Workers nfd";
            case _342111: return "Airconditioning and Refrigeration Mechanic";
            case _342200: return "Electrical Distribution Trades Workers nfd";
            case _342211: return "Electrical Linesworker";
            case _342212: return "Technical Cable Jointer";
            case _342300: return "Electronics Trades Workers nfd";
            case _342311: return "Business Machine Mechanic";
            case _342312: return "Communications Operator";
            case _342313: return "Electronic Equipment Trades Worker";
            case _342314: return "Electronic Instrument Trades Worker (General)";
            case _342315: return "Electronic Instrument Trades Worker (Special Class)";
            case _342400: return "Telecommunications Trades Workers nfd";
            case _342411: return "Cabler (Data and Telecommunications)";
            case _342412: return "Telecommunications Cable Jointer";
            case _342413: return "Telecommunications Linesworker";
            case _342414: return "Telecommunications Technician";
            case _351000: return "Food Trades Workers nfd";
            case _351100: return "Bakers and Pastrycooks nfd";
            case _351111: return "Baker";
            case _351112: return "Pastrycook";
            case _351211: return "Butcher or Smallgoods Maker";
            case _351311: return "Chef";
            case _351411: return "Cook";
            case _360000: return "Skilled Animal and Horticultural Workers nfd";
            case _361000: return "Animal Attendants and Trainers, and Shearers nfd";
            case _361100: return "Animal Attendants and Trainers nfd";
            case _361111: return "Dog Handler or Trainer";
            case _361112: return "Horse Trainer";
            case _361113: return "Pet Groomer";
            case _361114: return "Zookeeper";
            case _361199: return "Animal Attendants and Trainers nec";
            case _361211: return "Shearer";
            case _361311: return "Veterinary Nurse";
            case _362000: return "Horticultural Trades Workers nfd";
            case _362111: return "Florist";
            case _362200: return "Gardeners nfd";
            case _362211: return "Gardener (General)";
            case _362212: return "Arborist";
            case _362213: return "Landscape Gardener";
            case _362311: return "Greenkeeper";
            case _362411: return "Nurseryperson";
            case _390000: return "Other Technicians and Trades Workers nfd";
            case _391111: return "Hairdresser";
            case _392000: return "Printing Trades Workers nfd";
            case _392100: return "Binders, Finishers and Screen Printers nfd";
            case _392111: return "Binder and Finisher";
            case _392112: return "Screen Printer";
            case _392211: return "Graphic Pre-press Trades Worker";
            case _392300: return "Printers nfd";
            case _392311: return "Printing Machinist";
            case _392312: return "Small Offset Printer";
            case _393000: return "Textile, Clothing and Footwear Trades Workers nfd";
            case _393100: return "Canvas and Leather Goods Makers nfd";
            case _393111: return "Canvas Goods Maker";
            case _393112: return "Leather Goods Maker";
            case _393113: return "Sail Maker";
            case _393114: return "Shoemaker";
            case _393200: return "Clothing Trades Workers nfd";
            case _393211: return "Apparel Cutter";
            case _393212: return "Clothing Patternmaker";
            case _393213: return "Dressmaker or Tailor";
            case _393299: return "Clothing Trades Workers nec";
            case _393311: return "Upholsterer";
            case _394000: return "Wood Trades Workers nfd";
            case _394111: return "Cabinetmaker";
            case _394200: return "Wood Machinists and Other Wood Trades Workers nfd";
            case _394211: return "Furniture Finisher";
            case _394212: return "Picture Framer";
            case _394213: return "Wood Machinist";
            case _394214: return "Wood Turner";
            case _394299: return "Wood Machinists and Other Wood Trades Workers nec";
            case _399000: return "Miscellaneous Technicians and Trades Workers nfd";
            case _399100: return "Boat Builders and Shipwrights nfd";
            case _399111: return "Boat Builder and Repairer";
            case _399112: return "Shipwright";
            case _399200: return "Chemical, Gas, Petroleum and Power Generation Plant Operators nfd";
            case _399211: return "Chemical Plant Operator";
            case _399212: return "Gas or Petroleum Operator";
            case _399213: return "Power Generation Plant Operator";
            case _399300: return "Gallery, Library and Museum Technicians nfd";
            case _399311: return "Gallery or Museum Technician";
            case _399312: return "Library Technician";
            case _399411: return "Jeweller";
            case _399500: return "Performing Arts Technicians nfd";
            case _399511: return "Broadcast Transmitter Operator";
            case _399512: return "Camera Operator (Film, Television or Video)";
            case _399513: return "Light Technician";
            case _399514: return "Make Up Artist";
            case _399515: return "Musical Instrument Maker or Repairer";
            case _399516: return "Sound Technician";
            case _399517: return "Television Equipment Operator";
            case _399599: return "Performing Arts Technicians nec";
            case _399611: return "Signwriter";
            case _399900: return "Other Miscellaneous Technicians and Trades Workers nfd";
            case _399911: return "Diver";
            case _399912: return "Interior Decorator";
            case _399913: return "Optical Dispenser";
            case _399914: return "Optical Mechanic";
            case _399915: return "Photographer's Assistant";
            case _399916: return "Plastics Technician";
            case _399917: return "Wool Classer";
            case _399999: return "Technicians and Trades Workers nec";
            case _400000: return "Community and Personal Service Workers nfd";
            case _411000: return "Health and Welfare Support Workers nfd";
            case _411100: return "Ambulance Officers and Paramedics nfd";
            case _411111: return "Ambulance Officer";
            case _411112: return "Intensive Care Ambulance Paramedic";
            case _411200: return "Dental Hygienists, Technicians and Therapists nfd";
            case _411211: return "Dental Hygienist";
            case _411212: return "Dental Prosthetist";
            case _411213: return "Dental Technician";
            case _411214: return "Dental Therapist";
            case _411311: return "Diversional Therapist";
            case _411400: return "Enrolled and Mothercraft Nurses nfd";
            case _411411: return "Enrolled Nurse";
            case _411412: return "Mothercraft Nurse";
            case _411511: return "Aboriginal and Torres Strait Islander Health Worker";
            case _411611: return "Massage Therapist";
            case _411700: return "Welfare Support Workers nfd";
            case _411711: return "Community Worker";
            case _411712: return "Disabilities Services Officer";
            case _411713: return "Family Support Worker";
            case _411714: return "Parole or Probation Officer";
            case _411715: return "Residential Care Officer";
            case _411716: return "Youth Worker";
            case _420000: return "Carers and Aides nfd";
            case _421100: return "Child Carers nfd";
            case _421111: return "Child Care Worker";
            case _421112: return "Family Day Care Worker";
            case _421113: return "Nanny";
            case _421114: return "Out of School Hours Care Worker";
            case _422100: return "Education Aides nfd";
            case _422111: return "Aboriginal and Torres Strait Islander Education Worker";
            case _422112: return "Integration Aide";
            case _422115: return "Preschool Aide";
            case _422116: return "Teachers' Aide";
            case _423000: return "Personal Carers and Assistants nfd";
            case _423111: return "Aged or Disabled Carer";
            case _423211: return "Dental Assistant";
            case _423300: return "Nursing Support and Personal Care Workers nfd";
            case _423311: return "Hospital Orderly";
            case _423312: return "Nursing Support Worker";
            case _423313: return "Personal Care Assistant";
            case _423314: return "Therapy Aide";
            case _423400: return "Special Care Workers nfd";
            case _423411: return "Child or Youth Residential Care Assistant";
            case _423412: return "Hostel Parent";
            case _423413: return "Refuge Worker";
            case _431000: return "Hospitality Workers nfd";
            case _431100: return "Bar Attendants and Baristas nfd";
            case _431111: return "Bar Attendant";
            case _431112: return "Barista";
            case _431211: return "Cafe Worker";
            case _431311: return "Gaming Worker";
            case _431411: return "Hotel Service Manager";
            case _431511: return "Waiter";
            case _431900: return "Other Hospitality Workers nfd";
            case _431911: return "Bar Useful or Busser";
            case _431912: return "Doorperson or Luggage Porter";
            case _431999: return "Hospitality Workers nec";
            case _440000: return "Protective Service Workers nfd";
            case _441000: return "Defence Force Members, Fire Fighters and Police nfd";
            case _441111: return "Defence Force Member - Other Ranks";
            case _441200: return "Fire and Emergency Workers nfd";
            case _441211: return "Emergency Service Worker";
            case _441212: return "Fire Fighter";
            case _441300: return "Police nfd";
            case _441311: return "Detective";
            case _441312: return "Police Officer";
            case _442000: return "Prison and Security Officers nfd";
            case _442111: return "Prison Officer";
            case _442200: return "Security Officers and Guards nfd";
            case _442211: return "Alarm, Security or Surveillance Monitor";
            case _442212: return "Armoured Car Escort";
            case _442213: return "Crowd Controller";
            case _442214: return "Private Investigator";
            case _442215: return "Retail Loss Prevention Officer";
            case _442216: return "Security Consultant";
            case _442217: return "Security Officer";
            case _442299: return "Security Officers and Guards nec";
            case _450000: return "Sports and Personal Service Workers nfd";
            case _451000: return "Personal Service and Travel Workers nfd";
            case _451111: return "Beauty Therapist";
            case _451211: return "Driving Instructor";
            case _451300: return "Funeral Workers nfd";
            case _451311: return "Funeral Director";
            case _451399: return "Funeral Workers nec";
            case _451400: return "Gallery, Museum and Tour Guides nfd";
            case _451411: return "Gallery or Museum Guide";
            case _451412: return "Tour Guide";
            case _451500: return "Personal Care Consultants nfd";
            case _451511: return "Natural Remedy Consultant";
            case _451512: return "Weight Loss Consultant";
            case _451600: return "Tourism and Travel Advisers nfd";
            case _451611: return "Tourist Information Officer";
            case _451612: return "Travel Consultant";
            case _451700: return "Travel Attendants nfd";
            case _451711: return "Flight Attendant";
            case _451799: return "Travel Attendants nec";
            case _451800: return "Other Personal Service Workers nfd";
            case _451811: return "Civil Celebrant";
            case _451812: return "Hair or Beauty Salon Assistant";
            case _451813: return "Sex Worker or Escort";
            case _451899: return "Personal Service Workers nec";
            case _452000: return "Sports and Fitness Workers nfd";
            case _452111: return "Fitness Instructor";
            case _452200: return "Outdoor Adventure Guides nfd";
            case _452211: return "Bungy Jump Master";
            case _452212: return "Fishing Guide";
            case _452213: return "Hunting Guide";
            case _452214: return "Mountain or Glacier Guide";
            case _452215: return "Outdoor Adventure Instructor";
            case _452216: return "Trekking Guide";
            case _452217: return "Whitewater Rafting Guide";
            case _452299: return "Outdoor Adventure Guides nec";
            case _452300: return "Sports Coaches, Instructors and Officials nfd";
            case _452311: return "Diving Instructor (Open Water)";
            case _452312: return "Gymnastics Coach or Instructor";
            case _452313: return "Horse Riding Coach or Instructor";
            case _452314: return "Snowsport Instructor";
            case _452315: return "Swimming Coach or Instructor";
            case _452316: return "Tennis Coach";
            case _452317: return "Other Sports Coach or Instructor";
            case _452318: return "Dog or Horse Racing Official";
            case _452321: return "Sports Development Officer";
            case _452322: return "Sports Umpire";
            case _452323: return "Other Sports Official";
            case _452400: return "Sportspersons nfd";
            case _452411: return "Footballer";
            case _452412: return "Golfer";
            case _452413: return "Jockey";
            case _452414: return "Lifeguard";
            case _452499: return "Sportspersons nec";
            case _500000: return "Clerical and Administrative Workers nfd";
            case _510000: return "Office Managers and Program Administrators nfd";
            case _511100: return "Contract, Program and Project Administrators nfd";
            case _511111: return "Contract Administrator";
            case _511112: return "Program or Project Administrator";
            case _512000: return "Office and Practice Managers nfd";
            case _512111: return "Office Manager";
            case _512200: return "Practice Managers nfd";
            case _512211: return "Health Practice Manager";
            case _512299: return "Practice Managers nec";
            case _521000: return "Personal Assistants and Secretaries nfd";
            case _521111: return "Personal Assistant";
            case _521200: return "Secretaries nfd";
            case _521211: return "Secretary (General)";
            case _521212: return "Legal Secretary";
            case _530000: return "General Clerical Workers nfd";
            case _531111: return "General Clerk";
            case _532100: return "Keyboard Operators nfd";
            case _532111: return "Data Entry Operator";
            case _532112: return "Machine Shorthand Reporter";
            case _532113: return "Word Processing Operator";
            case _540000: return "Inquiry Clerks and Receptionists nfd";
            case _541000: return "Call or Contact Centre Information Clerks nfd";
            case _541100: return "Call or Contact Centre Workers nfd";
            case _541111: return "Call or Contact Centre Team Leader";
            case _541112: return "Call or Contact Centre Operator";
            case _541211: return "Inquiry Clerk";
            case _542100: return "Receptionists nfd";
            case _542111: return "Receptionist (General)";
            case _542112: return "Admissions Clerk";
            case _542113: return "Hotel or Motel Receptionist";
            case _542114: return "Medical Receptionist";
            case _550000: return "Numerical Clerks nfd";
            case _551000: return "Accounting Clerks and Bookkeepers nfd";
            case _551100: return "Accounting Clerks nfd";
            case _551111: return "Accounts Clerk";
            case _551112: return "Cost Clerk";
            case _551211: return "Bookkeeper";
            case _551311: return "Payroll Clerk";
            case _552000: return "Financial and Insurance Clerks nfd";
            case _552111: return "Bank Worker";
            case _552211: return "Credit or Loans Officer";
            case _552300: return "Insurance, Money Market and Statistical Clerks nfd";
            case _552311: return "Bookmaker";
            case _552312: return "Insurance Consultant";
            case _552313: return "Money Market Clerk";
            case _552314: return "Statistical Clerk";
            case _561000: return "Clerical and Office Support Workers nfd";
            case _561100: return "Betting Clerks nfd";
            case _561111: return "Betting Agency Counter Clerk";
            case _561112: return "Bookmaker's Clerk";
            case _561113: return "Telephone Betting Clerk";
            case _561199: return "Betting Clerks nec";
            case _561200: return "Couriers and Postal Deliverers nfd";
            case _561211: return "Courier";
            case _561212: return "Postal Delivery Officer";
            case _561311: return "Filing or Registry Clerk";
            case _561400: return "Mail Sorters nfd";
            case _561411: return "Mail Clerk";
            case _561412: return "Postal Sorting Officer";
            case _561511: return "Survey Interviewer";
            case _561611: return "Switchboard Operator";
            case _561900: return "Other Clerical and Office Support Workers nfd";
            case _561911: return "Classified Advertising Clerk";
            case _561912: return "Meter Reader";
            case _561913: return "Parking Inspector";
            case _561999: return "Clerical and Office Support Workers nec";
            case _590000: return "Other Clerical and Administrative Workers nfd";
            case _591000: return "Logistics Clerks nfd";
            case _591100: return "Purchasing and Supply Logistics Clerks nfd";
            case _591111: return "Order Clerk";
            case _591112: return "Production Clerk";
            case _591113: return "Purchasing Officer";
            case _591114: return "Sales Clerk";
            case _591115: return "Stock Clerk";
            case _591116: return "Warehouse Administrator";
            case _591200: return "Transport and Despatch Clerks nfd";
            case _591211: return "Despatching and Receiving Clerk";
            case _591212: return "Import-Export Clerk";
            case _599000: return "Miscellaneous Clerical and Administrative Workers nfd";
            case _599100: return "Conveyancers and Legal Executives nfd";
            case _599111: return "Conveyancer";
            case _599112: return "Legal Executive";
            case _599200: return "Court and Legal Clerks nfd";
            case _599211: return "Clerk of Court";
            case _599212: return "Court Bailiff or Sheriff";
            case _599213: return "Court Orderly";
            case _599214: return "Law Clerk";
            case _599215: return "Trust Officer";
            case _599311: return "Debt Collector";
            case _599411: return "Human Resource Clerk";
            case _599500: return "Inspectors and Regulatory Officers nfd";
            case _599511: return "Customs Officer";
            case _599512: return "Immigration Officer";
            case _599513: return "Motor Vehicle Licence Examiner";
            case _599514: return "Noxious Weeds and Pest Inspector";
            case _599515: return "Social Security Assessor";
            case _599516: return "Taxation Inspector";
            case _599517: return "Train Examiner";
            case _599518: return "Transport Operations Inspector";
            case _599521: return "Water Inspector";
            case _599599: return "Inspectors and Regulatory Officers nec";
            case _599600: return "Insurance Investigators, Loss Adjusters and Risk Surveyors nfd";
            case _599611: return "Insurance Investigator";
            case _599612: return "Insurance Loss Adjuster";
            case _599613: return "Insurance Risk Surveyor";
            case _599711: return "Library Assistant";
            case _599900: return "Other Miscellaneous Clerical and Administrative Workers nfd";
            case _599911: return "Coding Clerk";
            case _599912: return "Production Assistant (Film, Television, Radio or Stage)";
            case _599913: return "Proof Reader";
            case _599914: return "Radio Despatcher";
            case _599999: return "Clerical and Administrative Workers nec";
            case _600000: return "Sales Workers nfd";
            case _610000: return "Sales Representatives and Agents nfd";
            case _611000: return "Insurance Agents and Sales Representatives nfd";
            case _611100: return "Auctioneers, and Stock and Station Agents nfd";
            case _611111: return "Auctioneer";
            case _611112: return "Stock and Station Agent";
            case _611211: return "Insurance Agent";
            case _611300: return "Sales Representatives nfd";
            case _611311: return "Sales Representative (Building and Plumbing Supplies)";
            case _611312: return "Sales Representative (Business Services)";
            case _611313: return "Sales Representative (Motor Vehicle Parts and Accessories)";
            case _611314: return "Sales Representative (Personal and Household Goods)";
            case _611399: return "Sales Representatives nec";
            case _612100: return "Real Estate Sales Agents nfd";
            case _612111: return "Business Broker";
            case _612112: return "Property Manager";
            case _612113: return "Real Estate Agency Principal";
            case _612114: return "Real Estate Agent";
            case _612115: return "Real Estate Representative";
            case _621000: return "Sales Assistants and Salespersons nfd";
            case _621111: return "Sales Assistant (General)";
            case _621211: return "ICT Sales Assistant";
            case _621300: return "Motor Vehicle and Vehicle Parts Salespersons nfd";
            case _621311: return "Motor Vehicle or Caravan Salesperson";
            case _621312: return "Motor Vehicle Parts Interpreter";
            case _621411: return "Pharmacy Sales Assistant";
            case _621511: return "Retail Supervisor";
            case _621611: return "Service Station Attendant";
            case _621700: return "Street Vendors and Related Salespersons nfd";
            case _621711: return "Cash Van Salesperson";
            case _621712: return "Door-to-door Salesperson";
            case _621713: return "Street Vendor";
            case _621900: return "Other Sales Assistants and Salespersons nfd";
            case _621911: return "Materials Recycler";
            case _621912: return "Rental Salesperson";
            case _621999: return "Sales Assistants and Salespersons nec";
            case _630000: return "Sales Support Workers nfd";
            case _631100: return "Checkout Operators and Office Cashiers nfd";
            case _631111: return "Checkout Operator";
            case _631112: return "Office Cashier";
            case _639000: return "Miscellaneous Sales Support Workers nfd";
            case _639100: return "Models and Sales Demonstrators nfd";
            case _639111: return "Model";
            case _639112: return "Sales Demonstrator";
            case _639200: return "Retail and Wool Buyers nfd";
            case _639211: return "Retail Buyer";
            case _639212: return "Wool Buyer";
            case _639311: return "Telemarketer";
            case _639400: return "Ticket Salespersons nfd";
            case _639411: return "Ticket Seller";
            case _639412: return "Transport Conductor";
            case _639511: return "Visual Merchandiser";
            case _639911: return "Other Sales Support Worker";
            case _700000: return "Machinery Operators and Drivers nfd";
            case _710000: return "Machine and Stationary Plant Operators nfd";
            case _711000: return "Machine Operators nfd";
            case _711100: return "Clay, Concrete, Glass and Stone Processing Machine Operators nfd";
            case _711111: return "Clay Products Machine Operator";
            case _711112: return "Concrete Products Machine Operator";
            case _711113: return "Glass Production Machine Operator";
            case _711114: return "Stone Processing Machine Operator";
            case _711199: return "Clay, Concrete, Glass and Stone Processing Machine Operators nec";
            case _711211: return "Industrial Spraypainter";
            case _711300: return "Paper and Wood Processing Machine Operators nfd";
            case _711311: return "Paper Products Machine Operator";
            case _711312: return "Wood Processing Machine Operator";
            case _711411: return "Photographic Developer and Printer";
            case _711500: return "Plastics and Rubber Production Machine Operators nfd";
            case _711511: return "Plastic Cablemaking Machine Operator";
            case _711512: return "Plastic Compounding and Reclamation Machine Operator";
            case _711513: return "Plastics Fabricator or Welder";
            case _711514: return "Plastics Production Machine Operator (General)";
            case _711515: return "Reinforced Plastic and Composite Production Worker";
            case _711516: return "Rubber Production Machine Operator";
            case _711599: return "Plastics and Rubber Production Machine Operators nec";
            case _711611: return "Sewing Machinist";
            case _711700: return "Textile and Footwear Production Machine Operators nfd";
            case _711711: return "Footwear Production Machine Operator";
            case _711712: return "Hide and Skin Processing Machine Operator";
            case _711713: return "Knitting Machine Operator";
            case _711714: return "Textile Dyeing and Finishing Machine Operator";
            case _711715: return "Weaving Machine Operator";
            case _711716: return "Yarn Carding and Spinning Machine Operator";
            case _711799: return "Textile and Footwear Production Machine Operators nec";
            case _711900: return "Other Machine Operators nfd";
            case _711911: return "Chemical Production Machine Operator";
            case _711912: return "Motion Picture Projectionist";
            case _711913: return "Sand Blaster";
            case _711914: return "Sterilisation Technician";
            case _711999: return "Machine Operators nec";
            case _712000: return "Stationary Plant Operators nfd";
            case _712111: return "Crane, Hoist or Lift Operator";
            case _712200: return "Drillers, Miners and Shot Firers nfd";
            case _712211: return "Driller";
            case _712212: return "Miner";
            case _712213: return "Shot Firer";
            case _712311: return "Engineering Production Systems Worker";
            case _712900: return "Other Stationary Plant Operators nfd";
            case _712911: return "Boiler or Engine Operator";
            case _712912: return "Bulk Materials Handling Plant Operator";
            case _712913: return "Cement Production Plant Operator";
            case _712914: return "Concrete Batching Plant Operator";
            case _712915: return "Concrete Pump Operator";
            case _712916: return "Paper and Pulp Mill Operator";
            case _712917: return "Railway Signal Operator";
            case _712918: return "Train Controller";
            case _712921: return "Waste Water or Water Plant Operator";
            case _712922: return "Weighbridge Operator";
            case _712999: return "Stationary Plant Operators nec";
            case _721000: return "Mobile Plant Operators nfd";
            case _721100: return "Agricultural, Forestry and Horticultural Plant Operators nfd";
            case _721111: return "Agricultural and Horticultural Mobile Plant Operator";
            case _721112: return "Logging Plant Operator";
            case _721200: return "Earthmoving Plant Operators nfd";
            case _721211: return "Earthmoving Plant Operator (General)";
            case _721212: return "Backhoe Operator";
            case _721213: return "Bulldozer Operator";
            case _721214: return "Excavator Operator";
            case _721215: return "Grader Operator";
            case _721216: return "Loader Operator";
            case _721311: return "Forklift Driver";
            case _721900: return "Other Mobile Plant Operators nfd";
            case _721911: return "Aircraft Baggage Handler and Airline Ground Crew";
            case _721912: return "Linemarker";
            case _721913: return "Paving Plant Operator";
            case _721914: return "Railway Track Plant Operator";
            case _721915: return "Road Roller Operator";
            case _721916: return "Streetsweeper Operator";
            case _721999: return "Mobile Plant Operators nec";
            case _730000: return "Road and Rail Drivers nfd";
            case _731000: return "Automobile, Bus and Rail Drivers nfd";
            case _731100: return "Automobile Drivers nfd";
            case _731111: return "Chauffeur";
            case _731112: return "Taxi Driver";
            case _731199: return "Automobile Drivers nec";
            case _731200: return "Bus and Coach Drivers nfd";
            case _731211: return "Bus Driver";
            case _731212: return "Charter and Tour Bus Driver";
            case _731213: return "Passenger Coach Driver";
            case _731300: return "Train and Tram Drivers nfd";
            case _731311: return "Train Driver";
            case _731312: return "Tram Driver";
            case _732111: return "Delivery Driver";
            case _733100: return "Truck Drivers nfd";
            case _733111: return "Truck Driver (General)";
            case _733112: return "Aircraft Refueller";
            case _733113: return "Furniture Removalist";
            case _733114: return "Tanker Driver";
            case _733115: return "Tow Truck Driver";
            case _741111: return "Storeperson";
            case _800000: return "Labourers nfd";
            case _811000: return "Cleaners and Laundry Workers nfd";
            case _811111: return "Car Detailer";
            case _811211: return "Commercial Cleaner";
            case _811311: return "Domestic Cleaner";
            case _811400: return "Housekeepers nfd";
            case _811411: return "Commercial Housekeeper";
            case _811412: return "Domestic Housekeeper";
            case _811500: return "Laundry Workers nfd";
            case _811511: return "Laundry Worker (General)";
            case _811512: return "Drycleaner";
            case _811513: return "Ironer or Presser";
            case _811600: return "Other Cleaners nfd";
            case _811611: return "Carpet Cleaner";
            case _811612: return "Window Cleaner";
            case _811699: return "Cleaners nec";
            case _821000: return "Construction and Mining Labourers nfd";
            case _821100: return "Building and Plumbing Labourers nfd";
            case _821111: return "Builder's Labourer";
            case _821112: return "Drainage, Sewerage and Stormwater Labourer";
            case _821113: return "Earthmoving Labourer";
            case _821114: return "Plumber's Assistant";
            case _821211: return "Concreter";
            case _821311: return "Fencer";
            case _821400: return "Insulation and Home Improvement Installers nfd";
            case _821411: return "Building Insulation Installer";
            case _821412: return "Home Improvement Installer";
            case _821511: return "Paving and Surfacing Labourer";
            case _821611: return "Railway Track Worker";
            case _821700: return "Structural Steel Construction Workers nfd";
            case _821711: return "Construction Rigger";
            case _821712: return "Scaffolder";
            case _821713: return "Steel Fixer";
            case _821714: return "Structural Steel Erector";
            case _821900: return "Other Construction and Mining Labourers nfd";
            case _821911: return "Crane Chaser";
            case _821912: return "Driller's Assistant";
            case _821913: return "Lagger";
            case _821914: return "Mining Support Worker";
            case _821915: return "Surveyor's Assistant";
            case _830000: return "Factory Process Workers nfd";
            case _831000: return "Food Process Workers nfd";
            case _831100: return "Food and Drink Factory Workers nfd";
            case _831111: return "Baking Factory Worker";
            case _831112: return "Brewery Worker";
            case _831113: return "Confectionery Maker";
            case _831114: return "Dairy Products Maker";
            case _831115: return "Fruit and Vegetable Factory Worker";
            case _831116: return "Grain Mill Worker";
            case _831117: return "Sugar Mill Worker";
            case _831118: return "Winery Cellar Hand";
            case _831199: return "Food and Drink Factory Workers nec";
            case _831200: return "Meat Boners and Slicers, and Slaughterers nfd";
            case _831211: return "Meat Boner and Slicer";
            case _831212: return "Slaughterer";
            case _831300: return "Meat, Poultry and Seafood Process Workers nfd";
            case _831311: return "Meat Process Worker";
            case _831312: return "Poultry Process Worker";
            case _831313: return "Seafood Process Worker";
            case _832000: return "Packers and Product Assemblers nfd";
            case _832100: return "Packers nfd";
            case _832111: return "Chocolate Packer";
            case _832112: return "Container Filler";
            case _832113: return "Fruit and Vegetable Packer";
            case _832114: return "Meat Packer";
            case _832115: return "Seafood Packer";
            case _832199: return "Packers nec";
            case _832211: return "Product Assembler";
            case _839000: return "Miscellaneous Factory Process Workers nfd";
            case _839111: return "Metal Engineering Process Worker";
            case _839200: return "Plastics and Rubber Factory Workers nfd";
            case _839211: return "Plastics Factory Worker";
            case _839212: return "Rubber Factory Worker";
            case _839300: return "Product Quality Controllers nfd";
            case _839311: return "Product Examiner";
            case _839312: return "Product Grader";
            case _839313: return "Product Tester";
            case _839400: return "Timber and Wood Process Workers nfd";
            case _839411: return "Paper and Pulp Mill Worker";
            case _839412: return "Sawmill or Timber Yard Worker";
            case _839413: return "Wood and Wood Products Factory Worker";
            case _839900: return "Other Factory Process Workers nfd";
            case _839911: return "Cement and Concrete Plant Worker";
            case _839912: return "Chemical Plant Worker";
            case _839913: return "Clay Processing Factory Worker";
            case _839914: return "Fabric and Textile Factory Worker";
            case _839915: return "Footwear Factory Worker";
            case _839916: return "Glass Processing Worker";
            case _839917: return "Hide and Skin Processing Worker";
            case _839999: return "Factory Process Workers nec";
            case _841000: return "Farm, Forestry and Garden Workers nfd";
            case _841111: return "Aquaculture Worker";
            case _841200: return "Crop Farm Workers nfd";
            case _841211: return "Fruit or Nut Farm Worker";
            case _841212: return "Fruit or Nut Picker";
            case _841213: return "Grain, Oilseed or Pasture Farm Worker";
            case _841214: return "Vegetable Farm Worker";
            case _841215: return "Vegetable Picker";
            case _841216: return "Vineyard Worker";
            case _841299: return "Crop Farm Workers nec";
            case _841300: return "Forestry and Logging Workers nfd";
            case _841311: return "Forestry Worker";
            case _841312: return "Logging Assistant";
            case _841313: return "Tree Faller";
            case _841400: return "Garden and Nursery Labourers nfd";
            case _841411: return "Garden Labourer";
            case _841412: return "Horticultural Nursery Assistant";
            case _841500: return "Livestock Farm Workers nfd";
            case _841511: return "Beef Cattle Farm Worker";
            case _841512: return "Dairy Cattle Farm Worker";
            case _841513: return "Mixed Livestock Farm Worker";
            case _841514: return "Poultry Farm Worker";
            case _841515: return "Sheep Farm Worker";
            case _841516: return "Stablehand";
            case _841517: return "Wool Handler";
            case _841599: return "Livestock Farm Workers nec";
            case _841611: return "Mixed Crop and Livestock Farm Worker";
            case _841900: return "Other Farm, Forestry and Garden Workers nfd";
            case _841911: return "Hunter-Trapper";
            case _841912: return "Pest or Weed Controller";
            case _841999: return "Farm, Forestry and Garden Workers nec";
            case _851000: return "Food Preparation Assistants nfd";
            case _851111: return "Fast Food Cook";
            case _851200: return "Food Trades Assistants nfd";
            case _851211: return "Pastrycook's Assistant";
            case _851299: return "Food Trades Assistants nec";
            case _851311: return "Kitchenhand";
            case _890000: return "Other Labourers nfd";
            case _891000: return "Freight Handlers and Shelf Fillers nfd";
            case _891100: return "Freight and Furniture Handlers nfd";
            case _891111: return "Freight Handler (Rail or Road)";
            case _891112: return "Truck Driver's Offsider";
            case _891113: return "Waterside Worker";
            case _891211: return "Shelf Filler";
            case _899000: return "Miscellaneous Labourers nfd";
            case _899111: return "Caretaker";
            case _899200: return "Deck and Fishing Hands nfd";
            case _899211: return "Deck Hand";
            case _899212: return "Fishing Hand";
            case _899311: return "Handyperson";
            case _899400: return "Motor Vehicle Parts and Accessories Fitters nfd";
            case _899411: return "Motor Vehicle Parts and Accessories Fitter (General)";
            case _899412: return "Autoglazier";
            case _899413: return "Exhaust and Muffler Fitter";
            case _899414: return "Radiator Fitter";
            case _899415: return "Tyre Fitter";
            case _899500: return "Printing Assistants and Table Workers nfd";
            case _899511: return "Printer's Assistant";
            case _899512: return "Printing Table Worker";
            case _899611: return "Recycling or Rubbish Collector";
            case _899711: return "Vending Machine Attendant";
            case _899900: return "Other Miscellaneous Labourers nfd";
            case _899911: return "Bicycle Mechanic";
            case _899912: return "Car Park Attendant";
            case _899913: return "Crossing Supervisor";
            case _899914: return "Electrical or Telecommunications Trades Assistant";
            case _899915: return "Leaflet or Newspaper Deliverer";
            case _899916: return "Mechanic's Assistant";
            case _899917: return "Railways Assistant";
            case _899918: return "Sign Erector";
            case _899921: return "Ticket Collector or Usher";
            case _899922: return "Trolley Collector";
            case _899999: return "Labourers nec";
            case NULL: return null;
            default: return "?";
          }
    }


}