package org.hl7.fhir.r4.model.codesystems;

/*-
 * #%L
 * org.hl7.fhir.r4
 * %%
 * Copyright (C) 2014 - 2019 Health Level 7
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Wed, Jan 30, 2019 16:19-0500 for FHIR v4.0.0


import org.hl7.fhir.exceptions.FHIRException;

public enum V3Dentition {

        /**
         * Artificial dentition, artificial subsitutes for the natural dentition
         */
        ARTIFICIALDENTITION, 
        /**
         * Maxillary left lateral incisor abutment
         */
        TID10A, 
        /**
         * Maxillary left lateral incisor implant
         */
        TID10I, 
        /**
         * Maxillary left lateral incisor prosthesis
         */
        TID10P, 
        /**
         * Maxillary left lateral incisor distal prosthesis
         */
        TID10PD, 
        /**
         * Maxillary left lateral incisor mesial prosthesis
         */
        TID10PM, 
        /**
         * Maxillary left canine abutment
         */
        TID11A, 
        /**
         * Maxillary left canine implant
         */
        TID11I, 
        /**
         * Maxillary left canine prosthesis
         */
        TID11P, 
        /**
         * Maxillary left canine distal prosthesis
         */
        TID11PD, 
        /**
         * Maxillary left canine mesial prosthesis
         */
        TID11PM, 
        /**
         * Maxillary left first premolar abutment
         */
        TID12A, 
        /**
         * Maxillary left first premolar implant
         */
        TID12I, 
        /**
         * Maxillary left first premolar prosthesis
         */
        TID12P, 
        /**
         * Maxillary left first premolar distal prosthesis
         */
        TID12PD, 
        /**
         * Maxillary left first premolar mesial prosthesis
         */
        TID12PM, 
        /**
         * Maxillary left second premolar abutment
         */
        TID13A, 
        /**
         * Maxillary left second premolar implant
         */
        TID13I, 
        /**
         * Maxillary left second premolar prosthesis
         */
        TID13P, 
        /**
         * Maxillary left second premolar distal prosthesis
         */
        TID13PD, 
        /**
         * Maxillary left second premolar mesial prosthesis
         */
        TID13PM, 
        /**
         * Maxillary left first molar abutment
         */
        TID14A, 
        /**
         * Maxillary left first molar implant
         */
        TID14I, 
        /**
         * Maxillary left first molar prosthesis
         */
        TID14P, 
        /**
         * Maxillary left first molar distal prosthesis
         */
        TID14PD, 
        /**
         * Maxillary left first molar mesial prosthesis
         */
        TID14PM, 
        /**
         * Maxillary left second molar abutment
         */
        TID15A, 
        /**
         * Maxillary left second molar implant
         */
        TID15I, 
        /**
         * Maxillary left second molar prosthesis
         */
        TID15P, 
        /**
         * Maxillary left second molar distal prosthesis
         */
        TID15PD, 
        /**
         * Maxillary left second molar mesial prosthesis
         */
        TID15PM, 
        /**
         * Maxillary left third molar abutment
         */
        TID16A, 
        /**
         * Maxillary left third molar implant
         */
        TID16I, 
        /**
         * Maxillary left third molar prosthesis
         */
        TID16P, 
        /**
         * Maxillary left third molar distal prosthesis
         */
        TID16PD, 
        /**
         * Maxillary left third molar mesial prosthesis
         */
        TID16PM, 
        /**
         * Mandibular left third molar abutment
         */
        TID17A, 
        /**
         * Mandibular left third molar abutment distal hemisection
         */
        TID17AD, 
        /**
         * Mandibular left third molar abutment mesial hemisection
         */
        TID17AM, 
        /**
         * Mandibular left third molar implant
         */
        TID17I, 
        /**
         * Mandibular left third molar implant distal hemisection
         */
        TID17ID, 
        /**
         * Mandibular left third molar implant mesial hemisection
         */
        TID17IM, 
        /**
         * Mandibular left third molar prosthesis
         */
        TID17P, 
        /**
         * Mandibular left third molar distal prosthesis
         */
        TID17PD, 
        /**
         * Mandibular left third molar mesial prosthesis
         */
        TID17PM, 
        /**
         * Mandibular left second molar abutment
         */
        TID18A, 
        /**
         * Mandibular left second molar abutment distal hemisection
         */
        TID18AD, 
        /**
         * Mandibular left second molar abutment mesial hemisection
         */
        TID18AM, 
        /**
         * Mandibular left second molar implant
         */
        TID18I, 
        /**
         * Mandibular left second molar implant distal hemisection
         */
        TID18ID, 
        /**
         * Mandibular left second molar implant mesial hemisection
         */
        TID18IM, 
        /**
         * Mandibular left second molar prosthesis
         */
        TID18P, 
        /**
         * Mandibular left second molar distal prosthesis
         */
        TID18PD, 
        /**
         * Mandibular left second molar mesial prosthesis
         */
        TID18PM, 
        /**
         * Mandibular left first molar abutment
         */
        TID19A, 
        /**
         * Mandibular left first molar abutment distal hemisection
         */
        TID19AD, 
        /**
         * Mandibular left first molar abutment mesial hemisection
         */
        TID19AM, 
        /**
         * Mandibular left first molar implant
         */
        TID19I, 
        /**
         * Mandibular left first molar implant distal hemisection
         */
        TID19ID, 
        /**
         * Mandibular left first molar implant mesial hemisection
         */
        TID19IM, 
        /**
         * Mandibular left first molar prosthesis
         */
        TID19P, 
        /**
         * Mandibular left first molar distal prosthesis
         */
        TID19PD, 
        /**
         * Mandibular left first molar mesial prosthesis
         */
        TID19PM, 
        /**
         * Maxillary right third molar abutment
         */
        TID1A, 
        /**
         * Maxillary right third molar implant
         */
        TID1I, 
        /**
         * Maxillary right third molar prosthesis
         */
        TID1P, 
        /**
         * Maxillary right third molar distal prosthesis
         */
        TID1PD, 
        /**
         * Maxillary right third molar mesial prosthesis
         */
        TID1PM, 
        /**
         * Mandibular left second premolar abutment
         */
        TID20A, 
        /**
         * Mandibular left second premolar implant
         */
        TID20I, 
        /**
         * Mandibular left second premolar prosthesis
         */
        TID20P, 
        /**
         * Mandibular left second premolar distal prosthesis
         */
        TID20PD, 
        /**
         * Mandibular left second premolar mesial prosthesis
         */
        TID20PM, 
        /**
         * Mandibular left first premolar abutment
         */
        TID21A, 
        /**
         * Mandibular left first premolar implant
         */
        TID21I, 
        /**
         * Mandibular left first premolar prosthesis
         */
        TID21P, 
        /**
         * Mandibular left first premolar distal prosthesis
         */
        TID21PD, 
        /**
         * Mandibular left first premolar mesial prosthesis
         */
        TID21PM, 
        /**
         * Mandibular left canine abutment
         */
        TID22A, 
        /**
         * Mandibular left canine implant
         */
        TID22I, 
        /**
         * Mandibular left canine prosthesis
         */
        TID22P, 
        /**
         * Mandibular left canine distal prosthesis
         */
        TID22PD, 
        /**
         * Mandibular left canine mesial prosthesis
         */
        TID22PM, 
        /**
         * Mandibular left lateral incisor abutment
         */
        TID23A, 
        /**
         * Mandibular left lateral incisor implant
         */
        TID23I, 
        /**
         * Mandibular left lateral incisor prosthesis
         */
        TID23P, 
        /**
         * Mandibular left lateral incisor distal prosthesis
         */
        TID23PD, 
        /**
         * Mandibular left lateral incisor mesial prosthesis
         */
        TID23PM, 
        /**
         * Mandibular left central incisor abutment
         */
        TID24A, 
        /**
         * Mandibular left central incisor implant
         */
        TID24I, 
        /**
         * Mandibular left central incisor prosthesis
         */
        TID24P, 
        /**
         * Mandibular left central incisor distal prosthesis
         */
        TID24PD, 
        /**
         * Mandibular left central incisor mesial prosthesis
         */
        TID24PM, 
        /**
         * Mandibular right central incisor abutment
         */
        TID25A, 
        /**
         * Mandibular right central incisor implant
         */
        TID25I, 
        /**
         * Mandibular right central incisor prosthesis
         */
        TID25P, 
        /**
         * Mandibular right central incisor distal prosthesis
         */
        TID25PD, 
        /**
         * Mandibular right central incisor mesial prosthesis
         */
        TID25PM, 
        /**
         * Mandibular right lateral incisor abutment
         */
        TID26A, 
        /**
         * Mandibular right lateral incisor implant
         */
        TID26I, 
        /**
         * Mandibular right lateral incisor prosthesis
         */
        TID26P, 
        /**
         * Mandibular right lateral incisor distal prosthesis
         */
        TID26PD, 
        /**
         * Mandibular right lateral incisor mesial prosthesis
         */
        TID26PM, 
        /**
         * Mandibular right canine abutment
         */
        TID27A, 
        /**
         * Mandibular right canine implant
         */
        TID27I, 
        /**
         * Mandibular right canine prosthesis
         */
        TID27P, 
        /**
         * Mandibular right canine distal prosthesis
         */
        TID27PD, 
        /**
         * Mandibular right canine mesial prosthesis
         */
        TID27PM, 
        /**
         * Mandibular right first premolar abutment
         */
        TID28A, 
        /**
         * Mandibular right first premolar implant
         */
        TID28I, 
        /**
         * Mandibular right first premolar prosthesis
         */
        TID28P, 
        /**
         * Mandibular right first premolar distal prosthesis
         */
        TID28PD, 
        /**
         * Mandibular right first premolar mesial prosthesis
         */
        TID28PM, 
        /**
         * Mandibular right second premolar abutment
         */
        TID29A, 
        /**
         * Mandibular right second premolar implant
         */
        TID29I, 
        /**
         * Mandibular right second premolar prosthesis
         */
        TID29P, 
        /**
         * Mandibular right second premolar distal prosthesis
         */
        TID29PD, 
        /**
         * Mandibular right second premolar mesial prosthesis
         */
        TID29PM, 
        /**
         * Maxillary right second molar abutment
         */
        TID2A, 
        /**
         * Maxillary right second molar implant
         */
        TID2I, 
        /**
         * Maxillary right second molar prosthesis
         */
        TID2P, 
        /**
         * Maxillary right second molar distal prosthesis
         */
        TID2PD, 
        /**
         * Maxillary right second molar mesial prosthesis
         */
        TID2PM, 
        /**
         * Mandibular right first molar abutment
         */
        TID30A, 
        /**
         * Mandibular right first molar abutment distal hemisection
         */
        TID30AD, 
        /**
         * Mandibular right first molar abutment mesial hemisection
         */
        TID30AM, 
        /**
         * Mandibular right first molar implant
         */
        TID30I, 
        /**
         * Mandibular right first molar implant distal hemisection
         */
        TID30ID, 
        /**
         * Mandibular right first molar implant mesial hemisection
         */
        TID30IM, 
        /**
         * Mandibular right first molar prosthesis
         */
        TID30P, 
        /**
         * Mandibular right first molar distal prosthesis
         */
        TID30PD, 
        /**
         * Mandibular right first molar mesial prosthesis
         */
        TID30PM, 
        /**
         * Mandibular right second molar abutment
         */
        TID31A, 
        /**
         * Mandibular right second molar abutment distal hemisection
         */
        TID31AD, 
        /**
         * Mandibular right second molar abutment mesial hemisection
         */
        TID31AM, 
        /**
         * Mandibular right second molar implant
         */
        TID31I, 
        /**
         * Mandibular right second molar implant distal hemisection
         */
        TID31ID, 
        /**
         * Mandibular right second molar implant mesial hemisection
         */
        TID31IM, 
        /**
         * Mandibular right second molar prosthesis
         */
        TID31P, 
        /**
         * Mandibular right second molar distal prosthesis
         */
        TID31PD, 
        /**
         * Mandibular right second molar mesial prosthesis
         */
        TID31PM, 
        /**
         * Mandibular right third molar abutment
         */
        TID32A, 
        /**
         * Mandibular right third molar abutment distal hemisection
         */
        TID32AD, 
        /**
         * Mandibular right third molar abutment mesial hemisection
         */
        TID32AM, 
        /**
         * Mandibular right third molar implant
         */
        TID32I, 
        /**
         * Mandibular right third molar implant distal hemisection
         */
        TID32ID, 
        /**
         * Mandibular right third molar implant mesial hemisection
         */
        TID32IM, 
        /**
         * Mandibular right third molar prosthesis
         */
        TID32P, 
        /**
         * Mandibular right third molar distal prosthesis
         */
        TID32PD, 
        /**
         * Mandibular right third molar mesial prosthesis
         */
        TID32PM, 
        /**
         * Maxillary right first molar abutment
         */
        TID3A, 
        /**
         * Maxillary right first molar implant
         */
        TID3I, 
        /**
         * Maxillary right first molar prosthesis
         */
        TID3P, 
        /**
         * Maxillary right first molar distal prosthesis
         */
        TID3PD, 
        /**
         * Maxillary right first molar mesial prosthesis
         */
        TID3PM, 
        /**
         * Maxillary right second premolar abutment
         */
        TID4A, 
        /**
         * Maxillary right second premolar implant
         */
        TID4I, 
        /**
         * Maxillary right second premolar prosthesis
         */
        TID4P, 
        /**
         * Maxillary right second premolar distal prosthesis
         */
        TID4PD, 
        /**
         * Maxillary right second premolar mesial prosthesis
         */
        TID4PM, 
        /**
         * Maxillary right first premolar abutment
         */
        TID5A, 
        /**
         * Maxillary right first premolar implant
         */
        TID5I, 
        /**
         * Maxillary right first premolar prosthesis
         */
        TID5P, 
        /**
         * Maxillary right first premolar distal prosthesis
         */
        TID5PD, 
        /**
         * Maxillary right first premolar mesial prosthesis
         */
        TID5PM, 
        /**
         * Maxillary right canine abutment
         */
        TID6A, 
        /**
         * Maxillary right canine implant
         */
        TID6I, 
        /**
         * Maxillary right canine prosthesis
         */
        TID6P, 
        /**
         * Maxillary right canine distal prosthesis
         */
        TID6PD, 
        /**
         * Maxillary right canine mesial prosthesis
         */
        TID6PM, 
        /**
         * Maxillary right lateral incisor abutment
         */
        TID7A, 
        /**
         * Maxillary right lateral incisor implant
         */
        TID7I, 
        /**
         * Maxillary right lateral incisor prosthesis
         */
        TID7P, 
        /**
         * Maxillary right lateral incisor distal prosthesis
         */
        TID7PD, 
        /**
         * Maxillary right lateral incisor mesial prosthesis
         */
        TID7PM, 
        /**
         * Maxillary right central incisor abutment
         */
        TID8A, 
        /**
         * Maxillary right central incisor implant
         */
        TID8I, 
        /**
         * Maxillary right central incisor prosthesis
         */
        TID8P, 
        /**
         * Maxillary right central incisor distal prosthesis
         */
        TID8PD, 
        /**
         * Maxillary right central incisor mesial prosthesis
         */
        TID8PM, 
        /**
         * Maxillary left central incisor abutment
         */
        TID9A, 
        /**
         * Maxillary left central incisor implant
         */
        TID9I, 
        /**
         * Maxillary left central incisor prosthesis
         */
        TID9P, 
        /**
         * Maxillary left central incisor distal prosthesis
         */
        TID9PD, 
        /**
         * Maxillary left central incisor mesial prosthesis
         */
        TID9PM, 
        /**
         * Permanent dentition, the natural teeth of adulthood that replace or are added to the deciduous teeth
         */
        PERMANENTDENTITION, 
        /**
         * Maxillary right third molar
         */
        TID1, 
        /**
         * Maxillary left lateral incisor
         */
        TID10, 
        /**
         * Maxillary left canine
         */
        TID11, 
        /**
         * Maxillary left first premolar
         */
        TID12, 
        /**
         * Maxillary left second premolar
         */
        TID13, 
        /**
         * Maxillary left first molar
         */
        TID14, 
        /**
         * Maxillary left second molar
         */
        TID15, 
        /**
         * Maxillary left third molar
         */
        TID16, 
        /**
         * Mandibular left third molar
         */
        TID17, 
        /**
         * Mandibular left third molar distal hemisection
         */
        TID17D, 
        /**
         * Mandibular left third molar mesial hemisection
         */
        TID17M, 
        /**
         * Mandibular left second molar
         */
        TID18, 
        /**
         * Mandibular left second molar distal hemisection
         */
        TID18D, 
        /**
         * Mandibular left second molar mesial hemisection
         */
        TID18M, 
        /**
         * Mandibular left first molar
         */
        TID19, 
        /**
         * Mandibular left first molar distal hemisection
         */
        TID19D, 
        /**
         * Mandibular left first molar mesial hemisection
         */
        TID19M, 
        /**
         * Maxillary right second molar
         */
        TID2, 
        /**
         * Mandibular left second premolar
         */
        TID20, 
        /**
         * Mandibular left first premolar
         */
        TID21, 
        /**
         * Mandibular left canine
         */
        TID22, 
        /**
         * Mandibular left lateral incisor
         */
        TID23, 
        /**
         * Mandibular left central incisor
         */
        TID24, 
        /**
         * Mandibular right central incisor
         */
        TID25, 
        /**
         * Mandibular right lateral incisor
         */
        TID26, 
        /**
         * Mandibular right canine
         */
        TID27, 
        /**
         * Mandibular right first premolar
         */
        TID28, 
        /**
         * Mandibular right second premolar
         */
        TID29, 
        /**
         * Maxillary right first molar
         */
        TID3, 
        /**
         * Mandibular right first molar
         */
        TID30, 
        /**
         * Mandibular right first molar distal hemisection
         */
        TID30D, 
        /**
         * Mandibular right first molar mesial hemisection
         */
        TID30M, 
        /**
         * Mandibular right second molar
         */
        TID31, 
        /**
         * Mandibular right second molar distal hemisection
         */
        TID31D, 
        /**
         * Mandibular right second molar mesial hemisection
         */
        TID31M, 
        /**
         * Mandibular right third molar
         */
        TID32, 
        /**
         * Mandibular right third molar distal hemisection
         */
        TID32D, 
        /**
         * Mandibular right third molar mesial hemisection
         */
        TID32M, 
        /**
         * Maxillary right second premolar
         */
        TID4, 
        /**
         * Maxillary right first premolar
         */
        TID5, 
        /**
         * Maxillary right canine
         */
        TID6, 
        /**
         * Maxillary right lateral incisor
         */
        TID7, 
        /**
         * Maxillary right central incisor
         */
        TID8, 
        /**
         * Maxillary left central incisor
         */
        TID9, 
        /**
         * Primary dentition, the first teeth to errupt and usually replaced with permanent dentition
         */
        PRIMARYDENTITION, 
        /**
         * Maxillary right second primary molar
         */
        TIDA, 
        /**
         * Maxillary right first primary molar
         */
        TIDB, 
        /**
         * Maxillary right primary canine
         */
        TIDC, 
        /**
         * Maxillary right lateral primary incisor
         */
        TIDD, 
        /**
         * Maxillary right central primary incisor
         */
        TIDE, 
        /**
         * Maxillary left central primary incisor
         */
        TIDF, 
        /**
         * Maxillary left lateral primary incisor
         */
        TIDG, 
        /**
         * Maxillary left primary canine
         */
        TIDH, 
        /**
         * Maxillary left first primary molar
         */
        TIDI, 
        /**
         * Maxillary left second primary molar
         */
        TIDJ, 
        /**
         * Mandibular left second primary molar
         */
        TIDK, 
        /**
         * Mandibular left first primary molar
         */
        TIDL, 
        /**
         * Mandibular left primary canine
         */
        TIDM, 
        /**
         * Mandibular left lateral primary incisor
         */
        TIDN, 
        /**
         * Mandibular left central primary incisor
         */
        TIDO, 
        /**
         * Mandibular right central primary incisor
         */
        TIDP, 
        /**
         * Mandibular right lateral primary incisor
         */
        TIDQ, 
        /**
         * Mandibular right primary canine
         */
        TIDR, 
        /**
         * Mandibular right first primary molar
         */
        TIDS, 
        /**
         * Mandibular right second primary molar
         */
        TIDT, 
        /**
         * Supernumerary tooth, any tooth in addition to the normal permanent and primary dentition
         */
        SUPERNUMERARYTOOTH, 
        /**
         * Supernumerary maxillary left lateral incisor
         */
        TID10S, 
        /**
         * Supernumerary maxillary left canine
         */
        TID11S, 
        /**
         * Supernumerary maxillary left first premolar
         */
        TID12S, 
        /**
         * Supernumerary maxillary left second premolar
         */
        TID13S, 
        /**
         * Supernumerary maxillary left first molar
         */
        TID14S, 
        /**
         * Supernumerary maxillary left second molar
         */
        TID15S, 
        /**
         * Supernumerary maxillary left third molar
         */
        TID16S, 
        /**
         * Supernumerary mandibular left third molar
         */
        TID17S, 
        /**
         * Supernumerary mandibular left second molar
         */
        TID18S, 
        /**
         * Supernumerary mandibular left first molar
         */
        TID19S, 
        /**
         * Supernumerary maxillary right third molar
         */
        TID1S, 
        /**
         * Supernumerary mandibular left second premolar
         */
        TID20S, 
        /**
         * Supernumerary mandibular left first premolar
         */
        TID21S, 
        /**
         * Supernumerary mandibular left canine
         */
        TID22S, 
        /**
         * Supernumerary mandibular left lateral incisor
         */
        TID23S, 
        /**
         * Supernumerary mandibular left central incisor
         */
        TID24S, 
        /**
         * Supernumerary mandibular right central incisor
         */
        TID25S, 
        /**
         * Supernumerary mandibular right lateral incisor
         */
        TID26S, 
        /**
         * Supernumerary mandibular right canine
         */
        TID27S, 
        /**
         * Supernumerary mandibular right first premolar
         */
        TID28S, 
        /**
         * Supernumerary mandibular right second premolar
         */
        TID29S, 
        /**
         * Supernumerary maxillary right second molar
         */
        TID2S, 
        /**
         * Supernumerary mandibular right first molar
         */
        TID30S, 
        /**
         * Supernumerary mandibular right second molar
         */
        TID31S, 
        /**
         * Supernumerary mandibular right third molar
         */
        TID32S, 
        /**
         * Supernumerary maxillary right first molar
         */
        TID3S, 
        /**
         * Supernumerary maxillary right second premolar
         */
        TID4S, 
        /**
         * Supernumerary maxillary right first premolar
         */
        TID5S, 
        /**
         * Supernumerary maxillary right canine
         */
        TID6S, 
        /**
         * Supernumerary maxillary right lateral incisor
         */
        TID7S, 
        /**
         * Supernumerary maxillary right central incisor
         */
        TID8S, 
        /**
         * Supernumerary maxillary left central incisor
         */
        TID9S, 
        /**
         * Supernumerary maxillary right second primary molar
         */
        TIDAS, 
        /**
         * Supernumerary maxillary right first primary molar
         */
        TIDBS, 
        /**
         * Supernumerary maxillary right primary canine
         */
        TIDCS, 
        /**
         * Supernumerary maxillary right lateral primary incisor
         */
        TIDDS, 
        /**
         * Supernumerary maxillary right central primary incisor
         */
        TIDES, 
        /**
         * Supernumerary maxillary left central primary incisor
         */
        TIDFS, 
        /**
         * Supernumerary maxillary left lateral primary incisor
         */
        TIDGS, 
        /**
         * Supernumerary maxillary left primary canine
         */
        TIDHS, 
        /**
         * Supernumerary maxillary left first primary molar
         */
        TIDIS, 
        /**
         * Supernumerary maxillary left second primary molar
         */
        TIDJS, 
        /**
         * Supernumerary mandibular left second primary molar
         */
        TIDKS, 
        /**
         * Supernumerary mandibular left first primary molar
         */
        TIDLS, 
        /**
         * Supernumerary mandibular left primary canine
         */
        TIDMS, 
        /**
         * Supernumerary mandibular left lateral primary incisor
         */
        TIDNS, 
        /**
         * Supernumerary mandibular left central primary incisor
         */
        TIDOS, 
        /**
         * Supernumerary mandibular right central primary incisor
         */
        TIDPS, 
        /**
         * Supernumerary mandibular right lateral primary incisor
         */
        TIDQS, 
        /**
         * Supernumerary mandibular right primary canine
         */
        TIDRS, 
        /**
         * Supernumerary mandibular right first primary molar
         */
        TIDSS, 
        /**
         * Supernumerary mandibular right second primary molar
         */
        TIDTS, 
        /**
         * added to help the parsers
         */
        NULL;
        public static V3Dentition fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString))
                return null;
        if ("ArtificialDentition".equals(codeString))
          return ARTIFICIALDENTITION;
        if ("TID10a".equals(codeString))
          return TID10A;
        if ("TID10i".equals(codeString))
          return TID10I;
        if ("TID10p".equals(codeString))
          return TID10P;
        if ("TID10pd".equals(codeString))
          return TID10PD;
        if ("TID10pm".equals(codeString))
          return TID10PM;
        if ("TID11a".equals(codeString))
          return TID11A;
        if ("TID11i".equals(codeString))
          return TID11I;
        if ("TID11p".equals(codeString))
          return TID11P;
        if ("TID11pd".equals(codeString))
          return TID11PD;
        if ("TID11pm".equals(codeString))
          return TID11PM;
        if ("TID12a".equals(codeString))
          return TID12A;
        if ("TID12i".equals(codeString))
          return TID12I;
        if ("TID12p".equals(codeString))
          return TID12P;
        if ("TID12pd".equals(codeString))
          return TID12PD;
        if ("TID12pm".equals(codeString))
          return TID12PM;
        if ("TID13a".equals(codeString))
          return TID13A;
        if ("TID13i".equals(codeString))
          return TID13I;
        if ("TID13p".equals(codeString))
          return TID13P;
        if ("TID13pd".equals(codeString))
          return TID13PD;
        if ("TID13pm".equals(codeString))
          return TID13PM;
        if ("TID14a".equals(codeString))
          return TID14A;
        if ("TID14i".equals(codeString))
          return TID14I;
        if ("TID14p".equals(codeString))
          return TID14P;
        if ("TID14pd".equals(codeString))
          return TID14PD;
        if ("TID14pm".equals(codeString))
          return TID14PM;
        if ("TID15a".equals(codeString))
          return TID15A;
        if ("TID15i".equals(codeString))
          return TID15I;
        if ("TID15p".equals(codeString))
          return TID15P;
        if ("TID15pd".equals(codeString))
          return TID15PD;
        if ("TID15pm".equals(codeString))
          return TID15PM;
        if ("TID16a".equals(codeString))
          return TID16A;
        if ("TID16i".equals(codeString))
          return TID16I;
        if ("TID16p".equals(codeString))
          return TID16P;
        if ("TID16pd".equals(codeString))
          return TID16PD;
        if ("TID16pm".equals(codeString))
          return TID16PM;
        if ("TID17a".equals(codeString))
          return TID17A;
        if ("TID17ad".equals(codeString))
          return TID17AD;
        if ("TID17am".equals(codeString))
          return TID17AM;
        if ("TID17i".equals(codeString))
          return TID17I;
        if ("TID17id".equals(codeString))
          return TID17ID;
        if ("TID17im".equals(codeString))
          return TID17IM;
        if ("TID17p".equals(codeString))
          return TID17P;
        if ("TID17pd".equals(codeString))
          return TID17PD;
        if ("TID17pm".equals(codeString))
          return TID17PM;
        if ("TID18a".equals(codeString))
          return TID18A;
        if ("TID18ad".equals(codeString))
          return TID18AD;
        if ("TID18am".equals(codeString))
          return TID18AM;
        if ("TID18i".equals(codeString))
          return TID18I;
        if ("TID18id".equals(codeString))
          return TID18ID;
        if ("TID18im".equals(codeString))
          return TID18IM;
        if ("TID18p".equals(codeString))
          return TID18P;
        if ("TID18pd".equals(codeString))
          return TID18PD;
        if ("TID18pm".equals(codeString))
          return TID18PM;
        if ("TID19a".equals(codeString))
          return TID19A;
        if ("TID19ad".equals(codeString))
          return TID19AD;
        if ("TID19am".equals(codeString))
          return TID19AM;
        if ("TID19i".equals(codeString))
          return TID19I;
        if ("TID19id".equals(codeString))
          return TID19ID;
        if ("TID19im".equals(codeString))
          return TID19IM;
        if ("TID19p".equals(codeString))
          return TID19P;
        if ("TID19pd".equals(codeString))
          return TID19PD;
        if ("TID19pm".equals(codeString))
          return TID19PM;
        if ("TID1a".equals(codeString))
          return TID1A;
        if ("TID1i".equals(codeString))
          return TID1I;
        if ("TID1p".equals(codeString))
          return TID1P;
        if ("TID1pd".equals(codeString))
          return TID1PD;
        if ("TID1pm".equals(codeString))
          return TID1PM;
        if ("TID20a".equals(codeString))
          return TID20A;
        if ("TID20i".equals(codeString))
          return TID20I;
        if ("TID20p".equals(codeString))
          return TID20P;
        if ("TID20pd".equals(codeString))
          return TID20PD;
        if ("TID20pm".equals(codeString))
          return TID20PM;
        if ("TID21a".equals(codeString))
          return TID21A;
        if ("TID21i".equals(codeString))
          return TID21I;
        if ("TID21p".equals(codeString))
          return TID21P;
        if ("TID21pd".equals(codeString))
          return TID21PD;
        if ("TID21pm".equals(codeString))
          return TID21PM;
        if ("TID22a".equals(codeString))
          return TID22A;
        if ("TID22i".equals(codeString))
          return TID22I;
        if ("TID22p".equals(codeString))
          return TID22P;
        if ("TID22pd".equals(codeString))
          return TID22PD;
        if ("TID22pm".equals(codeString))
          return TID22PM;
        if ("TID23a".equals(codeString))
          return TID23A;
        if ("TID23i".equals(codeString))
          return TID23I;
        if ("TID23p".equals(codeString))
          return TID23P;
        if ("TID23pd".equals(codeString))
          return TID23PD;
        if ("TID23pm".equals(codeString))
          return TID23PM;
        if ("TID24a".equals(codeString))
          return TID24A;
        if ("TID24i".equals(codeString))
          return TID24I;
        if ("TID24p".equals(codeString))
          return TID24P;
        if ("TID24pd".equals(codeString))
          return TID24PD;
        if ("TID24pm".equals(codeString))
          return TID24PM;
        if ("TID25a".equals(codeString))
          return TID25A;
        if ("TID25i".equals(codeString))
          return TID25I;
        if ("TID25p".equals(codeString))
          return TID25P;
        if ("TID25pd".equals(codeString))
          return TID25PD;
        if ("TID25pm".equals(codeString))
          return TID25PM;
        if ("TID26a".equals(codeString))
          return TID26A;
        if ("TID26i".equals(codeString))
          return TID26I;
        if ("TID26p".equals(codeString))
          return TID26P;
        if ("TID26pd".equals(codeString))
          return TID26PD;
        if ("TID26pm".equals(codeString))
          return TID26PM;
        if ("TID27a".equals(codeString))
          return TID27A;
        if ("TID27i".equals(codeString))
          return TID27I;
        if ("TID27p".equals(codeString))
          return TID27P;
        if ("TID27pd".equals(codeString))
          return TID27PD;
        if ("TID27pm".equals(codeString))
          return TID27PM;
        if ("TID28a".equals(codeString))
          return TID28A;
        if ("TID28i".equals(codeString))
          return TID28I;
        if ("TID28p".equals(codeString))
          return TID28P;
        if ("TID28pd".equals(codeString))
          return TID28PD;
        if ("TID28pm".equals(codeString))
          return TID28PM;
        if ("TID29a".equals(codeString))
          return TID29A;
        if ("TID29i".equals(codeString))
          return TID29I;
        if ("TID29p".equals(codeString))
          return TID29P;
        if ("TID29pd".equals(codeString))
          return TID29PD;
        if ("TID29pm".equals(codeString))
          return TID29PM;
        if ("TID2a".equals(codeString))
          return TID2A;
        if ("TID2i".equals(codeString))
          return TID2I;
        if ("TID2p".equals(codeString))
          return TID2P;
        if ("TID2pd".equals(codeString))
          return TID2PD;
        if ("TID2pm".equals(codeString))
          return TID2PM;
        if ("TID30a".equals(codeString))
          return TID30A;
        if ("TID30ad".equals(codeString))
          return TID30AD;
        if ("TID30am".equals(codeString))
          return TID30AM;
        if ("TID30i".equals(codeString))
          return TID30I;
        if ("TID30id".equals(codeString))
          return TID30ID;
        if ("TID30im".equals(codeString))
          return TID30IM;
        if ("TID30p".equals(codeString))
          return TID30P;
        if ("TID30pd".equals(codeString))
          return TID30PD;
        if ("TID30pm".equals(codeString))
          return TID30PM;
        if ("TID31a".equals(codeString))
          return TID31A;
        if ("TID31ad".equals(codeString))
          return TID31AD;
        if ("TID31am".equals(codeString))
          return TID31AM;
        if ("TID31i".equals(codeString))
          return TID31I;
        if ("TID31id".equals(codeString))
          return TID31ID;
        if ("TID31im".equals(codeString))
          return TID31IM;
        if ("TID31p".equals(codeString))
          return TID31P;
        if ("TID31pd".equals(codeString))
          return TID31PD;
        if ("TID31pm".equals(codeString))
          return TID31PM;
        if ("TID32a".equals(codeString))
          return TID32A;
        if ("TID32ad".equals(codeString))
          return TID32AD;
        if ("TID32am".equals(codeString))
          return TID32AM;
        if ("TID32i".equals(codeString))
          return TID32I;
        if ("TID32id".equals(codeString))
          return TID32ID;
        if ("TID32im".equals(codeString))
          return TID32IM;
        if ("TID32p".equals(codeString))
          return TID32P;
        if ("TID32pd".equals(codeString))
          return TID32PD;
        if ("TID32pm".equals(codeString))
          return TID32PM;
        if ("TID3a".equals(codeString))
          return TID3A;
        if ("TID3i".equals(codeString))
          return TID3I;
        if ("TID3p".equals(codeString))
          return TID3P;
        if ("TID3pd".equals(codeString))
          return TID3PD;
        if ("TID3pm".equals(codeString))
          return TID3PM;
        if ("TID4a".equals(codeString))
          return TID4A;
        if ("TID4i".equals(codeString))
          return TID4I;
        if ("TID4p".equals(codeString))
          return TID4P;
        if ("TID4pd".equals(codeString))
          return TID4PD;
        if ("TID4pm".equals(codeString))
          return TID4PM;
        if ("TID5a".equals(codeString))
          return TID5A;
        if ("TID5i".equals(codeString))
          return TID5I;
        if ("TID5p".equals(codeString))
          return TID5P;
        if ("TID5pd".equals(codeString))
          return TID5PD;
        if ("TID5pm".equals(codeString))
          return TID5PM;
        if ("TID6a".equals(codeString))
          return TID6A;
        if ("TID6i".equals(codeString))
          return TID6I;
        if ("TID6p".equals(codeString))
          return TID6P;
        if ("TID6pd".equals(codeString))
          return TID6PD;
        if ("TID6pm".equals(codeString))
          return TID6PM;
        if ("TID7a".equals(codeString))
          return TID7A;
        if ("TID7i".equals(codeString))
          return TID7I;
        if ("TID7p".equals(codeString))
          return TID7P;
        if ("TID7pd".equals(codeString))
          return TID7PD;
        if ("TID7pm".equals(codeString))
          return TID7PM;
        if ("TID8a".equals(codeString))
          return TID8A;
        if ("TID8i".equals(codeString))
          return TID8I;
        if ("TID8p".equals(codeString))
          return TID8P;
        if ("TID8pd".equals(codeString))
          return TID8PD;
        if ("TID8pm".equals(codeString))
          return TID8PM;
        if ("TID9a".equals(codeString))
          return TID9A;
        if ("TID9i".equals(codeString))
          return TID9I;
        if ("TID9p".equals(codeString))
          return TID9P;
        if ("TID9pd".equals(codeString))
          return TID9PD;
        if ("TID9pm".equals(codeString))
          return TID9PM;
        if ("PermanentDentition".equals(codeString))
          return PERMANENTDENTITION;
        if ("TID1".equals(codeString))
          return TID1;
        if ("TID10".equals(codeString))
          return TID10;
        if ("TID11".equals(codeString))
          return TID11;
        if ("TID12".equals(codeString))
          return TID12;
        if ("TID13".equals(codeString))
          return TID13;
        if ("TID14".equals(codeString))
          return TID14;
        if ("TID15".equals(codeString))
          return TID15;
        if ("TID16".equals(codeString))
          return TID16;
        if ("TID17".equals(codeString))
          return TID17;
        if ("TID17d".equals(codeString))
          return TID17D;
        if ("TID17m".equals(codeString))
          return TID17M;
        if ("TID18".equals(codeString))
          return TID18;
        if ("TID18d".equals(codeString))
          return TID18D;
        if ("TID18m".equals(codeString))
          return TID18M;
        if ("TID19".equals(codeString))
          return TID19;
        if ("TID19d".equals(codeString))
          return TID19D;
        if ("TID19m".equals(codeString))
          return TID19M;
        if ("TID2".equals(codeString))
          return TID2;
        if ("TID20".equals(codeString))
          return TID20;
        if ("TID21".equals(codeString))
          return TID21;
        if ("TID22".equals(codeString))
          return TID22;
        if ("TID23".equals(codeString))
          return TID23;
        if ("TID24".equals(codeString))
          return TID24;
        if ("TID25".equals(codeString))
          return TID25;
        if ("TID26".equals(codeString))
          return TID26;
        if ("TID27".equals(codeString))
          return TID27;
        if ("TID28".equals(codeString))
          return TID28;
        if ("TID29".equals(codeString))
          return TID29;
        if ("TID3".equals(codeString))
          return TID3;
        if ("TID30".equals(codeString))
          return TID30;
        if ("TID30d".equals(codeString))
          return TID30D;
        if ("TID30m".equals(codeString))
          return TID30M;
        if ("TID31".equals(codeString))
          return TID31;
        if ("TID31d".equals(codeString))
          return TID31D;
        if ("TID31m".equals(codeString))
          return TID31M;
        if ("TID32".equals(codeString))
          return TID32;
        if ("TID32d".equals(codeString))
          return TID32D;
        if ("TID32m".equals(codeString))
          return TID32M;
        if ("TID4".equals(codeString))
          return TID4;
        if ("TID5".equals(codeString))
          return TID5;
        if ("TID6".equals(codeString))
          return TID6;
        if ("TID7".equals(codeString))
          return TID7;
        if ("TID8".equals(codeString))
          return TID8;
        if ("TID9".equals(codeString))
          return TID9;
        if ("PrimaryDentition".equals(codeString))
          return PRIMARYDENTITION;
        if ("TIDA".equals(codeString))
          return TIDA;
        if ("TIDB".equals(codeString))
          return TIDB;
        if ("TIDC".equals(codeString))
          return TIDC;
        if ("TIDD".equals(codeString))
          return TIDD;
        if ("TIDE".equals(codeString))
          return TIDE;
        if ("TIDF".equals(codeString))
          return TIDF;
        if ("TIDG".equals(codeString))
          return TIDG;
        if ("TIDH".equals(codeString))
          return TIDH;
        if ("TIDI".equals(codeString))
          return TIDI;
        if ("TIDJ".equals(codeString))
          return TIDJ;
        if ("TIDK".equals(codeString))
          return TIDK;
        if ("TIDL".equals(codeString))
          return TIDL;
        if ("TIDM".equals(codeString))
          return TIDM;
        if ("TIDN".equals(codeString))
          return TIDN;
        if ("TIDO".equals(codeString))
          return TIDO;
        if ("TIDP".equals(codeString))
          return TIDP;
        if ("TIDQ".equals(codeString))
          return TIDQ;
        if ("TIDR".equals(codeString))
          return TIDR;
        if ("TIDS".equals(codeString))
          return TIDS;
        if ("TIDT".equals(codeString))
          return TIDT;
        if ("SupernumeraryTooth".equals(codeString))
          return SUPERNUMERARYTOOTH;
        if ("TID10s".equals(codeString))
          return TID10S;
        if ("TID11s".equals(codeString))
          return TID11S;
        if ("TID12s".equals(codeString))
          return TID12S;
        if ("TID13s".equals(codeString))
          return TID13S;
        if ("TID14s".equals(codeString))
          return TID14S;
        if ("TID15s".equals(codeString))
          return TID15S;
        if ("TID16s".equals(codeString))
          return TID16S;
        if ("TID17s".equals(codeString))
          return TID17S;
        if ("TID18s".equals(codeString))
          return TID18S;
        if ("TID19s".equals(codeString))
          return TID19S;
        if ("TID1s".equals(codeString))
          return TID1S;
        if ("TID20s".equals(codeString))
          return TID20S;
        if ("TID21s".equals(codeString))
          return TID21S;
        if ("TID22s".equals(codeString))
          return TID22S;
        if ("TID23s".equals(codeString))
          return TID23S;
        if ("TID24s".equals(codeString))
          return TID24S;
        if ("TID25s".equals(codeString))
          return TID25S;
        if ("TID26s".equals(codeString))
          return TID26S;
        if ("TID27s".equals(codeString))
          return TID27S;
        if ("TID28s".equals(codeString))
          return TID28S;
        if ("TID29s".equals(codeString))
          return TID29S;
        if ("TID2s".equals(codeString))
          return TID2S;
        if ("TID30s".equals(codeString))
          return TID30S;
        if ("TID31s".equals(codeString))
          return TID31S;
        if ("TID32s".equals(codeString))
          return TID32S;
        if ("TID3s".equals(codeString))
          return TID3S;
        if ("TID4s".equals(codeString))
          return TID4S;
        if ("TID5s".equals(codeString))
          return TID5S;
        if ("TID6s".equals(codeString))
          return TID6S;
        if ("TID7s".equals(codeString))
          return TID7S;
        if ("TID8s".equals(codeString))
          return TID8S;
        if ("TID9s".equals(codeString))
          return TID9S;
        if ("TIDAs".equals(codeString))
          return TIDAS;
        if ("TIDBs".equals(codeString))
          return TIDBS;
        if ("TIDCs".equals(codeString))
          return TIDCS;
        if ("TIDDs".equals(codeString))
          return TIDDS;
        if ("TIDEs".equals(codeString))
          return TIDES;
        if ("TIDFs".equals(codeString))
          return TIDFS;
        if ("TIDGs".equals(codeString))
          return TIDGS;
        if ("TIDHs".equals(codeString))
          return TIDHS;
        if ("TIDIs".equals(codeString))
          return TIDIS;
        if ("TIDJs".equals(codeString))
          return TIDJS;
        if ("TIDKs".equals(codeString))
          return TIDKS;
        if ("TIDLs".equals(codeString))
          return TIDLS;
        if ("TIDMs".equals(codeString))
          return TIDMS;
        if ("TIDNs".equals(codeString))
          return TIDNS;
        if ("TIDOs".equals(codeString))
          return TIDOS;
        if ("TIDPs".equals(codeString))
          return TIDPS;
        if ("TIDQs".equals(codeString))
          return TIDQS;
        if ("TIDRs".equals(codeString))
          return TIDRS;
        if ("TIDSs".equals(codeString))
          return TIDSS;
        if ("TIDTs".equals(codeString))
          return TIDTS;
        throw new FHIRException("Unknown V3Dentition code '"+codeString+"'");
        }
        public String toCode() {
          switch (this) {
            case ARTIFICIALDENTITION: return "ArtificialDentition";
            case TID10A: return "TID10a";
            case TID10I: return "TID10i";
            case TID10P: return "TID10p";
            case TID10PD: return "TID10pd";
            case TID10PM: return "TID10pm";
            case TID11A: return "TID11a";
            case TID11I: return "TID11i";
            case TID11P: return "TID11p";
            case TID11PD: return "TID11pd";
            case TID11PM: return "TID11pm";
            case TID12A: return "TID12a";
            case TID12I: return "TID12i";
            case TID12P: return "TID12p";
            case TID12PD: return "TID12pd";
            case TID12PM: return "TID12pm";
            case TID13A: return "TID13a";
            case TID13I: return "TID13i";
            case TID13P: return "TID13p";
            case TID13PD: return "TID13pd";
            case TID13PM: return "TID13pm";
            case TID14A: return "TID14a";
            case TID14I: return "TID14i";
            case TID14P: return "TID14p";
            case TID14PD: return "TID14pd";
            case TID14PM: return "TID14pm";
            case TID15A: return "TID15a";
            case TID15I: return "TID15i";
            case TID15P: return "TID15p";
            case TID15PD: return "TID15pd";
            case TID15PM: return "TID15pm";
            case TID16A: return "TID16a";
            case TID16I: return "TID16i";
            case TID16P: return "TID16p";
            case TID16PD: return "TID16pd";
            case TID16PM: return "TID16pm";
            case TID17A: return "TID17a";
            case TID17AD: return "TID17ad";
            case TID17AM: return "TID17am";
            case TID17I: return "TID17i";
            case TID17ID: return "TID17id";
            case TID17IM: return "TID17im";
            case TID17P: return "TID17p";
            case TID17PD: return "TID17pd";
            case TID17PM: return "TID17pm";
            case TID18A: return "TID18a";
            case TID18AD: return "TID18ad";
            case TID18AM: return "TID18am";
            case TID18I: return "TID18i";
            case TID18ID: return "TID18id";
            case TID18IM: return "TID18im";
            case TID18P: return "TID18p";
            case TID18PD: return "TID18pd";
            case TID18PM: return "TID18pm";
            case TID19A: return "TID19a";
            case TID19AD: return "TID19ad";
            case TID19AM: return "TID19am";
            case TID19I: return "TID19i";
            case TID19ID: return "TID19id";
            case TID19IM: return "TID19im";
            case TID19P: return "TID19p";
            case TID19PD: return "TID19pd";
            case TID19PM: return "TID19pm";
            case TID1A: return "TID1a";
            case TID1I: return "TID1i";
            case TID1P: return "TID1p";
            case TID1PD: return "TID1pd";
            case TID1PM: return "TID1pm";
            case TID20A: return "TID20a";
            case TID20I: return "TID20i";
            case TID20P: return "TID20p";
            case TID20PD: return "TID20pd";
            case TID20PM: return "TID20pm";
            case TID21A: return "TID21a";
            case TID21I: return "TID21i";
            case TID21P: return "TID21p";
            case TID21PD: return "TID21pd";
            case TID21PM: return "TID21pm";
            case TID22A: return "TID22a";
            case TID22I: return "TID22i";
            case TID22P: return "TID22p";
            case TID22PD: return "TID22pd";
            case TID22PM: return "TID22pm";
            case TID23A: return "TID23a";
            case TID23I: return "TID23i";
            case TID23P: return "TID23p";
            case TID23PD: return "TID23pd";
            case TID23PM: return "TID23pm";
            case TID24A: return "TID24a";
            case TID24I: return "TID24i";
            case TID24P: return "TID24p";
            case TID24PD: return "TID24pd";
            case TID24PM: return "TID24pm";
            case TID25A: return "TID25a";
            case TID25I: return "TID25i";
            case TID25P: return "TID25p";
            case TID25PD: return "TID25pd";
            case TID25PM: return "TID25pm";
            case TID26A: return "TID26a";
            case TID26I: return "TID26i";
            case TID26P: return "TID26p";
            case TID26PD: return "TID26pd";
            case TID26PM: return "TID26pm";
            case TID27A: return "TID27a";
            case TID27I: return "TID27i";
            case TID27P: return "TID27p";
            case TID27PD: return "TID27pd";
            case TID27PM: return "TID27pm";
            case TID28A: return "TID28a";
            case TID28I: return "TID28i";
            case TID28P: return "TID28p";
            case TID28PD: return "TID28pd";
            case TID28PM: return "TID28pm";
            case TID29A: return "TID29a";
            case TID29I: return "TID29i";
            case TID29P: return "TID29p";
            case TID29PD: return "TID29pd";
            case TID29PM: return "TID29pm";
            case TID2A: return "TID2a";
            case TID2I: return "TID2i";
            case TID2P: return "TID2p";
            case TID2PD: return "TID2pd";
            case TID2PM: return "TID2pm";
            case TID30A: return "TID30a";
            case TID30AD: return "TID30ad";
            case TID30AM: return "TID30am";
            case TID30I: return "TID30i";
            case TID30ID: return "TID30id";
            case TID30IM: return "TID30im";
            case TID30P: return "TID30p";
            case TID30PD: return "TID30pd";
            case TID30PM: return "TID30pm";
            case TID31A: return "TID31a";
            case TID31AD: return "TID31ad";
            case TID31AM: return "TID31am";
            case TID31I: return "TID31i";
            case TID31ID: return "TID31id";
            case TID31IM: return "TID31im";
            case TID31P: return "TID31p";
            case TID31PD: return "TID31pd";
            case TID31PM: return "TID31pm";
            case TID32A: return "TID32a";
            case TID32AD: return "TID32ad";
            case TID32AM: return "TID32am";
            case TID32I: return "TID32i";
            case TID32ID: return "TID32id";
            case TID32IM: return "TID32im";
            case TID32P: return "TID32p";
            case TID32PD: return "TID32pd";
            case TID32PM: return "TID32pm";
            case TID3A: return "TID3a";
            case TID3I: return "TID3i";
            case TID3P: return "TID3p";
            case TID3PD: return "TID3pd";
            case TID3PM: return "TID3pm";
            case TID4A: return "TID4a";
            case TID4I: return "TID4i";
            case TID4P: return "TID4p";
            case TID4PD: return "TID4pd";
            case TID4PM: return "TID4pm";
            case TID5A: return "TID5a";
            case TID5I: return "TID5i";
            case TID5P: return "TID5p";
            case TID5PD: return "TID5pd";
            case TID5PM: return "TID5pm";
            case TID6A: return "TID6a";
            case TID6I: return "TID6i";
            case TID6P: return "TID6p";
            case TID6PD: return "TID6pd";
            case TID6PM: return "TID6pm";
            case TID7A: return "TID7a";
            case TID7I: return "TID7i";
            case TID7P: return "TID7p";
            case TID7PD: return "TID7pd";
            case TID7PM: return "TID7pm";
            case TID8A: return "TID8a";
            case TID8I: return "TID8i";
            case TID8P: return "TID8p";
            case TID8PD: return "TID8pd";
            case TID8PM: return "TID8pm";
            case TID9A: return "TID9a";
            case TID9I: return "TID9i";
            case TID9P: return "TID9p";
            case TID9PD: return "TID9pd";
            case TID9PM: return "TID9pm";
            case PERMANENTDENTITION: return "PermanentDentition";
            case TID1: return "TID1";
            case TID10: return "TID10";
            case TID11: return "TID11";
            case TID12: return "TID12";
            case TID13: return "TID13";
            case TID14: return "TID14";
            case TID15: return "TID15";
            case TID16: return "TID16";
            case TID17: return "TID17";
            case TID17D: return "TID17d";
            case TID17M: return "TID17m";
            case TID18: return "TID18";
            case TID18D: return "TID18d";
            case TID18M: return "TID18m";
            case TID19: return "TID19";
            case TID19D: return "TID19d";
            case TID19M: return "TID19m";
            case TID2: return "TID2";
            case TID20: return "TID20";
            case TID21: return "TID21";
            case TID22: return "TID22";
            case TID23: return "TID23";
            case TID24: return "TID24";
            case TID25: return "TID25";
            case TID26: return "TID26";
            case TID27: return "TID27";
            case TID28: return "TID28";
            case TID29: return "TID29";
            case TID3: return "TID3";
            case TID30: return "TID30";
            case TID30D: return "TID30d";
            case TID30M: return "TID30m";
            case TID31: return "TID31";
            case TID31D: return "TID31d";
            case TID31M: return "TID31m";
            case TID32: return "TID32";
            case TID32D: return "TID32d";
            case TID32M: return "TID32m";
            case TID4: return "TID4";
            case TID5: return "TID5";
            case TID6: return "TID6";
            case TID7: return "TID7";
            case TID8: return "TID8";
            case TID9: return "TID9";
            case PRIMARYDENTITION: return "PrimaryDentition";
            case TIDA: return "TIDA";
            case TIDB: return "TIDB";
            case TIDC: return "TIDC";
            case TIDD: return "TIDD";
            case TIDE: return "TIDE";
            case TIDF: return "TIDF";
            case TIDG: return "TIDG";
            case TIDH: return "TIDH";
            case TIDI: return "TIDI";
            case TIDJ: return "TIDJ";
            case TIDK: return "TIDK";
            case TIDL: return "TIDL";
            case TIDM: return "TIDM";
            case TIDN: return "TIDN";
            case TIDO: return "TIDO";
            case TIDP: return "TIDP";
            case TIDQ: return "TIDQ";
            case TIDR: return "TIDR";
            case TIDS: return "TIDS";
            case TIDT: return "TIDT";
            case SUPERNUMERARYTOOTH: return "SupernumeraryTooth";
            case TID10S: return "TID10s";
            case TID11S: return "TID11s";
            case TID12S: return "TID12s";
            case TID13S: return "TID13s";
            case TID14S: return "TID14s";
            case TID15S: return "TID15s";
            case TID16S: return "TID16s";
            case TID17S: return "TID17s";
            case TID18S: return "TID18s";
            case TID19S: return "TID19s";
            case TID1S: return "TID1s";
            case TID20S: return "TID20s";
            case TID21S: return "TID21s";
            case TID22S: return "TID22s";
            case TID23S: return "TID23s";
            case TID24S: return "TID24s";
            case TID25S: return "TID25s";
            case TID26S: return "TID26s";
            case TID27S: return "TID27s";
            case TID28S: return "TID28s";
            case TID29S: return "TID29s";
            case TID2S: return "TID2s";
            case TID30S: return "TID30s";
            case TID31S: return "TID31s";
            case TID32S: return "TID32s";
            case TID3S: return "TID3s";
            case TID4S: return "TID4s";
            case TID5S: return "TID5s";
            case TID6S: return "TID6s";
            case TID7S: return "TID7s";
            case TID8S: return "TID8s";
            case TID9S: return "TID9s";
            case TIDAS: return "TIDAs";
            case TIDBS: return "TIDBs";
            case TIDCS: return "TIDCs";
            case TIDDS: return "TIDDs";
            case TIDES: return "TIDEs";
            case TIDFS: return "TIDFs";
            case TIDGS: return "TIDGs";
            case TIDHS: return "TIDHs";
            case TIDIS: return "TIDIs";
            case TIDJS: return "TIDJs";
            case TIDKS: return "TIDKs";
            case TIDLS: return "TIDLs";
            case TIDMS: return "TIDMs";
            case TIDNS: return "TIDNs";
            case TIDOS: return "TIDOs";
            case TIDPS: return "TIDPs";
            case TIDQS: return "TIDQs";
            case TIDRS: return "TIDRs";
            case TIDSS: return "TIDSs";
            case TIDTS: return "TIDTs";
            default: return "?";
          }
        }
        public String getSystem() {
          return "http://terminology.hl7.org/CodeSystem/v3-Dentition";
        }
        public String getDefinition() {
          switch (this) {
            case ARTIFICIALDENTITION: return "Artificial dentition, artificial subsitutes for the natural dentition";
            case TID10A: return "Maxillary left lateral incisor abutment";
            case TID10I: return "Maxillary left lateral incisor implant";
            case TID10P: return "Maxillary left lateral incisor prosthesis";
            case TID10PD: return "Maxillary left lateral incisor distal prosthesis";
            case TID10PM: return "Maxillary left lateral incisor mesial prosthesis";
            case TID11A: return "Maxillary left canine abutment";
            case TID11I: return "Maxillary left canine implant";
            case TID11P: return "Maxillary left canine prosthesis";
            case TID11PD: return "Maxillary left canine distal prosthesis";
            case TID11PM: return "Maxillary left canine mesial prosthesis";
            case TID12A: return "Maxillary left first premolar abutment";
            case TID12I: return "Maxillary left first premolar implant";
            case TID12P: return "Maxillary left first premolar prosthesis";
            case TID12PD: return "Maxillary left first premolar distal prosthesis";
            case TID12PM: return "Maxillary left first premolar mesial prosthesis";
            case TID13A: return "Maxillary left second premolar abutment";
            case TID13I: return "Maxillary left second premolar implant";
            case TID13P: return "Maxillary left second premolar prosthesis";
            case TID13PD: return "Maxillary left second premolar distal prosthesis";
            case TID13PM: return "Maxillary left second premolar mesial prosthesis";
            case TID14A: return "Maxillary left first molar abutment";
            case TID14I: return "Maxillary left first molar implant";
            case TID14P: return "Maxillary left first molar prosthesis";
            case TID14PD: return "Maxillary left first molar distal prosthesis";
            case TID14PM: return "Maxillary left first molar mesial prosthesis";
            case TID15A: return "Maxillary left second molar abutment";
            case TID15I: return "Maxillary left second molar implant";
            case TID15P: return "Maxillary left second molar prosthesis";
            case TID15PD: return "Maxillary left second molar distal prosthesis";
            case TID15PM: return "Maxillary left second molar mesial prosthesis";
            case TID16A: return "Maxillary left third molar abutment";
            case TID16I: return "Maxillary left third molar implant";
            case TID16P: return "Maxillary left third molar prosthesis";
            case TID16PD: return "Maxillary left third molar distal prosthesis";
            case TID16PM: return "Maxillary left third molar mesial prosthesis";
            case TID17A: return "Mandibular left third molar abutment";
            case TID17AD: return "Mandibular left third molar abutment distal hemisection";
            case TID17AM: return "Mandibular left third molar abutment mesial hemisection";
            case TID17I: return "Mandibular left third molar implant";
            case TID17ID: return "Mandibular left third molar implant distal hemisection";
            case TID17IM: return "Mandibular left third molar implant mesial hemisection";
            case TID17P: return "Mandibular left third molar prosthesis";
            case TID17PD: return "Mandibular left third molar distal prosthesis";
            case TID17PM: return "Mandibular left third molar mesial prosthesis";
            case TID18A: return "Mandibular left second molar abutment";
            case TID18AD: return "Mandibular left second molar abutment distal hemisection";
            case TID18AM: return "Mandibular left second molar abutment mesial hemisection";
            case TID18I: return "Mandibular left second molar implant";
            case TID18ID: return "Mandibular left second molar implant distal hemisection";
            case TID18IM: return "Mandibular left second molar implant mesial hemisection";
            case TID18P: return "Mandibular left second molar prosthesis";
            case TID18PD: return "Mandibular left second molar distal prosthesis";
            case TID18PM: return "Mandibular left second molar mesial prosthesis";
            case TID19A: return "Mandibular left first molar abutment";
            case TID19AD: return "Mandibular left first molar abutment distal hemisection";
            case TID19AM: return "Mandibular left first molar abutment mesial hemisection";
            case TID19I: return "Mandibular left first molar implant";
            case TID19ID: return "Mandibular left first molar implant distal hemisection";
            case TID19IM: return "Mandibular left first molar implant mesial hemisection";
            case TID19P: return "Mandibular left first molar prosthesis";
            case TID19PD: return "Mandibular left first molar distal prosthesis";
            case TID19PM: return "Mandibular left first molar mesial prosthesis";
            case TID1A: return "Maxillary right third molar abutment";
            case TID1I: return "Maxillary right third molar implant";
            case TID1P: return "Maxillary right third molar prosthesis";
            case TID1PD: return "Maxillary right third molar distal prosthesis";
            case TID1PM: return "Maxillary right third molar mesial prosthesis";
            case TID20A: return "Mandibular left second premolar abutment";
            case TID20I: return "Mandibular left second premolar implant";
            case TID20P: return "Mandibular left second premolar prosthesis";
            case TID20PD: return "Mandibular left second premolar distal prosthesis";
            case TID20PM: return "Mandibular left second premolar mesial prosthesis";
            case TID21A: return "Mandibular left first premolar abutment";
            case TID21I: return "Mandibular left first premolar implant";
            case TID21P: return "Mandibular left first premolar prosthesis";
            case TID21PD: return "Mandibular left first premolar distal prosthesis";
            case TID21PM: return "Mandibular left first premolar mesial prosthesis";
            case TID22A: return "Mandibular left canine abutment";
            case TID22I: return "Mandibular left canine implant";
            case TID22P: return "Mandibular left canine prosthesis";
            case TID22PD: return "Mandibular left canine distal prosthesis";
            case TID22PM: return "Mandibular left canine mesial prosthesis";
            case TID23A: return "Mandibular left lateral incisor abutment";
            case TID23I: return "Mandibular left lateral incisor implant";
            case TID23P: return "Mandibular left lateral incisor prosthesis";
            case TID23PD: return "Mandibular left lateral incisor distal prosthesis";
            case TID23PM: return "Mandibular left lateral incisor mesial prosthesis";
            case TID24A: return "Mandibular left central incisor abutment";
            case TID24I: return "Mandibular left central incisor implant";
            case TID24P: return "Mandibular left central incisor prosthesis";
            case TID24PD: return "Mandibular left central incisor distal prosthesis";
            case TID24PM: return "Mandibular left central incisor mesial prosthesis";
            case TID25A: return "Mandibular right central incisor abutment";
            case TID25I: return "Mandibular right central incisor implant";
            case TID25P: return "Mandibular right central incisor prosthesis";
            case TID25PD: return "Mandibular right central incisor distal prosthesis";
            case TID25PM: return "Mandibular right central incisor mesial prosthesis";
            case TID26A: return "Mandibular right lateral incisor abutment";
            case TID26I: return "Mandibular right lateral incisor implant";
            case TID26P: return "Mandibular right lateral incisor prosthesis";
            case TID26PD: return "Mandibular right lateral incisor distal prosthesis";
            case TID26PM: return "Mandibular right lateral incisor mesial prosthesis";
            case TID27A: return "Mandibular right canine abutment";
            case TID27I: return "Mandibular right canine implant";
            case TID27P: return "Mandibular right canine prosthesis";
            case TID27PD: return "Mandibular right canine distal prosthesis";
            case TID27PM: return "Mandibular right canine mesial prosthesis";
            case TID28A: return "Mandibular right first premolar abutment";
            case TID28I: return "Mandibular right first premolar implant";
            case TID28P: return "Mandibular right first premolar prosthesis";
            case TID28PD: return "Mandibular right first premolar distal prosthesis";
            case TID28PM: return "Mandibular right first premolar mesial prosthesis";
            case TID29A: return "Mandibular right second premolar abutment";
            case TID29I: return "Mandibular right second premolar implant";
            case TID29P: return "Mandibular right second premolar prosthesis";
            case TID29PD: return "Mandibular right second premolar distal prosthesis";
            case TID29PM: return "Mandibular right second premolar mesial prosthesis";
            case TID2A: return "Maxillary right second molar abutment";
            case TID2I: return "Maxillary right second molar implant";
            case TID2P: return "Maxillary right second molar prosthesis";
            case TID2PD: return "Maxillary right second molar distal prosthesis";
            case TID2PM: return "Maxillary right second molar mesial prosthesis";
            case TID30A: return "Mandibular right first molar abutment";
            case TID30AD: return "Mandibular right first molar abutment distal hemisection";
            case TID30AM: return "Mandibular right first molar abutment mesial hemisection";
            case TID30I: return "Mandibular right first molar implant";
            case TID30ID: return "Mandibular right first molar implant distal hemisection";
            case TID30IM: return "Mandibular right first molar implant mesial hemisection";
            case TID30P: return "Mandibular right first molar prosthesis";
            case TID30PD: return "Mandibular right first molar distal prosthesis";
            case TID30PM: return "Mandibular right first molar mesial prosthesis";
            case TID31A: return "Mandibular right second molar abutment";
            case TID31AD: return "Mandibular right second molar abutment distal hemisection";
            case TID31AM: return "Mandibular right second molar abutment mesial hemisection";
            case TID31I: return "Mandibular right second molar implant";
            case TID31ID: return "Mandibular right second molar implant distal hemisection";
            case TID31IM: return "Mandibular right second molar implant mesial hemisection";
            case TID31P: return "Mandibular right second molar prosthesis";
            case TID31PD: return "Mandibular right second molar distal prosthesis";
            case TID31PM: return "Mandibular right second molar mesial prosthesis";
            case TID32A: return "Mandibular right third molar abutment";
            case TID32AD: return "Mandibular right third molar abutment distal hemisection";
            case TID32AM: return "Mandibular right third molar abutment mesial hemisection";
            case TID32I: return "Mandibular right third molar implant";
            case TID32ID: return "Mandibular right third molar implant distal hemisection";
            case TID32IM: return "Mandibular right third molar implant mesial hemisection";
            case TID32P: return "Mandibular right third molar prosthesis";
            case TID32PD: return "Mandibular right third molar distal prosthesis";
            case TID32PM: return "Mandibular right third molar mesial prosthesis";
            case TID3A: return "Maxillary right first molar abutment";
            case TID3I: return "Maxillary right first molar implant";
            case TID3P: return "Maxillary right first molar prosthesis";
            case TID3PD: return "Maxillary right first molar distal prosthesis";
            case TID3PM: return "Maxillary right first molar mesial prosthesis";
            case TID4A: return "Maxillary right second premolar abutment";
            case TID4I: return "Maxillary right second premolar implant";
            case TID4P: return "Maxillary right second premolar prosthesis";
            case TID4PD: return "Maxillary right second premolar distal prosthesis";
            case TID4PM: return "Maxillary right second premolar mesial prosthesis";
            case TID5A: return "Maxillary right first premolar abutment";
            case TID5I: return "Maxillary right first premolar implant";
            case TID5P: return "Maxillary right first premolar prosthesis";
            case TID5PD: return "Maxillary right first premolar distal prosthesis";
            case TID5PM: return "Maxillary right first premolar mesial prosthesis";
            case TID6A: return "Maxillary right canine abutment";
            case TID6I: return "Maxillary right canine implant";
            case TID6P: return "Maxillary right canine prosthesis";
            case TID6PD: return "Maxillary right canine distal prosthesis";
            case TID6PM: return "Maxillary right canine mesial prosthesis";
            case TID7A: return "Maxillary right lateral incisor abutment";
            case TID7I: return "Maxillary right lateral incisor implant";
            case TID7P: return "Maxillary right lateral incisor prosthesis";
            case TID7PD: return "Maxillary right lateral incisor distal prosthesis";
            case TID7PM: return "Maxillary right lateral incisor mesial prosthesis";
            case TID8A: return "Maxillary right central incisor abutment";
            case TID8I: return "Maxillary right central incisor implant";
            case TID8P: return "Maxillary right central incisor prosthesis";
            case TID8PD: return "Maxillary right central incisor distal prosthesis";
            case TID8PM: return "Maxillary right central incisor mesial prosthesis";
            case TID9A: return "Maxillary left central incisor abutment";
            case TID9I: return "Maxillary left central incisor implant";
            case TID9P: return "Maxillary left central incisor prosthesis";
            case TID9PD: return "Maxillary left central incisor distal prosthesis";
            case TID9PM: return "Maxillary left central incisor mesial prosthesis";
            case PERMANENTDENTITION: return "Permanent dentition, the natural teeth of adulthood that replace or are added to the deciduous teeth";
            case TID1: return "Maxillary right third molar";
            case TID10: return "Maxillary left lateral incisor";
            case TID11: return "Maxillary left canine";
            case TID12: return "Maxillary left first premolar";
            case TID13: return "Maxillary left second premolar";
            case TID14: return "Maxillary left first molar";
            case TID15: return "Maxillary left second molar";
            case TID16: return "Maxillary left third molar";
            case TID17: return "Mandibular left third molar";
            case TID17D: return "Mandibular left third molar distal hemisection";
            case TID17M: return "Mandibular left third molar mesial hemisection";
            case TID18: return "Mandibular left second molar";
            case TID18D: return "Mandibular left second molar distal hemisection";
            case TID18M: return "Mandibular left second molar mesial hemisection";
            case TID19: return "Mandibular left first molar";
            case TID19D: return "Mandibular left first molar distal hemisection";
            case TID19M: return "Mandibular left first molar mesial hemisection";
            case TID2: return "Maxillary right second molar";
            case TID20: return "Mandibular left second premolar";
            case TID21: return "Mandibular left first premolar";
            case TID22: return "Mandibular left canine";
            case TID23: return "Mandibular left lateral incisor";
            case TID24: return "Mandibular left central incisor";
            case TID25: return "Mandibular right central incisor";
            case TID26: return "Mandibular right lateral incisor";
            case TID27: return "Mandibular right canine";
            case TID28: return "Mandibular right first premolar";
            case TID29: return "Mandibular right second premolar";
            case TID3: return "Maxillary right first molar";
            case TID30: return "Mandibular right first molar";
            case TID30D: return "Mandibular right first molar distal hemisection";
            case TID30M: return "Mandibular right first molar mesial hemisection";
            case TID31: return "Mandibular right second molar";
            case TID31D: return "Mandibular right second molar distal hemisection";
            case TID31M: return "Mandibular right second molar mesial hemisection";
            case TID32: return "Mandibular right third molar";
            case TID32D: return "Mandibular right third molar distal hemisection";
            case TID32M: return "Mandibular right third molar mesial hemisection";
            case TID4: return "Maxillary right second premolar";
            case TID5: return "Maxillary right first premolar";
            case TID6: return "Maxillary right canine";
            case TID7: return "Maxillary right lateral incisor";
            case TID8: return "Maxillary right central incisor";
            case TID9: return "Maxillary left central incisor";
            case PRIMARYDENTITION: return "Primary dentition, the first teeth to errupt and usually replaced with permanent dentition";
            case TIDA: return "Maxillary right second primary molar";
            case TIDB: return "Maxillary right first primary molar";
            case TIDC: return "Maxillary right primary canine";
            case TIDD: return "Maxillary right lateral primary incisor";
            case TIDE: return "Maxillary right central primary incisor";
            case TIDF: return "Maxillary left central primary incisor";
            case TIDG: return "Maxillary left lateral primary incisor";
            case TIDH: return "Maxillary left primary canine";
            case TIDI: return "Maxillary left first primary molar";
            case TIDJ: return "Maxillary left second primary molar";
            case TIDK: return "Mandibular left second primary molar";
            case TIDL: return "Mandibular left first primary molar";
            case TIDM: return "Mandibular left primary canine";
            case TIDN: return "Mandibular left lateral primary incisor";
            case TIDO: return "Mandibular left central primary incisor";
            case TIDP: return "Mandibular right central primary incisor";
            case TIDQ: return "Mandibular right lateral primary incisor";
            case TIDR: return "Mandibular right primary canine";
            case TIDS: return "Mandibular right first primary molar";
            case TIDT: return "Mandibular right second primary molar";
            case SUPERNUMERARYTOOTH: return "Supernumerary tooth, any tooth in addition to the normal permanent and primary dentition";
            case TID10S: return "Supernumerary maxillary left lateral incisor";
            case TID11S: return "Supernumerary maxillary left canine";
            case TID12S: return "Supernumerary maxillary left first premolar";
            case TID13S: return "Supernumerary maxillary left second premolar";
            case TID14S: return "Supernumerary maxillary left first molar";
            case TID15S: return "Supernumerary maxillary left second molar";
            case TID16S: return "Supernumerary maxillary left third molar";
            case TID17S: return "Supernumerary mandibular left third molar";
            case TID18S: return "Supernumerary mandibular left second molar";
            case TID19S: return "Supernumerary mandibular left first molar";
            case TID1S: return "Supernumerary maxillary right third molar";
            case TID20S: return "Supernumerary mandibular left second premolar";
            case TID21S: return "Supernumerary mandibular left first premolar";
            case TID22S: return "Supernumerary mandibular left canine";
            case TID23S: return "Supernumerary mandibular left lateral incisor";
            case TID24S: return "Supernumerary mandibular left central incisor";
            case TID25S: return "Supernumerary mandibular right central incisor";
            case TID26S: return "Supernumerary mandibular right lateral incisor";
            case TID27S: return "Supernumerary mandibular right canine";
            case TID28S: return "Supernumerary mandibular right first premolar";
            case TID29S: return "Supernumerary mandibular right second premolar";
            case TID2S: return "Supernumerary maxillary right second molar";
            case TID30S: return "Supernumerary mandibular right first molar";
            case TID31S: return "Supernumerary mandibular right second molar";
            case TID32S: return "Supernumerary mandibular right third molar";
            case TID3S: return "Supernumerary maxillary right first molar";
            case TID4S: return "Supernumerary maxillary right second premolar";
            case TID5S: return "Supernumerary maxillary right first premolar";
            case TID6S: return "Supernumerary maxillary right canine";
            case TID7S: return "Supernumerary maxillary right lateral incisor";
            case TID8S: return "Supernumerary maxillary right central incisor";
            case TID9S: return "Supernumerary maxillary left central incisor";
            case TIDAS: return "Supernumerary maxillary right second primary molar";
            case TIDBS: return "Supernumerary maxillary right first primary molar";
            case TIDCS: return "Supernumerary maxillary right primary canine";
            case TIDDS: return "Supernumerary maxillary right lateral primary incisor";
            case TIDES: return "Supernumerary maxillary right central primary incisor";
            case TIDFS: return "Supernumerary maxillary left central primary incisor";
            case TIDGS: return "Supernumerary maxillary left lateral primary incisor";
            case TIDHS: return "Supernumerary maxillary left primary canine";
            case TIDIS: return "Supernumerary maxillary left first primary molar";
            case TIDJS: return "Supernumerary maxillary left second primary molar";
            case TIDKS: return "Supernumerary mandibular left second primary molar";
            case TIDLS: return "Supernumerary mandibular left first primary molar";
            case TIDMS: return "Supernumerary mandibular left primary canine";
            case TIDNS: return "Supernumerary mandibular left lateral primary incisor";
            case TIDOS: return "Supernumerary mandibular left central primary incisor";
            case TIDPS: return "Supernumerary mandibular right central primary incisor";
            case TIDQS: return "Supernumerary mandibular right lateral primary incisor";
            case TIDRS: return "Supernumerary mandibular right primary canine";
            case TIDSS: return "Supernumerary mandibular right first primary molar";
            case TIDTS: return "Supernumerary mandibular right second primary molar";
            default: return "?";
          }
        }
        public String getDisplay() {
          switch (this) {
            case ARTIFICIALDENTITION: return "Artificial dentition";
            case TID10A: return "10a";
            case TID10I: return "10i";
            case TID10P: return "10p";
            case TID10PD: return "10pd";
            case TID10PM: return "10pm";
            case TID11A: return "11a";
            case TID11I: return "11i";
            case TID11P: return "11p";
            case TID11PD: return "11pd";
            case TID11PM: return "11pm";
            case TID12A: return "12a";
            case TID12I: return "12i";
            case TID12P: return "12p";
            case TID12PD: return "12pd";
            case TID12PM: return "12pm";
            case TID13A: return "13a";
            case TID13I: return "13i";
            case TID13P: return "13p";
            case TID13PD: return "13pd";
            case TID13PM: return "13pm";
            case TID14A: return "14a";
            case TID14I: return "14i";
            case TID14P: return "14p";
            case TID14PD: return "14pd";
            case TID14PM: return "14pm";
            case TID15A: return "15a";
            case TID15I: return "15i";
            case TID15P: return "15p";
            case TID15PD: return "15pd";
            case TID15PM: return "15pm";
            case TID16A: return "16a";
            case TID16I: return "16i";
            case TID16P: return "16p";
            case TID16PD: return "16pd";
            case TID16PM: return "16pm";
            case TID17A: return "17a";
            case TID17AD: return "17ad";
            case TID17AM: return "17am";
            case TID17I: return "17i";
            case TID17ID: return "17id";
            case TID17IM: return "17im";
            case TID17P: return "17p";
            case TID17PD: return "17pd";
            case TID17PM: return "17pm";
            case TID18A: return "18a";
            case TID18AD: return "18ad";
            case TID18AM: return "18am";
            case TID18I: return "18i";
            case TID18ID: return "18id";
            case TID18IM: return "18im";
            case TID18P: return "18p";
            case TID18PD: return "18pd";
            case TID18PM: return "18pm";
            case TID19A: return "19a";
            case TID19AD: return "19ad";
            case TID19AM: return "19am";
            case TID19I: return "19i";
            case TID19ID: return "19id";
            case TID19IM: return "19im";
            case TID19P: return "19p";
            case TID19PD: return "19pd";
            case TID19PM: return "19pm";
            case TID1A: return "1a";
            case TID1I: return "1i";
            case TID1P: return "1p";
            case TID1PD: return "1pd";
            case TID1PM: return "1pm";
            case TID20A: return "20a";
            case TID20I: return "20i";
            case TID20P: return "20p";
            case TID20PD: return "20pd";
            case TID20PM: return "20pm";
            case TID21A: return "21a";
            case TID21I: return "21i";
            case TID21P: return "21p";
            case TID21PD: return "21pd";
            case TID21PM: return "21pm";
            case TID22A: return "22a";
            case TID22I: return "22i";
            case TID22P: return "22p";
            case TID22PD: return "22pd";
            case TID22PM: return "22pm";
            case TID23A: return "23a";
            case TID23I: return "23i";
            case TID23P: return "23p";
            case TID23PD: return "23pd";
            case TID23PM: return "23pm";
            case TID24A: return "24a";
            case TID24I: return "24i";
            case TID24P: return "24p";
            case TID24PD: return "24pd";
            case TID24PM: return "24pm";
            case TID25A: return "25a";
            case TID25I: return "25i";
            case TID25P: return "25p";
            case TID25PD: return "25pd";
            case TID25PM: return "25pm";
            case TID26A: return "26a";
            case TID26I: return "26i";
            case TID26P: return "26p";
            case TID26PD: return "26pd";
            case TID26PM: return "26pm";
            case TID27A: return "27a";
            case TID27I: return "27i";
            case TID27P: return "27p";
            case TID27PD: return "27pd";
            case TID27PM: return "27pm";
            case TID28A: return "28a";
            case TID28I: return "28i";
            case TID28P: return "28p";
            case TID28PD: return "28pd";
            case TID28PM: return "28pm";
            case TID29A: return "29a";
            case TID29I: return "29i";
            case TID29P: return "29p";
            case TID29PD: return "29pd";
            case TID29PM: return "29pm";
            case TID2A: return "2a";
            case TID2I: return "2i";
            case TID2P: return "2p";
            case TID2PD: return "2pd";
            case TID2PM: return "2pm";
            case TID30A: return "30a";
            case TID30AD: return "30ad";
            case TID30AM: return "30am";
            case TID30I: return "30i";
            case TID30ID: return "30id";
            case TID30IM: return "30im";
            case TID30P: return "30p";
            case TID30PD: return "30pd";
            case TID30PM: return "30pm";
            case TID31A: return "31a";
            case TID31AD: return "31ad";
            case TID31AM: return "31am";
            case TID31I: return "31i";
            case TID31ID: return "31id";
            case TID31IM: return "31im";
            case TID31P: return "31p";
            case TID31PD: return "31pd";
            case TID31PM: return "31pm";
            case TID32A: return "32a";
            case TID32AD: return "32ad";
            case TID32AM: return "32am";
            case TID32I: return "32i";
            case TID32ID: return "32id";
            case TID32IM: return "32im";
            case TID32P: return "32p";
            case TID32PD: return "32pd";
            case TID32PM: return "32pm";
            case TID3A: return "3a";
            case TID3I: return "3i";
            case TID3P: return "3p";
            case TID3PD: return "3pd";
            case TID3PM: return "3pm";
            case TID4A: return "4a";
            case TID4I: return "4i";
            case TID4P: return "4p";
            case TID4PD: return "4pd";
            case TID4PM: return "4pm";
            case TID5A: return "5a";
            case TID5I: return "5i";
            case TID5P: return "5p";
            case TID5PD: return "5pd";
            case TID5PM: return "5pm";
            case TID6A: return "6a";
            case TID6I: return "6i";
            case TID6P: return "6p";
            case TID6PD: return "6pd";
            case TID6PM: return "6pm";
            case TID7A: return "7a";
            case TID7I: return "7i";
            case TID7P: return "7p";
            case TID7PD: return "7pd";
            case TID7PM: return "7pm";
            case TID8A: return "8a";
            case TID8I: return "8i";
            case TID8P: return "8p";
            case TID8PD: return "8pd";
            case TID8PM: return "8pm";
            case TID9A: return "9a";
            case TID9I: return "9i";
            case TID9P: return "9p";
            case TID9PD: return "9pd";
            case TID9PM: return "9pm";
            case PERMANENTDENTITION: return "Permanent dentition";
            case TID1: return "1";
            case TID10: return "10";
            case TID11: return "11";
            case TID12: return "12";
            case TID13: return "13";
            case TID14: return "14";
            case TID15: return "15";
            case TID16: return "16";
            case TID17: return "17";
            case TID17D: return "17d";
            case TID17M: return "17m";
            case TID18: return "18";
            case TID18D: return "18d";
            case TID18M: return "18m";
            case TID19: return "19";
            case TID19D: return "19d";
            case TID19M: return "19m";
            case TID2: return "2";
            case TID20: return "20";
            case TID21: return "21";
            case TID22: return "22";
            case TID23: return "23";
            case TID24: return "24";
            case TID25: return "25";
            case TID26: return "26";
            case TID27: return "27";
            case TID28: return "28";
            case TID29: return "29";
            case TID3: return "3";
            case TID30: return "30";
            case TID30D: return "30d";
            case TID30M: return "30m";
            case TID31: return "31";
            case TID31D: return "31d";
            case TID31M: return "31m";
            case TID32: return "32";
            case TID32D: return "32d";
            case TID32M: return "32m";
            case TID4: return "4";
            case TID5: return "5";
            case TID6: return "6";
            case TID7: return "7";
            case TID8: return "8";
            case TID9: return "9";
            case PRIMARYDENTITION: return "Primary dentition";
            case TIDA: return "A";
            case TIDB: return "B";
            case TIDC: return "C";
            case TIDD: return "D";
            case TIDE: return "E";
            case TIDF: return "F";
            case TIDG: return "G";
            case TIDH: return "H";
            case TIDI: return "I";
            case TIDJ: return "J";
            case TIDK: return "K";
            case TIDL: return "L";
            case TIDM: return "M";
            case TIDN: return "N";
            case TIDO: return "O";
            case TIDP: return "P";
            case TIDQ: return "Q";
            case TIDR: return "R";
            case TIDS: return "S";
            case TIDT: return "T";
            case SUPERNUMERARYTOOTH: return "Supernumerary Tooth";
            case TID10S: return "10s";
            case TID11S: return "11s";
            case TID12S: return "12s";
            case TID13S: return "13s";
            case TID14S: return "14s";
            case TID15S: return "15s";
            case TID16S: return "16s";
            case TID17S: return "17s";
            case TID18S: return "18s";
            case TID19S: return "19s";
            case TID1S: return "1s";
            case TID20S: return "20s";
            case TID21S: return "21s";
            case TID22S: return "22s";
            case TID23S: return "23s";
            case TID24S: return "24s";
            case TID25S: return "25s";
            case TID26S: return "26s";
            case TID27S: return "27s";
            case TID28S: return "28s";
            case TID29S: return "29s";
            case TID2S: return "2s";
            case TID30S: return "30s";
            case TID31S: return "31s";
            case TID32S: return "32s";
            case TID3S: return "3s";
            case TID4S: return "4s";
            case TID5S: return "5s";
            case TID6S: return "6s";
            case TID7S: return "7s";
            case TID8S: return "8s";
            case TID9S: return "9s";
            case TIDAS: return "As";
            case TIDBS: return "Bs";
            case TIDCS: return "Cs";
            case TIDDS: return "Ds";
            case TIDES: return "Es";
            case TIDFS: return "Fs";
            case TIDGS: return "Gs";
            case TIDHS: return "Hs";
            case TIDIS: return "Is";
            case TIDJS: return "Js";
            case TIDKS: return "Ks";
            case TIDLS: return "Ls";
            case TIDMS: return "Ms";
            case TIDNS: return "Ns";
            case TIDOS: return "Os";
            case TIDPS: return "Ps";
            case TIDQS: return "Qs";
            case TIDRS: return "Rs";
            case TIDSS: return "Ss";
            case TIDTS: return "Ts";
            default: return "?";
          }
    }


}

