/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CompositionAttestationMode {
    PERSONAL,
    PROFESSIONAL,
    LEGAL,
    OFFICIAL,
    NULL;


    public static CompositionAttestationMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("personal".equals(codeString)) {
            return PERSONAL;
        }
        if ("professional".equals(codeString)) {
            return PROFESSIONAL;
        }
        if ("legal".equals(codeString)) {
            return LEGAL;
        }
        if ("official".equals(codeString)) {
            return OFFICIAL;
        }
        throw new FHIRException("Unknown CompositionAttestationMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PERSONAL: {
                return "personal";
            }
            case PROFESSIONAL: {
                return "professional";
            }
            case LEGAL: {
                return "legal";
            }
            case OFFICIAL: {
                return "official";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/composition-attestation-mode";
    }

    public String getDefinition() {
        switch (this) {
            case PERSONAL: {
                return "The person authenticated the content in their personal capacity.";
            }
            case PROFESSIONAL: {
                return "The person authenticated the content in their professional capacity.";
            }
            case LEGAL: {
                return "The person authenticated the content and accepted legal responsibility for its content.";
            }
            case OFFICIAL: {
                return "The organization authenticated the content as consistent with their policies and procedures.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PERSONAL: {
                return "Personal";
            }
            case PROFESSIONAL: {
                return "Professional";
            }
            case LEGAL: {
                return "Legal";
            }
            case OFFICIAL: {
                return "Official";
            }
        }
        return "?";
    }
}

