/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ExPayeeResourceType {
    ORGANIZATION,
    PATIENT,
    PRACTITIONER,
    RELATEDPERSON,
    NULL;


    public static ExPayeeResourceType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("organization".equals(codeString)) {
            return ORGANIZATION;
        }
        if ("patient".equals(codeString)) {
            return PATIENT;
        }
        if ("practitioner".equals(codeString)) {
            return PRACTITIONER;
        }
        if ("relatedperson".equals(codeString)) {
            return RELATEDPERSON;
        }
        throw new FHIRException("Unknown ExPayeeResourceType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ORGANIZATION: {
                return "organization";
            }
            case PATIENT: {
                return "patient";
            }
            case PRACTITIONER: {
                return "practitioner";
            }
            case RELATEDPERSON: {
                return "relatedperson";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/ex-payee-resource-type";
    }

    public String getDefinition() {
        switch (this) {
            case ORGANIZATION: {
                return "Organization resource.";
            }
            case PATIENT: {
                return "Patient resource.";
            }
            case PRACTITIONER: {
                return "Practitioner resource.";
            }
            case RELATEDPERSON: {
                return "RelatedPerson resource.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ORGANIZATION: {
                return "Organization";
            }
            case PATIENT: {
                return "Patient";
            }
            case PRACTITIONER: {
                return "Practitioner";
            }
            case RELATEDPERSON: {
                return "RelatedPerson";
            }
        }
        return "?";
    }
}

