/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SpecialValues {
    TRUE,
    FALSE,
    TRACE,
    SUFFICIENT,
    WITHDRAWN,
    NILKNOWN,
    NULL;


    public static SpecialValues fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("true".equals(codeString)) {
            return TRUE;
        }
        if ("false".equals(codeString)) {
            return FALSE;
        }
        if ("trace".equals(codeString)) {
            return TRACE;
        }
        if ("sufficient".equals(codeString)) {
            return SUFFICIENT;
        }
        if ("withdrawn".equals(codeString)) {
            return WITHDRAWN;
        }
        if ("nil-known".equals(codeString)) {
            return NILKNOWN;
        }
        throw new FHIRException("Unknown SpecialValues code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case TRUE: {
                return "true";
            }
            case FALSE: {
                return "false";
            }
            case TRACE: {
                return "trace";
            }
            case SUFFICIENT: {
                return "sufficient";
            }
            case WITHDRAWN: {
                return "withdrawn";
            }
            case NILKNOWN: {
                return "nil-known";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/special-values";
    }

    public String getDefinition() {
        switch (this) {
            case TRUE: {
                return "Boolean true.";
            }
            case FALSE: {
                return "Boolean false.";
            }
            case TRACE: {
                return "The content is greater than zero, but too small to be quantified.";
            }
            case SUFFICIENT: {
                return "The specific quantity is not known, but is known to be non-zero and is not specified because it makes up the bulk of the material.";
            }
            case WITHDRAWN: {
                return "The value is no longer available.";
            }
            case NILKNOWN: {
                return "The are no known applicable values in this context.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case TRUE: {
                return "true";
            }
            case FALSE: {
                return "false";
            }
            case TRACE: {
                return "Trace Amount Detected";
            }
            case SUFFICIENT: {
                return "Sufficient Quantity";
            }
            case WITHDRAWN: {
                return "Value Withdrawn";
            }
            case NILKNOWN: {
                return "Nil Known";
            }
        }
        return "?";
    }
}

