/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConceptProperties {
    INACTIVE,
    DEPRECATED,
    NOTSELECTABLE,
    PARENT,
    CHILD,
    NULL;


    public static ConceptProperties fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("inactive".equals(codeString)) {
            return INACTIVE;
        }
        if ("deprecated".equals(codeString)) {
            return DEPRECATED;
        }
        if ("notSelectable".equals(codeString)) {
            return NOTSELECTABLE;
        }
        if ("parent".equals(codeString)) {
            return PARENT;
        }
        if ("child".equals(codeString)) {
            return CHILD;
        }
        throw new FHIRException("Unknown ConceptProperties code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INACTIVE: {
                return "inactive";
            }
            case DEPRECATED: {
                return "deprecated";
            }
            case NOTSELECTABLE: {
                return "notSelectable";
            }
            case PARENT: {
                return "parent";
            }
            case CHILD: {
                return "child";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/concept-properties";
    }

    public String getDefinition() {
        switch (this) {
            case INACTIVE: {
                return "True if the concept is not considered active - e.g. not a valid concept any more. Property type is boolean, default value is false";
            }
            case DEPRECATED: {
                return "The date at which a concept was deprecated. Concepts that are deprecated but not inactive can still be used, but their use is discouraged, and they should be expected to be made inactive in a future release. Property type is dateTime";
            }
            case NOTSELECTABLE: {
                return "The concept is not intended to be chosen by the user - only intended to be used as a selector for other concepts. Note, though, that the interpretation of this is highly contextual; all concepts are selectable in some context. Property type is boolean";
            }
            case PARENT: {
                return "The concept identified in this property is a parent of the concept on which it is a property. The property type will be 'code'. The meaning of 'parent' is defined by the hierarchyMeaning attribute";
            }
            case CHILD: {
                return "The concept identified in this property is a child of the concept on which it is a property. The property type will be 'code'. The meaning of 'child' is defined by the hierarchyMeaning attribute";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INACTIVE: {
                return "Inactive";
            }
            case DEPRECATED: {
                return "Deprecated";
            }
            case NOTSELECTABLE: {
                return "Not Selectable";
            }
            case PARENT: {
                return "Parent";
            }
            case CHILD: {
                return "Child";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

