/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.HttpVerb;

public class HttpVerbEnumFactory
implements EnumFactory<HttpVerb> {
    @Override
    public HttpVerb fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("GET".equals(codeString)) {
            return HttpVerb.GET;
        }
        if ("HEAD".equals(codeString)) {
            return HttpVerb.HEAD;
        }
        if ("POST".equals(codeString)) {
            return HttpVerb.POST;
        }
        if ("PUT".equals(codeString)) {
            return HttpVerb.PUT;
        }
        if ("DELETE".equals(codeString)) {
            return HttpVerb.DELETE;
        }
        if ("PATCH".equals(codeString)) {
            return HttpVerb.PATCH;
        }
        throw new IllegalArgumentException("Unknown HttpVerb code '" + codeString + "'");
    }

    @Override
    public String toCode(HttpVerb code) {
        if (code == HttpVerb.GET) {
            return "GET";
        }
        if (code == HttpVerb.HEAD) {
            return "HEAD";
        }
        if (code == HttpVerb.POST) {
            return "POST";
        }
        if (code == HttpVerb.PUT) {
            return "PUT";
        }
        if (code == HttpVerb.DELETE) {
            return "DELETE";
        }
        if (code == HttpVerb.PATCH) {
            return "PATCH";
        }
        return "?";
    }

    @Override
    public String toSystem(HttpVerb code) {
        return code.getSystem();
    }
}

