package org.hl7.fhir.r4.model;

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Tue, May 12, 2020 07:26+1000 for FHIR v4.0.1
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumerations.PublicationStatus;
import org.hl7.fhir.r4.model.Enumerations.PublicationStatusEnumFactory;
import org.hl7.fhir.utilities.Utilities;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;

/**
 * The Evidence resource describes the conditional state (population and any
 * exposures being compared within the population) and outcome (if specified)
 * that the knowledge (evidence, assertion, recommendation) is about.
 */
@ResourceDef(name = "Evidence", profile = "http://hl7.org/fhir/StructureDefinition/Evidence")
@ChildOrder(names = { "url", "identifier", "version", "name", "title", "shortTitle", "subtitle", "status", "date",
    "publisher", "contact", "description", "note", "useContext", "jurisdiction", "copyright", "approvalDate",
    "lastReviewDate", "effectivePeriod", "topic", "author", "editor", "reviewer", "endorser", "relatedArtifact",
    "exposureBackground", "exposureVariant", "outcome" })
public class Evidence extends MetadataResource {

  /**
   * A formal identifier that is used to identify this evidence when it is
   * represented in other formats, or referenced in a specification, model, design
   * or an instance.
   */
  @Child(name = "identifier", type = {
      Identifier.class }, order = 0, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = true)
  @Description(shortDefinition = "Additional identifier for the evidence", formalDefinition = "A formal identifier that is used to identify this evidence when it is represented in other formats, or referenced in a specification, model, design or an instance.")
  protected List<Identifier> identifier;

  /**
   * The short title provides an alternate title for use in informal descriptive
   * contexts where the full, formal title is not necessary.
   */
  @Child(name = "shortTitle", type = {
      StringType.class }, order = 1, min = 0, max = 1, modifier = false, summary = false)
  @Description(shortDefinition = "Title for use in informal contexts", formalDefinition = "The short title provides an alternate title for use in informal descriptive contexts where the full, formal title is not necessary.")
  protected StringType shortTitle;

  /**
   * An explanatory or alternate title for the Evidence giving additional
   * information about its content.
   */
  @Child(name = "subtitle", type = { StringType.class }, order = 2, min = 0, max = 1, modifier = false, summary = false)
  @Description(shortDefinition = "Subordinate title of the Evidence", formalDefinition = "An explanatory or alternate title for the Evidence giving additional information about its content.")
  protected StringType subtitle;

  /**
   * A human-readable string to clarify or explain concepts about the resource.
   */
  @Child(name = "note", type = {
      Annotation.class }, order = 3, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = false)
  @Description(shortDefinition = "Used for footnotes or explanatory notes", formalDefinition = "A human-readable string to clarify or explain concepts about the resource.")
  protected List<Annotation> note;

  /**
   * A copyright statement relating to the evidence and/or its contents. Copyright
   * statements are generally legal restrictions on the use and publishing of the
   * evidence.
   */
  @Child(name = "copyright", type = {
      MarkdownType.class }, order = 4, min = 0, max = 1, modifier = false, summary = false)
  @Description(shortDefinition = "Use and/or publishing restrictions", formalDefinition = "A copyright statement relating to the evidence and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the evidence.")
  protected MarkdownType copyright;

  /**
   * The date on which the resource content was approved by the publisher.
   * Approval happens once when the content is officially approved for usage.
   */
  @Child(name = "approvalDate", type = {
      DateType.class }, order = 5, min = 0, max = 1, modifier = false, summary = false)
  @Description(shortDefinition = "When the evidence was approved by publisher", formalDefinition = "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
  protected DateType approvalDate;

  /**
   * The date on which the resource content was last reviewed. Review happens
   * periodically after approval but does not change the original approval date.
   */
  @Child(name = "lastReviewDate", type = {
      DateType.class }, order = 6, min = 0, max = 1, modifier = false, summary = false)
  @Description(shortDefinition = "When the evidence was last reviewed", formalDefinition = "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
  protected DateType lastReviewDate;

  /**
   * The period during which the evidence content was or is planned to be in
   * active use.
   */
  @Child(name = "effectivePeriod", type = {
      Period.class }, order = 7, min = 0, max = 1, modifier = false, summary = true)
  @Description(shortDefinition = "When the evidence is expected to be used", formalDefinition = "The period during which the evidence content was or is planned to be in active use.")
  protected Period effectivePeriod;

  /**
   * Descriptive topics related to the content of the Evidence. Topics provide a
   * high-level categorization grouping types of Evidences that can be useful for
   * filtering and searching.
   */
  @Child(name = "topic", type = {
      CodeableConcept.class }, order = 8, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = false)
  @Description(shortDefinition = "The category of the Evidence, such as Education, Treatment, Assessment, etc.", formalDefinition = "Descriptive topics related to the content of the Evidence. Topics provide a high-level categorization grouping types of Evidences that can be useful for filtering and searching.")
  @ca.uhn.fhir.model.api.annotation.Binding(valueSet = "http://hl7.org/fhir/ValueSet/definition-topic")
  protected List<CodeableConcept> topic;

  /**
   * An individiual or organization primarily involved in the creation and
   * maintenance of the content.
   */
  @Child(name = "author", type = {
      ContactDetail.class }, order = 9, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = false)
  @Description(shortDefinition = "Who authored the content", formalDefinition = "An individiual or organization primarily involved in the creation and maintenance of the content.")
  protected List<ContactDetail> author;

  /**
   * An individual or organization primarily responsible for internal coherence of
   * the content.
   */
  @Child(name = "editor", type = {
      ContactDetail.class }, order = 10, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = false)
  @Description(shortDefinition = "Who edited the content", formalDefinition = "An individual or organization primarily responsible for internal coherence of the content.")
  protected List<ContactDetail> editor;

  /**
   * An individual or organization primarily responsible for review of some aspect
   * of the content.
   */
  @Child(name = "reviewer", type = {
      ContactDetail.class }, order = 11, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = false)
  @Description(shortDefinition = "Who reviewed the content", formalDefinition = "An individual or organization primarily responsible for review of some aspect of the content.")
  protected List<ContactDetail> reviewer;

  /**
   * An individual or organization responsible for officially endorsing the
   * content for use in some setting.
   */
  @Child(name = "endorser", type = {
      ContactDetail.class }, order = 12, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = false)
  @Description(shortDefinition = "Who endorsed the content", formalDefinition = "An individual or organization responsible for officially endorsing the content for use in some setting.")
  protected List<ContactDetail> endorser;

  /**
   * Related artifacts such as additional documentation, justification, or
   * bibliographic references.
   */
  @Child(name = "relatedArtifact", type = {
      RelatedArtifact.class }, order = 13, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = false)
  @Description(shortDefinition = "Additional documentation, citations, etc.", formalDefinition = "Related artifacts such as additional documentation, justification, or bibliographic references.")
  protected List<RelatedArtifact> relatedArtifact;

  /**
   * A reference to a EvidenceVariable resource that defines the population for
   * the research.
   */
  @Child(name = "exposureBackground", type = {
      EvidenceVariable.class }, order = 14, min = 1, max = 1, modifier = false, summary = true)
  @Description(shortDefinition = "What population?", formalDefinition = "A reference to a EvidenceVariable resource that defines the population for the research.")
  protected Reference exposureBackground;

  /**
   * The actual object that is the target of the reference (A reference to a
   * EvidenceVariable resource that defines the population for the research.)
   */
  protected EvidenceVariable exposureBackgroundTarget;

  /**
   * A reference to a EvidenceVariable resource that defines the exposure for the
   * research.
   */
  @Child(name = "exposureVariant", type = {
      EvidenceVariable.class }, order = 15, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = true)
  @Description(shortDefinition = "What exposure?", formalDefinition = "A reference to a EvidenceVariable resource that defines the exposure for the research.")
  protected List<Reference> exposureVariant;
  /**
   * The actual objects that are the target of the reference (A reference to a
   * EvidenceVariable resource that defines the exposure for the research.)
   */
  protected List<EvidenceVariable> exposureVariantTarget;

  /**
   * A reference to a EvidenceVariable resomece that defines the outcome for the
   * research.
   */
  @Child(name = "outcome", type = {
      EvidenceVariable.class }, order = 16, min = 0, max = Child.MAX_UNLIMITED, modifier = false, summary = true)
  @Description(shortDefinition = "What outcome?", formalDefinition = "A reference to a EvidenceVariable resomece that defines the outcome for the research.")
  protected List<Reference> outcome;
  /**
   * The actual objects that are the target of the reference (A reference to a
   * EvidenceVariable resomece that defines the outcome for the research.)
   */
  protected List<EvidenceVariable> outcomeTarget;

  private static final long serialVersionUID = 137844509L;

  /**
   * Constructor
   */
  public Evidence() {
    super();
  }

  /**
   * Constructor
   */
  public Evidence(Enumeration<PublicationStatus> status, Reference exposureBackground) {
    super();
    this.status = status;
    this.exposureBackground = exposureBackground;
  }

  /**
   * @return {@link #url} (An absolute URI that is used to identify this evidence
   *         when it is referenced in a specification, model, design or an
   *         instance; also called its canonical identifier. This SHOULD be
   *         globally unique and SHOULD be a literal address at which at which an
   *         authoritative instance of this evidence is (or will be) published.
   *         This URL can be the target of a canonical reference. It SHALL remain
   *         the same when the evidence is stored on different servers.). This is
   *         the underlying object with id, value and extensions. The accessor
   *         "getUrl" gives direct access to the value
   */
  public UriType getUrlElement() {
    if (this.url == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.url");
      else if (Configuration.doAutoCreate())
        this.url = new UriType(); // bb
    return this.url;
  }

  public boolean hasUrlElement() {
    return this.url != null && !this.url.isEmpty();
  }

  public boolean hasUrl() {
    return this.url != null && !this.url.isEmpty();
  }

  /**
   * @param value {@link #url} (An absolute URI that is used to identify this
   *              evidence when it is referenced in a specification, model, design
   *              or an instance; also called its canonical identifier. This
   *              SHOULD be globally unique and SHOULD be a literal address at
   *              which at which an authoritative instance of this evidence is (or
   *              will be) published. This URL can be the target of a canonical
   *              reference. It SHALL remain the same when the evidence is stored
   *              on different servers.). This is the underlying object with id,
   *              value and extensions. The accessor "getUrl" gives direct access
   *              to the value
   */
  public Evidence setUrlElement(UriType value) {
    this.url = value;
    return this;
  }

  /**
   * @return An absolute URI that is used to identify this evidence when it is
   *         referenced in a specification, model, design or an instance; also
   *         called its canonical identifier. This SHOULD be globally unique and
   *         SHOULD be a literal address at which at which an authoritative
   *         instance of this evidence is (or will be) published. This URL can be
   *         the target of a canonical reference. It SHALL remain the same when
   *         the evidence is stored on different servers.
   */
  public String getUrl() {
    return this.url == null ? null : this.url.getValue();
  }

  /**
   * @param value An absolute URI that is used to identify this evidence when it
   *              is referenced in a specification, model, design or an instance;
   *              also called its canonical identifier. This SHOULD be globally
   *              unique and SHOULD be a literal address at which at which an
   *              authoritative instance of this evidence is (or will be)
   *              published. This URL can be the target of a canonical reference.
   *              It SHALL remain the same when the evidence is stored on
   *              different servers.
   */
  public Evidence setUrl(String value) {
    if (Utilities.noString(value))
      this.url = null;
    else {
      if (this.url == null)
        this.url = new UriType();
      this.url.setValue(value);
    }
    return this;
  }

  /**
   * @return {@link #identifier} (A formal identifier that is used to identify
   *         this evidence when it is represented in other formats, or referenced
   *         in a specification, model, design or an instance.)
   */
  public List<Identifier> getIdentifier() {
    if (this.identifier == null)
      this.identifier = new ArrayList<Identifier>();
    return this.identifier;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Evidence setIdentifier(List<Identifier> theIdentifier) {
    this.identifier = theIdentifier;
    return this;
  }

  public boolean hasIdentifier() {
    if (this.identifier == null)
      return false;
    for (Identifier item : this.identifier)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public Identifier addIdentifier() { // 3
    Identifier t = new Identifier();
    if (this.identifier == null)
      this.identifier = new ArrayList<Identifier>();
    this.identifier.add(t);
    return t;
  }

  public Evidence addIdentifier(Identifier t) { // 3
    if (t == null)
      return this;
    if (this.identifier == null)
      this.identifier = new ArrayList<Identifier>();
    this.identifier.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #identifier}, creating
   *         it if it does not already exist
   */
  public Identifier getIdentifierFirstRep() {
    if (getIdentifier().isEmpty()) {
      addIdentifier();
    }
    return getIdentifier().get(0);
  }

  /**
   * @return {@link #version} (The identifier that is used to identify this
   *         version of the evidence when it is referenced in a specification,
   *         model, design or instance. This is an arbitrary value managed by the
   *         evidence author and is not expected to be globally unique. For
   *         example, it might be a timestamp (e.g. yyyymmdd) if a managed version
   *         is not available. There is also no expectation that versions can be
   *         placed in a lexicographical sequence. To provide a version consistent
   *         with the Decision Support Service specification, use the format
   *         Major.Minor.Revision (e.g. 1.0.0). For more information on versioning
   *         knowledge assets, refer to the Decision Support Service
   *         specification. Note that a version is required for non-experimental
   *         active artifacts.). This is the underlying object with id, value and
   *         extensions. The accessor "getVersion" gives direct access to the
   *         value
   */
  public StringType getVersionElement() {
    if (this.version == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.version");
      else if (Configuration.doAutoCreate())
        this.version = new StringType(); // bb
    return this.version;
  }

  public boolean hasVersionElement() {
    return this.version != null && !this.version.isEmpty();
  }

  public boolean hasVersion() {
    return this.version != null && !this.version.isEmpty();
  }

  /**
   * @param value {@link #version} (The identifier that is used to identify this
   *              version of the evidence when it is referenced in a
   *              specification, model, design or instance. This is an arbitrary
   *              value managed by the evidence author and is not expected to be
   *              globally unique. For example, it might be a timestamp (e.g.
   *              yyyymmdd) if a managed version is not available. There is also
   *              no expectation that versions can be placed in a lexicographical
   *              sequence. To provide a version consistent with the Decision
   *              Support Service specification, use the format
   *              Major.Minor.Revision (e.g. 1.0.0). For more information on
   *              versioning knowledge assets, refer to the Decision Support
   *              Service specification. Note that a version is required for
   *              non-experimental active artifacts.). This is the underlying
   *              object with id, value and extensions. The accessor "getVersion"
   *              gives direct access to the value
   */
  public Evidence setVersionElement(StringType value) {
    this.version = value;
    return this;
  }

  /**
   * @return The identifier that is used to identify this version of the evidence
   *         when it is referenced in a specification, model, design or instance.
   *         This is an arbitrary value managed by the evidence author and is not
   *         expected to be globally unique. For example, it might be a timestamp
   *         (e.g. yyyymmdd) if a managed version is not available. There is also
   *         no expectation that versions can be placed in a lexicographical
   *         sequence. To provide a version consistent with the Decision Support
   *         Service specification, use the format Major.Minor.Revision (e.g.
   *         1.0.0). For more information on versioning knowledge assets, refer to
   *         the Decision Support Service specification. Note that a version is
   *         required for non-experimental active artifacts.
   */
  public String getVersion() {
    return this.version == null ? null : this.version.getValue();
  }

  /**
   * @param value The identifier that is used to identify this version of the
   *              evidence when it is referenced in a specification, model, design
   *              or instance. This is an arbitrary value managed by the evidence
   *              author and is not expected to be globally unique. For example,
   *              it might be a timestamp (e.g. yyyymmdd) if a managed version is
   *              not available. There is also no expectation that versions can be
   *              placed in a lexicographical sequence. To provide a version
   *              consistent with the Decision Support Service specification, use
   *              the format Major.Minor.Revision (e.g. 1.0.0). For more
   *              information on versioning knowledge assets, refer to the
   *              Decision Support Service specification. Note that a version is
   *              required for non-experimental active artifacts.
   */
  public Evidence setVersion(String value) {
    if (Utilities.noString(value))
      this.version = null;
    else {
      if (this.version == null)
        this.version = new StringType();
      this.version.setValue(value);
    }
    return this;
  }

  /**
   * @return {@link #name} (A natural language name identifying the evidence. This
   *         name should be usable as an identifier for the module by machine
   *         processing applications such as code generation.). This is the
   *         underlying object with id, value and extensions. The accessor
   *         "getName" gives direct access to the value
   */
  public StringType getNameElement() {
    if (this.name == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.name");
      else if (Configuration.doAutoCreate())
        this.name = new StringType(); // bb
    return this.name;
  }

  public boolean hasNameElement() {
    return this.name != null && !this.name.isEmpty();
  }

  public boolean hasName() {
    return this.name != null && !this.name.isEmpty();
  }

  /**
   * @param value {@link #name} (A natural language name identifying the evidence.
   *              This name should be usable as an identifier for the module by
   *              machine processing applications such as code generation.). This
   *              is the underlying object with id, value and extensions. The
   *              accessor "getName" gives direct access to the value
   */
  public Evidence setNameElement(StringType value) {
    this.name = value;
    return this;
  }

  /**
   * @return A natural language name identifying the evidence. This name should be
   *         usable as an identifier for the module by machine processing
   *         applications such as code generation.
   */
  public String getName() {
    return this.name == null ? null : this.name.getValue();
  }

  /**
   * @param value A natural language name identifying the evidence. This name
   *              should be usable as an identifier for the module by machine
   *              processing applications such as code generation.
   */
  public Evidence setName(String value) {
    if (Utilities.noString(value))
      this.name = null;
    else {
      if (this.name == null)
        this.name = new StringType();
      this.name.setValue(value);
    }
    return this;
  }

  /**
   * @return {@link #title} (A short, descriptive, user-friendly title for the
   *         evidence.). This is the underlying object with id, value and
   *         extensions. The accessor "getTitle" gives direct access to the value
   */
  public StringType getTitleElement() {
    if (this.title == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.title");
      else if (Configuration.doAutoCreate())
        this.title = new StringType(); // bb
    return this.title;
  }

  public boolean hasTitleElement() {
    return this.title != null && !this.title.isEmpty();
  }

  public boolean hasTitle() {
    return this.title != null && !this.title.isEmpty();
  }

  /**
   * @param value {@link #title} (A short, descriptive, user-friendly title for
   *              the evidence.). This is the underlying object with id, value and
   *              extensions. The accessor "getTitle" gives direct access to the
   *              value
   */
  public Evidence setTitleElement(StringType value) {
    this.title = value;
    return this;
  }

  /**
   * @return A short, descriptive, user-friendly title for the evidence.
   */
  public String getTitle() {
    return this.title == null ? null : this.title.getValue();
  }

  /**
   * @param value A short, descriptive, user-friendly title for the evidence.
   */
  public Evidence setTitle(String value) {
    if (Utilities.noString(value))
      this.title = null;
    else {
      if (this.title == null)
        this.title = new StringType();
      this.title.setValue(value);
    }
    return this;
  }

  /**
   * @return {@link #shortTitle} (The short title provides an alternate title for
   *         use in informal descriptive contexts where the full, formal title is
   *         not necessary.). This is the underlying object with id, value and
   *         extensions. The accessor "getShortTitle" gives direct access to the
   *         value
   */
  public StringType getShortTitleElement() {
    if (this.shortTitle == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.shortTitle");
      else if (Configuration.doAutoCreate())
        this.shortTitle = new StringType(); // bb
    return this.shortTitle;
  }

  public boolean hasShortTitleElement() {
    return this.shortTitle != null && !this.shortTitle.isEmpty();
  }

  public boolean hasShortTitle() {
    return this.shortTitle != null && !this.shortTitle.isEmpty();
  }

  /**
   * @param value {@link #shortTitle} (The short title provides an alternate title
   *              for use in informal descriptive contexts where the full, formal
   *              title is not necessary.). This is the underlying object with id,
   *              value and extensions. The accessor "getShortTitle" gives direct
   *              access to the value
   */
  public Evidence setShortTitleElement(StringType value) {
    this.shortTitle = value;
    return this;
  }

  /**
   * @return The short title provides an alternate title for use in informal
   *         descriptive contexts where the full, formal title is not necessary.
   */
  public String getShortTitle() {
    return this.shortTitle == null ? null : this.shortTitle.getValue();
  }

  /**
   * @param value The short title provides an alternate title for use in informal
   *              descriptive contexts where the full, formal title is not
   *              necessary.
   */
  public Evidence setShortTitle(String value) {
    if (Utilities.noString(value))
      this.shortTitle = null;
    else {
      if (this.shortTitle == null)
        this.shortTitle = new StringType();
      this.shortTitle.setValue(value);
    }
    return this;
  }

  /**
   * @return {@link #subtitle} (An explanatory or alternate title for the Evidence
   *         giving additional information about its content.). This is the
   *         underlying object with id, value and extensions. The accessor
   *         "getSubtitle" gives direct access to the value
   */
  public StringType getSubtitleElement() {
    if (this.subtitle == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.subtitle");
      else if (Configuration.doAutoCreate())
        this.subtitle = new StringType(); // bb
    return this.subtitle;
  }

  public boolean hasSubtitleElement() {
    return this.subtitle != null && !this.subtitle.isEmpty();
  }

  public boolean hasSubtitle() {
    return this.subtitle != null && !this.subtitle.isEmpty();
  }

  /**
   * @param value {@link #subtitle} (An explanatory or alternate title for the
   *              Evidence giving additional information about its content.). This
   *              is the underlying object with id, value and extensions. The
   *              accessor "getSubtitle" gives direct access to the value
   */
  public Evidence setSubtitleElement(StringType value) {
    this.subtitle = value;
    return this;
  }

  /**
   * @return An explanatory or alternate title for the Evidence giving additional
   *         information about its content.
   */
  public String getSubtitle() {
    return this.subtitle == null ? null : this.subtitle.getValue();
  }

  /**
   * @param value An explanatory or alternate title for the Evidence giving
   *              additional information about its content.
   */
  public Evidence setSubtitle(String value) {
    if (Utilities.noString(value))
      this.subtitle = null;
    else {
      if (this.subtitle == null)
        this.subtitle = new StringType();
      this.subtitle.setValue(value);
    }
    return this;
  }

  /**
   * @return {@link #status} (The status of this evidence. Enables tracking the
   *         life-cycle of the content.). This is the underlying object with id,
   *         value and extensions. The accessor "getStatus" gives direct access to
   *         the value
   */
  public Enumeration<PublicationStatus> getStatusElement() {
    if (this.status == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.status");
      else if (Configuration.doAutoCreate())
        this.status = new Enumeration<PublicationStatus>(new PublicationStatusEnumFactory()); // bb
    return this.status;
  }

  public boolean hasStatusElement() {
    return this.status != null && !this.status.isEmpty();
  }

  public boolean hasStatus() {
    return this.status != null && !this.status.isEmpty();
  }

  /**
   * @param value {@link #status} (The status of this evidence. Enables tracking
   *              the life-cycle of the content.). This is the underlying object
   *              with id, value and extensions. The accessor "getStatus" gives
   *              direct access to the value
   */
  public Evidence setStatusElement(Enumeration<PublicationStatus> value) {
    this.status = value;
    return this;
  }

  /**
   * @return The status of this evidence. Enables tracking the life-cycle of the
   *         content.
   */
  public PublicationStatus getStatus() {
    return this.status == null ? null : this.status.getValue();
  }

  /**
   * @param value The status of this evidence. Enables tracking the life-cycle of
   *              the content.
   */
  public Evidence setStatus(PublicationStatus value) {
    if (this.status == null)
      this.status = new Enumeration<PublicationStatus>(new PublicationStatusEnumFactory());
    this.status.setValue(value);
    return this;
  }

  /**
   * @return {@link #date} (The date (and optionally time) when the evidence was
   *         published. The date must change when the business version changes and
   *         it must change if the status code changes. In addition, it should
   *         change when the substantive content of the evidence changes.). This
   *         is the underlying object with id, value and extensions. The accessor
   *         "getDate" gives direct access to the value
   */
  public DateTimeType getDateElement() {
    if (this.date == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.date");
      else if (Configuration.doAutoCreate())
        this.date = new DateTimeType(); // bb
    return this.date;
  }

  public boolean hasDateElement() {
    return this.date != null && !this.date.isEmpty();
  }

  public boolean hasDate() {
    return this.date != null && !this.date.isEmpty();
  }

  /**
   * @param value {@link #date} (The date (and optionally time) when the evidence
   *              was published. The date must change when the business version
   *              changes and it must change if the status code changes. In
   *              addition, it should change when the substantive content of the
   *              evidence changes.). This is the underlying object with id, value
   *              and extensions. The accessor "getDate" gives direct access to
   *              the value
   */
  public Evidence setDateElement(DateTimeType value) {
    this.date = value;
    return this;
  }

  /**
   * @return The date (and optionally time) when the evidence was published. The
   *         date must change when the business version changes and it must change
   *         if the status code changes. In addition, it should change when the
   *         substantive content of the evidence changes.
   */
  public Date getDate() {
    return this.date == null ? null : this.date.getValue();
  }

  /**
   * @param value The date (and optionally time) when the evidence was published.
   *              The date must change when the business version changes and it
   *              must change if the status code changes. In addition, it should
   *              change when the substantive content of the evidence changes.
   */
  public Evidence setDate(Date value) {
    if (value == null)
      this.date = null;
    else {
      if (this.date == null)
        this.date = new DateTimeType();
      this.date.setValue(value);
    }
    return this;
  }

  /**
   * @return {@link #publisher} (The name of the organization or individual that
   *         published the evidence.). This is the underlying object with id,
   *         value and extensions. The accessor "getPublisher" gives direct access
   *         to the value
   */
  public StringType getPublisherElement() {
    if (this.publisher == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.publisher");
      else if (Configuration.doAutoCreate())
        this.publisher = new StringType(); // bb
    return this.publisher;
  }

  public boolean hasPublisherElement() {
    return this.publisher != null && !this.publisher.isEmpty();
  }

  public boolean hasPublisher() {
    return this.publisher != null && !this.publisher.isEmpty();
  }

  /**
   * @param value {@link #publisher} (The name of the organization or individual
   *              that published the evidence.). This is the underlying object
   *              with id, value and extensions. The accessor "getPublisher" gives
   *              direct access to the value
   */
  public Evidence setPublisherElement(StringType value) {
    this.publisher = value;
    return this;
  }

  /**
   * @return The name of the organization or individual that published the
   *         evidence.
   */
  public String getPublisher() {
    return this.publisher == null ? null : this.publisher.getValue();
  }

  /**
   * @param value The name of the organization or individual that published the
   *              evidence.
   */
  public Evidence setPublisher(String value) {
    if (Utilities.noString(value))
      this.publisher = null;
    else {
      if (this.publisher == null)
        this.publisher = new StringType();
      this.publisher.setValue(value);
    }
    return this;
  }

  /**
   * @return {@link #contact} (Contact details to assist a user in finding and
   *         communicating with the publisher.)
   */
  public List<ContactDetail> getContact() {
    if (this.contact == null)
      this.contact = new ArrayList<ContactDetail>();
    return this.contact;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Evidence setContact(List<ContactDetail> theContact) {
    this.contact = theContact;
    return this;
  }

  public boolean hasContact() {
    if (this.contact == null)
      return false;
    for (ContactDetail item : this.contact)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public ContactDetail addContact() { // 3
    ContactDetail t = new ContactDetail();
    if (this.contact == null)
      this.contact = new ArrayList<ContactDetail>();
    this.contact.add(t);
    return t;
  }

  public Evidence addContact(ContactDetail t) { // 3
    if (t == null)
      return this;
    if (this.contact == null)
      this.contact = new ArrayList<ContactDetail>();
    this.contact.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #contact}, creating it
   *         if it does not already exist
   */
  public ContactDetail getContactFirstRep() {
    if (getContact().isEmpty()) {
      addContact();
    }
    return getContact().get(0);
  }

  /**
   * @return {@link #description} (A free text natural language description of the
   *         evidence from a consumer's perspective.). This is the underlying
   *         object with id, value and extensions. The accessor "getDescription"
   *         gives direct access to the value
   */
  public MarkdownType getDescriptionElement() {
    if (this.description == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.description");
      else if (Configuration.doAutoCreate())
        this.description = new MarkdownType(); // bb
    return this.description;
  }

  public boolean hasDescriptionElement() {
    return this.description != null && !this.description.isEmpty();
  }

  public boolean hasDescription() {
    return this.description != null && !this.description.isEmpty();
  }

  /**
   * @param value {@link #description} (A free text natural language description
   *              of the evidence from a consumer's perspective.). This is the
   *              underlying object with id, value and extensions. The accessor
   *              "getDescription" gives direct access to the value
   */
  public Evidence setDescriptionElement(MarkdownType value) {
    this.description = value;
    return this;
  }

  /**
   * @return A free text natural language description of the evidence from a
   *         consumer's perspective.
   */
  public String getDescription() {
    return this.description == null ? null : this.description.getValue();
  }

  /**
   * @param value A free text natural language description of the evidence from a
   *              consumer's perspective.
   */
  public Evidence setDescription(String value) {
    if (value == null)
      this.description = null;
    else {
      if (this.description == null)
        this.description = new MarkdownType();
      this.description.setValue(value);
    }
    return this;
  }

  /**
   * @return {@link #note} (A human-readable string to clarify or explain concepts
   *         about the resource.)
   */
  public List<Annotation> getNote() {
    if (this.note == null)
      this.note = new ArrayList<Annotation>();
    return this.note;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Evidence setNote(List<Annotation> theNote) {
    this.note = theNote;
    return this;
  }

  public boolean hasNote() {
    if (this.note == null)
      return false;
    for (Annotation item : this.note)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public Annotation addNote() { // 3
    Annotation t = new Annotation();
    if (this.note == null)
      this.note = new ArrayList<Annotation>();
    this.note.add(t);
    return t;
  }

  public Evidence addNote(Annotation t) { // 3
    if (t == null)
      return this;
    if (this.note == null)
      this.note = new ArrayList<Annotation>();
    this.note.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #note}, creating it if
   *         it does not already exist
   */
  public Annotation getNoteFirstRep() {
    if (getNote().isEmpty()) {
      addNote();
    }
    return getNote().get(0);
  }

  /**
   * @return {@link #useContext} (The content was developed with a focus and
   *         intent of supporting the contexts that are listed. These contexts may
   *         be general categories (gender, age, ...) or may be references to
   *         specific programs (insurance plans, studies, ...) and may be used to
   *         assist with indexing and searching for appropriate evidence
   *         instances.)
   */
  public List<UsageContext> getUseContext() {
    if (this.useContext == null)
      this.useContext = new ArrayList<UsageContext>();
    return this.useContext;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Evidence setUseContext(List<UsageContext> theUseContext) {
    this.useContext = theUseContext;
    return this;
  }

  public boolean hasUseContext() {
    if (this.useContext == null)
      return false;
    for (UsageContext item : this.useContext)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public UsageContext addUseContext() { // 3
    UsageContext t = new UsageContext();
    if (this.useContext == null)
      this.useContext = new ArrayList<UsageContext>();
    this.useContext.add(t);
    return t;
  }

  public Evidence addUseContext(UsageContext t) { // 3
    if (t == null)
      return this;
    if (this.useContext == null)
      this.useContext = new ArrayList<UsageContext>();
    this.useContext.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #useContext}, creating
   *         it if it does not already exist
   */
  public UsageContext getUseContextFirstRep() {
    if (getUseContext().isEmpty()) {
      addUseContext();
    }
    return getUseContext().get(0);
  }

  /**
   * @return {@link #jurisdiction} (A legal or geographic region in which the
   *         evidence is intended to be used.)
   */
  public List<CodeableConcept> getJurisdiction() {
    if (this.jurisdiction == null)
      this.jurisdiction = new ArrayList<CodeableConcept>();
    return this.jurisdiction;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Evidence setJurisdiction(List<CodeableConcept> theJurisdiction) {
    this.jurisdiction = theJurisdiction;
    return this;
  }

  public boolean hasJurisdiction() {
    if (this.jurisdiction == null)
      return false;
    for (CodeableConcept item : this.jurisdiction)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public CodeableConcept addJurisdiction() { // 3
    CodeableConcept t = new CodeableConcept();
    if (this.jurisdiction == null)
      this.jurisdiction = new ArrayList<CodeableConcept>();
    this.jurisdiction.add(t);
    return t;
  }

  public Evidence addJurisdiction(CodeableConcept t) { // 3
    if (t == null)
      return this;
    if (this.jurisdiction == null)
      this.jurisdiction = new ArrayList<CodeableConcept>();
    this.jurisdiction.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #jurisdiction},
   *         creating it if it does not already exist
   */
  public CodeableConcept getJurisdictionFirstRep() {
    if (getJurisdiction().isEmpty()) {
      addJurisdiction();
    }
    return getJurisdiction().get(0);
  }

  /**
   * @return {@link #copyright} (A copyright statement relating to the evidence
   *         and/or its contents. Copyright statements are generally legal
   *         restrictions on the use and publishing of the evidence.). This is the
   *         underlying object with id, value and extensions. The accessor
   *         "getCopyright" gives direct access to the value
   */
  public MarkdownType getCopyrightElement() {
    if (this.copyright == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.copyright");
      else if (Configuration.doAutoCreate())
        this.copyright = new MarkdownType(); // bb
    return this.copyright;
  }

  public boolean hasCopyrightElement() {
    return this.copyright != null && !this.copyright.isEmpty();
  }

  public boolean hasCopyright() {
    return this.copyright != null && !this.copyright.isEmpty();
  }

  /**
   * @param value {@link #copyright} (A copyright statement relating to the
   *              evidence and/or its contents. Copyright statements are generally
   *              legal restrictions on the use and publishing of the evidence.).
   *              This is the underlying object with id, value and extensions. The
   *              accessor "getCopyright" gives direct access to the value
   */
  public Evidence setCopyrightElement(MarkdownType value) {
    this.copyright = value;
    return this;
  }

  /**
   * @return A copyright statement relating to the evidence and/or its contents.
   *         Copyright statements are generally legal restrictions on the use and
   *         publishing of the evidence.
   */
  public String getCopyright() {
    return this.copyright == null ? null : this.copyright.getValue();
  }

  /**
   * @param value A copyright statement relating to the evidence and/or its
   *              contents. Copyright statements are generally legal restrictions
   *              on the use and publishing of the evidence.
   */
  public Evidence setCopyright(String value) {
    if (value == null)
      this.copyright = null;
    else {
      if (this.copyright == null)
        this.copyright = new MarkdownType();
      this.copyright.setValue(value);
    }
    return this;
  }

  /**
   * @return {@link #approvalDate} (The date on which the resource content was
   *         approved by the publisher. Approval happens once when the content is
   *         officially approved for usage.). This is the underlying object with
   *         id, value and extensions. The accessor "getApprovalDate" gives direct
   *         access to the value
   */
  public DateType getApprovalDateElement() {
    if (this.approvalDate == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.approvalDate");
      else if (Configuration.doAutoCreate())
        this.approvalDate = new DateType(); // bb
    return this.approvalDate;
  }

  public boolean hasApprovalDateElement() {
    return this.approvalDate != null && !this.approvalDate.isEmpty();
  }

  public boolean hasApprovalDate() {
    return this.approvalDate != null && !this.approvalDate.isEmpty();
  }

  /**
   * @param value {@link #approvalDate} (The date on which the resource content
   *              was approved by the publisher. Approval happens once when the
   *              content is officially approved for usage.). This is the
   *              underlying object with id, value and extensions. The accessor
   *              "getApprovalDate" gives direct access to the value
   */
  public Evidence setApprovalDateElement(DateType value) {
    this.approvalDate = value;
    return this;
  }

  /**
   * @return The date on which the resource content was approved by the publisher.
   *         Approval happens once when the content is officially approved for
   *         usage.
   */
  public Date getApprovalDate() {
    return this.approvalDate == null ? null : this.approvalDate.getValue();
  }

  /**
   * @param value The date on which the resource content was approved by the
   *              publisher. Approval happens once when the content is officially
   *              approved for usage.
   */
  public Evidence setApprovalDate(Date value) {
    if (value == null)
      this.approvalDate = null;
    else {
      if (this.approvalDate == null)
        this.approvalDate = new DateType();
      this.approvalDate.setValue(value);
    }
    return this;
  }

  /**
   * @return {@link #lastReviewDate} (The date on which the resource content was
   *         last reviewed. Review happens periodically after approval but does
   *         not change the original approval date.). This is the underlying
   *         object with id, value and extensions. The accessor
   *         "getLastReviewDate" gives direct access to the value
   */
  public DateType getLastReviewDateElement() {
    if (this.lastReviewDate == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.lastReviewDate");
      else if (Configuration.doAutoCreate())
        this.lastReviewDate = new DateType(); // bb
    return this.lastReviewDate;
  }

  public boolean hasLastReviewDateElement() {
    return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
  }

  public boolean hasLastReviewDate() {
    return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
  }

  /**
   * @param value {@link #lastReviewDate} (The date on which the resource content
   *              was last reviewed. Review happens periodically after approval
   *              but does not change the original approval date.). This is the
   *              underlying object with id, value and extensions. The accessor
   *              "getLastReviewDate" gives direct access to the value
   */
  public Evidence setLastReviewDateElement(DateType value) {
    this.lastReviewDate = value;
    return this;
  }

  /**
   * @return The date on which the resource content was last reviewed. Review
   *         happens periodically after approval but does not change the original
   *         approval date.
   */
  public Date getLastReviewDate() {
    return this.lastReviewDate == null ? null : this.lastReviewDate.getValue();
  }

  /**
   * @param value The date on which the resource content was last reviewed. Review
   *              happens periodically after approval but does not change the
   *              original approval date.
   */
  public Evidence setLastReviewDate(Date value) {
    if (value == null)
      this.lastReviewDate = null;
    else {
      if (this.lastReviewDate == null)
        this.lastReviewDate = new DateType();
      this.lastReviewDate.setValue(value);
    }
    return this;
  }

  /**
   * @return {@link #effectivePeriod} (The period during which the evidence
   *         content was or is planned to be in active use.)
   */
  public Period getEffectivePeriod() {
    if (this.effectivePeriod == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.effectivePeriod");
      else if (Configuration.doAutoCreate())
        this.effectivePeriod = new Period(); // cc
    return this.effectivePeriod;
  }

  public boolean hasEffectivePeriod() {
    return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
  }

  /**
   * @param value {@link #effectivePeriod} (The period during which the evidence
   *              content was or is planned to be in active use.)
   */
  public Evidence setEffectivePeriod(Period value) {
    this.effectivePeriod = value;
    return this;
  }

  /**
   * @return {@link #topic} (Descriptive topics related to the content of the
   *         Evidence. Topics provide a high-level categorization grouping types
   *         of Evidences that can be useful for filtering and searching.)
   */
  public List<CodeableConcept> getTopic() {
    if (this.topic == null)
      this.topic = new ArrayList<CodeableConcept>();
    return this.topic;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Evidence setTopic(List<CodeableConcept> theTopic) {
    this.topic = theTopic;
    return this;
  }

  public boolean hasTopic() {
    if (this.topic == null)
      return false;
    for (CodeableConcept item : this.topic)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public CodeableConcept addTopic() { // 3
    CodeableConcept t = new CodeableConcept();
    if (this.topic == null)
      this.topic = new ArrayList<CodeableConcept>();
    this.topic.add(t);
    return t;
  }

  public Evidence addTopic(CodeableConcept t) { // 3
    if (t == null)
      return this;
    if (this.topic == null)
      this.topic = new ArrayList<CodeableConcept>();
    this.topic.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #topic}, creating it
   *         if it does not already exist
   */
  public CodeableConcept getTopicFirstRep() {
    if (getTopic().isEmpty()) {
      addTopic();
    }
    return getTopic().get(0);
  }

  /**
   * @return {@link #author} (An individiual or organization primarily involved in
   *         the creation and maintenance of the content.)
   */
  public List<ContactDetail> getAuthor() {
    if (this.author == null)
      this.author = new ArrayList<ContactDetail>();
    return this.author;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Evidence setAuthor(List<ContactDetail> theAuthor) {
    this.author = theAuthor;
    return this;
  }

  public boolean hasAuthor() {
    if (this.author == null)
      return false;
    for (ContactDetail item : this.author)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public ContactDetail addAuthor() { // 3
    ContactDetail t = new ContactDetail();
    if (this.author == null)
      this.author = new ArrayList<ContactDetail>();
    this.author.add(t);
    return t;
  }

  public Evidence addAuthor(ContactDetail t) { // 3
    if (t == null)
      return this;
    if (this.author == null)
      this.author = new ArrayList<ContactDetail>();
    this.author.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #author}, creating it
   *         if it does not already exist
   */
  public ContactDetail getAuthorFirstRep() {
    if (getAuthor().isEmpty()) {
      addAuthor();
    }
    return getAuthor().get(0);
  }

  /**
   * @return {@link #editor} (An individual or organization primarily responsible
   *         for internal coherence of the content.)
   */
  public List<ContactDetail> getEditor() {
    if (this.editor == null)
      this.editor = new ArrayList<ContactDetail>();
    return this.editor;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Evidence setEditor(List<ContactDetail> theEditor) {
    this.editor = theEditor;
    return this;
  }

  public boolean hasEditor() {
    if (this.editor == null)
      return false;
    for (ContactDetail item : this.editor)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public ContactDetail addEditor() { // 3
    ContactDetail t = new ContactDetail();
    if (this.editor == null)
      this.editor = new ArrayList<ContactDetail>();
    this.editor.add(t);
    return t;
  }

  public Evidence addEditor(ContactDetail t) { // 3
    if (t == null)
      return this;
    if (this.editor == null)
      this.editor = new ArrayList<ContactDetail>();
    this.editor.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #editor}, creating it
   *         if it does not already exist
   */
  public ContactDetail getEditorFirstRep() {
    if (getEditor().isEmpty()) {
      addEditor();
    }
    return getEditor().get(0);
  }

  /**
   * @return {@link #reviewer} (An individual or organization primarily
   *         responsible for review of some aspect of the content.)
   */
  public List<ContactDetail> getReviewer() {
    if (this.reviewer == null)
      this.reviewer = new ArrayList<ContactDetail>();
    return this.reviewer;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Evidence setReviewer(List<ContactDetail> theReviewer) {
    this.reviewer = theReviewer;
    return this;
  }

  public boolean hasReviewer() {
    if (this.reviewer == null)
      return false;
    for (ContactDetail item : this.reviewer)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public ContactDetail addReviewer() { // 3
    ContactDetail t = new ContactDetail();
    if (this.reviewer == null)
      this.reviewer = new ArrayList<ContactDetail>();
    this.reviewer.add(t);
    return t;
  }

  public Evidence addReviewer(ContactDetail t) { // 3
    if (t == null)
      return this;
    if (this.reviewer == null)
      this.reviewer = new ArrayList<ContactDetail>();
    this.reviewer.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #reviewer}, creating
   *         it if it does not already exist
   */
  public ContactDetail getReviewerFirstRep() {
    if (getReviewer().isEmpty()) {
      addReviewer();
    }
    return getReviewer().get(0);
  }

  /**
   * @return {@link #endorser} (An individual or organization responsible for
   *         officially endorsing the content for use in some setting.)
   */
  public List<ContactDetail> getEndorser() {
    if (this.endorser == null)
      this.endorser = new ArrayList<ContactDetail>();
    return this.endorser;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Evidence setEndorser(List<ContactDetail> theEndorser) {
    this.endorser = theEndorser;
    return this;
  }

  public boolean hasEndorser() {
    if (this.endorser == null)
      return false;
    for (ContactDetail item : this.endorser)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public ContactDetail addEndorser() { // 3
    ContactDetail t = new ContactDetail();
    if (this.endorser == null)
      this.endorser = new ArrayList<ContactDetail>();
    this.endorser.add(t);
    return t;
  }

  public Evidence addEndorser(ContactDetail t) { // 3
    if (t == null)
      return this;
    if (this.endorser == null)
      this.endorser = new ArrayList<ContactDetail>();
    this.endorser.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #endorser}, creating
   *         it if it does not already exist
   */
  public ContactDetail getEndorserFirstRep() {
    if (getEndorser().isEmpty()) {
      addEndorser();
    }
    return getEndorser().get(0);
  }

  /**
   * @return {@link #relatedArtifact} (Related artifacts such as additional
   *         documentation, justification, or bibliographic references.)
   */
  public List<RelatedArtifact> getRelatedArtifact() {
    if (this.relatedArtifact == null)
      this.relatedArtifact = new ArrayList<RelatedArtifact>();
    return this.relatedArtifact;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Evidence setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
    this.relatedArtifact = theRelatedArtifact;
    return this;
  }

  public boolean hasRelatedArtifact() {
    if (this.relatedArtifact == null)
      return false;
    for (RelatedArtifact item : this.relatedArtifact)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public RelatedArtifact addRelatedArtifact() { // 3
    RelatedArtifact t = new RelatedArtifact();
    if (this.relatedArtifact == null)
      this.relatedArtifact = new ArrayList<RelatedArtifact>();
    this.relatedArtifact.add(t);
    return t;
  }

  public Evidence addRelatedArtifact(RelatedArtifact t) { // 3
    if (t == null)
      return this;
    if (this.relatedArtifact == null)
      this.relatedArtifact = new ArrayList<RelatedArtifact>();
    this.relatedArtifact.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #relatedArtifact},
   *         creating it if it does not already exist
   */
  public RelatedArtifact getRelatedArtifactFirstRep() {
    if (getRelatedArtifact().isEmpty()) {
      addRelatedArtifact();
    }
    return getRelatedArtifact().get(0);
  }

  /**
   * @return {@link #exposureBackground} (A reference to a EvidenceVariable
   *         resource that defines the population for the research.)
   */
  public Reference getExposureBackground() {
    if (this.exposureBackground == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.exposureBackground");
      else if (Configuration.doAutoCreate())
        this.exposureBackground = new Reference(); // cc
    return this.exposureBackground;
  }

  public boolean hasExposureBackground() {
    return this.exposureBackground != null && !this.exposureBackground.isEmpty();
  }

  /**
   * @param value {@link #exposureBackground} (A reference to a EvidenceVariable
   *              resource that defines the population for the research.)
   */
  public Evidence setExposureBackground(Reference value) {
    this.exposureBackground = value;
    return this;
  }

  /**
   * @return {@link #exposureBackground} The actual object that is the target of
   *         the reference. The reference library doesn't populate this, but you
   *         can use it to hold the resource if you resolve it. (A reference to a
   *         EvidenceVariable resource that defines the population for the
   *         research.)
   */
  public EvidenceVariable getExposureBackgroundTarget() {
    if (this.exposureBackgroundTarget == null)
      if (Configuration.errorOnAutoCreate())
        throw new Error("Attempt to auto-create Evidence.exposureBackground");
      else if (Configuration.doAutoCreate())
        this.exposureBackgroundTarget = new EvidenceVariable(); // aa
    return this.exposureBackgroundTarget;
  }

  /**
   * @param value {@link #exposureBackground} The actual object that is the target
   *              of the reference. The reference library doesn't use these, but
   *              you can use it to hold the resource if you resolve it. (A
   *              reference to a EvidenceVariable resource that defines the
   *              population for the research.)
   */
  public Evidence setExposureBackgroundTarget(EvidenceVariable value) {
    this.exposureBackgroundTarget = value;
    return this;
  }

  /**
   * @return {@link #exposureVariant} (A reference to a EvidenceVariable resource
   *         that defines the exposure for the research.)
   */
  public List<Reference> getExposureVariant() {
    if (this.exposureVariant == null)
      this.exposureVariant = new ArrayList<Reference>();
    return this.exposureVariant;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Evidence setExposureVariant(List<Reference> theExposureVariant) {
    this.exposureVariant = theExposureVariant;
    return this;
  }

  public boolean hasExposureVariant() {
    if (this.exposureVariant == null)
      return false;
    for (Reference item : this.exposureVariant)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public Reference addExposureVariant() { // 3
    Reference t = new Reference();
    if (this.exposureVariant == null)
      this.exposureVariant = new ArrayList<Reference>();
    this.exposureVariant.add(t);
    return t;
  }

  public Evidence addExposureVariant(Reference t) { // 3
    if (t == null)
      return this;
    if (this.exposureVariant == null)
      this.exposureVariant = new ArrayList<Reference>();
    this.exposureVariant.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #exposureVariant},
   *         creating it if it does not already exist
   */
  public Reference getExposureVariantFirstRep() {
    if (getExposureVariant().isEmpty()) {
      addExposureVariant();
    }
    return getExposureVariant().get(0);
  }

  /**
   * @deprecated Use Reference#setResource(IBaseResource) instead
   */
  @Deprecated
  public List<EvidenceVariable> getExposureVariantTarget() {
    if (this.exposureVariantTarget == null)
      this.exposureVariantTarget = new ArrayList<EvidenceVariable>();
    return this.exposureVariantTarget;
  }

  /**
   * @deprecated Use Reference#setResource(IBaseResource) instead
   */
  @Deprecated
  public EvidenceVariable addExposureVariantTarget() {
    EvidenceVariable r = new EvidenceVariable();
    if (this.exposureVariantTarget == null)
      this.exposureVariantTarget = new ArrayList<EvidenceVariable>();
    this.exposureVariantTarget.add(r);
    return r;
  }

  /**
   * @return {@link #outcome} (A reference to a EvidenceVariable resomece that
   *         defines the outcome for the research.)
   */
  public List<Reference> getOutcome() {
    if (this.outcome == null)
      this.outcome = new ArrayList<Reference>();
    return this.outcome;
  }

  /**
   * @return Returns a reference to <code>this</code> for easy method chaining
   */
  public Evidence setOutcome(List<Reference> theOutcome) {
    this.outcome = theOutcome;
    return this;
  }

  public boolean hasOutcome() {
    if (this.outcome == null)
      return false;
    for (Reference item : this.outcome)
      if (!item.isEmpty())
        return true;
    return false;
  }

  public Reference addOutcome() { // 3
    Reference t = new Reference();
    if (this.outcome == null)
      this.outcome = new ArrayList<Reference>();
    this.outcome.add(t);
    return t;
  }

  public Evidence addOutcome(Reference t) { // 3
    if (t == null)
      return this;
    if (this.outcome == null)
      this.outcome = new ArrayList<Reference>();
    this.outcome.add(t);
    return this;
  }

  /**
   * @return The first repetition of repeating field {@link #outcome}, creating it
   *         if it does not already exist
   */
  public Reference getOutcomeFirstRep() {
    if (getOutcome().isEmpty()) {
      addOutcome();
    }
    return getOutcome().get(0);
  }

  /**
   * @deprecated Use Reference#setResource(IBaseResource) instead
   */
  @Deprecated
  public List<EvidenceVariable> getOutcomeTarget() {
    if (this.outcomeTarget == null)
      this.outcomeTarget = new ArrayList<EvidenceVariable>();
    return this.outcomeTarget;
  }

  /**
   * @deprecated Use Reference#setResource(IBaseResource) instead
   */
  @Deprecated
  public EvidenceVariable addOutcomeTarget() {
    EvidenceVariable r = new EvidenceVariable();
    if (this.outcomeTarget == null)
      this.outcomeTarget = new ArrayList<EvidenceVariable>();
    this.outcomeTarget.add(r);
    return r;
  }

  protected void listChildren(List<Property> children) {
    super.listChildren(children);
    children.add(new Property("url", "uri",
        "An absolute URI that is used to identify this evidence when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this evidence is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the evidence is stored on different servers.",
        0, 1, url));
    children.add(new Property("identifier", "Identifier",
        "A formal identifier that is used to identify this evidence when it is represented in other formats, or referenced in a specification, model, design or an instance.",
        0, java.lang.Integer.MAX_VALUE, identifier));
    children.add(new Property("version", "string",
        "The identifier that is used to identify this version of the evidence when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the evidence author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.",
        0, 1, version));
    children.add(new Property("name", "string",
        "A natural language name identifying the evidence. This name should be usable as an identifier for the module by machine processing applications such as code generation.",
        0, 1, name));
    children.add(
        new Property("title", "string", "A short, descriptive, user-friendly title for the evidence.", 0, 1, title));
    children.add(new Property("shortTitle", "string",
        "The short title provides an alternate title for use in informal descriptive contexts where the full, formal title is not necessary.",
        0, 1, shortTitle));
    children.add(new Property("subtitle", "string",
        "An explanatory or alternate title for the Evidence giving additional information about its content.", 0, 1,
        subtitle));
    children.add(new Property("status", "code",
        "The status of this evidence. Enables tracking the life-cycle of the content.", 0, 1, status));
    children.add(new Property("date", "dateTime",
        "The date  (and optionally time) when the evidence was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the evidence changes.",
        0, 1, date));
    children.add(new Property("publisher", "string",
        "The name of the organization or individual that published the evidence.", 0, 1, publisher));
    children.add(new Property("contact", "ContactDetail",
        "Contact details to assist a user in finding and communicating with the publisher.", 0,
        java.lang.Integer.MAX_VALUE, contact));
    children.add(new Property("description", "markdown",
        "A free text natural language description of the evidence from a consumer's perspective.", 0, 1, description));
    children.add(
        new Property("note", "Annotation", "A human-readable string to clarify or explain concepts about the resource.",
            0, java.lang.Integer.MAX_VALUE, note));
    children.add(new Property("useContext", "UsageContext",
        "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence instances.",
        0, java.lang.Integer.MAX_VALUE, useContext));
    children.add(new Property("jurisdiction", "CodeableConcept",
        "A legal or geographic region in which the evidence is intended to be used.", 0, java.lang.Integer.MAX_VALUE,
        jurisdiction));
    children.add(new Property("copyright", "markdown",
        "A copyright statement relating to the evidence and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the evidence.",
        0, 1, copyright));
    children.add(new Property("approvalDate", "date",
        "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.",
        0, 1, approvalDate));
    children.add(new Property("lastReviewDate", "date",
        "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.",
        0, 1, lastReviewDate));
    children.add(new Property("effectivePeriod", "Period",
        "The period during which the evidence content was or is planned to be in active use.", 0, 1, effectivePeriod));
    children.add(new Property("topic", "CodeableConcept",
        "Descriptive topics related to the content of the Evidence. Topics provide a high-level categorization grouping types of Evidences that can be useful for filtering and searching.",
        0, java.lang.Integer.MAX_VALUE, topic));
    children.add(new Property("author", "ContactDetail",
        "An individiual or organization primarily involved in the creation and maintenance of the content.", 0,
        java.lang.Integer.MAX_VALUE, author));
    children.add(new Property("editor", "ContactDetail",
        "An individual or organization primarily responsible for internal coherence of the content.", 0,
        java.lang.Integer.MAX_VALUE, editor));
    children.add(new Property("reviewer", "ContactDetail",
        "An individual or organization primarily responsible for review of some aspect of the content.", 0,
        java.lang.Integer.MAX_VALUE, reviewer));
    children.add(new Property("endorser", "ContactDetail",
        "An individual or organization responsible for officially endorsing the content for use in some setting.", 0,
        java.lang.Integer.MAX_VALUE, endorser));
    children.add(new Property("relatedArtifact", "RelatedArtifact",
        "Related artifacts such as additional documentation, justification, or bibliographic references.", 0,
        java.lang.Integer.MAX_VALUE, relatedArtifact));
    children.add(new Property("exposureBackground", "Reference(EvidenceVariable)",
        "A reference to a EvidenceVariable resource that defines the population for the research.", 0, 1,
        exposureBackground));
    children.add(new Property("exposureVariant", "Reference(EvidenceVariable)",
        "A reference to a EvidenceVariable resource that defines the exposure for the research.", 0,
        java.lang.Integer.MAX_VALUE, exposureVariant));
    children.add(new Property("outcome", "Reference(EvidenceVariable)",
        "A reference to a EvidenceVariable resomece that defines the outcome for the research.", 0,
        java.lang.Integer.MAX_VALUE, outcome));
  }

  @Override
  public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
    switch (_hash) {
    case 116079:
      /* url */ return new Property("url", "uri",
          "An absolute URI that is used to identify this evidence when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this evidence is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the evidence is stored on different servers.",
          0, 1, url);
    case -1618432855:
      /* identifier */ return new Property("identifier", "Identifier",
          "A formal identifier that is used to identify this evidence when it is represented in other formats, or referenced in a specification, model, design or an instance.",
          0, java.lang.Integer.MAX_VALUE, identifier);
    case 351608024:
      /* version */ return new Property("version", "string",
          "The identifier that is used to identify this version of the evidence when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the evidence author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.",
          0, 1, version);
    case 3373707:
      /* name */ return new Property("name", "string",
          "A natural language name identifying the evidence. This name should be usable as an identifier for the module by machine processing applications such as code generation.",
          0, 1, name);
    case 110371416:
      /* title */ return new Property("title", "string", "A short, descriptive, user-friendly title for the evidence.",
          0, 1, title);
    case 1555503932:
      /* shortTitle */ return new Property("shortTitle", "string",
          "The short title provides an alternate title for use in informal descriptive contexts where the full, formal title is not necessary.",
          0, 1, shortTitle);
    case -2060497896:
      /* subtitle */ return new Property("subtitle", "string",
          "An explanatory or alternate title for the Evidence giving additional information about its content.", 0, 1,
          subtitle);
    case -892481550:
      /* status */ return new Property("status", "code",
          "The status of this evidence. Enables tracking the life-cycle of the content.", 0, 1, status);
    case 3076014:
      /* date */ return new Property("date", "dateTime",
          "The date  (and optionally time) when the evidence was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the evidence changes.",
          0, 1, date);
    case 1447404028:
      /* publisher */ return new Property("publisher", "string",
          "The name of the organization or individual that published the evidence.", 0, 1, publisher);
    case 951526432:
      /* contact */ return new Property("contact", "ContactDetail",
          "Contact details to assist a user in finding and communicating with the publisher.", 0,
          java.lang.Integer.MAX_VALUE, contact);
    case -1724546052:
      /* description */ return new Property("description", "markdown",
          "A free text natural language description of the evidence from a consumer's perspective.", 0, 1, description);
    case 3387378:
      /* note */ return new Property("note", "Annotation",
          "A human-readable string to clarify or explain concepts about the resource.", 0, java.lang.Integer.MAX_VALUE,
          note);
    case -669707736:
      /* useContext */ return new Property("useContext", "UsageContext",
          "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate evidence instances.",
          0, java.lang.Integer.MAX_VALUE, useContext);
    case -507075711:
      /* jurisdiction */ return new Property("jurisdiction", "CodeableConcept",
          "A legal or geographic region in which the evidence is intended to be used.", 0, java.lang.Integer.MAX_VALUE,
          jurisdiction);
    case 1522889671:
      /* copyright */ return new Property("copyright", "markdown",
          "A copyright statement relating to the evidence and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the evidence.",
          0, 1, copyright);
    case 223539345:
      /* approvalDate */ return new Property("approvalDate", "date",
          "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.",
          0, 1, approvalDate);
    case -1687512484:
      /* lastReviewDate */ return new Property("lastReviewDate", "date",
          "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.",
          0, 1, lastReviewDate);
    case -403934648:
      /* effectivePeriod */ return new Property("effectivePeriod", "Period",
          "The period during which the evidence content was or is planned to be in active use.", 0, 1, effectivePeriod);
    case 110546223:
      /* topic */ return new Property("topic", "CodeableConcept",
          "Descriptive topics related to the content of the Evidence. Topics provide a high-level categorization grouping types of Evidences that can be useful for filtering and searching.",
          0, java.lang.Integer.MAX_VALUE, topic);
    case -1406328437:
      /* author */ return new Property("author", "ContactDetail",
          "An individiual or organization primarily involved in the creation and maintenance of the content.", 0,
          java.lang.Integer.MAX_VALUE, author);
    case -1307827859:
      /* editor */ return new Property("editor", "ContactDetail",
          "An individual or organization primarily responsible for internal coherence of the content.", 0,
          java.lang.Integer.MAX_VALUE, editor);
    case -261190139:
      /* reviewer */ return new Property("reviewer", "ContactDetail",
          "An individual or organization primarily responsible for review of some aspect of the content.", 0,
          java.lang.Integer.MAX_VALUE, reviewer);
    case 1740277666:
      /* endorser */ return new Property("endorser", "ContactDetail",
          "An individual or organization responsible for officially endorsing the content for use in some setting.", 0,
          java.lang.Integer.MAX_VALUE, endorser);
    case 666807069:
      /* relatedArtifact */ return new Property("relatedArtifact", "RelatedArtifact",
          "Related artifacts such as additional documentation, justification, or bibliographic references.", 0,
          java.lang.Integer.MAX_VALUE, relatedArtifact);
    case -832155243:
      /* exposureBackground */ return new Property("exposureBackground", "Reference(EvidenceVariable)",
          "A reference to a EvidenceVariable resource that defines the population for the research.", 0, 1,
          exposureBackground);
    case -19675778:
      /* exposureVariant */ return new Property("exposureVariant", "Reference(EvidenceVariable)",
          "A reference to a EvidenceVariable resource that defines the exposure for the research.", 0,
          java.lang.Integer.MAX_VALUE, exposureVariant);
    case -1106507950:
      /* outcome */ return new Property("outcome", "Reference(EvidenceVariable)",
          "A reference to a EvidenceVariable resomece that defines the outcome for the research.", 0,
          java.lang.Integer.MAX_VALUE, outcome);
    default:
      return super.getNamedProperty(_hash, _name, _checkValid);
    }

  }

  @Override
  public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
    switch (hash) {
    case 116079:
      /* url */ return this.url == null ? new Base[0] : new Base[] { this.url }; // UriType
    case -1618432855:
      /* identifier */ return this.identifier == null ? new Base[0]
          : this.identifier.toArray(new Base[this.identifier.size()]); // Identifier
    case 351608024:
      /* version */ return this.version == null ? new Base[0] : new Base[] { this.version }; // StringType
    case 3373707:
      /* name */ return this.name == null ? new Base[0] : new Base[] { this.name }; // StringType
    case 110371416:
      /* title */ return this.title == null ? new Base[0] : new Base[] { this.title }; // StringType
    case 1555503932:
      /* shortTitle */ return this.shortTitle == null ? new Base[0] : new Base[] { this.shortTitle }; // StringType
    case -2060497896:
      /* subtitle */ return this.subtitle == null ? new Base[0] : new Base[] { this.subtitle }; // StringType
    case -892481550:
      /* status */ return this.status == null ? new Base[0] : new Base[] { this.status }; // Enumeration<PublicationStatus>
    case 3076014:
      /* date */ return this.date == null ? new Base[0] : new Base[] { this.date }; // DateTimeType
    case 1447404028:
      /* publisher */ return this.publisher == null ? new Base[0] : new Base[] { this.publisher }; // StringType
    case 951526432:
      /* contact */ return this.contact == null ? new Base[0] : this.contact.toArray(new Base[this.contact.size()]); // ContactDetail
    case -1724546052:
      /* description */ return this.description == null ? new Base[0] : new Base[] { this.description }; // MarkdownType
    case 3387378:
      /* note */ return this.note == null ? new Base[0] : this.note.toArray(new Base[this.note.size()]); // Annotation
    case -669707736:
      /* useContext */ return this.useContext == null ? new Base[0]
          : this.useContext.toArray(new Base[this.useContext.size()]); // UsageContext
    case -507075711:
      /* jurisdiction */ return this.jurisdiction == null ? new Base[0]
          : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]); // CodeableConcept
    case 1522889671:
      /* copyright */ return this.copyright == null ? new Base[0] : new Base[] { this.copyright }; // MarkdownType
    case 223539345:
      /* approvalDate */ return this.approvalDate == null ? new Base[0] : new Base[] { this.approvalDate }; // DateType
    case -1687512484:
      /* lastReviewDate */ return this.lastReviewDate == null ? new Base[0] : new Base[] { this.lastReviewDate }; // DateType
    case -403934648:
      /* effectivePeriod */ return this.effectivePeriod == null ? new Base[0] : new Base[] { this.effectivePeriod }; // Period
    case 110546223:
      /* topic */ return this.topic == null ? new Base[0] : this.topic.toArray(new Base[this.topic.size()]); // CodeableConcept
    case -1406328437:
      /* author */ return this.author == null ? new Base[0] : this.author.toArray(new Base[this.author.size()]); // ContactDetail
    case -1307827859:
      /* editor */ return this.editor == null ? new Base[0] : this.editor.toArray(new Base[this.editor.size()]); // ContactDetail
    case -261190139:
      /* reviewer */ return this.reviewer == null ? new Base[0] : this.reviewer.toArray(new Base[this.reviewer.size()]); // ContactDetail
    case 1740277666:
      /* endorser */ return this.endorser == null ? new Base[0] : this.endorser.toArray(new Base[this.endorser.size()]); // ContactDetail
    case 666807069:
      /* relatedArtifact */ return this.relatedArtifact == null ? new Base[0]
          : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]); // RelatedArtifact
    case -832155243:
      /* exposureBackground */ return this.exposureBackground == null ? new Base[0]
          : new Base[] { this.exposureBackground }; // Reference
    case -19675778:
      /* exposureVariant */ return this.exposureVariant == null ? new Base[0]
          : this.exposureVariant.toArray(new Base[this.exposureVariant.size()]); // Reference
    case -1106507950:
      /* outcome */ return this.outcome == null ? new Base[0] : this.outcome.toArray(new Base[this.outcome.size()]); // Reference
    default:
      return super.getProperty(hash, name, checkValid);
    }

  }

  @Override
  public Base setProperty(int hash, String name, Base value) throws FHIRException {
    switch (hash) {
    case 116079: // url
      this.url = castToUri(value); // UriType
      return value;
    case -1618432855: // identifier
      this.getIdentifier().add(castToIdentifier(value)); // Identifier
      return value;
    case 351608024: // version
      this.version = castToString(value); // StringType
      return value;
    case 3373707: // name
      this.name = castToString(value); // StringType
      return value;
    case 110371416: // title
      this.title = castToString(value); // StringType
      return value;
    case 1555503932: // shortTitle
      this.shortTitle = castToString(value); // StringType
      return value;
    case -2060497896: // subtitle
      this.subtitle = castToString(value); // StringType
      return value;
    case -892481550: // status
      value = new PublicationStatusEnumFactory().fromType(castToCode(value));
      this.status = (Enumeration) value; // Enumeration<PublicationStatus>
      return value;
    case 3076014: // date
      this.date = castToDateTime(value); // DateTimeType
      return value;
    case 1447404028: // publisher
      this.publisher = castToString(value); // StringType
      return value;
    case 951526432: // contact
      this.getContact().add(castToContactDetail(value)); // ContactDetail
      return value;
    case -1724546052: // description
      this.description = castToMarkdown(value); // MarkdownType
      return value;
    case 3387378: // note
      this.getNote().add(castToAnnotation(value)); // Annotation
      return value;
    case -669707736: // useContext
      this.getUseContext().add(castToUsageContext(value)); // UsageContext
      return value;
    case -507075711: // jurisdiction
      this.getJurisdiction().add(castToCodeableConcept(value)); // CodeableConcept
      return value;
    case 1522889671: // copyright
      this.copyright = castToMarkdown(value); // MarkdownType
      return value;
    case 223539345: // approvalDate
      this.approvalDate = castToDate(value); // DateType
      return value;
    case -1687512484: // lastReviewDate
      this.lastReviewDate = castToDate(value); // DateType
      return value;
    case -403934648: // effectivePeriod
      this.effectivePeriod = castToPeriod(value); // Period
      return value;
    case 110546223: // topic
      this.getTopic().add(castToCodeableConcept(value)); // CodeableConcept
      return value;
    case -1406328437: // author
      this.getAuthor().add(castToContactDetail(value)); // ContactDetail
      return value;
    case -1307827859: // editor
      this.getEditor().add(castToContactDetail(value)); // ContactDetail
      return value;
    case -261190139: // reviewer
      this.getReviewer().add(castToContactDetail(value)); // ContactDetail
      return value;
    case 1740277666: // endorser
      this.getEndorser().add(castToContactDetail(value)); // ContactDetail
      return value;
    case 666807069: // relatedArtifact
      this.getRelatedArtifact().add(castToRelatedArtifact(value)); // RelatedArtifact
      return value;
    case -832155243: // exposureBackground
      this.exposureBackground = castToReference(value); // Reference
      return value;
    case -19675778: // exposureVariant
      this.getExposureVariant().add(castToReference(value)); // Reference
      return value;
    case -1106507950: // outcome
      this.getOutcome().add(castToReference(value)); // Reference
      return value;
    default:
      return super.setProperty(hash, name, value);
    }

  }

  @Override
  public Base setProperty(String name, Base value) throws FHIRException {
    if (name.equals("url")) {
      this.url = castToUri(value); // UriType
    } else if (name.equals("identifier")) {
      this.getIdentifier().add(castToIdentifier(value));
    } else if (name.equals("version")) {
      this.version = castToString(value); // StringType
    } else if (name.equals("name")) {
      this.name = castToString(value); // StringType
    } else if (name.equals("title")) {
      this.title = castToString(value); // StringType
    } else if (name.equals("shortTitle")) {
      this.shortTitle = castToString(value); // StringType
    } else if (name.equals("subtitle")) {
      this.subtitle = castToString(value); // StringType
    } else if (name.equals("status")) {
      value = new PublicationStatusEnumFactory().fromType(castToCode(value));
      this.status = (Enumeration) value; // Enumeration<PublicationStatus>
    } else if (name.equals("date")) {
      this.date = castToDateTime(value); // DateTimeType
    } else if (name.equals("publisher")) {
      this.publisher = castToString(value); // StringType
    } else if (name.equals("contact")) {
      this.getContact().add(castToContactDetail(value));
    } else if (name.equals("description")) {
      this.description = castToMarkdown(value); // MarkdownType
    } else if (name.equals("note")) {
      this.getNote().add(castToAnnotation(value));
    } else if (name.equals("useContext")) {
      this.getUseContext().add(castToUsageContext(value));
    } else if (name.equals("jurisdiction")) {
      this.getJurisdiction().add(castToCodeableConcept(value));
    } else if (name.equals("copyright")) {
      this.copyright = castToMarkdown(value); // MarkdownType
    } else if (name.equals("approvalDate")) {
      this.approvalDate = castToDate(value); // DateType
    } else if (name.equals("lastReviewDate")) {
      this.lastReviewDate = castToDate(value); // DateType
    } else if (name.equals("effectivePeriod")) {
      this.effectivePeriod = castToPeriod(value); // Period
    } else if (name.equals("topic")) {
      this.getTopic().add(castToCodeableConcept(value));
    } else if (name.equals("author")) {
      this.getAuthor().add(castToContactDetail(value));
    } else if (name.equals("editor")) {
      this.getEditor().add(castToContactDetail(value));
    } else if (name.equals("reviewer")) {
      this.getReviewer().add(castToContactDetail(value));
    } else if (name.equals("endorser")) {
      this.getEndorser().add(castToContactDetail(value));
    } else if (name.equals("relatedArtifact")) {
      this.getRelatedArtifact().add(castToRelatedArtifact(value));
    } else if (name.equals("exposureBackground")) {
      this.exposureBackground = castToReference(value); // Reference
    } else if (name.equals("exposureVariant")) {
      this.getExposureVariant().add(castToReference(value));
    } else if (name.equals("outcome")) {
      this.getOutcome().add(castToReference(value));
    } else
      return super.setProperty(name, value);
    return value;
  }

  @Override
  public void removeChild(String name, Base value) throws FHIRException {
    if (name.equals("url")) {
      this.url = null;
    } else if (name.equals("identifier")) {
      this.getIdentifier().remove(castToIdentifier(value));
    } else if (name.equals("version")) {
      this.version = null;
    } else if (name.equals("name")) {
      this.name = null;
    } else if (name.equals("title")) {
      this.title = null;
    } else if (name.equals("shortTitle")) {
      this.shortTitle = null;
    } else if (name.equals("subtitle")) {
      this.subtitle = null;
    } else if (name.equals("status")) {
      this.status = null;
    } else if (name.equals("date")) {
      this.date = null;
    } else if (name.equals("publisher")) {
      this.publisher = null;
    } else if (name.equals("contact")) {
      this.getContact().remove(castToContactDetail(value));
    } else if (name.equals("description")) {
      this.description = null;
    } else if (name.equals("note")) {
      this.getNote().remove(castToAnnotation(value));
    } else if (name.equals("useContext")) {
      this.getUseContext().remove(castToUsageContext(value));
    } else if (name.equals("jurisdiction")) {
      this.getJurisdiction().remove(castToCodeableConcept(value));
    } else if (name.equals("copyright")) {
      this.copyright = null;
    } else if (name.equals("approvalDate")) {
      this.approvalDate = null;
    } else if (name.equals("lastReviewDate")) {
      this.lastReviewDate = null;
    } else if (name.equals("effectivePeriod")) {
      this.effectivePeriod = null;
    } else if (name.equals("topic")) {
      this.getTopic().remove(castToCodeableConcept(value));
    } else if (name.equals("author")) {
      this.getAuthor().remove(castToContactDetail(value));
    } else if (name.equals("editor")) {
      this.getEditor().remove(castToContactDetail(value));
    } else if (name.equals("reviewer")) {
      this.getReviewer().remove(castToContactDetail(value));
    } else if (name.equals("endorser")) {
      this.getEndorser().remove(castToContactDetail(value));
    } else if (name.equals("relatedArtifact")) {
      this.getRelatedArtifact().remove(castToRelatedArtifact(value));
    } else if (name.equals("exposureBackground")) {
      this.exposureBackground = null;
    } else if (name.equals("exposureVariant")) {
      this.getExposureVariant().remove(castToReference(value));
    } else if (name.equals("outcome")) {
      this.getOutcome().remove(castToReference(value));
    } else
      super.removeChild(name, value);
    
  }

  @Override
  public Base makeProperty(int hash, String name) throws FHIRException {
    switch (hash) {
    case 116079:
      return getUrlElement();
    case -1618432855:
      return addIdentifier();
    case 351608024:
      return getVersionElement();
    case 3373707:
      return getNameElement();
    case 110371416:
      return getTitleElement();
    case 1555503932:
      return getShortTitleElement();
    case -2060497896:
      return getSubtitleElement();
    case -892481550:
      return getStatusElement();
    case 3076014:
      return getDateElement();
    case 1447404028:
      return getPublisherElement();
    case 951526432:
      return addContact();
    case -1724546052:
      return getDescriptionElement();
    case 3387378:
      return addNote();
    case -669707736:
      return addUseContext();
    case -507075711:
      return addJurisdiction();
    case 1522889671:
      return getCopyrightElement();
    case 223539345:
      return getApprovalDateElement();
    case -1687512484:
      return getLastReviewDateElement();
    case -403934648:
      return getEffectivePeriod();
    case 110546223:
      return addTopic();
    case -1406328437:
      return addAuthor();
    case -1307827859:
      return addEditor();
    case -261190139:
      return addReviewer();
    case 1740277666:
      return addEndorser();
    case 666807069:
      return addRelatedArtifact();
    case -832155243:
      return getExposureBackground();
    case -19675778:
      return addExposureVariant();
    case -1106507950:
      return addOutcome();
    default:
      return super.makeProperty(hash, name);
    }

  }

  @Override
  public String[] getTypesForProperty(int hash, String name) throws FHIRException {
    switch (hash) {
    case 116079:
      /* url */ return new String[] { "uri" };
    case -1618432855:
      /* identifier */ return new String[] { "Identifier" };
    case 351608024:
      /* version */ return new String[] { "string" };
    case 3373707:
      /* name */ return new String[] { "string" };
    case 110371416:
      /* title */ return new String[] { "string" };
    case 1555503932:
      /* shortTitle */ return new String[] { "string" };
    case -2060497896:
      /* subtitle */ return new String[] { "string" };
    case -892481550:
      /* status */ return new String[] { "code" };
    case 3076014:
      /* date */ return new String[] { "dateTime" };
    case 1447404028:
      /* publisher */ return new String[] { "string" };
    case 951526432:
      /* contact */ return new String[] { "ContactDetail" };
    case -1724546052:
      /* description */ return new String[] { "markdown" };
    case 3387378:
      /* note */ return new String[] { "Annotation" };
    case -669707736:
      /* useContext */ return new String[] { "UsageContext" };
    case -507075711:
      /* jurisdiction */ return new String[] { "CodeableConcept" };
    case 1522889671:
      /* copyright */ return new String[] { "markdown" };
    case 223539345:
      /* approvalDate */ return new String[] { "date" };
    case -1687512484:
      /* lastReviewDate */ return new String[] { "date" };
    case -403934648:
      /* effectivePeriod */ return new String[] { "Period" };
    case 110546223:
      /* topic */ return new String[] { "CodeableConcept" };
    case -1406328437:
      /* author */ return new String[] { "ContactDetail" };
    case -1307827859:
      /* editor */ return new String[] { "ContactDetail" };
    case -261190139:
      /* reviewer */ return new String[] { "ContactDetail" };
    case 1740277666:
      /* endorser */ return new String[] { "ContactDetail" };
    case 666807069:
      /* relatedArtifact */ return new String[] { "RelatedArtifact" };
    case -832155243:
      /* exposureBackground */ return new String[] { "Reference" };
    case -19675778:
      /* exposureVariant */ return new String[] { "Reference" };
    case -1106507950:
      /* outcome */ return new String[] { "Reference" };
    default:
      return super.getTypesForProperty(hash, name);
    }

  }

  @Override
  public Base addChild(String name) throws FHIRException {
    if (name.equals("url")) {
      throw new FHIRException("Cannot call addChild on a singleton property Evidence.url");
    } else if (name.equals("identifier")) {
      return addIdentifier();
    } else if (name.equals("version")) {
      throw new FHIRException("Cannot call addChild on a singleton property Evidence.version");
    } else if (name.equals("name")) {
      throw new FHIRException("Cannot call addChild on a singleton property Evidence.name");
    } else if (name.equals("title")) {
      throw new FHIRException("Cannot call addChild on a singleton property Evidence.title");
    } else if (name.equals("shortTitle")) {
      throw new FHIRException("Cannot call addChild on a singleton property Evidence.shortTitle");
    } else if (name.equals("subtitle")) {
      throw new FHIRException("Cannot call addChild on a singleton property Evidence.subtitle");
    } else if (name.equals("status")) {
      throw new FHIRException("Cannot call addChild on a singleton property Evidence.status");
    } else if (name.equals("date")) {
      throw new FHIRException("Cannot call addChild on a singleton property Evidence.date");
    } else if (name.equals("publisher")) {
      throw new FHIRException("Cannot call addChild on a singleton property Evidence.publisher");
    } else if (name.equals("contact")) {
      return addContact();
    } else if (name.equals("description")) {
      throw new FHIRException("Cannot call addChild on a singleton property Evidence.description");
    } else if (name.equals("note")) {
      return addNote();
    } else if (name.equals("useContext")) {
      return addUseContext();
    } else if (name.equals("jurisdiction")) {
      return addJurisdiction();
    } else if (name.equals("copyright")) {
      throw new FHIRException("Cannot call addChild on a singleton property Evidence.copyright");
    } else if (name.equals("approvalDate")) {
      throw new FHIRException("Cannot call addChild on a singleton property Evidence.approvalDate");
    } else if (name.equals("lastReviewDate")) {
      throw new FHIRException("Cannot call addChild on a singleton property Evidence.lastReviewDate");
    } else if (name.equals("effectivePeriod")) {
      this.effectivePeriod = new Period();
      return this.effectivePeriod;
    } else if (name.equals("topic")) {
      return addTopic();
    } else if (name.equals("author")) {
      return addAuthor();
    } else if (name.equals("editor")) {
      return addEditor();
    } else if (name.equals("reviewer")) {
      return addReviewer();
    } else if (name.equals("endorser")) {
      return addEndorser();
    } else if (name.equals("relatedArtifact")) {
      return addRelatedArtifact();
    } else if (name.equals("exposureBackground")) {
      this.exposureBackground = new Reference();
      return this.exposureBackground;
    } else if (name.equals("exposureVariant")) {
      return addExposureVariant();
    } else if (name.equals("outcome")) {
      return addOutcome();
    } else
      return super.addChild(name);
  }

  public String fhirType() {
    return "Evidence";

  }

  public Evidence copy() {
    Evidence dst = new Evidence();
    copyValues(dst);
    return dst;
  }

  public void copyValues(Evidence dst) {
    super.copyValues(dst);
    dst.url = url == null ? null : url.copy();
    if (identifier != null) {
      dst.identifier = new ArrayList<Identifier>();
      for (Identifier i : identifier)
        dst.identifier.add(i.copy());
    }
    ;
    dst.version = version == null ? null : version.copy();
    dst.name = name == null ? null : name.copy();
    dst.title = title == null ? null : title.copy();
    dst.shortTitle = shortTitle == null ? null : shortTitle.copy();
    dst.subtitle = subtitle == null ? null : subtitle.copy();
    dst.status = status == null ? null : status.copy();
    dst.date = date == null ? null : date.copy();
    dst.publisher = publisher == null ? null : publisher.copy();
    if (contact != null) {
      dst.contact = new ArrayList<ContactDetail>();
      for (ContactDetail i : contact)
        dst.contact.add(i.copy());
    }
    ;
    dst.description = description == null ? null : description.copy();
    if (note != null) {
      dst.note = new ArrayList<Annotation>();
      for (Annotation i : note)
        dst.note.add(i.copy());
    }
    ;
    if (useContext != null) {
      dst.useContext = new ArrayList<UsageContext>();
      for (UsageContext i : useContext)
        dst.useContext.add(i.copy());
    }
    ;
    if (jurisdiction != null) {
      dst.jurisdiction = new ArrayList<CodeableConcept>();
      for (CodeableConcept i : jurisdiction)
        dst.jurisdiction.add(i.copy());
    }
    ;
    dst.copyright = copyright == null ? null : copyright.copy();
    dst.approvalDate = approvalDate == null ? null : approvalDate.copy();
    dst.lastReviewDate = lastReviewDate == null ? null : lastReviewDate.copy();
    dst.effectivePeriod = effectivePeriod == null ? null : effectivePeriod.copy();
    if (topic != null) {
      dst.topic = new ArrayList<CodeableConcept>();
      for (CodeableConcept i : topic)
        dst.topic.add(i.copy());
    }
    ;
    if (author != null) {
      dst.author = new ArrayList<ContactDetail>();
      for (ContactDetail i : author)
        dst.author.add(i.copy());
    }
    ;
    if (editor != null) {
      dst.editor = new ArrayList<ContactDetail>();
      for (ContactDetail i : editor)
        dst.editor.add(i.copy());
    }
    ;
    if (reviewer != null) {
      dst.reviewer = new ArrayList<ContactDetail>();
      for (ContactDetail i : reviewer)
        dst.reviewer.add(i.copy());
    }
    ;
    if (endorser != null) {
      dst.endorser = new ArrayList<ContactDetail>();
      for (ContactDetail i : endorser)
        dst.endorser.add(i.copy());
    }
    ;
    if (relatedArtifact != null) {
      dst.relatedArtifact = new ArrayList<RelatedArtifact>();
      for (RelatedArtifact i : relatedArtifact)
        dst.relatedArtifact.add(i.copy());
    }
    ;
    dst.exposureBackground = exposureBackground == null ? null : exposureBackground.copy();
    if (exposureVariant != null) {
      dst.exposureVariant = new ArrayList<Reference>();
      for (Reference i : exposureVariant)
        dst.exposureVariant.add(i.copy());
    }
    ;
    if (outcome != null) {
      dst.outcome = new ArrayList<Reference>();
      for (Reference i : outcome)
        dst.outcome.add(i.copy());
    }
    ;
  }

  protected Evidence typedCopy() {
    return copy();
  }

  @Override
  public boolean equalsDeep(Base other_) {
    if (!super.equalsDeep(other_))
      return false;
    if (!(other_ instanceof Evidence))
      return false;
    Evidence o = (Evidence) other_;
    return compareDeep(identifier, o.identifier, true) && compareDeep(shortTitle, o.shortTitle, true)
        && compareDeep(subtitle, o.subtitle, true) && compareDeep(note, o.note, true)
        && compareDeep(copyright, o.copyright, true) && compareDeep(approvalDate, o.approvalDate, true)
        && compareDeep(lastReviewDate, o.lastReviewDate, true) && compareDeep(effectivePeriod, o.effectivePeriod, true)
        && compareDeep(topic, o.topic, true) && compareDeep(author, o.author, true)
        && compareDeep(editor, o.editor, true) && compareDeep(reviewer, o.reviewer, true)
        && compareDeep(endorser, o.endorser, true) && compareDeep(relatedArtifact, o.relatedArtifact, true)
        && compareDeep(exposureBackground, o.exposureBackground, true)
        && compareDeep(exposureVariant, o.exposureVariant, true) && compareDeep(outcome, o.outcome, true);
  }

  @Override
  public boolean equalsShallow(Base other_) {
    if (!super.equalsShallow(other_))
      return false;
    if (!(other_ instanceof Evidence))
      return false;
    Evidence o = (Evidence) other_;
    return compareValues(shortTitle, o.shortTitle, true) && compareValues(subtitle, o.subtitle, true)
        && compareValues(copyright, o.copyright, true) && compareValues(approvalDate, o.approvalDate, true)
        && compareValues(lastReviewDate, o.lastReviewDate, true);
  }

  public boolean isEmpty() {
    return super.isEmpty() && ca.uhn.fhir.util.ElementUtil.isEmpty(identifier, shortTitle, subtitle, note, copyright,
        approvalDate, lastReviewDate, effectivePeriod, topic, author, editor, reviewer, endorser, relatedArtifact,
        exposureBackground, exposureVariant, outcome);
  }

  @Override
  public ResourceType getResourceType() {
    return ResourceType.Evidence;
  }

  /**
   * Search parameter: <b>date</b>
   * <p>
   * Description: <b>The evidence publication date</b><br>
   * Type: <b>date</b><br>
   * Path: <b>Evidence.date</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "date", path = "Evidence.date", description = "The evidence publication date", type = "date")
  public static final String SP_DATE = "date";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>date</b>
   * <p>
   * Description: <b>The evidence publication date</b><br>
   * Type: <b>date</b><br>
   * Path: <b>Evidence.date</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.DateClientParam DATE = new ca.uhn.fhir.rest.gclient.DateClientParam(
      SP_DATE);

  /**
   * Search parameter: <b>identifier</b>
   * <p>
   * Description: <b>External identifier for the evidence</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Evidence.identifier</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "identifier", path = "Evidence.identifier", description = "External identifier for the evidence", type = "token")
  public static final String SP_IDENTIFIER = "identifier";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>identifier</b>
   * <p>
   * Description: <b>External identifier for the evidence</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Evidence.identifier</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam IDENTIFIER = new ca.uhn.fhir.rest.gclient.TokenClientParam(
      SP_IDENTIFIER);

  /**
   * Search parameter: <b>successor</b>
   * <p>
   * Description: <b>What resource is being referenced</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Evidence.relatedArtifact.resource</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "successor", path = "Evidence.relatedArtifact.where(type='successor').resource", description = "What resource is being referenced", type = "reference")
  public static final String SP_SUCCESSOR = "successor";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>successor</b>
   * <p>
   * Description: <b>What resource is being referenced</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Evidence.relatedArtifact.resource</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.ReferenceClientParam SUCCESSOR = new ca.uhn.fhir.rest.gclient.ReferenceClientParam(
      SP_SUCCESSOR);

  /**
   * Constant for fluent queries to be used to add include statements. Specifies
   * the path value of "<b>Evidence:successor</b>".
   */
  public static final ca.uhn.fhir.model.api.Include INCLUDE_SUCCESSOR = new ca.uhn.fhir.model.api.Include(
      "Evidence:successor").toLocked();

  /**
   * Search parameter: <b>context-type-value</b>
   * <p>
   * Description: <b>A use context type and value assigned to the evidence</b><br>
   * Type: <b>composite</b><br>
   * Path: <b></b><br>
   * </p>
   */
  @SearchParamDefinition(name = "context-type-value", path = "Evidence.useContext", description = "A use context type and value assigned to the evidence", type = "composite", compositeOf = {
      "context-type", "context" })
  public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>context-type-value</b>
   * <p>
   * Description: <b>A use context type and value assigned to the evidence</b><br>
   * Type: <b>composite</b><br>
   * Path: <b></b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.CompositeClientParam<ca.uhn.fhir.rest.gclient.TokenClientParam, ca.uhn.fhir.rest.gclient.TokenClientParam> CONTEXT_TYPE_VALUE = new ca.uhn.fhir.rest.gclient.CompositeClientParam<ca.uhn.fhir.rest.gclient.TokenClientParam, ca.uhn.fhir.rest.gclient.TokenClientParam>(
      SP_CONTEXT_TYPE_VALUE);

  /**
   * Search parameter: <b>jurisdiction</b>
   * <p>
   * Description: <b>Intended jurisdiction for the evidence</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Evidence.jurisdiction</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "jurisdiction", path = "Evidence.jurisdiction", description = "Intended jurisdiction for the evidence", type = "token")
  public static final String SP_JURISDICTION = "jurisdiction";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>jurisdiction</b>
   * <p>
   * Description: <b>Intended jurisdiction for the evidence</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Evidence.jurisdiction</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam JURISDICTION = new ca.uhn.fhir.rest.gclient.TokenClientParam(
      SP_JURISDICTION);

  /**
   * Search parameter: <b>description</b>
   * <p>
   * Description: <b>The description of the evidence</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Evidence.description</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "description", path = "Evidence.description", description = "The description of the evidence", type = "string")
  public static final String SP_DESCRIPTION = "description";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>description</b>
   * <p>
   * Description: <b>The description of the evidence</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Evidence.description</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.StringClientParam DESCRIPTION = new ca.uhn.fhir.rest.gclient.StringClientParam(
      SP_DESCRIPTION);

  /**
   * Search parameter: <b>derived-from</b>
   * <p>
   * Description: <b>What resource is being referenced</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Evidence.relatedArtifact.resource</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "derived-from", path = "Evidence.relatedArtifact.where(type='derived-from').resource", description = "What resource is being referenced", type = "reference")
  public static final String SP_DERIVED_FROM = "derived-from";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>derived-from</b>
   * <p>
   * Description: <b>What resource is being referenced</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Evidence.relatedArtifact.resource</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.ReferenceClientParam DERIVED_FROM = new ca.uhn.fhir.rest.gclient.ReferenceClientParam(
      SP_DERIVED_FROM);

  /**
   * Constant for fluent queries to be used to add include statements. Specifies
   * the path value of "<b>Evidence:derived-from</b>".
   */
  public static final ca.uhn.fhir.model.api.Include INCLUDE_DERIVED_FROM = new ca.uhn.fhir.model.api.Include(
      "Evidence:derived-from").toLocked();

  /**
   * Search parameter: <b>context-type</b>
   * <p>
   * Description: <b>A type of use context assigned to the evidence</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Evidence.useContext.code</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "context-type", path = "Evidence.useContext.code", description = "A type of use context assigned to the evidence", type = "token")
  public static final String SP_CONTEXT_TYPE = "context-type";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>context-type</b>
   * <p>
   * Description: <b>A type of use context assigned to the evidence</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Evidence.useContext.code</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam CONTEXT_TYPE = new ca.uhn.fhir.rest.gclient.TokenClientParam(
      SP_CONTEXT_TYPE);

  /**
   * Search parameter: <b>predecessor</b>
   * <p>
   * Description: <b>What resource is being referenced</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Evidence.relatedArtifact.resource</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "predecessor", path = "Evidence.relatedArtifact.where(type='predecessor').resource", description = "What resource is being referenced", type = "reference")
  public static final String SP_PREDECESSOR = "predecessor";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>predecessor</b>
   * <p>
   * Description: <b>What resource is being referenced</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Evidence.relatedArtifact.resource</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.ReferenceClientParam PREDECESSOR = new ca.uhn.fhir.rest.gclient.ReferenceClientParam(
      SP_PREDECESSOR);

  /**
   * Constant for fluent queries to be used to add include statements. Specifies
   * the path value of "<b>Evidence:predecessor</b>".
   */
  public static final ca.uhn.fhir.model.api.Include INCLUDE_PREDECESSOR = new ca.uhn.fhir.model.api.Include(
      "Evidence:predecessor").toLocked();

  /**
   * Search parameter: <b>title</b>
   * <p>
   * Description: <b>The human-friendly name of the evidence</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Evidence.title</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "title", path = "Evidence.title", description = "The human-friendly name of the evidence", type = "string")
  public static final String SP_TITLE = "title";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>title</b>
   * <p>
   * Description: <b>The human-friendly name of the evidence</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Evidence.title</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.StringClientParam TITLE = new ca.uhn.fhir.rest.gclient.StringClientParam(
      SP_TITLE);

  /**
   * Search parameter: <b>composed-of</b>
   * <p>
   * Description: <b>What resource is being referenced</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Evidence.relatedArtifact.resource</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "composed-of", path = "Evidence.relatedArtifact.where(type='composed-of').resource", description = "What resource is being referenced", type = "reference")
  public static final String SP_COMPOSED_OF = "composed-of";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>composed-of</b>
   * <p>
   * Description: <b>What resource is being referenced</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Evidence.relatedArtifact.resource</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.ReferenceClientParam COMPOSED_OF = new ca.uhn.fhir.rest.gclient.ReferenceClientParam(
      SP_COMPOSED_OF);

  /**
   * Constant for fluent queries to be used to add include statements. Specifies
   * the path value of "<b>Evidence:composed-of</b>".
   */
  public static final ca.uhn.fhir.model.api.Include INCLUDE_COMPOSED_OF = new ca.uhn.fhir.model.api.Include(
      "Evidence:composed-of").toLocked();

  /**
   * Search parameter: <b>version</b>
   * <p>
   * Description: <b>The business version of the evidence</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Evidence.version</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "version", path = "Evidence.version", description = "The business version of the evidence", type = "token")
  public static final String SP_VERSION = "version";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>version</b>
   * <p>
   * Description: <b>The business version of the evidence</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Evidence.version</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam VERSION = new ca.uhn.fhir.rest.gclient.TokenClientParam(
      SP_VERSION);

  /**
   * Search parameter: <b>url</b>
   * <p>
   * Description: <b>The uri that identifies the evidence</b><br>
   * Type: <b>uri</b><br>
   * Path: <b>Evidence.url</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "url", path = "Evidence.url", description = "The uri that identifies the evidence", type = "uri")
  public static final String SP_URL = "url";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>url</b>
   * <p>
   * Description: <b>The uri that identifies the evidence</b><br>
   * Type: <b>uri</b><br>
   * Path: <b>Evidence.url</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.UriClientParam URL = new ca.uhn.fhir.rest.gclient.UriClientParam(SP_URL);

  /**
   * Search parameter: <b>context-quantity</b>
   * <p>
   * Description: <b>A quantity- or range-valued use context assigned to the
   * evidence</b><br>
   * Type: <b>quantity</b><br>
   * Path: <b>Evidence.useContext.valueQuantity,
   * Evidence.useContext.valueRange</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "context-quantity", path = "(Evidence.useContext.value as Quantity) | (Evidence.useContext.value as Range)", description = "A quantity- or range-valued use context assigned to the evidence", type = "quantity")
  public static final String SP_CONTEXT_QUANTITY = "context-quantity";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>context-quantity</b>
   * <p>
   * Description: <b>A quantity- or range-valued use context assigned to the
   * evidence</b><br>
   * Type: <b>quantity</b><br>
   * Path: <b>Evidence.useContext.valueQuantity,
   * Evidence.useContext.valueRange</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.QuantityClientParam CONTEXT_QUANTITY = new ca.uhn.fhir.rest.gclient.QuantityClientParam(
      SP_CONTEXT_QUANTITY);

  /**
   * Search parameter: <b>effective</b>
   * <p>
   * Description: <b>The time during which the evidence is intended to be in
   * use</b><br>
   * Type: <b>date</b><br>
   * Path: <b>Evidence.effectivePeriod</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "effective", path = "Evidence.effectivePeriod", description = "The time during which the evidence is intended to be in use", type = "date")
  public static final String SP_EFFECTIVE = "effective";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>effective</b>
   * <p>
   * Description: <b>The time during which the evidence is intended to be in
   * use</b><br>
   * Type: <b>date</b><br>
   * Path: <b>Evidence.effectivePeriod</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.DateClientParam EFFECTIVE = new ca.uhn.fhir.rest.gclient.DateClientParam(
      SP_EFFECTIVE);

  /**
   * Search parameter: <b>depends-on</b>
   * <p>
   * Description: <b>What resource is being referenced</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Evidence.relatedArtifact.resource</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "depends-on", path = "Evidence.relatedArtifact.where(type='depends-on').resource", description = "What resource is being referenced", type = "reference")
  public static final String SP_DEPENDS_ON = "depends-on";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>depends-on</b>
   * <p>
   * Description: <b>What resource is being referenced</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Evidence.relatedArtifact.resource</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.ReferenceClientParam DEPENDS_ON = new ca.uhn.fhir.rest.gclient.ReferenceClientParam(
      SP_DEPENDS_ON);

  /**
   * Constant for fluent queries to be used to add include statements. Specifies
   * the path value of "<b>Evidence:depends-on</b>".
   */
  public static final ca.uhn.fhir.model.api.Include INCLUDE_DEPENDS_ON = new ca.uhn.fhir.model.api.Include(
      "Evidence:depends-on").toLocked();

  /**
   * Search parameter: <b>name</b>
   * <p>
   * Description: <b>Computationally friendly name of the evidence</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Evidence.name</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "name", path = "Evidence.name", description = "Computationally friendly name of the evidence", type = "string")
  public static final String SP_NAME = "name";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>name</b>
   * <p>
   * Description: <b>Computationally friendly name of the evidence</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Evidence.name</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.StringClientParam NAME = new ca.uhn.fhir.rest.gclient.StringClientParam(
      SP_NAME);

  /**
   * Search parameter: <b>context</b>
   * <p>
   * Description: <b>A use context assigned to the evidence</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Evidence.useContext.valueCodeableConcept</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "context", path = "(Evidence.useContext.value as CodeableConcept)", description = "A use context assigned to the evidence", type = "token")
  public static final String SP_CONTEXT = "context";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>context</b>
   * <p>
   * Description: <b>A use context assigned to the evidence</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Evidence.useContext.valueCodeableConcept</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam CONTEXT = new ca.uhn.fhir.rest.gclient.TokenClientParam(
      SP_CONTEXT);

  /**
   * Search parameter: <b>publisher</b>
   * <p>
   * Description: <b>Name of the publisher of the evidence</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Evidence.publisher</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "publisher", path = "Evidence.publisher", description = "Name of the publisher of the evidence", type = "string")
  public static final String SP_PUBLISHER = "publisher";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>publisher</b>
   * <p>
   * Description: <b>Name of the publisher of the evidence</b><br>
   * Type: <b>string</b><br>
   * Path: <b>Evidence.publisher</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.StringClientParam PUBLISHER = new ca.uhn.fhir.rest.gclient.StringClientParam(
      SP_PUBLISHER);

  /**
   * Search parameter: <b>topic</b>
   * <p>
   * Description: <b>Topics associated with the Evidence</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Evidence.topic</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "topic", path = "Evidence.topic", description = "Topics associated with the Evidence", type = "token")
  public static final String SP_TOPIC = "topic";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>topic</b>
   * <p>
   * Description: <b>Topics associated with the Evidence</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Evidence.topic</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam TOPIC = new ca.uhn.fhir.rest.gclient.TokenClientParam(
      SP_TOPIC);

  /**
   * Search parameter: <b>context-type-quantity</b>
   * <p>
   * Description: <b>A use context type and quantity- or range-based value
   * assigned to the evidence</b><br>
   * Type: <b>composite</b><br>
   * Path: <b></b><br>
   * </p>
   */
  @SearchParamDefinition(name = "context-type-quantity", path = "Evidence.useContext", description = "A use context type and quantity- or range-based value assigned to the evidence", type = "composite", compositeOf = {
      "context-type", "context-quantity" })
  public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
  /**
   * <b>Fluent Client</b> search parameter constant for
   * <b>context-type-quantity</b>
   * <p>
   * Description: <b>A use context type and quantity- or range-based value
   * assigned to the evidence</b><br>
   * Type: <b>composite</b><br>
   * Path: <b></b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.CompositeClientParam<ca.uhn.fhir.rest.gclient.TokenClientParam, ca.uhn.fhir.rest.gclient.QuantityClientParam> CONTEXT_TYPE_QUANTITY = new ca.uhn.fhir.rest.gclient.CompositeClientParam<ca.uhn.fhir.rest.gclient.TokenClientParam, ca.uhn.fhir.rest.gclient.QuantityClientParam>(
      SP_CONTEXT_TYPE_QUANTITY);

  /**
   * Search parameter: <b>status</b>
   * <p>
   * Description: <b>The current status of the evidence</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Evidence.status</b><br>
   * </p>
   */
  @SearchParamDefinition(name = "status", path = "Evidence.status", description = "The current status of the evidence", type = "token")
  public static final String SP_STATUS = "status";
  /**
   * <b>Fluent Client</b> search parameter constant for <b>status</b>
   * <p>
   * Description: <b>The current status of the evidence</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Evidence.status</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam STATUS = new ca.uhn.fhir.rest.gclient.TokenClientParam(
      SP_STATUS);

}