/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.ClaimResponse;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DeviceRequest;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Procedure;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.ServiceRequest;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Claim", profile="http://hl7.org/fhir/StructureDefinition/Claim")
public class Claim
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier for claim", formalDefinition="A unique identifier assigned to this claim.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<ClaimStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Category or discipline", formalDefinition="The category of claim, e.g. oral, pharmacy, vision, institutional, professional.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-type")
    protected CodeableConcept type;
    @Child(name="subType", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="More granular claim type", formalDefinition="A finer grained suite of claim type codes which may convey additional information such as Inpatient vs Outpatient and/or a specialty service.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-subtype")
    protected CodeableConcept subType;
    @Child(name="use", type={CodeType.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="claim | preauthorization | predetermination", formalDefinition="A code to indicate whether the nature of the request is: to request adjudication of products and services previously rendered; or requesting authorization and adjudication for provision in the future; or requesting the non-binding adjudication of the listed products and services which could be provided in the future.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-use")
    protected Enumeration<Use> use;
    @Child(name="patient", type={Patient.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The recipient of the products and services", formalDefinition="The party to whom the professional services and/or products have been supplied or are being considered and for whom actual or forecast reimbursement is sought.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="billablePeriod", type={Period.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Relevant time frame for the claim", formalDefinition="The period for which charges are being submitted.")
    protected Period billablePeriod;
    @Child(name="created", type={DateTimeType.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Resource creation date", formalDefinition="The date this resource was created.")
    protected DateTimeType created;
    @Child(name="enterer", type={Practitioner.class, PractitionerRole.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Author of the claim", formalDefinition="Individual who created the claim, predetermination or preauthorization.")
    protected Reference enterer;
    protected Resource entererTarget;
    @Child(name="insurer", type={Organization.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Target", formalDefinition="The Insurer who is target of the request.")
    protected Reference insurer;
    protected Organization insurerTarget;
    @Child(name="provider", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Party responsible for the claim", formalDefinition="The provider which is responsible for the claim, predetermination or preauthorization.")
    protected Reference provider;
    protected Resource providerTarget;
    @Child(name="priority", type={CodeableConcept.class}, order=11, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Desired processing ugency", formalDefinition="The provider-required urgency of processing the request. Typical values include: stat, routine deferred.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/process-priority")
    protected CodeableConcept priority;
    @Child(name="fundsReserve", type={CodeableConcept.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="For whom to reserve funds", formalDefinition="A code to indicate whether and for whom funds are to be reserved for future claims.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fundsreserve")
    protected CodeableConcept fundsReserve;
    @Child(name="related", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Prior or corollary claims", formalDefinition="Other claims which are related to this claim such as prior submissions or claims for related services or for the same event.")
    protected List<RelatedClaimComponent> related;
    @Child(name="prescription", type={DeviceRequest.class, MedicationRequest.class, VisionPrescription.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Prescription authorizing services and products", formalDefinition="Prescription to support the dispensing of pharmacy, device or vision products.")
    protected Reference prescription;
    protected Resource prescriptionTarget;
    @Child(name="originalPrescription", type={DeviceRequest.class, MedicationRequest.class, VisionPrescription.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Original prescription if superseded by fulfiller", formalDefinition="Original prescription which has been superseded by this prescription to support the dispensing of pharmacy services, medications or products.")
    protected Reference originalPrescription;
    protected Resource originalPrescriptionTarget;
    @Child(name="payee", type={}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Recipient of benefits payable", formalDefinition="The party to be reimbursed for cost of the products and services according to the terms of the policy.")
    protected PayeeComponent payee;
    @Child(name="referral", type={ServiceRequest.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Treatment referral", formalDefinition="A reference to a referral resource.")
    protected Reference referral;
    protected ServiceRequest referralTarget;
    @Child(name="facility", type={Location.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Servicing facility", formalDefinition="Facility where the services were provided.")
    protected Reference facility;
    protected Location facilityTarget;
    @Child(name="careTeam", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Members of the care team", formalDefinition="The members of the team who provided the products and services.")
    protected List<CareTeamComponent> careTeam;
    @Child(name="supportingInfo", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Supporting information", formalDefinition="Additional information codes regarding exceptions, special considerations, the condition, situation, prior or concurrent issues.")
    protected List<SupportingInformationComponent> supportingInfo;
    @Child(name="diagnosis", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Pertinent diagnosis information", formalDefinition="Information about diagnoses relevant to the claim items.")
    protected List<DiagnosisComponent> diagnosis;
    @Child(name="procedure", type={}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Clinical procedures performed", formalDefinition="Procedures performed on the patient relevant to the billing items with the claim.")
    protected List<ProcedureComponent> procedure;
    @Child(name="insurance", type={}, order=23, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Patient insurance information", formalDefinition="Financial instruments for reimbursement for the health care products and services specified on the claim.")
    protected List<InsuranceComponent> insurance;
    @Child(name="accident", type={}, order=24, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details of the event", formalDefinition="Details of an accident which resulted in injuries which required the products and services listed in the claim.")
    protected AccidentComponent accident;
    @Child(name="item", type={}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Product or service provided", formalDefinition="A claim line. Either a simple  product or service or a 'group' of details which can each be a simple items or groups of sub-details.")
    protected List<ItemComponent> item;
    @Child(name="total", type={Money.class}, order=26, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Total claim cost", formalDefinition="The total value of the all the items in the claim.")
    protected Money total;
    private static final long serialVersionUID = -80376108L;
    @SearchParamDefinition(name="care-team", path="Claim.careTeam.provider", description="Member of the CareTeam", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_CARE_TEAM = "care-team";
    public static final ReferenceClientParam CARE_TEAM = new ReferenceClientParam("care-team");
    public static final Include INCLUDE_CARE_TEAM = new Include("Claim:care-team").toLocked();
    @SearchParamDefinition(name="identifier", path="Claim.identifier", description="The primary identifier of the financial resource", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="use", path="Claim.use", description="The kind of financial resource", type="token")
    public static final String SP_USE = "use";
    public static final TokenClientParam USE = new TokenClientParam("use");
    @SearchParamDefinition(name="created", path="Claim.created", description="The creation date for the Claim", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="encounter", path="Claim.item.encounter", description="Encounters associated with a billed line item", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Claim:encounter").toLocked();
    @SearchParamDefinition(name="priority", path="Claim.priority", description="Processing priority requested", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="payee", path="Claim.payee.party", description="The party receiving any payment for the Claim", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PAYEE = "payee";
    public static final ReferenceClientParam PAYEE = new ReferenceClientParam("payee");
    public static final Include INCLUDE_PAYEE = new Include("Claim:payee").toLocked();
    @SearchParamDefinition(name="provider", path="Claim.provider", description="Provider responsible for the Claim", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_PROVIDER = "provider";
    public static final ReferenceClientParam PROVIDER = new ReferenceClientParam("provider");
    public static final Include INCLUDE_PROVIDER = new Include("Claim:provider").toLocked();
    @SearchParamDefinition(name="patient", path="Claim.patient", description="Patient receiving the products or services", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Claim:patient").toLocked();
    @SearchParamDefinition(name="insurer", path="Claim.insurer", description="The target payor/insurer for the Claim", type="reference", target={Organization.class})
    public static final String SP_INSURER = "insurer";
    public static final ReferenceClientParam INSURER = new ReferenceClientParam("insurer");
    public static final Include INCLUDE_INSURER = new Include("Claim:insurer").toLocked();
    @SearchParamDefinition(name="detail-udi", path="Claim.item.detail.udi", description="UDI associated with a line item, detail product or service", type="reference", providesMembershipIn={@Compartment(name="Device")}, target={Device.class})
    public static final String SP_DETAIL_UDI = "detail-udi";
    public static final ReferenceClientParam DETAIL_UDI = new ReferenceClientParam("detail-udi");
    public static final Include INCLUDE_DETAIL_UDI = new Include("Claim:detail-udi").toLocked();
    @SearchParamDefinition(name="enterer", path="Claim.enterer", description="The party responsible for the entry of the Claim", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class, PractitionerRole.class})
    public static final String SP_ENTERER = "enterer";
    public static final ReferenceClientParam ENTERER = new ReferenceClientParam("enterer");
    public static final Include INCLUDE_ENTERER = new Include("Claim:enterer").toLocked();
    @SearchParamDefinition(name="procedure-udi", path="Claim.procedure.udi", description="UDI associated with a procedure", type="reference", providesMembershipIn={@Compartment(name="Device")}, target={Device.class})
    public static final String SP_PROCEDURE_UDI = "procedure-udi";
    public static final ReferenceClientParam PROCEDURE_UDI = new ReferenceClientParam("procedure-udi");
    public static final Include INCLUDE_PROCEDURE_UDI = new Include("Claim:procedure-udi").toLocked();
    @SearchParamDefinition(name="subdetail-udi", path="Claim.item.detail.subDetail.udi", description="UDI associated with a line item, detail, subdetail product or service", type="reference", providesMembershipIn={@Compartment(name="Device")}, target={Device.class})
    public static final String SP_SUBDETAIL_UDI = "subdetail-udi";
    public static final ReferenceClientParam SUBDETAIL_UDI = new ReferenceClientParam("subdetail-udi");
    public static final Include INCLUDE_SUBDETAIL_UDI = new Include("Claim:subdetail-udi").toLocked();
    @SearchParamDefinition(name="facility", path="Claim.facility", description="Facility where the products or services have been or will be provided", type="reference", target={Location.class})
    public static final String SP_FACILITY = "facility";
    public static final ReferenceClientParam FACILITY = new ReferenceClientParam("facility");
    public static final Include INCLUDE_FACILITY = new Include("Claim:facility").toLocked();
    @SearchParamDefinition(name="item-udi", path="Claim.item.udi", description="UDI associated with a line item product or service", type="reference", providesMembershipIn={@Compartment(name="Device")}, target={Device.class})
    public static final String SP_ITEM_UDI = "item-udi";
    public static final ReferenceClientParam ITEM_UDI = new ReferenceClientParam("item-udi");
    public static final Include INCLUDE_ITEM_UDI = new Include("Claim:item-udi").toLocked();
    @SearchParamDefinition(name="status", path="Claim.status", description="The status of the Claim instance.", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Claim() {
    }

    public Claim(Enumeration<ClaimStatus> status, CodeableConcept type, Enumeration<Use> use, Reference patient, DateTimeType created, Reference provider, CodeableConcept priority) {
        this.status = status;
        this.type = type;
        this.use = use;
        this.patient = patient;
        this.created = created;
        this.provider = provider;
        this.priority = priority;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Claim setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Claim addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ClaimStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ClaimStatus>(new ClaimStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Claim setStatusElement(Enumeration<ClaimStatus> value) {
        this.status = value;
        return this;
    }

    public ClaimStatus getStatus() {
        return this.status == null ? null : (ClaimStatus)((Object)this.status.getValue());
    }

    public Claim setStatus(ClaimStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ClaimStatus>(new ClaimStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Claim setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public CodeableConcept getSubType() {
        if (this.subType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.subType");
            }
            if (Configuration.doAutoCreate()) {
                this.subType = new CodeableConcept();
            }
        }
        return this.subType;
    }

    public boolean hasSubType() {
        return this.subType != null && !this.subType.isEmpty();
    }

    public Claim setSubType(CodeableConcept value) {
        this.subType = value;
        return this;
    }

    public Enumeration<Use> getUseElement() {
        if (this.use == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.use");
            }
            if (Configuration.doAutoCreate()) {
                this.use = new Enumeration<Use>(new UseEnumFactory());
            }
        }
        return this.use;
    }

    public boolean hasUseElement() {
        return this.use != null && !this.use.isEmpty();
    }

    public boolean hasUse() {
        return this.use != null && !this.use.isEmpty();
    }

    public Claim setUseElement(Enumeration<Use> value) {
        this.use = value;
        return this;
    }

    public Use getUse() {
        return this.use == null ? null : (Use)((Object)this.use.getValue());
    }

    public Claim setUse(Use value) {
        if (this.use == null) {
            this.use = new Enumeration<Use>(new UseEnumFactory());
        }
        this.use.setValue((Object)value);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public Claim setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public Claim setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Period getBillablePeriod() {
        if (this.billablePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.billablePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.billablePeriod = new Period();
            }
        }
        return this.billablePeriod;
    }

    public boolean hasBillablePeriod() {
        return this.billablePeriod != null && !this.billablePeriod.isEmpty();
    }

    public Claim setBillablePeriod(Period value) {
        this.billablePeriod = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public Claim setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public Claim setCreated(Date value) {
        if (this.created == null) {
            this.created = new DateTimeType();
        }
        this.created.setValue(value);
        return this;
    }

    public Reference getEnterer() {
        if (this.enterer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.enterer = new Reference();
            }
        }
        return this.enterer;
    }

    public boolean hasEnterer() {
        return this.enterer != null && !this.enterer.isEmpty();
    }

    public Claim setEnterer(Reference value) {
        this.enterer = value;
        return this;
    }

    public Resource getEntererTarget() {
        return this.entererTarget;
    }

    public Claim setEntererTarget(Resource value) {
        this.entererTarget = value;
        return this;
    }

    public Reference getInsurer() {
        if (this.insurer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurer = new Reference();
            }
        }
        return this.insurer;
    }

    public boolean hasInsurer() {
        return this.insurer != null && !this.insurer.isEmpty();
    }

    public Claim setInsurer(Reference value) {
        this.insurer = value;
        return this;
    }

    public Organization getInsurerTarget() {
        if (this.insurerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.insurer");
            }
            if (Configuration.doAutoCreate()) {
                this.insurerTarget = new Organization();
            }
        }
        return this.insurerTarget;
    }

    public Claim setInsurerTarget(Organization value) {
        this.insurerTarget = value;
        return this;
    }

    public Reference getProvider() {
        if (this.provider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.provider");
            }
            if (Configuration.doAutoCreate()) {
                this.provider = new Reference();
            }
        }
        return this.provider;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public Claim setProvider(Reference value) {
        this.provider = value;
        return this;
    }

    public Resource getProviderTarget() {
        return this.providerTarget;
    }

    public Claim setProviderTarget(Resource value) {
        this.providerTarget = value;
        return this;
    }

    public CodeableConcept getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeableConcept();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Claim setPriority(CodeableConcept value) {
        this.priority = value;
        return this;
    }

    public CodeableConcept getFundsReserve() {
        if (this.fundsReserve == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.fundsReserve");
            }
            if (Configuration.doAutoCreate()) {
                this.fundsReserve = new CodeableConcept();
            }
        }
        return this.fundsReserve;
    }

    public boolean hasFundsReserve() {
        return this.fundsReserve != null && !this.fundsReserve.isEmpty();
    }

    public Claim setFundsReserve(CodeableConcept value) {
        this.fundsReserve = value;
        return this;
    }

    public List<RelatedClaimComponent> getRelated() {
        if (this.related == null) {
            this.related = new ArrayList<RelatedClaimComponent>();
        }
        return this.related;
    }

    public Claim setRelated(List<RelatedClaimComponent> theRelated) {
        this.related = theRelated;
        return this;
    }

    public boolean hasRelated() {
        if (this.related == null) {
            return false;
        }
        for (RelatedClaimComponent item : this.related) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedClaimComponent addRelated() {
        RelatedClaimComponent t = new RelatedClaimComponent();
        if (this.related == null) {
            this.related = new ArrayList<RelatedClaimComponent>();
        }
        this.related.add(t);
        return t;
    }

    public Claim addRelated(RelatedClaimComponent t) {
        if (t == null) {
            return this;
        }
        if (this.related == null) {
            this.related = new ArrayList<RelatedClaimComponent>();
        }
        this.related.add(t);
        return this;
    }

    public RelatedClaimComponent getRelatedFirstRep() {
        if (this.getRelated().isEmpty()) {
            this.addRelated();
        }
        return this.getRelated().get(0);
    }

    public Reference getPrescription() {
        if (this.prescription == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.prescription");
            }
            if (Configuration.doAutoCreate()) {
                this.prescription = new Reference();
            }
        }
        return this.prescription;
    }

    public boolean hasPrescription() {
        return this.prescription != null && !this.prescription.isEmpty();
    }

    public Claim setPrescription(Reference value) {
        this.prescription = value;
        return this;
    }

    public Resource getPrescriptionTarget() {
        return this.prescriptionTarget;
    }

    public Claim setPrescriptionTarget(Resource value) {
        this.prescriptionTarget = value;
        return this;
    }

    public Reference getOriginalPrescription() {
        if (this.originalPrescription == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.originalPrescription");
            }
            if (Configuration.doAutoCreate()) {
                this.originalPrescription = new Reference();
            }
        }
        return this.originalPrescription;
    }

    public boolean hasOriginalPrescription() {
        return this.originalPrescription != null && !this.originalPrescription.isEmpty();
    }

    public Claim setOriginalPrescription(Reference value) {
        this.originalPrescription = value;
        return this;
    }

    public Resource getOriginalPrescriptionTarget() {
        return this.originalPrescriptionTarget;
    }

    public Claim setOriginalPrescriptionTarget(Resource value) {
        this.originalPrescriptionTarget = value;
        return this;
    }

    public PayeeComponent getPayee() {
        if (this.payee == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.payee");
            }
            if (Configuration.doAutoCreate()) {
                this.payee = new PayeeComponent();
            }
        }
        return this.payee;
    }

    public boolean hasPayee() {
        return this.payee != null && !this.payee.isEmpty();
    }

    public Claim setPayee(PayeeComponent value) {
        this.payee = value;
        return this;
    }

    public Reference getReferral() {
        if (this.referral == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.referral");
            }
            if (Configuration.doAutoCreate()) {
                this.referral = new Reference();
            }
        }
        return this.referral;
    }

    public boolean hasReferral() {
        return this.referral != null && !this.referral.isEmpty();
    }

    public Claim setReferral(Reference value) {
        this.referral = value;
        return this;
    }

    public ServiceRequest getReferralTarget() {
        if (this.referralTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.referral");
            }
            if (Configuration.doAutoCreate()) {
                this.referralTarget = new ServiceRequest();
            }
        }
        return this.referralTarget;
    }

    public Claim setReferralTarget(ServiceRequest value) {
        this.referralTarget = value;
        return this;
    }

    public Reference getFacility() {
        if (this.facility == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.facility");
            }
            if (Configuration.doAutoCreate()) {
                this.facility = new Reference();
            }
        }
        return this.facility;
    }

    public boolean hasFacility() {
        return this.facility != null && !this.facility.isEmpty();
    }

    public Claim setFacility(Reference value) {
        this.facility = value;
        return this;
    }

    public Location getFacilityTarget() {
        if (this.facilityTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.facility");
            }
            if (Configuration.doAutoCreate()) {
                this.facilityTarget = new Location();
            }
        }
        return this.facilityTarget;
    }

    public Claim setFacilityTarget(Location value) {
        this.facilityTarget = value;
        return this;
    }

    public List<CareTeamComponent> getCareTeam() {
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<CareTeamComponent>();
        }
        return this.careTeam;
    }

    public Claim setCareTeam(List<CareTeamComponent> theCareTeam) {
        this.careTeam = theCareTeam;
        return this;
    }

    public boolean hasCareTeam() {
        if (this.careTeam == null) {
            return false;
        }
        for (CareTeamComponent item : this.careTeam) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CareTeamComponent addCareTeam() {
        CareTeamComponent t = new CareTeamComponent();
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<CareTeamComponent>();
        }
        this.careTeam.add(t);
        return t;
    }

    public Claim addCareTeam(CareTeamComponent t) {
        if (t == null) {
            return this;
        }
        if (this.careTeam == null) {
            this.careTeam = new ArrayList<CareTeamComponent>();
        }
        this.careTeam.add(t);
        return this;
    }

    public CareTeamComponent getCareTeamFirstRep() {
        if (this.getCareTeam().isEmpty()) {
            this.addCareTeam();
        }
        return this.getCareTeam().get(0);
    }

    public List<SupportingInformationComponent> getSupportingInfo() {
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<SupportingInformationComponent>();
        }
        return this.supportingInfo;
    }

    public Claim setSupportingInfo(List<SupportingInformationComponent> theSupportingInfo) {
        this.supportingInfo = theSupportingInfo;
        return this;
    }

    public boolean hasSupportingInfo() {
        if (this.supportingInfo == null) {
            return false;
        }
        for (SupportingInformationComponent item : this.supportingInfo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SupportingInformationComponent addSupportingInfo() {
        SupportingInformationComponent t = new SupportingInformationComponent();
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<SupportingInformationComponent>();
        }
        this.supportingInfo.add(t);
        return t;
    }

    public Claim addSupportingInfo(SupportingInformationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<SupportingInformationComponent>();
        }
        this.supportingInfo.add(t);
        return this;
    }

    public SupportingInformationComponent getSupportingInfoFirstRep() {
        if (this.getSupportingInfo().isEmpty()) {
            this.addSupportingInfo();
        }
        return this.getSupportingInfo().get(0);
    }

    public List<DiagnosisComponent> getDiagnosis() {
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        return this.diagnosis;
    }

    public Claim setDiagnosis(List<DiagnosisComponent> theDiagnosis) {
        this.diagnosis = theDiagnosis;
        return this;
    }

    public boolean hasDiagnosis() {
        if (this.diagnosis == null) {
            return false;
        }
        for (DiagnosisComponent item : this.diagnosis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosisComponent addDiagnosis() {
        DiagnosisComponent t = new DiagnosisComponent();
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return t;
    }

    public Claim addDiagnosis(DiagnosisComponent t) {
        if (t == null) {
            return this;
        }
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return this;
    }

    public DiagnosisComponent getDiagnosisFirstRep() {
        if (this.getDiagnosis().isEmpty()) {
            this.addDiagnosis();
        }
        return this.getDiagnosis().get(0);
    }

    public List<ProcedureComponent> getProcedure() {
        if (this.procedure == null) {
            this.procedure = new ArrayList<ProcedureComponent>();
        }
        return this.procedure;
    }

    public Claim setProcedure(List<ProcedureComponent> theProcedure) {
        this.procedure = theProcedure;
        return this;
    }

    public boolean hasProcedure() {
        if (this.procedure == null) {
            return false;
        }
        for (ProcedureComponent item : this.procedure) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProcedureComponent addProcedure() {
        ProcedureComponent t = new ProcedureComponent();
        if (this.procedure == null) {
            this.procedure = new ArrayList<ProcedureComponent>();
        }
        this.procedure.add(t);
        return t;
    }

    public Claim addProcedure(ProcedureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.procedure == null) {
            this.procedure = new ArrayList<ProcedureComponent>();
        }
        this.procedure.add(t);
        return this;
    }

    public ProcedureComponent getProcedureFirstRep() {
        if (this.getProcedure().isEmpty()) {
            this.addProcedure();
        }
        return this.getProcedure().get(0);
    }

    public List<InsuranceComponent> getInsurance() {
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        return this.insurance;
    }

    public Claim setInsurance(List<InsuranceComponent> theInsurance) {
        this.insurance = theInsurance;
        return this;
    }

    public boolean hasInsurance() {
        if (this.insurance == null) {
            return false;
        }
        for (InsuranceComponent item : this.insurance) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InsuranceComponent addInsurance() {
        InsuranceComponent t = new InsuranceComponent();
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return t;
    }

    public Claim addInsurance(InsuranceComponent t) {
        if (t == null) {
            return this;
        }
        if (this.insurance == null) {
            this.insurance = new ArrayList<InsuranceComponent>();
        }
        this.insurance.add(t);
        return this;
    }

    public InsuranceComponent getInsuranceFirstRep() {
        if (this.getInsurance().isEmpty()) {
            this.addInsurance();
        }
        return this.getInsurance().get(0);
    }

    public AccidentComponent getAccident() {
        if (this.accident == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.accident");
            }
            if (Configuration.doAutoCreate()) {
                this.accident = new AccidentComponent();
            }
        }
        return this.accident;
    }

    public boolean hasAccident() {
        return this.accident != null && !this.accident.isEmpty();
    }

    public Claim setAccident(AccidentComponent value) {
        this.accident = value;
        return this;
    }

    public List<ItemComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        return this.item;
    }

    public Claim setItem(List<ItemComponent> theItem) {
        this.item = theItem;
        return this;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (ItemComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ItemComponent addItem() {
        ItemComponent t = new ItemComponent();
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        this.item.add(t);
        return t;
    }

    public Claim addItem(ItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<ItemComponent>();
        }
        this.item.add(t);
        return this;
    }

    public ItemComponent getItemFirstRep() {
        if (this.getItem().isEmpty()) {
            this.addItem();
        }
        return this.getItem().get(0);
    }

    public Money getTotal() {
        if (this.total == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Claim.total");
            }
            if (Configuration.doAutoCreate()) {
                this.total = new Money();
            }
        }
        return this.total;
    }

    public boolean hasTotal() {
        return this.total != null && !this.total.isEmpty();
    }

    public Claim setTotal(Money value) {
        this.total = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this claim.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property("type", "CodeableConcept", "The category of claim, e.g. oral, pharmacy, vision, institutional, professional.", 0, 1, this.type));
        children.add(new Property("subType", "CodeableConcept", "A finer grained suite of claim type codes which may convey additional information such as Inpatient vs Outpatient and/or a specialty service.", 0, 1, this.subType));
        children.add(new Property(SP_USE, "code", "A code to indicate whether the nature of the request is: to request adjudication of products and services previously rendered; or requesting authorization and adjudication for provision in the future; or requesting the non-binding adjudication of the listed products and services which could be provided in the future.", 0, 1, this.use));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The party to whom the professional services and/or products have been supplied or are being considered and for whom actual or forecast reimbursement is sought.", 0, 1, this.patient));
        children.add(new Property("billablePeriod", "Period", "The period for which charges are being submitted.", 0, 1, this.billablePeriod));
        children.add(new Property(SP_CREATED, "dateTime", "The date this resource was created.", 0, 1, this.created));
        children.add(new Property(SP_ENTERER, "Reference(Practitioner|PractitionerRole)", "Individual who created the claim, predetermination or preauthorization.", 0, 1, this.enterer));
        children.add(new Property(SP_INSURER, "Reference(Organization)", "The Insurer who is target of the request.", 0, 1, this.insurer));
        children.add(new Property(SP_PROVIDER, "Reference(Practitioner|PractitionerRole|Organization)", "The provider which is responsible for the claim, predetermination or preauthorization.", 0, 1, this.provider));
        children.add(new Property(SP_PRIORITY, "CodeableConcept", "The provider-required urgency of processing the request. Typical values include: stat, routine deferred.", 0, 1, this.priority));
        children.add(new Property("fundsReserve", "CodeableConcept", "A code to indicate whether and for whom funds are to be reserved for future claims.", 0, 1, this.fundsReserve));
        children.add(new Property("related", "", "Other claims which are related to this claim such as prior submissions or claims for related services or for the same event.", 0, Integer.MAX_VALUE, this.related));
        children.add(new Property("prescription", "Reference(DeviceRequest|MedicationRequest|VisionPrescription)", "Prescription to support the dispensing of pharmacy, device or vision products.", 0, 1, this.prescription));
        children.add(new Property("originalPrescription", "Reference(DeviceRequest|MedicationRequest|VisionPrescription)", "Original prescription which has been superseded by this prescription to support the dispensing of pharmacy services, medications or products.", 0, 1, this.originalPrescription));
        children.add(new Property(SP_PAYEE, "", "The party to be reimbursed for cost of the products and services according to the terms of the policy.", 0, 1, this.payee));
        children.add(new Property("referral", "Reference(ServiceRequest)", "A reference to a referral resource.", 0, 1, this.referral));
        children.add(new Property(SP_FACILITY, "Reference(Location)", "Facility where the services were provided.", 0, 1, this.facility));
        children.add(new Property("careTeam", "", "The members of the team who provided the products and services.", 0, Integer.MAX_VALUE, this.careTeam));
        children.add(new Property("supportingInfo", "", "Additional information codes regarding exceptions, special considerations, the condition, situation, prior or concurrent issues.", 0, Integer.MAX_VALUE, this.supportingInfo));
        children.add(new Property("diagnosis", "", "Information about diagnoses relevant to the claim items.", 0, Integer.MAX_VALUE, this.diagnosis));
        children.add(new Property("procedure", "", "Procedures performed on the patient relevant to the billing items with the claim.", 0, Integer.MAX_VALUE, this.procedure));
        children.add(new Property("insurance", "", "Financial instruments for reimbursement for the health care products and services specified on the claim.", 0, Integer.MAX_VALUE, this.insurance));
        children.add(new Property("accident", "", "Details of an accident which resulted in injuries which required the products and services listed in the claim.", 0, 1, this.accident));
        children.add(new Property("item", "", "A claim line. Either a simple  product or service or a 'group' of details which can each be a simple items or groups of sub-details.", 0, Integer.MAX_VALUE, this.item));
        children.add(new Property("total", "Money", "The total value of the all the items in the claim.", 0, 1, this.total));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this claim.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "The category of claim, e.g. oral, pharmacy, vision, institutional, professional.", 0, 1, this.type);
            }
            case -1868521062: {
                return new Property("subType", "CodeableConcept", "A finer grained suite of claim type codes which may convey additional information such as Inpatient vs Outpatient and/or a specialty service.", 0, 1, this.subType);
            }
            case 116103: {
                return new Property(SP_USE, "code", "A code to indicate whether the nature of the request is: to request adjudication of products and services previously rendered; or requesting authorization and adjudication for provision in the future; or requesting the non-binding adjudication of the listed products and services which could be provided in the future.", 0, 1, this.use);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The party to whom the professional services and/or products have been supplied or are being considered and for whom actual or forecast reimbursement is sought.", 0, 1, this.patient);
            }
            case -332066046: {
                return new Property("billablePeriod", "Period", "The period for which charges are being submitted.", 0, 1, this.billablePeriod);
            }
            case 1028554472: {
                return new Property(SP_CREATED, "dateTime", "The date this resource was created.", 0, 1, this.created);
            }
            case -1591951995: {
                return new Property(SP_ENTERER, "Reference(Practitioner|PractitionerRole)", "Individual who created the claim, predetermination or preauthorization.", 0, 1, this.enterer);
            }
            case 1957615864: {
                return new Property(SP_INSURER, "Reference(Organization)", "The Insurer who is target of the request.", 0, 1, this.insurer);
            }
            case -987494927: {
                return new Property(SP_PROVIDER, "Reference(Practitioner|PractitionerRole|Organization)", "The provider which is responsible for the claim, predetermination or preauthorization.", 0, 1, this.provider);
            }
            case -1165461084: {
                return new Property(SP_PRIORITY, "CodeableConcept", "The provider-required urgency of processing the request. Typical values include: stat, routine deferred.", 0, 1, this.priority);
            }
            case 1314609806: {
                return new Property("fundsReserve", "CodeableConcept", "A code to indicate whether and for whom funds are to be reserved for future claims.", 0, 1, this.fundsReserve);
            }
            case 1090493483: {
                return new Property("related", "", "Other claims which are related to this claim such as prior submissions or claims for related services or for the same event.", 0, Integer.MAX_VALUE, this.related);
            }
            case 460301338: {
                return new Property("prescription", "Reference(DeviceRequest|MedicationRequest|VisionPrescription)", "Prescription to support the dispensing of pharmacy, device or vision products.", 0, 1, this.prescription);
            }
            case -1814015861: {
                return new Property("originalPrescription", "Reference(DeviceRequest|MedicationRequest|VisionPrescription)", "Original prescription which has been superseded by this prescription to support the dispensing of pharmacy services, medications or products.", 0, 1, this.originalPrescription);
            }
            case 106443592: {
                return new Property(SP_PAYEE, "", "The party to be reimbursed for cost of the products and services according to the terms of the policy.", 0, 1, this.payee);
            }
            case -722568291: {
                return new Property("referral", "Reference(ServiceRequest)", "A reference to a referral resource.", 0, 1, this.referral);
            }
            case 501116579: {
                return new Property(SP_FACILITY, "Reference(Location)", "Facility where the services were provided.", 0, 1, this.facility);
            }
            case -7323378: {
                return new Property("careTeam", "", "The members of the team who provided the products and services.", 0, Integer.MAX_VALUE, this.careTeam);
            }
            case 1922406657: {
                return new Property("supportingInfo", "", "Additional information codes regarding exceptions, special considerations, the condition, situation, prior or concurrent issues.", 0, Integer.MAX_VALUE, this.supportingInfo);
            }
            case 1196993265: {
                return new Property("diagnosis", "", "Information about diagnoses relevant to the claim items.", 0, Integer.MAX_VALUE, this.diagnosis);
            }
            case -1095204141: {
                return new Property("procedure", "", "Procedures performed on the patient relevant to the billing items with the claim.", 0, Integer.MAX_VALUE, this.procedure);
            }
            case 73049818: {
                return new Property("insurance", "", "Financial instruments for reimbursement for the health care products and services specified on the claim.", 0, Integer.MAX_VALUE, this.insurance);
            }
            case -2143202801: {
                return new Property("accident", "", "Details of an accident which resulted in injuries which required the products and services listed in the claim.", 0, 1, this.accident);
            }
            case 3242771: {
                return new Property("item", "", "A claim line. Either a simple  product or service or a 'group' of details which can each be a simple items or groups of sub-details.", 0, Integer.MAX_VALUE, this.item);
            }
            case 110549828: {
                return new Property("total", "Money", "The total value of the all the items in the claim.", 0, 1, this.total);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -1868521062: {
                Base[] baseArray;
                if (this.subType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.subType;
                }
                return baseArray;
            }
            case 116103: {
                Base[] baseArray;
                if (this.use == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.use;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.patient;
                }
                return baseArray;
            }
            case -332066046: {
                Base[] baseArray;
                if (this.billablePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.billablePeriod;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.created;
                }
                return baseArray;
            }
            case -1591951995: {
                Base[] baseArray;
                if (this.enterer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.enterer;
                }
                return baseArray;
            }
            case 1957615864: {
                Base[] baseArray;
                if (this.insurer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.insurer;
                }
                return baseArray;
            }
            case -987494927: {
                Base[] baseArray;
                if (this.provider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.provider;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.priority;
                }
                return baseArray;
            }
            case 1314609806: {
                Base[] baseArray;
                if (this.fundsReserve == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.fundsReserve;
                }
                return baseArray;
            }
            case 1090493483: {
                return this.related == null ? new Base[]{} : this.related.toArray(new Base[this.related.size()]);
            }
            case 460301338: {
                Base[] baseArray;
                if (this.prescription == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.prescription;
                }
                return baseArray;
            }
            case -1814015861: {
                Base[] baseArray;
                if (this.originalPrescription == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.originalPrescription;
                }
                return baseArray;
            }
            case 106443592: {
                Base[] baseArray;
                if (this.payee == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.payee;
                }
                return baseArray;
            }
            case -722568291: {
                Base[] baseArray;
                if (this.referral == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.referral;
                }
                return baseArray;
            }
            case 501116579: {
                Base[] baseArray;
                if (this.facility == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.facility;
                }
                return baseArray;
            }
            case -7323378: {
                return this.careTeam == null ? new Base[]{} : this.careTeam.toArray(new Base[this.careTeam.size()]);
            }
            case 1922406657: {
                return this.supportingInfo == null ? new Base[]{} : this.supportingInfo.toArray(new Base[this.supportingInfo.size()]);
            }
            case 1196993265: {
                return this.diagnosis == null ? new Base[]{} : this.diagnosis.toArray(new Base[this.diagnosis.size()]);
            }
            case -1095204141: {
                return this.procedure == null ? new Base[]{} : this.procedure.toArray(new Base[this.procedure.size()]);
            }
            case 73049818: {
                return this.insurance == null ? new Base[]{} : this.insurance.toArray(new Base[this.insurance.size()]);
            }
            case -2143202801: {
                Base[] baseArray;
                if (this.accident == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.accident;
                }
                return baseArray;
            }
            case 3242771: {
                return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
            }
            case 110549828: {
                Base[] baseArray;
                if (this.total == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.total;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ClaimStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.type = this.castToCodeableConcept(value);
                return value;
            }
            case -1868521062: {
                this.subType = this.castToCodeableConcept(value);
                return value;
            }
            case 116103: {
                value = new UseEnumFactory().fromType(this.castToCode(value));
                this.use = value;
                return value;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                return value;
            }
            case -332066046: {
                this.billablePeriod = this.castToPeriod(value);
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case -1591951995: {
                this.enterer = this.castToReference(value);
                return value;
            }
            case 1957615864: {
                this.insurer = this.castToReference(value);
                return value;
            }
            case -987494927: {
                this.provider = this.castToReference(value);
                return value;
            }
            case -1165461084: {
                this.priority = this.castToCodeableConcept(value);
                return value;
            }
            case 1314609806: {
                this.fundsReserve = this.castToCodeableConcept(value);
                return value;
            }
            case 1090493483: {
                this.getRelated().add((RelatedClaimComponent)((Object)value));
                return value;
            }
            case 460301338: {
                this.prescription = this.castToReference(value);
                return value;
            }
            case -1814015861: {
                this.originalPrescription = this.castToReference(value);
                return value;
            }
            case 106443592: {
                this.payee = (PayeeComponent)((Object)value);
                return value;
            }
            case -722568291: {
                this.referral = this.castToReference(value);
                return value;
            }
            case 501116579: {
                this.facility = this.castToReference(value);
                return value;
            }
            case -7323378: {
                this.getCareTeam().add((CareTeamComponent)((Object)value));
                return value;
            }
            case 1922406657: {
                this.getSupportingInfo().add((SupportingInformationComponent)((Object)value));
                return value;
            }
            case 1196993265: {
                this.getDiagnosis().add((DiagnosisComponent)((Object)value));
                return value;
            }
            case -1095204141: {
                this.getProcedure().add((ProcedureComponent)((Object)value));
                return value;
            }
            case 73049818: {
                this.getInsurance().add((InsuranceComponent)((Object)value));
                return value;
            }
            case -2143202801: {
                this.accident = (AccidentComponent)((Object)value);
                return value;
            }
            case 3242771: {
                this.getItem().add((ItemComponent)((Object)value));
                return value;
            }
            case 110549828: {
                this.total = this.castToMoney(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ClaimStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("subType")) {
            this.subType = this.castToCodeableConcept(value);
        } else if (name.equals(SP_USE)) {
            value = new UseEnumFactory().fromType(this.castToCode(value));
            this.use = value;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("billablePeriod")) {
            this.billablePeriod = this.castToPeriod(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals(SP_ENTERER)) {
            this.enterer = this.castToReference(value);
        } else if (name.equals(SP_INSURER)) {
            this.insurer = this.castToReference(value);
        } else if (name.equals(SP_PROVIDER)) {
            this.provider = this.castToReference(value);
        } else if (name.equals(SP_PRIORITY)) {
            this.priority = this.castToCodeableConcept(value);
        } else if (name.equals("fundsReserve")) {
            this.fundsReserve = this.castToCodeableConcept(value);
        } else if (name.equals("related")) {
            this.getRelated().add((RelatedClaimComponent)((Object)value));
        } else if (name.equals("prescription")) {
            this.prescription = this.castToReference(value);
        } else if (name.equals("originalPrescription")) {
            this.originalPrescription = this.castToReference(value);
        } else if (name.equals(SP_PAYEE)) {
            this.payee = (PayeeComponent)((Object)value);
        } else if (name.equals("referral")) {
            this.referral = this.castToReference(value);
        } else if (name.equals(SP_FACILITY)) {
            this.facility = this.castToReference(value);
        } else if (name.equals("careTeam")) {
            this.getCareTeam().add((CareTeamComponent)((Object)value));
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().add((SupportingInformationComponent)((Object)value));
        } else if (name.equals("diagnosis")) {
            this.getDiagnosis().add((DiagnosisComponent)((Object)value));
        } else if (name.equals("procedure")) {
            this.getProcedure().add((ProcedureComponent)((Object)value));
        } else if (name.equals("insurance")) {
            this.getInsurance().add((InsuranceComponent)((Object)value));
        } else if (name.equals("accident")) {
            this.accident = (AccidentComponent)((Object)value);
        } else if (name.equals("item")) {
            this.getItem().add((ItemComponent)((Object)value));
        } else if (name.equals("total")) {
            this.total = this.castToMoney(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = null;
        } else if (name.equals("type")) {
            this.type = null;
        } else if (name.equals("subType")) {
            this.subType = null;
        } else if (name.equals(SP_USE)) {
            this.use = null;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = null;
        } else if (name.equals("billablePeriod")) {
            this.billablePeriod = null;
        } else if (name.equals(SP_CREATED)) {
            this.created = null;
        } else if (name.equals(SP_ENTERER)) {
            this.enterer = null;
        } else if (name.equals(SP_INSURER)) {
            this.insurer = null;
        } else if (name.equals(SP_PROVIDER)) {
            this.provider = null;
        } else if (name.equals(SP_PRIORITY)) {
            this.priority = null;
        } else if (name.equals("fundsReserve")) {
            this.fundsReserve = null;
        } else if (name.equals("related")) {
            this.getRelated().remove((RelatedClaimComponent)value);
        } else if (name.equals("prescription")) {
            this.prescription = null;
        } else if (name.equals("originalPrescription")) {
            this.originalPrescription = null;
        } else if (name.equals(SP_PAYEE)) {
            this.payee = (PayeeComponent)value;
        } else if (name.equals("referral")) {
            this.referral = null;
        } else if (name.equals(SP_FACILITY)) {
            this.facility = null;
        } else if (name.equals("careTeam")) {
            this.getCareTeam().remove((CareTeamComponent)value);
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().remove((SupportingInformationComponent)value);
        } else if (name.equals("diagnosis")) {
            this.getDiagnosis().remove((DiagnosisComponent)value);
        } else if (name.equals("procedure")) {
            this.getProcedure().remove((ProcedureComponent)value);
        } else if (name.equals("insurance")) {
            this.getInsurance().remove((InsuranceComponent)value);
        } else if (name.equals("accident")) {
            this.accident = (AccidentComponent)value;
        } else if (name.equals("item")) {
            this.getItem().remove((ItemComponent)value);
        } else if (name.equals("total")) {
            this.total = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case -1868521062: {
                return this.getSubType();
            }
            case 116103: {
                return this.getUseElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -332066046: {
                return this.getBillablePeriod();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case -1591951995: {
                return this.getEnterer();
            }
            case 1957615864: {
                return this.getInsurer();
            }
            case -987494927: {
                return this.getProvider();
            }
            case -1165461084: {
                return this.getPriority();
            }
            case 1314609806: {
                return this.getFundsReserve();
            }
            case 1090493483: {
                return this.addRelated();
            }
            case 460301338: {
                return this.getPrescription();
            }
            case -1814015861: {
                return this.getOriginalPrescription();
            }
            case 106443592: {
                return this.getPayee();
            }
            case -722568291: {
                return this.getReferral();
            }
            case 501116579: {
                return this.getFacility();
            }
            case -7323378: {
                return this.addCareTeam();
            }
            case 1922406657: {
                return this.addSupportingInfo();
            }
            case 1196993265: {
                return this.addDiagnosis();
            }
            case -1095204141: {
                return this.addProcedure();
            }
            case 73049818: {
                return this.addInsurance();
            }
            case -2143202801: {
                return this.getAccident();
            }
            case 3242771: {
                return this.addItem();
            }
            case 110549828: {
                return this.getTotal();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1868521062: {
                return new String[]{"CodeableConcept"};
            }
            case 116103: {
                return new String[]{"code"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case -332066046: {
                return new String[]{"Period"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case -1591951995: {
                return new String[]{"Reference"};
            }
            case 1957615864: {
                return new String[]{"Reference"};
            }
            case -987494927: {
                return new String[]{"Reference"};
            }
            case -1165461084: {
                return new String[]{"CodeableConcept"};
            }
            case 1314609806: {
                return new String[]{"CodeableConcept"};
            }
            case 1090493483: {
                return new String[0];
            }
            case 460301338: {
                return new String[]{"Reference"};
            }
            case -1814015861: {
                return new String[]{"Reference"};
            }
            case 106443592: {
                return new String[0];
            }
            case -722568291: {
                return new String[]{"Reference"};
            }
            case 501116579: {
                return new String[]{"Reference"};
            }
            case -7323378: {
                return new String[0];
            }
            case 1922406657: {
                return new String[0];
            }
            case 1196993265: {
                return new String[0];
            }
            case -1095204141: {
                return new String[0];
            }
            case 73049818: {
                return new String[0];
            }
            case -2143202801: {
                return new String[0];
            }
            case 3242771: {
                return new String[0];
            }
            case 110549828: {
                return new String[]{"Money"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Claim.status");
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("subType")) {
            this.subType = new CodeableConcept();
            return this.subType;
        }
        if (name.equals(SP_USE)) {
            throw new FHIRException("Cannot call addChild on a singleton property Claim.use");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("billablePeriod")) {
            this.billablePeriod = new Period();
            return this.billablePeriod;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a singleton property Claim.created");
        }
        if (name.equals(SP_ENTERER)) {
            this.enterer = new Reference();
            return this.enterer;
        }
        if (name.equals(SP_INSURER)) {
            this.insurer = new Reference();
            return this.insurer;
        }
        if (name.equals(SP_PROVIDER)) {
            this.provider = new Reference();
            return this.provider;
        }
        if (name.equals(SP_PRIORITY)) {
            this.priority = new CodeableConcept();
            return this.priority;
        }
        if (name.equals("fundsReserve")) {
            this.fundsReserve = new CodeableConcept();
            return this.fundsReserve;
        }
        if (name.equals("related")) {
            return this.addRelated();
        }
        if (name.equals("prescription")) {
            this.prescription = new Reference();
            return this.prescription;
        }
        if (name.equals("originalPrescription")) {
            this.originalPrescription = new Reference();
            return this.originalPrescription;
        }
        if (name.equals(SP_PAYEE)) {
            this.payee = new PayeeComponent();
            return this.payee;
        }
        if (name.equals("referral")) {
            this.referral = new Reference();
            return this.referral;
        }
        if (name.equals(SP_FACILITY)) {
            this.facility = new Reference();
            return this.facility;
        }
        if (name.equals("careTeam")) {
            return this.addCareTeam();
        }
        if (name.equals("supportingInfo")) {
            return this.addSupportingInfo();
        }
        if (name.equals("diagnosis")) {
            return this.addDiagnosis();
        }
        if (name.equals("procedure")) {
            return this.addProcedure();
        }
        if (name.equals("insurance")) {
            return this.addInsurance();
        }
        if (name.equals("accident")) {
            this.accident = new AccidentComponent();
            return this.accident;
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        if (name.equals("total")) {
            this.total = new Money();
            return this.total;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Claim";
    }

    @Override
    public Claim copy() {
        Claim dst = new Claim();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Claim dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.subType = this.subType == null ? null : this.subType.copy();
        dst.use = this.use == null ? null : this.use.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.billablePeriod = this.billablePeriod == null ? null : this.billablePeriod.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.enterer = this.enterer == null ? null : this.enterer.copy();
        dst.insurer = this.insurer == null ? null : this.insurer.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        CodeableConcept codeableConcept = dst.fundsReserve = this.fundsReserve == null ? null : this.fundsReserve.copy();
        if (this.related != null) {
            dst.related = new ArrayList<RelatedClaimComponent>();
            for (RelatedClaimComponent relatedClaimComponent : this.related) {
                dst.related.add(relatedClaimComponent.copy());
            }
        }
        dst.prescription = this.prescription == null ? null : this.prescription.copy();
        dst.originalPrescription = this.originalPrescription == null ? null : this.originalPrescription.copy();
        dst.payee = this.payee == null ? null : this.payee.copy();
        dst.referral = this.referral == null ? null : this.referral.copy();
        Reference reference = dst.facility = this.facility == null ? null : this.facility.copy();
        if (this.careTeam != null) {
            dst.careTeam = new ArrayList<CareTeamComponent>();
            for (CareTeamComponent careTeamComponent : this.careTeam) {
                dst.careTeam.add(careTeamComponent.copy());
            }
        }
        if (this.supportingInfo != null) {
            dst.supportingInfo = new ArrayList<SupportingInformationComponent>();
            for (SupportingInformationComponent supportingInformationComponent : this.supportingInfo) {
                dst.supportingInfo.add(supportingInformationComponent.copy());
            }
        }
        if (this.diagnosis != null) {
            dst.diagnosis = new ArrayList<DiagnosisComponent>();
            for (DiagnosisComponent diagnosisComponent : this.diagnosis) {
                dst.diagnosis.add(diagnosisComponent.copy());
            }
        }
        if (this.procedure != null) {
            dst.procedure = new ArrayList<ProcedureComponent>();
            for (ProcedureComponent procedureComponent : this.procedure) {
                dst.procedure.add(procedureComponent.copy());
            }
        }
        if (this.insurance != null) {
            dst.insurance = new ArrayList<InsuranceComponent>();
            for (InsuranceComponent insuranceComponent : this.insurance) {
                dst.insurance.add(insuranceComponent.copy());
            }
        }
        AccidentComponent accidentComponent = dst.accident = this.accident == null ? null : this.accident.copy();
        if (this.item != null) {
            dst.item = new ArrayList<ItemComponent>();
            for (ItemComponent itemComponent : this.item) {
                dst.item.add(itemComponent.copy());
            }
        }
        dst.total = this.total == null ? null : this.total.copy();
    }

    protected Claim typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Claim)) {
            return false;
        }
        Claim o = (Claim)other_;
        return Claim.compareDeep(this.identifier, o.identifier, true) && Claim.compareDeep(this.status, o.status, true) && Claim.compareDeep(this.type, o.type, true) && Claim.compareDeep(this.subType, o.subType, true) && Claim.compareDeep(this.use, o.use, true) && Claim.compareDeep(this.patient, o.patient, true) && Claim.compareDeep(this.billablePeriod, o.billablePeriod, true) && Claim.compareDeep(this.created, o.created, true) && Claim.compareDeep(this.enterer, o.enterer, true) && Claim.compareDeep(this.insurer, o.insurer, true) && Claim.compareDeep(this.provider, o.provider, true) && Claim.compareDeep(this.priority, o.priority, true) && Claim.compareDeep(this.fundsReserve, o.fundsReserve, true) && Claim.compareDeep(this.related, o.related, true) && Claim.compareDeep(this.prescription, o.prescription, true) && Claim.compareDeep(this.originalPrescription, o.originalPrescription, true) && Claim.compareDeep(this.payee, o.payee, true) && Claim.compareDeep(this.referral, o.referral, true) && Claim.compareDeep(this.facility, o.facility, true) && Claim.compareDeep(this.careTeam, o.careTeam, true) && Claim.compareDeep(this.supportingInfo, o.supportingInfo, true) && Claim.compareDeep(this.diagnosis, o.diagnosis, true) && Claim.compareDeep(this.procedure, o.procedure, true) && Claim.compareDeep(this.insurance, o.insurance, true) && Claim.compareDeep(this.accident, o.accident, true) && Claim.compareDeep(this.item, o.item, true) && Claim.compareDeep(this.total, o.total, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Claim)) {
            return false;
        }
        Claim o = (Claim)other_;
        return Claim.compareValues(this.status, o.status, true) && Claim.compareValues(this.use, o.use, true) && Claim.compareValues(this.created, o.created, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.type, this.subType, this.use, this.patient, this.billablePeriod, this.created, this.enterer, this.insurer, this.provider, this.priority, this.fundsReserve, this.related, this.prescription, this.originalPrescription, this.payee, this.referral, this.facility, this.careTeam, this.supportingInfo, this.diagnosis, this.procedure, this.insurance, this.accident, this.item, this.total});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Claim;
    }

    @Block
    public static class SubDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Item instance identifier", formalDefinition="A number to uniquely identify item entries.")
        protected PositiveIntType sequence;
        @Child(name="revenue", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Revenue or cost center code", formalDefinition="The type of revenue or cost center providing the product and/or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-revenue-center")
        protected CodeableConcept revenue;
        @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Benefit classification", formalDefinition="Code to identify the general type of benefits under which products and services are provided.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-benefitcategory")
        protected CodeableConcept category;
        @Child(name="productOrService", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing, service, product, or drug code", formalDefinition="When the value is a group code then this item collects a set of related claim details, otherwise this contains the product, service, drug or other billing code for the item.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept productOrService;
        @Child(name="modifier", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes to convey additional context for the product or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="programCode", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Program the product or service is provided under", formalDefinition="Identifies the program under which this may be recovered.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
        protected List<CodeableConcept> programCode;
        @Child(name="quantity", type={Quantity.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of products or services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per item", formalDefinition="If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="net", type={Money.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total item cost", formalDefinition="The quantity times the unit price for an additional service or product or charge.")
        protected Money net;
        @Child(name="udi", type={Device.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Unique device identifier", formalDefinition="Unique Device Identifiers associated with this line item.")
        protected List<Reference> udi;
        protected List<Device> udiTarget;
        private static final long serialVersionUID = 1133026301L;

        public SubDetailComponent() {
        }

        public SubDetailComponent(PositiveIntType sequence, CodeableConcept productOrService) {
            this.sequence = sequence;
            this.productOrService = productOrService;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public SubDetailComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public SubDetailComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public CodeableConcept getRevenue() {
            if (this.revenue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.revenue");
                }
                if (Configuration.doAutoCreate()) {
                    this.revenue = new CodeableConcept();
                }
            }
            return this.revenue;
        }

        public boolean hasRevenue() {
            return this.revenue != null && !this.revenue.isEmpty();
        }

        public SubDetailComponent setRevenue(CodeableConcept value) {
            this.revenue = value;
            return this;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public SubDetailComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getProductOrService() {
            if (this.productOrService == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.productOrService");
                }
                if (Configuration.doAutoCreate()) {
                    this.productOrService = new CodeableConcept();
                }
            }
            return this.productOrService;
        }

        public boolean hasProductOrService() {
            return this.productOrService != null && !this.productOrService.isEmpty();
        }

        public SubDetailComponent setProductOrService(CodeableConcept value) {
            this.productOrService = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public SubDetailComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public SubDetailComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public List<CodeableConcept> getProgramCode() {
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            return this.programCode;
        }

        public SubDetailComponent setProgramCode(List<CodeableConcept> theProgramCode) {
            this.programCode = theProgramCode;
            return this;
        }

        public boolean hasProgramCode() {
            if (this.programCode == null) {
                return false;
            }
            for (CodeableConcept item : this.programCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addProgramCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return t;
        }

        public SubDetailComponent addProgramCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return this;
        }

        public CodeableConcept getProgramCodeFirstRep() {
            if (this.getProgramCode().isEmpty()) {
                this.addProgramCode();
            }
            return this.getProgramCode().get(0);
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public SubDetailComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public SubDetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public SubDetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public SubDetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public SubDetailComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public SubDetailComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public SubDetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<Reference> getUdi() {
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            return this.udi;
        }

        public SubDetailComponent setUdi(List<Reference> theUdi) {
            this.udi = theUdi;
            return this;
        }

        public boolean hasUdi() {
            if (this.udi == null) {
                return false;
            }
            for (Reference item : this.udi) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addUdi() {
            Reference t = new Reference();
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return t;
        }

        public SubDetailComponent addUdi(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return this;
        }

        public Reference getUdiFirstRep() {
            if (this.getUdi().isEmpty()) {
                this.addUdi();
            }
            return this.getUdi().get(0);
        }

        @Deprecated
        public List<Device> getUdiTarget() {
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            return this.udiTarget;
        }

        @Deprecated
        public Device addUdiTarget() {
            Device r = new Device();
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            this.udiTarget.add(r);
            return r;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A number to uniquely identify item entries.", 0, 1, this.sequence));
            children.add(new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue));
            children.add(new Property("category", "CodeableConcept", "Code to identify the general type of benefits under which products and services are provided.", 0, 1, this.category));
            children.add(new Property("productOrService", "CodeableConcept", "When the value is a group code then this item collects a set of related claim details, otherwise this contains the product, service, drug or other billing code for the item.", 0, 1, this.productOrService));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("programCode", "CodeableConcept", "Identifies the program under which this may be recovered.", 0, Integer.MAX_VALUE, this.programCode));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge.", 0, 1, this.net));
            children.add(new Property("udi", "Reference(Device)", "Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A number to uniquely identify item entries.", 0, 1, this.sequence);
                }
                case 1099842588: {
                    return new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Code to identify the general type of benefits under which products and services are provided.", 0, 1, this.category);
                }
                case 1957227299: {
                    return new Property("productOrService", "CodeableConcept", "When the value is a group code then this item collects a set of related claim details, otherwise this contains the product, service, drug or other billing code for the item.", 0, 1, this.productOrService);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case 1010065041: {
                    return new Property("programCode", "CodeableConcept", "Identifies the program under which this may be recovered.", 0, Integer.MAX_VALUE, this.programCode);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 108957: {
                    return new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge.", 0, 1, this.net);
                }
                case 115642: {
                    return new Property("udi", "Reference(Device)", "Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1099842588: {
                    Base[] baseArray;
                    if (this.revenue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.revenue;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.category;
                    }
                    return baseArray;
                }
                case 1957227299: {
                    Base[] baseArray;
                    if (this.productOrService == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.productOrService;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case 1010065041: {
                    return this.programCode == null ? new Base[]{} : this.programCode.toArray(new Base[this.programCode.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.factor;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.net;
                    }
                    return baseArray;
                }
                case 115642: {
                    return this.udi == null ? new Base[]{} : this.udi.toArray(new Base[this.udi.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 1099842588: {
                    this.revenue = this.castToCodeableConcept(value);
                    return value;
                }
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 1957227299: {
                    this.productOrService = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1010065041: {
                    this.getProgramCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case 115642: {
                    this.getUdi().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("revenue")) {
                this.revenue = this.castToCodeableConcept(value);
            } else if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("productOrService")) {
                this.productOrService = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("udi")) {
                this.getUdi().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = null;
            } else if (name.equals("revenue")) {
                this.revenue = null;
            } else if (name.equals("category")) {
                this.category = null;
            } else if (name.equals("productOrService")) {
                this.productOrService = null;
            } else if (name.equals("modifier")) {
                this.getModifier().remove(this.castToCodeableConcept(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().remove(this.castToCodeableConcept(value));
            } else if (name.equals("quantity")) {
                this.quantity = null;
            } else if (name.equals("unitPrice")) {
                this.unitPrice = null;
            } else if (name.equals("factor")) {
                this.factor = null;
            } else if (name.equals("net")) {
                this.net = null;
            } else if (name.equals("udi")) {
                this.getUdi().remove(this.castToReference(value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 1099842588: {
                    return this.getRevenue();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case 1957227299: {
                    return this.getProductOrService();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case 1010065041: {
                    return this.addProgramCode();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case 115642: {
                    return this.addUdi();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 1099842588: {
                    return new String[]{"CodeableConcept"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 1957227299: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case 1010065041: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case 115642: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.sequence");
            }
            if (name.equals("revenue")) {
                this.revenue = new CodeableConcept();
                return this.revenue;
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("productOrService")) {
                this.productOrService = new CodeableConcept();
                return this.productOrService;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("programCode")) {
                return this.addProgramCode();
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.factor");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("udi")) {
                return this.addUdi();
            }
            return super.addChild(name);
        }

        @Override
        public SubDetailComponent copy() {
            SubDetailComponent dst = new SubDetailComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SubDetailComponent dst) {
            super.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.revenue = this.revenue == null ? null : this.revenue.copy();
            dst.category = this.category == null ? null : this.category.copy();
            CodeableConcept codeableConcept = dst.productOrService = this.productOrService == null ? null : this.productOrService.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            if (this.programCode != null) {
                dst.programCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.programCode) {
                    dst.programCode.add(codeableConcept3.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.udi != null) {
                dst.udi = new ArrayList<Reference>();
                for (Reference reference : this.udi) {
                    dst.udi.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other_;
            return SubDetailComponent.compareDeep(this.sequence, o.sequence, true) && SubDetailComponent.compareDeep(this.revenue, o.revenue, true) && SubDetailComponent.compareDeep(this.category, o.category, true) && SubDetailComponent.compareDeep(this.productOrService, o.productOrService, true) && SubDetailComponent.compareDeep(this.modifier, o.modifier, true) && SubDetailComponent.compareDeep(this.programCode, o.programCode, true) && SubDetailComponent.compareDeep(this.quantity, o.quantity, true) && SubDetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && SubDetailComponent.compareDeep(this.factor, o.factor, true) && SubDetailComponent.compareDeep(this.net, o.net, true) && SubDetailComponent.compareDeep(this.udi, o.udi, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other_;
            return SubDetailComponent.compareValues(this.sequence, o.sequence, true) && SubDetailComponent.compareValues(this.factor, o.factor, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.revenue, this.category, this.productOrService, this.modifier, this.programCode, this.quantity, this.unitPrice, this.factor, this.net, this.udi});
        }

        @Override
        public String fhirType() {
            return "Claim.item.detail.subDetail";
        }
    }

    @Block
    public static class DetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Item instance identifier", formalDefinition="A number to uniquely identify item entries.")
        protected PositiveIntType sequence;
        @Child(name="revenue", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Revenue or cost center code", formalDefinition="The type of revenue or cost center providing the product and/or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-revenue-center")
        protected CodeableConcept revenue;
        @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Benefit classification", formalDefinition="Code to identify the general type of benefits under which products and services are provided.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-benefitcategory")
        protected CodeableConcept category;
        @Child(name="productOrService", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing, service, product, or drug code", formalDefinition="When the value is a group code then this item collects a set of related claim details, otherwise this contains the product, service, drug or other billing code for the item.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept productOrService;
        @Child(name="modifier", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Service/Product billing modifiers", formalDefinition="Item typification or modifiers codes to convey additional context for the product or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="programCode", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Program the product or service is provided under", formalDefinition="Identifies the program under which this may be recovered.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
        protected List<CodeableConcept> programCode;
        @Child(name="quantity", type={Quantity.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of products or services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per item", formalDefinition="If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="net", type={Money.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total item cost", formalDefinition="The quantity times the unit price for an additional service or product or charge.")
        protected Money net;
        @Child(name="udi", type={Device.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Unique device identifier", formalDefinition="Unique Device Identifiers associated with this line item.")
        protected List<Reference> udi;
        protected List<Device> udiTarget;
        @Child(name="subDetail", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Product or service provided", formalDefinition="A claim detail line. Either a simple (a product or service) or a 'group' of sub-details which are simple items.")
        protected List<SubDetailComponent> subDetail;
        private static final long serialVersionUID = -1245004924L;

        public DetailComponent() {
        }

        public DetailComponent(PositiveIntType sequence, CodeableConcept productOrService) {
            this.sequence = sequence;
            this.productOrService = productOrService;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public DetailComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public DetailComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public CodeableConcept getRevenue() {
            if (this.revenue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.revenue");
                }
                if (Configuration.doAutoCreate()) {
                    this.revenue = new CodeableConcept();
                }
            }
            return this.revenue;
        }

        public boolean hasRevenue() {
            return this.revenue != null && !this.revenue.isEmpty();
        }

        public DetailComponent setRevenue(CodeableConcept value) {
            this.revenue = value;
            return this;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public DetailComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getProductOrService() {
            if (this.productOrService == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.productOrService");
                }
                if (Configuration.doAutoCreate()) {
                    this.productOrService = new CodeableConcept();
                }
            }
            return this.productOrService;
        }

        public boolean hasProductOrService() {
            return this.productOrService != null && !this.productOrService.isEmpty();
        }

        public DetailComponent setProductOrService(CodeableConcept value) {
            this.productOrService = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public DetailComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public DetailComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public List<CodeableConcept> getProgramCode() {
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            return this.programCode;
        }

        public DetailComponent setProgramCode(List<CodeableConcept> theProgramCode) {
            this.programCode = theProgramCode;
            return this;
        }

        public boolean hasProgramCode() {
            if (this.programCode == null) {
                return false;
            }
            for (CodeableConcept item : this.programCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addProgramCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return t;
        }

        public DetailComponent addProgramCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return this;
        }

        public CodeableConcept getProgramCodeFirstRep() {
            if (this.getProgramCode().isEmpty()) {
                this.addProgramCode();
            }
            return this.getProgramCode().get(0);
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public DetailComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public DetailComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public DetailComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public DetailComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public DetailComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public DetailComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public DetailComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<Reference> getUdi() {
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            return this.udi;
        }

        public DetailComponent setUdi(List<Reference> theUdi) {
            this.udi = theUdi;
            return this;
        }

        public boolean hasUdi() {
            if (this.udi == null) {
                return false;
            }
            for (Reference item : this.udi) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addUdi() {
            Reference t = new Reference();
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return t;
        }

        public DetailComponent addUdi(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return this;
        }

        public Reference getUdiFirstRep() {
            if (this.getUdi().isEmpty()) {
                this.addUdi();
            }
            return this.getUdi().get(0);
        }

        @Deprecated
        public List<Device> getUdiTarget() {
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            return this.udiTarget;
        }

        @Deprecated
        public Device addUdiTarget() {
            Device r = new Device();
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            this.udiTarget.add(r);
            return r;
        }

        public List<SubDetailComponent> getSubDetail() {
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            return this.subDetail;
        }

        public DetailComponent setSubDetail(List<SubDetailComponent> theSubDetail) {
            this.subDetail = theSubDetail;
            return this;
        }

        public boolean hasSubDetail() {
            if (this.subDetail == null) {
                return false;
            }
            for (SubDetailComponent item : this.subDetail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubDetailComponent addSubDetail() {
            SubDetailComponent t = new SubDetailComponent();
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return t;
        }

        public DetailComponent addSubDetail(SubDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return this;
        }

        public SubDetailComponent getSubDetailFirstRep() {
            if (this.getSubDetail().isEmpty()) {
                this.addSubDetail();
            }
            return this.getSubDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A number to uniquely identify item entries.", 0, 1, this.sequence));
            children.add(new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue));
            children.add(new Property("category", "CodeableConcept", "Code to identify the general type of benefits under which products and services are provided.", 0, 1, this.category));
            children.add(new Property("productOrService", "CodeableConcept", "When the value is a group code then this item collects a set of related claim details, otherwise this contains the product, service, drug or other billing code for the item.", 0, 1, this.productOrService));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("programCode", "CodeableConcept", "Identifies the program under which this may be recovered.", 0, Integer.MAX_VALUE, this.programCode));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge.", 0, 1, this.net));
            children.add(new Property("udi", "Reference(Device)", "Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
            children.add(new Property("subDetail", "", "A claim detail line. Either a simple (a product or service) or a 'group' of sub-details which are simple items.", 0, Integer.MAX_VALUE, this.subDetail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A number to uniquely identify item entries.", 0, 1, this.sequence);
                }
                case 1099842588: {
                    return new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Code to identify the general type of benefits under which products and services are provided.", 0, 1, this.category);
                }
                case 1957227299: {
                    return new Property("productOrService", "CodeableConcept", "When the value is a group code then this item collects a set of related claim details, otherwise this contains the product, service, drug or other billing code for the item.", 0, 1, this.productOrService);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case 1010065041: {
                    return new Property("programCode", "CodeableConcept", "Identifies the program under which this may be recovered.", 0, Integer.MAX_VALUE, this.programCode);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 108957: {
                    return new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge.", 0, 1, this.net);
                }
                case 115642: {
                    return new Property("udi", "Reference(Device)", "Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi);
                }
                case -828829007: {
                    return new Property("subDetail", "", "A claim detail line. Either a simple (a product or service) or a 'group' of sub-details which are simple items.", 0, Integer.MAX_VALUE, this.subDetail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1099842588: {
                    Base[] baseArray;
                    if (this.revenue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.revenue;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.category;
                    }
                    return baseArray;
                }
                case 1957227299: {
                    Base[] baseArray;
                    if (this.productOrService == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.productOrService;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case 1010065041: {
                    return this.programCode == null ? new Base[]{} : this.programCode.toArray(new Base[this.programCode.size()]);
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.factor;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.net;
                    }
                    return baseArray;
                }
                case 115642: {
                    return this.udi == null ? new Base[]{} : this.udi.toArray(new Base[this.udi.size()]);
                }
                case -828829007: {
                    return this.subDetail == null ? new Base[]{} : this.subDetail.toArray(new Base[this.subDetail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 1099842588: {
                    this.revenue = this.castToCodeableConcept(value);
                    return value;
                }
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 1957227299: {
                    this.productOrService = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1010065041: {
                    this.getProgramCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case 115642: {
                    this.getUdi().add(this.castToReference(value));
                    return value;
                }
                case -828829007: {
                    this.getSubDetail().add((SubDetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("revenue")) {
                this.revenue = this.castToCodeableConcept(value);
            } else if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("productOrService")) {
                this.productOrService = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("udi")) {
                this.getUdi().add(this.castToReference(value));
            } else if (name.equals("subDetail")) {
                this.getSubDetail().add((SubDetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = null;
            } else if (name.equals("revenue")) {
                this.revenue = null;
            } else if (name.equals("category")) {
                this.category = null;
            } else if (name.equals("productOrService")) {
                this.productOrService = null;
            } else if (name.equals("modifier")) {
                this.getModifier().remove(this.castToCodeableConcept(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().remove(this.castToCodeableConcept(value));
            } else if (name.equals("quantity")) {
                this.quantity = null;
            } else if (name.equals("unitPrice")) {
                this.unitPrice = null;
            } else if (name.equals("factor")) {
                this.factor = null;
            } else if (name.equals("net")) {
                this.net = null;
            } else if (name.equals("udi")) {
                this.getUdi().remove(this.castToReference(value));
            } else if (name.equals("subDetail")) {
                this.getSubDetail().remove((SubDetailComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 1099842588: {
                    return this.getRevenue();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case 1957227299: {
                    return this.getProductOrService();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case 1010065041: {
                    return this.addProgramCode();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case 115642: {
                    return this.addUdi();
                }
                case -828829007: {
                    return this.addSubDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 1099842588: {
                    return new String[]{"CodeableConcept"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 1957227299: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case 1010065041: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case 115642: {
                    return new String[]{"Reference"};
                }
                case -828829007: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.sequence");
            }
            if (name.equals("revenue")) {
                this.revenue = new CodeableConcept();
                return this.revenue;
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("productOrService")) {
                this.productOrService = new CodeableConcept();
                return this.productOrService;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("programCode")) {
                return this.addProgramCode();
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.factor");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("udi")) {
                return this.addUdi();
            }
            if (name.equals("subDetail")) {
                return this.addSubDetail();
            }
            return super.addChild(name);
        }

        @Override
        public DetailComponent copy() {
            DetailComponent dst = new DetailComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DetailComponent dst) {
            super.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.revenue = this.revenue == null ? null : this.revenue.copy();
            dst.category = this.category == null ? null : this.category.copy();
            CodeableConcept codeableConcept = dst.productOrService = this.productOrService == null ? null : this.productOrService.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            if (this.programCode != null) {
                dst.programCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.programCode) {
                    dst.programCode.add(codeableConcept3.copy());
                }
            }
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.udi != null) {
                dst.udi = new ArrayList<Reference>();
                for (Reference reference : this.udi) {
                    dst.udi.add(reference.copy());
                }
            }
            if (this.subDetail != null) {
                dst.subDetail = new ArrayList<SubDetailComponent>();
                for (SubDetailComponent subDetailComponent : this.subDetail) {
                    dst.subDetail.add(subDetailComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DetailComponent)) {
                return false;
            }
            DetailComponent o = (DetailComponent)other_;
            return DetailComponent.compareDeep(this.sequence, o.sequence, true) && DetailComponent.compareDeep(this.revenue, o.revenue, true) && DetailComponent.compareDeep(this.category, o.category, true) && DetailComponent.compareDeep(this.productOrService, o.productOrService, true) && DetailComponent.compareDeep(this.modifier, o.modifier, true) && DetailComponent.compareDeep(this.programCode, o.programCode, true) && DetailComponent.compareDeep(this.quantity, o.quantity, true) && DetailComponent.compareDeep(this.unitPrice, o.unitPrice, true) && DetailComponent.compareDeep(this.factor, o.factor, true) && DetailComponent.compareDeep(this.net, o.net, true) && DetailComponent.compareDeep(this.udi, o.udi, true) && DetailComponent.compareDeep(this.subDetail, o.subDetail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DetailComponent)) {
                return false;
            }
            DetailComponent o = (DetailComponent)other_;
            return DetailComponent.compareValues(this.sequence, o.sequence, true) && DetailComponent.compareValues(this.factor, o.factor, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.revenue, this.category, this.productOrService, this.modifier, this.programCode, this.quantity, this.unitPrice, this.factor, this.net, this.udi, this.subDetail});
        }

        @Override
        public String fhirType() {
            return "Claim.item.detail";
        }
    }

    @Block
    public static class ItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Item instance identifier", formalDefinition="A number to uniquely identify item entries.")
        protected PositiveIntType sequence;
        @Child(name="careTeamSequence", type={PositiveIntType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable careTeam members", formalDefinition="CareTeam members related to this service or product.")
        protected List<PositiveIntType> careTeamSequence;
        @Child(name="diagnosisSequence", type={PositiveIntType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable diagnoses", formalDefinition="Diagnosis applicable for this service or product.")
        protected List<PositiveIntType> diagnosisSequence;
        @Child(name="procedureSequence", type={PositiveIntType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable procedures", formalDefinition="Procedures applicable for this service or product.")
        protected List<PositiveIntType> procedureSequence;
        @Child(name="informationSequence", type={PositiveIntType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Applicable exception and supporting information", formalDefinition="Exceptions, special conditions and supporting information applicable for this service or product.")
        protected List<PositiveIntType> informationSequence;
        @Child(name="revenue", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Revenue or cost center code", formalDefinition="The type of revenue or cost center providing the product and/or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-revenue-center")
        protected CodeableConcept revenue;
        @Child(name="category", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Benefit classification", formalDefinition="Code to identify the general type of benefits under which products and services are provided.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-benefitcategory")
        protected CodeableConcept category;
        @Child(name="productOrService", type={CodeableConcept.class}, order=8, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Billing, service, product, or drug code", formalDefinition="When the value is a group code then this item collects a set of related claim details, otherwise this contains the product, service, drug or other billing code for the item.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-uscls")
        protected CodeableConcept productOrService;
        @Child(name="modifier", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Product or service billing modifiers", formalDefinition="Item typification or modifiers codes to convey additional context for the product or service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-modifiers")
        protected List<CodeableConcept> modifier;
        @Child(name="programCode", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Program the product or service is provided under", formalDefinition="Identifies the program under which this may be recovered.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-program-code")
        protected List<CodeableConcept> programCode;
        @Child(name="serviced", type={DateType.class, Period.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date or dates of service or product delivery", formalDefinition="The date or dates when the service or product was supplied, performed or completed.")
        protected Type serviced;
        @Child(name="location", type={CodeableConcept.class, Address.class, Location.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Place of service or where product was supplied", formalDefinition="Where the product or service was provided.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-place")
        protected Type location;
        @Child(name="quantity", type={Quantity.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of products or services", formalDefinition="The number of repetitions of a service or product.")
        protected Quantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=14, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Fee, charge or cost per item", formalDefinition="If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=15, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Price scaling factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="net", type={Money.class}, order=16, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total item cost", formalDefinition="The quantity times the unit price for an additional service or product or charge.")
        protected Money net;
        @Child(name="udi", type={Device.class}, order=17, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Unique device identifier", formalDefinition="Unique Device Identifiers associated with this line item.")
        protected List<Reference> udi;
        protected List<Device> udiTarget;
        @Child(name="bodySite", type={CodeableConcept.class}, order=18, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Anatomical location", formalDefinition="Physical service site on the patient (limb, tooth, etc.).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/tooth")
        protected CodeableConcept bodySite;
        @Child(name="subSite", type={CodeableConcept.class}, order=19, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Anatomical sub-location", formalDefinition="A region or surface of the bodySite, e.g. limb region or tooth surface(s).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/surface")
        protected List<CodeableConcept> subSite;
        @Child(name="encounter", type={Encounter.class}, order=20, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Encounters related to this billed item", formalDefinition="The Encounters during which this Claim was created or to which the creation of this record is tightly associated.")
        protected List<Reference> encounter;
        protected List<Encounter> encounterTarget;
        @Child(name="detail", type={}, order=21, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Product or service provided", formalDefinition="A claim detail line. Either a simple (a product or service) or a 'group' of sub-details which are simple items.")
        protected List<DetailComponent> detail;
        private static final long serialVersionUID = -329028323L;

        public ItemComponent() {
        }

        public ItemComponent(PositiveIntType sequence, CodeableConcept productOrService) {
            this.sequence = sequence;
            this.productOrService = productOrService;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public ItemComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public ItemComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public List<PositiveIntType> getCareTeamSequence() {
            if (this.careTeamSequence == null) {
                this.careTeamSequence = new ArrayList<PositiveIntType>();
            }
            return this.careTeamSequence;
        }

        public ItemComponent setCareTeamSequence(List<PositiveIntType> theCareTeamSequence) {
            this.careTeamSequence = theCareTeamSequence;
            return this;
        }

        public boolean hasCareTeamSequence() {
            if (this.careTeamSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.careTeamSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addCareTeamSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.careTeamSequence == null) {
                this.careTeamSequence = new ArrayList<PositiveIntType>();
            }
            this.careTeamSequence.add(t);
            return t;
        }

        public ItemComponent addCareTeamSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.careTeamSequence == null) {
                this.careTeamSequence = new ArrayList<PositiveIntType>();
            }
            this.careTeamSequence.add(t);
            return this;
        }

        public boolean hasCareTeamSequence(int value) {
            if (this.careTeamSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.careTeamSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getDiagnosisSequence() {
            if (this.diagnosisSequence == null) {
                this.diagnosisSequence = new ArrayList<PositiveIntType>();
            }
            return this.diagnosisSequence;
        }

        public ItemComponent setDiagnosisSequence(List<PositiveIntType> theDiagnosisSequence) {
            this.diagnosisSequence = theDiagnosisSequence;
            return this;
        }

        public boolean hasDiagnosisSequence() {
            if (this.diagnosisSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.diagnosisSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addDiagnosisSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.diagnosisSequence == null) {
                this.diagnosisSequence = new ArrayList<PositiveIntType>();
            }
            this.diagnosisSequence.add(t);
            return t;
        }

        public ItemComponent addDiagnosisSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.diagnosisSequence == null) {
                this.diagnosisSequence = new ArrayList<PositiveIntType>();
            }
            this.diagnosisSequence.add(t);
            return this;
        }

        public boolean hasDiagnosisSequence(int value) {
            if (this.diagnosisSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.diagnosisSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getProcedureSequence() {
            if (this.procedureSequence == null) {
                this.procedureSequence = new ArrayList<PositiveIntType>();
            }
            return this.procedureSequence;
        }

        public ItemComponent setProcedureSequence(List<PositiveIntType> theProcedureSequence) {
            this.procedureSequence = theProcedureSequence;
            return this;
        }

        public boolean hasProcedureSequence() {
            if (this.procedureSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.procedureSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addProcedureSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.procedureSequence == null) {
                this.procedureSequence = new ArrayList<PositiveIntType>();
            }
            this.procedureSequence.add(t);
            return t;
        }

        public ItemComponent addProcedureSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.procedureSequence == null) {
                this.procedureSequence = new ArrayList<PositiveIntType>();
            }
            this.procedureSequence.add(t);
            return this;
        }

        public boolean hasProcedureSequence(int value) {
            if (this.procedureSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.procedureSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<PositiveIntType> getInformationSequence() {
            if (this.informationSequence == null) {
                this.informationSequence = new ArrayList<PositiveIntType>();
            }
            return this.informationSequence;
        }

        public ItemComponent setInformationSequence(List<PositiveIntType> theInformationSequence) {
            this.informationSequence = theInformationSequence;
            return this;
        }

        public boolean hasInformationSequence() {
            if (this.informationSequence == null) {
                return false;
            }
            for (PositiveIntType item : this.informationSequence) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addInformationSequenceElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.informationSequence == null) {
                this.informationSequence = new ArrayList<PositiveIntType>();
            }
            this.informationSequence.add(t);
            return t;
        }

        public ItemComponent addInformationSequence(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.informationSequence == null) {
                this.informationSequence = new ArrayList<PositiveIntType>();
            }
            this.informationSequence.add(t);
            return this;
        }

        public boolean hasInformationSequence(int value) {
            if (this.informationSequence == null) {
                return false;
            }
            for (PositiveIntType v : this.informationSequence) {
                if (!((Integer)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept getRevenue() {
            if (this.revenue == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.revenue");
                }
                if (Configuration.doAutoCreate()) {
                    this.revenue = new CodeableConcept();
                }
            }
            return this.revenue;
        }

        public boolean hasRevenue() {
            return this.revenue != null && !this.revenue.isEmpty();
        }

        public ItemComponent setRevenue(CodeableConcept value) {
            this.revenue = value;
            return this;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public ItemComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getProductOrService() {
            if (this.productOrService == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.productOrService");
                }
                if (Configuration.doAutoCreate()) {
                    this.productOrService = new CodeableConcept();
                }
            }
            return this.productOrService;
        }

        public boolean hasProductOrService() {
            return this.productOrService != null && !this.productOrService.isEmpty();
        }

        public ItemComponent setProductOrService(CodeableConcept value) {
            this.productOrService = value;
            return this;
        }

        public List<CodeableConcept> getModifier() {
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            return this.modifier;
        }

        public ItemComponent setModifier(List<CodeableConcept> theModifier) {
            this.modifier = theModifier;
            return this;
        }

        public boolean hasModifier() {
            if (this.modifier == null) {
                return false;
            }
            for (CodeableConcept item : this.modifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addModifier() {
            CodeableConcept t = new CodeableConcept();
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return t;
        }

        public ItemComponent addModifier(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.modifier == null) {
                this.modifier = new ArrayList<CodeableConcept>();
            }
            this.modifier.add(t);
            return this;
        }

        public CodeableConcept getModifierFirstRep() {
            if (this.getModifier().isEmpty()) {
                this.addModifier();
            }
            return this.getModifier().get(0);
        }

        public List<CodeableConcept> getProgramCode() {
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            return this.programCode;
        }

        public ItemComponent setProgramCode(List<CodeableConcept> theProgramCode) {
            this.programCode = theProgramCode;
            return this;
        }

        public boolean hasProgramCode() {
            if (this.programCode == null) {
                return false;
            }
            for (CodeableConcept item : this.programCode) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addProgramCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return t;
        }

        public ItemComponent addProgramCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.programCode == null) {
                this.programCode = new ArrayList<CodeableConcept>();
            }
            this.programCode.add(t);
            return this;
        }

        public CodeableConcept getProgramCodeFirstRep() {
            if (this.getProgramCode().isEmpty()) {
                this.addProgramCode();
            }
            return this.getProgramCode().get(0);
        }

        public Type getServiced() {
            return this.serviced;
        }

        public DateType getServicedDateType() throws FHIRException {
            if (this.serviced == null) {
                this.serviced = new DateType();
            }
            if (!(this.serviced instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (DateType)this.serviced;
        }

        public boolean hasServicedDateType() {
            return this != null && this.serviced instanceof DateType;
        }

        public Period getServicedPeriod() throws FHIRException {
            if (this.serviced == null) {
                this.serviced = new Period();
            }
            if (!(this.serviced instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.serviced.getClass().getName() + " was encountered");
            }
            return (Period)this.serviced;
        }

        public boolean hasServicedPeriod() {
            return this != null && this.serviced instanceof Period;
        }

        public boolean hasServiced() {
            return this.serviced != null && !this.serviced.isEmpty();
        }

        public ItemComponent setServiced(Type value) {
            if (value != null && !(value instanceof DateType) && !(value instanceof Period)) {
                throw new Error("Not the right type for Claim.item.serviced[x]: " + value.fhirType());
            }
            this.serviced = value;
            return this;
        }

        public Type getLocation() {
            return this.location;
        }

        public CodeableConcept getLocationCodeableConcept() throws FHIRException {
            if (this.location == null) {
                this.location = new CodeableConcept();
            }
            if (!(this.location instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.location;
        }

        public boolean hasLocationCodeableConcept() {
            return this != null && this.location instanceof CodeableConcept;
        }

        public Address getLocationAddress() throws FHIRException {
            if (this.location == null) {
                this.location = new Address();
            }
            if (!(this.location instanceof Address)) {
                throw new FHIRException("Type mismatch: the type Address was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Address)this.location;
        }

        public boolean hasLocationAddress() {
            return this != null && this.location instanceof Address;
        }

        public Reference getLocationReference() throws FHIRException {
            if (this.location == null) {
                this.location = new Reference();
            }
            if (!(this.location instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Reference)this.location;
        }

        public boolean hasLocationReference() {
            return this != null && this.location instanceof Reference;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public ItemComponent setLocation(Type value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Address || value instanceof Reference)) {
                throw new Error("Not the right type for Claim.item.location[x]: " + value.fhirType());
            }
            this.location = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public ItemComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public ItemComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public ItemComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public ItemComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public ItemComponent setFactor(long value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public ItemComponent setFactor(double value) {
            this.factor = new DecimalType();
            this.factor.setValue(value);
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public ItemComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        public List<Reference> getUdi() {
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            return this.udi;
        }

        public ItemComponent setUdi(List<Reference> theUdi) {
            this.udi = theUdi;
            return this;
        }

        public boolean hasUdi() {
            if (this.udi == null) {
                return false;
            }
            for (Reference item : this.udi) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addUdi() {
            Reference t = new Reference();
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return t;
        }

        public ItemComponent addUdi(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return this;
        }

        public Reference getUdiFirstRep() {
            if (this.getUdi().isEmpty()) {
                this.addUdi();
            }
            return this.getUdi().get(0);
        }

        @Deprecated
        public List<Device> getUdiTarget() {
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            return this.udiTarget;
        }

        @Deprecated
        public Device addUdiTarget() {
            Device r = new Device();
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            this.udiTarget.add(r);
            return r;
        }

        public CodeableConcept getBodySite() {
            if (this.bodySite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemComponent.bodySite");
                }
                if (Configuration.doAutoCreate()) {
                    this.bodySite = new CodeableConcept();
                }
            }
            return this.bodySite;
        }

        public boolean hasBodySite() {
            return this.bodySite != null && !this.bodySite.isEmpty();
        }

        public ItemComponent setBodySite(CodeableConcept value) {
            this.bodySite = value;
            return this;
        }

        public List<CodeableConcept> getSubSite() {
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            return this.subSite;
        }

        public ItemComponent setSubSite(List<CodeableConcept> theSubSite) {
            this.subSite = theSubSite;
            return this;
        }

        public boolean hasSubSite() {
            if (this.subSite == null) {
                return false;
            }
            for (CodeableConcept item : this.subSite) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSubSite() {
            CodeableConcept t = new CodeableConcept();
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            this.subSite.add(t);
            return t;
        }

        public ItemComponent addSubSite(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.subSite == null) {
                this.subSite = new ArrayList<CodeableConcept>();
            }
            this.subSite.add(t);
            return this;
        }

        public CodeableConcept getSubSiteFirstRep() {
            if (this.getSubSite().isEmpty()) {
                this.addSubSite();
            }
            return this.getSubSite().get(0);
        }

        public List<Reference> getEncounter() {
            if (this.encounter == null) {
                this.encounter = new ArrayList<Reference>();
            }
            return this.encounter;
        }

        public ItemComponent setEncounter(List<Reference> theEncounter) {
            this.encounter = theEncounter;
            return this;
        }

        public boolean hasEncounter() {
            if (this.encounter == null) {
                return false;
            }
            for (Reference item : this.encounter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addEncounter() {
            Reference t = new Reference();
            if (this.encounter == null) {
                this.encounter = new ArrayList<Reference>();
            }
            this.encounter.add(t);
            return t;
        }

        public ItemComponent addEncounter(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.encounter == null) {
                this.encounter = new ArrayList<Reference>();
            }
            this.encounter.add(t);
            return this;
        }

        public Reference getEncounterFirstRep() {
            if (this.getEncounter().isEmpty()) {
                this.addEncounter();
            }
            return this.getEncounter().get(0);
        }

        @Deprecated
        public List<Encounter> getEncounterTarget() {
            if (this.encounterTarget == null) {
                this.encounterTarget = new ArrayList<Encounter>();
            }
            return this.encounterTarget;
        }

        @Deprecated
        public Encounter addEncounterTarget() {
            Encounter r = new Encounter();
            if (this.encounterTarget == null) {
                this.encounterTarget = new ArrayList<Encounter>();
            }
            this.encounterTarget.add(r);
            return r;
        }

        public List<DetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<DetailComponent>();
            }
            return this.detail;
        }

        public ItemComponent setDetail(List<DetailComponent> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (DetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DetailComponent addDetail() {
            DetailComponent t = new DetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<DetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public ItemComponent addDetail(DetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<DetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        public DetailComponent getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A number to uniquely identify item entries.", 0, 1, this.sequence));
            children.add(new Property("careTeamSequence", "positiveInt", "CareTeam members related to this service or product.", 0, Integer.MAX_VALUE, this.careTeamSequence));
            children.add(new Property("diagnosisSequence", "positiveInt", "Diagnosis applicable for this service or product.", 0, Integer.MAX_VALUE, this.diagnosisSequence));
            children.add(new Property("procedureSequence", "positiveInt", "Procedures applicable for this service or product.", 0, Integer.MAX_VALUE, this.procedureSequence));
            children.add(new Property("informationSequence", "positiveInt", "Exceptions, special conditions and supporting information applicable for this service or product.", 0, Integer.MAX_VALUE, this.informationSequence));
            children.add(new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue));
            children.add(new Property("category", "CodeableConcept", "Code to identify the general type of benefits under which products and services are provided.", 0, 1, this.category));
            children.add(new Property("productOrService", "CodeableConcept", "When the value is a group code then this item collects a set of related claim details, otherwise this contains the product, service, drug or other billing code for the item.", 0, 1, this.productOrService));
            children.add(new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier));
            children.add(new Property("programCode", "CodeableConcept", "Identifies the program under which this may be recovered.", 0, Integer.MAX_VALUE, this.programCode));
            children.add(new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced));
            children.add(new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the product or service was provided.", 0, 1, this.location));
            children.add(new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity));
            children.add(new Property("unitPrice", "Money", "If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.", 0, 1, this.unitPrice));
            children.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor));
            children.add(new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge.", 0, 1, this.net));
            children.add(new Property("udi", "Reference(Device)", "Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
            children.add(new Property("bodySite", "CodeableConcept", "Physical service site on the patient (limb, tooth, etc.).", 0, 1, this.bodySite));
            children.add(new Property("subSite", "CodeableConcept", "A region or surface of the bodySite, e.g. limb region or tooth surface(s).", 0, Integer.MAX_VALUE, this.subSite));
            children.add(new Property(Claim.SP_ENCOUNTER, "Reference(Encounter)", "The Encounters during which this Claim was created or to which the creation of this record is tightly associated.", 0, Integer.MAX_VALUE, this.encounter));
            children.add(new Property("detail", "", "A claim detail line. Either a simple (a product or service) or a 'group' of sub-details which are simple items.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A number to uniquely identify item entries.", 0, 1, this.sequence);
                }
                case 1070083823: {
                    return new Property("careTeamSequence", "positiveInt", "CareTeam members related to this service or product.", 0, Integer.MAX_VALUE, this.careTeamSequence);
                }
                case -909769262: {
                    return new Property("diagnosisSequence", "positiveInt", "Diagnosis applicable for this service or product.", 0, Integer.MAX_VALUE, this.diagnosisSequence);
                }
                case -808920140: {
                    return new Property("procedureSequence", "positiveInt", "Procedures applicable for this service or product.", 0, Integer.MAX_VALUE, this.procedureSequence);
                }
                case -702585587: {
                    return new Property("informationSequence", "positiveInt", "Exceptions, special conditions and supporting information applicable for this service or product.", 0, Integer.MAX_VALUE, this.informationSequence);
                }
                case 1099842588: {
                    return new Property("revenue", "CodeableConcept", "The type of revenue or cost center providing the product and/or service.", 0, 1, this.revenue);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "Code to identify the general type of benefits under which products and services are provided.", 0, 1, this.category);
                }
                case 1957227299: {
                    return new Property("productOrService", "CodeableConcept", "When the value is a group code then this item collects a set of related claim details, otherwise this contains the product, service, drug or other billing code for the item.", 0, 1, this.productOrService);
                }
                case -615513385: {
                    return new Property("modifier", "CodeableConcept", "Item typification or modifiers codes to convey additional context for the product or service.", 0, Integer.MAX_VALUE, this.modifier);
                }
                case 1010065041: {
                    return new Property("programCode", "CodeableConcept", "Identifies the program under which this may be recovered.", 0, Integer.MAX_VALUE, this.programCode);
                }
                case -1927922223: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 1379209295: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 363246749: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 1534966512: {
                    return new Property("serviced[x]", "date|Period", "The date or dates when the service or product was supplied, performed or completed.", 0, 1, this.serviced);
                }
                case 552316075: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the product or service was provided.", 0, 1, this.location);
                }
                case 1901043637: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the product or service was provided.", 0, 1, this.location);
                }
                case -1224800468: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the product or service was provided.", 0, 1, this.location);
                }
                case -1280020865: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the product or service was provided.", 0, 1, this.location);
                }
                case 755866390: {
                    return new Property("location[x]", "CodeableConcept|Address|Reference(Location)", "Where the product or service was provided.", 0, 1, this.location);
                }
                case -1285004149: {
                    return new Property("quantity", "SimpleQuantity", "The number of repetitions of a service or product.", 0, 1, this.quantity);
                }
                case -486196699: {
                    return new Property("unitPrice", "Money", "If the item is not a group then this is the fee for the product or service, otherwise this is the total of the fees for the details of the group.", 0, 1, this.unitPrice);
                }
                case -1282148017: {
                    return new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of services delivered and/or goods received. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, 1, this.factor);
                }
                case 108957: {
                    return new Property("net", "Money", "The quantity times the unit price for an additional service or product or charge.", 0, 1, this.net);
                }
                case 115642: {
                    return new Property("udi", "Reference(Device)", "Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi);
                }
                case 1702620169: {
                    return new Property("bodySite", "CodeableConcept", "Physical service site on the patient (limb, tooth, etc.).", 0, 1, this.bodySite);
                }
                case -1868566105: {
                    return new Property("subSite", "CodeableConcept", "A region or surface of the bodySite, e.g. limb region or tooth surface(s).", 0, Integer.MAX_VALUE, this.subSite);
                }
                case 1524132147: {
                    return new Property(Claim.SP_ENCOUNTER, "Reference(Encounter)", "The Encounters during which this Claim was created or to which the creation of this record is tightly associated.", 0, Integer.MAX_VALUE, this.encounter);
                }
                case -1335224239: {
                    return new Property("detail", "", "A claim detail line. Either a simple (a product or service) or a 'group' of sub-details which are simple items.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1070083823: {
                    return this.careTeamSequence == null ? new Base[]{} : this.careTeamSequence.toArray(new Base[this.careTeamSequence.size()]);
                }
                case -909769262: {
                    return this.diagnosisSequence == null ? new Base[]{} : this.diagnosisSequence.toArray(new Base[this.diagnosisSequence.size()]);
                }
                case -808920140: {
                    return this.procedureSequence == null ? new Base[]{} : this.procedureSequence.toArray(new Base[this.procedureSequence.size()]);
                }
                case -702585587: {
                    return this.informationSequence == null ? new Base[]{} : this.informationSequence.toArray(new Base[this.informationSequence.size()]);
                }
                case 1099842588: {
                    Base[] baseArray;
                    if (this.revenue == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.revenue;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.category;
                    }
                    return baseArray;
                }
                case 1957227299: {
                    Base[] baseArray;
                    if (this.productOrService == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.productOrService;
                    }
                    return baseArray;
                }
                case -615513385: {
                    return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
                }
                case 1010065041: {
                    return this.programCode == null ? new Base[]{} : this.programCode.toArray(new Base[this.programCode.size()]);
                }
                case 1379209295: {
                    Base[] baseArray;
                    if (this.serviced == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.serviced;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.location;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.quantity;
                    }
                    return baseArray;
                }
                case -486196699: {
                    Base[] baseArray;
                    if (this.unitPrice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.unitPrice;
                    }
                    return baseArray;
                }
                case -1282148017: {
                    Base[] baseArray;
                    if (this.factor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.factor;
                    }
                    return baseArray;
                }
                case 108957: {
                    Base[] baseArray;
                    if (this.net == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.net;
                    }
                    return baseArray;
                }
                case 115642: {
                    return this.udi == null ? new Base[]{} : this.udi.toArray(new Base[this.udi.size()]);
                }
                case 1702620169: {
                    Base[] baseArray;
                    if (this.bodySite == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.bodySite;
                    }
                    return baseArray;
                }
                case -1868566105: {
                    return this.subSite == null ? new Base[]{} : this.subSite.toArray(new Base[this.subSite.size()]);
                }
                case 1524132147: {
                    return this.encounter == null ? new Base[]{} : this.encounter.toArray(new Base[this.encounter.size()]);
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 1070083823: {
                    this.getCareTeamSequence().add(this.castToPositiveInt(value));
                    return value;
                }
                case -909769262: {
                    this.getDiagnosisSequence().add(this.castToPositiveInt(value));
                    return value;
                }
                case -808920140: {
                    this.getProcedureSequence().add(this.castToPositiveInt(value));
                    return value;
                }
                case -702585587: {
                    this.getInformationSequence().add(this.castToPositiveInt(value));
                    return value;
                }
                case 1099842588: {
                    this.revenue = this.castToCodeableConcept(value);
                    return value;
                }
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 1957227299: {
                    this.productOrService = this.castToCodeableConcept(value);
                    return value;
                }
                case -615513385: {
                    this.getModifier().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1010065041: {
                    this.getProgramCode().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1379209295: {
                    this.serviced = this.castToType(value);
                    return value;
                }
                case 1901043637: {
                    this.location = this.castToType(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = this.castToQuantity(value);
                    return value;
                }
                case -486196699: {
                    this.unitPrice = this.castToMoney(value);
                    return value;
                }
                case -1282148017: {
                    this.factor = this.castToDecimal(value);
                    return value;
                }
                case 108957: {
                    this.net = this.castToMoney(value);
                    return value;
                }
                case 115642: {
                    this.getUdi().add(this.castToReference(value));
                    return value;
                }
                case 1702620169: {
                    this.bodySite = this.castToCodeableConcept(value);
                    return value;
                }
                case -1868566105: {
                    this.getSubSite().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1524132147: {
                    this.getEncounter().add(this.castToReference(value));
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add((DetailComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("careTeamSequence")) {
                this.getCareTeamSequence().add(this.castToPositiveInt(value));
            } else if (name.equals("diagnosisSequence")) {
                this.getDiagnosisSequence().add(this.castToPositiveInt(value));
            } else if (name.equals("procedureSequence")) {
                this.getProcedureSequence().add(this.castToPositiveInt(value));
            } else if (name.equals("informationSequence")) {
                this.getInformationSequence().add(this.castToPositiveInt(value));
            } else if (name.equals("revenue")) {
                this.revenue = this.castToCodeableConcept(value);
            } else if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("productOrService")) {
                this.productOrService = this.castToCodeableConcept(value);
            } else if (name.equals("modifier")) {
                this.getModifier().add(this.castToCodeableConcept(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().add(this.castToCodeableConcept(value));
            } else if (name.equals("serviced[x]")) {
                this.serviced = this.castToType(value);
            } else if (name.equals("location[x]")) {
                this.location = this.castToType(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else if (name.equals("udi")) {
                this.getUdi().add(this.castToReference(value));
            } else if (name.equals("bodySite")) {
                this.bodySite = this.castToCodeableConcept(value);
            } else if (name.equals("subSite")) {
                this.getSubSite().add(this.castToCodeableConcept(value));
            } else if (name.equals(Claim.SP_ENCOUNTER)) {
                this.getEncounter().add(this.castToReference(value));
            } else if (name.equals("detail")) {
                this.getDetail().add((DetailComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = null;
            } else if (name.equals("careTeamSequence")) {
                this.getCareTeamSequence().remove(this.castToPositiveInt(value));
            } else if (name.equals("diagnosisSequence")) {
                this.getDiagnosisSequence().remove(this.castToPositiveInt(value));
            } else if (name.equals("procedureSequence")) {
                this.getProcedureSequence().remove(this.castToPositiveInt(value));
            } else if (name.equals("informationSequence")) {
                this.getInformationSequence().remove(this.castToPositiveInt(value));
            } else if (name.equals("revenue")) {
                this.revenue = null;
            } else if (name.equals("category")) {
                this.category = null;
            } else if (name.equals("productOrService")) {
                this.productOrService = null;
            } else if (name.equals("modifier")) {
                this.getModifier().remove(this.castToCodeableConcept(value));
            } else if (name.equals("programCode")) {
                this.getProgramCode().remove(this.castToCodeableConcept(value));
            } else if (name.equals("serviced[x]")) {
                this.serviced = null;
            } else if (name.equals("location[x]")) {
                this.location = null;
            } else if (name.equals("quantity")) {
                this.quantity = null;
            } else if (name.equals("unitPrice")) {
                this.unitPrice = null;
            } else if (name.equals("factor")) {
                this.factor = null;
            } else if (name.equals("net")) {
                this.net = null;
            } else if (name.equals("udi")) {
                this.getUdi().remove(this.castToReference(value));
            } else if (name.equals("bodySite")) {
                this.bodySite = null;
            } else if (name.equals("subSite")) {
                this.getSubSite().remove(this.castToCodeableConcept(value));
            } else if (name.equals(Claim.SP_ENCOUNTER)) {
                this.getEncounter().remove(this.castToReference(value));
            } else if (name.equals("detail")) {
                this.getDetail().remove((DetailComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 1070083823: {
                    return this.addCareTeamSequenceElement();
                }
                case -909769262: {
                    return this.addDiagnosisSequenceElement();
                }
                case -808920140: {
                    return this.addProcedureSequenceElement();
                }
                case -702585587: {
                    return this.addInformationSequenceElement();
                }
                case 1099842588: {
                    return this.getRevenue();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case 1957227299: {
                    return this.getProductOrService();
                }
                case -615513385: {
                    return this.addModifier();
                }
                case 1010065041: {
                    return this.addProgramCode();
                }
                case -1927922223: {
                    return this.getServiced();
                }
                case 1379209295: {
                    return this.getServiced();
                }
                case 552316075: {
                    return this.getLocation();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case -486196699: {
                    return this.getUnitPrice();
                }
                case -1282148017: {
                    return this.getFactorElement();
                }
                case 108957: {
                    return this.getNet();
                }
                case 115642: {
                    return this.addUdi();
                }
                case 1702620169: {
                    return this.getBodySite();
                }
                case -1868566105: {
                    return this.addSubSite();
                }
                case 1524132147: {
                    return this.addEncounter();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 1070083823: {
                    return new String[]{"positiveInt"};
                }
                case -909769262: {
                    return new String[]{"positiveInt"};
                }
                case -808920140: {
                    return new String[]{"positiveInt"};
                }
                case -702585587: {
                    return new String[]{"positiveInt"};
                }
                case 1099842588: {
                    return new String[]{"CodeableConcept"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 1957227299: {
                    return new String[]{"CodeableConcept"};
                }
                case -615513385: {
                    return new String[]{"CodeableConcept"};
                }
                case 1010065041: {
                    return new String[]{"CodeableConcept"};
                }
                case 1379209295: {
                    return new String[]{"date", "Period"};
                }
                case 1901043637: {
                    return new String[]{"CodeableConcept", "Address", "Reference"};
                }
                case -1285004149: {
                    return new String[]{"SimpleQuantity"};
                }
                case -486196699: {
                    return new String[]{"Money"};
                }
                case -1282148017: {
                    return new String[]{"decimal"};
                }
                case 108957: {
                    return new String[]{"Money"};
                }
                case 115642: {
                    return new String[]{"Reference"};
                }
                case 1702620169: {
                    return new String[]{"CodeableConcept"};
                }
                case -1868566105: {
                    return new String[]{"CodeableConcept"};
                }
                case 1524132147: {
                    return new String[]{"Reference"};
                }
                case -1335224239: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.sequence");
            }
            if (name.equals("careTeamSequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.careTeamSequence");
            }
            if (name.equals("diagnosisSequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.diagnosisSequence");
            }
            if (name.equals("procedureSequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.procedureSequence");
            }
            if (name.equals("informationSequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.informationSequence");
            }
            if (name.equals("revenue")) {
                this.revenue = new CodeableConcept();
                return this.revenue;
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("productOrService")) {
                this.productOrService = new CodeableConcept();
                return this.productOrService;
            }
            if (name.equals("modifier")) {
                return this.addModifier();
            }
            if (name.equals("programCode")) {
                return this.addProgramCode();
            }
            if (name.equals("servicedDate")) {
                this.serviced = new DateType();
                return this.serviced;
            }
            if (name.equals("servicedPeriod")) {
                this.serviced = new Period();
                return this.serviced;
            }
            if (name.equals("locationCodeableConcept")) {
                this.location = new CodeableConcept();
                return this.location;
            }
            if (name.equals("locationAddress")) {
                this.location = new Address();
                return this.location;
            }
            if (name.equals("locationReference")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.factor");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            if (name.equals("udi")) {
                return this.addUdi();
            }
            if (name.equals("bodySite")) {
                this.bodySite = new CodeableConcept();
                return this.bodySite;
            }
            if (name.equals("subSite")) {
                return this.addSubSite();
            }
            if (name.equals(Claim.SP_ENCOUNTER)) {
                return this.addEncounter();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public ItemComponent copy() {
            ItemComponent dst = new ItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ItemComponent dst) {
            super.copyValues(dst);
            PositiveIntType positiveIntType = dst.sequence = this.sequence == null ? null : this.sequence.copy();
            if (this.careTeamSequence != null) {
                dst.careTeamSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType2 : this.careTeamSequence) {
                    dst.careTeamSequence.add(positiveIntType2.copy());
                }
            }
            if (this.diagnosisSequence != null) {
                dst.diagnosisSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType3 : this.diagnosisSequence) {
                    dst.diagnosisSequence.add(positiveIntType3.copy());
                }
            }
            if (this.procedureSequence != null) {
                dst.procedureSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType4 : this.procedureSequence) {
                    dst.procedureSequence.add(positiveIntType4.copy());
                }
            }
            if (this.informationSequence != null) {
                dst.informationSequence = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType5 : this.informationSequence) {
                    dst.informationSequence.add(positiveIntType5.copy());
                }
            }
            dst.revenue = this.revenue == null ? null : this.revenue.copy();
            dst.category = this.category == null ? null : this.category.copy();
            CodeableConcept codeableConcept = dst.productOrService = this.productOrService == null ? null : this.productOrService.copy();
            if (this.modifier != null) {
                dst.modifier = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.modifier) {
                    dst.modifier.add(codeableConcept2.copy());
                }
            }
            if (this.programCode != null) {
                dst.programCode = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.programCode) {
                    dst.programCode.add(codeableConcept3.copy());
                }
            }
            dst.serviced = this.serviced == null ? null : this.serviced.copy();
            dst.location = this.location == null ? null : this.location.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            Money money = dst.net = this.net == null ? null : this.net.copy();
            if (this.udi != null) {
                dst.udi = new ArrayList<Reference>();
                for (Reference reference : this.udi) {
                    dst.udi.add(reference.copy());
                }
            }
            CodeableConcept codeableConcept4 = dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            if (this.subSite != null) {
                dst.subSite = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept5 : this.subSite) {
                    dst.subSite.add(codeableConcept5.copy());
                }
            }
            if (this.encounter != null) {
                dst.encounter = new ArrayList<Reference>();
                for (Reference reference : this.encounter) {
                    dst.encounter.add(reference.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<DetailComponent>();
                for (DetailComponent detailComponent : this.detail) {
                    dst.detail.add(detailComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemComponent)) {
                return false;
            }
            ItemComponent o = (ItemComponent)other_;
            return ItemComponent.compareDeep(this.sequence, o.sequence, true) && ItemComponent.compareDeep(this.careTeamSequence, o.careTeamSequence, true) && ItemComponent.compareDeep(this.diagnosisSequence, o.diagnosisSequence, true) && ItemComponent.compareDeep(this.procedureSequence, o.procedureSequence, true) && ItemComponent.compareDeep(this.informationSequence, o.informationSequence, true) && ItemComponent.compareDeep(this.revenue, o.revenue, true) && ItemComponent.compareDeep(this.category, o.category, true) && ItemComponent.compareDeep(this.productOrService, o.productOrService, true) && ItemComponent.compareDeep(this.modifier, o.modifier, true) && ItemComponent.compareDeep(this.programCode, o.programCode, true) && ItemComponent.compareDeep(this.serviced, o.serviced, true) && ItemComponent.compareDeep(this.location, o.location, true) && ItemComponent.compareDeep(this.quantity, o.quantity, true) && ItemComponent.compareDeep(this.unitPrice, o.unitPrice, true) && ItemComponent.compareDeep(this.factor, o.factor, true) && ItemComponent.compareDeep(this.net, o.net, true) && ItemComponent.compareDeep(this.udi, o.udi, true) && ItemComponent.compareDeep(this.bodySite, o.bodySite, true) && ItemComponent.compareDeep(this.subSite, o.subSite, true) && ItemComponent.compareDeep(this.encounter, o.encounter, true) && ItemComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ItemComponent)) {
                return false;
            }
            ItemComponent o = (ItemComponent)other_;
            return ItemComponent.compareValues(this.sequence, o.sequence, true) && ItemComponent.compareValues(this.careTeamSequence, o.careTeamSequence, true) && ItemComponent.compareValues(this.diagnosisSequence, o.diagnosisSequence, true) && ItemComponent.compareValues(this.procedureSequence, o.procedureSequence, true) && ItemComponent.compareValues(this.informationSequence, o.informationSequence, true) && ItemComponent.compareValues(this.factor, o.factor, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.careTeamSequence, this.diagnosisSequence, this.procedureSequence, this.informationSequence, this.revenue, this.category, this.productOrService, this.modifier, this.programCode, this.serviced, this.location, this.quantity, this.unitPrice, this.factor, this.net, this.udi, this.bodySite, this.subSite, this.encounter, this.detail});
        }

        @Override
        public String fhirType() {
            return "Claim.item";
        }
    }

    @Block
    public static class AccidentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="date", type={DateType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the incident occurred", formalDefinition="Date of an accident event  related to the products and services contained in the claim.")
        protected DateType date;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The nature of the accident", formalDefinition="The type or context of the accident event for the purposes of selection of potential insurance coverages and determination of coordination between insurers.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActIncidentCode")
        protected CodeableConcept type;
        @Child(name="location", type={Address.class, Location.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Where the event occurred", formalDefinition="The physical location of the accident event.")
        protected Type location;
        private static final long serialVersionUID = 622904984L;

        public AccidentComponent() {
        }

        public AccidentComponent(DateType date) {
            this.date = date;
        }

        public DateType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccidentComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public AccidentComponent setDateElement(DateType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public AccidentComponent setDate(Date value) {
            if (this.date == null) {
                this.date = new DateType();
            }
            this.date.setValue(value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AccidentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public AccidentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Type getLocation() {
            return this.location;
        }

        public Address getLocationAddress() throws FHIRException {
            if (this.location == null) {
                this.location = new Address();
            }
            if (!(this.location instanceof Address)) {
                throw new FHIRException("Type mismatch: the type Address was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Address)this.location;
        }

        public boolean hasLocationAddress() {
            return this != null && this.location instanceof Address;
        }

        public Reference getLocationReference() throws FHIRException {
            if (this.location == null) {
                this.location = new Reference();
            }
            if (!(this.location instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.location.getClass().getName() + " was encountered");
            }
            return (Reference)this.location;
        }

        public boolean hasLocationReference() {
            return this != null && this.location instanceof Reference;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public AccidentComponent setLocation(Type value) {
            if (value != null && !(value instanceof Address) && !(value instanceof Reference)) {
                throw new Error("Not the right type for Claim.accident.location[x]: " + value.fhirType());
            }
            this.location = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("date", "date", "Date of an accident event  related to the products and services contained in the claim.", 0, 1, this.date));
            children.add(new Property("type", "CodeableConcept", "The type or context of the accident event for the purposes of selection of potential insurance coverages and determination of coordination between insurers.", 0, 1, this.type));
            children.add(new Property("location[x]", "Address|Reference(Location)", "The physical location of the accident event.", 0, 1, this.location));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3076014: {
                    return new Property("date", "date", "Date of an accident event  related to the products and services contained in the claim.", 0, 1, this.date);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type or context of the accident event for the purposes of selection of potential insurance coverages and determination of coordination between insurers.", 0, 1, this.type);
                }
                case 552316075: {
                    return new Property("location[x]", "Address|Reference(Location)", "The physical location of the accident event.", 0, 1, this.location);
                }
                case 1901043637: {
                    return new Property("location[x]", "Address|Reference(Location)", "The physical location of the accident event.", 0, 1, this.location);
                }
                case -1280020865: {
                    return new Property("location[x]", "Address|Reference(Location)", "The physical location of the accident event.", 0, 1, this.location);
                }
                case 755866390: {
                    return new Property("location[x]", "Address|Reference(Location)", "The physical location of the accident event.", 0, 1, this.location);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.date;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.location;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    this.date = this.castToDate(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 1901043637: {
                    this.location = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("date")) {
                this.date = this.castToDate(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("location[x]")) {
                this.location = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("date")) {
                this.date = null;
            } else if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("location[x]")) {
                this.location = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    return this.getDateElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case 552316075: {
                    return this.getLocation();
                }
                case 1901043637: {
                    return this.getLocation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3076014: {
                    return new String[]{"date"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1901043637: {
                    return new String[]{"Address", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.date");
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("locationAddress")) {
                this.location = new Address();
                return this.location;
            }
            if (name.equals("locationReference")) {
                this.location = new Reference();
                return this.location;
            }
            return super.addChild(name);
        }

        @Override
        public AccidentComponent copy() {
            AccidentComponent dst = new AccidentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AccidentComponent dst) {
            super.copyValues(dst);
            dst.date = this.date == null ? null : this.date.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.location = this.location == null ? null : this.location.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AccidentComponent)) {
                return false;
            }
            AccidentComponent o = (AccidentComponent)other_;
            return AccidentComponent.compareDeep(this.date, o.date, true) && AccidentComponent.compareDeep(this.type, o.type, true) && AccidentComponent.compareDeep(this.location, o.location, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AccidentComponent)) {
                return false;
            }
            AccidentComponent o = (AccidentComponent)other_;
            return AccidentComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.date, this.type, this.location});
        }

        @Override
        public String fhirType() {
            return "Claim.accident";
        }
    }

    @Block
    public static class InsuranceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Insurance instance identifier", formalDefinition="A number to uniquely identify insurance entries and provide a sequence of coverages to convey coordination of benefit order.")
        protected PositiveIntType sequence;
        @Child(name="focal", type={BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Coverage to be used for adjudication", formalDefinition="A flag to indicate that this Coverage is to be used for adjudication of this claim when set to true.")
        protected BooleanType focal;
        @Child(name="identifier", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Pre-assigned Claim number", formalDefinition="The business identifier to be used when the claim is sent for adjudication against this insurance policy.")
        protected Identifier identifier;
        @Child(name="coverage", type={Coverage.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Insurance information", formalDefinition="Reference to the insurance card level information contained in the Coverage resource. The coverage issuing insurer will use these details to locate the patient's actual coverage within the insurer's information system.")
        protected Reference coverage;
        protected Coverage coverageTarget;
        @Child(name="businessArrangement", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional provider contract number", formalDefinition="A business agreement number established between the provider and the insurer for special business processing purposes.")
        protected StringType businessArrangement;
        @Child(name="preAuthRef", type={StringType.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Prior authorization reference number", formalDefinition="Reference numbers previously provided by the insurer to the provider to be quoted on subsequent claims containing services or products related to the prior authorization.")
        protected List<StringType> preAuthRef;
        @Child(name="claimResponse", type={ClaimResponse.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Adjudication results", formalDefinition="The result of the adjudication of the line items for the Coverage specified in this insurance.")
        protected Reference claimResponse;
        protected ClaimResponse claimResponseTarget;
        private static final long serialVersionUID = -1711744215L;

        public InsuranceComponent() {
        }

        public InsuranceComponent(PositiveIntType sequence, BooleanType focal, Reference coverage) {
            this.sequence = sequence;
            this.focal = focal;
            this.coverage = coverage;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public InsuranceComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public InsuranceComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public BooleanType getFocalElement() {
            if (this.focal == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.focal");
                }
                if (Configuration.doAutoCreate()) {
                    this.focal = new BooleanType();
                }
            }
            return this.focal;
        }

        public boolean hasFocalElement() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public boolean hasFocal() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public InsuranceComponent setFocalElement(BooleanType value) {
            this.focal = value;
            return this;
        }

        public boolean getFocal() {
            return this.focal == null || this.focal.isEmpty() ? false : (Boolean)this.focal.getValue();
        }

        public InsuranceComponent setFocal(boolean value) {
            if (this.focal == null) {
                this.focal = new BooleanType();
            }
            this.focal.setValue((Object)value);
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public InsuranceComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public Reference getCoverage() {
            if (this.coverage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverage = new Reference();
                }
            }
            return this.coverage;
        }

        public boolean hasCoverage() {
            return this.coverage != null && !this.coverage.isEmpty();
        }

        public InsuranceComponent setCoverage(Reference value) {
            this.coverage = value;
            return this;
        }

        public Coverage getCoverageTarget() {
            if (this.coverageTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverageTarget = new Coverage();
                }
            }
            return this.coverageTarget;
        }

        public InsuranceComponent setCoverageTarget(Coverage value) {
            this.coverageTarget = value;
            return this;
        }

        public StringType getBusinessArrangementElement() {
            if (this.businessArrangement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.businessArrangement");
                }
                if (Configuration.doAutoCreate()) {
                    this.businessArrangement = new StringType();
                }
            }
            return this.businessArrangement;
        }

        public boolean hasBusinessArrangementElement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public boolean hasBusinessArrangement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public InsuranceComponent setBusinessArrangementElement(StringType value) {
            this.businessArrangement = value;
            return this;
        }

        public String getBusinessArrangement() {
            return this.businessArrangement == null ? null : (String)this.businessArrangement.getValue();
        }

        public InsuranceComponent setBusinessArrangement(String value) {
            if (Utilities.noString((String)value)) {
                this.businessArrangement = null;
            } else {
                if (this.businessArrangement == null) {
                    this.businessArrangement = new StringType();
                }
                this.businessArrangement.setValue(value);
            }
            return this;
        }

        public List<StringType> getPreAuthRef() {
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            return this.preAuthRef;
        }

        public InsuranceComponent setPreAuthRef(List<StringType> thePreAuthRef) {
            this.preAuthRef = thePreAuthRef;
            return this;
        }

        public boolean hasPreAuthRef() {
            if (this.preAuthRef == null) {
                return false;
            }
            for (StringType item : this.preAuthRef) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addPreAuthRefElement() {
            StringType t = new StringType();
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            this.preAuthRef.add(t);
            return t;
        }

        public InsuranceComponent addPreAuthRef(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            this.preAuthRef.add(t);
            return this;
        }

        public boolean hasPreAuthRef(String value) {
            if (this.preAuthRef == null) {
                return false;
            }
            for (StringType v : this.preAuthRef) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public Reference getClaimResponse() {
            if (this.claimResponse == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.claimResponse");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimResponse = new Reference();
                }
            }
            return this.claimResponse;
        }

        public boolean hasClaimResponse() {
            return this.claimResponse != null && !this.claimResponse.isEmpty();
        }

        public InsuranceComponent setClaimResponse(Reference value) {
            this.claimResponse = value;
            return this;
        }

        public ClaimResponse getClaimResponseTarget() {
            if (this.claimResponseTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InsuranceComponent.claimResponse");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimResponseTarget = new ClaimResponse();
                }
            }
            return this.claimResponseTarget;
        }

        public InsuranceComponent setClaimResponseTarget(ClaimResponse value) {
            this.claimResponseTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A number to uniquely identify insurance entries and provide a sequence of coverages to convey coordination of benefit order.", 0, 1, this.sequence));
            children.add(new Property("focal", "boolean", "A flag to indicate that this Coverage is to be used for adjudication of this claim when set to true.", 0, 1, this.focal));
            children.add(new Property(Claim.SP_IDENTIFIER, "Identifier", "The business identifier to be used when the claim is sent for adjudication against this insurance policy.", 0, 1, this.identifier));
            children.add(new Property("coverage", "Reference(Coverage)", "Reference to the insurance card level information contained in the Coverage resource. The coverage issuing insurer will use these details to locate the patient's actual coverage within the insurer's information system.", 0, 1, this.coverage));
            children.add(new Property("businessArrangement", "string", "A business agreement number established between the provider and the insurer for special business processing purposes.", 0, 1, this.businessArrangement));
            children.add(new Property("preAuthRef", "string", "Reference numbers previously provided by the insurer to the provider to be quoted on subsequent claims containing services or products related to the prior authorization.", 0, Integer.MAX_VALUE, this.preAuthRef));
            children.add(new Property("claimResponse", "Reference(ClaimResponse)", "The result of the adjudication of the line items for the Coverage specified in this insurance.", 0, 1, this.claimResponse));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A number to uniquely identify insurance entries and provide a sequence of coverages to convey coordination of benefit order.", 0, 1, this.sequence);
                }
                case 97604197: {
                    return new Property("focal", "boolean", "A flag to indicate that this Coverage is to be used for adjudication of this claim when set to true.", 0, 1, this.focal);
                }
                case -1618432855: {
                    return new Property(Claim.SP_IDENTIFIER, "Identifier", "The business identifier to be used when the claim is sent for adjudication against this insurance policy.", 0, 1, this.identifier);
                }
                case -351767064: {
                    return new Property("coverage", "Reference(Coverage)", "Reference to the insurance card level information contained in the Coverage resource. The coverage issuing insurer will use these details to locate the patient's actual coverage within the insurer's information system.", 0, 1, this.coverage);
                }
                case 259920682: {
                    return new Property("businessArrangement", "string", "A business agreement number established between the provider and the insurer for special business processing purposes.", 0, 1, this.businessArrangement);
                }
                case 522246568: {
                    return new Property("preAuthRef", "string", "Reference numbers previously provided by the insurer to the provider to be quoted on subsequent claims containing services or products related to the prior authorization.", 0, Integer.MAX_VALUE, this.preAuthRef);
                }
                case 689513629: {
                    return new Property("claimResponse", "Reference(ClaimResponse)", "The result of the adjudication of the line items for the Coverage specified in this insurance.", 0, 1, this.claimResponse);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 97604197: {
                    Base[] baseArray;
                    if (this.focal == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.focal;
                    }
                    return baseArray;
                }
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.identifier;
                    }
                    return baseArray;
                }
                case -351767064: {
                    Base[] baseArray;
                    if (this.coverage == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.coverage;
                    }
                    return baseArray;
                }
                case 259920682: {
                    Base[] baseArray;
                    if (this.businessArrangement == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.businessArrangement;
                    }
                    return baseArray;
                }
                case 522246568: {
                    return this.preAuthRef == null ? new Base[]{} : this.preAuthRef.toArray(new Base[this.preAuthRef.size()]);
                }
                case 689513629: {
                    Base[] baseArray;
                    if (this.claimResponse == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.claimResponse;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 97604197: {
                    this.focal = this.castToBoolean(value);
                    return value;
                }
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case -351767064: {
                    this.coverage = this.castToReference(value);
                    return value;
                }
                case 259920682: {
                    this.businessArrangement = this.castToString(value);
                    return value;
                }
                case 522246568: {
                    this.getPreAuthRef().add(this.castToString(value));
                    return value;
                }
                case 689513629: {
                    this.claimResponse = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("focal")) {
                this.focal = this.castToBoolean(value);
            } else if (name.equals(Claim.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("coverage")) {
                this.coverage = this.castToReference(value);
            } else if (name.equals("businessArrangement")) {
                this.businessArrangement = this.castToString(value);
            } else if (name.equals("preAuthRef")) {
                this.getPreAuthRef().add(this.castToString(value));
            } else if (name.equals("claimResponse")) {
                this.claimResponse = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = null;
            } else if (name.equals("focal")) {
                this.focal = null;
            } else if (name.equals(Claim.SP_IDENTIFIER)) {
                this.identifier = null;
            } else if (name.equals("coverage")) {
                this.coverage = null;
            } else if (name.equals("businessArrangement")) {
                this.businessArrangement = null;
            } else if (name.equals("preAuthRef")) {
                this.getPreAuthRef().remove(this.castToString(value));
            } else if (name.equals("claimResponse")) {
                this.claimResponse = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 97604197: {
                    return this.getFocalElement();
                }
                case -1618432855: {
                    return this.getIdentifier();
                }
                case -351767064: {
                    return this.getCoverage();
                }
                case 259920682: {
                    return this.getBusinessArrangementElement();
                }
                case 522246568: {
                    return this.addPreAuthRefElement();
                }
                case 689513629: {
                    return this.getClaimResponse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 97604197: {
                    return new String[]{"boolean"};
                }
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case -351767064: {
                    return new String[]{"Reference"};
                }
                case 259920682: {
                    return new String[]{"string"};
                }
                case 522246568: {
                    return new String[]{"string"};
                }
                case 689513629: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.sequence");
            }
            if (name.equals("focal")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.focal");
            }
            if (name.equals(Claim.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("coverage")) {
                this.coverage = new Reference();
                return this.coverage;
            }
            if (name.equals("businessArrangement")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.businessArrangement");
            }
            if (name.equals("preAuthRef")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.preAuthRef");
            }
            if (name.equals("claimResponse")) {
                this.claimResponse = new Reference();
                return this.claimResponse;
            }
            return super.addChild(name);
        }

        @Override
        public InsuranceComponent copy() {
            InsuranceComponent dst = new InsuranceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InsuranceComponent dst) {
            super.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.focal = this.focal == null ? null : this.focal.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.coverage = this.coverage == null ? null : this.coverage.copy();
            StringType stringType = dst.businessArrangement = this.businessArrangement == null ? null : this.businessArrangement.copy();
            if (this.preAuthRef != null) {
                dst.preAuthRef = new ArrayList<StringType>();
                for (StringType i : this.preAuthRef) {
                    dst.preAuthRef.add(i.copy());
                }
            }
            dst.claimResponse = this.claimResponse == null ? null : this.claimResponse.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return InsuranceComponent.compareDeep(this.sequence, o.sequence, true) && InsuranceComponent.compareDeep(this.focal, o.focal, true) && InsuranceComponent.compareDeep(this.identifier, o.identifier, true) && InsuranceComponent.compareDeep(this.coverage, o.coverage, true) && InsuranceComponent.compareDeep(this.businessArrangement, o.businessArrangement, true) && InsuranceComponent.compareDeep(this.preAuthRef, o.preAuthRef, true) && InsuranceComponent.compareDeep(this.claimResponse, o.claimResponse, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InsuranceComponent)) {
                return false;
            }
            InsuranceComponent o = (InsuranceComponent)other_;
            return InsuranceComponent.compareValues(this.sequence, o.sequence, true) && InsuranceComponent.compareValues(this.focal, o.focal, true) && InsuranceComponent.compareValues(this.businessArrangement, o.businessArrangement, true) && InsuranceComponent.compareValues(this.preAuthRef, o.preAuthRef, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.focal, this.identifier, this.coverage, this.businessArrangement, this.preAuthRef, this.claimResponse});
        }

        @Override
        public String fhirType() {
            return "Claim.insurance";
        }
    }

    @Block
    public static class ProcedureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Procedure instance identifier", formalDefinition="A number to uniquely identify procedure entries.")
        protected PositiveIntType sequence;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Category of Procedure", formalDefinition="When the condition was observed or the relative ranking.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-procedure-type")
        protected List<CodeableConcept> type;
        @Child(name="date", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the procedure was performed", formalDefinition="Date and optionally time the procedure was performed.")
        protected DateTimeType date;
        @Child(name="procedure", type={CodeableConcept.class, Procedure.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific clinical procedure", formalDefinition="The code or reference to a Procedure resource which identifies the clinical intervention performed.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/icd-10-procedures")
        protected Type procedure;
        @Child(name="udi", type={Device.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Unique device identifier", formalDefinition="Unique Device Identifiers associated with this line item.")
        protected List<Reference> udi;
        protected List<Device> udiTarget;
        private static final long serialVersionUID = 935341852L;

        public ProcedureComponent() {
        }

        public ProcedureComponent(PositiveIntType sequence, Type procedure) {
            this.sequence = sequence;
            this.procedure = procedure;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public ProcedureComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public ProcedureComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public ProcedureComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public ProcedureComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public ProcedureComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public ProcedureComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Type getProcedure() {
            return this.procedure;
        }

        public CodeableConcept getProcedureCodeableConcept() throws FHIRException {
            if (this.procedure == null) {
                this.procedure = new CodeableConcept();
            }
            if (!(this.procedure instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.procedure.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.procedure;
        }

        public boolean hasProcedureCodeableConcept() {
            return this != null && this.procedure instanceof CodeableConcept;
        }

        public Reference getProcedureReference() throws FHIRException {
            if (this.procedure == null) {
                this.procedure = new Reference();
            }
            if (!(this.procedure instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.procedure.getClass().getName() + " was encountered");
            }
            return (Reference)this.procedure;
        }

        public boolean hasProcedureReference() {
            return this != null && this.procedure instanceof Reference;
        }

        public boolean hasProcedure() {
            return this.procedure != null && !this.procedure.isEmpty();
        }

        public ProcedureComponent setProcedure(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for Claim.procedure.procedure[x]: " + value.fhirType());
            }
            this.procedure = value;
            return this;
        }

        public List<Reference> getUdi() {
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            return this.udi;
        }

        public ProcedureComponent setUdi(List<Reference> theUdi) {
            this.udi = theUdi;
            return this;
        }

        public boolean hasUdi() {
            if (this.udi == null) {
                return false;
            }
            for (Reference item : this.udi) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addUdi() {
            Reference t = new Reference();
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return t;
        }

        public ProcedureComponent addUdi(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.udi == null) {
                this.udi = new ArrayList<Reference>();
            }
            this.udi.add(t);
            return this;
        }

        public Reference getUdiFirstRep() {
            if (this.getUdi().isEmpty()) {
                this.addUdi();
            }
            return this.getUdi().get(0);
        }

        @Deprecated
        public List<Device> getUdiTarget() {
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            return this.udiTarget;
        }

        @Deprecated
        public Device addUdiTarget() {
            Device r = new Device();
            if (this.udiTarget == null) {
                this.udiTarget = new ArrayList<Device>();
            }
            this.udiTarget.add(r);
            return r;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A number to uniquely identify procedure entries.", 0, 1, this.sequence));
            children.add(new Property("type", "CodeableConcept", "When the condition was observed or the relative ranking.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("date", "dateTime", "Date and optionally time the procedure was performed.", 0, 1, this.date));
            children.add(new Property("procedure[x]", "CodeableConcept|Reference(Procedure)", "The code or reference to a Procedure resource which identifies the clinical intervention performed.", 0, 1, this.procedure));
            children.add(new Property("udi", "Reference(Device)", "Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A number to uniquely identify procedure entries.", 0, 1, this.sequence);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "When the condition was observed or the relative ranking.", 0, Integer.MAX_VALUE, this.type);
                }
                case 3076014: {
                    return new Property("date", "dateTime", "Date and optionally time the procedure was performed.", 0, 1, this.date);
                }
                case 1640074445: {
                    return new Property("procedure[x]", "CodeableConcept|Reference(Procedure)", "The code or reference to a Procedure resource which identifies the clinical intervention performed.", 0, 1, this.procedure);
                }
                case -1095204141: {
                    return new Property("procedure[x]", "CodeableConcept|Reference(Procedure)", "The code or reference to a Procedure resource which identifies the clinical intervention performed.", 0, 1, this.procedure);
                }
                case -1284783026: {
                    return new Property("procedure[x]", "CodeableConcept|Reference(Procedure)", "The code or reference to a Procedure resource which identifies the clinical intervention performed.", 0, 1, this.procedure);
                }
                case 881809848: {
                    return new Property("procedure[x]", "CodeableConcept|Reference(Procedure)", "The code or reference to a Procedure resource which identifies the clinical intervention performed.", 0, 1, this.procedure);
                }
                case 115642: {
                    return new Property("udi", "Reference(Device)", "Unique Device Identifiers associated with this line item.", 0, Integer.MAX_VALUE, this.udi);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.date;
                    }
                    return baseArray;
                }
                case -1095204141: {
                    Base[] baseArray;
                    if (this.procedure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.procedure;
                    }
                    return baseArray;
                }
                case 115642: {
                    return this.udi == null ? new Base[]{} : this.udi.toArray(new Base[this.udi.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 3575610: {
                    this.getType().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 3076014: {
                    this.date = this.castToDateTime(value);
                    return value;
                }
                case -1095204141: {
                    this.procedure = this.castToType(value);
                    return value;
                }
                case 115642: {
                    this.getUdi().add(this.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("type")) {
                this.getType().add(this.castToCodeableConcept(value));
            } else if (name.equals("date")) {
                this.date = this.castToDateTime(value);
            } else if (name.equals("procedure[x]")) {
                this.procedure = this.castToType(value);
            } else if (name.equals("udi")) {
                this.getUdi().add(this.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = null;
            } else if (name.equals("type")) {
                this.getType().remove(this.castToCodeableConcept(value));
            } else if (name.equals("date")) {
                this.date = null;
            } else if (name.equals("procedure[x]")) {
                this.procedure = null;
            } else if (name.equals("udi")) {
                this.getUdi().remove(this.castToReference(value));
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 3575610: {
                    return this.addType();
                }
                case 3076014: {
                    return this.getDateElement();
                }
                case 1640074445: {
                    return this.getProcedure();
                }
                case -1095204141: {
                    return this.getProcedure();
                }
                case 115642: {
                    return this.addUdi();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3076014: {
                    return new String[]{"dateTime"};
                }
                case -1095204141: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case 115642: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.sequence");
            }
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.date");
            }
            if (name.equals("procedureCodeableConcept")) {
                this.procedure = new CodeableConcept();
                return this.procedure;
            }
            if (name.equals("procedureReference")) {
                this.procedure = new Reference();
                return this.procedure;
            }
            if (name.equals("udi")) {
                return this.addUdi();
            }
            return super.addChild(name);
        }

        @Override
        public ProcedureComponent copy() {
            ProcedureComponent dst = new ProcedureComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ProcedureComponent dst) {
            super.copyValues(dst);
            PositiveIntType positiveIntType = dst.sequence = this.sequence == null ? null : this.sequence.copy();
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.type) {
                    dst.type.add(codeableConcept.copy());
                }
            }
            dst.date = this.date == null ? null : this.date.copy();
            Type type = dst.procedure = this.procedure == null ? null : this.procedure.copy();
            if (this.udi != null) {
                dst.udi = new ArrayList<Reference>();
                for (Reference reference : this.udi) {
                    dst.udi.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedureComponent)) {
                return false;
            }
            ProcedureComponent o = (ProcedureComponent)other_;
            return ProcedureComponent.compareDeep(this.sequence, o.sequence, true) && ProcedureComponent.compareDeep(this.type, o.type, true) && ProcedureComponent.compareDeep(this.date, o.date, true) && ProcedureComponent.compareDeep(this.procedure, o.procedure, true) && ProcedureComponent.compareDeep(this.udi, o.udi, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedureComponent)) {
                return false;
            }
            ProcedureComponent o = (ProcedureComponent)other_;
            return ProcedureComponent.compareValues(this.sequence, o.sequence, true) && ProcedureComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.type, this.date, this.procedure, this.udi});
        }

        @Override
        public String fhirType() {
            return "Claim.procedure";
        }
    }

    @Block
    public static class DiagnosisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Diagnosis instance identifier", formalDefinition="A number to uniquely identify diagnosis entries.")
        protected PositiveIntType sequence;
        @Child(name="diagnosis", type={CodeableConcept.class, Condition.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Nature of illness or problem", formalDefinition="The nature of illness or problem in a coded form or as a reference to an external defined Condition.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/icd-10")
        protected Type diagnosis;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Timing or nature of the diagnosis", formalDefinition="When the condition was observed or the relative ranking.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-diagnosistype")
        protected List<CodeableConcept> type;
        @Child(name="onAdmission", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Present on admission", formalDefinition="Indication of whether the diagnosis was present on admission to a facility.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-diagnosis-on-admission")
        protected CodeableConcept onAdmission;
        @Child(name="packageCode", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Package billing code", formalDefinition="A package billing code or bundle code used to group products and services to a particular health condition (such as heart attack) which is based on a predetermined grouping code system.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/ex-diagnosisrelatedgroup")
        protected CodeableConcept packageCode;
        private static final long serialVersionUID = 2120593974L;

        public DiagnosisComponent() {
        }

        public DiagnosisComponent(PositiveIntType sequence, Type diagnosis) {
            this.sequence = sequence;
            this.diagnosis = diagnosis;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public DiagnosisComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public DiagnosisComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Type getDiagnosis() {
            return this.diagnosis;
        }

        public CodeableConcept getDiagnosisCodeableConcept() throws FHIRException {
            if (this.diagnosis == null) {
                this.diagnosis = new CodeableConcept();
            }
            if (!(this.diagnosis instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.diagnosis.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.diagnosis;
        }

        public boolean hasDiagnosisCodeableConcept() {
            return this != null && this.diagnosis instanceof CodeableConcept;
        }

        public Reference getDiagnosisReference() throws FHIRException {
            if (this.diagnosis == null) {
                this.diagnosis = new Reference();
            }
            if (!(this.diagnosis instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.diagnosis.getClass().getName() + " was encountered");
            }
            return (Reference)this.diagnosis;
        }

        public boolean hasDiagnosisReference() {
            return this != null && this.diagnosis instanceof Reference;
        }

        public boolean hasDiagnosis() {
            return this.diagnosis != null && !this.diagnosis.isEmpty();
        }

        public DiagnosisComponent setDiagnosis(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for Claim.diagnosis.diagnosis[x]: " + value.fhirType());
            }
            this.diagnosis = value;
            return this;
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public DiagnosisComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public DiagnosisComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public CodeableConcept getOnAdmission() {
            if (this.onAdmission == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.onAdmission");
                }
                if (Configuration.doAutoCreate()) {
                    this.onAdmission = new CodeableConcept();
                }
            }
            return this.onAdmission;
        }

        public boolean hasOnAdmission() {
            return this.onAdmission != null && !this.onAdmission.isEmpty();
        }

        public DiagnosisComponent setOnAdmission(CodeableConcept value) {
            this.onAdmission = value;
            return this;
        }

        public CodeableConcept getPackageCode() {
            if (this.packageCode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.packageCode");
                }
                if (Configuration.doAutoCreate()) {
                    this.packageCode = new CodeableConcept();
                }
            }
            return this.packageCode;
        }

        public boolean hasPackageCode() {
            return this.packageCode != null && !this.packageCode.isEmpty();
        }

        public DiagnosisComponent setPackageCode(CodeableConcept value) {
            this.packageCode = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A number to uniquely identify diagnosis entries.", 0, 1, this.sequence));
            children.add(new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The nature of illness or problem in a coded form or as a reference to an external defined Condition.", 0, 1, this.diagnosis));
            children.add(new Property("type", "CodeableConcept", "When the condition was observed or the relative ranking.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("onAdmission", "CodeableConcept", "Indication of whether the diagnosis was present on admission to a facility.", 0, 1, this.onAdmission));
            children.add(new Property("packageCode", "CodeableConcept", "A package billing code or bundle code used to group products and services to a particular health condition (such as heart attack) which is based on a predetermined grouping code system.", 0, 1, this.packageCode));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A number to uniquely identify diagnosis entries.", 0, 1, this.sequence);
                }
                case -1487009809: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The nature of illness or problem in a coded form or as a reference to an external defined Condition.", 0, 1, this.diagnosis);
                }
                case 1196993265: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The nature of illness or problem in a coded form or as a reference to an external defined Condition.", 0, 1, this.diagnosis);
                }
                case 277781616: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The nature of illness or problem in a coded form or as a reference to an external defined Condition.", 0, 1, this.diagnosis);
                }
                case 2050454362: {
                    return new Property("diagnosis[x]", "CodeableConcept|Reference(Condition)", "The nature of illness or problem in a coded form or as a reference to an external defined Condition.", 0, 1, this.diagnosis);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "When the condition was observed or the relative ranking.", 0, Integer.MAX_VALUE, this.type);
                }
                case -3386134: {
                    return new Property("onAdmission", "CodeableConcept", "Indication of whether the diagnosis was present on admission to a facility.", 0, 1, this.onAdmission);
                }
                case 908444499: {
                    return new Property("packageCode", "CodeableConcept", "A package billing code or bundle code used to group products and services to a particular health condition (such as heart attack) which is based on a predetermined grouping code system.", 0, 1, this.packageCode);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 1196993265: {
                    Base[] baseArray;
                    if (this.diagnosis == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.diagnosis;
                    }
                    return baseArray;
                }
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -3386134: {
                    Base[] baseArray;
                    if (this.onAdmission == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.onAdmission;
                    }
                    return baseArray;
                }
                case 908444499: {
                    Base[] baseArray;
                    if (this.packageCode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.packageCode;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 1196993265: {
                    this.diagnosis = this.castToType(value);
                    return value;
                }
                case 3575610: {
                    this.getType().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -3386134: {
                    this.onAdmission = this.castToCodeableConcept(value);
                    return value;
                }
                case 908444499: {
                    this.packageCode = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("diagnosis[x]")) {
                this.diagnosis = this.castToType(value);
            } else if (name.equals("type")) {
                this.getType().add(this.castToCodeableConcept(value));
            } else if (name.equals("onAdmission")) {
                this.onAdmission = this.castToCodeableConcept(value);
            } else if (name.equals("packageCode")) {
                this.packageCode = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = null;
            } else if (name.equals("diagnosis[x]")) {
                this.diagnosis = null;
            } else if (name.equals("type")) {
                this.getType().remove(this.castToCodeableConcept(value));
            } else if (name.equals("onAdmission")) {
                this.onAdmission = null;
            } else if (name.equals("packageCode")) {
                this.packageCode = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case -1487009809: {
                    return this.getDiagnosis();
                }
                case 1196993265: {
                    return this.getDiagnosis();
                }
                case 3575610: {
                    return this.addType();
                }
                case -3386134: {
                    return this.getOnAdmission();
                }
                case 908444499: {
                    return this.getPackageCode();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 1196993265: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -3386134: {
                    return new String[]{"CodeableConcept"};
                }
                case 908444499: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.sequence");
            }
            if (name.equals("diagnosisCodeableConcept")) {
                this.diagnosis = new CodeableConcept();
                return this.diagnosis;
            }
            if (name.equals("diagnosisReference")) {
                this.diagnosis = new Reference();
                return this.diagnosis;
            }
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals("onAdmission")) {
                this.onAdmission = new CodeableConcept();
                return this.onAdmission;
            }
            if (name.equals("packageCode")) {
                this.packageCode = new CodeableConcept();
                return this.packageCode;
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosisComponent copy() {
            DiagnosisComponent dst = new DiagnosisComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DiagnosisComponent dst) {
            super.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            Type type = dst.diagnosis = this.diagnosis == null ? null : this.diagnosis.copy();
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.type) {
                    dst.type.add(i.copy());
                }
            }
            dst.onAdmission = this.onAdmission == null ? null : this.onAdmission.copy();
            dst.packageCode = this.packageCode == null ? null : this.packageCode.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return DiagnosisComponent.compareDeep(this.sequence, o.sequence, true) && DiagnosisComponent.compareDeep(this.diagnosis, o.diagnosis, true) && DiagnosisComponent.compareDeep(this.type, o.type, true) && DiagnosisComponent.compareDeep(this.onAdmission, o.onAdmission, true) && DiagnosisComponent.compareDeep(this.packageCode, o.packageCode, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return DiagnosisComponent.compareValues(this.sequence, o.sequence, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.sequence, this.diagnosis, this.type, this.onAdmission, this.packageCode});
        }

        @Override
        public String fhirType() {
            return "Claim.diagnosis";
        }
    }

    @Block
    public static class SupportingInformationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Information instance identifier", formalDefinition="A number to uniquely identify supporting information entries.")
        protected PositiveIntType sequence;
        @Child(name="category", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Classification of the supplied information", formalDefinition="The general class of the information supplied: information; exception; accident, employment; onset, etc.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-informationcategory")
        protected CodeableConcept category;
        @Child(name="code", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of information", formalDefinition="System and code pertaining to the specific information regarding special conditions relating to the setting, treatment or patient  for which care is sought.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-exception")
        protected CodeableConcept code;
        @Child(name="timing", type={DateType.class, Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When it occurred", formalDefinition="The date when or period to which this information refers.")
        protected Type timing;
        @Child(name="value", type={BooleanType.class, StringType.class, Quantity.class, Attachment.class, Reference.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Data to be provided", formalDefinition="Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.")
        protected Type value;
        @Child(name="reason", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Explanation for the information", formalDefinition="Provides the reason in the situation where a reason code is required in addition to the content.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/missing-tooth-reason")
        protected CodeableConcept reason;
        private static final long serialVersionUID = -518630232L;

        public SupportingInformationComponent() {
        }

        public SupportingInformationComponent(PositiveIntType sequence, CodeableConcept category) {
            this.sequence = sequence;
            this.category = category;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupportingInformationComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public SupportingInformationComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public SupportingInformationComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupportingInformationComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public SupportingInformationComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupportingInformationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SupportingInformationComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Type getTiming() {
            return this.timing;
        }

        public DateType getTimingDateType() throws FHIRException {
            if (this.timing == null) {
                this.timing = new DateType();
            }
            if (!(this.timing instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (DateType)this.timing;
        }

        public boolean hasTimingDateType() {
            return this != null && this.timing instanceof DateType;
        }

        public Period getTimingPeriod() throws FHIRException {
            if (this.timing == null) {
                this.timing = new Period();
            }
            if (!(this.timing instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.timing.getClass().getName() + " was encountered");
            }
            return (Period)this.timing;
        }

        public boolean hasTimingPeriod() {
            return this != null && this.timing instanceof Period;
        }

        public boolean hasTiming() {
            return this.timing != null && !this.timing.isEmpty();
        }

        public SupportingInformationComponent setTiming(Type value) {
            if (value != null && !(value instanceof DateType) && !(value instanceof Period)) {
                throw new Error("Not the right type for Claim.supportingInfo.timing[x]: " + value.fhirType());
            }
            this.timing = value;
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public SupportingInformationComponent setValue(Type value) {
            if (!(value == null || value instanceof BooleanType || value instanceof StringType || value instanceof Quantity || value instanceof Attachment || value instanceof Reference)) {
                throw new Error("Not the right type for Claim.supportingInfo.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public CodeableConcept getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupportingInformationComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new CodeableConcept();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public SupportingInformationComponent setReason(CodeableConcept value) {
            this.reason = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A number to uniquely identify supporting information entries.", 0, 1, this.sequence));
            children.add(new Property("category", "CodeableConcept", "The general class of the information supplied: information; exception; accident, employment; onset, etc.", 0, 1, this.category));
            children.add(new Property("code", "CodeableConcept", "System and code pertaining to the specific information regarding special conditions relating to the setting, treatment or patient  for which care is sought.", 0, 1, this.code));
            children.add(new Property("timing[x]", "date|Period", "The date when or period to which this information refers.", 0, 1, this.timing));
            children.add(new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value));
            children.add(new Property("reason", "CodeableConcept", "Provides the reason in the situation where a reason code is required in addition to the content.", 0, 1, this.reason));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A number to uniquely identify supporting information entries.", 0, 1, this.sequence);
                }
                case 50511102: {
                    return new Property("category", "CodeableConcept", "The general class of the information supplied: information; exception; accident, employment; onset, etc.", 0, 1, this.category);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "System and code pertaining to the specific information regarding special conditions relating to the setting, treatment or patient  for which care is sought.", 0, 1, this.code);
                }
                case 164632566: {
                    return new Property("timing[x]", "date|Period", "The date when or period to which this information refers.", 0, 1, this.timing);
                }
                case -873664438: {
                    return new Property("timing[x]", "date|Period", "The date when or period to which this information refers.", 0, 1, this.timing);
                }
                case 807935768: {
                    return new Property("timing[x]", "date|Period", "The date when or period to which this information refers.", 0, 1, this.timing);
                }
                case -615615829: {
                    return new Property("timing[x]", "date|Period", "The date when or period to which this information refers.", 0, 1, this.timing);
                }
                case -1410166417: {
                    return new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "boolean|string|Quantity|Attachment|Reference(Any)", "Additional data or information such as resources, documents, images etc. including references to the data or the actual inclusion of the data.", 0, 1, this.value);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "Provides the reason in the situation where a reason code is required in addition to the content.", 0, 1, this.reason);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.category;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.code;
                    }
                    return baseArray;
                }
                case -873664438: {
                    Base[] baseArray;
                    if (this.timing == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.timing;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.value;
                    }
                    return baseArray;
                }
                case -934964668: {
                    Base[] baseArray;
                    if (this.reason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.reason;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case 50511102: {
                    this.category = this.castToCodeableConcept(value);
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -873664438: {
                    this.timing = this.castToType(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
                case -934964668: {
                    this.reason = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("category")) {
                this.category = this.castToCodeableConcept(value);
            } else if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("timing[x]")) {
                this.timing = this.castToType(value);
            } else if (name.equals("value[x]")) {
                this.value = this.castToType(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = null;
            } else if (name.equals("category")) {
                this.category = null;
            } else if (name.equals("code")) {
                this.code = null;
            } else if (name.equals("timing[x]")) {
                this.timing = null;
            } else if (name.equals("value[x]")) {
                this.value = null;
            } else if (name.equals("reason")) {
                this.reason = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case 50511102: {
                    return this.getCategory();
                }
                case 3059181: {
                    return this.getCode();
                }
                case 164632566: {
                    return this.getTiming();
                }
                case -873664438: {
                    return this.getTiming();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -934964668: {
                    return this.getReason();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -873664438: {
                    return new String[]{"date", "Period"};
                }
                case 111972721: {
                    return new String[]{"boolean", "string", "Quantity", "Attachment", "Reference"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.sequence");
            }
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("timingDate")) {
                this.timing = new DateType();
                return this.timing;
            }
            if (name.equals("timingPeriod")) {
                this.timing = new Period();
                return this.timing;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("reason")) {
                this.reason = new CodeableConcept();
                return this.reason;
            }
            return super.addChild(name);
        }

        @Override
        public SupportingInformationComponent copy() {
            SupportingInformationComponent dst = new SupportingInformationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SupportingInformationComponent dst) {
            super.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.category = this.category == null ? null : this.category.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.timing = this.timing == null ? null : this.timing.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SupportingInformationComponent)) {
                return false;
            }
            SupportingInformationComponent o = (SupportingInformationComponent)other_;
            return SupportingInformationComponent.compareDeep(this.sequence, o.sequence, true) && SupportingInformationComponent.compareDeep(this.category, o.category, true) && SupportingInformationComponent.compareDeep(this.code, o.code, true) && SupportingInformationComponent.compareDeep(this.timing, o.timing, true) && SupportingInformationComponent.compareDeep(this.value, o.value, true) && SupportingInformationComponent.compareDeep(this.reason, o.reason, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SupportingInformationComponent)) {
                return false;
            }
            SupportingInformationComponent o = (SupportingInformationComponent)other_;
            return SupportingInformationComponent.compareValues(this.sequence, o.sequence, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.sequence, this.category, this.code, this.timing, this.value, this.reason});
        }

        @Override
        public String fhirType() {
            return "Claim.supportingInfo";
        }
    }

    @Block
    public static class CareTeamComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Order of care team", formalDefinition="A number to uniquely identify care team entries.")
        protected PositiveIntType sequence;
        @Child(name="provider", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Practitioner or organization", formalDefinition="Member of the team who provided the product or service.")
        protected Reference provider;
        protected Resource providerTarget;
        @Child(name="responsible", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicator of the lead practitioner", formalDefinition="The party who is billing and/or responsible for the claimed products or services.")
        protected BooleanType responsible;
        @Child(name="role", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Function within the team", formalDefinition="The lead, assisting or supervising practitioner and their discipline if a multidisciplinary team.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/claim-careteamrole")
        protected CodeableConcept role;
        @Child(name="qualification", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Practitioner credential or specialization", formalDefinition="The qualification of the practitioner which is applicable for this service.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/provider-qualification")
        protected CodeableConcept qualification;
        private static final long serialVersionUID = 1758966968L;

        public CareTeamComponent() {
        }

        public CareTeamComponent(PositiveIntType sequence, Reference provider) {
            this.sequence = sequence;
            this.provider = provider;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public CareTeamComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public CareTeamComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public Reference getProvider() {
            if (this.provider == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamComponent.provider");
                }
                if (Configuration.doAutoCreate()) {
                    this.provider = new Reference();
                }
            }
            return this.provider;
        }

        public boolean hasProvider() {
            return this.provider != null && !this.provider.isEmpty();
        }

        public CareTeamComponent setProvider(Reference value) {
            this.provider = value;
            return this;
        }

        public Resource getProviderTarget() {
            return this.providerTarget;
        }

        public CareTeamComponent setProviderTarget(Resource value) {
            this.providerTarget = value;
            return this;
        }

        public BooleanType getResponsibleElement() {
            if (this.responsible == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamComponent.responsible");
                }
                if (Configuration.doAutoCreate()) {
                    this.responsible = new BooleanType();
                }
            }
            return this.responsible;
        }

        public boolean hasResponsibleElement() {
            return this.responsible != null && !this.responsible.isEmpty();
        }

        public boolean hasResponsible() {
            return this.responsible != null && !this.responsible.isEmpty();
        }

        public CareTeamComponent setResponsibleElement(BooleanType value) {
            this.responsible = value;
            return this;
        }

        public boolean getResponsible() {
            return this.responsible == null || this.responsible.isEmpty() ? false : (Boolean)this.responsible.getValue();
        }

        public CareTeamComponent setResponsible(boolean value) {
            if (this.responsible == null) {
                this.responsible = new BooleanType();
            }
            this.responsible.setValue((Object)value);
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public CareTeamComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public CodeableConcept getQualification() {
            if (this.qualification == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CareTeamComponent.qualification");
                }
                if (Configuration.doAutoCreate()) {
                    this.qualification = new CodeableConcept();
                }
            }
            return this.qualification;
        }

        public boolean hasQualification() {
            return this.qualification != null && !this.qualification.isEmpty();
        }

        public CareTeamComponent setQualification(CodeableConcept value) {
            this.qualification = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("sequence", "positiveInt", "A number to uniquely identify care team entries.", 0, 1, this.sequence));
            children.add(new Property(Claim.SP_PROVIDER, "Reference(Practitioner|PractitionerRole|Organization)", "Member of the team who provided the product or service.", 0, 1, this.provider));
            children.add(new Property("responsible", "boolean", "The party who is billing and/or responsible for the claimed products or services.", 0, 1, this.responsible));
            children.add(new Property("role", "CodeableConcept", "The lead, assisting or supervising practitioner and their discipline if a multidisciplinary team.", 0, 1, this.role));
            children.add(new Property("qualification", "CodeableConcept", "The qualification of the practitioner which is applicable for this service.", 0, 1, this.qualification));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1349547969: {
                    return new Property("sequence", "positiveInt", "A number to uniquely identify care team entries.", 0, 1, this.sequence);
                }
                case -987494927: {
                    return new Property(Claim.SP_PROVIDER, "Reference(Practitioner|PractitionerRole|Organization)", "Member of the team who provided the product or service.", 0, 1, this.provider);
                }
                case 1847674614: {
                    return new Property("responsible", "boolean", "The party who is billing and/or responsible for the claimed products or services.", 0, 1, this.responsible);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The lead, assisting or supervising practitioner and their discipline if a multidisciplinary team.", 0, 1, this.role);
                }
                case -631333393: {
                    return new Property("qualification", "CodeableConcept", "The qualification of the practitioner which is applicable for this service.", 0, 1, this.qualification);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    Base[] baseArray;
                    if (this.sequence == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.sequence;
                    }
                    return baseArray;
                }
                case -987494927: {
                    Base[] baseArray;
                    if (this.provider == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.provider;
                    }
                    return baseArray;
                }
                case 1847674614: {
                    Base[] baseArray;
                    if (this.responsible == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.responsible;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.role;
                    }
                    return baseArray;
                }
                case -631333393: {
                    Base[] baseArray;
                    if (this.qualification == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.qualification;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    this.sequence = this.castToPositiveInt(value);
                    return value;
                }
                case -987494927: {
                    this.provider = this.castToReference(value);
                    return value;
                }
                case 1847674614: {
                    this.responsible = this.castToBoolean(value);
                    return value;
                }
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
                case -631333393: {
                    this.qualification = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals(Claim.SP_PROVIDER)) {
                this.provider = this.castToReference(value);
            } else if (name.equals("responsible")) {
                this.responsible = this.castToBoolean(value);
            } else if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else if (name.equals("qualification")) {
                this.qualification = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = null;
            } else if (name.equals(Claim.SP_PROVIDER)) {
                this.provider = null;
            } else if (name.equals("responsible")) {
                this.responsible = null;
            } else if (name.equals("role")) {
                this.role = null;
            } else if (name.equals("qualification")) {
                this.qualification = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return this.getSequenceElement();
                }
                case -987494927: {
                    return this.getProvider();
                }
                case 1847674614: {
                    return this.getResponsibleElement();
                }
                case 3506294: {
                    return this.getRole();
                }
                case -631333393: {
                    return this.getQualification();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1349547969: {
                    return new String[]{"positiveInt"};
                }
                case -987494927: {
                    return new String[]{"Reference"};
                }
                case 1847674614: {
                    return new String[]{"boolean"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -631333393: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.sequence");
            }
            if (name.equals(Claim.SP_PROVIDER)) {
                this.provider = new Reference();
                return this.provider;
            }
            if (name.equals("responsible")) {
                throw new FHIRException("Cannot call addChild on a singleton property Claim.responsible");
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("qualification")) {
                this.qualification = new CodeableConcept();
                return this.qualification;
            }
            return super.addChild(name);
        }

        @Override
        public CareTeamComponent copy() {
            CareTeamComponent dst = new CareTeamComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CareTeamComponent dst) {
            super.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.provider = this.provider == null ? null : this.provider.copy();
            dst.responsible = this.responsible == null ? null : this.responsible.copy();
            dst.role = this.role == null ? null : this.role.copy();
            dst.qualification = this.qualification == null ? null : this.qualification.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CareTeamComponent)) {
                return false;
            }
            CareTeamComponent o = (CareTeamComponent)other_;
            return CareTeamComponent.compareDeep(this.sequence, o.sequence, true) && CareTeamComponent.compareDeep(this.provider, o.provider, true) && CareTeamComponent.compareDeep(this.responsible, o.responsible, true) && CareTeamComponent.compareDeep(this.role, o.role, true) && CareTeamComponent.compareDeep(this.qualification, o.qualification, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CareTeamComponent)) {
                return false;
            }
            CareTeamComponent o = (CareTeamComponent)other_;
            return CareTeamComponent.compareValues(this.sequence, o.sequence, true) && CareTeamComponent.compareValues(this.responsible, o.responsible, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.sequence, this.provider, this.responsible, this.role, this.qualification});
        }

        @Override
        public String fhirType() {
            return "Claim.careTeam";
        }
    }

    @Block
    public static class PayeeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category of recipient", formalDefinition="Type of Party to be reimbursed: subscriber, provider, other.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/payeetype")
        protected CodeableConcept type;
        @Child(name="party", type={Practitioner.class, PractitionerRole.class, Organization.class, Patient.class, RelatedPerson.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recipient reference", formalDefinition="Reference to the individual or organization to whom any payment will be made.")
        protected Reference party;
        protected Resource partyTarget;
        private static final long serialVersionUID = 1609484699L;

        public PayeeComponent() {
        }

        public PayeeComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PayeeComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Reference getParty() {
            if (this.party == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PayeeComponent.party");
                }
                if (Configuration.doAutoCreate()) {
                    this.party = new Reference();
                }
            }
            return this.party;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public PayeeComponent setParty(Reference value) {
            this.party = value;
            return this;
        }

        public Resource getPartyTarget() {
            return this.partyTarget;
        }

        public PayeeComponent setPartyTarget(Resource value) {
            this.partyTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "Type of Party to be reimbursed: subscriber, provider, other.", 0, 1, this.type));
            children.add(new Property("party", "Reference(Practitioner|PractitionerRole|Organization|Patient|RelatedPerson)", "Reference to the individual or organization to whom any payment will be made.", 0, 1, this.party));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of Party to be reimbursed: subscriber, provider, other.", 0, 1, this.type);
                }
                case 106437350: {
                    return new Property("party", "Reference(Practitioner|PractitionerRole|Organization|Patient|RelatedPerson)", "Reference to the individual or organization to whom any payment will be made.", 0, 1, this.party);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 106437350: {
                    Base[] baseArray;
                    if (this.party == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.party;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 106437350: {
                    this.party = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("party")) {
                this.party = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = null;
            } else if (name.equals("party")) {
                this.party = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 106437350: {
                    return this.getParty();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 106437350: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("party")) {
                this.party = new Reference();
                return this.party;
            }
            return super.addChild(name);
        }

        @Override
        public PayeeComponent copy() {
            PayeeComponent dst = new PayeeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PayeeComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.party = this.party == null ? null : this.party.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PayeeComponent)) {
                return false;
            }
            PayeeComponent o = (PayeeComponent)other_;
            return PayeeComponent.compareDeep(this.type, o.type, true) && PayeeComponent.compareDeep(this.party, o.party, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PayeeComponent)) {
                return false;
            }
            PayeeComponent o = (PayeeComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.party});
        }

        @Override
        public String fhirType() {
            return "Claim.payee";
        }
    }

    @Block
    public static class RelatedClaimComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="claim", type={Claim.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to the related claim", formalDefinition="Reference to a related claim.")
        protected Reference claim;
        protected Claim claimTarget;
        @Child(name="relationship", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the reference claim is related", formalDefinition="A code to convey how the claims are related.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/related-claim-relationship")
        protected CodeableConcept relationship;
        @Child(name="reference", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="File or case reference", formalDefinition="An alternate organizational reference to the case or file to which this particular claim pertains.")
        protected Identifier reference;
        private static final long serialVersionUID = -379338905L;

        public Reference getClaim() {
            if (this.claim == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedClaimComponent.claim");
                }
                if (Configuration.doAutoCreate()) {
                    this.claim = new Reference();
                }
            }
            return this.claim;
        }

        public boolean hasClaim() {
            return this.claim != null && !this.claim.isEmpty();
        }

        public RelatedClaimComponent setClaim(Reference value) {
            this.claim = value;
            return this;
        }

        public Claim getClaimTarget() {
            if (this.claimTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedClaimComponent.claim");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimTarget = new Claim();
                }
            }
            return this.claimTarget;
        }

        public RelatedClaimComponent setClaimTarget(Claim value) {
            this.claimTarget = value;
            return this;
        }

        public CodeableConcept getRelationship() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedClaimComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new CodeableConcept();
                }
            }
            return this.relationship;
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public RelatedClaimComponent setRelationship(CodeableConcept value) {
            this.relationship = value;
            return this;
        }

        public Identifier getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedClaimComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Identifier();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public RelatedClaimComponent setReference(Identifier value) {
            this.reference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("claim", "Reference(Claim)", "Reference to a related claim.", 0, 1, this.claim));
            children.add(new Property("relationship", "CodeableConcept", "A code to convey how the claims are related.", 0, 1, this.relationship));
            children.add(new Property("reference", "Identifier", "An alternate organizational reference to the case or file to which this particular claim pertains.", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 94742588: {
                    return new Property("claim", "Reference(Claim)", "Reference to a related claim.", 0, 1, this.claim);
                }
                case -261851592: {
                    return new Property("relationship", "CodeableConcept", "A code to convey how the claims are related.", 0, 1, this.relationship);
                }
                case -925155509: {
                    return new Property("reference", "Identifier", "An alternate organizational reference to the case or file to which this particular claim pertains.", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 94742588: {
                    Base[] baseArray;
                    if (this.claim == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.claim;
                    }
                    return baseArray;
                }
                case -261851592: {
                    Base[] baseArray;
                    if (this.relationship == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.relationship;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 94742588: {
                    this.claim = this.castToReference(value);
                    return value;
                }
                case -261851592: {
                    this.relationship = this.castToCodeableConcept(value);
                    return value;
                }
                case -925155509: {
                    this.reference = this.castToIdentifier(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("claim")) {
                this.claim = this.castToReference(value);
            } else if (name.equals("relationship")) {
                this.relationship = this.castToCodeableConcept(value);
            } else if (name.equals("reference")) {
                this.reference = this.castToIdentifier(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("claim")) {
                this.claim = null;
            } else if (name.equals("relationship")) {
                this.relationship = null;
            } else if (name.equals("reference")) {
                this.reference = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 94742588: {
                    return this.getClaim();
                }
                case -261851592: {
                    return this.getRelationship();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 94742588: {
                    return new String[]{"Reference"};
                }
                case -261851592: {
                    return new String[]{"CodeableConcept"};
                }
                case -925155509: {
                    return new String[]{"Identifier"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("claim")) {
                this.claim = new Reference();
                return this.claim;
            }
            if (name.equals("relationship")) {
                this.relationship = new CodeableConcept();
                return this.relationship;
            }
            if (name.equals("reference")) {
                this.reference = new Identifier();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public RelatedClaimComponent copy() {
            RelatedClaimComponent dst = new RelatedClaimComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RelatedClaimComponent dst) {
            super.copyValues(dst);
            dst.claim = this.claim == null ? null : this.claim.copy();
            dst.relationship = this.relationship == null ? null : this.relationship.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RelatedClaimComponent)) {
                return false;
            }
            RelatedClaimComponent o = (RelatedClaimComponent)other_;
            return RelatedClaimComponent.compareDeep(this.claim, o.claim, true) && RelatedClaimComponent.compareDeep(this.relationship, o.relationship, true) && RelatedClaimComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RelatedClaimComponent)) {
                return false;
            }
            RelatedClaimComponent o = (RelatedClaimComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.claim, this.relationship, this.reference});
        }

        @Override
        public String fhirType() {
            return "Claim.related";
        }
    }

    public static class UseEnumFactory
    implements EnumFactory<Use> {
        @Override
        public Use fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("claim".equals(codeString)) {
                return Use.CLAIM;
            }
            if ("preauthorization".equals(codeString)) {
                return Use.PREAUTHORIZATION;
            }
            if ("predetermination".equals(codeString)) {
                return Use.PREDETERMINATION;
            }
            throw new IllegalArgumentException("Unknown Use code '" + codeString + "'");
        }

        public Enumeration<Use> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<Use>(this, Use.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<Use>(this, Use.NULL, code);
            }
            if ("claim".equals(codeString)) {
                return new Enumeration<Use>(this, Use.CLAIM, code);
            }
            if ("preauthorization".equals(codeString)) {
                return new Enumeration<Use>(this, Use.PREAUTHORIZATION, code);
            }
            if ("predetermination".equals(codeString)) {
                return new Enumeration<Use>(this, Use.PREDETERMINATION, code);
            }
            throw new FHIRException("Unknown Use code '" + codeString + "'");
        }

        @Override
        public String toCode(Use code) {
            if (code == Use.CLAIM) {
                return "claim";
            }
            if (code == Use.PREAUTHORIZATION) {
                return "preauthorization";
            }
            if (code == Use.PREDETERMINATION) {
                return "predetermination";
            }
            return "?";
        }

        @Override
        public String toSystem(Use code) {
            return code.getSystem();
        }
    }

    public static enum Use {
        CLAIM,
        PREAUTHORIZATION,
        PREDETERMINATION,
        NULL;


        public static Use fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("claim".equals(codeString)) {
                return CLAIM;
            }
            if ("preauthorization".equals(codeString)) {
                return PREAUTHORIZATION;
            }
            if ("predetermination".equals(codeString)) {
                return PREDETERMINATION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown Use code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CLAIM: {
                    return "claim";
                }
                case PREAUTHORIZATION: {
                    return "preauthorization";
                }
                case PREDETERMINATION: {
                    return "predetermination";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CLAIM: {
                    return "http://hl7.org/fhir/claim-use";
                }
                case PREAUTHORIZATION: {
                    return "http://hl7.org/fhir/claim-use";
                }
                case PREDETERMINATION: {
                    return "http://hl7.org/fhir/claim-use";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CLAIM: {
                    return "The treatment is complete and this represents a Claim for the services.";
                }
                case PREAUTHORIZATION: {
                    return "The treatment is proposed and this represents a Pre-authorization for the services.";
                }
                case PREDETERMINATION: {
                    return "The treatment is proposed and this represents a Pre-determination for the services.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CLAIM: {
                    return "Claim";
                }
                case PREAUTHORIZATION: {
                    return "Preauthorization";
                }
                case PREDETERMINATION: {
                    return "Predetermination";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ClaimStatusEnumFactory
    implements EnumFactory<ClaimStatus> {
        @Override
        public ClaimStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ClaimStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return ClaimStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return ClaimStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ClaimStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown ClaimStatus code '" + codeString + "'");
        }

        public Enumeration<ClaimStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ClaimStatus>(this, ClaimStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ClaimStatus>(this, ClaimStatus.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ClaimStatus>(this, ClaimStatus.ACTIVE, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ClaimStatus>(this, ClaimStatus.CANCELLED, code);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ClaimStatus>(this, ClaimStatus.DRAFT, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ClaimStatus>(this, ClaimStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown ClaimStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ClaimStatus code) {
            if (code == ClaimStatus.ACTIVE) {
                return "active";
            }
            if (code == ClaimStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ClaimStatus.DRAFT) {
                return "draft";
            }
            if (code == ClaimStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(ClaimStatus code) {
            return code.getSystem();
        }
    }

    public static enum ClaimStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static ClaimStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ClaimStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The instance was entered in error.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

