/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CarePlanActivityStatus {
    NOTSTARTED,
    SCHEDULED,
    INPROGRESS,
    ONHOLD,
    COMPLETED,
    CANCELLED,
    STOPPED,
    UNKNOWN,
    ENTEREDINERROR,
    NULL;


    public static CarePlanActivityStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("not-started".equals(codeString)) {
            return NOTSTARTED;
        }
        if ("scheduled".equals(codeString)) {
            return SCHEDULED;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("on-hold".equals(codeString)) {
            return ONHOLD;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("stopped".equals(codeString)) {
            return STOPPED;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown CarePlanActivityStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NOTSTARTED: {
                return "not-started";
            }
            case SCHEDULED: {
                return "scheduled";
            }
            case INPROGRESS: {
                return "in-progress";
            }
            case ONHOLD: {
                return "on-hold";
            }
            case COMPLETED: {
                return "completed";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case STOPPED: {
                return "stopped";
            }
            case UNKNOWN: {
                return "unknown";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/care-plan-activity-status";
    }

    public String getDefinition() {
        switch (this) {
            case NOTSTARTED: {
                return "Care plan activity is planned but no action has yet been taken.";
            }
            case SCHEDULED: {
                return "Appointment or other booking has occurred but activity has not yet begun.";
            }
            case INPROGRESS: {
                return "Care plan activity has been started but is not yet complete.";
            }
            case ONHOLD: {
                return "Care plan activity was started but has temporarily ceased with an expectation of resumption at a future time.";
            }
            case COMPLETED: {
                return "Care plan activity has been completed (more or less) as planned.";
            }
            case CANCELLED: {
                return "The planned care plan activity has been withdrawn.";
            }
            case STOPPED: {
                return "The planned care plan activity has been ended prior to completion after the activity was started.";
            }
            case UNKNOWN: {
                return "The current state of the care plan activity is not known.  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, but the authoring/source system does not know which one.";
            }
            case ENTEREDINERROR: {
                return "Care plan activity was entered in error and voided.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NOTSTARTED: {
                return "Not Started";
            }
            case SCHEDULED: {
                return "Scheduled";
            }
            case INPROGRESS: {
                return "In Progress";
            }
            case ONHOLD: {
                return "On Hold";
            }
            case COMPLETED: {
                return "Completed";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case STOPPED: {
                return "Stopped";
            }
            case UNKNOWN: {
                return "Unknown";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

