/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.SearchParameter;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class IntegrityChecker {
    private NpmPackage npm;

    public static void main(String[] args) throws Exception {
        IntegrityChecker check = new IntegrityChecker();
        check.load(args[0]);
        check.check();
    }

    private void check() throws IOException {
        this.dumpSD(new FileWriter("/Users/grahamegrieve/temp/r4-dump.txt"));
    }

    private void dumpSD(FileWriter w) throws FHIRFormatError, IOException {
        HashMap<String, StructureDefinition> map = new HashMap<String, StructureDefinition>();
        for (String sdn : this.npm.listResources(new String[]{"StructureDefinition"})) {
            InputStream s = this.npm.load(sdn);
            StructureDefinition sd = (StructureDefinition)new JsonParser().parse(s);
            map.put(sd.getUrl(), sd);
        }
        this.msg("Loaded " + map.size() + " Structures");
        ArrayList<String> structures = new ArrayList<String>();
        for (StructureDefinition sd : map.values()) {
            structures.add(sd.getUrl());
        }
        Collections.sort(structures);
        for (String sdn : structures) {
            this.dumpSD((StructureDefinition)map.get(sdn), map, w);
        }
    }

    private void dumpSD(StructureDefinition sd, Map<String, StructureDefinition> map, FileWriter w) throws IOException {
        if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
            StructureDefinition base = sd.hasBaseDefinition() ? map.get(sd.getBaseDefinition()) : null;
            System.out.println(sd.getType() + (String)(base == null ? "" : " : " + base.getType()));
            w.append(sd.getType() + (String)(base == null ? "" : " : " + base.getType()) + "\r\n");
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                w.append("  " + Utilities.padLeft((String)"", (char)' ', (int)Utilities.charCount((String)ed.getPath(), (char)'.')) + this.tail(ed.getPath()) + " : " + ed.typeSummary() + " [" + ed.getMin() + ".." + ed.getMax() + "]\r\n");
            }
        }
    }

    private String tail(String path) {
        return path.contains(".") ? path.substring(path.lastIndexOf(46) + 1) : path;
    }

    private void checkSP() throws IOException {
        ArrayList<SearchParameter> list = new ArrayList<SearchParameter>();
        for (String sdn : this.npm.listResources(new String[]{"SearchParameter"})) {
            InputStream s = this.npm.load(sdn);
            SearchParameter sp = (SearchParameter)new JsonParser().parse(s);
            list.add(sp);
        }
        this.msg("Loaded " + list.size() + " resources");
        HashMap<String, SearchParameterNode> map = new HashMap<String, SearchParameterNode>();
        for (SearchParameter sp : list) {
            for (CodeType c : sp.getBase()) {
                String s = c.primitiveValue();
                if (!map.containsKey(s)) {
                    map.put(s, new SearchParameterNode(s));
                }
                this.addNode(sp, sp.getBase().size() == 1, (SearchParameterNode)map.get(s));
            }
        }
        for (SearchParameterNode node : this.sort(map.values())) {
            this.dump(node);
        }
    }

    private void dump(SearchParameterNode node) {
        this.msg(node.name);
        for (SearchParameterParamNode p : this.sortP(node.params)) {
            String exp;
            String string = exp = p.sp.getExperimental() ? "  **exp!" : "";
            if (p.only) {
                this.msg("  " + p.sp.getCode() + exp);
                continue;
            }
            this.msg("  *" + p.sp.getCode() + exp);
        }
    }

    private List<SearchParameterParamNode> sortP(List<SearchParameterParamNode> params) {
        ArrayList<SearchParameterParamNode> res = new ArrayList<SearchParameterParamNode>();
        res.addAll(params);
        Collections.sort(res, new SearchParameterParamNodeSorter());
        return res;
    }

    private List<SearchParameterNode> sort(Collection<SearchParameterNode> values) {
        ArrayList<SearchParameterNode> res = new ArrayList<SearchParameterNode>();
        res.addAll(values);
        Collections.sort(res, new SearchParameterNodeSorter());
        return res;
    }

    private void addNode(SearchParameter sp, boolean b, SearchParameterNode node) {
        node.params.add(new SearchParameterParamNode(sp, b));
    }

    private void checkSD() throws IOException {
        HashMap<String, StructureDefinition> map = new HashMap<String, StructureDefinition>();
        for (String sdn : this.npm.listResources(new String[]{"StructureDefinition"})) {
            InputStream s = this.npm.load(sdn);
            StructureDefinition sd = (StructureDefinition)new JsonParser().parse(s);
            map.put(sd.getUrl(), sd);
        }
        this.msg("Loaded " + map.size() + " resources");
        ArrayList<StructureDefinitionNode> roots = new ArrayList<StructureDefinitionNode>();
        for (StructureDefinition sd : map.values()) {
            if (sd.getBaseDefinition() != null && map.containsKey(sd.getBaseDefinition())) continue;
            StructureDefinitionNode root = new StructureDefinitionNode(sd);
            roots.add(root);
            this.analyse(root, map);
        }
        this.sort((List<StructureDefinitionNode>)roots);
        for (StructureDefinitionNode root : roots) {
            this.describe(root, 0);
        }
    }

    private void sort(List<StructureDefinitionNode> list) {
        Collections.sort(list, new StructureDefinitionNodeComparer());
    }

    private void analyse(StructureDefinitionNode node, Map<String, StructureDefinition> map) {
        for (StructureDefinition sd : map.values()) {
            if (!node.sd.getUrl().equals(sd.getBaseDefinition())) continue;
            StructureDefinitionNode c = new StructureDefinitionNode(sd);
            node.children.add(c);
            this.analyse(c, map);
        }
        this.sort(node.children);
    }

    private void describe(StructureDefinitionNode node, int level) {
        this.describe(node.sd, level);
        for (StructureDefinitionNode c : node.children) {
            this.describe(c, level + 1);
        }
    }

    private void describe(StructureDefinition sd, int level) {
        String exp;
        String string = exp = sd.getExperimental() ? "  **exp!" : "";
        if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            this.msg(Utilities.padLeft((String)"", (char)' ', (int)level) + sd.getType() + " / " + sd.getName() + " (" + sd.getUrl() + ")" + exp);
        } else {
            this.msg(Utilities.padLeft((String)"", (char)' ', (int)level) + sd.getType() + " : " + sd.getKind() + exp);
        }
    }

    private void msg(String string) {
        System.out.println(string);
    }

    private void load(String folder) throws IOException {
        this.msg("Loading resources from " + folder);
        this.npm = NpmPackage.fromFolder((String)folder);
    }

    public class StructureDefinitionNode {
        StructureDefinition sd;
        List<StructureDefinitionNode> children = new ArrayList<StructureDefinitionNode>();

        public StructureDefinitionNode(StructureDefinition sd) {
            this.sd = sd;
        }
    }

    public class StructureDefinitionNodeComparer
    implements Comparator<StructureDefinitionNode> {
        @Override
        public int compare(StructureDefinitionNode arg0, StructureDefinitionNode arg1) {
            if (arg0.sd.getType().equals(arg1.sd.getType())) {
                return arg0.sd.getName().compareTo(arg1.sd.getName());
            }
            return arg0.sd.getType().compareTo(arg1.sd.getType());
        }
    }

    public class SearchParameterNode {
        private String name;
        private List<SearchParameterParamNode> params = new ArrayList<SearchParameterParamNode>();

        public SearchParameterNode(String name) {
            this.name = name;
        }
    }

    public class SearchParameterParamNode {
        SearchParameter sp;
        boolean only;

        public SearchParameterParamNode(SearchParameter sp, boolean only) {
            this.sp = sp;
            this.only = only;
        }
    }

    public class SearchParameterParamNodeSorter
    implements Comparator<SearchParameterParamNode> {
        @Override
        public int compare(SearchParameterParamNode o1, SearchParameterParamNode o2) {
            return o1.sp.getCode().compareTo(o2.sp.getCode());
        }
    }

    public class SearchParameterNodeSorter
    implements Comparator<SearchParameterNode> {
        @Override
        public int compare(SearchParameterNode o1, SearchParameterNode o2) {
            return o1.name.compareTo(o2.name);
        }
    }
}

