/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r4.conformance.ProfileUtilities;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.XmlParser;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.CompartmentDefinition;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.DiagnosticReport;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.ExtensionHelper;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ImplementationGuide;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.OperationDefinition;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.SampledData;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r4.terminologies.ValueSetExpander;
import org.hl7.fhir.r4.utils.EOperationOutcome;
import org.hl7.fhir.r4.utils.INarrativeGenerator;
import org.hl7.fhir.r4.utils.LiquidEngine;
import org.hl7.fhir.r4.utils.ResourceUtilities;
import org.hl7.fhir.r4.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.LoincLinker;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.TerminologyServiceOptions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.utilities.xml.XmlGenerator;
import org.w3c.dom.Element;

public class NarrativeGenerator
implements INarrativeGenerator {
    private static final String ABSTRACT_CODE_HINT = "This code is not selectable ('Abstract')";
    private Bundle bundle;
    private String definitionsTarget;
    private String corePath;
    private String destDir;
    private String snomedEdition;
    private ProfileUtilities.ProfileKnowledgeProvider pkp;
    private MarkDownProcessor markdown = new MarkDownProcessor(MarkDownProcessor.Dialect.COMMON_MARK);
    private ITypeParser parser;
    private ILiquidTemplateProvider templateProvider;
    private FHIRPathEngine.IEvaluationContext services;
    private String prefix;
    private IWorkerContext context;
    private String basePath;
    private String tooCostlyNoteEmpty;
    private String tooCostlyNoteNotEmpty;
    private IReferenceResolver resolver;
    private int headerLevelContext;
    private List<ConceptMapRenderInstructions> renderingMaps = new ArrayList<ConceptMapRenderInstructions>();
    private boolean pretty;
    private boolean canonicalUrlsAsLinks;
    private TerminologyServiceOptions terminologyServiceOptions = new TerminologyServiceOptions(FhirPublication.R4);

    public boolean generate(Bundle b, boolean evenIfAlreadyHasNarrative, Set<String> outputTracker) throws EOperationOutcome, FHIRException, IOException {
        boolean res = false;
        this.bundle = b;
        for (Bundle.BundleEntryComponent be : b.getEntry()) {
            if (!be.hasResource() || !(be.getResource() instanceof DomainResource)) continue;
            DomainResource dr = (DomainResource)be.getResource();
            if (!evenIfAlreadyHasNarrative && dr.getText().hasDiv()) continue;
            res = this.generate(new ResourceContext(b, dr), dr, outputTracker) || res;
        }
        return res;
    }

    public boolean generate(DomainResource r, Set<String> outputTracker) throws EOperationOutcome, FHIRException, IOException {
        return this.generate(null, r, outputTracker);
    }

    public boolean generate(ResourceContext rcontext, DomainResource r, Set<String> outputTracker) throws EOperationOutcome, FHIRException, IOException {
        String liquidTemplate;
        if (rcontext == null) {
            rcontext = new ResourceContext(null, r);
        }
        if (this.templateProvider != null && (liquidTemplate = this.templateProvider.findTemplate(rcontext, r)) != null) {
            return this.generateByLiquid(rcontext, r, liquidTemplate, outputTracker);
        }
        if (r instanceof ConceptMap) {
            return this.generate(rcontext, (ConceptMap)r);
        }
        if (r instanceof ValueSet) {
            return this.generate(rcontext, (ValueSet)r, true);
        }
        if (r instanceof CodeSystem) {
            return this.generate(rcontext, (CodeSystem)r, true, null);
        }
        if (r instanceof OperationOutcome) {
            return this.generate(rcontext, (OperationOutcome)r);
        }
        if (r instanceof CapabilityStatement) {
            return this.generate(rcontext, (CapabilityStatement)r);
        }
        if (r instanceof CompartmentDefinition) {
            return this.generate(rcontext, (CompartmentDefinition)r);
        }
        if (r instanceof OperationDefinition) {
            return this.generate(rcontext, (OperationDefinition)r);
        }
        if (r instanceof StructureDefinition) {
            return this.generate(rcontext, (StructureDefinition)r, outputTracker);
        }
        if (r instanceof ImplementationGuide) {
            return this.generate(rcontext, (ImplementationGuide)r);
        }
        if (r instanceof DiagnosticReport) {
            this.inject(r, this.generateDiagnosticReport(new ResourceWrapperDirect(r)), Narrative.NarrativeStatus.GENERATED);
            return true;
        }
        StructureDefinition p = null;
        if (r.hasMeta()) {
            for (UriType uriType : r.getMeta().getProfile()) {
                if (p != null) continue;
                p = this.context.fetchResource(StructureDefinition.class, (String)uriType.getValue());
            }
        }
        if (p == null) {
            p = this.context.fetchResource(StructureDefinition.class, r.getResourceType().toString());
        }
        if (p == null) {
            p = this.context.fetchTypeDefinition(r.getResourceType().toString().toLowerCase());
        }
        if (p != null) {
            return this.generateByProfile(rcontext, p, true);
        }
        return false;
    }

    private boolean generateByLiquid(ResourceContext rcontext, DomainResource r, String liquidTemplate, Set<String> outputTracker) {
        XhtmlNode x;
        LiquidEngine engine = new LiquidEngine(this.context, this.services);
        try {
            LiquidEngine.LiquidDocument doc = engine.parse(liquidTemplate, "template");
            String html = engine.evaluate(doc, r, rcontext);
            x = new XhtmlParser().parseFragment(html);
            if (!x.getName().equals("div")) {
                throw new FHIRException("Error in template: Root element is not 'div'");
            }
        }
        catch (IOException | FHIRException e) {
            x = new XhtmlNode(NodeType.Element, "div");
            x.para().b().setAttribute("style", "color: maroon").tx("Exception generating Narrative: " + e.getMessage());
        }
        this.inject(r, x, Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    public NarrativeGenerator(String prefix, String basePath, IWorkerContext context) {
        this.prefix = prefix;
        this.context = context;
        this.basePath = basePath;
        this.init();
    }

    public NarrativeGenerator setLiquidServices(ILiquidTemplateProvider templateProvider, FHIRPathEngine.IEvaluationContext services) {
        this.templateProvider = templateProvider;
        this.services = services;
        return this;
    }

    public Base parseType(String xml, String type) throws IOException, FHIRException {
        if (this.parser != null) {
            return this.parser.parseType(xml, type);
        }
        return new XmlParser().parseAnyType(xml, type);
    }

    public NarrativeGenerator(String prefix, String basePath, IWorkerContext context, IReferenceResolver resolver) {
        this.prefix = prefix;
        this.context = context;
        this.basePath = basePath;
        this.resolver = resolver;
        this.init();
    }

    private void init() {
        this.renderingMaps.add(new ConceptMapRenderInstructions("Canonical Status", "http://hl7.org/fhir/ValueSet/resource-status", false));
    }

    public List<ConceptMapRenderInstructions> getRenderingMaps() {
        return this.renderingMaps;
    }

    public int getHeaderLevelContext() {
        return this.headerLevelContext;
    }

    public NarrativeGenerator setHeaderLevelContext(int headerLevelContext) {
        this.headerLevelContext = headerLevelContext;
        return this;
    }

    public String getTooCostlyNoteEmpty() {
        return this.tooCostlyNoteEmpty;
    }

    public NarrativeGenerator setTooCostlyNoteEmpty(String tooCostlyNoteEmpty) {
        this.tooCostlyNoteEmpty = tooCostlyNoteEmpty;
        return this;
    }

    public String getTooCostlyNoteNotEmpty() {
        return this.tooCostlyNoteNotEmpty;
    }

    public NarrativeGenerator setTooCostlyNoteNotEmpty(String tooCostlyNoteNotEmpty) {
        this.tooCostlyNoteNotEmpty = tooCostlyNoteNotEmpty;
        return this;
    }

    public String generate(Element doc) throws IOException, FHIRException {
        return this.generate(null, doc);
    }

    public String generate(ResourceContext rcontext, Element doc) throws IOException, FHIRException {
        if (rcontext == null) {
            rcontext = new ResourceContext(null, doc);
        }
        String rt = "http://hl7.org/fhir/StructureDefinition/" + doc.getNodeName();
        StructureDefinition p = this.context.fetchResource(StructureDefinition.class, rt);
        return this.generateByProfile(doc, p, true);
    }

    public String generate(org.hl7.fhir.r4.elementmodel.Element er, boolean showCodeDetails, ITypeParser parser) throws IOException, FHIRException {
        return this.generate(null, er, showCodeDetails, parser);
    }

    public String generate(ResourceContext rcontext, org.hl7.fhir.r4.elementmodel.Element er, boolean showCodeDetails, ITypeParser parser) throws IOException, FHIRException {
        if (rcontext == null) {
            rcontext = new ResourceContext(null, er);
        }
        this.parser = parser;
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.para().b().tx("Generated Narrative" + (showCodeDetails ? " with Details" : ""));
        try {
            ResourceWrapperMetaElement resw = new ResourceWrapperMetaElement(er);
            BaseWrapperMetaElement base = new BaseWrapperMetaElement(er, null, er.getProperty().getStructure(), er.getProperty().getDefinition());
            base.children();
            this.generateByProfile(resw, er.getProperty().getStructure(), base, er.getProperty().getStructure().getSnapshot().getElement(), er.getProperty().getDefinition(), base.children, x, er.fhirType(), showCodeDetails, 0, rcontext);
        }
        catch (Exception e) {
            e.printStackTrace();
            x.para().b().setAttribute("style", "color: maroon").tx("Exception generating Narrative: " + e.getMessage());
        }
        this.inject(er, x, Narrative.NarrativeStatus.GENERATED);
        return new XhtmlComposer(true, this.pretty).compose(x);
    }

    private boolean generateByProfile(ResourceContext rc, StructureDefinition profile, boolean showCodeDetails) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.para().b().tx("Generated Narrative" + (showCodeDetails ? " with Details" : ""));
        try {
            this.generateByProfile(rc.resourceResource, profile, rc.resourceResource, profile.getSnapshot().getElement(), profile.getSnapshot().getElement().get(0), this.getChildrenForPath(profile.getSnapshot().getElement(), rc.resourceResource.getResourceType().toString()), x, rc.resourceResource.getResourceType().toString(), showCodeDetails, rc);
        }
        catch (Exception e) {
            e.printStackTrace();
            x.para().b().setAttribute("style", "color: maroon").tx("Exception generating Narrative: " + e.getMessage());
        }
        this.inject(rc.resourceResource, x, Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    private String generateByProfile(Element er, StructureDefinition profile, boolean showCodeDetails) throws IOException, FHIRException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.para().b().tx("Generated Narrative" + (showCodeDetails ? " with Details" : ""));
        try {
            this.generateByProfile(er, profile, er, profile.getSnapshot().getElement(), profile.getSnapshot().getElement().get(0), this.getChildrenForPath(profile.getSnapshot().getElement(), er.getLocalName()), x, er.getLocalName(), showCodeDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
            x.para().b().setAttribute("style", "color: maroon").tx("Exception generating Narrative: " + e.getMessage());
        }
        this.inject(er, x, Narrative.NarrativeStatus.GENERATED);
        String b = new XhtmlComposer(true, this.pretty).compose(x);
        return b;
    }

    private void generateByProfile(Element eres, StructureDefinition profile, Element ee, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails) throws FHIRException, UnsupportedEncodingException, IOException {
        ResourceWrapperElement resw = new ResourceWrapperElement(eres, profile);
        BaseWrapperElement base = new BaseWrapperElement(ee, null, profile, profile.getSnapshot().getElement().get(0));
        this.generateByProfile(resw, profile, base, allElements, defn, children, x, path, showCodeDetails, 0, null);
    }

    private void generateByProfile(Resource res, StructureDefinition profile, Base e, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails, ResourceContext rc) throws FHIRException, UnsupportedEncodingException, IOException {
        this.generateByProfile(new ResourceWrapperDirect(res), profile, new BaseWrapperDirect(e), allElements, defn, children, x, path, showCodeDetails, 0, rc);
    }

    private void generateByProfile(ResourceWrapper res, StructureDefinition profile, BaseWrapper e, List<ElementDefinition> allElements, ElementDefinition defn, List<ElementDefinition> children, XhtmlNode x, String path, boolean showCodeDetails, int indent, ResourceContext rc) throws FHIRException, UnsupportedEncodingException, IOException {
        if (children.isEmpty()) {
            this.renderLeaf(res, e, defn, x, false, showCodeDetails, this.readDisplayHints(defn), path, indent, rc);
        } else {
            for (PropertyWrapper p : this.splitExtensions(profile, e.children())) {
                ElementDefinition child;
                if (!p.hasValues() || (child = this.getElementDefinition(children, path + "." + p.getName(), p)) == null) continue;
                Map<String, String> displayHints = this.readDisplayHints(child);
                if (this.exemptFromRendering(child)) continue;
                List<ElementDefinition> grandChildren = this.getChildrenForPath(allElements, path + "." + p.getName());
                this.filterGrandChildren(grandChildren, path + "." + p.getName(), p);
                if (p.getValues().size() <= 0 || child == null) continue;
                if (this.isPrimitive(child)) {
                    XhtmlNode para = x.para();
                    String name = p.getName();
                    if (name.endsWith("[x]")) {
                        name = name.substring(0, name.length() - 3);
                    }
                    if (!showCodeDetails && this.isDefaultValue(displayHints, p.getValues())) continue;
                    para.b().addText(name);
                    para.tx(": ");
                    if (this.renderAsList(child) && p.getValues().size() > 1) {
                        XhtmlNode list = x.ul();
                        for (BaseWrapper v : p.getValues()) {
                            this.renderLeaf(res, v, child, list.li(), false, showCodeDetails, displayHints, path, indent, rc);
                        }
                        continue;
                    }
                    boolean first = true;
                    for (BaseWrapper v : p.getValues()) {
                        if (first) {
                            first = false;
                        } else {
                            para.tx(", ");
                        }
                        this.renderLeaf(res, v, child, para, false, showCodeDetails, displayHints, path, indent, rc);
                    }
                    continue;
                }
                if (this.canDoTable(path, p, grandChildren)) {
                    x.addTag(this.getHeader()).addText(Utilities.capitalize((String)Utilities.camelCase((String)Utilities.pluralizeMe((String)p.getName()))));
                    XhtmlNode tbl = x.table("grid");
                    XhtmlNode tr = tbl.tr();
                    tr.td().tx("-");
                    this.addColumnHeadings(tr, grandChildren);
                    for (BaseWrapper v : p.getValues()) {
                        if (v == null) continue;
                        tr = tbl.tr();
                        tr.td().tx("*");
                        this.addColumnValues(res, tr, grandChildren, v, showCodeDetails, displayHints, path, indent, rc);
                    }
                    continue;
                }
                for (BaseWrapper v : p.getValues()) {
                    if (v == null) continue;
                    XhtmlNode bq = x.addTag("blockquote");
                    bq.para().b().addText(p.getName());
                    this.generateByProfile(res, profile, v, allElements, child, grandChildren, bq, path + "." + p.getName(), showCodeDetails, indent + 1, rc);
                }
            }
        }
    }

    private String getHeader() {
        int i;
        for (i = 3; i <= this.headerLevelContext; ++i) {
        }
        if (i > 6) {
            i = 6;
        }
        return "h" + Integer.toString(i);
    }

    private void filterGrandChildren(List<ElementDefinition> grandChildren, String string, PropertyWrapper prop) {
        ArrayList<ElementDefinition> toRemove = new ArrayList<ElementDefinition>();
        toRemove.addAll(grandChildren);
        for (BaseWrapper b : prop.getValues()) {
            ArrayList<ElementDefinition> list = new ArrayList<ElementDefinition>();
            for (ElementDefinition ed : toRemove) {
                PropertyWrapper p = b.getChildByName(this.tail(ed.getPath()));
                if (p == null || !p.hasValues()) continue;
                list.add(ed);
            }
            toRemove.removeAll(list);
        }
        grandChildren.removeAll(toRemove);
    }

    private List<PropertyWrapper> splitExtensions(StructureDefinition profile, List<PropertyWrapper> children) throws UnsupportedEncodingException, IOException, FHIRException {
        ArrayList<PropertyWrapper> results = new ArrayList<PropertyWrapper>();
        HashMap map = new HashMap();
        for (PropertyWrapper p : children) {
            if (p.getName().equals("extension") || p.getName().equals("modifierExtension")) {
                if (!p.hasValues()) continue;
                for (BaseWrapper v : p.getValues()) {
                    Extension ex = (Extension)v.getBase();
                    String url = ex.getUrl();
                    StructureDefinition ed = this.context.fetchResource(StructureDefinition.class, url);
                    if (p.getName().equals("modifierExtension") && ed == null) {
                        throw new DefinitionException("Unknown modifier extension " + url);
                    }
                    PropertyWrapper pe = (PropertyWrapper)map.get(p.getName() + "[" + url + "]");
                    if (pe == null) {
                        if (ed == null) {
                            if (url.startsWith("http://hl7.org/fhir") && !url.startsWith("http://hl7.org/fhir/us")) {
                                throw new DefinitionException("unknown extension " + url);
                            }
                            pe = new PropertyWrapperDirect(new Property(p.getName() + "[" + url + "]", p.getTypeCode(), p.getDefinition(), p.getMinCardinality(), p.getMaxCardinality(), ex));
                        } else {
                            ElementDefinition def = ed.getSnapshot().getElement().get(0);
                            pe = new PropertyWrapperDirect(new Property(p.getName() + "[" + url + "]", "Extension", def.getDefinition(), def.getMin(), def.getMax().equals("*") ? Integer.MAX_VALUE : Integer.parseInt(def.getMax()), ex));
                            ((PropertyWrapperDirect)pe).wrapped.setStructure(ed);
                        }
                        results.add(pe);
                        continue;
                    }
                    pe.getValues().add(v);
                }
                continue;
            }
            results.add(p);
        }
        return results;
    }

    private boolean isDefaultValue(Map<String, String> displayHints, List<BaseWrapper> list) throws UnsupportedEncodingException, IOException, FHIRException {
        if (list.size() != 1) {
            return false;
        }
        if (list.get(0).getBase() instanceof PrimitiveType) {
            return this.isDefault(displayHints, (PrimitiveType)list.get(0).getBase());
        }
        return false;
    }

    private boolean isDefault(Map<String, String> displayHints, PrimitiveType primitiveType) {
        String v = primitiveType.asStringValue();
        return !Utilities.noString((String)v) && displayHints.containsKey("default") && v.equals(displayHints.get("default"));
    }

    private boolean exemptFromRendering(ElementDefinition child) {
        if (child == null) {
            return false;
        }
        if ("Composition.subject".equals(child.getPath())) {
            return true;
        }
        return "Composition.section".equals(child.getPath());
    }

    private boolean renderAsList(ElementDefinition child) {
        String t;
        return child.getType().size() == 1 && ((t = child.getType().get(0).getWorkingCode()).equals("Address") || t.equals("Reference"));
    }

    private void addColumnHeadings(XhtmlNode tr, List<ElementDefinition> grandChildren) {
        for (ElementDefinition e : grandChildren) {
            tr.td().b().addText(Utilities.capitalize((String)this.tail(e.getPath())));
        }
    }

    private void addColumnValues(ResourceWrapper res, XhtmlNode tr, List<ElementDefinition> grandChildren, BaseWrapper v, boolean showCodeDetails, Map<String, String> displayHints, String path, int indent, ResourceContext rc) throws FHIRException, UnsupportedEncodingException, IOException {
        for (ElementDefinition e : grandChildren) {
            PropertyWrapper p = v.getChildByName(e.getPath().substring(e.getPath().lastIndexOf(".") + 1));
            if (p == null || p.getValues().size() == 0 || p.getValues().get(0) == null) {
                tr.td().tx(" ");
                continue;
            }
            this.renderLeaf(res, p.getValues().get(0), e, tr.td(), false, showCodeDetails, displayHints, path, indent, rc);
        }
    }

    private String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    private boolean canDoTable(String path, PropertyWrapper p, List<ElementDefinition> grandChildren) {
        for (ElementDefinition e : grandChildren) {
            List<PropertyWrapper> values = this.getValues(path, p, e);
            if (values.size() <= 1 && this.isPrimitive(e) && this.canCollapse(e)) continue;
            return false;
        }
        return true;
    }

    private List<PropertyWrapper> getValues(String path, PropertyWrapper p, ElementDefinition e) {
        ArrayList<PropertyWrapper> res = new ArrayList<PropertyWrapper>();
        for (BaseWrapper v : p.getValues()) {
            for (PropertyWrapper g : v.children()) {
                if (!(path + "." + p.getName() + "." + g.getName()).equals(e.getPath())) continue;
                res.add(p);
            }
        }
        return res;
    }

    private boolean canCollapse(ElementDefinition e) {
        return !e.getType().isEmpty();
    }

    private boolean isPrimitive(ElementDefinition e) {
        if (e.getType().isEmpty()) {
            return false;
        }
        return e.getType().size() != 1 || !this.isBase(e.getType().get(0).getWorkingCode());
    }

    private boolean isBase(String code) {
        return code.equals("Element") || code.equals("BackboneElement");
    }

    private ElementDefinition getElementDefinition(List<ElementDefinition> elements, String path, PropertyWrapper p) {
        for (ElementDefinition element : elements) {
            if (!element.getPath().equals(path)) continue;
            return element;
        }
        if (path.endsWith("\"]") && p.getStructure() != null) {
            return p.getStructure().getSnapshot().getElement().get(0);
        }
        return null;
    }

    private void renderLeaf(ResourceWrapper res, BaseWrapper ew, ElementDefinition defn, XhtmlNode x, boolean title, boolean showCodeDetails, Map<String, String> displayHints, String path, int indent, ResourceContext rc) throws FHIRException, UnsupportedEncodingException, IOException {
        if (ew == null) {
            return;
        }
        Base e = ew.getBase();
        if (e instanceof StringType) {
            x.addText((String)((StringType)e).getValue());
        } else if (e instanceof CodeType) {
            x.addText((String)((CodeType)e).getValue());
        } else if (e instanceof IdType) {
            x.addText(((IdType)e).getValue());
        } else {
            if (e instanceof Extension) {
                return;
            }
            if (e instanceof InstantType) {
                x.addText(((InstantType)e).toHumanDisplay());
            } else if (e instanceof DateTimeType) {
                if (e.hasPrimitiveValue()) {
                    x.addText(((DateTimeType)e).toHumanDisplay());
                }
            } else if (e instanceof Base64BinaryType) {
                x.addText(new Base64().encodeAsString(((Base64BinaryType)e).getValue()));
            } else if (e instanceof DateType) {
                x.addText(((DateType)e).toHumanDisplay());
            } else if (e instanceof Enumeration) {
                Object ev = ((Enumeration)e).getValue();
                x.addText(ev == null ? "" : ev.toString());
            } else if (e instanceof BooleanType) {
                x.addText(((Boolean)((BooleanType)e).getValue()).toString());
            } else if (e instanceof CodeableConcept) {
                this.renderCodeableConcept((CodeableConcept)e, x, showCodeDetails);
            } else if (e instanceof Coding) {
                this.renderCoding((Coding)e, x, showCodeDetails);
            } else if (e instanceof Annotation) {
                this.renderAnnotation((Annotation)e, x);
            } else if (e instanceof Identifier) {
                this.renderIdentifier((Identifier)e, x);
            } else if (e instanceof IntegerType) {
                x.addText(Integer.toString((Integer)((IntegerType)e).getValue()));
            } else if (e instanceof DecimalType) {
                x.addText(((BigDecimal)((DecimalType)e).getValue()).toString());
            } else if (e instanceof HumanName) {
                this.renderHumanName((HumanName)e, x);
            } else if (e instanceof SampledData) {
                this.renderSampledData((SampledData)e, x);
            } else if (e instanceof Address) {
                this.renderAddress((Address)e, x);
            } else if (e instanceof ContactPoint) {
                this.renderContactPoint((ContactPoint)e, x);
            } else if (e instanceof UriType) {
                this.renderUri((UriType)e, x, defn.getPath(), rc != null && rc.resourceResource != null ? rc.resourceResource.getId() : null);
            } else if (e instanceof Timing) {
                this.renderTiming((Timing)e, x);
            } else if (e instanceof Range) {
                this.renderRange((Range)e, x);
            } else if (e instanceof Quantity) {
                this.renderQuantity((Quantity)e, x, showCodeDetails);
            } else if (e instanceof Ratio) {
                this.renderQuantity(((Ratio)e).getNumerator(), x, showCodeDetails);
                x.tx("/");
                this.renderQuantity(((Ratio)e).getDenominator(), x, showCodeDetails);
            } else if (e instanceof Period) {
                Period p = (Period)e;
                x.addText(!p.hasStart() ? "??" : p.getStartElement().toHumanDisplay());
                x.tx(" --> ");
                x.addText(!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
            } else if (e instanceof Reference) {
                Reference r = (Reference)e;
                XhtmlNode c = x;
                ResourceWithReference tr = null;
                if (r.hasReferenceElement()) {
                    tr = this.resolveReference(res, r.getReference(), rc);
                    if (!r.getReference().startsWith("#")) {
                        c = tr != null && tr.getReference() != null ? x.ah(tr.getReference()) : x.ah(r.getReference());
                    }
                }
                if (r.hasDisplayElement()) {
                    c.addText(r.getDisplay());
                    if (tr != null && tr.getResource() != null) {
                        c.tx(". Generated Summary: ");
                        this.generateResourceSummary(c, tr.getResource(), true, r.getReference().startsWith("#"), rc);
                    }
                } else if (tr != null && tr.getResource() != null) {
                    this.generateResourceSummary(c, tr.getResource(), r.getReference().startsWith("#"), r.getReference().startsWith("#"), rc);
                } else {
                    c.addText(r.getReference());
                }
            } else {
                if (e instanceof Resource) {
                    return;
                }
                if (e instanceof ElementDefinition) {
                    x.tx("todo-bundle");
                } else if (!(e == null || e instanceof Attachment || e instanceof Narrative || e instanceof Meta)) {
                    StructureDefinition sd = this.context.fetchTypeDefinition(e.fhirType());
                    if (sd == null) {
                        throw new NotImplementedException("type " + e.getClass().getName() + " not handled yet, and no structure found");
                    }
                    this.generateByProfile(res, sd, ew, sd.getSnapshot().getElement(), sd.getSnapshot().getElementFirstRep(), this.getChildrenForPath(sd.getSnapshot().getElement(), sd.getSnapshot().getElementFirstRep().getPath()), x, path, showCodeDetails, indent + 1, rc);
                }
            }
        }
    }

    private boolean displayLeaf(ResourceWrapper res, BaseWrapper ew, ElementDefinition defn, XhtmlNode x, String name, boolean showCodeDetails, ResourceContext rc) throws FHIRException, UnsupportedEncodingException, IOException {
        if (ew == null) {
            return false;
        }
        Base e = ew.getBase();
        if (e == null) {
            return false;
        }
        Map<String, String> displayHints = this.readDisplayHints(defn);
        if (name.endsWith("[x]")) {
            name = name.substring(0, name.length() - 3);
        }
        if (!showCodeDetails && e instanceof PrimitiveType && this.isDefault(displayHints, (PrimitiveType)e)) {
            return false;
        }
        if (e instanceof StringType) {
            x.addText(name + ": " + (String)((StringType)e).getValue());
            return true;
        }
        if (e instanceof CodeType) {
            x.addText(name + ": " + (String)((CodeType)e).getValue());
            return true;
        }
        if (e instanceof IdType) {
            x.addText(name + ": " + ((IdType)e).getValue());
            return true;
        }
        if (e instanceof UriType) {
            x.addText(name + ": " + (String)((UriType)e).getValue());
            return true;
        }
        if (e instanceof DateTimeType) {
            x.addText(name + ": " + ((DateTimeType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof InstantType) {
            x.addText(name + ": " + ((InstantType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof Extension) {
            return false;
        }
        if (e instanceof DateType) {
            x.addText(name + ": " + ((DateType)e).toHumanDisplay());
            return true;
        }
        if (e instanceof Enumeration) {
            x.addText(((Enum)((Enumeration)e).getValue()).toString());
            return true;
        }
        if (e instanceof BooleanType) {
            if (((Boolean)((BooleanType)e).getValue()).booleanValue()) {
                x.addText(name);
                return true;
            }
        } else {
            if (e instanceof CodeableConcept) {
                this.renderCodeableConcept((CodeableConcept)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof Coding) {
                this.renderCoding((Coding)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof Annotation) {
                this.renderAnnotation((Annotation)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof IntegerType) {
                x.addText(Integer.toString((Integer)((IntegerType)e).getValue()));
                return true;
            }
            if (e instanceof DecimalType) {
                x.addText(((BigDecimal)((DecimalType)e).getValue()).toString());
                return true;
            }
            if (e instanceof Identifier) {
                this.renderIdentifier((Identifier)e, x);
                return true;
            }
            if (e instanceof HumanName) {
                this.renderHumanName((HumanName)e, x);
                return true;
            }
            if (e instanceof SampledData) {
                this.renderSampledData((SampledData)e, x);
                return true;
            }
            if (e instanceof Address) {
                this.renderAddress((Address)e, x);
                return true;
            }
            if (e instanceof ContactPoint) {
                this.renderContactPoint((ContactPoint)e, x);
                return true;
            }
            if (e instanceof Timing) {
                this.renderTiming((Timing)e, x);
                return true;
            }
            if (e instanceof Quantity) {
                this.renderQuantity((Quantity)e, x, showCodeDetails);
                return true;
            }
            if (e instanceof Ratio) {
                this.renderQuantity(((Ratio)e).getNumerator(), x, showCodeDetails);
                x.tx("/");
                this.renderQuantity(((Ratio)e).getDenominator(), x, showCodeDetails);
                return true;
            }
            if (e instanceof Period) {
                Period p = (Period)e;
                x.addText(name + ": ");
                x.addText(!p.hasStart() ? "??" : p.getStartElement().toHumanDisplay());
                x.tx(" --> ");
                x.addText(!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
                return true;
            }
            if (e instanceof Reference) {
                Reference r = (Reference)e;
                if (r.hasDisplayElement()) {
                    x.addText(r.getDisplay());
                } else if (r.hasReferenceElement()) {
                    ResourceWithReference tr = this.resolveReference(res, r.getReference(), rc);
                    x.addText(tr == null ? r.getReference() : "????");
                } else {
                    x.tx("??");
                }
                return true;
            }
            if (e instanceof Narrative) {
                return false;
            }
            if (e instanceof Resource) {
                return false;
            }
            if (e instanceof ContactDetail) {
                return false;
            }
            if (e instanceof Range) {
                return false;
            }
            if (e instanceof Meta) {
                return false;
            }
            if (e instanceof Dosage) {
                return false;
            }
            if (e instanceof Signature) {
                return false;
            }
            if (e instanceof UsageContext) {
                return false;
            }
            if (e instanceof RelatedArtifact) {
                return false;
            }
            if (e instanceof ElementDefinition) {
                return false;
            }
            if (!(e instanceof Attachment)) {
                throw new NotImplementedException("type " + e.getClass().getName() + " not handled yet");
            }
        }
        return false;
    }

    private Map<String, String> readDisplayHints(ElementDefinition defn) throws DefinitionException {
        String displayHint;
        HashMap<String, String> hints = new HashMap<String, String>();
        if (defn != null && !Utilities.noString((String)(displayHint = ToolingExtensions.getDisplayHint(defn)))) {
            String[] list;
            for (String item : list = displayHint.split(";")) {
                String[] parts = item.split(":");
                if (parts.length != 2) {
                    throw new DefinitionException("error reading display hint: '" + displayHint + "'");
                }
                hints.put(parts[0].trim(), parts[1].trim());
            }
        }
        return hints;
    }

    public static String displayPeriod(Period p) {
        Object s = !p.hasStart() ? "??" : p.getStartElement().toHumanDisplay();
        s = (String)s + " --> ";
        return (String)s + (!p.hasEnd() ? "(ongoing)" : p.getEndElement().toHumanDisplay());
    }

    private void generateResourceSummary(XhtmlNode x, ResourceWrapper res, boolean textAlready, boolean showCodeDetails, ResourceContext rc) throws FHIRException, UnsupportedEncodingException, IOException {
        String path;
        StructureDefinition profile;
        if (!textAlready) {
            XhtmlNode div = res.getNarrative();
            if (div != null) {
                if (div.allChildrenAreText()) {
                    x.getChildNodes().addAll((Collection)div.getChildNodes());
                }
                if (div.getChildNodes().size() == 1 && div.getChildNodes().get(0).allChildrenAreText()) {
                    x.getChildNodes().addAll((Collection)div.getChildNodes().get(0).getChildNodes());
                }
            }
            x.tx("Generated Summary: ");
        }
        if ((profile = this.context.fetchResource(StructureDefinition.class, path = res.getName())) == null) {
            x.tx("unknown resource " + path);
        } else {
            boolean firstElement = true;
            boolean last = false;
            for (PropertyWrapper p : res.children()) {
                ElementDefinition child = this.getElementDefinition(profile.getSnapshot().getElement(), path + "." + p.getName(), p);
                if (p.getValues().size() <= 0 || p.getValues().get(0) == null || child == null || !this.isPrimitive(child) || !this.includeInSummary(child)) continue;
                if (firstElement) {
                    firstElement = false;
                } else if (last) {
                    x.tx("; ");
                }
                boolean first = true;
                last = false;
                for (BaseWrapper v : p.getValues()) {
                    if (first) {
                        first = false;
                    } else if (last) {
                        x.tx(", ");
                    }
                    last = this.displayLeaf(res, v, child, x, p.getName(), showCodeDetails, rc) || last;
                }
            }
        }
    }

    private boolean includeInSummary(ElementDefinition child) {
        String t;
        if (child.getIsModifier()) {
            return true;
        }
        if (child.getMustSupport()) {
            return true;
        }
        return child.getType().size() != 1 || !(t = child.getType().get(0).getWorkingCode()).equals("Address") && !t.equals("Contact") && !t.equals("Reference") && !t.equals("Uri") && !t.equals("Url") && !t.equals("Canonical");
    }

    private ResourceWithReference resolveReference(ResourceWrapper res, String url, ResourceContext rc) {
        Resource bundleResource;
        if (url == null) {
            return null;
        }
        if (url.startsWith("#")) {
            for (ResourceWrapper r : res.getContained()) {
                if (!r.getId().equals(url.substring(1))) continue;
                return new ResourceWithReference(null, r);
            }
            return null;
        }
        if (rc != null && (bundleResource = rc.resolve(url)) != null) {
            String bundleUrl = "#" + bundleResource.getResourceType().name().toLowerCase() + "_" + bundleResource.getId();
            return new ResourceWithReference(bundleUrl, new ResourceWrapperDirect(bundleResource));
        }
        Object ae = this.context.fetchResource(null, url);
        if (ae != null) {
            return new ResourceWithReference(url, new ResourceWrapperDirect((Resource)ae));
        }
        if (this.resolver != null) {
            return this.resolver.resolve(url);
        }
        return null;
    }

    private void renderCodeableConcept(CodeableConcept cc, XhtmlNode x, boolean showCodeDetails) {
        String s = cc.getText();
        if (Utilities.noString((String)s)) {
            for (Coding c : cc.getCoding()) {
                if (!c.hasDisplayElement()) continue;
                s = c.getDisplay();
                break;
            }
        }
        if (Utilities.noString((String)s)) {
            for (Coding c : cc.getCoding()) {
                if (c.hasCodeElement() && c.hasSystemElement() && !Utilities.noString((String)(s = this.lookupCode(c.getSystem(), c.getCode())))) break;
            }
        }
        if (Utilities.noString((String)s)) {
            s = cc.getCoding().isEmpty() ? "" : cc.getCoding().get(0).getCode();
        }
        if (showCodeDetails) {
            x.addText(s + " ");
            XhtmlNode sp = x.span("background: LightGoldenRodYellow", null);
            sp.tx("(Details ");
            boolean first = true;
            for (Coding c : cc.getCoding()) {
                if (first) {
                    sp.tx(": ");
                    first = false;
                } else {
                    sp.tx("; ");
                }
                sp.tx("{" + NarrativeGenerator.describeSystem(c.getSystem()) + " code '" + c.getCode() + "' = '" + this.lookupCode(c.getSystem(), c.getCode()) + (String)(c.hasDisplay() ? "', given as '" + c.getDisplay() + "'}" : ""));
            }
            sp.tx(")");
        } else {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (Coding c : cc.getCoding()) {
                if (!c.hasCodeElement() || !c.hasSystemElement()) continue;
                b.append("{" + c.getSystem() + " " + c.getCode() + "}");
            }
            x.span(null, "Codes: " + b.toString()).addText(s);
        }
    }

    private void renderAnnotation(Annotation a, XhtmlNode x, boolean showCodeDetails) throws FHIRException {
        StringBuilder s = new StringBuilder();
        if (a.hasAuthor()) {
            s.append("Author: ");
            if (a.hasAuthorReference()) {
                s.append(a.getAuthorReference().getReference());
            } else if (a.hasAuthorStringType()) {
                s.append((String)a.getAuthorStringType().getValue());
            }
        }
        if (a.hasTimeElement()) {
            if (s.length() > 0) {
                s.append("; ");
            }
            s.append("Made: ").append(a.getTimeElement().toHumanDisplay());
        }
        if (a.hasText()) {
            if (s.length() > 0) {
                s.append("; ");
            }
            s.append("Annotation: ").append(a.getText());
        }
        x.addText(s.toString());
    }

    private void renderCoding(Coding c, XhtmlNode x, boolean showCodeDetails) {
        String s = "";
        if (c.hasDisplayElement()) {
            s = c.getDisplay();
        }
        if (Utilities.noString((String)s)) {
            s = this.lookupCode(c.getSystem(), c.getCode());
        }
        if (Utilities.noString((String)s)) {
            s = c.getCode();
        }
        if (showCodeDetails) {
            x.addText(s + " (Details: " + NarrativeGenerator.describeSystem(c.getSystem()) + " code " + c.getCode() + " = '" + this.lookupCode(c.getSystem(), c.getCode()) + "', stated as '" + c.getDisplay() + "')");
        } else {
            x.span(null, "{" + c.getSystem() + " " + c.getCode() + "}").addText(s);
        }
    }

    public static String describeSystem(String system) {
        if (system == null) {
            return "[not stated]";
        }
        if (system.equals("http://loinc.org")) {
            return "LOINC";
        }
        if (system.startsWith("http://snomed.info")) {
            return "SNOMED CT";
        }
        if (system.equals("http://www.nlm.nih.gov/research/umls/rxnorm")) {
            return "RxNorm";
        }
        if (system.equals("http://hl7.org/fhir/sid/icd-9")) {
            return "ICD-9";
        }
        if (system.equals("http://dicom.nema.org/resources/ontology/DCM")) {
            return "DICOM";
        }
        if (system.equals("http://unitsofmeasure.org")) {
            return "UCUM";
        }
        return system;
    }

    private String lookupCode(String system, String code) {
        IWorkerContext.ValidationResult t = this.context.validateCode((ValidationOptions)this.terminologyServiceOptions, system, code, null);
        if (t != null && t.getDisplay() != null) {
            return t.getDisplay();
        }
        return code;
    }

    private CodeSystem.ConceptDefinitionComponent findCode(String code, List<CodeSystem.ConceptDefinitionComponent> list) {
        for (CodeSystem.ConceptDefinitionComponent t : list) {
            if (code.equals(t.getCode())) {
                return t;
            }
            CodeSystem.ConceptDefinitionComponent c = this.findCode(code, t.getConcept());
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public String displayCodeableConcept(CodeableConcept cc) {
        String s = cc.getText();
        if (Utilities.noString((String)s)) {
            for (Coding c : cc.getCoding()) {
                if (!c.hasDisplayElement()) continue;
                s = c.getDisplay();
                break;
            }
        }
        if (Utilities.noString((String)s)) {
            for (Coding c : cc.getCoding()) {
                if (c.hasCode() && c.hasSystem() && !Utilities.noString((String)(s = this.lookupCode(c.getSystem(), c.getCode())))) break;
            }
        }
        if (Utilities.noString((String)s)) {
            s = cc.getCoding().isEmpty() ? "" : cc.getCoding().get(0).getCode();
        }
        return s;
    }

    private void renderIdentifier(Identifier ii, XhtmlNode x) {
        x.addText(this.displayIdentifier(ii));
    }

    private void renderTiming(Timing s, XhtmlNode x) throws FHIRException {
        x.addText(this.displayTiming(s));
    }

    private void renderQuantity(Quantity q, XhtmlNode x, boolean showCodeDetails) {
        if (q.hasComparator()) {
            x.addText(q.getComparator().toCode());
        }
        x.addText(q.getValue().toString());
        if (q.hasUnit()) {
            x.tx(" " + q.getUnit());
        } else if (q.hasCode()) {
            x.tx(" " + q.getCode());
        }
        if (showCodeDetails && q.hasCode()) {
            x.span("background: LightGoldenRodYellow", null).tx(" (Details: " + NarrativeGenerator.describeSystem(q.getSystem()) + " code " + q.getCode() + " = '" + this.lookupCode(q.getSystem(), q.getCode()) + "')");
        }
    }

    private void renderRange(Range q, XhtmlNode x) {
        if (q.hasLow()) {
            x.addText(q.getLow().getValue().toString());
        } else {
            x.tx("?");
        }
        x.tx("-");
        if (q.hasHigh()) {
            x.addText(q.getHigh().getValue().toString());
        } else {
            x.tx("?");
        }
        if (q.getLow().hasUnit()) {
            x.tx(" " + q.getLow().getUnit());
        }
    }

    public String displayRange(Range q) {
        StringBuilder b = new StringBuilder();
        if (q.hasLow()) {
            b.append(q.getLow().getValue().toString());
        } else {
            b.append("?");
        }
        b.append("-");
        if (q.hasHigh()) {
            b.append(q.getHigh().getValue().toString());
        } else {
            b.append("?");
        }
        if (q.getLow().hasUnit()) {
            b.append(" " + q.getLow().getUnit());
        }
        return b.toString();
    }

    private void renderHumanName(HumanName name, XhtmlNode x) {
        x.addText(NarrativeGenerator.displayHumanName(name));
    }

    private void renderAnnotation(Annotation annot, XhtmlNode x) {
        x.addText(annot.getText());
    }

    private void renderAddress(Address address, XhtmlNode x) {
        x.addText(this.displayAddress(address));
    }

    private void renderContactPoint(ContactPoint contact, XhtmlNode x) {
        x.addText(NarrativeGenerator.displayContactPoint(contact));
    }

    private void renderUri(UriType uri, XhtmlNode x, String path, String id) {
        String url = (String)uri.getValue();
        if (this.isCanonical(path)) {
            MetadataResource mr = (MetadataResource)this.context.fetchResource(null, url);
            if (mr != null) {
                if (path.startsWith(mr.fhirType() + ".") && mr.getId().equals(id)) {
                    url = null;
                } else if (mr.hasUserData("path")) {
                    url = mr.getUserString("path");
                }
            } else if (!this.canonicalUrlsAsLinks) {
                url = null;
            }
        }
        if (url == null) {
            x.b().tx((String)uri.getValue());
        } else if (((String)uri.getValue()).startsWith("mailto:")) {
            x.ah((String)uri.getValue()).addText(((String)uri.getValue()).substring(7));
        } else {
            x.ah((String)uri.getValue()).addText((String)uri.getValue());
        }
    }

    private boolean isCanonical(String path) {
        if (!path.endsWith(".url")) {
            return false;
        }
        StructureDefinition sd = this.context.fetchTypeDefinition(path.substring(0, path.length() - 4));
        if (sd == null) {
            return false;
        }
        if (Utilities.existsInList((String)path.substring(0, path.length() - 4), (String[])new String[]{"CapabilityStatement", "StructureDefinition", "ImplementationGuide", "SearchParameter", "MessageDefinition", "OperationDefinition", "CompartmentDefinition", "StructureMap", "GraphDefinition", "ExampleScenario", "CodeSystem", "ValueSet", "ConceptMap", "NamingSystem", "TerminologyCapabilities"})) {
            return true;
        }
        return sd.getBaseDefinitionElement().hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-codegen-super");
    }

    private void renderSampledData(SampledData sampledData, XhtmlNode x) {
        x.addText(this.displaySampledData(sampledData));
    }

    private String displaySampledData(SampledData s) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (s.hasOrigin()) {
            b.append("Origin: " + this.displayQuantity(s.getOrigin()));
        }
        if (s.hasPeriod()) {
            b.append("Period: " + s.getPeriod().toString());
        }
        if (s.hasFactor()) {
            b.append("Factor: " + s.getFactor().toString());
        }
        if (s.hasLowerLimit()) {
            b.append("Lower: " + s.getLowerLimit().toString());
        }
        if (s.hasUpperLimit()) {
            b.append("Upper: " + s.getUpperLimit().toString());
        }
        if (s.hasDimensions()) {
            b.append("Dimensions: " + s.getDimensions());
        }
        if (s.hasData()) {
            b.append("Data: " + s.getData());
        }
        return b.toString();
    }

    private String displayQuantity(Quantity q) {
        StringBuilder s = new StringBuilder();
        s.append("(system = '").append(NarrativeGenerator.describeSystem(q.getSystem())).append("' code ").append(q.getCode()).append(" = '").append(this.lookupCode(q.getSystem(), q.getCode())).append("')");
        return s.toString();
    }

    private String displayTiming(Timing s) throws FHIRException {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (s.hasCode()) {
            b.append("Code: " + this.displayCodeableConcept(s.getCode()));
        }
        if (s.getEvent().size() > 0) {
            CommaSeparatedStringBuilder c = new CommaSeparatedStringBuilder();
            for (DateTimeType p : s.getEvent()) {
                c.append(p.toHumanDisplay());
            }
            b.append("Events: " + c.toString());
        }
        if (s.hasRepeat()) {
            Object st;
            Timing.TimingRepeatComponent rep = s.getRepeat();
            if (rep.hasBoundsPeriod() && rep.getBoundsPeriod().hasStart()) {
                b.append("Starting " + rep.getBoundsPeriod().getStartElement().toHumanDisplay());
            }
            if (rep.hasCount()) {
                b.append("Count " + Integer.toString(rep.getCount()) + " times");
            }
            if (rep.hasDuration()) {
                b.append("Duration " + rep.getDuration().toPlainString() + this.displayTimeUnits(rep.getPeriodUnit()));
            }
            if (rep.hasWhen()) {
                st = "";
                if (rep.hasOffset()) {
                    st = Integer.toString(rep.getOffset()) + "min ";
                }
                b.append("Do " + (String)st);
                for (Enumeration<Timing.EventTiming> wh : rep.getWhen()) {
                    b.append(this.displayEventCode((Timing.EventTiming)((Object)wh.getValue())));
                }
            } else {
                st = "";
                if (!rep.hasFrequency() || !rep.hasFrequencyMax() && rep.getFrequency() == 1) {
                    st = "Once";
                } else {
                    st = Integer.toString(rep.getFrequency());
                    if (rep.hasFrequencyMax()) {
                        st = (String)st + "-" + Integer.toString(rep.getFrequency());
                    }
                }
                if (rep.hasPeriod()) {
                    st = (String)st + " per " + rep.getPeriod().toPlainString();
                    if (rep.hasPeriodMax()) {
                        st = (String)st + "-" + rep.getPeriodMax().toPlainString();
                    }
                    st = (String)st + " " + this.displayTimeUnits(rep.getPeriodUnit());
                }
                b.append("Do " + (String)st);
            }
            if (rep.hasBoundsPeriod() && rep.getBoundsPeriod().hasEnd()) {
                b.append("Until " + rep.getBoundsPeriod().getEndElement().toHumanDisplay());
            }
        }
        return b.toString();
    }

    private String displayEventCode(Timing.EventTiming when) {
        switch (when) {
            case C: {
                return "at meals";
            }
            case CD: {
                return "at lunch";
            }
            case CM: {
                return "at breakfast";
            }
            case CV: {
                return "at dinner";
            }
            case AC: {
                return "before meals";
            }
            case ACD: {
                return "before lunch";
            }
            case ACM: {
                return "before breakfast";
            }
            case ACV: {
                return "before dinner";
            }
            case HS: {
                return "before sleeping";
            }
            case PC: {
                return "after meals";
            }
            case PCD: {
                return "after lunch";
            }
            case PCM: {
                return "after breakfast";
            }
            case PCV: {
                return "after dinner";
            }
            case WAKE: {
                return "after waking";
            }
        }
        return "??";
    }

    private String displayTimeUnits(Timing.UnitsOfTime units) {
        if (units == null) {
            return "??";
        }
        switch (units) {
            case A: {
                return "years";
            }
            case D: {
                return "days";
            }
            case H: {
                return "hours";
            }
            case MIN: {
                return "minutes";
            }
            case MO: {
                return "months";
            }
            case S: {
                return "seconds";
            }
            case WK: {
                return "weeks";
            }
        }
        return "??";
    }

    public static String displayHumanName(HumanName name) {
        StringBuilder s = new StringBuilder();
        if (name.hasText()) {
            s.append(name.getText());
        } else {
            for (StringType p : name.getGiven()) {
                s.append((String)p.getValue());
                s.append(" ");
            }
            if (name.hasFamily()) {
                s.append(name.getFamily());
                s.append(" ");
            }
        }
        if (name.hasUse() && name.getUse() != HumanName.NameUse.USUAL) {
            s.append("(" + name.getUse().toString() + ")");
        }
        return s.toString();
    }

    private String displayAddress(Address address) {
        StringBuilder s = new StringBuilder();
        if (address.hasText()) {
            s.append(address.getText());
        } else {
            for (StringType p : address.getLine()) {
                s.append((String)p.getValue());
                s.append(" ");
            }
            if (address.hasCity()) {
                s.append(address.getCity());
                s.append(" ");
            }
            if (address.hasState()) {
                s.append(address.getState());
                s.append(" ");
            }
            if (address.hasPostalCode()) {
                s.append(address.getPostalCode());
                s.append(" ");
            }
            if (address.hasCountry()) {
                s.append(address.getCountry());
                s.append(" ");
            }
        }
        if (address.hasUse()) {
            s.append("(" + address.getUse().toString() + ")");
        }
        return s.toString();
    }

    public static String displayContactPoint(ContactPoint contact) {
        StringBuilder s = new StringBuilder();
        s.append(NarrativeGenerator.describeSystem(contact.getSystem()));
        if (Utilities.noString((String)contact.getValue())) {
            s.append("-unknown-");
        } else {
            s.append(contact.getValue());
        }
        if (contact.hasUse()) {
            s.append("(" + contact.getUse().toString() + ")");
        }
        return s.toString();
    }

    private static String describeSystem(ContactPoint.ContactPointSystem system) {
        if (system == null) {
            return "";
        }
        switch (system) {
            case PHONE: {
                return "ph: ";
            }
            case FAX: {
                return "fax: ";
            }
        }
        return "";
    }

    private String displayIdentifier(Identifier ii) {
        Object s;
        Object object = s = Utilities.noString((String)ii.getValue()) ? "??" : ii.getValue();
        if (ii.hasType()) {
            if (ii.getType().hasText()) {
                s = ii.getType().getText() + " = " + (String)s;
            } else if (ii.getType().hasCoding() && ii.getType().getCoding().get(0).hasDisplay()) {
                s = ii.getType().getCoding().get(0).getDisplay() + " = " + (String)s;
            } else if (ii.getType().hasCoding() && ii.getType().getCoding().get(0).hasCode()) {
                s = this.lookupCode(ii.getType().getCoding().get(0).getSystem(), ii.getType().getCoding().get(0).getCode()) + " = " + (String)s;
            }
        }
        if (ii.hasUse()) {
            s = (String)s + " (" + ii.getUse().toString() + ")";
        }
        return s;
    }

    private List<ElementDefinition> getChildrenForPath(List<ElementDefinition> elements, String path) throws DefinitionException {
        for (ElementDefinition e : elements) {
            if (!e.getPath().equals(path) || !e.hasContentReference()) continue;
            String ref = e.getContentReference();
            ElementDefinition t = null;
            for (ElementDefinition e1 : elements) {
                if (!ref.equals("#" + e1.getId())) continue;
                t = e1;
            }
            if (t == null) {
                throw new DefinitionException("Unable to resolve content reference " + ref + " trying to resolve " + path);
            }
            path = t.getPath();
            break;
        }
        ArrayList<ElementDefinition> results = new ArrayList<ElementDefinition>();
        for (ElementDefinition e : elements) {
            if (!e.getPath().startsWith(path + ".") || e.getPath().substring(path.length() + 1).contains(".")) continue;
            results.add(e);
        }
        return results;
    }

    public boolean generate(ResourceContext rcontext, ConceptMap cm) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.h2().addText(cm.getName() + " (" + cm.getUrl() + ")");
        XhtmlNode p = x.para();
        p.tx("Mapping from ");
        if (cm.hasSource()) {
            this.AddVsRef(rcontext, cm.getSource().primitiveValue(), p);
        } else {
            p.tx("(not specified)");
        }
        p.tx(" to ");
        if (cm.hasTarget()) {
            this.AddVsRef(rcontext, cm.getTarget().primitiveValue(), p);
        } else {
            p.tx("(not specified)");
        }
        p = x.para();
        if (cm.getExperimental()) {
            p.addText(Utilities.capitalize((String)cm.getStatus().toString()) + " (not intended for production usage). ");
        } else {
            p.addText(Utilities.capitalize((String)cm.getStatus().toString()) + ". ");
        }
        p.tx("Published on " + (cm.hasDate() ? cm.getDateElement().toHumanDisplay() : "??") + " by " + cm.getPublisher());
        if (!cm.getContact().isEmpty()) {
            p.tx(" (");
            boolean firsti = true;
            for (ContactDetail ci : cm.getContact()) {
                if (firsti) {
                    firsti = false;
                } else {
                    p.tx(", ");
                }
                if (ci.hasName()) {
                    p.addText(ci.getName() + ": ");
                }
                boolean first = true;
                for (ContactPoint c : ci.getTelecom()) {
                    if (first) {
                        first = false;
                    } else {
                        p.tx(", ");
                    }
                    this.addTelecom(p, c);
                }
            }
            p.tx(")");
        }
        p.tx(". ");
        p.addText(cm.getCopyright());
        if (!Utilities.noString((String)cm.getDescription())) {
            this.addMarkdown(x, cm.getDescription());
        }
        x.br();
        CodeSystem cs = this.context.fetchCodeSystem("http://hl7.org/fhir/concept-map-equivalence");
        String eqpath = cs.getUserString("path");
        for (ConceptMap.ConceptMapGroupComponent grp : cm.getGroup()) {
            String url;
            String display;
            XhtmlNode tr;
            XhtmlNode tbl;
            String src = grp.getSource();
            boolean comment = false;
            boolean ok = true;
            HashMap sources = new HashMap();
            HashMap targets = new HashMap();
            sources.put("code", new HashSet());
            targets.put("code", new HashSet());
            ConceptMap.SourceElementComponent cc = grp.getElement().get(0);
            String dst = grp.getTarget();
            ((HashSet)sources.get("code")).add(grp.getSource());
            ((HashSet)targets.get("code")).add(grp.getTarget());
            for (ConceptMap.SourceElementComponent ccl : grp.getElement()) {
                ok = ok && ccl.getTarget().size() == 1 && ccl.getTarget().get(0).getDependsOn().isEmpty() && ccl.getTarget().get(0).getProduct().isEmpty();
                for (ConceptMap.TargetElementComponent targetElementComponent : ccl.getTarget()) {
                    comment = comment || !Utilities.noString((String)targetElementComponent.getComment());
                    for (ConceptMap.OtherElementComponent d : targetElementComponent.getDependsOn()) {
                        if (!sources.containsKey(d.getProperty())) {
                            sources.put(d.getProperty(), new HashSet());
                        }
                        ((HashSet)sources.get(d.getProperty())).add(d.getSystem());
                    }
                    for (ConceptMap.OtherElementComponent d : targetElementComponent.getProduct()) {
                        if (!targets.containsKey(d.getProperty())) {
                            targets.put(d.getProperty(), new HashSet());
                        }
                        ((HashSet)targets.get(d.getProperty())).add(d.getSystem());
                    }
                }
            }
            if (ok) {
                tbl = x.table("grid");
                tr = tbl.tr();
                tr.td().b().tx("Source Code");
                tr.td().b().tx("Equivalence");
                tr.td().b().tx("Destination Code");
                if (comment) {
                    tr.td().b().tx("Comment");
                }
                for (ConceptMap.SourceElementComponent ccl : grp.getElement()) {
                    tr = tbl.tr();
                    XhtmlNode td = tr.td();
                    td.addText(ccl.getCode());
                    display = this.getDisplayForConcept(grp.getSource(), ccl.getCode());
                    if (display != null && !this.isSameCodeAndDisplay(ccl.getCode(), display)) {
                        td.tx(" (" + display + ")");
                    }
                    ConceptMap.TargetElementComponent ccm2 = ccl.getTarget().get(0);
                    tr.td().addText(!ccm2.hasEquivalence() ? "" : ccm2.getEquivalence().toCode());
                    td = tr.td();
                    td.addText(ccm2.getCode());
                    display = this.getDisplayForConcept(grp.getTarget(), ccm2.getCode());
                    if (display != null && !this.isSameCodeAndDisplay(ccm2.getCode(), display)) {
                        td.tx(" (" + display + ")");
                    }
                    if (!comment) continue;
                    tr.td().addText(ccm2.getComment());
                }
                continue;
            }
            tbl = x.table("grid");
            tr = tbl.tr();
            tr.td().colspan(Integer.toString(sources.size())).b().tx("Source Concept Details");
            tr.td().b().tx("Equivalence");
            tr.td().colspan(Integer.toString(targets.size())).b().tx("Destination Concept Details");
            if (comment) {
                tr.td().b().tx("Comment");
            }
            tr = tbl.tr();
            if (((HashSet)sources.get("code")).size() == 1) {
                String url2 = (String)((HashSet)sources.get("code")).iterator().next();
                this.renderCSDetailsLink(tr, url2);
            } else {
                tr.td().b().tx("Code");
            }
            for (String s : sources.keySet()) {
                if (s.equals("code")) continue;
                if (((HashSet)sources.get(s)).size() == 1) {
                    url = (String)((HashSet)sources.get(s)).iterator().next();
                    this.renderCSDetailsLink(tr, url);
                    continue;
                }
                tr.td().b().addText(this.getDescForConcept(s));
            }
            tr.td();
            if (((HashSet)targets.get("code")).size() == 1) {
                String url2 = (String)((HashSet)targets.get("code")).iterator().next();
                this.renderCSDetailsLink(tr, url2);
            } else {
                tr.td().b().tx("Code");
            }
            for (String s : targets.keySet()) {
                if (s.equals("code")) continue;
                if (((HashSet)targets.get(s)).size() == 1) {
                    url = (String)((HashSet)targets.get(s)).iterator().next();
                    this.renderCSDetailsLink(tr, url);
                    continue;
                }
                tr.td().b().addText(this.getDescForConcept(s));
            }
            if (comment) {
                tr.td();
            }
            for (int si = 0; si < grp.getElement().size(); ++si) {
                ConceptMap.SourceElementComponent ccl = grp.getElement().get(si);
                boolean slast = si == grp.getElement().size() - 1;
                boolean first = true;
                for (int ti = 0; ti < ccl.getTarget().size(); ++ti) {
                    ConceptMap.TargetElementComponent ccm = ccl.getTarget().get(ti);
                    boolean last = ti == ccl.getTarget().size() - 1;
                    tr = tbl.tr();
                    XhtmlNode xhtmlNode = tr.td();
                    if (!first && !last) {
                        xhtmlNode.setAttribute("style", "border-top-style: none; border-bottom-style: none");
                    } else if (!first) {
                        xhtmlNode.setAttribute("style", "border-top-style: none");
                    } else if (!last) {
                        xhtmlNode.setAttribute("style", "border-bottom-style: none");
                    }
                    if (first) {
                        if (((HashSet)sources.get("code")).size() == 1) {
                            xhtmlNode.addText(ccl.getCode());
                        } else {
                            xhtmlNode.addText(grp.getSource() + " / " + ccl.getCode());
                        }
                        display = this.getDisplayForConcept(grp.getSource(), ccl.getCode());
                        if (display != null) {
                            xhtmlNode.tx(" (" + display + ")");
                        }
                    }
                    for (String s : sources.keySet()) {
                        if (s.equals("code")) continue;
                        XhtmlNode xhtmlNode2 = tr.td();
                        if (!first) continue;
                        xhtmlNode2.addText(this.getValue(ccm.getDependsOn(), s, ((HashSet)sources.get(s)).size() != 1));
                        display = this.getDisplay(ccm.getDependsOn(), s);
                        if (display == null) continue;
                        xhtmlNode2.tx(" (" + display + ")");
                    }
                    first = false;
                    if (!ccm.hasEquivalence()) {
                        tr.td().tx(":(" + Enumerations.ConceptMapEquivalence.EQUIVALENT.toCode() + ")");
                    } else {
                        tr.td().ah(eqpath + "#" + ccm.getEquivalence().toCode()).tx(ccm.getEquivalence().toCode());
                    }
                    XhtmlNode xhtmlNode3 = tr.td();
                    if (((HashSet)targets.get("code")).size() == 1) {
                        xhtmlNode3.addText(ccm.getCode());
                    } else {
                        xhtmlNode3.addText(grp.getTarget() + " / " + ccm.getCode());
                    }
                    display = this.getDisplayForConcept(grp.getTarget(), ccm.getCode());
                    if (display != null) {
                        xhtmlNode3.tx(" (" + display + ")");
                    }
                    for (String s : targets.keySet()) {
                        if (s.equals("code")) continue;
                        XhtmlNode xhtmlNode4 = tr.td();
                        xhtmlNode4.addText(this.getValue(ccm.getProduct(), s, ((HashSet)targets.get(s)).size() != 1));
                        display = this.getDisplay(ccm.getProduct(), s);
                        if (display == null) continue;
                        xhtmlNode4.tx(" (" + display + ")");
                    }
                    if (!comment) continue;
                    tr.td().addText(ccm.getComment());
                }
            }
        }
        this.inject(cm, x, Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    public void renderCSDetailsLink(XhtmlNode tr, String url) {
        CodeSystem cs = this.context.fetchCodeSystem(url);
        XhtmlNode td = tr.td();
        td.b().tx("Code");
        td.tx(" from ");
        if (cs == null) {
            td.tx(url);
        } else {
            td.ah(cs.getUserString("path")).attribute("title", url).tx(cs.present());
        }
    }

    private boolean isSameCodeAndDisplay(String code, String display) {
        String c = code.replace(" ", "").replace("-", "").toLowerCase();
        String d = display.replace(" ", "").replace("-", "").toLowerCase();
        return c.equals(d);
    }

    private void inject(DomainResource r, XhtmlNode x, Narrative.NarrativeStatus status) {
        if (!x.hasAttribute("xmlns")) {
            x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        }
        if (!r.hasText() || !r.getText().hasDiv() || r.getText().getDiv().getChildNodes().isEmpty()) {
            r.setText(new Narrative());
            r.getText().setDiv(x);
            r.getText().setStatus(status);
        } else {
            XhtmlNode n = r.getText().getDiv();
            n.hr();
            n.getChildNodes().addAll((Collection)x.getChildNodes());
        }
    }

    public Element getNarrative(Element er) {
        Element txt = XMLUtil.getNamedChild((Element)er, (String)"text");
        if (txt == null) {
            return null;
        }
        return XMLUtil.getNamedChild((Element)txt, (String)"div");
    }

    private void inject(Element er, XhtmlNode x, Narrative.NarrativeStatus status) {
        Element st;
        Element txt;
        if (!x.hasAttribute("xmlns")) {
            x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        }
        if ((txt = XMLUtil.getNamedChild((Element)er, (String)"text")) == null) {
            txt = er.getOwnerDocument().createElementNS("http://hl7.org/fhir", "text");
            Element n = XMLUtil.getFirstChild((Element)er);
            while (n != null && (n.getNodeName().equals("id") || n.getNodeName().equals("meta") || n.getNodeName().equals("implicitRules") || n.getNodeName().equals("language"))) {
                n = XMLUtil.getNextSibling((Element)n);
            }
            if (n == null) {
                er.appendChild(txt);
            } else {
                er.insertBefore(txt, n);
            }
        }
        if ((st = XMLUtil.getNamedChild((Element)txt, (String)"status")) == null) {
            st = er.getOwnerDocument().createElementNS("http://hl7.org/fhir", "status");
            Element n = XMLUtil.getFirstChild((Element)txt);
            if (n == null) {
                txt.appendChild(st);
            } else {
                txt.insertBefore(st, n);
            }
        }
        st.setAttribute("value", status.toCode());
        Element div = XMLUtil.getNamedChild((Element)txt, (String)"div");
        if (div == null) {
            div = er.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "div");
            div.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
            txt.appendChild(div);
        }
        if (div.hasChildNodes()) {
            div.appendChild(er.getOwnerDocument().createElementNS("http://www.w3.org/1999/xhtml", "hr"));
        }
        new XhtmlComposer(true, this.pretty).compose(div, x);
    }

    private void inject(org.hl7.fhir.r4.elementmodel.Element er, XhtmlNode x, Narrative.NarrativeStatus status) throws IOException, FHIRException {
        org.hl7.fhir.r4.elementmodel.Element st;
        org.hl7.fhir.r4.elementmodel.Element txt;
        if (!x.hasAttribute("xmlns")) {
            x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        }
        if ((txt = er.getNamedChild("text")) == null) {
            int i;
            txt = new org.hl7.fhir.r4.elementmodel.Element("text", er.getProperty().getChild(null, "text"));
            for (i = 0; i < er.getChildren().size() && (er.getChildren().get(i).getName().equals("id") || er.getChildren().get(i).getName().equals("meta") || er.getChildren().get(i).getName().equals("implicitRules") || er.getChildren().get(i).getName().equals("language")); ++i) {
            }
            if (i >= er.getChildren().size()) {
                er.getChildren().add(txt);
            } else {
                er.getChildren().add(i, txt);
            }
        }
        if ((st = txt.getNamedChild("status")) == null) {
            st = new org.hl7.fhir.r4.elementmodel.Element("status", txt.getProperty().getChild(null, "status"));
            txt.getChildren().add(0, st);
        }
        st.setValue(status.toCode());
        org.hl7.fhir.r4.elementmodel.Element div = txt.getNamedChild("div");
        if (div == null) {
            div = new org.hl7.fhir.r4.elementmodel.Element("div", txt.getProperty().getChild(null, "div"));
            txt.getChildren().add(div);
            div.setValue(new XhtmlComposer(true, this.pretty).compose(x));
        }
        div.setXhtml(x);
    }

    private String getDisplay(List<ConceptMap.OtherElementComponent> list, String s) {
        for (ConceptMap.OtherElementComponent c : list) {
            if (!s.equals(c.getProperty())) continue;
            return this.getDisplayForConcept(c.getSystem(), c.getValue());
        }
        return null;
    }

    private String getDisplayForConcept(String system, String value) {
        if (value == null || system == null) {
            return null;
        }
        IWorkerContext.ValidationResult cl = this.context.validateCode((ValidationOptions)this.terminologyServiceOptions, system, value, null);
        return cl == null ? null : cl.getDisplay();
    }

    private String getDescForConcept(String s) {
        if (s.startsWith("http://hl7.org/fhir/v2/element/")) {
            return "v2 " + s.substring("http://hl7.org/fhir/v2/element/".length());
        }
        return s;
    }

    private String getValue(List<ConceptMap.OtherElementComponent> list, String s, boolean withSystem) {
        for (ConceptMap.OtherElementComponent c : list) {
            if (!s.equals(c.getProperty())) continue;
            if (withSystem) {
                return c.getSystem() + " / " + c.getValue();
            }
            return c.getValue();
        }
        return null;
    }

    private void addTelecom(XhtmlNode p, ContactPoint c) {
        if (c.getSystem() == ContactPoint.ContactPointSystem.PHONE) {
            p.tx("Phone: " + c.getValue());
        } else if (c.getSystem() == ContactPoint.ContactPointSystem.FAX) {
            p.tx("Fax: " + c.getValue());
        } else if (c.getSystem() == ContactPoint.ContactPointSystem.EMAIL) {
            p.ah("mailto:" + c.getValue()).addText(c.getValue());
        } else if (c.getSystem() == ContactPoint.ContactPointSystem.URL) {
            if (c.getValue().length() > 30) {
                p.ah(c.getValue()).addText(c.getValue().substring(0, 30) + "...");
            } else {
                p.ah(c.getValue()).addText(c.getValue());
            }
        }
    }

    public boolean generate(ResourceContext rcontext, CodeSystem cs, boolean header, String lang) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean hasExtensions = false;
        hasExtensions = this.generateDefinition(x, cs, header, lang);
        this.inject(cs, x, hasExtensions ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    private boolean generateDefinition(XhtmlNode x, CodeSystem cs, boolean header, String lang) throws FHIRFormatError, DefinitionException, IOException {
        boolean hasExtensions = false;
        if (header) {
            XhtmlNode h = x.h2();
            h.addText(cs.hasTitle() ? cs.getTitle() : cs.getName());
            this.addMarkdown(x, cs.getDescription());
            if (cs.hasCopyright()) {
                this.generateCopyright(x, cs, lang);
            }
        }
        this.generateProperties(x, cs, lang);
        this.generateFilters(x, cs, lang);
        ArrayList<UsedConceptMap> maps = new ArrayList<UsedConceptMap>();
        hasExtensions = this.generateCodeSystemContent(x, cs, hasExtensions, maps, lang);
        return hasExtensions;
    }

    private void generateFilters(XhtmlNode x, CodeSystem cs, String lang) {
        if (cs.hasFilter()) {
            x.para().b().tx(this.context.translator().translate("xhtml-gen-cs", "Filters", lang));
            XhtmlNode tbl = x.table("grid");
            XhtmlNode tr = tbl.tr();
            tr.td().b().tx(this.context.translator().translate("xhtml-gen-cs", "Code", lang));
            tr.td().b().tx(this.context.translator().translate("xhtml-gen-cs", "Description", lang));
            tr.td().b().tx(this.context.translator().translate("xhtml-gen-cs", "operator", lang));
            tr.td().b().tx(this.context.translator().translate("xhtml-gen-cs", "Value", lang));
            for (CodeSystem.CodeSystemFilterComponent f : cs.getFilter()) {
                tr = tbl.tr();
                tr.td().tx(f.getCode());
                tr.td().tx(f.getDescription());
                XhtmlNode td = tr.td();
                for (Enumeration<CodeSystem.FilterOperator> t : f.getOperator()) {
                    td.tx(t.asStringValue() + " ");
                }
                tr.td().tx(f.getValue());
            }
        }
    }

    private void generateProperties(XhtmlNode x, CodeSystem cs, String lang) {
        if (cs.hasProperty()) {
            x.para().b().tx(this.context.translator().translate("xhtml-gen-cs", "Properties", lang));
            XhtmlNode tbl = x.table("grid");
            XhtmlNode tr = tbl.tr();
            tr.td().b().tx(this.context.translator().translate("xhtml-gen-cs", "Code", lang));
            tr.td().b().tx(this.context.translator().translate("xhtml-gen-cs", "URL", lang));
            tr.td().b().tx(this.context.translator().translate("xhtml-gen-cs", "Description", lang));
            tr.td().b().tx(this.context.translator().translate("xhtml-gen-cs", "Type", lang));
            for (CodeSystem.PropertyComponent p : cs.getProperty()) {
                tr = tbl.tr();
                tr.td().tx(p.getCode());
                tr.td().tx(p.getUri());
                tr.td().tx(p.getDescription());
                tr.td().tx(p.hasType() ? p.getType().toCode() : "");
            }
        }
    }

    private boolean generateCodeSystemContent(XhtmlNode x, CodeSystem cs, boolean hasExtensions, List<UsedConceptMap> maps, String lang) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode p = x.para();
        if (cs.getContent() == CodeSystem.CodeSystemContentMode.COMPLETE) {
            p.tx(this.context.translator().translateAndFormat("xhtml-gen-cs", lang, "This code system %s defines the following codes", new Object[]{cs.getUrl()}) + ":");
        } else if (cs.getContent() == CodeSystem.CodeSystemContentMode.EXAMPLE) {
            p.tx(this.context.translator().translateAndFormat("xhtml-gen-cs", lang, "This code system %s defines many codes, of which the following are some examples", new Object[]{cs.getUrl()}) + ":");
        } else if (cs.getContent() == CodeSystem.CodeSystemContentMode.FRAGMENT) {
            p.tx(this.context.translator().translateAndFormat("xhtml-gen-cs", lang, "This code system %s defines many codes, of which the following are a subset", new Object[]{cs.getUrl()}) + ":");
        } else if (cs.getContent() == CodeSystem.CodeSystemContentMode.NOTPRESENT) {
            p.tx(this.context.translator().translateAndFormat("xhtml-gen-cs", lang, "This code system %s defines many codes, but they are not represented here", new Object[]{cs.getUrl()}));
            return false;
        }
        XhtmlNode t = x.table("codes");
        boolean commentS = false;
        boolean deprecated = false;
        boolean display = false;
        boolean hierarchy = false;
        boolean version = false;
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            commentS = commentS || this.conceptsHaveComments(c);
            deprecated = deprecated || this.conceptsHaveDeprecated(cs, c);
            display = display || this.conceptsHaveDisplay(c);
            version = version || this.conceptsHaveVersion(c);
            hierarchy = hierarchy || c.hasConcept();
        }
        this.addMapHeaders(this.addTableHeaderRowStandard(t, hierarchy, display, true, commentS, version, deprecated, lang), maps);
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            hasExtensions = this.addDefineRowToTable(t, c, 0, hierarchy, display, commentS, version, deprecated, maps, cs.getUrl(), cs, lang) || hasExtensions;
        }
        return hasExtensions;
    }

    private int countConcepts(List<CodeSystem.ConceptDefinitionComponent> list) {
        int count = list.size();
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (!c.hasConcept()) continue;
            count += this.countConcepts(c.getConcept());
        }
        return count;
    }

    private void generateCopyright(XhtmlNode x, CodeSystem cs, String lang) {
        XhtmlNode p = x.para();
        p.b().tx(this.context.translator().translate("xhtml-gen-cs", "Copyright Statement:", lang));
        this.smartAddText(p, " " + cs.getCopyright());
    }

    public boolean generate(ResourceContext rcontext, ValueSet vs, boolean header) throws FHIRException, IOException {
        this.generate(rcontext, vs, null, header);
        return true;
    }

    public void generate(ResourceContext rcontext, ValueSet vs, ValueSet src, boolean header) throws FHIRException, IOException {
        List<UsedConceptMap> maps = this.findReleventMaps(vs);
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean hasExtensions = vs.hasExpansion() ? this.generateExpansion(x, vs, src, header, maps) : this.generateComposition(rcontext, x, vs, header, maps);
        this.inject(vs, x, hasExtensions ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
    }

    private List<UsedConceptMap> findReleventMaps(ValueSet vs) throws FHIRException {
        ArrayList<UsedConceptMap> res = new ArrayList<UsedConceptMap>();
        for (MetadataResource md : this.context.allConformanceResources()) {
            ConceptMapRenderInstructions re;
            ConceptMap cm;
            if (!(md instanceof ConceptMap) || !this.isSource(vs, (cm = (ConceptMap)md).getSource()) || (re = this.findByTarget(cm.getTarget())) == null) continue;
            ValueSet vst = cm.hasTarget() ? this.context.fetchResource(ValueSet.class, cm.hasTargetCanonicalType() ? (String)cm.getTargetCanonicalType().getValue() : cm.getTargetUriType().asStringValue()) : null;
            res.add(new UsedConceptMap(re, vst == null ? cm.getUserString("path") : vst.getUserString("path"), cm));
        }
        return res;
    }

    private ConceptMapRenderInstructions findByTarget(Type source) {
        String src = source.primitiveValue();
        if (src != null) {
            for (ConceptMapRenderInstructions t : this.renderingMaps) {
                if (!src.equals(t.url)) continue;
                return t;
            }
        }
        return null;
    }

    private boolean isSource(ValueSet vs, Type source) {
        return vs.hasUrl() && source != null && vs.getUrl().equals(source.primitiveValue());
    }

    private Integer countMembership(ValueSet vs) {
        int count = 0;
        if (vs.hasExpansion()) {
            count += this.conceptCount(vs.getExpansion().getContains());
        } else if (vs.hasCompose()) {
            if (vs.getCompose().hasExclude()) {
                try {
                    ValueSetExpander.ValueSetExpansionOutcome vse = this.context.expandVS(vs, true, false);
                    count = 0;
                    return count += this.conceptCount(vse.getValueset().getExpansion().getContains());
                }
                catch (Exception e) {
                    return null;
                }
            }
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                if (inc.hasFilter()) {
                    return null;
                }
                if (!inc.hasConcept()) {
                    return null;
                }
                count += inc.getConcept().size();
            }
        }
        return count;
    }

    private int conceptCount(List<ValueSet.ValueSetExpansionContainsComponent> list) {
        int count = 0;
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            if (!c.getAbstract()) {
                ++count;
            }
            count += this.conceptCount(c.getContains());
        }
        return count;
    }

    private boolean generateExpansion(XhtmlNode x, ValueSet vs, ValueSet src, boolean header, List<UsedConceptMap> maps) throws FHIRFormatError, DefinitionException, IOException {
        boolean hasExtensions = false;
        ArrayList<String> langs = new ArrayList<String>();
        if (header) {
            XhtmlNode h = x.addTag(this.getHeader());
            h.tx("Value Set Contents");
            if (this.IsNotFixedExpansion(vs)) {
                this.addMarkdown(x, vs.getDescription());
            }
            if (vs.hasCopyright()) {
                this.generateCopyright(x, vs);
            }
        }
        if (ToolingExtensions.hasExtension(vs.getExpansion(), "http://hl7.org/fhir/StructureDefinition/valueset-toocostly")) {
            x.para().setAttribute("style", "border: maroon 1px solid; background-color: #FFCCCC; font-weight: bold; padding: 8px").addText(vs.getExpansion().getContains().isEmpty() ? this.tooCostlyNoteEmpty : this.tooCostlyNoteNotEmpty);
        } else {
            Integer count = this.countMembership(vs);
            if (count == null) {
                x.para().tx("This value set does not contain a fixed number of concepts");
            } else {
                x.para().tx("This value set contains " + count.toString() + " concepts");
            }
        }
        this.generateVersionNotice(x, vs.getExpansion());
        CodeSystem allCS = null;
        boolean doLevel = false;
        for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
            if (!cc.hasContains()) continue;
            doLevel = true;
            break;
        }
        boolean doSystem = true;
        boolean doDefinition = this.checkDoDefinition(vs.getExpansion().getContains());
        if (doSystem && this.allFromOneSystem(vs)) {
            doSystem = false;
            XhtmlNode p = x.para();
            p.tx("All codes from system ");
            allCS = this.context.fetchCodeSystem(vs.getExpansion().getContains().get(0).getSystem());
            String ref = null;
            if (allCS != null) {
                ref = this.getCsRef(allCS);
            }
            if (ref == null) {
                p.code(vs.getExpansion().getContains().get(0).getSystem());
            } else {
                p.ah(this.prefix + ref).code(vs.getExpansion().getContains().get(0).getSystem());
            }
        }
        XhtmlNode t = x.table("codes");
        XhtmlNode tr = t.tr();
        if (doLevel) {
            tr.td().b().tx("Lvl");
        }
        tr.td().attribute("style", "white-space:nowrap").b().tx("Code");
        if (doSystem) {
            tr.td().b().tx("System");
        }
        tr.td().b().tx("Display");
        if (doDefinition) {
            tr.td().b().tx("Definition");
        }
        this.addMapHeaders(tr, maps);
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            this.addExpansionRowToTable(t, c, 0, doLevel, doSystem, doDefinition, maps, allCS, langs);
        }
        if (langs.size() > 0) {
            Collections.sort(langs);
            x.para().b().tx("Additional Language Displays");
            t = x.table("codes");
            tr = t.tr();
            tr.td().b().tx("Code");
            for (String lang : langs) {
                tr.td().b().addText(this.describeLang(lang));
            }
            for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
                this.addLanguageRow(c, t, langs);
            }
        }
        return hasExtensions;
    }

    private void generateVersionNotice(XhtmlNode x, ValueSet.ValueSetExpansionComponent expansion) {
        HashMap<String, String> versions = new HashMap<String, String>();
        boolean firstVersion = true;
        for (ValueSet.ValueSetExpansionParameterComponent p : expansion.getParameter()) {
            if (!p.getName().equals("version")) continue;
            String[] parts = ((PrimitiveType)p.getValue()).asStringValue().split("\\|");
            if (parts.length == 2) {
                versions.put(parts[0], parts[1]);
            }
            if (versions.isEmpty()) continue;
            StringBuilder b = new StringBuilder();
            if (firstVersion) {
                x.para().setAttribute("style", "border: black 1px dotted; background-color: #EEEEEE; padding: 8px");
                firstVersion = false;
            } else {
                x.br();
            }
            b.append("Expansion based on ");
            boolean firstPart = true;
            for (String s : versions.keySet()) {
                if (firstPart) {
                    firstPart = false;
                } else {
                    b.append(", ");
                }
                if (!s.equals("http://snomed.info/sct")) {
                    b.append(NarrativeGenerator.describeSystem(s) + " version " + (String)versions.get(s));
                    continue;
                }
                parts = ((String)versions.get(s)).split("\\/");
                if (parts.length >= 5) {
                    String m = this.describeModule(parts[4]);
                    if (parts.length == 7) {
                        b.append("SNOMED CT " + m + " edition " + this.formatSCTDate(parts[6]));
                        continue;
                    }
                    b.append("SNOMED CT " + m + " edition");
                    continue;
                }
                b.append(NarrativeGenerator.describeSystem(s) + " version " + (String)versions.get(s));
            }
            x.addText(b.toString());
        }
    }

    private String formatSCTDate(String ds) {
        Date date;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {
            date = format.parse(ds);
        }
        catch (ParseException e) {
            return ds;
        }
        return new SimpleDateFormat("dd-MMM yyyy", new Locale("en", "US")).format(date);
    }

    private String describeModule(String module) {
        if ("900000000000207008".equals(module)) {
            return "International";
        }
        if ("731000124108".equals(module)) {
            return "United States";
        }
        if ("32506021000036107".equals(module)) {
            return "Australian";
        }
        if ("449081005".equals(module)) {
            return "Spanish";
        }
        if ("554471000005108".equals(module)) {
            return "Danish";
        }
        if ("11000146104".equals(module)) {
            return "Dutch";
        }
        if ("45991000052106".equals(module)) {
            return "Swedish";
        }
        if ("999000041000000102".equals(module)) {
            return "United Kingdon";
        }
        return module;
    }

    private boolean hasVersionParameter(ValueSet.ValueSetExpansionComponent expansion) {
        for (ValueSet.ValueSetExpansionParameterComponent p : expansion.getParameter()) {
            if (!p.getName().equals("version")) continue;
            return true;
        }
        return false;
    }

    private void addLanguageRow(ValueSet.ValueSetExpansionContainsComponent c, XhtmlNode t, List<String> langs) {
        XhtmlNode tr = t.tr();
        tr.td().addText(c.getCode());
        for (String lang : langs) {
            String d = null;
            for (Extension ext : c.getExtension()) {
                String l;
                if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || !lang.equals(l = ToolingExtensions.readStringExtension(ext, "lang"))) continue;
                d = ToolingExtensions.readStringExtension(ext, "content");
            }
            tr.td().addText(d == null ? "" : d);
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : c.getContains()) {
            this.addLanguageRow(cc, t, langs);
        }
    }

    private String describeLang(String lang) {
        ValueSet v = this.context.fetchResource(ValueSet.class, "http://hl7.org/fhir/ValueSet/languages");
        if (v != null) {
            ValueSet.ConceptReferenceComponent l = null;
            for (ValueSet.ConceptReferenceComponent cc : v.getCompose().getIncludeFirstRep().getConcept()) {
                if (!cc.getCode().equals(lang)) continue;
                l = cc;
            }
            if (l == null) {
                if (lang.contains("-")) {
                    lang = lang.substring(0, lang.indexOf("-"));
                }
                for (ValueSet.ConceptReferenceComponent cc : v.getCompose().getIncludeFirstRep().getConcept()) {
                    if (!cc.getCode().equals(lang) && !cc.getCode().startsWith(lang + "-")) continue;
                    l = cc;
                }
            }
            if (l != null) {
                if (lang.contains("-")) {
                    lang = lang.substring(0, lang.indexOf("-"));
                }
                String en = l.getDisplay();
                String nativelang = null;
                for (ValueSet.ConceptReferenceDesignationComponent cd : l.getDesignation()) {
                    if (!cd.getLanguage().equals(lang)) continue;
                    nativelang = cd.getValue();
                }
                if (nativelang == null) {
                    return en + " (" + lang + ")";
                }
                return nativelang + " (" + en + ", " + lang + ")";
            }
        }
        return lang;
    }

    private boolean checkDoDefinition(List<ValueSet.ValueSetExpansionContainsComponent> contains) {
        for (ValueSet.ValueSetExpansionContainsComponent c : contains) {
            CodeSystem cs = this.context.fetchCodeSystem(c.getSystem());
            if (cs != null) {
                return true;
            }
            if (!this.checkDoDefinition(c.getContains())) continue;
            return true;
        }
        return false;
    }

    private boolean allFromOneSystem(ValueSet vs) {
        if (vs.getExpansion().getContains().isEmpty()) {
            return false;
        }
        String system = vs.getExpansion().getContains().get(0).getSystem();
        for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
            if (this.checkSystemMatches(system, cc)) continue;
            return false;
        }
        return true;
    }

    private boolean checkSystemMatches(String system, ValueSet.ValueSetExpansionContainsComponent cc) {
        if (!system.equals(cc.getSystem())) {
            return false;
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc1 : cc.getContains()) {
            if (this.checkSystemMatches(system, cc1)) continue;
            return false;
        }
        return true;
    }

    private boolean checkDoSystem(ValueSet vs, ValueSet src) {
        if (src != null) {
            vs = src;
        }
        return vs.hasCompose();
    }

    private boolean IsNotFixedExpansion(ValueSet vs) {
        if (vs.hasCompose()) {
            return false;
        }
        for (ValueSet.ConceptSetComponent cc : vs.getCompose().getInclude()) {
            if (cc.hasValueSet()) {
                return true;
            }
            if (cc.hasVersion()) continue;
            return true;
        }
        return false;
    }

    private void addLanguageRow(CodeSystem.ConceptDefinitionComponent c, XhtmlNode t, List<String> langs) {
        XhtmlNode tr = t.tr();
        tr.td().addText(c.getCode());
        for (String lang : langs) {
            CodeSystem.ConceptDefinitionDesignationComponent d = null;
            for (CodeSystem.ConceptDefinitionDesignationComponent designation : c.getDesignation()) {
                if (!designation.hasLanguage() || !lang.equals(designation.getLanguage())) continue;
                d = designation;
            }
            tr.td().addText(d == null ? "" : d.getValue());
        }
    }

    private void addMapHeaders(XhtmlNode tr, List<UsedConceptMap> maps) throws FHIRFormatError, DefinitionException, IOException {
        for (UsedConceptMap m : maps) {
            XhtmlNode td = tr.td();
            XhtmlNode b = td.b();
            XhtmlNode a = b.ah(this.prefix + m.getLink());
            a.addText(m.getDetails().getName());
            if (!m.getDetails().isDoDescription() || !m.getMap().hasDescription()) continue;
            this.addMarkdown(td, m.getMap().getDescription());
        }
    }

    private void smartAddText(XhtmlNode p, String text) {
        if (text == null) {
            return;
        }
        String[] lines = text.split("\\r\\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                p.br();
            }
            p.addText(lines[i]);
        }
    }

    private boolean conceptsHaveComments(CodeSystem.ConceptDefinitionComponent c) {
        if (ToolingExtensions.hasCSComment(c)) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveComments(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveDisplay(CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasDisplay()) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveDisplay(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveVersion(CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasUserData("cs.version.notes")) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveVersion(g)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveDeprecated(CodeSystem cs, CodeSystem.ConceptDefinitionComponent c) {
        if (CodeSystemUtilities.isDeprecated(cs, c)) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.conceptsHaveDeprecated(cs, g)) continue;
            return true;
        }
        return false;
    }

    private void generateCopyright(XhtmlNode x, ValueSet vs) {
        XhtmlNode p = x.para();
        p.b().tx("Copyright Statement:");
        this.smartAddText(p, " " + vs.getCopyright());
    }

    private XhtmlNode addTableHeaderRowStandard(XhtmlNode t, boolean hasHierarchy, boolean hasDisplay, boolean definitions, boolean comments, boolean version, boolean deprecated, String lang) {
        XhtmlNode tr = t.tr();
        if (hasHierarchy) {
            tr.td().b().tx("Lvl");
        }
        tr.td().attribute("style", "white-space:nowrap").b().tx(this.context.translator().translate("xhtml-gen-cs", "Code", lang));
        if (hasDisplay) {
            tr.td().b().tx(this.context.translator().translate("xhtml-gen-cs", "Display", lang));
        }
        if (definitions) {
            tr.td().b().tx(this.context.translator().translate("xhtml-gen-cs", "Definition", lang));
        }
        if (deprecated) {
            tr.td().b().tx(this.context.translator().translate("xhtml-gen-cs", "Deprecated", lang));
        }
        if (comments) {
            tr.td().b().tx(this.context.translator().translate("xhtml-gen-cs", "Comments", lang));
        }
        if (version) {
            tr.td().b().tx(this.context.translator().translate("xhtml-gen-cs", "Version", lang));
        }
        return tr;
    }

    private void addExpansionRowToTable(XhtmlNode t, ValueSet.ValueSetExpansionContainsComponent c, int i, boolean doLevel, boolean doSystem, boolean doDefinition, List<UsedConceptMap> maps, CodeSystem allCS, List<String> langs) {
        XhtmlNode tr = t.tr();
        XhtmlNode td = tr.td();
        String tgt = this.makeAnchor(c.getSystem(), c.getCode());
        td.an(tgt);
        if (doLevel) {
            td.addText(Integer.toString(i));
            td = tr.td();
        }
        String s = Utilities.padLeft((String)"", (char)'\u00a0', (int)(i * 2));
        td.attribute("style", "white-space:nowrap").addText(s);
        this.addCodeToTable(c.getAbstract(), c.getSystem(), c.getCode(), c.getDisplay(), td);
        if (doSystem) {
            td = tr.td();
            td.addText(c.getSystem());
        }
        td = tr.td();
        if (c.hasDisplayElement()) {
            td.addText(c.getDisplay());
        }
        if (doDefinition) {
            CodeSystem cs = allCS;
            if (cs == null) {
                cs = this.context.fetchCodeSystem(c.getSystem());
            }
            td = tr.td();
            if (cs != null) {
                td.addText(CodeSystemUtilities.getCodeDefinition(cs, c.getCode()));
            }
        }
        for (UsedConceptMap m : maps) {
            td = tr.td();
            List<TargetElementComponentWrapper> mappings = this.findMappingsForCode(c.getCode(), m.getMap());
            boolean first = true;
            for (TargetElementComponentWrapper mapping : mappings) {
                if (!first) {
                    td.br();
                }
                first = false;
                XhtmlNode span = td.span(null, mapping.comp.getEquivalence().toString());
                span.addText(this.getCharForEquivalence(mapping.comp));
                this.addRefToCode(td, mapping.group.getTarget(), m.getLink(), mapping.comp.getCode());
                if (Utilities.noString((String)mapping.comp.getComment())) continue;
                td.i().tx("(" + mapping.comp.getComment() + ")");
            }
        }
        for (Extension ext : c.getExtension()) {
            String lang;
            if (!"http://hl7.org/fhir/StructureDefinition/translation".equals(ext.getUrl()) || Utilities.noString((String)(lang = ToolingExtensions.readStringExtension(ext, "lang"))) || langs.contains(lang)) continue;
            langs.add(lang);
        }
        for (ValueSet.ValueSetExpansionContainsComponent cc : c.getContains()) {
            this.addExpansionRowToTable(t, cc, i + 1, doLevel, doSystem, doDefinition, maps, allCS, langs);
        }
    }

    private void addCodeToTable(boolean isAbstract, String system, String code, String display, XhtmlNode td) {
        CodeSystem e = this.context.fetchCodeSystem(system);
        if (e == null || e.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) {
            if (isAbstract) {
                td.i().setAttribute("title", ABSTRACT_CODE_HINT).addText(code);
            } else if ("http://snomed.info/sct".equals(system)) {
                td.ah(this.sctLink(code)).addText(code);
            } else if ("http://loinc.org".equals(system)) {
                td.ah(LoincLinker.getLinkForCode((String)code)).addText(code);
            } else {
                td.addText(code);
            }
        } else {
            String href = this.prefix + this.getCsRef(e);
            href = href.contains("#") ? href + "-" + Utilities.nmtokenize((String)code) : href + "#" + e.getId() + "-" + Utilities.nmtokenize((String)code);
            if (isAbstract) {
                td.ah(href).setAttribute("title", ABSTRACT_CODE_HINT).i().addText(code);
            } else {
                td.ah(href).addText(code);
            }
        }
    }

    public String sctLink(String code) {
        return "http://browser.ihtsdotools.org/?perspective=full&conceptId1=" + code;
    }

    private String langDisplay(String l, boolean isShort) {
        ValueSet vs = this.context.fetchResource(ValueSet.class, "http://hl7.org/fhir/ValueSet/languages");
        for (ValueSet.ConceptReferenceComponent vc : vs.getCompose().getInclude().get(0).getConcept()) {
            if (!vc.getCode().equals(l)) continue;
            for (ValueSet.ConceptReferenceDesignationComponent cd : vc.getDesignation()) {
                if (!cd.getLanguage().equals(l)) continue;
                return cd.getValue() + (String)(isShort ? "" : " (" + vc.getDisplay() + ")");
            }
            return vc.getDisplay();
        }
        return "??Lang";
    }

    private boolean addDefineRowToTable(XhtmlNode t, CodeSystem.ConceptDefinitionComponent c, int i, boolean hasHierarchy, boolean hasDisplay, boolean comment, boolean version, boolean deprecated, List<UsedConceptMap> maps, String system, CodeSystem cs, String lang) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode a;
        boolean sl;
        boolean hasExtensions = false;
        XhtmlNode tr = t.tr();
        XhtmlNode td = tr.td();
        if (hasHierarchy) {
            td.addText(Integer.toString(i + 1));
            td = tr.td();
            String s = Utilities.padLeft((String)"", (char)'\u00a0', (int)(i * 2));
            td.addText(s);
        }
        td.attribute("style", "white-space:nowrap").addText(c.getCode());
        if (c.hasCodeElement()) {
            td.an(cs.getId() + "-" + Utilities.nmtokenize((String)c.getCode()));
        }
        if (hasDisplay) {
            td = tr.td();
            if (c.hasDisplayElement()) {
                if (lang == null) {
                    td.addText(c.getDisplay());
                } else if (lang.equals("*")) {
                    sl = false;
                    for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                        if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "display") || !cd.hasLanguage() || c.getDisplay().equalsIgnoreCase(cd.getValue())) continue;
                        sl = true;
                    }
                    td.addText((String)(sl ? cs.getLanguage("en") + ": " : "") + c.getDisplay());
                    for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                        if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "display") || !cd.hasLanguage() || c.getDisplay().equalsIgnoreCase(cd.getValue())) continue;
                        td.br();
                        td.addText(cd.getLanguage() + ": " + cd.getValue());
                    }
                } else if (lang.equals(cs.getLanguage()) || lang.equals("en") && !cs.hasLanguage()) {
                    td.addText(c.getDisplay());
                } else {
                    for (CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : c.getDesignation()) {
                        if (!conceptDefinitionDesignationComponent.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "display") || !conceptDefinitionDesignationComponent.hasLanguage() || !conceptDefinitionDesignationComponent.getLanguage().equals(lang)) continue;
                        td.addText(conceptDefinitionDesignationComponent.getValue());
                    }
                }
            }
        }
        td = tr.td();
        if (c != null && c.hasDefinitionElement()) {
            if (lang == null) {
                if (this.hasMarkdownInDefinitions(cs)) {
                    this.addMarkdown(td, c.getDefinition());
                } else {
                    td.addText(c.getDefinition());
                }
            } else if (lang.equals("*")) {
                sl = false;
                for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                    if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "definition") || !cd.hasLanguage() || c.getDefinition().equalsIgnoreCase(cd.getValue())) continue;
                    sl = true;
                }
                td.addText((String)(sl ? cs.getLanguage("en") + ": " : "") + c.getDefinition());
                for (CodeSystem.ConceptDefinitionDesignationComponent cd : c.getDesignation()) {
                    if (!cd.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "definition") || !cd.hasLanguage() || c.getDefinition().equalsIgnoreCase(cd.getValue())) continue;
                    td.br();
                    td.addText(cd.getLanguage() + ": " + cd.getValue());
                }
            } else if (lang.equals(cs.getLanguage()) || lang.equals("en") && !cs.hasLanguage()) {
                td.addText(c.getDefinition());
            } else {
                for (CodeSystem.ConceptDefinitionDesignationComponent conceptDefinitionDesignationComponent : c.getDesignation()) {
                    if (!conceptDefinitionDesignationComponent.getUse().is("http://terminology.hl7.org/CodeSystem/designation-usage", "definition") || !conceptDefinitionDesignationComponent.hasLanguage() || !conceptDefinitionDesignationComponent.getLanguage().equals(lang)) continue;
                    td.addText(conceptDefinitionDesignationComponent.getValue());
                }
            }
        }
        if (deprecated) {
            td = tr.td();
            Boolean b = CodeSystemUtilities.isDeprecated(cs, c);
            if (b != null && b.booleanValue()) {
                this.smartAddText(td, this.context.translator().translate("xhtml-gen-cs", "Deprecated", lang));
                hasExtensions = true;
                if (ToolingExtensions.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-replacedby")) {
                    Coding coding = (Coding)ToolingExtensions.getExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-replacedby").getValue();
                    td.tx(" (replaced by ");
                    String url = this.getCodingReference(coding, system);
                    if (url != null) {
                        td.ah(url).addText(coding.getCode());
                        td.tx(": " + coding.getDisplay() + ")");
                    } else {
                        td.addText(coding.getCode() + " '" + coding.getDisplay() + "' in " + coding.getSystem() + ")");
                    }
                }
            }
        }
        if (comment) {
            td = tr.td();
            Extension ext = c.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/codesystem-concept-comments");
            if (ext != null) {
                hasExtensions = true;
                String string = ext.hasValue() ? ext.getValue().primitiveValue() : null;
                Map<String, String> translations = ToolingExtensions.getLanguageTranslations(ext.getValue());
                if (lang == null) {
                    if (string != null) {
                        td.addText(string);
                    }
                } else if (lang.equals("*")) {
                    boolean sl2 = false;
                    for (String l : translations.keySet()) {
                        if (string != null && string.equalsIgnoreCase(translations.get(l))) continue;
                        sl2 = true;
                    }
                    if (string != null) {
                        td.addText((String)(sl2 ? cs.getLanguage("en") + ": " : "") + string);
                    }
                    for (String l : translations.keySet()) {
                        if (string != null && string.equalsIgnoreCase(translations.get(l))) continue;
                        if (!td.getChildNodes().isEmpty()) {
                            td.br();
                        }
                        td.addText(l + ": " + translations.get(l));
                    }
                } else if (lang.equals(cs.getLanguage()) || lang.equals("en") && !cs.hasLanguage()) {
                    if (string != null) {
                        td.addText(string);
                    }
                } else {
                    if (string != null) {
                        translations.put(cs.getLanguage("en"), string);
                    }
                    for (String l : translations.keySet()) {
                        if (!l.equals(lang)) continue;
                        td.addText(translations.get(l));
                    }
                }
            }
        }
        if (version) {
            td = tr.td();
            if (c.hasUserData("cs.version.notes")) {
                td.addText(c.getUserString("cs.version.notes"));
            }
        }
        for (UsedConceptMap usedConceptMap : maps) {
            td = tr.td();
            List<TargetElementComponentWrapper> mappings = this.findMappingsForCode(c.getCode(), usedConceptMap.getMap());
            boolean first = true;
            for (TargetElementComponentWrapper mapping : mappings) {
                if (!first) {
                    td.br();
                }
                first = false;
                XhtmlNode span = td.span(null, mapping.comp.hasEquivalence() ? mapping.comp.getEquivalence().toCode() : "");
                span.addText(this.getCharForEquivalence(mapping.comp));
                a = td.ah(this.prefix + usedConceptMap.getLink() + "#" + this.makeAnchor(mapping.group.getTarget(), mapping.comp.getCode()));
                a.addText(mapping.comp.getCode());
                if (Utilities.noString((String)mapping.comp.getComment())) continue;
                td.i().tx("(" + mapping.comp.getComment() + ")");
            }
        }
        for (String string : CodeSystemUtilities.getOtherChildren(cs, c)) {
            tr = t.tr();
            td = tr.td();
            String s = Utilities.padLeft((String)"", (char)'.', (int)(i * 2));
            td.addText(s);
            a = td.ah("#" + Utilities.nmtokenize((String)string));
            a.addText(c.getCode());
        }
        for (CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent : c.getConcept()) {
            hasExtensions = this.addDefineRowToTable(t, conceptDefinitionComponent, i + 1, hasHierarchy, hasDisplay, comment, version, deprecated, maps, system, cs, lang) || hasExtensions;
        }
        return hasExtensions;
    }

    private boolean hasMarkdownInDefinitions(CodeSystem cs) {
        return ToolingExtensions.readBoolExtension(cs, "http://hl7.org/fhir/StructureDefinition/codesystem-use-markdown");
    }

    private String makeAnchor(String codeSystem, String code) {
        String s = codeSystem + "-" + code;
        StringBuilder b = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '.') {
                b.append(c);
                continue;
            }
            b.append('-');
        }
        return b.toString();
    }

    private String getCodingReference(Coding cc, String system) {
        if (cc.getSystem().equals(system)) {
            return "#" + cc.getCode();
        }
        if (cc.getSystem().equals("http://snomed.info/sct")) {
            return "http://snomed.info/sct/" + cc.getCode();
        }
        if (cc.getSystem().equals("http://loinc.org")) {
            return LoincLinker.getLinkForCode((String)cc.getCode());
        }
        return null;
    }

    private String getCharForEquivalence(ConceptMap.TargetElementComponent mapping) {
        if (!mapping.hasEquivalence()) {
            return "";
        }
        switch (mapping.getEquivalence()) {
            case EQUAL: {
                return "=";
            }
            case EQUIVALENT: {
                return "~";
            }
            case WIDER: {
                return "<";
            }
            case NARROWER: {
                return ">";
            }
            case INEXACT: {
                return "><";
            }
            case UNMATCHED: {
                return "-";
            }
            case DISJOINT: {
                return "!=";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    private List<TargetElementComponentWrapper> findMappingsForCode(String code, ConceptMap map) {
        ArrayList<TargetElementComponentWrapper> mappings = new ArrayList<TargetElementComponentWrapper>();
        for (ConceptMap.ConceptMapGroupComponent g : map.getGroup()) {
            for (ConceptMap.SourceElementComponent c : g.getElement()) {
                if (!c.getCode().equals(code)) continue;
                for (ConceptMap.TargetElementComponent cc : c.getTarget()) {
                    mappings.add(new TargetElementComponentWrapper(g, cc));
                }
            }
        }
        return mappings;
    }

    private boolean generateComposition(ResourceContext rcontext, XhtmlNode x, ValueSet vs, boolean header, List<UsedConceptMap> maps) throws FHIRException, IOException {
        boolean hasExtensions = false;
        ArrayList<String> langs = new ArrayList<String>();
        if (header) {
            XhtmlNode h = x.h2();
            h.addText(vs.present());
            this.addMarkdown(x, vs.getDescription());
            if (vs.hasCopyrightElement()) {
                this.generateCopyright(x, vs);
            }
        }
        XhtmlNode p = x.para();
        p.tx("This value set includes codes from the following code systems:");
        XhtmlNode ul = x.ul();
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            hasExtensions = this.genInclude(rcontext, ul, inc, "Include", langs, maps) || hasExtensions;
        }
        for (ValueSet.ConceptSetComponent exc : vs.getCompose().getExclude()) {
            hasExtensions = this.genInclude(rcontext, ul, exc, "Exclude", langs, maps) || hasExtensions;
        }
        if (langs.size() > 0) {
            Collections.sort(langs);
            x.para().b().tx("Additional Language Displays");
            XhtmlNode t = x.table("codes");
            XhtmlNode tr = t.tr();
            tr.td().b().tx("Code");
            for (String lang : langs) {
                tr.td().b().addText(this.describeLang(lang));
            }
            for (ValueSet.ConceptSetComponent c : vs.getCompose().getInclude()) {
                for (ValueSet.ConceptReferenceComponent cc : c.getConcept()) {
                    this.addLanguageRow(cc, t, langs);
                }
            }
        }
        return hasExtensions;
    }

    private void addLanguageRow(ValueSet.ConceptReferenceComponent c, XhtmlNode t, List<String> langs) {
        XhtmlNode tr = t.tr();
        tr.td().addText(c.getCode());
        for (String lang : langs) {
            String d = null;
            for (ValueSet.ConceptReferenceDesignationComponent cd : c.getDesignation()) {
                String l = cd.getLanguage();
                if (!lang.equals(l)) continue;
                d = cd.getValue();
            }
            tr.td().addText(d == null ? "" : d);
        }
    }

    private void AddVsRef(ResourceContext rcontext, String value, XhtmlNode li) {
        Resource res;
        Resource resource = res = rcontext == null ? null : rcontext.resolve(value);
        if (res != null && !(res instanceof MetadataResource)) {
            li.addText(value);
            return;
        }
        MetadataResource vs = (MetadataResource)res;
        if (vs == null) {
            vs = this.context.fetchResource(ValueSet.class, value);
        }
        if (vs == null) {
            vs = this.context.fetchResource(StructureDefinition.class, value);
        }
        if (vs == null) {
            vs = this.context.fetchResource(Questionnaire.class, value);
        }
        if (vs != null) {
            String ref = (String)vs.getUserData("path");
            XhtmlNode a = li.ah((ref = this.adjustForPath(ref)) == null ? "??" : ref.replace("\\", "/"));
            a.addText(value);
        } else {
            CodeSystem cs = this.context.fetchCodeSystem(value);
            if (cs != null) {
                String ref = (String)cs.getUserData("path");
                XhtmlNode a = li.ah((ref = this.adjustForPath(ref)) == null ? "??" : ref.replace("\\", "/"));
                a.addText(value);
            } else if (value.equals("http://snomed.info/sct") || value.equals("http://snomed.info/id")) {
                XhtmlNode a = li.ah(value);
                a.tx("SNOMED-CT");
            } else {
                if (value.startsWith("http://hl7.org") && !Utilities.existsInList((String)value, (String[])new String[]{"http://hl7.org/fhir/sid/icd-10-us"})) {
                    System.out.println("Unable to resolve value set " + value);
                }
                li.addText(value);
            }
        }
    }

    private String adjustForPath(String ref) {
        if (this.prefix == null) {
            return ref;
        }
        return this.prefix + ref;
    }

    private boolean genInclude(ResourceContext rcontext, XhtmlNode ul, ValueSet.ConceptSetComponent inc, String type, List<String> langs, List<UsedConceptMap> maps) throws FHIRException, IOException {
        boolean hasExtensions;
        block29: {
            XhtmlNode li;
            block28: {
                boolean first;
                hasExtensions = false;
                li = ul.li();
                CodeSystem e = this.context.fetchCodeSystem(inc.getSystem());
                if (!inc.hasSystem()) break block28;
                if (inc.getConcept().size() == 0 && inc.getFilter().size() == 0) {
                    li.addText(type + " all codes defined in ");
                    this.addCsRef(inc, li, e);
                } else {
                    if (inc.getConcept().size() > 0) {
                        boolean bl;
                        li.addText(type + " these codes as defined in ");
                        this.addCsRef(inc, li, e);
                        XhtmlNode t = li.table("none");
                        boolean hasComments = false;
                        boolean bl2 = false;
                        for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                            hasComments = hasComments || ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments");
                            bl = bl || ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition");
                        }
                        if (hasComments || bl) {
                            hasExtensions = true;
                        }
                        this.addMapHeaders(this.addTableHeaderRowStandard(t, false, true, bl, hasComments, false, false, null), maps);
                        for (ValueSet.ConceptReferenceComponent c : inc.getConcept()) {
                            XhtmlNode tr = t.tr();
                            XhtmlNode td = tr.td();
                            CodeSystem.ConceptDefinitionComponent cc = this.getConceptForCode(e, c.getCode(), inc);
                            this.addCodeToTable(false, inc.getSystem(), c.getCode(), c.hasDisplay() ? c.getDisplay() : (cc != null ? cc.getDisplay() : ""), td);
                            td = tr.td();
                            if (!Utilities.noString((String)c.getDisplay())) {
                                td.addText(c.getDisplay());
                            } else if (cc != null && !Utilities.noString((String)cc.getDisplay())) {
                                td.addText(cc.getDisplay());
                            }
                            td = tr.td();
                            if (ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition")) {
                                this.smartAddText(td, ToolingExtensions.readStringExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition"));
                            } else if (cc != null && !Utilities.noString((String)cc.getDefinition())) {
                                this.smartAddText(td, cc.getDefinition());
                            }
                            if (ExtensionHelper.hasExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments")) {
                                this.smartAddText(tr.td(), "Note: " + ToolingExtensions.readStringExtension(c, "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments"));
                            }
                            for (ValueSet.ConceptReferenceDesignationComponent cd : c.getDesignation()) {
                                if (!cd.hasLanguage() || langs.contains(cd.getLanguage())) continue;
                                langs.add(cd.getLanguage());
                            }
                        }
                    }
                    first = true;
                    for (ValueSet.ConceptSetFilterComponent conceptSetFilterComponent : inc.getFilter()) {
                        String disp;
                        if (first) {
                            li.addText(type + " codes from ");
                            first = false;
                        } else {
                            li.tx(" and ");
                        }
                        this.addCsRef(inc, li, e);
                        li.tx(" where " + conceptSetFilterComponent.getProperty() + " " + this.describe(conceptSetFilterComponent.getOp()) + " ");
                        if (e != null && this.codeExistsInValueSet(e, conceptSetFilterComponent.getValue())) {
                            String href = this.prefix + this.getCsRef(e);
                            href = href.contains("#") ? href + "-" + Utilities.nmtokenize((String)conceptSetFilterComponent.getValue()) : href + "#" + e.getId() + "-" + Utilities.nmtokenize((String)conceptSetFilterComponent.getValue());
                            li.ah(href).addText(conceptSetFilterComponent.getValue());
                        } else if ("concept".equals(conceptSetFilterComponent.getProperty()) && inc.hasSystem()) {
                            li.addText(conceptSetFilterComponent.getValue());
                            IWorkerContext.ValidationResult vr = this.context.validateCode((ValidationOptions)this.terminologyServiceOptions, inc.getSystem(), conceptSetFilterComponent.getValue(), null);
                            if (vr.isOk()) {
                                li.tx(" (" + vr.getDisplay() + ")");
                            }
                        } else {
                            li.addText(conceptSetFilterComponent.getValue());
                        }
                        if ((disp = ToolingExtensions.getDisplayHint(conceptSetFilterComponent)) == null) continue;
                        li.tx(" (" + disp + ")");
                    }
                }
                if (!inc.hasValueSet()) break block29;
                li.tx(", where the codes are contained in ");
                first = true;
                for (UriType uriType : inc.getValueSet()) {
                    if (first) {
                        first = false;
                    } else {
                        li.tx(", ");
                    }
                    this.AddVsRef(rcontext, uriType.asStringValue(), li);
                }
                break block29;
            }
            li.tx("Import all the codes that are contained in ");
            boolean first = true;
            for (UriType uriType : inc.getValueSet()) {
                if (first) {
                    first = false;
                } else {
                    li.tx(", ");
                }
                this.AddVsRef(rcontext, uriType.asStringValue(), li);
            }
        }
        return hasExtensions;
    }

    private String describe(ValueSet.FilterOperator op) {
        switch (op) {
            case EQUAL: {
                return " = ";
            }
            case ISA: {
                return " is-a ";
            }
            case ISNOTA: {
                return " is-not-a ";
            }
            case REGEX: {
                return " matches (by regex) ";
            }
            case NULL: {
                return " ?? ";
            }
            case IN: {
                return " in ";
            }
            case NOTIN: {
                return " not in ";
            }
            case DESCENDENTOF: {
                return " descends from ";
            }
            case EXISTS: {
                return " exists ";
            }
            case GENERALIZES: {
                return " generalizes ";
            }
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCode(CodeSystem e, String code, ValueSet.ConceptSetComponent inc) {
        CodeSystem.ConceptDefinitionComponent v;
        if (e == null) {
            e = this.context.fetchCodeSystem(inc.getSystem());
        }
        if (e != null && (v = this.getConceptForCode(e.getConcept(), code)) != null) {
            return v;
        }
        if (!this.context.hasCache()) {
            CodeSystem.ConceptDefinitionComponent v2;
            ValueSet.ValueSetExpansionComponent vse;
            try {
                ValueSetExpander.ValueSetExpansionOutcome vso = this.context.expandVS(inc, false);
                ValueSet valueset = vso.getValueset();
                if (valueset == null) {
                    throw new TerminologyServiceException("Error Expanding ValueSet: " + vso.getError());
                }
                vse = valueset.getExpansion();
            }
            catch (TerminologyServiceException e1) {
                return null;
            }
            if (vse != null && (v2 = this.getConceptForCodeFromExpansion(vse.getContains(), code)) != null) {
                return v2;
            }
        }
        return this.context.validateCode((ValidationOptions)this.terminologyServiceOptions, inc.getSystem(), code, null).asConceptDefinition();
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCode(List<CodeSystem.ConceptDefinitionComponent> list, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : list) {
            if (code.equals(c.getCode())) {
                return c;
            }
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCode(c.getConcept(), code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent getConceptForCodeFromExpansion(List<ValueSet.ValueSetExpansionContainsComponent> list, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : list) {
            if (code.equals(c.getCode())) {
                CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
                res.setCode(c.getCode());
                res.setDisplay(c.getDisplay());
                return res;
            }
            CodeSystem.ConceptDefinitionComponent v = this.getConceptForCodeFromExpansion(c.getContains(), code);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private void addRefToCode(XhtmlNode td, String target, String vslink, String code) {
        CodeSystem cs = this.context.fetchCodeSystem(target);
        String cslink = this.getCsRef(cs);
        XhtmlNode a = null;
        a = cslink != null ? td.ah(this.prefix + cslink + "#" + cs.getId() + "-" + code) : td.ah(this.prefix + vslink + "#" + code);
        a.addText(code);
    }

    private <T extends Resource> void addCsRef(ValueSet.ConceptSetComponent inc, XhtmlNode li, T cs) {
        String spec;
        Object ref = null;
        boolean addHtml = true;
        if (cs != null) {
            ref = (String)cs.getUserData("external.url");
            if (Utilities.noString((String)ref)) {
                ref = (String)cs.getUserData("filename");
            } else {
                addHtml = false;
            }
            if (Utilities.noString((String)ref)) {
                ref = (String)cs.getUserData("path");
            }
        }
        if ((spec = this.getSpecialReference(inc.getSystem())) != null) {
            XhtmlNode a = li.ah(spec);
            a.code(inc.getSystem());
        } else if (cs != null && ref != null) {
            if (!Utilities.noString((String)this.prefix) && ((String)ref).startsWith("http://hl7.org/fhir/")) {
                ref = ((String)ref).substring(20) + "/index.html";
            } else if (addHtml && !((String)ref).contains(".html")) {
                ref = (String)ref + ".html";
            }
            XhtmlNode a = li.ah(this.prefix + ((String)ref).replace("\\", "/"));
            a.code(inc.getSystem());
        } else {
            li.code(inc.getSystem());
        }
    }

    private String getSpecialReference(String system) {
        if ("http://snomed.info/sct".equals(system)) {
            return "http://www.snomed.org/";
        }
        if (Utilities.existsInList((String)system, (String[])new String[]{"http://loinc.org", "http://unitsofmeasure.org", "http://www.nlm.nih.gov/research/umls/rxnorm", "http://ncimeta.nci.nih.gov", "http://fdasis.nlm.nih.gov", "http://www.radlex.org", "http://www.whocc.no/atc", "http://dicom.nema.org/resources/ontology/DCM", "http://www.genenames.org", "http://www.ensembl.org", "http://www.ncbi.nlm.nih.gov/nuccore", "http://www.ncbi.nlm.nih.gov/clinvar", "http://sequenceontology.org", "http://www.hgvs.org/mutnomen", "http://www.ncbi.nlm.nih.gov/projects/SNP", "http://cancer.sanger.ac.uk/cancergenome/projects/cosmic", "http://www.lrg-sequence.org", "http://www.omim.org", "http://www.ncbi.nlm.nih.gov/pubmed", "http://www.pharmgkb.org", "http://clinicaltrials.gov", "http://www.ebi.ac.uk/ipd/imgt/hla/"})) {
            return system;
        }
        return null;
    }

    private String getCsRef(String system) {
        CodeSystem cs = this.context.fetchCodeSystem(system);
        return this.getCsRef(cs);
    }

    private <T extends Resource> String getCsRef(T cs) {
        Object ref = (String)cs.getUserData("filename");
        if (ref == null) {
            ref = (String)cs.getUserData("path");
        }
        if (ref == null) {
            return "??.html";
        }
        if (!((String)ref).contains(".html")) {
            ref = (String)ref + ".html";
        }
        return ((String)ref).replace("\\", "/");
    }

    private boolean codeExistsInValueSet(CodeSystem cs, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            if (!this.inConcept(code, c)) continue;
            return true;
        }
        return false;
    }

    private boolean inConcept(String code, CodeSystem.ConceptDefinitionComponent c) {
        if (c.hasCodeElement() && c.getCode().equals(code)) {
            return true;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            if (!this.inConcept(code, g)) continue;
            return true;
        }
        return false;
    }

    public boolean generate(ResourceContext rcontext, OperationOutcome op) throws DefinitionException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean hasSource = false;
        boolean success = true;
        for (OperationOutcome.OperationOutcomeIssueComponent i : op.getIssue()) {
            success = success && i.getSeverity() == OperationOutcome.IssueSeverity.INFORMATION;
            hasSource = hasSource || ExtensionHelper.hasExtension(i, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
        }
        if (success) {
            x.para().tx("All OK");
        }
        if (op.getIssue().size() > 0) {
            XhtmlNode tbl = x.table("grid");
            XhtmlNode tr = tbl.tr();
            tr.td().b().tx("Severity");
            tr.td().b().tx("Location");
            tr.td().b().tx("Code");
            tr.td().b().tx("Details");
            tr.td().b().tx("Diagnostics");
            if (hasSource) {
                tr.td().b().tx("Source");
            }
            for (OperationOutcome.OperationOutcomeIssueComponent i : op.getIssue()) {
                tr = tbl.tr();
                tr.td().addText(i.getSeverity().toString());
                XhtmlNode td = tr.td();
                boolean d = false;
                for (StringType s : i.getLocation()) {
                    if (d) {
                        td.tx(", ");
                    } else {
                        d = true;
                    }
                    td.addText((String)s.getValue());
                }
                tr.td().addText(i.getCode().getDisplay());
                tr.td().addText(this.gen(i.getDetails()));
                this.smartAddText(tr.td(), i.getDiagnostics());
                if (!hasSource) continue;
                Extension ext = ExtensionHelper.getExtension(i, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
                tr.td().addText(ext == null ? "" : this.gen(ext));
            }
        }
        this.inject(op, x, hasSource ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    public String genType(Type type) throws DefinitionException {
        if (type instanceof Coding) {
            return this.gen((Coding)type);
        }
        if (type instanceof CodeableConcept) {
            return this.displayCodeableConcept((CodeableConcept)type);
        }
        if (type instanceof Quantity) {
            return this.displayQuantity((Quantity)type);
        }
        if (type instanceof Range) {
            return this.displayRange((Range)type);
        }
        return null;
    }

    private String gen(Extension extension) throws DefinitionException {
        if (extension.getValue() instanceof CodeType) {
            return (String)((CodeType)extension.getValue()).getValue();
        }
        if (extension.getValue() instanceof Coding) {
            return this.gen((Coding)extension.getValue());
        }
        throw new DefinitionException("Unhandled type " + extension.getValue().getClass().getName());
    }

    public String gen(CodeableConcept code) {
        if (code == null) {
            return null;
        }
        if (code.hasText()) {
            return code.getText();
        }
        if (code.hasCoding()) {
            return this.gen(code.getCoding().get(0));
        }
        return null;
    }

    public String gen(Coding code) {
        if (code == null) {
            return null;
        }
        if (code.hasDisplayElement()) {
            return code.getDisplay();
        }
        if (code.hasCodeElement()) {
            return code.getCode();
        }
        return null;
    }

    public boolean generate(ResourceContext rcontext, StructureDefinition sd, Set<String> outputTracker) throws EOperationOutcome, FHIRException, IOException {
        ProfileUtilities pu = new ProfileUtilities(this.context, null, this.pkp);
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.getChildNodes().add(pu.generateTable(this.definitionsTarget, sd, true, this.destDir, false, sd.getId(), false, this.corePath, "", false, false, outputTracker));
        this.inject(sd, x, Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    public boolean generate(ResourceContext rcontext, ImplementationGuide ig) throws EOperationOutcome, FHIRException, IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.h2().addText(ig.getName());
        x.para().tx("The official URL for this implementation guide is: ");
        x.pre().tx(ig.getUrl());
        this.addMarkdown(x, ig.getDescription());
        this.inject(ig, x, Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    public boolean generate(ResourceContext rcontext, OperationDefinition opd) throws EOperationOutcome, FHIRException, IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.h2().addText(opd.getName());
        x.para().addText(Utilities.capitalize((String)opd.getKind().toString()) + ": " + opd.getName());
        x.para().tx("The official URL for this operation definition is: ");
        x.pre().tx(opd.getUrl());
        this.addMarkdown(x, opd.getDescription());
        if (opd.getSystem()) {
            x.para().tx("URL: [base]/$" + opd.getCode());
        }
        for (CodeType c : opd.getResource()) {
            if (opd.getType()) {
                x.para().tx("URL: [base]/" + (String)c.getValue() + "/$" + opd.getCode());
            }
            if (!opd.getInstance()) continue;
            x.para().tx("URL: [base]/" + (String)c.getValue() + "/[id]/$" + opd.getCode());
        }
        x.para().tx("Parameters");
        XhtmlNode tbl = x.table("grid");
        XhtmlNode tr = tbl.tr();
        tr.td().b().tx("Use");
        tr.td().b().tx("Name");
        tr.td().b().tx("Cardinality");
        tr.td().b().tx("Type");
        tr.td().b().tx("Binding");
        tr.td().b().tx("Documentation");
        for (OperationDefinition.OperationDefinitionParameterComponent p : opd.getParameter()) {
            this.genOpParam(rcontext, tbl, "", p);
        }
        this.addMarkdown(x, opd.getComment());
        this.inject(opd, x, Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    private void genOpParam(ResourceContext rcontext, XhtmlNode tbl, String path, OperationDefinition.OperationDefinitionParameterComponent p) throws EOperationOutcome, FHIRException, IOException {
        XhtmlNode tr = tbl.tr();
        tr.td().addText(p.getUse().toString());
        tr.td().addText(path + p.getName());
        tr.td().addText(Integer.toString(p.getMin()) + ".." + p.getMax());
        XhtmlNode td = tr.td();
        StructureDefinition sd = this.context.fetchTypeDefinition(p.getType());
        if (sd == null) {
            td.tx(p.hasType() ? p.getType() : "");
        } else if (sd.getAbstract() && p.hasExtension("http://hl7.org/fhir/StructureDefinition/operationdefinition-allowed-type")) {
            boolean first = true;
            for (Extension ex : p.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/operationdefinition-allowed-type")) {
                if (first) {
                    first = false;
                } else {
                    td.tx(" | ");
                }
                String s = ex.getValue().primitiveValue();
                StructureDefinition sdt = this.context.fetchTypeDefinition(s);
                if (sdt == null) {
                    td.tx(p.hasType() ? p.getType() : "");
                    continue;
                }
                td.ah(sdt.getUserString("path")).tx(s);
            }
        } else {
            td.ah(sd.getUserString("path")).tx(p.hasType() ? p.getType() : "");
        }
        if (p.hasSearchType()) {
            td.br();
            td.tx("(");
            td.ah((String)(this.corePath == null ? "search.html#" + p.getSearchType().toCode() : Utilities.pathURL((String[])new String[]{this.corePath, "search.html#" + p.getSearchType().toCode()}))).tx(p.getSearchType().toCode());
            td.tx(")");
        }
        td = tr.td();
        if (p.hasBinding() && p.getBinding().hasValueSet()) {
            this.AddVsRef(rcontext, p.getBinding().getValueSet(), td);
            td.tx(" (" + p.getBinding().getStrength().getDisplay() + ")");
        }
        this.addMarkdown(tr.td(), p.getDocumentation());
        if (!p.hasType()) {
            for (OperationDefinition.OperationDefinitionParameterComponent pp : p.getPart()) {
                this.genOpParam(rcontext, tbl, path + p.getName() + ".", pp);
            }
        }
    }

    private void addMarkdown(XhtmlNode x, String text) throws FHIRFormatError, IOException, DefinitionException {
        if (text != null) {
            XhtmlDocument m;
            while (((String)text).contains("[[[")) {
                String left = ((String)text).substring(0, ((String)text).indexOf("[[["));
                String link = ((String)text).substring(((String)text).indexOf("[[[") + 3, ((String)text).indexOf("]]]"));
                String right = ((String)text).substring(((String)text).indexOf("]]]") + 3);
                String url = link;
                String[] parts = link.split("\\#");
                StructureDefinition p = this.context.fetchResource(StructureDefinition.class, parts[0]);
                if (p == null) {
                    p = this.context.fetchTypeDefinition(parts[0]);
                }
                if (p == null) {
                    p = this.context.fetchResource(StructureDefinition.class, link);
                }
                if (p != null) {
                    url = p.getUserString("path");
                    if (url == null) {
                        url = p.getUserString("filename");
                    }
                } else {
                    throw new DefinitionException("Unable to resolve markdown link " + link);
                }
                text = left + "[" + link + "](" + url + ")" + right;
            }
            String s = this.markdown.process(Utilities.escapeXml((String)text), "narrative generator");
            XhtmlParser p = new XhtmlParser();
            try {
                m = p.parse("<div>" + s + "</div>", "div");
            }
            catch (FHIRFormatError e) {
                throw new FHIRFormatError(e.getMessage(), (Throwable)e);
            }
            x.getChildNodes().addAll((Collection)m.getChildNodes());
        }
    }

    public boolean generate(ResourceContext rcontext, CompartmentDefinition cpd) {
        StringBuilder in = new StringBuilder();
        StringBuilder out = new StringBuilder();
        for (CompartmentDefinition.CompartmentDefinitionResourceComponent cc : cpd.getResource()) {
            CommaSeparatedStringBuilder rules = new CommaSeparatedStringBuilder();
            if (!cc.hasParam()) {
                out.append(" <li><a href=\"").append(cc.getCode().toLowerCase()).append(".html\">").append(cc.getCode()).append("</a></li>\r\n");
                continue;
            }
            if (rules.equals("{def}")) continue;
            for (StringType p : cc.getParam()) {
                rules.append(p.asStringValue());
            }
            in.append(" <tr><td><a href=\"").append(cc.getCode().toLowerCase()).append(".html\">").append(cc.getCode()).append("</a></td><td>").append(rules.toString()).append("</td></tr>\r\n");
        }
        try {
            XhtmlNode x = new XhtmlParser().parseFragment("<div><p>\r\nThe following resources may be in this compartment:\r\n</p>\r\n<table class=\"grid\">\r\n <tr><td><b>Resource</b></td><td><b>Inclusion Criteria</b></td></tr>\r\n" + in.toString() + "</table>\r\n<p>\r\nA resource is in this compartment if the nominated search parameter (or chain) refers to the patient resource that defines the compartment.\r\n</p>\r\n<p>\r\n\r\n</p>\r\n<p>\r\nThe following resources are never in this compartment:\r\n</p>\r\n<ul>\r\n" + out.toString() + "</ul></div>\r\n");
            this.inject(cpd, x, Narrative.NarrativeStatus.GENERATED);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean generate(ResourceContext rcontext, CapabilityStatement conf) throws FHIRFormatError, DefinitionException, IOException {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        x.h2().addText(conf.getName());
        this.addMarkdown(x, conf.getDescription());
        if (conf.getRest().size() > 0) {
            CapabilityStatement.CapabilityStatementRestComponent rest = conf.getRest().get(0);
            XhtmlNode t = x.table(null);
            this.addTableRow(t, "Mode", rest.getMode().toString());
            this.addTableRow(t, "Description", rest.getDocumentation());
            this.addTableRow(t, "Transaction", this.showOp(rest, CapabilityStatement.SystemRestfulInteraction.TRANSACTION));
            this.addTableRow(t, "System History", this.showOp(rest, CapabilityStatement.SystemRestfulInteraction.HISTORYSYSTEM));
            this.addTableRow(t, "System Search", this.showOp(rest, CapabilityStatement.SystemRestfulInteraction.SEARCHSYSTEM));
            boolean hasVRead = false;
            boolean hasPatch = false;
            boolean hasDelete = false;
            boolean hasHistory = false;
            boolean hasUpdates = false;
            for (CapabilityStatement.CapabilityStatementRestResourceComponent r : rest.getResource()) {
                hasVRead = hasVRead || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.VREAD);
                hasPatch = hasPatch || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.PATCH);
                hasDelete = hasDelete || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.DELETE);
                hasHistory = hasHistory || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE);
                hasUpdates = hasUpdates || this.hasOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE);
            }
            t = x.table(null);
            XhtmlNode tr = t.tr();
            tr.th().b().tx("Resource Type");
            tr.th().b().tx("Profile");
            tr.th().b().attribute("title", "GET a resource (read interaction)").tx("Read");
            if (hasVRead) {
                tr.th().b().attribute("title", "GET past versions of resources (vread interaction)").tx("V-Read");
            }
            tr.th().b().attribute("title", "GET all set of resources of the type (search interaction)").tx("Search");
            tr.th().b().attribute("title", "PUT a new resource version (update interaction)").tx("Update");
            if (hasPatch) {
                tr.th().b().attribute("title", "PATCH a new resource version (patch interaction)").tx("Patch");
            }
            tr.th().b().attribute("title", "POST a new resource (create interaction)").tx("Create");
            if (hasDelete) {
                tr.th().b().attribute("title", "DELETE a resource (delete interaction)").tx("Delete");
            }
            if (hasUpdates) {
                tr.th().b().attribute("title", "GET changes to a resource (history interaction on instance)").tx("Updates");
            }
            if (hasHistory) {
                tr.th().b().attribute("title", "GET changes for all resources of the type (history interaction on type)").tx("History");
            }
            for (CapabilityStatement.CapabilityStatementRestResourceComponent r : rest.getResource()) {
                tr = t.tr();
                tr.td().addText(r.getType());
                if (r.hasProfile()) {
                    tr.td().ah(this.prefix + r.getProfile()).addText(r.getProfile());
                }
                tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.READ));
                if (hasVRead) {
                    tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.VREAD));
                }
                tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE));
                tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.UPDATE));
                if (hasPatch) {
                    tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.PATCH));
                }
                tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.CREATE));
                if (hasDelete) {
                    tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.DELETE));
                }
                if (hasUpdates) {
                    tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE));
                }
                if (!hasHistory) continue;
                tr.td().addText(this.showOp(r, CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE));
            }
        }
        this.inject(conf, x, Narrative.NarrativeStatus.GENERATED);
        return true;
    }

    private boolean hasOp(CapabilityStatement.CapabilityStatementRestResourceComponent r, CapabilityStatement.TypeRestfulInteraction on) {
        for (CapabilityStatement.ResourceInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return true;
        }
        return false;
    }

    private String showOp(CapabilityStatement.CapabilityStatementRestResourceComponent r, CapabilityStatement.TypeRestfulInteraction on) {
        for (CapabilityStatement.ResourceInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return "y";
        }
        return "";
    }

    private String showOp(CapabilityStatement.CapabilityStatementRestComponent r, CapabilityStatement.SystemRestfulInteraction on) {
        for (CapabilityStatement.SystemInteractionComponent op : r.getInteraction()) {
            if (op.getCode() != on) continue;
            return "y";
        }
        return "";
    }

    private void addTableRow(XhtmlNode t, String name, String value) {
        XhtmlNode tr = t.tr();
        tr.td().addText(name);
        tr.td().addText(value);
    }

    public XhtmlNode generateDocumentNarrative(Bundle feed) {
        XhtmlNode root = new XhtmlNode(NodeType.Element, "div");
        Composition comp = (Composition)feed.getEntry().get(0).getResource();
        root.getChildNodes().add(comp.getText().getDiv());
        Resource subject = ResourceUtilities.getById(feed, null, comp.getSubject().getReference());
        if (subject != null && subject instanceof DomainResource) {
            root.hr();
            root.getChildNodes().add(((DomainResource)subject).getText().getDiv());
        }
        List<Composition.SectionComponent> sections = comp.getSection();
        this.renderSections(feed, root, sections, 1);
        return root;
    }

    private void renderSections(Bundle feed, XhtmlNode node, List<Composition.SectionComponent> sections, int level) {
        for (Composition.SectionComponent section : sections) {
            node.hr();
            if (!section.hasTitleElement()) continue;
            node.addTag("h" + Integer.toString(level)).addText(section.getTitle());
        }
    }

    public XhtmlNode generateDiagnosticReport(ResourceWrapper dr) {
        XhtmlNode root = new XhtmlNode(NodeType.Element, "div");
        XhtmlNode h2 = root.h2();
        this.displayCodeableConcept(h2, this.getProperty(dr, "code").value());
        h2.tx(" ");
        PropertyWrapper pw = this.getProperty(dr, "category");
        if (this.valued(pw)) {
            h2.tx("(");
            this.displayCodeableConcept(h2, pw.value());
            h2.tx(") ");
        }
        this.displayDate(h2, this.getProperty(dr, "issued").value());
        XhtmlNode tbl = root.table("grid");
        XhtmlNode tr = tbl.tr();
        XhtmlNode tdl = tr.td();
        XhtmlNode tdr = tr.td();
        this.populateSubjectSummary(tdl, this.getProperty(dr, "subject").value());
        tdr.b().tx("Report Details");
        tdr.br();
        pw = this.getProperty(dr, "perfomer");
        if (this.valued(pw)) {
            tdr.addText(this.pluralise("Performer", pw.getValues().size()) + ":");
            for (BaseWrapper v : pw.getValues()) {
                tdr.tx(" ");
                this.displayReference(tdr, v);
            }
            tdr.br();
        }
        if (this.valued(pw = this.getProperty(dr, "identifier"))) {
            tdr.addText(this.pluralise("Identifier", pw.getValues().size()) + ":");
            for (BaseWrapper v : pw.getValues()) {
                tdr.tx(" ");
                this.displayIdentifier(tdr, v);
            }
            tdr.br();
        }
        if (this.valued(pw = this.getProperty(dr, "request"))) {
            tdr.addText(this.pluralise("Request", pw.getValues().size()) + ":");
            for (BaseWrapper v : pw.getValues()) {
                tdr.tx(" ");
                this.displayReferenceId(tdr, v);
            }
            tdr.br();
        }
        if (this.valued(pw = this.getProperty(dr, "result"))) {
            List<ObservationNode> observations = this.fetchObservations(pw.getValues());
            this.buildObservationsTable(root, observations);
        }
        if (this.valued(pw = this.getProperty(dr, "conclusion"))) {
            this.displayText(root.para(), pw.value());
        }
        if (this.valued(pw = this.getProperty(dr, "result"))) {
            XhtmlNode p = root.para();
            p.b().tx("Coded Diagnoses :");
            for (BaseWrapper v : pw.getValues()) {
                tdr.tx(" ");
                this.displayCodeableConcept(tdr, v);
            }
        }
        return root;
    }

    private void buildObservationsTable(XhtmlNode root, List<ObservationNode> observations) {
        XhtmlNode tbl = root.table("none");
        for (ObservationNode o : observations) {
            this.addObservationToTable(tbl, o, 0);
        }
    }

    private void addObservationToTable(XhtmlNode tbl, ObservationNode o, int i) {
        XhtmlNode tr = tbl.tr();
        if (o.obs == null) {
            XhtmlNode td = tr.td().colspan("6");
            td.i().tx("This Observation could not be resolved");
        } else {
            this.addObservationToTable(tr, o.obs, i);
        }
        for (ObservationNode c : o.contained) {
            this.addObservationToTable(tbl, c, i + 1);
        }
    }

    private void addObservationToTable(XhtmlNode tr, ResourceWrapper obs, int i) {
        XhtmlNode td = tr.td();
        PropertyWrapper pw = this.getProperty(obs, "result");
        if (this.valued(pw)) {
            this.displayCodeableConcept(td, pw.value());
        }
        if (this.valued(pw = this.getProperty(obs, "bodySite"))) {
            td.tx(" (");
            this.displayCodeableConcept(td, pw.value());
            td.tx(")");
        }
        td = tr.td();
        pw = this.getProperty(obs, "value[x]");
        if (this.valued(pw)) {
            if (pw.getTypeCode().equals("CodeableConcept")) {
                this.displayCodeableConcept(td, pw.value());
            } else if (pw.getTypeCode().equals("string")) {
                this.displayText(td, pw.value());
            } else {
                td.addText(pw.getTypeCode() + " not rendered yet");
            }
        }
        td = tr.td();
        td.tx("to do");
        td = tr.td();
        td.tx("to do");
        td = tr.td();
        td.tx("to do");
        td = tr.td();
        td.tx("to do");
    }

    private boolean valued(PropertyWrapper pw) {
        return pw != null && pw.hasValues();
    }

    private void displayText(XhtmlNode c, BaseWrapper v) {
        c.addText(v.toString());
    }

    private String pluralise(String name, int size) {
        return size == 1 ? name : name + "s";
    }

    private void displayIdentifier(XhtmlNode c, BaseWrapper v) {
        String hint = "";
        PropertyWrapper pw = v.getChildByName("type");
        if (this.valued(pw)) {
            hint = this.genCC(pw.value());
        } else {
            pw = v.getChildByName("system");
            if (this.valued(pw)) {
                hint = pw.value().toString();
            }
        }
        this.displayText(c.span(null, hint), v.getChildByName("value").value());
    }

    private String genCoding(BaseWrapper value) {
        PropertyWrapper pw = value.getChildByName("display");
        if (this.valued(pw)) {
            return pw.value().toString();
        }
        pw = value.getChildByName("code");
        if (this.valued(pw)) {
            return pw.value().toString();
        }
        return "";
    }

    private String genCC(BaseWrapper value) {
        PropertyWrapper pw = value.getChildByName("text");
        if (this.valued(pw)) {
            return pw.value().toString();
        }
        pw = value.getChildByName("coding");
        if (this.valued(pw)) {
            return this.genCoding(pw.getValues().get(0));
        }
        return "";
    }

    private void displayReference(XhtmlNode c, BaseWrapper v) {
        c.tx("to do");
    }

    private void displayDate(XhtmlNode c, BaseWrapper baseWrapper) {
        c.tx("to do");
    }

    private void displayCodeableConcept(XhtmlNode c, BaseWrapper property) {
        c.tx("to do");
    }

    private void displayReferenceId(XhtmlNode c, BaseWrapper v) {
        c.tx("to do");
    }

    private PropertyWrapper getProperty(ResourceWrapper res, String name) {
        for (PropertyWrapper t : res.children()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    private void populateSubjectSummary(XhtmlNode container, BaseWrapper subject) {
        ResourceWrapper r = this.fetchResource(subject);
        if (r == null) {
            container.tx("Unable to get Patient Details");
        } else if (r.getName().equals("Patient")) {
            this.generatePatientSummary(container, r);
        } else {
            container.tx("Not done yet");
        }
    }

    private void generatePatientSummary(XhtmlNode c, ResourceWrapper r) {
        c.tx("to do");
    }

    private ResourceWrapper fetchResource(BaseWrapper subject) {
        if (this.resolver == null) {
            return null;
        }
        String url = subject.getChildByName("reference").value().toString();
        ResourceWithReference rr = this.resolver.resolve(url);
        return rr == null ? null : rr.resource;
    }

    private List<ObservationNode> fetchObservations(List<BaseWrapper> list) {
        return new ArrayList<ObservationNode>();
    }

    public XhtmlNode renderBundle(Bundle b) throws FHIRException {
        if (b.getType() == Bundle.BundleType.DOCUMENT) {
            if (!(b.hasEntry() && b.getEntryFirstRep().hasResource() && b.getEntryFirstRep().getResource() instanceof Composition)) {
                throw new FHIRException("Invalid document - first entry is not a Composition");
            }
            Composition dr = (Composition)b.getEntryFirstRep().getResource();
            return dr.getText().getDiv();
        }
        XhtmlNode root = new XhtmlNode(NodeType.Element, "div");
        root.para().addText("Bundle " + b.getId() + " of type " + b.getType().toCode());
        int i = 0;
        for (Bundle.BundleEntryComponent be : b.getEntry()) {
            DomainResource dr;
            ++i;
            if (be.hasResource() && be.getResource().hasId()) {
                root.an(be.getResource().getResourceType().name().toLowerCase() + "_" + be.getResource().getId());
            }
            root.hr();
            root.para().addText("Entry " + Integer.toString(i) + (String)(be.hasFullUrl() ? " - Full URL = " + be.getFullUrl() : ""));
            if (be.hasRequest()) {
                this.renderRequest(root, be.getRequest());
            }
            if (be.hasSearch()) {
                this.renderSearch(root, be.getSearch());
            }
            if (be.hasResponse()) {
                this.renderResponse(root, be.getResponse());
            }
            if (!be.hasResource()) continue;
            root.para().addText("Resource " + be.getResource().fhirType() + ":");
            if (!be.hasResource() || !(be.getResource() instanceof DomainResource) || !(dr = (DomainResource)be.getResource()).getText().hasDiv()) continue;
            root.blockquote().getChildNodes().addAll((Collection)dr.getText().getDiv().getChildNodes());
        }
        return root;
    }

    private void renderSearch(XhtmlNode root, Bundle.BundleEntrySearchComponent search) {
        StringBuilder b = new StringBuilder();
        b.append("Search: ");
        if (search.hasMode()) {
            b.append("mode = " + search.getMode().toCode());
        }
        if (search.hasScore()) {
            if (search.hasMode()) {
                b.append(",");
            }
            b.append("score = " + search.getScore());
        }
        root.para().addText(b.toString());
    }

    private void renderResponse(XhtmlNode root, Bundle.BundleEntryResponseComponent response) {
        root.para().addText("Request:");
        StringBuilder b = new StringBuilder();
        b.append(response.getStatus() + "\r\n");
        if (response.hasLocation()) {
            b.append("Location: " + response.getLocation() + "\r\n");
        }
        if (response.hasEtag()) {
            b.append("E-Tag: " + response.getEtag() + "\r\n");
        }
        if (response.hasLastModified()) {
            b.append("LastModified: " + response.getEtag() + "\r\n");
        }
        root.pre().addText(b.toString());
    }

    private void renderRequest(XhtmlNode root, Bundle.BundleEntryRequestComponent request) {
        root.para().addText("Response:");
        StringBuilder b = new StringBuilder();
        b.append(request.getMethod() + " " + request.getUrl() + "\r\n");
        if (request.hasIfNoneMatch()) {
            b.append("If-None-Match: " + request.getIfNoneMatch() + "\r\n");
        }
        if (request.hasIfModifiedSince()) {
            b.append("If-Modified-Since: " + request.getIfModifiedSince() + "\r\n");
        }
        if (request.hasIfMatch()) {
            b.append("If-Match: " + request.getIfMatch() + "\r\n");
        }
        if (request.hasIfNoneExist()) {
            b.append("If-None-Exist: " + request.getIfNoneExist() + "\r\n");
        }
        root.pre().addText(b.toString());
    }

    public XhtmlNode renderBundle(org.hl7.fhir.r4.elementmodel.Element element) throws FHIRException {
        XhtmlNode root = new XhtmlNode(NodeType.Element, "div");
        for (Base b : element.listChildrenByName("entry")) {
            org.hl7.fhir.r4.elementmodel.Element r = ((org.hl7.fhir.r4.elementmodel.Element)b).getNamedChild("resource");
            if (r == null) continue;
            XhtmlNode c = this.getHtmlForResource(r);
            if (c != null) {
                root.getChildNodes().addAll((Collection)c.getChildNodes());
            }
            root.hr();
        }
        return root;
    }

    private XhtmlNode getHtmlForResource(org.hl7.fhir.r4.elementmodel.Element element) {
        org.hl7.fhir.r4.elementmodel.Element text = element.getNamedChild("text");
        if (text == null) {
            return null;
        }
        org.hl7.fhir.r4.elementmodel.Element div = text.getNamedChild("div");
        if (div == null) {
            return null;
        }
        return div.getXhtml();
    }

    public String getDefinitionsTarget() {
        return this.definitionsTarget;
    }

    public void setDefinitionsTarget(String definitionsTarget) {
        this.definitionsTarget = definitionsTarget;
    }

    public String getCorePath() {
        return this.corePath;
    }

    public void setCorePath(String corePath) {
        this.corePath = corePath;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public ProfileUtilities.ProfileKnowledgeProvider getPkp() {
        return this.pkp;
    }

    public NarrativeGenerator setPkp(ProfileUtilities.ProfileKnowledgeProvider pkp) {
        this.pkp = pkp;
        return this;
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public NarrativeGenerator setPretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    public boolean isCanonicalUrlsAsLinks() {
        return this.canonicalUrlsAsLinks;
    }

    @Override
    public void setCanonicalUrlsAsLinks(boolean canonicalUrlsAsLinks) {
        this.canonicalUrlsAsLinks = canonicalUrlsAsLinks;
    }

    public String getSnomedEdition() {
        return this.snomedEdition;
    }

    public NarrativeGenerator setSnomedEdition(String snomedEdition) {
        this.snomedEdition = snomedEdition;
        return this;
    }

    public TerminologyServiceOptions getTerminologyServiceOptions() {
        return this.terminologyServiceOptions;
    }

    public void setTerminologyServiceOptions(TerminologyServiceOptions terminologyServiceOptions) {
        this.terminologyServiceOptions = terminologyServiceOptions;
    }

    public class ObservationNode {
        private String ref;
        private ResourceWrapper obs;
        private List<ObservationNode> contained = new ArrayList<ObservationNode>();
    }

    private class TargetElementComponentWrapper {
        private ConceptMap.ConceptMapGroupComponent group;
        private ConceptMap.TargetElementComponent comp;

        public TargetElementComponentWrapper(ConceptMap.ConceptMapGroupComponent group, ConceptMap.TargetElementComponent comp) {
            this.group = group;
            this.comp = comp;
        }
    }

    public static class ResourceWithReference {
        private String reference;
        private ResourceWrapper resource;

        public ResourceWithReference(String reference, ResourceWrapper resource) {
            this.reference = reference;
            this.resource = resource;
        }

        public String getReference() {
            return this.reference;
        }

        public ResourceWrapper getResource() {
            return this.resource;
        }
    }

    public class ResourceWrapperDirect
    implements ResourceWrapper {
        private Resource wrapped;

        public ResourceWrapperDirect(Resource wrapped) {
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
        }

        @Override
        public List<ResourceWrapper> getContained() {
            ArrayList<ResourceWrapper> list = new ArrayList<ResourceWrapper>();
            if (this.wrapped instanceof DomainResource) {
                DomainResource dr = (DomainResource)this.wrapped;
                for (Resource c : dr.getContained()) {
                    list.add(new ResourceWrapperDirect(c));
                }
            }
            return list;
        }

        @Override
        public String getId() {
            return this.wrapped.getId();
        }

        @Override
        public XhtmlNode getNarrative() {
            DomainResource dr;
            if (this.wrapped instanceof DomainResource && (dr = (DomainResource)this.wrapped).hasText() && dr.getText().hasDiv()) {
                return dr.getText().getDiv();
            }
            return null;
        }

        @Override
        public String getName() {
            return this.wrapped.getResourceType().toString();
        }

        @Override
        public List<PropertyWrapper> children() {
            ArrayList<PropertyWrapper> list = new ArrayList<PropertyWrapper>();
            for (Property c : this.wrapped.children()) {
                list.add(new PropertyWrapperDirect(c));
            }
            return list;
        }
    }

    private class BaseWrapperDirect
    implements BaseWrapper {
        private Base wrapped;
        private List<PropertyWrapper> list;

        private BaseWrapperDirect(Base wrapped) {
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
        }

        @Override
        public Base getBase() {
            return this.wrapped;
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list == null) {
                this.list = new ArrayList<PropertyWrapper>();
                for (Property p : this.wrapped.children()) {
                    this.list.add(new PropertyWrapperDirect(p));
                }
            }
            return this.list;
        }

        @Override
        public PropertyWrapper getChildByName(String name) {
            Property p = this.wrapped.getChildByName(name);
            if (p == null) {
                return null;
            }
            return new PropertyWrapperDirect(p);
        }
    }

    private class PropertyWrapperDirect
    implements PropertyWrapper {
        private Property wrapped;
        private List<BaseWrapper> list;

        private PropertyWrapperDirect(Property wrapped) {
            if (wrapped == null) {
                throw new Error("wrapped == null");
            }
            this.wrapped = wrapped;
        }

        @Override
        public String getName() {
            return this.wrapped.getName();
        }

        @Override
        public boolean hasValues() {
            return this.wrapped.hasValues();
        }

        @Override
        public List<BaseWrapper> getValues() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrapper>();
                for (Base b : this.wrapped.getValues()) {
                    this.list.add(b == null ? null : new BaseWrapperDirect(b));
                }
            }
            return this.list;
        }

        @Override
        public String getTypeCode() {
            return this.wrapped.getTypeCode();
        }

        @Override
        public String getDefinition() {
            return this.wrapped.getDefinition();
        }

        @Override
        public int getMinCardinality() {
            return this.wrapped.getMinCardinality();
        }

        @Override
        public int getMaxCardinality() {
            return this.wrapped.getMinCardinality();
        }

        @Override
        public StructureDefinition getStructure() {
            return this.wrapped.getStructure();
        }

        @Override
        public BaseWrapper value() {
            if (this.getValues().size() != 1) {
                throw new Error("Access single value, but value count is " + this.getValues().size());
            }
            return this.getValues().get(0);
        }

        public String toString() {
            return "#." + this.wrapped.toString();
        }
    }

    private class ResourceWrapperElement
    implements ResourceWrapper {
        private Element wrapped;
        private StructureDefinition definition;
        private List<ResourceWrapper> list;
        private List<PropertyWrapper> list2;

        public ResourceWrapperElement(Element wrapped, StructureDefinition definition) {
            this.wrapped = wrapped;
            this.definition = definition;
        }

        @Override
        public List<ResourceWrapper> getContained() {
            if (this.list == null) {
                ArrayList children = new ArrayList();
                XMLUtil.getNamedChildren((Element)this.wrapped, (String)"contained", children);
                this.list = new ArrayList<ResourceWrapper>();
                for (Element e : children) {
                    Element c = XMLUtil.getFirstChild((Element)e);
                    this.list.add(new ResourceWrapperElement(c, NarrativeGenerator.this.context.fetchTypeDefinition(c.getNodeName())));
                }
            }
            return this.list;
        }

        @Override
        public String getId() {
            return XMLUtil.getNamedChildValue((Element)this.wrapped, (String)"id");
        }

        @Override
        public XhtmlNode getNarrative() throws FHIRFormatError, IOException, FHIRException {
            Element txt = XMLUtil.getNamedChild((Element)this.wrapped, (String)"text");
            if (txt == null) {
                return null;
            }
            Element div = XMLUtil.getNamedChild((Element)txt, (String)"div");
            if (div == null) {
                return null;
            }
            try {
                return new XhtmlParser().parse(new XmlGenerator().generate(div), "div");
            }
            catch (FHIRFormatError e) {
                throw new FHIRFormatError(e.getMessage(), (Throwable)e);
            }
            catch (FHIRException e) {
                throw new FHIRException(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public String getName() {
            return this.wrapped.getNodeName();
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list2 == null) {
                List<ElementDefinition> children = ProfileUtilities.getChildList(this.definition, this.definition.getSnapshot().getElement().get(0));
                this.list2 = new ArrayList<PropertyWrapper>();
                for (ElementDefinition child : children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    XMLUtil.getNamedChildrenWithWildcard((Element)this.wrapped, (String)NarrativeGenerator.this.tail(child.getPath()), elements);
                    this.list2.add(new PropertyWrapperElement(this.definition, child, elements));
                }
            }
            return this.list2;
        }
    }

    private class PropertyWrapperMetaElement
    implements PropertyWrapper {
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<org.hl7.fhir.r4.elementmodel.Element> values;
        private List<BaseWrapper> list;

        public PropertyWrapperMetaElement(StructureDefinition structure, ElementDefinition definition, List<org.hl7.fhir.r4.elementmodel.Element> values) {
            this.structure = structure;
            this.definition = definition;
            this.values = values;
        }

        @Override
        public String getName() {
            return NarrativeGenerator.this.tail(this.definition.getPath());
        }

        @Override
        public boolean hasValues() {
            return this.values.size() > 0;
        }

        @Override
        public List<BaseWrapper> getValues() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrapper>();
                for (org.hl7.fhir.r4.elementmodel.Element e : this.values) {
                    this.list.add(new BaseWrapperMetaElement(e, e.fhirType(), this.structure, this.definition));
                }
            }
            return this.list;
        }

        @Override
        public String getTypeCode() {
            return this.definition.typeSummary();
        }

        @Override
        public String getDefinition() {
            return this.definition.getDefinition();
        }

        @Override
        public int getMinCardinality() {
            return this.definition.getMin();
        }

        @Override
        public int getMaxCardinality() {
            return "*".equals(this.definition.getMax()) ? Integer.MAX_VALUE : Integer.valueOf(this.definition.getMax());
        }

        @Override
        public StructureDefinition getStructure() {
            return this.structure;
        }

        @Override
        public BaseWrapper value() {
            if (this.getValues().size() != 1) {
                throw new Error("Access single value, but value count is " + this.getValues().size());
            }
            return this.getValues().get(0);
        }
    }

    public class ResourceWrapperMetaElement
    implements ResourceWrapper {
        private org.hl7.fhir.r4.elementmodel.Element wrapped;
        private List<ResourceWrapper> list;
        private List<PropertyWrapper> list2;
        private StructureDefinition definition;

        public ResourceWrapperMetaElement(org.hl7.fhir.r4.elementmodel.Element wrapped) {
            this.wrapped = wrapped;
            this.definition = wrapped.getProperty().getStructure();
        }

        @Override
        public List<ResourceWrapper> getContained() {
            if (this.list == null) {
                List<org.hl7.fhir.r4.elementmodel.Element> children = this.wrapped.getChildrenByName("contained");
                this.list = new ArrayList<ResourceWrapper>();
                for (org.hl7.fhir.r4.elementmodel.Element e : children) {
                    this.list.add(new ResourceWrapperMetaElement(e));
                }
            }
            return this.list;
        }

        @Override
        public String getId() {
            return this.wrapped.getNamedChildValue("id");
        }

        @Override
        public XhtmlNode getNarrative() throws IOException, FHIRException {
            org.hl7.fhir.r4.elementmodel.Element txt = this.wrapped.getNamedChild("text");
            if (txt == null) {
                return null;
            }
            org.hl7.fhir.r4.elementmodel.Element div = txt.getNamedChild("div");
            if (div == null) {
                return null;
            }
            return div.getXhtml();
        }

        @Override
        public String getName() {
            return this.wrapped.getName();
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list2 == null) {
                List<ElementDefinition> children = ProfileUtilities.getChildList(this.definition, this.definition.getSnapshot().getElement().get(0));
                this.list2 = new ArrayList<PropertyWrapper>();
                for (ElementDefinition child : children) {
                    ArrayList<org.hl7.fhir.r4.elementmodel.Element> elements = new ArrayList<org.hl7.fhir.r4.elementmodel.Element>();
                    if (child.getPath().endsWith("[x]")) {
                        this.wrapped.getNamedChildrenWithWildcard(NarrativeGenerator.this.tail(child.getPath()), elements);
                    } else {
                        this.wrapped.getNamedChildren(NarrativeGenerator.this.tail(child.getPath()), elements);
                    }
                    this.list2.add(new PropertyWrapperMetaElement(this.definition, child, elements));
                }
            }
            return this.list2;
        }
    }

    private class BaseWrapperMetaElement
    implements BaseWrapper {
        private org.hl7.fhir.r4.elementmodel.Element element;
        private String type;
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<ElementDefinition> children;
        private List<PropertyWrapper> list;

        public BaseWrapperMetaElement(org.hl7.fhir.r4.elementmodel.Element element, String type, StructureDefinition structure, ElementDefinition definition) {
            this.element = element;
            this.type = type;
            this.structure = structure;
            this.definition = definition;
        }

        @Override
        public Base getBase() throws UnsupportedEncodingException, IOException, FHIRException {
            if (this.type == null || this.type.equals("Resource") || this.type.equals("BackboneElement") || this.type.equals("Element")) {
                return null;
            }
            if (this.element.hasElementProperty()) {
                return null;
            }
            ByteArrayOutputStream xml = new ByteArrayOutputStream();
            try {
                new org.hl7.fhir.r4.elementmodel.XmlParser(NarrativeGenerator.this.context).compose(this.element, (OutputStream)xml, IParser.OutputStyle.PRETTY, null);
            }
            catch (Exception e) {
                throw new FHIRException(e.getMessage(), (Throwable)e);
            }
            return NarrativeGenerator.this.parseType(xml.toString(), this.type);
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list == null) {
                this.children = ProfileUtilities.getChildList(this.structure, this.definition);
                this.list = new ArrayList<PropertyWrapper>();
                for (ElementDefinition child : this.children) {
                    ArrayList<org.hl7.fhir.r4.elementmodel.Element> elements = new ArrayList<org.hl7.fhir.r4.elementmodel.Element>();
                    String name = NarrativeGenerator.this.tail(child.getPath());
                    if (name.endsWith("[x]")) {
                        this.element.getNamedChildrenWithWildcard(name, elements);
                    } else {
                        this.element.getNamedChildren(name, elements);
                    }
                    this.list.add(new PropertyWrapperMetaElement(this.structure, child, elements));
                }
            }
            return this.list;
        }

        @Override
        public PropertyWrapper getChildByName(String name) {
            for (PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
            return null;
        }
    }

    private class PropertyWrapperElement
    implements PropertyWrapper {
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<Element> values;
        private List<BaseWrapper> list;

        public PropertyWrapperElement(StructureDefinition structure, ElementDefinition definition, List<Element> values) {
            this.structure = structure;
            this.definition = definition;
            this.values = values;
        }

        @Override
        public String getName() {
            return NarrativeGenerator.this.tail(this.definition.getPath());
        }

        @Override
        public boolean hasValues() {
            return this.values.size() > 0;
        }

        @Override
        public List<BaseWrapper> getValues() {
            if (this.list == null) {
                this.list = new ArrayList<BaseWrapper>();
                for (Element e : this.values) {
                    this.list.add(new BaseWrapperElement(e, this.determineType(e), this.structure, this.definition));
                }
            }
            return this.list;
        }

        private String determineType(Element e) {
            if (this.definition.getType().isEmpty()) {
                return null;
            }
            if (this.definition.getType().size() == 1) {
                if (this.definition.getType().get(0).getWorkingCode().equals("Element") || this.definition.getType().get(0).getWorkingCode().equals("BackboneElement")) {
                    return null;
                }
                return this.definition.getType().get(0).getWorkingCode();
            }
            String t = e.getNodeName().substring(NarrativeGenerator.this.tail(this.definition.getPath()).length() - 3);
            if (this.isPrimitive(Utilities.uncapitalize((String)t))) {
                return Utilities.uncapitalize((String)t);
            }
            return t;
        }

        private boolean isPrimitive(String code) {
            StructureDefinition sd = NarrativeGenerator.this.context.fetchTypeDefinition(code);
            return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
        }

        @Override
        public String getTypeCode() {
            if (this.definition == null || this.definition.getType().size() != 1) {
                throw new Error("not handled");
            }
            return this.definition.getType().get(0).getWorkingCode();
        }

        @Override
        public String getDefinition() {
            if (this.definition == null) {
                throw new Error("not handled");
            }
            return this.definition.getDefinition();
        }

        @Override
        public int getMinCardinality() {
            if (this.definition == null) {
                throw new Error("not handled");
            }
            return this.definition.getMin();
        }

        @Override
        public int getMaxCardinality() {
            if (this.definition == null) {
                throw new Error("not handled");
            }
            return this.definition.getMax().equals("*") ? Integer.MAX_VALUE : Integer.parseInt(this.definition.getMax());
        }

        @Override
        public StructureDefinition getStructure() {
            return this.structure;
        }

        @Override
        public BaseWrapper value() {
            if (this.getValues().size() != 1) {
                throw new Error("Access single value, but value count is " + this.getValues().size());
            }
            return this.getValues().get(0);
        }
    }

    private class BaseWrapperElement
    implements BaseWrapper {
        private Element element;
        private String type;
        private StructureDefinition structure;
        private ElementDefinition definition;
        private List<ElementDefinition> children;
        private List<PropertyWrapper> list;

        public BaseWrapperElement(Element element, String type, StructureDefinition structure, ElementDefinition definition) {
            this.element = element;
            this.type = type;
            this.structure = structure;
            this.definition = definition;
        }

        @Override
        public Base getBase() throws UnsupportedEncodingException, IOException, FHIRException {
            String xml;
            if (this.type == null || this.type.equals("Resource") || this.type.equals("BackboneElement") || this.type.equals("Element")) {
                return null;
            }
            try {
                xml = new XmlGenerator().generate(this.element);
            }
            catch (FHIRException e) {
                throw new FHIRException(e.getMessage(), (Throwable)e);
            }
            return NarrativeGenerator.this.parseType(xml, this.type);
        }

        @Override
        public List<PropertyWrapper> children() {
            if (this.list == null) {
                this.children = ProfileUtilities.getChildList(this.structure, this.definition);
                this.list = new ArrayList<PropertyWrapper>();
                for (ElementDefinition child : this.children) {
                    ArrayList<Element> elements = new ArrayList<Element>();
                    XMLUtil.getNamedChildrenWithWildcard((Element)this.element, (String)NarrativeGenerator.this.tail(child.getPath()), elements);
                    this.list.add(new PropertyWrapperElement(this.structure, child, elements));
                }
            }
            return this.list;
        }

        @Override
        public PropertyWrapper getChildByName(String name) {
            for (PropertyWrapper p : this.children()) {
                if (!p.getName().equals(name)) continue;
                return p;
            }
            return null;
        }
    }

    private static interface BaseWrapper {
        public Base getBase() throws UnsupportedEncodingException, IOException, FHIRException;

        public List<PropertyWrapper> children();

        public PropertyWrapper getChildByName(String var1);
    }

    private static interface ResourceWrapper {
        public List<ResourceWrapper> getContained();

        public String getId();

        public XhtmlNode getNarrative() throws FHIRFormatError, IOException, FHIRException;

        public String getName();

        public List<PropertyWrapper> children();
    }

    private static interface PropertyWrapper {
        public String getName();

        public boolean hasValues();

        public List<BaseWrapper> getValues();

        public String getTypeCode();

        public String getDefinition();

        public int getMinCardinality();

        public int getMaxCardinality();

        public StructureDefinition getStructure();

        public BaseWrapper value();
    }

    public static interface IReferenceResolver {
        public ResourceWithReference resolve(String var1);
    }

    public static class ResourceContext {
        Bundle bundleResource;
        DomainResource resourceResource;

        public ResourceContext(Bundle bundle, DomainResource dr) {
            this.bundleResource = bundle;
            this.resourceResource = dr;
        }

        public ResourceContext(Element bundle, Element doc) {
        }

        public ResourceContext(org.hl7.fhir.r4.elementmodel.Element bundle, org.hl7.fhir.r4.elementmodel.Element er) {
        }

        public Resource resolve(String value) {
            if (value.startsWith("#")) {
                for (Resource r : this.resourceResource.getContained()) {
                    if (!r.getId().equals(value.substring(1))) continue;
                    return r;
                }
                return null;
            }
            if (this.bundleResource != null) {
                for (Bundle.BundleEntryComponent be : this.bundleResource.getEntry()) {
                    if (be.getFullUrl().equals(value)) {
                        return be.getResource();
                    }
                    if (!value.equals(be.getResource().fhirType() + "/" + be.getResource().getId())) continue;
                    return be.getResource();
                }
            }
            return null;
        }
    }

    public class UsedConceptMap {
        private ConceptMapRenderInstructions details;
        private String link;
        private ConceptMap map;

        public UsedConceptMap(ConceptMapRenderInstructions details, String link, ConceptMap map) {
            this.details = details;
            this.link = link;
            this.map = map;
        }

        public ConceptMapRenderInstructions getDetails() {
            return this.details;
        }

        public ConceptMap getMap() {
            return this.map;
        }

        public String getLink() {
            return this.link;
        }
    }

    public class ConceptMapRenderInstructions {
        private String name;
        private String url;
        private boolean doDescription;

        public ConceptMapRenderInstructions(String name, String url, boolean doDescription) {
            this.name = name;
            this.url = url;
            this.doDescription = doDescription;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isDoDescription() {
            return this.doDescription;
        }
    }

    public static interface ITypeParser {
        public Base parseType(String var1, String var2) throws FHIRFormatError, IOException, FHIRException;
    }

    public static interface ILiquidTemplateProvider {
        public String findTemplate(ResourceContext var1, DomainResource var2);
    }
}

