package org.hl7.fhir.r4b.formats;


// generated

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, \
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this \
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, \
     this list of conditions and the following disclaimer in the documentation \
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND \
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED \
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. \
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, \
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT \
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR \
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, \
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) \
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE \
  POSSIBILITY OF SUCH DAMAGE.
  */

// Generated on Wed, Dec 29, 2021 07:58+1100 for FHIR v4.3.0-snapshot1



import org.hl7.fhir.r4b.model.*;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.turtle.Turtle.*;
import java.io.IOException;

public class RdfParser extends RdfParserBase {

  public RdfParser() {
    super();
  }

  public RdfParser(boolean allowUnknownContent) {
    super();
    setAllowUnknownContent(allowUnknownContent);
  }

  private void composeEnum(Complex parent, String parentType, String name, Enumeration<? extends Enum> value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
    decorateCode(t, value);
  }


  protected void composeDate(Complex parent, String parentType, String name, DateType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeDateTime(Complex parent, String parentType, String name, DateTimeType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeCode(Complex parent, String parentType, String name, CodeType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
    decorateCode(t, value);
  }

  protected void composeString(Complex parent, String parentType, String name, StringType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeInteger(Complex parent, String parentType, String name, IntegerType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeInteger64(Complex parent, String parentType, String name, Integer64Type value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeOid(Complex parent, String parentType, String name, OidType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeCanonical(Complex parent, String parentType, String name, CanonicalType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeUri(Complex parent, String parentType, String name, UriType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeUuid(Complex parent, String parentType, String name, UuidType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeUrl(Complex parent, String parentType, String name, UrlType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeInstant(Complex parent, String parentType, String name, InstantType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeBoolean(Complex parent, String parentType, String name, BooleanType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeBase64Binary(Complex parent, String parentType, String name, Base64BinaryType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeUnsignedInt(Complex parent, String parentType, String name, UnsignedIntType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeMarkdown(Complex parent, String parentType, String name, MarkdownType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeTime(Complex parent, String parentType, String name, TimeType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeId(Complex parent, String parentType, String name, IdType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composePositiveInt(Complex parent, String parentType, String name, PositiveIntType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeDecimal(Complex parent, String parentType, String name, DecimalType value, int index) {
    if (value == null)
      return;
    Complex t = parent.predicate("fhir:"+parentType+"."+name);
    t.predicate("fhir:value", ttlLiteral(value.asStringValue()));
    composeElement(t, parentType, name, value, index);
  }

  protected void composeElement(Complex t, String parentType, String name, Element element, int index) {
    if (element.hasIdElement()) {
      composeString(t, "Element", "id", element.getIdElement(), -1);
    }
    for (int i = 0; i < element.getExtension().size(); i++) {
      composeExtension(t, "Element", "extension", element.getExtension().get(i), i);
    }
  }

  protected void composeBackboneElement(Complex t, String parentType, String name, BackboneElement element, int index) {
    composeDataType(t, parentType, name, element, index);
    for (int i = 0; i < element.getModifierExtension().size(); i++) {
      composeExtension(t, "BackboneElement", "modifierExtension", element.getModifierExtension().get(i), i);
    }
  }

  protected void composeDataType(Complex t, String parentType, String name, DataType element, int index) {
    composeDataType(t, parentType, name, element, index);
  }

  protected void composeAddress(Complex parent, String parentType, String name, Address element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Address", name, element, index);
    if (element.hasUseElement()) {
      composeEnum(t, "Address", "use", element.getUseElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "Address", "type", element.getTypeElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "Address", "text", element.getTextElement(), -1);
    }
    for (int i = 0; i < element.getLine().size(); i++) {
      composeString(t, "Address", "line", element.getLine().get(i), i);
    }
    if (element.hasCityElement()) {
      composeString(t, "Address", "city", element.getCityElement(), -1);
    }
    if (element.hasDistrictElement()) {
      composeString(t, "Address", "district", element.getDistrictElement(), -1);
    }
    if (element.hasStateElement()) {
      composeString(t, "Address", "state", element.getStateElement(), -1);
    }
    if (element.hasPostalCodeElement()) {
      composeString(t, "Address", "postalCode", element.getPostalCodeElement(), -1);
    }
    if (element.hasCountryElement()) {
      composeString(t, "Address", "country", element.getCountryElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "Address", "period", element.getPeriod(), -1);
    }
  }

  protected void composeAge(Complex parent, String parentType, String name, Age element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeQuantity(t, "Age", name, element, index);
  }

  protected void composeAnnotation(Complex parent, String parentType, String name, Annotation element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Annotation", name, element, index);
    if (element.hasAuthor()) {
      composeType(t, "Annotation", "author", element.getAuthor(), -1);
    }
    if (element.hasTimeElement()) {
      composeDateTime(t, "Annotation", "time", element.getTimeElement(), -1);
    }
    if (element.hasTextElement()) {
      composeMarkdown(t, "Annotation", "text", element.getTextElement(), -1);
    }
  }

  protected void composeAttachment(Complex parent, String parentType, String name, Attachment element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Attachment", name, element, index);
    if (element.hasContentTypeElement()) {
      composeCode(t, "Attachment", "contentType", element.getContentTypeElement(), -1);
    }
    if (element.hasLanguageElement()) {
      composeCode(t, "Attachment", "language", element.getLanguageElement(), -1);
    }
    if (element.hasDataElement()) {
      composeBase64Binary(t, "Attachment", "data", element.getDataElement(), -1);
    }
    if (element.hasUrlElement()) {
      composeUrl(t, "Attachment", "url", element.getUrlElement(), -1);
    }
    if (element.hasSizeElement()) {
      composeUnsignedInt(t, "Attachment", "size", element.getSizeElement(), -1);
    }
    if (element.hasHashElement()) {
      composeBase64Binary(t, "Attachment", "hash", element.getHashElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Attachment", "title", element.getTitleElement(), -1);
    }
    if (element.hasCreationElement()) {
      composeDateTime(t, "Attachment", "creation", element.getCreationElement(), -1);
    }
  }

  protected void composeCodeableConcept(Complex parent, String parentType, String name, CodeableConcept element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "CodeableConcept", name, element, index);
    decorateCodeableConcept(t, element);
    for (int i = 0; i < element.getCoding().size(); i++) {
      composeCoding(t, "CodeableConcept", "coding", element.getCoding().get(i), i);
    }
    if (element.hasTextElement()) {
      composeString(t, "CodeableConcept", "text", element.getTextElement(), -1);
    }
  }

  protected void composeCodeableReference(Complex parent, String parentType, String name, CodeableReference element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "CodeableReference", name, element, index);
    if (element.hasConcept()) {
      composeCodeableConcept(t, "CodeableReference", "concept", element.getConcept(), -1);
    }
    if (element.hasReference()) {
      composeReference(t, "CodeableReference", "reference", element.getReference(), -1);
    }
  }

  protected void composeCoding(Complex parent, String parentType, String name, Coding element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Coding", name, element, index);
    decorateCoding(t, element);
    if (element.hasSystemElement()) {
      composeUri(t, "Coding", "system", element.getSystemElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Coding", "version", element.getVersionElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeCode(t, "Coding", "code", element.getCodeElement(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "Coding", "display", element.getDisplayElement(), -1);
    }
    if (element.hasUserSelectedElement()) {
      composeBoolean(t, "Coding", "userSelected", element.getUserSelectedElement(), -1);
    }
  }

  protected void composeContactDetail(Complex parent, String parentType, String name, ContactDetail element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "ContactDetail", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "ContactDetail", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "ContactDetail", "telecom", element.getTelecom().get(i), i);
    }
  }

  protected void composeContactPoint(Complex parent, String parentType, String name, ContactPoint element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "ContactPoint", name, element, index);
    if (element.hasSystemElement()) {
      composeEnum(t, "ContactPoint", "system", element.getSystemElement(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "ContactPoint", "value", element.getValueElement(), -1);
    }
    if (element.hasUseElement()) {
      composeEnum(t, "ContactPoint", "use", element.getUseElement(), -1);
    }
    if (element.hasRankElement()) {
      composePositiveInt(t, "ContactPoint", "rank", element.getRankElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ContactPoint", "period", element.getPeriod(), -1);
    }
  }

  protected void composeContributor(Complex parent, String parentType, String name, Contributor element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Contributor", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "Contributor", "type", element.getTypeElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Contributor", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "Contributor", "contact", element.getContact().get(i), i);
    }
  }

  protected void composeCount(Complex parent, String parentType, String name, Count element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeQuantity(t, "Count", name, element, index);
  }

  protected void composeDataRequirement(Complex parent, String parentType, String name, DataRequirement element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "DataRequirement", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "DataRequirement", "type", element.getTypeElement(), -1);
    }
    for (int i = 0; i < element.getProfile().size(); i++) {
      composeCanonical(t, "DataRequirement", "profile", element.getProfile().get(i), i);
    }
    if (element.hasSubject()) {
      composeType(t, "DataRequirement", "subject", element.getSubject(), -1);
    }
    for (int i = 0; i < element.getMustSupport().size(); i++) {
      composeString(t, "DataRequirement", "mustSupport", element.getMustSupport().get(i), i);
    }
    for (int i = 0; i < element.getCodeFilter().size(); i++) {
      composeDataRequirementCodeFilterComponent(t, "DataRequirement", "codeFilter", element.getCodeFilter().get(i), i);
    }
    for (int i = 0; i < element.getDateFilter().size(); i++) {
      composeDataRequirementDateFilterComponent(t, "DataRequirement", "dateFilter", element.getDateFilter().get(i), i);
    }
    if (element.hasLimitElement()) {
      composePositiveInt(t, "DataRequirement", "limit", element.getLimitElement(), -1);
    }
    for (int i = 0; i < element.getSort().size(); i++) {
      composeDataRequirementSortComponent(t, "DataRequirement", "sort", element.getSort().get(i), i);
    }
  }

  protected void composeDataRequirementCodeFilterComponent(Complex parent, String parentType, String name, DataRequirement.DataRequirementCodeFilterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "codeFilter", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "DataRequirementCodeFilterComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasSearchParamElement()) {
      composeString(t, "DataRequirementCodeFilterComponent", "searchParam", element.getSearchParamElement(), -1);
    }
    if (element.hasValueSetElement()) {
      composeCanonical(t, "DataRequirementCodeFilterComponent", "valueSet", element.getValueSetElement(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCoding(t, "DataRequirementCodeFilterComponent", "code", element.getCode().get(i), i);
    }
  }

  protected void composeDataRequirementDateFilterComponent(Complex parent, String parentType, String name, DataRequirement.DataRequirementDateFilterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "dateFilter", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "DataRequirementDateFilterComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasSearchParamElement()) {
      composeString(t, "DataRequirementDateFilterComponent", "searchParam", element.getSearchParamElement(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "DataRequirementDateFilterComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeDataRequirementSortComponent(Complex parent, String parentType, String name, DataRequirement.DataRequirementSortComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "sort", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "DataRequirementSortComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasDirectionElement()) {
      composeEnum(t, "DataRequirementSortComponent", "direction", element.getDirectionElement(), -1);
    }
  }

  protected void composeDistance(Complex parent, String parentType, String name, Distance element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeQuantity(t, "Distance", name, element, index);
  }

  protected void composeDosage(Complex parent, String parentType, String name, Dosage element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Dosage", name, element, index);
    if (element.hasSequenceElement()) {
      composeInteger(t, "Dosage", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "Dosage", "text", element.getTextElement(), -1);
    }
    for (int i = 0; i < element.getAdditionalInstruction().size(); i++) {
      composeCodeableConcept(t, "Dosage", "additionalInstruction", element.getAdditionalInstruction().get(i), i);
    }
    if (element.hasPatientInstructionElement()) {
      composeString(t, "Dosage", "patientInstruction", element.getPatientInstructionElement(), -1);
    }
    if (element.hasTiming()) {
      composeTiming(t, "Dosage", "timing", element.getTiming(), -1);
    }
    if (element.hasAsNeeded()) {
      composeType(t, "Dosage", "asNeeded", element.getAsNeeded(), -1);
    }
    if (element.hasSite()) {
      composeCodeableConcept(t, "Dosage", "site", element.getSite(), -1);
    }
    if (element.hasRoute()) {
      composeCodeableConcept(t, "Dosage", "route", element.getRoute(), -1);
    }
    if (element.hasMethod()) {
      composeCodeableConcept(t, "Dosage", "method", element.getMethod(), -1);
    }
    for (int i = 0; i < element.getDoseAndRate().size(); i++) {
      composeDosageDoseAndRateComponent(t, "Dosage", "doseAndRate", element.getDoseAndRate().get(i), i);
    }
    if (element.hasMaxDosePerPeriod()) {
      composeRatio(t, "Dosage", "maxDosePerPeriod", element.getMaxDosePerPeriod(), -1);
    }
    if (element.hasMaxDosePerAdministration()) {
      composeQuantity(t, "Dosage", "maxDosePerAdministration", element.getMaxDosePerAdministration(), -1);
    }
    if (element.hasMaxDosePerLifetime()) {
      composeQuantity(t, "Dosage", "maxDosePerLifetime", element.getMaxDosePerLifetime(), -1);
    }
  }

  protected void composeDosageDoseAndRateComponent(Complex parent, String parentType, String name, Dosage.DosageDoseAndRateComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "doseAndRate", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "DosageDoseAndRateComponent", "type", element.getType(), -1);
    }
    if (element.hasDose()) {
      composeType(t, "DosageDoseAndRateComponent", "dose", element.getDose(), -1);
    }
    if (element.hasRate()) {
      composeType(t, "DosageDoseAndRateComponent", "rate", element.getRate(), -1);
    }
  }

  protected void composeDuration(Complex parent, String parentType, String name, Duration element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeQuantity(t, "Duration", name, element, index);
  }

  protected void composeElementDefinition(Complex parent, String parentType, String name, ElementDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "ElementDefinition", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "ElementDefinition", "path", element.getPathElement(), -1);
    }
    for (int i = 0; i < element.getRepresentation().size(); i++) {
      composeEnum(t, "ElementDefinition", "representation", element.getRepresentation().get(i), i);
    }
    if (element.hasSliceNameElement()) {
      composeString(t, "ElementDefinition", "sliceName", element.getSliceNameElement(), -1);
    }
    if (element.hasSliceIsConstrainingElement()) {
      composeBoolean(t, "ElementDefinition", "sliceIsConstraining", element.getSliceIsConstrainingElement(), -1);
    }
    if (element.hasLabelElement()) {
      composeString(t, "ElementDefinition", "label", element.getLabelElement(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCoding(t, "ElementDefinition", "code", element.getCode().get(i), i);
    }
    if (element.hasSlicing()) {
      composeElementDefinitionSlicingComponent(t, "ElementDefinition", "slicing", element.getSlicing(), -1);
    }
    if (element.hasShortElement()) {
      composeString(t, "ElementDefinition", "short", element.getShortElement(), -1);
    }
    if (element.hasDefinitionElement()) {
      composeMarkdown(t, "ElementDefinition", "definition", element.getDefinitionElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeMarkdown(t, "ElementDefinition", "comment", element.getCommentElement(), -1);
    }
    if (element.hasRequirementsElement()) {
      composeMarkdown(t, "ElementDefinition", "requirements", element.getRequirementsElement(), -1);
    }
    for (int i = 0; i < element.getAlias().size(); i++) {
      composeString(t, "ElementDefinition", "alias", element.getAlias().get(i), i);
    }
    if (element.hasMinElement()) {
      composeUnsignedInt(t, "ElementDefinition", "min", element.getMinElement(), -1);
    }
    if (element.hasMaxElement()) {
      composeString(t, "ElementDefinition", "max", element.getMaxElement(), -1);
    }
    if (element.hasBase()) {
      composeElementDefinitionBaseComponent(t, "ElementDefinition", "base", element.getBase(), -1);
    }
    if (element.hasContentReferenceElement()) {
      composeUri(t, "ElementDefinition", "contentReference", element.getContentReferenceElement(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeElementDefinitionTypeRefComponent(t, "ElementDefinition", "type", element.getType().get(i), i);
    }
    if (element.hasDefaultValue()) {
      composeType(t, "ElementDefinition", "defaultValue", element.getDefaultValue(), -1);
    }
    if (element.hasMeaningWhenMissingElement()) {
      composeMarkdown(t, "ElementDefinition", "meaningWhenMissing", element.getMeaningWhenMissingElement(), -1);
    }
    if (element.hasOrderMeaningElement()) {
      composeString(t, "ElementDefinition", "orderMeaning", element.getOrderMeaningElement(), -1);
    }
    if (element.hasFixed()) {
      composeType(t, "ElementDefinition", "fixed", element.getFixed(), -1);
    }
    if (element.hasPattern()) {
      composeType(t, "ElementDefinition", "pattern", element.getPattern(), -1);
    }
    for (int i = 0; i < element.getExample().size(); i++) {
      composeElementDefinitionExampleComponent(t, "ElementDefinition", "example", element.getExample().get(i), i);
    }
    if (element.hasMinValue()) {
      composeType(t, "ElementDefinition", "minValue", element.getMinValue(), -1);
    }
    if (element.hasMaxValue()) {
      composeType(t, "ElementDefinition", "maxValue", element.getMaxValue(), -1);
    }
    if (element.hasMaxLengthElement()) {
      composeInteger(t, "ElementDefinition", "maxLength", element.getMaxLengthElement(), -1);
    }
    for (int i = 0; i < element.getCondition().size(); i++) {
      composeId(t, "ElementDefinition", "condition", element.getCondition().get(i), i);
    }
    for (int i = 0; i < element.getConstraint().size(); i++) {
      composeElementDefinitionConstraintComponent(t, "ElementDefinition", "constraint", element.getConstraint().get(i), i);
    }
    if (element.hasMustSupportElement()) {
      composeBoolean(t, "ElementDefinition", "mustSupport", element.getMustSupportElement(), -1);
    }
    if (element.hasIsModifierElement()) {
      composeBoolean(t, "ElementDefinition", "isModifier", element.getIsModifierElement(), -1);
    }
    if (element.hasIsModifierReasonElement()) {
      composeString(t, "ElementDefinition", "isModifierReason", element.getIsModifierReasonElement(), -1);
    }
    if (element.hasIsSummaryElement()) {
      composeBoolean(t, "ElementDefinition", "isSummary", element.getIsSummaryElement(), -1);
    }
    if (element.hasBinding()) {
      composeElementDefinitionBindingComponent(t, "ElementDefinition", "binding", element.getBinding(), -1);
    }
    for (int i = 0; i < element.getMapping().size(); i++) {
      composeElementDefinitionMappingComponent(t, "ElementDefinition", "mapping", element.getMapping().get(i), i);
    }
  }

  protected void composeElementDefinitionSlicingComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionSlicingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "slicing", name, element, index);
    for (int i = 0; i < element.getDiscriminator().size(); i++) {
      composeElementDefinitionSlicingDiscriminatorComponent(t, "ElementDefinitionSlicingComponent", "discriminator", element.getDiscriminator().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ElementDefinitionSlicingComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasOrderedElement()) {
      composeBoolean(t, "ElementDefinitionSlicingComponent", "ordered", element.getOrderedElement(), -1);
    }
    if (element.hasRulesElement()) {
      composeEnum(t, "ElementDefinitionSlicingComponent", "rules", element.getRulesElement(), -1);
    }
  }

  protected void composeElementDefinitionSlicingDiscriminatorComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "discriminator", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "ElementDefinitionSlicingDiscriminatorComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasPathElement()) {
      composeString(t, "ElementDefinitionSlicingDiscriminatorComponent", "path", element.getPathElement(), -1);
    }
  }

  protected void composeElementDefinitionBaseComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBaseComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "base", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "ElementDefinitionBaseComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasMinElement()) {
      composeUnsignedInt(t, "ElementDefinitionBaseComponent", "min", element.getMinElement(), -1);
    }
    if (element.hasMaxElement()) {
      composeString(t, "ElementDefinitionBaseComponent", "max", element.getMaxElement(), -1);
    }
  }

  protected void composeElementDefinitionTypeRefComponent(Complex parent, String parentType, String name, ElementDefinition.TypeRefComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "type", name, element, index);
    if (element.hasCodeElement()) {
      composeUri(t, "TypeRefComponent", "code", element.getCodeElement(), -1);
    }
    for (int i = 0; i < element.getProfile().size(); i++) {
      composeCanonical(t, "TypeRefComponent", "profile", element.getProfile().get(i), i);
    }
    for (int i = 0; i < element.getTargetProfile().size(); i++) {
      composeCanonical(t, "TypeRefComponent", "targetProfile", element.getTargetProfile().get(i), i);
    }
    for (int i = 0; i < element.getAggregation().size(); i++) {
      composeEnum(t, "TypeRefComponent", "aggregation", element.getAggregation().get(i), i);
    }
    if (element.hasVersioningElement()) {
      composeEnum(t, "TypeRefComponent", "versioning", element.getVersioningElement(), -1);
    }
  }

  protected void composeElementDefinitionExampleComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionExampleComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "example", name, element, index);
    if (element.hasLabelElement()) {
      composeString(t, "ElementDefinitionExampleComponent", "label", element.getLabelElement(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "ElementDefinitionExampleComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeElementDefinitionConstraintComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionConstraintComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "constraint", name, element, index);
    if (element.hasKeyElement()) {
      composeId(t, "ElementDefinitionConstraintComponent", "key", element.getKeyElement(), -1);
    }
    if (element.hasRequirementsElement()) {
      composeString(t, "ElementDefinitionConstraintComponent", "requirements", element.getRequirementsElement(), -1);
    }
    if (element.hasSeverityElement()) {
      composeEnum(t, "ElementDefinitionConstraintComponent", "severity", element.getSeverityElement(), -1);
    }
    if (element.hasHumanElement()) {
      composeString(t, "ElementDefinitionConstraintComponent", "human", element.getHumanElement(), -1);
    }
    if (element.hasExpressionElement()) {
      composeString(t, "ElementDefinitionConstraintComponent", "expression", element.getExpressionElement(), -1);
    }
    if (element.hasXpathElement()) {
      composeString(t, "ElementDefinitionConstraintComponent", "xpath", element.getXpathElement(), -1);
    }
    if (element.hasSourceElement()) {
      composeCanonical(t, "ElementDefinitionConstraintComponent", "source", element.getSourceElement(), -1);
    }
  }

  protected void composeElementDefinitionBindingComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBindingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "binding", name, element, index);
    if (element.hasStrengthElement()) {
      composeEnum(t, "ElementDefinitionBindingComponent", "strength", element.getStrengthElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ElementDefinitionBindingComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasValueSetElement()) {
      composeCanonical(t, "ElementDefinitionBindingComponent", "valueSet", element.getValueSetElement(), -1);
    }
  }

  protected void composeElementDefinitionMappingComponent(Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionMappingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "mapping", name, element, index);
    if (element.hasIdentityElement()) {
      composeId(t, "ElementDefinitionMappingComponent", "identity", element.getIdentityElement(), -1);
    }
    if (element.hasLanguageElement()) {
      composeCode(t, "ElementDefinitionMappingComponent", "language", element.getLanguageElement(), -1);
    }
    if (element.hasMapElement()) {
      composeString(t, "ElementDefinitionMappingComponent", "map", element.getMapElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeString(t, "ElementDefinitionMappingComponent", "comment", element.getCommentElement(), -1);
    }
  }

  protected void composeExpression(Complex parent, String parentType, String name, Expression element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Expression", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "Expression", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeId(t, "Expression", "name", element.getNameElement(), -1);
    }
    if (element.hasLanguageElement()) {
      composeCode(t, "Expression", "language", element.getLanguageElement(), -1);
    }
    if (element.hasExpressionElement()) {
      composeString(t, "Expression", "expression", element.getExpressionElement(), -1);
    }
    if (element.hasReferenceElement()) {
      composeUri(t, "Expression", "reference", element.getReferenceElement(), -1);
    }
  }

  protected void composeExtension(Complex parent, String parentType, String name, Extension element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Extension", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "Extension", "url", element.getUrlElement(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "Extension", "value", element.getValue(), -1);
    }
  }

  protected void composeHumanName(Complex parent, String parentType, String name, HumanName element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "HumanName", name, element, index);
    if (element.hasUseElement()) {
      composeEnum(t, "HumanName", "use", element.getUseElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "HumanName", "text", element.getTextElement(), -1);
    }
    if (element.hasFamilyElement()) {
      composeString(t, "HumanName", "family", element.getFamilyElement(), -1);
    }
    for (int i = 0; i < element.getGiven().size(); i++) {
      composeString(t, "HumanName", "given", element.getGiven().get(i), i);
    }
    for (int i = 0; i < element.getPrefix().size(); i++) {
      composeString(t, "HumanName", "prefix", element.getPrefix().get(i), i);
    }
    for (int i = 0; i < element.getSuffix().size(); i++) {
      composeString(t, "HumanName", "suffix", element.getSuffix().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "HumanName", "period", element.getPeriod(), -1);
    }
  }

  protected void composeIdentifier(Complex parent, String parentType, String name, Identifier element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Identifier", name, element, index);
    if (element.hasUseElement()) {
      composeEnum(t, "Identifier", "use", element.getUseElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Identifier", "type", element.getType(), -1);
    }
    if (element.hasSystemElement()) {
      composeUri(t, "Identifier", "system", element.getSystemElement(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "Identifier", "value", element.getValueElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "Identifier", "period", element.getPeriod(), -1);
    }
    if (element.hasAssigner()) {
      composeReference(t, "Identifier", "assigner", element.getAssigner(), -1);
    }
  }

  protected void composeMarketingStatus(Complex parent, String parentType, String name, MarketingStatus element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "MarketingStatus", name, element, index);
    if (element.hasCountry()) {
      composeCodeableConcept(t, "MarketingStatus", "country", element.getCountry(), -1);
    }
    if (element.hasJurisdiction()) {
      composeCodeableConcept(t, "MarketingStatus", "jurisdiction", element.getJurisdiction(), -1);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "MarketingStatus", "status", element.getStatus(), -1);
    }
    if (element.hasDateRange()) {
      composePeriod(t, "MarketingStatus", "dateRange", element.getDateRange(), -1);
    }
    if (element.hasRestoreDateElement()) {
      composeDateTime(t, "MarketingStatus", "restoreDate", element.getRestoreDateElement(), -1);
    }
  }

  protected void composeMeta(Complex parent, String parentType, String name, Meta element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Meta", name, element, index);
    if (element.hasVersionIdElement()) {
      composeId(t, "Meta", "versionId", element.getVersionIdElement(), -1);
    }
    if (element.hasLastUpdatedElement()) {
      composeInstant(t, "Meta", "lastUpdated", element.getLastUpdatedElement(), -1);
    }
    if (element.hasSourceElement()) {
      composeUri(t, "Meta", "source", element.getSourceElement(), -1);
    }
    for (int i = 0; i < element.getProfile().size(); i++) {
      composeCanonical(t, "Meta", "profile", element.getProfile().get(i), i);
    }
    for (int i = 0; i < element.getSecurity().size(); i++) {
      composeCoding(t, "Meta", "security", element.getSecurity().get(i), i);
    }
    for (int i = 0; i < element.getTag().size(); i++) {
      composeCoding(t, "Meta", "tag", element.getTag().get(i), i);
    }
  }

  protected void composeMoney(Complex parent, String parentType, String name, Money element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Money", name, element, index);
    if (element.hasValueElement()) {
      composeDecimal(t, "Money", "value", element.getValueElement(), -1);
    }
    if (element.hasCurrencyElement()) {
      composeCode(t, "Money", "currency", element.getCurrencyElement(), -1);
    }
  }

  protected void composeNarrative(Complex parent, String parentType, String name, Narrative element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Narrative", name, element, index);
    if (element.hasStatusElement()) {
      composeEnum(t, "Narrative", "status", element.getStatusElement(), -1);
    }
    if (element.hasDiv()) {
      composeXhtmlNode(t, "Narrative", "div", element.getDiv(), -1);
    }
  }

  protected void composeParameterDefinition(Complex parent, String parentType, String name, ParameterDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "ParameterDefinition", name, element, index);
    if (element.hasNameElement()) {
      composeCode(t, "ParameterDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasUseElement()) {
      composeEnum(t, "ParameterDefinition", "use", element.getUseElement(), -1);
    }
    if (element.hasMinElement()) {
      composeInteger(t, "ParameterDefinition", "min", element.getMinElement(), -1);
    }
    if (element.hasMaxElement()) {
      composeString(t, "ParameterDefinition", "max", element.getMaxElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeString(t, "ParameterDefinition", "documentation", element.getDocumentationElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "ParameterDefinition", "type", element.getTypeElement(), -1);
    }
    if (element.hasProfileElement()) {
      composeCanonical(t, "ParameterDefinition", "profile", element.getProfileElement(), -1);
    }
  }

  protected void composePeriod(Complex parent, String parentType, String name, Period element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Period", name, element, index);
    if (element.hasStartElement()) {
      composeDateTime(t, "Period", "start", element.getStartElement(), -1);
    }
    if (element.hasEndElement()) {
      composeDateTime(t, "Period", "end", element.getEndElement(), -1);
    }
  }

  protected void composePopulation(Complex parent, String parentType, String name, Population element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Population", name, element, index);
    if (element.hasAge()) {
      composeType(t, "Population", "age", element.getAge(), -1);
    }
    if (element.hasGender()) {
      composeCodeableConcept(t, "Population", "gender", element.getGender(), -1);
    }
    if (element.hasRace()) {
      composeCodeableConcept(t, "Population", "race", element.getRace(), -1);
    }
    if (element.hasPhysiologicalCondition()) {
      composeCodeableConcept(t, "Population", "physiologicalCondition", element.getPhysiologicalCondition(), -1);
    }
  }

  protected void composeProdCharacteristic(Complex parent, String parentType, String name, ProdCharacteristic element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "ProdCharacteristic", name, element, index);
    if (element.hasHeight()) {
      composeQuantity(t, "ProdCharacteristic", "height", element.getHeight(), -1);
    }
    if (element.hasWidth()) {
      composeQuantity(t, "ProdCharacteristic", "width", element.getWidth(), -1);
    }
    if (element.hasDepth()) {
      composeQuantity(t, "ProdCharacteristic", "depth", element.getDepth(), -1);
    }
    if (element.hasWeight()) {
      composeQuantity(t, "ProdCharacteristic", "weight", element.getWeight(), -1);
    }
    if (element.hasNominalVolume()) {
      composeQuantity(t, "ProdCharacteristic", "nominalVolume", element.getNominalVolume(), -1);
    }
    if (element.hasExternalDiameter()) {
      composeQuantity(t, "ProdCharacteristic", "externalDiameter", element.getExternalDiameter(), -1);
    }
    if (element.hasShapeElement()) {
      composeString(t, "ProdCharacteristic", "shape", element.getShapeElement(), -1);
    }
    for (int i = 0; i < element.getColor().size(); i++) {
      composeString(t, "ProdCharacteristic", "color", element.getColor().get(i), i);
    }
    for (int i = 0; i < element.getImprint().size(); i++) {
      composeString(t, "ProdCharacteristic", "imprint", element.getImprint().get(i), i);
    }
    for (int i = 0; i < element.getImage().size(); i++) {
      composeAttachment(t, "ProdCharacteristic", "image", element.getImage().get(i), i);
    }
    if (element.hasScoring()) {
      composeCodeableConcept(t, "ProdCharacteristic", "scoring", element.getScoring(), -1);
    }
  }

  protected void composeProductShelfLife(Complex parent, String parentType, String name, ProductShelfLife element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "ProductShelfLife", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ProductShelfLife", "type", element.getType(), -1);
    }
    if (element.hasPeriod()) {
      composeType(t, "ProductShelfLife", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getSpecialPrecautionsForStorage().size(); i++) {
      composeCodeableConcept(t, "ProductShelfLife", "specialPrecautionsForStorage", element.getSpecialPrecautionsForStorage().get(i), i);
    }
  }

  protected void composeQuantity(Complex parent, String parentType, String name, Quantity element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Quantity", name, element, index);
    if (element.hasValueElement()) {
      composeDecimal(t, "Quantity", "value", element.getValueElement(), -1);
    }
    if (element.hasComparatorElement()) {
      composeEnum(t, "Quantity", "comparator", element.getComparatorElement(), -1);
    }
    if (element.hasUnitElement()) {
      composeString(t, "Quantity", "unit", element.getUnitElement(), -1);
    }
    if (element.hasSystemElement()) {
      composeUri(t, "Quantity", "system", element.getSystemElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeCode(t, "Quantity", "code", element.getCodeElement(), -1);
    }
  }

  protected void composeRange(Complex parent, String parentType, String name, Range element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Range", name, element, index);
    if (element.hasLow()) {
      composeQuantity(t, "Range", "low", element.getLow(), -1);
    }
    if (element.hasHigh()) {
      composeQuantity(t, "Range", "high", element.getHigh(), -1);
    }
  }

  protected void composeRatio(Complex parent, String parentType, String name, Ratio element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Ratio", name, element, index);
    if (element.hasNumerator()) {
      composeQuantity(t, "Ratio", "numerator", element.getNumerator(), -1);
    }
    if (element.hasDenominator()) {
      composeQuantity(t, "Ratio", "denominator", element.getDenominator(), -1);
    }
  }

  protected void composeRatioRange(Complex parent, String parentType, String name, RatioRange element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "RatioRange", name, element, index);
    if (element.hasLowNumerator()) {
      composeQuantity(t, "RatioRange", "lowNumerator", element.getLowNumerator(), -1);
    }
    if (element.hasHighNumerator()) {
      composeQuantity(t, "RatioRange", "highNumerator", element.getHighNumerator(), -1);
    }
    if (element.hasDenominator()) {
      composeQuantity(t, "RatioRange", "denominator", element.getDenominator(), -1);
    }
  }

  protected void composeReference(Complex parent, String parentType, String name, Reference element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Reference", name, element, index);
    if (element.hasReferenceElement()) {
      composeString(t, "Reference", "reference", element.getReferenceElement_(), -1);
    }
    if (element.hasTypeElement()) {
      composeUri(t, "Reference", "type", element.getTypeElement(), -1);
    }
    if (element.hasIdentifier()) {
      composeIdentifier(t, "Reference", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "Reference", "display", element.getDisplayElement(), -1);
    }
  }

  protected void composeRelatedArtifact(Complex parent, String parentType, String name, RelatedArtifact element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "RelatedArtifact", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "RelatedArtifact", "type", element.getTypeElement(), -1);
    }
    if (element.hasLabelElement()) {
      composeString(t, "RelatedArtifact", "label", element.getLabelElement(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "RelatedArtifact", "display", element.getDisplayElement(), -1);
    }
    if (element.hasCitationElement()) {
      composeMarkdown(t, "RelatedArtifact", "citation", element.getCitationElement(), -1);
    }
    if (element.hasUrlElement()) {
      composeUrl(t, "RelatedArtifact", "url", element.getUrlElement(), -1);
    }
    if (element.hasDocument()) {
      composeAttachment(t, "RelatedArtifact", "document", element.getDocument(), -1);
    }
    if (element.hasResourceElement()) {
      composeCanonical(t, "RelatedArtifact", "resource", element.getResourceElement(), -1);
    }
  }

  protected void composeSampledData(Complex parent, String parentType, String name, SampledData element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "SampledData", name, element, index);
    if (element.hasOrigin()) {
      composeQuantity(t, "SampledData", "origin", element.getOrigin(), -1);
    }
    if (element.hasPeriodElement()) {
      composeDecimal(t, "SampledData", "period", element.getPeriodElement(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "SampledData", "factor", element.getFactorElement(), -1);
    }
    if (element.hasLowerLimitElement()) {
      composeDecimal(t, "SampledData", "lowerLimit", element.getLowerLimitElement(), -1);
    }
    if (element.hasUpperLimitElement()) {
      composeDecimal(t, "SampledData", "upperLimit", element.getUpperLimitElement(), -1);
    }
    if (element.hasDimensionsElement()) {
      composePositiveInt(t, "SampledData", "dimensions", element.getDimensionsElement(), -1);
    }
    if (element.hasDataElement()) {
      composeString(t, "SampledData", "data", element.getDataElement(), -1);
    }
  }

  protected void composeSignature(Complex parent, String parentType, String name, Signature element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Signature", name, element, index);
    for (int i = 0; i < element.getType().size(); i++) {
      composeCoding(t, "Signature", "type", element.getType().get(i), i);
    }
    if (element.hasWhenElement()) {
      composeInstant(t, "Signature", "when", element.getWhenElement(), -1);
    }
    if (element.hasWho()) {
      composeReference(t, "Signature", "who", element.getWho(), -1);
    }
    if (element.hasOnBehalfOf()) {
      composeReference(t, "Signature", "onBehalfOf", element.getOnBehalfOf(), -1);
    }
    if (element.hasTargetFormatElement()) {
      composeCode(t, "Signature", "targetFormat", element.getTargetFormatElement(), -1);
    }
    if (element.hasSigFormatElement()) {
      composeCode(t, "Signature", "sigFormat", element.getSigFormatElement(), -1);
    }
    if (element.hasDataElement()) {
      composeBase64Binary(t, "Signature", "data", element.getDataElement(), -1);
    }
  }

  protected void composeTiming(Complex parent, String parentType, String name, Timing element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "Timing", name, element, index);
    for (int i = 0; i < element.getEvent().size(); i++) {
      composeDateTime(t, "Timing", "event", element.getEvent().get(i), i);
    }
    if (element.hasRepeat()) {
      composeTimingRepeatComponent(t, "Timing", "repeat", element.getRepeat(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Timing", "code", element.getCode(), -1);
    }
  }

  protected void composeTimingRepeatComponent(Complex parent, String parentType, String name, Timing.TimingRepeatComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeElement(t, "repeat", name, element, index);
    if (element.hasBounds()) {
      composeType(t, "TimingRepeatComponent", "bounds", element.getBounds(), -1);
    }
    if (element.hasCountElement()) {
      composePositiveInt(t, "TimingRepeatComponent", "count", element.getCountElement(), -1);
    }
    if (element.hasCountMaxElement()) {
      composePositiveInt(t, "TimingRepeatComponent", "countMax", element.getCountMaxElement(), -1);
    }
    if (element.hasDurationElement()) {
      composeDecimal(t, "TimingRepeatComponent", "duration", element.getDurationElement(), -1);
    }
    if (element.hasDurationMaxElement()) {
      composeDecimal(t, "TimingRepeatComponent", "durationMax", element.getDurationMaxElement(), -1);
    }
    if (element.hasDurationUnitElement()) {
      composeEnum(t, "TimingRepeatComponent", "durationUnit", element.getDurationUnitElement(), -1);
    }
    if (element.hasFrequencyElement()) {
      composePositiveInt(t, "TimingRepeatComponent", "frequency", element.getFrequencyElement(), -1);
    }
    if (element.hasFrequencyMaxElement()) {
      composePositiveInt(t, "TimingRepeatComponent", "frequencyMax", element.getFrequencyMaxElement(), -1);
    }
    if (element.hasPeriodElement()) {
      composeDecimal(t, "TimingRepeatComponent", "period", element.getPeriodElement(), -1);
    }
    if (element.hasPeriodMaxElement()) {
      composeDecimal(t, "TimingRepeatComponent", "periodMax", element.getPeriodMaxElement(), -1);
    }
    if (element.hasPeriodUnitElement()) {
      composeEnum(t, "TimingRepeatComponent", "periodUnit", element.getPeriodUnitElement(), -1);
    }
    for (int i = 0; i < element.getDayOfWeek().size(); i++) {
      composeEnum(t, "TimingRepeatComponent", "dayOfWeek", element.getDayOfWeek().get(i), i);
    }
    for (int i = 0; i < element.getTimeOfDay().size(); i++) {
      composeTime(t, "TimingRepeatComponent", "timeOfDay", element.getTimeOfDay().get(i), i);
    }
    for (int i = 0; i < element.getWhen().size(); i++) {
      composeEnum(t, "TimingRepeatComponent", "when", element.getWhen().get(i), i);
    }
    if (element.hasOffsetElement()) {
      composeUnsignedInt(t, "TimingRepeatComponent", "offset", element.getOffsetElement(), -1);
    }
  }

  protected void composeTriggerDefinition(Complex parent, String parentType, String name, TriggerDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "TriggerDefinition", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "TriggerDefinition", "type", element.getTypeElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "TriggerDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTiming()) {
      composeType(t, "TriggerDefinition", "timing", element.getTiming(), -1);
    }
    for (int i = 0; i < element.getData().size(); i++) {
      composeDataRequirement(t, "TriggerDefinition", "data", element.getData().get(i), i);
    }
    if (element.hasCondition()) {
      composeExpression(t, "TriggerDefinition", "condition", element.getCondition(), -1);
    }
  }

  protected void composeUsageContext(Complex parent, String parentType, String name, UsageContext element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDataType(t, "UsageContext", name, element, index);
    if (element.hasCode()) {
      composeCoding(t, "UsageContext", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "UsageContext", "value", element.getValue(), -1);
    }
  }

  protected void composeResource(Complex t, String parentType, String name, Resource element, int index) {
    if (element.hasIdElement()) {
      composeId(t, "Resource", "id", element.getIdElement(), -1);
    }
    if (element.hasMeta()) {
      composeMeta(t, "Resource", "meta", element.getMeta(), -1);
    }
    if (element.hasImplicitRulesElement()) {
      composeUri(t, "Resource", "implicitRules", element.getImplicitRulesElement(), -1);
    }
    if (element.hasLanguageElement()) {
      composeCode(t, "Resource", "language", element.getLanguageElement(), -1);
    }
  }

  protected void composeDomainResource(Complex t, String parentType, String name, DomainResource element, int index) {
    composeResource(t, parentType, name, element, index);
    if (element.hasText()) {
      composeNarrative(t, "DomainResource", "text", element.getText(), -1);
    }
    for (int i = 0; i < element.getContained().size(); i++) {
      composeResource(t, "DomainResource", "contained", element.getContained().get(i), i);
    }
    for (int i = 0; i < element.getExtension().size(); i++) {
      composeExtension(t, "DomainResource", "extension", element.getExtension().get(i), i);
    }
    for (int i = 0; i < element.getModifierExtension().size(); i++) {
      composeExtension(t, "DomainResource", "modifierExtension", element.getModifierExtension().get(i), i);
    }
  }

  protected void composeAccount(Complex parent, String parentType, String name, Account element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Account", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Account", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Account", "status", element.getStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Account", "type", element.getType(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Account", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getSubject().size(); i++) {
      composeReference(t, "Account", "subject", element.getSubject().get(i), i);
    }
    if (element.hasServicePeriod()) {
      composePeriod(t, "Account", "servicePeriod", element.getServicePeriod(), -1);
    }
    for (int i = 0; i < element.getCoverage().size(); i++) {
      composeAccountCoverageComponent(t, "Account", "coverage", element.getCoverage().get(i), i);
    }
    if (element.hasOwner()) {
      composeReference(t, "Account", "owner", element.getOwner(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "Account", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getGuarantor().size(); i++) {
      composeAccountGuarantorComponent(t, "Account", "guarantor", element.getGuarantor().get(i), i);
    }
    if (element.hasPartOf()) {
      composeReference(t, "Account", "partOf", element.getPartOf(), -1);
    }
  }

  protected void composeAccountCoverageComponent(Complex parent, String parentType, String name, Account.CoverageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "coverage", name, element, index);
    if (element.hasCoverage()) {
      composeReference(t, "CoverageComponent", "coverage", element.getCoverage(), -1);
    }
    if (element.hasPriorityElement()) {
      composePositiveInt(t, "CoverageComponent", "priority", element.getPriorityElement(), -1);
    }
  }

  protected void composeAccountGuarantorComponent(Complex parent, String parentType, String name, Account.GuarantorComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "guarantor", name, element, index);
    if (element.hasParty()) {
      composeReference(t, "GuarantorComponent", "party", element.getParty(), -1);
    }
    if (element.hasOnHoldElement()) {
      composeBoolean(t, "GuarantorComponent", "onHold", element.getOnHoldElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "GuarantorComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeActivityDefinition(Complex parent, String parentType, String name, ActivityDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ActivityDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ActivityDefinition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ActivityDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ActivityDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ActivityDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ActivityDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "ActivityDefinition", "subtitle", element.getSubtitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ActivityDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "ActivityDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasSubject()) {
      composeType(t, "ActivityDefinition", "subject", element.getSubject(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ActivityDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "ActivityDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ActivityDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ActivityDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "ActivityDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "ActivityDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "ActivityDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasUsageElement()) {
      composeString(t, "ActivityDefinition", "usage", element.getUsageElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ActivityDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "ActivityDefinition", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "ActivityDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "ActivityDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "ActivityDefinition", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "ActivityDefinition", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "ActivityDefinition", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "ActivityDefinition", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "ActivityDefinition", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "ActivityDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    for (int i = 0; i < element.getLibrary().size(); i++) {
      composeCanonical(t, "ActivityDefinition", "library", element.getLibrary().get(i), i);
    }
    if (element.hasKindElement()) {
      composeEnum(t, "ActivityDefinition", "kind", element.getKindElement(), -1);
    }
    if (element.hasProfileElement()) {
      composeCanonical(t, "ActivityDefinition", "profile", element.getProfileElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ActivityDefinition", "code", element.getCode(), -1);
    }
    if (element.hasIntentElement()) {
      composeEnum(t, "ActivityDefinition", "intent", element.getIntentElement(), -1);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "ActivityDefinition", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasDoNotPerformElement()) {
      composeBoolean(t, "ActivityDefinition", "doNotPerform", element.getDoNotPerformElement(), -1);
    }
    if (element.hasTiming()) {
      composeType(t, "ActivityDefinition", "timing", element.getTiming(), -1);
    }
    if (element.hasLocation()) {
      composeReference(t, "ActivityDefinition", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeActivityDefinitionParticipantComponent(t, "ActivityDefinition", "participant", element.getParticipant().get(i), i);
    }
    if (element.hasProduct()) {
      composeType(t, "ActivityDefinition", "product", element.getProduct(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "ActivityDefinition", "quantity", element.getQuantity(), -1);
    }
    for (int i = 0; i < element.getDosage().size(); i++) {
      composeDosage(t, "ActivityDefinition", "dosage", element.getDosage().get(i), i);
    }
    for (int i = 0; i < element.getBodySite().size(); i++) {
      composeCodeableConcept(t, "ActivityDefinition", "bodySite", element.getBodySite().get(i), i);
    }
    for (int i = 0; i < element.getSpecimenRequirement().size(); i++) {
      composeReference(t, "ActivityDefinition", "specimenRequirement", element.getSpecimenRequirement().get(i), i);
    }
    for (int i = 0; i < element.getObservationRequirement().size(); i++) {
      composeReference(t, "ActivityDefinition", "observationRequirement", element.getObservationRequirement().get(i), i);
    }
    for (int i = 0; i < element.getObservationResultRequirement().size(); i++) {
      composeReference(t, "ActivityDefinition", "observationResultRequirement", element.getObservationResultRequirement().get(i), i);
    }
    if (element.hasTransformElement()) {
      composeCanonical(t, "ActivityDefinition", "transform", element.getTransformElement(), -1);
    }
    for (int i = 0; i < element.getDynamicValue().size(); i++) {
      composeActivityDefinitionDynamicValueComponent(t, "ActivityDefinition", "dynamicValue", element.getDynamicValue().get(i), i);
    }
  }

  protected void composeActivityDefinitionParticipantComponent(Complex parent, String parentType, String name, ActivityDefinition.ActivityDefinitionParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "ActivityDefinitionParticipantComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "ActivityDefinitionParticipantComponent", "role", element.getRole(), -1);
    }
  }

  protected void composeActivityDefinitionDynamicValueComponent(Complex parent, String parentType, String name, ActivityDefinition.ActivityDefinitionDynamicValueComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dynamicValue", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "ActivityDefinitionDynamicValueComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasExpression()) {
      composeExpression(t, "ActivityDefinitionDynamicValueComponent", "expression", element.getExpression(), -1);
    }
  }

  protected void composeAdministrableProductDefinition(Complex parent, String parentType, String name, AdministrableProductDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "AdministrableProductDefinition", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "AdministrableProductDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "AdministrableProductDefinition", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getFormOf().size(); i++) {
      composeReference(t, "AdministrableProductDefinition", "formOf", element.getFormOf().get(i), i);
    }
    if (element.hasAdministrableDoseForm()) {
      composeCodeableConcept(t, "AdministrableProductDefinition", "administrableDoseForm", element.getAdministrableDoseForm(), -1);
    }
    if (element.hasUnitOfPresentation()) {
      composeCodeableConcept(t, "AdministrableProductDefinition", "unitOfPresentation", element.getUnitOfPresentation(), -1);
    }
    for (int i = 0; i < element.getProducedFrom().size(); i++) {
      composeReference(t, "AdministrableProductDefinition", "producedFrom", element.getProducedFrom().get(i), i);
    }
    for (int i = 0; i < element.getIngredient().size(); i++) {
      composeCodeableConcept(t, "AdministrableProductDefinition", "ingredient", element.getIngredient().get(i), i);
    }
    if (element.hasDevice()) {
      composeReference(t, "AdministrableProductDefinition", "device", element.getDevice(), -1);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeAdministrableProductDefinitionPropertyComponent(t, "AdministrableProductDefinition", "property", element.getProperty().get(i), i);
    }
    for (int i = 0; i < element.getRouteOfAdministration().size(); i++) {
      composeAdministrableProductDefinitionRouteOfAdministrationComponent(t, "AdministrableProductDefinition", "routeOfAdministration", element.getRouteOfAdministration().get(i), i);
    }
  }

  protected void composeAdministrableProductDefinitionPropertyComponent(Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "AdministrableProductDefinitionPropertyComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "AdministrableProductDefinitionPropertyComponent", "value", element.getValue(), -1);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "AdministrableProductDefinitionPropertyComponent", "status", element.getStatus(), -1);
    }
  }

  protected void composeAdministrableProductDefinitionRouteOfAdministrationComponent(Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "routeOfAdministration", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "code", element.getCode(), -1);
    }
    if (element.hasFirstDose()) {
      composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "firstDose", element.getFirstDose(), -1);
    }
    if (element.hasMaxSingleDose()) {
      composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxSingleDose", element.getMaxSingleDose(), -1);
    }
    if (element.hasMaxDosePerDay()) {
      composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxDosePerDay", element.getMaxDosePerDay(), -1);
    }
    if (element.hasMaxDosePerTreatmentPeriod()) {
      composeRatio(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxDosePerTreatmentPeriod", element.getMaxDosePerTreatmentPeriod(), -1);
    }
    if (element.hasMaxTreatmentPeriod()) {
      composeDuration(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxTreatmentPeriod", element.getMaxTreatmentPeriod(), -1);
    }
    for (int i = 0; i < element.getTargetSpecies().size(); i++) {
      composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "targetSpecies", element.getTargetSpecies().get(i), i);
    }
  }

  protected void composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "targetSpecies", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getWithdrawalPeriod().size(); i++) {
      composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent", "withdrawalPeriod", element.getWithdrawalPeriod().get(i), i);
    }
  }

  protected void composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "withdrawalPeriod", name, element, index);
    if (element.hasTissue()) {
      composeCodeableConcept(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent", "tissue", element.getTissue(), -1);
    }
    if (element.hasValue()) {
      composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent", "value", element.getValue(), -1);
    }
    if (element.hasSupportingInformationElement()) {
      composeString(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent", "supportingInformation", element.getSupportingInformationElement(), -1);
    }
  }

  protected void composeAdverseEvent(Complex parent, String parentType, String name, AdverseEvent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "AdverseEvent", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "AdverseEvent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasActualityElement()) {
      composeEnum(t, "AdverseEvent", "actuality", element.getActualityElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "AdverseEvent", "category", element.getCategory().get(i), i);
    }
    if (element.hasEvent()) {
      composeCodeableConcept(t, "AdverseEvent", "event", element.getEvent(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "AdverseEvent", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "AdverseEvent", "encounter", element.getEncounter(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "AdverseEvent", "date", element.getDateElement(), -1);
    }
    if (element.hasDetectedElement()) {
      composeDateTime(t, "AdverseEvent", "detected", element.getDetectedElement(), -1);
    }
    if (element.hasRecordedDateElement()) {
      composeDateTime(t, "AdverseEvent", "recordedDate", element.getRecordedDateElement(), -1);
    }
    for (int i = 0; i < element.getResultingCondition().size(); i++) {
      composeReference(t, "AdverseEvent", "resultingCondition", element.getResultingCondition().get(i), i);
    }
    if (element.hasLocation()) {
      composeReference(t, "AdverseEvent", "location", element.getLocation(), -1);
    }
    if (element.hasSeriousness()) {
      composeCodeableConcept(t, "AdverseEvent", "seriousness", element.getSeriousness(), -1);
    }
    if (element.hasSeverity()) {
      composeCodeableConcept(t, "AdverseEvent", "severity", element.getSeverity(), -1);
    }
    if (element.hasOutcome()) {
      composeCodeableConcept(t, "AdverseEvent", "outcome", element.getOutcome(), -1);
    }
    if (element.hasRecorder()) {
      composeReference(t, "AdverseEvent", "recorder", element.getRecorder(), -1);
    }
    for (int i = 0; i < element.getContributor().size(); i++) {
      composeReference(t, "AdverseEvent", "contributor", element.getContributor().get(i), i);
    }
    for (int i = 0; i < element.getSuspectEntity().size(); i++) {
      composeAdverseEventSuspectEntityComponent(t, "AdverseEvent", "suspectEntity", element.getSuspectEntity().get(i), i);
    }
    for (int i = 0; i < element.getSubjectMedicalHistory().size(); i++) {
      composeReference(t, "AdverseEvent", "subjectMedicalHistory", element.getSubjectMedicalHistory().get(i), i);
    }
    for (int i = 0; i < element.getReferenceDocument().size(); i++) {
      composeReference(t, "AdverseEvent", "referenceDocument", element.getReferenceDocument().get(i), i);
    }
    for (int i = 0; i < element.getStudy().size(); i++) {
      composeReference(t, "AdverseEvent", "study", element.getStudy().get(i), i);
    }
  }

  protected void composeAdverseEventSuspectEntityComponent(Complex parent, String parentType, String name, AdverseEvent.AdverseEventSuspectEntityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "suspectEntity", name, element, index);
    if (element.hasInstance()) {
      composeReference(t, "AdverseEventSuspectEntityComponent", "instance", element.getInstance(), -1);
    }
    for (int i = 0; i < element.getCausality().size(); i++) {
      composeAdverseEventSuspectEntityCausalityComponent(t, "AdverseEventSuspectEntityComponent", "causality", element.getCausality().get(i), i);
    }
  }

  protected void composeAdverseEventSuspectEntityCausalityComponent(Complex parent, String parentType, String name, AdverseEvent.AdverseEventSuspectEntityCausalityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "causality", name, element, index);
    if (element.hasAssessment()) {
      composeCodeableConcept(t, "AdverseEventSuspectEntityCausalityComponent", "assessment", element.getAssessment(), -1);
    }
    if (element.hasProductRelatednessElement()) {
      composeString(t, "AdverseEventSuspectEntityCausalityComponent", "productRelatedness", element.getProductRelatednessElement(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "AdverseEventSuspectEntityCausalityComponent", "author", element.getAuthor(), -1);
    }
    if (element.hasMethod()) {
      composeCodeableConcept(t, "AdverseEventSuspectEntityCausalityComponent", "method", element.getMethod(), -1);
    }
  }

  protected void composeAllergyIntolerance(Complex parent, String parentType, String name, AllergyIntolerance element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "AllergyIntolerance", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "AllergyIntolerance", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasClinicalStatus()) {
      composeCodeableConcept(t, "AllergyIntolerance", "clinicalStatus", element.getClinicalStatus(), -1);
    }
    if (element.hasVerificationStatus()) {
      composeCodeableConcept(t, "AllergyIntolerance", "verificationStatus", element.getVerificationStatus(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "AllergyIntolerance", "type", element.getTypeElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeEnum(t, "AllergyIntolerance", "category", element.getCategory().get(i), i);
    }
    if (element.hasCriticalityElement()) {
      composeEnum(t, "AllergyIntolerance", "criticality", element.getCriticalityElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "AllergyIntolerance", "code", element.getCode(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "AllergyIntolerance", "patient", element.getPatient(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "AllergyIntolerance", "encounter", element.getEncounter(), -1);
    }
    if (element.hasOnset()) {
      composeType(t, "AllergyIntolerance", "onset", element.getOnset(), -1);
    }
    if (element.hasRecordedDateElement()) {
      composeDateTime(t, "AllergyIntolerance", "recordedDate", element.getRecordedDateElement(), -1);
    }
    if (element.hasRecorder()) {
      composeReference(t, "AllergyIntolerance", "recorder", element.getRecorder(), -1);
    }
    if (element.hasAsserter()) {
      composeReference(t, "AllergyIntolerance", "asserter", element.getAsserter(), -1);
    }
    if (element.hasLastOccurrenceElement()) {
      composeDateTime(t, "AllergyIntolerance", "lastOccurrence", element.getLastOccurrenceElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "AllergyIntolerance", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getReaction().size(); i++) {
      composeAllergyIntoleranceReactionComponent(t, "AllergyIntolerance", "reaction", element.getReaction().get(i), i);
    }
  }

  protected void composeAllergyIntoleranceReactionComponent(Complex parent, String parentType, String name, AllergyIntolerance.AllergyIntoleranceReactionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "reaction", name, element, index);
    if (element.hasSubstance()) {
      composeCodeableConcept(t, "AllergyIntoleranceReactionComponent", "substance", element.getSubstance(), -1);
    }
    for (int i = 0; i < element.getManifestation().size(); i++) {
      composeCodeableConcept(t, "AllergyIntoleranceReactionComponent", "manifestation", element.getManifestation().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "AllergyIntoleranceReactionComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasOnsetElement()) {
      composeDateTime(t, "AllergyIntoleranceReactionComponent", "onset", element.getOnsetElement(), -1);
    }
    if (element.hasSeverityElement()) {
      composeEnum(t, "AllergyIntoleranceReactionComponent", "severity", element.getSeverityElement(), -1);
    }
    if (element.hasExposureRoute()) {
      composeCodeableConcept(t, "AllergyIntoleranceReactionComponent", "exposureRoute", element.getExposureRoute(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "AllergyIntoleranceReactionComponent", "note", element.getNote().get(i), i);
    }
  }

  protected void composeAppointment(Complex parent, String parentType, String name, Appointment element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Appointment", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Appointment", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Appointment", "status", element.getStatusElement(), -1);
    }
    if (element.hasCancelationReason()) {
      composeCodeableConcept(t, "Appointment", "cancelationReason", element.getCancelationReason(), -1);
    }
    for (int i = 0; i < element.getServiceCategory().size(); i++) {
      composeCodeableConcept(t, "Appointment", "serviceCategory", element.getServiceCategory().get(i), i);
    }
    for (int i = 0; i < element.getServiceType().size(); i++) {
      composeCodeableConcept(t, "Appointment", "serviceType", element.getServiceType().get(i), i);
    }
    for (int i = 0; i < element.getSpecialty().size(); i++) {
      composeCodeableConcept(t, "Appointment", "specialty", element.getSpecialty().get(i), i);
    }
    if (element.hasAppointmentType()) {
      composeCodeableConcept(t, "Appointment", "appointmentType", element.getAppointmentType(), -1);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "Appointment", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "Appointment", "reasonReference", element.getReasonReference().get(i), i);
    }
    if (element.hasPriorityElement()) {
      composeUnsignedInt(t, "Appointment", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "Appointment", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getSupportingInformation().size(); i++) {
      composeReference(t, "Appointment", "supportingInformation", element.getSupportingInformation().get(i), i);
    }
    if (element.hasStartElement()) {
      composeInstant(t, "Appointment", "start", element.getStartElement(), -1);
    }
    if (element.hasEndElement()) {
      composeInstant(t, "Appointment", "end", element.getEndElement(), -1);
    }
    if (element.hasMinutesDurationElement()) {
      composePositiveInt(t, "Appointment", "minutesDuration", element.getMinutesDurationElement(), -1);
    }
    for (int i = 0; i < element.getSlot().size(); i++) {
      composeReference(t, "Appointment", "slot", element.getSlot().get(i), i);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "Appointment", "created", element.getCreatedElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeString(t, "Appointment", "comment", element.getCommentElement(), -1);
    }
    if (element.hasPatientInstructionElement()) {
      composeString(t, "Appointment", "patientInstruction", element.getPatientInstructionElement(), -1);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "Appointment", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeAppointmentParticipantComponent(t, "Appointment", "participant", element.getParticipant().get(i), i);
    }
    for (int i = 0; i < element.getRequestedPeriod().size(); i++) {
      composePeriod(t, "Appointment", "requestedPeriod", element.getRequestedPeriod().get(i), i);
    }
  }

  protected void composeAppointmentParticipantComponent(Complex parent, String parentType, String name, Appointment.AppointmentParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "AppointmentParticipantComponent", "type", element.getType().get(i), i);
    }
    if (element.hasActor()) {
      composeReference(t, "AppointmentParticipantComponent", "actor", element.getActor(), -1);
    }
    if (element.hasRequiredElement()) {
      composeEnum(t, "AppointmentParticipantComponent", "required", element.getRequiredElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "AppointmentParticipantComponent", "status", element.getStatusElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "AppointmentParticipantComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeAppointmentResponse(Complex parent, String parentType, String name, AppointmentResponse element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "AppointmentResponse", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "AppointmentResponse", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasAppointment()) {
      composeReference(t, "AppointmentResponse", "appointment", element.getAppointment(), -1);
    }
    if (element.hasStartElement()) {
      composeInstant(t, "AppointmentResponse", "start", element.getStartElement(), -1);
    }
    if (element.hasEndElement()) {
      composeInstant(t, "AppointmentResponse", "end", element.getEndElement(), -1);
    }
    for (int i = 0; i < element.getParticipantType().size(); i++) {
      composeCodeableConcept(t, "AppointmentResponse", "participantType", element.getParticipantType().get(i), i);
    }
    if (element.hasActor()) {
      composeReference(t, "AppointmentResponse", "actor", element.getActor(), -1);
    }
    if (element.hasParticipantStatusElement()) {
      composeEnum(t, "AppointmentResponse", "participantStatus", element.getParticipantStatusElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeString(t, "AppointmentResponse", "comment", element.getCommentElement(), -1);
    }
  }

  protected void composeAuditEvent(Complex parent, String parentType, String name, AuditEvent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "AuditEvent", name, element, index);
    if (element.hasType()) {
      composeCoding(t, "AuditEvent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getSubtype().size(); i++) {
      composeCoding(t, "AuditEvent", "subtype", element.getSubtype().get(i), i);
    }
    if (element.hasActionElement()) {
      composeEnum(t, "AuditEvent", "action", element.getActionElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "AuditEvent", "period", element.getPeriod(), -1);
    }
    if (element.hasRecordedElement()) {
      composeInstant(t, "AuditEvent", "recorded", element.getRecordedElement(), -1);
    }
    if (element.hasOutcomeElement()) {
      composeEnum(t, "AuditEvent", "outcome", element.getOutcomeElement(), -1);
    }
    if (element.hasOutcomeDescElement()) {
      composeString(t, "AuditEvent", "outcomeDesc", element.getOutcomeDescElement(), -1);
    }
    for (int i = 0; i < element.getPurposeOfEvent().size(); i++) {
      composeCodeableConcept(t, "AuditEvent", "purposeOfEvent", element.getPurposeOfEvent().get(i), i);
    }
    for (int i = 0; i < element.getAgent().size(); i++) {
      composeAuditEventAgentComponent(t, "AuditEvent", "agent", element.getAgent().get(i), i);
    }
    if (element.hasSource()) {
      composeAuditEventSourceComponent(t, "AuditEvent", "source", element.getSource(), -1);
    }
    for (int i = 0; i < element.getEntity().size(); i++) {
      composeAuditEventEntityComponent(t, "AuditEvent", "entity", element.getEntity().get(i), i);
    }
  }

  protected void composeAuditEventAgentComponent(Complex parent, String parentType, String name, AuditEvent.AuditEventAgentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "agent", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "AuditEventAgentComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getRole().size(); i++) {
      composeCodeableConcept(t, "AuditEventAgentComponent", "role", element.getRole().get(i), i);
    }
    if (element.hasWho()) {
      composeReference(t, "AuditEventAgentComponent", "who", element.getWho(), -1);
    }
    if (element.hasAltIdElement()) {
      composeString(t, "AuditEventAgentComponent", "altId", element.getAltIdElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "AuditEventAgentComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasRequestorElement()) {
      composeBoolean(t, "AuditEventAgentComponent", "requestor", element.getRequestorElement(), -1);
    }
    if (element.hasLocation()) {
      composeReference(t, "AuditEventAgentComponent", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getPolicy().size(); i++) {
      composeUri(t, "AuditEventAgentComponent", "policy", element.getPolicy().get(i), i);
    }
    if (element.hasMedia()) {
      composeCoding(t, "AuditEventAgentComponent", "media", element.getMedia(), -1);
    }
    if (element.hasNetwork()) {
      composeAuditEventAgentNetworkComponent(t, "AuditEventAgentComponent", "network", element.getNetwork(), -1);
    }
    for (int i = 0; i < element.getPurposeOfUse().size(); i++) {
      composeCodeableConcept(t, "AuditEventAgentComponent", "purposeOfUse", element.getPurposeOfUse().get(i), i);
    }
  }

  protected void composeAuditEventAgentNetworkComponent(Complex parent, String parentType, String name, AuditEvent.AuditEventAgentNetworkComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "network", name, element, index);
    if (element.hasAddressElement()) {
      composeString(t, "AuditEventAgentNetworkComponent", "address", element.getAddressElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "AuditEventAgentNetworkComponent", "type", element.getTypeElement(), -1);
    }
  }

  protected void composeAuditEventSourceComponent(Complex parent, String parentType, String name, AuditEvent.AuditEventSourceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "source", name, element, index);
    if (element.hasSiteElement()) {
      composeString(t, "AuditEventSourceComponent", "site", element.getSiteElement(), -1);
    }
    if (element.hasObserver()) {
      composeReference(t, "AuditEventSourceComponent", "observer", element.getObserver(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCoding(t, "AuditEventSourceComponent", "type", element.getType().get(i), i);
    }
  }

  protected void composeAuditEventEntityComponent(Complex parent, String parentType, String name, AuditEvent.AuditEventEntityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "entity", name, element, index);
    if (element.hasWhat()) {
      composeReference(t, "AuditEventEntityComponent", "what", element.getWhat(), -1);
    }
    if (element.hasType()) {
      composeCoding(t, "AuditEventEntityComponent", "type", element.getType(), -1);
    }
    if (element.hasRole()) {
      composeCoding(t, "AuditEventEntityComponent", "role", element.getRole(), -1);
    }
    if (element.hasLifecycle()) {
      composeCoding(t, "AuditEventEntityComponent", "lifecycle", element.getLifecycle(), -1);
    }
    for (int i = 0; i < element.getSecurityLabel().size(); i++) {
      composeCoding(t, "AuditEventEntityComponent", "securityLabel", element.getSecurityLabel().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "AuditEventEntityComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "AuditEventEntityComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasQueryElement()) {
      composeBase64Binary(t, "AuditEventEntityComponent", "query", element.getQueryElement(), -1);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeAuditEventEntityDetailComponent(t, "AuditEventEntityComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeAuditEventEntityDetailComponent(Complex parent, String parentType, String name, AuditEvent.AuditEventEntityDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "detail", name, element, index);
    if (element.hasTypeElement()) {
      composeString(t, "AuditEventEntityDetailComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "AuditEventEntityDetailComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeBasic(Complex parent, String parentType, String name, Basic element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Basic", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Basic", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Basic", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "Basic", "subject", element.getSubject(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDate(t, "Basic", "created", element.getCreatedElement(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "Basic", "author", element.getAuthor(), -1);
    }
  }

  protected void composeBinary(Complex parent, String parentType, String name, Binary element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeResource(t, "Binary", name, element, index);
    if (element.hasContentTypeElement()) {
      composeCode(t, "Binary", "contentType", element.getContentTypeElement(), -1);
    }
    if (element.hasSecurityContext()) {
      composeReference(t, "Binary", "securityContext", element.getSecurityContext(), -1);
    }
    if (element.hasDataElement()) {
      composeBase64Binary(t, "Binary", "data", element.getDataElement(), -1);
    }
  }

  protected void composeBiologicallyDerivedProduct(Complex parent, String parentType, String name, BiologicallyDerivedProduct element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "BiologicallyDerivedProduct", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "BiologicallyDerivedProduct", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasProductCategoryElement()) {
      composeEnum(t, "BiologicallyDerivedProduct", "productCategory", element.getProductCategoryElement(), -1);
    }
    if (element.hasProductCode()) {
      composeCodeableConcept(t, "BiologicallyDerivedProduct", "productCode", element.getProductCode(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "BiologicallyDerivedProduct", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getRequest().size(); i++) {
      composeReference(t, "BiologicallyDerivedProduct", "request", element.getRequest().get(i), i);
    }
    if (element.hasQuantityElement()) {
      composeInteger(t, "BiologicallyDerivedProduct", "quantity", element.getQuantityElement(), -1);
    }
    for (int i = 0; i < element.getParent().size(); i++) {
      composeReference(t, "BiologicallyDerivedProduct", "parent", element.getParent().get(i), i);
    }
    if (element.hasCollection()) {
      composeBiologicallyDerivedProductCollectionComponent(t, "BiologicallyDerivedProduct", "collection", element.getCollection(), -1);
    }
    for (int i = 0; i < element.getProcessing().size(); i++) {
      composeBiologicallyDerivedProductProcessingComponent(t, "BiologicallyDerivedProduct", "processing", element.getProcessing().get(i), i);
    }
    if (element.hasManipulation()) {
      composeBiologicallyDerivedProductManipulationComponent(t, "BiologicallyDerivedProduct", "manipulation", element.getManipulation(), -1);
    }
    for (int i = 0; i < element.getStorage().size(); i++) {
      composeBiologicallyDerivedProductStorageComponent(t, "BiologicallyDerivedProduct", "storage", element.getStorage().get(i), i);
    }
  }

  protected void composeBiologicallyDerivedProductCollectionComponent(Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "collection", name, element, index);
    if (element.hasCollector()) {
      composeReference(t, "BiologicallyDerivedProductCollectionComponent", "collector", element.getCollector(), -1);
    }
    if (element.hasSource()) {
      composeReference(t, "BiologicallyDerivedProductCollectionComponent", "source", element.getSource(), -1);
    }
    if (element.hasCollected()) {
      composeType(t, "BiologicallyDerivedProductCollectionComponent", "collected", element.getCollected(), -1);
    }
  }

  protected void composeBiologicallyDerivedProductProcessingComponent(Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "processing", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "BiologicallyDerivedProductProcessingComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasProcedure()) {
      composeCodeableConcept(t, "BiologicallyDerivedProductProcessingComponent", "procedure", element.getProcedure(), -1);
    }
    if (element.hasAdditive()) {
      composeReference(t, "BiologicallyDerivedProductProcessingComponent", "additive", element.getAdditive(), -1);
    }
    if (element.hasTime()) {
      composeType(t, "BiologicallyDerivedProductProcessingComponent", "time", element.getTime(), -1);
    }
  }

  protected void composeBiologicallyDerivedProductManipulationComponent(Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "manipulation", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "BiologicallyDerivedProductManipulationComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasTime()) {
      composeType(t, "BiologicallyDerivedProductManipulationComponent", "time", element.getTime(), -1);
    }
  }

  protected void composeBiologicallyDerivedProductStorageComponent(Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "storage", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "BiologicallyDerivedProductStorageComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasTemperatureElement()) {
      composeDecimal(t, "BiologicallyDerivedProductStorageComponent", "temperature", element.getTemperatureElement(), -1);
    }
    if (element.hasScaleElement()) {
      composeEnum(t, "BiologicallyDerivedProductStorageComponent", "scale", element.getScaleElement(), -1);
    }
    if (element.hasDuration()) {
      composePeriod(t, "BiologicallyDerivedProductStorageComponent", "duration", element.getDuration(), -1);
    }
  }

  protected void composeBodyStructure(Complex parent, String parentType, String name, BodyStructure element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "BodyStructure", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "BodyStructure", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "BodyStructure", "active", element.getActiveElement(), -1);
    }
    if (element.hasMorphology()) {
      composeCodeableConcept(t, "BodyStructure", "morphology", element.getMorphology(), -1);
    }
    if (element.hasLocation()) {
      composeCodeableConcept(t, "BodyStructure", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getLocationQualifier().size(); i++) {
      composeCodeableConcept(t, "BodyStructure", "locationQualifier", element.getLocationQualifier().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "BodyStructure", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getImage().size(); i++) {
      composeAttachment(t, "BodyStructure", "image", element.getImage().get(i), i);
    }
    if (element.hasPatient()) {
      composeReference(t, "BodyStructure", "patient", element.getPatient(), -1);
    }
  }

  protected void composeBundle(Complex parent, String parentType, String name, Bundle element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeResource(t, "Bundle", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "Bundle", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "Bundle", "type", element.getTypeElement(), -1);
    }
    if (element.hasTimestampElement()) {
      composeInstant(t, "Bundle", "timestamp", element.getTimestampElement(), -1);
    }
    if (element.hasTotalElement()) {
      composeUnsignedInt(t, "Bundle", "total", element.getTotalElement(), -1);
    }
    for (int i = 0; i < element.getLink().size(); i++) {
      composeBundleLinkComponent(t, "Bundle", "link", element.getLink().get(i), i);
    }
    for (int i = 0; i < element.getEntry().size(); i++) {
      composeBundleEntryComponent(t, "Bundle", "entry", element.getEntry().get(i), i);
    }
    if (element.hasSignature()) {
      composeSignature(t, "Bundle", "signature", element.getSignature(), -1);
    }
  }

  protected void composeBundleLinkComponent(Complex parent, String parentType, String name, Bundle.BundleLinkComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "link", name, element, index);
    if (element.hasRelationElement()) {
      composeString(t, "BundleLinkComponent", "relation", element.getRelationElement(), -1);
    }
    if (element.hasUrlElement()) {
      composeUri(t, "BundleLinkComponent", "url", element.getUrlElement(), -1);
    }
  }

  protected void composeBundleEntryComponent(Complex parent, String parentType, String name, Bundle.BundleEntryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "entry", name, element, index);
    for (int i = 0; i < element.getLink().size(); i++) {
      composeBundleLinkComponent(t, "BundleEntryComponent", "link", element.getLink().get(i), i);
    }
    if (element.hasFullUrlElement()) {
      composeUri(t, "BundleEntryComponent", "fullUrl", element.getFullUrlElement(), -1);
    }
    if (element.hasResource()) {
      composeResource(t, "BundleEntryComponent", "resource", element.getResource(), -1);
    }
    if (element.hasSearch()) {
      composeBundleEntrySearchComponent(t, "BundleEntryComponent", "search", element.getSearch(), -1);
    }
    if (element.hasRequest()) {
      composeBundleEntryRequestComponent(t, "BundleEntryComponent", "request", element.getRequest(), -1);
    }
    if (element.hasResponse()) {
      composeBundleEntryResponseComponent(t, "BundleEntryComponent", "response", element.getResponse(), -1);
    }
  }

  protected void composeBundleEntrySearchComponent(Complex parent, String parentType, String name, Bundle.BundleEntrySearchComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "search", name, element, index);
    if (element.hasModeElement()) {
      composeEnum(t, "BundleEntrySearchComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasScoreElement()) {
      composeDecimal(t, "BundleEntrySearchComponent", "score", element.getScoreElement(), -1);
    }
  }

  protected void composeBundleEntryRequestComponent(Complex parent, String parentType, String name, Bundle.BundleEntryRequestComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "request", name, element, index);
    if (element.hasMethodElement()) {
      composeEnum(t, "BundleEntryRequestComponent", "method", element.getMethodElement(), -1);
    }
    if (element.hasUrlElement()) {
      composeUri(t, "BundleEntryRequestComponent", "url", element.getUrlElement(), -1);
    }
    if (element.hasIfNoneMatchElement()) {
      composeString(t, "BundleEntryRequestComponent", "ifNoneMatch", element.getIfNoneMatchElement(), -1);
    }
    if (element.hasIfModifiedSinceElement()) {
      composeInstant(t, "BundleEntryRequestComponent", "ifModifiedSince", element.getIfModifiedSinceElement(), -1);
    }
    if (element.hasIfMatchElement()) {
      composeString(t, "BundleEntryRequestComponent", "ifMatch", element.getIfMatchElement(), -1);
    }
    if (element.hasIfNoneExistElement()) {
      composeString(t, "BundleEntryRequestComponent", "ifNoneExist", element.getIfNoneExistElement(), -1);
    }
  }

  protected void composeBundleEntryResponseComponent(Complex parent, String parentType, String name, Bundle.BundleEntryResponseComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "response", name, element, index);
    if (element.hasStatusElement()) {
      composeString(t, "BundleEntryResponseComponent", "status", element.getStatusElement(), -1);
    }
    if (element.hasLocationElement()) {
      composeUri(t, "BundleEntryResponseComponent", "location", element.getLocationElement(), -1);
    }
    if (element.hasEtagElement()) {
      composeString(t, "BundleEntryResponseComponent", "etag", element.getEtagElement(), -1);
    }
    if (element.hasLastModifiedElement()) {
      composeInstant(t, "BundleEntryResponseComponent", "lastModified", element.getLastModifiedElement(), -1);
    }
    if (element.hasOutcome()) {
      composeResource(t, "BundleEntryResponseComponent", "outcome", element.getOutcome(), -1);
    }
  }

  protected void composeCapabilityStatement(Complex parent, String parentType, String name, CapabilityStatement element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "CapabilityStatement", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "CapabilityStatement", "url", element.getUrlElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "CapabilityStatement", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "CapabilityStatement", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "CapabilityStatement", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CapabilityStatement", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "CapabilityStatement", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "CapabilityStatement", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "CapabilityStatement", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "CapabilityStatement", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "CapabilityStatement", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "CapabilityStatement", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "CapabilityStatement", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "CapabilityStatement", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "CapabilityStatement", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasKindElement()) {
      composeEnum(t, "CapabilityStatement", "kind", element.getKindElement(), -1);
    }
    for (int i = 0; i < element.getInstantiates().size(); i++) {
      composeCanonical(t, "CapabilityStatement", "instantiates", element.getInstantiates().get(i), i);
    }
    for (int i = 0; i < element.getImports().size(); i++) {
      composeCanonical(t, "CapabilityStatement", "imports", element.getImports().get(i), i);
    }
    if (element.hasSoftware()) {
      composeCapabilityStatementSoftwareComponent(t, "CapabilityStatement", "software", element.getSoftware(), -1);
    }
    if (element.hasImplementation()) {
      composeCapabilityStatementImplementationComponent(t, "CapabilityStatement", "implementation", element.getImplementation(), -1);
    }
    if (element.hasFhirVersionElement()) {
      composeEnum(t, "CapabilityStatement", "fhirVersion", element.getFhirVersionElement(), -1);
    }
    for (int i = 0; i < element.getFormat().size(); i++) {
      composeCode(t, "CapabilityStatement", "format", element.getFormat().get(i), i);
    }
    for (int i = 0; i < element.getPatchFormat().size(); i++) {
      composeCode(t, "CapabilityStatement", "patchFormat", element.getPatchFormat().get(i), i);
    }
    for (int i = 0; i < element.getImplementationGuide().size(); i++) {
      composeCanonical(t, "CapabilityStatement", "implementationGuide", element.getImplementationGuide().get(i), i);
    }
    for (int i = 0; i < element.getRest().size(); i++) {
      composeCapabilityStatementRestComponent(t, "CapabilityStatement", "rest", element.getRest().get(i), i);
    }
    for (int i = 0; i < element.getMessaging().size(); i++) {
      composeCapabilityStatementMessagingComponent(t, "CapabilityStatement", "messaging", element.getMessaging().get(i), i);
    }
    for (int i = 0; i < element.getDocument().size(); i++) {
      composeCapabilityStatementDocumentComponent(t, "CapabilityStatement", "document", element.getDocument().get(i), i);
    }
  }

  protected void composeCapabilityStatementSoftwareComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementSoftwareComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "software", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "CapabilityStatementSoftwareComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "CapabilityStatementSoftwareComponent", "version", element.getVersionElement(), -1);
    }
    if (element.hasReleaseDateElement()) {
      composeDateTime(t, "CapabilityStatementSoftwareComponent", "releaseDate", element.getReleaseDateElement(), -1);
    }
  }

  protected void composeCapabilityStatementImplementationComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementImplementationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "implementation", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "CapabilityStatementImplementationComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasUrlElement()) {
      composeUrl(t, "CapabilityStatementImplementationComponent", "url", element.getUrlElement(), -1);
    }
    if (element.hasCustodian()) {
      composeReference(t, "CapabilityStatementImplementationComponent", "custodian", element.getCustodian(), -1);
    }
  }

  protected void composeCapabilityStatementRestComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "rest", name, element, index);
    if (element.hasModeElement()) {
      composeEnum(t, "CapabilityStatementRestComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "CapabilityStatementRestComponent", "documentation", element.getDocumentationElement(), -1);
    }
    if (element.hasSecurity()) {
      composeCapabilityStatementRestSecurityComponent(t, "CapabilityStatementRestComponent", "security", element.getSecurity(), -1);
    }
    for (int i = 0; i < element.getResource().size(); i++) {
      composeCapabilityStatementRestResourceComponent(t, "CapabilityStatementRestComponent", "resource", element.getResource().get(i), i);
    }
    for (int i = 0; i < element.getInteraction().size(); i++) {
      composeCapabilityStatementSystemInteractionComponent(t, "CapabilityStatementRestComponent", "interaction", element.getInteraction().get(i), i);
    }
    for (int i = 0; i < element.getSearchParam().size(); i++) {
      composeCapabilityStatementRestResourceSearchParamComponent(t, "CapabilityStatementRestComponent", "searchParam", element.getSearchParam().get(i), i);
    }
    for (int i = 0; i < element.getOperation().size(); i++) {
      composeCapabilityStatementRestResourceOperationComponent(t, "CapabilityStatementRestComponent", "operation", element.getOperation().get(i), i);
    }
    for (int i = 0; i < element.getCompartment().size(); i++) {
      composeCanonical(t, "CapabilityStatementRestComponent", "compartment", element.getCompartment().get(i), i);
    }
  }

  protected void composeCapabilityStatementRestSecurityComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestSecurityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "security", name, element, index);
    if (element.hasCorsElement()) {
      composeBoolean(t, "CapabilityStatementRestSecurityComponent", "cors", element.getCorsElement(), -1);
    }
    for (int i = 0; i < element.getService().size(); i++) {
      composeCodeableConcept(t, "CapabilityStatementRestSecurityComponent", "service", element.getService().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "CapabilityStatementRestSecurityComponent", "description", element.getDescriptionElement(), -1);
    }
  }

  protected void composeCapabilityStatementRestResourceComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "resource", name, element, index);
    if (element.hasTypeElement()) {
      composeCode(t, "CapabilityStatementRestResourceComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasProfileElement()) {
      composeCanonical(t, "CapabilityStatementRestResourceComponent", "profile", element.getProfileElement(), -1);
    }
    for (int i = 0; i < element.getSupportedProfile().size(); i++) {
      composeCanonical(t, "CapabilityStatementRestResourceComponent", "supportedProfile", element.getSupportedProfile().get(i), i);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "CapabilityStatementRestResourceComponent", "documentation", element.getDocumentationElement(), -1);
    }
    for (int i = 0; i < element.getInteraction().size(); i++) {
      composeCapabilityStatementResourceInteractionComponent(t, "CapabilityStatementRestResourceComponent", "interaction", element.getInteraction().get(i), i);
    }
    if (element.hasVersioningElement()) {
      composeEnum(t, "CapabilityStatementRestResourceComponent", "versioning", element.getVersioningElement(), -1);
    }
    if (element.hasReadHistoryElement()) {
      composeBoolean(t, "CapabilityStatementRestResourceComponent", "readHistory", element.getReadHistoryElement(), -1);
    }
    if (element.hasUpdateCreateElement()) {
      composeBoolean(t, "CapabilityStatementRestResourceComponent", "updateCreate", element.getUpdateCreateElement(), -1);
    }
    if (element.hasConditionalCreateElement()) {
      composeBoolean(t, "CapabilityStatementRestResourceComponent", "conditionalCreate", element.getConditionalCreateElement(), -1);
    }
    if (element.hasConditionalReadElement()) {
      composeEnum(t, "CapabilityStatementRestResourceComponent", "conditionalRead", element.getConditionalReadElement(), -1);
    }
    if (element.hasConditionalUpdateElement()) {
      composeBoolean(t, "CapabilityStatementRestResourceComponent", "conditionalUpdate", element.getConditionalUpdateElement(), -1);
    }
    if (element.hasConditionalDeleteElement()) {
      composeEnum(t, "CapabilityStatementRestResourceComponent", "conditionalDelete", element.getConditionalDeleteElement(), -1);
    }
    for (int i = 0; i < element.getReferencePolicy().size(); i++) {
      composeEnum(t, "CapabilityStatementRestResourceComponent", "referencePolicy", element.getReferencePolicy().get(i), i);
    }
    for (int i = 0; i < element.getSearchInclude().size(); i++) {
      composeString(t, "CapabilityStatementRestResourceComponent", "searchInclude", element.getSearchInclude().get(i), i);
    }
    for (int i = 0; i < element.getSearchRevInclude().size(); i++) {
      composeString(t, "CapabilityStatementRestResourceComponent", "searchRevInclude", element.getSearchRevInclude().get(i), i);
    }
    for (int i = 0; i < element.getSearchParam().size(); i++) {
      composeCapabilityStatementRestResourceSearchParamComponent(t, "CapabilityStatementRestResourceComponent", "searchParam", element.getSearchParam().get(i), i);
    }
    for (int i = 0; i < element.getOperation().size(); i++) {
      composeCapabilityStatementRestResourceOperationComponent(t, "CapabilityStatementRestResourceComponent", "operation", element.getOperation().get(i), i);
    }
  }

  protected void composeCapabilityStatementResourceInteractionComponent(Complex parent, String parentType, String name, CapabilityStatement.ResourceInteractionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "interaction", name, element, index);
    if (element.hasCodeElement()) {
      composeEnum(t, "ResourceInteractionComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "ResourceInteractionComponent", "documentation", element.getDocumentationElement(), -1);
    }
  }

  protected void composeCapabilityStatementRestResourceSearchParamComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "searchParam", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "CapabilityStatementRestResourceSearchParamComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDefinitionElement()) {
      composeCanonical(t, "CapabilityStatementRestResourceSearchParamComponent", "definition", element.getDefinitionElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "CapabilityStatementRestResourceSearchParamComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "CapabilityStatementRestResourceSearchParamComponent", "documentation", element.getDocumentationElement(), -1);
    }
  }

  protected void composeCapabilityStatementRestResourceOperationComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceOperationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "operation", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "CapabilityStatementRestResourceOperationComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDefinitionElement()) {
      composeCanonical(t, "CapabilityStatementRestResourceOperationComponent", "definition", element.getDefinitionElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "CapabilityStatementRestResourceOperationComponent", "documentation", element.getDocumentationElement(), -1);
    }
  }

  protected void composeCapabilityStatementSystemInteractionComponent(Complex parent, String parentType, String name, CapabilityStatement.SystemInteractionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "interaction", name, element, index);
    if (element.hasCodeElement()) {
      composeEnum(t, "SystemInteractionComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "SystemInteractionComponent", "documentation", element.getDocumentationElement(), -1);
    }
  }

  protected void composeCapabilityStatementMessagingComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "messaging", name, element, index);
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeCapabilityStatementMessagingEndpointComponent(t, "CapabilityStatementMessagingComponent", "endpoint", element.getEndpoint().get(i), i);
    }
    if (element.hasReliableCacheElement()) {
      composeUnsignedInt(t, "CapabilityStatementMessagingComponent", "reliableCache", element.getReliableCacheElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "CapabilityStatementMessagingComponent", "documentation", element.getDocumentationElement(), -1);
    }
    for (int i = 0; i < element.getSupportedMessage().size(); i++) {
      composeCapabilityStatementMessagingSupportedMessageComponent(t, "CapabilityStatementMessagingComponent", "supportedMessage", element.getSupportedMessage().get(i), i);
    }
  }

  protected void composeCapabilityStatementMessagingEndpointComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingEndpointComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "endpoint", name, element, index);
    if (element.hasProtocol()) {
      composeCoding(t, "CapabilityStatementMessagingEndpointComponent", "protocol", element.getProtocol(), -1);
    }
    if (element.hasAddressElement()) {
      composeUrl(t, "CapabilityStatementMessagingEndpointComponent", "address", element.getAddressElement(), -1);
    }
  }

  protected void composeCapabilityStatementMessagingSupportedMessageComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "supportedMessage", name, element, index);
    if (element.hasModeElement()) {
      composeEnum(t, "CapabilityStatementMessagingSupportedMessageComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasDefinitionElement()) {
      composeCanonical(t, "CapabilityStatementMessagingSupportedMessageComponent", "definition", element.getDefinitionElement(), -1);
    }
  }

  protected void composeCapabilityStatementDocumentComponent(Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementDocumentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "document", name, element, index);
    if (element.hasModeElement()) {
      composeEnum(t, "CapabilityStatementDocumentComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeMarkdown(t, "CapabilityStatementDocumentComponent", "documentation", element.getDocumentationElement(), -1);
    }
    if (element.hasProfileElement()) {
      composeCanonical(t, "CapabilityStatementDocumentComponent", "profile", element.getProfileElement(), -1);
    }
  }

  protected void composeCarePlan(Complex parent, String parentType, String name, CarePlan element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "CarePlan", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CarePlan", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "CarePlan", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "CarePlan", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "CarePlan", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getReplaces().size(); i++) {
      composeReference(t, "CarePlan", "replaces", element.getReplaces().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "CarePlan", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CarePlan", "status", element.getStatusElement(), -1);
    }
    if (element.hasIntentElement()) {
      composeEnum(t, "CarePlan", "intent", element.getIntentElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "CarePlan", "category", element.getCategory().get(i), i);
    }
    if (element.hasTitleElement()) {
      composeString(t, "CarePlan", "title", element.getTitleElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "CarePlan", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "CarePlan", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "CarePlan", "encounter", element.getEncounter(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "CarePlan", "period", element.getPeriod(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "CarePlan", "created", element.getCreatedElement(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "CarePlan", "author", element.getAuthor(), -1);
    }
    for (int i = 0; i < element.getContributor().size(); i++) {
      composeReference(t, "CarePlan", "contributor", element.getContributor().get(i), i);
    }
    for (int i = 0; i < element.getCareTeam().size(); i++) {
      composeReference(t, "CarePlan", "careTeam", element.getCareTeam().get(i), i);
    }
    for (int i = 0; i < element.getAddresses().size(); i++) {
      composeReference(t, "CarePlan", "addresses", element.getAddresses().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeReference(t, "CarePlan", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getGoal().size(); i++) {
      composeReference(t, "CarePlan", "goal", element.getGoal().get(i), i);
    }
    for (int i = 0; i < element.getActivity().size(); i++) {
      composeCarePlanActivityComponent(t, "CarePlan", "activity", element.getActivity().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "CarePlan", "note", element.getNote().get(i), i);
    }
  }

  protected void composeCarePlanActivityComponent(Complex parent, String parentType, String name, CarePlan.CarePlanActivityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "activity", name, element, index);
    for (int i = 0; i < element.getOutcomeCodeableConcept().size(); i++) {
      composeCodeableConcept(t, "CarePlanActivityComponent", "outcomeCodeableConcept", element.getOutcomeCodeableConcept().get(i), i);
    }
    for (int i = 0; i < element.getOutcomeReference().size(); i++) {
      composeReference(t, "CarePlanActivityComponent", "outcomeReference", element.getOutcomeReference().get(i), i);
    }
    for (int i = 0; i < element.getProgress().size(); i++) {
      composeAnnotation(t, "CarePlanActivityComponent", "progress", element.getProgress().get(i), i);
    }
    if (element.hasReference()) {
      composeReference(t, "CarePlanActivityComponent", "reference", element.getReference(), -1);
    }
    if (element.hasDetail()) {
      composeCarePlanActivityDetailComponent(t, "CarePlanActivityComponent", "detail", element.getDetail(), -1);
    }
  }

  protected void composeCarePlanActivityDetailComponent(Complex parent, String parentType, String name, CarePlan.CarePlanActivityDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "detail", name, element, index);
    if (element.hasKindElement()) {
      composeEnum(t, "CarePlanActivityDetailComponent", "kind", element.getKindElement(), -1);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "CarePlanActivityDetailComponent", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "CarePlanActivityDetailComponent", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "CarePlanActivityDetailComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "CarePlanActivityDetailComponent", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "CarePlanActivityDetailComponent", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getGoal().size(); i++) {
      composeReference(t, "CarePlanActivityDetailComponent", "goal", element.getGoal().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CarePlanActivityDetailComponent", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept(t, "CarePlanActivityDetailComponent", "statusReason", element.getStatusReason(), -1);
    }
    if (element.hasDoNotPerformElement()) {
      composeBoolean(t, "CarePlanActivityDetailComponent", "doNotPerform", element.getDoNotPerformElement(), -1);
    }
    if (element.hasScheduled()) {
      composeType(t, "CarePlanActivityDetailComponent", "scheduled", element.getScheduled(), -1);
    }
    if (element.hasLocation()) {
      composeReference(t, "CarePlanActivityDetailComponent", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeReference(t, "CarePlanActivityDetailComponent", "performer", element.getPerformer().get(i), i);
    }
    if (element.hasProduct()) {
      composeType(t, "CarePlanActivityDetailComponent", "product", element.getProduct(), -1);
    }
    if (element.hasDailyAmount()) {
      composeQuantity(t, "CarePlanActivityDetailComponent", "dailyAmount", element.getDailyAmount(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "CarePlanActivityDetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "CarePlanActivityDetailComponent", "description", element.getDescriptionElement(), -1);
    }
  }

  protected void composeCareTeam(Complex parent, String parentType, String name, CareTeam element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "CareTeam", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CareTeam", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CareTeam", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "CareTeam", "category", element.getCategory().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "CareTeam", "name", element.getNameElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "CareTeam", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "CareTeam", "encounter", element.getEncounter(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "CareTeam", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeCareTeamParticipantComponent(t, "CareTeam", "participant", element.getParticipant().get(i), i);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "CareTeam", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "CareTeam", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getManagingOrganization().size(); i++) {
      composeReference(t, "CareTeam", "managingOrganization", element.getManagingOrganization().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "CareTeam", "telecom", element.getTelecom().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "CareTeam", "note", element.getNote().get(i), i);
    }
  }

  protected void composeCareTeamParticipantComponent(Complex parent, String parentType, String name, CareTeam.CareTeamParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    for (int i = 0; i < element.getRole().size(); i++) {
      composeCodeableConcept(t, "CareTeamParticipantComponent", "role", element.getRole().get(i), i);
    }
    if (element.hasMember()) {
      composeReference(t, "CareTeamParticipantComponent", "member", element.getMember(), -1);
    }
    if (element.hasOnBehalfOf()) {
      composeReference(t, "CareTeamParticipantComponent", "onBehalfOf", element.getOnBehalfOf(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "CareTeamParticipantComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeCatalogEntry(Complex parent, String parentType, String name, CatalogEntry element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "CatalogEntry", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CatalogEntry", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "CatalogEntry", "type", element.getType(), -1);
    }
    if (element.hasOrderableElement()) {
      composeBoolean(t, "CatalogEntry", "orderable", element.getOrderableElement(), -1);
    }
    if (element.hasReferencedItem()) {
      composeReference(t, "CatalogEntry", "referencedItem", element.getReferencedItem(), -1);
    }
    for (int i = 0; i < element.getAdditionalIdentifier().size(); i++) {
      composeIdentifier(t, "CatalogEntry", "additionalIdentifier", element.getAdditionalIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getClassification().size(); i++) {
      composeCodeableConcept(t, "CatalogEntry", "classification", element.getClassification().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CatalogEntry", "status", element.getStatusElement(), -1);
    }
    if (element.hasValidityPeriod()) {
      composePeriod(t, "CatalogEntry", "validityPeriod", element.getValidityPeriod(), -1);
    }
    if (element.hasValidToElement()) {
      composeDateTime(t, "CatalogEntry", "validTo", element.getValidToElement(), -1);
    }
    if (element.hasLastUpdatedElement()) {
      composeDateTime(t, "CatalogEntry", "lastUpdated", element.getLastUpdatedElement(), -1);
    }
    for (int i = 0; i < element.getAdditionalCharacteristic().size(); i++) {
      composeCodeableConcept(t, "CatalogEntry", "additionalCharacteristic", element.getAdditionalCharacteristic().get(i), i);
    }
    for (int i = 0; i < element.getAdditionalClassification().size(); i++) {
      composeCodeableConcept(t, "CatalogEntry", "additionalClassification", element.getAdditionalClassification().get(i), i);
    }
    for (int i = 0; i < element.getRelatedEntry().size(); i++) {
      composeCatalogEntryRelatedEntryComponent(t, "CatalogEntry", "relatedEntry", element.getRelatedEntry().get(i), i);
    }
  }

  protected void composeCatalogEntryRelatedEntryComponent(Complex parent, String parentType, String name, CatalogEntry.CatalogEntryRelatedEntryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatedEntry", name, element, index);
    if (element.hasRelationtypeElement()) {
      composeEnum(t, "CatalogEntryRelatedEntryComponent", "relationtype", element.getRelationtypeElement(), -1);
    }
    if (element.hasItem()) {
      composeReference(t, "CatalogEntryRelatedEntryComponent", "item", element.getItem(), -1);
    }
  }

  protected void composeChargeItem(Complex parent, String parentType, String name, ChargeItem element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ChargeItem", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ChargeItem", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getDefinitionUri().size(); i++) {
      composeUri(t, "ChargeItem", "definitionUri", element.getDefinitionUri().get(i), i);
    }
    for (int i = 0; i < element.getDefinitionCanonical().size(); i++) {
      composeCanonical(t, "ChargeItem", "definitionCanonical", element.getDefinitionCanonical().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ChargeItem", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "ChargeItem", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ChargeItem", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "ChargeItem", "subject", element.getSubject(), -1);
    }
    if (element.hasContext()) {
      composeReference(t, "ChargeItem", "context", element.getContext(), -1);
    }
    if (element.hasOccurrence()) {
      composeType(t, "ChargeItem", "occurrence", element.getOccurrence(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeChargeItemPerformerComponent(t, "ChargeItem", "performer", element.getPerformer().get(i), i);
    }
    if (element.hasPerformingOrganization()) {
      composeReference(t, "ChargeItem", "performingOrganization", element.getPerformingOrganization(), -1);
    }
    if (element.hasRequestingOrganization()) {
      composeReference(t, "ChargeItem", "requestingOrganization", element.getRequestingOrganization(), -1);
    }
    if (element.hasCostCenter()) {
      composeReference(t, "ChargeItem", "costCenter", element.getCostCenter(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "ChargeItem", "quantity", element.getQuantity(), -1);
    }
    for (int i = 0; i < element.getBodysite().size(); i++) {
      composeCodeableConcept(t, "ChargeItem", "bodysite", element.getBodysite().get(i), i);
    }
    if (element.hasFactorOverrideElement()) {
      composeDecimal(t, "ChargeItem", "factorOverride", element.getFactorOverrideElement(), -1);
    }
    if (element.hasPriceOverride()) {
      composeMoney(t, "ChargeItem", "priceOverride", element.getPriceOverride(), -1);
    }
    if (element.hasOverrideReasonElement()) {
      composeString(t, "ChargeItem", "overrideReason", element.getOverrideReasonElement(), -1);
    }
    if (element.hasEnterer()) {
      composeReference(t, "ChargeItem", "enterer", element.getEnterer(), -1);
    }
    if (element.hasEnteredDateElement()) {
      composeDateTime(t, "ChargeItem", "enteredDate", element.getEnteredDateElement(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableConcept(t, "ChargeItem", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getService().size(); i++) {
      composeReference(t, "ChargeItem", "service", element.getService().get(i), i);
    }
    if (element.hasProduct()) {
      composeType(t, "ChargeItem", "product", element.getProduct(), -1);
    }
    for (int i = 0; i < element.getAccount().size(); i++) {
      composeReference(t, "ChargeItem", "account", element.getAccount().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "ChargeItem", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInformation().size(); i++) {
      composeReference(t, "ChargeItem", "supportingInformation", element.getSupportingInformation().get(i), i);
    }
  }

  protected void composeChargeItemPerformerComponent(Complex parent, String parentType, String name, ChargeItem.ChargeItemPerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "ChargeItemPerformerComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "ChargeItemPerformerComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeChargeItemDefinition(Complex parent, String parentType, String name, ChargeItemDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ChargeItemDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ChargeItemDefinition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ChargeItemDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ChargeItemDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ChargeItemDefinition", "title", element.getTitleElement(), -1);
    }
    for (int i = 0; i < element.getDerivedFromUri().size(); i++) {
      composeUri(t, "ChargeItemDefinition", "derivedFromUri", element.getDerivedFromUri().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeCanonical(t, "ChargeItemDefinition", "partOf", element.getPartOf().get(i), i);
    }
    for (int i = 0; i < element.getReplaces().size(); i++) {
      composeCanonical(t, "ChargeItemDefinition", "replaces", element.getReplaces().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ChargeItemDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "ChargeItemDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ChargeItemDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "ChargeItemDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ChargeItemDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ChargeItemDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "ChargeItemDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "ChargeItemDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ChargeItemDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "ChargeItemDefinition", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "ChargeItemDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "ChargeItemDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ChargeItemDefinition", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getInstance().size(); i++) {
      composeReference(t, "ChargeItemDefinition", "instance", element.getInstance().get(i), i);
    }
    for (int i = 0; i < element.getApplicability().size(); i++) {
      composeChargeItemDefinitionApplicabilityComponent(t, "ChargeItemDefinition", "applicability", element.getApplicability().get(i), i);
    }
    for (int i = 0; i < element.getPropertyGroup().size(); i++) {
      composeChargeItemDefinitionPropertyGroupComponent(t, "ChargeItemDefinition", "propertyGroup", element.getPropertyGroup().get(i), i);
    }
  }

  protected void composeChargeItemDefinitionApplicabilityComponent(Complex parent, String parentType, String name, ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "applicability", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "ChargeItemDefinitionApplicabilityComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasLanguageElement()) {
      composeString(t, "ChargeItemDefinitionApplicabilityComponent", "language", element.getLanguageElement(), -1);
    }
    if (element.hasExpressionElement()) {
      composeString(t, "ChargeItemDefinitionApplicabilityComponent", "expression", element.getExpressionElement(), -1);
    }
  }

  protected void composeChargeItemDefinitionPropertyGroupComponent(Complex parent, String parentType, String name, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "propertyGroup", name, element, index);
    for (int i = 0; i < element.getApplicability().size(); i++) {
      composeChargeItemDefinitionApplicabilityComponent(t, "ChargeItemDefinitionPropertyGroupComponent", "applicability", element.getApplicability().get(i), i);
    }
    for (int i = 0; i < element.getPriceComponent().size(); i++) {
      composeChargeItemDefinitionPropertyGroupPriceComponentComponent(t, "ChargeItemDefinitionPropertyGroupComponent", "priceComponent", element.getPriceComponent().get(i), i);
    }
  }

  protected void composeChargeItemDefinitionPropertyGroupPriceComponentComponent(Complex parent, String parentType, String name, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "priceComponent", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "ChargeItemDefinitionPropertyGroupPriceComponentComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ChargeItemDefinitionPropertyGroupPriceComponentComponent", "code", element.getCode(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "ChargeItemDefinitionPropertyGroupPriceComponentComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "ChargeItemDefinitionPropertyGroupPriceComponentComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composeCitation(Complex parent, String parentType, String name, Citation element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Citation", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "Citation", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Citation", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Citation", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Citation", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Citation", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Citation", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "Citation", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "Citation", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "Citation", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "Citation", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "Citation", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "Citation", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "Citation", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "Citation", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "Citation", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "Citation", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "Citation", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "Citation", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "Citation", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "Citation", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "Citation", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "Citation", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getSummary().size(); i++) {
      composeContactDetail(t, "Citation", "summary", element.getSummary().get(i), i);
    }
    for (int i = 0; i < element.getClassification().size(); i++) {
      composeCitationClassificationComponent(t, "Citation", "classification", element.getClassification().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Citation", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getCurrentState().size(); i++) {
      composeCodeableConcept(t, "Citation", "currentState", element.getCurrentState().get(i), i);
    }
    for (int i = 0; i < element.getStatusDate().size(); i++) {
      composeCitationStatusDateComponent(t, "Citation", "statusDate", element.getStatusDate().get(i), i);
    }
    for (int i = 0; i < element.getRelatesTo().size(); i++) {
      composeCitationRelatesToComponent(t, "Citation", "relatesTo", element.getRelatesTo().get(i), i);
    }
    if (element.hasCitedArtifact()) {
      composeCitationCitedArtifactComponent(t, "Citation", "citedArtifact", element.getCitedArtifact(), -1);
    }
  }

  protected void composeCitationClassificationComponent(Complex parent, String parentType, String name, Citation.CitationClassificationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "classification", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CitationClassificationComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getClassifier().size(); i++) {
      composeCodeableConcept(t, "CitationClassificationComponent", "classifier", element.getClassifier().get(i), i);
    }
  }

  protected void composeCitationStatusDateComponent(Complex parent, String parentType, String name, Citation.CitationStatusDateComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "statusDate", name, element, index);
    if (element.hasActivity()) {
      composeCodeableConcept(t, "CitationStatusDateComponent", "activity", element.getActivity(), -1);
    }
    if (element.hasActualElement()) {
      composeBoolean(t, "CitationStatusDateComponent", "actual", element.getActualElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "CitationStatusDateComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeCitationRelatesToComponent(Complex parent, String parentType, String name, Citation.CitationRelatesToComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatesTo", name, element, index);
    if (element.hasRelationshipType()) {
      composeCodeableConcept(t, "CitationRelatesToComponent", "relationshipType", element.getRelationshipType(), -1);
    }
    for (int i = 0; i < element.getTargetClassifier().size(); i++) {
      composeCodeableConcept(t, "CitationRelatesToComponent", "targetClassifier", element.getTargetClassifier().get(i), i);
    }
    if (element.hasTarget()) {
      composeType(t, "CitationRelatesToComponent", "target", element.getTarget(), -1);
    }
  }

  protected void composeCitationCitedArtifactComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "citedArtifact", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CitationCitedArtifactComponent", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getRelatedIdentifier().size(); i++) {
      composeIdentifier(t, "CitationCitedArtifactComponent", "relatedIdentifier", element.getRelatedIdentifier().get(i), i);
    }
    if (element.hasDateAccessedElement()) {
      composeDateTime(t, "CitationCitedArtifactComponent", "dateAccessed", element.getDateAccessedElement(), -1);
    }
    if (element.hasVersion()) {
      composeCitationCitedArtifactVersionComponent(t, "CitationCitedArtifactComponent", "version", element.getVersion(), -1);
    }
    for (int i = 0; i < element.getCurrentState().size(); i++) {
      composeCodeableConcept(t, "CitationCitedArtifactComponent", "currentState", element.getCurrentState().get(i), i);
    }
    for (int i = 0; i < element.getStatusDate().size(); i++) {
      composeCitationCitedArtifactStatusDateComponent(t, "CitationCitedArtifactComponent", "statusDate", element.getStatusDate().get(i), i);
    }
    for (int i = 0; i < element.getTitle().size(); i++) {
      composeCitationCitedArtifactTitleComponent(t, "CitationCitedArtifactComponent", "title", element.getTitle().get(i), i);
    }
    for (int i = 0; i < element.getAbstract().size(); i++) {
      composeCitationCitedArtifactAbstractComponent(t, "CitationCitedArtifactComponent", "abstract", element.getAbstract().get(i), i);
    }
    if (element.hasPart()) {
      composeCitationCitedArtifactPartComponent(t, "CitationCitedArtifactComponent", "part", element.getPart(), -1);
    }
    for (int i = 0; i < element.getRelatesTo().size(); i++) {
      composeCitationCitedArtifactRelatesToComponent(t, "CitationCitedArtifactComponent", "relatesTo", element.getRelatesTo().get(i), i);
    }
    for (int i = 0; i < element.getPublicationForm().size(); i++) {
      composeCitationCitedArtifactPublicationFormComponent(t, "CitationCitedArtifactComponent", "publicationForm", element.getPublicationForm().get(i), i);
    }
    for (int i = 0; i < element.getWebLocation().size(); i++) {
      composeCitationCitedArtifactWebLocationComponent(t, "CitationCitedArtifactComponent", "webLocation", element.getWebLocation().get(i), i);
    }
    for (int i = 0; i < element.getClassification().size(); i++) {
      composeCitationCitedArtifactClassificationComponent(t, "CitationCitedArtifactComponent", "classification", element.getClassification().get(i), i);
    }
    if (element.hasContributorship()) {
      composeCitationCitedArtifactContributorshipComponent(t, "CitationCitedArtifactComponent", "contributorship", element.getContributorship(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "CitationCitedArtifactComponent", "note", element.getNote().get(i), i);
    }
  }

  protected void composeCitationCitedArtifactVersionComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactVersionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "version", name, element, index);
    if (element.hasValueElement()) {
      composeString(t, "CitationCitedArtifactVersionComponent", "value", element.getValueElement(), -1);
    }
    if (element.hasBaseCitation()) {
      composeReference(t, "CitationCitedArtifactVersionComponent", "baseCitation", element.getBaseCitation(), -1);
    }
  }

  protected void composeCitationCitedArtifactStatusDateComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactStatusDateComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "statusDate", name, element, index);
    if (element.hasActivity()) {
      composeCodeableConcept(t, "CitationCitedArtifactStatusDateComponent", "activity", element.getActivity(), -1);
    }
    if (element.hasActualElement()) {
      composeBoolean(t, "CitationCitedArtifactStatusDateComponent", "actual", element.getActualElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "CitationCitedArtifactStatusDateComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeCitationCitedArtifactTitleComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactTitleComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "title", name, element, index);
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "CitationCitedArtifactTitleComponent", "type", element.getType().get(i), i);
    }
    if (element.hasLanguage()) {
      composeCodeableConcept(t, "CitationCitedArtifactTitleComponent", "language", element.getLanguage(), -1);
    }
    if (element.hasTextElement()) {
      composeMarkdown(t, "CitationCitedArtifactTitleComponent", "text", element.getTextElement(), -1);
    }
  }

  protected void composeCitationCitedArtifactAbstractComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactAbstractComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "abstract", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CitationCitedArtifactAbstractComponent", "type", element.getType(), -1);
    }
    if (element.hasLanguage()) {
      composeCodeableConcept(t, "CitationCitedArtifactAbstractComponent", "language", element.getLanguage(), -1);
    }
    if (element.hasTextElement()) {
      composeMarkdown(t, "CitationCitedArtifactAbstractComponent", "text", element.getTextElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "CitationCitedArtifactAbstractComponent", "copyright", element.getCopyrightElement(), -1);
    }
  }

  protected void composeCitationCitedArtifactPartComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactPartComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "part", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CitationCitedArtifactPartComponent", "type", element.getType(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "CitationCitedArtifactPartComponent", "value", element.getValueElement(), -1);
    }
    if (element.hasBaseCitation()) {
      composeReference(t, "CitationCitedArtifactPartComponent", "baseCitation", element.getBaseCitation(), -1);
    }
  }

  protected void composeCitationCitedArtifactRelatesToComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactRelatesToComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatesTo", name, element, index);
    if (element.hasRelationshipType()) {
      composeCodeableConcept(t, "CitationCitedArtifactRelatesToComponent", "relationshipType", element.getRelationshipType(), -1);
    }
    for (int i = 0; i < element.getTargetClassifier().size(); i++) {
      composeCodeableConcept(t, "CitationCitedArtifactRelatesToComponent", "targetClassifier", element.getTargetClassifier().get(i), i);
    }
    if (element.hasTarget()) {
      composeType(t, "CitationCitedArtifactRelatesToComponent", "target", element.getTarget(), -1);
    }
  }

  protected void composeCitationCitedArtifactPublicationFormComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactPublicationFormComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "publicationForm", name, element, index);
    if (element.hasPublishedIn()) {
      composeCitationCitedArtifactPublicationFormPublishedInComponent(t, "CitationCitedArtifactPublicationFormComponent", "publishedIn", element.getPublishedIn(), -1);
    }
    if (element.hasPeriodicRelease()) {
      composeCitationCitedArtifactPublicationFormPeriodicReleaseComponent(t, "CitationCitedArtifactPublicationFormComponent", "periodicRelease", element.getPeriodicRelease(), -1);
    }
    if (element.hasArticleDateElement()) {
      composeDateTime(t, "CitationCitedArtifactPublicationFormComponent", "articleDate", element.getArticleDateElement(), -1);
    }
    if (element.hasLastRevisionDateElement()) {
      composeDateTime(t, "CitationCitedArtifactPublicationFormComponent", "lastRevisionDate", element.getLastRevisionDateElement(), -1);
    }
    for (int i = 0; i < element.getLanguage().size(); i++) {
      composeCodeableConcept(t, "CitationCitedArtifactPublicationFormComponent", "language", element.getLanguage().get(i), i);
    }
    if (element.hasAccessionNumberElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "accessionNumber", element.getAccessionNumberElement(), -1);
    }
    if (element.hasPageStringElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "pageString", element.getPageStringElement(), -1);
    }
    if (element.hasFirstPageElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "firstPage", element.getFirstPageElement(), -1);
    }
    if (element.hasLastPageElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "lastPage", element.getLastPageElement(), -1);
    }
    if (element.hasPageCountElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormComponent", "pageCount", element.getPageCountElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "CitationCitedArtifactPublicationFormComponent", "copyright", element.getCopyrightElement(), -1);
    }
  }

  protected void composeCitationCitedArtifactPublicationFormPublishedInComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactPublicationFormPublishedInComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "publishedIn", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasTitleElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasPublisher()) {
      composeReference(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "publisher", element.getPublisher(), -1);
    }
    if (element.hasPublisherLocationElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "publisherLocation", element.getPublisherLocationElement(), -1);
    }
  }

  protected void composeCitationCitedArtifactPublicationFormPeriodicReleaseComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactPublicationFormPeriodicReleaseComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "periodicRelease", name, element, index);
    if (element.hasCitedMedium()) {
      composeCodeableConcept(t, "CitationCitedArtifactPublicationFormPeriodicReleaseComponent", "citedMedium", element.getCitedMedium(), -1);
    }
    if (element.hasVolumeElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormPeriodicReleaseComponent", "volume", element.getVolumeElement(), -1);
    }
    if (element.hasIssueElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormPeriodicReleaseComponent", "issue", element.getIssueElement(), -1);
    }
    if (element.hasDateOfPublication()) {
      composeCitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent(t, "CitationCitedArtifactPublicationFormPeriodicReleaseComponent", "dateOfPublication", element.getDateOfPublication(), -1);
    }
  }

  protected void composeCitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dateOfPublication", name, element, index);
    if (element.hasDateElement()) {
      composeDate(t, "CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasYearElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent", "year", element.getYearElement(), -1);
    }
    if (element.hasMonthElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent", "month", element.getMonthElement(), -1);
    }
    if (element.hasDayElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent", "day", element.getDayElement(), -1);
    }
    if (element.hasSeasonElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent", "season", element.getSeasonElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "CitationCitedArtifactPublicationFormPeriodicReleaseDateOfPublicationComponent", "text", element.getTextElement(), -1);
    }
  }

  protected void composeCitationCitedArtifactWebLocationComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactWebLocationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "webLocation", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CitationCitedArtifactWebLocationComponent", "type", element.getType(), -1);
    }
    if (element.hasUrlElement()) {
      composeUri(t, "CitationCitedArtifactWebLocationComponent", "url", element.getUrlElement(), -1);
    }
  }

  protected void composeCitationCitedArtifactClassificationComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactClassificationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "classification", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CitationCitedArtifactClassificationComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getClassifier().size(); i++) {
      composeCodeableConcept(t, "CitationCitedArtifactClassificationComponent", "classifier", element.getClassifier().get(i), i);
    }
    if (element.hasWhoClassified()) {
      composeCitationCitedArtifactClassificationWhoClassifiedComponent(t, "CitationCitedArtifactClassificationComponent", "whoClassified", element.getWhoClassified(), -1);
    }
  }

  protected void composeCitationCitedArtifactClassificationWhoClassifiedComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactClassificationWhoClassifiedComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "whoClassified", name, element, index);
    if (element.hasPerson()) {
      composeReference(t, "CitationCitedArtifactClassificationWhoClassifiedComponent", "person", element.getPerson(), -1);
    }
    if (element.hasOrganization()) {
      composeReference(t, "CitationCitedArtifactClassificationWhoClassifiedComponent", "organization", element.getOrganization(), -1);
    }
    if (element.hasPublisher()) {
      composeReference(t, "CitationCitedArtifactClassificationWhoClassifiedComponent", "publisher", element.getPublisher(), -1);
    }
    if (element.hasClassifierCopyrightElement()) {
      composeString(t, "CitationCitedArtifactClassificationWhoClassifiedComponent", "classifierCopyright", element.getClassifierCopyrightElement(), -1);
    }
    if (element.hasFreeToShareElement()) {
      composeBoolean(t, "CitationCitedArtifactClassificationWhoClassifiedComponent", "freeToShare", element.getFreeToShareElement(), -1);
    }
  }

  protected void composeCitationCitedArtifactContributorshipComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "contributorship", name, element, index);
    if (element.hasCompleteElement()) {
      composeBoolean(t, "CitationCitedArtifactContributorshipComponent", "complete", element.getCompleteElement(), -1);
    }
    for (int i = 0; i < element.getEntry().size(); i++) {
      composeCitationCitedArtifactContributorshipEntryComponent(t, "CitationCitedArtifactContributorshipComponent", "entry", element.getEntry().get(i), i);
    }
    for (int i = 0; i < element.getSummary().size(); i++) {
      composeCitationCitedArtifactContributorshipSummaryComponent(t, "CitationCitedArtifactContributorshipComponent", "summary", element.getSummary().get(i), i);
    }
  }

  protected void composeCitationCitedArtifactContributorshipEntryComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipEntryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "entry", name, element, index);
    if (element.hasName()) {
      composeHumanName(t, "CitationCitedArtifactContributorshipEntryComponent", "name", element.getName(), -1);
    }
    if (element.hasInitialsElement()) {
      composeString(t, "CitationCitedArtifactContributorshipEntryComponent", "initials", element.getInitialsElement(), -1);
    }
    if (element.hasCollectiveNameElement()) {
      composeString(t, "CitationCitedArtifactContributorshipEntryComponent", "collectiveName", element.getCollectiveNameElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CitationCitedArtifactContributorshipEntryComponent", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getAffiliationInfo().size(); i++) {
      composeCitationCitedArtifactContributorshipEntryAffiliationInfoComponent(t, "CitationCitedArtifactContributorshipEntryComponent", "affiliationInfo", element.getAffiliationInfo().get(i), i);
    }
    for (int i = 0; i < element.getAddress().size(); i++) {
      composeAddress(t, "CitationCitedArtifactContributorshipEntryComponent", "address", element.getAddress().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "CitationCitedArtifactContributorshipEntryComponent", "telecom", element.getTelecom().get(i), i);
    }
    for (int i = 0; i < element.getContributionType().size(); i++) {
      composeCodeableConcept(t, "CitationCitedArtifactContributorshipEntryComponent", "contributionType", element.getContributionType().get(i), i);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "CitationCitedArtifactContributorshipEntryComponent", "role", element.getRole(), -1);
    }
    for (int i = 0; i < element.getContributionInstance().size(); i++) {
      composeCitationCitedArtifactContributorshipEntryContributionInstanceComponent(t, "CitationCitedArtifactContributorshipEntryComponent", "contributionInstance", element.getContributionInstance().get(i), i);
    }
    if (element.hasCorrespondingContactElement()) {
      composeBoolean(t, "CitationCitedArtifactContributorshipEntryComponent", "correspondingContact", element.getCorrespondingContactElement(), -1);
    }
    if (element.hasListOrderElement()) {
      composePositiveInt(t, "CitationCitedArtifactContributorshipEntryComponent", "listOrder", element.getListOrderElement(), -1);
    }
  }

  protected void composeCitationCitedArtifactContributorshipEntryAffiliationInfoComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipEntryAffiliationInfoComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "affiliationInfo", name, element, index);
    if (element.hasAffiliationElement()) {
      composeString(t, "CitationCitedArtifactContributorshipEntryAffiliationInfoComponent", "affiliation", element.getAffiliationElement(), -1);
    }
    if (element.hasRoleElement()) {
      composeString(t, "CitationCitedArtifactContributorshipEntryAffiliationInfoComponent", "role", element.getRoleElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CitationCitedArtifactContributorshipEntryAffiliationInfoComponent", "identifier", element.getIdentifier().get(i), i);
    }
  }

  protected void composeCitationCitedArtifactContributorshipEntryContributionInstanceComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "contributionInstance", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CitationCitedArtifactContributorshipEntryContributionInstanceComponent", "type", element.getType(), -1);
    }
    if (element.hasTimeElement()) {
      composeDateTime(t, "CitationCitedArtifactContributorshipEntryContributionInstanceComponent", "time", element.getTimeElement(), -1);
    }
  }

  protected void composeCitationCitedArtifactContributorshipSummaryComponent(Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipSummaryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "summary", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CitationCitedArtifactContributorshipSummaryComponent", "type", element.getType(), -1);
    }
    if (element.hasStyle()) {
      composeCodeableConcept(t, "CitationCitedArtifactContributorshipSummaryComponent", "style", element.getStyle(), -1);
    }
    if (element.hasSource()) {
      composeCodeableConcept(t, "CitationCitedArtifactContributorshipSummaryComponent", "source", element.getSource(), -1);
    }
    if (element.hasValueElement()) {
      composeMarkdown(t, "CitationCitedArtifactContributorshipSummaryComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeClaim(Complex parent, String parentType, String name, Claim element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Claim", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Claim", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Claim", "status", element.getStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Claim", "type", element.getType(), -1);
    }
    if (element.hasSubType()) {
      composeCodeableConcept(t, "Claim", "subType", element.getSubType(), -1);
    }
    if (element.hasUseElement()) {
      composeEnum(t, "Claim", "use", element.getUseElement(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "Claim", "patient", element.getPatient(), -1);
    }
    if (element.hasBillablePeriod()) {
      composePeriod(t, "Claim", "billablePeriod", element.getBillablePeriod(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "Claim", "created", element.getCreatedElement(), -1);
    }
    if (element.hasEnterer()) {
      composeReference(t, "Claim", "enterer", element.getEnterer(), -1);
    }
    if (element.hasInsurer()) {
      composeReference(t, "Claim", "insurer", element.getInsurer(), -1);
    }
    if (element.hasProvider()) {
      composeReference(t, "Claim", "provider", element.getProvider(), -1);
    }
    if (element.hasPriority()) {
      composeCodeableConcept(t, "Claim", "priority", element.getPriority(), -1);
    }
    if (element.hasFundsReserve()) {
      composeCodeableConcept(t, "Claim", "fundsReserve", element.getFundsReserve(), -1);
    }
    for (int i = 0; i < element.getRelated().size(); i++) {
      composeClaimRelatedClaimComponent(t, "Claim", "related", element.getRelated().get(i), i);
    }
    if (element.hasPrescription()) {
      composeReference(t, "Claim", "prescription", element.getPrescription(), -1);
    }
    if (element.hasOriginalPrescription()) {
      composeReference(t, "Claim", "originalPrescription", element.getOriginalPrescription(), -1);
    }
    if (element.hasPayee()) {
      composeClaimPayeeComponent(t, "Claim", "payee", element.getPayee(), -1);
    }
    if (element.hasReferral()) {
      composeReference(t, "Claim", "referral", element.getReferral(), -1);
    }
    if (element.hasFacility()) {
      composeReference(t, "Claim", "facility", element.getFacility(), -1);
    }
    for (int i = 0; i < element.getCareTeam().size(); i++) {
      composeClaimCareTeamComponent(t, "Claim", "careTeam", element.getCareTeam().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeClaimSupportingInformationComponent(t, "Claim", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getDiagnosis().size(); i++) {
      composeClaimDiagnosisComponent(t, "Claim", "diagnosis", element.getDiagnosis().get(i), i);
    }
    for (int i = 0; i < element.getProcedure().size(); i++) {
      composeClaimProcedureComponent(t, "Claim", "procedure", element.getProcedure().get(i), i);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeClaimInsuranceComponent(t, "Claim", "insurance", element.getInsurance().get(i), i);
    }
    if (element.hasAccident()) {
      composeClaimAccidentComponent(t, "Claim", "accident", element.getAccident(), -1);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeClaimItemComponent(t, "Claim", "item", element.getItem().get(i), i);
    }
    if (element.hasTotal()) {
      composeMoney(t, "Claim", "total", element.getTotal(), -1);
    }
  }

  protected void composeClaimRelatedClaimComponent(Complex parent, String parentType, String name, Claim.RelatedClaimComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "related", name, element, index);
    if (element.hasClaim()) {
      composeReference(t, "RelatedClaimComponent", "claim", element.getClaim(), -1);
    }
    if (element.hasRelationship()) {
      composeCodeableConcept(t, "RelatedClaimComponent", "relationship", element.getRelationship(), -1);
    }
    if (element.hasReference()) {
      composeIdentifier(t, "RelatedClaimComponent", "reference", element.getReference(), -1);
    }
  }

  protected void composeClaimPayeeComponent(Complex parent, String parentType, String name, Claim.PayeeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "payee", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "PayeeComponent", "type", element.getType(), -1);
    }
    if (element.hasParty()) {
      composeReference(t, "PayeeComponent", "party", element.getParty(), -1);
    }
  }

  protected void composeClaimCareTeamComponent(Complex parent, String parentType, String name, Claim.CareTeamComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "careTeam", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "CareTeamComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasProvider()) {
      composeReference(t, "CareTeamComponent", "provider", element.getProvider(), -1);
    }
    if (element.hasResponsibleElement()) {
      composeBoolean(t, "CareTeamComponent", "responsible", element.getResponsibleElement(), -1);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "CareTeamComponent", "role", element.getRole(), -1);
    }
    if (element.hasQualification()) {
      composeCodeableConcept(t, "CareTeamComponent", "qualification", element.getQualification(), -1);
    }
  }

  protected void composeClaimSupportingInformationComponent(Complex parent, String parentType, String name, Claim.SupportingInformationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "supportingInfo", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "SupportingInformationComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "SupportingInformationComponent", "category", element.getCategory(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "SupportingInformationComponent", "code", element.getCode(), -1);
    }
    if (element.hasTiming()) {
      composeType(t, "SupportingInformationComponent", "timing", element.getTiming(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "SupportingInformationComponent", "value", element.getValue(), -1);
    }
    if (element.hasReason()) {
      composeCodeableConcept(t, "SupportingInformationComponent", "reason", element.getReason(), -1);
    }
  }

  protected void composeClaimDiagnosisComponent(Complex parent, String parentType, String name, Claim.DiagnosisComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "diagnosis", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "DiagnosisComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasDiagnosis()) {
      composeType(t, "DiagnosisComponent", "diagnosis", element.getDiagnosis(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "DiagnosisComponent", "type", element.getType().get(i), i);
    }
    if (element.hasOnAdmission()) {
      composeCodeableConcept(t, "DiagnosisComponent", "onAdmission", element.getOnAdmission(), -1);
    }
    if (element.hasPackageCode()) {
      composeCodeableConcept(t, "DiagnosisComponent", "packageCode", element.getPackageCode(), -1);
    }
  }

  protected void composeClaimProcedureComponent(Complex parent, String parentType, String name, Claim.ProcedureComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "procedure", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "ProcedureComponent", "sequence", element.getSequenceElement(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "ProcedureComponent", "type", element.getType().get(i), i);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ProcedureComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasProcedure()) {
      composeType(t, "ProcedureComponent", "procedure", element.getProcedure(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "ProcedureComponent", "udi", element.getUdi().get(i), i);
    }
  }

  protected void composeClaimInsuranceComponent(Complex parent, String parentType, String name, Claim.InsuranceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "insurance", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "InsuranceComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasFocalElement()) {
      composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
    }
    if (element.hasIdentifier()) {
      composeIdentifier(t, "InsuranceComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasCoverage()) {
      composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
    }
    if (element.hasBusinessArrangementElement()) {
      composeString(t, "InsuranceComponent", "businessArrangement", element.getBusinessArrangementElement(), -1);
    }
    for (int i = 0; i < element.getPreAuthRef().size(); i++) {
      composeString(t, "InsuranceComponent", "preAuthRef", element.getPreAuthRef().get(i), i);
    }
    if (element.hasClaimResponse()) {
      composeReference(t, "InsuranceComponent", "claimResponse", element.getClaimResponse(), -1);
    }
  }

  protected void composeClaimAccidentComponent(Complex parent, String parentType, String name, Claim.AccidentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "accident", name, element, index);
    if (element.hasDateElement()) {
      composeDate(t, "AccidentComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "AccidentComponent", "type", element.getType(), -1);
    }
    if (element.hasLocation()) {
      composeType(t, "AccidentComponent", "location", element.getLocation(), -1);
    }
  }

  protected void composeClaimItemComponent(Complex parent, String parentType, String name, Claim.ItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "ItemComponent", "sequence", element.getSequenceElement(), -1);
    }
    for (int i = 0; i < element.getCareTeamSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "careTeamSequence", element.getCareTeamSequence().get(i), i);
    }
    for (int i = 0; i < element.getDiagnosisSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "diagnosisSequence", element.getDiagnosisSequence().get(i), i);
    }
    for (int i = 0; i < element.getProcedureSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "procedureSequence", element.getProcedureSequence().get(i), i);
    }
    for (int i = 0; i < element.getInformationSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "informationSequence", element.getInformationSequence().get(i), i);
    }
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "ItemComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "ItemComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "ItemComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "ItemComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "ItemComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasServiced()) {
      composeType(t, "ItemComponent", "serviced", element.getServiced(), -1);
    }
    if (element.hasLocation()) {
      composeType(t, "ItemComponent", "location", element.getLocation(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "ItemComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "ItemComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "ItemComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "ItemComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "ItemComponent", "udi", element.getUdi().get(i), i);
    }
    if (element.hasBodySite()) {
      composeCodeableConcept(t, "ItemComponent", "bodySite", element.getBodySite(), -1);
    }
    for (int i = 0; i < element.getSubSite().size(); i++) {
      composeCodeableConcept(t, "ItemComponent", "subSite", element.getSubSite().get(i), i);
    }
    for (int i = 0; i < element.getEncounter().size(); i++) {
      composeReference(t, "ItemComponent", "encounter", element.getEncounter().get(i), i);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeClaimDetailComponent(t, "ItemComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeClaimDetailComponent(Complex parent, String parentType, String name, Claim.DetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "detail", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "DetailComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "DetailComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "DetailComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "DetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "DetailComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "DetailComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "DetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "DetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "DetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "DetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "DetailComponent", "udi", element.getUdi().get(i), i);
    }
    for (int i = 0; i < element.getSubDetail().size(); i++) {
      composeClaimSubDetailComponent(t, "DetailComponent", "subDetail", element.getSubDetail().get(i), i);
    }
  }

  protected void composeClaimSubDetailComponent(Complex parent, String parentType, String name, Claim.SubDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "subDetail", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "SubDetailComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "SubDetailComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "SubDetailComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "SubDetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "SubDetailComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "SubDetailComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "SubDetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "SubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "SubDetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "SubDetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "SubDetailComponent", "udi", element.getUdi().get(i), i);
    }
  }

  protected void composeClaimResponse(Complex parent, String parentType, String name, ClaimResponse element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ClaimResponse", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ClaimResponse", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ClaimResponse", "status", element.getStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ClaimResponse", "type", element.getType(), -1);
    }
    if (element.hasSubType()) {
      composeCodeableConcept(t, "ClaimResponse", "subType", element.getSubType(), -1);
    }
    if (element.hasUseElement()) {
      composeEnum(t, "ClaimResponse", "use", element.getUseElement(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "ClaimResponse", "patient", element.getPatient(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "ClaimResponse", "created", element.getCreatedElement(), -1);
    }
    if (element.hasInsurer()) {
      composeReference(t, "ClaimResponse", "insurer", element.getInsurer(), -1);
    }
    if (element.hasRequestor()) {
      composeReference(t, "ClaimResponse", "requestor", element.getRequestor(), -1);
    }
    if (element.hasRequest()) {
      composeReference(t, "ClaimResponse", "request", element.getRequest(), -1);
    }
    if (element.hasOutcomeElement()) {
      composeEnum(t, "ClaimResponse", "outcome", element.getOutcomeElement(), -1);
    }
    if (element.hasDispositionElement()) {
      composeString(t, "ClaimResponse", "disposition", element.getDispositionElement(), -1);
    }
    if (element.hasPreAuthRefElement()) {
      composeString(t, "ClaimResponse", "preAuthRef", element.getPreAuthRefElement(), -1);
    }
    if (element.hasPreAuthPeriod()) {
      composePeriod(t, "ClaimResponse", "preAuthPeriod", element.getPreAuthPeriod(), -1);
    }
    if (element.hasPayeeType()) {
      composeCodeableConcept(t, "ClaimResponse", "payeeType", element.getPayeeType(), -1);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeClaimResponseItemComponent(t, "ClaimResponse", "item", element.getItem().get(i), i);
    }
    for (int i = 0; i < element.getAddItem().size(); i++) {
      composeClaimResponseAddedItemComponent(t, "ClaimResponse", "addItem", element.getAddItem().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeClaimResponseAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getTotal().size(); i++) {
      composeClaimResponseTotalComponent(t, "ClaimResponse", "total", element.getTotal().get(i), i);
    }
    if (element.hasPayment()) {
      composeClaimResponsePaymentComponent(t, "ClaimResponse", "payment", element.getPayment(), -1);
    }
    if (element.hasFundsReserve()) {
      composeCodeableConcept(t, "ClaimResponse", "fundsReserve", element.getFundsReserve(), -1);
    }
    if (element.hasFormCode()) {
      composeCodeableConcept(t, "ClaimResponse", "formCode", element.getFormCode(), -1);
    }
    if (element.hasForm()) {
      composeAttachment(t, "ClaimResponse", "form", element.getForm(), -1);
    }
    for (int i = 0; i < element.getProcessNote().size(); i++) {
      composeClaimResponseNoteComponent(t, "ClaimResponse", "processNote", element.getProcessNote().get(i), i);
    }
    for (int i = 0; i < element.getCommunicationRequest().size(); i++) {
      composeReference(t, "ClaimResponse", "communicationRequest", element.getCommunicationRequest().get(i), i);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeClaimResponseInsuranceComponent(t, "ClaimResponse", "insurance", element.getInsurance().get(i), i);
    }
    for (int i = 0; i < element.getError().size(); i++) {
      composeClaimResponseErrorComponent(t, "ClaimResponse", "error", element.getError().get(i), i);
    }
  }

  protected void composeClaimResponseItemComponent(Complex parent, String parentType, String name, ClaimResponse.ItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    if (element.hasItemSequenceElement()) {
      composePositiveInt(t, "ItemComponent", "itemSequence", element.getItemSequenceElement(), -1);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "ItemComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeClaimResponseAdjudicationComponent(t, "ItemComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeClaimResponseItemDetailComponent(t, "ItemComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeClaimResponseAdjudicationComponent(Complex parent, String parentType, String name, ClaimResponse.AdjudicationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "adjudication", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "AdjudicationComponent", "category", element.getCategory(), -1);
    }
    if (element.hasReason()) {
      composeCodeableConcept(t, "AdjudicationComponent", "reason", element.getReason(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "AdjudicationComponent", "amount", element.getAmount(), -1);
    }
    if (element.hasValueElement()) {
      composeDecimal(t, "AdjudicationComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeClaimResponseItemDetailComponent(Complex parent, String parentType, String name, ClaimResponse.ItemDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "detail", name, element, index);
    if (element.hasDetailSequenceElement()) {
      composePositiveInt(t, "ItemDetailComponent", "detailSequence", element.getDetailSequenceElement(), -1);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "ItemDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeClaimResponseAdjudicationComponent(t, "ItemDetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getSubDetail().size(); i++) {
      composeClaimResponseSubDetailComponent(t, "ItemDetailComponent", "subDetail", element.getSubDetail().get(i), i);
    }
  }

  protected void composeClaimResponseSubDetailComponent(Complex parent, String parentType, String name, ClaimResponse.SubDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "subDetail", name, element, index);
    if (element.hasSubDetailSequenceElement()) {
      composePositiveInt(t, "SubDetailComponent", "subDetailSequence", element.getSubDetailSequenceElement(), -1);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "SubDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeClaimResponseAdjudicationComponent(t, "SubDetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
  }

  protected void composeClaimResponseAddedItemComponent(Complex parent, String parentType, String name, ClaimResponse.AddedItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "addItem", name, element, index);
    for (int i = 0; i < element.getItemSequence().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "itemSequence", element.getItemSequence().get(i), i);
    }
    for (int i = 0; i < element.getDetailSequence().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "detailSequence", element.getDetailSequence().get(i), i);
    }
    for (int i = 0; i < element.getSubdetailSequence().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "subdetailSequence", element.getSubdetailSequence().get(i), i);
    }
    for (int i = 0; i < element.getProvider().size(); i++) {
      composeReference(t, "AddedItemComponent", "provider", element.getProvider().get(i), i);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "AddedItemComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "AddedItemComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "AddedItemComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasServiced()) {
      composeType(t, "AddedItemComponent", "serviced", element.getServiced(), -1);
    }
    if (element.hasLocation()) {
      composeType(t, "AddedItemComponent", "location", element.getLocation(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "AddedItemComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "AddedItemComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "AddedItemComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "AddedItemComponent", "net", element.getNet(), -1);
    }
    if (element.hasBodySite()) {
      composeCodeableConcept(t, "AddedItemComponent", "bodySite", element.getBodySite(), -1);
    }
    for (int i = 0; i < element.getSubSite().size(); i++) {
      composeCodeableConcept(t, "AddedItemComponent", "subSite", element.getSubSite().get(i), i);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeClaimResponseAdjudicationComponent(t, "AddedItemComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeClaimResponseAddedItemDetailComponent(t, "AddedItemComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeClaimResponseAddedItemDetailComponent(Complex parent, String parentType, String name, ClaimResponse.AddedItemDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "detail", name, element, index);
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "AddedItemDetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "AddedItemDetailComponent", "modifier", element.getModifier().get(i), i);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "AddedItemDetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "AddedItemDetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "AddedItemDetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "AddedItemDetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "AddedItemDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeClaimResponseAdjudicationComponent(t, "AddedItemDetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getSubDetail().size(); i++) {
      composeClaimResponseAddedItemSubDetailComponent(t, "AddedItemDetailComponent", "subDetail", element.getSubDetail().get(i), i);
    }
  }

  protected void composeClaimResponseAddedItemSubDetailComponent(Complex parent, String parentType, String name, ClaimResponse.AddedItemSubDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "subDetail", name, element, index);
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "AddedItemSubDetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "AddedItemSubDetailComponent", "modifier", element.getModifier().get(i), i);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "AddedItemSubDetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "AddedItemSubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "AddedItemSubDetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "AddedItemSubDetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "AddedItemSubDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeClaimResponseAdjudicationComponent(t, "AddedItemSubDetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
  }

  protected void composeClaimResponseTotalComponent(Complex parent, String parentType, String name, ClaimResponse.TotalComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "total", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "TotalComponent", "category", element.getCategory(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "TotalComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composeClaimResponsePaymentComponent(Complex parent, String parentType, String name, ClaimResponse.PaymentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "payment", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "PaymentComponent", "type", element.getType(), -1);
    }
    if (element.hasAdjustment()) {
      composeMoney(t, "PaymentComponent", "adjustment", element.getAdjustment(), -1);
    }
    if (element.hasAdjustmentReason()) {
      composeCodeableConcept(t, "PaymentComponent", "adjustmentReason", element.getAdjustmentReason(), -1);
    }
    if (element.hasDateElement()) {
      composeDate(t, "PaymentComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "PaymentComponent", "amount", element.getAmount(), -1);
    }
    if (element.hasIdentifier()) {
      composeIdentifier(t, "PaymentComponent", "identifier", element.getIdentifier(), -1);
    }
  }

  protected void composeClaimResponseNoteComponent(Complex parent, String parentType, String name, ClaimResponse.NoteComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "processNote", name, element, index);
    if (element.hasNumberElement()) {
      composePositiveInt(t, "NoteComponent", "number", element.getNumberElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "NoteComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "NoteComponent", "text", element.getTextElement(), -1);
    }
    if (element.hasLanguage()) {
      composeCodeableConcept(t, "NoteComponent", "language", element.getLanguage(), -1);
    }
  }

  protected void composeClaimResponseInsuranceComponent(Complex parent, String parentType, String name, ClaimResponse.InsuranceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "insurance", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "InsuranceComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasFocalElement()) {
      composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
    }
    if (element.hasCoverage()) {
      composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
    }
    if (element.hasBusinessArrangementElement()) {
      composeString(t, "InsuranceComponent", "businessArrangement", element.getBusinessArrangementElement(), -1);
    }
    if (element.hasClaimResponse()) {
      composeReference(t, "InsuranceComponent", "claimResponse", element.getClaimResponse(), -1);
    }
  }

  protected void composeClaimResponseErrorComponent(Complex parent, String parentType, String name, ClaimResponse.ErrorComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "error", name, element, index);
    if (element.hasItemSequenceElement()) {
      composePositiveInt(t, "ErrorComponent", "itemSequence", element.getItemSequenceElement(), -1);
    }
    if (element.hasDetailSequenceElement()) {
      composePositiveInt(t, "ErrorComponent", "detailSequence", element.getDetailSequenceElement(), -1);
    }
    if (element.hasSubDetailSequenceElement()) {
      composePositiveInt(t, "ErrorComponent", "subDetailSequence", element.getSubDetailSequenceElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ErrorComponent", "code", element.getCode(), -1);
    }
  }

  protected void composeClinicalImpression(Complex parent, String parentType, String name, ClinicalImpression element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ClinicalImpression", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ClinicalImpression", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ClinicalImpression", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept(t, "ClinicalImpression", "statusReason", element.getStatusReason(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ClinicalImpression", "code", element.getCode(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ClinicalImpression", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "ClinicalImpression", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "ClinicalImpression", "encounter", element.getEncounter(), -1);
    }
    if (element.hasEffective()) {
      composeType(t, "ClinicalImpression", "effective", element.getEffective(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ClinicalImpression", "date", element.getDateElement(), -1);
    }
    if (element.hasAssessor()) {
      composeReference(t, "ClinicalImpression", "assessor", element.getAssessor(), -1);
    }
    if (element.hasPrevious()) {
      composeReference(t, "ClinicalImpression", "previous", element.getPrevious(), -1);
    }
    for (int i = 0; i < element.getProblem().size(); i++) {
      composeReference(t, "ClinicalImpression", "problem", element.getProblem().get(i), i);
    }
    for (int i = 0; i < element.getInvestigation().size(); i++) {
      composeClinicalImpressionInvestigationComponent(t, "ClinicalImpression", "investigation", element.getInvestigation().get(i), i);
    }
    for (int i = 0; i < element.getProtocol().size(); i++) {
      composeUri(t, "ClinicalImpression", "protocol", element.getProtocol().get(i), i);
    }
    if (element.hasSummaryElement()) {
      composeString(t, "ClinicalImpression", "summary", element.getSummaryElement(), -1);
    }
    for (int i = 0; i < element.getFinding().size(); i++) {
      composeClinicalImpressionFindingComponent(t, "ClinicalImpression", "finding", element.getFinding().get(i), i);
    }
    for (int i = 0; i < element.getPrognosisCodeableConcept().size(); i++) {
      composeCodeableConcept(t, "ClinicalImpression", "prognosisCodeableConcept", element.getPrognosisCodeableConcept().get(i), i);
    }
    for (int i = 0; i < element.getPrognosisReference().size(); i++) {
      composeReference(t, "ClinicalImpression", "prognosisReference", element.getPrognosisReference().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeReference(t, "ClinicalImpression", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "ClinicalImpression", "note", element.getNote().get(i), i);
    }
  }

  protected void composeClinicalImpressionInvestigationComponent(Complex parent, String parentType, String name, ClinicalImpression.ClinicalImpressionInvestigationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "investigation", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "ClinicalImpressionInvestigationComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeReference(t, "ClinicalImpressionInvestigationComponent", "item", element.getItem().get(i), i);
    }
  }

  protected void composeClinicalImpressionFindingComponent(Complex parent, String parentType, String name, ClinicalImpression.ClinicalImpressionFindingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "finding", name, element, index);
    if (element.hasItemCodeableConcept()) {
      composeCodeableConcept(t, "ClinicalImpressionFindingComponent", "itemCodeableConcept", element.getItemCodeableConcept(), -1);
    }
    if (element.hasItemReference()) {
      composeReference(t, "ClinicalImpressionFindingComponent", "itemReference", element.getItemReference(), -1);
    }
    if (element.hasBasisElement()) {
      composeString(t, "ClinicalImpressionFindingComponent", "basis", element.getBasisElement(), -1);
    }
  }

  protected void composeClinicalUseDefinition(Complex parent, String parentType, String name, ClinicalUseDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ClinicalUseDefinition", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ClinicalUseDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "ClinicalUseDefinition", "type", element.getTypeElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "ClinicalUseDefinition", "category", element.getCategory().get(i), i);
    }
    for (int i = 0; i < element.getSubject().size(); i++) {
      composeReference(t, "ClinicalUseDefinition", "subject", element.getSubject().get(i), i);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "ClinicalUseDefinition", "status", element.getStatus(), -1);
    }
    if (element.hasContraindication()) {
      composeClinicalUseDefinitionContraindicationComponent(t, "ClinicalUseDefinition", "contraindication", element.getContraindication(), -1);
    }
    if (element.hasIndication()) {
      composeClinicalUseDefinitionIndicationComponent(t, "ClinicalUseDefinition", "indication", element.getIndication(), -1);
    }
    if (element.hasInteraction()) {
      composeClinicalUseDefinitionInteractionComponent(t, "ClinicalUseDefinition", "interaction", element.getInteraction(), -1);
    }
    for (int i = 0; i < element.getPopulation().size(); i++) {
      composeReference(t, "ClinicalUseDefinition", "population", element.getPopulation().get(i), i);
    }
    if (element.hasUndesirableEffect()) {
      composeClinicalUseDefinitionUndesirableEffectComponent(t, "ClinicalUseDefinition", "undesirableEffect", element.getUndesirableEffect(), -1);
    }
    if (element.hasWarning()) {
      composeClinicalUseDefinitionWarningComponent(t, "ClinicalUseDefinition", "warning", element.getWarning(), -1);
    }
  }

  protected void composeClinicalUseDefinitionContraindicationComponent(Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "contraindication", name, element, index);
    if (element.hasDiseaseSymptomProcedure()) {
      composeCodeableReference(t, "ClinicalUseDefinitionContraindicationComponent", "diseaseSymptomProcedure", element.getDiseaseSymptomProcedure(), -1);
    }
    if (element.hasDiseaseStatus()) {
      composeCodeableReference(t, "ClinicalUseDefinitionContraindicationComponent", "diseaseStatus", element.getDiseaseStatus(), -1);
    }
    for (int i = 0; i < element.getComorbidity().size(); i++) {
      composeCodeableReference(t, "ClinicalUseDefinitionContraindicationComponent", "comorbidity", element.getComorbidity().get(i), i);
    }
    for (int i = 0; i < element.getIndication().size(); i++) {
      composeReference(t, "ClinicalUseDefinitionContraindicationComponent", "indication", element.getIndication().get(i), i);
    }
    for (int i = 0; i < element.getOtherTherapy().size(); i++) {
      composeClinicalUseDefinitionContraindicationOtherTherapyComponent(t, "ClinicalUseDefinitionContraindicationComponent", "otherTherapy", element.getOtherTherapy().get(i), i);
    }
  }

  protected void composeClinicalUseDefinitionContraindicationOtherTherapyComponent(Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "otherTherapy", name, element, index);
    if (element.hasRelationshipType()) {
      composeCodeableConcept(t, "ClinicalUseDefinitionContraindicationOtherTherapyComponent", "relationshipType", element.getRelationshipType(), -1);
    }
    if (element.hasTherapy()) {
      composeCodeableReference(t, "ClinicalUseDefinitionContraindicationOtherTherapyComponent", "therapy", element.getTherapy(), -1);
    }
  }

  protected void composeClinicalUseDefinitionIndicationComponent(Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "indication", name, element, index);
    if (element.hasDiseaseSymptomProcedure()) {
      composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "diseaseSymptomProcedure", element.getDiseaseSymptomProcedure(), -1);
    }
    if (element.hasDiseaseStatus()) {
      composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "diseaseStatus", element.getDiseaseStatus(), -1);
    }
    for (int i = 0; i < element.getComorbidity().size(); i++) {
      composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "comorbidity", element.getComorbidity().get(i), i);
    }
    if (element.hasIntendedEffect()) {
      composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "intendedEffect", element.getIntendedEffect(), -1);
    }
    if (element.hasDuration()) {
      composeQuantity(t, "ClinicalUseDefinitionIndicationComponent", "duration", element.getDuration(), -1);
    }
    for (int i = 0; i < element.getUndesirableEffect().size(); i++) {
      composeReference(t, "ClinicalUseDefinitionIndicationComponent", "undesirableEffect", element.getUndesirableEffect().get(i), i);
    }
    for (int i = 0; i < element.getOtherTherapy().size(); i++) {
      composeClinicalUseDefinitionContraindicationOtherTherapyComponent(t, "ClinicalUseDefinitionIndicationComponent", "otherTherapy", element.getOtherTherapy().get(i), i);
    }
  }

  protected void composeClinicalUseDefinitionInteractionComponent(Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "interaction", name, element, index);
    for (int i = 0; i < element.getInteractant().size(); i++) {
      composeClinicalUseDefinitionInteractionInteractantComponent(t, "ClinicalUseDefinitionInteractionComponent", "interactant", element.getInteractant().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ClinicalUseDefinitionInteractionComponent", "type", element.getType(), -1);
    }
    if (element.hasEffect()) {
      composeCodeableReference(t, "ClinicalUseDefinitionInteractionComponent", "effect", element.getEffect(), -1);
    }
    if (element.hasIncidence()) {
      composeCodeableConcept(t, "ClinicalUseDefinitionInteractionComponent", "incidence", element.getIncidence(), -1);
    }
    for (int i = 0; i < element.getManagement().size(); i++) {
      composeCodeableConcept(t, "ClinicalUseDefinitionInteractionComponent", "management", element.getManagement().get(i), i);
    }
  }

  protected void composeClinicalUseDefinitionInteractionInteractantComponent(Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "interactant", name, element, index);
    if (element.hasItem()) {
      composeType(t, "ClinicalUseDefinitionInteractionInteractantComponent", "item", element.getItem(), -1);
    }
  }

  protected void composeClinicalUseDefinitionUndesirableEffectComponent(Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "undesirableEffect", name, element, index);
    if (element.hasSymptomConditionEffect()) {
      composeCodeableReference(t, "ClinicalUseDefinitionUndesirableEffectComponent", "symptomConditionEffect", element.getSymptomConditionEffect(), -1);
    }
    if (element.hasClassification()) {
      composeCodeableConcept(t, "ClinicalUseDefinitionUndesirableEffectComponent", "classification", element.getClassification(), -1);
    }
    if (element.hasFrequencyOfOccurrence()) {
      composeCodeableConcept(t, "ClinicalUseDefinitionUndesirableEffectComponent", "frequencyOfOccurrence", element.getFrequencyOfOccurrence(), -1);
    }
  }

  protected void composeClinicalUseDefinitionWarningComponent(Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "warning", name, element, index);
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ClinicalUseDefinitionWarningComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ClinicalUseDefinitionWarningComponent", "code", element.getCode(), -1);
    }
  }

  protected void composeCodeSystem(Complex parent, String parentType, String name, CodeSystem element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "CodeSystem", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "CodeSystem", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CodeSystem", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "CodeSystem", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "CodeSystem", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "CodeSystem", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CodeSystem", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "CodeSystem", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "CodeSystem", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "CodeSystem", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "CodeSystem", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "CodeSystem", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "CodeSystem", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "CodeSystem", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "CodeSystem", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "CodeSystem", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasCaseSensitiveElement()) {
      composeBoolean(t, "CodeSystem", "caseSensitive", element.getCaseSensitiveElement(), -1);
    }
    if (element.hasValueSetElement()) {
      composeCanonical(t, "CodeSystem", "valueSet", element.getValueSetElement(), -1);
    }
    if (element.hasHierarchyMeaningElement()) {
      composeEnum(t, "CodeSystem", "hierarchyMeaning", element.getHierarchyMeaningElement(), -1);
    }
    if (element.hasCompositionalElement()) {
      composeBoolean(t, "CodeSystem", "compositional", element.getCompositionalElement(), -1);
    }
    if (element.hasVersionNeededElement()) {
      composeBoolean(t, "CodeSystem", "versionNeeded", element.getVersionNeededElement(), -1);
    }
    if (element.hasContentElement()) {
      composeEnum(t, "CodeSystem", "content", element.getContentElement(), -1);
    }
    if (element.hasSupplementsElement()) {
      composeCanonical(t, "CodeSystem", "supplements", element.getSupplementsElement(), -1);
    }
    if (element.hasCountElement()) {
      composeUnsignedInt(t, "CodeSystem", "count", element.getCountElement(), -1);
    }
    for (int i = 0; i < element.getFilter().size(); i++) {
      composeCodeSystemFilterComponent(t, "CodeSystem", "filter", element.getFilter().get(i), i);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeCodeSystemPropertyComponent(t, "CodeSystem", "property", element.getProperty().get(i), i);
    }
    for (int i = 0; i < element.getConcept().size(); i++) {
      composeCodeSystemConceptDefinitionComponent(t, "CodeSystem", "concept", element.getConcept().get(i), i);
    }
  }

  protected void composeCodeSystemFilterComponent(Complex parent, String parentType, String name, CodeSystem.CodeSystemFilterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "filter", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "CodeSystemFilterComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "CodeSystemFilterComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getOperator().size(); i++) {
      composeEnum(t, "CodeSystemFilterComponent", "operator", element.getOperator().get(i), i);
    }
    if (element.hasValueElement()) {
      composeString(t, "CodeSystemFilterComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeCodeSystemPropertyComponent(Complex parent, String parentType, String name, CodeSystem.PropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "PropertyComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasUriElement()) {
      composeUri(t, "PropertyComponent", "uri", element.getUriElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "PropertyComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "PropertyComponent", "type", element.getTypeElement(), -1);
    }
  }

  protected void composeCodeSystemConceptDefinitionComponent(Complex parent, String parentType, String name, CodeSystem.ConceptDefinitionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "concept", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "ConceptDefinitionComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "ConceptDefinitionComponent", "display", element.getDisplayElement(), -1);
    }
    if (element.hasDefinitionElement()) {
      composeString(t, "ConceptDefinitionComponent", "definition", element.getDefinitionElement(), -1);
    }
    for (int i = 0; i < element.getDesignation().size(); i++) {
      composeCodeSystemConceptDefinitionDesignationComponent(t, "ConceptDefinitionComponent", "designation", element.getDesignation().get(i), i);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeCodeSystemConceptPropertyComponent(t, "ConceptDefinitionComponent", "property", element.getProperty().get(i), i);
    }
    for (int i = 0; i < element.getConcept().size(); i++) {
      composeCodeSystemConceptDefinitionComponent(t, "ConceptDefinitionComponent", "concept", element.getConcept().get(i), i);
    }
  }

  protected void composeCodeSystemConceptDefinitionDesignationComponent(Complex parent, String parentType, String name, CodeSystem.ConceptDefinitionDesignationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "designation", name, element, index);
    if (element.hasLanguageElement()) {
      composeCode(t, "ConceptDefinitionDesignationComponent", "language", element.getLanguageElement(), -1);
    }
    if (element.hasUse()) {
      composeCoding(t, "ConceptDefinitionDesignationComponent", "use", element.getUse(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "ConceptDefinitionDesignationComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeCodeSystemConceptPropertyComponent(Complex parent, String parentType, String name, CodeSystem.ConceptPropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "ConceptPropertyComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "ConceptPropertyComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeCommunication(Complex parent, String parentType, String name, Communication element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Communication", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Communication", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "Communication", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "Communication", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "Communication", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "Communication", "partOf", element.getPartOf().get(i), i);
    }
    for (int i = 0; i < element.getInResponseTo().size(); i++) {
      composeReference(t, "Communication", "inResponseTo", element.getInResponseTo().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Communication", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept(t, "Communication", "statusReason", element.getStatusReason(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Communication", "category", element.getCategory().get(i), i);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "Communication", "priority", element.getPriorityElement(), -1);
    }
    for (int i = 0; i < element.getMedium().size(); i++) {
      composeCodeableConcept(t, "Communication", "medium", element.getMedium().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "Communication", "subject", element.getSubject(), -1);
    }
    if (element.hasTopic()) {
      composeCodeableConcept(t, "Communication", "topic", element.getTopic(), -1);
    }
    for (int i = 0; i < element.getAbout().size(); i++) {
      composeReference(t, "Communication", "about", element.getAbout().get(i), i);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Communication", "encounter", element.getEncounter(), -1);
    }
    if (element.hasSentElement()) {
      composeDateTime(t, "Communication", "sent", element.getSentElement(), -1);
    }
    if (element.hasReceivedElement()) {
      composeDateTime(t, "Communication", "received", element.getReceivedElement(), -1);
    }
    for (int i = 0; i < element.getRecipient().size(); i++) {
      composeReference(t, "Communication", "recipient", element.getRecipient().get(i), i);
    }
    if (element.hasSender()) {
      composeReference(t, "Communication", "sender", element.getSender(), -1);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "Communication", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "Communication", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getPayload().size(); i++) {
      composeCommunicationPayloadComponent(t, "Communication", "payload", element.getPayload().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Communication", "note", element.getNote().get(i), i);
    }
  }

  protected void composeCommunicationPayloadComponent(Complex parent, String parentType, String name, Communication.CommunicationPayloadComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "payload", name, element, index);
    if (element.hasContent()) {
      composeType(t, "CommunicationPayloadComponent", "content", element.getContent(), -1);
    }
  }

  protected void composeCommunicationRequest(Complex parent, String parentType, String name, CommunicationRequest element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "CommunicationRequest", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CommunicationRequest", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "CommunicationRequest", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getReplaces().size(); i++) {
      composeReference(t, "CommunicationRequest", "replaces", element.getReplaces().get(i), i);
    }
    if (element.hasGroupIdentifier()) {
      composeIdentifier(t, "CommunicationRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CommunicationRequest", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept(t, "CommunicationRequest", "statusReason", element.getStatusReason(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "CommunicationRequest", "category", element.getCategory().get(i), i);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "CommunicationRequest", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasDoNotPerformElement()) {
      composeBoolean(t, "CommunicationRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
    }
    for (int i = 0; i < element.getMedium().size(); i++) {
      composeCodeableConcept(t, "CommunicationRequest", "medium", element.getMedium().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "CommunicationRequest", "subject", element.getSubject(), -1);
    }
    for (int i = 0; i < element.getAbout().size(); i++) {
      composeReference(t, "CommunicationRequest", "about", element.getAbout().get(i), i);
    }
    if (element.hasEncounter()) {
      composeReference(t, "CommunicationRequest", "encounter", element.getEncounter(), -1);
    }
    for (int i = 0; i < element.getPayload().size(); i++) {
      composeCommunicationRequestPayloadComponent(t, "CommunicationRequest", "payload", element.getPayload().get(i), i);
    }
    if (element.hasOccurrence()) {
      composeType(t, "CommunicationRequest", "occurrence", element.getOccurrence(), -1);
    }
    if (element.hasAuthoredOnElement()) {
      composeDateTime(t, "CommunicationRequest", "authoredOn", element.getAuthoredOnElement(), -1);
    }
    if (element.hasRequester()) {
      composeReference(t, "CommunicationRequest", "requester", element.getRequester(), -1);
    }
    for (int i = 0; i < element.getRecipient().size(); i++) {
      composeReference(t, "CommunicationRequest", "recipient", element.getRecipient().get(i), i);
    }
    if (element.hasSender()) {
      composeReference(t, "CommunicationRequest", "sender", element.getSender(), -1);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "CommunicationRequest", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "CommunicationRequest", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "CommunicationRequest", "note", element.getNote().get(i), i);
    }
  }

  protected void composeCommunicationRequestPayloadComponent(Complex parent, String parentType, String name, CommunicationRequest.CommunicationRequestPayloadComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "payload", name, element, index);
    if (element.hasContent()) {
      composeType(t, "CommunicationRequestPayloadComponent", "content", element.getContent(), -1);
    }
  }

  protected void composeCompartmentDefinition(Complex parent, String parentType, String name, CompartmentDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "CompartmentDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "CompartmentDefinition", "url", element.getUrlElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "CompartmentDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "CompartmentDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CompartmentDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "CompartmentDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "CompartmentDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "CompartmentDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "CompartmentDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "CompartmentDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "CompartmentDefinition", "useContext", element.getUseContext().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "CompartmentDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeEnum(t, "CompartmentDefinition", "code", element.getCodeElement(), -1);
    }
    if (element.hasSearchElement()) {
      composeBoolean(t, "CompartmentDefinition", "search", element.getSearchElement(), -1);
    }
    for (int i = 0; i < element.getResource().size(); i++) {
      composeCompartmentDefinitionResourceComponent(t, "CompartmentDefinition", "resource", element.getResource().get(i), i);
    }
  }

  protected void composeCompartmentDefinitionResourceComponent(Complex parent, String parentType, String name, CompartmentDefinition.CompartmentDefinitionResourceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "resource", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "CompartmentDefinitionResourceComponent", "code", element.getCodeElement(), -1);
    }
    for (int i = 0; i < element.getParam().size(); i++) {
      composeString(t, "CompartmentDefinitionResourceComponent", "param", element.getParam().get(i), i);
    }
    if (element.hasDocumentationElement()) {
      composeString(t, "CompartmentDefinitionResourceComponent", "documentation", element.getDocumentationElement(), -1);
    }
  }

  protected void composeComposition(Complex parent, String parentType, String name, Composition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Composition", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "Composition", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Composition", "status", element.getStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Composition", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Composition", "category", element.getCategory().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "Composition", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Composition", "encounter", element.getEncounter(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "Composition", "date", element.getDateElement(), -1);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeReference(t, "Composition", "author", element.getAuthor().get(i), i);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Composition", "title", element.getTitleElement(), -1);
    }
    if (element.hasConfidentialityElement()) {
      composeCode(t, "Composition", "confidentiality", element.getConfidentialityElement(), -1);
    }
    for (int i = 0; i < element.getAttester().size(); i++) {
      composeCompositionAttesterComponent(t, "Composition", "attester", element.getAttester().get(i), i);
    }
    if (element.hasCustodian()) {
      composeReference(t, "Composition", "custodian", element.getCustodian(), -1);
    }
    for (int i = 0; i < element.getRelatesTo().size(); i++) {
      composeCompositionRelatesToComponent(t, "Composition", "relatesTo", element.getRelatesTo().get(i), i);
    }
    for (int i = 0; i < element.getEvent().size(); i++) {
      composeCompositionEventComponent(t, "Composition", "event", element.getEvent().get(i), i);
    }
    for (int i = 0; i < element.getSection().size(); i++) {
      composeCompositionSectionComponent(t, "Composition", "section", element.getSection().get(i), i);
    }
  }

  protected void composeCompositionAttesterComponent(Complex parent, String parentType, String name, Composition.CompositionAttesterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "attester", name, element, index);
    if (element.hasModeElement()) {
      composeEnum(t, "CompositionAttesterComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasTimeElement()) {
      composeDateTime(t, "CompositionAttesterComponent", "time", element.getTimeElement(), -1);
    }
    if (element.hasParty()) {
      composeReference(t, "CompositionAttesterComponent", "party", element.getParty(), -1);
    }
  }

  protected void composeCompositionRelatesToComponent(Complex parent, String parentType, String name, Composition.CompositionRelatesToComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatesTo", name, element, index);
    if (element.hasCodeElement()) {
      composeEnum(t, "CompositionRelatesToComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasTarget()) {
      composeType(t, "CompositionRelatesToComponent", "target", element.getTarget(), -1);
    }
  }

  protected void composeCompositionEventComponent(Complex parent, String parentType, String name, Composition.CompositionEventComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "event", name, element, index);
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "CompositionEventComponent", "code", element.getCode().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "CompositionEventComponent", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeReference(t, "CompositionEventComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeCompositionSectionComponent(Complex parent, String parentType, String name, Composition.SectionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "section", name, element, index);
    if (element.hasTitleElement()) {
      composeString(t, "SectionComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "SectionComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeReference(t, "SectionComponent", "author", element.getAuthor().get(i), i);
    }
    if (element.hasFocus()) {
      composeReference(t, "SectionComponent", "focus", element.getFocus(), -1);
    }
    if (element.hasText()) {
      composeNarrative(t, "SectionComponent", "text", element.getText(), -1);
    }
    if (element.hasModeElement()) {
      composeEnum(t, "SectionComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasOrderedBy()) {
      composeCodeableConcept(t, "SectionComponent", "orderedBy", element.getOrderedBy(), -1);
    }
    for (int i = 0; i < element.getEntry().size(); i++) {
      composeReference(t, "SectionComponent", "entry", element.getEntry().get(i), i);
    }
    if (element.hasEmptyReason()) {
      composeCodeableConcept(t, "SectionComponent", "emptyReason", element.getEmptyReason(), -1);
    }
    for (int i = 0; i < element.getSection().size(); i++) {
      composeCompositionSectionComponent(t, "SectionComponent", "section", element.getSection().get(i), i);
    }
  }

  protected void composeConceptMap(Complex parent, String parentType, String name, ConceptMap element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ConceptMap", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ConceptMap", "url", element.getUrlElement(), -1);
    }
    if (element.hasIdentifier()) {
      composeIdentifier(t, "ConceptMap", "identifier", element.getIdentifierFirstRep(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ConceptMap", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ConceptMap", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ConceptMap", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ConceptMap", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "ConceptMap", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ConceptMap", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "ConceptMap", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ConceptMap", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ConceptMap", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "ConceptMap", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "ConceptMap", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "ConceptMap", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ConceptMap", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasSource()) {
      composeType(t, "ConceptMap", "source", element.getSource(), -1);
    }
    if (element.hasTarget()) {
      composeType(t, "ConceptMap", "target", element.getTarget(), -1);
    }
    for (int i = 0; i < element.getGroup().size(); i++) {
      composeConceptMapGroupComponent(t, "ConceptMap", "group", element.getGroup().get(i), i);
    }
  }

  protected void composeConceptMapGroupComponent(Complex parent, String parentType, String name, ConceptMap.ConceptMapGroupComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "group", name, element, index);
    if (element.hasSourceElement()) {
      composeUri(t, "ConceptMapGroupComponent", "source", element.getSourceElement(), -1);
    }
    if (element.hasSourceVersionElement()) {
      composeString(t, "ConceptMapGroupComponent", "sourceVersion", element.getSourceVersionElement(), -1);
    }
    if (element.hasTargetElement()) {
      composeUri(t, "ConceptMapGroupComponent", "target", element.getTargetElement(), -1);
    }
    if (element.hasTargetVersionElement()) {
      composeString(t, "ConceptMapGroupComponent", "targetVersion", element.getTargetVersionElement(), -1);
    }
    for (int i = 0; i < element.getElement().size(); i++) {
      composeConceptMapSourceElementComponent(t, "ConceptMapGroupComponent", "element", element.getElement().get(i), i);
    }
    if (element.hasUnmapped()) {
      composeConceptMapGroupUnmappedComponent(t, "ConceptMapGroupComponent", "unmapped", element.getUnmapped(), -1);
    }
  }

  protected void composeConceptMapSourceElementComponent(Complex parent, String parentType, String name, ConceptMap.SourceElementComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "element", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "SourceElementComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "SourceElementComponent", "display", element.getDisplayElement(), -1);
    }
    for (int i = 0; i < element.getTarget().size(); i++) {
      composeConceptMapTargetElementComponent(t, "SourceElementComponent", "target", element.getTarget().get(i), i);
    }
  }

  protected void composeConceptMapTargetElementComponent(Complex parent, String parentType, String name, ConceptMap.TargetElementComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "target", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "TargetElementComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "TargetElementComponent", "display", element.getDisplayElement(), -1);
    }
    if (element.hasEquivalenceElement()) {
      composeEnum(t, "TargetElementComponent", "equivalence", element.getEquivalenceElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeString(t, "TargetElementComponent", "comment", element.getCommentElement(), -1);
    }
    for (int i = 0; i < element.getDependsOn().size(); i++) {
      composeConceptMapOtherElementComponent(t, "TargetElementComponent", "dependsOn", element.getDependsOn().get(i), i);
    }
    for (int i = 0; i < element.getProduct().size(); i++) {
      composeConceptMapOtherElementComponent(t, "TargetElementComponent", "product", element.getProduct().get(i), i);
    }
  }

  protected void composeConceptMapOtherElementComponent(Complex parent, String parentType, String name, ConceptMap.OtherElementComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dependsOn", name, element, index);
    if (element.hasPropertyElement()) {
      composeUri(t, "OtherElementComponent", "property", element.getPropertyElement(), -1);
    }
    if (element.hasSystemElement()) {
      composeCanonical(t, "OtherElementComponent", "system", element.getSystemElement(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "OtherElementComponent", "value", element.getValueElement(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "OtherElementComponent", "display", element.getDisplayElement(), -1);
    }
  }

  protected void composeConceptMapGroupUnmappedComponent(Complex parent, String parentType, String name, ConceptMap.ConceptMapGroupUnmappedComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "unmapped", name, element, index);
    if (element.hasModeElement()) {
      composeEnum(t, "ConceptMapGroupUnmappedComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeCode(t, "ConceptMapGroupUnmappedComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "ConceptMapGroupUnmappedComponent", "display", element.getDisplayElement(), -1);
    }
    if (element.hasUrlElement()) {
      composeCanonical(t, "ConceptMapGroupUnmappedComponent", "url", element.getUrlElement(), -1);
    }
  }

  protected void composeCondition(Complex parent, String parentType, String name, Condition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Condition", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Condition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasClinicalStatus()) {
      composeCodeableConcept(t, "Condition", "clinicalStatus", element.getClinicalStatus(), -1);
    }
    if (element.hasVerificationStatus()) {
      composeCodeableConcept(t, "Condition", "verificationStatus", element.getVerificationStatus(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Condition", "category", element.getCategory().get(i), i);
    }
    if (element.hasSeverity()) {
      composeCodeableConcept(t, "Condition", "severity", element.getSeverity(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Condition", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getBodySite().size(); i++) {
      composeCodeableConcept(t, "Condition", "bodySite", element.getBodySite().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "Condition", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Condition", "encounter", element.getEncounter(), -1);
    }
    if (element.hasOnset()) {
      composeType(t, "Condition", "onset", element.getOnset(), -1);
    }
    if (element.hasAbatement()) {
      composeType(t, "Condition", "abatement", element.getAbatement(), -1);
    }
    if (element.hasRecordedDateElement()) {
      composeDateTime(t, "Condition", "recordedDate", element.getRecordedDateElement(), -1);
    }
    if (element.hasRecorder()) {
      composeReference(t, "Condition", "recorder", element.getRecorder(), -1);
    }
    if (element.hasAsserter()) {
      composeReference(t, "Condition", "asserter", element.getAsserter(), -1);
    }
    for (int i = 0; i < element.getStage().size(); i++) {
      composeConditionStageComponent(t, "Condition", "stage", element.getStage().get(i), i);
    }
    for (int i = 0; i < element.getEvidence().size(); i++) {
      composeConditionEvidenceComponent(t, "Condition", "evidence", element.getEvidence().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Condition", "note", element.getNote().get(i), i);
    }
  }

  protected void composeConditionStageComponent(Complex parent, String parentType, String name, Condition.ConditionStageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "stage", name, element, index);
    if (element.hasSummary()) {
      composeCodeableConcept(t, "ConditionStageComponent", "summary", element.getSummary(), -1);
    }
    for (int i = 0; i < element.getAssessment().size(); i++) {
      composeReference(t, "ConditionStageComponent", "assessment", element.getAssessment().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ConditionStageComponent", "type", element.getType(), -1);
    }
  }

  protected void composeConditionEvidenceComponent(Complex parent, String parentType, String name, Condition.ConditionEvidenceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "evidence", name, element, index);
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "ConditionEvidenceComponent", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeReference(t, "ConditionEvidenceComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeConsent(Complex parent, String parentType, String name, Consent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Consent", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Consent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Consent", "status", element.getStatusElement(), -1);
    }
    if (element.hasScope()) {
      composeCodeableConcept(t, "Consent", "scope", element.getScope(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Consent", "category", element.getCategory().get(i), i);
    }
    if (element.hasPatient()) {
      composeReference(t, "Consent", "patient", element.getPatient(), -1);
    }
    if (element.hasDateTimeElement()) {
      composeDateTime(t, "Consent", "dateTime", element.getDateTimeElement(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeReference(t, "Consent", "performer", element.getPerformer().get(i), i);
    }
    for (int i = 0; i < element.getOrganization().size(); i++) {
      composeReference(t, "Consent", "organization", element.getOrganization().get(i), i);
    }
    if (element.hasSource()) {
      composeType(t, "Consent", "source", element.getSource(), -1);
    }
    for (int i = 0; i < element.getPolicy().size(); i++) {
      composeConsentPolicyComponent(t, "Consent", "policy", element.getPolicy().get(i), i);
    }
    if (element.hasPolicyRule()) {
      composeCodeableConcept(t, "Consent", "policyRule", element.getPolicyRule(), -1);
    }
    for (int i = 0; i < element.getVerification().size(); i++) {
      composeConsentVerificationComponent(t, "Consent", "verification", element.getVerification().get(i), i);
    }
    if (element.hasProvision()) {
      composeConsentProvisionComponent(t, "Consent", "provision", element.getProvision(), -1);
    }
  }

  protected void composeConsentPolicyComponent(Complex parent, String parentType, String name, Consent.ConsentPolicyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "policy", name, element, index);
    if (element.hasAuthorityElement()) {
      composeUri(t, "ConsentPolicyComponent", "authority", element.getAuthorityElement(), -1);
    }
    if (element.hasUriElement()) {
      composeUri(t, "ConsentPolicyComponent", "uri", element.getUriElement(), -1);
    }
  }

  protected void composeConsentVerificationComponent(Complex parent, String parentType, String name, Consent.ConsentVerificationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "verification", name, element, index);
    if (element.hasVerifiedElement()) {
      composeBoolean(t, "ConsentVerificationComponent", "verified", element.getVerifiedElement(), -1);
    }
    if (element.hasVerifiedWith()) {
      composeReference(t, "ConsentVerificationComponent", "verifiedWith", element.getVerifiedWith(), -1);
    }
    if (element.hasVerificationDateElement()) {
      composeDateTime(t, "ConsentVerificationComponent", "verificationDate", element.getVerificationDateElement(), -1);
    }
  }

  protected void composeConsentProvisionComponent(Complex parent, String parentType, String name, Consent.ProvisionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "provision", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "ProvisionComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ProvisionComponent", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getActor().size(); i++) {
      composeConsentProvisionActorComponent(t, "ProvisionComponent", "actor", element.getActor().get(i), i);
    }
    for (int i = 0; i < element.getAction().size(); i++) {
      composeCodeableConcept(t, "ProvisionComponent", "action", element.getAction().get(i), i);
    }
    for (int i = 0; i < element.getSecurityLabel().size(); i++) {
      composeCoding(t, "ProvisionComponent", "securityLabel", element.getSecurityLabel().get(i), i);
    }
    for (int i = 0; i < element.getPurpose().size(); i++) {
      composeCoding(t, "ProvisionComponent", "purpose", element.getPurpose().get(i), i);
    }
    for (int i = 0; i < element.getClass_().size(); i++) {
      composeCoding(t, "ProvisionComponent", "class", element.getClass_().get(i), i);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "ProvisionComponent", "code", element.getCode().get(i), i);
    }
    if (element.hasDataPeriod()) {
      composePeriod(t, "ProvisionComponent", "dataPeriod", element.getDataPeriod(), -1);
    }
    for (int i = 0; i < element.getData().size(); i++) {
      composeConsentProvisionDataComponent(t, "ProvisionComponent", "data", element.getData().get(i), i);
    }
    for (int i = 0; i < element.getProvision().size(); i++) {
      composeConsentProvisionComponent(t, "ProvisionComponent", "provision", element.getProvision().get(i), i);
    }
  }

  protected void composeConsentProvisionActorComponent(Complex parent, String parentType, String name, Consent.ProvisionActorComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "actor", name, element, index);
    if (element.hasRole()) {
      composeCodeableConcept(t, "ProvisionActorComponent", "role", element.getRole(), -1);
    }
    if (element.hasReference()) {
      composeReference(t, "ProvisionActorComponent", "reference", element.getReference(), -1);
    }
  }

  protected void composeConsentProvisionDataComponent(Complex parent, String parentType, String name, Consent.ProvisionDataComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "data", name, element, index);
    if (element.hasMeaningElement()) {
      composeEnum(t, "ProvisionDataComponent", "meaning", element.getMeaningElement(), -1);
    }
    if (element.hasReference()) {
      composeReference(t, "ProvisionDataComponent", "reference", element.getReference(), -1);
    }
  }

  protected void composeContract(Complex parent, String parentType, String name, Contract element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Contract", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Contract", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasUrlElement()) {
      composeUri(t, "Contract", "url", element.getUrlElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Contract", "version", element.getVersionElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Contract", "status", element.getStatusElement(), -1);
    }
    if (element.hasLegalState()) {
      composeCodeableConcept(t, "Contract", "legalState", element.getLegalState(), -1);
    }
    if (element.hasInstantiatesCanonical()) {
      composeReference(t, "Contract", "instantiatesCanonical", element.getInstantiatesCanonical(), -1);
    }
    if (element.hasInstantiatesUriElement()) {
      composeUri(t, "Contract", "instantiatesUri", element.getInstantiatesUriElement(), -1);
    }
    if (element.hasContentDerivative()) {
      composeCodeableConcept(t, "Contract", "contentDerivative", element.getContentDerivative(), -1);
    }
    if (element.hasIssuedElement()) {
      composeDateTime(t, "Contract", "issued", element.getIssuedElement(), -1);
    }
    if (element.hasApplies()) {
      composePeriod(t, "Contract", "applies", element.getApplies(), -1);
    }
    if (element.hasExpirationType()) {
      composeCodeableConcept(t, "Contract", "expirationType", element.getExpirationType(), -1);
    }
    for (int i = 0; i < element.getSubject().size(); i++) {
      composeReference(t, "Contract", "subject", element.getSubject().get(i), i);
    }
    for (int i = 0; i < element.getAuthority().size(); i++) {
      composeReference(t, "Contract", "authority", element.getAuthority().get(i), i);
    }
    for (int i = 0; i < element.getDomain().size(); i++) {
      composeReference(t, "Contract", "domain", element.getDomain().get(i), i);
    }
    for (int i = 0; i < element.getSite().size(); i++) {
      composeReference(t, "Contract", "site", element.getSite().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "Contract", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Contract", "title", element.getTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "Contract", "subtitle", element.getSubtitleElement(), -1);
    }
    for (int i = 0; i < element.getAlias().size(); i++) {
      composeString(t, "Contract", "alias", element.getAlias().get(i), i);
    }
    if (element.hasAuthor()) {
      composeReference(t, "Contract", "author", element.getAuthor(), -1);
    }
    if (element.hasScope()) {
      composeCodeableConcept(t, "Contract", "scope", element.getScope(), -1);
    }
    if (element.hasTopic()) {
      composeType(t, "Contract", "topic", element.getTopic(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Contract", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getSubType().size(); i++) {
      composeCodeableConcept(t, "Contract", "subType", element.getSubType().get(i), i);
    }
    if (element.hasContentDefinition()) {
      composeContractContentDefinitionComponent(t, "Contract", "contentDefinition", element.getContentDefinition(), -1);
    }
    for (int i = 0; i < element.getTerm().size(); i++) {
      composeContractTermComponent(t, "Contract", "term", element.getTerm().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeReference(t, "Contract", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getRelevantHistory().size(); i++) {
      composeReference(t, "Contract", "relevantHistory", element.getRelevantHistory().get(i), i);
    }
    for (int i = 0; i < element.getSigner().size(); i++) {
      composeContractSignatoryComponent(t, "Contract", "signer", element.getSigner().get(i), i);
    }
    for (int i = 0; i < element.getFriendly().size(); i++) {
      composeContractFriendlyLanguageComponent(t, "Contract", "friendly", element.getFriendly().get(i), i);
    }
    for (int i = 0; i < element.getLegal().size(); i++) {
      composeContractLegalLanguageComponent(t, "Contract", "legal", element.getLegal().get(i), i);
    }
    for (int i = 0; i < element.getRule().size(); i++) {
      composeContractComputableLanguageComponent(t, "Contract", "rule", element.getRule().get(i), i);
    }
    if (element.hasLegallyBinding()) {
      composeType(t, "Contract", "legallyBinding", element.getLegallyBinding(), -1);
    }
  }

  protected void composeContractContentDefinitionComponent(Complex parent, String parentType, String name, Contract.ContentDefinitionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "contentDefinition", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ContentDefinitionComponent", "type", element.getType(), -1);
    }
    if (element.hasSubType()) {
      composeCodeableConcept(t, "ContentDefinitionComponent", "subType", element.getSubType(), -1);
    }
    if (element.hasPublisher()) {
      composeReference(t, "ContentDefinitionComponent", "publisher", element.getPublisher(), -1);
    }
    if (element.hasPublicationDateElement()) {
      composeDateTime(t, "ContentDefinitionComponent", "publicationDate", element.getPublicationDateElement(), -1);
    }
    if (element.hasPublicationStatusElement()) {
      composeEnum(t, "ContentDefinitionComponent", "publicationStatus", element.getPublicationStatusElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ContentDefinitionComponent", "copyright", element.getCopyrightElement(), -1);
    }
  }

  protected void composeContractTermComponent(Complex parent, String parentType, String name, Contract.TermComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "term", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "TermComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasIssuedElement()) {
      composeDateTime(t, "TermComponent", "issued", element.getIssuedElement(), -1);
    }
    if (element.hasApplies()) {
      composePeriod(t, "TermComponent", "applies", element.getApplies(), -1);
    }
    if (element.hasTopic()) {
      composeType(t, "TermComponent", "topic", element.getTopic(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "TermComponent", "type", element.getType(), -1);
    }
    if (element.hasSubType()) {
      composeCodeableConcept(t, "TermComponent", "subType", element.getSubType(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "TermComponent", "text", element.getTextElement(), -1);
    }
    for (int i = 0; i < element.getSecurityLabel().size(); i++) {
      composeContractSecurityLabelComponent(t, "TermComponent", "securityLabel", element.getSecurityLabel().get(i), i);
    }
    if (element.hasOffer()) {
      composeContractOfferComponent(t, "TermComponent", "offer", element.getOffer(), -1);
    }
    for (int i = 0; i < element.getAsset().size(); i++) {
      composeContractAssetComponent(t, "TermComponent", "asset", element.getAsset().get(i), i);
    }
    for (int i = 0; i < element.getAction().size(); i++) {
      composeContractActionComponent(t, "TermComponent", "action", element.getAction().get(i), i);
    }
    for (int i = 0; i < element.getGroup().size(); i++) {
      composeContractTermComponent(t, "TermComponent", "group", element.getGroup().get(i), i);
    }
  }

  protected void composeContractSecurityLabelComponent(Complex parent, String parentType, String name, Contract.SecurityLabelComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "securityLabel", name, element, index);
    for (int i = 0; i < element.getNumber().size(); i++) {
      composeUnsignedInt(t, "SecurityLabelComponent", "number", element.getNumber().get(i), i);
    }
    if (element.hasClassification()) {
      composeCoding(t, "SecurityLabelComponent", "classification", element.getClassification(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCoding(t, "SecurityLabelComponent", "category", element.getCategory().get(i), i);
    }
    for (int i = 0; i < element.getControl().size(); i++) {
      composeCoding(t, "SecurityLabelComponent", "control", element.getControl().get(i), i);
    }
  }

  protected void composeContractOfferComponent(Complex parent, String parentType, String name, Contract.ContractOfferComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "offer", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ContractOfferComponent", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getParty().size(); i++) {
      composeContractPartyComponent(t, "ContractOfferComponent", "party", element.getParty().get(i), i);
    }
    if (element.hasTopic()) {
      composeReference(t, "ContractOfferComponent", "topic", element.getTopic(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ContractOfferComponent", "type", element.getType(), -1);
    }
    if (element.hasDecision()) {
      composeCodeableConcept(t, "ContractOfferComponent", "decision", element.getDecision(), -1);
    }
    for (int i = 0; i < element.getDecisionMode().size(); i++) {
      composeCodeableConcept(t, "ContractOfferComponent", "decisionMode", element.getDecisionMode().get(i), i);
    }
    for (int i = 0; i < element.getAnswer().size(); i++) {
      composeContractAnswerComponent(t, "ContractOfferComponent", "answer", element.getAnswer().get(i), i);
    }
    if (element.hasTextElement()) {
      composeString(t, "ContractOfferComponent", "text", element.getTextElement(), -1);
    }
    for (int i = 0; i < element.getLinkId().size(); i++) {
      composeString(t, "ContractOfferComponent", "linkId", element.getLinkId().get(i), i);
    }
    for (int i = 0; i < element.getSecurityLabelNumber().size(); i++) {
      composeUnsignedInt(t, "ContractOfferComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
    }
  }

  protected void composeContractPartyComponent(Complex parent, String parentType, String name, Contract.ContractPartyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "party", name, element, index);
    for (int i = 0; i < element.getReference().size(); i++) {
      composeReference(t, "ContractPartyComponent", "reference", element.getReference().get(i), i);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "ContractPartyComponent", "role", element.getRole(), -1);
    }
  }

  protected void composeContractAnswerComponent(Complex parent, String parentType, String name, Contract.AnswerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "answer", name, element, index);
    if (element.hasValue()) {
      composeType(t, "AnswerComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeContractAssetComponent(Complex parent, String parentType, String name, Contract.ContractAssetComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "asset", name, element, index);
    if (element.hasScope()) {
      composeCodeableConcept(t, "ContractAssetComponent", "scope", element.getScope(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "ContractAssetComponent", "type", element.getType().get(i), i);
    }
    for (int i = 0; i < element.getTypeReference().size(); i++) {
      composeReference(t, "ContractAssetComponent", "typeReference", element.getTypeReference().get(i), i);
    }
    for (int i = 0; i < element.getSubtype().size(); i++) {
      composeCodeableConcept(t, "ContractAssetComponent", "subtype", element.getSubtype().get(i), i);
    }
    if (element.hasRelationship()) {
      composeCoding(t, "ContractAssetComponent", "relationship", element.getRelationship(), -1);
    }
    for (int i = 0; i < element.getContext().size(); i++) {
      composeContractAssetContextComponent(t, "ContractAssetComponent", "context", element.getContext().get(i), i);
    }
    if (element.hasConditionElement()) {
      composeString(t, "ContractAssetComponent", "condition", element.getConditionElement(), -1);
    }
    for (int i = 0; i < element.getPeriodType().size(); i++) {
      composeCodeableConcept(t, "ContractAssetComponent", "periodType", element.getPeriodType().get(i), i);
    }
    for (int i = 0; i < element.getPeriod().size(); i++) {
      composePeriod(t, "ContractAssetComponent", "period", element.getPeriod().get(i), i);
    }
    for (int i = 0; i < element.getUsePeriod().size(); i++) {
      composePeriod(t, "ContractAssetComponent", "usePeriod", element.getUsePeriod().get(i), i);
    }
    if (element.hasTextElement()) {
      composeString(t, "ContractAssetComponent", "text", element.getTextElement(), -1);
    }
    for (int i = 0; i < element.getLinkId().size(); i++) {
      composeString(t, "ContractAssetComponent", "linkId", element.getLinkId().get(i), i);
    }
    for (int i = 0; i < element.getAnswer().size(); i++) {
      composeContractAnswerComponent(t, "ContractAssetComponent", "answer", element.getAnswer().get(i), i);
    }
    for (int i = 0; i < element.getSecurityLabelNumber().size(); i++) {
      composeUnsignedInt(t, "ContractAssetComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
    }
    for (int i = 0; i < element.getValuedItem().size(); i++) {
      composeContractValuedItemComponent(t, "ContractAssetComponent", "valuedItem", element.getValuedItem().get(i), i);
    }
  }

  protected void composeContractAssetContextComponent(Complex parent, String parentType, String name, Contract.AssetContextComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "context", name, element, index);
    if (element.hasReference()) {
      composeReference(t, "AssetContextComponent", "reference", element.getReference(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "AssetContextComponent", "code", element.getCode().get(i), i);
    }
    if (element.hasTextElement()) {
      composeString(t, "AssetContextComponent", "text", element.getTextElement(), -1);
    }
  }

  protected void composeContractValuedItemComponent(Complex parent, String parentType, String name, Contract.ValuedItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "valuedItem", name, element, index);
    if (element.hasEntity()) {
      composeType(t, "ValuedItemComponent", "entity", element.getEntity(), -1);
    }
    if (element.hasIdentifier()) {
      composeIdentifier(t, "ValuedItemComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasEffectiveTimeElement()) {
      composeDateTime(t, "ValuedItemComponent", "effectiveTime", element.getEffectiveTimeElement(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "ValuedItemComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "ValuedItemComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "ValuedItemComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasPointsElement()) {
      composeDecimal(t, "ValuedItemComponent", "points", element.getPointsElement(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "ValuedItemComponent", "net", element.getNet(), -1);
    }
    if (element.hasPaymentElement()) {
      composeString(t, "ValuedItemComponent", "payment", element.getPaymentElement(), -1);
    }
    if (element.hasPaymentDateElement()) {
      composeDateTime(t, "ValuedItemComponent", "paymentDate", element.getPaymentDateElement(), -1);
    }
    if (element.hasResponsible()) {
      composeReference(t, "ValuedItemComponent", "responsible", element.getResponsible(), -1);
    }
    if (element.hasRecipient()) {
      composeReference(t, "ValuedItemComponent", "recipient", element.getRecipient(), -1);
    }
    for (int i = 0; i < element.getLinkId().size(); i++) {
      composeString(t, "ValuedItemComponent", "linkId", element.getLinkId().get(i), i);
    }
    for (int i = 0; i < element.getSecurityLabelNumber().size(); i++) {
      composeUnsignedInt(t, "ValuedItemComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
    }
  }

  protected void composeContractActionComponent(Complex parent, String parentType, String name, Contract.ActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "action", name, element, index);
    if (element.hasDoNotPerformElement()) {
      composeBoolean(t, "ActionComponent", "doNotPerform", element.getDoNotPerformElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ActionComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getSubject().size(); i++) {
      composeContractActionSubjectComponent(t, "ActionComponent", "subject", element.getSubject().get(i), i);
    }
    if (element.hasIntent()) {
      composeCodeableConcept(t, "ActionComponent", "intent", element.getIntent(), -1);
    }
    for (int i = 0; i < element.getLinkId().size(); i++) {
      composeString(t, "ActionComponent", "linkId", element.getLinkId().get(i), i);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "ActionComponent", "status", element.getStatus(), -1);
    }
    if (element.hasContext()) {
      composeReference(t, "ActionComponent", "context", element.getContext(), -1);
    }
    for (int i = 0; i < element.getContextLinkId().size(); i++) {
      composeString(t, "ActionComponent", "contextLinkId", element.getContextLinkId().get(i), i);
    }
    if (element.hasOccurrence()) {
      composeType(t, "ActionComponent", "occurrence", element.getOccurrence(), -1);
    }
    for (int i = 0; i < element.getRequester().size(); i++) {
      composeReference(t, "ActionComponent", "requester", element.getRequester().get(i), i);
    }
    for (int i = 0; i < element.getRequesterLinkId().size(); i++) {
      composeString(t, "ActionComponent", "requesterLinkId", element.getRequesterLinkId().get(i), i);
    }
    for (int i = 0; i < element.getPerformerType().size(); i++) {
      composeCodeableConcept(t, "ActionComponent", "performerType", element.getPerformerType().get(i), i);
    }
    if (element.hasPerformerRole()) {
      composeCodeableConcept(t, "ActionComponent", "performerRole", element.getPerformerRole(), -1);
    }
    if (element.hasPerformer()) {
      composeReference(t, "ActionComponent", "performer", element.getPerformer(), -1);
    }
    for (int i = 0; i < element.getPerformerLinkId().size(); i++) {
      composeString(t, "ActionComponent", "performerLinkId", element.getPerformerLinkId().get(i), i);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "ActionComponent", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "ActionComponent", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeString(t, "ActionComponent", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getReasonLinkId().size(); i++) {
      composeString(t, "ActionComponent", "reasonLinkId", element.getReasonLinkId().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "ActionComponent", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getSecurityLabelNumber().size(); i++) {
      composeUnsignedInt(t, "ActionComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i), i);
    }
  }

  protected void composeContractActionSubjectComponent(Complex parent, String parentType, String name, Contract.ActionSubjectComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "subject", name, element, index);
    for (int i = 0; i < element.getReference().size(); i++) {
      composeReference(t, "ActionSubjectComponent", "reference", element.getReference().get(i), i);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "ActionSubjectComponent", "role", element.getRole(), -1);
    }
  }

  protected void composeContractSignatoryComponent(Complex parent, String parentType, String name, Contract.SignatoryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "signer", name, element, index);
    if (element.hasType()) {
      composeCoding(t, "SignatoryComponent", "type", element.getType(), -1);
    }
    if (element.hasParty()) {
      composeReference(t, "SignatoryComponent", "party", element.getParty(), -1);
    }
    for (int i = 0; i < element.getSignature().size(); i++) {
      composeSignature(t, "SignatoryComponent", "signature", element.getSignature().get(i), i);
    }
  }

  protected void composeContractFriendlyLanguageComponent(Complex parent, String parentType, String name, Contract.FriendlyLanguageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "friendly", name, element, index);
    if (element.hasContent()) {
      composeType(t, "FriendlyLanguageComponent", "content", element.getContent(), -1);
    }
  }

  protected void composeContractLegalLanguageComponent(Complex parent, String parentType, String name, Contract.LegalLanguageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "legal", name, element, index);
    if (element.hasContent()) {
      composeType(t, "LegalLanguageComponent", "content", element.getContent(), -1);
    }
  }

  protected void composeContractComputableLanguageComponent(Complex parent, String parentType, String name, Contract.ComputableLanguageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "rule", name, element, index);
    if (element.hasContent()) {
      composeType(t, "ComputableLanguageComponent", "content", element.getContent(), -1);
    }
  }

  protected void composeCoverage(Complex parent, String parentType, String name, Coverage element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Coverage", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Coverage", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Coverage", "status", element.getStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Coverage", "type", element.getType(), -1);
    }
    if (element.hasPolicyHolder()) {
      composeReference(t, "Coverage", "policyHolder", element.getPolicyHolder(), -1);
    }
    if (element.hasSubscriber()) {
      composeReference(t, "Coverage", "subscriber", element.getSubscriber(), -1);
    }
    if (element.hasSubscriberIdElement()) {
      composeString(t, "Coverage", "subscriberId", element.getSubscriberIdElement(), -1);
    }
    if (element.hasBeneficiary()) {
      composeReference(t, "Coverage", "beneficiary", element.getBeneficiary(), -1);
    }
    if (element.hasDependentElement()) {
      composeString(t, "Coverage", "dependent", element.getDependentElement(), -1);
    }
    if (element.hasRelationship()) {
      composeCodeableConcept(t, "Coverage", "relationship", element.getRelationship(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "Coverage", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getPayor().size(); i++) {
      composeReference(t, "Coverage", "payor", element.getPayor().get(i), i);
    }
    for (int i = 0; i < element.getClass_().size(); i++) {
      composeCoverageClassComponent(t, "Coverage", "class", element.getClass_().get(i), i);
    }
    if (element.hasOrderElement()) {
      composePositiveInt(t, "Coverage", "order", element.getOrderElement(), -1);
    }
    if (element.hasNetworkElement()) {
      composeString(t, "Coverage", "network", element.getNetworkElement(), -1);
    }
    for (int i = 0; i < element.getCostToBeneficiary().size(); i++) {
      composeCoverageCostToBeneficiaryComponent(t, "Coverage", "costToBeneficiary", element.getCostToBeneficiary().get(i), i);
    }
    if (element.hasSubrogationElement()) {
      composeBoolean(t, "Coverage", "subrogation", element.getSubrogationElement(), -1);
    }
    for (int i = 0; i < element.getContract().size(); i++) {
      composeReference(t, "Coverage", "contract", element.getContract().get(i), i);
    }
  }

  protected void composeCoverageClassComponent(Complex parent, String parentType, String name, Coverage.ClassComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "class", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ClassComponent", "type", element.getType(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "ClassComponent", "value", element.getValueElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ClassComponent", "name", element.getNameElement(), -1);
    }
  }

  protected void composeCoverageCostToBeneficiaryComponent(Complex parent, String parentType, String name, Coverage.CostToBeneficiaryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "costToBeneficiary", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CostToBeneficiaryComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "CostToBeneficiaryComponent", "value", element.getValue(), -1);
    }
    for (int i = 0; i < element.getException().size(); i++) {
      composeCoverageExemptionComponent(t, "CostToBeneficiaryComponent", "exception", element.getException().get(i), i);
    }
  }

  protected void composeCoverageExemptionComponent(Complex parent, String parentType, String name, Coverage.ExemptionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "exception", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ExemptionComponent", "type", element.getType(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ExemptionComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeCoverageEligibilityRequest(Complex parent, String parentType, String name, CoverageEligibilityRequest element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "CoverageEligibilityRequest", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CoverageEligibilityRequest", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CoverageEligibilityRequest", "status", element.getStatusElement(), -1);
    }
    if (element.hasPriority()) {
      composeCodeableConcept(t, "CoverageEligibilityRequest", "priority", element.getPriority(), -1);
    }
    for (int i = 0; i < element.getPurpose().size(); i++) {
      composeEnum(t, "CoverageEligibilityRequest", "purpose", element.getPurpose().get(i), i);
    }
    if (element.hasPatient()) {
      composeReference(t, "CoverageEligibilityRequest", "patient", element.getPatient(), -1);
    }
    if (element.hasServiced()) {
      composeType(t, "CoverageEligibilityRequest", "serviced", element.getServiced(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "CoverageEligibilityRequest", "created", element.getCreatedElement(), -1);
    }
    if (element.hasEnterer()) {
      composeReference(t, "CoverageEligibilityRequest", "enterer", element.getEnterer(), -1);
    }
    if (element.hasProvider()) {
      composeReference(t, "CoverageEligibilityRequest", "provider", element.getProvider(), -1);
    }
    if (element.hasInsurer()) {
      composeReference(t, "CoverageEligibilityRequest", "insurer", element.getInsurer(), -1);
    }
    if (element.hasFacility()) {
      composeReference(t, "CoverageEligibilityRequest", "facility", element.getFacility(), -1);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeCoverageEligibilityRequestSupportingInformationComponent(t, "CoverageEligibilityRequest", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeCoverageEligibilityRequestInsuranceComponent(t, "CoverageEligibilityRequest", "insurance", element.getInsurance().get(i), i);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeCoverageEligibilityRequestDetailsComponent(t, "CoverageEligibilityRequest", "item", element.getItem().get(i), i);
    }
  }

  protected void composeCoverageEligibilityRequestSupportingInformationComponent(Complex parent, String parentType, String name, CoverageEligibilityRequest.SupportingInformationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "supportingInfo", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "SupportingInformationComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasInformation()) {
      composeReference(t, "SupportingInformationComponent", "information", element.getInformation(), -1);
    }
    if (element.hasAppliesToAllElement()) {
      composeBoolean(t, "SupportingInformationComponent", "appliesToAll", element.getAppliesToAllElement(), -1);
    }
  }

  protected void composeCoverageEligibilityRequestInsuranceComponent(Complex parent, String parentType, String name, CoverageEligibilityRequest.InsuranceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "insurance", name, element, index);
    if (element.hasFocalElement()) {
      composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
    }
    if (element.hasCoverage()) {
      composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
    }
    if (element.hasBusinessArrangementElement()) {
      composeString(t, "InsuranceComponent", "businessArrangement", element.getBusinessArrangementElement(), -1);
    }
  }

  protected void composeCoverageEligibilityRequestDetailsComponent(Complex parent, String parentType, String name, CoverageEligibilityRequest.DetailsComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    for (int i = 0; i < element.getSupportingInfoSequence().size(); i++) {
      composePositiveInt(t, "DetailsComponent", "supportingInfoSequence", element.getSupportingInfoSequence().get(i), i);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "DetailsComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "DetailsComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "DetailsComponent", "modifier", element.getModifier().get(i), i);
    }
    if (element.hasProvider()) {
      composeReference(t, "DetailsComponent", "provider", element.getProvider(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "DetailsComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "DetailsComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFacility()) {
      composeReference(t, "DetailsComponent", "facility", element.getFacility(), -1);
    }
    for (int i = 0; i < element.getDiagnosis().size(); i++) {
      composeCoverageEligibilityRequestDiagnosisComponent(t, "DetailsComponent", "diagnosis", element.getDiagnosis().get(i), i);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeReference(t, "DetailsComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeCoverageEligibilityRequestDiagnosisComponent(Complex parent, String parentType, String name, CoverageEligibilityRequest.DiagnosisComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "diagnosis", name, element, index);
    if (element.hasDiagnosis()) {
      composeType(t, "DiagnosisComponent", "diagnosis", element.getDiagnosis(), -1);
    }
  }

  protected void composeCoverageEligibilityResponse(Complex parent, String parentType, String name, CoverageEligibilityResponse element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "CoverageEligibilityResponse", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "CoverageEligibilityResponse", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "CoverageEligibilityResponse", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getPurpose().size(); i++) {
      composeEnum(t, "CoverageEligibilityResponse", "purpose", element.getPurpose().get(i), i);
    }
    if (element.hasPatient()) {
      composeReference(t, "CoverageEligibilityResponse", "patient", element.getPatient(), -1);
    }
    if (element.hasServiced()) {
      composeType(t, "CoverageEligibilityResponse", "serviced", element.getServiced(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "CoverageEligibilityResponse", "created", element.getCreatedElement(), -1);
    }
    if (element.hasRequestor()) {
      composeReference(t, "CoverageEligibilityResponse", "requestor", element.getRequestor(), -1);
    }
    if (element.hasRequest()) {
      composeReference(t, "CoverageEligibilityResponse", "request", element.getRequest(), -1);
    }
    if (element.hasOutcomeElement()) {
      composeEnum(t, "CoverageEligibilityResponse", "outcome", element.getOutcomeElement(), -1);
    }
    if (element.hasDispositionElement()) {
      composeString(t, "CoverageEligibilityResponse", "disposition", element.getDispositionElement(), -1);
    }
    if (element.hasInsurer()) {
      composeReference(t, "CoverageEligibilityResponse", "insurer", element.getInsurer(), -1);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeCoverageEligibilityResponseInsuranceComponent(t, "CoverageEligibilityResponse", "insurance", element.getInsurance().get(i), i);
    }
    if (element.hasPreAuthRefElement()) {
      composeString(t, "CoverageEligibilityResponse", "preAuthRef", element.getPreAuthRefElement(), -1);
    }
    if (element.hasForm()) {
      composeCodeableConcept(t, "CoverageEligibilityResponse", "form", element.getForm(), -1);
    }
    for (int i = 0; i < element.getError().size(); i++) {
      composeCoverageEligibilityResponseErrorsComponent(t, "CoverageEligibilityResponse", "error", element.getError().get(i), i);
    }
  }

  protected void composeCoverageEligibilityResponseInsuranceComponent(Complex parent, String parentType, String name, CoverageEligibilityResponse.InsuranceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "insurance", name, element, index);
    if (element.hasCoverage()) {
      composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
    }
    if (element.hasInforceElement()) {
      composeBoolean(t, "InsuranceComponent", "inforce", element.getInforceElement(), -1);
    }
    if (element.hasBenefitPeriod()) {
      composePeriod(t, "InsuranceComponent", "benefitPeriod", element.getBenefitPeriod(), -1);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeCoverageEligibilityResponseItemsComponent(t, "InsuranceComponent", "item", element.getItem().get(i), i);
    }
  }

  protected void composeCoverageEligibilityResponseItemsComponent(Complex parent, String parentType, String name, CoverageEligibilityResponse.ItemsComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "ItemsComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "ItemsComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "ItemsComponent", "modifier", element.getModifier().get(i), i);
    }
    if (element.hasProvider()) {
      composeReference(t, "ItemsComponent", "provider", element.getProvider(), -1);
    }
    if (element.hasExcludedElement()) {
      composeBoolean(t, "ItemsComponent", "excluded", element.getExcludedElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ItemsComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ItemsComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasNetwork()) {
      composeCodeableConcept(t, "ItemsComponent", "network", element.getNetwork(), -1);
    }
    if (element.hasUnit()) {
      composeCodeableConcept(t, "ItemsComponent", "unit", element.getUnit(), -1);
    }
    if (element.hasTerm()) {
      composeCodeableConcept(t, "ItemsComponent", "term", element.getTerm(), -1);
    }
    for (int i = 0; i < element.getBenefit().size(); i++) {
      composeCoverageEligibilityResponseBenefitComponent(t, "ItemsComponent", "benefit", element.getBenefit().get(i), i);
    }
    if (element.hasAuthorizationRequiredElement()) {
      composeBoolean(t, "ItemsComponent", "authorizationRequired", element.getAuthorizationRequiredElement(), -1);
    }
    for (int i = 0; i < element.getAuthorizationSupporting().size(); i++) {
      composeCodeableConcept(t, "ItemsComponent", "authorizationSupporting", element.getAuthorizationSupporting().get(i), i);
    }
    if (element.hasAuthorizationUrlElement()) {
      composeUri(t, "ItemsComponent", "authorizationUrl", element.getAuthorizationUrlElement(), -1);
    }
  }

  protected void composeCoverageEligibilityResponseBenefitComponent(Complex parent, String parentType, String name, CoverageEligibilityResponse.BenefitComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "benefit", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "BenefitComponent", "type", element.getType(), -1);
    }
    if (element.hasAllowed()) {
      composeType(t, "BenefitComponent", "allowed", element.getAllowed(), -1);
    }
    if (element.hasUsed()) {
      composeType(t, "BenefitComponent", "used", element.getUsed(), -1);
    }
  }

  protected void composeCoverageEligibilityResponseErrorsComponent(Complex parent, String parentType, String name, CoverageEligibilityResponse.ErrorsComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "error", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "ErrorsComponent", "code", element.getCode(), -1);
    }
  }

  protected void composeDetectedIssue(Complex parent, String parentType, String name, DetectedIssue element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DetectedIssue", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DetectedIssue", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "DetectedIssue", "status", element.getStatusElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "DetectedIssue", "code", element.getCode(), -1);
    }
    if (element.hasSeverityElement()) {
      composeEnum(t, "DetectedIssue", "severity", element.getSeverityElement(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "DetectedIssue", "patient", element.getPatient(), -1);
    }
    if (element.hasIdentified()) {
      composeType(t, "DetectedIssue", "identified", element.getIdentified(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "DetectedIssue", "author", element.getAuthor(), -1);
    }
    for (int i = 0; i < element.getImplicated().size(); i++) {
      composeReference(t, "DetectedIssue", "implicated", element.getImplicated().get(i), i);
    }
    for (int i = 0; i < element.getEvidence().size(); i++) {
      composeDetectedIssueEvidenceComponent(t, "DetectedIssue", "evidence", element.getEvidence().get(i), i);
    }
    if (element.hasDetailElement()) {
      composeString(t, "DetectedIssue", "detail", element.getDetailElement(), -1);
    }
    if (element.hasReferenceElement()) {
      composeUri(t, "DetectedIssue", "reference", element.getReferenceElement(), -1);
    }
    for (int i = 0; i < element.getMitigation().size(); i++) {
      composeDetectedIssueMitigationComponent(t, "DetectedIssue", "mitigation", element.getMitigation().get(i), i);
    }
  }

  protected void composeDetectedIssueEvidenceComponent(Complex parent, String parentType, String name, DetectedIssue.DetectedIssueEvidenceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "evidence", name, element, index);
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "DetectedIssueEvidenceComponent", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeReference(t, "DetectedIssueEvidenceComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeDetectedIssueMitigationComponent(Complex parent, String parentType, String name, DetectedIssue.DetectedIssueMitigationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "mitigation", name, element, index);
    if (element.hasAction()) {
      composeCodeableConcept(t, "DetectedIssueMitigationComponent", "action", element.getAction(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "DetectedIssueMitigationComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "DetectedIssueMitigationComponent", "author", element.getAuthor(), -1);
    }
  }

  protected void composeDevice(Complex parent, String parentType, String name, Device element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Device", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Device", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasDefinition()) {
      composeReference(t, "Device", "definition", element.getDefinition(), -1);
    }
    for (int i = 0; i < element.getUdiCarrier().size(); i++) {
      composeDeviceUdiCarrierComponent(t, "Device", "udiCarrier", element.getUdiCarrier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Device", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getStatusReason().size(); i++) {
      composeCodeableConcept(t, "Device", "statusReason", element.getStatusReason().get(i), i);
    }
    if (element.hasDistinctIdentifierElement()) {
      composeString(t, "Device", "distinctIdentifier", element.getDistinctIdentifierElement(), -1);
    }
    if (element.hasManufacturerElement()) {
      composeString(t, "Device", "manufacturer", element.getManufacturerElement(), -1);
    }
    if (element.hasManufactureDateElement()) {
      composeDateTime(t, "Device", "manufactureDate", element.getManufactureDateElement(), -1);
    }
    if (element.hasExpirationDateElement()) {
      composeDateTime(t, "Device", "expirationDate", element.getExpirationDateElement(), -1);
    }
    if (element.hasLotNumberElement()) {
      composeString(t, "Device", "lotNumber", element.getLotNumberElement(), -1);
    }
    if (element.hasSerialNumberElement()) {
      composeString(t, "Device", "serialNumber", element.getSerialNumberElement(), -1);
    }
    for (int i = 0; i < element.getDeviceName().size(); i++) {
      composeDeviceDeviceNameComponent(t, "Device", "deviceName", element.getDeviceName().get(i), i);
    }
    if (element.hasModelNumberElement()) {
      composeString(t, "Device", "modelNumber", element.getModelNumberElement(), -1);
    }
    if (element.hasPartNumberElement()) {
      composeString(t, "Device", "partNumber", element.getPartNumberElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Device", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getSpecialization().size(); i++) {
      composeDeviceSpecializationComponent(t, "Device", "specialization", element.getSpecialization().get(i), i);
    }
    for (int i = 0; i < element.getVersion().size(); i++) {
      composeDeviceVersionComponent(t, "Device", "version", element.getVersion().get(i), i);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeDevicePropertyComponent(t, "Device", "property", element.getProperty().get(i), i);
    }
    if (element.hasPatient()) {
      composeReference(t, "Device", "patient", element.getPatient(), -1);
    }
    if (element.hasOwner()) {
      composeReference(t, "Device", "owner", element.getOwner(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactPoint(t, "Device", "contact", element.getContact().get(i), i);
    }
    if (element.hasLocation()) {
      composeReference(t, "Device", "location", element.getLocation(), -1);
    }
    if (element.hasUrlElement()) {
      composeUri(t, "Device", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Device", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getSafety().size(); i++) {
      composeCodeableConcept(t, "Device", "safety", element.getSafety().get(i), i);
    }
    if (element.hasParent()) {
      composeReference(t, "Device", "parent", element.getParent(), -1);
    }
  }

  protected void composeDeviceUdiCarrierComponent(Complex parent, String parentType, String name, Device.DeviceUdiCarrierComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "udiCarrier", name, element, index);
    if (element.hasDeviceIdentifierElement()) {
      composeString(t, "DeviceUdiCarrierComponent", "deviceIdentifier", element.getDeviceIdentifierElement(), -1);
    }
    if (element.hasIssuerElement()) {
      composeUri(t, "DeviceUdiCarrierComponent", "issuer", element.getIssuerElement(), -1);
    }
    if (element.hasJurisdictionElement()) {
      composeUri(t, "DeviceUdiCarrierComponent", "jurisdiction", element.getJurisdictionElement(), -1);
    }
    if (element.hasCarrierAIDCElement()) {
      composeBase64Binary(t, "DeviceUdiCarrierComponent", "carrierAIDC", element.getCarrierAIDCElement(), -1);
    }
    if (element.hasCarrierHRFElement()) {
      composeString(t, "DeviceUdiCarrierComponent", "carrierHRF", element.getCarrierHRFElement(), -1);
    }
    if (element.hasEntryTypeElement()) {
      composeEnum(t, "DeviceUdiCarrierComponent", "entryType", element.getEntryTypeElement(), -1);
    }
  }

  protected void composeDeviceDeviceNameComponent(Complex parent, String parentType, String name, Device.DeviceDeviceNameComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "deviceName", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "DeviceDeviceNameComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "DeviceDeviceNameComponent", "type", element.getTypeElement(), -1);
    }
  }

  protected void composeDeviceSpecializationComponent(Complex parent, String parentType, String name, Device.DeviceSpecializationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "specialization", name, element, index);
    if (element.hasSystemType()) {
      composeCodeableConcept(t, "DeviceSpecializationComponent", "systemType", element.getSystemType(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "DeviceSpecializationComponent", "version", element.getVersionElement(), -1);
    }
  }

  protected void composeDeviceVersionComponent(Complex parent, String parentType, String name, Device.DeviceVersionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "version", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "DeviceVersionComponent", "type", element.getType(), -1);
    }
    if (element.hasComponent()) {
      composeIdentifier(t, "DeviceVersionComponent", "component", element.getComponent(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "DeviceVersionComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeDevicePropertyComponent(Complex parent, String parentType, String name, Device.DevicePropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "DevicePropertyComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getValueQuantity().size(); i++) {
      composeQuantity(t, "DevicePropertyComponent", "valueQuantity", element.getValueQuantity().get(i), i);
    }
    for (int i = 0; i < element.getValueCode().size(); i++) {
      composeCodeableConcept(t, "DevicePropertyComponent", "valueCode", element.getValueCode().get(i), i);
    }
  }

  protected void composeDeviceDefinition(Complex parent, String parentType, String name, DeviceDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DeviceDefinition", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DeviceDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getUdiDeviceIdentifier().size(); i++) {
      composeDeviceDefinitionUdiDeviceIdentifierComponent(t, "DeviceDefinition", "udiDeviceIdentifier", element.getUdiDeviceIdentifier().get(i), i);
    }
    if (element.hasManufacturer()) {
      composeType(t, "DeviceDefinition", "manufacturer", element.getManufacturer(), -1);
    }
    for (int i = 0; i < element.getDeviceName().size(); i++) {
      composeDeviceDefinitionDeviceNameComponent(t, "DeviceDefinition", "deviceName", element.getDeviceName().get(i), i);
    }
    if (element.hasModelNumberElement()) {
      composeString(t, "DeviceDefinition", "modelNumber", element.getModelNumberElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "DeviceDefinition", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getSpecialization().size(); i++) {
      composeDeviceDefinitionSpecializationComponent(t, "DeviceDefinition", "specialization", element.getSpecialization().get(i), i);
    }
    for (int i = 0; i < element.getVersion().size(); i++) {
      composeString(t, "DeviceDefinition", "version", element.getVersion().get(i), i);
    }
    for (int i = 0; i < element.getSafety().size(); i++) {
      composeCodeableConcept(t, "DeviceDefinition", "safety", element.getSafety().get(i), i);
    }
    for (int i = 0; i < element.getShelfLifeStorage().size(); i++) {
      composeProductShelfLife(t, "DeviceDefinition", "shelfLifeStorage", element.getShelfLifeStorage().get(i), i);
    }
    if (element.hasPhysicalCharacteristics()) {
      composeProdCharacteristic(t, "DeviceDefinition", "physicalCharacteristics", element.getPhysicalCharacteristics(), -1);
    }
    for (int i = 0; i < element.getLanguageCode().size(); i++) {
      composeCodeableConcept(t, "DeviceDefinition", "languageCode", element.getLanguageCode().get(i), i);
    }
    for (int i = 0; i < element.getCapability().size(); i++) {
      composeDeviceDefinitionCapabilityComponent(t, "DeviceDefinition", "capability", element.getCapability().get(i), i);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeDeviceDefinitionPropertyComponent(t, "DeviceDefinition", "property", element.getProperty().get(i), i);
    }
    if (element.hasOwner()) {
      composeReference(t, "DeviceDefinition", "owner", element.getOwner(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactPoint(t, "DeviceDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasUrlElement()) {
      composeUri(t, "DeviceDefinition", "url", element.getUrlElement(), -1);
    }
    if (element.hasOnlineInformationElement()) {
      composeUri(t, "DeviceDefinition", "onlineInformation", element.getOnlineInformationElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "DeviceDefinition", "note", element.getNote().get(i), i);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "DeviceDefinition", "quantity", element.getQuantity(), -1);
    }
    if (element.hasParentDevice()) {
      composeReference(t, "DeviceDefinition", "parentDevice", element.getParentDevice(), -1);
    }
    for (int i = 0; i < element.getMaterial().size(); i++) {
      composeDeviceDefinitionMaterialComponent(t, "DeviceDefinition", "material", element.getMaterial().get(i), i);
    }
  }

  protected void composeDeviceDefinitionUdiDeviceIdentifierComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "udiDeviceIdentifier", name, element, index);
    if (element.hasDeviceIdentifierElement()) {
      composeString(t, "DeviceDefinitionUdiDeviceIdentifierComponent", "deviceIdentifier", element.getDeviceIdentifierElement(), -1);
    }
    if (element.hasIssuerElement()) {
      composeUri(t, "DeviceDefinitionUdiDeviceIdentifierComponent", "issuer", element.getIssuerElement(), -1);
    }
    if (element.hasJurisdictionElement()) {
      composeUri(t, "DeviceDefinitionUdiDeviceIdentifierComponent", "jurisdiction", element.getJurisdictionElement(), -1);
    }
  }

  protected void composeDeviceDefinitionDeviceNameComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionDeviceNameComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "deviceName", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "DeviceDefinitionDeviceNameComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "DeviceDefinitionDeviceNameComponent", "type", element.getTypeElement(), -1);
    }
  }

  protected void composeDeviceDefinitionSpecializationComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionSpecializationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "specialization", name, element, index);
    if (element.hasSystemTypeElement()) {
      composeString(t, "DeviceDefinitionSpecializationComponent", "systemType", element.getSystemTypeElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "DeviceDefinitionSpecializationComponent", "version", element.getVersionElement(), -1);
    }
  }

  protected void composeDeviceDefinitionCapabilityComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionCapabilityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "capability", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "DeviceDefinitionCapabilityComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getDescription().size(); i++) {
      composeCodeableConcept(t, "DeviceDefinitionCapabilityComponent", "description", element.getDescription().get(i), i);
    }
  }

  protected void composeDeviceDefinitionPropertyComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionPropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "DeviceDefinitionPropertyComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getValueQuantity().size(); i++) {
      composeQuantity(t, "DeviceDefinitionPropertyComponent", "valueQuantity", element.getValueQuantity().get(i), i);
    }
    for (int i = 0; i < element.getValueCode().size(); i++) {
      composeCodeableConcept(t, "DeviceDefinitionPropertyComponent", "valueCode", element.getValueCode().get(i), i);
    }
  }

  protected void composeDeviceDefinitionMaterialComponent(Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionMaterialComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "material", name, element, index);
    if (element.hasSubstance()) {
      composeCodeableConcept(t, "DeviceDefinitionMaterialComponent", "substance", element.getSubstance(), -1);
    }
    if (element.hasAlternateElement()) {
      composeBoolean(t, "DeviceDefinitionMaterialComponent", "alternate", element.getAlternateElement(), -1);
    }
    if (element.hasAllergenicIndicatorElement()) {
      composeBoolean(t, "DeviceDefinitionMaterialComponent", "allergenicIndicator", element.getAllergenicIndicatorElement(), -1);
    }
  }

  protected void composeDeviceMetric(Complex parent, String parentType, String name, DeviceMetric element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DeviceMetric", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DeviceMetric", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "DeviceMetric", "type", element.getType(), -1);
    }
    if (element.hasUnit()) {
      composeCodeableConcept(t, "DeviceMetric", "unit", element.getUnit(), -1);
    }
    if (element.hasSource()) {
      composeReference(t, "DeviceMetric", "source", element.getSource(), -1);
    }
    if (element.hasParent()) {
      composeReference(t, "DeviceMetric", "parent", element.getParent(), -1);
    }
    if (element.hasOperationalStatusElement()) {
      composeEnum(t, "DeviceMetric", "operationalStatus", element.getOperationalStatusElement(), -1);
    }
    if (element.hasColorElement()) {
      composeEnum(t, "DeviceMetric", "color", element.getColorElement(), -1);
    }
    if (element.hasCategoryElement()) {
      composeEnum(t, "DeviceMetric", "category", element.getCategoryElement(), -1);
    }
    if (element.hasMeasurementPeriod()) {
      composeTiming(t, "DeviceMetric", "measurementPeriod", element.getMeasurementPeriod(), -1);
    }
    for (int i = 0; i < element.getCalibration().size(); i++) {
      composeDeviceMetricCalibrationComponent(t, "DeviceMetric", "calibration", element.getCalibration().get(i), i);
    }
  }

  protected void composeDeviceMetricCalibrationComponent(Complex parent, String parentType, String name, DeviceMetric.DeviceMetricCalibrationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "calibration", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "DeviceMetricCalibrationComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasStateElement()) {
      composeEnum(t, "DeviceMetricCalibrationComponent", "state", element.getStateElement(), -1);
    }
    if (element.hasTimeElement()) {
      composeInstant(t, "DeviceMetricCalibrationComponent", "time", element.getTimeElement(), -1);
    }
  }

  protected void composeDeviceRequest(Complex parent, String parentType, String name, DeviceRequest element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DeviceRequest", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DeviceRequest", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "DeviceRequest", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "DeviceRequest", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "DeviceRequest", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getPriorRequest().size(); i++) {
      composeReference(t, "DeviceRequest", "priorRequest", element.getPriorRequest().get(i), i);
    }
    if (element.hasGroupIdentifier()) {
      composeIdentifier(t, "DeviceRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "DeviceRequest", "status", element.getStatusElement(), -1);
    }
    if (element.hasIntentElement()) {
      composeEnum(t, "DeviceRequest", "intent", element.getIntentElement(), -1);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "DeviceRequest", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasCode()) {
      composeType(t, "DeviceRequest", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getParameter().size(); i++) {
      composeDeviceRequestParameterComponent(t, "DeviceRequest", "parameter", element.getParameter().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "DeviceRequest", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "DeviceRequest", "encounter", element.getEncounter(), -1);
    }
    if (element.hasOccurrence()) {
      composeType(t, "DeviceRequest", "occurrence", element.getOccurrence(), -1);
    }
    if (element.hasAuthoredOnElement()) {
      composeDateTime(t, "DeviceRequest", "authoredOn", element.getAuthoredOnElement(), -1);
    }
    if (element.hasRequester()) {
      composeReference(t, "DeviceRequest", "requester", element.getRequester(), -1);
    }
    if (element.hasPerformerType()) {
      composeCodeableConcept(t, "DeviceRequest", "performerType", element.getPerformerType(), -1);
    }
    if (element.hasPerformer()) {
      composeReference(t, "DeviceRequest", "performer", element.getPerformer(), -1);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "DeviceRequest", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "DeviceRequest", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeReference(t, "DeviceRequest", "insurance", element.getInsurance().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeReference(t, "DeviceRequest", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "DeviceRequest", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getRelevantHistory().size(); i++) {
      composeReference(t, "DeviceRequest", "relevantHistory", element.getRelevantHistory().get(i), i);
    }
  }

  protected void composeDeviceRequestParameterComponent(Complex parent, String parentType, String name, DeviceRequest.DeviceRequestParameterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "parameter", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "DeviceRequestParameterComponent", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "DeviceRequestParameterComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeDeviceUseStatement(Complex parent, String parentType, String name, DeviceUseStatement element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DeviceUseStatement", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DeviceUseStatement", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "DeviceUseStatement", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "DeviceUseStatement", "status", element.getStatusElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "DeviceUseStatement", "subject", element.getSubject(), -1);
    }
    for (int i = 0; i < element.getDerivedFrom().size(); i++) {
      composeReference(t, "DeviceUseStatement", "derivedFrom", element.getDerivedFrom().get(i), i);
    }
    if (element.hasTiming()) {
      composeType(t, "DeviceUseStatement", "timing", element.getTiming(), -1);
    }
    if (element.hasRecordedOnElement()) {
      composeDateTime(t, "DeviceUseStatement", "recordedOn", element.getRecordedOnElement(), -1);
    }
    if (element.hasSource()) {
      composeReference(t, "DeviceUseStatement", "source", element.getSource(), -1);
    }
    if (element.hasDevice()) {
      composeReference(t, "DeviceUseStatement", "device", element.getDevice(), -1);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "DeviceUseStatement", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "DeviceUseStatement", "reasonReference", element.getReasonReference().get(i), i);
    }
    if (element.hasBodySite()) {
      composeCodeableConcept(t, "DeviceUseStatement", "bodySite", element.getBodySite(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "DeviceUseStatement", "note", element.getNote().get(i), i);
    }
  }

  protected void composeDiagnosticReport(Complex parent, String parentType, String name, DiagnosticReport element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DiagnosticReport", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DiagnosticReport", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "DiagnosticReport", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "DiagnosticReport", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "DiagnosticReport", "category", element.getCategory().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "DiagnosticReport", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "DiagnosticReport", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "DiagnosticReport", "encounter", element.getEncounter(), -1);
    }
    if (element.hasEffective()) {
      composeType(t, "DiagnosticReport", "effective", element.getEffective(), -1);
    }
    if (element.hasIssuedElement()) {
      composeInstant(t, "DiagnosticReport", "issued", element.getIssuedElement(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeReference(t, "DiagnosticReport", "performer", element.getPerformer().get(i), i);
    }
    for (int i = 0; i < element.getResultsInterpreter().size(); i++) {
      composeReference(t, "DiagnosticReport", "resultsInterpreter", element.getResultsInterpreter().get(i), i);
    }
    for (int i = 0; i < element.getSpecimen().size(); i++) {
      composeReference(t, "DiagnosticReport", "specimen", element.getSpecimen().get(i), i);
    }
    for (int i = 0; i < element.getResult().size(); i++) {
      composeReference(t, "DiagnosticReport", "result", element.getResult().get(i), i);
    }
    for (int i = 0; i < element.getImagingStudy().size(); i++) {
      composeReference(t, "DiagnosticReport", "imagingStudy", element.getImagingStudy().get(i), i);
    }
    for (int i = 0; i < element.getMedia().size(); i++) {
      composeDiagnosticReportMediaComponent(t, "DiagnosticReport", "media", element.getMedia().get(i), i);
    }
    if (element.hasConclusionElement()) {
      composeString(t, "DiagnosticReport", "conclusion", element.getConclusionElement(), -1);
    }
    for (int i = 0; i < element.getConclusionCode().size(); i++) {
      composeCodeableConcept(t, "DiagnosticReport", "conclusionCode", element.getConclusionCode().get(i), i);
    }
    for (int i = 0; i < element.getPresentedForm().size(); i++) {
      composeAttachment(t, "DiagnosticReport", "presentedForm", element.getPresentedForm().get(i), i);
    }
  }

  protected void composeDiagnosticReportMediaComponent(Complex parent, String parentType, String name, DiagnosticReport.DiagnosticReportMediaComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "media", name, element, index);
    if (element.hasCommentElement()) {
      composeString(t, "DiagnosticReportMediaComponent", "comment", element.getCommentElement(), -1);
    }
    if (element.hasLink()) {
      composeReference(t, "DiagnosticReportMediaComponent", "link", element.getLink(), -1);
    }
  }

  protected void composeDocumentManifest(Complex parent, String parentType, String name, DocumentManifest element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DocumentManifest", name, element, index);
    if (element.hasMasterIdentifier()) {
      composeIdentifier(t, "DocumentManifest", "masterIdentifier", element.getMasterIdentifier(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DocumentManifest", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "DocumentManifest", "status", element.getStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "DocumentManifest", "type", element.getType(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "DocumentManifest", "subject", element.getSubject(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "DocumentManifest", "created", element.getCreatedElement(), -1);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeReference(t, "DocumentManifest", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getRecipient().size(); i++) {
      composeReference(t, "DocumentManifest", "recipient", element.getRecipient().get(i), i);
    }
    if (element.hasSourceElement()) {
      composeUri(t, "DocumentManifest", "source", element.getSourceElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "DocumentManifest", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getContent().size(); i++) {
      composeReference(t, "DocumentManifest", "content", element.getContent().get(i), i);
    }
    for (int i = 0; i < element.getRelated().size(); i++) {
      composeDocumentManifestRelatedComponent(t, "DocumentManifest", "related", element.getRelated().get(i), i);
    }
  }

  protected void composeDocumentManifestRelatedComponent(Complex parent, String parentType, String name, DocumentManifest.DocumentManifestRelatedComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "related", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "DocumentManifestRelatedComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasRef()) {
      composeReference(t, "DocumentManifestRelatedComponent", "ref", element.getRef(), -1);
    }
  }

  protected void composeDocumentReference(Complex parent, String parentType, String name, DocumentReference element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "DocumentReference", name, element, index);
    if (element.hasMasterIdentifier()) {
      composeIdentifier(t, "DocumentReference", "masterIdentifier", element.getMasterIdentifier(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "DocumentReference", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "DocumentReference", "status", element.getStatusElement(), -1);
    }
    if (element.hasDocStatusElement()) {
      composeEnum(t, "DocumentReference", "docStatus", element.getDocStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "DocumentReference", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "DocumentReference", "category", element.getCategory().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "DocumentReference", "subject", element.getSubject(), -1);
    }
    if (element.hasDateElement()) {
      composeInstant(t, "DocumentReference", "date", element.getDateElement(), -1);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeReference(t, "DocumentReference", "author", element.getAuthor().get(i), i);
    }
    if (element.hasAuthenticator()) {
      composeReference(t, "DocumentReference", "authenticator", element.getAuthenticator(), -1);
    }
    if (element.hasCustodian()) {
      composeReference(t, "DocumentReference", "custodian", element.getCustodian(), -1);
    }
    for (int i = 0; i < element.getRelatesTo().size(); i++) {
      composeDocumentReferenceRelatesToComponent(t, "DocumentReference", "relatesTo", element.getRelatesTo().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "DocumentReference", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getSecurityLabel().size(); i++) {
      composeCodeableConcept(t, "DocumentReference", "securityLabel", element.getSecurityLabel().get(i), i);
    }
    for (int i = 0; i < element.getContent().size(); i++) {
      composeDocumentReferenceContentComponent(t, "DocumentReference", "content", element.getContent().get(i), i);
    }
    if (element.hasContext()) {
      composeDocumentReferenceContextComponent(t, "DocumentReference", "context", element.getContext(), -1);
    }
  }

  protected void composeDocumentReferenceRelatesToComponent(Complex parent, String parentType, String name, DocumentReference.DocumentReferenceRelatesToComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatesTo", name, element, index);
    if (element.hasCodeElement()) {
      composeEnum(t, "DocumentReferenceRelatesToComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasTarget()) {
      composeReference(t, "DocumentReferenceRelatesToComponent", "target", element.getTarget(), -1);
    }
  }

  protected void composeDocumentReferenceContentComponent(Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "content", name, element, index);
    if (element.hasAttachment()) {
      composeAttachment(t, "DocumentReferenceContentComponent", "attachment", element.getAttachment(), -1);
    }
    if (element.hasFormat()) {
      composeCoding(t, "DocumentReferenceContentComponent", "format", element.getFormat(), -1);
    }
  }

  protected void composeDocumentReferenceContextComponent(Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContextComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "context", name, element, index);
    for (int i = 0; i < element.getEncounter().size(); i++) {
      composeReference(t, "DocumentReferenceContextComponent", "encounter", element.getEncounter().get(i), i);
    }
    for (int i = 0; i < element.getEvent().size(); i++) {
      composeCodeableConcept(t, "DocumentReferenceContextComponent", "event", element.getEvent().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "DocumentReferenceContextComponent", "period", element.getPeriod(), -1);
    }
    if (element.hasFacilityType()) {
      composeCodeableConcept(t, "DocumentReferenceContextComponent", "facilityType", element.getFacilityType(), -1);
    }
    if (element.hasPracticeSetting()) {
      composeCodeableConcept(t, "DocumentReferenceContextComponent", "practiceSetting", element.getPracticeSetting(), -1);
    }
    if (element.hasSourcePatientInfo()) {
      composeReference(t, "DocumentReferenceContextComponent", "sourcePatientInfo", element.getSourcePatientInfo(), -1);
    }
    for (int i = 0; i < element.getRelated().size(); i++) {
      composeReference(t, "DocumentReferenceContextComponent", "related", element.getRelated().get(i), i);
    }
  }

  protected void composeEncounter(Complex parent, String parentType, String name, Encounter element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Encounter", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Encounter", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Encounter", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getStatusHistory().size(); i++) {
      composeEncounterStatusHistoryComponent(t, "Encounter", "statusHistory", element.getStatusHistory().get(i), i);
    }
    if (element.hasClass_()) {
      composeCoding(t, "Encounter", "class", element.getClass_(), -1);
    }
    for (int i = 0; i < element.getClassHistory().size(); i++) {
      composeEncounterClassHistoryComponent(t, "Encounter", "classHistory", element.getClassHistory().get(i), i);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "Encounter", "type", element.getType().get(i), i);
    }
    if (element.hasServiceType()) {
      composeCodeableConcept(t, "Encounter", "serviceType", element.getServiceType(), -1);
    }
    if (element.hasPriority()) {
      composeCodeableConcept(t, "Encounter", "priority", element.getPriority(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "Encounter", "subject", element.getSubject(), -1);
    }
    for (int i = 0; i < element.getEpisodeOfCare().size(); i++) {
      composeReference(t, "Encounter", "episodeOfCare", element.getEpisodeOfCare().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "Encounter", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeEncounterParticipantComponent(t, "Encounter", "participant", element.getParticipant().get(i), i);
    }
    for (int i = 0; i < element.getAppointment().size(); i++) {
      composeReference(t, "Encounter", "appointment", element.getAppointment().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "Encounter", "period", element.getPeriod(), -1);
    }
    if (element.hasLength()) {
      composeDuration(t, "Encounter", "length", element.getLength(), -1);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "Encounter", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "Encounter", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getDiagnosis().size(); i++) {
      composeEncounterDiagnosisComponent(t, "Encounter", "diagnosis", element.getDiagnosis().get(i), i);
    }
    for (int i = 0; i < element.getAccount().size(); i++) {
      composeReference(t, "Encounter", "account", element.getAccount().get(i), i);
    }
    if (element.hasHospitalization()) {
      composeEncounterHospitalizationComponent(t, "Encounter", "hospitalization", element.getHospitalization(), -1);
    }
    for (int i = 0; i < element.getLocation().size(); i++) {
      composeEncounterLocationComponent(t, "Encounter", "location", element.getLocation().get(i), i);
    }
    if (element.hasServiceProvider()) {
      composeReference(t, "Encounter", "serviceProvider", element.getServiceProvider(), -1);
    }
    if (element.hasPartOf()) {
      composeReference(t, "Encounter", "partOf", element.getPartOf(), -1);
    }
  }

  protected void composeEncounterStatusHistoryComponent(Complex parent, String parentType, String name, Encounter.StatusHistoryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "statusHistory", name, element, index);
    if (element.hasStatusElement()) {
      composeEnum(t, "StatusHistoryComponent", "status", element.getStatusElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "StatusHistoryComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeEncounterClassHistoryComponent(Complex parent, String parentType, String name, Encounter.ClassHistoryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "classHistory", name, element, index);
    if (element.hasClass_()) {
      composeCoding(t, "ClassHistoryComponent", "class", element.getClass_(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ClassHistoryComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeEncounterParticipantComponent(Complex parent, String parentType, String name, Encounter.EncounterParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "EncounterParticipantComponent", "type", element.getType().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "EncounterParticipantComponent", "period", element.getPeriod(), -1);
    }
    if (element.hasIndividual()) {
      composeReference(t, "EncounterParticipantComponent", "individual", element.getIndividual(), -1);
    }
  }

  protected void composeEncounterDiagnosisComponent(Complex parent, String parentType, String name, Encounter.DiagnosisComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "diagnosis", name, element, index);
    if (element.hasCondition()) {
      composeReference(t, "DiagnosisComponent", "condition", element.getCondition(), -1);
    }
    if (element.hasUse()) {
      composeCodeableConcept(t, "DiagnosisComponent", "use", element.getUse(), -1);
    }
    if (element.hasRankElement()) {
      composePositiveInt(t, "DiagnosisComponent", "rank", element.getRankElement(), -1);
    }
  }

  protected void composeEncounterHospitalizationComponent(Complex parent, String parentType, String name, Encounter.EncounterHospitalizationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "hospitalization", name, element, index);
    if (element.hasPreAdmissionIdentifier()) {
      composeIdentifier(t, "EncounterHospitalizationComponent", "preAdmissionIdentifier", element.getPreAdmissionIdentifier(), -1);
    }
    if (element.hasOrigin()) {
      composeReference(t, "EncounterHospitalizationComponent", "origin", element.getOrigin(), -1);
    }
    if (element.hasAdmitSource()) {
      composeCodeableConcept(t, "EncounterHospitalizationComponent", "admitSource", element.getAdmitSource(), -1);
    }
    if (element.hasReAdmission()) {
      composeCodeableConcept(t, "EncounterHospitalizationComponent", "reAdmission", element.getReAdmission(), -1);
    }
    for (int i = 0; i < element.getDietPreference().size(); i++) {
      composeCodeableConcept(t, "EncounterHospitalizationComponent", "dietPreference", element.getDietPreference().get(i), i);
    }
    for (int i = 0; i < element.getSpecialCourtesy().size(); i++) {
      composeCodeableConcept(t, "EncounterHospitalizationComponent", "specialCourtesy", element.getSpecialCourtesy().get(i), i);
    }
    for (int i = 0; i < element.getSpecialArrangement().size(); i++) {
      composeCodeableConcept(t, "EncounterHospitalizationComponent", "specialArrangement", element.getSpecialArrangement().get(i), i);
    }
    if (element.hasDestination()) {
      composeReference(t, "EncounterHospitalizationComponent", "destination", element.getDestination(), -1);
    }
    if (element.hasDischargeDisposition()) {
      composeCodeableConcept(t, "EncounterHospitalizationComponent", "dischargeDisposition", element.getDischargeDisposition(), -1);
    }
  }

  protected void composeEncounterLocationComponent(Complex parent, String parentType, String name, Encounter.EncounterLocationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "location", name, element, index);
    if (element.hasLocation()) {
      composeReference(t, "EncounterLocationComponent", "location", element.getLocation(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "EncounterLocationComponent", "status", element.getStatusElement(), -1);
    }
    if (element.hasPhysicalType()) {
      composeCodeableConcept(t, "EncounterLocationComponent", "physicalType", element.getPhysicalType(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "EncounterLocationComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeEndpoint(Complex parent, String parentType, String name, Endpoint element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Endpoint", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Endpoint", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Endpoint", "status", element.getStatusElement(), -1);
    }
    if (element.hasConnectionType()) {
      composeCoding(t, "Endpoint", "connectionType", element.getConnectionType(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Endpoint", "name", element.getNameElement(), -1);
    }
    if (element.hasManagingOrganization()) {
      composeReference(t, "Endpoint", "managingOrganization", element.getManagingOrganization(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactPoint(t, "Endpoint", "contact", element.getContact().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "Endpoint", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getPayloadType().size(); i++) {
      composeCodeableConcept(t, "Endpoint", "payloadType", element.getPayloadType().get(i), i);
    }
    for (int i = 0; i < element.getPayloadMimeType().size(); i++) {
      composeCode(t, "Endpoint", "payloadMimeType", element.getPayloadMimeType().get(i), i);
    }
    if (element.hasAddressElement()) {
      composeUrl(t, "Endpoint", "address", element.getAddressElement(), -1);
    }
    for (int i = 0; i < element.getHeader().size(); i++) {
      composeString(t, "Endpoint", "header", element.getHeader().get(i), i);
    }
  }

  protected void composeEnrollmentRequest(Complex parent, String parentType, String name, EnrollmentRequest element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "EnrollmentRequest", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "EnrollmentRequest", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "EnrollmentRequest", "status", element.getStatusElement(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "EnrollmentRequest", "created", element.getCreatedElement(), -1);
    }
    if (element.hasInsurer()) {
      composeReference(t, "EnrollmentRequest", "insurer", element.getInsurer(), -1);
    }
    if (element.hasProvider()) {
      composeReference(t, "EnrollmentRequest", "provider", element.getProvider(), -1);
    }
    if (element.hasCandidate()) {
      composeReference(t, "EnrollmentRequest", "candidate", element.getCandidate(), -1);
    }
    if (element.hasCoverage()) {
      composeReference(t, "EnrollmentRequest", "coverage", element.getCoverage(), -1);
    }
  }

  protected void composeEnrollmentResponse(Complex parent, String parentType, String name, EnrollmentResponse element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "EnrollmentResponse", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "EnrollmentResponse", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "EnrollmentResponse", "status", element.getStatusElement(), -1);
    }
    if (element.hasRequest()) {
      composeReference(t, "EnrollmentResponse", "request", element.getRequest(), -1);
    }
    if (element.hasOutcomeElement()) {
      composeEnum(t, "EnrollmentResponse", "outcome", element.getOutcomeElement(), -1);
    }
    if (element.hasDispositionElement()) {
      composeString(t, "EnrollmentResponse", "disposition", element.getDispositionElement(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "EnrollmentResponse", "created", element.getCreatedElement(), -1);
    }
    if (element.hasOrganization()) {
      composeReference(t, "EnrollmentResponse", "organization", element.getOrganization(), -1);
    }
    if (element.hasRequestProvider()) {
      composeReference(t, "EnrollmentResponse", "requestProvider", element.getRequestProvider(), -1);
    }
  }

  protected void composeEpisodeOfCare(Complex parent, String parentType, String name, EpisodeOfCare element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "EpisodeOfCare", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "EpisodeOfCare", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "EpisodeOfCare", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getStatusHistory().size(); i++) {
      composeEpisodeOfCareStatusHistoryComponent(t, "EpisodeOfCare", "statusHistory", element.getStatusHistory().get(i), i);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "EpisodeOfCare", "type", element.getType().get(i), i);
    }
    for (int i = 0; i < element.getDiagnosis().size(); i++) {
      composeEpisodeOfCareDiagnosisComponent(t, "EpisodeOfCare", "diagnosis", element.getDiagnosis().get(i), i);
    }
    if (element.hasPatient()) {
      composeReference(t, "EpisodeOfCare", "patient", element.getPatient(), -1);
    }
    if (element.hasManagingOrganization()) {
      composeReference(t, "EpisodeOfCare", "managingOrganization", element.getManagingOrganization(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "EpisodeOfCare", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getReferralRequest().size(); i++) {
      composeReference(t, "EpisodeOfCare", "referralRequest", element.getReferralRequest().get(i), i);
    }
    if (element.hasCareManager()) {
      composeReference(t, "EpisodeOfCare", "careManager", element.getCareManager(), -1);
    }
    for (int i = 0; i < element.getTeam().size(); i++) {
      composeReference(t, "EpisodeOfCare", "team", element.getTeam().get(i), i);
    }
    for (int i = 0; i < element.getAccount().size(); i++) {
      composeReference(t, "EpisodeOfCare", "account", element.getAccount().get(i), i);
    }
  }

  protected void composeEpisodeOfCareStatusHistoryComponent(Complex parent, String parentType, String name, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "statusHistory", name, element, index);
    if (element.hasStatusElement()) {
      composeEnum(t, "EpisodeOfCareStatusHistoryComponent", "status", element.getStatusElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "EpisodeOfCareStatusHistoryComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeEpisodeOfCareDiagnosisComponent(Complex parent, String parentType, String name, EpisodeOfCare.DiagnosisComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "diagnosis", name, element, index);
    if (element.hasCondition()) {
      composeReference(t, "DiagnosisComponent", "condition", element.getCondition(), -1);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "DiagnosisComponent", "role", element.getRole(), -1);
    }
    if (element.hasRankElement()) {
      composePositiveInt(t, "DiagnosisComponent", "rank", element.getRankElement(), -1);
    }
  }

  protected void composeEventDefinition(Complex parent, String parentType, String name, EventDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "EventDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "EventDefinition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "EventDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "EventDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "EventDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "EventDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "EventDefinition", "subtitle", element.getSubtitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "EventDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "EventDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasSubject()) {
      composeType(t, "EventDefinition", "subject", element.getSubject(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "EventDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "EventDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "EventDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "EventDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "EventDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "EventDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "EventDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasUsageElement()) {
      composeString(t, "EventDefinition", "usage", element.getUsageElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "EventDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "EventDefinition", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "EventDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "EventDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "EventDefinition", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "EventDefinition", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "EventDefinition", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "EventDefinition", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "EventDefinition", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "EventDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    for (int i = 0; i < element.getTrigger().size(); i++) {
      composeTriggerDefinition(t, "EventDefinition", "trigger", element.getTrigger().get(i), i);
    }
  }

  protected void composeEvidence(Complex parent, String parentType, String name, Evidence element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Evidence", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "Evidence", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Evidence", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Evidence", "version", element.getVersionElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Evidence", "title", element.getTitleElement(), -1);
    }
    if (element.hasCiteAs()) {
      composeType(t, "Evidence", "citeAs", element.getCiteAs(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Evidence", "status", element.getStatusElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "Evidence", "date", element.getDateElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "Evidence", "useContext", element.getUseContext().get(i), i);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "Evidence", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "Evidence", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "Evidence", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "Evidence", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "Evidence", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "Evidence", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "Evidence", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "Evidence", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "Evidence", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "Evidence", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasAssertionElement()) {
      composeMarkdown(t, "Evidence", "assertion", element.getAssertionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Evidence", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getVariableDefinition().size(); i++) {
      composeEvidenceVariableDefinitionComponent(t, "Evidence", "variableDefinition", element.getVariableDefinition().get(i), i);
    }
    if (element.hasSynthesisType()) {
      composeCodeableConcept(t, "Evidence", "synthesisType", element.getSynthesisType(), -1);
    }
    if (element.hasStudyType()) {
      composeCodeableConcept(t, "Evidence", "studyType", element.getStudyType(), -1);
    }
    for (int i = 0; i < element.getStatistic().size(); i++) {
      composeEvidenceStatisticComponent(t, "Evidence", "statistic", element.getStatistic().get(i), i);
    }
    for (int i = 0; i < element.getCertainty().size(); i++) {
      composeEvidenceCertaintyComponent(t, "Evidence", "certainty", element.getCertainty().get(i), i);
    }
  }

  protected void composeEvidenceVariableDefinitionComponent(Complex parent, String parentType, String name, Evidence.EvidenceVariableDefinitionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "variableDefinition", name, element, index);
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "EvidenceVariableDefinitionComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceVariableDefinitionComponent", "note", element.getNote().get(i), i);
    }
    if (element.hasVariableRole()) {
      composeCodeableConcept(t, "EvidenceVariableDefinitionComponent", "variableRole", element.getVariableRole(), -1);
    }
    if (element.hasObserved()) {
      composeReference(t, "EvidenceVariableDefinitionComponent", "observed", element.getObserved(), -1);
    }
    if (element.hasIntended()) {
      composeReference(t, "EvidenceVariableDefinitionComponent", "intended", element.getIntended(), -1);
    }
    if (element.hasDirectnessMatch()) {
      composeCodeableConcept(t, "EvidenceVariableDefinitionComponent", "directnessMatch", element.getDirectnessMatch(), -1);
    }
  }

  protected void composeEvidenceStatisticComponent(Complex parent, String parentType, String name, Evidence.EvidenceStatisticComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "statistic", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "EvidenceStatisticComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceStatisticComponent", "note", element.getNote().get(i), i);
    }
    if (element.hasStatisticType()) {
      composeCodeableConcept(t, "EvidenceStatisticComponent", "statisticType", element.getStatisticType(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "EvidenceStatisticComponent", "category", element.getCategory(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "EvidenceStatisticComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasNumberOfEventsElement()) {
      composeUnsignedInt(t, "EvidenceStatisticComponent", "numberOfEvents", element.getNumberOfEventsElement(), -1);
    }
    if (element.hasNumberAffectedElement()) {
      composeUnsignedInt(t, "EvidenceStatisticComponent", "numberAffected", element.getNumberAffectedElement(), -1);
    }
    if (element.hasSampleSize()) {
      composeEvidenceStatisticSampleSizeComponent(t, "EvidenceStatisticComponent", "sampleSize", element.getSampleSize(), -1);
    }
    for (int i = 0; i < element.getAttributeEstimate().size(); i++) {
      composeEvidenceStatisticAttributeEstimateComponent(t, "EvidenceStatisticComponent", "attributeEstimate", element.getAttributeEstimate().get(i), i);
    }
    for (int i = 0; i < element.getModelCharacteristic().size(); i++) {
      composeEvidenceStatisticModelCharacteristicComponent(t, "EvidenceStatisticComponent", "modelCharacteristic", element.getModelCharacteristic().get(i), i);
    }
  }

  protected void composeEvidenceStatisticSampleSizeComponent(Complex parent, String parentType, String name, Evidence.EvidenceStatisticSampleSizeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "sampleSize", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "EvidenceStatisticSampleSizeComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceStatisticSampleSizeComponent", "note", element.getNote().get(i), i);
    }
    if (element.hasNumberOfStudiesElement()) {
      composeUnsignedInt(t, "EvidenceStatisticSampleSizeComponent", "numberOfStudies", element.getNumberOfStudiesElement(), -1);
    }
    if (element.hasNumberOfParticipantsElement()) {
      composeUnsignedInt(t, "EvidenceStatisticSampleSizeComponent", "numberOfParticipants", element.getNumberOfParticipantsElement(), -1);
    }
    if (element.hasKnownDataCountElement()) {
      composeUnsignedInt(t, "EvidenceStatisticSampleSizeComponent", "knownDataCount", element.getKnownDataCountElement(), -1);
    }
  }

  protected void composeEvidenceStatisticAttributeEstimateComponent(Complex parent, String parentType, String name, Evidence.EvidenceStatisticAttributeEstimateComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "attributeEstimate", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "EvidenceStatisticAttributeEstimateComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceStatisticAttributeEstimateComponent", "note", element.getNote().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "EvidenceStatisticAttributeEstimateComponent", "type", element.getType(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "EvidenceStatisticAttributeEstimateComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasLevelElement()) {
      composeDecimal(t, "EvidenceStatisticAttributeEstimateComponent", "level", element.getLevelElement(), -1);
    }
    if (element.hasRange()) {
      composeRange(t, "EvidenceStatisticAttributeEstimateComponent", "range", element.getRange(), -1);
    }
    for (int i = 0; i < element.getAttributeEstimate().size(); i++) {
      composeEvidenceStatisticAttributeEstimateComponent(t, "EvidenceStatisticAttributeEstimateComponent", "attributeEstimate", element.getAttributeEstimate().get(i), i);
    }
  }

  protected void composeEvidenceStatisticModelCharacteristicComponent(Complex parent, String parentType, String name, Evidence.EvidenceStatisticModelCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "modelCharacteristic", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "EvidenceStatisticModelCharacteristicComponent", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeQuantity(t, "EvidenceStatisticModelCharacteristicComponent", "value", element.getValue(), -1);
    }
    for (int i = 0; i < element.getVariable().size(); i++) {
      composeEvidenceStatisticModelCharacteristicVariableComponent(t, "EvidenceStatisticModelCharacteristicComponent", "variable", element.getVariable().get(i), i);
    }
    for (int i = 0; i < element.getAttributeEstimate().size(); i++) {
      composeEvidenceStatisticAttributeEstimateComponent(t, "EvidenceStatisticModelCharacteristicComponent", "attributeEstimate", element.getAttributeEstimate().get(i), i);
    }
  }

  protected void composeEvidenceStatisticModelCharacteristicVariableComponent(Complex parent, String parentType, String name, Evidence.EvidenceStatisticModelCharacteristicVariableComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "variable", name, element, index);
    if (element.hasVariableDefinition()) {
      composeReference(t, "EvidenceStatisticModelCharacteristicVariableComponent", "variableDefinition", element.getVariableDefinition(), -1);
    }
    if (element.hasHandlingElement()) {
      composeEnum(t, "EvidenceStatisticModelCharacteristicVariableComponent", "handling", element.getHandlingElement(), -1);
    }
    for (int i = 0; i < element.getValueCategory().size(); i++) {
      composeCodeableConcept(t, "EvidenceStatisticModelCharacteristicVariableComponent", "valueCategory", element.getValueCategory().get(i), i);
    }
    for (int i = 0; i < element.getValueQuantity().size(); i++) {
      composeQuantity(t, "EvidenceStatisticModelCharacteristicVariableComponent", "valueQuantity", element.getValueQuantity().get(i), i);
    }
    for (int i = 0; i < element.getValueRange().size(); i++) {
      composeRange(t, "EvidenceStatisticModelCharacteristicVariableComponent", "valueRange", element.getValueRange().get(i), i);
    }
  }

  protected void composeEvidenceCertaintyComponent(Complex parent, String parentType, String name, Evidence.EvidenceCertaintyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "certainty", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "EvidenceCertaintyComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceCertaintyComponent", "note", element.getNote().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "EvidenceCertaintyComponent", "type", element.getType(), -1);
    }
    if (element.hasRating()) {
      composeCodeableConcept(t, "EvidenceCertaintyComponent", "rating", element.getRating(), -1);
    }
    if (element.hasRaterElement()) {
      composeString(t, "EvidenceCertaintyComponent", "rater", element.getRaterElement(), -1);
    }
    for (int i = 0; i < element.getSubcomponent().size(); i++) {
      composeEvidenceCertaintyComponent(t, "EvidenceCertaintyComponent", "subcomponent", element.getSubcomponent().get(i), i);
    }
  }

  protected void composeEvidenceReport(Complex parent, String parentType, String name, EvidenceReport element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "EvidenceReport", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "EvidenceReport", "url", element.getUrlElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "EvidenceReport", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "EvidenceReport", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "EvidenceReport", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getRelatedIdentifier().size(); i++) {
      composeIdentifier(t, "EvidenceReport", "relatedIdentifier", element.getRelatedIdentifier().get(i), i);
    }
    if (element.hasCiteAs()) {
      composeType(t, "EvidenceReport", "citeAs", element.getCiteAs(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "EvidenceReport", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceReport", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "EvidenceReport", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    if (element.hasSubject()) {
      composeEvidenceReportSubjectComponent(t, "EvidenceReport", "subject", element.getSubject(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "EvidenceReport", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "EvidenceReport", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "EvidenceReport", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "EvidenceReport", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "EvidenceReport", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "EvidenceReport", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatesTo().size(); i++) {
      composeEvidenceReportRelatesToComponent(t, "EvidenceReport", "relatesTo", element.getRelatesTo().get(i), i);
    }
    for (int i = 0; i < element.getSection().size(); i++) {
      composeEvidenceReportSectionComponent(t, "EvidenceReport", "section", element.getSection().get(i), i);
    }
  }

  protected void composeEvidenceReportSubjectComponent(Complex parent, String parentType, String name, EvidenceReport.EvidenceReportSubjectComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "subject", name, element, index);
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composeEvidenceReportSubjectCharacteristicComponent(t, "EvidenceReportSubjectComponent", "characteristic", element.getCharacteristic().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceReportSubjectComponent", "note", element.getNote().get(i), i);
    }
  }

  protected void composeEvidenceReportSubjectCharacteristicComponent(Complex parent, String parentType, String name, EvidenceReport.EvidenceReportSubjectCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "characteristic", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "EvidenceReportSubjectCharacteristicComponent", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "EvidenceReportSubjectCharacteristicComponent", "value", element.getValue(), -1);
    }
    if (element.hasExcludeElement()) {
      composeBoolean(t, "EvidenceReportSubjectCharacteristicComponent", "exclude", element.getExcludeElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "EvidenceReportSubjectCharacteristicComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeEvidenceReportRelatesToComponent(Complex parent, String parentType, String name, EvidenceReport.EvidenceReportRelatesToComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatesTo", name, element, index);
    if (element.hasCodeElement()) {
      composeEnum(t, "EvidenceReportRelatesToComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasTarget()) {
      composeType(t, "EvidenceReportRelatesToComponent", "target", element.getTarget(), -1);
    }
  }

  protected void composeEvidenceReportSectionComponent(Complex parent, String parentType, String name, EvidenceReport.SectionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "section", name, element, index);
    if (element.hasTitleElement()) {
      composeString(t, "SectionComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasFocus()) {
      composeCodeableConcept(t, "SectionComponent", "focus", element.getFocus(), -1);
    }
    if (element.hasFocusReference()) {
      composeReference(t, "SectionComponent", "focusReference", element.getFocusReference(), -1);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeReference(t, "SectionComponent", "author", element.getAuthor().get(i), i);
    }
    if (element.hasText()) {
      composeNarrative(t, "SectionComponent", "text", element.getText(), -1);
    }
    if (element.hasModeElement()) {
      composeEnum(t, "SectionComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasOrderedBy()) {
      composeCodeableConcept(t, "SectionComponent", "orderedBy", element.getOrderedBy(), -1);
    }
    for (int i = 0; i < element.getEntryClassifier().size(); i++) {
      composeCodeableConcept(t, "SectionComponent", "entryClassifier", element.getEntryClassifier().get(i), i);
    }
    for (int i = 0; i < element.getEntryReference().size(); i++) {
      composeReference(t, "SectionComponent", "entryReference", element.getEntryReference().get(i), i);
    }
    for (int i = 0; i < element.getEntryQuantity().size(); i++) {
      composeQuantity(t, "SectionComponent", "entryQuantity", element.getEntryQuantity().get(i), i);
    }
    if (element.hasEmptyReason()) {
      composeCodeableConcept(t, "SectionComponent", "emptyReason", element.getEmptyReason(), -1);
    }
    for (int i = 0; i < element.getSection().size(); i++) {
      composeEvidenceReportSectionComponent(t, "SectionComponent", "section", element.getSection().get(i), i);
    }
  }

  protected void composeEvidenceVariable(Complex parent, String parentType, String name, EvidenceVariable element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "EvidenceVariable", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "EvidenceVariable", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "EvidenceVariable", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "EvidenceVariable", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "EvidenceVariable", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "EvidenceVariable", "title", element.getTitleElement(), -1);
    }
    if (element.hasShortTitleElement()) {
      composeString(t, "EvidenceVariable", "shortTitle", element.getShortTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "EvidenceVariable", "subtitle", element.getSubtitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "EvidenceVariable", "status", element.getStatusElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "EvidenceVariable", "date", element.getDateElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "EvidenceVariable", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceVariable", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "EvidenceVariable", "useContext", element.getUseContext().get(i), i);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "EvidenceVariable", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "EvidenceVariable", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "EvidenceVariable", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "EvidenceVariable", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "EvidenceVariable", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "EvidenceVariable", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "EvidenceVariable", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    if (element.hasActualElement()) {
      composeBoolean(t, "EvidenceVariable", "actual", element.getActualElement(), -1);
    }
    if (element.hasCharacteristicCombinationElement()) {
      composeEnum(t, "EvidenceVariable", "characteristicCombination", element.getCharacteristicCombinationElement(), -1);
    }
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composeEvidenceVariableCharacteristicComponent(t, "EvidenceVariable", "characteristic", element.getCharacteristic().get(i), i);
    }
    if (element.hasHandlingElement()) {
      composeEnum(t, "EvidenceVariable", "handling", element.getHandlingElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeEvidenceVariableCategoryComponent(t, "EvidenceVariable", "category", element.getCategory().get(i), i);
    }
  }

  protected void composeEvidenceVariableCharacteristicComponent(Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "characteristic", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "EvidenceVariableCharacteristicComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasDefinition()) {
      composeType(t, "EvidenceVariableCharacteristicComponent", "definition", element.getDefinition(), -1);
    }
    if (element.hasMethod()) {
      composeCodeableConcept(t, "EvidenceVariableCharacteristicComponent", "method", element.getMethod(), -1);
    }
    if (element.hasDevice()) {
      composeReference(t, "EvidenceVariableCharacteristicComponent", "device", element.getDevice(), -1);
    }
    if (element.hasExcludeElement()) {
      composeBoolean(t, "EvidenceVariableCharacteristicComponent", "exclude", element.getExcludeElement(), -1);
    }
    if (element.hasTimeFromStart()) {
      composeEvidenceVariableCharacteristicTimeFromStartComponent(t, "EvidenceVariableCharacteristicComponent", "timeFromStart", element.getTimeFromStart(), -1);
    }
    if (element.hasGroupMeasureElement()) {
      composeEnum(t, "EvidenceVariableCharacteristicComponent", "groupMeasure", element.getGroupMeasureElement(), -1);
    }
  }

  protected void composeEvidenceVariableCharacteristicTimeFromStartComponent(Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCharacteristicTimeFromStartComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "timeFromStart", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "EvidenceVariableCharacteristicTimeFromStartComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "EvidenceVariableCharacteristicTimeFromStartComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasRange()) {
      composeRange(t, "EvidenceVariableCharacteristicTimeFromStartComponent", "range", element.getRange(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "EvidenceVariableCharacteristicTimeFromStartComponent", "note", element.getNote().get(i), i);
    }
  }

  protected void composeEvidenceVariableCategoryComponent(Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCategoryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "category", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "EvidenceVariableCategoryComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "EvidenceVariableCategoryComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeExampleScenario(Complex parent, String parentType, String name, ExampleScenario element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ExampleScenario", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ExampleScenario", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ExampleScenario", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ExampleScenario", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ExampleScenario", "name", element.getNameElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ExampleScenario", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "ExampleScenario", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ExampleScenario", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "ExampleScenario", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ExampleScenario", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "ExampleScenario", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "ExampleScenario", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ExampleScenario", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "ExampleScenario", "purpose", element.getPurposeElement(), -1);
    }
    for (int i = 0; i < element.getActor().size(); i++) {
      composeExampleScenarioActorComponent(t, "ExampleScenario", "actor", element.getActor().get(i), i);
    }
    for (int i = 0; i < element.getInstance().size(); i++) {
      composeExampleScenarioInstanceComponent(t, "ExampleScenario", "instance", element.getInstance().get(i), i);
    }
    for (int i = 0; i < element.getProcess().size(); i++) {
      composeExampleScenarioProcessComponent(t, "ExampleScenario", "process", element.getProcess().get(i), i);
    }
    for (int i = 0; i < element.getWorkflow().size(); i++) {
      composeCanonical(t, "ExampleScenario", "workflow", element.getWorkflow().get(i), i);
    }
  }

  protected void composeExampleScenarioActorComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioActorComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "actor", name, element, index);
    if (element.hasActorIdElement()) {
      composeString(t, "ExampleScenarioActorComponent", "actorId", element.getActorIdElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "ExampleScenarioActorComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ExampleScenarioActorComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ExampleScenarioActorComponent", "description", element.getDescriptionElement(), -1);
    }
  }

  protected void composeExampleScenarioInstanceComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "instance", name, element, index);
    if (element.hasResourceIdElement()) {
      composeString(t, "ExampleScenarioInstanceComponent", "resourceId", element.getResourceIdElement(), -1);
    }
    if (element.hasResourceTypeElement()) {
      composeCode(t, "ExampleScenarioInstanceComponent", "resourceType", element.getResourceTypeElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ExampleScenarioInstanceComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ExampleScenarioInstanceComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getVersion().size(); i++) {
      composeExampleScenarioInstanceVersionComponent(t, "ExampleScenarioInstanceComponent", "version", element.getVersion().get(i), i);
    }
    for (int i = 0; i < element.getContainedInstance().size(); i++) {
      composeExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenarioInstanceComponent", "containedInstance", element.getContainedInstance().get(i), i);
    }
  }

  protected void composeExampleScenarioInstanceVersionComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceVersionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "version", name, element, index);
    if (element.hasVersionIdElement()) {
      composeString(t, "ExampleScenarioInstanceVersionComponent", "versionId", element.getVersionIdElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ExampleScenarioInstanceVersionComponent", "description", element.getDescriptionElement(), -1);
    }
  }

  protected void composeExampleScenarioInstanceContainedInstanceComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "containedInstance", name, element, index);
    if (element.hasResourceIdElement()) {
      composeString(t, "ExampleScenarioInstanceContainedInstanceComponent", "resourceId", element.getResourceIdElement(), -1);
    }
    if (element.hasVersionIdElement()) {
      composeString(t, "ExampleScenarioInstanceContainedInstanceComponent", "versionId", element.getVersionIdElement(), -1);
    }
  }

  protected void composeExampleScenarioProcessComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "process", name, element, index);
    if (element.hasTitleElement()) {
      composeString(t, "ExampleScenarioProcessComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ExampleScenarioProcessComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasPreConditionsElement()) {
      composeMarkdown(t, "ExampleScenarioProcessComponent", "preConditions", element.getPreConditionsElement(), -1);
    }
    if (element.hasPostConditionsElement()) {
      composeMarkdown(t, "ExampleScenarioProcessComponent", "postConditions", element.getPostConditionsElement(), -1);
    }
    for (int i = 0; i < element.getStep().size(); i++) {
      composeExampleScenarioProcessStepComponent(t, "ExampleScenarioProcessComponent", "step", element.getStep().get(i), i);
    }
  }

  protected void composeExampleScenarioProcessStepComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "step", name, element, index);
    for (int i = 0; i < element.getProcess().size(); i++) {
      composeExampleScenarioProcessComponent(t, "ExampleScenarioProcessStepComponent", "process", element.getProcess().get(i), i);
    }
    if (element.hasPauseElement()) {
      composeBoolean(t, "ExampleScenarioProcessStepComponent", "pause", element.getPauseElement(), -1);
    }
    if (element.hasOperation()) {
      composeExampleScenarioProcessStepOperationComponent(t, "ExampleScenarioProcessStepComponent", "operation", element.getOperation(), -1);
    }
    for (int i = 0; i < element.getAlternative().size(); i++) {
      composeExampleScenarioProcessStepAlternativeComponent(t, "ExampleScenarioProcessStepComponent", "alternative", element.getAlternative().get(i), i);
    }
  }

  protected void composeExampleScenarioProcessStepOperationComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepOperationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "operation", name, element, index);
    if (element.hasNumberElement()) {
      composeString(t, "ExampleScenarioProcessStepOperationComponent", "number", element.getNumberElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeString(t, "ExampleScenarioProcessStepOperationComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ExampleScenarioProcessStepOperationComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasInitiatorElement()) {
      composeString(t, "ExampleScenarioProcessStepOperationComponent", "initiator", element.getInitiatorElement(), -1);
    }
    if (element.hasReceiverElement()) {
      composeString(t, "ExampleScenarioProcessStepOperationComponent", "receiver", element.getReceiverElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ExampleScenarioProcessStepOperationComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasInitiatorActiveElement()) {
      composeBoolean(t, "ExampleScenarioProcessStepOperationComponent", "initiatorActive", element.getInitiatorActiveElement(), -1);
    }
    if (element.hasReceiverActiveElement()) {
      composeBoolean(t, "ExampleScenarioProcessStepOperationComponent", "receiverActive", element.getReceiverActiveElement(), -1);
    }
    if (element.hasRequest()) {
      composeExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenarioProcessStepOperationComponent", "request", element.getRequest(), -1);
    }
    if (element.hasResponse()) {
      composeExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenarioProcessStepOperationComponent", "response", element.getResponse(), -1);
    }
  }

  protected void composeExampleScenarioProcessStepAlternativeComponent(Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "alternative", name, element, index);
    if (element.hasTitleElement()) {
      composeString(t, "ExampleScenarioProcessStepAlternativeComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ExampleScenarioProcessStepAlternativeComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getStep().size(); i++) {
      composeExampleScenarioProcessStepComponent(t, "ExampleScenarioProcessStepAlternativeComponent", "step", element.getStep().get(i), i);
    }
  }

  protected void composeExplanationOfBenefit(Complex parent, String parentType, String name, ExplanationOfBenefit element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ExplanationOfBenefit", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ExplanationOfBenefit", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ExplanationOfBenefit", "status", element.getStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType(), -1);
    }
    if (element.hasSubType()) {
      composeCodeableConcept(t, "ExplanationOfBenefit", "subType", element.getSubType(), -1);
    }
    if (element.hasUseElement()) {
      composeEnum(t, "ExplanationOfBenefit", "use", element.getUseElement(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "ExplanationOfBenefit", "patient", element.getPatient(), -1);
    }
    if (element.hasBillablePeriod()) {
      composePeriod(t, "ExplanationOfBenefit", "billablePeriod", element.getBillablePeriod(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "ExplanationOfBenefit", "created", element.getCreatedElement(), -1);
    }
    if (element.hasEnterer()) {
      composeReference(t, "ExplanationOfBenefit", "enterer", element.getEnterer(), -1);
    }
    if (element.hasInsurer()) {
      composeReference(t, "ExplanationOfBenefit", "insurer", element.getInsurer(), -1);
    }
    if (element.hasProvider()) {
      composeReference(t, "ExplanationOfBenefit", "provider", element.getProvider(), -1);
    }
    if (element.hasPriority()) {
      composeCodeableConcept(t, "ExplanationOfBenefit", "priority", element.getPriority(), -1);
    }
    if (element.hasFundsReserveRequested()) {
      composeCodeableConcept(t, "ExplanationOfBenefit", "fundsReserveRequested", element.getFundsReserveRequested(), -1);
    }
    if (element.hasFundsReserve()) {
      composeCodeableConcept(t, "ExplanationOfBenefit", "fundsReserve", element.getFundsReserve(), -1);
    }
    for (int i = 0; i < element.getRelated().size(); i++) {
      composeExplanationOfBenefitRelatedClaimComponent(t, "ExplanationOfBenefit", "related", element.getRelated().get(i), i);
    }
    if (element.hasPrescription()) {
      composeReference(t, "ExplanationOfBenefit", "prescription", element.getPrescription(), -1);
    }
    if (element.hasOriginalPrescription()) {
      composeReference(t, "ExplanationOfBenefit", "originalPrescription", element.getOriginalPrescription(), -1);
    }
    if (element.hasPayee()) {
      composeExplanationOfBenefitPayeeComponent(t, "ExplanationOfBenefit", "payee", element.getPayee(), -1);
    }
    if (element.hasReferral()) {
      composeReference(t, "ExplanationOfBenefit", "referral", element.getReferral(), -1);
    }
    if (element.hasFacility()) {
      composeReference(t, "ExplanationOfBenefit", "facility", element.getFacility(), -1);
    }
    if (element.hasClaim()) {
      composeReference(t, "ExplanationOfBenefit", "claim", element.getClaim(), -1);
    }
    if (element.hasClaimResponse()) {
      composeReference(t, "ExplanationOfBenefit", "claimResponse", element.getClaimResponse(), -1);
    }
    if (element.hasOutcomeElement()) {
      composeEnum(t, "ExplanationOfBenefit", "outcome", element.getOutcomeElement(), -1);
    }
    if (element.hasDispositionElement()) {
      composeString(t, "ExplanationOfBenefit", "disposition", element.getDispositionElement(), -1);
    }
    for (int i = 0; i < element.getPreAuthRef().size(); i++) {
      composeString(t, "ExplanationOfBenefit", "preAuthRef", element.getPreAuthRef().get(i), i);
    }
    for (int i = 0; i < element.getPreAuthRefPeriod().size(); i++) {
      composePeriod(t, "ExplanationOfBenefit", "preAuthRefPeriod", element.getPreAuthRefPeriod().get(i), i);
    }
    for (int i = 0; i < element.getCareTeam().size(); i++) {
      composeExplanationOfBenefitCareTeamComponent(t, "ExplanationOfBenefit", "careTeam", element.getCareTeam().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeExplanationOfBenefitSupportingInformationComponent(t, "ExplanationOfBenefit", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getDiagnosis().size(); i++) {
      composeExplanationOfBenefitDiagnosisComponent(t, "ExplanationOfBenefit", "diagnosis", element.getDiagnosis().get(i), i);
    }
    for (int i = 0; i < element.getProcedure().size(); i++) {
      composeExplanationOfBenefitProcedureComponent(t, "ExplanationOfBenefit", "procedure", element.getProcedure().get(i), i);
    }
    if (element.hasPrecedenceElement()) {
      composePositiveInt(t, "ExplanationOfBenefit", "precedence", element.getPrecedenceElement(), -1);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeExplanationOfBenefitInsuranceComponent(t, "ExplanationOfBenefit", "insurance", element.getInsurance().get(i), i);
    }
    if (element.hasAccident()) {
      composeExplanationOfBenefitAccidentComponent(t, "ExplanationOfBenefit", "accident", element.getAccident(), -1);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeExplanationOfBenefitItemComponent(t, "ExplanationOfBenefit", "item", element.getItem().get(i), i);
    }
    for (int i = 0; i < element.getAddItem().size(); i++) {
      composeExplanationOfBenefitAddedItemComponent(t, "ExplanationOfBenefit", "addItem", element.getAddItem().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeExplanationOfBenefitAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getTotal().size(); i++) {
      composeExplanationOfBenefitTotalComponent(t, "ExplanationOfBenefit", "total", element.getTotal().get(i), i);
    }
    if (element.hasPayment()) {
      composeExplanationOfBenefitPaymentComponent(t, "ExplanationOfBenefit", "payment", element.getPayment(), -1);
    }
    if (element.hasFormCode()) {
      composeCodeableConcept(t, "ExplanationOfBenefit", "formCode", element.getFormCode(), -1);
    }
    if (element.hasForm()) {
      composeAttachment(t, "ExplanationOfBenefit", "form", element.getForm(), -1);
    }
    for (int i = 0; i < element.getProcessNote().size(); i++) {
      composeExplanationOfBenefitNoteComponent(t, "ExplanationOfBenefit", "processNote", element.getProcessNote().get(i), i);
    }
    if (element.hasBenefitPeriod()) {
      composePeriod(t, "ExplanationOfBenefit", "benefitPeriod", element.getBenefitPeriod(), -1);
    }
    for (int i = 0; i < element.getBenefitBalance().size(); i++) {
      composeExplanationOfBenefitBenefitBalanceComponent(t, "ExplanationOfBenefit", "benefitBalance", element.getBenefitBalance().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitRelatedClaimComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.RelatedClaimComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "related", name, element, index);
    if (element.hasClaim()) {
      composeReference(t, "RelatedClaimComponent", "claim", element.getClaim(), -1);
    }
    if (element.hasRelationship()) {
      composeCodeableConcept(t, "RelatedClaimComponent", "relationship", element.getRelationship(), -1);
    }
    if (element.hasReference()) {
      composeIdentifier(t, "RelatedClaimComponent", "reference", element.getReference(), -1);
    }
  }

  protected void composeExplanationOfBenefitPayeeComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.PayeeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "payee", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "PayeeComponent", "type", element.getType(), -1);
    }
    if (element.hasParty()) {
      composeReference(t, "PayeeComponent", "party", element.getParty(), -1);
    }
  }

  protected void composeExplanationOfBenefitCareTeamComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.CareTeamComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "careTeam", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "CareTeamComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasProvider()) {
      composeReference(t, "CareTeamComponent", "provider", element.getProvider(), -1);
    }
    if (element.hasResponsibleElement()) {
      composeBoolean(t, "CareTeamComponent", "responsible", element.getResponsibleElement(), -1);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "CareTeamComponent", "role", element.getRole(), -1);
    }
    if (element.hasQualification()) {
      composeCodeableConcept(t, "CareTeamComponent", "qualification", element.getQualification(), -1);
    }
  }

  protected void composeExplanationOfBenefitSupportingInformationComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.SupportingInformationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "supportingInfo", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "SupportingInformationComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "SupportingInformationComponent", "category", element.getCategory(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "SupportingInformationComponent", "code", element.getCode(), -1);
    }
    if (element.hasTiming()) {
      composeType(t, "SupportingInformationComponent", "timing", element.getTiming(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "SupportingInformationComponent", "value", element.getValue(), -1);
    }
    if (element.hasReason()) {
      composeCoding(t, "SupportingInformationComponent", "reason", element.getReason(), -1);
    }
  }

  protected void composeExplanationOfBenefitDiagnosisComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.DiagnosisComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "diagnosis", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "DiagnosisComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasDiagnosis()) {
      composeType(t, "DiagnosisComponent", "diagnosis", element.getDiagnosis(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "DiagnosisComponent", "type", element.getType().get(i), i);
    }
    if (element.hasOnAdmission()) {
      composeCodeableConcept(t, "DiagnosisComponent", "onAdmission", element.getOnAdmission(), -1);
    }
    if (element.hasPackageCode()) {
      composeCodeableConcept(t, "DiagnosisComponent", "packageCode", element.getPackageCode(), -1);
    }
  }

  protected void composeExplanationOfBenefitProcedureComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.ProcedureComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "procedure", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "ProcedureComponent", "sequence", element.getSequenceElement(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "ProcedureComponent", "type", element.getType().get(i), i);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ProcedureComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasProcedure()) {
      composeType(t, "ProcedureComponent", "procedure", element.getProcedure(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "ProcedureComponent", "udi", element.getUdi().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitInsuranceComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.InsuranceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "insurance", name, element, index);
    if (element.hasFocalElement()) {
      composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
    }
    if (element.hasCoverage()) {
      composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
    }
    for (int i = 0; i < element.getPreAuthRef().size(); i++) {
      composeString(t, "InsuranceComponent", "preAuthRef", element.getPreAuthRef().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitAccidentComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.AccidentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "accident", name, element, index);
    if (element.hasDateElement()) {
      composeDate(t, "AccidentComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "AccidentComponent", "type", element.getType(), -1);
    }
    if (element.hasLocation()) {
      composeType(t, "AccidentComponent", "location", element.getLocation(), -1);
    }
  }

  protected void composeExplanationOfBenefitItemComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.ItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "ItemComponent", "sequence", element.getSequenceElement(), -1);
    }
    for (int i = 0; i < element.getCareTeamSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "careTeamSequence", element.getCareTeamSequence().get(i), i);
    }
    for (int i = 0; i < element.getDiagnosisSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "diagnosisSequence", element.getDiagnosisSequence().get(i), i);
    }
    for (int i = 0; i < element.getProcedureSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "procedureSequence", element.getProcedureSequence().get(i), i);
    }
    for (int i = 0; i < element.getInformationSequence().size(); i++) {
      composePositiveInt(t, "ItemComponent", "informationSequence", element.getInformationSequence().get(i), i);
    }
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "ItemComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "ItemComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "ItemComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "ItemComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "ItemComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasServiced()) {
      composeType(t, "ItemComponent", "serviced", element.getServiced(), -1);
    }
    if (element.hasLocation()) {
      composeType(t, "ItemComponent", "location", element.getLocation(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "ItemComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "ItemComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "ItemComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "ItemComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "ItemComponent", "udi", element.getUdi().get(i), i);
    }
    if (element.hasBodySite()) {
      composeCodeableConcept(t, "ItemComponent", "bodySite", element.getBodySite(), -1);
    }
    for (int i = 0; i < element.getSubSite().size(); i++) {
      composeCodeableConcept(t, "ItemComponent", "subSite", element.getSubSite().get(i), i);
    }
    for (int i = 0; i < element.getEncounter().size(); i++) {
      composeReference(t, "ItemComponent", "encounter", element.getEncounter().get(i), i);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "ItemComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeExplanationOfBenefitAdjudicationComponent(t, "ItemComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeExplanationOfBenefitDetailComponent(t, "ItemComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitAdjudicationComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.AdjudicationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "adjudication", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "AdjudicationComponent", "category", element.getCategory(), -1);
    }
    if (element.hasReason()) {
      composeCodeableConcept(t, "AdjudicationComponent", "reason", element.getReason(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "AdjudicationComponent", "amount", element.getAmount(), -1);
    }
    if (element.hasValueElement()) {
      composeDecimal(t, "AdjudicationComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeExplanationOfBenefitDetailComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.DetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "detail", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "DetailComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "DetailComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "DetailComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "DetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "DetailComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "DetailComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "DetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "DetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "DetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "DetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "DetailComponent", "udi", element.getUdi().get(i), i);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "DetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeExplanationOfBenefitAdjudicationComponent(t, "DetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getSubDetail().size(); i++) {
      composeExplanationOfBenefitSubDetailComponent(t, "DetailComponent", "subDetail", element.getSubDetail().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitSubDetailComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.SubDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "subDetail", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "SubDetailComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasRevenue()) {
      composeCodeableConcept(t, "SubDetailComponent", "revenue", element.getRevenue(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "SubDetailComponent", "category", element.getCategory(), -1);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "SubDetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "SubDetailComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "SubDetailComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "SubDetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "SubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "SubDetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "SubDetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getUdi().size(); i++) {
      composeReference(t, "SubDetailComponent", "udi", element.getUdi().get(i), i);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "SubDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeExplanationOfBenefitAdjudicationComponent(t, "SubDetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitAddedItemComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "addItem", name, element, index);
    for (int i = 0; i < element.getItemSequence().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "itemSequence", element.getItemSequence().get(i), i);
    }
    for (int i = 0; i < element.getDetailSequence().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "detailSequence", element.getDetailSequence().get(i), i);
    }
    for (int i = 0; i < element.getSubDetailSequence().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "subDetailSequence", element.getSubDetailSequence().get(i), i);
    }
    for (int i = 0; i < element.getProvider().size(); i++) {
      composeReference(t, "AddedItemComponent", "provider", element.getProvider().get(i), i);
    }
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "AddedItemComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "AddedItemComponent", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getProgramCode().size(); i++) {
      composeCodeableConcept(t, "AddedItemComponent", "programCode", element.getProgramCode().get(i), i);
    }
    if (element.hasServiced()) {
      composeType(t, "AddedItemComponent", "serviced", element.getServiced(), -1);
    }
    if (element.hasLocation()) {
      composeType(t, "AddedItemComponent", "location", element.getLocation(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "AddedItemComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "AddedItemComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "AddedItemComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "AddedItemComponent", "net", element.getNet(), -1);
    }
    if (element.hasBodySite()) {
      composeCodeableConcept(t, "AddedItemComponent", "bodySite", element.getBodySite(), -1);
    }
    for (int i = 0; i < element.getSubSite().size(); i++) {
      composeCodeableConcept(t, "AddedItemComponent", "subSite", element.getSubSite().get(i), i);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "AddedItemComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeExplanationOfBenefitAdjudicationComponent(t, "AddedItemComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composeExplanationOfBenefitAddedItemDetailComponent(t, "AddedItemComponent", "detail", element.getDetail().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitAddedItemDetailComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "detail", name, element, index);
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "AddedItemDetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "AddedItemDetailComponent", "modifier", element.getModifier().get(i), i);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "AddedItemDetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "AddedItemDetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "AddedItemDetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "AddedItemDetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "AddedItemDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeExplanationOfBenefitAdjudicationComponent(t, "AddedItemDetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
    for (int i = 0; i < element.getSubDetail().size(); i++) {
      composeExplanationOfBenefitAddedItemDetailSubDetailComponent(t, "AddedItemDetailComponent", "subDetail", element.getSubDetail().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitAddedItemDetailSubDetailComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemDetailSubDetailComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "subDetail", name, element, index);
    if (element.hasProductOrService()) {
      composeCodeableConcept(t, "AddedItemDetailSubDetailComponent", "productOrService", element.getProductOrService(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeCodeableConcept(t, "AddedItemDetailSubDetailComponent", "modifier", element.getModifier().get(i), i);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "AddedItemDetailSubDetailComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasUnitPrice()) {
      composeMoney(t, "AddedItemDetailSubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "AddedItemDetailSubDetailComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasNet()) {
      composeMoney(t, "AddedItemDetailSubDetailComponent", "net", element.getNet(), -1);
    }
    for (int i = 0; i < element.getNoteNumber().size(); i++) {
      composePositiveInt(t, "AddedItemDetailSubDetailComponent", "noteNumber", element.getNoteNumber().get(i), i);
    }
    for (int i = 0; i < element.getAdjudication().size(); i++) {
      composeExplanationOfBenefitAdjudicationComponent(t, "AddedItemDetailSubDetailComponent", "adjudication", element.getAdjudication().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitTotalComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.TotalComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "total", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "TotalComponent", "category", element.getCategory(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "TotalComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composeExplanationOfBenefitPaymentComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.PaymentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "payment", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "PaymentComponent", "type", element.getType(), -1);
    }
    if (element.hasAdjustment()) {
      composeMoney(t, "PaymentComponent", "adjustment", element.getAdjustment(), -1);
    }
    if (element.hasAdjustmentReason()) {
      composeCodeableConcept(t, "PaymentComponent", "adjustmentReason", element.getAdjustmentReason(), -1);
    }
    if (element.hasDateElement()) {
      composeDate(t, "PaymentComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "PaymentComponent", "amount", element.getAmount(), -1);
    }
    if (element.hasIdentifier()) {
      composeIdentifier(t, "PaymentComponent", "identifier", element.getIdentifier(), -1);
    }
  }

  protected void composeExplanationOfBenefitNoteComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.NoteComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "processNote", name, element, index);
    if (element.hasNumberElement()) {
      composePositiveInt(t, "NoteComponent", "number", element.getNumberElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "NoteComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "NoteComponent", "text", element.getTextElement(), -1);
    }
    if (element.hasLanguage()) {
      composeCodeableConcept(t, "NoteComponent", "language", element.getLanguage(), -1);
    }
  }

  protected void composeExplanationOfBenefitBenefitBalanceComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.BenefitBalanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "benefitBalance", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "BenefitBalanceComponent", "category", element.getCategory(), -1);
    }
    if (element.hasExcludedElement()) {
      composeBoolean(t, "BenefitBalanceComponent", "excluded", element.getExcludedElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "BenefitBalanceComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "BenefitBalanceComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasNetwork()) {
      composeCodeableConcept(t, "BenefitBalanceComponent", "network", element.getNetwork(), -1);
    }
    if (element.hasUnit()) {
      composeCodeableConcept(t, "BenefitBalanceComponent", "unit", element.getUnit(), -1);
    }
    if (element.hasTerm()) {
      composeCodeableConcept(t, "BenefitBalanceComponent", "term", element.getTerm(), -1);
    }
    for (int i = 0; i < element.getFinancial().size(); i++) {
      composeExplanationOfBenefitBenefitComponent(t, "BenefitBalanceComponent", "financial", element.getFinancial().get(i), i);
    }
  }

  protected void composeExplanationOfBenefitBenefitComponent(Complex parent, String parentType, String name, ExplanationOfBenefit.BenefitComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "financial", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "BenefitComponent", "type", element.getType(), -1);
    }
    if (element.hasAllowed()) {
      composeType(t, "BenefitComponent", "allowed", element.getAllowed(), -1);
    }
    if (element.hasUsed()) {
      composeType(t, "BenefitComponent", "used", element.getUsed(), -1);
    }
  }

  protected void composeFamilyMemberHistory(Complex parent, String parentType, String name, FamilyMemberHistory element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "FamilyMemberHistory", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "FamilyMemberHistory", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "FamilyMemberHistory", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "FamilyMemberHistory", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "FamilyMemberHistory", "status", element.getStatusElement(), -1);
    }
    if (element.hasDataAbsentReason()) {
      composeCodeableConcept(t, "FamilyMemberHistory", "dataAbsentReason", element.getDataAbsentReason(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "FamilyMemberHistory", "patient", element.getPatient(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "FamilyMemberHistory", "date", element.getDateElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "FamilyMemberHistory", "name", element.getNameElement(), -1);
    }
    if (element.hasRelationship()) {
      composeCodeableConcept(t, "FamilyMemberHistory", "relationship", element.getRelationship(), -1);
    }
    if (element.hasSex()) {
      composeCodeableConcept(t, "FamilyMemberHistory", "sex", element.getSex(), -1);
    }
    if (element.hasBorn()) {
      composeType(t, "FamilyMemberHistory", "born", element.getBorn(), -1);
    }
    if (element.hasAge()) {
      composeType(t, "FamilyMemberHistory", "age", element.getAge(), -1);
    }
    if (element.hasEstimatedAgeElement()) {
      composeBoolean(t, "FamilyMemberHistory", "estimatedAge", element.getEstimatedAgeElement(), -1);
    }
    if (element.hasDeceased()) {
      composeType(t, "FamilyMemberHistory", "deceased", element.getDeceased(), -1);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "FamilyMemberHistory", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "FamilyMemberHistory", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "FamilyMemberHistory", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getCondition().size(); i++) {
      composeFamilyMemberHistoryConditionComponent(t, "FamilyMemberHistory", "condition", element.getCondition().get(i), i);
    }
  }

  protected void composeFamilyMemberHistoryConditionComponent(Complex parent, String parentType, String name, FamilyMemberHistory.FamilyMemberHistoryConditionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "condition", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "FamilyMemberHistoryConditionComponent", "code", element.getCode(), -1);
    }
    if (element.hasOutcome()) {
      composeCodeableConcept(t, "FamilyMemberHistoryConditionComponent", "outcome", element.getOutcome(), -1);
    }
    if (element.hasContributedToDeathElement()) {
      composeBoolean(t, "FamilyMemberHistoryConditionComponent", "contributedToDeath", element.getContributedToDeathElement(), -1);
    }
    if (element.hasOnset()) {
      composeType(t, "FamilyMemberHistoryConditionComponent", "onset", element.getOnset(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "FamilyMemberHistoryConditionComponent", "note", element.getNote().get(i), i);
    }
  }

  protected void composeFlag(Complex parent, String parentType, String name, Flag element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Flag", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Flag", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Flag", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Flag", "category", element.getCategory().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Flag", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "Flag", "subject", element.getSubject(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "Flag", "period", element.getPeriod(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Flag", "encounter", element.getEncounter(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "Flag", "author", element.getAuthor(), -1);
    }
  }

  protected void composeGoal(Complex parent, String parentType, String name, Goal element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Goal", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Goal", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasLifecycleStatusElement()) {
      composeEnum(t, "Goal", "lifecycleStatus", element.getLifecycleStatusElement(), -1);
    }
    if (element.hasAchievementStatus()) {
      composeCodeableConcept(t, "Goal", "achievementStatus", element.getAchievementStatus(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Goal", "category", element.getCategory().get(i), i);
    }
    if (element.hasPriority()) {
      composeCodeableConcept(t, "Goal", "priority", element.getPriority(), -1);
    }
    if (element.hasDescription()) {
      composeCodeableConcept(t, "Goal", "description", element.getDescription(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "Goal", "subject", element.getSubject(), -1);
    }
    if (element.hasStart()) {
      composeType(t, "Goal", "start", element.getStart(), -1);
    }
    for (int i = 0; i < element.getTarget().size(); i++) {
      composeGoalTargetComponent(t, "Goal", "target", element.getTarget().get(i), i);
    }
    if (element.hasStatusDateElement()) {
      composeDate(t, "Goal", "statusDate", element.getStatusDateElement(), -1);
    }
    if (element.hasStatusReasonElement()) {
      composeString(t, "Goal", "statusReason", element.getStatusReasonElement(), -1);
    }
    if (element.hasExpressedBy()) {
      composeReference(t, "Goal", "expressedBy", element.getExpressedBy(), -1);
    }
    for (int i = 0; i < element.getAddresses().size(); i++) {
      composeReference(t, "Goal", "addresses", element.getAddresses().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Goal", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getOutcomeCode().size(); i++) {
      composeCodeableConcept(t, "Goal", "outcomeCode", element.getOutcomeCode().get(i), i);
    }
    for (int i = 0; i < element.getOutcomeReference().size(); i++) {
      composeReference(t, "Goal", "outcomeReference", element.getOutcomeReference().get(i), i);
    }
  }

  protected void composeGoalTargetComponent(Complex parent, String parentType, String name, Goal.GoalTargetComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "target", name, element, index);
    if (element.hasMeasure()) {
      composeCodeableConcept(t, "GoalTargetComponent", "measure", element.getMeasure(), -1);
    }
    if (element.hasDetail()) {
      composeType(t, "GoalTargetComponent", "detail", element.getDetail(), -1);
    }
    if (element.hasDue()) {
      composeType(t, "GoalTargetComponent", "due", element.getDue(), -1);
    }
  }

  protected void composeGraphDefinition(Complex parent, String parentType, String name, GraphDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "GraphDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "GraphDefinition", "url", element.getUrlElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "GraphDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "GraphDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "GraphDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "GraphDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "GraphDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "GraphDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "GraphDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "GraphDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "GraphDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "GraphDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "GraphDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasStartElement()) {
      composeCode(t, "GraphDefinition", "start", element.getStartElement(), -1);
    }
    if (element.hasProfileElement()) {
      composeCanonical(t, "GraphDefinition", "profile", element.getProfileElement(), -1);
    }
    for (int i = 0; i < element.getLink().size(); i++) {
      composeGraphDefinitionLinkComponent(t, "GraphDefinition", "link", element.getLink().get(i), i);
    }
  }

  protected void composeGraphDefinitionLinkComponent(Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "link", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "GraphDefinitionLinkComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasSliceNameElement()) {
      composeString(t, "GraphDefinitionLinkComponent", "sliceName", element.getSliceNameElement(), -1);
    }
    if (element.hasMinElement()) {
      composeInteger(t, "GraphDefinitionLinkComponent", "min", element.getMinElement(), -1);
    }
    if (element.hasMaxElement()) {
      composeString(t, "GraphDefinitionLinkComponent", "max", element.getMaxElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "GraphDefinitionLinkComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getTarget().size(); i++) {
      composeGraphDefinitionLinkTargetComponent(t, "GraphDefinitionLinkComponent", "target", element.getTarget().get(i), i);
    }
  }

  protected void composeGraphDefinitionLinkTargetComponent(Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkTargetComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "target", name, element, index);
    if (element.hasTypeElement()) {
      composeCode(t, "GraphDefinitionLinkTargetComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasParamsElement()) {
      composeString(t, "GraphDefinitionLinkTargetComponent", "params", element.getParamsElement(), -1);
    }
    if (element.hasProfileElement()) {
      composeCanonical(t, "GraphDefinitionLinkTargetComponent", "profile", element.getProfileElement(), -1);
    }
    for (int i = 0; i < element.getCompartment().size(); i++) {
      composeGraphDefinitionLinkTargetCompartmentComponent(t, "GraphDefinitionLinkTargetComponent", "compartment", element.getCompartment().get(i), i);
    }
    for (int i = 0; i < element.getLink().size(); i++) {
      composeGraphDefinitionLinkComponent(t, "GraphDefinitionLinkTargetComponent", "link", element.getLink().get(i), i);
    }
  }

  protected void composeGraphDefinitionLinkTargetCompartmentComponent(Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "compartment", name, element, index);
    if (element.hasUseElement()) {
      composeEnum(t, "GraphDefinitionLinkTargetCompartmentComponent", "use", element.getUseElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeEnum(t, "GraphDefinitionLinkTargetCompartmentComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasRuleElement()) {
      composeEnum(t, "GraphDefinitionLinkTargetCompartmentComponent", "rule", element.getRuleElement(), -1);
    }
    if (element.hasExpressionElement()) {
      composeString(t, "GraphDefinitionLinkTargetCompartmentComponent", "expression", element.getExpressionElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "GraphDefinitionLinkTargetCompartmentComponent", "description", element.getDescriptionElement(), -1);
    }
  }

  protected void composeGroup(Complex parent, String parentType, String name, Group element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Group", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Group", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "Group", "active", element.getActiveElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "Group", "type", element.getTypeElement(), -1);
    }
    if (element.hasActualElement()) {
      composeBoolean(t, "Group", "actual", element.getActualElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Group", "code", element.getCode(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Group", "name", element.getNameElement(), -1);
    }
    if (element.hasQuantityElement()) {
      composeUnsignedInt(t, "Group", "quantity", element.getQuantityElement(), -1);
    }
    if (element.hasManagingEntity()) {
      composeReference(t, "Group", "managingEntity", element.getManagingEntity(), -1);
    }
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composeGroupCharacteristicComponent(t, "Group", "characteristic", element.getCharacteristic().get(i), i);
    }
    for (int i = 0; i < element.getMember().size(); i++) {
      composeGroupMemberComponent(t, "Group", "member", element.getMember().get(i), i);
    }
  }

  protected void composeGroupCharacteristicComponent(Complex parent, String parentType, String name, Group.GroupCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "characteristic", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "GroupCharacteristicComponent", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "GroupCharacteristicComponent", "value", element.getValue(), -1);
    }
    if (element.hasExcludeElement()) {
      composeBoolean(t, "GroupCharacteristicComponent", "exclude", element.getExcludeElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "GroupCharacteristicComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeGroupMemberComponent(Complex parent, String parentType, String name, Group.GroupMemberComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "member", name, element, index);
    if (element.hasEntity()) {
      composeReference(t, "GroupMemberComponent", "entity", element.getEntity(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "GroupMemberComponent", "period", element.getPeriod(), -1);
    }
    if (element.hasInactiveElement()) {
      composeBoolean(t, "GroupMemberComponent", "inactive", element.getInactiveElement(), -1);
    }
  }

  protected void composeGuidanceResponse(Complex parent, String parentType, String name, GuidanceResponse element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "GuidanceResponse", name, element, index);
    if (element.hasRequestIdentifier()) {
      composeIdentifier(t, "GuidanceResponse", "requestIdentifier", element.getRequestIdentifier(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "GuidanceResponse", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasModule()) {
      composeType(t, "GuidanceResponse", "module", element.getModule(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "GuidanceResponse", "status", element.getStatusElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "GuidanceResponse", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "GuidanceResponse", "encounter", element.getEncounter(), -1);
    }
    if (element.hasOccurrenceDateTimeElement()) {
      composeDateTime(t, "GuidanceResponse", "occurrenceDateTime", element.getOccurrenceDateTimeElement(), -1);
    }
    if (element.hasPerformer()) {
      composeReference(t, "GuidanceResponse", "performer", element.getPerformer(), -1);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "GuidanceResponse", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "GuidanceResponse", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "GuidanceResponse", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getEvaluationMessage().size(); i++) {
      composeReference(t, "GuidanceResponse", "evaluationMessage", element.getEvaluationMessage().get(i), i);
    }
    if (element.hasOutputParameters()) {
      composeReference(t, "GuidanceResponse", "outputParameters", element.getOutputParameters(), -1);
    }
    if (element.hasResult()) {
      composeReference(t, "GuidanceResponse", "result", element.getResult(), -1);
    }
    for (int i = 0; i < element.getDataRequirement().size(); i++) {
      composeDataRequirement(t, "GuidanceResponse", "dataRequirement", element.getDataRequirement().get(i), i);
    }
  }

  protected void composeHealthcareService(Complex parent, String parentType, String name, HealthcareService element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "HealthcareService", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "HealthcareService", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "HealthcareService", "active", element.getActiveElement(), -1);
    }
    if (element.hasProvidedBy()) {
      composeReference(t, "HealthcareService", "providedBy", element.getProvidedBy(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "category", element.getCategory().get(i), i);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "type", element.getType().get(i), i);
    }
    for (int i = 0; i < element.getSpecialty().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "specialty", element.getSpecialty().get(i), i);
    }
    for (int i = 0; i < element.getLocation().size(); i++) {
      composeReference(t, "HealthcareService", "location", element.getLocation().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "HealthcareService", "name", element.getNameElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeString(t, "HealthcareService", "comment", element.getCommentElement(), -1);
    }
    if (element.hasExtraDetailsElement()) {
      composeMarkdown(t, "HealthcareService", "extraDetails", element.getExtraDetailsElement(), -1);
    }
    if (element.hasPhoto()) {
      composeAttachment(t, "HealthcareService", "photo", element.getPhoto(), -1);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "HealthcareService", "telecom", element.getTelecom().get(i), i);
    }
    for (int i = 0; i < element.getCoverageArea().size(); i++) {
      composeReference(t, "HealthcareService", "coverageArea", element.getCoverageArea().get(i), i);
    }
    for (int i = 0; i < element.getServiceProvisionCode().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "serviceProvisionCode", element.getServiceProvisionCode().get(i), i);
    }
    for (int i = 0; i < element.getEligibility().size(); i++) {
      composeHealthcareServiceEligibilityComponent(t, "HealthcareService", "eligibility", element.getEligibility().get(i), i);
    }
    for (int i = 0; i < element.getProgram().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "program", element.getProgram().get(i), i);
    }
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "characteristic", element.getCharacteristic().get(i), i);
    }
    for (int i = 0; i < element.getCommunication().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "communication", element.getCommunication().get(i), i);
    }
    for (int i = 0; i < element.getReferralMethod().size(); i++) {
      composeCodeableConcept(t, "HealthcareService", "referralMethod", element.getReferralMethod().get(i), i);
    }
    if (element.hasAppointmentRequiredElement()) {
      composeBoolean(t, "HealthcareService", "appointmentRequired", element.getAppointmentRequiredElement(), -1);
    }
    for (int i = 0; i < element.getAvailableTime().size(); i++) {
      composeHealthcareServiceAvailableTimeComponent(t, "HealthcareService", "availableTime", element.getAvailableTime().get(i), i);
    }
    for (int i = 0; i < element.getNotAvailable().size(); i++) {
      composeHealthcareServiceNotAvailableComponent(t, "HealthcareService", "notAvailable", element.getNotAvailable().get(i), i);
    }
    if (element.hasAvailabilityExceptionsElement()) {
      composeString(t, "HealthcareService", "availabilityExceptions", element.getAvailabilityExceptionsElement(), -1);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "HealthcareService", "endpoint", element.getEndpoint().get(i), i);
    }
  }

  protected void composeHealthcareServiceEligibilityComponent(Complex parent, String parentType, String name, HealthcareService.HealthcareServiceEligibilityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "eligibility", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "HealthcareServiceEligibilityComponent", "code", element.getCode(), -1);
    }
    if (element.hasCommentElement()) {
      composeMarkdown(t, "HealthcareServiceEligibilityComponent", "comment", element.getCommentElement(), -1);
    }
  }

  protected void composeHealthcareServiceAvailableTimeComponent(Complex parent, String parentType, String name, HealthcareService.HealthcareServiceAvailableTimeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "availableTime", name, element, index);
    for (int i = 0; i < element.getDaysOfWeek().size(); i++) {
      composeEnum(t, "HealthcareServiceAvailableTimeComponent", "daysOfWeek", element.getDaysOfWeek().get(i), i);
    }
    if (element.hasAllDayElement()) {
      composeBoolean(t, "HealthcareServiceAvailableTimeComponent", "allDay", element.getAllDayElement(), -1);
    }
    if (element.hasAvailableStartTimeElement()) {
      composeTime(t, "HealthcareServiceAvailableTimeComponent", "availableStartTime", element.getAvailableStartTimeElement(), -1);
    }
    if (element.hasAvailableEndTimeElement()) {
      composeTime(t, "HealthcareServiceAvailableTimeComponent", "availableEndTime", element.getAvailableEndTimeElement(), -1);
    }
  }

  protected void composeHealthcareServiceNotAvailableComponent(Complex parent, String parentType, String name, HealthcareService.HealthcareServiceNotAvailableComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "notAvailable", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "HealthcareServiceNotAvailableComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasDuring()) {
      composePeriod(t, "HealthcareServiceNotAvailableComponent", "during", element.getDuring(), -1);
    }
  }

  protected void composeImagingStudy(Complex parent, String parentType, String name, ImagingStudy element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ImagingStudy", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ImagingStudy", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ImagingStudy", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getModality().size(); i++) {
      composeCoding(t, "ImagingStudy", "modality", element.getModality().get(i), i);
    }
    if (element.hasSubject()) {
      composeReference(t, "ImagingStudy", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "ImagingStudy", "encounter", element.getEncounter(), -1);
    }
    if (element.hasStartedElement()) {
      composeDateTime(t, "ImagingStudy", "started", element.getStartedElement(), -1);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "ImagingStudy", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasReferrer()) {
      composeReference(t, "ImagingStudy", "referrer", element.getReferrer(), -1);
    }
    for (int i = 0; i < element.getInterpreter().size(); i++) {
      composeReference(t, "ImagingStudy", "interpreter", element.getInterpreter().get(i), i);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "ImagingStudy", "endpoint", element.getEndpoint().get(i), i);
    }
    if (element.hasNumberOfSeriesElement()) {
      composeUnsignedInt(t, "ImagingStudy", "numberOfSeries", element.getNumberOfSeriesElement(), -1);
    }
    if (element.hasNumberOfInstancesElement()) {
      composeUnsignedInt(t, "ImagingStudy", "numberOfInstances", element.getNumberOfInstancesElement(), -1);
    }
    if (element.hasProcedureReference()) {
      composeReference(t, "ImagingStudy", "procedureReference", element.getProcedureReference(), -1);
    }
    for (int i = 0; i < element.getProcedureCode().size(); i++) {
      composeCodeableConcept(t, "ImagingStudy", "procedureCode", element.getProcedureCode().get(i), i);
    }
    if (element.hasLocation()) {
      composeReference(t, "ImagingStudy", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "ImagingStudy", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "ImagingStudy", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "ImagingStudy", "note", element.getNote().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ImagingStudy", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getSeries().size(); i++) {
      composeImagingStudySeriesComponent(t, "ImagingStudy", "series", element.getSeries().get(i), i);
    }
  }

  protected void composeImagingStudySeriesComponent(Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "series", name, element, index);
    if (element.hasUidElement()) {
      composeId(t, "ImagingStudySeriesComponent", "uid", element.getUidElement(), -1);
    }
    if (element.hasNumberElement()) {
      composeUnsignedInt(t, "ImagingStudySeriesComponent", "number", element.getNumberElement(), -1);
    }
    if (element.hasModality()) {
      composeCoding(t, "ImagingStudySeriesComponent", "modality", element.getModality(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ImagingStudySeriesComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasNumberOfInstancesElement()) {
      composeUnsignedInt(t, "ImagingStudySeriesComponent", "numberOfInstances", element.getNumberOfInstancesElement(), -1);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "ImagingStudySeriesComponent", "endpoint", element.getEndpoint().get(i), i);
    }
    if (element.hasBodySite()) {
      composeCoding(t, "ImagingStudySeriesComponent", "bodySite", element.getBodySite(), -1);
    }
    if (element.hasLaterality()) {
      composeCoding(t, "ImagingStudySeriesComponent", "laterality", element.getLaterality(), -1);
    }
    for (int i = 0; i < element.getSpecimen().size(); i++) {
      composeReference(t, "ImagingStudySeriesComponent", "specimen", element.getSpecimen().get(i), i);
    }
    if (element.hasStartedElement()) {
      composeDateTime(t, "ImagingStudySeriesComponent", "started", element.getStartedElement(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeImagingStudySeriesPerformerComponent(t, "ImagingStudySeriesComponent", "performer", element.getPerformer().get(i), i);
    }
    for (int i = 0; i < element.getInstance().size(); i++) {
      composeImagingStudySeriesInstanceComponent(t, "ImagingStudySeriesComponent", "instance", element.getInstance().get(i), i);
    }
  }

  protected void composeImagingStudySeriesPerformerComponent(Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesPerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "ImagingStudySeriesPerformerComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "ImagingStudySeriesPerformerComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeImagingStudySeriesInstanceComponent(Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesInstanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "instance", name, element, index);
    if (element.hasUidElement()) {
      composeId(t, "ImagingStudySeriesInstanceComponent", "uid", element.getUidElement(), -1);
    }
    if (element.hasSopClass()) {
      composeCoding(t, "ImagingStudySeriesInstanceComponent", "sopClass", element.getSopClass(), -1);
    }
    if (element.hasNumberElement()) {
      composeUnsignedInt(t, "ImagingStudySeriesInstanceComponent", "number", element.getNumberElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ImagingStudySeriesInstanceComponent", "title", element.getTitleElement(), -1);
    }
  }

  protected void composeImmunization(Complex parent, String parentType, String name, Immunization element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Immunization", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Immunization", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Immunization", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept(t, "Immunization", "statusReason", element.getStatusReason(), -1);
    }
    if (element.hasVaccineCode()) {
      composeCodeableConcept(t, "Immunization", "vaccineCode", element.getVaccineCode(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "Immunization", "patient", element.getPatient(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Immunization", "encounter", element.getEncounter(), -1);
    }
    if (element.hasOccurrence()) {
      composeType(t, "Immunization", "occurrence", element.getOccurrence(), -1);
    }
    if (element.hasRecordedElement()) {
      composeDateTime(t, "Immunization", "recorded", element.getRecordedElement(), -1);
    }
    if (element.hasPrimarySourceElement()) {
      composeBoolean(t, "Immunization", "primarySource", element.getPrimarySourceElement(), -1);
    }
    if (element.hasReportOrigin()) {
      composeCodeableConcept(t, "Immunization", "reportOrigin", element.getReportOrigin(), -1);
    }
    if (element.hasLocation()) {
      composeReference(t, "Immunization", "location", element.getLocation(), -1);
    }
    if (element.hasManufacturer()) {
      composeReference(t, "Immunization", "manufacturer", element.getManufacturer(), -1);
    }
    if (element.hasLotNumberElement()) {
      composeString(t, "Immunization", "lotNumber", element.getLotNumberElement(), -1);
    }
    if (element.hasExpirationDateElement()) {
      composeDate(t, "Immunization", "expirationDate", element.getExpirationDateElement(), -1);
    }
    if (element.hasSite()) {
      composeCodeableConcept(t, "Immunization", "site", element.getSite(), -1);
    }
    if (element.hasRoute()) {
      composeCodeableConcept(t, "Immunization", "route", element.getRoute(), -1);
    }
    if (element.hasDoseQuantity()) {
      composeQuantity(t, "Immunization", "doseQuantity", element.getDoseQuantity(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeImmunizationPerformerComponent(t, "Immunization", "performer", element.getPerformer().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Immunization", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "Immunization", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "Immunization", "reasonReference", element.getReasonReference().get(i), i);
    }
    if (element.hasIsSubpotentElement()) {
      composeBoolean(t, "Immunization", "isSubpotent", element.getIsSubpotentElement(), -1);
    }
    for (int i = 0; i < element.getSubpotentReason().size(); i++) {
      composeCodeableConcept(t, "Immunization", "subpotentReason", element.getSubpotentReason().get(i), i);
    }
    for (int i = 0; i < element.getEducation().size(); i++) {
      composeImmunizationEducationComponent(t, "Immunization", "education", element.getEducation().get(i), i);
    }
    for (int i = 0; i < element.getProgramEligibility().size(); i++) {
      composeCodeableConcept(t, "Immunization", "programEligibility", element.getProgramEligibility().get(i), i);
    }
    if (element.hasFundingSource()) {
      composeCodeableConcept(t, "Immunization", "fundingSource", element.getFundingSource(), -1);
    }
    for (int i = 0; i < element.getReaction().size(); i++) {
      composeImmunizationReactionComponent(t, "Immunization", "reaction", element.getReaction().get(i), i);
    }
    for (int i = 0; i < element.getProtocolApplied().size(); i++) {
      composeImmunizationProtocolAppliedComponent(t, "Immunization", "protocolApplied", element.getProtocolApplied().get(i), i);
    }
  }

  protected void composeImmunizationPerformerComponent(Complex parent, String parentType, String name, Immunization.ImmunizationPerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "ImmunizationPerformerComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "ImmunizationPerformerComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeImmunizationEducationComponent(Complex parent, String parentType, String name, Immunization.ImmunizationEducationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "education", name, element, index);
    if (element.hasDocumentTypeElement()) {
      composeString(t, "ImmunizationEducationComponent", "documentType", element.getDocumentTypeElement(), -1);
    }
    if (element.hasReferenceElement()) {
      composeUri(t, "ImmunizationEducationComponent", "reference", element.getReferenceElement(), -1);
    }
    if (element.hasPublicationDateElement()) {
      composeDateTime(t, "ImmunizationEducationComponent", "publicationDate", element.getPublicationDateElement(), -1);
    }
    if (element.hasPresentationDateElement()) {
      composeDateTime(t, "ImmunizationEducationComponent", "presentationDate", element.getPresentationDateElement(), -1);
    }
  }

  protected void composeImmunizationReactionComponent(Complex parent, String parentType, String name, Immunization.ImmunizationReactionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "reaction", name, element, index);
    if (element.hasDateElement()) {
      composeDateTime(t, "ImmunizationReactionComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasDetail()) {
      composeReference(t, "ImmunizationReactionComponent", "detail", element.getDetail(), -1);
    }
    if (element.hasReportedElement()) {
      composeBoolean(t, "ImmunizationReactionComponent", "reported", element.getReportedElement(), -1);
    }
  }

  protected void composeImmunizationProtocolAppliedComponent(Complex parent, String parentType, String name, Immunization.ImmunizationProtocolAppliedComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "protocolApplied", name, element, index);
    if (element.hasSeriesElement()) {
      composeString(t, "ImmunizationProtocolAppliedComponent", "series", element.getSeriesElement(), -1);
    }
    if (element.hasAuthority()) {
      composeReference(t, "ImmunizationProtocolAppliedComponent", "authority", element.getAuthority(), -1);
    }
    for (int i = 0; i < element.getTargetDisease().size(); i++) {
      composeCodeableConcept(t, "ImmunizationProtocolAppliedComponent", "targetDisease", element.getTargetDisease().get(i), i);
    }
    if (element.hasDoseNumber()) {
      composeType(t, "ImmunizationProtocolAppliedComponent", "doseNumber", element.getDoseNumber(), -1);
    }
    if (element.hasSeriesDoses()) {
      composeType(t, "ImmunizationProtocolAppliedComponent", "seriesDoses", element.getSeriesDoses(), -1);
    }
  }

  protected void composeImmunizationEvaluation(Complex parent, String parentType, String name, ImmunizationEvaluation element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ImmunizationEvaluation", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ImmunizationEvaluation", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ImmunizationEvaluation", "status", element.getStatusElement(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "ImmunizationEvaluation", "patient", element.getPatient(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ImmunizationEvaluation", "date", element.getDateElement(), -1);
    }
    if (element.hasAuthority()) {
      composeReference(t, "ImmunizationEvaluation", "authority", element.getAuthority(), -1);
    }
    if (element.hasTargetDisease()) {
      composeCodeableConcept(t, "ImmunizationEvaluation", "targetDisease", element.getTargetDisease(), -1);
    }
    if (element.hasImmunizationEvent()) {
      composeReference(t, "ImmunizationEvaluation", "immunizationEvent", element.getImmunizationEvent(), -1);
    }
    if (element.hasDoseStatus()) {
      composeCodeableConcept(t, "ImmunizationEvaluation", "doseStatus", element.getDoseStatus(), -1);
    }
    for (int i = 0; i < element.getDoseStatusReason().size(); i++) {
      composeCodeableConcept(t, "ImmunizationEvaluation", "doseStatusReason", element.getDoseStatusReason().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ImmunizationEvaluation", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasSeriesElement()) {
      composeString(t, "ImmunizationEvaluation", "series", element.getSeriesElement(), -1);
    }
    if (element.hasDoseNumber()) {
      composeType(t, "ImmunizationEvaluation", "doseNumber", element.getDoseNumber(), -1);
    }
    if (element.hasSeriesDoses()) {
      composeType(t, "ImmunizationEvaluation", "seriesDoses", element.getSeriesDoses(), -1);
    }
  }

  protected void composeImmunizationRecommendation(Complex parent, String parentType, String name, ImmunizationRecommendation element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ImmunizationRecommendation", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ImmunizationRecommendation", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasPatient()) {
      composeReference(t, "ImmunizationRecommendation", "patient", element.getPatient(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ImmunizationRecommendation", "date", element.getDateElement(), -1);
    }
    if (element.hasAuthority()) {
      composeReference(t, "ImmunizationRecommendation", "authority", element.getAuthority(), -1);
    }
    for (int i = 0; i < element.getRecommendation().size(); i++) {
      composeImmunizationRecommendationRecommendationComponent(t, "ImmunizationRecommendation", "recommendation", element.getRecommendation().get(i), i);
    }
  }

  protected void composeImmunizationRecommendationRecommendationComponent(Complex parent, String parentType, String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "recommendation", name, element, index);
    for (int i = 0; i < element.getVaccineCode().size(); i++) {
      composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "vaccineCode", element.getVaccineCode().get(i), i);
    }
    if (element.hasTargetDisease()) {
      composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "targetDisease", element.getTargetDisease(), -1);
    }
    for (int i = 0; i < element.getContraindicatedVaccineCode().size(); i++) {
      composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "contraindicatedVaccineCode", element.getContraindicatedVaccineCode().get(i), i);
    }
    if (element.hasForecastStatus()) {
      composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "forecastStatus", element.getForecastStatus(), -1);
    }
    for (int i = 0; i < element.getForecastReason().size(); i++) {
      composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "forecastReason", element.getForecastReason().get(i), i);
    }
    for (int i = 0; i < element.getDateCriterion().size(); i++) {
      composeImmunizationRecommendationRecommendationDateCriterionComponent(t, "ImmunizationRecommendationRecommendationComponent", "dateCriterion", element.getDateCriterion().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ImmunizationRecommendationRecommendationComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasSeriesElement()) {
      composeString(t, "ImmunizationRecommendationRecommendationComponent", "series", element.getSeriesElement(), -1);
    }
    if (element.hasDoseNumber()) {
      composeType(t, "ImmunizationRecommendationRecommendationComponent", "doseNumber", element.getDoseNumber(), -1);
    }
    if (element.hasSeriesDoses()) {
      composeType(t, "ImmunizationRecommendationRecommendationComponent", "seriesDoses", element.getSeriesDoses(), -1);
    }
    for (int i = 0; i < element.getSupportingImmunization().size(); i++) {
      composeReference(t, "ImmunizationRecommendationRecommendationComponent", "supportingImmunization", element.getSupportingImmunization().get(i), i);
    }
    for (int i = 0; i < element.getSupportingPatientInformation().size(); i++) {
      composeReference(t, "ImmunizationRecommendationRecommendationComponent", "supportingPatientInformation", element.getSupportingPatientInformation().get(i), i);
    }
  }

  protected void composeImmunizationRecommendationRecommendationDateCriterionComponent(Complex parent, String parentType, String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dateCriterion", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "ImmunizationRecommendationRecommendationDateCriterionComponent", "code", element.getCode(), -1);
    }
    if (element.hasValueElement()) {
      composeDateTime(t, "ImmunizationRecommendationRecommendationDateCriterionComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeImplementationGuide(Complex parent, String parentType, String name, ImplementationGuide element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ImplementationGuide", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ImplementationGuide", "url", element.getUrlElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ImplementationGuide", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ImplementationGuide", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ImplementationGuide", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "ImplementationGuide", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ImplementationGuide", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "ImplementationGuide", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ImplementationGuide", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ImplementationGuide", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "ImplementationGuide", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "ImplementationGuide", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ImplementationGuide", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasPackageIdElement()) {
      composeId(t, "ImplementationGuide", "packageId", element.getPackageIdElement(), -1);
    }
    if (element.hasLicenseElement()) {
      composeEnum(t, "ImplementationGuide", "license", element.getLicenseElement(), -1);
    }
    for (int i = 0; i < element.getFhirVersion().size(); i++) {
      composeEnum(t, "ImplementationGuide", "fhirVersion", element.getFhirVersion().get(i), i);
    }
    for (int i = 0; i < element.getDependsOn().size(); i++) {
      composeImplementationGuideDependsOnComponent(t, "ImplementationGuide", "dependsOn", element.getDependsOn().get(i), i);
    }
    for (int i = 0; i < element.getGlobal().size(); i++) {
      composeImplementationGuideGlobalComponent(t, "ImplementationGuide", "global", element.getGlobal().get(i), i);
    }
    if (element.hasDefinition()) {
      composeImplementationGuideDefinitionComponent(t, "ImplementationGuide", "definition", element.getDefinition(), -1);
    }
    if (element.hasManifest()) {
      composeImplementationGuideManifestComponent(t, "ImplementationGuide", "manifest", element.getManifest(), -1);
    }
  }

  protected void composeImplementationGuideDependsOnComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDependsOnComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dependsOn", name, element, index);
    if (element.hasUriElement()) {
      composeCanonical(t, "ImplementationGuideDependsOnComponent", "uri", element.getUriElement(), -1);
    }
    if (element.hasPackageIdElement()) {
      composeId(t, "ImplementationGuideDependsOnComponent", "packageId", element.getPackageIdElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ImplementationGuideDependsOnComponent", "version", element.getVersionElement(), -1);
    }
  }

  protected void composeImplementationGuideGlobalComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideGlobalComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "global", name, element, index);
    if (element.hasTypeElement()) {
      composeCode(t, "ImplementationGuideGlobalComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasProfileElement()) {
      composeCanonical(t, "ImplementationGuideGlobalComponent", "profile", element.getProfileElement(), -1);
    }
  }

  protected void composeImplementationGuideDefinitionComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "definition", name, element, index);
    for (int i = 0; i < element.getGrouping().size(); i++) {
      composeImplementationGuideDefinitionGroupingComponent(t, "ImplementationGuideDefinitionComponent", "grouping", element.getGrouping().get(i), i);
    }
    for (int i = 0; i < element.getResource().size(); i++) {
      composeImplementationGuideDefinitionResourceComponent(t, "ImplementationGuideDefinitionComponent", "resource", element.getResource().get(i), i);
    }
    if (element.hasPage()) {
      composeImplementationGuideDefinitionPageComponent(t, "ImplementationGuideDefinitionComponent", "page", element.getPage(), -1);
    }
    for (int i = 0; i < element.getParameter().size(); i++) {
      composeImplementationGuideDefinitionParameterComponent(t, "ImplementationGuideDefinitionComponent", "parameter", element.getParameter().get(i), i);
    }
    for (int i = 0; i < element.getTemplate().size(); i++) {
      composeImplementationGuideDefinitionTemplateComponent(t, "ImplementationGuideDefinitionComponent", "template", element.getTemplate().get(i), i);
    }
  }

  protected void composeImplementationGuideDefinitionGroupingComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionGroupingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "grouping", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "ImplementationGuideDefinitionGroupingComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ImplementationGuideDefinitionGroupingComponent", "description", element.getDescriptionElement(), -1);
    }
  }

  protected void composeImplementationGuideDefinitionResourceComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionResourceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "resource", name, element, index);
    if (element.hasReference()) {
      composeReference(t, "ImplementationGuideDefinitionResourceComponent", "reference", element.getReference(), -1);
    }
    for (int i = 0; i < element.getFhirVersion().size(); i++) {
      composeEnum(t, "ImplementationGuideDefinitionResourceComponent", "fhirVersion", element.getFhirVersion().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "ImplementationGuideDefinitionResourceComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ImplementationGuideDefinitionResourceComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasExample()) {
      composeType(t, "ImplementationGuideDefinitionResourceComponent", "example", element.getExample(), -1);
    }
    if (element.hasGroupingIdElement()) {
      composeId(t, "ImplementationGuideDefinitionResourceComponent", "groupingId", element.getGroupingIdElement(), -1);
    }
  }

  protected void composeImplementationGuideDefinitionPageComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionPageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "page", name, element, index);
    if (element.hasName()) {
      composeType(t, "ImplementationGuideDefinitionPageComponent", "name", element.getName(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ImplementationGuideDefinitionPageComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasGenerationElement()) {
      composeEnum(t, "ImplementationGuideDefinitionPageComponent", "generation", element.getGenerationElement(), -1);
    }
    for (int i = 0; i < element.getPage().size(); i++) {
      composeImplementationGuideDefinitionPageComponent(t, "ImplementationGuideDefinitionPageComponent", "page", element.getPage().get(i), i);
    }
  }

  protected void composeImplementationGuideDefinitionParameterComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionParameterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "parameter", name, element, index);
    if (element.hasCodeElement()) {
      composeEnum(t, "ImplementationGuideDefinitionParameterComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "ImplementationGuideDefinitionParameterComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeImplementationGuideDefinitionTemplateComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionTemplateComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "template", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "ImplementationGuideDefinitionTemplateComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasSourceElement()) {
      composeString(t, "ImplementationGuideDefinitionTemplateComponent", "source", element.getSourceElement(), -1);
    }
    if (element.hasScopeElement()) {
      composeString(t, "ImplementationGuideDefinitionTemplateComponent", "scope", element.getScopeElement(), -1);
    }
  }

  protected void composeImplementationGuideManifestComponent(Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideManifestComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "manifest", name, element, index);
    if (element.hasRenderingElement()) {
      composeUrl(t, "ImplementationGuideManifestComponent", "rendering", element.getRenderingElement(), -1);
    }
    for (int i = 0; i < element.getResource().size(); i++) {
      composeImplementationGuideManifestResourceComponent(t, "ImplementationGuideManifestComponent", "resource", element.getResource().get(i), i);
    }
    for (int i = 0; i < element.getPage().size(); i++) {
      composeImplementationGuideManifestPageComponent(t, "ImplementationGuideManifestComponent", "page", element.getPage().get(i), i);
    }
    for (int i = 0; i < element.getImage().size(); i++) {
      composeString(t, "ImplementationGuideManifestComponent", "image", element.getImage().get(i), i);
    }
    for (int i = 0; i < element.getOther().size(); i++) {
      composeString(t, "ImplementationGuideManifestComponent", "other", element.getOther().get(i), i);
    }
  }

  protected void composeImplementationGuideManifestResourceComponent(Complex parent, String parentType, String name, ImplementationGuide.ManifestResourceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "resource", name, element, index);
    if (element.hasReference()) {
      composeReference(t, "ManifestResourceComponent", "reference", element.getReference(), -1);
    }
    if (element.hasExample()) {
      composeType(t, "ManifestResourceComponent", "example", element.getExample(), -1);
    }
    if (element.hasRelativePathElement()) {
      composeUrl(t, "ManifestResourceComponent", "relativePath", element.getRelativePathElement(), -1);
    }
  }

  protected void composeImplementationGuideManifestPageComponent(Complex parent, String parentType, String name, ImplementationGuide.ManifestPageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "page", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "ManifestPageComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ManifestPageComponent", "title", element.getTitleElement(), -1);
    }
    for (int i = 0; i < element.getAnchor().size(); i++) {
      composeString(t, "ManifestPageComponent", "anchor", element.getAnchor().get(i), i);
    }
  }

  protected void composeIngredient(Complex parent, String parentType, String name, Ingredient element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Ingredient", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "Ingredient", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Ingredient", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getFor().size(); i++) {
      composeReference(t, "Ingredient", "for", element.getFor().get(i), i);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "Ingredient", "role", element.getRole(), -1);
    }
    for (int i = 0; i < element.getFunction().size(); i++) {
      composeCodeableConcept(t, "Ingredient", "function", element.getFunction().get(i), i);
    }
    if (element.hasAllergenicIndicatorElement()) {
      composeBoolean(t, "Ingredient", "allergenicIndicator", element.getAllergenicIndicatorElement(), -1);
    }
    for (int i = 0; i < element.getManufacturer().size(); i++) {
      composeIngredientManufacturerComponent(t, "Ingredient", "manufacturer", element.getManufacturer().get(i), i);
    }
    if (element.hasSubstance()) {
      composeIngredientSubstanceComponent(t, "Ingredient", "substance", element.getSubstance(), -1);
    }
  }

  protected void composeIngredientManufacturerComponent(Complex parent, String parentType, String name, Ingredient.IngredientManufacturerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "manufacturer", name, element, index);
    if (element.hasRole()) {
      composeCoding(t, "IngredientManufacturerComponent", "role", element.getRole(), -1);
    }
    if (element.hasManufacturer()) {
      composeReference(t, "IngredientManufacturerComponent", "manufacturer", element.getManufacturer(), -1);
    }
  }

  protected void composeIngredientSubstanceComponent(Complex parent, String parentType, String name, Ingredient.IngredientSubstanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "substance", name, element, index);
    if (element.hasCode()) {
      composeCodeableReference(t, "IngredientSubstanceComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getStrength().size(); i++) {
      composeIngredientSubstanceStrengthComponent(t, "IngredientSubstanceComponent", "strength", element.getStrength().get(i), i);
    }
  }

  protected void composeIngredientSubstanceStrengthComponent(Complex parent, String parentType, String name, Ingredient.IngredientSubstanceStrengthComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "strength", name, element, index);
    if (element.hasPresentation()) {
      composeType(t, "IngredientSubstanceStrengthComponent", "presentation", element.getPresentation(), -1);
    }
    if (element.hasPresentationTextElement()) {
      composeString(t, "IngredientSubstanceStrengthComponent", "presentationText", element.getPresentationTextElement(), -1);
    }
    if (element.hasConcentration()) {
      composeType(t, "IngredientSubstanceStrengthComponent", "concentration", element.getConcentration(), -1);
    }
    if (element.hasConcentrationTextElement()) {
      composeString(t, "IngredientSubstanceStrengthComponent", "concentrationText", element.getConcentrationTextElement(), -1);
    }
    if (element.hasMeasurementPointElement()) {
      composeString(t, "IngredientSubstanceStrengthComponent", "measurementPoint", element.getMeasurementPointElement(), -1);
    }
    for (int i = 0; i < element.getCountry().size(); i++) {
      composeCodeableConcept(t, "IngredientSubstanceStrengthComponent", "country", element.getCountry().get(i), i);
    }
    for (int i = 0; i < element.getReferenceStrength().size(); i++) {
      composeIngredientSubstanceStrengthReferenceStrengthComponent(t, "IngredientSubstanceStrengthComponent", "referenceStrength", element.getReferenceStrength().get(i), i);
    }
  }

  protected void composeIngredientSubstanceStrengthReferenceStrengthComponent(Complex parent, String parentType, String name, Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "referenceStrength", name, element, index);
    if (element.hasSubstance()) {
      composeCodeableReference(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "substance", element.getSubstance(), -1);
    }
    if (element.hasStrength()) {
      composeType(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "strength", element.getStrength(), -1);
    }
    if (element.hasMeasurementPointElement()) {
      composeString(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "measurementPoint", element.getMeasurementPointElement(), -1);
    }
    for (int i = 0; i < element.getCountry().size(); i++) {
      composeCodeableConcept(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "country", element.getCountry().get(i), i);
    }
  }

  protected void composeInsurancePlan(Complex parent, String parentType, String name, InsurancePlan element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "InsurancePlan", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "InsurancePlan", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "InsurancePlan", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "InsurancePlan", "type", element.getType().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "InsurancePlan", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getAlias().size(); i++) {
      composeString(t, "InsurancePlan", "alias", element.getAlias().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "InsurancePlan", "period", element.getPeriod(), -1);
    }
    if (element.hasOwnedBy()) {
      composeReference(t, "InsurancePlan", "ownedBy", element.getOwnedBy(), -1);
    }
    if (element.hasAdministeredBy()) {
      composeReference(t, "InsurancePlan", "administeredBy", element.getAdministeredBy(), -1);
    }
    for (int i = 0; i < element.getCoverageArea().size(); i++) {
      composeReference(t, "InsurancePlan", "coverageArea", element.getCoverageArea().get(i), i);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeInsurancePlanContactComponent(t, "InsurancePlan", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "InsurancePlan", "endpoint", element.getEndpoint().get(i), i);
    }
    for (int i = 0; i < element.getNetwork().size(); i++) {
      composeReference(t, "InsurancePlan", "network", element.getNetwork().get(i), i);
    }
    for (int i = 0; i < element.getCoverage().size(); i++) {
      composeInsurancePlanCoverageComponent(t, "InsurancePlan", "coverage", element.getCoverage().get(i), i);
    }
    for (int i = 0; i < element.getPlan().size(); i++) {
      composeInsurancePlanPlanComponent(t, "InsurancePlan", "plan", element.getPlan().get(i), i);
    }
  }

  protected void composeInsurancePlanContactComponent(Complex parent, String parentType, String name, InsurancePlan.InsurancePlanContactComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "contact", name, element, index);
    if (element.hasPurpose()) {
      composeCodeableConcept(t, "InsurancePlanContactComponent", "purpose", element.getPurpose(), -1);
    }
    if (element.hasName()) {
      composeHumanName(t, "InsurancePlanContactComponent", "name", element.getName(), -1);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "InsurancePlanContactComponent", "telecom", element.getTelecom().get(i), i);
    }
    if (element.hasAddress()) {
      composeAddress(t, "InsurancePlanContactComponent", "address", element.getAddress(), -1);
    }
  }

  protected void composeInsurancePlanCoverageComponent(Complex parent, String parentType, String name, InsurancePlan.InsurancePlanCoverageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "coverage", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "InsurancePlanCoverageComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getNetwork().size(); i++) {
      composeReference(t, "InsurancePlanCoverageComponent", "network", element.getNetwork().get(i), i);
    }
    for (int i = 0; i < element.getBenefit().size(); i++) {
      composeInsurancePlanCoverageBenefitComponent(t, "InsurancePlanCoverageComponent", "benefit", element.getBenefit().get(i), i);
    }
  }

  protected void composeInsurancePlanCoverageBenefitComponent(Complex parent, String parentType, String name, InsurancePlan.CoverageBenefitComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "benefit", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "CoverageBenefitComponent", "type", element.getType(), -1);
    }
    if (element.hasRequirementElement()) {
      composeString(t, "CoverageBenefitComponent", "requirement", element.getRequirementElement(), -1);
    }
    for (int i = 0; i < element.getLimit().size(); i++) {
      composeInsurancePlanCoverageBenefitLimitComponent(t, "CoverageBenefitComponent", "limit", element.getLimit().get(i), i);
    }
  }

  protected void composeInsurancePlanCoverageBenefitLimitComponent(Complex parent, String parentType, String name, InsurancePlan.CoverageBenefitLimitComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "limit", name, element, index);
    if (element.hasValue()) {
      composeQuantity(t, "CoverageBenefitLimitComponent", "value", element.getValue(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "CoverageBenefitLimitComponent", "code", element.getCode(), -1);
    }
  }

  protected void composeInsurancePlanPlanComponent(Complex parent, String parentType, String name, InsurancePlan.InsurancePlanPlanComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "plan", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "InsurancePlanPlanComponent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "InsurancePlanPlanComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getCoverageArea().size(); i++) {
      composeReference(t, "InsurancePlanPlanComponent", "coverageArea", element.getCoverageArea().get(i), i);
    }
    for (int i = 0; i < element.getNetwork().size(); i++) {
      composeReference(t, "InsurancePlanPlanComponent", "network", element.getNetwork().get(i), i);
    }
    for (int i = 0; i < element.getGeneralCost().size(); i++) {
      composeInsurancePlanPlanGeneralCostComponent(t, "InsurancePlanPlanComponent", "generalCost", element.getGeneralCost().get(i), i);
    }
    for (int i = 0; i < element.getSpecificCost().size(); i++) {
      composeInsurancePlanPlanSpecificCostComponent(t, "InsurancePlanPlanComponent", "specificCost", element.getSpecificCost().get(i), i);
    }
  }

  protected void composeInsurancePlanPlanGeneralCostComponent(Complex parent, String parentType, String name, InsurancePlan.InsurancePlanPlanGeneralCostComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "generalCost", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "InsurancePlanPlanGeneralCostComponent", "type", element.getType(), -1);
    }
    if (element.hasGroupSizeElement()) {
      composePositiveInt(t, "InsurancePlanPlanGeneralCostComponent", "groupSize", element.getGroupSizeElement(), -1);
    }
    if (element.hasCost()) {
      composeMoney(t, "InsurancePlanPlanGeneralCostComponent", "cost", element.getCost(), -1);
    }
    if (element.hasCommentElement()) {
      composeString(t, "InsurancePlanPlanGeneralCostComponent", "comment", element.getCommentElement(), -1);
    }
  }

  protected void composeInsurancePlanPlanSpecificCostComponent(Complex parent, String parentType, String name, InsurancePlan.InsurancePlanPlanSpecificCostComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "specificCost", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "InsurancePlanPlanSpecificCostComponent", "category", element.getCategory(), -1);
    }
    for (int i = 0; i < element.getBenefit().size(); i++) {
      composeInsurancePlanPlanBenefitComponent(t, "InsurancePlanPlanSpecificCostComponent", "benefit", element.getBenefit().get(i), i);
    }
  }

  protected void composeInsurancePlanPlanBenefitComponent(Complex parent, String parentType, String name, InsurancePlan.PlanBenefitComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "benefit", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "PlanBenefitComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getCost().size(); i++) {
      composeInsurancePlanPlanBenefitCostComponent(t, "PlanBenefitComponent", "cost", element.getCost().get(i), i);
    }
  }

  protected void composeInsurancePlanPlanBenefitCostComponent(Complex parent, String parentType, String name, InsurancePlan.PlanBenefitCostComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "cost", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "PlanBenefitCostComponent", "type", element.getType(), -1);
    }
    if (element.hasApplicability()) {
      composeCodeableConcept(t, "PlanBenefitCostComponent", "applicability", element.getApplicability(), -1);
    }
    for (int i = 0; i < element.getQualifiers().size(); i++) {
      composeCodeableConcept(t, "PlanBenefitCostComponent", "qualifiers", element.getQualifiers().get(i), i);
    }
    if (element.hasValue()) {
      composeQuantity(t, "PlanBenefitCostComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeInvoice(Complex parent, String parentType, String name, Invoice element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Invoice", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Invoice", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Invoice", "status", element.getStatusElement(), -1);
    }
    if (element.hasCancelledReasonElement()) {
      composeString(t, "Invoice", "cancelledReason", element.getCancelledReasonElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Invoice", "type", element.getType(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "Invoice", "subject", element.getSubject(), -1);
    }
    if (element.hasRecipient()) {
      composeReference(t, "Invoice", "recipient", element.getRecipient(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "Invoice", "date", element.getDateElement(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeInvoiceParticipantComponent(t, "Invoice", "participant", element.getParticipant().get(i), i);
    }
    if (element.hasIssuer()) {
      composeReference(t, "Invoice", "issuer", element.getIssuer(), -1);
    }
    if (element.hasAccount()) {
      composeReference(t, "Invoice", "account", element.getAccount(), -1);
    }
    for (int i = 0; i < element.getLineItem().size(); i++) {
      composeInvoiceLineItemComponent(t, "Invoice", "lineItem", element.getLineItem().get(i), i);
    }
    for (int i = 0; i < element.getTotalPriceComponent().size(); i++) {
      composeInvoiceLineItemPriceComponentComponent(t, "Invoice", "totalPriceComponent", element.getTotalPriceComponent().get(i), i);
    }
    if (element.hasTotalNet()) {
      composeMoney(t, "Invoice", "totalNet", element.getTotalNet(), -1);
    }
    if (element.hasTotalGross()) {
      composeMoney(t, "Invoice", "totalGross", element.getTotalGross(), -1);
    }
    if (element.hasPaymentTermsElement()) {
      composeMarkdown(t, "Invoice", "paymentTerms", element.getPaymentTermsElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Invoice", "note", element.getNote().get(i), i);
    }
  }

  protected void composeInvoiceParticipantComponent(Complex parent, String parentType, String name, Invoice.InvoiceParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    if (element.hasRole()) {
      composeCodeableConcept(t, "InvoiceParticipantComponent", "role", element.getRole(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "InvoiceParticipantComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeInvoiceLineItemComponent(Complex parent, String parentType, String name, Invoice.InvoiceLineItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "lineItem", name, element, index);
    if (element.hasSequenceElement()) {
      composePositiveInt(t, "InvoiceLineItemComponent", "sequence", element.getSequenceElement(), -1);
    }
    if (element.hasChargeItem()) {
      composeType(t, "InvoiceLineItemComponent", "chargeItem", element.getChargeItem(), -1);
    }
    for (int i = 0; i < element.getPriceComponent().size(); i++) {
      composeInvoiceLineItemPriceComponentComponent(t, "InvoiceLineItemComponent", "priceComponent", element.getPriceComponent().get(i), i);
    }
  }

  protected void composeInvoiceLineItemPriceComponentComponent(Complex parent, String parentType, String name, Invoice.InvoiceLineItemPriceComponentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "priceComponent", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "InvoiceLineItemPriceComponentComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "InvoiceLineItemPriceComponentComponent", "code", element.getCode(), -1);
    }
    if (element.hasFactorElement()) {
      composeDecimal(t, "InvoiceLineItemPriceComponentComponent", "factor", element.getFactorElement(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "InvoiceLineItemPriceComponentComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composeLibrary(Complex parent, String parentType, String name, Library element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Library", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "Library", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Library", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Library", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Library", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Library", "title", element.getTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "Library", "subtitle", element.getSubtitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Library", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "Library", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Library", "type", element.getType(), -1);
    }
    if (element.hasSubject()) {
      composeType(t, "Library", "subject", element.getSubject(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "Library", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "Library", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "Library", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "Library", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "Library", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "Library", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "Library", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasUsageElement()) {
      composeString(t, "Library", "usage", element.getUsageElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "Library", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "Library", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "Library", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "Library", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "Library", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "Library", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "Library", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "Library", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "Library", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "Library", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    for (int i = 0; i < element.getParameter().size(); i++) {
      composeParameterDefinition(t, "Library", "parameter", element.getParameter().get(i), i);
    }
    for (int i = 0; i < element.getDataRequirement().size(); i++) {
      composeDataRequirement(t, "Library", "dataRequirement", element.getDataRequirement().get(i), i);
    }
    for (int i = 0; i < element.getContent().size(); i++) {
      composeAttachment(t, "Library", "content", element.getContent().get(i), i);
    }
  }

  protected void composeLinkage(Complex parent, String parentType, String name, Linkage element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Linkage", name, element, index);
    if (element.hasActiveElement()) {
      composeBoolean(t, "Linkage", "active", element.getActiveElement(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "Linkage", "author", element.getAuthor(), -1);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeLinkageItemComponent(t, "Linkage", "item", element.getItem().get(i), i);
    }
  }

  protected void composeLinkageItemComponent(Complex parent, String parentType, String name, Linkage.LinkageItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "LinkageItemComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasResource()) {
      composeReference(t, "LinkageItemComponent", "resource", element.getResource(), -1);
    }
  }

  protected void composeListResource(Complex parent, String parentType, String name, ListResource element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "List", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ListResource", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ListResource", "status", element.getStatusElement(), -1);
    }
    if (element.hasModeElement()) {
      composeEnum(t, "ListResource", "mode", element.getModeElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ListResource", "title", element.getTitleElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ListResource", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "ListResource", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "ListResource", "encounter", element.getEncounter(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ListResource", "date", element.getDateElement(), -1);
    }
    if (element.hasSource()) {
      composeReference(t, "ListResource", "source", element.getSource(), -1);
    }
    if (element.hasOrderedBy()) {
      composeCodeableConcept(t, "ListResource", "orderedBy", element.getOrderedBy(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "ListResource", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getEntry().size(); i++) {
      composeListResourceEntryComponent(t, "ListResource", "entry", element.getEntry().get(i), i);
    }
    if (element.hasEmptyReason()) {
      composeCodeableConcept(t, "ListResource", "emptyReason", element.getEmptyReason(), -1);
    }
  }

  protected void composeListResourceEntryComponent(Complex parent, String parentType, String name, ListResource.ListResourceEntryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "entry", name, element, index);
    if (element.hasFlag()) {
      composeCodeableConcept(t, "ListResourceEntryComponent", "flag", element.getFlag(), -1);
    }
    if (element.hasDeletedElement()) {
      composeBoolean(t, "ListResourceEntryComponent", "deleted", element.getDeletedElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ListResourceEntryComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasItem()) {
      composeReference(t, "ListResourceEntryComponent", "item", element.getItem(), -1);
    }
  }

  protected void composeLocation(Complex parent, String parentType, String name, Location element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Location", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Location", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Location", "status", element.getStatusElement(), -1);
    }
    if (element.hasOperationalStatus()) {
      composeCoding(t, "Location", "operationalStatus", element.getOperationalStatus(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Location", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getAlias().size(); i++) {
      composeString(t, "Location", "alias", element.getAlias().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "Location", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasModeElement()) {
      composeEnum(t, "Location", "mode", element.getModeElement(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "Location", "type", element.getType().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "Location", "telecom", element.getTelecom().get(i), i);
    }
    if (element.hasAddress()) {
      composeAddress(t, "Location", "address", element.getAddress(), -1);
    }
    if (element.hasPhysicalType()) {
      composeCodeableConcept(t, "Location", "physicalType", element.getPhysicalType(), -1);
    }
    if (element.hasPosition()) {
      composeLocationPositionComponent(t, "Location", "position", element.getPosition(), -1);
    }
    if (element.hasManagingOrganization()) {
      composeReference(t, "Location", "managingOrganization", element.getManagingOrganization(), -1);
    }
    if (element.hasPartOf()) {
      composeReference(t, "Location", "partOf", element.getPartOf(), -1);
    }
    for (int i = 0; i < element.getHoursOfOperation().size(); i++) {
      composeLocationHoursOfOperationComponent(t, "Location", "hoursOfOperation", element.getHoursOfOperation().get(i), i);
    }
    if (element.hasAvailabilityExceptionsElement()) {
      composeString(t, "Location", "availabilityExceptions", element.getAvailabilityExceptionsElement(), -1);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "Location", "endpoint", element.getEndpoint().get(i), i);
    }
  }

  protected void composeLocationPositionComponent(Complex parent, String parentType, String name, Location.LocationPositionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "position", name, element, index);
    if (element.hasLongitudeElement()) {
      composeDecimal(t, "LocationPositionComponent", "longitude", element.getLongitudeElement(), -1);
    }
    if (element.hasLatitudeElement()) {
      composeDecimal(t, "LocationPositionComponent", "latitude", element.getLatitudeElement(), -1);
    }
    if (element.hasAltitudeElement()) {
      composeDecimal(t, "LocationPositionComponent", "altitude", element.getAltitudeElement(), -1);
    }
  }

  protected void composeLocationHoursOfOperationComponent(Complex parent, String parentType, String name, Location.LocationHoursOfOperationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "hoursOfOperation", name, element, index);
    for (int i = 0; i < element.getDaysOfWeek().size(); i++) {
      composeEnum(t, "LocationHoursOfOperationComponent", "daysOfWeek", element.getDaysOfWeek().get(i), i);
    }
    if (element.hasAllDayElement()) {
      composeBoolean(t, "LocationHoursOfOperationComponent", "allDay", element.getAllDayElement(), -1);
    }
    if (element.hasOpeningTimeElement()) {
      composeTime(t, "LocationHoursOfOperationComponent", "openingTime", element.getOpeningTimeElement(), -1);
    }
    if (element.hasClosingTimeElement()) {
      composeTime(t, "LocationHoursOfOperationComponent", "closingTime", element.getClosingTimeElement(), -1);
    }
  }

  protected void composeManufacturedItemDefinition(Complex parent, String parentType, String name, ManufacturedItemDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ManufacturedItemDefinition", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ManufacturedItemDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ManufacturedItemDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasManufacturedDoseForm()) {
      composeCodeableConcept(t, "ManufacturedItemDefinition", "manufacturedDoseForm", element.getManufacturedDoseForm(), -1);
    }
    if (element.hasUnitOfPresentation()) {
      composeCodeableConcept(t, "ManufacturedItemDefinition", "unitOfPresentation", element.getUnitOfPresentation(), -1);
    }
    for (int i = 0; i < element.getManufacturer().size(); i++) {
      composeReference(t, "ManufacturedItemDefinition", "manufacturer", element.getManufacturer().get(i), i);
    }
    for (int i = 0; i < element.getIngredient().size(); i++) {
      composeCodeableConcept(t, "ManufacturedItemDefinition", "ingredient", element.getIngredient().get(i), i);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeManufacturedItemDefinitionPropertyComponent(t, "ManufacturedItemDefinition", "property", element.getProperty().get(i), i);
    }
  }

  protected void composeManufacturedItemDefinitionPropertyComponent(Complex parent, String parentType, String name, ManufacturedItemDefinition.ManufacturedItemDefinitionPropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ManufacturedItemDefinitionPropertyComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "ManufacturedItemDefinitionPropertyComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeMeasure(Complex parent, String parentType, String name, Measure element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Measure", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "Measure", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Measure", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Measure", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Measure", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Measure", "title", element.getTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "Measure", "subtitle", element.getSubtitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Measure", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "Measure", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasSubject()) {
      composeType(t, "Measure", "subject", element.getSubject(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "Measure", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "Measure", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "Measure", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "Measure", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "Measure", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "Measure", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "Measure", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasUsageElement()) {
      composeString(t, "Measure", "usage", element.getUsageElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "Measure", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "Measure", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "Measure", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "Measure", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "Measure", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "Measure", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "Measure", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "Measure", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "Measure", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "Measure", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    for (int i = 0; i < element.getLibrary().size(); i++) {
      composeCanonical(t, "Measure", "library", element.getLibrary().get(i), i);
    }
    if (element.hasDisclaimerElement()) {
      composeMarkdown(t, "Measure", "disclaimer", element.getDisclaimerElement(), -1);
    }
    if (element.hasScoring()) {
      composeCodeableConcept(t, "Measure", "scoring", element.getScoring(), -1);
    }
    if (element.hasCompositeScoring()) {
      composeCodeableConcept(t, "Measure", "compositeScoring", element.getCompositeScoring(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "Measure", "type", element.getType().get(i), i);
    }
    if (element.hasRiskAdjustmentElement()) {
      composeString(t, "Measure", "riskAdjustment", element.getRiskAdjustmentElement(), -1);
    }
    if (element.hasRateAggregationElement()) {
      composeString(t, "Measure", "rateAggregation", element.getRateAggregationElement(), -1);
    }
    if (element.hasRationaleElement()) {
      composeMarkdown(t, "Measure", "rationale", element.getRationaleElement(), -1);
    }
    if (element.hasClinicalRecommendationStatementElement()) {
      composeMarkdown(t, "Measure", "clinicalRecommendationStatement", element.getClinicalRecommendationStatementElement(), -1);
    }
    if (element.hasImprovementNotation()) {
      composeCodeableConcept(t, "Measure", "improvementNotation", element.getImprovementNotation(), -1);
    }
    for (int i = 0; i < element.getDefinition().size(); i++) {
      composeMarkdown(t, "Measure", "definition", element.getDefinition().get(i), i);
    }
    if (element.hasGuidanceElement()) {
      composeMarkdown(t, "Measure", "guidance", element.getGuidanceElement(), -1);
    }
    for (int i = 0; i < element.getGroup().size(); i++) {
      composeMeasureGroupComponent(t, "Measure", "group", element.getGroup().get(i), i);
    }
    for (int i = 0; i < element.getSupplementalData().size(); i++) {
      composeMeasureSupplementalDataComponent(t, "Measure", "supplementalData", element.getSupplementalData().get(i), i);
    }
  }

  protected void composeMeasureGroupComponent(Complex parent, String parentType, String name, Measure.MeasureGroupComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "group", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureGroupComponent", "code", element.getCode(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "MeasureGroupComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getPopulation().size(); i++) {
      composeMeasureGroupPopulationComponent(t, "MeasureGroupComponent", "population", element.getPopulation().get(i), i);
    }
    for (int i = 0; i < element.getStratifier().size(); i++) {
      composeMeasureGroupStratifierComponent(t, "MeasureGroupComponent", "stratifier", element.getStratifier().get(i), i);
    }
  }

  protected void composeMeasureGroupPopulationComponent(Complex parent, String parentType, String name, Measure.MeasureGroupPopulationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "population", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureGroupPopulationComponent", "code", element.getCode(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "MeasureGroupPopulationComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasCriteria()) {
      composeExpression(t, "MeasureGroupPopulationComponent", "criteria", element.getCriteria(), -1);
    }
  }

  protected void composeMeasureGroupStratifierComponent(Complex parent, String parentType, String name, Measure.MeasureGroupStratifierComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "stratifier", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureGroupStratifierComponent", "code", element.getCode(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "MeasureGroupStratifierComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasCriteria()) {
      composeExpression(t, "MeasureGroupStratifierComponent", "criteria", element.getCriteria(), -1);
    }
    for (int i = 0; i < element.getComponent().size(); i++) {
      composeMeasureGroupStratifierComponentComponent(t, "MeasureGroupStratifierComponent", "component", element.getComponent().get(i), i);
    }
  }

  protected void composeMeasureGroupStratifierComponentComponent(Complex parent, String parentType, String name, Measure.MeasureGroupStratifierComponentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "component", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureGroupStratifierComponentComponent", "code", element.getCode(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "MeasureGroupStratifierComponentComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasCriteria()) {
      composeExpression(t, "MeasureGroupStratifierComponentComponent", "criteria", element.getCriteria(), -1);
    }
  }

  protected void composeMeasureSupplementalDataComponent(Complex parent, String parentType, String name, Measure.MeasureSupplementalDataComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "supplementalData", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureSupplementalDataComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getUsage().size(); i++) {
      composeCodeableConcept(t, "MeasureSupplementalDataComponent", "usage", element.getUsage().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "MeasureSupplementalDataComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasCriteria()) {
      composeExpression(t, "MeasureSupplementalDataComponent", "criteria", element.getCriteria(), -1);
    }
  }

  protected void composeMeasureReport(Complex parent, String parentType, String name, MeasureReport element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MeasureReport", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MeasureReport", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "MeasureReport", "status", element.getStatusElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "MeasureReport", "type", element.getTypeElement(), -1);
    }
    if (element.hasMeasureElement()) {
      composeCanonical(t, "MeasureReport", "measure", element.getMeasureElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "MeasureReport", "subject", element.getSubject(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "MeasureReport", "date", element.getDateElement(), -1);
    }
    if (element.hasReporter()) {
      composeReference(t, "MeasureReport", "reporter", element.getReporter(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "MeasureReport", "period", element.getPeriod(), -1);
    }
    if (element.hasImprovementNotation()) {
      composeCodeableConcept(t, "MeasureReport", "improvementNotation", element.getImprovementNotation(), -1);
    }
    for (int i = 0; i < element.getGroup().size(); i++) {
      composeMeasureReportGroupComponent(t, "MeasureReport", "group", element.getGroup().get(i), i);
    }
    for (int i = 0; i < element.getEvaluatedResource().size(); i++) {
      composeReference(t, "MeasureReport", "evaluatedResource", element.getEvaluatedResource().get(i), i);
    }
  }

  protected void composeMeasureReportGroupComponent(Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "group", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureReportGroupComponent", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getPopulation().size(); i++) {
      composeMeasureReportGroupPopulationComponent(t, "MeasureReportGroupComponent", "population", element.getPopulation().get(i), i);
    }
    if (element.hasMeasureScore()) {
      composeQuantity(t, "MeasureReportGroupComponent", "measureScore", element.getMeasureScore(), -1);
    }
    for (int i = 0; i < element.getStratifier().size(); i++) {
      composeMeasureReportGroupStratifierComponent(t, "MeasureReportGroupComponent", "stratifier", element.getStratifier().get(i), i);
    }
  }

  protected void composeMeasureReportGroupPopulationComponent(Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupPopulationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "population", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MeasureReportGroupPopulationComponent", "code", element.getCode(), -1);
    }
    if (element.hasCountElement()) {
      composeInteger(t, "MeasureReportGroupPopulationComponent", "count", element.getCountElement(), -1);
    }
    if (element.hasSubjectResults()) {
      composeReference(t, "MeasureReportGroupPopulationComponent", "subjectResults", element.getSubjectResults(), -1);
    }
  }

  protected void composeMeasureReportGroupStratifierComponent(Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupStratifierComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "stratifier", name, element, index);
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "MeasureReportGroupStratifierComponent", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getStratum().size(); i++) {
      composeMeasureReportStratifierGroupComponent(t, "MeasureReportGroupStratifierComponent", "stratum", element.getStratum().get(i), i);
    }
  }

  protected void composeMeasureReportStratifierGroupComponent(Complex parent, String parentType, String name, MeasureReport.StratifierGroupComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "stratum", name, element, index);
    if (element.hasValue()) {
      composeCodeableConcept(t, "StratifierGroupComponent", "value", element.getValue(), -1);
    }
    for (int i = 0; i < element.getComponent().size(); i++) {
      composeMeasureReportStratifierGroupComponentComponent(t, "StratifierGroupComponent", "component", element.getComponent().get(i), i);
    }
    for (int i = 0; i < element.getPopulation().size(); i++) {
      composeMeasureReportStratifierGroupPopulationComponent(t, "StratifierGroupComponent", "population", element.getPopulation().get(i), i);
    }
    if (element.hasMeasureScore()) {
      composeQuantity(t, "StratifierGroupComponent", "measureScore", element.getMeasureScore(), -1);
    }
  }

  protected void composeMeasureReportStratifierGroupComponentComponent(Complex parent, String parentType, String name, MeasureReport.StratifierGroupComponentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "component", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "StratifierGroupComponentComponent", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeCodeableConcept(t, "StratifierGroupComponentComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeMeasureReportStratifierGroupPopulationComponent(Complex parent, String parentType, String name, MeasureReport.StratifierGroupPopulationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "population", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "StratifierGroupPopulationComponent", "code", element.getCode(), -1);
    }
    if (element.hasCountElement()) {
      composeInteger(t, "StratifierGroupPopulationComponent", "count", element.getCountElement(), -1);
    }
    if (element.hasSubjectResults()) {
      composeReference(t, "StratifierGroupPopulationComponent", "subjectResults", element.getSubjectResults(), -1);
    }
  }

  protected void composeMedia(Complex parent, String parentType, String name, Media element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Media", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Media", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "Media", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "Media", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Media", "status", element.getStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Media", "type", element.getType(), -1);
    }
    if (element.hasModality()) {
      composeCodeableConcept(t, "Media", "modality", element.getModality(), -1);
    }
    if (element.hasView()) {
      composeCodeableConcept(t, "Media", "view", element.getView(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "Media", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Media", "encounter", element.getEncounter(), -1);
    }
    if (element.hasCreated()) {
      composeType(t, "Media", "created", element.getCreated(), -1);
    }
    if (element.hasIssuedElement()) {
      composeInstant(t, "Media", "issued", element.getIssuedElement(), -1);
    }
    if (element.hasOperator()) {
      composeReference(t, "Media", "operator", element.getOperator(), -1);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "Media", "reasonCode", element.getReasonCode().get(i), i);
    }
    if (element.hasBodySite()) {
      composeCodeableConcept(t, "Media", "bodySite", element.getBodySite(), -1);
    }
    if (element.hasDeviceNameElement()) {
      composeString(t, "Media", "deviceName", element.getDeviceNameElement(), -1);
    }
    if (element.hasDevice()) {
      composeReference(t, "Media", "device", element.getDevice(), -1);
    }
    if (element.hasHeightElement()) {
      composePositiveInt(t, "Media", "height", element.getHeightElement(), -1);
    }
    if (element.hasWidthElement()) {
      composePositiveInt(t, "Media", "width", element.getWidthElement(), -1);
    }
    if (element.hasFramesElement()) {
      composePositiveInt(t, "Media", "frames", element.getFramesElement(), -1);
    }
    if (element.hasDurationElement()) {
      composeDecimal(t, "Media", "duration", element.getDurationElement(), -1);
    }
    if (element.hasContent()) {
      composeAttachment(t, "Media", "content", element.getContent(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Media", "note", element.getNote().get(i), i);
    }
  }

  protected void composeMedication(Complex parent, String parentType, String name, Medication element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Medication", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Medication", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Medication", "code", element.getCode(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Medication", "status", element.getStatusElement(), -1);
    }
    if (element.hasManufacturer()) {
      composeReference(t, "Medication", "manufacturer", element.getManufacturer(), -1);
    }
    if (element.hasForm()) {
      composeCodeableConcept(t, "Medication", "form", element.getForm(), -1);
    }
    if (element.hasAmount()) {
      composeRatio(t, "Medication", "amount", element.getAmount(), -1);
    }
    for (int i = 0; i < element.getIngredient().size(); i++) {
      composeMedicationIngredientComponent(t, "Medication", "ingredient", element.getIngredient().get(i), i);
    }
    if (element.hasBatch()) {
      composeMedicationBatchComponent(t, "Medication", "batch", element.getBatch(), -1);
    }
  }

  protected void composeMedicationIngredientComponent(Complex parent, String parentType, String name, Medication.MedicationIngredientComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "ingredient", name, element, index);
    if (element.hasItem()) {
      composeType(t, "MedicationIngredientComponent", "item", element.getItem(), -1);
    }
    if (element.hasIsActiveElement()) {
      composeBoolean(t, "MedicationIngredientComponent", "isActive", element.getIsActiveElement(), -1);
    }
    if (element.hasStrength()) {
      composeRatio(t, "MedicationIngredientComponent", "strength", element.getStrength(), -1);
    }
  }

  protected void composeMedicationBatchComponent(Complex parent, String parentType, String name, Medication.MedicationBatchComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "batch", name, element, index);
    if (element.hasLotNumberElement()) {
      composeString(t, "MedicationBatchComponent", "lotNumber", element.getLotNumberElement(), -1);
    }
    if (element.hasExpirationDateElement()) {
      composeDateTime(t, "MedicationBatchComponent", "expirationDate", element.getExpirationDateElement(), -1);
    }
  }

  protected void composeMedicationAdministration(Complex parent, String parentType, String name, MedicationAdministration element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MedicationAdministration", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MedicationAdministration", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiates().size(); i++) {
      composeUri(t, "MedicationAdministration", "instantiates", element.getInstantiates().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "MedicationAdministration", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "MedicationAdministration", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getStatusReason().size(); i++) {
      composeCodeableConcept(t, "MedicationAdministration", "statusReason", element.getStatusReason().get(i), i);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "MedicationAdministration", "category", element.getCategory(), -1);
    }
    if (element.hasMedication()) {
      composeType(t, "MedicationAdministration", "medication", element.getMedication(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "MedicationAdministration", "subject", element.getSubject(), -1);
    }
    if (element.hasContext()) {
      composeReference(t, "MedicationAdministration", "context", element.getContext(), -1);
    }
    for (int i = 0; i < element.getSupportingInformation().size(); i++) {
      composeReference(t, "MedicationAdministration", "supportingInformation", element.getSupportingInformation().get(i), i);
    }
    if (element.hasEffective()) {
      composeType(t, "MedicationAdministration", "effective", element.getEffective(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeMedicationAdministrationPerformerComponent(t, "MedicationAdministration", "performer", element.getPerformer().get(i), i);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "MedicationAdministration", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "MedicationAdministration", "reasonReference", element.getReasonReference().get(i), i);
    }
    if (element.hasRequest()) {
      composeReference(t, "MedicationAdministration", "request", element.getRequest(), -1);
    }
    for (int i = 0; i < element.getDevice().size(); i++) {
      composeReference(t, "MedicationAdministration", "device", element.getDevice().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "MedicationAdministration", "note", element.getNote().get(i), i);
    }
    if (element.hasDosage()) {
      composeMedicationAdministrationDosageComponent(t, "MedicationAdministration", "dosage", element.getDosage(), -1);
    }
    for (int i = 0; i < element.getEventHistory().size(); i++) {
      composeReference(t, "MedicationAdministration", "eventHistory", element.getEventHistory().get(i), i);
    }
  }

  protected void composeMedicationAdministrationPerformerComponent(Complex parent, String parentType, String name, MedicationAdministration.MedicationAdministrationPerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "MedicationAdministrationPerformerComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "MedicationAdministrationPerformerComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeMedicationAdministrationDosageComponent(Complex parent, String parentType, String name, MedicationAdministration.MedicationAdministrationDosageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dosage", name, element, index);
    if (element.hasTextElement()) {
      composeString(t, "MedicationAdministrationDosageComponent", "text", element.getTextElement(), -1);
    }
    if (element.hasSite()) {
      composeCodeableConcept(t, "MedicationAdministrationDosageComponent", "site", element.getSite(), -1);
    }
    if (element.hasRoute()) {
      composeCodeableConcept(t, "MedicationAdministrationDosageComponent", "route", element.getRoute(), -1);
    }
    if (element.hasMethod()) {
      composeCodeableConcept(t, "MedicationAdministrationDosageComponent", "method", element.getMethod(), -1);
    }
    if (element.hasDose()) {
      composeQuantity(t, "MedicationAdministrationDosageComponent", "dose", element.getDose(), -1);
    }
    if (element.hasRate()) {
      composeType(t, "MedicationAdministrationDosageComponent", "rate", element.getRate(), -1);
    }
  }

  protected void composeMedicationDispense(Complex parent, String parentType, String name, MedicationDispense element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MedicationDispense", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MedicationDispense", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "MedicationDispense", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "MedicationDispense", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeType(t, "MedicationDispense", "statusReason", element.getStatusReason(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "MedicationDispense", "category", element.getCategory(), -1);
    }
    if (element.hasMedication()) {
      composeType(t, "MedicationDispense", "medication", element.getMedication(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "MedicationDispense", "subject", element.getSubject(), -1);
    }
    if (element.hasContext()) {
      composeReference(t, "MedicationDispense", "context", element.getContext(), -1);
    }
    for (int i = 0; i < element.getSupportingInformation().size(); i++) {
      composeReference(t, "MedicationDispense", "supportingInformation", element.getSupportingInformation().get(i), i);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeMedicationDispensePerformerComponent(t, "MedicationDispense", "performer", element.getPerformer().get(i), i);
    }
    if (element.hasLocation()) {
      composeReference(t, "MedicationDispense", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getAuthorizingPrescription().size(); i++) {
      composeReference(t, "MedicationDispense", "authorizingPrescription", element.getAuthorizingPrescription().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationDispense", "type", element.getType(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "MedicationDispense", "quantity", element.getQuantity(), -1);
    }
    if (element.hasDaysSupply()) {
      composeQuantity(t, "MedicationDispense", "daysSupply", element.getDaysSupply(), -1);
    }
    if (element.hasWhenPreparedElement()) {
      composeDateTime(t, "MedicationDispense", "whenPrepared", element.getWhenPreparedElement(), -1);
    }
    if (element.hasWhenHandedOverElement()) {
      composeDateTime(t, "MedicationDispense", "whenHandedOver", element.getWhenHandedOverElement(), -1);
    }
    if (element.hasDestination()) {
      composeReference(t, "MedicationDispense", "destination", element.getDestination(), -1);
    }
    for (int i = 0; i < element.getReceiver().size(); i++) {
      composeReference(t, "MedicationDispense", "receiver", element.getReceiver().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "MedicationDispense", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getDosageInstruction().size(); i++) {
      composeDosage(t, "MedicationDispense", "dosageInstruction", element.getDosageInstruction().get(i), i);
    }
    if (element.hasSubstitution()) {
      composeMedicationDispenseSubstitutionComponent(t, "MedicationDispense", "substitution", element.getSubstitution(), -1);
    }
    for (int i = 0; i < element.getDetectedIssue().size(); i++) {
      composeReference(t, "MedicationDispense", "detectedIssue", element.getDetectedIssue().get(i), i);
    }
    for (int i = 0; i < element.getEventHistory().size(); i++) {
      composeReference(t, "MedicationDispense", "eventHistory", element.getEventHistory().get(i), i);
    }
  }

  protected void composeMedicationDispensePerformerComponent(Complex parent, String parentType, String name, MedicationDispense.MedicationDispensePerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "MedicationDispensePerformerComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "MedicationDispensePerformerComponent", "actor", element.getActor(), -1);
    }
  }

  protected void composeMedicationDispenseSubstitutionComponent(Complex parent, String parentType, String name, MedicationDispense.MedicationDispenseSubstitutionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "substitution", name, element, index);
    if (element.hasWasSubstitutedElement()) {
      composeBoolean(t, "MedicationDispenseSubstitutionComponent", "wasSubstituted", element.getWasSubstitutedElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationDispenseSubstitutionComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableConcept(t, "MedicationDispenseSubstitutionComponent", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getResponsibleParty().size(); i++) {
      composeReference(t, "MedicationDispenseSubstitutionComponent", "responsibleParty", element.getResponsibleParty().get(i), i);
    }
  }

  protected void composeMedicationKnowledge(Complex parent, String parentType, String name, MedicationKnowledge element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MedicationKnowledge", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "MedicationKnowledge", "code", element.getCode(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "MedicationKnowledge", "status", element.getStatusElement(), -1);
    }
    if (element.hasManufacturer()) {
      composeReference(t, "MedicationKnowledge", "manufacturer", element.getManufacturer(), -1);
    }
    if (element.hasDoseForm()) {
      composeCodeableConcept(t, "MedicationKnowledge", "doseForm", element.getDoseForm(), -1);
    }
    if (element.hasAmount()) {
      composeQuantity(t, "MedicationKnowledge", "amount", element.getAmount(), -1);
    }
    for (int i = 0; i < element.getSynonym().size(); i++) {
      composeString(t, "MedicationKnowledge", "synonym", element.getSynonym().get(i), i);
    }
    for (int i = 0; i < element.getRelatedMedicationKnowledge().size(); i++) {
      composeMedicationKnowledgeRelatedMedicationKnowledgeComponent(t, "MedicationKnowledge", "relatedMedicationKnowledge", element.getRelatedMedicationKnowledge().get(i), i);
    }
    for (int i = 0; i < element.getAssociatedMedication().size(); i++) {
      composeReference(t, "MedicationKnowledge", "associatedMedication", element.getAssociatedMedication().get(i), i);
    }
    for (int i = 0; i < element.getProductType().size(); i++) {
      composeCodeableConcept(t, "MedicationKnowledge", "productType", element.getProductType().get(i), i);
    }
    for (int i = 0; i < element.getMonograph().size(); i++) {
      composeMedicationKnowledgeMonographComponent(t, "MedicationKnowledge", "monograph", element.getMonograph().get(i), i);
    }
    for (int i = 0; i < element.getIngredient().size(); i++) {
      composeMedicationKnowledgeIngredientComponent(t, "MedicationKnowledge", "ingredient", element.getIngredient().get(i), i);
    }
    if (element.hasPreparationInstructionElement()) {
      composeMarkdown(t, "MedicationKnowledge", "preparationInstruction", element.getPreparationInstructionElement(), -1);
    }
    for (int i = 0; i < element.getIntendedRoute().size(); i++) {
      composeCodeableConcept(t, "MedicationKnowledge", "intendedRoute", element.getIntendedRoute().get(i), i);
    }
    for (int i = 0; i < element.getCost().size(); i++) {
      composeMedicationKnowledgeCostComponent(t, "MedicationKnowledge", "cost", element.getCost().get(i), i);
    }
    for (int i = 0; i < element.getMonitoringProgram().size(); i++) {
      composeMedicationKnowledgeMonitoringProgramComponent(t, "MedicationKnowledge", "monitoringProgram", element.getMonitoringProgram().get(i), i);
    }
    for (int i = 0; i < element.getAdministrationGuidelines().size(); i++) {
      composeMedicationKnowledgeAdministrationGuidelinesComponent(t, "MedicationKnowledge", "administrationGuidelines", element.getAdministrationGuidelines().get(i), i);
    }
    for (int i = 0; i < element.getMedicineClassification().size(); i++) {
      composeMedicationKnowledgeMedicineClassificationComponent(t, "MedicationKnowledge", "medicineClassification", element.getMedicineClassification().get(i), i);
    }
    if (element.hasPackaging()) {
      composeMedicationKnowledgePackagingComponent(t, "MedicationKnowledge", "packaging", element.getPackaging(), -1);
    }
    for (int i = 0; i < element.getDrugCharacteristic().size(); i++) {
      composeMedicationKnowledgeDrugCharacteristicComponent(t, "MedicationKnowledge", "drugCharacteristic", element.getDrugCharacteristic().get(i), i);
    }
    for (int i = 0; i < element.getContraindication().size(); i++) {
      composeReference(t, "MedicationKnowledge", "contraindication", element.getContraindication().get(i), i);
    }
    for (int i = 0; i < element.getRegulatory().size(); i++) {
      composeMedicationKnowledgeRegulatoryComponent(t, "MedicationKnowledge", "regulatory", element.getRegulatory().get(i), i);
    }
    for (int i = 0; i < element.getKinetics().size(); i++) {
      composeMedicationKnowledgeKineticsComponent(t, "MedicationKnowledge", "kinetics", element.getKinetics().get(i), i);
    }
  }

  protected void composeMedicationKnowledgeRelatedMedicationKnowledgeComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatedMedicationKnowledge", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeRelatedMedicationKnowledgeComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getReference().size(); i++) {
      composeReference(t, "MedicationKnowledgeRelatedMedicationKnowledgeComponent", "reference", element.getReference().get(i), i);
    }
  }

  protected void composeMedicationKnowledgeMonographComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMonographComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "monograph", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeMonographComponent", "type", element.getType(), -1);
    }
    if (element.hasSource()) {
      composeReference(t, "MedicationKnowledgeMonographComponent", "source", element.getSource(), -1);
    }
  }

  protected void composeMedicationKnowledgeIngredientComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeIngredientComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "ingredient", name, element, index);
    if (element.hasItem()) {
      composeType(t, "MedicationKnowledgeIngredientComponent", "item", element.getItem(), -1);
    }
    if (element.hasIsActiveElement()) {
      composeBoolean(t, "MedicationKnowledgeIngredientComponent", "isActive", element.getIsActiveElement(), -1);
    }
    if (element.hasStrength()) {
      composeRatio(t, "MedicationKnowledgeIngredientComponent", "strength", element.getStrength(), -1);
    }
  }

  protected void composeMedicationKnowledgeCostComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeCostComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "cost", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeCostComponent", "type", element.getType(), -1);
    }
    if (element.hasSourceElement()) {
      composeString(t, "MedicationKnowledgeCostComponent", "source", element.getSourceElement(), -1);
    }
    if (element.hasCost()) {
      composeMoney(t, "MedicationKnowledgeCostComponent", "cost", element.getCost(), -1);
    }
  }

  protected void composeMedicationKnowledgeMonitoringProgramComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "monitoringProgram", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeMonitoringProgramComponent", "type", element.getType(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "MedicationKnowledgeMonitoringProgramComponent", "name", element.getNameElement(), -1);
    }
  }

  protected void composeMedicationKnowledgeAdministrationGuidelinesComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "administrationGuidelines", name, element, index);
    for (int i = 0; i < element.getDosage().size(); i++) {
      composeMedicationKnowledgeAdministrationGuidelinesDosageComponent(t, "MedicationKnowledgeAdministrationGuidelinesComponent", "dosage", element.getDosage().get(i), i);
    }
    if (element.hasIndication()) {
      composeType(t, "MedicationKnowledgeAdministrationGuidelinesComponent", "indication", element.getIndication(), -1);
    }
    for (int i = 0; i < element.getPatientCharacteristics().size(); i++) {
      composeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(t, "MedicationKnowledgeAdministrationGuidelinesComponent", "patientCharacteristics", element.getPatientCharacteristics().get(i), i);
    }
  }

  protected void composeMedicationKnowledgeAdministrationGuidelinesDosageComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dosage", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeAdministrationGuidelinesDosageComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getDosage().size(); i++) {
      composeDosage(t, "MedicationKnowledgeAdministrationGuidelinesDosageComponent", "dosage", element.getDosage().get(i), i);
    }
  }

  protected void composeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "patientCharacteristics", name, element, index);
    if (element.hasCharacteristic()) {
      composeType(t, "MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent", "characteristic", element.getCharacteristic(), -1);
    }
    for (int i = 0; i < element.getValue().size(); i++) {
      composeString(t, "MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent", "value", element.getValue().get(i), i);
    }
  }

  protected void composeMedicationKnowledgeMedicineClassificationComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "medicineClassification", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeMedicineClassificationComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getClassification().size(); i++) {
      composeCodeableConcept(t, "MedicationKnowledgeMedicineClassificationComponent", "classification", element.getClassification().get(i), i);
    }
  }

  protected void composeMedicationKnowledgePackagingComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgePackagingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "packaging", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgePackagingComponent", "type", element.getType(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "MedicationKnowledgePackagingComponent", "quantity", element.getQuantity(), -1);
    }
  }

  protected void composeMedicationKnowledgeDrugCharacteristicComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "drugCharacteristic", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeDrugCharacteristicComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "MedicationKnowledgeDrugCharacteristicComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeMedicationKnowledgeRegulatoryComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatoryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "regulatory", name, element, index);
    if (element.hasRegulatoryAuthority()) {
      composeReference(t, "MedicationKnowledgeRegulatoryComponent", "regulatoryAuthority", element.getRegulatoryAuthority(), -1);
    }
    for (int i = 0; i < element.getSubstitution().size(); i++) {
      composeMedicationKnowledgeRegulatorySubstitutionComponent(t, "MedicationKnowledgeRegulatoryComponent", "substitution", element.getSubstitution().get(i), i);
    }
    for (int i = 0; i < element.getSchedule().size(); i++) {
      composeMedicationKnowledgeRegulatoryScheduleComponent(t, "MedicationKnowledgeRegulatoryComponent", "schedule", element.getSchedule().get(i), i);
    }
    if (element.hasMaxDispense()) {
      composeMedicationKnowledgeRegulatoryMaxDispenseComponent(t, "MedicationKnowledgeRegulatoryComponent", "maxDispense", element.getMaxDispense(), -1);
    }
  }

  protected void composeMedicationKnowledgeRegulatorySubstitutionComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "substitution", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicationKnowledgeRegulatorySubstitutionComponent", "type", element.getType(), -1);
    }
    if (element.hasAllowedElement()) {
      composeBoolean(t, "MedicationKnowledgeRegulatorySubstitutionComponent", "allowed", element.getAllowedElement(), -1);
    }
  }

  protected void composeMedicationKnowledgeRegulatoryScheduleComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "schedule", name, element, index);
    if (element.hasSchedule()) {
      composeCodeableConcept(t, "MedicationKnowledgeRegulatoryScheduleComponent", "schedule", element.getSchedule(), -1);
    }
  }

  protected void composeMedicationKnowledgeRegulatoryMaxDispenseComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "maxDispense", name, element, index);
    if (element.hasQuantity()) {
      composeQuantity(t, "MedicationKnowledgeRegulatoryMaxDispenseComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasPeriod()) {
      composeDuration(t, "MedicationKnowledgeRegulatoryMaxDispenseComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeMedicationKnowledgeKineticsComponent(Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeKineticsComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "kinetics", name, element, index);
    for (int i = 0; i < element.getAreaUnderCurve().size(); i++) {
      composeQuantity(t, "MedicationKnowledgeKineticsComponent", "areaUnderCurve", element.getAreaUnderCurve().get(i), i);
    }
    for (int i = 0; i < element.getLethalDose50().size(); i++) {
      composeQuantity(t, "MedicationKnowledgeKineticsComponent", "lethalDose50", element.getLethalDose50().get(i), i);
    }
    if (element.hasHalfLifePeriod()) {
      composeDuration(t, "MedicationKnowledgeKineticsComponent", "halfLifePeriod", element.getHalfLifePeriod(), -1);
    }
  }

  protected void composeMedicationRequest(Complex parent, String parentType, String name, MedicationRequest element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MedicationRequest", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MedicationRequest", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "MedicationRequest", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept(t, "MedicationRequest", "statusReason", element.getStatusReason(), -1);
    }
    if (element.hasIntentElement()) {
      composeEnum(t, "MedicationRequest", "intent", element.getIntentElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "MedicationRequest", "category", element.getCategory().get(i), i);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "MedicationRequest", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasDoNotPerformElement()) {
      composeBoolean(t, "MedicationRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
    }
    if (element.hasReported()) {
      composeType(t, "MedicationRequest", "reported", element.getReported(), -1);
    }
    if (element.hasMedication()) {
      composeType(t, "MedicationRequest", "medication", element.getMedication(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "MedicationRequest", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "MedicationRequest", "encounter", element.getEncounter(), -1);
    }
    for (int i = 0; i < element.getSupportingInformation().size(); i++) {
      composeReference(t, "MedicationRequest", "supportingInformation", element.getSupportingInformation().get(i), i);
    }
    if (element.hasAuthoredOnElement()) {
      composeDateTime(t, "MedicationRequest", "authoredOn", element.getAuthoredOnElement(), -1);
    }
    if (element.hasRequester()) {
      composeReference(t, "MedicationRequest", "requester", element.getRequester(), -1);
    }
    if (element.hasPerformer()) {
      composeReference(t, "MedicationRequest", "performer", element.getPerformer(), -1);
    }
    if (element.hasPerformerType()) {
      composeCodeableConcept(t, "MedicationRequest", "performerType", element.getPerformerType(), -1);
    }
    if (element.hasRecorder()) {
      composeReference(t, "MedicationRequest", "recorder", element.getRecorder(), -1);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "MedicationRequest", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "MedicationRequest", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "MedicationRequest", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "MedicationRequest", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "MedicationRequest", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasGroupIdentifier()) {
      composeIdentifier(t, "MedicationRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
    }
    if (element.hasCourseOfTherapyType()) {
      composeCodeableConcept(t, "MedicationRequest", "courseOfTherapyType", element.getCourseOfTherapyType(), -1);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeReference(t, "MedicationRequest", "insurance", element.getInsurance().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "MedicationRequest", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getDosageInstruction().size(); i++) {
      composeDosage(t, "MedicationRequest", "dosageInstruction", element.getDosageInstruction().get(i), i);
    }
    if (element.hasDispenseRequest()) {
      composeMedicationRequestDispenseRequestComponent(t, "MedicationRequest", "dispenseRequest", element.getDispenseRequest(), -1);
    }
    if (element.hasSubstitution()) {
      composeMedicationRequestSubstitutionComponent(t, "MedicationRequest", "substitution", element.getSubstitution(), -1);
    }
    if (element.hasPriorPrescription()) {
      composeReference(t, "MedicationRequest", "priorPrescription", element.getPriorPrescription(), -1);
    }
    for (int i = 0; i < element.getDetectedIssue().size(); i++) {
      composeReference(t, "MedicationRequest", "detectedIssue", element.getDetectedIssue().get(i), i);
    }
    for (int i = 0; i < element.getEventHistory().size(); i++) {
      composeReference(t, "MedicationRequest", "eventHistory", element.getEventHistory().get(i), i);
    }
  }

  protected void composeMedicationRequestDispenseRequestComponent(Complex parent, String parentType, String name, MedicationRequest.MedicationRequestDispenseRequestComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dispenseRequest", name, element, index);
    if (element.hasInitialFill()) {
      composeMedicationRequestDispenseRequestInitialFillComponent(t, "MedicationRequestDispenseRequestComponent", "initialFill", element.getInitialFill(), -1);
    }
    if (element.hasDispenseInterval()) {
      composeDuration(t, "MedicationRequestDispenseRequestComponent", "dispenseInterval", element.getDispenseInterval(), -1);
    }
    if (element.hasValidityPeriod()) {
      composePeriod(t, "MedicationRequestDispenseRequestComponent", "validityPeriod", element.getValidityPeriod(), -1);
    }
    if (element.hasNumberOfRepeatsAllowedElement()) {
      composeUnsignedInt(t, "MedicationRequestDispenseRequestComponent", "numberOfRepeatsAllowed", element.getNumberOfRepeatsAllowedElement(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "MedicationRequestDispenseRequestComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasExpectedSupplyDuration()) {
      composeDuration(t, "MedicationRequestDispenseRequestComponent", "expectedSupplyDuration", element.getExpectedSupplyDuration(), -1);
    }
    if (element.hasPerformer()) {
      composeReference(t, "MedicationRequestDispenseRequestComponent", "performer", element.getPerformer(), -1);
    }
  }

  protected void composeMedicationRequestDispenseRequestInitialFillComponent(Complex parent, String parentType, String name, MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "initialFill", name, element, index);
    if (element.hasQuantity()) {
      composeQuantity(t, "MedicationRequestDispenseRequestInitialFillComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasDuration()) {
      composeDuration(t, "MedicationRequestDispenseRequestInitialFillComponent", "duration", element.getDuration(), -1);
    }
  }

  protected void composeMedicationRequestSubstitutionComponent(Complex parent, String parentType, String name, MedicationRequest.MedicationRequestSubstitutionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "substitution", name, element, index);
    if (element.hasAllowed()) {
      composeType(t, "MedicationRequestSubstitutionComponent", "allowed", element.getAllowed(), -1);
    }
    if (element.hasReason()) {
      composeCodeableConcept(t, "MedicationRequestSubstitutionComponent", "reason", element.getReason(), -1);
    }
  }

  protected void composeMedicationStatement(Complex parent, String parentType, String name, MedicationStatement element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MedicationStatement", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MedicationStatement", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "MedicationStatement", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "MedicationStatement", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "MedicationStatement", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getStatusReason().size(); i++) {
      composeCodeableConcept(t, "MedicationStatement", "statusReason", element.getStatusReason().get(i), i);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "MedicationStatement", "category", element.getCategory(), -1);
    }
    if (element.hasMedication()) {
      composeType(t, "MedicationStatement", "medication", element.getMedication(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "MedicationStatement", "subject", element.getSubject(), -1);
    }
    if (element.hasContext()) {
      composeReference(t, "MedicationStatement", "context", element.getContext(), -1);
    }
    if (element.hasEffective()) {
      composeType(t, "MedicationStatement", "effective", element.getEffective(), -1);
    }
    if (element.hasDateAssertedElement()) {
      composeDateTime(t, "MedicationStatement", "dateAsserted", element.getDateAssertedElement(), -1);
    }
    if (element.hasInformationSource()) {
      composeReference(t, "MedicationStatement", "informationSource", element.getInformationSource(), -1);
    }
    for (int i = 0; i < element.getDerivedFrom().size(); i++) {
      composeReference(t, "MedicationStatement", "derivedFrom", element.getDerivedFrom().get(i), i);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "MedicationStatement", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "MedicationStatement", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "MedicationStatement", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getDosage().size(); i++) {
      composeDosage(t, "MedicationStatement", "dosage", element.getDosage().get(i), i);
    }
  }

  protected void composeMedicinalProductDefinition(Complex parent, String parentType, String name, MedicinalProductDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MedicinalProductDefinition", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MedicinalProductDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "type", element.getType(), -1);
    }
    if (element.hasDomain()) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "domain", element.getDomain(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "MedicinalProductDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "status", element.getStatus(), -1);
    }
    if (element.hasStatusDateElement()) {
      composeDateTime(t, "MedicinalProductDefinition", "statusDate", element.getStatusDateElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "MedicinalProductDefinition", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasCombinedPharmaceuticalDoseForm()) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "combinedPharmaceuticalDoseForm", element.getCombinedPharmaceuticalDoseForm(), -1);
    }
    for (int i = 0; i < element.getRoute().size(); i++) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "route", element.getRoute().get(i), i);
    }
    if (element.hasIndicationElement()) {
      composeMarkdown(t, "MedicinalProductDefinition", "indication", element.getIndicationElement(), -1);
    }
    if (element.hasLegalStatusOfSupply()) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "legalStatusOfSupply", element.getLegalStatusOfSupply(), -1);
    }
    if (element.hasAdditionalMonitoringIndicator()) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "additionalMonitoringIndicator", element.getAdditionalMonitoringIndicator(), -1);
    }
    for (int i = 0; i < element.getSpecialMeasures().size(); i++) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "specialMeasures", element.getSpecialMeasures().get(i), i);
    }
    if (element.hasPediatricUseIndicator()) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "pediatricUseIndicator", element.getPediatricUseIndicator(), -1);
    }
    for (int i = 0; i < element.getClassification().size(); i++) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "classification", element.getClassification().get(i), i);
    }
    for (int i = 0; i < element.getMarketingStatus().size(); i++) {
      composeMarketingStatus(t, "MedicinalProductDefinition", "marketingStatus", element.getMarketingStatus().get(i), i);
    }
    for (int i = 0; i < element.getPackagedMedicinalProduct().size(); i++) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "packagedMedicinalProduct", element.getPackagedMedicinalProduct().get(i), i);
    }
    for (int i = 0; i < element.getIngredient().size(); i++) {
      composeCodeableConcept(t, "MedicinalProductDefinition", "ingredient", element.getIngredient().get(i), i);
    }
    for (int i = 0; i < element.getImpurity().size(); i++) {
      composeCodeableReference(t, "MedicinalProductDefinition", "impurity", element.getImpurity().get(i), i);
    }
    for (int i = 0; i < element.getAttachedDocument().size(); i++) {
      composeReference(t, "MedicinalProductDefinition", "attachedDocument", element.getAttachedDocument().get(i), i);
    }
    for (int i = 0; i < element.getMasterFile().size(); i++) {
      composeReference(t, "MedicinalProductDefinition", "masterFile", element.getMasterFile().get(i), i);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeMedicinalProductDefinitionContactComponent(t, "MedicinalProductDefinition", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getClinicalTrial().size(); i++) {
      composeReference(t, "MedicinalProductDefinition", "clinicalTrial", element.getClinicalTrial().get(i), i);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCoding(t, "MedicinalProductDefinition", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getName().size(); i++) {
      composeMedicinalProductDefinitionNameComponent(t, "MedicinalProductDefinition", "name", element.getName().get(i), i);
    }
    for (int i = 0; i < element.getCrossReference().size(); i++) {
      composeMedicinalProductDefinitionCrossReferenceComponent(t, "MedicinalProductDefinition", "crossReference", element.getCrossReference().get(i), i);
    }
    for (int i = 0; i < element.getOperation().size(); i++) {
      composeMedicinalProductDefinitionOperationComponent(t, "MedicinalProductDefinition", "operation", element.getOperation().get(i), i);
    }
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composeMedicinalProductDefinitionCharacteristicComponent(t, "MedicinalProductDefinition", "characteristic", element.getCharacteristic().get(i), i);
    }
  }

  protected void composeMedicinalProductDefinitionContactComponent(Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionContactComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "contact", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionContactComponent", "type", element.getType(), -1);
    }
    if (element.hasContact()) {
      composeReference(t, "MedicinalProductDefinitionContactComponent", "contact", element.getContact(), -1);
    }
  }

  protected void composeMedicinalProductDefinitionNameComponent(Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionNameComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "name", name, element, index);
    if (element.hasProductNameElement()) {
      composeString(t, "MedicinalProductDefinitionNameComponent", "productName", element.getProductNameElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionNameComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getNamePart().size(); i++) {
      composeMedicinalProductDefinitionNameNamePartComponent(t, "MedicinalProductDefinitionNameComponent", "namePart", element.getNamePart().get(i), i);
    }
    for (int i = 0; i < element.getCountryLanguage().size(); i++) {
      composeMedicinalProductDefinitionNameCountryLanguageComponent(t, "MedicinalProductDefinitionNameComponent", "countryLanguage", element.getCountryLanguage().get(i), i);
    }
  }

  protected void composeMedicinalProductDefinitionNameNamePartComponent(Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "namePart", name, element, index);
    if (element.hasPartElement()) {
      composeString(t, "MedicinalProductDefinitionNameNamePartComponent", "part", element.getPartElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionNameNamePartComponent", "type", element.getType(), -1);
    }
  }

  protected void composeMedicinalProductDefinitionNameCountryLanguageComponent(Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "countryLanguage", name, element, index);
    if (element.hasCountry()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionNameCountryLanguageComponent", "country", element.getCountry(), -1);
    }
    if (element.hasJurisdiction()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionNameCountryLanguageComponent", "jurisdiction", element.getJurisdiction(), -1);
    }
    if (element.hasLanguage()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionNameCountryLanguageComponent", "language", element.getLanguage(), -1);
    }
  }

  protected void composeMedicinalProductDefinitionCrossReferenceComponent(Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "crossReference", name, element, index);
    if (element.hasProduct()) {
      composeCodeableReference(t, "MedicinalProductDefinitionCrossReferenceComponent", "product", element.getProduct(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionCrossReferenceComponent", "type", element.getType(), -1);
    }
  }

  protected void composeMedicinalProductDefinitionOperationComponent(Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionOperationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "operation", name, element, index);
    if (element.hasType()) {
      composeCodeableReference(t, "MedicinalProductDefinitionOperationComponent", "type", element.getType(), -1);
    }
    if (element.hasEffectiveDate()) {
      composePeriod(t, "MedicinalProductDefinitionOperationComponent", "effectiveDate", element.getEffectiveDate(), -1);
    }
    for (int i = 0; i < element.getOrganization().size(); i++) {
      composeReference(t, "MedicinalProductDefinitionOperationComponent", "organization", element.getOrganization().get(i), i);
    }
    if (element.hasConfidentialityIndicator()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionOperationComponent", "confidentialityIndicator", element.getConfidentialityIndicator(), -1);
    }
  }

  protected void composeMedicinalProductDefinitionCharacteristicComponent(Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "characteristic", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "MedicinalProductDefinitionCharacteristicComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "MedicinalProductDefinitionCharacteristicComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeMessageDefinition(Complex parent, String parentType, String name, MessageDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MessageDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "MessageDefinition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MessageDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "MessageDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "MessageDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "MessageDefinition", "title", element.getTitleElement(), -1);
    }
    for (int i = 0; i < element.getReplaces().size(); i++) {
      composeCanonical(t, "MessageDefinition", "replaces", element.getReplaces().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "MessageDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "MessageDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "MessageDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "MessageDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "MessageDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "MessageDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "MessageDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "MessageDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "MessageDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "MessageDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasBaseElement()) {
      composeCanonical(t, "MessageDefinition", "base", element.getBaseElement(), -1);
    }
    for (int i = 0; i < element.getParent().size(); i++) {
      composeCanonical(t, "MessageDefinition", "parent", element.getParent().get(i), i);
    }
    if (element.hasEvent()) {
      composeType(t, "MessageDefinition", "event", element.getEvent(), -1);
    }
    if (element.hasCategoryElement()) {
      composeEnum(t, "MessageDefinition", "category", element.getCategoryElement(), -1);
    }
    for (int i = 0; i < element.getFocus().size(); i++) {
      composeMessageDefinitionFocusComponent(t, "MessageDefinition", "focus", element.getFocus().get(i), i);
    }
    if (element.hasResponseRequiredElement()) {
      composeEnum(t, "MessageDefinition", "responseRequired", element.getResponseRequiredElement(), -1);
    }
    for (int i = 0; i < element.getAllowedResponse().size(); i++) {
      composeMessageDefinitionAllowedResponseComponent(t, "MessageDefinition", "allowedResponse", element.getAllowedResponse().get(i), i);
    }
    for (int i = 0; i < element.getGraph().size(); i++) {
      composeCanonical(t, "MessageDefinition", "graph", element.getGraph().get(i), i);
    }
  }

  protected void composeMessageDefinitionFocusComponent(Complex parent, String parentType, String name, MessageDefinition.MessageDefinitionFocusComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "focus", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "MessageDefinitionFocusComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasProfileElement()) {
      composeCanonical(t, "MessageDefinitionFocusComponent", "profile", element.getProfileElement(), -1);
    }
    if (element.hasMinElement()) {
      composeUnsignedInt(t, "MessageDefinitionFocusComponent", "min", element.getMinElement(), -1);
    }
    if (element.hasMaxElement()) {
      composeString(t, "MessageDefinitionFocusComponent", "max", element.getMaxElement(), -1);
    }
  }

  protected void composeMessageDefinitionAllowedResponseComponent(Complex parent, String parentType, String name, MessageDefinition.MessageDefinitionAllowedResponseComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "allowedResponse", name, element, index);
    if (element.hasMessageElement()) {
      composeCanonical(t, "MessageDefinitionAllowedResponseComponent", "message", element.getMessageElement(), -1);
    }
    if (element.hasSituationElement()) {
      composeMarkdown(t, "MessageDefinitionAllowedResponseComponent", "situation", element.getSituationElement(), -1);
    }
  }

  protected void composeMessageHeader(Complex parent, String parentType, String name, MessageHeader element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MessageHeader", name, element, index);
    if (element.hasEvent()) {
      composeType(t, "MessageHeader", "event", element.getEvent(), -1);
    }
    for (int i = 0; i < element.getDestination().size(); i++) {
      composeMessageHeaderMessageDestinationComponent(t, "MessageHeader", "destination", element.getDestination().get(i), i);
    }
    if (element.hasSender()) {
      composeReference(t, "MessageHeader", "sender", element.getSender(), -1);
    }
    if (element.hasEnterer()) {
      composeReference(t, "MessageHeader", "enterer", element.getEnterer(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "MessageHeader", "author", element.getAuthor(), -1);
    }
    if (element.hasSource()) {
      composeMessageHeaderMessageSourceComponent(t, "MessageHeader", "source", element.getSource(), -1);
    }
    if (element.hasResponsible()) {
      composeReference(t, "MessageHeader", "responsible", element.getResponsible(), -1);
    }
    if (element.hasReason()) {
      composeCodeableConcept(t, "MessageHeader", "reason", element.getReason(), -1);
    }
    if (element.hasResponse()) {
      composeMessageHeaderResponseComponent(t, "MessageHeader", "response", element.getResponse(), -1);
    }
    for (int i = 0; i < element.getFocus().size(); i++) {
      composeReference(t, "MessageHeader", "focus", element.getFocus().get(i), i);
    }
    if (element.hasDefinitionElement()) {
      composeCanonical(t, "MessageHeader", "definition", element.getDefinitionElement(), -1);
    }
  }

  protected void composeMessageHeaderMessageDestinationComponent(Complex parent, String parentType, String name, MessageHeader.MessageDestinationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "destination", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "MessageDestinationComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasTarget()) {
      composeReference(t, "MessageDestinationComponent", "target", element.getTarget(), -1);
    }
    if (element.hasEndpointElement()) {
      composeUrl(t, "MessageDestinationComponent", "endpoint", element.getEndpointElement(), -1);
    }
    if (element.hasReceiver()) {
      composeReference(t, "MessageDestinationComponent", "receiver", element.getReceiver(), -1);
    }
  }

  protected void composeMessageHeaderMessageSourceComponent(Complex parent, String parentType, String name, MessageHeader.MessageSourceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "source", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "MessageSourceComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasSoftwareElement()) {
      composeString(t, "MessageSourceComponent", "software", element.getSoftwareElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "MessageSourceComponent", "version", element.getVersionElement(), -1);
    }
    if (element.hasContact()) {
      composeContactPoint(t, "MessageSourceComponent", "contact", element.getContact(), -1);
    }
    if (element.hasEndpointElement()) {
      composeUrl(t, "MessageSourceComponent", "endpoint", element.getEndpointElement(), -1);
    }
  }

  protected void composeMessageHeaderResponseComponent(Complex parent, String parentType, String name, MessageHeader.MessageHeaderResponseComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "response", name, element, index);
    if (element.hasIdentifierElement()) {
      composeId(t, "MessageHeaderResponseComponent", "identifier", element.getIdentifierElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeEnum(t, "MessageHeaderResponseComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDetails()) {
      composeReference(t, "MessageHeaderResponseComponent", "details", element.getDetails(), -1);
    }
  }

  protected void composeMolecularSequence(Complex parent, String parentType, String name, MolecularSequence element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "MolecularSequence", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "MolecularSequence", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "MolecularSequence", "type", element.getTypeElement(), -1);
    }
    if (element.hasCoordinateSystemElement()) {
      composeInteger(t, "MolecularSequence", "coordinateSystem", element.getCoordinateSystemElement(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "MolecularSequence", "patient", element.getPatient(), -1);
    }
    if (element.hasSpecimen()) {
      composeReference(t, "MolecularSequence", "specimen", element.getSpecimen(), -1);
    }
    if (element.hasDevice()) {
      composeReference(t, "MolecularSequence", "device", element.getDevice(), -1);
    }
    if (element.hasPerformer()) {
      composeReference(t, "MolecularSequence", "performer", element.getPerformer(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "MolecularSequence", "quantity", element.getQuantity(), -1);
    }
    if (element.hasReferenceSeq()) {
      composeMolecularSequenceReferenceSeqComponent(t, "MolecularSequence", "referenceSeq", element.getReferenceSeq(), -1);
    }
    for (int i = 0; i < element.getVariant().size(); i++) {
      composeMolecularSequenceVariantComponent(t, "MolecularSequence", "variant", element.getVariant().get(i), i);
    }
    if (element.hasObservedSeqElement()) {
      composeString(t, "MolecularSequence", "observedSeq", element.getObservedSeqElement(), -1);
    }
    for (int i = 0; i < element.getQuality().size(); i++) {
      composeMolecularSequenceQualityComponent(t, "MolecularSequence", "quality", element.getQuality().get(i), i);
    }
    if (element.hasReadCoverageElement()) {
      composeInteger(t, "MolecularSequence", "readCoverage", element.getReadCoverageElement(), -1);
    }
    for (int i = 0; i < element.getRepository().size(); i++) {
      composeMolecularSequenceRepositoryComponent(t, "MolecularSequence", "repository", element.getRepository().get(i), i);
    }
    for (int i = 0; i < element.getPointer().size(); i++) {
      composeReference(t, "MolecularSequence", "pointer", element.getPointer().get(i), i);
    }
    for (int i = 0; i < element.getStructureVariant().size(); i++) {
      composeMolecularSequenceStructureVariantComponent(t, "MolecularSequence", "structureVariant", element.getStructureVariant().get(i), i);
    }
  }

  protected void composeMolecularSequenceReferenceSeqComponent(Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceReferenceSeqComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "referenceSeq", name, element, index);
    if (element.hasChromosome()) {
      composeCodeableConcept(t, "MolecularSequenceReferenceSeqComponent", "chromosome", element.getChromosome(), -1);
    }
    if (element.hasGenomeBuildElement()) {
      composeString(t, "MolecularSequenceReferenceSeqComponent", "genomeBuild", element.getGenomeBuildElement(), -1);
    }
    if (element.hasOrientationElement()) {
      composeEnum(t, "MolecularSequenceReferenceSeqComponent", "orientation", element.getOrientationElement(), -1);
    }
    if (element.hasReferenceSeqId()) {
      composeCodeableConcept(t, "MolecularSequenceReferenceSeqComponent", "referenceSeqId", element.getReferenceSeqId(), -1);
    }
    if (element.hasReferenceSeqPointer()) {
      composeReference(t, "MolecularSequenceReferenceSeqComponent", "referenceSeqPointer", element.getReferenceSeqPointer(), -1);
    }
    if (element.hasReferenceSeqStringElement()) {
      composeString(t, "MolecularSequenceReferenceSeqComponent", "referenceSeqString", element.getReferenceSeqStringElement(), -1);
    }
    if (element.hasStrandElement()) {
      composeEnum(t, "MolecularSequenceReferenceSeqComponent", "strand", element.getStrandElement(), -1);
    }
    if (element.hasWindowStartElement()) {
      composeInteger(t, "MolecularSequenceReferenceSeqComponent", "windowStart", element.getWindowStartElement(), -1);
    }
    if (element.hasWindowEndElement()) {
      composeInteger(t, "MolecularSequenceReferenceSeqComponent", "windowEnd", element.getWindowEndElement(), -1);
    }
  }

  protected void composeMolecularSequenceVariantComponent(Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceVariantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "variant", name, element, index);
    if (element.hasStartElement()) {
      composeInteger(t, "MolecularSequenceVariantComponent", "start", element.getStartElement(), -1);
    }
    if (element.hasEndElement()) {
      composeInteger(t, "MolecularSequenceVariantComponent", "end", element.getEndElement(), -1);
    }
    if (element.hasObservedAlleleElement()) {
      composeString(t, "MolecularSequenceVariantComponent", "observedAllele", element.getObservedAlleleElement(), -1);
    }
    if (element.hasReferenceAlleleElement()) {
      composeString(t, "MolecularSequenceVariantComponent", "referenceAllele", element.getReferenceAlleleElement(), -1);
    }
    if (element.hasCigarElement()) {
      composeString(t, "MolecularSequenceVariantComponent", "cigar", element.getCigarElement(), -1);
    }
    if (element.hasVariantPointer()) {
      composeReference(t, "MolecularSequenceVariantComponent", "variantPointer", element.getVariantPointer(), -1);
    }
  }

  protected void composeMolecularSequenceQualityComponent(Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceQualityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "quality", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "MolecularSequenceQualityComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasStandardSequence()) {
      composeCodeableConcept(t, "MolecularSequenceQualityComponent", "standardSequence", element.getStandardSequence(), -1);
    }
    if (element.hasStartElement()) {
      composeInteger(t, "MolecularSequenceQualityComponent", "start", element.getStartElement(), -1);
    }
    if (element.hasEndElement()) {
      composeInteger(t, "MolecularSequenceQualityComponent", "end", element.getEndElement(), -1);
    }
    if (element.hasScore()) {
      composeQuantity(t, "MolecularSequenceQualityComponent", "score", element.getScore(), -1);
    }
    if (element.hasMethod()) {
      composeCodeableConcept(t, "MolecularSequenceQualityComponent", "method", element.getMethod(), -1);
    }
    if (element.hasTruthTPElement()) {
      composeDecimal(t, "MolecularSequenceQualityComponent", "truthTP", element.getTruthTPElement(), -1);
    }
    if (element.hasQueryTPElement()) {
      composeDecimal(t, "MolecularSequenceQualityComponent", "queryTP", element.getQueryTPElement(), -1);
    }
    if (element.hasTruthFNElement()) {
      composeDecimal(t, "MolecularSequenceQualityComponent", "truthFN", element.getTruthFNElement(), -1);
    }
    if (element.hasQueryFPElement()) {
      composeDecimal(t, "MolecularSequenceQualityComponent", "queryFP", element.getQueryFPElement(), -1);
    }
    if (element.hasGtFPElement()) {
      composeDecimal(t, "MolecularSequenceQualityComponent", "gtFP", element.getGtFPElement(), -1);
    }
    if (element.hasPrecisionElement()) {
      composeDecimal(t, "MolecularSequenceQualityComponent", "precision", element.getPrecisionElement(), -1);
    }
    if (element.hasRecallElement()) {
      composeDecimal(t, "MolecularSequenceQualityComponent", "recall", element.getRecallElement(), -1);
    }
    if (element.hasFScoreElement()) {
      composeDecimal(t, "MolecularSequenceQualityComponent", "fScore", element.getFScoreElement(), -1);
    }
    if (element.hasRoc()) {
      composeMolecularSequenceQualityRocComponent(t, "MolecularSequenceQualityComponent", "roc", element.getRoc(), -1);
    }
  }

  protected void composeMolecularSequenceQualityRocComponent(Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceQualityRocComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "roc", name, element, index);
    for (int i = 0; i < element.getScore().size(); i++) {
      composeInteger(t, "MolecularSequenceQualityRocComponent", "score", element.getScore().get(i), i);
    }
    for (int i = 0; i < element.getNumTP().size(); i++) {
      composeInteger(t, "MolecularSequenceQualityRocComponent", "numTP", element.getNumTP().get(i), i);
    }
    for (int i = 0; i < element.getNumFP().size(); i++) {
      composeInteger(t, "MolecularSequenceQualityRocComponent", "numFP", element.getNumFP().get(i), i);
    }
    for (int i = 0; i < element.getNumFN().size(); i++) {
      composeInteger(t, "MolecularSequenceQualityRocComponent", "numFN", element.getNumFN().get(i), i);
    }
    for (int i = 0; i < element.getPrecision().size(); i++) {
      composeDecimal(t, "MolecularSequenceQualityRocComponent", "precision", element.getPrecision().get(i), i);
    }
    for (int i = 0; i < element.getSensitivity().size(); i++) {
      composeDecimal(t, "MolecularSequenceQualityRocComponent", "sensitivity", element.getSensitivity().get(i), i);
    }
    for (int i = 0; i < element.getFMeasure().size(); i++) {
      composeDecimal(t, "MolecularSequenceQualityRocComponent", "fMeasure", element.getFMeasure().get(i), i);
    }
  }

  protected void composeMolecularSequenceRepositoryComponent(Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceRepositoryComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "repository", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "MolecularSequenceRepositoryComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasUrlElement()) {
      composeUri(t, "MolecularSequenceRepositoryComponent", "url", element.getUrlElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "MolecularSequenceRepositoryComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDatasetIdElement()) {
      composeString(t, "MolecularSequenceRepositoryComponent", "datasetId", element.getDatasetIdElement(), -1);
    }
    if (element.hasVariantsetIdElement()) {
      composeString(t, "MolecularSequenceRepositoryComponent", "variantsetId", element.getVariantsetIdElement(), -1);
    }
    if (element.hasReadsetIdElement()) {
      composeString(t, "MolecularSequenceRepositoryComponent", "readsetId", element.getReadsetIdElement(), -1);
    }
  }

  protected void composeMolecularSequenceStructureVariantComponent(Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceStructureVariantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "structureVariant", name, element, index);
    if (element.hasVariantType()) {
      composeCodeableConcept(t, "MolecularSequenceStructureVariantComponent", "variantType", element.getVariantType(), -1);
    }
    if (element.hasExactElement()) {
      composeBoolean(t, "MolecularSequenceStructureVariantComponent", "exact", element.getExactElement(), -1);
    }
    if (element.hasLengthElement()) {
      composeInteger(t, "MolecularSequenceStructureVariantComponent", "length", element.getLengthElement(), -1);
    }
    if (element.hasOuter()) {
      composeMolecularSequenceStructureVariantOuterComponent(t, "MolecularSequenceStructureVariantComponent", "outer", element.getOuter(), -1);
    }
    if (element.hasInner()) {
      composeMolecularSequenceStructureVariantInnerComponent(t, "MolecularSequenceStructureVariantComponent", "inner", element.getInner(), -1);
    }
  }

  protected void composeMolecularSequenceStructureVariantOuterComponent(Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceStructureVariantOuterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "outer", name, element, index);
    if (element.hasStartElement()) {
      composeInteger(t, "MolecularSequenceStructureVariantOuterComponent", "start", element.getStartElement(), -1);
    }
    if (element.hasEndElement()) {
      composeInteger(t, "MolecularSequenceStructureVariantOuterComponent", "end", element.getEndElement(), -1);
    }
  }

  protected void composeMolecularSequenceStructureVariantInnerComponent(Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceStructureVariantInnerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "inner", name, element, index);
    if (element.hasStartElement()) {
      composeInteger(t, "MolecularSequenceStructureVariantInnerComponent", "start", element.getStartElement(), -1);
    }
    if (element.hasEndElement()) {
      composeInteger(t, "MolecularSequenceStructureVariantInnerComponent", "end", element.getEndElement(), -1);
    }
  }

  protected void composeNamingSystem(Complex parent, String parentType, String name, NamingSystem element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "NamingSystem", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "NamingSystem", "name", element.getNameElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "NamingSystem", "status", element.getStatusElement(), -1);
    }
    if (element.hasKindElement()) {
      composeEnum(t, "NamingSystem", "kind", element.getKindElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "NamingSystem", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "NamingSystem", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "NamingSystem", "contact", element.getContact().get(i), i);
    }
    if (element.hasResponsibleElement()) {
      composeString(t, "NamingSystem", "responsible", element.getResponsibleElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "NamingSystem", "type", element.getType(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "NamingSystem", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "NamingSystem", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "NamingSystem", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasUsageElement()) {
      composeString(t, "NamingSystem", "usage", element.getUsageElement(), -1);
    }
    for (int i = 0; i < element.getUniqueId().size(); i++) {
      composeNamingSystemUniqueIdComponent(t, "NamingSystem", "uniqueId", element.getUniqueId().get(i), i);
    }
  }

  protected void composeNamingSystemUniqueIdComponent(Complex parent, String parentType, String name, NamingSystem.NamingSystemUniqueIdComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "uniqueId", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "NamingSystemUniqueIdComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "NamingSystemUniqueIdComponent", "value", element.getValueElement(), -1);
    }
    if (element.hasPreferredElement()) {
      composeBoolean(t, "NamingSystemUniqueIdComponent", "preferred", element.getPreferredElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeString(t, "NamingSystemUniqueIdComponent", "comment", element.getCommentElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "NamingSystemUniqueIdComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composeNutritionOrder(Complex parent, String parentType, String name, NutritionOrder element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "NutritionOrder", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "NutritionOrder", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "NutritionOrder", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "NutritionOrder", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    for (int i = 0; i < element.getInstantiates().size(); i++) {
      composeUri(t, "NutritionOrder", "instantiates", element.getInstantiates().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "NutritionOrder", "status", element.getStatusElement(), -1);
    }
    if (element.hasIntentElement()) {
      composeEnum(t, "NutritionOrder", "intent", element.getIntentElement(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "NutritionOrder", "patient", element.getPatient(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "NutritionOrder", "encounter", element.getEncounter(), -1);
    }
    if (element.hasDateTimeElement()) {
      composeDateTime(t, "NutritionOrder", "dateTime", element.getDateTimeElement(), -1);
    }
    if (element.hasOrderer()) {
      composeReference(t, "NutritionOrder", "orderer", element.getOrderer(), -1);
    }
    for (int i = 0; i < element.getAllergyIntolerance().size(); i++) {
      composeReference(t, "NutritionOrder", "allergyIntolerance", element.getAllergyIntolerance().get(i), i);
    }
    for (int i = 0; i < element.getFoodPreferenceModifier().size(); i++) {
      composeCodeableConcept(t, "NutritionOrder", "foodPreferenceModifier", element.getFoodPreferenceModifier().get(i), i);
    }
    for (int i = 0; i < element.getExcludeFoodModifier().size(); i++) {
      composeCodeableConcept(t, "NutritionOrder", "excludeFoodModifier", element.getExcludeFoodModifier().get(i), i);
    }
    if (element.hasOralDiet()) {
      composeNutritionOrderOralDietComponent(t, "NutritionOrder", "oralDiet", element.getOralDiet(), -1);
    }
    for (int i = 0; i < element.getSupplement().size(); i++) {
      composeNutritionOrderSupplementComponent(t, "NutritionOrder", "supplement", element.getSupplement().get(i), i);
    }
    if (element.hasEnteralFormula()) {
      composeNutritionOrderEnteralFormulaComponent(t, "NutritionOrder", "enteralFormula", element.getEnteralFormula(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "NutritionOrder", "note", element.getNote().get(i), i);
    }
  }

  protected void composeNutritionOrderOralDietComponent(Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "oralDiet", name, element, index);
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "NutritionOrderOralDietComponent", "type", element.getType().get(i), i);
    }
    for (int i = 0; i < element.getSchedule().size(); i++) {
      composeTiming(t, "NutritionOrderOralDietComponent", "schedule", element.getSchedule().get(i), i);
    }
    for (int i = 0; i < element.getNutrient().size(); i++) {
      composeNutritionOrderOralDietNutrientComponent(t, "NutritionOrderOralDietComponent", "nutrient", element.getNutrient().get(i), i);
    }
    for (int i = 0; i < element.getTexture().size(); i++) {
      composeNutritionOrderOralDietTextureComponent(t, "NutritionOrderOralDietComponent", "texture", element.getTexture().get(i), i);
    }
    for (int i = 0; i < element.getFluidConsistencyType().size(); i++) {
      composeCodeableConcept(t, "NutritionOrderOralDietComponent", "fluidConsistencyType", element.getFluidConsistencyType().get(i), i);
    }
    if (element.hasInstructionElement()) {
      composeString(t, "NutritionOrderOralDietComponent", "instruction", element.getInstructionElement(), -1);
    }
  }

  protected void composeNutritionOrderOralDietNutrientComponent(Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietNutrientComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "nutrient", name, element, index);
    if (element.hasModifier()) {
      composeCodeableConcept(t, "NutritionOrderOralDietNutrientComponent", "modifier", element.getModifier(), -1);
    }
    if (element.hasAmount()) {
      composeQuantity(t, "NutritionOrderOralDietNutrientComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composeNutritionOrderOralDietTextureComponent(Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietTextureComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "texture", name, element, index);
    if (element.hasModifier()) {
      composeCodeableConcept(t, "NutritionOrderOralDietTextureComponent", "modifier", element.getModifier(), -1);
    }
    if (element.hasFoodType()) {
      composeCodeableConcept(t, "NutritionOrderOralDietTextureComponent", "foodType", element.getFoodType(), -1);
    }
  }

  protected void composeNutritionOrderSupplementComponent(Complex parent, String parentType, String name, NutritionOrder.NutritionOrderSupplementComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "supplement", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "NutritionOrderSupplementComponent", "type", element.getType(), -1);
    }
    if (element.hasProductNameElement()) {
      composeString(t, "NutritionOrderSupplementComponent", "productName", element.getProductNameElement(), -1);
    }
    for (int i = 0; i < element.getSchedule().size(); i++) {
      composeTiming(t, "NutritionOrderSupplementComponent", "schedule", element.getSchedule().get(i), i);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "NutritionOrderSupplementComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasInstructionElement()) {
      composeString(t, "NutritionOrderSupplementComponent", "instruction", element.getInstructionElement(), -1);
    }
  }

  protected void composeNutritionOrderEnteralFormulaComponent(Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "enteralFormula", name, element, index);
    if (element.hasBaseFormulaType()) {
      composeCodeableConcept(t, "NutritionOrderEnteralFormulaComponent", "baseFormulaType", element.getBaseFormulaType(), -1);
    }
    if (element.hasBaseFormulaProductNameElement()) {
      composeString(t, "NutritionOrderEnteralFormulaComponent", "baseFormulaProductName", element.getBaseFormulaProductNameElement(), -1);
    }
    if (element.hasAdditiveType()) {
      composeCodeableConcept(t, "NutritionOrderEnteralFormulaComponent", "additiveType", element.getAdditiveType(), -1);
    }
    if (element.hasAdditiveProductNameElement()) {
      composeString(t, "NutritionOrderEnteralFormulaComponent", "additiveProductName", element.getAdditiveProductNameElement(), -1);
    }
    if (element.hasCaloricDensity()) {
      composeQuantity(t, "NutritionOrderEnteralFormulaComponent", "caloricDensity", element.getCaloricDensity(), -1);
    }
    if (element.hasRouteofAdministration()) {
      composeCodeableConcept(t, "NutritionOrderEnteralFormulaComponent", "routeofAdministration", element.getRouteofAdministration(), -1);
    }
    for (int i = 0; i < element.getAdministration().size(); i++) {
      composeNutritionOrderEnteralFormulaAdministrationComponent(t, "NutritionOrderEnteralFormulaComponent", "administration", element.getAdministration().get(i), i);
    }
    if (element.hasMaxVolumeToDeliver()) {
      composeQuantity(t, "NutritionOrderEnteralFormulaComponent", "maxVolumeToDeliver", element.getMaxVolumeToDeliver(), -1);
    }
    if (element.hasAdministrationInstructionElement()) {
      composeString(t, "NutritionOrderEnteralFormulaComponent", "administrationInstruction", element.getAdministrationInstructionElement(), -1);
    }
  }

  protected void composeNutritionOrderEnteralFormulaAdministrationComponent(Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "administration", name, element, index);
    if (element.hasSchedule()) {
      composeTiming(t, "NutritionOrderEnteralFormulaAdministrationComponent", "schedule", element.getSchedule(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "NutritionOrderEnteralFormulaAdministrationComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasRate()) {
      composeType(t, "NutritionOrderEnteralFormulaAdministrationComponent", "rate", element.getRate(), -1);
    }
  }

  protected void composeNutritionProduct(Complex parent, String parentType, String name, NutritionProduct element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "NutritionProduct", name, element, index);
    if (element.hasStatusElement()) {
      composeEnum(t, "NutritionProduct", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "NutritionProduct", "category", element.getCategory().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "NutritionProduct", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getManufacturer().size(); i++) {
      composeReference(t, "NutritionProduct", "manufacturer", element.getManufacturer().get(i), i);
    }
    for (int i = 0; i < element.getNutrient().size(); i++) {
      composeNutritionProductNutrientComponent(t, "NutritionProduct", "nutrient", element.getNutrient().get(i), i);
    }
    for (int i = 0; i < element.getIngredient().size(); i++) {
      composeNutritionProductIngredientComponent(t, "NutritionProduct", "ingredient", element.getIngredient().get(i), i);
    }
    for (int i = 0; i < element.getKnownAllergen().size(); i++) {
      composeCodeableReference(t, "NutritionProduct", "knownAllergen", element.getKnownAllergen().get(i), i);
    }
    for (int i = 0; i < element.getProductCharacteristic().size(); i++) {
      composeNutritionProductProductCharacteristicComponent(t, "NutritionProduct", "productCharacteristic", element.getProductCharacteristic().get(i), i);
    }
    if (element.hasInstance()) {
      composeNutritionProductInstanceComponent(t, "NutritionProduct", "instance", element.getInstance(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "NutritionProduct", "note", element.getNote().get(i), i);
    }
  }

  protected void composeNutritionProductNutrientComponent(Complex parent, String parentType, String name, NutritionProduct.NutritionProductNutrientComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "nutrient", name, element, index);
    if (element.hasItem()) {
      composeCodeableReference(t, "NutritionProductNutrientComponent", "item", element.getItem(), -1);
    }
    for (int i = 0; i < element.getAmount().size(); i++) {
      composeRatio(t, "NutritionProductNutrientComponent", "amount", element.getAmount().get(i), i);
    }
  }

  protected void composeNutritionProductIngredientComponent(Complex parent, String parentType, String name, NutritionProduct.NutritionProductIngredientComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "ingredient", name, element, index);
    if (element.hasItem()) {
      composeCodeableReference(t, "NutritionProductIngredientComponent", "item", element.getItem(), -1);
    }
    for (int i = 0; i < element.getAmount().size(); i++) {
      composeRatio(t, "NutritionProductIngredientComponent", "amount", element.getAmount().get(i), i);
    }
  }

  protected void composeNutritionProductProductCharacteristicComponent(Complex parent, String parentType, String name, NutritionProduct.NutritionProductProductCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "productCharacteristic", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "NutritionProductProductCharacteristicComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "NutritionProductProductCharacteristicComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeNutritionProductInstanceComponent(Complex parent, String parentType, String name, NutritionProduct.NutritionProductInstanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "instance", name, element, index);
    if (element.hasQuantity()) {
      composeQuantity(t, "NutritionProductInstanceComponent", "quantity", element.getQuantity(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "NutritionProductInstanceComponent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasLotNumberElement()) {
      composeString(t, "NutritionProductInstanceComponent", "lotNumber", element.getLotNumberElement(), -1);
    }
    if (element.hasExpiryElement()) {
      composeDateTime(t, "NutritionProductInstanceComponent", "expiry", element.getExpiryElement(), -1);
    }
    if (element.hasUseByElement()) {
      composeDateTime(t, "NutritionProductInstanceComponent", "useBy", element.getUseByElement(), -1);
    }
  }

  protected void composeObservation(Complex parent, String parentType, String name, Observation element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Observation", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Observation", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "Observation", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "Observation", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Observation", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Observation", "category", element.getCategory().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Observation", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "Observation", "subject", element.getSubject(), -1);
    }
    for (int i = 0; i < element.getFocus().size(); i++) {
      composeReference(t, "Observation", "focus", element.getFocus().get(i), i);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Observation", "encounter", element.getEncounter(), -1);
    }
    if (element.hasEffective()) {
      composeType(t, "Observation", "effective", element.getEffective(), -1);
    }
    if (element.hasIssuedElement()) {
      composeInstant(t, "Observation", "issued", element.getIssuedElement(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeReference(t, "Observation", "performer", element.getPerformer().get(i), i);
    }
    if (element.hasValue()) {
      composeType(t, "Observation", "value", element.getValue(), -1);
    }
    if (element.hasDataAbsentReason()) {
      composeCodeableConcept(t, "Observation", "dataAbsentReason", element.getDataAbsentReason(), -1);
    }
    for (int i = 0; i < element.getInterpretation().size(); i++) {
      composeCodeableConcept(t, "Observation", "interpretation", element.getInterpretation().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Observation", "note", element.getNote().get(i), i);
    }
    if (element.hasBodySite()) {
      composeCodeableConcept(t, "Observation", "bodySite", element.getBodySite(), -1);
    }
    if (element.hasMethod()) {
      composeCodeableConcept(t, "Observation", "method", element.getMethod(), -1);
    }
    if (element.hasSpecimen()) {
      composeReference(t, "Observation", "specimen", element.getSpecimen(), -1);
    }
    if (element.hasDevice()) {
      composeReference(t, "Observation", "device", element.getDevice(), -1);
    }
    for (int i = 0; i < element.getReferenceRange().size(); i++) {
      composeObservationReferenceRangeComponent(t, "Observation", "referenceRange", element.getReferenceRange().get(i), i);
    }
    for (int i = 0; i < element.getHasMember().size(); i++) {
      composeReference(t, "Observation", "hasMember", element.getHasMember().get(i), i);
    }
    for (int i = 0; i < element.getDerivedFrom().size(); i++) {
      composeReference(t, "Observation", "derivedFrom", element.getDerivedFrom().get(i), i);
    }
    for (int i = 0; i < element.getComponent().size(); i++) {
      composeObservationComponentComponent(t, "Observation", "component", element.getComponent().get(i), i);
    }
  }

  protected void composeObservationReferenceRangeComponent(Complex parent, String parentType, String name, Observation.ObservationReferenceRangeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "referenceRange", name, element, index);
    if (element.hasLow()) {
      composeQuantity(t, "ObservationReferenceRangeComponent", "low", element.getLow(), -1);
    }
    if (element.hasHigh()) {
      composeQuantity(t, "ObservationReferenceRangeComponent", "high", element.getHigh(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ObservationReferenceRangeComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getAppliesTo().size(); i++) {
      composeCodeableConcept(t, "ObservationReferenceRangeComponent", "appliesTo", element.getAppliesTo().get(i), i);
    }
    if (element.hasAge()) {
      composeRange(t, "ObservationReferenceRangeComponent", "age", element.getAge(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "ObservationReferenceRangeComponent", "text", element.getTextElement(), -1);
    }
  }

  protected void composeObservationComponentComponent(Complex parent, String parentType, String name, Observation.ObservationComponentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "component", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "ObservationComponentComponent", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "ObservationComponentComponent", "value", element.getValue(), -1);
    }
    if (element.hasDataAbsentReason()) {
      composeCodeableConcept(t, "ObservationComponentComponent", "dataAbsentReason", element.getDataAbsentReason(), -1);
    }
    for (int i = 0; i < element.getInterpretation().size(); i++) {
      composeCodeableConcept(t, "ObservationComponentComponent", "interpretation", element.getInterpretation().get(i), i);
    }
    for (int i = 0; i < element.getReferenceRange().size(); i++) {
      composeObservationReferenceRangeComponent(t, "ObservationComponentComponent", "referenceRange", element.getReferenceRange().get(i), i);
    }
  }

  protected void composeObservationDefinition(Complex parent, String parentType, String name, ObservationDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ObservationDefinition", name, element, index);
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "ObservationDefinition", "category", element.getCategory().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ObservationDefinition", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ObservationDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getPermittedDataType().size(); i++) {
      composeEnum(t, "ObservationDefinition", "permittedDataType", element.getPermittedDataType().get(i), i);
    }
    if (element.hasMultipleResultsAllowedElement()) {
      composeBoolean(t, "ObservationDefinition", "multipleResultsAllowed", element.getMultipleResultsAllowedElement(), -1);
    }
    if (element.hasMethod()) {
      composeCodeableConcept(t, "ObservationDefinition", "method", element.getMethod(), -1);
    }
    if (element.hasPreferredReportNameElement()) {
      composeString(t, "ObservationDefinition", "preferredReportName", element.getPreferredReportNameElement(), -1);
    }
    if (element.hasQuantitativeDetails()) {
      composeObservationDefinitionQuantitativeDetailsComponent(t, "ObservationDefinition", "quantitativeDetails", element.getQuantitativeDetails(), -1);
    }
    for (int i = 0; i < element.getQualifiedInterval().size(); i++) {
      composeObservationDefinitionQualifiedIntervalComponent(t, "ObservationDefinition", "qualifiedInterval", element.getQualifiedInterval().get(i), i);
    }
    if (element.hasValidCodedValueSet()) {
      composeReference(t, "ObservationDefinition", "validCodedValueSet", element.getValidCodedValueSet(), -1);
    }
    if (element.hasNormalCodedValueSet()) {
      composeReference(t, "ObservationDefinition", "normalCodedValueSet", element.getNormalCodedValueSet(), -1);
    }
    if (element.hasAbnormalCodedValueSet()) {
      composeReference(t, "ObservationDefinition", "abnormalCodedValueSet", element.getAbnormalCodedValueSet(), -1);
    }
    if (element.hasCriticalCodedValueSet()) {
      composeReference(t, "ObservationDefinition", "criticalCodedValueSet", element.getCriticalCodedValueSet(), -1);
    }
  }

  protected void composeObservationDefinitionQuantitativeDetailsComponent(Complex parent, String parentType, String name, ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "quantitativeDetails", name, element, index);
    if (element.hasCustomaryUnit()) {
      composeCodeableConcept(t, "ObservationDefinitionQuantitativeDetailsComponent", "customaryUnit", element.getCustomaryUnit(), -1);
    }
    if (element.hasUnit()) {
      composeCodeableConcept(t, "ObservationDefinitionQuantitativeDetailsComponent", "unit", element.getUnit(), -1);
    }
    if (element.hasConversionFactorElement()) {
      composeDecimal(t, "ObservationDefinitionQuantitativeDetailsComponent", "conversionFactor", element.getConversionFactorElement(), -1);
    }
    if (element.hasDecimalPrecisionElement()) {
      composeInteger(t, "ObservationDefinitionQuantitativeDetailsComponent", "decimalPrecision", element.getDecimalPrecisionElement(), -1);
    }
  }

  protected void composeObservationDefinitionQualifiedIntervalComponent(Complex parent, String parentType, String name, ObservationDefinition.ObservationDefinitionQualifiedIntervalComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "qualifiedInterval", name, element, index);
    if (element.hasCategoryElement()) {
      composeEnum(t, "ObservationDefinitionQualifiedIntervalComponent", "category", element.getCategoryElement(), -1);
    }
    if (element.hasRange()) {
      composeRange(t, "ObservationDefinitionQualifiedIntervalComponent", "range", element.getRange(), -1);
    }
    if (element.hasContext()) {
      composeCodeableConcept(t, "ObservationDefinitionQualifiedIntervalComponent", "context", element.getContext(), -1);
    }
    for (int i = 0; i < element.getAppliesTo().size(); i++) {
      composeCodeableConcept(t, "ObservationDefinitionQualifiedIntervalComponent", "appliesTo", element.getAppliesTo().get(i), i);
    }
    if (element.hasGenderElement()) {
      composeEnum(t, "ObservationDefinitionQualifiedIntervalComponent", "gender", element.getGenderElement(), -1);
    }
    if (element.hasAge()) {
      composeRange(t, "ObservationDefinitionQualifiedIntervalComponent", "age", element.getAge(), -1);
    }
    if (element.hasGestationalAge()) {
      composeRange(t, "ObservationDefinitionQualifiedIntervalComponent", "gestationalAge", element.getGestationalAge(), -1);
    }
    if (element.hasConditionElement()) {
      composeString(t, "ObservationDefinitionQualifiedIntervalComponent", "condition", element.getConditionElement(), -1);
    }
  }

  protected void composeOperationDefinition(Complex parent, String parentType, String name, OperationDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "OperationDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "OperationDefinition", "url", element.getUrlElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "OperationDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "OperationDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "OperationDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "OperationDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasKindElement()) {
      composeEnum(t, "OperationDefinition", "kind", element.getKindElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "OperationDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "OperationDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "OperationDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "OperationDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "OperationDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "OperationDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "OperationDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "OperationDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasAffectsStateElement()) {
      composeBoolean(t, "OperationDefinition", "affectsState", element.getAffectsStateElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeCode(t, "OperationDefinition", "code", element.getCodeElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeMarkdown(t, "OperationDefinition", "comment", element.getCommentElement(), -1);
    }
    if (element.hasBaseElement()) {
      composeCanonical(t, "OperationDefinition", "base", element.getBaseElement(), -1);
    }
    for (int i = 0; i < element.getResource().size(); i++) {
      composeCode(t, "OperationDefinition", "resource", element.getResource().get(i), i);
    }
    if (element.hasSystemElement()) {
      composeBoolean(t, "OperationDefinition", "system", element.getSystemElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeBoolean(t, "OperationDefinition", "type", element.getTypeElement(), -1);
    }
    if (element.hasInstanceElement()) {
      composeBoolean(t, "OperationDefinition", "instance", element.getInstanceElement(), -1);
    }
    if (element.hasInputProfileElement()) {
      composeCanonical(t, "OperationDefinition", "inputProfile", element.getInputProfileElement(), -1);
    }
    if (element.hasOutputProfileElement()) {
      composeCanonical(t, "OperationDefinition", "outputProfile", element.getOutputProfileElement(), -1);
    }
    for (int i = 0; i < element.getParameter().size(); i++) {
      composeOperationDefinitionParameterComponent(t, "OperationDefinition", "parameter", element.getParameter().get(i), i);
    }
    for (int i = 0; i < element.getOverload().size(); i++) {
      composeOperationDefinitionOverloadComponent(t, "OperationDefinition", "overload", element.getOverload().get(i), i);
    }
  }

  protected void composeOperationDefinitionParameterComponent(Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "parameter", name, element, index);
    if (element.hasNameElement()) {
      composeCode(t, "OperationDefinitionParameterComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasUseElement()) {
      composeEnum(t, "OperationDefinitionParameterComponent", "use", element.getUseElement(), -1);
    }
    if (element.hasMinElement()) {
      composeInteger(t, "OperationDefinitionParameterComponent", "min", element.getMinElement(), -1);
    }
    if (element.hasMaxElement()) {
      composeString(t, "OperationDefinitionParameterComponent", "max", element.getMaxElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeString(t, "OperationDefinitionParameterComponent", "documentation", element.getDocumentationElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "OperationDefinitionParameterComponent", "type", element.getTypeElement(), -1);
    }
    for (int i = 0; i < element.getTargetProfile().size(); i++) {
      composeCanonical(t, "OperationDefinitionParameterComponent", "targetProfile", element.getTargetProfile().get(i), i);
    }
    if (element.hasSearchTypeElement()) {
      composeEnum(t, "OperationDefinitionParameterComponent", "searchType", element.getSearchTypeElement(), -1);
    }
    if (element.hasBinding()) {
      composeOperationDefinitionParameterBindingComponent(t, "OperationDefinitionParameterComponent", "binding", element.getBinding(), -1);
    }
    for (int i = 0; i < element.getReferencedFrom().size(); i++) {
      composeOperationDefinitionParameterReferencedFromComponent(t, "OperationDefinitionParameterComponent", "referencedFrom", element.getReferencedFrom().get(i), i);
    }
    for (int i = 0; i < element.getPart().size(); i++) {
      composeOperationDefinitionParameterComponent(t, "OperationDefinitionParameterComponent", "part", element.getPart().get(i), i);
    }
  }

  protected void composeOperationDefinitionParameterBindingComponent(Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterBindingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "binding", name, element, index);
    if (element.hasStrengthElement()) {
      composeEnum(t, "OperationDefinitionParameterBindingComponent", "strength", element.getStrengthElement(), -1);
    }
    if (element.hasValueSetElement()) {
      composeCanonical(t, "OperationDefinitionParameterBindingComponent", "valueSet", element.getValueSetElement(), -1);
    }
  }

  protected void composeOperationDefinitionParameterReferencedFromComponent(Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterReferencedFromComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "referencedFrom", name, element, index);
    if (element.hasSourceElement()) {
      composeString(t, "OperationDefinitionParameterReferencedFromComponent", "source", element.getSourceElement(), -1);
    }
    if (element.hasSourceIdElement()) {
      composeString(t, "OperationDefinitionParameterReferencedFromComponent", "sourceId", element.getSourceIdElement(), -1);
    }
  }

  protected void composeOperationDefinitionOverloadComponent(Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionOverloadComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "overload", name, element, index);
    for (int i = 0; i < element.getParameterName().size(); i++) {
      composeString(t, "OperationDefinitionOverloadComponent", "parameterName", element.getParameterName().get(i), i);
    }
    if (element.hasCommentElement()) {
      composeString(t, "OperationDefinitionOverloadComponent", "comment", element.getCommentElement(), -1);
    }
  }

  protected void composeOperationOutcome(Complex parent, String parentType, String name, OperationOutcome element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "OperationOutcome", name, element, index);
    for (int i = 0; i < element.getIssue().size(); i++) {
      composeOperationOutcomeIssueComponent(t, "OperationOutcome", "issue", element.getIssue().get(i), i);
    }
  }

  protected void composeOperationOutcomeIssueComponent(Complex parent, String parentType, String name, OperationOutcome.OperationOutcomeIssueComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "issue", name, element, index);
    if (element.hasSeverityElement()) {
      composeEnum(t, "OperationOutcomeIssueComponent", "severity", element.getSeverityElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeEnum(t, "OperationOutcomeIssueComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasDetails()) {
      composeCodeableConcept(t, "OperationOutcomeIssueComponent", "details", element.getDetails(), -1);
    }
    if (element.hasDiagnosticsElement()) {
      composeString(t, "OperationOutcomeIssueComponent", "diagnostics", element.getDiagnosticsElement(), -1);
    }
    for (int i = 0; i < element.getLocation().size(); i++) {
      composeString(t, "OperationOutcomeIssueComponent", "location", element.getLocation().get(i), i);
    }
    for (int i = 0; i < element.getExpression().size(); i++) {
      composeString(t, "OperationOutcomeIssueComponent", "expression", element.getExpression().get(i), i);
    }
  }

  protected void composeOrganization(Complex parent, String parentType, String name, Organization element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Organization", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Organization", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "Organization", "active", element.getActiveElement(), -1);
    }
    for (int i = 0; i < element.getType().size(); i++) {
      composeCodeableConcept(t, "Organization", "type", element.getType().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "Organization", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getAlias().size(); i++) {
      composeString(t, "Organization", "alias", element.getAlias().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "Organization", "telecom", element.getTelecom().get(i), i);
    }
    for (int i = 0; i < element.getAddress().size(); i++) {
      composeAddress(t, "Organization", "address", element.getAddress().get(i), i);
    }
    if (element.hasPartOf()) {
      composeReference(t, "Organization", "partOf", element.getPartOf(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeOrganizationContactComponent(t, "Organization", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "Organization", "endpoint", element.getEndpoint().get(i), i);
    }
  }

  protected void composeOrganizationContactComponent(Complex parent, String parentType, String name, Organization.OrganizationContactComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "contact", name, element, index);
    if (element.hasPurpose()) {
      composeCodeableConcept(t, "OrganizationContactComponent", "purpose", element.getPurpose(), -1);
    }
    if (element.hasName()) {
      composeHumanName(t, "OrganizationContactComponent", "name", element.getName(), -1);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "OrganizationContactComponent", "telecom", element.getTelecom().get(i), i);
    }
    if (element.hasAddress()) {
      composeAddress(t, "OrganizationContactComponent", "address", element.getAddress(), -1);
    }
  }

  protected void composeOrganizationAffiliation(Complex parent, String parentType, String name, OrganizationAffiliation element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "OrganizationAffiliation", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "OrganizationAffiliation", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "OrganizationAffiliation", "active", element.getActiveElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "OrganizationAffiliation", "period", element.getPeriod(), -1);
    }
    if (element.hasOrganization()) {
      composeReference(t, "OrganizationAffiliation", "organization", element.getOrganization(), -1);
    }
    if (element.hasParticipatingOrganization()) {
      composeReference(t, "OrganizationAffiliation", "participatingOrganization", element.getParticipatingOrganization(), -1);
    }
    for (int i = 0; i < element.getNetwork().size(); i++) {
      composeReference(t, "OrganizationAffiliation", "network", element.getNetwork().get(i), i);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "OrganizationAffiliation", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getSpecialty().size(); i++) {
      composeCodeableConcept(t, "OrganizationAffiliation", "specialty", element.getSpecialty().get(i), i);
    }
    for (int i = 0; i < element.getLocation().size(); i++) {
      composeReference(t, "OrganizationAffiliation", "location", element.getLocation().get(i), i);
    }
    for (int i = 0; i < element.getHealthcareService().size(); i++) {
      composeReference(t, "OrganizationAffiliation", "healthcareService", element.getHealthcareService().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "OrganizationAffiliation", "telecom", element.getTelecom().get(i), i);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "OrganizationAffiliation", "endpoint", element.getEndpoint().get(i), i);
    }
  }

  protected void composePackagedProductDefinition(Complex parent, String parentType, String name, PackagedProductDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "PackagedProductDefinition", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "PackagedProductDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasNameElement()) {
      composeString(t, "PackagedProductDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "PackagedProductDefinition", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getPackageFor().size(); i++) {
      composeReference(t, "PackagedProductDefinition", "packageFor", element.getPackageFor().get(i), i);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "PackagedProductDefinition", "status", element.getStatus(), -1);
    }
    if (element.hasStatusDateElement()) {
      composeDateTime(t, "PackagedProductDefinition", "statusDate", element.getStatusDateElement(), -1);
    }
    for (int i = 0; i < element.getContainedItemQuantity().size(); i++) {
      composeQuantity(t, "PackagedProductDefinition", "containedItemQuantity", element.getContainedItemQuantity().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "PackagedProductDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getLegalStatusOfSupply().size(); i++) {
      composePackagedProductDefinitionLegalStatusOfSupplyComponent(t, "PackagedProductDefinition", "legalStatusOfSupply", element.getLegalStatusOfSupply().get(i), i);
    }
    for (int i = 0; i < element.getMarketingStatus().size(); i++) {
      composeMarketingStatus(t, "PackagedProductDefinition", "marketingStatus", element.getMarketingStatus().get(i), i);
    }
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composeCodeableConcept(t, "PackagedProductDefinition", "characteristic", element.getCharacteristic().get(i), i);
    }
    if (element.hasCopackagedIndicatorElement()) {
      composeBoolean(t, "PackagedProductDefinition", "copackagedIndicator", element.getCopackagedIndicatorElement(), -1);
    }
    for (int i = 0; i < element.getManufacturer().size(); i++) {
      composeReference(t, "PackagedProductDefinition", "manufacturer", element.getManufacturer().get(i), i);
    }
    if (element.hasPackage()) {
      composePackagedProductDefinitionPackageComponent(t, "PackagedProductDefinition", "package", element.getPackage(), -1);
    }
  }

  protected void composePackagedProductDefinitionLegalStatusOfSupplyComponent(Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionLegalStatusOfSupplyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "legalStatusOfSupply", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "PackagedProductDefinitionLegalStatusOfSupplyComponent", "code", element.getCode(), -1);
    }
    if (element.hasJurisdiction()) {
      composeCodeableConcept(t, "PackagedProductDefinitionLegalStatusOfSupplyComponent", "jurisdiction", element.getJurisdiction(), -1);
    }
  }

  protected void composePackagedProductDefinitionPackageComponent(Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionPackageComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "package", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "PackagedProductDefinitionPackageComponent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "PackagedProductDefinitionPackageComponent", "type", element.getType(), -1);
    }
    if (element.hasQuantityElement()) {
      composeInteger(t, "PackagedProductDefinitionPackageComponent", "quantity", element.getQuantityElement(), -1);
    }
    for (int i = 0; i < element.getMaterial().size(); i++) {
      composeCodeableConcept(t, "PackagedProductDefinitionPackageComponent", "material", element.getMaterial().get(i), i);
    }
    for (int i = 0; i < element.getAlternateMaterial().size(); i++) {
      composeCodeableConcept(t, "PackagedProductDefinitionPackageComponent", "alternateMaterial", element.getAlternateMaterial().get(i), i);
    }
    for (int i = 0; i < element.getShelfLifeStorage().size(); i++) {
      composeProductShelfLife(t, "PackagedProductDefinitionPackageComponent", "shelfLifeStorage", element.getShelfLifeStorage().get(i), i);
    }
    for (int i = 0; i < element.getManufacturer().size(); i++) {
      composeReference(t, "PackagedProductDefinitionPackageComponent", "manufacturer", element.getManufacturer().get(i), i);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composePackagedProductDefinitionPackagePropertyComponent(t, "PackagedProductDefinitionPackageComponent", "property", element.getProperty().get(i), i);
    }
    for (int i = 0; i < element.getContainedItem().size(); i++) {
      composePackagedProductDefinitionPackageContainedItemComponent(t, "PackagedProductDefinitionPackageComponent", "containedItem", element.getContainedItem().get(i), i);
    }
    for (int i = 0; i < element.getPackage().size(); i++) {
      composePackagedProductDefinitionPackageComponent(t, "PackagedProductDefinitionPackageComponent", "package", element.getPackage().get(i), i);
    }
  }

  protected void composePackagedProductDefinitionPackagePropertyComponent(Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionPackagePropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "PackagedProductDefinitionPackagePropertyComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "PackagedProductDefinitionPackagePropertyComponent", "value", element.getValue(), -1);
    }
  }

  protected void composePackagedProductDefinitionPackageContainedItemComponent(Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionPackageContainedItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "containedItem", name, element, index);
    if (element.hasItem()) {
      composeCodeableReference(t, "PackagedProductDefinitionPackageContainedItemComponent", "item", element.getItem(), -1);
    }
    if (element.hasAmount()) {
      composeQuantity(t, "PackagedProductDefinitionPackageContainedItemComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composeParameters(Complex parent, String parentType, String name, Parameters element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeResource(t, "Parameters", name, element, index);
    for (int i = 0; i < element.getParameter().size(); i++) {
      composeParametersParameterComponent(t, "Parameters", "parameter", element.getParameter().get(i), i);
    }
  }

  protected void composeParametersParameterComponent(Complex parent, String parentType, String name, Parameters.ParametersParameterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "parameter", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "ParametersParameterComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "ParametersParameterComponent", "value", element.getValue(), -1);
    }
    if (element.hasResource()) {
      composeResource(t, "ParametersParameterComponent", "resource", element.getResource(), -1);
    }
    for (int i = 0; i < element.getPart().size(); i++) {
      composeParametersParameterComponent(t, "ParametersParameterComponent", "part", element.getPart().get(i), i);
    }
  }

  protected void composePatient(Complex parent, String parentType, String name, Patient element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Patient", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Patient", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "Patient", "active", element.getActiveElement(), -1);
    }
    for (int i = 0; i < element.getName().size(); i++) {
      composeHumanName(t, "Patient", "name", element.getName().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "Patient", "telecom", element.getTelecom().get(i), i);
    }
    if (element.hasGenderElement()) {
      composeEnum(t, "Patient", "gender", element.getGenderElement(), -1);
    }
    if (element.hasBirthDateElement()) {
      composeDate(t, "Patient", "birthDate", element.getBirthDateElement(), -1);
    }
    if (element.hasDeceased()) {
      composeType(t, "Patient", "deceased", element.getDeceased(), -1);
    }
    for (int i = 0; i < element.getAddress().size(); i++) {
      composeAddress(t, "Patient", "address", element.getAddress().get(i), i);
    }
    if (element.hasMaritalStatus()) {
      composeCodeableConcept(t, "Patient", "maritalStatus", element.getMaritalStatus(), -1);
    }
    if (element.hasMultipleBirth()) {
      composeType(t, "Patient", "multipleBirth", element.getMultipleBirth(), -1);
    }
    for (int i = 0; i < element.getPhoto().size(); i++) {
      composeAttachment(t, "Patient", "photo", element.getPhoto().get(i), i);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composePatientContactComponent(t, "Patient", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getCommunication().size(); i++) {
      composePatientCommunicationComponent(t, "Patient", "communication", element.getCommunication().get(i), i);
    }
    for (int i = 0; i < element.getGeneralPractitioner().size(); i++) {
      composeReference(t, "Patient", "generalPractitioner", element.getGeneralPractitioner().get(i), i);
    }
    if (element.hasManagingOrganization()) {
      composeReference(t, "Patient", "managingOrganization", element.getManagingOrganization(), -1);
    }
    for (int i = 0; i < element.getLink().size(); i++) {
      composePatientLinkComponent(t, "Patient", "link", element.getLink().get(i), i);
    }
  }

  protected void composePatientContactComponent(Complex parent, String parentType, String name, Patient.ContactComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "contact", name, element, index);
    for (int i = 0; i < element.getRelationship().size(); i++) {
      composeCodeableConcept(t, "ContactComponent", "relationship", element.getRelationship().get(i), i);
    }
    if (element.hasName()) {
      composeHumanName(t, "ContactComponent", "name", element.getName(), -1);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "ContactComponent", "telecom", element.getTelecom().get(i), i);
    }
    if (element.hasAddress()) {
      composeAddress(t, "ContactComponent", "address", element.getAddress(), -1);
    }
    if (element.hasGenderElement()) {
      composeEnum(t, "ContactComponent", "gender", element.getGenderElement(), -1);
    }
    if (element.hasOrganization()) {
      composeReference(t, "ContactComponent", "organization", element.getOrganization(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ContactComponent", "period", element.getPeriod(), -1);
    }
  }

  protected void composePatientCommunicationComponent(Complex parent, String parentType, String name, Patient.PatientCommunicationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "communication", name, element, index);
    if (element.hasLanguage()) {
      composeCodeableConcept(t, "PatientCommunicationComponent", "language", element.getLanguage(), -1);
    }
    if (element.hasPreferredElement()) {
      composeBoolean(t, "PatientCommunicationComponent", "preferred", element.getPreferredElement(), -1);
    }
  }

  protected void composePatientLinkComponent(Complex parent, String parentType, String name, Patient.PatientLinkComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "link", name, element, index);
    if (element.hasOther()) {
      composeReference(t, "PatientLinkComponent", "other", element.getOther(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "PatientLinkComponent", "type", element.getTypeElement(), -1);
    }
  }

  protected void composePaymentNotice(Complex parent, String parentType, String name, PaymentNotice element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "PaymentNotice", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "PaymentNotice", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "PaymentNotice", "status", element.getStatusElement(), -1);
    }
    if (element.hasRequest()) {
      composeReference(t, "PaymentNotice", "request", element.getRequest(), -1);
    }
    if (element.hasResponse()) {
      composeReference(t, "PaymentNotice", "response", element.getResponse(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "PaymentNotice", "created", element.getCreatedElement(), -1);
    }
    if (element.hasProvider()) {
      composeReference(t, "PaymentNotice", "provider", element.getProvider(), -1);
    }
    if (element.hasPayment()) {
      composeReference(t, "PaymentNotice", "payment", element.getPayment(), -1);
    }
    if (element.hasPaymentDateElement()) {
      composeDate(t, "PaymentNotice", "paymentDate", element.getPaymentDateElement(), -1);
    }
    if (element.hasPayee()) {
      composeReference(t, "PaymentNotice", "payee", element.getPayee(), -1);
    }
    if (element.hasRecipient()) {
      composeReference(t, "PaymentNotice", "recipient", element.getRecipient(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "PaymentNotice", "amount", element.getAmount(), -1);
    }
    if (element.hasPaymentStatus()) {
      composeCodeableConcept(t, "PaymentNotice", "paymentStatus", element.getPaymentStatus(), -1);
    }
  }

  protected void composePaymentReconciliation(Complex parent, String parentType, String name, PaymentReconciliation element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "PaymentReconciliation", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "PaymentReconciliation", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "PaymentReconciliation", "status", element.getStatusElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "PaymentReconciliation", "period", element.getPeriod(), -1);
    }
    if (element.hasCreatedElement()) {
      composeDateTime(t, "PaymentReconciliation", "created", element.getCreatedElement(), -1);
    }
    if (element.hasPaymentIssuer()) {
      composeReference(t, "PaymentReconciliation", "paymentIssuer", element.getPaymentIssuer(), -1);
    }
    if (element.hasRequest()) {
      composeReference(t, "PaymentReconciliation", "request", element.getRequest(), -1);
    }
    if (element.hasRequestor()) {
      composeReference(t, "PaymentReconciliation", "requestor", element.getRequestor(), -1);
    }
    if (element.hasOutcomeElement()) {
      composeEnum(t, "PaymentReconciliation", "outcome", element.getOutcomeElement(), -1);
    }
    if (element.hasDispositionElement()) {
      composeString(t, "PaymentReconciliation", "disposition", element.getDispositionElement(), -1);
    }
    if (element.hasPaymentDateElement()) {
      composeDate(t, "PaymentReconciliation", "paymentDate", element.getPaymentDateElement(), -1);
    }
    if (element.hasPaymentAmount()) {
      composeMoney(t, "PaymentReconciliation", "paymentAmount", element.getPaymentAmount(), -1);
    }
    if (element.hasPaymentIdentifier()) {
      composeIdentifier(t, "PaymentReconciliation", "paymentIdentifier", element.getPaymentIdentifier(), -1);
    }
    for (int i = 0; i < element.getDetail().size(); i++) {
      composePaymentReconciliationDetailsComponent(t, "PaymentReconciliation", "detail", element.getDetail().get(i), i);
    }
    if (element.hasFormCode()) {
      composeCodeableConcept(t, "PaymentReconciliation", "formCode", element.getFormCode(), -1);
    }
    for (int i = 0; i < element.getProcessNote().size(); i++) {
      composePaymentReconciliationNotesComponent(t, "PaymentReconciliation", "processNote", element.getProcessNote().get(i), i);
    }
  }

  protected void composePaymentReconciliationDetailsComponent(Complex parent, String parentType, String name, PaymentReconciliation.DetailsComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "detail", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "DetailsComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasPredecessor()) {
      composeIdentifier(t, "DetailsComponent", "predecessor", element.getPredecessor(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "DetailsComponent", "type", element.getType(), -1);
    }
    if (element.hasRequest()) {
      composeReference(t, "DetailsComponent", "request", element.getRequest(), -1);
    }
    if (element.hasSubmitter()) {
      composeReference(t, "DetailsComponent", "submitter", element.getSubmitter(), -1);
    }
    if (element.hasResponse()) {
      composeReference(t, "DetailsComponent", "response", element.getResponse(), -1);
    }
    if (element.hasDateElement()) {
      composeDate(t, "DetailsComponent", "date", element.getDateElement(), -1);
    }
    if (element.hasResponsible()) {
      composeReference(t, "DetailsComponent", "responsible", element.getResponsible(), -1);
    }
    if (element.hasPayee()) {
      composeReference(t, "DetailsComponent", "payee", element.getPayee(), -1);
    }
    if (element.hasAmount()) {
      composeMoney(t, "DetailsComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composePaymentReconciliationNotesComponent(Complex parent, String parentType, String name, PaymentReconciliation.NotesComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "processNote", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "NotesComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "NotesComponent", "text", element.getTextElement(), -1);
    }
  }

  protected void composePerson(Complex parent, String parentType, String name, Person element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Person", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Person", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getName().size(); i++) {
      composeHumanName(t, "Person", "name", element.getName().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "Person", "telecom", element.getTelecom().get(i), i);
    }
    if (element.hasGenderElement()) {
      composeEnum(t, "Person", "gender", element.getGenderElement(), -1);
    }
    if (element.hasBirthDateElement()) {
      composeDate(t, "Person", "birthDate", element.getBirthDateElement(), -1);
    }
    for (int i = 0; i < element.getAddress().size(); i++) {
      composeAddress(t, "Person", "address", element.getAddress().get(i), i);
    }
    if (element.hasPhoto()) {
      composeAttachment(t, "Person", "photo", element.getPhoto(), -1);
    }
    if (element.hasManagingOrganization()) {
      composeReference(t, "Person", "managingOrganization", element.getManagingOrganization(), -1);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "Person", "active", element.getActiveElement(), -1);
    }
    for (int i = 0; i < element.getLink().size(); i++) {
      composePersonLinkComponent(t, "Person", "link", element.getLink().get(i), i);
    }
  }

  protected void composePersonLinkComponent(Complex parent, String parentType, String name, Person.PersonLinkComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "link", name, element, index);
    if (element.hasTarget()) {
      composeReference(t, "PersonLinkComponent", "target", element.getTarget(), -1);
    }
    if (element.hasAssuranceElement()) {
      composeEnum(t, "PersonLinkComponent", "assurance", element.getAssuranceElement(), -1);
    }
  }

  protected void composePlanDefinition(Complex parent, String parentType, String name, PlanDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "PlanDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "PlanDefinition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "PlanDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "PlanDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "PlanDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "PlanDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "PlanDefinition", "subtitle", element.getSubtitleElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "PlanDefinition", "type", element.getType(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "PlanDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "PlanDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasSubject()) {
      composeType(t, "PlanDefinition", "subject", element.getSubject(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "PlanDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "PlanDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "PlanDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "PlanDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "PlanDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "PlanDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "PlanDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasUsageElement()) {
      composeString(t, "PlanDefinition", "usage", element.getUsageElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "PlanDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "PlanDefinition", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "PlanDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "PlanDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "PlanDefinition", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "PlanDefinition", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "PlanDefinition", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "PlanDefinition", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "PlanDefinition", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "PlanDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    for (int i = 0; i < element.getLibrary().size(); i++) {
      composeCanonical(t, "PlanDefinition", "library", element.getLibrary().get(i), i);
    }
    for (int i = 0; i < element.getGoal().size(); i++) {
      composePlanDefinitionGoalComponent(t, "PlanDefinition", "goal", element.getGoal().get(i), i);
    }
    for (int i = 0; i < element.getAction().size(); i++) {
      composePlanDefinitionActionComponent(t, "PlanDefinition", "action", element.getAction().get(i), i);
    }
  }

  protected void composePlanDefinitionGoalComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionGoalComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "goal", name, element, index);
    if (element.hasCategory()) {
      composeCodeableConcept(t, "PlanDefinitionGoalComponent", "category", element.getCategory(), -1);
    }
    if (element.hasDescription()) {
      composeCodeableConcept(t, "PlanDefinitionGoalComponent", "description", element.getDescription(), -1);
    }
    if (element.hasPriority()) {
      composeCodeableConcept(t, "PlanDefinitionGoalComponent", "priority", element.getPriority(), -1);
    }
    if (element.hasStart()) {
      composeCodeableConcept(t, "PlanDefinitionGoalComponent", "start", element.getStart(), -1);
    }
    for (int i = 0; i < element.getAddresses().size(); i++) {
      composeCodeableConcept(t, "PlanDefinitionGoalComponent", "addresses", element.getAddresses().get(i), i);
    }
    for (int i = 0; i < element.getDocumentation().size(); i++) {
      composeRelatedArtifact(t, "PlanDefinitionGoalComponent", "documentation", element.getDocumentation().get(i), i);
    }
    for (int i = 0; i < element.getTarget().size(); i++) {
      composePlanDefinitionGoalTargetComponent(t, "PlanDefinitionGoalComponent", "target", element.getTarget().get(i), i);
    }
  }

  protected void composePlanDefinitionGoalTargetComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionGoalTargetComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "target", name, element, index);
    if (element.hasMeasure()) {
      composeCodeableConcept(t, "PlanDefinitionGoalTargetComponent", "measure", element.getMeasure(), -1);
    }
    if (element.hasDetail()) {
      composeType(t, "PlanDefinitionGoalTargetComponent", "detail", element.getDetail(), -1);
    }
    if (element.hasDue()) {
      composeDuration(t, "PlanDefinitionGoalTargetComponent", "due", element.getDue(), -1);
    }
  }

  protected void composePlanDefinitionActionComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "action", name, element, index);
    if (element.hasPrefixElement()) {
      composeString(t, "PlanDefinitionActionComponent", "prefix", element.getPrefixElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "PlanDefinitionActionComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "PlanDefinitionActionComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasTextEquivalentElement()) {
      composeString(t, "PlanDefinitionActionComponent", "textEquivalent", element.getTextEquivalentElement(), -1);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "PlanDefinitionActionComponent", "priority", element.getPriorityElement(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "PlanDefinitionActionComponent", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableConcept(t, "PlanDefinitionActionComponent", "reason", element.getReason().get(i), i);
    }
    for (int i = 0; i < element.getDocumentation().size(); i++) {
      composeRelatedArtifact(t, "PlanDefinitionActionComponent", "documentation", element.getDocumentation().get(i), i);
    }
    for (int i = 0; i < element.getGoalId().size(); i++) {
      composeId(t, "PlanDefinitionActionComponent", "goalId", element.getGoalId().get(i), i);
    }
    if (element.hasSubject()) {
      composeType(t, "PlanDefinitionActionComponent", "subject", element.getSubject(), -1);
    }
    for (int i = 0; i < element.getTrigger().size(); i++) {
      composeTriggerDefinition(t, "PlanDefinitionActionComponent", "trigger", element.getTrigger().get(i), i);
    }
    for (int i = 0; i < element.getCondition().size(); i++) {
      composePlanDefinitionActionConditionComponent(t, "PlanDefinitionActionComponent", "condition", element.getCondition().get(i), i);
    }
    for (int i = 0; i < element.getInput().size(); i++) {
      composeDataRequirement(t, "PlanDefinitionActionComponent", "input", element.getInput().get(i), i);
    }
    for (int i = 0; i < element.getOutput().size(); i++) {
      composeDataRequirement(t, "PlanDefinitionActionComponent", "output", element.getOutput().get(i), i);
    }
    for (int i = 0; i < element.getRelatedAction().size(); i++) {
      composePlanDefinitionActionRelatedActionComponent(t, "PlanDefinitionActionComponent", "relatedAction", element.getRelatedAction().get(i), i);
    }
    if (element.hasTiming()) {
      composeType(t, "PlanDefinitionActionComponent", "timing", element.getTiming(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composePlanDefinitionActionParticipantComponent(t, "PlanDefinitionActionComponent", "participant", element.getParticipant().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "PlanDefinitionActionComponent", "type", element.getType(), -1);
    }
    if (element.hasGroupingBehaviorElement()) {
      composeEnum(t, "PlanDefinitionActionComponent", "groupingBehavior", element.getGroupingBehaviorElement(), -1);
    }
    if (element.hasSelectionBehaviorElement()) {
      composeEnum(t, "PlanDefinitionActionComponent", "selectionBehavior", element.getSelectionBehaviorElement(), -1);
    }
    if (element.hasRequiredBehaviorElement()) {
      composeEnum(t, "PlanDefinitionActionComponent", "requiredBehavior", element.getRequiredBehaviorElement(), -1);
    }
    if (element.hasPrecheckBehaviorElement()) {
      composeEnum(t, "PlanDefinitionActionComponent", "precheckBehavior", element.getPrecheckBehaviorElement(), -1);
    }
    if (element.hasCardinalityBehaviorElement()) {
      composeEnum(t, "PlanDefinitionActionComponent", "cardinalityBehavior", element.getCardinalityBehaviorElement(), -1);
    }
    if (element.hasDefinition()) {
      composeType(t, "PlanDefinitionActionComponent", "definition", element.getDefinition(), -1);
    }
    if (element.hasTransformElement()) {
      composeCanonical(t, "PlanDefinitionActionComponent", "transform", element.getTransformElement(), -1);
    }
    for (int i = 0; i < element.getDynamicValue().size(); i++) {
      composePlanDefinitionActionDynamicValueComponent(t, "PlanDefinitionActionComponent", "dynamicValue", element.getDynamicValue().get(i), i);
    }
    for (int i = 0; i < element.getAction().size(); i++) {
      composePlanDefinitionActionComponent(t, "PlanDefinitionActionComponent", "action", element.getAction().get(i), i);
    }
  }

  protected void composePlanDefinitionActionConditionComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionConditionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "condition", name, element, index);
    if (element.hasKindElement()) {
      composeEnum(t, "PlanDefinitionActionConditionComponent", "kind", element.getKindElement(), -1);
    }
    if (element.hasExpression()) {
      composeExpression(t, "PlanDefinitionActionConditionComponent", "expression", element.getExpression(), -1);
    }
  }

  protected void composePlanDefinitionActionRelatedActionComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionRelatedActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatedAction", name, element, index);
    if (element.hasActionIdElement()) {
      composeId(t, "PlanDefinitionActionRelatedActionComponent", "actionId", element.getActionIdElement(), -1);
    }
    if (element.hasRelationshipElement()) {
      composeEnum(t, "PlanDefinitionActionRelatedActionComponent", "relationship", element.getRelationshipElement(), -1);
    }
    if (element.hasOffset()) {
      composeType(t, "PlanDefinitionActionRelatedActionComponent", "offset", element.getOffset(), -1);
    }
  }

  protected void composePlanDefinitionActionParticipantComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "PlanDefinitionActionParticipantComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasRole()) {
      composeCodeableConcept(t, "PlanDefinitionActionParticipantComponent", "role", element.getRole(), -1);
    }
  }

  protected void composePlanDefinitionActionDynamicValueComponent(Complex parent, String parentType, String name, PlanDefinition.PlanDefinitionActionDynamicValueComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dynamicValue", name, element, index);
    if (element.hasPathElement()) {
      composeString(t, "PlanDefinitionActionDynamicValueComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasExpression()) {
      composeExpression(t, "PlanDefinitionActionDynamicValueComponent", "expression", element.getExpression(), -1);
    }
  }

  protected void composePractitioner(Complex parent, String parentType, String name, Practitioner element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Practitioner", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Practitioner", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "Practitioner", "active", element.getActiveElement(), -1);
    }
    for (int i = 0; i < element.getName().size(); i++) {
      composeHumanName(t, "Practitioner", "name", element.getName().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "Practitioner", "telecom", element.getTelecom().get(i), i);
    }
    for (int i = 0; i < element.getAddress().size(); i++) {
      composeAddress(t, "Practitioner", "address", element.getAddress().get(i), i);
    }
    if (element.hasGenderElement()) {
      composeEnum(t, "Practitioner", "gender", element.getGenderElement(), -1);
    }
    if (element.hasBirthDateElement()) {
      composeDate(t, "Practitioner", "birthDate", element.getBirthDateElement(), -1);
    }
    for (int i = 0; i < element.getPhoto().size(); i++) {
      composeAttachment(t, "Practitioner", "photo", element.getPhoto().get(i), i);
    }
    for (int i = 0; i < element.getQualification().size(); i++) {
      composePractitionerQualificationComponent(t, "Practitioner", "qualification", element.getQualification().get(i), i);
    }
    for (int i = 0; i < element.getCommunication().size(); i++) {
      composeCodeableConcept(t, "Practitioner", "communication", element.getCommunication().get(i), i);
    }
  }

  protected void composePractitionerQualificationComponent(Complex parent, String parentType, String name, Practitioner.PractitionerQualificationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "qualification", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "PractitionerQualificationComponent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "PractitionerQualificationComponent", "code", element.getCode(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "PractitionerQualificationComponent", "period", element.getPeriod(), -1);
    }
    if (element.hasIssuer()) {
      composeReference(t, "PractitionerQualificationComponent", "issuer", element.getIssuer(), -1);
    }
  }

  protected void composePractitionerRole(Complex parent, String parentType, String name, PractitionerRole element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "PractitionerRole", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "PractitionerRole", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "PractitionerRole", "active", element.getActiveElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "PractitionerRole", "period", element.getPeriod(), -1);
    }
    if (element.hasPractitioner()) {
      composeReference(t, "PractitionerRole", "practitioner", element.getPractitioner(), -1);
    }
    if (element.hasOrganization()) {
      composeReference(t, "PractitionerRole", "organization", element.getOrganization(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "PractitionerRole", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getSpecialty().size(); i++) {
      composeCodeableConcept(t, "PractitionerRole", "specialty", element.getSpecialty().get(i), i);
    }
    for (int i = 0; i < element.getLocation().size(); i++) {
      composeReference(t, "PractitionerRole", "location", element.getLocation().get(i), i);
    }
    for (int i = 0; i < element.getHealthcareService().size(); i++) {
      composeReference(t, "PractitionerRole", "healthcareService", element.getHealthcareService().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "PractitionerRole", "telecom", element.getTelecom().get(i), i);
    }
    for (int i = 0; i < element.getAvailableTime().size(); i++) {
      composePractitionerRoleAvailableTimeComponent(t, "PractitionerRole", "availableTime", element.getAvailableTime().get(i), i);
    }
    for (int i = 0; i < element.getNotAvailable().size(); i++) {
      composePractitionerRoleNotAvailableComponent(t, "PractitionerRole", "notAvailable", element.getNotAvailable().get(i), i);
    }
    if (element.hasAvailabilityExceptionsElement()) {
      composeString(t, "PractitionerRole", "availabilityExceptions", element.getAvailabilityExceptionsElement(), -1);
    }
    for (int i = 0; i < element.getEndpoint().size(); i++) {
      composeReference(t, "PractitionerRole", "endpoint", element.getEndpoint().get(i), i);
    }
  }

  protected void composePractitionerRoleAvailableTimeComponent(Complex parent, String parentType, String name, PractitionerRole.PractitionerRoleAvailableTimeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "availableTime", name, element, index);
    for (int i = 0; i < element.getDaysOfWeek().size(); i++) {
      composeEnum(t, "PractitionerRoleAvailableTimeComponent", "daysOfWeek", element.getDaysOfWeek().get(i), i);
    }
    if (element.hasAllDayElement()) {
      composeBoolean(t, "PractitionerRoleAvailableTimeComponent", "allDay", element.getAllDayElement(), -1);
    }
    if (element.hasAvailableStartTimeElement()) {
      composeTime(t, "PractitionerRoleAvailableTimeComponent", "availableStartTime", element.getAvailableStartTimeElement(), -1);
    }
    if (element.hasAvailableEndTimeElement()) {
      composeTime(t, "PractitionerRoleAvailableTimeComponent", "availableEndTime", element.getAvailableEndTimeElement(), -1);
    }
  }

  protected void composePractitionerRoleNotAvailableComponent(Complex parent, String parentType, String name, PractitionerRole.PractitionerRoleNotAvailableComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "notAvailable", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "PractitionerRoleNotAvailableComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasDuring()) {
      composePeriod(t, "PractitionerRoleNotAvailableComponent", "during", element.getDuring(), -1);
    }
  }

  protected void composeProcedure(Complex parent, String parentType, String name, Procedure element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Procedure", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Procedure", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "Procedure", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "Procedure", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "Procedure", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "Procedure", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Procedure", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept(t, "Procedure", "statusReason", element.getStatusReason(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "Procedure", "category", element.getCategory(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Procedure", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "Procedure", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Procedure", "encounter", element.getEncounter(), -1);
    }
    if (element.hasPerformed()) {
      composeType(t, "Procedure", "performed", element.getPerformed(), -1);
    }
    if (element.hasRecorder()) {
      composeReference(t, "Procedure", "recorder", element.getRecorder(), -1);
    }
    if (element.hasAsserter()) {
      composeReference(t, "Procedure", "asserter", element.getAsserter(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeProcedurePerformerComponent(t, "Procedure", "performer", element.getPerformer().get(i), i);
    }
    if (element.hasLocation()) {
      composeReference(t, "Procedure", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "Procedure", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "Procedure", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getBodySite().size(); i++) {
      composeCodeableConcept(t, "Procedure", "bodySite", element.getBodySite().get(i), i);
    }
    if (element.hasOutcome()) {
      composeCodeableConcept(t, "Procedure", "outcome", element.getOutcome(), -1);
    }
    for (int i = 0; i < element.getReport().size(); i++) {
      composeReference(t, "Procedure", "report", element.getReport().get(i), i);
    }
    for (int i = 0; i < element.getComplication().size(); i++) {
      composeCodeableConcept(t, "Procedure", "complication", element.getComplication().get(i), i);
    }
    for (int i = 0; i < element.getComplicationDetail().size(); i++) {
      composeReference(t, "Procedure", "complicationDetail", element.getComplicationDetail().get(i), i);
    }
    for (int i = 0; i < element.getFollowUp().size(); i++) {
      composeCodeableConcept(t, "Procedure", "followUp", element.getFollowUp().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Procedure", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getFocalDevice().size(); i++) {
      composeProcedureFocalDeviceComponent(t, "Procedure", "focalDevice", element.getFocalDevice().get(i), i);
    }
    for (int i = 0; i < element.getUsedReference().size(); i++) {
      composeReference(t, "Procedure", "usedReference", element.getUsedReference().get(i), i);
    }
    for (int i = 0; i < element.getUsedCode().size(); i++) {
      composeCodeableConcept(t, "Procedure", "usedCode", element.getUsedCode().get(i), i);
    }
  }

  protected void composeProcedurePerformerComponent(Complex parent, String parentType, String name, Procedure.ProcedurePerformerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "performer", name, element, index);
    if (element.hasFunction()) {
      composeCodeableConcept(t, "ProcedurePerformerComponent", "function", element.getFunction(), -1);
    }
    if (element.hasActor()) {
      composeReference(t, "ProcedurePerformerComponent", "actor", element.getActor(), -1);
    }
    if (element.hasOnBehalfOf()) {
      composeReference(t, "ProcedurePerformerComponent", "onBehalfOf", element.getOnBehalfOf(), -1);
    }
  }

  protected void composeProcedureFocalDeviceComponent(Complex parent, String parentType, String name, Procedure.ProcedureFocalDeviceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "focalDevice", name, element, index);
    if (element.hasAction()) {
      composeCodeableConcept(t, "ProcedureFocalDeviceComponent", "action", element.getAction(), -1);
    }
    if (element.hasManipulated()) {
      composeReference(t, "ProcedureFocalDeviceComponent", "manipulated", element.getManipulated(), -1);
    }
  }

  protected void composeProvenance(Complex parent, String parentType, String name, Provenance element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Provenance", name, element, index);
    for (int i = 0; i < element.getTarget().size(); i++) {
      composeReference(t, "Provenance", "target", element.getTarget().get(i), i);
    }
    if (element.hasOccurred()) {
      composeType(t, "Provenance", "occurred", element.getOccurred(), -1);
    }
    if (element.hasRecordedElement()) {
      composeInstant(t, "Provenance", "recorded", element.getRecordedElement(), -1);
    }
    for (int i = 0; i < element.getPolicy().size(); i++) {
      composeUri(t, "Provenance", "policy", element.getPolicy().get(i), i);
    }
    if (element.hasLocation()) {
      composeReference(t, "Provenance", "location", element.getLocation(), -1);
    }
    for (int i = 0; i < element.getReason().size(); i++) {
      composeCodeableConcept(t, "Provenance", "reason", element.getReason().get(i), i);
    }
    if (element.hasActivity()) {
      composeCodeableConcept(t, "Provenance", "activity", element.getActivity(), -1);
    }
    for (int i = 0; i < element.getAgent().size(); i++) {
      composeProvenanceAgentComponent(t, "Provenance", "agent", element.getAgent().get(i), i);
    }
    for (int i = 0; i < element.getEntity().size(); i++) {
      composeProvenanceEntityComponent(t, "Provenance", "entity", element.getEntity().get(i), i);
    }
    for (int i = 0; i < element.getSignature().size(); i++) {
      composeSignature(t, "Provenance", "signature", element.getSignature().get(i), i);
    }
  }

  protected void composeProvenanceAgentComponent(Complex parent, String parentType, String name, Provenance.ProvenanceAgentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "agent", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ProvenanceAgentComponent", "type", element.getType(), -1);
    }
    for (int i = 0; i < element.getRole().size(); i++) {
      composeCodeableConcept(t, "ProvenanceAgentComponent", "role", element.getRole().get(i), i);
    }
    if (element.hasWho()) {
      composeReference(t, "ProvenanceAgentComponent", "who", element.getWho(), -1);
    }
    if (element.hasOnBehalfOf()) {
      composeReference(t, "ProvenanceAgentComponent", "onBehalfOf", element.getOnBehalfOf(), -1);
    }
  }

  protected void composeProvenanceEntityComponent(Complex parent, String parentType, String name, Provenance.ProvenanceEntityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "entity", name, element, index);
    if (element.hasRoleElement()) {
      composeEnum(t, "ProvenanceEntityComponent", "role", element.getRoleElement(), -1);
    }
    if (element.hasWhat()) {
      composeReference(t, "ProvenanceEntityComponent", "what", element.getWhat(), -1);
    }
    for (int i = 0; i < element.getAgent().size(); i++) {
      composeProvenanceAgentComponent(t, "ProvenanceEntityComponent", "agent", element.getAgent().get(i), i);
    }
  }

  protected void composeQuestionnaire(Complex parent, String parentType, String name, Questionnaire element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Questionnaire", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "Questionnaire", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Questionnaire", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "Questionnaire", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "Questionnaire", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "Questionnaire", "title", element.getTitleElement(), -1);
    }
    for (int i = 0; i < element.getDerivedFrom().size(); i++) {
      composeCanonical(t, "Questionnaire", "derivedFrom", element.getDerivedFrom().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Questionnaire", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "Questionnaire", "experimental", element.getExperimentalElement(), -1);
    }
    for (int i = 0; i < element.getSubjectType().size(); i++) {
      composeCode(t, "Questionnaire", "subjectType", element.getSubjectType().get(i), i);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "Questionnaire", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "Questionnaire", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "Questionnaire", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "Questionnaire", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "Questionnaire", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "Questionnaire", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "Questionnaire", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "Questionnaire", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "Questionnaire", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "Questionnaire", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "Questionnaire", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCoding(t, "Questionnaire", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeQuestionnaireItemComponent(t, "Questionnaire", "item", element.getItem().get(i), i);
    }
  }

  protected void composeQuestionnaireItemComponent(Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    if (element.hasLinkIdElement()) {
      composeString(t, "QuestionnaireItemComponent", "linkId", element.getLinkIdElement(), -1);
    }
    if (element.hasDefinitionElement()) {
      composeUri(t, "QuestionnaireItemComponent", "definition", element.getDefinitionElement(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCoding(t, "QuestionnaireItemComponent", "code", element.getCode().get(i), i);
    }
    if (element.hasPrefixElement()) {
      composeString(t, "QuestionnaireItemComponent", "prefix", element.getPrefixElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "QuestionnaireItemComponent", "text", element.getTextElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "QuestionnaireItemComponent", "type", element.getTypeElement(), -1);
    }
    for (int i = 0; i < element.getEnableWhen().size(); i++) {
      composeQuestionnaireItemEnableWhenComponent(t, "QuestionnaireItemComponent", "enableWhen", element.getEnableWhen().get(i), i);
    }
    if (element.hasEnableBehaviorElement()) {
      composeEnum(t, "QuestionnaireItemComponent", "enableBehavior", element.getEnableBehaviorElement(), -1);
    }
    if (element.hasRequiredElement()) {
      composeBoolean(t, "QuestionnaireItemComponent", "required", element.getRequiredElement(), -1);
    }
    if (element.hasRepeatsElement()) {
      composeBoolean(t, "QuestionnaireItemComponent", "repeats", element.getRepeatsElement(), -1);
    }
    if (element.hasReadOnlyElement()) {
      composeBoolean(t, "QuestionnaireItemComponent", "readOnly", element.getReadOnlyElement(), -1);
    }
    if (element.hasMaxLengthElement()) {
      composeInteger(t, "QuestionnaireItemComponent", "maxLength", element.getMaxLengthElement(), -1);
    }
    if (element.hasAnswerValueSetElement()) {
      composeCanonical(t, "QuestionnaireItemComponent", "answerValueSet", element.getAnswerValueSetElement(), -1);
    }
    for (int i = 0; i < element.getAnswerOption().size(); i++) {
      composeQuestionnaireItemAnswerOptionComponent(t, "QuestionnaireItemComponent", "answerOption", element.getAnswerOption().get(i), i);
    }
    for (int i = 0; i < element.getInitial().size(); i++) {
      composeQuestionnaireItemInitialComponent(t, "QuestionnaireItemComponent", "initial", element.getInitial().get(i), i);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeQuestionnaireItemComponent(t, "QuestionnaireItemComponent", "item", element.getItem().get(i), i);
    }
  }

  protected void composeQuestionnaireItemEnableWhenComponent(Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemEnableWhenComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "enableWhen", name, element, index);
    if (element.hasQuestionElement()) {
      composeString(t, "QuestionnaireItemEnableWhenComponent", "question", element.getQuestionElement(), -1);
    }
    if (element.hasOperatorElement()) {
      composeEnum(t, "QuestionnaireItemEnableWhenComponent", "operator", element.getOperatorElement(), -1);
    }
    if (element.hasAnswer()) {
      composeType(t, "QuestionnaireItemEnableWhenComponent", "answer", element.getAnswer(), -1);
    }
  }

  protected void composeQuestionnaireItemAnswerOptionComponent(Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemAnswerOptionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "answerOption", name, element, index);
    if (element.hasValue()) {
      composeType(t, "QuestionnaireItemAnswerOptionComponent", "value", element.getValue(), -1);
    }
    if (element.hasInitialSelectedElement()) {
      composeBoolean(t, "QuestionnaireItemAnswerOptionComponent", "initialSelected", element.getInitialSelectedElement(), -1);
    }
  }

  protected void composeQuestionnaireItemInitialComponent(Complex parent, String parentType, String name, Questionnaire.QuestionnaireItemInitialComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "initial", name, element, index);
    if (element.hasValue()) {
      composeType(t, "QuestionnaireItemInitialComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeQuestionnaireResponse(Complex parent, String parentType, String name, QuestionnaireResponse element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "QuestionnaireResponse", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "QuestionnaireResponse", "identifier", element.getIdentifier(), -1);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "QuestionnaireResponse", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "QuestionnaireResponse", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasQuestionnaireElement()) {
      composeCanonical(t, "QuestionnaireResponse", "questionnaire", element.getQuestionnaireElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "QuestionnaireResponse", "status", element.getStatusElement(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "QuestionnaireResponse", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "QuestionnaireResponse", "encounter", element.getEncounter(), -1);
    }
    if (element.hasAuthoredElement()) {
      composeDateTime(t, "QuestionnaireResponse", "authored", element.getAuthoredElement(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "QuestionnaireResponse", "author", element.getAuthor(), -1);
    }
    if (element.hasSource()) {
      composeReference(t, "QuestionnaireResponse", "source", element.getSource(), -1);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeQuestionnaireResponseItemComponent(t, "QuestionnaireResponse", "item", element.getItem().get(i), i);
    }
  }

  protected void composeQuestionnaireResponseItemComponent(Complex parent, String parentType, String name, QuestionnaireResponse.QuestionnaireResponseItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "item", name, element, index);
    if (element.hasLinkIdElement()) {
      composeString(t, "QuestionnaireResponseItemComponent", "linkId", element.getLinkIdElement(), -1);
    }
    if (element.hasDefinitionElement()) {
      composeUri(t, "QuestionnaireResponseItemComponent", "definition", element.getDefinitionElement(), -1);
    }
    if (element.hasTextElement()) {
      composeString(t, "QuestionnaireResponseItemComponent", "text", element.getTextElement(), -1);
    }
    for (int i = 0; i < element.getAnswer().size(); i++) {
      composeQuestionnaireResponseItemAnswerComponent(t, "QuestionnaireResponseItemComponent", "answer", element.getAnswer().get(i), i);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeQuestionnaireResponseItemComponent(t, "QuestionnaireResponseItemComponent", "item", element.getItem().get(i), i);
    }
  }

  protected void composeQuestionnaireResponseItemAnswerComponent(Complex parent, String parentType, String name, QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "answer", name, element, index);
    if (element.hasValue()) {
      composeType(t, "QuestionnaireResponseItemAnswerComponent", "value", element.getValue(), -1);
    }
    for (int i = 0; i < element.getItem().size(); i++) {
      composeQuestionnaireResponseItemComponent(t, "QuestionnaireResponseItemAnswerComponent", "item", element.getItem().get(i), i);
    }
  }

  protected void composeRegulatedAuthorization(Complex parent, String parentType, String name, RegulatedAuthorization element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "RegulatedAuthorization", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "RegulatedAuthorization", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getSubject().size(); i++) {
      composeReference(t, "RegulatedAuthorization", "subject", element.getSubject().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "RegulatedAuthorization", "type", element.getType(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "RegulatedAuthorization", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getRegion().size(); i++) {
      composeCodeableConcept(t, "RegulatedAuthorization", "region", element.getRegion().get(i), i);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "RegulatedAuthorization", "status", element.getStatus(), -1);
    }
    if (element.hasStatusDateElement()) {
      composeDateTime(t, "RegulatedAuthorization", "statusDate", element.getStatusDateElement(), -1);
    }
    if (element.hasValidityPeriod()) {
      composePeriod(t, "RegulatedAuthorization", "validityPeriod", element.getValidityPeriod(), -1);
    }
    if (element.hasIndication()) {
      composeCodeableReference(t, "RegulatedAuthorization", "indication", element.getIndication(), -1);
    }
    if (element.hasIntendedUse()) {
      composeCodeableConcept(t, "RegulatedAuthorization", "intendedUse", element.getIntendedUse(), -1);
    }
    for (int i = 0; i < element.getBasis().size(); i++) {
      composeCodeableConcept(t, "RegulatedAuthorization", "basis", element.getBasis().get(i), i);
    }
    if (element.hasHolder()) {
      composeReference(t, "RegulatedAuthorization", "holder", element.getHolder(), -1);
    }
    if (element.hasRegulator()) {
      composeReference(t, "RegulatedAuthorization", "regulator", element.getRegulator(), -1);
    }
    if (element.hasCase()) {
      composeRegulatedAuthorizationCaseComponent(t, "RegulatedAuthorization", "case", element.getCase(), -1);
    }
  }

  protected void composeRegulatedAuthorizationCaseComponent(Complex parent, String parentType, String name, RegulatedAuthorization.RegulatedAuthorizationCaseComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "case", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "RegulatedAuthorizationCaseComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "RegulatedAuthorizationCaseComponent", "type", element.getType(), -1);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "RegulatedAuthorizationCaseComponent", "status", element.getStatus(), -1);
    }
    if (element.hasDate()) {
      composeType(t, "RegulatedAuthorizationCaseComponent", "date", element.getDate(), -1);
    }
    for (int i = 0; i < element.getApplication().size(); i++) {
      composeRegulatedAuthorizationCaseComponent(t, "RegulatedAuthorizationCaseComponent", "application", element.getApplication().get(i), i);
    }
  }

  protected void composeRelatedPerson(Complex parent, String parentType, String name, RelatedPerson element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "RelatedPerson", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "RelatedPerson", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "RelatedPerson", "active", element.getActiveElement(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "RelatedPerson", "patient", element.getPatient(), -1);
    }
    for (int i = 0; i < element.getRelationship().size(); i++) {
      composeCodeableConcept(t, "RelatedPerson", "relationship", element.getRelationship().get(i), i);
    }
    for (int i = 0; i < element.getName().size(); i++) {
      composeHumanName(t, "RelatedPerson", "name", element.getName().get(i), i);
    }
    for (int i = 0; i < element.getTelecom().size(); i++) {
      composeContactPoint(t, "RelatedPerson", "telecom", element.getTelecom().get(i), i);
    }
    if (element.hasGenderElement()) {
      composeEnum(t, "RelatedPerson", "gender", element.getGenderElement(), -1);
    }
    if (element.hasBirthDateElement()) {
      composeDate(t, "RelatedPerson", "birthDate", element.getBirthDateElement(), -1);
    }
    for (int i = 0; i < element.getAddress().size(); i++) {
      composeAddress(t, "RelatedPerson", "address", element.getAddress().get(i), i);
    }
    for (int i = 0; i < element.getPhoto().size(); i++) {
      composeAttachment(t, "RelatedPerson", "photo", element.getPhoto().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "RelatedPerson", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getCommunication().size(); i++) {
      composeRelatedPersonCommunicationComponent(t, "RelatedPerson", "communication", element.getCommunication().get(i), i);
    }
  }

  protected void composeRelatedPersonCommunicationComponent(Complex parent, String parentType, String name, RelatedPerson.RelatedPersonCommunicationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "communication", name, element, index);
    if (element.hasLanguage()) {
      composeCodeableConcept(t, "RelatedPersonCommunicationComponent", "language", element.getLanguage(), -1);
    }
    if (element.hasPreferredElement()) {
      composeBoolean(t, "RelatedPersonCommunicationComponent", "preferred", element.getPreferredElement(), -1);
    }
  }

  protected void composeRequestGroup(Complex parent, String parentType, String name, RequestGroup element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "RequestGroup", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "RequestGroup", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "RequestGroup", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "RequestGroup", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "RequestGroup", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getReplaces().size(); i++) {
      composeReference(t, "RequestGroup", "replaces", element.getReplaces().get(i), i);
    }
    if (element.hasGroupIdentifier()) {
      composeIdentifier(t, "RequestGroup", "groupIdentifier", element.getGroupIdentifier(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "RequestGroup", "status", element.getStatusElement(), -1);
    }
    if (element.hasIntentElement()) {
      composeEnum(t, "RequestGroup", "intent", element.getIntentElement(), -1);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "RequestGroup", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "RequestGroup", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "RequestGroup", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "RequestGroup", "encounter", element.getEncounter(), -1);
    }
    if (element.hasAuthoredOnElement()) {
      composeDateTime(t, "RequestGroup", "authoredOn", element.getAuthoredOnElement(), -1);
    }
    if (element.hasAuthor()) {
      composeReference(t, "RequestGroup", "author", element.getAuthor(), -1);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "RequestGroup", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "RequestGroup", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "RequestGroup", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getAction().size(); i++) {
      composeRequestGroupActionComponent(t, "RequestGroup", "action", element.getAction().get(i), i);
    }
  }

  protected void composeRequestGroupActionComponent(Complex parent, String parentType, String name, RequestGroup.RequestGroupActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "action", name, element, index);
    if (element.hasPrefixElement()) {
      composeString(t, "RequestGroupActionComponent", "prefix", element.getPrefixElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "RequestGroupActionComponent", "title", element.getTitleElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "RequestGroupActionComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasTextEquivalentElement()) {
      composeString(t, "RequestGroupActionComponent", "textEquivalent", element.getTextEquivalentElement(), -1);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "RequestGroupActionComponent", "priority", element.getPriorityElement(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeCodeableConcept(t, "RequestGroupActionComponent", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getDocumentation().size(); i++) {
      composeRelatedArtifact(t, "RequestGroupActionComponent", "documentation", element.getDocumentation().get(i), i);
    }
    for (int i = 0; i < element.getCondition().size(); i++) {
      composeRequestGroupActionConditionComponent(t, "RequestGroupActionComponent", "condition", element.getCondition().get(i), i);
    }
    for (int i = 0; i < element.getRelatedAction().size(); i++) {
      composeRequestGroupActionRelatedActionComponent(t, "RequestGroupActionComponent", "relatedAction", element.getRelatedAction().get(i), i);
    }
    if (element.hasTiming()) {
      composeType(t, "RequestGroupActionComponent", "timing", element.getTiming(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeReference(t, "RequestGroupActionComponent", "participant", element.getParticipant().get(i), i);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "RequestGroupActionComponent", "type", element.getType(), -1);
    }
    if (element.hasGroupingBehaviorElement()) {
      composeEnum(t, "RequestGroupActionComponent", "groupingBehavior", element.getGroupingBehaviorElement(), -1);
    }
    if (element.hasSelectionBehaviorElement()) {
      composeEnum(t, "RequestGroupActionComponent", "selectionBehavior", element.getSelectionBehaviorElement(), -1);
    }
    if (element.hasRequiredBehaviorElement()) {
      composeEnum(t, "RequestGroupActionComponent", "requiredBehavior", element.getRequiredBehaviorElement(), -1);
    }
    if (element.hasPrecheckBehaviorElement()) {
      composeEnum(t, "RequestGroupActionComponent", "precheckBehavior", element.getPrecheckBehaviorElement(), -1);
    }
    if (element.hasCardinalityBehaviorElement()) {
      composeEnum(t, "RequestGroupActionComponent", "cardinalityBehavior", element.getCardinalityBehaviorElement(), -1);
    }
    if (element.hasResource()) {
      composeReference(t, "RequestGroupActionComponent", "resource", element.getResource(), -1);
    }
    for (int i = 0; i < element.getAction().size(); i++) {
      composeRequestGroupActionComponent(t, "RequestGroupActionComponent", "action", element.getAction().get(i), i);
    }
  }

  protected void composeRequestGroupActionConditionComponent(Complex parent, String parentType, String name, RequestGroup.RequestGroupActionConditionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "condition", name, element, index);
    if (element.hasKindElement()) {
      composeEnum(t, "RequestGroupActionConditionComponent", "kind", element.getKindElement(), -1);
    }
    if (element.hasExpression()) {
      composeExpression(t, "RequestGroupActionConditionComponent", "expression", element.getExpression(), -1);
    }
  }

  protected void composeRequestGroupActionRelatedActionComponent(Complex parent, String parentType, String name, RequestGroup.RequestGroupActionRelatedActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relatedAction", name, element, index);
    if (element.hasActionIdElement()) {
      composeId(t, "RequestGroupActionRelatedActionComponent", "actionId", element.getActionIdElement(), -1);
    }
    if (element.hasRelationshipElement()) {
      composeEnum(t, "RequestGroupActionRelatedActionComponent", "relationship", element.getRelationshipElement(), -1);
    }
    if (element.hasOffset()) {
      composeType(t, "RequestGroupActionRelatedActionComponent", "offset", element.getOffset(), -1);
    }
  }

  protected void composeResearchDefinition(Complex parent, String parentType, String name, ResearchDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ResearchDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ResearchDefinition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ResearchDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ResearchDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ResearchDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ResearchDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasShortTitleElement()) {
      composeString(t, "ResearchDefinition", "shortTitle", element.getShortTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "ResearchDefinition", "subtitle", element.getSubtitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ResearchDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "ResearchDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasSubject()) {
      composeType(t, "ResearchDefinition", "subject", element.getSubject(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ResearchDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "ResearchDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ResearchDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ResearchDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getComment().size(); i++) {
      composeString(t, "ResearchDefinition", "comment", element.getComment().get(i), i);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "ResearchDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "ResearchDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "ResearchDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasUsageElement()) {
      composeString(t, "ResearchDefinition", "usage", element.getUsageElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ResearchDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "ResearchDefinition", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "ResearchDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "ResearchDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "ResearchDefinition", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "ResearchDefinition", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "ResearchDefinition", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "ResearchDefinition", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "ResearchDefinition", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "ResearchDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    for (int i = 0; i < element.getLibrary().size(); i++) {
      composeCanonical(t, "ResearchDefinition", "library", element.getLibrary().get(i), i);
    }
    if (element.hasPopulation()) {
      composeReference(t, "ResearchDefinition", "population", element.getPopulation(), -1);
    }
    if (element.hasExposure()) {
      composeReference(t, "ResearchDefinition", "exposure", element.getExposure(), -1);
    }
    if (element.hasExposureAlternative()) {
      composeReference(t, "ResearchDefinition", "exposureAlternative", element.getExposureAlternative(), -1);
    }
    if (element.hasOutcome()) {
      composeReference(t, "ResearchDefinition", "outcome", element.getOutcome(), -1);
    }
  }

  protected void composeResearchElementDefinition(Complex parent, String parentType, String name, ResearchElementDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ResearchElementDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ResearchElementDefinition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ResearchElementDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "ResearchElementDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "ResearchElementDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ResearchElementDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasShortTitleElement()) {
      composeString(t, "ResearchElementDefinition", "shortTitle", element.getShortTitleElement(), -1);
    }
    if (element.hasSubtitleElement()) {
      composeString(t, "ResearchElementDefinition", "subtitle", element.getSubtitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ResearchElementDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "ResearchElementDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasSubject()) {
      composeType(t, "ResearchElementDefinition", "subject", element.getSubject(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "ResearchElementDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "ResearchElementDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ResearchElementDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ResearchElementDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getComment().size(); i++) {
      composeString(t, "ResearchElementDefinition", "comment", element.getComment().get(i), i);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "ResearchElementDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "ResearchElementDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "ResearchElementDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasUsageElement()) {
      composeString(t, "ResearchElementDefinition", "usage", element.getUsageElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "ResearchElementDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "ResearchElementDefinition", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "ResearchElementDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "ResearchElementDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getTopic().size(); i++) {
      composeCodeableConcept(t, "ResearchElementDefinition", "topic", element.getTopic().get(i), i);
    }
    for (int i = 0; i < element.getAuthor().size(); i++) {
      composeContactDetail(t, "ResearchElementDefinition", "author", element.getAuthor().get(i), i);
    }
    for (int i = 0; i < element.getEditor().size(); i++) {
      composeContactDetail(t, "ResearchElementDefinition", "editor", element.getEditor().get(i), i);
    }
    for (int i = 0; i < element.getReviewer().size(); i++) {
      composeContactDetail(t, "ResearchElementDefinition", "reviewer", element.getReviewer().get(i), i);
    }
    for (int i = 0; i < element.getEndorser().size(); i++) {
      composeContactDetail(t, "ResearchElementDefinition", "endorser", element.getEndorser().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "ResearchElementDefinition", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    for (int i = 0; i < element.getLibrary().size(); i++) {
      composeCanonical(t, "ResearchElementDefinition", "library", element.getLibrary().get(i), i);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "ResearchElementDefinition", "type", element.getTypeElement(), -1);
    }
    if (element.hasVariableTypeElement()) {
      composeEnum(t, "ResearchElementDefinition", "variableType", element.getVariableTypeElement(), -1);
    }
    for (int i = 0; i < element.getCharacteristic().size(); i++) {
      composeResearchElementDefinitionCharacteristicComponent(t, "ResearchElementDefinition", "characteristic", element.getCharacteristic().get(i), i);
    }
  }

  protected void composeResearchElementDefinitionCharacteristicComponent(Complex parent, String parentType, String name, ResearchElementDefinition.ResearchElementDefinitionCharacteristicComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "characteristic", name, element, index);
    if (element.hasDefinition()) {
      composeType(t, "ResearchElementDefinitionCharacteristicComponent", "definition", element.getDefinition(), -1);
    }
    for (int i = 0; i < element.getUsageContext().size(); i++) {
      composeUsageContext(t, "ResearchElementDefinitionCharacteristicComponent", "usageContext", element.getUsageContext().get(i), i);
    }
    if (element.hasExcludeElement()) {
      composeBoolean(t, "ResearchElementDefinitionCharacteristicComponent", "exclude", element.getExcludeElement(), -1);
    }
    if (element.hasUnitOfMeasure()) {
      composeCodeableConcept(t, "ResearchElementDefinitionCharacteristicComponent", "unitOfMeasure", element.getUnitOfMeasure(), -1);
    }
    if (element.hasStudyEffectiveDescriptionElement()) {
      composeString(t, "ResearchElementDefinitionCharacteristicComponent", "studyEffectiveDescription", element.getStudyEffectiveDescriptionElement(), -1);
    }
    if (element.hasStudyEffective()) {
      composeType(t, "ResearchElementDefinitionCharacteristicComponent", "studyEffective", element.getStudyEffective(), -1);
    }
    if (element.hasStudyEffectiveTimeFromStart()) {
      composeDuration(t, "ResearchElementDefinitionCharacteristicComponent", "studyEffectiveTimeFromStart", element.getStudyEffectiveTimeFromStart(), -1);
    }
    if (element.hasStudyEffectiveGroupMeasureElement()) {
      composeEnum(t, "ResearchElementDefinitionCharacteristicComponent", "studyEffectiveGroupMeasure", element.getStudyEffectiveGroupMeasureElement(), -1);
    }
    if (element.hasParticipantEffectiveDescriptionElement()) {
      composeString(t, "ResearchElementDefinitionCharacteristicComponent", "participantEffectiveDescription", element.getParticipantEffectiveDescriptionElement(), -1);
    }
    if (element.hasParticipantEffective()) {
      composeType(t, "ResearchElementDefinitionCharacteristicComponent", "participantEffective", element.getParticipantEffective(), -1);
    }
    if (element.hasParticipantEffectiveTimeFromStart()) {
      composeDuration(t, "ResearchElementDefinitionCharacteristicComponent", "participantEffectiveTimeFromStart", element.getParticipantEffectiveTimeFromStart(), -1);
    }
    if (element.hasParticipantEffectiveGroupMeasureElement()) {
      composeEnum(t, "ResearchElementDefinitionCharacteristicComponent", "participantEffectiveGroupMeasure", element.getParticipantEffectiveGroupMeasureElement(), -1);
    }
  }

  protected void composeResearchStudy(Complex parent, String parentType, String name, ResearchStudy element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ResearchStudy", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ResearchStudy", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasTitleElement()) {
      composeString(t, "ResearchStudy", "title", element.getTitleElement(), -1);
    }
    for (int i = 0; i < element.getProtocol().size(); i++) {
      composeReference(t, "ResearchStudy", "protocol", element.getProtocol().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "ResearchStudy", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ResearchStudy", "status", element.getStatusElement(), -1);
    }
    if (element.hasPrimaryPurposeType()) {
      composeCodeableConcept(t, "ResearchStudy", "primaryPurposeType", element.getPrimaryPurposeType(), -1);
    }
    if (element.hasPhase()) {
      composeCodeableConcept(t, "ResearchStudy", "phase", element.getPhase(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "ResearchStudy", "category", element.getCategory().get(i), i);
    }
    for (int i = 0; i < element.getFocus().size(); i++) {
      composeCodeableConcept(t, "ResearchStudy", "focus", element.getFocus().get(i), i);
    }
    for (int i = 0; i < element.getCondition().size(); i++) {
      composeCodeableConcept(t, "ResearchStudy", "condition", element.getCondition().get(i), i);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "ResearchStudy", "contact", element.getContact().get(i), i);
    }
    for (int i = 0; i < element.getRelatedArtifact().size(); i++) {
      composeRelatedArtifact(t, "ResearchStudy", "relatedArtifact", element.getRelatedArtifact().get(i), i);
    }
    for (int i = 0; i < element.getKeyword().size(); i++) {
      composeCodeableConcept(t, "ResearchStudy", "keyword", element.getKeyword().get(i), i);
    }
    for (int i = 0; i < element.getLocation().size(); i++) {
      composeCodeableConcept(t, "ResearchStudy", "location", element.getLocation().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "ResearchStudy", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getEnrollment().size(); i++) {
      composeReference(t, "ResearchStudy", "enrollment", element.getEnrollment().get(i), i);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ResearchStudy", "period", element.getPeriod(), -1);
    }
    if (element.hasSponsor()) {
      composeReference(t, "ResearchStudy", "sponsor", element.getSponsor(), -1);
    }
    if (element.hasPrincipalInvestigator()) {
      composeReference(t, "ResearchStudy", "principalInvestigator", element.getPrincipalInvestigator(), -1);
    }
    for (int i = 0; i < element.getSite().size(); i++) {
      composeReference(t, "ResearchStudy", "site", element.getSite().get(i), i);
    }
    if (element.hasReasonStopped()) {
      composeCodeableConcept(t, "ResearchStudy", "reasonStopped", element.getReasonStopped(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "ResearchStudy", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getArm().size(); i++) {
      composeResearchStudyArmComponent(t, "ResearchStudy", "arm", element.getArm().get(i), i);
    }
    for (int i = 0; i < element.getObjective().size(); i++) {
      composeResearchStudyObjectiveComponent(t, "ResearchStudy", "objective", element.getObjective().get(i), i);
    }
  }

  protected void composeResearchStudyArmComponent(Complex parent, String parentType, String name, ResearchStudy.ResearchStudyArmComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "arm", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "ResearchStudyArmComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ResearchStudyArmComponent", "type", element.getType(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "ResearchStudyArmComponent", "description", element.getDescriptionElement(), -1);
    }
  }

  protected void composeResearchStudyObjectiveComponent(Complex parent, String parentType, String name, ResearchStudy.ResearchStudyObjectiveComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "objective", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "ResearchStudyObjectiveComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "ResearchStudyObjectiveComponent", "type", element.getType(), -1);
    }
  }

  protected void composeResearchSubject(Complex parent, String parentType, String name, ResearchSubject element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ResearchSubject", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ResearchSubject", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ResearchSubject", "status", element.getStatusElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "ResearchSubject", "period", element.getPeriod(), -1);
    }
    if (element.hasStudy()) {
      composeReference(t, "ResearchSubject", "study", element.getStudy(), -1);
    }
    if (element.hasIndividual()) {
      composeReference(t, "ResearchSubject", "individual", element.getIndividual(), -1);
    }
    if (element.hasAssignedArmElement()) {
      composeString(t, "ResearchSubject", "assignedArm", element.getAssignedArmElement(), -1);
    }
    if (element.hasActualArmElement()) {
      composeString(t, "ResearchSubject", "actualArm", element.getActualArmElement(), -1);
    }
    if (element.hasConsent()) {
      composeReference(t, "ResearchSubject", "consent", element.getConsent(), -1);
    }
  }

  protected void composeRiskAssessment(Complex parent, String parentType, String name, RiskAssessment element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "RiskAssessment", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "RiskAssessment", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasBasedOn()) {
      composeReference(t, "RiskAssessment", "basedOn", element.getBasedOn(), -1);
    }
    if (element.hasParent()) {
      composeReference(t, "RiskAssessment", "parent", element.getParent(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "RiskAssessment", "status", element.getStatusElement(), -1);
    }
    if (element.hasMethod()) {
      composeCodeableConcept(t, "RiskAssessment", "method", element.getMethod(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "RiskAssessment", "code", element.getCode(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "RiskAssessment", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "RiskAssessment", "encounter", element.getEncounter(), -1);
    }
    if (element.hasOccurrence()) {
      composeType(t, "RiskAssessment", "occurrence", element.getOccurrence(), -1);
    }
    if (element.hasCondition()) {
      composeReference(t, "RiskAssessment", "condition", element.getCondition(), -1);
    }
    if (element.hasPerformer()) {
      composeReference(t, "RiskAssessment", "performer", element.getPerformer(), -1);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "RiskAssessment", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "RiskAssessment", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getBasis().size(); i++) {
      composeReference(t, "RiskAssessment", "basis", element.getBasis().get(i), i);
    }
    for (int i = 0; i < element.getPrediction().size(); i++) {
      composeRiskAssessmentPredictionComponent(t, "RiskAssessment", "prediction", element.getPrediction().get(i), i);
    }
    if (element.hasMitigationElement()) {
      composeString(t, "RiskAssessment", "mitigation", element.getMitigationElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "RiskAssessment", "note", element.getNote().get(i), i);
    }
  }

  protected void composeRiskAssessmentPredictionComponent(Complex parent, String parentType, String name, RiskAssessment.RiskAssessmentPredictionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "prediction", name, element, index);
    if (element.hasOutcome()) {
      composeCodeableConcept(t, "RiskAssessmentPredictionComponent", "outcome", element.getOutcome(), -1);
    }
    if (element.hasProbability()) {
      composeType(t, "RiskAssessmentPredictionComponent", "probability", element.getProbability(), -1);
    }
    if (element.hasQualitativeRisk()) {
      composeCodeableConcept(t, "RiskAssessmentPredictionComponent", "qualitativeRisk", element.getQualitativeRisk(), -1);
    }
    if (element.hasRelativeRiskElement()) {
      composeDecimal(t, "RiskAssessmentPredictionComponent", "relativeRisk", element.getRelativeRiskElement(), -1);
    }
    if (element.hasWhen()) {
      composeType(t, "RiskAssessmentPredictionComponent", "when", element.getWhen(), -1);
    }
    if (element.hasRationaleElement()) {
      composeString(t, "RiskAssessmentPredictionComponent", "rationale", element.getRationaleElement(), -1);
    }
  }

  protected void composeSchedule(Complex parent, String parentType, String name, Schedule element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Schedule", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Schedule", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasActiveElement()) {
      composeBoolean(t, "Schedule", "active", element.getActiveElement(), -1);
    }
    for (int i = 0; i < element.getServiceCategory().size(); i++) {
      composeCodeableConcept(t, "Schedule", "serviceCategory", element.getServiceCategory().get(i), i);
    }
    for (int i = 0; i < element.getServiceType().size(); i++) {
      composeCodeableConcept(t, "Schedule", "serviceType", element.getServiceType().get(i), i);
    }
    for (int i = 0; i < element.getSpecialty().size(); i++) {
      composeCodeableConcept(t, "Schedule", "specialty", element.getSpecialty().get(i), i);
    }
    for (int i = 0; i < element.getActor().size(); i++) {
      composeReference(t, "Schedule", "actor", element.getActor().get(i), i);
    }
    if (element.hasPlanningHorizon()) {
      composePeriod(t, "Schedule", "planningHorizon", element.getPlanningHorizon(), -1);
    }
    if (element.hasCommentElement()) {
      composeString(t, "Schedule", "comment", element.getCommentElement(), -1);
    }
  }

  protected void composeSearchParameter(Complex parent, String parentType, String name, SearchParameter element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "SearchParameter", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "SearchParameter", "url", element.getUrlElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "SearchParameter", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "SearchParameter", "name", element.getNameElement(), -1);
    }
    if (element.hasDerivedFromElement()) {
      composeCanonical(t, "SearchParameter", "derivedFrom", element.getDerivedFromElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "SearchParameter", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "SearchParameter", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "SearchParameter", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "SearchParameter", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "SearchParameter", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "SearchParameter", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "SearchParameter", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "SearchParameter", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "SearchParameter", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCodeElement()) {
      composeCode(t, "SearchParameter", "code", element.getCodeElement(), -1);
    }
    for (int i = 0; i < element.getBase().size(); i++) {
      composeCode(t, "SearchParameter", "base", element.getBase().get(i), i);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "SearchParameter", "type", element.getTypeElement(), -1);
    }
    if (element.hasExpressionElement()) {
      composeString(t, "SearchParameter", "expression", element.getExpressionElement(), -1);
    }
    if (element.hasXpathElement()) {
      composeString(t, "SearchParameter", "xpath", element.getXpathElement(), -1);
    }
    if (element.hasXpathUsageElement()) {
      composeEnum(t, "SearchParameter", "xpathUsage", element.getXpathUsageElement(), -1);
    }
    for (int i = 0; i < element.getTarget().size(); i++) {
      composeCode(t, "SearchParameter", "target", element.getTarget().get(i), i);
    }
    if (element.hasMultipleOrElement()) {
      composeBoolean(t, "SearchParameter", "multipleOr", element.getMultipleOrElement(), -1);
    }
    if (element.hasMultipleAndElement()) {
      composeBoolean(t, "SearchParameter", "multipleAnd", element.getMultipleAndElement(), -1);
    }
    for (int i = 0; i < element.getComparator().size(); i++) {
      composeEnum(t, "SearchParameter", "comparator", element.getComparator().get(i), i);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeEnum(t, "SearchParameter", "modifier", element.getModifier().get(i), i);
    }
    for (int i = 0; i < element.getChain().size(); i++) {
      composeString(t, "SearchParameter", "chain", element.getChain().get(i), i);
    }
    for (int i = 0; i < element.getComponent().size(); i++) {
      composeSearchParameterComponentComponent(t, "SearchParameter", "component", element.getComponent().get(i), i);
    }
  }

  protected void composeSearchParameterComponentComponent(Complex parent, String parentType, String name, SearchParameter.SearchParameterComponentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "component", name, element, index);
    if (element.hasDefinitionElement()) {
      composeCanonical(t, "SearchParameterComponentComponent", "definition", element.getDefinitionElement(), -1);
    }
    if (element.hasExpressionElement()) {
      composeString(t, "SearchParameterComponentComponent", "expression", element.getExpressionElement(), -1);
    }
  }

  protected void composeServiceRequest(Complex parent, String parentType, String name, ServiceRequest element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ServiceRequest", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "ServiceRequest", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesCanonical().size(); i++) {
      composeCanonical(t, "ServiceRequest", "instantiatesCanonical", element.getInstantiatesCanonical().get(i), i);
    }
    for (int i = 0; i < element.getInstantiatesUri().size(); i++) {
      composeUri(t, "ServiceRequest", "instantiatesUri", element.getInstantiatesUri().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "ServiceRequest", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getReplaces().size(); i++) {
      composeReference(t, "ServiceRequest", "replaces", element.getReplaces().get(i), i);
    }
    if (element.hasRequisition()) {
      composeIdentifier(t, "ServiceRequest", "requisition", element.getRequisition(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "ServiceRequest", "status", element.getStatusElement(), -1);
    }
    if (element.hasIntentElement()) {
      composeEnum(t, "ServiceRequest", "intent", element.getIntentElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "ServiceRequest", "category", element.getCategory().get(i), i);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "ServiceRequest", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasDoNotPerformElement()) {
      composeBoolean(t, "ServiceRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "ServiceRequest", "code", element.getCode(), -1);
    }
    for (int i = 0; i < element.getOrderDetail().size(); i++) {
      composeCodeableConcept(t, "ServiceRequest", "orderDetail", element.getOrderDetail().get(i), i);
    }
    if (element.hasQuantity()) {
      composeType(t, "ServiceRequest", "quantity", element.getQuantity(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "ServiceRequest", "subject", element.getSubject(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "ServiceRequest", "encounter", element.getEncounter(), -1);
    }
    if (element.hasOccurrence()) {
      composeType(t, "ServiceRequest", "occurrence", element.getOccurrence(), -1);
    }
    if (element.hasAsNeeded()) {
      composeType(t, "ServiceRequest", "asNeeded", element.getAsNeeded(), -1);
    }
    if (element.hasAuthoredOnElement()) {
      composeDateTime(t, "ServiceRequest", "authoredOn", element.getAuthoredOnElement(), -1);
    }
    if (element.hasRequester()) {
      composeReference(t, "ServiceRequest", "requester", element.getRequester(), -1);
    }
    if (element.hasPerformerType()) {
      composeCodeableConcept(t, "ServiceRequest", "performerType", element.getPerformerType(), -1);
    }
    for (int i = 0; i < element.getPerformer().size(); i++) {
      composeReference(t, "ServiceRequest", "performer", element.getPerformer().get(i), i);
    }
    for (int i = 0; i < element.getLocationCode().size(); i++) {
      composeCodeableConcept(t, "ServiceRequest", "locationCode", element.getLocationCode().get(i), i);
    }
    for (int i = 0; i < element.getLocationReference().size(); i++) {
      composeReference(t, "ServiceRequest", "locationReference", element.getLocationReference().get(i), i);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "ServiceRequest", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "ServiceRequest", "reasonReference", element.getReasonReference().get(i), i);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeReference(t, "ServiceRequest", "insurance", element.getInsurance().get(i), i);
    }
    for (int i = 0; i < element.getSupportingInfo().size(); i++) {
      composeReference(t, "ServiceRequest", "supportingInfo", element.getSupportingInfo().get(i), i);
    }
    for (int i = 0; i < element.getSpecimen().size(); i++) {
      composeReference(t, "ServiceRequest", "specimen", element.getSpecimen().get(i), i);
    }
    for (int i = 0; i < element.getBodySite().size(); i++) {
      composeCodeableConcept(t, "ServiceRequest", "bodySite", element.getBodySite().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "ServiceRequest", "note", element.getNote().get(i), i);
    }
    if (element.hasPatientInstructionElement()) {
      composeString(t, "ServiceRequest", "patientInstruction", element.getPatientInstructionElement(), -1);
    }
    for (int i = 0; i < element.getRelevantHistory().size(); i++) {
      composeReference(t, "ServiceRequest", "relevantHistory", element.getRelevantHistory().get(i), i);
    }
  }

  protected void composeSlot(Complex parent, String parentType, String name, Slot element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Slot", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Slot", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getServiceCategory().size(); i++) {
      composeCodeableConcept(t, "Slot", "serviceCategory", element.getServiceCategory().get(i), i);
    }
    for (int i = 0; i < element.getServiceType().size(); i++) {
      composeCodeableConcept(t, "Slot", "serviceType", element.getServiceType().get(i), i);
    }
    for (int i = 0; i < element.getSpecialty().size(); i++) {
      composeCodeableConcept(t, "Slot", "specialty", element.getSpecialty().get(i), i);
    }
    if (element.hasAppointmentType()) {
      composeCodeableConcept(t, "Slot", "appointmentType", element.getAppointmentType(), -1);
    }
    if (element.hasSchedule()) {
      composeReference(t, "Slot", "schedule", element.getSchedule(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Slot", "status", element.getStatusElement(), -1);
    }
    if (element.hasStartElement()) {
      composeInstant(t, "Slot", "start", element.getStartElement(), -1);
    }
    if (element.hasEndElement()) {
      composeInstant(t, "Slot", "end", element.getEndElement(), -1);
    }
    if (element.hasOverbookedElement()) {
      composeBoolean(t, "Slot", "overbooked", element.getOverbookedElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeString(t, "Slot", "comment", element.getCommentElement(), -1);
    }
  }

  protected void composeSpecimen(Complex parent, String parentType, String name, Specimen element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Specimen", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Specimen", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasAccessionIdentifier()) {
      composeIdentifier(t, "Specimen", "accessionIdentifier", element.getAccessionIdentifier(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Specimen", "status", element.getStatusElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "Specimen", "type", element.getType(), -1);
    }
    if (element.hasSubject()) {
      composeReference(t, "Specimen", "subject", element.getSubject(), -1);
    }
    if (element.hasReceivedTimeElement()) {
      composeDateTime(t, "Specimen", "receivedTime", element.getReceivedTimeElement(), -1);
    }
    for (int i = 0; i < element.getParent().size(); i++) {
      composeReference(t, "Specimen", "parent", element.getParent().get(i), i);
    }
    for (int i = 0; i < element.getRequest().size(); i++) {
      composeReference(t, "Specimen", "request", element.getRequest().get(i), i);
    }
    if (element.hasCollection()) {
      composeSpecimenCollectionComponent(t, "Specimen", "collection", element.getCollection(), -1);
    }
    for (int i = 0; i < element.getProcessing().size(); i++) {
      composeSpecimenProcessingComponent(t, "Specimen", "processing", element.getProcessing().get(i), i);
    }
    for (int i = 0; i < element.getContainer().size(); i++) {
      composeSpecimenContainerComponent(t, "Specimen", "container", element.getContainer().get(i), i);
    }
    for (int i = 0; i < element.getCondition().size(); i++) {
      composeCodeableConcept(t, "Specimen", "condition", element.getCondition().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Specimen", "note", element.getNote().get(i), i);
    }
  }

  protected void composeSpecimenCollectionComponent(Complex parent, String parentType, String name, Specimen.SpecimenCollectionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "collection", name, element, index);
    if (element.hasCollector()) {
      composeReference(t, "SpecimenCollectionComponent", "collector", element.getCollector(), -1);
    }
    if (element.hasCollected()) {
      composeType(t, "SpecimenCollectionComponent", "collected", element.getCollected(), -1);
    }
    if (element.hasDuration()) {
      composeDuration(t, "SpecimenCollectionComponent", "duration", element.getDuration(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "SpecimenCollectionComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasMethod()) {
      composeCodeableConcept(t, "SpecimenCollectionComponent", "method", element.getMethod(), -1);
    }
    if (element.hasBodySite()) {
      composeCodeableConcept(t, "SpecimenCollectionComponent", "bodySite", element.getBodySite(), -1);
    }
    if (element.hasFastingStatus()) {
      composeType(t, "SpecimenCollectionComponent", "fastingStatus", element.getFastingStatus(), -1);
    }
  }

  protected void composeSpecimenProcessingComponent(Complex parent, String parentType, String name, Specimen.SpecimenProcessingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "processing", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "SpecimenProcessingComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasProcedure()) {
      composeCodeableConcept(t, "SpecimenProcessingComponent", "procedure", element.getProcedure(), -1);
    }
    for (int i = 0; i < element.getAdditive().size(); i++) {
      composeReference(t, "SpecimenProcessingComponent", "additive", element.getAdditive().get(i), i);
    }
    if (element.hasTime()) {
      composeType(t, "SpecimenProcessingComponent", "time", element.getTime(), -1);
    }
  }

  protected void composeSpecimenContainerComponent(Complex parent, String parentType, String name, Specimen.SpecimenContainerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "container", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "SpecimenContainerComponent", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "SpecimenContainerComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "SpecimenContainerComponent", "type", element.getType(), -1);
    }
    if (element.hasCapacity()) {
      composeQuantity(t, "SpecimenContainerComponent", "capacity", element.getCapacity(), -1);
    }
    if (element.hasSpecimenQuantity()) {
      composeQuantity(t, "SpecimenContainerComponent", "specimenQuantity", element.getSpecimenQuantity(), -1);
    }
    if (element.hasAdditive()) {
      composeType(t, "SpecimenContainerComponent", "additive", element.getAdditive(), -1);
    }
  }

  protected void composeSpecimenDefinition(Complex parent, String parentType, String name, SpecimenDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "SpecimenDefinition", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "SpecimenDefinition", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasTypeCollected()) {
      composeCodeableConcept(t, "SpecimenDefinition", "typeCollected", element.getTypeCollected(), -1);
    }
    for (int i = 0; i < element.getPatientPreparation().size(); i++) {
      composeCodeableConcept(t, "SpecimenDefinition", "patientPreparation", element.getPatientPreparation().get(i), i);
    }
    if (element.hasTimeAspectElement()) {
      composeString(t, "SpecimenDefinition", "timeAspect", element.getTimeAspectElement(), -1);
    }
    for (int i = 0; i < element.getCollection().size(); i++) {
      composeCodeableConcept(t, "SpecimenDefinition", "collection", element.getCollection().get(i), i);
    }
    for (int i = 0; i < element.getTypeTested().size(); i++) {
      composeSpecimenDefinitionTypeTestedComponent(t, "SpecimenDefinition", "typeTested", element.getTypeTested().get(i), i);
    }
  }

  protected void composeSpecimenDefinitionTypeTestedComponent(Complex parent, String parentType, String name, SpecimenDefinition.SpecimenDefinitionTypeTestedComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "typeTested", name, element, index);
    if (element.hasIsDerivedElement()) {
      composeBoolean(t, "SpecimenDefinitionTypeTestedComponent", "isDerived", element.getIsDerivedElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "SpecimenDefinitionTypeTestedComponent", "type", element.getType(), -1);
    }
    if (element.hasPreferenceElement()) {
      composeEnum(t, "SpecimenDefinitionTypeTestedComponent", "preference", element.getPreferenceElement(), -1);
    }
    if (element.hasContainer()) {
      composeSpecimenDefinitionTypeTestedContainerComponent(t, "SpecimenDefinitionTypeTestedComponent", "container", element.getContainer(), -1);
    }
    if (element.hasRequirementElement()) {
      composeString(t, "SpecimenDefinitionTypeTestedComponent", "requirement", element.getRequirementElement(), -1);
    }
    if (element.hasRetentionTime()) {
      composeDuration(t, "SpecimenDefinitionTypeTestedComponent", "retentionTime", element.getRetentionTime(), -1);
    }
    for (int i = 0; i < element.getRejectionCriterion().size(); i++) {
      composeCodeableConcept(t, "SpecimenDefinitionTypeTestedComponent", "rejectionCriterion", element.getRejectionCriterion().get(i), i);
    }
    for (int i = 0; i < element.getHandling().size(); i++) {
      composeSpecimenDefinitionTypeTestedHandlingComponent(t, "SpecimenDefinitionTypeTestedComponent", "handling", element.getHandling().get(i), i);
    }
  }

  protected void composeSpecimenDefinitionTypeTestedContainerComponent(Complex parent, String parentType, String name, SpecimenDefinition.SpecimenDefinitionTypeTestedContainerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "container", name, element, index);
    if (element.hasMaterial()) {
      composeCodeableConcept(t, "SpecimenDefinitionTypeTestedContainerComponent", "material", element.getMaterial(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "SpecimenDefinitionTypeTestedContainerComponent", "type", element.getType(), -1);
    }
    if (element.hasCap()) {
      composeCodeableConcept(t, "SpecimenDefinitionTypeTestedContainerComponent", "cap", element.getCap(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "SpecimenDefinitionTypeTestedContainerComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasCapacity()) {
      composeQuantity(t, "SpecimenDefinitionTypeTestedContainerComponent", "capacity", element.getCapacity(), -1);
    }
    if (element.hasMinimumVolume()) {
      composeType(t, "SpecimenDefinitionTypeTestedContainerComponent", "minimumVolume", element.getMinimumVolume(), -1);
    }
    for (int i = 0; i < element.getAdditive().size(); i++) {
      composeSpecimenDefinitionTypeTestedContainerAdditiveComponent(t, "SpecimenDefinitionTypeTestedContainerComponent", "additive", element.getAdditive().get(i), i);
    }
    if (element.hasPreparationElement()) {
      composeString(t, "SpecimenDefinitionTypeTestedContainerComponent", "preparation", element.getPreparationElement(), -1);
    }
  }

  protected void composeSpecimenDefinitionTypeTestedContainerAdditiveComponent(Complex parent, String parentType, String name, SpecimenDefinition.SpecimenDefinitionTypeTestedContainerAdditiveComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "additive", name, element, index);
    if (element.hasAdditive()) {
      composeType(t, "SpecimenDefinitionTypeTestedContainerAdditiveComponent", "additive", element.getAdditive(), -1);
    }
  }

  protected void composeSpecimenDefinitionTypeTestedHandlingComponent(Complex parent, String parentType, String name, SpecimenDefinition.SpecimenDefinitionTypeTestedHandlingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "handling", name, element, index);
    if (element.hasTemperatureQualifier()) {
      composeCodeableConcept(t, "SpecimenDefinitionTypeTestedHandlingComponent", "temperatureQualifier", element.getTemperatureQualifier(), -1);
    }
    if (element.hasTemperatureRange()) {
      composeRange(t, "SpecimenDefinitionTypeTestedHandlingComponent", "temperatureRange", element.getTemperatureRange(), -1);
    }
    if (element.hasMaxDuration()) {
      composeDuration(t, "SpecimenDefinitionTypeTestedHandlingComponent", "maxDuration", element.getMaxDuration(), -1);
    }
    if (element.hasInstructionElement()) {
      composeString(t, "SpecimenDefinitionTypeTestedHandlingComponent", "instruction", element.getInstructionElement(), -1);
    }
  }

  protected void composeStructureDefinition(Complex parent, String parentType, String name, StructureDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "StructureDefinition", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "StructureDefinition", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "StructureDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "StructureDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "StructureDefinition", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "StructureDefinition", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "StructureDefinition", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "StructureDefinition", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "StructureDefinition", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "StructureDefinition", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "StructureDefinition", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "StructureDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "StructureDefinition", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "StructureDefinition", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "StructureDefinition", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "StructureDefinition", "copyright", element.getCopyrightElement(), -1);
    }
    for (int i = 0; i < element.getKeyword().size(); i++) {
      composeCoding(t, "StructureDefinition", "keyword", element.getKeyword().get(i), i);
    }
    if (element.hasFhirVersionElement()) {
      composeEnum(t, "StructureDefinition", "fhirVersion", element.getFhirVersionElement(), -1);
    }
    for (int i = 0; i < element.getMapping().size(); i++) {
      composeStructureDefinitionMappingComponent(t, "StructureDefinition", "mapping", element.getMapping().get(i), i);
    }
    if (element.hasKindElement()) {
      composeEnum(t, "StructureDefinition", "kind", element.getKindElement(), -1);
    }
    if (element.hasAbstractElement()) {
      composeBoolean(t, "StructureDefinition", "abstract", element.getAbstractElement(), -1);
    }
    for (int i = 0; i < element.getContext().size(); i++) {
      composeStructureDefinitionContextComponent(t, "StructureDefinition", "context", element.getContext().get(i), i);
    }
    for (int i = 0; i < element.getContextInvariant().size(); i++) {
      composeString(t, "StructureDefinition", "contextInvariant", element.getContextInvariant().get(i), i);
    }
    if (element.hasTypeElement()) {
      composeUri(t, "StructureDefinition", "type", element.getTypeElement(), -1);
    }
    if (element.hasBaseDefinitionElement()) {
      composeCanonical(t, "StructureDefinition", "baseDefinition", element.getBaseDefinitionElement(), -1);
    }
    if (element.hasDerivationElement()) {
      composeEnum(t, "StructureDefinition", "derivation", element.getDerivationElement(), -1);
    }
    if (element.hasSnapshot()) {
      composeStructureDefinitionSnapshotComponent(t, "StructureDefinition", "snapshot", element.getSnapshot(), -1);
    }
    if (element.hasDifferential()) {
      composeStructureDefinitionDifferentialComponent(t, "StructureDefinition", "differential", element.getDifferential(), -1);
    }
  }

  protected void composeStructureDefinitionMappingComponent(Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionMappingComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "mapping", name, element, index);
    if (element.hasIdentityElement()) {
      composeId(t, "StructureDefinitionMappingComponent", "identity", element.getIdentityElement(), -1);
    }
    if (element.hasUriElement()) {
      composeUri(t, "StructureDefinitionMappingComponent", "uri", element.getUriElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "StructureDefinitionMappingComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasCommentElement()) {
      composeString(t, "StructureDefinitionMappingComponent", "comment", element.getCommentElement(), -1);
    }
  }

  protected void composeStructureDefinitionContextComponent(Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionContextComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "context", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "StructureDefinitionContextComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasExpressionElement()) {
      composeString(t, "StructureDefinitionContextComponent", "expression", element.getExpressionElement(), -1);
    }
  }

  protected void composeStructureDefinitionSnapshotComponent(Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionSnapshotComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "snapshot", name, element, index);
    for (int i = 0; i < element.getElement().size(); i++) {
      composeElementDefinition(t, "StructureDefinitionSnapshotComponent", "element", element.getElement().get(i), i);
    }
  }

  protected void composeStructureDefinitionDifferentialComponent(Complex parent, String parentType, String name, StructureDefinition.StructureDefinitionDifferentialComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "differential", name, element, index);
    for (int i = 0; i < element.getElement().size(); i++) {
      composeElementDefinition(t, "StructureDefinitionDifferentialComponent", "element", element.getElement().get(i), i);
    }
  }

  protected void composeStructureMap(Complex parent, String parentType, String name, StructureMap element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "StructureMap", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "StructureMap", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "StructureMap", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "StructureMap", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "StructureMap", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "StructureMap", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "StructureMap", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "StructureMap", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "StructureMap", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "StructureMap", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "StructureMap", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "StructureMap", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "StructureMap", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "StructureMap", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "StructureMap", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "StructureMap", "copyright", element.getCopyrightElement(), -1);
    }
    for (int i = 0; i < element.getStructure().size(); i++) {
      composeStructureMapStructureComponent(t, "StructureMap", "structure", element.getStructure().get(i), i);
    }
    for (int i = 0; i < element.getImport().size(); i++) {
      composeCanonical(t, "StructureMap", "import", element.getImport().get(i), i);
    }
    for (int i = 0; i < element.getGroup().size(); i++) {
      composeStructureMapGroupComponent(t, "StructureMap", "group", element.getGroup().get(i), i);
    }
  }

  protected void composeStructureMapStructureComponent(Complex parent, String parentType, String name, StructureMap.StructureMapStructureComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "structure", name, element, index);
    if (element.hasUrlElement()) {
      composeCanonical(t, "StructureMapStructureComponent", "url", element.getUrlElement(), -1);
    }
    if (element.hasModeElement()) {
      composeEnum(t, "StructureMapStructureComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasAliasElement()) {
      composeString(t, "StructureMapStructureComponent", "alias", element.getAliasElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeString(t, "StructureMapStructureComponent", "documentation", element.getDocumentationElement(), -1);
    }
  }

  protected void composeStructureMapGroupComponent(Complex parent, String parentType, String name, StructureMap.StructureMapGroupComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "group", name, element, index);
    if (element.hasNameElement()) {
      composeId(t, "StructureMapGroupComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasExtendsElement()) {
      composeId(t, "StructureMapGroupComponent", "extends", element.getExtendsElement(), -1);
    }
    if (element.hasTypeModeElement()) {
      composeEnum(t, "StructureMapGroupComponent", "typeMode", element.getTypeModeElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeString(t, "StructureMapGroupComponent", "documentation", element.getDocumentationElement(), -1);
    }
    for (int i = 0; i < element.getInput().size(); i++) {
      composeStructureMapGroupInputComponent(t, "StructureMapGroupComponent", "input", element.getInput().get(i), i);
    }
    for (int i = 0; i < element.getRule().size(); i++) {
      composeStructureMapGroupRuleComponent(t, "StructureMapGroupComponent", "rule", element.getRule().get(i), i);
    }
  }

  protected void composeStructureMapGroupInputComponent(Complex parent, String parentType, String name, StructureMap.StructureMapGroupInputComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "input", name, element, index);
    if (element.hasNameElement()) {
      composeId(t, "StructureMapGroupInputComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeString(t, "StructureMapGroupInputComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasModeElement()) {
      composeEnum(t, "StructureMapGroupInputComponent", "mode", element.getModeElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeString(t, "StructureMapGroupInputComponent", "documentation", element.getDocumentationElement(), -1);
    }
  }

  protected void composeStructureMapGroupRuleComponent(Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "rule", name, element, index);
    if (element.hasNameElement()) {
      composeId(t, "StructureMapGroupRuleComponent", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getSource().size(); i++) {
      composeStructureMapGroupRuleSourceComponent(t, "StructureMapGroupRuleComponent", "source", element.getSource().get(i), i);
    }
    for (int i = 0; i < element.getTarget().size(); i++) {
      composeStructureMapGroupRuleTargetComponent(t, "StructureMapGroupRuleComponent", "target", element.getTarget().get(i), i);
    }
    for (int i = 0; i < element.getRule().size(); i++) {
      composeStructureMapGroupRuleComponent(t, "StructureMapGroupRuleComponent", "rule", element.getRule().get(i), i);
    }
    for (int i = 0; i < element.getDependent().size(); i++) {
      composeStructureMapGroupRuleDependentComponent(t, "StructureMapGroupRuleComponent", "dependent", element.getDependent().get(i), i);
    }
    if (element.hasDocumentationElement()) {
      composeString(t, "StructureMapGroupRuleComponent", "documentation", element.getDocumentationElement(), -1);
    }
  }

  protected void composeStructureMapGroupRuleSourceComponent(Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleSourceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "source", name, element, index);
    if (element.hasContextElement()) {
      composeId(t, "StructureMapGroupRuleSourceComponent", "context", element.getContextElement(), -1);
    }
    if (element.hasMinElement()) {
      composeInteger(t, "StructureMapGroupRuleSourceComponent", "min", element.getMinElement(), -1);
    }
    if (element.hasMaxElement()) {
      composeString(t, "StructureMapGroupRuleSourceComponent", "max", element.getMaxElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeString(t, "StructureMapGroupRuleSourceComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasDefaultValue()) {
      composeType(t, "StructureMapGroupRuleSourceComponent", "defaultValue", element.getDefaultValue(), -1);
    }
    if (element.hasElementElement()) {
      composeString(t, "StructureMapGroupRuleSourceComponent", "element", element.getElementElement(), -1);
    }
    if (element.hasListModeElement()) {
      composeEnum(t, "StructureMapGroupRuleSourceComponent", "listMode", element.getListModeElement(), -1);
    }
    if (element.hasVariableElement()) {
      composeId(t, "StructureMapGroupRuleSourceComponent", "variable", element.getVariableElement(), -1);
    }
    if (element.hasConditionElement()) {
      composeString(t, "StructureMapGroupRuleSourceComponent", "condition", element.getConditionElement(), -1);
    }
    if (element.hasCheckElement()) {
      composeString(t, "StructureMapGroupRuleSourceComponent", "check", element.getCheckElement(), -1);
    }
    if (element.hasLogMessageElement()) {
      composeString(t, "StructureMapGroupRuleSourceComponent", "logMessage", element.getLogMessageElement(), -1);
    }
  }

  protected void composeStructureMapGroupRuleTargetComponent(Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleTargetComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "target", name, element, index);
    if (element.hasContextElement()) {
      composeId(t, "StructureMapGroupRuleTargetComponent", "context", element.getContextElement(), -1);
    }
    if (element.hasContextTypeElement()) {
      composeEnum(t, "StructureMapGroupRuleTargetComponent", "contextType", element.getContextTypeElement(), -1);
    }
    if (element.hasElementElement()) {
      composeString(t, "StructureMapGroupRuleTargetComponent", "element", element.getElementElement(), -1);
    }
    if (element.hasVariableElement()) {
      composeId(t, "StructureMapGroupRuleTargetComponent", "variable", element.getVariableElement(), -1);
    }
    for (int i = 0; i < element.getListMode().size(); i++) {
      composeEnum(t, "StructureMapGroupRuleTargetComponent", "listMode", element.getListMode().get(i), i);
    }
    if (element.hasListRuleIdElement()) {
      composeId(t, "StructureMapGroupRuleTargetComponent", "listRuleId", element.getListRuleIdElement(), -1);
    }
    if (element.hasTransformElement()) {
      composeEnum(t, "StructureMapGroupRuleTargetComponent", "transform", element.getTransformElement(), -1);
    }
    for (int i = 0; i < element.getParameter().size(); i++) {
      composeStructureMapGroupRuleTargetParameterComponent(t, "StructureMapGroupRuleTargetComponent", "parameter", element.getParameter().get(i), i);
    }
  }

  protected void composeStructureMapGroupRuleTargetParameterComponent(Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleTargetParameterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "parameter", name, element, index);
    if (element.hasValue()) {
      composeType(t, "StructureMapGroupRuleTargetParameterComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeStructureMapGroupRuleDependentComponent(Complex parent, String parentType, String name, StructureMap.StructureMapGroupRuleDependentComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "dependent", name, element, index);
    if (element.hasNameElement()) {
      composeId(t, "StructureMapGroupRuleDependentComponent", "name", element.getNameElement(), -1);
    }
    for (int i = 0; i < element.getVariable().size(); i++) {
      composeString(t, "StructureMapGroupRuleDependentComponent", "variable", element.getVariable().get(i), i);
    }
  }

  protected void composeSubscription(Complex parent, String parentType, String name, Subscription element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Subscription", name, element, index);
    if (element.hasStatusElement()) {
      composeEnum(t, "Subscription", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactPoint(t, "Subscription", "contact", element.getContact().get(i), i);
    }
    if (element.hasEndElement()) {
      composeInstant(t, "Subscription", "end", element.getEndElement(), -1);
    }
    if (element.hasReasonElement()) {
      composeString(t, "Subscription", "reason", element.getReasonElement(), -1);
    }
    if (element.hasCriteriaElement()) {
      composeString(t, "Subscription", "criteria", element.getCriteriaElement(), -1);
    }
    if (element.hasErrorElement()) {
      composeString(t, "Subscription", "error", element.getErrorElement(), -1);
    }
    if (element.hasChannel()) {
      composeSubscriptionChannelComponent(t, "Subscription", "channel", element.getChannel(), -1);
    }
  }

  protected void composeSubscriptionChannelComponent(Complex parent, String parentType, String name, Subscription.SubscriptionChannelComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "channel", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "SubscriptionChannelComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasEndpointElement()) {
      composeUrl(t, "SubscriptionChannelComponent", "endpoint", element.getEndpointElement(), -1);
    }
    if (element.hasPayloadElement()) {
      composeCode(t, "SubscriptionChannelComponent", "payload", element.getPayloadElement(), -1);
    }
    for (int i = 0; i < element.getHeader().size(); i++) {
      composeString(t, "SubscriptionChannelComponent", "header", element.getHeader().get(i), i);
    }
  }

  protected void composeSubscriptionStatus(Complex parent, String parentType, String name, SubscriptionStatus element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "SubscriptionStatus", name, element, index);
    if (element.hasStatusElement()) {
      composeEnum(t, "SubscriptionStatus", "status", element.getStatusElement(), -1);
    }
    if (element.hasTypeElement()) {
      composeEnum(t, "SubscriptionStatus", "type", element.getTypeElement(), -1);
    }
    if (element.hasEventsSinceSubscriptionStartElement()) {
      composeString(t, "SubscriptionStatus", "eventsSinceSubscriptionStart", element.getEventsSinceSubscriptionStartElement(), -1);
    }
    if (element.hasEventsInNotificationElement()) {
      composeInteger(t, "SubscriptionStatus", "eventsInNotification", element.getEventsInNotificationElement(), -1);
    }
    for (int i = 0; i < element.getNotificationEvent().size(); i++) {
      composeSubscriptionStatusNotificationEventComponent(t, "SubscriptionStatus", "notificationEvent", element.getNotificationEvent().get(i), i);
    }
    if (element.hasSubscription()) {
      composeReference(t, "SubscriptionStatus", "subscription", element.getSubscription(), -1);
    }
    if (element.hasTopicElement()) {
      composeCanonical(t, "SubscriptionStatus", "topic", element.getTopicElement(), -1);
    }
    for (int i = 0; i < element.getError().size(); i++) {
      composeCodeableConcept(t, "SubscriptionStatus", "error", element.getError().get(i), i);
    }
  }

  protected void composeSubscriptionStatusNotificationEventComponent(Complex parent, String parentType, String name, SubscriptionStatus.SubscriptionStatusNotificationEventComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "notificationEvent", name, element, index);
    if (element.hasEventNumberElement()) {
      composeString(t, "SubscriptionStatusNotificationEventComponent", "eventNumber", element.getEventNumberElement(), -1);
    }
    if (element.hasTimestampElement()) {
      composeInstant(t, "SubscriptionStatusNotificationEventComponent", "timestamp", element.getTimestampElement(), -1);
    }
    if (element.hasFocus()) {
      composeReference(t, "SubscriptionStatusNotificationEventComponent", "focus", element.getFocus(), -1);
    }
    for (int i = 0; i < element.getAdditionalContext().size(); i++) {
      composeReference(t, "SubscriptionStatusNotificationEventComponent", "additionalContext", element.getAdditionalContext().get(i), i);
    }
  }

  protected void composeSubscriptionTopic(Complex parent, String parentType, String name, SubscriptionTopic element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "SubscriptionTopic", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "SubscriptionTopic", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "SubscriptionTopic", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "SubscriptionTopic", "version", element.getVersionElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "SubscriptionTopic", "title", element.getTitleElement(), -1);
    }
    for (int i = 0; i < element.getDerivedFrom().size(); i++) {
      composeCanonical(t, "SubscriptionTopic", "derivedFrom", element.getDerivedFrom().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "SubscriptionTopic", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "SubscriptionTopic", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "SubscriptionTopic", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "SubscriptionTopic", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "SubscriptionTopic", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "SubscriptionTopic", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "SubscriptionTopic", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "SubscriptionTopic", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "SubscriptionTopic", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "SubscriptionTopic", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasApprovalDateElement()) {
      composeDate(t, "SubscriptionTopic", "approvalDate", element.getApprovalDateElement(), -1);
    }
    if (element.hasLastReviewDateElement()) {
      composeDate(t, "SubscriptionTopic", "lastReviewDate", element.getLastReviewDateElement(), -1);
    }
    if (element.hasEffectivePeriod()) {
      composePeriod(t, "SubscriptionTopic", "effectivePeriod", element.getEffectivePeriod(), -1);
    }
    for (int i = 0; i < element.getResourceTrigger().size(); i++) {
      composeSubscriptionTopicResourceTriggerComponent(t, "SubscriptionTopic", "resourceTrigger", element.getResourceTrigger().get(i), i);
    }
    for (int i = 0; i < element.getEventTrigger().size(); i++) {
      composeSubscriptionTopicEventTriggerComponent(t, "SubscriptionTopic", "eventTrigger", element.getEventTrigger().get(i), i);
    }
    for (int i = 0; i < element.getCanFilterBy().size(); i++) {
      composeSubscriptionTopicCanFilterByComponent(t, "SubscriptionTopic", "canFilterBy", element.getCanFilterBy().get(i), i);
    }
    for (int i = 0; i < element.getNotificationShape().size(); i++) {
      composeSubscriptionTopicNotificationShapeComponent(t, "SubscriptionTopic", "notificationShape", element.getNotificationShape().get(i), i);
    }
  }

  protected void composeSubscriptionTopicResourceTriggerComponent(Complex parent, String parentType, String name, SubscriptionTopic.SubscriptionTopicResourceTriggerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "resourceTrigger", name, element, index);
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "SubscriptionTopicResourceTriggerComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasResourceElement()) {
      composeUri(t, "SubscriptionTopicResourceTriggerComponent", "resource", element.getResourceElement(), -1);
    }
    for (int i = 0; i < element.getSupportedInteraction().size(); i++) {
      composeEnum(t, "SubscriptionTopicResourceTriggerComponent", "supportedInteraction", element.getSupportedInteraction().get(i), i);
    }
    if (element.hasQueryCriteria()) {
      composeSubscriptionTopicResourceTriggerQueryCriteriaComponent(t, "SubscriptionTopicResourceTriggerComponent", "queryCriteria", element.getQueryCriteria(), -1);
    }
    if (element.hasFhirPathCriteriaElement()) {
      composeString(t, "SubscriptionTopicResourceTriggerComponent", "fhirPathCriteria", element.getFhirPathCriteriaElement(), -1);
    }
  }

  protected void composeSubscriptionTopicResourceTriggerQueryCriteriaComponent(Complex parent, String parentType, String name, SubscriptionTopic.SubscriptionTopicResourceTriggerQueryCriteriaComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "queryCriteria", name, element, index);
    if (element.hasPreviousElement()) {
      composeString(t, "SubscriptionTopicResourceTriggerQueryCriteriaComponent", "previous", element.getPreviousElement(), -1);
    }
    if (element.hasResultForCreateElement()) {
      composeEnum(t, "SubscriptionTopicResourceTriggerQueryCriteriaComponent", "resultForCreate", element.getResultForCreateElement(), -1);
    }
    if (element.hasCurrentElement()) {
      composeString(t, "SubscriptionTopicResourceTriggerQueryCriteriaComponent", "current", element.getCurrentElement(), -1);
    }
    if (element.hasResultForDeleteElement()) {
      composeEnum(t, "SubscriptionTopicResourceTriggerQueryCriteriaComponent", "resultForDelete", element.getResultForDeleteElement(), -1);
    }
    if (element.hasRequireBothElement()) {
      composeBoolean(t, "SubscriptionTopicResourceTriggerQueryCriteriaComponent", "requireBoth", element.getRequireBothElement(), -1);
    }
  }

  protected void composeSubscriptionTopicEventTriggerComponent(Complex parent, String parentType, String name, SubscriptionTopic.SubscriptionTopicEventTriggerComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "eventTrigger", name, element, index);
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "SubscriptionTopicEventTriggerComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasEvent()) {
      composeCodeableConcept(t, "SubscriptionTopicEventTriggerComponent", "event", element.getEvent(), -1);
    }
    if (element.hasResourceElement()) {
      composeUri(t, "SubscriptionTopicEventTriggerComponent", "resource", element.getResourceElement(), -1);
    }
  }

  protected void composeSubscriptionTopicCanFilterByComponent(Complex parent, String parentType, String name, SubscriptionTopic.SubscriptionTopicCanFilterByComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "canFilterBy", name, element, index);
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "SubscriptionTopicCanFilterByComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasResourceElement()) {
      composeUri(t, "SubscriptionTopicCanFilterByComponent", "resource", element.getResourceElement(), -1);
    }
    if (element.hasFilterParameterElement()) {
      composeString(t, "SubscriptionTopicCanFilterByComponent", "filterParameter", element.getFilterParameterElement(), -1);
    }
    for (int i = 0; i < element.getModifier().size(); i++) {
      composeEnum(t, "SubscriptionTopicCanFilterByComponent", "modifier", element.getModifier().get(i), i);
    }
  }

  protected void composeSubscriptionTopicNotificationShapeComponent(Complex parent, String parentType, String name, SubscriptionTopic.SubscriptionTopicNotificationShapeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "notificationShape", name, element, index);
    if (element.hasResourceElement()) {
      composeUri(t, "SubscriptionTopicNotificationShapeComponent", "resource", element.getResourceElement(), -1);
    }
    for (int i = 0; i < element.getInclude().size(); i++) {
      composeString(t, "SubscriptionTopicNotificationShapeComponent", "include", element.getInclude().get(i), i);
    }
    for (int i = 0; i < element.getRevInclude().size(); i++) {
      composeString(t, "SubscriptionTopicNotificationShapeComponent", "revInclude", element.getRevInclude().get(i), i);
    }
  }

  protected void composeSubstance(Complex parent, String parentType, String name, Substance element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Substance", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Substance", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Substance", "status", element.getStatusElement(), -1);
    }
    for (int i = 0; i < element.getCategory().size(); i++) {
      composeCodeableConcept(t, "Substance", "category", element.getCategory().get(i), i);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Substance", "code", element.getCode(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "Substance", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getInstance().size(); i++) {
      composeSubstanceInstanceComponent(t, "Substance", "instance", element.getInstance().get(i), i);
    }
    for (int i = 0; i < element.getIngredient().size(); i++) {
      composeSubstanceIngredientComponent(t, "Substance", "ingredient", element.getIngredient().get(i), i);
    }
  }

  protected void composeSubstanceInstanceComponent(Complex parent, String parentType, String name, Substance.SubstanceInstanceComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "instance", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "SubstanceInstanceComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasExpiryElement()) {
      composeDateTime(t, "SubstanceInstanceComponent", "expiry", element.getExpiryElement(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "SubstanceInstanceComponent", "quantity", element.getQuantity(), -1);
    }
  }

  protected void composeSubstanceIngredientComponent(Complex parent, String parentType, String name, Substance.SubstanceIngredientComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "ingredient", name, element, index);
    if (element.hasQuantity()) {
      composeRatio(t, "SubstanceIngredientComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasSubstance()) {
      composeType(t, "SubstanceIngredientComponent", "substance", element.getSubstance(), -1);
    }
  }

  protected void composeSubstanceDefinition(Complex parent, String parentType, String name, SubstanceDefinition element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "SubstanceDefinition", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "SubstanceDefinition", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasVersionElement()) {
      composeString(t, "SubstanceDefinition", "version", element.getVersionElement(), -1);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "SubstanceDefinition", "status", element.getStatus(), -1);
    }
    for (int i = 0; i < element.getClassification().size(); i++) {
      composeCodeableConcept(t, "SubstanceDefinition", "classification", element.getClassification().get(i), i);
    }
    if (element.hasDomain()) {
      composeCodeableConcept(t, "SubstanceDefinition", "domain", element.getDomain(), -1);
    }
    for (int i = 0; i < element.getGrade().size(); i++) {
      composeCodeableConcept(t, "SubstanceDefinition", "grade", element.getGrade().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "SubstanceDefinition", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getInformationSource().size(); i++) {
      composeReference(t, "SubstanceDefinition", "informationSource", element.getInformationSource().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "SubstanceDefinition", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getManufacturer().size(); i++) {
      composeReference(t, "SubstanceDefinition", "manufacturer", element.getManufacturer().get(i), i);
    }
    for (int i = 0; i < element.getSupplier().size(); i++) {
      composeReference(t, "SubstanceDefinition", "supplier", element.getSupplier().get(i), i);
    }
    for (int i = 0; i < element.getMoiety().size(); i++) {
      composeSubstanceDefinitionMoietyComponent(t, "SubstanceDefinition", "moiety", element.getMoiety().get(i), i);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeSubstanceDefinitionPropertyComponent(t, "SubstanceDefinition", "property", element.getProperty().get(i), i);
    }
    for (int i = 0; i < element.getMolecularWeight().size(); i++) {
      composeSubstanceDefinitionMolecularWeightComponent(t, "SubstanceDefinition", "molecularWeight", element.getMolecularWeight().get(i), i);
    }
    if (element.hasStructure()) {
      composeSubstanceDefinitionStructureComponent(t, "SubstanceDefinition", "structure", element.getStructure(), -1);
    }
    for (int i = 0; i < element.getCode().size(); i++) {
      composeSubstanceDefinitionCodeComponent(t, "SubstanceDefinition", "code", element.getCode().get(i), i);
    }
    for (int i = 0; i < element.getName().size(); i++) {
      composeSubstanceDefinitionNameComponent(t, "SubstanceDefinition", "name", element.getName().get(i), i);
    }
    for (int i = 0; i < element.getRelationship().size(); i++) {
      composeSubstanceDefinitionRelationshipComponent(t, "SubstanceDefinition", "relationship", element.getRelationship().get(i), i);
    }
    if (element.hasSourceMaterial()) {
      composeSubstanceDefinitionSourceMaterialComponent(t, "SubstanceDefinition", "sourceMaterial", element.getSourceMaterial(), -1);
    }
  }

  protected void composeSubstanceDefinitionMoietyComponent(Complex parent, String parentType, String name, SubstanceDefinition.SubstanceDefinitionMoietyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "moiety", name, element, index);
    if (element.hasRole()) {
      composeCodeableConcept(t, "SubstanceDefinitionMoietyComponent", "role", element.getRole(), -1);
    }
    if (element.hasIdentifier()) {
      composeIdentifier(t, "SubstanceDefinitionMoietyComponent", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "SubstanceDefinitionMoietyComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasStereochemistry()) {
      composeCodeableConcept(t, "SubstanceDefinitionMoietyComponent", "stereochemistry", element.getStereochemistry(), -1);
    }
    if (element.hasOpticalActivity()) {
      composeCodeableConcept(t, "SubstanceDefinitionMoietyComponent", "opticalActivity", element.getOpticalActivity(), -1);
    }
    if (element.hasMolecularFormulaElement()) {
      composeString(t, "SubstanceDefinitionMoietyComponent", "molecularFormula", element.getMolecularFormulaElement(), -1);
    }
    if (element.hasAmount()) {
      composeType(t, "SubstanceDefinitionMoietyComponent", "amount", element.getAmount(), -1);
    }
    if (element.hasAmountType()) {
      composeCodeableConcept(t, "SubstanceDefinitionMoietyComponent", "amountType", element.getAmountType(), -1);
    }
  }

  protected void composeSubstanceDefinitionPropertyComponent(Complex parent, String parentType, String name, SubstanceDefinition.SubstanceDefinitionPropertyComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "property", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "SubstanceDefinitionPropertyComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "SubstanceDefinitionPropertyComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeSubstanceDefinitionMolecularWeightComponent(Complex parent, String parentType, String name, SubstanceDefinition.SubstanceDefinitionMolecularWeightComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "molecularWeight", name, element, index);
    if (element.hasMethod()) {
      composeCodeableConcept(t, "SubstanceDefinitionMolecularWeightComponent", "method", element.getMethod(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "SubstanceDefinitionMolecularWeightComponent", "type", element.getType(), -1);
    }
    if (element.hasAmount()) {
      composeQuantity(t, "SubstanceDefinitionMolecularWeightComponent", "amount", element.getAmount(), -1);
    }
  }

  protected void composeSubstanceDefinitionStructureComponent(Complex parent, String parentType, String name, SubstanceDefinition.SubstanceDefinitionStructureComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "structure", name, element, index);
    if (element.hasStereochemistry()) {
      composeCodeableConcept(t, "SubstanceDefinitionStructureComponent", "stereochemistry", element.getStereochemistry(), -1);
    }
    if (element.hasOpticalActivity()) {
      composeCodeableConcept(t, "SubstanceDefinitionStructureComponent", "opticalActivity", element.getOpticalActivity(), -1);
    }
    if (element.hasMolecularFormulaElement()) {
      composeString(t, "SubstanceDefinitionStructureComponent", "molecularFormula", element.getMolecularFormulaElement(), -1);
    }
    if (element.hasMolecularFormulaByMoietyElement()) {
      composeString(t, "SubstanceDefinitionStructureComponent", "molecularFormulaByMoiety", element.getMolecularFormulaByMoietyElement(), -1);
    }
    if (element.hasMolecularWeight()) {
      composeSubstanceDefinitionMolecularWeightComponent(t, "SubstanceDefinitionStructureComponent", "molecularWeight", element.getMolecularWeight(), -1);
    }
    for (int i = 0; i < element.getTechnique().size(); i++) {
      composeCodeableConcept(t, "SubstanceDefinitionStructureComponent", "technique", element.getTechnique().get(i), i);
    }
    for (int i = 0; i < element.getSourceDocument().size(); i++) {
      composeReference(t, "SubstanceDefinitionStructureComponent", "sourceDocument", element.getSourceDocument().get(i), i);
    }
    for (int i = 0; i < element.getRepresentation().size(); i++) {
      composeSubstanceDefinitionStructureRepresentationComponent(t, "SubstanceDefinitionStructureComponent", "representation", element.getRepresentation().get(i), i);
    }
  }

  protected void composeSubstanceDefinitionStructureRepresentationComponent(Complex parent, String parentType, String name, SubstanceDefinition.SubstanceDefinitionStructureRepresentationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "representation", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "SubstanceDefinitionStructureRepresentationComponent", "type", element.getType(), -1);
    }
    if (element.hasRepresentationElement()) {
      composeString(t, "SubstanceDefinitionStructureRepresentationComponent", "representation", element.getRepresentationElement(), -1);
    }
    if (element.hasFormat()) {
      composeCodeableConcept(t, "SubstanceDefinitionStructureRepresentationComponent", "format", element.getFormat(), -1);
    }
    if (element.hasDocument()) {
      composeReference(t, "SubstanceDefinitionStructureRepresentationComponent", "document", element.getDocument(), -1);
    }
  }

  protected void composeSubstanceDefinitionCodeComponent(Complex parent, String parentType, String name, SubstanceDefinition.SubstanceDefinitionCodeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "code", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "SubstanceDefinitionCodeComponent", "code", element.getCode(), -1);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "SubstanceDefinitionCodeComponent", "status", element.getStatus(), -1);
    }
    if (element.hasStatusDateElement()) {
      composeDateTime(t, "SubstanceDefinitionCodeComponent", "statusDate", element.getStatusDateElement(), -1);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "SubstanceDefinitionCodeComponent", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getSource().size(); i++) {
      composeReference(t, "SubstanceDefinitionCodeComponent", "source", element.getSource().get(i), i);
    }
  }

  protected void composeSubstanceDefinitionNameComponent(Complex parent, String parentType, String name, SubstanceDefinition.SubstanceDefinitionNameComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "name", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "SubstanceDefinitionNameComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "SubstanceDefinitionNameComponent", "type", element.getType(), -1);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "SubstanceDefinitionNameComponent", "status", element.getStatus(), -1);
    }
    if (element.hasPreferredElement()) {
      composeBoolean(t, "SubstanceDefinitionNameComponent", "preferred", element.getPreferredElement(), -1);
    }
    for (int i = 0; i < element.getLanguage().size(); i++) {
      composeCodeableConcept(t, "SubstanceDefinitionNameComponent", "language", element.getLanguage().get(i), i);
    }
    for (int i = 0; i < element.getDomain().size(); i++) {
      composeCodeableConcept(t, "SubstanceDefinitionNameComponent", "domain", element.getDomain().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "SubstanceDefinitionNameComponent", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    for (int i = 0; i < element.getSynonym().size(); i++) {
      composeSubstanceDefinitionNameComponent(t, "SubstanceDefinitionNameComponent", "synonym", element.getSynonym().get(i), i);
    }
    for (int i = 0; i < element.getTranslation().size(); i++) {
      composeSubstanceDefinitionNameComponent(t, "SubstanceDefinitionNameComponent", "translation", element.getTranslation().get(i), i);
    }
    for (int i = 0; i < element.getOfficial().size(); i++) {
      composeSubstanceDefinitionNameOfficialComponent(t, "SubstanceDefinitionNameComponent", "official", element.getOfficial().get(i), i);
    }
    for (int i = 0; i < element.getSource().size(); i++) {
      composeReference(t, "SubstanceDefinitionNameComponent", "source", element.getSource().get(i), i);
    }
  }

  protected void composeSubstanceDefinitionNameOfficialComponent(Complex parent, String parentType, String name, SubstanceDefinition.SubstanceDefinitionNameOfficialComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "official", name, element, index);
    if (element.hasAuthority()) {
      composeCodeableConcept(t, "SubstanceDefinitionNameOfficialComponent", "authority", element.getAuthority(), -1);
    }
    if (element.hasStatus()) {
      composeCodeableConcept(t, "SubstanceDefinitionNameOfficialComponent", "status", element.getStatus(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "SubstanceDefinitionNameOfficialComponent", "date", element.getDateElement(), -1);
    }
  }

  protected void composeSubstanceDefinitionRelationshipComponent(Complex parent, String parentType, String name, SubstanceDefinition.SubstanceDefinitionRelationshipComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "relationship", name, element, index);
    if (element.hasSubstanceDefinition()) {
      composeType(t, "SubstanceDefinitionRelationshipComponent", "substanceDefinition", element.getSubstanceDefinition(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "SubstanceDefinitionRelationshipComponent", "type", element.getType(), -1);
    }
    if (element.hasIsDefiningElement()) {
      composeBoolean(t, "SubstanceDefinitionRelationshipComponent", "isDefining", element.getIsDefiningElement(), -1);
    }
    if (element.hasAmount()) {
      composeType(t, "SubstanceDefinitionRelationshipComponent", "amount", element.getAmount(), -1);
    }
    if (element.hasAmountRatioHighLimit()) {
      composeRatio(t, "SubstanceDefinitionRelationshipComponent", "amountRatioHighLimit", element.getAmountRatioHighLimit(), -1);
    }
    if (element.hasAmountType()) {
      composeCodeableConcept(t, "SubstanceDefinitionRelationshipComponent", "amountType", element.getAmountType(), -1);
    }
    for (int i = 0; i < element.getSource().size(); i++) {
      composeReference(t, "SubstanceDefinitionRelationshipComponent", "source", element.getSource().get(i), i);
    }
  }

  protected void composeSubstanceDefinitionSourceMaterialComponent(Complex parent, String parentType, String name, SubstanceDefinition.SubstanceDefinitionSourceMaterialComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "sourceMaterial", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "SubstanceDefinitionSourceMaterialComponent", "type", element.getType(), -1);
    }
    if (element.hasGenus()) {
      composeCodeableConcept(t, "SubstanceDefinitionSourceMaterialComponent", "genus", element.getGenus(), -1);
    }
    if (element.hasSpecies()) {
      composeCodeableConcept(t, "SubstanceDefinitionSourceMaterialComponent", "species", element.getSpecies(), -1);
    }
    if (element.hasPart()) {
      composeCodeableConcept(t, "SubstanceDefinitionSourceMaterialComponent", "part", element.getPart(), -1);
    }
    for (int i = 0; i < element.getCountryOfOrigin().size(); i++) {
      composeCodeableConcept(t, "SubstanceDefinitionSourceMaterialComponent", "countryOfOrigin", element.getCountryOfOrigin().get(i), i);
    }
  }

  protected void composeSupplyDelivery(Complex parent, String parentType, String name, SupplyDelivery element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "SupplyDelivery", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "SupplyDelivery", "identifier", element.getIdentifier().get(i), i);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "SupplyDelivery", "basedOn", element.getBasedOn().get(i), i);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "SupplyDelivery", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "SupplyDelivery", "status", element.getStatusElement(), -1);
    }
    if (element.hasPatient()) {
      composeReference(t, "SupplyDelivery", "patient", element.getPatient(), -1);
    }
    if (element.hasType()) {
      composeCodeableConcept(t, "SupplyDelivery", "type", element.getType(), -1);
    }
    if (element.hasSuppliedItem()) {
      composeSupplyDeliverySuppliedItemComponent(t, "SupplyDelivery", "suppliedItem", element.getSuppliedItem(), -1);
    }
    if (element.hasOccurrence()) {
      composeType(t, "SupplyDelivery", "occurrence", element.getOccurrence(), -1);
    }
    if (element.hasSupplier()) {
      composeReference(t, "SupplyDelivery", "supplier", element.getSupplier(), -1);
    }
    if (element.hasDestination()) {
      composeReference(t, "SupplyDelivery", "destination", element.getDestination(), -1);
    }
    for (int i = 0; i < element.getReceiver().size(); i++) {
      composeReference(t, "SupplyDelivery", "receiver", element.getReceiver().get(i), i);
    }
  }

  protected void composeSupplyDeliverySuppliedItemComponent(Complex parent, String parentType, String name, SupplyDelivery.SupplyDeliverySuppliedItemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "suppliedItem", name, element, index);
    if (element.hasQuantity()) {
      composeQuantity(t, "SupplyDeliverySuppliedItemComponent", "quantity", element.getQuantity(), -1);
    }
    if (element.hasItem()) {
      composeType(t, "SupplyDeliverySuppliedItemComponent", "item", element.getItem(), -1);
    }
  }

  protected void composeSupplyRequest(Complex parent, String parentType, String name, SupplyRequest element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "SupplyRequest", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "SupplyRequest", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "SupplyRequest", "status", element.getStatusElement(), -1);
    }
    if (element.hasCategory()) {
      composeCodeableConcept(t, "SupplyRequest", "category", element.getCategory(), -1);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "SupplyRequest", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasItem()) {
      composeType(t, "SupplyRequest", "item", element.getItem(), -1);
    }
    if (element.hasQuantity()) {
      composeQuantity(t, "SupplyRequest", "quantity", element.getQuantity(), -1);
    }
    for (int i = 0; i < element.getParameter().size(); i++) {
      composeSupplyRequestParameterComponent(t, "SupplyRequest", "parameter", element.getParameter().get(i), i);
    }
    if (element.hasOccurrence()) {
      composeType(t, "SupplyRequest", "occurrence", element.getOccurrence(), -1);
    }
    if (element.hasAuthoredOnElement()) {
      composeDateTime(t, "SupplyRequest", "authoredOn", element.getAuthoredOnElement(), -1);
    }
    if (element.hasRequester()) {
      composeReference(t, "SupplyRequest", "requester", element.getRequester(), -1);
    }
    for (int i = 0; i < element.getSupplier().size(); i++) {
      composeReference(t, "SupplyRequest", "supplier", element.getSupplier().get(i), i);
    }
    for (int i = 0; i < element.getReasonCode().size(); i++) {
      composeCodeableConcept(t, "SupplyRequest", "reasonCode", element.getReasonCode().get(i), i);
    }
    for (int i = 0; i < element.getReasonReference().size(); i++) {
      composeReference(t, "SupplyRequest", "reasonReference", element.getReasonReference().get(i), i);
    }
    if (element.hasDeliverFrom()) {
      composeReference(t, "SupplyRequest", "deliverFrom", element.getDeliverFrom(), -1);
    }
    if (element.hasDeliverTo()) {
      composeReference(t, "SupplyRequest", "deliverTo", element.getDeliverTo(), -1);
    }
  }

  protected void composeSupplyRequestParameterComponent(Complex parent, String parentType, String name, SupplyRequest.SupplyRequestParameterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "parameter", name, element, index);
    if (element.hasCode()) {
      composeCodeableConcept(t, "SupplyRequestParameterComponent", "code", element.getCode(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "SupplyRequestParameterComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeTask(Complex parent, String parentType, String name, Task element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "Task", name, element, index);
    for (int i = 0; i < element.getIdentifier().size(); i++) {
      composeIdentifier(t, "Task", "identifier", element.getIdentifier().get(i), i);
    }
    if (element.hasInstantiatesCanonicalElement()) {
      composeCanonical(t, "Task", "instantiatesCanonical", element.getInstantiatesCanonicalElement(), -1);
    }
    if (element.hasInstantiatesUriElement()) {
      composeUri(t, "Task", "instantiatesUri", element.getInstantiatesUriElement(), -1);
    }
    for (int i = 0; i < element.getBasedOn().size(); i++) {
      composeReference(t, "Task", "basedOn", element.getBasedOn().get(i), i);
    }
    if (element.hasGroupIdentifier()) {
      composeIdentifier(t, "Task", "groupIdentifier", element.getGroupIdentifier(), -1);
    }
    for (int i = 0; i < element.getPartOf().size(); i++) {
      composeReference(t, "Task", "partOf", element.getPartOf().get(i), i);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "Task", "status", element.getStatusElement(), -1);
    }
    if (element.hasStatusReason()) {
      composeCodeableConcept(t, "Task", "statusReason", element.getStatusReason(), -1);
    }
    if (element.hasBusinessStatus()) {
      composeCodeableConcept(t, "Task", "businessStatus", element.getBusinessStatus(), -1);
    }
    if (element.hasIntentElement()) {
      composeEnum(t, "Task", "intent", element.getIntentElement(), -1);
    }
    if (element.hasPriorityElement()) {
      composeEnum(t, "Task", "priority", element.getPriorityElement(), -1);
    }
    if (element.hasCode()) {
      composeCodeableConcept(t, "Task", "code", element.getCode(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "Task", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasFocus()) {
      composeReference(t, "Task", "focus", element.getFocus(), -1);
    }
    if (element.hasFor()) {
      composeReference(t, "Task", "for", element.getFor(), -1);
    }
    if (element.hasEncounter()) {
      composeReference(t, "Task", "encounter", element.getEncounter(), -1);
    }
    if (element.hasExecutionPeriod()) {
      composePeriod(t, "Task", "executionPeriod", element.getExecutionPeriod(), -1);
    }
    if (element.hasAuthoredOnElement()) {
      composeDateTime(t, "Task", "authoredOn", element.getAuthoredOnElement(), -1);
    }
    if (element.hasLastModifiedElement()) {
      composeDateTime(t, "Task", "lastModified", element.getLastModifiedElement(), -1);
    }
    if (element.hasRequester()) {
      composeReference(t, "Task", "requester", element.getRequester(), -1);
    }
    for (int i = 0; i < element.getPerformerType().size(); i++) {
      composeCodeableConcept(t, "Task", "performerType", element.getPerformerType().get(i), i);
    }
    if (element.hasOwner()) {
      composeReference(t, "Task", "owner", element.getOwner(), -1);
    }
    if (element.hasLocation()) {
      composeReference(t, "Task", "location", element.getLocation(), -1);
    }
    if (element.hasReasonCode()) {
      composeCodeableConcept(t, "Task", "reasonCode", element.getReasonCode(), -1);
    }
    if (element.hasReasonReference()) {
      composeReference(t, "Task", "reasonReference", element.getReasonReference(), -1);
    }
    for (int i = 0; i < element.getInsurance().size(); i++) {
      composeReference(t, "Task", "insurance", element.getInsurance().get(i), i);
    }
    for (int i = 0; i < element.getNote().size(); i++) {
      composeAnnotation(t, "Task", "note", element.getNote().get(i), i);
    }
    for (int i = 0; i < element.getRelevantHistory().size(); i++) {
      composeReference(t, "Task", "relevantHistory", element.getRelevantHistory().get(i), i);
    }
    if (element.hasRestriction()) {
      composeTaskRestrictionComponent(t, "Task", "restriction", element.getRestriction(), -1);
    }
    for (int i = 0; i < element.getInput().size(); i++) {
      composeTaskParameterComponent(t, "Task", "input", element.getInput().get(i), i);
    }
    for (int i = 0; i < element.getOutput().size(); i++) {
      composeTaskOutputComponent(t, "Task", "output", element.getOutput().get(i), i);
    }
  }

  protected void composeTaskRestrictionComponent(Complex parent, String parentType, String name, Task.TaskRestrictionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "restriction", name, element, index);
    if (element.hasRepetitionsElement()) {
      composePositiveInt(t, "TaskRestrictionComponent", "repetitions", element.getRepetitionsElement(), -1);
    }
    if (element.hasPeriod()) {
      composePeriod(t, "TaskRestrictionComponent", "period", element.getPeriod(), -1);
    }
    for (int i = 0; i < element.getRecipient().size(); i++) {
      composeReference(t, "TaskRestrictionComponent", "recipient", element.getRecipient().get(i), i);
    }
  }

  protected void composeTaskParameterComponent(Complex parent, String parentType, String name, Task.ParameterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "input", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "ParameterComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "ParameterComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeTaskOutputComponent(Complex parent, String parentType, String name, Task.TaskOutputComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "output", name, element, index);
    if (element.hasType()) {
      composeCodeableConcept(t, "TaskOutputComponent", "type", element.getType(), -1);
    }
    if (element.hasValue()) {
      composeType(t, "TaskOutputComponent", "value", element.getValue(), -1);
    }
  }

  protected void composeTerminologyCapabilities(Complex parent, String parentType, String name, TerminologyCapabilities element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "TerminologyCapabilities", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "TerminologyCapabilities", "url", element.getUrlElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "TerminologyCapabilities", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "TerminologyCapabilities", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "TerminologyCapabilities", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "TerminologyCapabilities", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "TerminologyCapabilities", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "TerminologyCapabilities", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "TerminologyCapabilities", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "TerminologyCapabilities", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "TerminologyCapabilities", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "TerminologyCapabilities", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "TerminologyCapabilities", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "TerminologyCapabilities", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "TerminologyCapabilities", "copyright", element.getCopyrightElement(), -1);
    }
    if (element.hasKindElement()) {
      composeEnum(t, "TerminologyCapabilities", "kind", element.getKindElement(), -1);
    }
    if (element.hasSoftware()) {
      composeTerminologyCapabilitiesSoftwareComponent(t, "TerminologyCapabilities", "software", element.getSoftware(), -1);
    }
    if (element.hasImplementation()) {
      composeTerminologyCapabilitiesImplementationComponent(t, "TerminologyCapabilities", "implementation", element.getImplementation(), -1);
    }
    if (element.hasLockedDateElement()) {
      composeBoolean(t, "TerminologyCapabilities", "lockedDate", element.getLockedDateElement(), -1);
    }
    for (int i = 0; i < element.getCodeSystem().size(); i++) {
      composeTerminologyCapabilitiesCodeSystemComponent(t, "TerminologyCapabilities", "codeSystem", element.getCodeSystem().get(i), i);
    }
    if (element.hasExpansion()) {
      composeTerminologyCapabilitiesExpansionComponent(t, "TerminologyCapabilities", "expansion", element.getExpansion(), -1);
    }
    if (element.hasCodeSearchElement()) {
      composeEnum(t, "TerminologyCapabilities", "codeSearch", element.getCodeSearchElement(), -1);
    }
    if (element.hasValidateCode()) {
      composeTerminologyCapabilitiesValidateCodeComponent(t, "TerminologyCapabilities", "validateCode", element.getValidateCode(), -1);
    }
    if (element.hasTranslation()) {
      composeTerminologyCapabilitiesTranslationComponent(t, "TerminologyCapabilities", "translation", element.getTranslation(), -1);
    }
    if (element.hasClosure()) {
      composeTerminologyCapabilitiesClosureComponent(t, "TerminologyCapabilities", "closure", element.getClosure(), -1);
    }
  }

  protected void composeTerminologyCapabilitiesSoftwareComponent(Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesSoftwareComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "software", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "TerminologyCapabilitiesSoftwareComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "TerminologyCapabilitiesSoftwareComponent", "version", element.getVersionElement(), -1);
    }
  }

  protected void composeTerminologyCapabilitiesImplementationComponent(Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesImplementationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "implementation", name, element, index);
    if (element.hasDescriptionElement()) {
      composeString(t, "TerminologyCapabilitiesImplementationComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasUrlElement()) {
      composeUrl(t, "TerminologyCapabilitiesImplementationComponent", "url", element.getUrlElement(), -1);
    }
  }

  protected void composeTerminologyCapabilitiesCodeSystemComponent(Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "codeSystem", name, element, index);
    if (element.hasUriElement()) {
      composeCanonical(t, "TerminologyCapabilitiesCodeSystemComponent", "uri", element.getUriElement(), -1);
    }
    for (int i = 0; i < element.getVersion().size(); i++) {
      composeTerminologyCapabilitiesCodeSystemVersionComponent(t, "TerminologyCapabilitiesCodeSystemComponent", "version", element.getVersion().get(i), i);
    }
    if (element.hasSubsumptionElement()) {
      composeBoolean(t, "TerminologyCapabilitiesCodeSystemComponent", "subsumption", element.getSubsumptionElement(), -1);
    }
  }

  protected void composeTerminologyCapabilitiesCodeSystemVersionComponent(Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "version", name, element, index);
    if (element.hasCodeElement()) {
      composeString(t, "TerminologyCapabilitiesCodeSystemVersionComponent", "code", element.getCodeElement(), -1);
    }
    if (element.hasIsDefaultElement()) {
      composeBoolean(t, "TerminologyCapabilitiesCodeSystemVersionComponent", "isDefault", element.getIsDefaultElement(), -1);
    }
    if (element.hasCompositionalElement()) {
      composeBoolean(t, "TerminologyCapabilitiesCodeSystemVersionComponent", "compositional", element.getCompositionalElement(), -1);
    }
    for (int i = 0; i < element.getLanguage().size(); i++) {
      composeCode(t, "TerminologyCapabilitiesCodeSystemVersionComponent", "language", element.getLanguage().get(i), i);
    }
    for (int i = 0; i < element.getFilter().size(); i++) {
      composeTerminologyCapabilitiesCodeSystemVersionFilterComponent(t, "TerminologyCapabilitiesCodeSystemVersionComponent", "filter", element.getFilter().get(i), i);
    }
    for (int i = 0; i < element.getProperty().size(); i++) {
      composeCode(t, "TerminologyCapabilitiesCodeSystemVersionComponent", "property", element.getProperty().get(i), i);
    }
  }

  protected void composeTerminologyCapabilitiesCodeSystemVersionFilterComponent(Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionFilterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "filter", name, element, index);
    if (element.hasCodeElement()) {
      composeCode(t, "TerminologyCapabilitiesCodeSystemVersionFilterComponent", "code", element.getCodeElement(), -1);
    }
    for (int i = 0; i < element.getOp().size(); i++) {
      composeCode(t, "TerminologyCapabilitiesCodeSystemVersionFilterComponent", "op", element.getOp().get(i), i);
    }
  }

  protected void composeTerminologyCapabilitiesExpansionComponent(Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesExpansionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "expansion", name, element, index);
    if (element.hasHierarchicalElement()) {
      composeBoolean(t, "TerminologyCapabilitiesExpansionComponent", "hierarchical", element.getHierarchicalElement(), -1);
    }
    if (element.hasPagingElement()) {
      composeBoolean(t, "TerminologyCapabilitiesExpansionComponent", "paging", element.getPagingElement(), -1);
    }
    if (element.hasIncompleteElement()) {
      composeBoolean(t, "TerminologyCapabilitiesExpansionComponent", "incomplete", element.getIncompleteElement(), -1);
    }
    for (int i = 0; i < element.getParameter().size(); i++) {
      composeTerminologyCapabilitiesExpansionParameterComponent(t, "TerminologyCapabilitiesExpansionComponent", "parameter", element.getParameter().get(i), i);
    }
    if (element.hasTextFilterElement()) {
      composeMarkdown(t, "TerminologyCapabilitiesExpansionComponent", "textFilter", element.getTextFilterElement(), -1);
    }
  }

  protected void composeTerminologyCapabilitiesExpansionParameterComponent(Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "parameter", name, element, index);
    if (element.hasNameElement()) {
      composeCode(t, "TerminologyCapabilitiesExpansionParameterComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDocumentationElement()) {
      composeString(t, "TerminologyCapabilitiesExpansionParameterComponent", "documentation", element.getDocumentationElement(), -1);
    }
  }

  protected void composeTerminologyCapabilitiesValidateCodeComponent(Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesValidateCodeComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "validateCode", name, element, index);
    if (element.hasTranslationsElement()) {
      composeBoolean(t, "TerminologyCapabilitiesValidateCodeComponent", "translations", element.getTranslationsElement(), -1);
    }
  }

  protected void composeTerminologyCapabilitiesTranslationComponent(Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesTranslationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "translation", name, element, index);
    if (element.hasNeedsMapElement()) {
      composeBoolean(t, "TerminologyCapabilitiesTranslationComponent", "needsMap", element.getNeedsMapElement(), -1);
    }
  }

  protected void composeTerminologyCapabilitiesClosureComponent(Complex parent, String parentType, String name, TerminologyCapabilities.TerminologyCapabilitiesClosureComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "closure", name, element, index);
    if (element.hasTranslationElement()) {
      composeBoolean(t, "TerminologyCapabilitiesClosureComponent", "translation", element.getTranslationElement(), -1);
    }
  }

  protected void composeTestReport(Complex parent, String parentType, String name, TestReport element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "TestReport", name, element, index);
    if (element.hasIdentifier()) {
      composeIdentifier(t, "TestReport", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "TestReport", "name", element.getNameElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "TestReport", "status", element.getStatusElement(), -1);
    }
    if (element.hasTestScript()) {
      composeReference(t, "TestReport", "testScript", element.getTestScript(), -1);
    }
    if (element.hasResultElement()) {
      composeEnum(t, "TestReport", "result", element.getResultElement(), -1);
    }
    if (element.hasScoreElement()) {
      composeDecimal(t, "TestReport", "score", element.getScoreElement(), -1);
    }
    if (element.hasTesterElement()) {
      composeString(t, "TestReport", "tester", element.getTesterElement(), -1);
    }
    if (element.hasIssuedElement()) {
      composeDateTime(t, "TestReport", "issued", element.getIssuedElement(), -1);
    }
    for (int i = 0; i < element.getParticipant().size(); i++) {
      composeTestReportParticipantComponent(t, "TestReport", "participant", element.getParticipant().get(i), i);
    }
    if (element.hasSetup()) {
      composeTestReportSetupComponent(t, "TestReport", "setup", element.getSetup(), -1);
    }
    for (int i = 0; i < element.getTest().size(); i++) {
      composeTestReportTestComponent(t, "TestReport", "test", element.getTest().get(i), i);
    }
    if (element.hasTeardown()) {
      composeTestReportTeardownComponent(t, "TestReport", "teardown", element.getTeardown(), -1);
    }
  }

  protected void composeTestReportParticipantComponent(Complex parent, String parentType, String name, TestReport.TestReportParticipantComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "participant", name, element, index);
    if (element.hasTypeElement()) {
      composeEnum(t, "TestReportParticipantComponent", "type", element.getTypeElement(), -1);
    }
    if (element.hasUriElement()) {
      composeUri(t, "TestReportParticipantComponent", "uri", element.getUriElement(), -1);
    }
    if (element.hasDisplayElement()) {
      composeString(t, "TestReportParticipantComponent", "display", element.getDisplayElement(), -1);
    }
  }

  protected void composeTestReportSetupComponent(Complex parent, String parentType, String name, TestReport.TestReportSetupComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "setup", name, element, index);
    for (int i = 0; i < element.getAction().size(); i++) {
      composeTestReportSetupActionComponent(t, "TestReportSetupComponent", "action", element.getAction().get(i), i);
    }
  }

  protected void composeTestReportSetupActionComponent(Complex parent, String parentType, String name, TestReport.SetupActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "action", name, element, index);
    if (element.hasOperation()) {
      composeTestReportSetupActionOperationComponent(t, "SetupActionComponent", "operation", element.getOperation(), -1);
    }
    if (element.hasAssert()) {
      composeTestReportSetupActionAssertComponent(t, "SetupActionComponent", "assert", element.getAssert(), -1);
    }
  }

  protected void composeTestReportSetupActionOperationComponent(Complex parent, String parentType, String name, TestReport.SetupActionOperationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "operation", name, element, index);
    if (element.hasResultElement()) {
      composeEnum(t, "SetupActionOperationComponent", "result", element.getResultElement(), -1);
    }
    if (element.hasMessageElement()) {
      composeMarkdown(t, "SetupActionOperationComponent", "message", element.getMessageElement(), -1);
    }
    if (element.hasDetailElement()) {
      composeUri(t, "SetupActionOperationComponent", "detail", element.getDetailElement(), -1);
    }
  }

  protected void composeTestReportSetupActionAssertComponent(Complex parent, String parentType, String name, TestReport.SetupActionAssertComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "assert", name, element, index);
    if (element.hasResultElement()) {
      composeEnum(t, "SetupActionAssertComponent", "result", element.getResultElement(), -1);
    }
    if (element.hasMessageElement()) {
      composeMarkdown(t, "SetupActionAssertComponent", "message", element.getMessageElement(), -1);
    }
    if (element.hasDetailElement()) {
      composeString(t, "SetupActionAssertComponent", "detail", element.getDetailElement(), -1);
    }
  }

  protected void composeTestReportTestComponent(Complex parent, String parentType, String name, TestReport.TestReportTestComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "test", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "TestReportTestComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "TestReportTestComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getAction().size(); i++) {
      composeTestReportTestActionComponent(t, "TestReportTestComponent", "action", element.getAction().get(i), i);
    }
  }

  protected void composeTestReportTestActionComponent(Complex parent, String parentType, String name, TestReport.TestActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "action", name, element, index);
    if (element.hasOperation()) {
      composeTestReportSetupActionOperationComponent(t, "TestActionComponent", "operation", element.getOperation(), -1);
    }
    if (element.hasAssert()) {
      composeTestReportSetupActionAssertComponent(t, "TestActionComponent", "assert", element.getAssert(), -1);
    }
  }

  protected void composeTestReportTeardownComponent(Complex parent, String parentType, String name, TestReport.TestReportTeardownComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "teardown", name, element, index);
    for (int i = 0; i < element.getAction().size(); i++) {
      composeTestReportTeardownActionComponent(t, "TestReportTeardownComponent", "action", element.getAction().get(i), i);
    }
  }

  protected void composeTestReportTeardownActionComponent(Complex parent, String parentType, String name, TestReport.TeardownActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "action", name, element, index);
    if (element.hasOperation()) {
      composeTestReportSetupActionOperationComponent(t, "TeardownActionComponent", "operation", element.getOperation(), -1);
    }
  }

  protected void composeTestScript(Complex parent, String parentType, String name, TestScript element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "TestScript", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "TestScript", "url", element.getUrlElement(), -1);
    }
    if (element.hasIdentifier()) {
      composeIdentifier(t, "TestScript", "identifier", element.getIdentifier(), -1);
    }
    if (element.hasVersionElement()) {
      composeString(t, "TestScript", "version", element.getVersionElement(), -1);
    }
    if (element.hasNameElement()) {
      composeString(t, "TestScript", "name", element.getNameElement(), -1);
    }
    if (element.hasTitleElement()) {
      composeString(t, "TestScript", "title", element.getTitleElement(), -1);
    }
    if (element.hasStatusElement()) {
      composeEnum(t, "TestScript", "status", element.getStatusElement(), -1);
    }
    if (element.hasExperimentalElement()) {
      composeBoolean(t, "TestScript", "experimental", element.getExperimentalElement(), -1);
    }
    if (element.hasDateElement()) {
      composeDateTime(t, "TestScript", "date", element.getDateElement(), -1);
    }
    if (element.hasPublisherElement()) {
      composeString(t, "TestScript", "publisher", element.getPublisherElement(), -1);
    }
    for (int i = 0; i < element.getContact().size(); i++) {
      composeContactDetail(t, "TestScript", "contact", element.getContact().get(i), i);
    }
    if (element.hasDescriptionElement()) {
      composeMarkdown(t, "TestScript", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getUseContext().size(); i++) {
      composeUsageContext(t, "TestScript", "useContext", element.getUseContext().get(i), i);
    }
    for (int i = 0; i < element.getJurisdiction().size(); i++) {
      composeCodeableConcept(t, "TestScript", "jurisdiction", element.getJurisdiction().get(i), i);
    }
    if (element.hasPurposeElement()) {
      composeMarkdown(t, "TestScript", "purpose", element.getPurposeElement(), -1);
    }
    if (element.hasCopyrightElement()) {
      composeMarkdown(t, "TestScript", "copyright", element.getCopyrightElement(), -1);
    }
    for (int i = 0; i < element.getOrigin().size(); i++) {
      composeTestScriptOriginComponent(t, "TestScript", "origin", element.getOrigin().get(i), i);
    }
    for (int i = 0; i < element.getDestination().size(); i++) {
      composeTestScriptDestinationComponent(t, "TestScript", "destination", element.getDestination().get(i), i);
    }
    if (element.hasMetadata()) {
      composeTestScriptMetadataComponent(t, "TestScript", "metadata", element.getMetadata(), -1);
    }
    for (int i = 0; i < element.getFixture().size(); i++) {
      composeTestScriptFixtureComponent(t, "TestScript", "fixture", element.getFixture().get(i), i);
    }
    for (int i = 0; i < element.getProfile().size(); i++) {
      composeReference(t, "TestScript", "profile", element.getProfile().get(i), i);
    }
    for (int i = 0; i < element.getVariable().size(); i++) {
      composeTestScriptVariableComponent(t, "TestScript", "variable", element.getVariable().get(i), i);
    }
    if (element.hasSetup()) {
      composeTestScriptSetupComponent(t, "TestScript", "setup", element.getSetup(), -1);
    }
    for (int i = 0; i < element.getTest().size(); i++) {
      composeTestScriptTestComponent(t, "TestScript", "test", element.getTest().get(i), i);
    }
    if (element.hasTeardown()) {
      composeTestScriptTeardownComponent(t, "TestScript", "teardown", element.getTeardown(), -1);
    }
  }

  protected void composeTestScriptOriginComponent(Complex parent, String parentType, String name, TestScript.TestScriptOriginComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "origin", name, element, index);
    if (element.hasIndexElement()) {
      composeInteger(t, "TestScriptOriginComponent", "index", element.getIndexElement(), -1);
    }
    if (element.hasProfile()) {
      composeCoding(t, "TestScriptOriginComponent", "profile", element.getProfile(), -1);
    }
  }

  protected void composeTestScriptDestinationComponent(Complex parent, String parentType, String name, TestScript.TestScriptDestinationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "destination", name, element, index);
    if (element.hasIndexElement()) {
      composeInteger(t, "TestScriptDestinationComponent", "index", element.getIndexElement(), -1);
    }
    if (element.hasProfile()) {
      composeCoding(t, "TestScriptDestinationComponent", "profile", element.getProfile(), -1);
    }
  }

  protected void composeTestScriptMetadataComponent(Complex parent, String parentType, String name, TestScript.TestScriptMetadataComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "metadata", name, element, index);
    for (int i = 0; i < element.getLink().size(); i++) {
      composeTestScriptMetadataLinkComponent(t, "TestScriptMetadataComponent", "link", element.getLink().get(i), i);
    }
    for (int i = 0; i < element.getCapability().size(); i++) {
      composeTestScriptMetadataCapabilityComponent(t, "TestScriptMetadataComponent", "capability", element.getCapability().get(i), i);
    }
  }

  protected void composeTestScriptMetadataLinkComponent(Complex parent, String parentType, String name, TestScript.TestScriptMetadataLinkComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "link", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "TestScriptMetadataLinkComponent", "url", element.getUrlElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "TestScriptMetadataLinkComponent", "description", element.getDescriptionElement(), -1);
    }
  }

  protected void composeTestScriptMetadataCapabilityComponent(Complex parent, String parentType, String name, TestScript.TestScriptMetadataCapabilityComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "capability", name, element, index);
    if (element.hasRequiredElement()) {
      composeBoolean(t, "TestScriptMetadataCapabilityComponent", "required", element.getRequiredElement(), -1);
    }
    if (element.hasValidatedElement()) {
      composeBoolean(t, "TestScriptMetadataCapabilityComponent", "validated", element.getValidatedElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "TestScriptMetadataCapabilityComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getOrigin().size(); i++) {
      composeInteger(t, "TestScriptMetadataCapabilityComponent", "origin", element.getOrigin().get(i), i);
    }
    if (element.hasDestinationElement()) {
      composeInteger(t, "TestScriptMetadataCapabilityComponent", "destination", element.getDestinationElement(), -1);
    }
    for (int i = 0; i < element.getLink().size(); i++) {
      composeUri(t, "TestScriptMetadataCapabilityComponent", "link", element.getLink().get(i), i);
    }
    if (element.hasCapabilitiesElement()) {
      composeCanonical(t, "TestScriptMetadataCapabilityComponent", "capabilities", element.getCapabilitiesElement(), -1);
    }
  }

  protected void composeTestScriptFixtureComponent(Complex parent, String parentType, String name, TestScript.TestScriptFixtureComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "fixture", name, element, index);
    if (element.hasAutocreateElement()) {
      composeBoolean(t, "TestScriptFixtureComponent", "autocreate", element.getAutocreateElement(), -1);
    }
    if (element.hasAutodeleteElement()) {
      composeBoolean(t, "TestScriptFixtureComponent", "autodelete", element.getAutodeleteElement(), -1);
    }
    if (element.hasResource()) {
      composeReference(t, "TestScriptFixtureComponent", "resource", element.getResource(), -1);
    }
  }

  protected void composeTestScriptVariableComponent(Complex parent, String parentType, String name, TestScript.TestScriptVariableComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "variable", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "TestScriptVariableComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDefaultValueElement()) {
      composeString(t, "TestScriptVariableComponent", "defaultValue", element.getDefaultValueElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "TestScriptVariableComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasExpressionElement()) {
      composeString(t, "TestScriptVariableComponent", "expression", element.getExpressionElement(), -1);
    }
    if (element.hasHeaderFieldElement()) {
      composeString(t, "TestScriptVariableComponent", "headerField", element.getHeaderFieldElement(), -1);
    }
    if (element.hasHintElement()) {
      composeString(t, "TestScriptVariableComponent", "hint", element.getHintElement(), -1);
    }
    if (element.hasPathElement()) {
      composeString(t, "TestScriptVariableComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasSourceIdElement()) {
      composeId(t, "TestScriptVariableComponent", "sourceId", element.getSourceIdElement(), -1);
    }
  }

  protected void composeTestScriptSetupComponent(Complex parent, String parentType, String name, TestScript.TestScriptSetupComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "setup", name, element, index);
    for (int i = 0; i < element.getAction().size(); i++) {
      composeTestScriptSetupActionComponent(t, "TestScriptSetupComponent", "action", element.getAction().get(i), i);
    }
  }

  protected void composeTestScriptSetupActionComponent(Complex parent, String parentType, String name, TestScript.SetupActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "action", name, element, index);
    if (element.hasOperation()) {
      composeTestScriptSetupActionOperationComponent(t, "SetupActionComponent", "operation", element.getOperation(), -1);
    }
    if (element.hasAssert()) {
      composeTestScriptSetupActionAssertComponent(t, "SetupActionComponent", "assert", element.getAssert(), -1);
    }
  }

  protected void composeTestScriptSetupActionOperationComponent(Complex parent, String parentType, String name, TestScript.SetupActionOperationComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "operation", name, element, index);
    if (element.hasType()) {
      composeCoding(t, "SetupActionOperationComponent", "type", element.getType(), -1);
    }
    if (element.hasResourceElement()) {
      composeEnum(t, "SetupActionOperationComponent", "resource", element.getResourceElement(), -1);
    }
    if (element.hasLabelElement()) {
      composeString(t, "SetupActionOperationComponent", "label", element.getLabelElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "SetupActionOperationComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasAcceptElement()) {
      composeCode(t, "SetupActionOperationComponent", "accept", element.getAcceptElement(), -1);
    }
    if (element.hasContentTypeElement()) {
      composeCode(t, "SetupActionOperationComponent", "contentType", element.getContentTypeElement(), -1);
    }
    if (element.hasDestinationElement()) {
      composeInteger(t, "SetupActionOperationComponent", "destination", element.getDestinationElement(), -1);
    }
    if (element.hasEncodeRequestUrlElement()) {
      composeBoolean(t, "SetupActionOperationComponent", "encodeRequestUrl", element.getEncodeRequestUrlElement(), -1);
    }
    if (element.hasMethodElement()) {
      composeEnum(t, "SetupActionOperationComponent", "method", element.getMethodElement(), -1);
    }
    if (element.hasOriginElement()) {
      composeInteger(t, "SetupActionOperationComponent", "origin", element.getOriginElement(), -1);
    }
    if (element.hasParamsElement()) {
      composeString(t, "SetupActionOperationComponent", "params", element.getParamsElement(), -1);
    }
    for (int i = 0; i < element.getRequestHeader().size(); i++) {
      composeTestScriptSetupActionOperationRequestHeaderComponent(t, "SetupActionOperationComponent", "requestHeader", element.getRequestHeader().get(i), i);
    }
    if (element.hasRequestIdElement()) {
      composeId(t, "SetupActionOperationComponent", "requestId", element.getRequestIdElement(), -1);
    }
    if (element.hasResponseIdElement()) {
      composeId(t, "SetupActionOperationComponent", "responseId", element.getResponseIdElement(), -1);
    }
    if (element.hasSourceIdElement()) {
      composeId(t, "SetupActionOperationComponent", "sourceId", element.getSourceIdElement(), -1);
    }
    if (element.hasTargetIdElement()) {
      composeId(t, "SetupActionOperationComponent", "targetId", element.getTargetIdElement(), -1);
    }
    if (element.hasUrlElement()) {
      composeString(t, "SetupActionOperationComponent", "url", element.getUrlElement(), -1);
    }
  }

  protected void composeTestScriptSetupActionOperationRequestHeaderComponent(Complex parent, String parentType, String name, TestScript.SetupActionOperationRequestHeaderComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "requestHeader", name, element, index);
    if (element.hasFieldElement()) {
      composeString(t, "SetupActionOperationRequestHeaderComponent", "field", element.getFieldElement(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "SetupActionOperationRequestHeaderComponent", "value", element.getValueElement(), -1);
    }
  }

  protected void composeTestScriptSetupActionAssertComponent(Complex parent, String parentType, String name, TestScript.SetupActionAssertComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "assert", name, element, index);
    if (element.hasLabelElement()) {
      composeString(t, "SetupActionAssertComponent", "label", element.getLabelElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "SetupActionAssertComponent", "description", element.getDescriptionElement(), -1);
    }
    if (element.hasDirectionElement()) {
      composeEnum(t, "SetupActionAssertComponent", "direction", element.getDirectionElement(), -1);
    }
    if (element.hasCompareToSourceIdElement()) {
      composeString(t, "SetupActionAssertComponent", "compareToSourceId", element.getCompareToSourceIdElement(), -1);
    }
    if (element.hasCompareToSourceExpressionElement()) {
      composeString(t, "SetupActionAssertComponent", "compareToSourceExpression", element.getCompareToSourceExpressionElement(), -1);
    }
    if (element.hasCompareToSourcePathElement()) {
      composeString(t, "SetupActionAssertComponent", "compareToSourcePath", element.getCompareToSourcePathElement(), -1);
    }
    if (element.hasContentTypeElement()) {
      composeCode(t, "SetupActionAssertComponent", "contentType", element.getContentTypeElement(), -1);
    }
    if (element.hasExpressionElement()) {
      composeString(t, "SetupActionAssertComponent", "expression", element.getExpressionElement(), -1);
    }
    if (element.hasHeaderFieldElement()) {
      composeString(t, "SetupActionAssertComponent", "headerField", element.getHeaderFieldElement(), -1);
    }
    if (element.hasMinimumIdElement()) {
      composeString(t, "SetupActionAssertComponent", "minimumId", element.getMinimumIdElement(), -1);
    }
    if (element.hasNavigationLinksElement()) {
      composeBoolean(t, "SetupActionAssertComponent", "navigationLinks", element.getNavigationLinksElement(), -1);
    }
    if (element.hasOperatorElement()) {
      composeEnum(t, "SetupActionAssertComponent", "operator", element.getOperatorElement(), -1);
    }
    if (element.hasPathElement()) {
      composeString(t, "SetupActionAssertComponent", "path", element.getPathElement(), -1);
    }
    if (element.hasRequestMethodElement()) {
      composeEnum(t, "SetupActionAssertComponent", "requestMethod", element.getRequestMethodElement(), -1);
    }
    if (element.hasRequestURLElement()) {
      composeString(t, "SetupActionAssertComponent", "requestURL", element.getRequestURLElement(), -1);
    }
    if (element.hasResourceElement()) {
      composeEnum(t, "SetupActionAssertComponent", "resource", element.getResourceElement(), -1);
    }
    if (element.hasResponseElement()) {
      composeEnum(t, "SetupActionAssertComponent", "response", element.getResponseElement(), -1);
    }
    if (element.hasResponseCodeElement()) {
      composeString(t, "SetupActionAssertComponent", "responseCode", element.getResponseCodeElement(), -1);
    }
    if (element.hasSourceIdElement()) {
      composeId(t, "SetupActionAssertComponent", "sourceId", element.getSourceIdElement(), -1);
    }
    if (element.hasValidateProfileIdElement()) {
      composeId(t, "SetupActionAssertComponent", "validateProfileId", element.getValidateProfileIdElement(), -1);
    }
    if (element.hasValueElement()) {
      composeString(t, "SetupActionAssertComponent", "value", element.getValueElement(), -1);
    }
    if (element.hasWarningOnlyElement()) {
      composeBoolean(t, "SetupActionAssertComponent", "warningOnly", element.getWarningOnlyElement(), -1);
    }
  }

  protected void composeTestScriptTestComponent(Complex parent, String parentType, String name, TestScript.TestScriptTestComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "test", name, element, index);
    if (element.hasNameElement()) {
      composeString(t, "TestScriptTestComponent", "name", element.getNameElement(), -1);
    }
    if (element.hasDescriptionElement()) {
      composeString(t, "TestScriptTestComponent", "description", element.getDescriptionElement(), -1);
    }
    for (int i = 0; i < element.getAction().size(); i++) {
      composeTestScriptTestActionComponent(t, "TestScriptTestComponent", "action", element.getAction().get(i), i);
    }
  }

  protected void composeTestScriptTestActionComponent(Complex parent, String parentType, String name, TestScript.TestActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "action", name, element, index);
    if (element.hasOperation()) {
      composeTestScriptSetupActionOperationComponent(t, "TestActionComponent", "operation", element.getOperation(), -1);
    }
    if (element.hasAssert()) {
      composeTestScriptSetupActionAssertComponent(t, "TestActionComponent", "assert", element.getAssert(), -1);
    }
  }

  protected void composeTestScriptTeardownComponent(Complex parent, String parentType, String name, TestScript.TestScriptTeardownComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "teardown", name, element, index);
    for (int i = 0; i < element.getAction().size(); i++) {
      composeTestScriptTeardownActionComponent(t, "TestScriptTeardownComponent", "action", element.getAction().get(i), i);
    }
  }

  protected void composeTestScriptTeardownActionComponent(Complex parent, String parentType, String name, TestScript.TeardownActionComponent element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeBackboneElement(t, "action", name, element, index);
    if (element.hasOperation()) {
      composeTestScriptSetupActionOperationComponent(t, "TeardownActionComponent", "operation", element.getOperation(), -1);
    }
  }

  protected void composeValueSet(Complex parent, String parentType, String name, ValueSet element, int index) {
    if (element == null) 
      return;
    Complex t;
    if (Utilities.noString(parentType))
      t = parent;
    else {
      t = parent.predicate("fhir:"+parentType+'.'+name);
    }
    composeDomainResource(t, "ValueSet", name, element, index);
    if (element.hasUrlElement()) {
      composeUri(t, "ValueSet", "url", element.getUrlElement(), -1);
    }
    for (int i = 0; i < element.getIdentifier().size(); i+