/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.Type;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ActivityDefinition", profile="http://hl7.org/fhir/StructureDefinition/ActivityDefinition")
@ChildOrder(names={"url", "identifier", "version", "name", "title", "subtitle", "status", "experimental", "subject[x]", "date", "publisher", "contact", "description", "useContext", "jurisdiction", "purpose", "usage", "copyright", "approvalDate", "lastReviewDate", "effectivePeriod", "topic", "author", "editor", "reviewer", "endorser", "relatedArtifact", "library", "kind", "profile", "code", "intent", "priority", "doNotPerform", "timing[x]", "location", "participant", "product[x]", "quantity", "dosage", "bodySite", "specimenRequirement", "observationRequirement", "observationResultRequirement", "transform", "dynamicValue"})
public class ActivityDefinition
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the activity definition", formalDefinition="A formal identifier that is used to identify this activity definition when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="subtitle", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Subordinate title of the activity definition", formalDefinition="An explanatory or alternate title for the activity definition giving additional information about its content.")
    protected StringType subtitle;
    @Child(name="subject", type={CodeableConcept.class, Group.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type of individual the activity definition is intended for", formalDefinition="A code or group definition that describes the intended subject of the activity being defined.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/subject-type")
    protected Type subject;
    @Child(name="purpose", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this activity definition is defined", formalDefinition="Explanation of why this activity definition is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="usage", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Describes the clinical usage of the activity definition", formalDefinition="A detailed description of how the activity definition is used from a clinical perspective.")
    protected StringType usage;
    @Child(name="copyright", type={MarkdownType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the activity definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the activity definition.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the activity definition was approved by publisher", formalDefinition="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the activity definition was last reviewed", formalDefinition="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the activity definition is expected to be used", formalDefinition="The period during which the activity definition content was or is planned to be in active use.")
    protected Period effectivePeriod;
    @Child(name="topic", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="E.g. Education, Treatment, Assessment, etc.", formalDefinition="Descriptive topics related to the content of the activity. Topics provide a high-level categorization of the activity that can be useful for filtering and searching.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/definition-topic")
    protected List<CodeableConcept> topic;
    @Child(name="author", type={ContactDetail.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who authored the content", formalDefinition="An individiual or organization primarily involved in the creation and maintenance of the content.")
    protected List<ContactDetail> author;
    @Child(name="editor", type={ContactDetail.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who edited the content", formalDefinition="An individual or organization primarily responsible for internal coherence of the content.")
    protected List<ContactDetail> editor;
    @Child(name="reviewer", type={ContactDetail.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who reviewed the content", formalDefinition="An individual or organization primarily responsible for review of some aspect of the content.")
    protected List<ContactDetail> reviewer;
    @Child(name="endorser", type={ContactDetail.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who endorsed the content", formalDefinition="An individual or organization responsible for officially endorsing the content for use in some setting.")
    protected List<ContactDetail> endorser;
    @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional documentation, citations, etc.", formalDefinition="Related artifacts such as additional documentation, justification, or bibliographic references.")
    protected List<RelatedArtifact> relatedArtifact;
    @Child(name="library", type={CanonicalType.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Logic used by the activity definition", formalDefinition="A reference to a Library resource containing any formal logic used by the activity definition.")
    protected List<CanonicalType> library;
    @Child(name="kind", type={CodeType.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of resource", formalDefinition="A description of the kind of resource the activity definition is representing. For example, a MedicationRequest, a ServiceRequest, or a CommunicationRequest. Typically, but not always, this is a Request resource.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-resource-types")
    protected Enumeration<ActivityDefinitionKind> kind;
    @Child(name="profile", type={CanonicalType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What profile the resource needs to conform to", formalDefinition="A profile to which the target of the activity definition is expected to conform.")
    protected CanonicalType profile;
    @Child(name="code", type={CodeableConcept.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Detail type of activity", formalDefinition="Detailed description of the type of activity; e.g. What lab test, what procedure, what kind of encounter.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-code")
    protected CodeableConcept code;
    @Child(name="intent", type={CodeType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="proposal | plan | order", formalDefinition="Indicates the level of authority/intentionality associated with the activity and where the request should fit into the workflow chain.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-intent")
    protected Enumeration<RequestIntent> intent;
    @Child(name="priority", type={CodeType.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="routine | urgent | asap | stat", formalDefinition="Indicates how quickly the activity  should be addressed with respect to other requests.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
    protected Enumeration<RequestPriority> priority;
    @Child(name="doNotPerform", type={BooleanType.class}, order=21, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="True if the activity should not be performed", formalDefinition="Set this to true if the definition is to indicate that a particular activity should NOT be performed. If true, this element should be interpreted to reinforce a negative coding. For example NPO as a code with a doNotPerform of true would still indicate to NOT perform the action.")
    protected BooleanType doNotPerform;
    @Child(name="timing", type={Timing.class, DateTimeType.class, Age.class, Period.class, Range.class, Duration.class}, order=22, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When activity is to occur", formalDefinition="The period, timing or frequency upon which the described activity is to occur.")
    protected Type timing;
    @Child(name="location", type={Location.class}, order=23, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where it should happen", formalDefinition="Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.")
    protected Reference location;
    protected Location locationTarget;
    @Child(name="participant", type={}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Who should participate in the action", formalDefinition="Indicates who should participate in performing the action described.")
    protected List<ActivityDefinitionParticipantComponent> participant;
    @Child(name="product", type={Medication.class, Substance.class, CodeableConcept.class}, order=25, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What's administered/supplied", formalDefinition="Identifies the food, drug or other product being consumed or supplied in the activity.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-codes")
    protected Type product;
    @Child(name="quantity", type={Quantity.class}, order=26, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How much is administered/consumed/supplied", formalDefinition="Identifies the quantity expected to be consumed at once (per dose, per meal, etc.).")
    protected Quantity quantity;
    @Child(name="dosage", type={Dosage.class}, order=27, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Detailed dosage instructions", formalDefinition="Provides detailed dosage instructions in the same way that they are described for MedicationRequest resources.")
    protected List<Dosage> dosage;
    @Child(name="bodySite", type={CodeableConcept.class}, order=28, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What part of body to perform on", formalDefinition="Indicates the sites on the subject's body where the procedure should be performed (I.e. the target sites).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected List<CodeableConcept> bodySite;
    @Child(name="specimenRequirement", type={SpecimenDefinition.class}, order=29, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What specimens are required to perform this action", formalDefinition="Defines specimen requirements for the action to be performed, such as required specimens for a lab test.")
    protected List<Reference> specimenRequirement;
    protected List<SpecimenDefinition> specimenRequirementTarget;
    @Child(name="observationRequirement", type={ObservationDefinition.class}, order=30, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What observations are required to perform this action", formalDefinition="Defines observation requirements for the action to be performed, such as body weight or surface area.")
    protected List<Reference> observationRequirement;
    protected List<ObservationDefinition> observationRequirementTarget;
    @Child(name="observationResultRequirement", type={ObservationDefinition.class}, order=31, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What observations must be produced by this action", formalDefinition="Defines the observations that are expected to be produced by the action.")
    protected List<Reference> observationResultRequirement;
    protected List<ObservationDefinition> observationResultRequirementTarget;
    @Child(name="transform", type={CanonicalType.class}, order=32, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Transform to apply the template", formalDefinition="A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.")
    protected CanonicalType transform;
    @Child(name="dynamicValue", type={}, order=33, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Dynamic aspects of the definition", formalDefinition="Dynamic values that will be evaluated to produce values for elements of the resulting resource. For example, if the dosage of a medication must be computed based on the patient's weight, a dynamic value would be used to specify an expression that calculated the weight, and the path on the request resource that would contain the result.")
    protected List<ActivityDefinitionDynamicValueComponent> dynamicValue;
    private static final long serialVersionUID = 1488459022L;
    @SearchParamDefinition(name="date", path="ActivityDefinition.date", description="The activity definition publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ActivityDefinition.identifier", description="External identifier for the activity definition", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="successor", path="ActivityDefinition.relatedArtifact.where(type='successor').resource", description="What resource is being referenced", type="reference")
    public static final String SP_SUCCESSOR = "successor";
    public static final ReferenceClientParam SUCCESSOR = new ReferenceClientParam("successor");
    public static final Include INCLUDE_SUCCESSOR = new Include("ActivityDefinition:successor").toLocked();
    @SearchParamDefinition(name="context-type-value", path="ActivityDefinition.useContext", description="A use context type and value assigned to the activity definition", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="jurisdiction", path="ActivityDefinition.jurisdiction", description="Intended jurisdiction for the activity definition", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="ActivityDefinition.description", description="The description of the activity definition", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="derived-from", path="ActivityDefinition.relatedArtifact.where(type='derived-from').resource", description="What resource is being referenced", type="reference")
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final ReferenceClientParam DERIVED_FROM = new ReferenceClientParam("derived-from");
    public static final Include INCLUDE_DERIVED_FROM = new Include("ActivityDefinition:derived-from").toLocked();
    @SearchParamDefinition(name="context-type", path="ActivityDefinition.useContext.code", description="A type of use context assigned to the activity definition", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="predecessor", path="ActivityDefinition.relatedArtifact.where(type='predecessor').resource", description="What resource is being referenced", type="reference")
    public static final String SP_PREDECESSOR = "predecessor";
    public static final ReferenceClientParam PREDECESSOR = new ReferenceClientParam("predecessor");
    public static final Include INCLUDE_PREDECESSOR = new Include("ActivityDefinition:predecessor").toLocked();
    @SearchParamDefinition(name="title", path="ActivityDefinition.title", description="The human-friendly name of the activity definition", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="composed-of", path="ActivityDefinition.relatedArtifact.where(type='composed-of').resource", description="What resource is being referenced", type="reference")
    public static final String SP_COMPOSED_OF = "composed-of";
    public static final ReferenceClientParam COMPOSED_OF = new ReferenceClientParam("composed-of");
    public static final Include INCLUDE_COMPOSED_OF = new Include("ActivityDefinition:composed-of").toLocked();
    @SearchParamDefinition(name="version", path="ActivityDefinition.version", description="The business version of the activity definition", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="ActivityDefinition.url", description="The uri that identifies the activity definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="context-quantity", path="(ActivityDefinition.useContext.value as Quantity) | (ActivityDefinition.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the activity definition", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="effective", path="ActivityDefinition.effectivePeriod", description="The time during which the activity definition is intended to be in use", type="date")
    public static final String SP_EFFECTIVE = "effective";
    public static final DateClientParam EFFECTIVE = new DateClientParam("effective");
    @SearchParamDefinition(name="depends-on", path="ActivityDefinition.relatedArtifact.where(type='depends-on').resource | ActivityDefinition.library", description="What resource is being referenced", type="reference")
    public static final String SP_DEPENDS_ON = "depends-on";
    public static final ReferenceClientParam DEPENDS_ON = new ReferenceClientParam("depends-on");
    public static final Include INCLUDE_DEPENDS_ON = new Include("ActivityDefinition:depends-on").toLocked();
    @SearchParamDefinition(name="name", path="ActivityDefinition.name", description="Computationally friendly name of the activity definition", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="(ActivityDefinition.useContext.value as CodeableConcept)", description="A use context assigned to the activity definition", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="publisher", path="ActivityDefinition.publisher", description="Name of the publisher of the activity definition", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="topic", path="ActivityDefinition.topic", description="Topics associated with the module", type="token")
    public static final String SP_TOPIC = "topic";
    public static final TokenClientParam TOPIC = new TokenClientParam("topic");
    @SearchParamDefinition(name="context-type-quantity", path="ActivityDefinition.useContext", description="A use context type and quantity- or range-based value assigned to the activity definition", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="status", path="ActivityDefinition.status", description="The current status of the activity definition", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ActivityDefinition() {
    }

    public ActivityDefinition(Enumeration<Enumerations.PublicationStatus> status) {
        this.status = status;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ActivityDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ActivityDefinition setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ActivityDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ActivityDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ActivityDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ActivityDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ActivityDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ActivityDefinition setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public ActivityDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public ActivityDefinition setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public StringType getSubtitleElement() {
        if (this.subtitle == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.subtitle");
            }
            if (Configuration.doAutoCreate()) {
                this.subtitle = new StringType();
            }
        }
        return this.subtitle;
    }

    public boolean hasSubtitleElement() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public boolean hasSubtitle() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public ActivityDefinition setSubtitleElement(StringType value) {
        this.subtitle = value;
        return this;
    }

    public String getSubtitle() {
        return this.subtitle == null ? null : (String)this.subtitle.getValue();
    }

    public ActivityDefinition setSubtitle(String value) {
        if (Utilities.noString((String)value)) {
            this.subtitle = null;
        } else {
            if (this.subtitle == null) {
                this.subtitle = new StringType();
            }
            this.subtitle.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ActivityDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ActivityDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ActivityDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ActivityDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public Type getSubject() {
        return this.subject;
    }

    public CodeableConcept getSubjectCodeableConcept() throws FHIRException {
        if (this.subject == null) {
            this.subject = new CodeableConcept();
        }
        if (!(this.subject instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.subject.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.subject;
    }

    public boolean hasSubjectCodeableConcept() {
        return this != null && this.subject instanceof CodeableConcept;
    }

    public Reference getSubjectReference() throws FHIRException {
        if (this.subject == null) {
            this.subject = new Reference();
        }
        if (!(this.subject instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.subject.getClass().getName() + " was encountered");
        }
        return (Reference)this.subject;
    }

    public boolean hasSubjectReference() {
        return this != null && this.subject instanceof Reference;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ActivityDefinition setSubject(Type value) {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new Error("Not the right type for ActivityDefinition.subject[x]: " + value.fhirType());
        }
        this.subject = value;
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ActivityDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ActivityDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ActivityDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ActivityDefinition setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public ActivityDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ActivityDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ActivityDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ActivityDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public ActivityDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ActivityDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public ActivityDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ActivityDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public ActivityDefinition setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public ActivityDefinition setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public StringType getUsageElement() {
        if (this.usage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.usage");
            }
            if (Configuration.doAutoCreate()) {
                this.usage = new StringType();
            }
        }
        return this.usage;
    }

    public boolean hasUsageElement() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public boolean hasUsage() {
        return this.usage != null && !this.usage.isEmpty();
    }

    public ActivityDefinition setUsageElement(StringType value) {
        this.usage = value;
        return this;
    }

    public String getUsage() {
        return this.usage == null ? null : (String)this.usage.getValue();
    }

    public ActivityDefinition setUsage(String value) {
        if (Utilities.noString((String)value)) {
            this.usage = null;
        } else {
            if (this.usage == null) {
                this.usage = new StringType();
            }
            this.usage.setValue(value);
        }
        return this;
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public ActivityDefinition setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public ActivityDefinition setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public ActivityDefinition setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public ActivityDefinition setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public ActivityDefinition setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public ActivityDefinition setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public ActivityDefinition setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    public List<CodeableConcept> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        return this.topic;
    }

    public ActivityDefinition setTopic(List<CodeableConcept> theTopic) {
        this.topic = theTopic;
        return this;
    }

    public boolean hasTopic() {
        if (this.topic == null) {
            return false;
        }
        for (CodeableConcept item : this.topic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addTopic() {
        CodeableConcept t = new CodeableConcept();
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return t;
    }

    public ActivityDefinition addTopic(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.topic == null) {
            this.topic = new ArrayList<CodeableConcept>();
        }
        this.topic.add(t);
        return this;
    }

    public CodeableConcept getTopicFirstRep() {
        if (this.getTopic().isEmpty()) {
            this.addTopic();
        }
        return this.getTopic().get(0);
    }

    public List<ContactDetail> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        return this.author;
    }

    public ActivityDefinition setAuthor(List<ContactDetail> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (ContactDetail item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addAuthor() {
        ContactDetail t = new ContactDetail();
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return t;
    }

    public ActivityDefinition addAuthor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<ContactDetail>();
        }
        this.author.add(t);
        return this;
    }

    public ContactDetail getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    public List<ContactDetail> getEditor() {
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        return this.editor;
    }

    public ActivityDefinition setEditor(List<ContactDetail> theEditor) {
        this.editor = theEditor;
        return this;
    }

    public boolean hasEditor() {
        if (this.editor == null) {
            return false;
        }
        for (ContactDetail item : this.editor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addEditor() {
        ContactDetail t = new ContactDetail();
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return t;
    }

    public ActivityDefinition addEditor(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.editor == null) {
            this.editor = new ArrayList<ContactDetail>();
        }
        this.editor.add(t);
        return this;
    }

    public ContactDetail getEditorFirstRep() {
        if (this.getEditor().isEmpty()) {
            this.addEditor();
        }
        return this.getEditor().get(0);
    }

    public List<ContactDetail> getReviewer() {
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        return this.reviewer;
    }

    public ActivityDefinition setReviewer(List<ContactDetail> theReviewer) {
        this.reviewer = theReviewer;
        return this;
    }

    public boolean hasReviewer() {
        if (this.reviewer == null) {
            return false;
        }
        for (ContactDetail item : this.reviewer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addReviewer() {
        ContactDetail t = new ContactDetail();
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return t;
    }

    public ActivityDefinition addReviewer(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.reviewer == null) {
            this.reviewer = new ArrayList<ContactDetail>();
        }
        this.reviewer.add(t);
        return this;
    }

    public ContactDetail getReviewerFirstRep() {
        if (this.getReviewer().isEmpty()) {
            this.addReviewer();
        }
        return this.getReviewer().get(0);
    }

    public List<ContactDetail> getEndorser() {
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        return this.endorser;
    }

    public ActivityDefinition setEndorser(List<ContactDetail> theEndorser) {
        this.endorser = theEndorser;
        return this;
    }

    public boolean hasEndorser() {
        if (this.endorser == null) {
            return false;
        }
        for (ContactDetail item : this.endorser) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addEndorser() {
        ContactDetail t = new ContactDetail();
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return t;
    }

    public ActivityDefinition addEndorser(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.endorser == null) {
            this.endorser = new ArrayList<ContactDetail>();
        }
        this.endorser.add(t);
        return this;
    }

    public ContactDetail getEndorserFirstRep() {
        if (this.getEndorser().isEmpty()) {
            this.addEndorser();
        }
        return this.getEndorser().get(0);
    }

    public List<RelatedArtifact> getRelatedArtifact() {
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        return this.relatedArtifact;
    }

    public ActivityDefinition setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
        this.relatedArtifact = theRelatedArtifact;
        return this;
    }

    public boolean hasRelatedArtifact() {
        if (this.relatedArtifact == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatedArtifact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatedArtifact() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return t;
    }

    public ActivityDefinition addRelatedArtifact(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatedArtifact == null) {
            this.relatedArtifact = new ArrayList<RelatedArtifact>();
        }
        this.relatedArtifact.add(t);
        return this;
    }

    public RelatedArtifact getRelatedArtifactFirstRep() {
        if (this.getRelatedArtifact().isEmpty()) {
            this.addRelatedArtifact();
        }
        return this.getRelatedArtifact().get(0);
    }

    public List<CanonicalType> getLibrary() {
        if (this.library == null) {
            this.library = new ArrayList<CanonicalType>();
        }
        return this.library;
    }

    public ActivityDefinition setLibrary(List<CanonicalType> theLibrary) {
        this.library = theLibrary;
        return this;
    }

    public boolean hasLibrary() {
        if (this.library == null) {
            return false;
        }
        for (CanonicalType item : this.library) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addLibraryElement() {
        CanonicalType t = new CanonicalType();
        if (this.library == null) {
            this.library = new ArrayList<CanonicalType>();
        }
        this.library.add(t);
        return t;
    }

    public ActivityDefinition addLibrary(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.library == null) {
            this.library = new ArrayList<CanonicalType>();
        }
        this.library.add(t);
        return this;
    }

    public boolean hasLibrary(String value) {
        if (this.library == null) {
            return false;
        }
        for (CanonicalType v : this.library) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<ActivityDefinitionKind> getKindElement() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new Enumeration<ActivityDefinitionKind>(new ActivityDefinitionKindEnumFactory());
            }
        }
        return this.kind;
    }

    public boolean hasKindElement() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public ActivityDefinition setKindElement(Enumeration<ActivityDefinitionKind> value) {
        this.kind = value;
        return this;
    }

    public ActivityDefinitionKind getKind() {
        return this.kind == null ? null : (ActivityDefinitionKind)((Object)this.kind.getValue());
    }

    public ActivityDefinition setKind(ActivityDefinitionKind value) {
        if (value == null) {
            this.kind = null;
        } else {
            if (this.kind == null) {
                this.kind = new Enumeration<ActivityDefinitionKind>(new ActivityDefinitionKindEnumFactory());
            }
            this.kind.setValue((Object)value);
        }
        return this;
    }

    public CanonicalType getProfileElement() {
        if (this.profile == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.profile");
            }
            if (Configuration.doAutoCreate()) {
                this.profile = new CanonicalType();
            }
        }
        return this.profile;
    }

    public boolean hasProfileElement() {
        return this.profile != null && !this.profile.isEmpty();
    }

    public boolean hasProfile() {
        return this.profile != null && !this.profile.isEmpty();
    }

    public ActivityDefinition setProfileElement(CanonicalType value) {
        this.profile = value;
        return this;
    }

    public String getProfile() {
        return this.profile == null ? null : (String)this.profile.getValue();
    }

    public ActivityDefinition setProfile(String value) {
        if (Utilities.noString((String)value)) {
            this.profile = null;
        } else {
            if (this.profile == null) {
                this.profile = new CanonicalType();
            }
            this.profile.setValue(value);
        }
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ActivityDefinition setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Enumeration<RequestIntent> getIntentElement() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new Enumeration<RequestIntent>(new RequestIntentEnumFactory());
            }
        }
        return this.intent;
    }

    public boolean hasIntentElement() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public ActivityDefinition setIntentElement(Enumeration<RequestIntent> value) {
        this.intent = value;
        return this;
    }

    public RequestIntent getIntent() {
        return this.intent == null ? null : (RequestIntent)((Object)this.intent.getValue());
    }

    public ActivityDefinition setIntent(RequestIntent value) {
        if (value == null) {
            this.intent = null;
        } else {
            if (this.intent == null) {
                this.intent = new Enumeration<RequestIntent>(new RequestIntentEnumFactory());
            }
            this.intent.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<RequestPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<RequestPriority>(new RequestPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public ActivityDefinition setPriorityElement(Enumeration<RequestPriority> value) {
        this.priority = value;
        return this;
    }

    public RequestPriority getPriority() {
        return this.priority == null ? null : (RequestPriority)((Object)this.priority.getValue());
    }

    public ActivityDefinition setPriority(RequestPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<RequestPriority>(new RequestPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public BooleanType getDoNotPerformElement() {
        if (this.doNotPerform == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.doNotPerform");
            }
            if (Configuration.doAutoCreate()) {
                this.doNotPerform = new BooleanType();
            }
        }
        return this.doNotPerform;
    }

    public boolean hasDoNotPerformElement() {
        return this.doNotPerform != null && !this.doNotPerform.isEmpty();
    }

    public boolean hasDoNotPerform() {
        return this.doNotPerform != null && !this.doNotPerform.isEmpty();
    }

    public ActivityDefinition setDoNotPerformElement(BooleanType value) {
        this.doNotPerform = value;
        return this;
    }

    public boolean getDoNotPerform() {
        return this.doNotPerform == null || this.doNotPerform.isEmpty() ? false : (Boolean)this.doNotPerform.getValue();
    }

    public ActivityDefinition setDoNotPerform(boolean value) {
        if (this.doNotPerform == null) {
            this.doNotPerform = new BooleanType();
        }
        this.doNotPerform.setValue((Object)value);
        return this;
    }

    public Type getTiming() {
        return this.timing;
    }

    public Timing getTimingTiming() throws FHIRException {
        if (this.timing == null) {
            this.timing = new Timing();
        }
        if (!(this.timing instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Timing)this.timing;
    }

    public boolean hasTimingTiming() {
        return this != null && this.timing instanceof Timing;
    }

    public DateTimeType getTimingDateTimeType() throws FHIRException {
        if (this.timing == null) {
            this.timing = new DateTimeType();
        }
        if (!(this.timing instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.timing;
    }

    public boolean hasTimingDateTimeType() {
        return this != null && this.timing instanceof DateTimeType;
    }

    public Age getTimingAge() throws FHIRException {
        if (this.timing == null) {
            this.timing = new Age();
        }
        if (!(this.timing instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Age)this.timing;
    }

    public boolean hasTimingAge() {
        return this != null && this.timing instanceof Age;
    }

    public Period getTimingPeriod() throws FHIRException {
        if (this.timing == null) {
            this.timing = new Period();
        }
        if (!(this.timing instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Period)this.timing;
    }

    public boolean hasTimingPeriod() {
        return this != null && this.timing instanceof Period;
    }

    public Range getTimingRange() throws FHIRException {
        if (this.timing == null) {
            this.timing = new Range();
        }
        if (!(this.timing instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Range)this.timing;
    }

    public boolean hasTimingRange() {
        return this != null && this.timing instanceof Range;
    }

    public Duration getTimingDuration() throws FHIRException {
        if (this.timing == null) {
            this.timing = new Duration();
        }
        if (!(this.timing instanceof Duration)) {
            throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Duration)this.timing;
    }

    public boolean hasTimingDuration() {
        return this != null && this.timing instanceof Duration;
    }

    public boolean hasTiming() {
        return this.timing != null && !this.timing.isEmpty();
    }

    public ActivityDefinition setTiming(Type value) {
        if (!(value == null || value instanceof Timing || value instanceof DateTimeType || value instanceof Age || value instanceof Period || value instanceof Range || value instanceof Duration)) {
            throw new Error("Not the right type for ActivityDefinition.timing[x]: " + value.fhirType());
        }
        this.timing = value;
        return this;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public ActivityDefinition setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public Location getLocationTarget() {
        if (this.locationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.location");
            }
            if (Configuration.doAutoCreate()) {
                this.locationTarget = new Location();
            }
        }
        return this.locationTarget;
    }

    public ActivityDefinition setLocationTarget(Location value) {
        this.locationTarget = value;
        return this;
    }

    public List<ActivityDefinitionParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<ActivityDefinitionParticipantComponent>();
        }
        return this.participant;
    }

    public ActivityDefinition setParticipant(List<ActivityDefinitionParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (ActivityDefinitionParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ActivityDefinitionParticipantComponent addParticipant() {
        ActivityDefinitionParticipantComponent t = new ActivityDefinitionParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<ActivityDefinitionParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public ActivityDefinition addParticipant(ActivityDefinitionParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<ActivityDefinitionParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public ActivityDefinitionParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public Type getProduct() {
        return this.product;
    }

    public Reference getProductReference() throws FHIRException {
        if (this.product == null) {
            this.product = new Reference();
        }
        if (!(this.product instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.product.getClass().getName() + " was encountered");
        }
        return (Reference)this.product;
    }

    public boolean hasProductReference() {
        return this != null && this.product instanceof Reference;
    }

    public CodeableConcept getProductCodeableConcept() throws FHIRException {
        if (this.product == null) {
            this.product = new CodeableConcept();
        }
        if (!(this.product instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.product.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.product;
    }

    public boolean hasProductCodeableConcept() {
        return this != null && this.product instanceof CodeableConcept;
    }

    public boolean hasProduct() {
        return this.product != null && !this.product.isEmpty();
    }

    public ActivityDefinition setProduct(Type value) {
        if (value != null && !(value instanceof Reference) && !(value instanceof CodeableConcept)) {
            throw new Error("Not the right type for ActivityDefinition.product[x]: " + value.fhirType());
        }
        this.product = value;
        return this;
    }

    public Quantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new Quantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public ActivityDefinition setQuantity(Quantity value) {
        this.quantity = value;
        return this;
    }

    public List<Dosage> getDosage() {
        if (this.dosage == null) {
            this.dosage = new ArrayList<Dosage>();
        }
        return this.dosage;
    }

    public ActivityDefinition setDosage(List<Dosage> theDosage) {
        this.dosage = theDosage;
        return this;
    }

    public boolean hasDosage() {
        if (this.dosage == null) {
            return false;
        }
        for (Dosage item : this.dosage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Dosage addDosage() {
        Dosage t = new Dosage();
        if (this.dosage == null) {
            this.dosage = new ArrayList<Dosage>();
        }
        this.dosage.add(t);
        return t;
    }

    public ActivityDefinition addDosage(Dosage t) {
        if (t == null) {
            return this;
        }
        if (this.dosage == null) {
            this.dosage = new ArrayList<Dosage>();
        }
        this.dosage.add(t);
        return this;
    }

    public Dosage getDosageFirstRep() {
        if (this.getDosage().isEmpty()) {
            this.addDosage();
        }
        return this.getDosage().get(0);
    }

    public List<CodeableConcept> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        return this.bodySite;
    }

    public ActivityDefinition setBodySite(List<CodeableConcept> theBodySite) {
        this.bodySite = theBodySite;
        return this;
    }

    public boolean hasBodySite() {
        if (this.bodySite == null) {
            return false;
        }
        for (CodeableConcept item : this.bodySite) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addBodySite() {
        CodeableConcept t = new CodeableConcept();
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return t;
    }

    public ActivityDefinition addBodySite(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return this;
    }

    public CodeableConcept getBodySiteFirstRep() {
        if (this.getBodySite().isEmpty()) {
            this.addBodySite();
        }
        return this.getBodySite().get(0);
    }

    public List<Reference> getSpecimenRequirement() {
        if (this.specimenRequirement == null) {
            this.specimenRequirement = new ArrayList<Reference>();
        }
        return this.specimenRequirement;
    }

    public ActivityDefinition setSpecimenRequirement(List<Reference> theSpecimenRequirement) {
        this.specimenRequirement = theSpecimenRequirement;
        return this;
    }

    public boolean hasSpecimenRequirement() {
        if (this.specimenRequirement == null) {
            return false;
        }
        for (Reference item : this.specimenRequirement) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSpecimenRequirement() {
        Reference t = new Reference();
        if (this.specimenRequirement == null) {
            this.specimenRequirement = new ArrayList<Reference>();
        }
        this.specimenRequirement.add(t);
        return t;
    }

    public ActivityDefinition addSpecimenRequirement(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.specimenRequirement == null) {
            this.specimenRequirement = new ArrayList<Reference>();
        }
        this.specimenRequirement.add(t);
        return this;
    }

    public Reference getSpecimenRequirementFirstRep() {
        if (this.getSpecimenRequirement().isEmpty()) {
            this.addSpecimenRequirement();
        }
        return this.getSpecimenRequirement().get(0);
    }

    @Deprecated
    public List<SpecimenDefinition> getSpecimenRequirementTarget() {
        if (this.specimenRequirementTarget == null) {
            this.specimenRequirementTarget = new ArrayList<SpecimenDefinition>();
        }
        return this.specimenRequirementTarget;
    }

    @Deprecated
    public SpecimenDefinition addSpecimenRequirementTarget() {
        SpecimenDefinition r = new SpecimenDefinition();
        if (this.specimenRequirementTarget == null) {
            this.specimenRequirementTarget = new ArrayList<SpecimenDefinition>();
        }
        this.specimenRequirementTarget.add(r);
        return r;
    }

    public List<Reference> getObservationRequirement() {
        if (this.observationRequirement == null) {
            this.observationRequirement = new ArrayList<Reference>();
        }
        return this.observationRequirement;
    }

    public ActivityDefinition setObservationRequirement(List<Reference> theObservationRequirement) {
        this.observationRequirement = theObservationRequirement;
        return this;
    }

    public boolean hasObservationRequirement() {
        if (this.observationRequirement == null) {
            return false;
        }
        for (Reference item : this.observationRequirement) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addObservationRequirement() {
        Reference t = new Reference();
        if (this.observationRequirement == null) {
            this.observationRequirement = new ArrayList<Reference>();
        }
        this.observationRequirement.add(t);
        return t;
    }

    public ActivityDefinition addObservationRequirement(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.observationRequirement == null) {
            this.observationRequirement = new ArrayList<Reference>();
        }
        this.observationRequirement.add(t);
        return this;
    }

    public Reference getObservationRequirementFirstRep() {
        if (this.getObservationRequirement().isEmpty()) {
            this.addObservationRequirement();
        }
        return this.getObservationRequirement().get(0);
    }

    @Deprecated
    public List<ObservationDefinition> getObservationRequirementTarget() {
        if (this.observationRequirementTarget == null) {
            this.observationRequirementTarget = new ArrayList<ObservationDefinition>();
        }
        return this.observationRequirementTarget;
    }

    @Deprecated
    public ObservationDefinition addObservationRequirementTarget() {
        ObservationDefinition r = new ObservationDefinition();
        if (this.observationRequirementTarget == null) {
            this.observationRequirementTarget = new ArrayList<ObservationDefinition>();
        }
        this.observationRequirementTarget.add(r);
        return r;
    }

    public List<Reference> getObservationResultRequirement() {
        if (this.observationResultRequirement == null) {
            this.observationResultRequirement = new ArrayList<Reference>();
        }
        return this.observationResultRequirement;
    }

    public ActivityDefinition setObservationResultRequirement(List<Reference> theObservationResultRequirement) {
        this.observationResultRequirement = theObservationResultRequirement;
        return this;
    }

    public boolean hasObservationResultRequirement() {
        if (this.observationResultRequirement == null) {
            return false;
        }
        for (Reference item : this.observationResultRequirement) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addObservationResultRequirement() {
        Reference t = new Reference();
        if (this.observationResultRequirement == null) {
            this.observationResultRequirement = new ArrayList<Reference>();
        }
        this.observationResultRequirement.add(t);
        return t;
    }

    public ActivityDefinition addObservationResultRequirement(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.observationResultRequirement == null) {
            this.observationResultRequirement = new ArrayList<Reference>();
        }
        this.observationResultRequirement.add(t);
        return this;
    }

    public Reference getObservationResultRequirementFirstRep() {
        if (this.getObservationResultRequirement().isEmpty()) {
            this.addObservationResultRequirement();
        }
        return this.getObservationResultRequirement().get(0);
    }

    @Deprecated
    public List<ObservationDefinition> getObservationResultRequirementTarget() {
        if (this.observationResultRequirementTarget == null) {
            this.observationResultRequirementTarget = new ArrayList<ObservationDefinition>();
        }
        return this.observationResultRequirementTarget;
    }

    @Deprecated
    public ObservationDefinition addObservationResultRequirementTarget() {
        ObservationDefinition r = new ObservationDefinition();
        if (this.observationResultRequirementTarget == null) {
            this.observationResultRequirementTarget = new ArrayList<ObservationDefinition>();
        }
        this.observationResultRequirementTarget.add(r);
        return r;
    }

    public CanonicalType getTransformElement() {
        if (this.transform == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ActivityDefinition.transform");
            }
            if (Configuration.doAutoCreate()) {
                this.transform = new CanonicalType();
            }
        }
        return this.transform;
    }

    public boolean hasTransformElement() {
        return this.transform != null && !this.transform.isEmpty();
    }

    public boolean hasTransform() {
        return this.transform != null && !this.transform.isEmpty();
    }

    public ActivityDefinition setTransformElement(CanonicalType value) {
        this.transform = value;
        return this;
    }

    public String getTransform() {
        return this.transform == null ? null : (String)this.transform.getValue();
    }

    public ActivityDefinition setTransform(String value) {
        if (Utilities.noString((String)value)) {
            this.transform = null;
        } else {
            if (this.transform == null) {
                this.transform = new CanonicalType();
            }
            this.transform.setValue(value);
        }
        return this;
    }

    public List<ActivityDefinitionDynamicValueComponent> getDynamicValue() {
        if (this.dynamicValue == null) {
            this.dynamicValue = new ArrayList<ActivityDefinitionDynamicValueComponent>();
        }
        return this.dynamicValue;
    }

    public ActivityDefinition setDynamicValue(List<ActivityDefinitionDynamicValueComponent> theDynamicValue) {
        this.dynamicValue = theDynamicValue;
        return this;
    }

    public boolean hasDynamicValue() {
        if (this.dynamicValue == null) {
            return false;
        }
        for (ActivityDefinitionDynamicValueComponent item : this.dynamicValue) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ActivityDefinitionDynamicValueComponent addDynamicValue() {
        ActivityDefinitionDynamicValueComponent t = new ActivityDefinitionDynamicValueComponent();
        if (this.dynamicValue == null) {
            this.dynamicValue = new ArrayList<ActivityDefinitionDynamicValueComponent>();
        }
        this.dynamicValue.add(t);
        return t;
    }

    public ActivityDefinition addDynamicValue(ActivityDefinitionDynamicValueComponent t) {
        if (t == null) {
            return this;
        }
        if (this.dynamicValue == null) {
            this.dynamicValue = new ArrayList<ActivityDefinitionDynamicValueComponent>();
        }
        this.dynamicValue.add(t);
        return this;
    }

    public ActivityDefinitionDynamicValueComponent getDynamicValueFirstRep() {
        if (this.getDynamicValue().isEmpty()) {
            this.addDynamicValue();
        }
        return this.getDynamicValue().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this activity definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this activity definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the activity definition is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this activity definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the activity definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the activity definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active assets.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the activity definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the activity definition.", 0, 1, this.title));
        children.add(new Property("subtitle", "string", "An explanatory or alternate title for the activity definition giving additional information about its content.", 0, 1, this.subtitle));
        children.add(new Property(SP_STATUS, "code", "The status of this activity definition. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this activity definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property("subject[x]", "CodeableConcept|Reference(Group)", "A code or group definition that describes the intended subject of the activity being defined.", 0, 1, this.subject));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the activity definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the activity definition changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the activity definition.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the activity definition from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate activity definition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the activity definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this activity definition is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("usage", "string", "A detailed description of how the activity definition is used from a clinical perspective.", 0, 1, this.usage));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the activity definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the activity definition.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the activity definition content was or is planned to be in active use.", 0, 1, this.effectivePeriod));
        children.add(new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the activity. Topics provide a high-level categorization of the activity that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic));
        children.add(new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor));
        children.add(new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer));
        children.add(new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser));
        children.add(new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact));
        children.add(new Property("library", "canonical(Library)", "A reference to a Library resource containing any formal logic used by the activity definition.", 0, Integer.MAX_VALUE, this.library));
        children.add(new Property("kind", "code", "A description of the kind of resource the activity definition is representing. For example, a MedicationRequest, a ServiceRequest, or a CommunicationRequest. Typically, but not always, this is a Request resource.", 0, 1, this.kind));
        children.add(new Property("profile", "canonical(StructureDefinition)", "A profile to which the target of the activity definition is expected to conform.", 0, 1, this.profile));
        children.add(new Property("code", "CodeableConcept", "Detailed description of the type of activity; e.g. What lab test, what procedure, what kind of encounter.", 0, 1, this.code));
        children.add(new Property("intent", "code", "Indicates the level of authority/intentionality associated with the activity and where the request should fit into the workflow chain.", 0, 1, this.intent));
        children.add(new Property("priority", "code", "Indicates how quickly the activity  should be addressed with respect to other requests.", 0, 1, this.priority));
        children.add(new Property("doNotPerform", "boolean", "Set this to true if the definition is to indicate that a particular activity should NOT be performed. If true, this element should be interpreted to reinforce a negative coding. For example NPO as a code with a doNotPerform of true would still indicate to NOT perform the action.", 0, 1, this.doNotPerform));
        children.add(new Property("timing[x]", "Timing|dateTime|Age|Period|Range|Duration", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing));
        children.add(new Property("location", "Reference(Location)", "Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.", 0, 1, this.location));
        children.add(new Property("participant", "", "Indicates who should participate in performing the action described.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property("product[x]", "Reference(Medication|Substance)|CodeableConcept", "Identifies the food, drug or other product being consumed or supplied in the activity.", 0, 1, this.product));
        children.add(new Property("quantity", "SimpleQuantity", "Identifies the quantity expected to be consumed at once (per dose, per meal, etc.).", 0, 1, this.quantity));
        children.add(new Property("dosage", "Dosage", "Provides detailed dosage instructions in the same way that they are described for MedicationRequest resources.", 0, Integer.MAX_VALUE, this.dosage));
        children.add(new Property("bodySite", "CodeableConcept", "Indicates the sites on the subject's body where the procedure should be performed (I.e. the target sites).", 0, Integer.MAX_VALUE, this.bodySite));
        children.add(new Property("specimenRequirement", "Reference(SpecimenDefinition)", "Defines specimen requirements for the action to be performed, such as required specimens for a lab test.", 0, Integer.MAX_VALUE, this.specimenRequirement));
        children.add(new Property("observationRequirement", "Reference(ObservationDefinition)", "Defines observation requirements for the action to be performed, such as body weight or surface area.", 0, Integer.MAX_VALUE, this.observationRequirement));
        children.add(new Property("observationResultRequirement", "Reference(ObservationDefinition)", "Defines the observations that are expected to be produced by the action.", 0, Integer.MAX_VALUE, this.observationResultRequirement));
        children.add(new Property("transform", "canonical(StructureMap)", "A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.", 0, 1, this.transform));
        children.add(new Property("dynamicValue", "", "Dynamic values that will be evaluated to produce values for elements of the resulting resource. For example, if the dosage of a medication must be computed based on the patient's weight, a dynamic value would be used to specify an expression that calculated the weight, and the path on the request resource that would contain the result.", 0, Integer.MAX_VALUE, this.dynamicValue));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this activity definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this activity definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the activity definition is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this activity definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the activity definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the activity definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active assets.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the activity definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the activity definition.", 0, 1, this.title);
            }
            case -2060497896: {
                return new Property("subtitle", "string", "An explanatory or alternate title for the activity definition giving additional information about its content.", 0, 1, this.subtitle);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this activity definition. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this activity definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case -573640748: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)", "A code or group definition that describes the intended subject of the activity being defined.", 0, 1, this.subject);
            }
            case -1867885268: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)", "A code or group definition that describes the intended subject of the activity being defined.", 0, 1, this.subject);
            }
            case -1257122603: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)", "A code or group definition that describes the intended subject of the activity being defined.", 0, 1, this.subject);
            }
            case 772938623: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)", "A code or group definition that describes the intended subject of the activity being defined.", 0, 1, this.subject);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the activity definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the activity definition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the activity definition.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the activity definition from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate activity definition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the activity definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this activity definition is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 111574433: {
                return new Property("usage", "string", "A detailed description of how the activity definition is used from a clinical perspective.", 0, 1, this.usage);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the activity definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the activity definition.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the activity definition content was or is planned to be in active use.", 0, 1, this.effectivePeriod);
            }
            case 110546223: {
                return new Property(SP_TOPIC, "CodeableConcept", "Descriptive topics related to the content of the activity. Topics provide a high-level categorization of the activity that can be useful for filtering and searching.", 0, Integer.MAX_VALUE, this.topic);
            }
            case -1406328437: {
                return new Property("author", "ContactDetail", "An individiual or organization primarily involved in the creation and maintenance of the content.", 0, Integer.MAX_VALUE, this.author);
            }
            case -1307827859: {
                return new Property("editor", "ContactDetail", "An individual or organization primarily responsible for internal coherence of the content.", 0, Integer.MAX_VALUE, this.editor);
            }
            case -261190139: {
                return new Property("reviewer", "ContactDetail", "An individual or organization primarily responsible for review of some aspect of the content.", 0, Integer.MAX_VALUE, this.reviewer);
            }
            case 1740277666: {
                return new Property("endorser", "ContactDetail", "An individual or organization responsible for officially endorsing the content for use in some setting.", 0, Integer.MAX_VALUE, this.endorser);
            }
            case 666807069: {
                return new Property("relatedArtifact", "RelatedArtifact", "Related artifacts such as additional documentation, justification, or bibliographic references.", 0, Integer.MAX_VALUE, this.relatedArtifact);
            }
            case 166208699: {
                return new Property("library", "canonical(Library)", "A reference to a Library resource containing any formal logic used by the activity definition.", 0, Integer.MAX_VALUE, this.library);
            }
            case 3292052: {
                return new Property("kind", "code", "A description of the kind of resource the activity definition is representing. For example, a MedicationRequest, a ServiceRequest, or a CommunicationRequest. Typically, but not always, this is a Request resource.", 0, 1, this.kind);
            }
            case -309425751: {
                return new Property("profile", "canonical(StructureDefinition)", "A profile to which the target of the activity definition is expected to conform.", 0, 1, this.profile);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "Detailed description of the type of activity; e.g. What lab test, what procedure, what kind of encounter.", 0, 1, this.code);
            }
            case -1183762788: {
                return new Property("intent", "code", "Indicates the level of authority/intentionality associated with the activity and where the request should fit into the workflow chain.", 0, 1, this.intent);
            }
            case -1165461084: {
                return new Property("priority", "code", "Indicates how quickly the activity  should be addressed with respect to other requests.", 0, 1, this.priority);
            }
            case -1788508167: {
                return new Property("doNotPerform", "boolean", "Set this to true if the definition is to indicate that a particular activity should NOT be performed. If true, this element should be interpreted to reinforce a negative coding. For example NPO as a code with a doNotPerform of true would still indicate to NOT perform the action.", 0, 1, this.doNotPerform);
            }
            case 164632566: {
                return new Property("timing[x]", "Timing|dateTime|Age|Period|Range|Duration", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing);
            }
            case -873664438: {
                return new Property("timing[x]", "Timing|dateTime|Age|Period|Range|Duration", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing);
            }
            case -497554124: {
                return new Property("timing[x]", "Timing|dateTime|Age|Period|Range|Duration", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing);
            }
            case -1837458939: {
                return new Property("timing[x]", "Timing|dateTime|Age|Period|Range|Duration", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing);
            }
            case 164607061: {
                return new Property("timing[x]", "Timing|dateTime|Age|Period|Range|Duration", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing);
            }
            case -615615829: {
                return new Property("timing[x]", "Timing|dateTime|Age|Period|Range|Duration", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing);
            }
            case -710871277: {
                return new Property("timing[x]", "Timing|dateTime|Age|Period|Range|Duration", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing);
            }
            case -1327253506: {
                return new Property("timing[x]", "Timing|dateTime|Age|Period|Range|Duration", "The period, timing or frequency upon which the described activity is to occur.", 0, 1, this.timing);
            }
            case 1901043637: {
                return new Property("location", "Reference(Location)", "Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.", 0, 1, this.location);
            }
            case 767422259: {
                return new Property("participant", "", "Indicates who should participate in performing the action described.", 0, Integer.MAX_VALUE, this.participant);
            }
            case 1753005361: {
                return new Property("product[x]", "Reference(Medication|Substance)|CodeableConcept", "Identifies the food, drug or other product being consumed or supplied in the activity.", 0, 1, this.product);
            }
            case -309474065: {
                return new Property("product[x]", "Reference(Medication|Substance)|CodeableConcept", "Identifies the food, drug or other product being consumed or supplied in the activity.", 0, 1, this.product);
            }
            case -669667556: {
                return new Property("product[x]", "Reference(Medication|Substance)|CodeableConcept", "Identifies the food, drug or other product being consumed or supplied in the activity.", 0, 1, this.product);
            }
            case 906854066: {
                return new Property("product[x]", "Reference(Medication|Substance)|CodeableConcept", "Identifies the food, drug or other product being consumed or supplied in the activity.", 0, 1, this.product);
            }
            case -1285004149: {
                return new Property("quantity", "SimpleQuantity", "Identifies the quantity expected to be consumed at once (per dose, per meal, etc.).", 0, 1, this.quantity);
            }
            case -1326018889: {
                return new Property("dosage", "Dosage", "Provides detailed dosage instructions in the same way that they are described for MedicationRequest resources.", 0, Integer.MAX_VALUE, this.dosage);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableConcept", "Indicates the sites on the subject's body where the procedure should be performed (I.e. the target sites).", 0, Integer.MAX_VALUE, this.bodySite);
            }
            case 1498467355: {
                return new Property("specimenRequirement", "Reference(SpecimenDefinition)", "Defines specimen requirements for the action to be performed, such as required specimens for a lab test.", 0, Integer.MAX_VALUE, this.specimenRequirement);
            }
            case 362354807: {
                return new Property("observationRequirement", "Reference(ObservationDefinition)", "Defines observation requirements for the action to be performed, such as body weight or surface area.", 0, Integer.MAX_VALUE, this.observationRequirement);
            }
            case 395230490: {
                return new Property("observationResultRequirement", "Reference(ObservationDefinition)", "Defines the observations that are expected to be produced by the action.", 0, Integer.MAX_VALUE, this.observationResultRequirement);
            }
            case 1052666732: {
                return new Property("transform", "canonical(StructureMap)", "A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.", 0, 1, this.transform);
            }
            case 572625010: {
                return new Property("dynamicValue", "", "Dynamic values that will be evaluated to produce values for elements of the resulting resource. For example, if the dosage of a medication must be computed based on the patient's weight, a dynamic value would be used to specify an expression that calculated the weight, and the path on the request resource that would contain the result.", 0, Integer.MAX_VALUE, this.dynamicValue);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -2060497896: {
                Base[] baseArray;
                if (this.subtitle == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subtitle;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.experimental;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.subject;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.purpose;
                }
                return baseArray;
            }
            case 111574433: {
                Base[] baseArray;
                if (this.usage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.usage;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case 110546223: {
                return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case -1307827859: {
                return this.editor == null ? new Base[]{} : this.editor.toArray(new Base[this.editor.size()]);
            }
            case -261190139: {
                return this.reviewer == null ? new Base[]{} : this.reviewer.toArray(new Base[this.reviewer.size()]);
            }
            case 1740277666: {
                return this.endorser == null ? new Base[]{} : this.endorser.toArray(new Base[this.endorser.size()]);
            }
            case 666807069: {
                return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
            }
            case 166208699: {
                return this.library == null ? new Base[]{} : this.library.toArray(new Base[this.library.size()]);
            }
            case 3292052: {
                Base[] baseArray;
                if (this.kind == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.kind;
                }
                return baseArray;
            }
            case -309425751: {
                Base[] baseArray;
                if (this.profile == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.profile;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.code;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray22 = new Base[1];
                    baseArray = baseArray22;
                    baseArray22[0] = this.intent;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray23 = new Base[1];
                    baseArray = baseArray23;
                    baseArray23[0] = this.priority;
                }
                return baseArray;
            }
            case -1788508167: {
                Base[] baseArray;
                if (this.doNotPerform == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray24 = new Base[1];
                    baseArray = baseArray24;
                    baseArray24[0] = this.doNotPerform;
                }
                return baseArray;
            }
            case -873664438: {
                Base[] baseArray;
                if (this.timing == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray25 = new Base[1];
                    baseArray = baseArray25;
                    baseArray25[0] = this.timing;
                }
                return baseArray;
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray26 = new Base[1];
                    baseArray = baseArray26;
                    baseArray26[0] = this.location;
                }
                return baseArray;
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case -309474065: {
                Base[] baseArray;
                if (this.product == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray27 = new Base[1];
                    baseArray = baseArray27;
                    baseArray27[0] = this.product;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray28 = new Base[1];
                    baseArray = baseArray28;
                    baseArray28[0] = this.quantity;
                }
                return baseArray;
            }
            case -1326018889: {
                return this.dosage == null ? new Base[]{} : this.dosage.toArray(new Base[this.dosage.size()]);
            }
            case 1702620169: {
                return this.bodySite == null ? new Base[]{} : this.bodySite.toArray(new Base[this.bodySite.size()]);
            }
            case 1498467355: {
                return this.specimenRequirement == null ? new Base[]{} : this.specimenRequirement.toArray(new Base[this.specimenRequirement.size()]);
            }
            case 362354807: {
                return this.observationRequirement == null ? new Base[]{} : this.observationRequirement.toArray(new Base[this.observationRequirement.size()]);
            }
            case 395230490: {
                return this.observationResultRequirement == null ? new Base[]{} : this.observationResultRequirement.toArray(new Base[this.observationResultRequirement.size()]);
            }
            case 1052666732: {
                Base[] baseArray;
                if (this.transform == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray29 = new Base[1];
                    baseArray = baseArray29;
                    baseArray29[0] = this.transform;
                }
                return baseArray;
            }
            case 572625010: {
                return this.dynamicValue == null ? new Base[]{} : this.dynamicValue.toArray(new Base[this.dynamicValue.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -2060497896: {
                this.subtitle = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToType(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 111574433: {
                this.usage = this.castToString(value);
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = this.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = this.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = this.castToPeriod(value);
                return value;
            }
            case 110546223: {
                this.getTopic().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(this.castToContactDetail(value));
                return value;
            }
            case -1307827859: {
                this.getEditor().add(this.castToContactDetail(value));
                return value;
            }
            case -261190139: {
                this.getReviewer().add(this.castToContactDetail(value));
                return value;
            }
            case 1740277666: {
                this.getEndorser().add(this.castToContactDetail(value));
                return value;
            }
            case 666807069: {
                this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
                return value;
            }
            case 166208699: {
                this.getLibrary().add(this.castToCanonical(value));
                return value;
            }
            case 3292052: {
                value = new ActivityDefinitionKindEnumFactory().fromType(this.castToCode(value));
                this.kind = value;
                return value;
            }
            case -309425751: {
                this.profile = this.castToCanonical(value);
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -1183762788: {
                value = new RequestIntentEnumFactory().fromType(this.castToCode(value));
                this.intent = value;
                return value;
            }
            case -1165461084: {
                value = new RequestPriorityEnumFactory().fromType(this.castToCode(value));
                this.priority = value;
                return value;
            }
            case -1788508167: {
                this.doNotPerform = this.castToBoolean(value);
                return value;
            }
            case -873664438: {
                this.timing = this.castToType(value);
                return value;
            }
            case 1901043637: {
                this.location = this.castToReference(value);
                return value;
            }
            case 767422259: {
                this.getParticipant().add((ActivityDefinitionParticipantComponent)((Object)value));
                return value;
            }
            case -309474065: {
                this.product = this.castToType(value);
                return value;
            }
            case -1285004149: {
                this.quantity = this.castToQuantity(value);
                return value;
            }
            case -1326018889: {
                this.getDosage().add(this.castToDosage(value));
                return value;
            }
            case 1702620169: {
                this.getBodySite().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1498467355: {
                this.getSpecimenRequirement().add(this.castToReference(value));
                return value;
            }
            case 362354807: {
                this.getObservationRequirement().add(this.castToReference(value));
                return value;
            }
            case 395230490: {
                this.getObservationResultRequirement().add(this.castToReference(value));
                return value;
            }
            case 1052666732: {
                this.transform = this.castToCanonical(value);
                return value;
            }
            case 572625010: {
                this.getDynamicValue().add((ActivityDefinitionDynamicValueComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals("subtitle")) {
            this.subtitle = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals("subject[x]")) {
            this.subject = this.castToType(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals("usage")) {
            this.usage = this.castToString(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = this.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = this.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = this.castToPeriod(value);
        } else if (name.equals(SP_TOPIC)) {
            this.getTopic().add(this.castToCodeableConcept(value));
        } else if (name.equals("author")) {
            this.getAuthor().add(this.castToContactDetail(value));
        } else if (name.equals("editor")) {
            this.getEditor().add(this.castToContactDetail(value));
        } else if (name.equals("reviewer")) {
            this.getReviewer().add(this.castToContactDetail(value));
        } else if (name.equals("endorser")) {
            this.getEndorser().add(this.castToContactDetail(value));
        } else if (name.equals("relatedArtifact")) {
            this.getRelatedArtifact().add(this.castToRelatedArtifact(value));
        } else if (name.equals("library")) {
            this.getLibrary().add(this.castToCanonical(value));
        } else if (name.equals("kind")) {
            value = new ActivityDefinitionKindEnumFactory().fromType(this.castToCode(value));
            this.kind = value;
        } else if (name.equals("profile")) {
            this.profile = this.castToCanonical(value);
        } else if (name.equals("code")) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals("intent")) {
            value = new RequestIntentEnumFactory().fromType(this.castToCode(value));
            this.intent = value;
        } else if (name.equals("priority")) {
            value = new RequestPriorityEnumFactory().fromType(this.castToCode(value));
            this.priority = value;
        } else if (name.equals("doNotPerform")) {
            this.doNotPerform = this.castToBoolean(value);
        } else if (name.equals("timing[x]")) {
            this.timing = this.castToType(value);
        } else if (name.equals("location")) {
            this.location = this.castToReference(value);
        } else if (name.equals("participant")) {
            this.getParticipant().add((ActivityDefinitionParticipantComponent)((Object)value));
        } else if (name.equals("product[x]")) {
            this.product = this.castToType(value);
        } else if (name.equals("quantity")) {
            this.quantity = this.castToQuantity(value);
        } else if (name.equals("dosage")) {
            this.getDosage().add(this.castToDosage(value));
        } else if (name.equals("bodySite")) {
            this.getBodySite().add(this.castToCodeableConcept(value));
        } else if (name.equals("specimenRequirement")) {
            this.getSpecimenRequirement().add(this.castToReference(value));
        } else if (name.equals("observationRequirement")) {
            this.getObservationRequirement().add(this.castToReference(value));
        } else if (name.equals("observationResultRequirement")) {
            this.getObservationResultRequirement().add(this.castToReference(value));
        } else if (name.equals("transform")) {
            this.transform = this.castToCanonical(value);
        } else if (name.equals("dynamicValue")) {
            this.getDynamicValue().add((ActivityDefinitionDynamicValueComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -2060497896: {
                return this.getSubtitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case -573640748: {
                return this.getSubject();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 111574433: {
                return this.getUsageElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case 110546223: {
                return this.addTopic();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case -1307827859: {
                return this.addEditor();
            }
            case -261190139: {
                return this.addReviewer();
            }
            case 1740277666: {
                return this.addEndorser();
            }
            case 666807069: {
                return this.addRelatedArtifact();
            }
            case 166208699: {
                return this.addLibraryElement();
            }
            case 3292052: {
                return this.getKindElement();
            }
            case -309425751: {
                return this.getProfileElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1183762788: {
                return this.getIntentElement();
            }
            case -1165461084: {
                return this.getPriorityElement();
            }
            case -1788508167: {
                return this.getDoNotPerformElement();
            }
            case 164632566: {
                return this.getTiming();
            }
            case -873664438: {
                return this.getTiming();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case 1753005361: {
                return this.getProduct();
            }
            case -309474065: {
                return this.getProduct();
            }
            case -1285004149: {
                return this.getQuantity();
            }
            case -1326018889: {
                return this.addDosage();
            }
            case 1702620169: {
                return this.addBodySite();
            }
            case 1498467355: {
                return this.addSpecimenRequirement();
            }
            case 362354807: {
                return this.addObservationRequirement();
            }
            case 395230490: {
                return this.addObservationResultRequirement();
            }
            case 1052666732: {
                return this.getTransformElement();
            }
            case 572625010: {
                return this.addDynamicValue();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -2060497896: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case -1867885268: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 111574433: {
                return new String[]{"string"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case 110546223: {
                return new String[]{"CodeableConcept"};
            }
            case -1406328437: {
                return new String[]{"ContactDetail"};
            }
            case -1307827859: {
                return new String[]{"ContactDetail"};
            }
            case -261190139: {
                return new String[]{"ContactDetail"};
            }
            case 1740277666: {
                return new String[]{"ContactDetail"};
            }
            case 666807069: {
                return new String[]{"RelatedArtifact"};
            }
            case 166208699: {
                return new String[]{"canonical"};
            }
            case 3292052: {
                return new String[]{"code"};
            }
            case -309425751: {
                return new String[]{"canonical"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1183762788: {
                return new String[]{"code"};
            }
            case -1165461084: {
                return new String[]{"code"};
            }
            case -1788508167: {
                return new String[]{"boolean"};
            }
            case -873664438: {
                return new String[]{"Timing", "dateTime", "Age", "Period", "Range", "Duration"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case 767422259: {
                return new String[0];
            }
            case -309474065: {
                return new String[]{"Reference", "CodeableConcept"};
            }
            case -1285004149: {
                return new String[]{"SimpleQuantity"};
            }
            case -1326018889: {
                return new String[]{"Dosage"};
            }
            case 1702620169: {
                return new String[]{"CodeableConcept"};
            }
            case 1498467355: {
                return new String[]{"Reference"};
            }
            case 362354807: {
                return new String[]{"Reference"};
            }
            case 395230490: {
                return new String[]{"Reference"};
            }
            case 1052666732: {
                return new String[]{"canonical"};
            }
            case 572625010: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.title");
        }
        if (name.equals("subtitle")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.subtitle");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.experimental");
        }
        if (name.equals("subjectCodeableConcept")) {
            this.subject = new CodeableConcept();
            return this.subject;
        }
        if (name.equals("subjectReference")) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.purpose");
        }
        if (name.equals("usage")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.usage");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals(SP_TOPIC)) {
            return this.addTopic();
        }
        if (name.equals("author")) {
            return this.addAuthor();
        }
        if (name.equals("editor")) {
            return this.addEditor();
        }
        if (name.equals("reviewer")) {
            return this.addReviewer();
        }
        if (name.equals("endorser")) {
            return this.addEndorser();
        }
        if (name.equals("relatedArtifact")) {
            return this.addRelatedArtifact();
        }
        if (name.equals("library")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.library");
        }
        if (name.equals("kind")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.kind");
        }
        if (name.equals("profile")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.profile");
        }
        if (name.equals("code")) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals("intent")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.intent");
        }
        if (name.equals("priority")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.priority");
        }
        if (name.equals("doNotPerform")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.doNotPerform");
        }
        if (name.equals("timingTiming")) {
            this.timing = new Timing();
            return this.timing;
        }
        if (name.equals("timingDateTime")) {
            this.timing = new DateTimeType();
            return this.timing;
        }
        if (name.equals("timingAge")) {
            this.timing = new Age();
            return this.timing;
        }
        if (name.equals("timingPeriod")) {
            this.timing = new Period();
            return this.timing;
        }
        if (name.equals("timingRange")) {
            this.timing = new Range();
            return this.timing;
        }
        if (name.equals("timingDuration")) {
            this.timing = new Duration();
            return this.timing;
        }
        if (name.equals("location")) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("participant")) {
            return this.addParticipant();
        }
        if (name.equals("productReference")) {
            this.product = new Reference();
            return this.product;
        }
        if (name.equals("productCodeableConcept")) {
            this.product = new CodeableConcept();
            return this.product;
        }
        if (name.equals("quantity")) {
            this.quantity = new Quantity();
            return this.quantity;
        }
        if (name.equals("dosage")) {
            return this.addDosage();
        }
        if (name.equals("bodySite")) {
            return this.addBodySite();
        }
        if (name.equals("specimenRequirement")) {
            return this.addSpecimenRequirement();
        }
        if (name.equals("observationRequirement")) {
            return this.addObservationRequirement();
        }
        if (name.equals("observationResultRequirement")) {
            return this.addObservationResultRequirement();
        }
        if (name.equals("transform")) {
            throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.transform");
        }
        if (name.equals("dynamicValue")) {
            return this.addDynamicValue();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ActivityDefinition";
    }

    @Override
    public ActivityDefinition copy() {
        ActivityDefinition dst = new ActivityDefinition();
        this.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.subtitle = this.subtitle == null ? null : this.subtitle.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.usage = this.usage == null ? null : this.usage.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        if (this.topic != null) {
            dst.topic = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.topic) {
                dst.topic.add(codeableConcept.copy());
            }
        }
        if (this.author != null) {
            dst.author = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.author) {
                dst.author.add(contactDetail.copy());
            }
        }
        if (this.editor != null) {
            dst.editor = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.editor) {
                dst.editor.add(contactDetail.copy());
            }
        }
        if (this.reviewer != null) {
            dst.reviewer = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.reviewer) {
                dst.reviewer.add(contactDetail.copy());
            }
        }
        if (this.endorser != null) {
            dst.endorser = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.endorser) {
                dst.endorser.add(contactDetail.copy());
            }
        }
        if (this.relatedArtifact != null) {
            dst.relatedArtifact = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                dst.relatedArtifact.add(relatedArtifact.copy());
            }
        }
        if (this.library != null) {
            dst.library = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.library) {
                dst.library.add(canonicalType.copy());
            }
        }
        dst.kind = this.kind == null ? null : this.kind.copy();
        dst.profile = this.profile == null ? null : this.profile.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.intent = this.intent == null ? null : this.intent.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.doNotPerform = this.doNotPerform == null ? null : this.doNotPerform.copy();
        dst.timing = this.timing == null ? null : this.timing.copy();
        Reference reference = dst.location = this.location == null ? null : this.location.copy();
        if (this.participant != null) {
            dst.participant = new ArrayList<ActivityDefinitionParticipantComponent>();
            for (ActivityDefinitionParticipantComponent activityDefinitionParticipantComponent : this.participant) {
                dst.participant.add(activityDefinitionParticipantComponent.copy());
            }
        }
        dst.product = this.product == null ? null : this.product.copy();
        Quantity quantity = dst.quantity = this.quantity == null ? null : this.quantity.copy();
        if (this.dosage != null) {
            dst.dosage = new ArrayList<Dosage>();
            for (Dosage dosage : this.dosage) {
                dst.dosage.add(dosage.copy());
            }
        }
        if (this.bodySite != null) {
            dst.bodySite = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.bodySite) {
                dst.bodySite.add(codeableConcept.copy());
            }
        }
        if (this.specimenRequirement != null) {
            dst.specimenRequirement = new ArrayList<Reference>();
            for (Reference reference2 : this.specimenRequirement) {
                dst.specimenRequirement.add(reference2.copy());
            }
        }
        if (this.observationRequirement != null) {
            dst.observationRequirement = new ArrayList<Reference>();
            for (Reference reference3 : this.observationRequirement) {
                dst.observationRequirement.add(reference3.copy());
            }
        }
        if (this.observationResultRequirement != null) {
            dst.observationResultRequirement = new ArrayList<Reference>();
            for (Reference reference4 : this.observationResultRequirement) {
                dst.observationResultRequirement.add(reference4.copy());
            }
        }
        CanonicalType canonicalType = dst.transform = this.transform == null ? null : this.transform.copy();
        if (this.dynamicValue != null) {
            dst.dynamicValue = new ArrayList<ActivityDefinitionDynamicValueComponent>();
            for (ActivityDefinitionDynamicValueComponent activityDefinitionDynamicValueComponent : this.dynamicValue) {
                dst.dynamicValue.add(activityDefinitionDynamicValueComponent.copy());
            }
        }
        return dst;
    }

    protected ActivityDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ActivityDefinition)) {
            return false;
        }
        ActivityDefinition o = (ActivityDefinition)other_;
        return ActivityDefinition.compareDeep(this.identifier, o.identifier, true) && ActivityDefinition.compareDeep(this.subtitle, o.subtitle, true) && ActivityDefinition.compareDeep(this.subject, o.subject, true) && ActivityDefinition.compareDeep(this.purpose, o.purpose, true) && ActivityDefinition.compareDeep(this.usage, o.usage, true) && ActivityDefinition.compareDeep(this.copyright, o.copyright, true) && ActivityDefinition.compareDeep(this.approvalDate, o.approvalDate, true) && ActivityDefinition.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && ActivityDefinition.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && ActivityDefinition.compareDeep(this.topic, o.topic, true) && ActivityDefinition.compareDeep(this.author, o.author, true) && ActivityDefinition.compareDeep(this.editor, o.editor, true) && ActivityDefinition.compareDeep(this.reviewer, o.reviewer, true) && ActivityDefinition.compareDeep(this.endorser, o.endorser, true) && ActivityDefinition.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && ActivityDefinition.compareDeep(this.library, o.library, true) && ActivityDefinition.compareDeep(this.kind, o.kind, true) && ActivityDefinition.compareDeep(this.profile, o.profile, true) && ActivityDefinition.compareDeep(this.code, o.code, true) && ActivityDefinition.compareDeep(this.intent, o.intent, true) && ActivityDefinition.compareDeep(this.priority, o.priority, true) && ActivityDefinition.compareDeep(this.doNotPerform, o.doNotPerform, true) && ActivityDefinition.compareDeep(this.timing, o.timing, true) && ActivityDefinition.compareDeep(this.location, o.location, true) && ActivityDefinition.compareDeep(this.participant, o.participant, true) && ActivityDefinition.compareDeep(this.product, o.product, true) && ActivityDefinition.compareDeep(this.quantity, o.quantity, true) && ActivityDefinition.compareDeep(this.dosage, o.dosage, true) && ActivityDefinition.compareDeep(this.bodySite, o.bodySite, true) && ActivityDefinition.compareDeep(this.specimenRequirement, o.specimenRequirement, true) && ActivityDefinition.compareDeep(this.observationRequirement, o.observationRequirement, true) && ActivityDefinition.compareDeep(this.observationResultRequirement, o.observationResultRequirement, true) && ActivityDefinition.compareDeep(this.transform, o.transform, true) && ActivityDefinition.compareDeep(this.dynamicValue, o.dynamicValue, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ActivityDefinition)) {
            return false;
        }
        ActivityDefinition o = (ActivityDefinition)other_;
        return ActivityDefinition.compareValues(this.subtitle, o.subtitle, true) && ActivityDefinition.compareValues(this.purpose, o.purpose, true) && ActivityDefinition.compareValues(this.usage, o.usage, true) && ActivityDefinition.compareValues(this.copyright, o.copyright, true) && ActivityDefinition.compareValues(this.approvalDate, o.approvalDate, true) && ActivityDefinition.compareValues(this.lastReviewDate, o.lastReviewDate, true) && ActivityDefinition.compareValues(this.kind, o.kind, true) && ActivityDefinition.compareValues(this.intent, o.intent, true) && ActivityDefinition.compareValues(this.priority, o.priority, true) && ActivityDefinition.compareValues(this.doNotPerform, o.doNotPerform, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.subtitle, this.subject, this.purpose, this.usage, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.topic, this.author, this.editor, this.reviewer, this.endorser, this.relatedArtifact, this.library, this.kind, this.profile, this.code, this.intent, this.priority, this.doNotPerform, this.timing, this.location, this.participant, this.product, this.quantity, this.dosage, this.bodySite, this.specimenRequirement, this.observationRequirement, this.observationResultRequirement, this.transform, this.dynamicValue});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ActivityDefinition;
    }

    @Block
    public static class ActivityDefinitionDynamicValueComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="path", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The path to the element to be set dynamically", formalDefinition="The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression. The specified path SHALL be a FHIRPath resolveable on the specified target type of the ActivityDefinition, and SHALL consist only of identifiers, constant indexers, and a restricted subset of functions. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details).")
        protected StringType path;
        @Child(name="expression", type={Expression.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="An expression that provides the dynamic value for the customization", formalDefinition="An expression specifying the value of the customized element.")
        protected Expression expression;
        private static final long serialVersionUID = 1064529082L;

        public ActivityDefinitionDynamicValueComponent() {
        }

        public ActivityDefinitionDynamicValueComponent(StringType path, Expression expression) {
            this.path = path;
            this.expression = expression;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActivityDefinitionDynamicValueComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public ActivityDefinitionDynamicValueComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public ActivityDefinitionDynamicValueComponent setPath(String value) {
            if (this.path == null) {
                this.path = new StringType();
            }
            this.path.setValue(value);
            return this;
        }

        public Expression getExpression() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActivityDefinitionDynamicValueComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new Expression();
                }
            }
            return this.expression;
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public ActivityDefinitionDynamicValueComponent setExpression(Expression value) {
            this.expression = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("path", "string", "The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression. The specified path SHALL be a FHIRPath resolveable on the specified target type of the ActivityDefinition, and SHALL consist only of identifiers, constant indexers, and a restricted subset of functions. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details).", 0, 1, this.path));
            children.add(new Property("expression", "Expression", "An expression specifying the value of the customized element.", 0, 1, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3433509: {
                    return new Property("path", "string", "The path to the element to be customized. This is the path on the resource that will hold the result of the calculation defined by the expression. The specified path SHALL be a FHIRPath resolveable on the specified target type of the ActivityDefinition, and SHALL consist only of identifiers, constant indexers, and a restricted subset of functions. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details).", 0, 1, this.path);
                }
                case -1795452264: {
                    return new Property("expression", "Expression", "An expression specifying the value of the customized element.", 0, 1, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = this.castToString(value);
                    return value;
                }
                case -1795452264: {
                    this.expression = this.castToExpression(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = this.castToString(value);
            } else if (name.equals("expression")) {
                this.expression = this.castToExpression(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return this.getPathElement();
                }
                case -1795452264: {
                    return this.getExpression();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return new String[]{"string"};
                }
                case -1795452264: {
                    return new String[]{"Expression"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.path");
            }
            if (name.equals("expression")) {
                this.expression = new Expression();
                return this.expression;
            }
            return super.addChild(name);
        }

        @Override
        public ActivityDefinitionDynamicValueComponent copy() {
            ActivityDefinitionDynamicValueComponent dst = new ActivityDefinitionDynamicValueComponent();
            this.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ActivityDefinitionDynamicValueComponent)) {
                return false;
            }
            ActivityDefinitionDynamicValueComponent o = (ActivityDefinitionDynamicValueComponent)other_;
            return ActivityDefinitionDynamicValueComponent.compareDeep(this.path, o.path, true) && ActivityDefinitionDynamicValueComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ActivityDefinitionDynamicValueComponent)) {
                return false;
            }
            ActivityDefinitionDynamicValueComponent o = (ActivityDefinitionDynamicValueComponent)other_;
            return ActivityDefinitionDynamicValueComponent.compareValues(this.path, o.path, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.path, this.expression});
        }

        @Override
        public String fhirType() {
            return "ActivityDefinition.dynamicValue";
        }
    }

    @Block
    public static class ActivityDefinitionParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="patient | practitioner | related-person | device", formalDefinition="The type of participant in the action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-participant-type")
        protected Enumeration<ActivityParticipantType> type;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="E.g. Nurse, Surgeon, Parent, etc.", formalDefinition="The role the participant should play in performing the described action.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/action-participant-role")
        protected CodeableConcept role;
        private static final long serialVersionUID = -1450932564L;

        public ActivityDefinitionParticipantComponent() {
        }

        public ActivityDefinitionParticipantComponent(Enumeration<ActivityParticipantType> type) {
            this.type = type;
        }

        public Enumeration<ActivityParticipantType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActivityDefinitionParticipantComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<ActivityParticipantType>(new ActivityParticipantTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ActivityDefinitionParticipantComponent setTypeElement(Enumeration<ActivityParticipantType> value) {
            this.type = value;
            return this;
        }

        public ActivityParticipantType getType() {
            return this.type == null ? null : (ActivityParticipantType)((Object)this.type.getValue());
        }

        public ActivityDefinitionParticipantComponent setType(ActivityParticipantType value) {
            if (this.type == null) {
                this.type = new Enumeration<ActivityParticipantType>(new ActivityParticipantTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActivityDefinitionParticipantComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ActivityDefinitionParticipantComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "The type of participant in the action.", 0, 1, this.type));
            children.add(new Property("role", "CodeableConcept", "The role the participant should play in performing the described action.", 0, 1, this.role));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "The type of participant in the action.", 0, 1, this.type);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The role the participant should play in performing the described action.", 0, 1, this.role);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.role;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new ActivityParticipantTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new ActivityParticipantTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3506294: {
                    return this.getRole();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ActivityDefinition.type");
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            return super.addChild(name);
        }

        @Override
        public ActivityDefinitionParticipantComponent copy() {
            ActivityDefinitionParticipantComponent dst = new ActivityDefinitionParticipantComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.role = this.role == null ? null : this.role.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ActivityDefinitionParticipantComponent)) {
                return false;
            }
            ActivityDefinitionParticipantComponent o = (ActivityDefinitionParticipantComponent)other_;
            return ActivityDefinitionParticipantComponent.compareDeep(this.type, o.type, true) && ActivityDefinitionParticipantComponent.compareDeep(this.role, o.role, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ActivityDefinitionParticipantComponent)) {
                return false;
            }
            ActivityDefinitionParticipantComponent o = (ActivityDefinitionParticipantComponent)other_;
            return ActivityDefinitionParticipantComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.role});
        }

        @Override
        public String fhirType() {
            return "ActivityDefinition.participant";
        }
    }

    public static class ActivityParticipantTypeEnumFactory
    implements EnumFactory<ActivityParticipantType> {
        @Override
        public ActivityParticipantType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("patient".equals(codeString)) {
                return ActivityParticipantType.PATIENT;
            }
            if ("practitioner".equals(codeString)) {
                return ActivityParticipantType.PRACTITIONER;
            }
            if ("related-person".equals(codeString)) {
                return ActivityParticipantType.RELATEDPERSON;
            }
            if ("device".equals(codeString)) {
                return ActivityParticipantType.DEVICE;
            }
            throw new IllegalArgumentException("Unknown ActivityParticipantType code '" + codeString + "'");
        }

        public Enumeration<ActivityParticipantType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActivityParticipantType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("patient".equals(codeString)) {
                return new Enumeration<ActivityParticipantType>(this, ActivityParticipantType.PATIENT);
            }
            if ("practitioner".equals(codeString)) {
                return new Enumeration<ActivityParticipantType>(this, ActivityParticipantType.PRACTITIONER);
            }
            if ("related-person".equals(codeString)) {
                return new Enumeration<ActivityParticipantType>(this, ActivityParticipantType.RELATEDPERSON);
            }
            if ("device".equals(codeString)) {
                return new Enumeration<ActivityParticipantType>(this, ActivityParticipantType.DEVICE);
            }
            throw new FHIRException("Unknown ActivityParticipantType code '" + codeString + "'");
        }

        @Override
        public String toCode(ActivityParticipantType code) {
            if (code == ActivityParticipantType.PATIENT) {
                return "patient";
            }
            if (code == ActivityParticipantType.PRACTITIONER) {
                return "practitioner";
            }
            if (code == ActivityParticipantType.RELATEDPERSON) {
                return "related-person";
            }
            if (code == ActivityParticipantType.DEVICE) {
                return "device";
            }
            return "?";
        }

        @Override
        public String toSystem(ActivityParticipantType code) {
            return code.getSystem();
        }
    }

    public static enum ActivityParticipantType {
        PATIENT,
        PRACTITIONER,
        RELATEDPERSON,
        DEVICE,
        NULL;


        public static ActivityParticipantType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("patient".equals(codeString)) {
                return PATIENT;
            }
            if ("practitioner".equals(codeString)) {
                return PRACTITIONER;
            }
            if ("related-person".equals(codeString)) {
                return RELATEDPERSON;
            }
            if ("device".equals(codeString)) {
                return DEVICE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActivityParticipantType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PATIENT: {
                    return "patient";
                }
                case PRACTITIONER: {
                    return "practitioner";
                }
                case RELATEDPERSON: {
                    return "related-person";
                }
                case DEVICE: {
                    return "device";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PATIENT: {
                    return "http://hl7.org/fhir/action-participant-type";
                }
                case PRACTITIONER: {
                    return "http://hl7.org/fhir/action-participant-type";
                }
                case RELATEDPERSON: {
                    return "http://hl7.org/fhir/action-participant-type";
                }
                case DEVICE: {
                    return "http://hl7.org/fhir/action-participant-type";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PATIENT: {
                    return "The participant is the patient under evaluation.";
                }
                case PRACTITIONER: {
                    return "The participant is a practitioner involved in the patient's care.";
                }
                case RELATEDPERSON: {
                    return "The participant is a person related to the patient.";
                }
                case DEVICE: {
                    return "The participant is a system or device used in the care of the patient.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PATIENT: {
                    return "Patient";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case RELATEDPERSON: {
                    return "Related Person";
                }
                case DEVICE: {
                    return "Device";
                }
            }
            return "?";
        }
    }

    public static class RequestPriorityEnumFactory
    implements EnumFactory<RequestPriority> {
        @Override
        public RequestPriority fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return RequestPriority.ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return RequestPriority.URGENT;
            }
            if ("asap".equals(codeString)) {
                return RequestPriority.ASAP;
            }
            if ("stat".equals(codeString)) {
                return RequestPriority.STAT;
            }
            throw new IllegalArgumentException("Unknown RequestPriority code '" + codeString + "'");
        }

        public Enumeration<RequestPriority> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RequestPriority>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.ROUTINE);
            }
            if ("urgent".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.URGENT);
            }
            if ("asap".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.ASAP);
            }
            if ("stat".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.STAT);
            }
            throw new FHIRException("Unknown RequestPriority code '" + codeString + "'");
        }

        @Override
        public String toCode(RequestPriority code) {
            if (code == RequestPriority.ROUTINE) {
                return "routine";
            }
            if (code == RequestPriority.URGENT) {
                return "urgent";
            }
            if (code == RequestPriority.ASAP) {
                return "asap";
            }
            if (code == RequestPriority.STAT) {
                return "stat";
            }
            return "?";
        }

        @Override
        public String toSystem(RequestPriority code) {
            return code.getSystem();
        }
    }

    public static enum RequestPriority {
        ROUTINE,
        URGENT,
        ASAP,
        STAT,
        NULL;


        public static RequestPriority fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return URGENT;
            }
            if ("asap".equals(codeString)) {
                return ASAP;
            }
            if ("stat".equals(codeString)) {
                return STAT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RequestPriority code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ROUTINE: {
                    return "routine";
                }
                case URGENT: {
                    return "urgent";
                }
                case ASAP: {
                    return "asap";
                }
                case STAT: {
                    return "stat";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ROUTINE: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case URGENT: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case ASAP: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case STAT: {
                    return "http://hl7.org/fhir/request-priority";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ROUTINE: {
                    return "The request has normal priority.";
                }
                case URGENT: {
                    return "The request should be actioned promptly - higher priority than routine.";
                }
                case ASAP: {
                    return "The request should be actioned as soon as possible - higher priority than urgent.";
                }
                case STAT: {
                    return "The request should be actioned immediately - highest possible priority.  E.g. an emergency.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ROUTINE: {
                    return "Routine";
                }
                case URGENT: {
                    return "Urgent";
                }
                case ASAP: {
                    return "ASAP";
                }
                case STAT: {
                    return "STAT";
                }
            }
            return "?";
        }
    }

    public static class RequestIntentEnumFactory
    implements EnumFactory<RequestIntent> {
        @Override
        public RequestIntent fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return RequestIntent.PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return RequestIntent.PLAN;
            }
            if ("directive".equals(codeString)) {
                return RequestIntent.DIRECTIVE;
            }
            if ("order".equals(codeString)) {
                return RequestIntent.ORDER;
            }
            if ("original-order".equals(codeString)) {
                return RequestIntent.ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return RequestIntent.REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return RequestIntent.FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return RequestIntent.INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return RequestIntent.OPTION;
            }
            throw new IllegalArgumentException("Unknown RequestIntent code '" + codeString + "'");
        }

        public Enumeration<RequestIntent> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RequestIntent>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.PROPOSAL);
            }
            if ("plan".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.PLAN);
            }
            if ("directive".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.DIRECTIVE);
            }
            if ("order".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.ORDER);
            }
            if ("original-order".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.ORIGINALORDER);
            }
            if ("reflex-order".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.REFLEXORDER);
            }
            if ("filler-order".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.FILLERORDER);
            }
            if ("instance-order".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.INSTANCEORDER);
            }
            if ("option".equals(codeString)) {
                return new Enumeration<RequestIntent>(this, RequestIntent.OPTION);
            }
            throw new FHIRException("Unknown RequestIntent code '" + codeString + "'");
        }

        @Override
        public String toCode(RequestIntent code) {
            if (code == RequestIntent.PROPOSAL) {
                return "proposal";
            }
            if (code == RequestIntent.PLAN) {
                return "plan";
            }
            if (code == RequestIntent.DIRECTIVE) {
                return "directive";
            }
            if (code == RequestIntent.ORDER) {
                return "order";
            }
            if (code == RequestIntent.ORIGINALORDER) {
                return "original-order";
            }
            if (code == RequestIntent.REFLEXORDER) {
                return "reflex-order";
            }
            if (code == RequestIntent.FILLERORDER) {
                return "filler-order";
            }
            if (code == RequestIntent.INSTANCEORDER) {
                return "instance-order";
            }
            if (code == RequestIntent.OPTION) {
                return "option";
            }
            return "?";
        }

        @Override
        public String toSystem(RequestIntent code) {
            return code.getSystem();
        }
    }

    public static enum RequestIntent {
        PROPOSAL,
        PLAN,
        DIRECTIVE,
        ORDER,
        ORIGINALORDER,
        REFLEXORDER,
        FILLERORDER,
        INSTANCEORDER,
        OPTION,
        NULL;


        public static RequestIntent fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return PLAN;
            }
            if ("directive".equals(codeString)) {
                return DIRECTIVE;
            }
            if ("order".equals(codeString)) {
                return ORDER;
            }
            if ("original-order".equals(codeString)) {
                return ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return OPTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RequestIntent code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSAL: {
                    return "proposal";
                }
                case PLAN: {
                    return "plan";
                }
                case DIRECTIVE: {
                    return "directive";
                }
                case ORDER: {
                    return "order";
                }
                case ORIGINALORDER: {
                    return "original-order";
                }
                case REFLEXORDER: {
                    return "reflex-order";
                }
                case FILLERORDER: {
                    return "filler-order";
                }
                case INSTANCEORDER: {
                    return "instance-order";
                }
                case OPTION: {
                    return "option";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSAL: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case PLAN: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case DIRECTIVE: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORIGINALORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case REFLEXORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case FILLERORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case INSTANCEORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case OPTION: {
                    return "http://hl7.org/fhir/request-intent";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSAL: {
                    return "The request is a suggestion made by someone/something that does not have an intention to ensure it occurs and without providing an authorization to act.";
                }
                case PLAN: {
                    return "The request represents an intention to ensure something occurs without providing an authorization for others to act.";
                }
                case DIRECTIVE: {
                    return "The request represents a legally binding instruction authored by a Patient or RelatedPerson.";
                }
                case ORDER: {
                    return "The request represents a request/demand and authorization for action by a Practitioner.";
                }
                case ORIGINALORDER: {
                    return "The request represents an original authorization for action.";
                }
                case REFLEXORDER: {
                    return "The request represents an automatically generated supplemental authorization for action based on a parent authorization together with initial results of the action taken against that parent authorization.";
                }
                case FILLERORDER: {
                    return "The request represents the view of an authorization instantiated by a fulfilling system representing the details of the fulfiller's intention to act upon a submitted order.";
                }
                case INSTANCEORDER: {
                    return "An order created in fulfillment of a broader order that represents the authorization for a single activity occurrence.  E.g. The administration of a single dose of a drug.";
                }
                case OPTION: {
                    return "The request represents a component or option for a RequestGroup that establishes timing, conditionality and/or other constraints among a set of requests.  Refer to [[[RequestGroup]]] for additional information on how this status is used.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSAL: {
                    return "Proposal";
                }
                case PLAN: {
                    return "Plan";
                }
                case DIRECTIVE: {
                    return "Directive";
                }
                case ORDER: {
                    return "Order";
                }
                case ORIGINALORDER: {
                    return "Original Order";
                }
                case REFLEXORDER: {
                    return "Reflex Order";
                }
                case FILLERORDER: {
                    return "Filler Order";
                }
                case INSTANCEORDER: {
                    return "Instance Order";
                }
                case OPTION: {
                    return "Option";
                }
            }
            return "?";
        }
    }

    public static class ActivityDefinitionKindEnumFactory
    implements EnumFactory<ActivityDefinitionKind> {
        @Override
        public ActivityDefinitionKind fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("Appointment".equals(codeString)) {
                return ActivityDefinitionKind.APPOINTMENT;
            }
            if ("AppointmentResponse".equals(codeString)) {
                return ActivityDefinitionKind.APPOINTMENTRESPONSE;
            }
            if ("CarePlan".equals(codeString)) {
                return ActivityDefinitionKind.CAREPLAN;
            }
            if ("Claim".equals(codeString)) {
                return ActivityDefinitionKind.CLAIM;
            }
            if ("CommunicationRequest".equals(codeString)) {
                return ActivityDefinitionKind.COMMUNICATIONREQUEST;
            }
            if ("Contract".equals(codeString)) {
                return ActivityDefinitionKind.CONTRACT;
            }
            if ("DeviceRequest".equals(codeString)) {
                return ActivityDefinitionKind.DEVICEREQUEST;
            }
            if ("EnrollmentRequest".equals(codeString)) {
                return ActivityDefinitionKind.ENROLLMENTREQUEST;
            }
            if ("ImmunizationRecommendation".equals(codeString)) {
                return ActivityDefinitionKind.IMMUNIZATIONRECOMMENDATION;
            }
            if ("MedicationRequest".equals(codeString)) {
                return ActivityDefinitionKind.MEDICATIONREQUEST;
            }
            if ("NutritionOrder".equals(codeString)) {
                return ActivityDefinitionKind.NUTRITIONORDER;
            }
            if ("ServiceRequest".equals(codeString)) {
                return ActivityDefinitionKind.SERVICEREQUEST;
            }
            if ("SupplyRequest".equals(codeString)) {
                return ActivityDefinitionKind.SUPPLYREQUEST;
            }
            if ("Task".equals(codeString)) {
                return ActivityDefinitionKind.TASK;
            }
            if ("VisionPrescription".equals(codeString)) {
                return ActivityDefinitionKind.VISIONPRESCRIPTION;
            }
            throw new IllegalArgumentException("Unknown ActivityDefinitionKind code '" + codeString + "'");
        }

        public Enumeration<ActivityDefinitionKind> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ActivityDefinitionKind>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Appointment".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.APPOINTMENT);
            }
            if ("AppointmentResponse".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.APPOINTMENTRESPONSE);
            }
            if ("CarePlan".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.CAREPLAN);
            }
            if ("Claim".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.CLAIM);
            }
            if ("CommunicationRequest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.COMMUNICATIONREQUEST);
            }
            if ("Contract".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.CONTRACT);
            }
            if ("DeviceRequest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.DEVICEREQUEST);
            }
            if ("EnrollmentRequest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.ENROLLMENTREQUEST);
            }
            if ("ImmunizationRecommendation".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.IMMUNIZATIONRECOMMENDATION);
            }
            if ("MedicationRequest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.MEDICATIONREQUEST);
            }
            if ("NutritionOrder".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.NUTRITIONORDER);
            }
            if ("ServiceRequest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.SERVICEREQUEST);
            }
            if ("SupplyRequest".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.SUPPLYREQUEST);
            }
            if ("Task".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.TASK);
            }
            if ("VisionPrescription".equals(codeString)) {
                return new Enumeration<ActivityDefinitionKind>(this, ActivityDefinitionKind.VISIONPRESCRIPTION);
            }
            throw new FHIRException("Unknown ActivityDefinitionKind code '" + codeString + "'");
        }

        @Override
        public String toCode(ActivityDefinitionKind code) {
            if (code == ActivityDefinitionKind.APPOINTMENT) {
                return "Appointment";
            }
            if (code == ActivityDefinitionKind.APPOINTMENTRESPONSE) {
                return "AppointmentResponse";
            }
            if (code == ActivityDefinitionKind.CAREPLAN) {
                return "CarePlan";
            }
            if (code == ActivityDefinitionKind.CLAIM) {
                return "Claim";
            }
            if (code == ActivityDefinitionKind.COMMUNICATIONREQUEST) {
                return "CommunicationRequest";
            }
            if (code == ActivityDefinitionKind.CONTRACT) {
                return "Contract";
            }
            if (code == ActivityDefinitionKind.DEVICEREQUEST) {
                return "DeviceRequest";
            }
            if (code == ActivityDefinitionKind.ENROLLMENTREQUEST) {
                return "EnrollmentRequest";
            }
            if (code == ActivityDefinitionKind.IMMUNIZATIONRECOMMENDATION) {
                return "ImmunizationRecommendation";
            }
            if (code == ActivityDefinitionKind.MEDICATIONREQUEST) {
                return "MedicationRequest";
            }
            if (code == ActivityDefinitionKind.NUTRITIONORDER) {
                return "NutritionOrder";
            }
            if (code == ActivityDefinitionKind.SERVICEREQUEST) {
                return "ServiceRequest";
            }
            if (code == ActivityDefinitionKind.SUPPLYREQUEST) {
                return "SupplyRequest";
            }
            if (code == ActivityDefinitionKind.TASK) {
                return "Task";
            }
            if (code == ActivityDefinitionKind.VISIONPRESCRIPTION) {
                return "VisionPrescription";
            }
            return "?";
        }

        @Override
        public String toSystem(ActivityDefinitionKind code) {
            return code.getSystem();
        }
    }

    public static enum ActivityDefinitionKind {
        APPOINTMENT,
        APPOINTMENTRESPONSE,
        CAREPLAN,
        CLAIM,
        COMMUNICATIONREQUEST,
        CONTRACT,
        DEVICEREQUEST,
        ENROLLMENTREQUEST,
        IMMUNIZATIONRECOMMENDATION,
        MEDICATIONREQUEST,
        NUTRITIONORDER,
        SERVICEREQUEST,
        SUPPLYREQUEST,
        TASK,
        VISIONPRESCRIPTION,
        NULL;


        public static ActivityDefinitionKind fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Appointment".equals(codeString)) {
                return APPOINTMENT;
            }
            if ("AppointmentResponse".equals(codeString)) {
                return APPOINTMENTRESPONSE;
            }
            if ("CarePlan".equals(codeString)) {
                return CAREPLAN;
            }
            if ("Claim".equals(codeString)) {
                return CLAIM;
            }
            if ("CommunicationRequest".equals(codeString)) {
                return COMMUNICATIONREQUEST;
            }
            if ("Contract".equals(codeString)) {
                return CONTRACT;
            }
            if ("DeviceRequest".equals(codeString)) {
                return DEVICEREQUEST;
            }
            if ("EnrollmentRequest".equals(codeString)) {
                return ENROLLMENTREQUEST;
            }
            if ("ImmunizationRecommendation".equals(codeString)) {
                return IMMUNIZATIONRECOMMENDATION;
            }
            if ("MedicationRequest".equals(codeString)) {
                return MEDICATIONREQUEST;
            }
            if ("NutritionOrder".equals(codeString)) {
                return NUTRITIONORDER;
            }
            if ("ServiceRequest".equals(codeString)) {
                return SERVICEREQUEST;
            }
            if ("SupplyRequest".equals(codeString)) {
                return SUPPLYREQUEST;
            }
            if ("Task".equals(codeString)) {
                return TASK;
            }
            if ("VisionPrescription".equals(codeString)) {
                return VISIONPRESCRIPTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ActivityDefinitionKind code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case APPOINTMENT: {
                    return "Appointment";
                }
                case APPOINTMENTRESPONSE: {
                    return "AppointmentResponse";
                }
                case CAREPLAN: {
                    return "CarePlan";
                }
                case CLAIM: {
                    return "Claim";
                }
                case COMMUNICATIONREQUEST: {
                    return "CommunicationRequest";
                }
                case CONTRACT: {
                    return "Contract";
                }
                case DEVICEREQUEST: {
                    return "DeviceRequest";
                }
                case ENROLLMENTREQUEST: {
                    return "EnrollmentRequest";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "ImmunizationRecommendation";
                }
                case MEDICATIONREQUEST: {
                    return "MedicationRequest";
                }
                case NUTRITIONORDER: {
                    return "NutritionOrder";
                }
                case SERVICEREQUEST: {
                    return "ServiceRequest";
                }
                case SUPPLYREQUEST: {
                    return "SupplyRequest";
                }
                case TASK: {
                    return "Task";
                }
                case VISIONPRESCRIPTION: {
                    return "VisionPrescription";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case APPOINTMENT: {
                    return "http://hl7.org/fhir/request-resource-types";
                }
                case APPOINTMENTRESPONSE: {
                    return "http://hl7.org/fhir/request-resource-types";
                }
                case CAREPLAN: {
                    return "http://hl7.org/fhir/request-resource-types";
                }
                case CLAIM: {
                    return "http://hl7.org/fhir/request-resource-types";
                }
                case COMMUNICATIONREQUEST: {
                    return "http://hl7.org/fhir/request-resource-types";
                }
                case CONTRACT: {
                    return "http://hl7.org/fhir/request-resource-types";
                }
                case DEVICEREQUEST: {
                    return "http://hl7.org/fhir/request-resource-types";
                }
                case ENROLLMENTREQUEST: {
                    return "http://hl7.org/fhir/request-resource-types";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "http://hl7.org/fhir/request-resource-types";
                }
                case MEDICATIONREQUEST: {
                    return "http://hl7.org/fhir/request-resource-types";
                }
                case NUTRITIONORDER: {
                    return "http://hl7.org/fhir/request-resource-types";
                }
                case SERVICEREQUEST: {
                    return "http://hl7.org/fhir/request-resource-types";
                }
                case SUPPLYREQUEST: {
                    return "http://hl7.org/fhir/request-resource-types";
                }
                case TASK: {
                    return "http://hl7.org/fhir/request-resource-types";
                }
                case VISIONPRESCRIPTION: {
                    return "http://hl7.org/fhir/request-resource-types";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case APPOINTMENT: {
                    return "A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).";
                }
                case APPOINTMENTRESPONSE: {
                    return "A reply to an appointment request for a patient and/or practitioner(s), such as a confirmation or rejection.";
                }
                case CAREPLAN: {
                    return "Healthcare plan for patient or group.";
                }
                case CLAIM: {
                    return "Claim, Pre-determination or Pre-authorization.";
                }
                case COMMUNICATIONREQUEST: {
                    return "A request for information to be sent to a receiver.";
                }
                case CONTRACT: {
                    return "Legal Agreement.";
                }
                case DEVICEREQUEST: {
                    return "Medical device request.";
                }
                case ENROLLMENTREQUEST: {
                    return "Enrollment request.";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "Guidance or advice relating to an immunization.";
                }
                case MEDICATIONREQUEST: {
                    return "Ordering of medication for patient or group.";
                }
                case NUTRITIONORDER: {
                    return "Diet, formula or nutritional supplement request.";
                }
                case SERVICEREQUEST: {
                    return "A record of a request for service such as diagnostic investigations, treatments, or operations to be performed.";
                }
                case SUPPLYREQUEST: {
                    return "Request for a medication, substance or device.";
                }
                case TASK: {
                    return "A task to be performed.";
                }
                case VISIONPRESCRIPTION: {
                    return "Prescription for vision correction products for a patient.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case APPOINTMENT: {
                    return "Appointment";
                }
                case APPOINTMENTRESPONSE: {
                    return "AppointmentResponse";
                }
                case CAREPLAN: {
                    return "CarePlan";
                }
                case CLAIM: {
                    return "Claim";
                }
                case COMMUNICATIONREQUEST: {
                    return "CommunicationRequest";
                }
                case CONTRACT: {
                    return "Contract";
                }
                case DEVICEREQUEST: {
                    return "DeviceRequest";
                }
                case ENROLLMENTREQUEST: {
                    return "EnrollmentRequest";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "ImmunizationRecommendation";
                }
                case MEDICATIONREQUEST: {
                    return "MedicationRequest";
                }
                case NUTRITIONORDER: {
                    return "NutritionOrder";
                }
                case SERVICEREQUEST: {
                    return "ServiceRequest";
                }
                case SUPPLYREQUEST: {
                    return "SupplyRequest";
                }
                case TASK: {
                    return "Task";
                }
                case VISIONPRESCRIPTION: {
                    return "VisionPrescription";
                }
            }
            return "?";
        }
    }
}

