/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BaseBinary;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;

@ResourceDef(name="Binary", profile="http://hl7.org/fhir/StructureDefinition/Binary")
public class Binary
extends BaseBinary
implements IBaseBinary {
    @Child(name="contentType", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="MimeType of the binary content", formalDefinition="MimeType of the binary content represented as a standard MimeType (BCP 13).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
    protected CodeType contentType;
    @Child(name="securityContext", type={Reference.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Identifies another resource to use as proxy when enforcing access control", formalDefinition="This element identifies another resource that can be used as a proxy of the security sensitivity to use when deciding and enforcing access control rules for the Binary resource. Given that the Binary resource contains very few elements that can be used to determine the sensitivity of the data and relationships to individuals, the referenced resource stands in as a proxy equivalent for this purpose. This referenced resource may be related to the Binary (e.g. Media, DocumentReference), or may be some non-related Resource purely as a security proxy. E.g. to identify that the binary resource relates to a patient, and access should only be granted to applications that have access to the patient.")
    protected Reference securityContext;
    protected Resource securityContextTarget;
    @Child(name="data", type={Base64BinaryType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The actual content", formalDefinition="The actual content, base64 encoded.")
    protected Base64BinaryType data;
    private static final long serialVersionUID = 1353224198L;

    public Binary() {
    }

    public Binary(CodeType contentType) {
        this.contentType = contentType;
    }

    public CodeType getContentTypeElement() {
        if (this.contentType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Binary.contentType");
            }
            if (Configuration.doAutoCreate()) {
                this.contentType = new CodeType();
            }
        }
        return this.contentType;
    }

    public boolean hasContentTypeElement() {
        return this.contentType != null && !this.contentType.isEmpty();
    }

    public boolean hasContentType() {
        return this.contentType != null && !this.contentType.isEmpty();
    }

    public Binary setContentTypeElement(CodeType value) {
        this.contentType = value;
        return this;
    }

    public String getContentType() {
        return this.contentType == null ? null : (String)this.contentType.getValue();
    }

    public Binary setContentType(String value) {
        if (this.contentType == null) {
            this.contentType = new CodeType();
        }
        this.contentType.setValue(value);
        return this;
    }

    public Reference getSecurityContext() {
        if (this.securityContext == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Binary.securityContext");
            }
            if (Configuration.doAutoCreate()) {
                this.securityContext = new Reference();
            }
        }
        return this.securityContext;
    }

    public boolean hasSecurityContext() {
        return this.securityContext != null && !this.securityContext.isEmpty();
    }

    public Binary setSecurityContext(Reference value) {
        this.securityContext = value;
        return this;
    }

    public Resource getSecurityContextTarget() {
        return this.securityContextTarget;
    }

    public Binary setSecurityContextTarget(Resource value) {
        this.securityContextTarget = value;
        return this;
    }

    public Base64BinaryType getDataElement() {
        if (this.data == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Binary.data");
            }
            if (Configuration.doAutoCreate()) {
                this.data = new Base64BinaryType();
            }
        }
        return this.data;
    }

    public boolean hasDataElement() {
        return this.data != null && !this.data.isEmpty();
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public Binary setDataElement(Base64BinaryType value) {
        this.data = value;
        return this;
    }

    public byte[] getData() {
        return this.data == null ? null : this.data.getValue();
    }

    public Binary setData(byte[] value) {
        if (value == null) {
            this.data = null;
        } else {
            if (this.data == null) {
                this.data = new Base64BinaryType();
            }
            this.data.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("contentType", "code", "MimeType of the binary content represented as a standard MimeType (BCP 13).", 0, 1, this.contentType));
        children.add(new Property("securityContext", "Reference(Any)", "This element identifies another resource that can be used as a proxy of the security sensitivity to use when deciding and enforcing access control rules for the Binary resource. Given that the Binary resource contains very few elements that can be used to determine the sensitivity of the data and relationships to individuals, the referenced resource stands in as a proxy equivalent for this purpose. This referenced resource may be related to the Binary (e.g. Media, DocumentReference), or may be some non-related Resource purely as a security proxy. E.g. to identify that the binary resource relates to a patient, and access should only be granted to applications that have access to the patient.", 0, 1, this.securityContext));
        children.add(new Property("data", "base64Binary", "The actual content, base64 encoded.", 0, 1, this.data));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -389131437: {
                return new Property("contentType", "code", "MimeType of the binary content represented as a standard MimeType (BCP 13).", 0, 1, this.contentType);
            }
            case -1622888881: {
                return new Property("securityContext", "Reference(Any)", "This element identifies another resource that can be used as a proxy of the security sensitivity to use when deciding and enforcing access control rules for the Binary resource. Given that the Binary resource contains very few elements that can be used to determine the sensitivity of the data and relationships to individuals, the referenced resource stands in as a proxy equivalent for this purpose. This referenced resource may be related to the Binary (e.g. Media, DocumentReference), or may be some non-related Resource purely as a security proxy. E.g. to identify that the binary resource relates to a patient, and access should only be granted to applications that have access to the patient.", 0, 1, this.securityContext);
            }
            case 3076010: {
                return new Property("data", "base64Binary", "The actual content, base64 encoded.", 0, 1, this.data);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -389131437: {
                Base[] baseArray;
                if (this.contentType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.contentType;
                }
                return baseArray;
            }
            case -1622888881: {
                Base[] baseArray;
                if (this.securityContext == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.securityContext;
                }
                return baseArray;
            }
            case 3076010: {
                Base[] baseArray;
                if (this.data == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.data;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -389131437: {
                this.contentType = this.castToCode(value);
                return value;
            }
            case -1622888881: {
                this.securityContext = this.castToReference(value);
                return value;
            }
            case 3076010: {
                this.data = this.castToBase64Binary(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("contentType")) {
            this.contentType = this.castToCode(value);
        } else if (name.equals("securityContext")) {
            this.securityContext = this.castToReference(value);
        } else if (name.equals("data")) {
            this.data = this.castToBase64Binary(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -389131437: {
                return this.getContentTypeElement();
            }
            case -1622888881: {
                return this.getSecurityContext();
            }
            case 3076010: {
                return this.getDataElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -389131437: {
                return new String[]{"code"};
            }
            case -1622888881: {
                return new String[]{"Reference"};
            }
            case 3076010: {
                return new String[]{"base64Binary"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("contentType")) {
            throw new FHIRException("Cannot call addChild on a primitive type Binary.contentType");
        }
        if (name.equals("securityContext")) {
            this.securityContext = new Reference();
            return this.securityContext;
        }
        if (name.equals("data")) {
            throw new FHIRException("Cannot call addChild on a primitive type Binary.data");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Binary";
    }

    @Override
    public Binary copy() {
        Binary dst = new Binary();
        this.copyValues(dst);
        dst.contentType = this.contentType == null ? null : this.contentType.copy();
        dst.securityContext = this.securityContext == null ? null : this.securityContext.copy();
        dst.data = this.data == null ? null : this.data.copy();
        return dst;
    }

    protected Binary typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Binary)) {
            return false;
        }
        Binary o = (Binary)other_;
        return Binary.compareDeep(this.contentType, o.contentType, true) && Binary.compareDeep(this.securityContext, o.securityContext, true) && Binary.compareDeep(this.data, o.data, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Binary)) {
            return false;
        }
        Binary o = (Binary)other_;
        return Binary.compareValues(this.contentType, o.contentType, true) && Binary.compareValues(this.data, o.data, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.contentType, this.securityContext, this.data});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Binary;
    }

    public byte[] getContent() {
        return this.getData();
    }

    public IBaseBinary setContent(byte[] arg0) {
        return this.setData(arg0);
    }

    @Override
    Base64BinaryType getContentElement() {
        return this.getDataElement();
    }
}

