/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import org.hl7.fhir.r5.model.Enumerations;

public enum FhirPublication {
    NULL,
    DSTU1,
    DSTU2,
    DSTU2016May,
    STU3,
    R4,
    R5;


    public static FhirPublication fromCode(String v) {
        if ("1.0.2".equals(v)) {
            return DSTU2;
        }
        if ("1.0".equals(v)) {
            return DSTU2;
        }
        if ("1.4.0".equals(v)) {
            return DSTU2016May;
        }
        if ("1.4".equals(v)) {
            return DSTU2016May;
        }
        if ("3.0.1".equals(v)) {
            return STU3;
        }
        if ("3.0".equals(v)) {
            return STU3;
        }
        if ("3.5.0".equals(v)) {
            return R4;
        }
        if ("4.0.0".equals(v)) {
            return R4;
        }
        if ("3.5".equals(v)) {
            return R4;
        }
        if ("4.0".equals(v)) {
            return R4;
        }
        if ("4.1.0".equals(v)) {
            return R5;
        }
        return null;
    }

    public String toCode() {
        switch (this) {
            case DSTU1: {
                return "0.01";
            }
            case DSTU2: {
                return "1.0.2";
            }
            case DSTU2016May: {
                return "1.4.0";
            }
            case STU3: {
                return "3.0.1";
            }
            case R4: {
                return "4.1.0";
            }
        }
        return "??";
    }

    public static FhirPublication fromVersion(Enumerations.FHIRVersion v) {
        return FhirPublication.fromCode(v.toCode());
    }
}

