/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MedicinalProduct;
import org.hl7.fhir.r5.model.MedicinalProductPackaged;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Type;

@ResourceDef(name="MedicinalProductAuthorization", profile="http://hl7.org/fhir/StructureDefinition/MedicinalProductAuthorization")
public class MedicinalProductAuthorization
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for the marketing authorization, as assigned by a regulator", formalDefinition="Business identifier for the marketing authorization, as assigned by a regulator.")
    protected List<Identifier> identifier;
    @Child(name="subject", type={MedicinalProduct.class, MedicinalProductPackaged.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The medicinal product that is being authorized", formalDefinition="The medicinal product that is being authorized.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="country", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The country in which the marketing authorization has been granted", formalDefinition="The country in which the marketing authorization has been granted.")
    protected List<CodeableConcept> country;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Jurisdiction within a country", formalDefinition="Jurisdiction within a country.")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="status", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The status of the marketing authorization", formalDefinition="The status of the marketing authorization.")
    protected CodeableConcept status;
    @Child(name="statusDate", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date at which the given status has become applicable", formalDefinition="The date at which the given status has become applicable.")
    protected DateTimeType statusDate;
    @Child(name="restoreDate", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date when a suspended the marketing or the marketing authorization of the product is anticipated to be restored", formalDefinition="The date when a suspended the marketing or the marketing authorization of the product is anticipated to be restored.")
    protected DateTimeType restoreDate;
    @Child(name="validityPeriod", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The beginning of the time period in which the marketing authorization is in the specific status shall be specified A complete date consisting of day, month and year shall be specified using the ISO 8601 date format", formalDefinition="The beginning of the time period in which the marketing authorization is in the specific status shall be specified A complete date consisting of day, month and year shall be specified using the ISO 8601 date format.")
    protected Period validityPeriod;
    @Child(name="dataExclusivityPeriod", type={Period.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A period of time after authorization before generic product applicatiosn can be submitted", formalDefinition="A period of time after authorization before generic product applicatiosn can be submitted.")
    protected Period dataExclusivityPeriod;
    @Child(name="dateOfFirstAuthorization", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date when the first authorization was granted by a Medicines Regulatory Agency", formalDefinition="The date when the first authorization was granted by a Medicines Regulatory Agency.")
    protected DateTimeType dateOfFirstAuthorization;
    @Child(name="internationalBirthDate", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date of first marketing authorization for a company's new medicinal product in any country in the World", formalDefinition="Date of first marketing authorization for a company's new medicinal product in any country in the World.")
    protected DateTimeType internationalBirthDate;
    @Child(name="legalBasis", type={CodeableConcept.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The legal framework against which this authorization is granted", formalDefinition="The legal framework against which this authorization is granted.")
    protected CodeableConcept legalBasis;
    @Child(name="jurisdictionalAuthorization", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Authorization in areas within a country", formalDefinition="Authorization in areas within a country.")
    protected List<MedicinalProductAuthorizationJurisdictionalAuthorizationComponent> jurisdictionalAuthorization;
    @Child(name="holder", type={Organization.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Marketing Authorization Holder", formalDefinition="Marketing Authorization Holder.")
    protected Reference holder;
    protected Organization holderTarget;
    @Child(name="regulator", type={Organization.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Medicines Regulatory Agency", formalDefinition="Medicines Regulatory Agency.")
    protected Reference regulator;
    protected Organization regulatorTarget;
    @Child(name="procedure", type={}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The regulatory procedure for granting or amending a marketing authorization", formalDefinition="The regulatory procedure for granting or amending a marketing authorization.")
    protected MedicinalProductAuthorizationProcedureComponent procedure;
    private static final long serialVersionUID = 16249078L;
    @SearchParamDefinition(name="identifier", path="MedicinalProductAuthorization.identifier", description="Business identifier for the marketing authorization, as assigned by a regulator", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="country", path="MedicinalProductAuthorization.country", description="The country in which the marketing authorization has been granted", type="token")
    public static final String SP_COUNTRY = "country";
    public static final TokenClientParam COUNTRY = new TokenClientParam("country");
    @SearchParamDefinition(name="subject", path="MedicinalProductAuthorization.subject", description="The medicinal product that is being authorized", type="reference", target={MedicinalProduct.class, MedicinalProductPackaged.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MedicinalProductAuthorization:subject").toLocked();
    @SearchParamDefinition(name="holder", path="MedicinalProductAuthorization.holder", description="Marketing Authorization Holder", type="reference", target={Organization.class})
    public static final String SP_HOLDER = "holder";
    public static final ReferenceClientParam HOLDER = new ReferenceClientParam("holder");
    public static final Include INCLUDE_HOLDER = new Include("MedicinalProductAuthorization:holder").toLocked();
    @SearchParamDefinition(name="status", path="MedicinalProductAuthorization.status", description="The status of the marketing authorization", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicinalProductAuthorization setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicinalProductAuthorization addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductAuthorization.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public MedicinalProductAuthorization setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public MedicinalProductAuthorization setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public List<CodeableConcept> getCountry() {
        if (this.country == null) {
            this.country = new ArrayList<CodeableConcept>();
        }
        return this.country;
    }

    public MedicinalProductAuthorization setCountry(List<CodeableConcept> theCountry) {
        this.country = theCountry;
        return this;
    }

    public boolean hasCountry() {
        if (this.country == null) {
            return false;
        }
        for (CodeableConcept item : this.country) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCountry() {
        CodeableConcept t = new CodeableConcept();
        if (this.country == null) {
            this.country = new ArrayList<CodeableConcept>();
        }
        this.country.add(t);
        return t;
    }

    public MedicinalProductAuthorization addCountry(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.country == null) {
            this.country = new ArrayList<CodeableConcept>();
        }
        this.country.add(t);
        return this;
    }

    public CodeableConcept getCountryFirstRep() {
        if (this.getCountry().isEmpty()) {
            this.addCountry();
        }
        return this.getCountry().get(0);
    }

    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    public MedicinalProductAuthorization setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    public MedicinalProductAuthorization addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public CodeableConcept getStatus() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductAuthorization.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeableConcept();
            }
        }
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicinalProductAuthorization setStatus(CodeableConcept value) {
        this.status = value;
        return this;
    }

    public DateTimeType getStatusDateElement() {
        if (this.statusDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductAuthorization.statusDate");
            }
            if (Configuration.doAutoCreate()) {
                this.statusDate = new DateTimeType();
            }
        }
        return this.statusDate;
    }

    public boolean hasStatusDateElement() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public boolean hasStatusDate() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public MedicinalProductAuthorization setStatusDateElement(DateTimeType value) {
        this.statusDate = value;
        return this;
    }

    public Date getStatusDate() {
        return this.statusDate == null ? null : (Date)this.statusDate.getValue();
    }

    public MedicinalProductAuthorization setStatusDate(Date value) {
        if (value == null) {
            this.statusDate = null;
        } else {
            if (this.statusDate == null) {
                this.statusDate = new DateTimeType();
            }
            this.statusDate.setValue(value);
        }
        return this;
    }

    public DateTimeType getRestoreDateElement() {
        if (this.restoreDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductAuthorization.restoreDate");
            }
            if (Configuration.doAutoCreate()) {
                this.restoreDate = new DateTimeType();
            }
        }
        return this.restoreDate;
    }

    public boolean hasRestoreDateElement() {
        return this.restoreDate != null && !this.restoreDate.isEmpty();
    }

    public boolean hasRestoreDate() {
        return this.restoreDate != null && !this.restoreDate.isEmpty();
    }

    public MedicinalProductAuthorization setRestoreDateElement(DateTimeType value) {
        this.restoreDate = value;
        return this;
    }

    public Date getRestoreDate() {
        return this.restoreDate == null ? null : (Date)this.restoreDate.getValue();
    }

    public MedicinalProductAuthorization setRestoreDate(Date value) {
        if (value == null) {
            this.restoreDate = null;
        } else {
            if (this.restoreDate == null) {
                this.restoreDate = new DateTimeType();
            }
            this.restoreDate.setValue(value);
        }
        return this;
    }

    public Period getValidityPeriod() {
        if (this.validityPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductAuthorization.validityPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.validityPeriod = new Period();
            }
        }
        return this.validityPeriod;
    }

    public boolean hasValidityPeriod() {
        return this.validityPeriod != null && !this.validityPeriod.isEmpty();
    }

    public MedicinalProductAuthorization setValidityPeriod(Period value) {
        this.validityPeriod = value;
        return this;
    }

    public Period getDataExclusivityPeriod() {
        if (this.dataExclusivityPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductAuthorization.dataExclusivityPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.dataExclusivityPeriod = new Period();
            }
        }
        return this.dataExclusivityPeriod;
    }

    public boolean hasDataExclusivityPeriod() {
        return this.dataExclusivityPeriod != null && !this.dataExclusivityPeriod.isEmpty();
    }

    public MedicinalProductAuthorization setDataExclusivityPeriod(Period value) {
        this.dataExclusivityPeriod = value;
        return this;
    }

    public DateTimeType getDateOfFirstAuthorizationElement() {
        if (this.dateOfFirstAuthorization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductAuthorization.dateOfFirstAuthorization");
            }
            if (Configuration.doAutoCreate()) {
                this.dateOfFirstAuthorization = new DateTimeType();
            }
        }
        return this.dateOfFirstAuthorization;
    }

    public boolean hasDateOfFirstAuthorizationElement() {
        return this.dateOfFirstAuthorization != null && !this.dateOfFirstAuthorization.isEmpty();
    }

    public boolean hasDateOfFirstAuthorization() {
        return this.dateOfFirstAuthorization != null && !this.dateOfFirstAuthorization.isEmpty();
    }

    public MedicinalProductAuthorization setDateOfFirstAuthorizationElement(DateTimeType value) {
        this.dateOfFirstAuthorization = value;
        return this;
    }

    public Date getDateOfFirstAuthorization() {
        return this.dateOfFirstAuthorization == null ? null : (Date)this.dateOfFirstAuthorization.getValue();
    }

    public MedicinalProductAuthorization setDateOfFirstAuthorization(Date value) {
        if (value == null) {
            this.dateOfFirstAuthorization = null;
        } else {
            if (this.dateOfFirstAuthorization == null) {
                this.dateOfFirstAuthorization = new DateTimeType();
            }
            this.dateOfFirstAuthorization.setValue(value);
        }
        return this;
    }

    public DateTimeType getInternationalBirthDateElement() {
        if (this.internationalBirthDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductAuthorization.internationalBirthDate");
            }
            if (Configuration.doAutoCreate()) {
                this.internationalBirthDate = new DateTimeType();
            }
        }
        return this.internationalBirthDate;
    }

    public boolean hasInternationalBirthDateElement() {
        return this.internationalBirthDate != null && !this.internationalBirthDate.isEmpty();
    }

    public boolean hasInternationalBirthDate() {
        return this.internationalBirthDate != null && !this.internationalBirthDate.isEmpty();
    }

    public MedicinalProductAuthorization setInternationalBirthDateElement(DateTimeType value) {
        this.internationalBirthDate = value;
        return this;
    }

    public Date getInternationalBirthDate() {
        return this.internationalBirthDate == null ? null : (Date)this.internationalBirthDate.getValue();
    }

    public MedicinalProductAuthorization setInternationalBirthDate(Date value) {
        if (value == null) {
            this.internationalBirthDate = null;
        } else {
            if (this.internationalBirthDate == null) {
                this.internationalBirthDate = new DateTimeType();
            }
            this.internationalBirthDate.setValue(value);
        }
        return this;
    }

    public CodeableConcept getLegalBasis() {
        if (this.legalBasis == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductAuthorization.legalBasis");
            }
            if (Configuration.doAutoCreate()) {
                this.legalBasis = new CodeableConcept();
            }
        }
        return this.legalBasis;
    }

    public boolean hasLegalBasis() {
        return this.legalBasis != null && !this.legalBasis.isEmpty();
    }

    public MedicinalProductAuthorization setLegalBasis(CodeableConcept value) {
        this.legalBasis = value;
        return this;
    }

    public List<MedicinalProductAuthorizationJurisdictionalAuthorizationComponent> getJurisdictionalAuthorization() {
        if (this.jurisdictionalAuthorization == null) {
            this.jurisdictionalAuthorization = new ArrayList<MedicinalProductAuthorizationJurisdictionalAuthorizationComponent>();
        }
        return this.jurisdictionalAuthorization;
    }

    public MedicinalProductAuthorization setJurisdictionalAuthorization(List<MedicinalProductAuthorizationJurisdictionalAuthorizationComponent> theJurisdictionalAuthorization) {
        this.jurisdictionalAuthorization = theJurisdictionalAuthorization;
        return this;
    }

    public boolean hasJurisdictionalAuthorization() {
        if (this.jurisdictionalAuthorization == null) {
            return false;
        }
        for (MedicinalProductAuthorizationJurisdictionalAuthorizationComponent item : this.jurisdictionalAuthorization) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductAuthorizationJurisdictionalAuthorizationComponent addJurisdictionalAuthorization() {
        MedicinalProductAuthorizationJurisdictionalAuthorizationComponent t = new MedicinalProductAuthorizationJurisdictionalAuthorizationComponent();
        if (this.jurisdictionalAuthorization == null) {
            this.jurisdictionalAuthorization = new ArrayList<MedicinalProductAuthorizationJurisdictionalAuthorizationComponent>();
        }
        this.jurisdictionalAuthorization.add(t);
        return t;
    }

    public MedicinalProductAuthorization addJurisdictionalAuthorization(MedicinalProductAuthorizationJurisdictionalAuthorizationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdictionalAuthorization == null) {
            this.jurisdictionalAuthorization = new ArrayList<MedicinalProductAuthorizationJurisdictionalAuthorizationComponent>();
        }
        this.jurisdictionalAuthorization.add(t);
        return this;
    }

    public MedicinalProductAuthorizationJurisdictionalAuthorizationComponent getJurisdictionalAuthorizationFirstRep() {
        if (this.getJurisdictionalAuthorization().isEmpty()) {
            this.addJurisdictionalAuthorization();
        }
        return this.getJurisdictionalAuthorization().get(0);
    }

    public Reference getHolder() {
        if (this.holder == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductAuthorization.holder");
            }
            if (Configuration.doAutoCreate()) {
                this.holder = new Reference();
            }
        }
        return this.holder;
    }

    public boolean hasHolder() {
        return this.holder != null && !this.holder.isEmpty();
    }

    public MedicinalProductAuthorization setHolder(Reference value) {
        this.holder = value;
        return this;
    }

    public Organization getHolderTarget() {
        if (this.holderTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductAuthorization.holder");
            }
            if (Configuration.doAutoCreate()) {
                this.holderTarget = new Organization();
            }
        }
        return this.holderTarget;
    }

    public MedicinalProductAuthorization setHolderTarget(Organization value) {
        this.holderTarget = value;
        return this;
    }

    public Reference getRegulator() {
        if (this.regulator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductAuthorization.regulator");
            }
            if (Configuration.doAutoCreate()) {
                this.regulator = new Reference();
            }
        }
        return this.regulator;
    }

    public boolean hasRegulator() {
        return this.regulator != null && !this.regulator.isEmpty();
    }

    public MedicinalProductAuthorization setRegulator(Reference value) {
        this.regulator = value;
        return this;
    }

    public Organization getRegulatorTarget() {
        if (this.regulatorTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductAuthorization.regulator");
            }
            if (Configuration.doAutoCreate()) {
                this.regulatorTarget = new Organization();
            }
        }
        return this.regulatorTarget;
    }

    public MedicinalProductAuthorization setRegulatorTarget(Organization value) {
        this.regulatorTarget = value;
        return this;
    }

    public MedicinalProductAuthorizationProcedureComponent getProcedure() {
        if (this.procedure == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductAuthorization.procedure");
            }
            if (Configuration.doAutoCreate()) {
                this.procedure = new MedicinalProductAuthorizationProcedureComponent();
            }
        }
        return this.procedure;
    }

    public boolean hasProcedure() {
        return this.procedure != null && !this.procedure.isEmpty();
    }

    public MedicinalProductAuthorization setProcedure(MedicinalProductAuthorizationProcedureComponent value) {
        this.procedure = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier for the marketing authorization, as assigned by a regulator.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_SUBJECT, "Reference(MedicinalProduct|MedicinalProductPackaged)", "The medicinal product that is being authorized.", 0, 1, this.subject));
        children.add(new Property(SP_COUNTRY, "CodeableConcept", "The country in which the marketing authorization has been granted.", 0, Integer.MAX_VALUE, this.country));
        children.add(new Property("jurisdiction", "CodeableConcept", "Jurisdiction within a country.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property(SP_STATUS, "CodeableConcept", "The status of the marketing authorization.", 0, 1, this.status));
        children.add(new Property("statusDate", "dateTime", "The date at which the given status has become applicable.", 0, 1, this.statusDate));
        children.add(new Property("restoreDate", "dateTime", "The date when a suspended the marketing or the marketing authorization of the product is anticipated to be restored.", 0, 1, this.restoreDate));
        children.add(new Property("validityPeriod", "Period", "The beginning of the time period in which the marketing authorization is in the specific status shall be specified A complete date consisting of day, month and year shall be specified using the ISO 8601 date format.", 0, 1, this.validityPeriod));
        children.add(new Property("dataExclusivityPeriod", "Period", "A period of time after authorization before generic product applicatiosn can be submitted.", 0, 1, this.dataExclusivityPeriod));
        children.add(new Property("dateOfFirstAuthorization", "dateTime", "The date when the first authorization was granted by a Medicines Regulatory Agency.", 0, 1, this.dateOfFirstAuthorization));
        children.add(new Property("internationalBirthDate", "dateTime", "Date of first marketing authorization for a company's new medicinal product in any country in the World.", 0, 1, this.internationalBirthDate));
        children.add(new Property("legalBasis", "CodeableConcept", "The legal framework against which this authorization is granted.", 0, 1, this.legalBasis));
        children.add(new Property("jurisdictionalAuthorization", "", "Authorization in areas within a country.", 0, Integer.MAX_VALUE, this.jurisdictionalAuthorization));
        children.add(new Property(SP_HOLDER, "Reference(Organization)", "Marketing Authorization Holder.", 0, 1, this.holder));
        children.add(new Property("regulator", "Reference(Organization)", "Medicines Regulatory Agency.", 0, 1, this.regulator));
        children.add(new Property("procedure", "", "The regulatory procedure for granting or amending a marketing authorization.", 0, 1, this.procedure));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier for the marketing authorization, as assigned by a regulator.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(MedicinalProduct|MedicinalProductPackaged)", "The medicinal product that is being authorized.", 0, 1, this.subject);
            }
            case 957831062: {
                return new Property(SP_COUNTRY, "CodeableConcept", "The country in which the marketing authorization has been granted.", 0, Integer.MAX_VALUE, this.country);
            }
            case -507075711: {
                return new Property("jurisdiction", "CodeableConcept", "Jurisdiction within a country.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -892481550: {
                return new Property(SP_STATUS, "CodeableConcept", "The status of the marketing authorization.", 0, 1, this.status);
            }
            case 247524032: {
                return new Property("statusDate", "dateTime", "The date at which the given status has become applicable.", 0, 1, this.statusDate);
            }
            case 329465692: {
                return new Property("restoreDate", "dateTime", "The date when a suspended the marketing or the marketing authorization of the product is anticipated to be restored.", 0, 1, this.restoreDate);
            }
            case -1434195053: {
                return new Property("validityPeriod", "Period", "The beginning of the time period in which the marketing authorization is in the specific status shall be specified A complete date consisting of day, month and year shall be specified using the ISO 8601 date format.", 0, 1, this.validityPeriod);
            }
            case 1940655806: {
                return new Property("dataExclusivityPeriod", "Period", "A period of time after authorization before generic product applicatiosn can be submitted.", 0, 1, this.dataExclusivityPeriod);
            }
            case -1026933074: {
                return new Property("dateOfFirstAuthorization", "dateTime", "The date when the first authorization was granted by a Medicines Regulatory Agency.", 0, 1, this.dateOfFirstAuthorization);
            }
            case 400069151: {
                return new Property("internationalBirthDate", "dateTime", "Date of first marketing authorization for a company's new medicinal product in any country in the World.", 0, 1, this.internationalBirthDate);
            }
            case 552357125: {
                return new Property("legalBasis", "CodeableConcept", "The legal framework against which this authorization is granted.", 0, 1, this.legalBasis);
            }
            case 1459432557: {
                return new Property("jurisdictionalAuthorization", "", "Authorization in areas within a country.", 0, Integer.MAX_VALUE, this.jurisdictionalAuthorization);
            }
            case -1211707988: {
                return new Property(SP_HOLDER, "Reference(Organization)", "Marketing Authorization Holder.", 0, 1, this.holder);
            }
            case 414760449: {
                return new Property("regulator", "Reference(Organization)", "Medicines Regulatory Agency.", 0, 1, this.regulator);
            }
            case -1095204141: {
                return new Property("procedure", "", "The regulatory procedure for granting or amending a marketing authorization.", 0, 1, this.procedure);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.subject;
                }
                return baseArray;
            }
            case 957831062: {
                return this.country == null ? new Base[]{} : this.country.toArray(new Base[this.country.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 247524032: {
                Base[] baseArray;
                if (this.statusDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.statusDate;
                }
                return baseArray;
            }
            case 329465692: {
                Base[] baseArray;
                if (this.restoreDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.restoreDate;
                }
                return baseArray;
            }
            case -1434195053: {
                Base[] baseArray;
                if (this.validityPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.validityPeriod;
                }
                return baseArray;
            }
            case 1940655806: {
                Base[] baseArray;
                if (this.dataExclusivityPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.dataExclusivityPeriod;
                }
                return baseArray;
            }
            case -1026933074: {
                Base[] baseArray;
                if (this.dateOfFirstAuthorization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.dateOfFirstAuthorization;
                }
                return baseArray;
            }
            case 400069151: {
                Base[] baseArray;
                if (this.internationalBirthDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.internationalBirthDate;
                }
                return baseArray;
            }
            case 552357125: {
                Base[] baseArray;
                if (this.legalBasis == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.legalBasis;
                }
                return baseArray;
            }
            case 1459432557: {
                return this.jurisdictionalAuthorization == null ? new Base[]{} : this.jurisdictionalAuthorization.toArray(new Base[this.jurisdictionalAuthorization.size()]);
            }
            case -1211707988: {
                Base[] baseArray;
                if (this.holder == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.holder;
                }
                return baseArray;
            }
            case 414760449: {
                Base[] baseArray;
                if (this.regulator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.regulator;
                }
                return baseArray;
            }
            case -1095204141: {
                Base[] baseArray;
                if (this.procedure == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.procedure;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 957831062: {
                this.getCountry().add(this.castToCodeableConcept(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case -892481550: {
                this.status = this.castToCodeableConcept(value);
                return value;
            }
            case 247524032: {
                this.statusDate = this.castToDateTime(value);
                return value;
            }
            case 329465692: {
                this.restoreDate = this.castToDateTime(value);
                return value;
            }
            case -1434195053: {
                this.validityPeriod = this.castToPeriod(value);
                return value;
            }
            case 1940655806: {
                this.dataExclusivityPeriod = this.castToPeriod(value);
                return value;
            }
            case -1026933074: {
                this.dateOfFirstAuthorization = this.castToDateTime(value);
                return value;
            }
            case 400069151: {
                this.internationalBirthDate = this.castToDateTime(value);
                return value;
            }
            case 552357125: {
                this.legalBasis = this.castToCodeableConcept(value);
                return value;
            }
            case 1459432557: {
                this.getJurisdictionalAuthorization().add((MedicinalProductAuthorizationJurisdictionalAuthorizationComponent)value);
                return value;
            }
            case -1211707988: {
                this.holder = this.castToReference(value);
                return value;
            }
            case 414760449: {
                this.regulator = this.castToReference(value);
                return value;
            }
            case -1095204141: {
                this.procedure = (MedicinalProductAuthorizationProcedureComponent)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_COUNTRY)) {
            this.getCountry().add(this.castToCodeableConcept(value));
        } else if (name.equals("jurisdiction")) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = this.castToCodeableConcept(value);
        } else if (name.equals("statusDate")) {
            this.statusDate = this.castToDateTime(value);
        } else if (name.equals("restoreDate")) {
            this.restoreDate = this.castToDateTime(value);
        } else if (name.equals("validityPeriod")) {
            this.validityPeriod = this.castToPeriod(value);
        } else if (name.equals("dataExclusivityPeriod")) {
            this.dataExclusivityPeriod = this.castToPeriod(value);
        } else if (name.equals("dateOfFirstAuthorization")) {
            this.dateOfFirstAuthorization = this.castToDateTime(value);
        } else if (name.equals("internationalBirthDate")) {
            this.internationalBirthDate = this.castToDateTime(value);
        } else if (name.equals("legalBasis")) {
            this.legalBasis = this.castToCodeableConcept(value);
        } else if (name.equals("jurisdictionalAuthorization")) {
            this.getJurisdictionalAuthorization().add((MedicinalProductAuthorizationJurisdictionalAuthorizationComponent)value);
        } else if (name.equals(SP_HOLDER)) {
            this.holder = this.castToReference(value);
        } else if (name.equals("regulator")) {
            this.regulator = this.castToReference(value);
        } else if (name.equals("procedure")) {
            this.procedure = (MedicinalProductAuthorizationProcedureComponent)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 957831062: {
                return this.addCountry();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -892481550: {
                return this.getStatus();
            }
            case 247524032: {
                return this.getStatusDateElement();
            }
            case 329465692: {
                return this.getRestoreDateElement();
            }
            case -1434195053: {
                return this.getValidityPeriod();
            }
            case 1940655806: {
                return this.getDataExclusivityPeriod();
            }
            case -1026933074: {
                return this.getDateOfFirstAuthorizationElement();
            }
            case 400069151: {
                return this.getInternationalBirthDateElement();
            }
            case 552357125: {
                return this.getLegalBasis();
            }
            case 1459432557: {
                return this.addJurisdictionalAuthorization();
            }
            case -1211707988: {
                return this.getHolder();
            }
            case 414760449: {
                return this.getRegulator();
            }
            case -1095204141: {
                return this.getProcedure();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 957831062: {
                return new String[]{"CodeableConcept"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{"CodeableConcept"};
            }
            case 247524032: {
                return new String[]{"dateTime"};
            }
            case 329465692: {
                return new String[]{"dateTime"};
            }
            case -1434195053: {
                return new String[]{"Period"};
            }
            case 1940655806: {
                return new String[]{"Period"};
            }
            case -1026933074: {
                return new String[]{"dateTime"};
            }
            case 400069151: {
                return new String[]{"dateTime"};
            }
            case 552357125: {
                return new String[]{"CodeableConcept"};
            }
            case 1459432557: {
                return new String[0];
            }
            case -1211707988: {
                return new String[]{"Reference"};
            }
            case 414760449: {
                return new String[]{"Reference"};
            }
            case -1095204141: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_COUNTRY)) {
            return this.addCountry();
        }
        if (name.equals("jurisdiction")) {
            return this.addJurisdiction();
        }
        if (name.equals(SP_STATUS)) {
            this.status = new CodeableConcept();
            return this.status;
        }
        if (name.equals("statusDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductAuthorization.statusDate");
        }
        if (name.equals("restoreDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductAuthorization.restoreDate");
        }
        if (name.equals("validityPeriod")) {
            this.validityPeriod = new Period();
            return this.validityPeriod;
        }
        if (name.equals("dataExclusivityPeriod")) {
            this.dataExclusivityPeriod = new Period();
            return this.dataExclusivityPeriod;
        }
        if (name.equals("dateOfFirstAuthorization")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductAuthorization.dateOfFirstAuthorization");
        }
        if (name.equals("internationalBirthDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductAuthorization.internationalBirthDate");
        }
        if (name.equals("legalBasis")) {
            this.legalBasis = new CodeableConcept();
            return this.legalBasis;
        }
        if (name.equals("jurisdictionalAuthorization")) {
            return this.addJurisdictionalAuthorization();
        }
        if (name.equals(SP_HOLDER)) {
            this.holder = new Reference();
            return this.holder;
        }
        if (name.equals("regulator")) {
            this.regulator = new Reference();
            return this.regulator;
        }
        if (name.equals("procedure")) {
            this.procedure = new MedicinalProductAuthorizationProcedureComponent();
            return this.procedure;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicinalProductAuthorization";
    }

    @Override
    public MedicinalProductAuthorization copy() {
        MedicinalProductAuthorization dst = new MedicinalProductAuthorization();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
        if (this.country != null) {
            dst.country = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.country) {
                dst.country.add(codeableConcept.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.statusDate = this.statusDate == null ? null : this.statusDate.copy();
        dst.restoreDate = this.restoreDate == null ? null : this.restoreDate.copy();
        dst.validityPeriod = this.validityPeriod == null ? null : this.validityPeriod.copy();
        dst.dataExclusivityPeriod = this.dataExclusivityPeriod == null ? null : this.dataExclusivityPeriod.copy();
        dst.dateOfFirstAuthorization = this.dateOfFirstAuthorization == null ? null : this.dateOfFirstAuthorization.copy();
        dst.internationalBirthDate = this.internationalBirthDate == null ? null : this.internationalBirthDate.copy();
        CodeableConcept codeableConcept = dst.legalBasis = this.legalBasis == null ? null : this.legalBasis.copy();
        if (this.jurisdictionalAuthorization != null) {
            dst.jurisdictionalAuthorization = new ArrayList<MedicinalProductAuthorizationJurisdictionalAuthorizationComponent>();
            for (MedicinalProductAuthorizationJurisdictionalAuthorizationComponent medicinalProductAuthorizationJurisdictionalAuthorizationComponent : this.jurisdictionalAuthorization) {
                dst.jurisdictionalAuthorization.add(medicinalProductAuthorizationJurisdictionalAuthorizationComponent.copy());
            }
        }
        dst.holder = this.holder == null ? null : this.holder.copy();
        dst.regulator = this.regulator == null ? null : this.regulator.copy();
        dst.procedure = this.procedure == null ? null : this.procedure.copy();
        return dst;
    }

    protected MedicinalProductAuthorization typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductAuthorization)) {
            return false;
        }
        MedicinalProductAuthorization o = (MedicinalProductAuthorization)other_;
        return MedicinalProductAuthorization.compareDeep(this.identifier, o.identifier, true) && MedicinalProductAuthorization.compareDeep(this.subject, o.subject, true) && MedicinalProductAuthorization.compareDeep(this.country, o.country, true) && MedicinalProductAuthorization.compareDeep(this.jurisdiction, o.jurisdiction, true) && MedicinalProductAuthorization.compareDeep(this.status, o.status, true) && MedicinalProductAuthorization.compareDeep(this.statusDate, o.statusDate, true) && MedicinalProductAuthorization.compareDeep(this.restoreDate, o.restoreDate, true) && MedicinalProductAuthorization.compareDeep(this.validityPeriod, o.validityPeriod, true) && MedicinalProductAuthorization.compareDeep(this.dataExclusivityPeriod, o.dataExclusivityPeriod, true) && MedicinalProductAuthorization.compareDeep(this.dateOfFirstAuthorization, o.dateOfFirstAuthorization, true) && MedicinalProductAuthorization.compareDeep(this.internationalBirthDate, o.internationalBirthDate, true) && MedicinalProductAuthorization.compareDeep(this.legalBasis, o.legalBasis, true) && MedicinalProductAuthorization.compareDeep(this.jurisdictionalAuthorization, o.jurisdictionalAuthorization, true) && MedicinalProductAuthorization.compareDeep(this.holder, o.holder, true) && MedicinalProductAuthorization.compareDeep(this.regulator, o.regulator, true) && MedicinalProductAuthorization.compareDeep(this.procedure, o.procedure, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductAuthorization)) {
            return false;
        }
        MedicinalProductAuthorization o = (MedicinalProductAuthorization)other_;
        return MedicinalProductAuthorization.compareValues(this.statusDate, o.statusDate, true) && MedicinalProductAuthorization.compareValues(this.restoreDate, o.restoreDate, true) && MedicinalProductAuthorization.compareValues(this.dateOfFirstAuthorization, o.dateOfFirstAuthorization, true) && MedicinalProductAuthorization.compareValues(this.internationalBirthDate, o.internationalBirthDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.subject, this.country, this.jurisdiction, this.status, this.statusDate, this.restoreDate, this.validityPeriod, this.dataExclusivityPeriod, this.dateOfFirstAuthorization, this.internationalBirthDate, this.legalBasis, this.jurisdictionalAuthorization, this.holder, this.regulator, this.procedure});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicinalProductAuthorization;
    }

    @Block
    public static class MedicinalProductAuthorizationProcedureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier for this procedure", formalDefinition="Identifier for this procedure.")
        protected Identifier identifier;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of procedure", formalDefinition="Type of procedure.")
        protected CodeableConcept type;
        @Child(name="date", type={Period.class, DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Date of procedure", formalDefinition="Date of procedure.")
        protected Type date;
        @Child(name="application", type={MedicinalProductAuthorizationProcedureComponent.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Applcations submitted to obtain a marketing authorization", formalDefinition="Applcations submitted to obtain a marketing authorization.")
        protected List<MedicinalProductAuthorizationProcedureComponent> application;
        private static final long serialVersionUID = 930236001L;

        public MedicinalProductAuthorizationProcedureComponent() {
        }

        public MedicinalProductAuthorizationProcedureComponent(CodeableConcept type) {
            this.type = type;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductAuthorizationProcedureComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public MedicinalProductAuthorizationProcedureComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductAuthorizationProcedureComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicinalProductAuthorizationProcedureComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Type getDate() {
            return this.date;
        }

        public Period getDatePeriod() throws FHIRException {
            if (this.date == null) {
                this.date = new Period();
            }
            if (!(this.date instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.date.getClass().getName() + " was encountered");
            }
            return (Period)this.date;
        }

        public boolean hasDatePeriod() {
            return this != null && this.date instanceof Period;
        }

        public DateTimeType getDateDateTimeType() throws FHIRException {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            if (!(this.date instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.date.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.date;
        }

        public boolean hasDateDateTimeType() {
            return this != null && this.date instanceof DateTimeType;
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public MedicinalProductAuthorizationProcedureComponent setDate(Type value) {
            if (value != null && !(value instanceof Period) && !(value instanceof DateTimeType)) {
                throw new Error("Not the right type for MedicinalProductAuthorization.procedure.date[x]: " + value.fhirType());
            }
            this.date = value;
            return this;
        }

        public List<MedicinalProductAuthorizationProcedureComponent> getApplication() {
            if (this.application == null) {
                this.application = new ArrayList<MedicinalProductAuthorizationProcedureComponent>();
            }
            return this.application;
        }

        public MedicinalProductAuthorizationProcedureComponent setApplication(List<MedicinalProductAuthorizationProcedureComponent> theApplication) {
            this.application = theApplication;
            return this;
        }

        public boolean hasApplication() {
            if (this.application == null) {
                return false;
            }
            for (MedicinalProductAuthorizationProcedureComponent item : this.application) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MedicinalProductAuthorizationProcedureComponent addApplication() {
            MedicinalProductAuthorizationProcedureComponent t = new MedicinalProductAuthorizationProcedureComponent();
            if (this.application == null) {
                this.application = new ArrayList<MedicinalProductAuthorizationProcedureComponent>();
            }
            this.application.add(t);
            return t;
        }

        public MedicinalProductAuthorizationProcedureComponent addApplication(MedicinalProductAuthorizationProcedureComponent t) {
            if (t == null) {
                return this;
            }
            if (this.application == null) {
                this.application = new ArrayList<MedicinalProductAuthorizationProcedureComponent>();
            }
            this.application.add(t);
            return this;
        }

        public MedicinalProductAuthorizationProcedureComponent getApplicationFirstRep() {
            if (this.getApplication().isEmpty()) {
                this.addApplication();
            }
            return this.getApplication().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(MedicinalProductAuthorization.SP_IDENTIFIER, "Identifier", "Identifier for this procedure.", 0, 1, this.identifier));
            children.add(new Property("type", "CodeableConcept", "Type of procedure.", 0, 1, this.type));
            children.add(new Property("date[x]", "Period|dateTime", "Date of procedure.", 0, 1, this.date));
            children.add(new Property("application", "@MedicinalProductAuthorization.procedure", "Applcations submitted to obtain a marketing authorization.", 0, Integer.MAX_VALUE, this.application));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(MedicinalProductAuthorization.SP_IDENTIFIER, "Identifier", "Identifier for this procedure.", 0, 1, this.identifier);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of procedure.", 0, 1, this.type);
                }
                case 1443311122: {
                    return new Property("date[x]", "Period|dateTime", "Date of procedure.", 0, 1, this.date);
                }
                case 3076014: {
                    return new Property("date[x]", "Period|dateTime", "Date of procedure.", 0, 1, this.date);
                }
                case 432297743: {
                    return new Property("date[x]", "Period|dateTime", "Date of procedure.", 0, 1, this.date);
                }
                case 185136489: {
                    return new Property("date[x]", "Period|dateTime", "Date of procedure.", 0, 1, this.date);
                }
                case 1554253136: {
                    return new Property("application", "@MedicinalProductAuthorization.procedure", "Applcations submitted to obtain a marketing authorization.", 0, Integer.MAX_VALUE, this.application);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.date;
                    }
                    return baseArray;
                }
                case 1554253136: {
                    return this.application == null ? new Base[]{} : this.application.toArray(new Base[this.application.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    return value;
                }
                case 3575610: {
                    this.type = this.castToCodeableConcept(value);
                    return value;
                }
                case 3076014: {
                    this.date = this.castToType(value);
                    return value;
                }
                case 1554253136: {
                    this.getApplication().add((MedicinalProductAuthorizationProcedureComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(MedicinalProductAuthorization.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("date[x]")) {
                this.date = this.castToType(value);
            } else if (name.equals("application")) {
                this.getApplication().add((MedicinalProductAuthorizationProcedureComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 3575610: {
                    return this.getType();
                }
                case 1443311122: {
                    return this.getDate();
                }
                case 3076014: {
                    return this.getDate();
                }
                case 1554253136: {
                    return this.addApplication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3076014: {
                    return new String[]{"Period", "dateTime"};
                }
                case 1554253136: {
                    return new String[]{"@MedicinalProductAuthorization.procedure"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(MedicinalProductAuthorization.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("datePeriod")) {
                this.date = new Period();
                return this.date;
            }
            if (name.equals("dateDateTime")) {
                this.date = new DateTimeType();
                return this.date;
            }
            if (name.equals("application")) {
                return this.addApplication();
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductAuthorizationProcedureComponent copy() {
            MedicinalProductAuthorizationProcedureComponent dst = new MedicinalProductAuthorizationProcedureComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.type = this.type == null ? null : this.type.copy();
            Type type = dst.date = this.date == null ? null : this.date.copy();
            if (this.application != null) {
                dst.application = new ArrayList<MedicinalProductAuthorizationProcedureComponent>();
                for (MedicinalProductAuthorizationProcedureComponent i : this.application) {
                    dst.application.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductAuthorizationProcedureComponent)) {
                return false;
            }
            MedicinalProductAuthorizationProcedureComponent o = (MedicinalProductAuthorizationProcedureComponent)other_;
            return MedicinalProductAuthorizationProcedureComponent.compareDeep(this.identifier, o.identifier, true) && MedicinalProductAuthorizationProcedureComponent.compareDeep(this.type, o.type, true) && MedicinalProductAuthorizationProcedureComponent.compareDeep(this.date, o.date, true) && MedicinalProductAuthorizationProcedureComponent.compareDeep(this.application, o.application, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductAuthorizationProcedureComponent)) {
                return false;
            }
            MedicinalProductAuthorizationProcedureComponent o = (MedicinalProductAuthorizationProcedureComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.date, this.application});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductAuthorization.procedure";
        }
    }

    @Block
    public static class MedicinalProductAuthorizationJurisdictionalAuthorizationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The assigned number for the marketing authorization", formalDefinition="The assigned number for the marketing authorization.")
        protected List<Identifier> identifier;
        @Child(name="country", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Country of authorization", formalDefinition="Country of authorization.")
        protected CodeableConcept country;
        @Child(name="jurisdiction", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Jurisdiction within a country", formalDefinition="Jurisdiction within a country.")
        protected List<CodeableConcept> jurisdiction;
        @Child(name="legalStatusOfSupply", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The legal status of supply in a jurisdiction or region", formalDefinition="The legal status of supply in a jurisdiction or region.")
        protected CodeableConcept legalStatusOfSupply;
        @Child(name="validityPeriod", type={Period.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The start and expected end date of the authorization", formalDefinition="The start and expected end date of the authorization.")
        protected Period validityPeriod;
        private static final long serialVersionUID = -1893307291L;

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public MedicinalProductAuthorizationJurisdictionalAuthorizationComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public MedicinalProductAuthorizationJurisdictionalAuthorizationComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public CodeableConcept getCountry() {
            if (this.country == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductAuthorizationJurisdictionalAuthorizationComponent.country");
                }
                if (Configuration.doAutoCreate()) {
                    this.country = new CodeableConcept();
                }
            }
            return this.country;
        }

        public boolean hasCountry() {
            return this.country != null && !this.country.isEmpty();
        }

        public MedicinalProductAuthorizationJurisdictionalAuthorizationComponent setCountry(CodeableConcept value) {
            this.country = value;
            return this;
        }

        public List<CodeableConcept> getJurisdiction() {
            if (this.jurisdiction == null) {
                this.jurisdiction = new ArrayList<CodeableConcept>();
            }
            return this.jurisdiction;
        }

        public MedicinalProductAuthorizationJurisdictionalAuthorizationComponent setJurisdiction(List<CodeableConcept> theJurisdiction) {
            this.jurisdiction = theJurisdiction;
            return this;
        }

        public boolean hasJurisdiction() {
            if (this.jurisdiction == null) {
                return false;
            }
            for (CodeableConcept item : this.jurisdiction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addJurisdiction() {
            CodeableConcept t = new CodeableConcept();
            if (this.jurisdiction == null) {
                this.jurisdiction = new ArrayList<CodeableConcept>();
            }
            this.jurisdiction.add(t);
            return t;
        }

        public MedicinalProductAuthorizationJurisdictionalAuthorizationComponent addJurisdiction(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.jurisdiction == null) {
                this.jurisdiction = new ArrayList<CodeableConcept>();
            }
            this.jurisdiction.add(t);
            return this;
        }

        public CodeableConcept getJurisdictionFirstRep() {
            if (this.getJurisdiction().isEmpty()) {
                this.addJurisdiction();
            }
            return this.getJurisdiction().get(0);
        }

        public CodeableConcept getLegalStatusOfSupply() {
            if (this.legalStatusOfSupply == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductAuthorizationJurisdictionalAuthorizationComponent.legalStatusOfSupply");
                }
                if (Configuration.doAutoCreate()) {
                    this.legalStatusOfSupply = new CodeableConcept();
                }
            }
            return this.legalStatusOfSupply;
        }

        public boolean hasLegalStatusOfSupply() {
            return this.legalStatusOfSupply != null && !this.legalStatusOfSupply.isEmpty();
        }

        public MedicinalProductAuthorizationJurisdictionalAuthorizationComponent setLegalStatusOfSupply(CodeableConcept value) {
            this.legalStatusOfSupply = value;
            return this;
        }

        public Period getValidityPeriod() {
            if (this.validityPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductAuthorizationJurisdictionalAuthorizationComponent.validityPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.validityPeriod = new Period();
                }
            }
            return this.validityPeriod;
        }

        public boolean hasValidityPeriod() {
            return this.validityPeriod != null && !this.validityPeriod.isEmpty();
        }

        public MedicinalProductAuthorizationJurisdictionalAuthorizationComponent setValidityPeriod(Period value) {
            this.validityPeriod = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(MedicinalProductAuthorization.SP_IDENTIFIER, "Identifier", "The assigned number for the marketing authorization.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property(MedicinalProductAuthorization.SP_COUNTRY, "CodeableConcept", "Country of authorization.", 0, 1, this.country));
            children.add(new Property("jurisdiction", "CodeableConcept", "Jurisdiction within a country.", 0, Integer.MAX_VALUE, this.jurisdiction));
            children.add(new Property("legalStatusOfSupply", "CodeableConcept", "The legal status of supply in a jurisdiction or region.", 0, 1, this.legalStatusOfSupply));
            children.add(new Property("validityPeriod", "Period", "The start and expected end date of the authorization.", 0, 1, this.validityPeriod));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(MedicinalProductAuthorization.SP_IDENTIFIER, "Identifier", "The assigned number for the marketing authorization.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case 957831062: {
                    return new Property(MedicinalProductAuthorization.SP_COUNTRY, "CodeableConcept", "Country of authorization.", 0, 1, this.country);
                }
                case -507075711: {
                    return new Property("jurisdiction", "CodeableConcept", "Jurisdiction within a country.", 0, Integer.MAX_VALUE, this.jurisdiction);
                }
                case -844874031: {
                    return new Property("legalStatusOfSupply", "CodeableConcept", "The legal status of supply in a jurisdiction or region.", 0, 1, this.legalStatusOfSupply);
                }
                case -1434195053: {
                    return new Property("validityPeriod", "Period", "The start and expected end date of the authorization.", 0, 1, this.validityPeriod);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case 957831062: {
                    Base[] baseArray;
                    if (this.country == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.country;
                    }
                    return baseArray;
                }
                case -507075711: {
                    return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
                }
                case -844874031: {
                    Base[] baseArray;
                    if (this.legalStatusOfSupply == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.legalStatusOfSupply;
                    }
                    return baseArray;
                }
                case -1434195053: {
                    Base[] baseArray;
                    if (this.validityPeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.validityPeriod;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(this.castToIdentifier(value));
                    return value;
                }
                case 957831062: {
                    this.country = this.castToCodeableConcept(value);
                    return value;
                }
                case -507075711: {
                    this.getJurisdiction().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -844874031: {
                    this.legalStatusOfSupply = this.castToCodeableConcept(value);
                    return value;
                }
                case -1434195053: {
                    this.validityPeriod = this.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(MedicinalProductAuthorization.SP_IDENTIFIER)) {
                this.getIdentifier().add(this.castToIdentifier(value));
            } else if (name.equals(MedicinalProductAuthorization.SP_COUNTRY)) {
                this.country = this.castToCodeableConcept(value);
            } else if (name.equals("jurisdiction")) {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
            } else if (name.equals("legalStatusOfSupply")) {
                this.legalStatusOfSupply = this.castToCodeableConcept(value);
            } else if (name.equals("validityPeriod")) {
                this.validityPeriod = this.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case 957831062: {
                    return this.getCountry();
                }
                case -507075711: {
                    return this.addJurisdiction();
                }
                case -844874031: {
                    return this.getLegalStatusOfSupply();
                }
                case -1434195053: {
                    return this.getValidityPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 957831062: {
                    return new String[]{"CodeableConcept"};
                }
                case -507075711: {
                    return new String[]{"CodeableConcept"};
                }
                case -844874031: {
                    return new String[]{"CodeableConcept"};
                }
                case -1434195053: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(MedicinalProductAuthorization.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals(MedicinalProductAuthorization.SP_COUNTRY)) {
                this.country = new CodeableConcept();
                return this.country;
            }
            if (name.equals("jurisdiction")) {
                return this.addJurisdiction();
            }
            if (name.equals("legalStatusOfSupply")) {
                this.legalStatusOfSupply = new CodeableConcept();
                return this.legalStatusOfSupply;
            }
            if (name.equals("validityPeriod")) {
                this.validityPeriod = new Period();
                return this.validityPeriod;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductAuthorizationJurisdictionalAuthorizationComponent copy() {
            MedicinalProductAuthorizationJurisdictionalAuthorizationComponent dst = new MedicinalProductAuthorizationJurisdictionalAuthorizationComponent();
            this.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            CodeableConcept codeableConcept = dst.country = this.country == null ? null : this.country.copy();
            if (this.jurisdiction != null) {
                dst.jurisdiction = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.jurisdiction) {
                    dst.jurisdiction.add(codeableConcept2.copy());
                }
            }
            dst.legalStatusOfSupply = this.legalStatusOfSupply == null ? null : this.legalStatusOfSupply.copy();
            dst.validityPeriod = this.validityPeriod == null ? null : this.validityPeriod.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductAuthorizationJurisdictionalAuthorizationComponent)) {
                return false;
            }
            MedicinalProductAuthorizationJurisdictionalAuthorizationComponent o = (MedicinalProductAuthorizationJurisdictionalAuthorizationComponent)other_;
            return MedicinalProductAuthorizationJurisdictionalAuthorizationComponent.compareDeep(this.identifier, o.identifier, true) && MedicinalProductAuthorizationJurisdictionalAuthorizationComponent.compareDeep(this.country, o.country, true) && MedicinalProductAuthorizationJurisdictionalAuthorizationComponent.compareDeep(this.jurisdiction, o.jurisdiction, true) && MedicinalProductAuthorizationJurisdictionalAuthorizationComponent.compareDeep(this.legalStatusOfSupply, o.legalStatusOfSupply, true) && MedicinalProductAuthorizationJurisdictionalAuthorizationComponent.compareDeep(this.validityPeriod, o.validityPeriod, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductAuthorizationJurisdictionalAuthorizationComponent)) {
                return false;
            }
            MedicinalProductAuthorizationJurisdictionalAuthorizationComponent o = (MedicinalProductAuthorizationJurisdictionalAuthorizationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.country, this.jurisdiction, this.legalStatusOfSupply, this.validityPeriod});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductAuthorization.jurisdictionalAuthorization";
        }
    }
}

