/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicinalProduct;
import org.hl7.fhir.r5.model.MedicinalProductUndesirableEffect;
import org.hl7.fhir.r5.model.Population;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceSpecification;
import org.hl7.fhir.r5.model.Type;

@ResourceDef(name="MedicinalProductIndication", profile="http://hl7.org/fhir/StructureDefinition/MedicinalProductIndication")
public class MedicinalProductIndication
extends DomainResource {
    @Child(name="subject", type={MedicinalProduct.class, Medication.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The medication for which this is an indication", formalDefinition="The medication for which this is an indication.")
    protected List<Reference> subject;
    protected List<Resource> subjectTarget;
    @Child(name="diseaseSymptomProcedure", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The disease, symptom or procedure that is the indication for treatment", formalDefinition="The disease, symptom or procedure that is the indication for treatment.")
    protected CodeableConcept diseaseSymptomProcedure;
    @Child(name="diseaseStatus", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The status of the disease or symptom for which the indication applies", formalDefinition="The status of the disease or symptom for which the indication applies.")
    protected CodeableConcept diseaseStatus;
    @Child(name="comorbidity", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Comorbidity (concurrent condition) or co-infection as part of the indication", formalDefinition="Comorbidity (concurrent condition) or co-infection as part of the indication.")
    protected List<CodeableConcept> comorbidity;
    @Child(name="intendedEffect", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The intended effect, aim or strategy to be achieved by the indication", formalDefinition="The intended effect, aim or strategy to be achieved by the indication.")
    protected CodeableConcept intendedEffect;
    @Child(name="duration", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Timing or duration information as part of the indication", formalDefinition="Timing or duration information as part of the indication.")
    protected Quantity duration;
    @Child(name="otherTherapy", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Information about the use of the medicinal product in relation to other therapies described as part of the indication", formalDefinition="Information about the use of the medicinal product in relation to other therapies described as part of the indication.")
    protected List<MedicinalProductIndicationOtherTherapyComponent> otherTherapy;
    @Child(name="undesirableEffect", type={MedicinalProductUndesirableEffect.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Describe the undesirable effects of the medicinal product", formalDefinition="Describe the undesirable effects of the medicinal product.")
    protected List<Reference> undesirableEffect;
    protected List<MedicinalProductUndesirableEffect> undesirableEffectTarget;
    @Child(name="population", type={Population.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The population group to which this applies", formalDefinition="The population group to which this applies.")
    protected List<Population> population;
    private static final long serialVersionUID = 1205519664L;
    @SearchParamDefinition(name="subject", path="MedicinalProductIndication.subject", description="The medication for which this is an indication", type="reference", target={Medication.class, MedicinalProduct.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("MedicinalProductIndication:subject").toLocked();

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public MedicinalProductIndication setSubject(List<Reference> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public MedicinalProductIndication addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public Reference getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    @Deprecated
    public List<Resource> getSubjectTarget() {
        if (this.subjectTarget == null) {
            this.subjectTarget = new ArrayList<Resource>();
        }
        return this.subjectTarget;
    }

    public CodeableConcept getDiseaseSymptomProcedure() {
        if (this.diseaseSymptomProcedure == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductIndication.diseaseSymptomProcedure");
            }
            if (Configuration.doAutoCreate()) {
                this.diseaseSymptomProcedure = new CodeableConcept();
            }
        }
        return this.diseaseSymptomProcedure;
    }

    public boolean hasDiseaseSymptomProcedure() {
        return this.diseaseSymptomProcedure != null && !this.diseaseSymptomProcedure.isEmpty();
    }

    public MedicinalProductIndication setDiseaseSymptomProcedure(CodeableConcept value) {
        this.diseaseSymptomProcedure = value;
        return this;
    }

    public CodeableConcept getDiseaseStatus() {
        if (this.diseaseStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductIndication.diseaseStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.diseaseStatus = new CodeableConcept();
            }
        }
        return this.diseaseStatus;
    }

    public boolean hasDiseaseStatus() {
        return this.diseaseStatus != null && !this.diseaseStatus.isEmpty();
    }

    public MedicinalProductIndication setDiseaseStatus(CodeableConcept value) {
        this.diseaseStatus = value;
        return this;
    }

    public List<CodeableConcept> getComorbidity() {
        if (this.comorbidity == null) {
            this.comorbidity = new ArrayList<CodeableConcept>();
        }
        return this.comorbidity;
    }

    public MedicinalProductIndication setComorbidity(List<CodeableConcept> theComorbidity) {
        this.comorbidity = theComorbidity;
        return this;
    }

    public boolean hasComorbidity() {
        if (this.comorbidity == null) {
            return false;
        }
        for (CodeableConcept item : this.comorbidity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addComorbidity() {
        CodeableConcept t = new CodeableConcept();
        if (this.comorbidity == null) {
            this.comorbidity = new ArrayList<CodeableConcept>();
        }
        this.comorbidity.add(t);
        return t;
    }

    public MedicinalProductIndication addComorbidity(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.comorbidity == null) {
            this.comorbidity = new ArrayList<CodeableConcept>();
        }
        this.comorbidity.add(t);
        return this;
    }

    public CodeableConcept getComorbidityFirstRep() {
        if (this.getComorbidity().isEmpty()) {
            this.addComorbidity();
        }
        return this.getComorbidity().get(0);
    }

    public CodeableConcept getIntendedEffect() {
        if (this.intendedEffect == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductIndication.intendedEffect");
            }
            if (Configuration.doAutoCreate()) {
                this.intendedEffect = new CodeableConcept();
            }
        }
        return this.intendedEffect;
    }

    public boolean hasIntendedEffect() {
        return this.intendedEffect != null && !this.intendedEffect.isEmpty();
    }

    public MedicinalProductIndication setIntendedEffect(CodeableConcept value) {
        this.intendedEffect = value;
        return this;
    }

    public Quantity getDuration() {
        if (this.duration == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductIndication.duration");
            }
            if (Configuration.doAutoCreate()) {
                this.duration = new Quantity();
            }
        }
        return this.duration;
    }

    public boolean hasDuration() {
        return this.duration != null && !this.duration.isEmpty();
    }

    public MedicinalProductIndication setDuration(Quantity value) {
        this.duration = value;
        return this;
    }

    public List<MedicinalProductIndicationOtherTherapyComponent> getOtherTherapy() {
        if (this.otherTherapy == null) {
            this.otherTherapy = new ArrayList<MedicinalProductIndicationOtherTherapyComponent>();
        }
        return this.otherTherapy;
    }

    public MedicinalProductIndication setOtherTherapy(List<MedicinalProductIndicationOtherTherapyComponent> theOtherTherapy) {
        this.otherTherapy = theOtherTherapy;
        return this;
    }

    public boolean hasOtherTherapy() {
        if (this.otherTherapy == null) {
            return false;
        }
        for (MedicinalProductIndicationOtherTherapyComponent item : this.otherTherapy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductIndicationOtherTherapyComponent addOtherTherapy() {
        MedicinalProductIndicationOtherTherapyComponent t = new MedicinalProductIndicationOtherTherapyComponent();
        if (this.otherTherapy == null) {
            this.otherTherapy = new ArrayList<MedicinalProductIndicationOtherTherapyComponent>();
        }
        this.otherTherapy.add(t);
        return t;
    }

    public MedicinalProductIndication addOtherTherapy(MedicinalProductIndicationOtherTherapyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.otherTherapy == null) {
            this.otherTherapy = new ArrayList<MedicinalProductIndicationOtherTherapyComponent>();
        }
        this.otherTherapy.add(t);
        return this;
    }

    public MedicinalProductIndicationOtherTherapyComponent getOtherTherapyFirstRep() {
        if (this.getOtherTherapy().isEmpty()) {
            this.addOtherTherapy();
        }
        return this.getOtherTherapy().get(0);
    }

    public List<Reference> getUndesirableEffect() {
        if (this.undesirableEffect == null) {
            this.undesirableEffect = new ArrayList<Reference>();
        }
        return this.undesirableEffect;
    }

    public MedicinalProductIndication setUndesirableEffect(List<Reference> theUndesirableEffect) {
        this.undesirableEffect = theUndesirableEffect;
        return this;
    }

    public boolean hasUndesirableEffect() {
        if (this.undesirableEffect == null) {
            return false;
        }
        for (Reference item : this.undesirableEffect) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addUndesirableEffect() {
        Reference t = new Reference();
        if (this.undesirableEffect == null) {
            this.undesirableEffect = new ArrayList<Reference>();
        }
        this.undesirableEffect.add(t);
        return t;
    }

    public MedicinalProductIndication addUndesirableEffect(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.undesirableEffect == null) {
            this.undesirableEffect = new ArrayList<Reference>();
        }
        this.undesirableEffect.add(t);
        return this;
    }

    public Reference getUndesirableEffectFirstRep() {
        if (this.getUndesirableEffect().isEmpty()) {
            this.addUndesirableEffect();
        }
        return this.getUndesirableEffect().get(0);
    }

    @Deprecated
    public List<MedicinalProductUndesirableEffect> getUndesirableEffectTarget() {
        if (this.undesirableEffectTarget == null) {
            this.undesirableEffectTarget = new ArrayList<MedicinalProductUndesirableEffect>();
        }
        return this.undesirableEffectTarget;
    }

    @Deprecated
    public MedicinalProductUndesirableEffect addUndesirableEffectTarget() {
        MedicinalProductUndesirableEffect r = new MedicinalProductUndesirableEffect();
        if (this.undesirableEffectTarget == null) {
            this.undesirableEffectTarget = new ArrayList<MedicinalProductUndesirableEffect>();
        }
        this.undesirableEffectTarget.add(r);
        return r;
    }

    public List<Population> getPopulation() {
        if (this.population == null) {
            this.population = new ArrayList<Population>();
        }
        return this.population;
    }

    public MedicinalProductIndication setPopulation(List<Population> thePopulation) {
        this.population = thePopulation;
        return this;
    }

    public boolean hasPopulation() {
        if (this.population == null) {
            return false;
        }
        for (Population item : this.population) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Population addPopulation() {
        Population t = new Population();
        if (this.population == null) {
            this.population = new ArrayList<Population>();
        }
        this.population.add(t);
        return t;
    }

    public MedicinalProductIndication addPopulation(Population t) {
        if (t == null) {
            return this;
        }
        if (this.population == null) {
            this.population = new ArrayList<Population>();
        }
        this.population.add(t);
        return this;
    }

    public Population getPopulationFirstRep() {
        if (this.getPopulation().isEmpty()) {
            this.addPopulation();
        }
        return this.getPopulation().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_SUBJECT, "Reference(MedicinalProduct|Medication)", "The medication for which this is an indication.", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property("diseaseSymptomProcedure", "CodeableConcept", "The disease, symptom or procedure that is the indication for treatment.", 0, 1, this.diseaseSymptomProcedure));
        children.add(new Property("diseaseStatus", "CodeableConcept", "The status of the disease or symptom for which the indication applies.", 0, 1, this.diseaseStatus));
        children.add(new Property("comorbidity", "CodeableConcept", "Comorbidity (concurrent condition) or co-infection as part of the indication.", 0, Integer.MAX_VALUE, this.comorbidity));
        children.add(new Property("intendedEffect", "CodeableConcept", "The intended effect, aim or strategy to be achieved by the indication.", 0, 1, this.intendedEffect));
        children.add(new Property("duration", "Quantity", "Timing or duration information as part of the indication.", 0, 1, this.duration));
        children.add(new Property("otherTherapy", "", "Information about the use of the medicinal product in relation to other therapies described as part of the indication.", 0, Integer.MAX_VALUE, this.otherTherapy));
        children.add(new Property("undesirableEffect", "Reference(MedicinalProductUndesirableEffect)", "Describe the undesirable effects of the medicinal product.", 0, Integer.MAX_VALUE, this.undesirableEffect));
        children.add(new Property("population", "Population", "The population group to which this applies.", 0, Integer.MAX_VALUE, this.population));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(MedicinalProduct|Medication)", "The medication for which this is an indication.", 0, Integer.MAX_VALUE, this.subject);
            }
            case -1497395130: {
                return new Property("diseaseSymptomProcedure", "CodeableConcept", "The disease, symptom or procedure that is the indication for treatment.", 0, 1, this.diseaseSymptomProcedure);
            }
            case -505503602: {
                return new Property("diseaseStatus", "CodeableConcept", "The status of the disease or symptom for which the indication applies.", 0, 1, this.diseaseStatus);
            }
            case -406395211: {
                return new Property("comorbidity", "CodeableConcept", "Comorbidity (concurrent condition) or co-infection as part of the indication.", 0, Integer.MAX_VALUE, this.comorbidity);
            }
            case 1587112348: {
                return new Property("intendedEffect", "CodeableConcept", "The intended effect, aim or strategy to be achieved by the indication.", 0, 1, this.intendedEffect);
            }
            case -1992012396: {
                return new Property("duration", "Quantity", "Timing or duration information as part of the indication.", 0, 1, this.duration);
            }
            case -544509127: {
                return new Property("otherTherapy", "", "Information about the use of the medicinal product in relation to other therapies described as part of the indication.", 0, Integer.MAX_VALUE, this.otherTherapy);
            }
            case 444367565: {
                return new Property("undesirableEffect", "Reference(MedicinalProductUndesirableEffect)", "Describe the undesirable effects of the medicinal product.", 0, Integer.MAX_VALUE, this.undesirableEffect);
            }
            case -2023558323: {
                return new Property("population", "Population", "The population group to which this applies.", 0, Integer.MAX_VALUE, this.population);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case -1497395130: {
                Base[] baseArray;
                if (this.diseaseSymptomProcedure == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.diseaseSymptomProcedure;
                }
                return baseArray;
            }
            case -505503602: {
                Base[] baseArray;
                if (this.diseaseStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.diseaseStatus;
                }
                return baseArray;
            }
            case -406395211: {
                return this.comorbidity == null ? new Base[]{} : this.comorbidity.toArray(new Base[this.comorbidity.size()]);
            }
            case 1587112348: {
                Base[] baseArray;
                if (this.intendedEffect == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.intendedEffect;
                }
                return baseArray;
            }
            case -1992012396: {
                Base[] baseArray;
                if (this.duration == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.duration;
                }
                return baseArray;
            }
            case -544509127: {
                return this.otherTherapy == null ? new Base[]{} : this.otherTherapy.toArray(new Base[this.otherTherapy.size()]);
            }
            case 444367565: {
                return this.undesirableEffect == null ? new Base[]{} : this.undesirableEffect.toArray(new Base[this.undesirableEffect.size()]);
            }
            case -2023558323: {
                return this.population == null ? new Base[]{} : this.population.toArray(new Base[this.population.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                this.getSubject().add(this.castToReference(value));
                return value;
            }
            case -1497395130: {
                this.diseaseSymptomProcedure = this.castToCodeableConcept(value);
                return value;
            }
            case -505503602: {
                this.diseaseStatus = this.castToCodeableConcept(value);
                return value;
            }
            case -406395211: {
                this.getComorbidity().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1587112348: {
                this.intendedEffect = this.castToCodeableConcept(value);
                return value;
            }
            case -1992012396: {
                this.duration = this.castToQuantity(value);
                return value;
            }
            case -544509127: {
                this.getOtherTherapy().add((MedicinalProductIndicationOtherTherapyComponent)value);
                return value;
            }
            case 444367565: {
                this.getUndesirableEffect().add(this.castToReference(value));
                return value;
            }
            case -2023558323: {
                this.getPopulation().add(this.castToPopulation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(this.castToReference(value));
        } else if (name.equals("diseaseSymptomProcedure")) {
            this.diseaseSymptomProcedure = this.castToCodeableConcept(value);
        } else if (name.equals("diseaseStatus")) {
            this.diseaseStatus = this.castToCodeableConcept(value);
        } else if (name.equals("comorbidity")) {
            this.getComorbidity().add(this.castToCodeableConcept(value));
        } else if (name.equals("intendedEffect")) {
            this.intendedEffect = this.castToCodeableConcept(value);
        } else if (name.equals("duration")) {
            this.duration = this.castToQuantity(value);
        } else if (name.equals("otherTherapy")) {
            this.getOtherTherapy().add((MedicinalProductIndicationOtherTherapyComponent)value);
        } else if (name.equals("undesirableEffect")) {
            this.getUndesirableEffect().add(this.castToReference(value));
        } else if (name.equals("population")) {
            this.getPopulation().add(this.castToPopulation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                return this.addSubject();
            }
            case -1497395130: {
                return this.getDiseaseSymptomProcedure();
            }
            case -505503602: {
                return this.getDiseaseStatus();
            }
            case -406395211: {
                return this.addComorbidity();
            }
            case 1587112348: {
                return this.getIntendedEffect();
            }
            case -1992012396: {
                return this.getDuration();
            }
            case -544509127: {
                return this.addOtherTherapy();
            }
            case 444367565: {
                return this.addUndesirableEffect();
            }
            case -2023558323: {
                return this.addPopulation();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -1497395130: {
                return new String[]{"CodeableConcept"};
            }
            case -505503602: {
                return new String[]{"CodeableConcept"};
            }
            case -406395211: {
                return new String[]{"CodeableConcept"};
            }
            case 1587112348: {
                return new String[]{"CodeableConcept"};
            }
            case -1992012396: {
                return new String[]{"Quantity"};
            }
            case -544509127: {
                return new String[0];
            }
            case 444367565: {
                return new String[]{"Reference"};
            }
            case -2023558323: {
                return new String[]{"Population"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals("diseaseSymptomProcedure")) {
            this.diseaseSymptomProcedure = new CodeableConcept();
            return this.diseaseSymptomProcedure;
        }
        if (name.equals("diseaseStatus")) {
            this.diseaseStatus = new CodeableConcept();
            return this.diseaseStatus;
        }
        if (name.equals("comorbidity")) {
            return this.addComorbidity();
        }
        if (name.equals("intendedEffect")) {
            this.intendedEffect = new CodeableConcept();
            return this.intendedEffect;
        }
        if (name.equals("duration")) {
            this.duration = new Quantity();
            return this.duration;
        }
        if (name.equals("otherTherapy")) {
            return this.addOtherTherapy();
        }
        if (name.equals("undesirableEffect")) {
            return this.addUndesirableEffect();
        }
        if (name.equals("population")) {
            return this.addPopulation();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicinalProductIndication";
    }

    @Override
    public MedicinalProductIndication copy() {
        MedicinalProductIndication dst = new MedicinalProductIndication();
        this.copyValues(dst);
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        dst.diseaseSymptomProcedure = this.diseaseSymptomProcedure == null ? null : this.diseaseSymptomProcedure.copy();
        CodeableConcept codeableConcept = dst.diseaseStatus = this.diseaseStatus == null ? null : this.diseaseStatus.copy();
        if (this.comorbidity != null) {
            dst.comorbidity = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.comorbidity) {
                dst.comorbidity.add(codeableConcept2.copy());
            }
        }
        dst.intendedEffect = this.intendedEffect == null ? null : this.intendedEffect.copy();
        Quantity quantity = dst.duration = this.duration == null ? null : this.duration.copy();
        if (this.otherTherapy != null) {
            dst.otherTherapy = new ArrayList<MedicinalProductIndicationOtherTherapyComponent>();
            for (MedicinalProductIndicationOtherTherapyComponent medicinalProductIndicationOtherTherapyComponent : this.otherTherapy) {
                dst.otherTherapy.add(medicinalProductIndicationOtherTherapyComponent.copy());
            }
        }
        if (this.undesirableEffect != null) {
            dst.undesirableEffect = new ArrayList<Reference>();
            for (Reference reference : this.undesirableEffect) {
                dst.undesirableEffect.add(reference.copy());
            }
        }
        if (this.population != null) {
            dst.population = new ArrayList<Population>();
            for (Population population : this.population) {
                dst.population.add(population.copy());
            }
        }
        return dst;
    }

    protected MedicinalProductIndication typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductIndication)) {
            return false;
        }
        MedicinalProductIndication o = (MedicinalProductIndication)other_;
        return MedicinalProductIndication.compareDeep(this.subject, o.subject, true) && MedicinalProductIndication.compareDeep(this.diseaseSymptomProcedure, o.diseaseSymptomProcedure, true) && MedicinalProductIndication.compareDeep(this.diseaseStatus, o.diseaseStatus, true) && MedicinalProductIndication.compareDeep(this.comorbidity, o.comorbidity, true) && MedicinalProductIndication.compareDeep(this.intendedEffect, o.intendedEffect, true) && MedicinalProductIndication.compareDeep(this.duration, o.duration, true) && MedicinalProductIndication.compareDeep(this.otherTherapy, o.otherTherapy, true) && MedicinalProductIndication.compareDeep(this.undesirableEffect, o.undesirableEffect, true) && MedicinalProductIndication.compareDeep(this.population, o.population, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductIndication)) {
            return false;
        }
        MedicinalProductIndication o = (MedicinalProductIndication)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.subject, this.diseaseSymptomProcedure, this.diseaseStatus, this.comorbidity, this.intendedEffect, this.duration, this.otherTherapy, this.undesirableEffect, this.population});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicinalProductIndication;
    }

    @Block
    public static class MedicinalProductIndicationOtherTherapyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="therapyRelationshipType", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of relationship between the medicinal product indication or contraindication and another therapy", formalDefinition="The type of relationship between the medicinal product indication or contraindication and another therapy.")
        protected CodeableConcept therapyRelationshipType;
        @Child(name="medication", type={CodeableConcept.class, MedicinalProduct.class, Medication.class, Substance.class, SubstanceSpecification.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication", formalDefinition="Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.")
        protected Type medication;
        private static final long serialVersionUID = 1438478115L;

        public MedicinalProductIndicationOtherTherapyComponent() {
        }

        public MedicinalProductIndicationOtherTherapyComponent(CodeableConcept therapyRelationshipType, Type medication) {
            this.therapyRelationshipType = therapyRelationshipType;
            this.medication = medication;
        }

        public CodeableConcept getTherapyRelationshipType() {
            if (this.therapyRelationshipType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductIndicationOtherTherapyComponent.therapyRelationshipType");
                }
                if (Configuration.doAutoCreate()) {
                    this.therapyRelationshipType = new CodeableConcept();
                }
            }
            return this.therapyRelationshipType;
        }

        public boolean hasTherapyRelationshipType() {
            return this.therapyRelationshipType != null && !this.therapyRelationshipType.isEmpty();
        }

        public MedicinalProductIndicationOtherTherapyComponent setTherapyRelationshipType(CodeableConcept value) {
            this.therapyRelationshipType = value;
            return this;
        }

        public Type getMedication() {
            return this.medication;
        }

        public CodeableConcept getMedicationCodeableConcept() throws FHIRException {
            if (this.medication == null) {
                this.medication = new CodeableConcept();
            }
            if (!(this.medication instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.medication.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.medication;
        }

        public boolean hasMedicationCodeableConcept() {
            return this != null && this.medication instanceof CodeableConcept;
        }

        public Reference getMedicationReference() throws FHIRException {
            if (this.medication == null) {
                this.medication = new Reference();
            }
            if (!(this.medication instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.medication.getClass().getName() + " was encountered");
            }
            return (Reference)this.medication;
        }

        public boolean hasMedicationReference() {
            return this != null && this.medication instanceof Reference;
        }

        public boolean hasMedication() {
            return this.medication != null && !this.medication.isEmpty();
        }

        public MedicinalProductIndicationOtherTherapyComponent setMedication(Type value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for MedicinalProductIndication.otherTherapy.medication[x]: " + value.fhirType());
            }
            this.medication = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("therapyRelationshipType", "CodeableConcept", "The type of relationship between the medicinal product indication or contraindication and another therapy.", 0, 1, this.therapyRelationshipType));
            children.add(new Property("medication[x]", "CodeableConcept|Reference(MedicinalProduct|Medication|Substance|SubstanceSpecification)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.medication));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -551658469: {
                    return new Property("therapyRelationshipType", "CodeableConcept", "The type of relationship between the medicinal product indication or contraindication and another therapy.", 0, 1, this.therapyRelationshipType);
                }
                case 1458402129: {
                    return new Property("medication[x]", "CodeableConcept|Reference(MedicinalProduct|Medication|Substance|SubstanceSpecification)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.medication);
                }
                case 1998965455: {
                    return new Property("medication[x]", "CodeableConcept|Reference(MedicinalProduct|Medication|Substance|SubstanceSpecification)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.medication);
                }
                case -209845038: {
                    return new Property("medication[x]", "CodeableConcept|Reference(MedicinalProduct|Medication|Substance|SubstanceSpecification)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.medication);
                }
                case 2104315196: {
                    return new Property("medication[x]", "CodeableConcept|Reference(MedicinalProduct|Medication|Substance|SubstanceSpecification)", "Reference to a specific medication (active substance, medicinal product or class of products) as part of an indication or contraindication.", 0, 1, this.medication);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -551658469: {
                    Base[] baseArray;
                    if (this.therapyRelationshipType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.therapyRelationshipType;
                    }
                    return baseArray;
                }
                case 1998965455: {
                    Base[] baseArray;
                    if (this.medication == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.medication;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -551658469: {
                    this.therapyRelationshipType = this.castToCodeableConcept(value);
                    return value;
                }
                case 1998965455: {
                    this.medication = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("therapyRelationshipType")) {
                this.therapyRelationshipType = this.castToCodeableConcept(value);
            } else if (name.equals("medication[x]")) {
                this.medication = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -551658469: {
                    return this.getTherapyRelationshipType();
                }
                case 1458402129: {
                    return this.getMedication();
                }
                case 1998965455: {
                    return this.getMedication();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -551658469: {
                    return new String[]{"CodeableConcept"};
                }
                case 1998965455: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("therapyRelationshipType")) {
                this.therapyRelationshipType = new CodeableConcept();
                return this.therapyRelationshipType;
            }
            if (name.equals("medicationCodeableConcept")) {
                this.medication = new CodeableConcept();
                return this.medication;
            }
            if (name.equals("medicationReference")) {
                this.medication = new Reference();
                return this.medication;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductIndicationOtherTherapyComponent copy() {
            MedicinalProductIndicationOtherTherapyComponent dst = new MedicinalProductIndicationOtherTherapyComponent();
            this.copyValues(dst);
            dst.therapyRelationshipType = this.therapyRelationshipType == null ? null : this.therapyRelationshipType.copy();
            dst.medication = this.medication == null ? null : this.medication.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductIndicationOtherTherapyComponent)) {
                return false;
            }
            MedicinalProductIndicationOtherTherapyComponent o = (MedicinalProductIndicationOtherTherapyComponent)other_;
            return MedicinalProductIndicationOtherTherapyComponent.compareDeep(this.therapyRelationshipType, o.therapyRelationshipType, true) && MedicinalProductIndicationOtherTherapyComponent.compareDeep(this.medication, o.medication, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductIndicationOtherTherapyComponent)) {
                return false;
            }
            MedicinalProductIndicationOtherTherapyComponent o = (MedicinalProductIndicationOtherTherapyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.therapyRelationshipType, this.medication});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductIndication.otherTherapy";
        }
    }
}

