/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Type;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ValueSet", profile="http://hl7.org/fhir/StructureDefinition/ValueSet")
@ChildOrder(names={"url", "identifier", "version", "name", "title", "status", "experimental", "date", "publisher", "contact", "description", "useContext", "jurisdiction", "immutable", "purpose", "copyright", "compose", "expansion"})
public class ValueSet
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the value set (business identifier)", formalDefinition="A formal identifier that is used to identify this value set when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="immutable", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Indicates whether or not any change to the content logical definition may occur", formalDefinition="If this is set to 'true', then no new versions of the content logical definition can be created.  Note: Other metadata might still change.")
    protected BooleanType immutable;
    @Child(name="purpose", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this value set is defined", formalDefinition="Explanation of why this value set is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the value set and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the value set.")
    protected MarkdownType copyright;
    @Child(name="compose", type={}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Content logical definition of the value set (CLD)", formalDefinition="A set of criteria that define the contents of the value set by including or excluding codes selected from the specified code system(s) that the value set draws from. This is also known as the Content Logical Definition (CLD).")
    protected ValueSetComposeComponent compose;
    @Child(name="expansion", type={}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Used when the value set is \"expanded\"", formalDefinition="A value set can also be \"expanded\", where the value set is turned into a simple collection of enumerated codes. This element holds the expansion, if it has been performed.")
    protected ValueSetExpansionComponent expansion;
    private static final long serialVersionUID = 786712949L;
    @SearchParamDefinition(name="date", path="ValueSet.date", description="The value set publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="ValueSet.identifier", description="External identifier for the value set", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="code", path="ValueSet.expansion.contains.code | ValueSet.compose.include.concept.code", description="This special parameter searches for codes in the value set. See additional notes on the ValueSet resource", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="context-type-value", path="ValueSet.useContext", description="A use context type and value assigned to the value set", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="jurisdiction", path="ValueSet.jurisdiction", description="Intended jurisdiction for the value set", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="ValueSet.description", description="The description of the value set", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="context-type", path="ValueSet.useContext.code", description="A type of use context assigned to the value set", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="title", path="ValueSet.title", description="The human-friendly name of the value set", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="version", path="ValueSet.version", description="The business version of the value set", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="ValueSet.url", description="The uri that identifies the value set", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="expansion", path="ValueSet.expansion.identifier", description="Identifies the value set expansion (business identifier)", type="uri")
    public static final String SP_EXPANSION = "expansion";
    public static final UriClientParam EXPANSION = new UriClientParam("expansion");
    @SearchParamDefinition(name="reference", path="ValueSet.compose.include.system", description="A code system included or excluded in the value set or an imported value set", type="uri")
    public static final String SP_REFERENCE = "reference";
    public static final UriClientParam REFERENCE = new UriClientParam("reference");
    @SearchParamDefinition(name="context-quantity", path="(ValueSet.useContext.value as Quantity) | (ValueSet.useContext.value as Range)", description="A quantity- or range-valued use context assigned to the value set", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="name", path="ValueSet.name", description="Computationally friendly name of the value set", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="context", path="(ValueSet.useContext.value as CodeableConcept)", description="A use context assigned to the value set", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="publisher", path="ValueSet.publisher", description="Name of the publisher of the value set", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="context-type-quantity", path="ValueSet.useContext", description="A use context type and quantity- or range-based value assigned to the value set", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="status", path="ValueSet.status", description="The current status of the value set", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ValueSet() {
    }

    public ValueSet(Enumeration<Enumerations.PublicationStatus> status) {
        this.status = status;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ValueSet setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ValueSet setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ValueSet setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ValueSet addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ValueSet setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ValueSet setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ValueSet setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ValueSet setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public ValueSet setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public ValueSet setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ValueSet setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ValueSet setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ValueSet setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ValueSet setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ValueSet setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ValueSet setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ValueSet setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ValueSet setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public ValueSet setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ValueSet addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ValueSet setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ValueSet setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public ValueSet setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ValueSet addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public ValueSet setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ValueSet addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public BooleanType getImmutableElement() {
        if (this.immutable == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.immutable");
            }
            if (Configuration.doAutoCreate()) {
                this.immutable = new BooleanType();
            }
        }
        return this.immutable;
    }

    public boolean hasImmutableElement() {
        return this.immutable != null && !this.immutable.isEmpty();
    }

    public boolean hasImmutable() {
        return this.immutable != null && !this.immutable.isEmpty();
    }

    public ValueSet setImmutableElement(BooleanType value) {
        this.immutable = value;
        return this;
    }

    public boolean getImmutable() {
        return this.immutable == null || this.immutable.isEmpty() ? false : (Boolean)this.immutable.getValue();
    }

    public ValueSet setImmutable(boolean value) {
        if (this.immutable == null) {
            this.immutable = new BooleanType();
        }
        this.immutable.setValue((Object)value);
        return this;
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public ValueSet setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public ValueSet setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public ValueSet setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public ValueSet setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public ValueSetComposeComponent getCompose() {
        if (this.compose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.compose");
            }
            if (Configuration.doAutoCreate()) {
                this.compose = new ValueSetComposeComponent();
            }
        }
        return this.compose;
    }

    public boolean hasCompose() {
        return this.compose != null && !this.compose.isEmpty();
    }

    public ValueSet setCompose(ValueSetComposeComponent value) {
        this.compose = value;
        return this;
    }

    public ValueSetExpansionComponent getExpansion() {
        if (this.expansion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ValueSet.expansion");
            }
            if (Configuration.doAutoCreate()) {
                this.expansion = new ValueSetExpansionComponent();
            }
        }
        return this.expansion;
    }

    public boolean hasExpansion() {
        return this.expansion != null && !this.expansion.isEmpty();
    }

    public ValueSet setExpansion(ValueSetExpansionComponent value) {
        this.expansion = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this value set when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this value set is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the value set is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this value set when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the value set when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the value set author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the value set. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the value set.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, SP_CODE, "The status of this value set. Enables tracking the life-cycle of the content. The status of the value set applies to the value set definition (ValueSet.compose) and the associated ValueSet metadata. Expansions do not have a state.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this value set is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date (and optionally time) when the value set was created or revised (e.g. the 'content logical definition').", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the value set.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the value set from a consumer's perspective. The textual description specifies the span of meanings for concepts to be included within the Value Set Expansion, and also may specify the intended use and limitations of the Value Set.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate value set instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the value set is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("immutable", "boolean", "If this is set to 'true', then no new versions of the content logical definition can be created.  Note: Other metadata might still change.", 0, 1, this.immutable));
        children.add(new Property("purpose", "markdown", "Explanation of why this value set is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the value set and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the value set.", 0, 1, this.copyright));
        children.add(new Property("compose", "", "A set of criteria that define the contents of the value set by including or excluding codes selected from the specified code system(s) that the value set draws from. This is also known as the Content Logical Definition (CLD).", 0, 1, this.compose));
        children.add(new Property(SP_EXPANSION, "", "A value set can also be \"expanded\", where the value set is turned into a simple collection of enumerated codes. This element holds the expansion, if it has been performed.", 0, 1, this.expansion));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this value set when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this value set is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the value set is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this value set when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the value set when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the value set author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the value set. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the value set.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The status of this value set. Enables tracking the life-cycle of the content. The status of the value set applies to the value set definition (ValueSet.compose) and the associated ValueSet metadata. Expansions do not have a state.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this value set is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date (and optionally time) when the value set was created or revised (e.g. the 'content logical definition').", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the value set.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the value set from a consumer's perspective. The textual description specifies the span of meanings for concepts to be included within the Value Set Expansion, and also may specify the intended use and limitations of the Value Set.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate value set instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the value set is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 1596987778: {
                return new Property("immutable", "boolean", "If this is set to 'true', then no new versions of the content logical definition can be created.  Note: Other metadata might still change.", 0, 1, this.immutable);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this value set is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the value set and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the value set.", 0, 1, this.copyright);
            }
            case 950497682: {
                return new Property("compose", "", "A set of criteria that define the contents of the value set by including or excluding codes selected from the specified code system(s) that the value set draws from. This is also known as the Content Logical Definition (CLD).", 0, 1, this.compose);
            }
            case 17878207: {
                return new Property(SP_EXPANSION, "", "A value set can also be \"expanded\", where the value set is turned into a simple collection of enumerated codes. This element holds the expansion, if it has been performed.", 0, 1, this.expansion);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 1596987778: {
                Base[] baseArray;
                if (this.immutable == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.immutable;
                }
                return baseArray;
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.copyright;
                }
                return baseArray;
            }
            case 950497682: {
                Base[] baseArray;
                if (this.compose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.compose;
                }
                return baseArray;
            }
            case 17878207: {
                Base[] baseArray;
                if (this.expansion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.expansion;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1596987778: {
                this.immutable = this.castToBoolean(value);
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 950497682: {
                this.compose = (ValueSetComposeComponent)((Object)value);
                return value;
            }
            case 17878207: {
                this.expansion = (ValueSetExpansionComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("immutable")) {
            this.immutable = this.castToBoolean(value);
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("compose")) {
            this.compose = (ValueSetComposeComponent)((Object)value);
        } else if (name.equals(SP_EXPANSION)) {
            this.expansion = (ValueSetExpansionComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 1596987778: {
                return this.getImmutableElement();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 950497682: {
                return this.getCompose();
            }
            case 17878207: {
                return this.getExpansion();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 1596987778: {
                return new String[]{"boolean"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 950497682: {
                return new String[0];
            }
            case 17878207: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("immutable")) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.immutable");
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type ValueSet.copyright");
        }
        if (name.equals("compose")) {
            this.compose = new ValueSetComposeComponent();
            return this.compose;
        }
        if (name.equals(SP_EXPANSION)) {
            this.expansion = new ValueSetExpansionComponent();
            return this.expansion;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ValueSet";
    }

    @Override
    public ValueSet copy() {
        ValueSet dst = new ValueSet();
        this.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.immutable = this.immutable == null ? null : this.immutable.copy();
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.compose = this.compose == null ? null : this.compose.copy();
        dst.expansion = this.expansion == null ? null : this.expansion.copy();
        return dst;
    }

    protected ValueSet typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ValueSet)) {
            return false;
        }
        ValueSet o = (ValueSet)other_;
        return ValueSet.compareDeep(this.identifier, o.identifier, true) && ValueSet.compareDeep(this.immutable, o.immutable, true) && ValueSet.compareDeep(this.purpose, o.purpose, true) && ValueSet.compareDeep(this.copyright, o.copyright, true) && ValueSet.compareDeep(this.compose, o.compose, true) && ValueSet.compareDeep(this.expansion, o.expansion, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ValueSet)) {
            return false;
        }
        ValueSet o = (ValueSet)other_;
        return ValueSet.compareValues(this.immutable, o.immutable, true) && ValueSet.compareValues(this.purpose, o.purpose, true) && ValueSet.compareValues(this.copyright, o.copyright, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.immutable, this.purpose, this.copyright, this.compose, this.expansion});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ValueSet;
    }

    @Block
    public static class ValueSetExpansionContainsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="system", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="System value for the code", formalDefinition="An absolute URI which is the code system in which the code for this item in the expansion is defined.")
        protected UriType system;
        @Child(name="abstract", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If user cannot select this entry", formalDefinition="If true, this entry is included in the expansion for navigational purposes, and the user cannot select the code directly as a proper value.")
        protected BooleanType abstract_;
        @Child(name="inactive", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If concept is inactive in the code system", formalDefinition="If the concept is inactive in the code system that defines it. Inactive codes are those that are no longer to be used, but are maintained by the code system for understanding legacy data. It might not be known or specified whether an concept is inactive (and it may depend on the context of use).")
        protected BooleanType inactive;
        @Child(name="version", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Version in which this code/display is defined", formalDefinition="The version of the code system from this code was taken. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured, and when the meaning is not guaranteed to be consistent, the version SHOULD be exchanged.")
        protected StringType version;
        @Child(name="code", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code - if blank, this is not a selectable code", formalDefinition="The code for this item in the expansion hierarchy. If this code is missing the entry in the hierarchy is a place holder (abstract) and does not represent a valid code in the value set.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="User display for the concept", formalDefinition="The recommended display for this item in the expansion.")
        protected StringType display;
        @Child(name="designation", type={ConceptReferenceDesignationComponent.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional representations for this item", formalDefinition="Additional representations for this item - other languages, aliases, specialized purposes, used for particular purposes, etc. These are relevant when the conditions of the expansion do not fix to a single correct representation.")
        protected List<ConceptReferenceDesignationComponent> designation;
        @Child(name="contains", type={ValueSetExpansionContainsComponent.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Codes contained under this entry", formalDefinition="Other codes and entries contained under this entry in the hierarchy.")
        protected List<ValueSetExpansionContainsComponent> contains;
        private static final long serialVersionUID = 719458860L;

        public UriType getSystemElement() {
            if (this.system == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.system");
                }
                if (Configuration.doAutoCreate()) {
                    this.system = new UriType();
                }
            }
            return this.system;
        }

        public boolean hasSystemElement() {
            return this.system != null && !this.system.isEmpty();
        }

        public boolean hasSystem() {
            return this.system != null && !this.system.isEmpty();
        }

        public ValueSetExpansionContainsComponent setSystemElement(UriType value) {
            this.system = value;
            return this;
        }

        public String getSystem() {
            return this.system == null ? null : (String)this.system.getValue();
        }

        public ValueSetExpansionContainsComponent setSystem(String value) {
            if (Utilities.noString((String)value)) {
                this.system = null;
            } else {
                if (this.system == null) {
                    this.system = new UriType();
                }
                this.system.setValue(value);
            }
            return this;
        }

        public BooleanType getAbstractElement() {
            if (this.abstract_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.abstract_");
                }
                if (Configuration.doAutoCreate()) {
                    this.abstract_ = new BooleanType();
                }
            }
            return this.abstract_;
        }

        public boolean hasAbstractElement() {
            return this.abstract_ != null && !this.abstract_.isEmpty();
        }

        public boolean hasAbstract() {
            return this.abstract_ != null && !this.abstract_.isEmpty();
        }

        public ValueSetExpansionContainsComponent setAbstractElement(BooleanType value) {
            this.abstract_ = value;
            return this;
        }

        public boolean getAbstract() {
            return this.abstract_ == null || this.abstract_.isEmpty() ? false : (Boolean)this.abstract_.getValue();
        }

        public ValueSetExpansionContainsComponent setAbstract(boolean value) {
            if (this.abstract_ == null) {
                this.abstract_ = new BooleanType();
            }
            this.abstract_.setValue((Object)value);
            return this;
        }

        public BooleanType getInactiveElement() {
            if (this.inactive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.inactive");
                }
                if (Configuration.doAutoCreate()) {
                    this.inactive = new BooleanType();
                }
            }
            return this.inactive;
        }

        public boolean hasInactiveElement() {
            return this.inactive != null && !this.inactive.isEmpty();
        }

        public boolean hasInactive() {
            return this.inactive != null && !this.inactive.isEmpty();
        }

        public ValueSetExpansionContainsComponent setInactiveElement(BooleanType value) {
            this.inactive = value;
            return this;
        }

        public boolean getInactive() {
            return this.inactive == null || this.inactive.isEmpty() ? false : (Boolean)this.inactive.getValue();
        }

        public ValueSetExpansionContainsComponent setInactive(boolean value) {
            if (this.inactive == null) {
                this.inactive = new BooleanType();
            }
            this.inactive.setValue((Object)value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ValueSetExpansionContainsComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ValueSetExpansionContainsComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ValueSetExpansionContainsComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ValueSetExpansionContainsComponent setCode(String value) {
            if (Utilities.noString((String)value)) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(value);
            }
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionContainsComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public ValueSetExpansionContainsComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public ValueSetExpansionContainsComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public List<ConceptReferenceDesignationComponent> getDesignation() {
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptReferenceDesignationComponent>();
            }
            return this.designation;
        }

        public ValueSetExpansionContainsComponent setDesignation(List<ConceptReferenceDesignationComponent> theDesignation) {
            this.designation = theDesignation;
            return this;
        }

        public boolean hasDesignation() {
            if (this.designation == null) {
                return false;
            }
            for (ConceptReferenceDesignationComponent item : this.designation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptReferenceDesignationComponent addDesignation() {
            ConceptReferenceDesignationComponent t = new ConceptReferenceDesignationComponent();
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptReferenceDesignationComponent>();
            }
            this.designation.add(t);
            return t;
        }

        public ValueSetExpansionContainsComponent addDesignation(ConceptReferenceDesignationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptReferenceDesignationComponent>();
            }
            this.designation.add(t);
            return this;
        }

        public ConceptReferenceDesignationComponent getDesignationFirstRep() {
            if (this.getDesignation().isEmpty()) {
                this.addDesignation();
            }
            return this.getDesignation().get(0);
        }

        public List<ValueSetExpansionContainsComponent> getContains() {
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            return this.contains;
        }

        public ValueSetExpansionContainsComponent setContains(List<ValueSetExpansionContainsComponent> theContains) {
            this.contains = theContains;
            return this;
        }

        public boolean hasContains() {
            if (this.contains == null) {
                return false;
            }
            for (ValueSetExpansionContainsComponent item : this.contains) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ValueSetExpansionContainsComponent addContains() {
            ValueSetExpansionContainsComponent t = new ValueSetExpansionContainsComponent();
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            this.contains.add(t);
            return t;
        }

        public ValueSetExpansionContainsComponent addContains(ValueSetExpansionContainsComponent t) {
            if (t == null) {
                return this;
            }
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            this.contains.add(t);
            return this;
        }

        public ValueSetExpansionContainsComponent getContainsFirstRep() {
            if (this.getContains().isEmpty()) {
                this.addContains();
            }
            return this.getContains().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("system", "uri", "An absolute URI which is the code system in which the code for this item in the expansion is defined.", 0, 1, this.system));
            children.add(new Property("abstract", "boolean", "If true, this entry is included in the expansion for navigational purposes, and the user cannot select the code directly as a proper value.", 0, 1, this.abstract_));
            children.add(new Property("inactive", "boolean", "If the concept is inactive in the code system that defines it. Inactive codes are those that are no longer to be used, but are maintained by the code system for understanding legacy data. It might not be known or specified whether an concept is inactive (and it may depend on the context of use).", 0, 1, this.inactive));
            children.add(new Property(ValueSet.SP_VERSION, "string", "The version of the code system from this code was taken. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured, and when the meaning is not guaranteed to be consistent, the version SHOULD be exchanged.", 0, 1, this.version));
            children.add(new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "The code for this item in the expansion hierarchy. If this code is missing the entry in the hierarchy is a place holder (abstract) and does not represent a valid code in the value set.", 0, 1, this.code));
            children.add(new Property("display", "string", "The recommended display for this item in the expansion.", 0, 1, this.display));
            children.add(new Property("designation", "@ValueSet.compose.include.concept.designation", "Additional representations for this item - other languages, aliases, specialized purposes, used for particular purposes, etc. These are relevant when the conditions of the expansion do not fix to a single correct representation.", 0, Integer.MAX_VALUE, this.designation));
            children.add(new Property("contains", "@ValueSet.expansion.contains", "Other codes and entries contained under this entry in the hierarchy.", 0, Integer.MAX_VALUE, this.contains));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -887328209: {
                    return new Property("system", "uri", "An absolute URI which is the code system in which the code for this item in the expansion is defined.", 0, 1, this.system);
                }
                case 1732898850: {
                    return new Property("abstract", "boolean", "If true, this entry is included in the expansion for navigational purposes, and the user cannot select the code directly as a proper value.", 0, 1, this.abstract_);
                }
                case 24665195: {
                    return new Property("inactive", "boolean", "If the concept is inactive in the code system that defines it. Inactive codes are those that are no longer to be used, but are maintained by the code system for understanding legacy data. It might not be known or specified whether an concept is inactive (and it may depend on the context of use).", 0, 1, this.inactive);
                }
                case 351608024: {
                    return new Property(ValueSet.SP_VERSION, "string", "The version of the code system from this code was taken. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured, and when the meaning is not guaranteed to be consistent, the version SHOULD be exchanged.", 0, 1, this.version);
                }
                case 3059181: {
                    return new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "The code for this item in the expansion hierarchy. If this code is missing the entry in the hierarchy is a place holder (abstract) and does not represent a valid code in the value set.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The recommended display for this item in the expansion.", 0, 1, this.display);
                }
                case -900931593: {
                    return new Property("designation", "@ValueSet.compose.include.concept.designation", "Additional representations for this item - other languages, aliases, specialized purposes, used for particular purposes, etc. These are relevant when the conditions of the expansion do not fix to a single correct representation.", 0, Integer.MAX_VALUE, this.designation);
                }
                case -567445985: {
                    return new Property("contains", "@ValueSet.expansion.contains", "Other codes and entries contained under this entry in the hierarchy.", 0, Integer.MAX_VALUE, this.contains);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    Base[] baseArray;
                    if (this.system == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.system;
                    }
                    return baseArray;
                }
                case 1732898850: {
                    Base[] baseArray;
                    if (this.abstract_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.abstract_;
                    }
                    return baseArray;
                }
                case 24665195: {
                    Base[] baseArray;
                    if (this.inactive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.inactive;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.version;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.display;
                    }
                    return baseArray;
                }
                case -900931593: {
                    return this.designation == null ? new Base[]{} : this.designation.toArray(new Base[this.designation.size()]);
                }
                case -567445985: {
                    return this.contains == null ? new Base[]{} : this.contains.toArray(new Base[this.contains.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    this.system = this.castToUri(value);
                    return value;
                }
                case 1732898850: {
                    this.abstract_ = this.castToBoolean(value);
                    return value;
                }
                case 24665195: {
                    this.inactive = this.castToBoolean(value);
                    return value;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    return value;
                }
                case 3059181: {
                    this.code = this.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = this.castToString(value);
                    return value;
                }
                case -900931593: {
                    this.getDesignation().add((ConceptReferenceDesignationComponent)value);
                    return value;
                }
                case -567445985: {
                    this.getContains().add((ValueSetExpansionContainsComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("system")) {
                this.system = this.castToUri(value);
            } else if (name.equals("abstract")) {
                this.abstract_ = this.castToBoolean(value);
            } else if (name.equals("inactive")) {
                this.inactive = this.castToBoolean(value);
            } else if (name.equals(ValueSet.SP_VERSION)) {
                this.version = this.castToString(value);
            } else if (name.equals(ValueSet.SP_CODE)) {
                this.code = this.castToCode(value);
            } else if (name.equals("display")) {
                this.display = this.castToString(value);
            } else if (name.equals("designation")) {
                this.getDesignation().add((ConceptReferenceDesignationComponent)value);
            } else if (name.equals("contains")) {
                this.getContains().add((ValueSetExpansionContainsComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    return this.getSystemElement();
                }
                case 1732898850: {
                    return this.getAbstractElement();
                }
                case 24665195: {
                    return this.getInactiveElement();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -900931593: {
                    return this.addDesignation();
                }
                case -567445985: {
                    return this.addContains();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    return new String[]{"uri"};
                }
                case 1732898850: {
                    return new String[]{"boolean"};
                }
                case 24665195: {
                    return new String[]{"boolean"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
                case 3059181: {
                    return new String[]{ValueSet.SP_CODE};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -900931593: {
                    return new String[]{"@ValueSet.compose.include.concept.designation"};
                }
                case -567445985: {
                    return new String[]{"@ValueSet.expansion.contains"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("system")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.system");
            }
            if (name.equals("abstract")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.abstract");
            }
            if (name.equals("inactive")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.inactive");
            }
            if (name.equals(ValueSet.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.version");
            }
            if (name.equals(ValueSet.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.display");
            }
            if (name.equals("designation")) {
                return this.addDesignation();
            }
            if (name.equals("contains")) {
                return this.addContains();
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetExpansionContainsComponent copy() {
            ValueSetExpansionContainsComponent dst = new ValueSetExpansionContainsComponent();
            this.copyValues(dst);
            dst.system = this.system == null ? null : this.system.copy();
            dst.abstract_ = this.abstract_ == null ? null : this.abstract_.copy();
            dst.inactive = this.inactive == null ? null : this.inactive.copy();
            dst.version = this.version == null ? null : this.version.copy();
            dst.code = this.code == null ? null : this.code.copy();
            StringType stringType = dst.display = this.display == null ? null : this.display.copy();
            if (this.designation != null) {
                dst.designation = new ArrayList<ConceptReferenceDesignationComponent>();
                for (ConceptReferenceDesignationComponent conceptReferenceDesignationComponent : this.designation) {
                    dst.designation.add(conceptReferenceDesignationComponent.copy());
                }
            }
            if (this.contains != null) {
                dst.contains = new ArrayList<ValueSetExpansionContainsComponent>();
                for (ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : this.contains) {
                    dst.contains.add(valueSetExpansionContainsComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetExpansionContainsComponent)) {
                return false;
            }
            ValueSetExpansionContainsComponent o = (ValueSetExpansionContainsComponent)other_;
            return ValueSetExpansionContainsComponent.compareDeep(this.system, o.system, true) && ValueSetExpansionContainsComponent.compareDeep(this.abstract_, o.abstract_, true) && ValueSetExpansionContainsComponent.compareDeep(this.inactive, o.inactive, true) && ValueSetExpansionContainsComponent.compareDeep(this.version, o.version, true) && ValueSetExpansionContainsComponent.compareDeep(this.code, o.code, true) && ValueSetExpansionContainsComponent.compareDeep(this.display, o.display, true) && ValueSetExpansionContainsComponent.compareDeep(this.designation, o.designation, true) && ValueSetExpansionContainsComponent.compareDeep(this.contains, o.contains, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetExpansionContainsComponent)) {
                return false;
            }
            ValueSetExpansionContainsComponent o = (ValueSetExpansionContainsComponent)other_;
            return ValueSetExpansionContainsComponent.compareValues(this.system, o.system, true) && ValueSetExpansionContainsComponent.compareValues(this.abstract_, o.abstract_, true) && ValueSetExpansionContainsComponent.compareValues(this.inactive, o.inactive, true) && ValueSetExpansionContainsComponent.compareValues(this.version, o.version, true) && ValueSetExpansionContainsComponent.compareValues(this.code, o.code, true) && ValueSetExpansionContainsComponent.compareValues(this.display, o.display, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.system, this.abstract_, this.inactive, this.version, this.code, this.display, this.designation, this.contains});
        }

        @Override
        public String fhirType() {
            return "ValueSet.expansion.contains";
        }
    }

    @Block
    public static class ValueSetExpansionParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name as assigned by the client or server", formalDefinition="Name of the input parameter to the $expand operation; may be a server-assigned name for additional default or other server-supplied parameters used to control the expansion process.")
        protected StringType name;
        @Child(name="value", type={StringType.class, BooleanType.class, IntegerType.class, DecimalType.class, UriType.class, CodeType.class, DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of the named parameter", formalDefinition="The value of the parameter.")
        protected Type value;
        private static final long serialVersionUID = 1172641169L;

        public ValueSetExpansionParameterComponent() {
        }

        public ValueSetExpansionParameterComponent(StringType name) {
            this.name = name;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionParameterComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ValueSetExpansionParameterComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ValueSetExpansionParameterComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this != null && this.value instanceof DecimalType;
        }

        public UriType getValueUriType() throws FHIRException {
            if (this.value == null) {
                this.value = new UriType();
            }
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this != null && this.value instanceof UriType;
        }

        public CodeType getValueCodeType() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeType();
            }
            if (!(this.value instanceof CodeType)) {
                throw new FHIRException("Type mismatch: the type CodeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeType)this.value;
        }

        public boolean hasValueCodeType() {
            return this != null && this.value instanceof CodeType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ValueSetExpansionParameterComponent setValue(Type value) {
            if (!(value == null || value instanceof StringType || value instanceof BooleanType || value instanceof IntegerType || value instanceof DecimalType || value instanceof UriType || value instanceof CodeType || value instanceof DateTimeType)) {
                throw new Error("Not the right type for ValueSet.expansion.parameter.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ValueSet.SP_NAME, "string", "Name of the input parameter to the $expand operation; may be a server-assigned name for additional default or other server-supplied parameters used to control the expansion process.", 0, 1, this.name));
            children.add(new Property("value[x]", "string|boolean|integer|decimal|uri|code|dateTime", "The value of the parameter.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(ValueSet.SP_NAME, "string", "Name of the input parameter to the $expand operation; may be a server-assigned name for additional default or other server-supplied parameters used to control the expansion process.", 0, 1, this.name);
                }
                case -1410166417: {
                    return new Property("value[x]", "string|boolean|integer|decimal|uri|code|dateTime", "The value of the parameter.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "string|boolean|integer|decimal|uri|code|dateTime", "The value of the parameter.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string|boolean|integer|decimal|uri|code|dateTime", "The value of the parameter.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "string|boolean|integer|decimal|uri|code|dateTime", "The value of the parameter.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "string|boolean|integer|decimal|uri|code|dateTime", "The value of the parameter.", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "string|boolean|integer|decimal|uri|code|dateTime", "The value of the parameter.", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "string|boolean|integer|decimal|uri|code|dateTime", "The value of the parameter.", 0, 1, this.value);
                }
                case -766209282: {
                    return new Property("value[x]", "string|boolean|integer|decimal|uri|code|dateTime", "The value of the parameter.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "string|boolean|integer|decimal|uri|code|dateTime", "The value of the parameter.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 111972721: {
                    return new String[]{"string", "boolean", "integer", "decimal", "uri", ValueSet.SP_CODE, "dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.name");
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetExpansionParameterComponent copy() {
            ValueSetExpansionParameterComponent dst = new ValueSetExpansionParameterComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetExpansionParameterComponent)) {
                return false;
            }
            ValueSetExpansionParameterComponent o = (ValueSetExpansionParameterComponent)other_;
            return ValueSetExpansionParameterComponent.compareDeep(this.name, o.name, true) && ValueSetExpansionParameterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetExpansionParameterComponent)) {
                return false;
            }
            ValueSetExpansionParameterComponent o = (ValueSetExpansionParameterComponent)other_;
            return ValueSetExpansionParameterComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.value});
        }

        @Override
        public String fhirType() {
            return "ValueSet.expansion.parameter";
        }
    }

    @Block
    public static class ValueSetExpansionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies the value set expansion (business identifier)", formalDefinition="An identifier that uniquely identifies this expansion of the valueset, based on a unique combination of the provided parameters, the system default parameters, and the underlying system code system versions etc. Systems may re-use the same identifier as long as those factors remain the same, and the expansion is the same, but are not required to do so. This is a business identifier.")
        protected UriType identifier;
        @Child(name="timestamp", type={DateTimeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time ValueSet expansion happened", formalDefinition="The time at which the expansion was produced by the expanding system.")
        protected DateTimeType timestamp;
        @Child(name="total", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total number of codes in the expansion", formalDefinition="The total number of concepts in the expansion. If the number of concept nodes in this resource is less than the stated number, then the server can return more using the offset parameter.")
        protected IntegerType total;
        @Child(name="offset", type={IntegerType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Offset at which this resource starts", formalDefinition="If paging is being used, the offset at which this resource starts.  I.e. this resource is a partial view into the expansion. If paging is not being used, this element SHALL NOT be present.")
        protected IntegerType offset;
        @Child(name="parameter", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Parameter that controlled the expansion process", formalDefinition="A parameter that controlled the expansion process. These parameters may be used by users of expanded value sets to check whether the expansion is suitable for a particular purpose, or to pick the correct expansion.")
        protected List<ValueSetExpansionParameterComponent> parameter;
        @Child(name="contains", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Codes in the value set", formalDefinition="The codes that are contained in the value set expansion.")
        protected List<ValueSetExpansionContainsComponent> contains;
        private static final long serialVersionUID = -43471993L;

        public ValueSetExpansionComponent() {
        }

        public ValueSetExpansionComponent(DateTimeType timestamp) {
            this.timestamp = timestamp;
        }

        public UriType getIdentifierElement() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new UriType();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifierElement() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public ValueSetExpansionComponent setIdentifierElement(UriType value) {
            this.identifier = value;
            return this;
        }

        public String getIdentifier() {
            return this.identifier == null ? null : (String)this.identifier.getValue();
        }

        public ValueSetExpansionComponent setIdentifier(String value) {
            if (Utilities.noString((String)value)) {
                this.identifier = null;
            } else {
                if (this.identifier == null) {
                    this.identifier = new UriType();
                }
                this.identifier.setValue(value);
            }
            return this;
        }

        public DateTimeType getTimestampElement() {
            if (this.timestamp == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionComponent.timestamp");
                }
                if (Configuration.doAutoCreate()) {
                    this.timestamp = new DateTimeType();
                }
            }
            return this.timestamp;
        }

        public boolean hasTimestampElement() {
            return this.timestamp != null && !this.timestamp.isEmpty();
        }

        public boolean hasTimestamp() {
            return this.timestamp != null && !this.timestamp.isEmpty();
        }

        public ValueSetExpansionComponent setTimestampElement(DateTimeType value) {
            this.timestamp = value;
            return this;
        }

        public Date getTimestamp() {
            return this.timestamp == null ? null : (Date)this.timestamp.getValue();
        }

        public ValueSetExpansionComponent setTimestamp(Date value) {
            if (this.timestamp == null) {
                this.timestamp = new DateTimeType();
            }
            this.timestamp.setValue(value);
            return this;
        }

        public IntegerType getTotalElement() {
            if (this.total == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionComponent.total");
                }
                if (Configuration.doAutoCreate()) {
                    this.total = new IntegerType();
                }
            }
            return this.total;
        }

        public boolean hasTotalElement() {
            return this.total != null && !this.total.isEmpty();
        }

        public boolean hasTotal() {
            return this.total != null && !this.total.isEmpty();
        }

        public ValueSetExpansionComponent setTotalElement(IntegerType value) {
            this.total = value;
            return this;
        }

        public int getTotal() {
            return this.total == null || this.total.isEmpty() ? 0 : (Integer)this.total.getValue();
        }

        public ValueSetExpansionComponent setTotal(int value) {
            if (this.total == null) {
                this.total = new IntegerType();
            }
            this.total.setValue((Object)value);
            return this;
        }

        public IntegerType getOffsetElement() {
            if (this.offset == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetExpansionComponent.offset");
                }
                if (Configuration.doAutoCreate()) {
                    this.offset = new IntegerType();
                }
            }
            return this.offset;
        }

        public boolean hasOffsetElement() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public boolean hasOffset() {
            return this.offset != null && !this.offset.isEmpty();
        }

        public ValueSetExpansionComponent setOffsetElement(IntegerType value) {
            this.offset = value;
            return this;
        }

        public int getOffset() {
            return this.offset == null || this.offset.isEmpty() ? 0 : (Integer)this.offset.getValue();
        }

        public ValueSetExpansionComponent setOffset(int value) {
            if (this.offset == null) {
                this.offset = new IntegerType();
            }
            this.offset.setValue((Object)value);
            return this;
        }

        public List<ValueSetExpansionParameterComponent> getParameter() {
            if (this.parameter == null) {
                this.parameter = new ArrayList<ValueSetExpansionParameterComponent>();
            }
            return this.parameter;
        }

        public ValueSetExpansionComponent setParameter(List<ValueSetExpansionParameterComponent> theParameter) {
            this.parameter = theParameter;
            return this;
        }

        public boolean hasParameter() {
            if (this.parameter == null) {
                return false;
            }
            for (ValueSetExpansionParameterComponent item : this.parameter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ValueSetExpansionParameterComponent addParameter() {
            ValueSetExpansionParameterComponent t = new ValueSetExpansionParameterComponent();
            if (this.parameter == null) {
                this.parameter = new ArrayList<ValueSetExpansionParameterComponent>();
            }
            this.parameter.add(t);
            return t;
        }

        public ValueSetExpansionComponent addParameter(ValueSetExpansionParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.parameter == null) {
                this.parameter = new ArrayList<ValueSetExpansionParameterComponent>();
            }
            this.parameter.add(t);
            return this;
        }

        public ValueSetExpansionParameterComponent getParameterFirstRep() {
            if (this.getParameter().isEmpty()) {
                this.addParameter();
            }
            return this.getParameter().get(0);
        }

        public List<ValueSetExpansionContainsComponent> getContains() {
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            return this.contains;
        }

        public ValueSetExpansionComponent setContains(List<ValueSetExpansionContainsComponent> theContains) {
            this.contains = theContains;
            return this;
        }

        public boolean hasContains() {
            if (this.contains == null) {
                return false;
            }
            for (ValueSetExpansionContainsComponent item : this.contains) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ValueSetExpansionContainsComponent addContains() {
            ValueSetExpansionContainsComponent t = new ValueSetExpansionContainsComponent();
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            this.contains.add(t);
            return t;
        }

        public ValueSetExpansionComponent addContains(ValueSetExpansionContainsComponent t) {
            if (t == null) {
                return this;
            }
            if (this.contains == null) {
                this.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            }
            this.contains.add(t);
            return this;
        }

        public ValueSetExpansionContainsComponent getContainsFirstRep() {
            if (this.getContains().isEmpty()) {
                this.addContains();
            }
            return this.getContains().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ValueSet.SP_IDENTIFIER, "uri", "An identifier that uniquely identifies this expansion of the valueset, based on a unique combination of the provided parameters, the system default parameters, and the underlying system code system versions etc. Systems may re-use the same identifier as long as those factors remain the same, and the expansion is the same, but are not required to do so. This is a business identifier.", 0, 1, this.identifier));
            children.add(new Property("timestamp", "dateTime", "The time at which the expansion was produced by the expanding system.", 0, 1, this.timestamp));
            children.add(new Property("total", "integer", "The total number of concepts in the expansion. If the number of concept nodes in this resource is less than the stated number, then the server can return more using the offset parameter.", 0, 1, this.total));
            children.add(new Property("offset", "integer", "If paging is being used, the offset at which this resource starts.  I.e. this resource is a partial view into the expansion. If paging is not being used, this element SHALL NOT be present.", 0, 1, this.offset));
            children.add(new Property("parameter", "", "A parameter that controlled the expansion process. These parameters may be used by users of expanded value sets to check whether the expansion is suitable for a particular purpose, or to pick the correct expansion.", 0, Integer.MAX_VALUE, this.parameter));
            children.add(new Property("contains", "", "The codes that are contained in the value set expansion.", 0, Integer.MAX_VALUE, this.contains));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(ValueSet.SP_IDENTIFIER, "uri", "An identifier that uniquely identifies this expansion of the valueset, based on a unique combination of the provided parameters, the system default parameters, and the underlying system code system versions etc. Systems may re-use the same identifier as long as those factors remain the same, and the expansion is the same, but are not required to do so. This is a business identifier.", 0, 1, this.identifier);
                }
                case 55126294: {
                    return new Property("timestamp", "dateTime", "The time at which the expansion was produced by the expanding system.", 0, 1, this.timestamp);
                }
                case 110549828: {
                    return new Property("total", "integer", "The total number of concepts in the expansion. If the number of concept nodes in this resource is less than the stated number, then the server can return more using the offset parameter.", 0, 1, this.total);
                }
                case -1019779949: {
                    return new Property("offset", "integer", "If paging is being used, the offset at which this resource starts.  I.e. this resource is a partial view into the expansion. If paging is not being used, this element SHALL NOT be present.", 0, 1, this.offset);
                }
                case 1954460585: {
                    return new Property("parameter", "", "A parameter that controlled the expansion process. These parameters may be used by users of expanded value sets to check whether the expansion is suitable for a particular purpose, or to pick the correct expansion.", 0, Integer.MAX_VALUE, this.parameter);
                }
                case -567445985: {
                    return new Property("contains", "", "The codes that are contained in the value set expansion.", 0, Integer.MAX_VALUE, this.contains);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 55126294: {
                    Base[] baseArray;
                    if (this.timestamp == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.timestamp;
                    }
                    return baseArray;
                }
                case 110549828: {
                    Base[] baseArray;
                    if (this.total == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.total;
                    }
                    return baseArray;
                }
                case -1019779949: {
                    Base[] baseArray;
                    if (this.offset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.offset;
                    }
                    return baseArray;
                }
                case 1954460585: {
                    return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
                }
                case -567445985: {
                    return this.contains == null ? new Base[]{} : this.contains.toArray(new Base[this.contains.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToUri(value);
                    return value;
                }
                case 55126294: {
                    this.timestamp = this.castToDateTime(value);
                    return value;
                }
                case 110549828: {
                    this.total = this.castToInteger(value);
                    return value;
                }
                case -1019779949: {
                    this.offset = this.castToInteger(value);
                    return value;
                }
                case 1954460585: {
                    this.getParameter().add((ValueSetExpansionParameterComponent)value);
                    return value;
                }
                case -567445985: {
                    this.getContains().add((ValueSetExpansionContainsComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_IDENTIFIER)) {
                this.identifier = this.castToUri(value);
            } else if (name.equals("timestamp")) {
                this.timestamp = this.castToDateTime(value);
            } else if (name.equals("total")) {
                this.total = this.castToInteger(value);
            } else if (name.equals("offset")) {
                this.offset = this.castToInteger(value);
            } else if (name.equals("parameter")) {
                this.getParameter().add((ValueSetExpansionParameterComponent)value);
            } else if (name.equals("contains")) {
                this.getContains().add((ValueSetExpansionContainsComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifierElement();
                }
                case 55126294: {
                    return this.getTimestampElement();
                }
                case 110549828: {
                    return this.getTotalElement();
                }
                case -1019779949: {
                    return this.getOffsetElement();
                }
                case 1954460585: {
                    return this.addParameter();
                }
                case -567445985: {
                    return this.addContains();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"uri"};
                }
                case 55126294: {
                    return new String[]{"dateTime"};
                }
                case 110549828: {
                    return new String[]{"integer"};
                }
                case -1019779949: {
                    return new String[]{"integer"};
                }
                case 1954460585: {
                    return new String[0];
                }
                case -567445985: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_IDENTIFIER)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.identifier");
            }
            if (name.equals("timestamp")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.timestamp");
            }
            if (name.equals("total")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.total");
            }
            if (name.equals("offset")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.offset");
            }
            if (name.equals("parameter")) {
                return this.addParameter();
            }
            if (name.equals("contains")) {
                return this.addContains();
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetExpansionComponent copy() {
            ValueSetExpansionComponent dst = new ValueSetExpansionComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.timestamp = this.timestamp == null ? null : this.timestamp.copy();
            dst.total = this.total == null ? null : this.total.copy();
            IntegerType integerType = dst.offset = this.offset == null ? null : this.offset.copy();
            if (this.parameter != null) {
                dst.parameter = new ArrayList<ValueSetExpansionParameterComponent>();
                for (ValueSetExpansionParameterComponent valueSetExpansionParameterComponent : this.parameter) {
                    dst.parameter.add(valueSetExpansionParameterComponent.copy());
                }
            }
            if (this.contains != null) {
                dst.contains = new ArrayList<ValueSetExpansionContainsComponent>();
                for (ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : this.contains) {
                    dst.contains.add(valueSetExpansionContainsComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetExpansionComponent)) {
                return false;
            }
            ValueSetExpansionComponent o = (ValueSetExpansionComponent)other_;
            return ValueSetExpansionComponent.compareDeep(this.identifier, o.identifier, true) && ValueSetExpansionComponent.compareDeep(this.timestamp, o.timestamp, true) && ValueSetExpansionComponent.compareDeep(this.total, o.total, true) && ValueSetExpansionComponent.compareDeep(this.offset, o.offset, true) && ValueSetExpansionComponent.compareDeep(this.parameter, o.parameter, true) && ValueSetExpansionComponent.compareDeep(this.contains, o.contains, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetExpansionComponent)) {
                return false;
            }
            ValueSetExpansionComponent o = (ValueSetExpansionComponent)other_;
            return ValueSetExpansionComponent.compareValues(this.identifier, o.identifier, true) && ValueSetExpansionComponent.compareValues(this.timestamp, o.timestamp, true) && ValueSetExpansionComponent.compareValues(this.total, o.total, true) && ValueSetExpansionComponent.compareValues(this.offset, o.offset, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.timestamp, this.total, this.offset, this.parameter, this.contains});
        }

        @Override
        public String fhirType() {
            return "ValueSet.expansion";
        }
    }

    @Block
    public static class ConceptSetFilterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="property", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A property/filter defined by the code system", formalDefinition="A code that identifies a property or a filter defined in the code system.")
        protected CodeType property;
        @Child(name="op", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="= | is-a | descendent-of | is-not-a | regex | in | not-in | generalizes | exists", formalDefinition="The kind of operation to perform as a part of the filter criteria.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/filter-operator")
        protected Enumeration<FilterOperator> op;
        @Child(name="value", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Code from the system, or regex criteria, or boolean value for exists", formalDefinition="The match value may be either a code defined by the system, or a string value, which is a regex match on the literal string of the property value  (if the filter represents a property defined in CodeSystem) or of the system filter value (if the filter represents a filter defined in CodeSystem) when the operation is 'regex', or one of the values (true and false), when the operation is 'exists'.")
        protected StringType value;
        private static final long serialVersionUID = 1259153492L;

        public ConceptSetFilterComponent() {
        }

        public ConceptSetFilterComponent(CodeType property, Enumeration<FilterOperator> op, StringType value) {
            this.property = property;
            this.op = op;
            this.value = value;
        }

        public CodeType getPropertyElement() {
            if (this.property == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetFilterComponent.property");
                }
                if (Configuration.doAutoCreate()) {
                    this.property = new CodeType();
                }
            }
            return this.property;
        }

        public boolean hasPropertyElement() {
            return this.property != null && !this.property.isEmpty();
        }

        public boolean hasProperty() {
            return this.property != null && !this.property.isEmpty();
        }

        public ConceptSetFilterComponent setPropertyElement(CodeType value) {
            this.property = value;
            return this;
        }

        public String getProperty() {
            return this.property == null ? null : (String)this.property.getValue();
        }

        public ConceptSetFilterComponent setProperty(String value) {
            if (this.property == null) {
                this.property = new CodeType();
            }
            this.property.setValue(value);
            return this;
        }

        public Enumeration<FilterOperator> getOpElement() {
            if (this.op == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetFilterComponent.op");
                }
                if (Configuration.doAutoCreate()) {
                    this.op = new Enumeration<FilterOperator>(new FilterOperatorEnumFactory());
                }
            }
            return this.op;
        }

        public boolean hasOpElement() {
            return this.op != null && !this.op.isEmpty();
        }

        public boolean hasOp() {
            return this.op != null && !this.op.isEmpty();
        }

        public ConceptSetFilterComponent setOpElement(Enumeration<FilterOperator> value) {
            this.op = value;
            return this;
        }

        public FilterOperator getOp() {
            return this.op == null ? null : (FilterOperator)((Object)this.op.getValue());
        }

        public ConceptSetFilterComponent setOp(FilterOperator value) {
            if (this.op == null) {
                this.op = new Enumeration<FilterOperator>(new FilterOperatorEnumFactory());
            }
            this.op.setValue((Object)value);
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetFilterComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ConceptSetFilterComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public ConceptSetFilterComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("property", ValueSet.SP_CODE, "A code that identifies a property or a filter defined in the code system.", 0, 1, this.property));
            children.add(new Property("op", ValueSet.SP_CODE, "The kind of operation to perform as a part of the filter criteria.", 0, 1, this.op));
            children.add(new Property("value", "string", "The match value may be either a code defined by the system, or a string value, which is a regex match on the literal string of the property value  (if the filter represents a property defined in CodeSystem) or of the system filter value (if the filter represents a filter defined in CodeSystem) when the operation is 'regex', or one of the values (true and false), when the operation is 'exists'.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -993141291: {
                    return new Property("property", ValueSet.SP_CODE, "A code that identifies a property or a filter defined in the code system.", 0, 1, this.property);
                }
                case 3553: {
                    return new Property("op", ValueSet.SP_CODE, "The kind of operation to perform as a part of the filter criteria.", 0, 1, this.op);
                }
                case 111972721: {
                    return new Property("value", "string", "The match value may be either a code defined by the system, or a string value, which is a regex match on the literal string of the property value  (if the filter represents a property defined in CodeSystem) or of the system filter value (if the filter represents a filter defined in CodeSystem) when the operation is 'regex', or one of the values (true and false), when the operation is 'exists'.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    Base[] baseArray;
                    if (this.property == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.property;
                    }
                    return baseArray;
                }
                case 3553: {
                    Base[] baseArray;
                    if (this.op == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.op;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    this.property = this.castToCode(value);
                    return value;
                }
                case 3553: {
                    value = new FilterOperatorEnumFactory().fromType(this.castToCode(value));
                    this.op = value;
                    return value;
                }
                case 111972721: {
                    this.value = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("property")) {
                this.property = this.castToCode(value);
            } else if (name.equals("op")) {
                value = new FilterOperatorEnumFactory().fromType(this.castToCode(value));
                this.op = value;
            } else if (name.equals("value")) {
                this.value = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    return this.getPropertyElement();
                }
                case 3553: {
                    return this.getOpElement();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -993141291: {
                    return new String[]{ValueSet.SP_CODE};
                }
                case 3553: {
                    return new String[]{ValueSet.SP_CODE};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("property")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.property");
            }
            if (name.equals("op")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.op");
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.value");
            }
            return super.addChild(name);
        }

        @Override
        public ConceptSetFilterComponent copy() {
            ConceptSetFilterComponent dst = new ConceptSetFilterComponent();
            this.copyValues(dst);
            dst.property = this.property == null ? null : this.property.copy();
            dst.op = this.op == null ? null : this.op.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptSetFilterComponent)) {
                return false;
            }
            ConceptSetFilterComponent o = (ConceptSetFilterComponent)other_;
            return ConceptSetFilterComponent.compareDeep(this.property, o.property, true) && ConceptSetFilterComponent.compareDeep(this.op, o.op, true) && ConceptSetFilterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptSetFilterComponent)) {
                return false;
            }
            ConceptSetFilterComponent o = (ConceptSetFilterComponent)other_;
            return ConceptSetFilterComponent.compareValues(this.property, o.property, true) && ConceptSetFilterComponent.compareValues(this.op, o.op, true) && ConceptSetFilterComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.property, this.op, this.value});
        }

        @Override
        public String fhirType() {
            return "ValueSet.compose.include.filter";
        }
    }

    @Block
    public static class ConceptReferenceDesignationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="language", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human language of the designation", formalDefinition="The language this designation is defined for.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
        protected CodeType language;
        @Child(name="use", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Types of uses of designations", formalDefinition="A code that represents types of uses of designations.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/designation-use")
        protected Coding use;
        @Child(name="value", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The text value for this designation", formalDefinition="The text value for this designation.")
        protected StringType value;
        private static final long serialVersionUID = 1515662414L;

        public ConceptReferenceDesignationComponent() {
        }

        public ConceptReferenceDesignationComponent(StringType value) {
            this.value = value;
        }

        public CodeType getLanguageElement() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptReferenceDesignationComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeType();
                }
            }
            return this.language;
        }

        public boolean hasLanguageElement() {
            return this.language != null && !this.language.isEmpty();
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public ConceptReferenceDesignationComponent setLanguageElement(CodeType value) {
            this.language = value;
            return this;
        }

        public String getLanguage() {
            return this.language == null ? null : (String)this.language.getValue();
        }

        public ConceptReferenceDesignationComponent setLanguage(String value) {
            if (Utilities.noString((String)value)) {
                this.language = null;
            } else {
                if (this.language == null) {
                    this.language = new CodeType();
                }
                this.language.setValue(value);
            }
            return this;
        }

        public Coding getUse() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptReferenceDesignationComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new Coding();
                }
            }
            return this.use;
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public ConceptReferenceDesignationComponent setUse(Coding value) {
            this.use = value;
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptReferenceDesignationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ConceptReferenceDesignationComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public ConceptReferenceDesignationComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("language", ValueSet.SP_CODE, "The language this designation is defined for.", 0, 1, this.language));
            children.add(new Property("use", "Coding", "A code that represents types of uses of designations.", 0, 1, this.use));
            children.add(new Property("value", "string", "The text value for this designation.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1613589672: {
                    return new Property("language", ValueSet.SP_CODE, "The language this designation is defined for.", 0, 1, this.language);
                }
                case 116103: {
                    return new Property("use", "Coding", "A code that represents types of uses of designations.", 0, 1, this.use);
                }
                case 111972721: {
                    return new Property("value", "string", "The text value for this designation.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.language;
                    }
                    return baseArray;
                }
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.use;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    this.language = this.castToCode(value);
                    return value;
                }
                case 116103: {
                    this.use = this.castToCoding(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("language")) {
                this.language = this.castToCode(value);
            } else if (name.equals("use")) {
                this.use = this.castToCoding(value);
            } else if (name.equals("value")) {
                this.value = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return this.getLanguageElement();
                }
                case 116103: {
                    return this.getUse();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return new String[]{ValueSet.SP_CODE};
                }
                case 116103: {
                    return new String[]{"Coding"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("language")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.language");
            }
            if (name.equals("use")) {
                this.use = new Coding();
                return this.use;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.value");
            }
            return super.addChild(name);
        }

        @Override
        public ConceptReferenceDesignationComponent copy() {
            ConceptReferenceDesignationComponent dst = new ConceptReferenceDesignationComponent();
            this.copyValues(dst);
            dst.language = this.language == null ? null : this.language.copy();
            dst.use = this.use == null ? null : this.use.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptReferenceDesignationComponent)) {
                return false;
            }
            ConceptReferenceDesignationComponent o = (ConceptReferenceDesignationComponent)other_;
            return ConceptReferenceDesignationComponent.compareDeep(this.language, o.language, true) && ConceptReferenceDesignationComponent.compareDeep(this.use, o.use, true) && ConceptReferenceDesignationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptReferenceDesignationComponent)) {
                return false;
            }
            ConceptReferenceDesignationComponent o = (ConceptReferenceDesignationComponent)other_;
            return ConceptReferenceDesignationComponent.compareValues(this.language, o.language, true) && ConceptReferenceDesignationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.language, this.use, this.value});
        }

        @Override
        public String fhirType() {
            return "ValueSet.compose.include.concept.designation";
        }
    }

    @Block
    public static class ConceptReferenceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code or expression from system", formalDefinition="Specifies a code for the concept to be included or excluded.")
        protected CodeType code;
        @Child(name="display", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text to display for this code for this value set in this valueset", formalDefinition="The text to display to the user for this concept in the context of this valueset. If no display is provided, then applications using the value set use the display specified for the code by the system.")
        protected StringType display;
        @Child(name="designation", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional representations for this concept", formalDefinition="Additional representations for this concept when used in this value set - other languages, aliases, specialized purposes, used for particular purposes, etc.")
        protected List<ConceptReferenceDesignationComponent> designation;
        private static final long serialVersionUID = 260579971L;

        public ConceptReferenceComponent() {
        }

        public ConceptReferenceComponent(CodeType code) {
            this.code = code;
        }

        public CodeType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptReferenceComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ConceptReferenceComponent setCodeElement(CodeType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public ConceptReferenceComponent setCode(String value) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(value);
            return this;
        }

        public StringType getDisplayElement() {
            if (this.display == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptReferenceComponent.display");
                }
                if (Configuration.doAutoCreate()) {
                    this.display = new StringType();
                }
            }
            return this.display;
        }

        public boolean hasDisplayElement() {
            return this.display != null && !this.display.isEmpty();
        }

        public boolean hasDisplay() {
            return this.display != null && !this.display.isEmpty();
        }

        public ConceptReferenceComponent setDisplayElement(StringType value) {
            this.display = value;
            return this;
        }

        public String getDisplay() {
            return this.display == null ? null : (String)this.display.getValue();
        }

        public ConceptReferenceComponent setDisplay(String value) {
            if (Utilities.noString((String)value)) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(value);
            }
            return this;
        }

        public List<ConceptReferenceDesignationComponent> getDesignation() {
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptReferenceDesignationComponent>();
            }
            return this.designation;
        }

        public ConceptReferenceComponent setDesignation(List<ConceptReferenceDesignationComponent> theDesignation) {
            this.designation = theDesignation;
            return this;
        }

        public boolean hasDesignation() {
            if (this.designation == null) {
                return false;
            }
            for (ConceptReferenceDesignationComponent item : this.designation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptReferenceDesignationComponent addDesignation() {
            ConceptReferenceDesignationComponent t = new ConceptReferenceDesignationComponent();
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptReferenceDesignationComponent>();
            }
            this.designation.add(t);
            return t;
        }

        public ConceptReferenceComponent addDesignation(ConceptReferenceDesignationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.designation == null) {
                this.designation = new ArrayList<ConceptReferenceDesignationComponent>();
            }
            this.designation.add(t);
            return this;
        }

        public ConceptReferenceDesignationComponent getDesignationFirstRep() {
            if (this.getDesignation().isEmpty()) {
                this.addDesignation();
            }
            return this.getDesignation().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "Specifies a code for the concept to be included or excluded.", 0, 1, this.code));
            children.add(new Property("display", "string", "The text to display to the user for this concept in the context of this valueset. If no display is provided, then applications using the value set use the display specified for the code by the system.", 0, 1, this.display));
            children.add(new Property("designation", "", "Additional representations for this concept when used in this value set - other languages, aliases, specialized purposes, used for particular purposes, etc.", 0, Integer.MAX_VALUE, this.designation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(ValueSet.SP_CODE, ValueSet.SP_CODE, "Specifies a code for the concept to be included or excluded.", 0, 1, this.code);
                }
                case 1671764162: {
                    return new Property("display", "string", "The text to display to the user for this concept in the context of this valueset. If no display is provided, then applications using the value set use the display specified for the code by the system.", 0, 1, this.display);
                }
                case -900931593: {
                    return new Property("designation", "", "Additional representations for this concept when used in this value set - other languages, aliases, specialized purposes, used for particular purposes, etc.", 0, Integer.MAX_VALUE, this.designation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1671764162: {
                    Base[] baseArray;
                    if (this.display == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.display;
                    }
                    return baseArray;
                }
                case -900931593: {
                    return this.designation == null ? new Base[]{} : this.designation.toArray(new Base[this.designation.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCode(value);
                    return value;
                }
                case 1671764162: {
                    this.display = this.castToString(value);
                    return value;
                }
                case -900931593: {
                    this.getDesignation().add((ConceptReferenceDesignationComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                this.code = this.castToCode(value);
            } else if (name.equals("display")) {
                this.display = this.castToString(value);
            } else if (name.equals("designation")) {
                this.getDesignation().add((ConceptReferenceDesignationComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1671764162: {
                    return this.getDisplayElement();
                }
                case -900931593: {
                    return this.addDesignation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{ValueSet.SP_CODE};
                }
                case 1671764162: {
                    return new String[]{"string"};
                }
                case -900931593: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ValueSet.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.code");
            }
            if (name.equals("display")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.display");
            }
            if (name.equals("designation")) {
                return this.addDesignation();
            }
            return super.addChild(name);
        }

        @Override
        public ConceptReferenceComponent copy() {
            ConceptReferenceComponent dst = new ConceptReferenceComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            StringType stringType = dst.display = this.display == null ? null : this.display.copy();
            if (this.designation != null) {
                dst.designation = new ArrayList<ConceptReferenceDesignationComponent>();
                for (ConceptReferenceDesignationComponent i : this.designation) {
                    dst.designation.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptReferenceComponent)) {
                return false;
            }
            ConceptReferenceComponent o = (ConceptReferenceComponent)other_;
            return ConceptReferenceComponent.compareDeep(this.code, o.code, true) && ConceptReferenceComponent.compareDeep(this.display, o.display, true) && ConceptReferenceComponent.compareDeep(this.designation, o.designation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptReferenceComponent)) {
                return false;
            }
            ConceptReferenceComponent o = (ConceptReferenceComponent)other_;
            return ConceptReferenceComponent.compareValues(this.code, o.code, true) && ConceptReferenceComponent.compareValues(this.display, o.display, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.display, this.designation});
        }

        @Override
        public String fhirType() {
            return "ValueSet.compose.include.concept";
        }
    }

    @Block
    public static class ConceptSetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="system", type={UriType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The system the codes come from", formalDefinition="An absolute URI which is the code system from which the selected codes come from.")
        protected UriType system;
        @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific version of the code system referred to", formalDefinition="The version of the code system that the codes are selected from, or the special version \"*\" for all versions.")
        protected StringType version;
        @Child(name="concept", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A concept defined in the system", formalDefinition="Specifies a concept to be included or excluded.")
        protected List<ConceptReferenceComponent> concept;
        @Child(name="filter", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Select codes/concepts by their properties (including relationships)", formalDefinition="Select concepts by specify a matching criterion based on the properties (including relationships) defined by the system, or on filters defined by the system. If multiple filters are specified, they SHALL all be true.")
        protected List<ConceptSetFilterComponent> filter;
        @Child(name="valueSet", type={CanonicalType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Select the contents included in this value set", formalDefinition="Selects the concepts found in this value set (based on its value set definition). This is an absolute URI that is a reference to ValueSet.url.  If multiple value sets are specified this includes the union of the contents of all of the referenced value sets.")
        protected List<CanonicalType> valueSet;
        private static final long serialVersionUID = 969391146L;

        public UriType getSystemElement() {
            if (this.system == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetComponent.system");
                }
                if (Configuration.doAutoCreate()) {
                    this.system = new UriType();
                }
            }
            return this.system;
        }

        public boolean hasSystemElement() {
            return this.system != null && !this.system.isEmpty();
        }

        public boolean hasSystem() {
            return this.system != null && !this.system.isEmpty();
        }

        public ConceptSetComponent setSystemElement(UriType value) {
            this.system = value;
            return this;
        }

        public String getSystem() {
            return this.system == null ? null : (String)this.system.getValue();
        }

        public ConceptSetComponent setSystem(String value) {
            if (Utilities.noString((String)value)) {
                this.system = null;
            } else {
                if (this.system == null) {
                    this.system = new UriType();
                }
                this.system.setValue(value);
            }
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConceptSetComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public ConceptSetComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public ConceptSetComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public List<ConceptReferenceComponent> getConcept() {
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptReferenceComponent>();
            }
            return this.concept;
        }

        public ConceptSetComponent setConcept(List<ConceptReferenceComponent> theConcept) {
            this.concept = theConcept;
            return this;
        }

        public boolean hasConcept() {
            if (this.concept == null) {
                return false;
            }
            for (ConceptReferenceComponent item : this.concept) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptReferenceComponent addConcept() {
            ConceptReferenceComponent t = new ConceptReferenceComponent();
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptReferenceComponent>();
            }
            this.concept.add(t);
            return t;
        }

        public ConceptSetComponent addConcept(ConceptReferenceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.concept == null) {
                this.concept = new ArrayList<ConceptReferenceComponent>();
            }
            this.concept.add(t);
            return this;
        }

        public ConceptReferenceComponent getConceptFirstRep() {
            if (this.getConcept().isEmpty()) {
                this.addConcept();
            }
            return this.getConcept().get(0);
        }

        public List<ConceptSetFilterComponent> getFilter() {
            if (this.filter == null) {
                this.filter = new ArrayList<ConceptSetFilterComponent>();
            }
            return this.filter;
        }

        public ConceptSetComponent setFilter(List<ConceptSetFilterComponent> theFilter) {
            this.filter = theFilter;
            return this;
        }

        public boolean hasFilter() {
            if (this.filter == null) {
                return false;
            }
            for (ConceptSetFilterComponent item : this.filter) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptSetFilterComponent addFilter() {
            ConceptSetFilterComponent t = new ConceptSetFilterComponent();
            if (this.filter == null) {
                this.filter = new ArrayList<ConceptSetFilterComponent>();
            }
            this.filter.add(t);
            return t;
        }

        public ConceptSetComponent addFilter(ConceptSetFilterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.filter == null) {
                this.filter = new ArrayList<ConceptSetFilterComponent>();
            }
            this.filter.add(t);
            return this;
        }

        public ConceptSetFilterComponent getFilterFirstRep() {
            if (this.getFilter().isEmpty()) {
                this.addFilter();
            }
            return this.getFilter().get(0);
        }

        public List<CanonicalType> getValueSet() {
            if (this.valueSet == null) {
                this.valueSet = new ArrayList<CanonicalType>();
            }
            return this.valueSet;
        }

        public ConceptSetComponent setValueSet(List<CanonicalType> theValueSet) {
            this.valueSet = theValueSet;
            return this;
        }

        public boolean hasValueSet() {
            if (this.valueSet == null) {
                return false;
            }
            for (CanonicalType item : this.valueSet) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CanonicalType addValueSetElement() {
            CanonicalType t = new CanonicalType();
            if (this.valueSet == null) {
                this.valueSet = new ArrayList<CanonicalType>();
            }
            this.valueSet.add(t);
            return t;
        }

        public ConceptSetComponent addValueSet(String value) {
            CanonicalType t = new CanonicalType();
            t.setValue(value);
            if (this.valueSet == null) {
                this.valueSet = new ArrayList<CanonicalType>();
            }
            this.valueSet.add(t);
            return this;
        }

        public boolean hasValueSet(String value) {
            if (this.valueSet == null) {
                return false;
            }
            for (CanonicalType v : this.valueSet) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("system", "uri", "An absolute URI which is the code system from which the selected codes come from.", 0, 1, this.system));
            children.add(new Property(ValueSet.SP_VERSION, "string", "The version of the code system that the codes are selected from, or the special version \"*\" for all versions.", 0, 1, this.version));
            children.add(new Property("concept", "", "Specifies a concept to be included or excluded.", 0, Integer.MAX_VALUE, this.concept));
            children.add(new Property("filter", "", "Select concepts by specify a matching criterion based on the properties (including relationships) defined by the system, or on filters defined by the system. If multiple filters are specified, they SHALL all be true.", 0, Integer.MAX_VALUE, this.filter));
            children.add(new Property("valueSet", "canonical(ValueSet)", "Selects the concepts found in this value set (based on its value set definition). This is an absolute URI that is a reference to ValueSet.url.  If multiple value sets are specified this includes the union of the contents of all of the referenced value sets.", 0, Integer.MAX_VALUE, this.valueSet));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -887328209: {
                    return new Property("system", "uri", "An absolute URI which is the code system from which the selected codes come from.", 0, 1, this.system);
                }
                case 351608024: {
                    return new Property(ValueSet.SP_VERSION, "string", "The version of the code system that the codes are selected from, or the special version \"*\" for all versions.", 0, 1, this.version);
                }
                case 951024232: {
                    return new Property("concept", "", "Specifies a concept to be included or excluded.", 0, Integer.MAX_VALUE, this.concept);
                }
                case -1274492040: {
                    return new Property("filter", "", "Select concepts by specify a matching criterion based on the properties (including relationships) defined by the system, or on filters defined by the system. If multiple filters are specified, they SHALL all be true.", 0, Integer.MAX_VALUE, this.filter);
                }
                case -1410174671: {
                    return new Property("valueSet", "canonical(ValueSet)", "Selects the concepts found in this value set (based on its value set definition). This is an absolute URI that is a reference to ValueSet.url.  If multiple value sets are specified this includes the union of the contents of all of the referenced value sets.", 0, Integer.MAX_VALUE, this.valueSet);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    Base[] baseArray;
                    if (this.system == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.system;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.version;
                    }
                    return baseArray;
                }
                case 951024232: {
                    return this.concept == null ? new Base[]{} : this.concept.toArray(new Base[this.concept.size()]);
                }
                case -1274492040: {
                    return this.filter == null ? new Base[]{} : this.filter.toArray(new Base[this.filter.size()]);
                }
                case -1410174671: {
                    return this.valueSet == null ? new Base[]{} : this.valueSet.toArray(new Base[this.valueSet.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    this.system = this.castToUri(value);
                    return value;
                }
                case 351608024: {
                    this.version = this.castToString(value);
                    return value;
                }
                case 951024232: {
                    this.getConcept().add((ConceptReferenceComponent)value);
                    return value;
                }
                case -1274492040: {
                    this.getFilter().add((ConceptSetFilterComponent)value);
                    return value;
                }
                case -1410174671: {
                    this.getValueSet().add(this.castToCanonical(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("system")) {
                this.system = this.castToUri(value);
            } else if (name.equals(ValueSet.SP_VERSION)) {
                this.version = this.castToString(value);
            } else if (name.equals("concept")) {
                this.getConcept().add((ConceptReferenceComponent)value);
            } else if (name.equals("filter")) {
                this.getFilter().add((ConceptSetFilterComponent)value);
            } else if (name.equals("valueSet")) {
                this.getValueSet().add(this.castToCanonical(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    return this.getSystemElement();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
                case 951024232: {
                    return this.addConcept();
                }
                case -1274492040: {
                    return this.addFilter();
                }
                case -1410174671: {
                    return this.addValueSetElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -887328209: {
                    return new String[]{"uri"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
                case 951024232: {
                    return new String[0];
                }
                case -1274492040: {
                    return new String[0];
                }
                case -1410174671: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("system")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.system");
            }
            if (name.equals(ValueSet.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.version");
            }
            if (name.equals("concept")) {
                return this.addConcept();
            }
            if (name.equals("filter")) {
                return this.addFilter();
            }
            if (name.equals("valueSet")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.valueSet");
            }
            return super.addChild(name);
        }

        @Override
        public ConceptSetComponent copy() {
            ConceptSetComponent dst = new ConceptSetComponent();
            this.copyValues(dst);
            dst.system = this.system == null ? null : this.system.copy();
            StringType stringType = dst.version = this.version == null ? null : this.version.copy();
            if (this.concept != null) {
                dst.concept = new ArrayList<ConceptReferenceComponent>();
                for (ConceptReferenceComponent conceptReferenceComponent : this.concept) {
                    dst.concept.add(conceptReferenceComponent.copy());
                }
            }
            if (this.filter != null) {
                dst.filter = new ArrayList<ConceptSetFilterComponent>();
                for (ConceptSetFilterComponent conceptSetFilterComponent : this.filter) {
                    dst.filter.add(conceptSetFilterComponent.copy());
                }
            }
            if (this.valueSet != null) {
                dst.valueSet = new ArrayList<CanonicalType>();
                for (CanonicalType canonicalType : this.valueSet) {
                    dst.valueSet.add(canonicalType.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptSetComponent)) {
                return false;
            }
            ConceptSetComponent o = (ConceptSetComponent)other_;
            return ConceptSetComponent.compareDeep(this.system, o.system, true) && ConceptSetComponent.compareDeep(this.version, o.version, true) && ConceptSetComponent.compareDeep(this.concept, o.concept, true) && ConceptSetComponent.compareDeep(this.filter, o.filter, true) && ConceptSetComponent.compareDeep(this.valueSet, o.valueSet, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConceptSetComponent)) {
                return false;
            }
            ConceptSetComponent o = (ConceptSetComponent)other_;
            return ConceptSetComponent.compareValues(this.system, o.system, true) && ConceptSetComponent.compareValues(this.version, o.version, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.system, this.version, this.concept, this.filter, this.valueSet});
        }

        @Override
        public String fhirType() {
            return "ValueSet.compose.include";
        }
    }

    @Block
    public static class ValueSetComposeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="lockedDate", type={DateType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Fixed date for references with no specified version (transitive)", formalDefinition="The Locked Date is  the effective date that is used to determine the version of all referenced Code Systems and Value Set Definitions included in the compose that are not already tied to a specific version.")
        protected DateType lockedDate;
        @Child(name="inactive", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Whether inactive codes are in the value set", formalDefinition="Whether inactive codes - codes that are not approved for current use - are in the value set. If inactive = true, inactive codes are to be included in the expansion, if inactive = false, the inactive codes will not be included in the expansion. If absent, the behavior is determined by the implementation, or by the applicable $expand parameters (but generally, inactive codes would be expected to be included).")
        protected BooleanType inactive;
        @Child(name="include", type={}, order=3, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Include one or more codes from a code system or other value set(s)", formalDefinition="Include one or more codes from a code system or other value set(s).")
        protected List<ConceptSetComponent> include;
        @Child(name="exclude", type={ConceptSetComponent.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Explicitly exclude codes from a code system or other value sets", formalDefinition="Exclude one or more codes from the value set based on code system filters and/or other value sets.")
        protected List<ConceptSetComponent> exclude;
        private static final long serialVersionUID = -765941757L;

        public DateType getLockedDateElement() {
            if (this.lockedDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetComposeComponent.lockedDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.lockedDate = new DateType();
                }
            }
            return this.lockedDate;
        }

        public boolean hasLockedDateElement() {
            return this.lockedDate != null && !this.lockedDate.isEmpty();
        }

        public boolean hasLockedDate() {
            return this.lockedDate != null && !this.lockedDate.isEmpty();
        }

        public ValueSetComposeComponent setLockedDateElement(DateType value) {
            this.lockedDate = value;
            return this;
        }

        public Date getLockedDate() {
            return this.lockedDate == null ? null : (Date)this.lockedDate.getValue();
        }

        public ValueSetComposeComponent setLockedDate(Date value) {
            if (value == null) {
                this.lockedDate = null;
            } else {
                if (this.lockedDate == null) {
                    this.lockedDate = new DateType();
                }
                this.lockedDate.setValue(value);
            }
            return this;
        }

        public BooleanType getInactiveElement() {
            if (this.inactive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValueSetComposeComponent.inactive");
                }
                if (Configuration.doAutoCreate()) {
                    this.inactive = new BooleanType();
                }
            }
            return this.inactive;
        }

        public boolean hasInactiveElement() {
            return this.inactive != null && !this.inactive.isEmpty();
        }

        public boolean hasInactive() {
            return this.inactive != null && !this.inactive.isEmpty();
        }

        public ValueSetComposeComponent setInactiveElement(BooleanType value) {
            this.inactive = value;
            return this;
        }

        public boolean getInactive() {
            return this.inactive == null || this.inactive.isEmpty() ? false : (Boolean)this.inactive.getValue();
        }

        public ValueSetComposeComponent setInactive(boolean value) {
            if (this.inactive == null) {
                this.inactive = new BooleanType();
            }
            this.inactive.setValue((Object)value);
            return this;
        }

        public List<ConceptSetComponent> getInclude() {
            if (this.include == null) {
                this.include = new ArrayList<ConceptSetComponent>();
            }
            return this.include;
        }

        public ValueSetComposeComponent setInclude(List<ConceptSetComponent> theInclude) {
            this.include = theInclude;
            return this;
        }

        public boolean hasInclude() {
            if (this.include == null) {
                return false;
            }
            for (ConceptSetComponent item : this.include) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptSetComponent addInclude() {
            ConceptSetComponent t = new ConceptSetComponent();
            if (this.include == null) {
                this.include = new ArrayList<ConceptSetComponent>();
            }
            this.include.add(t);
            return t;
        }

        public ValueSetComposeComponent addInclude(ConceptSetComponent t) {
            if (t == null) {
                return this;
            }
            if (this.include == null) {
                this.include = new ArrayList<ConceptSetComponent>();
            }
            this.include.add(t);
            return this;
        }

        public ConceptSetComponent getIncludeFirstRep() {
            if (this.getInclude().isEmpty()) {
                this.addInclude();
            }
            return this.getInclude().get(0);
        }

        public List<ConceptSetComponent> getExclude() {
            if (this.exclude == null) {
                this.exclude = new ArrayList<ConceptSetComponent>();
            }
            return this.exclude;
        }

        public ValueSetComposeComponent setExclude(List<ConceptSetComponent> theExclude) {
            this.exclude = theExclude;
            return this;
        }

        public boolean hasExclude() {
            if (this.exclude == null) {
                return false;
            }
            for (ConceptSetComponent item : this.exclude) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ConceptSetComponent addExclude() {
            ConceptSetComponent t = new ConceptSetComponent();
            if (this.exclude == null) {
                this.exclude = new ArrayList<ConceptSetComponent>();
            }
            this.exclude.add(t);
            return t;
        }

        public ValueSetComposeComponent addExclude(ConceptSetComponent t) {
            if (t == null) {
                return this;
            }
            if (this.exclude == null) {
                this.exclude = new ArrayList<ConceptSetComponent>();
            }
            this.exclude.add(t);
            return this;
        }

        public ConceptSetComponent getExcludeFirstRep() {
            if (this.getExclude().isEmpty()) {
                this.addExclude();
            }
            return this.getExclude().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("lockedDate", ValueSet.SP_DATE, "The Locked Date is  the effective date that is used to determine the version of all referenced Code Systems and Value Set Definitions included in the compose that are not already tied to a specific version.", 0, 1, this.lockedDate));
            children.add(new Property("inactive", "boolean", "Whether inactive codes - codes that are not approved for current use - are in the value set. If inactive = true, inactive codes are to be included in the expansion, if inactive = false, the inactive codes will not be included in the expansion. If absent, the behavior is determined by the implementation, or by the applicable $expand parameters (but generally, inactive codes would be expected to be included).", 0, 1, this.inactive));
            children.add(new Property("include", "", "Include one or more codes from a code system or other value set(s).", 0, Integer.MAX_VALUE, this.include));
            children.add(new Property("exclude", "@ValueSet.compose.include", "Exclude one or more codes from the value set based on code system filters and/or other value sets.", 0, Integer.MAX_VALUE, this.exclude));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1391591896: {
                    return new Property("lockedDate", ValueSet.SP_DATE, "The Locked Date is  the effective date that is used to determine the version of all referenced Code Systems and Value Set Definitions included in the compose that are not already tied to a specific version.", 0, 1, this.lockedDate);
                }
                case 24665195: {
                    return new Property("inactive", "boolean", "Whether inactive codes - codes that are not approved for current use - are in the value set. If inactive = true, inactive codes are to be included in the expansion, if inactive = false, the inactive codes will not be included in the expansion. If absent, the behavior is determined by the implementation, or by the applicable $expand parameters (but generally, inactive codes would be expected to be included).", 0, 1, this.inactive);
                }
                case 1942574248: {
                    return new Property("include", "", "Include one or more codes from a code system or other value set(s).", 0, Integer.MAX_VALUE, this.include);
                }
                case -1321148966: {
                    return new Property("exclude", "@ValueSet.compose.include", "Exclude one or more codes from the value set based on code system filters and/or other value sets.", 0, Integer.MAX_VALUE, this.exclude);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1391591896: {
                    Base[] baseArray;
                    if (this.lockedDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.lockedDate;
                    }
                    return baseArray;
                }
                case 24665195: {
                    Base[] baseArray;
                    if (this.inactive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.inactive;
                    }
                    return baseArray;
                }
                case 1942574248: {
                    return this.include == null ? new Base[]{} : this.include.toArray(new Base[this.include.size()]);
                }
                case -1321148966: {
                    return this.exclude == null ? new Base[]{} : this.exclude.toArray(new Base[this.exclude.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1391591896: {
                    this.lockedDate = this.castToDate(value);
                    return value;
                }
                case 24665195: {
                    this.inactive = this.castToBoolean(value);
                    return value;
                }
                case 1942574248: {
                    this.getInclude().add((ConceptSetComponent)value);
                    return value;
                }
                case -1321148966: {
                    this.getExclude().add((ConceptSetComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("lockedDate")) {
                this.lockedDate = this.castToDate(value);
            } else if (name.equals("inactive")) {
                this.inactive = this.castToBoolean(value);
            } else if (name.equals("include")) {
                this.getInclude().add((ConceptSetComponent)value);
            } else if (name.equals("exclude")) {
                this.getExclude().add((ConceptSetComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1391591896: {
                    return this.getLockedDateElement();
                }
                case 24665195: {
                    return this.getInactiveElement();
                }
                case 1942574248: {
                    return this.addInclude();
                }
                case -1321148966: {
                    return this.addExclude();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1391591896: {
                    return new String[]{ValueSet.SP_DATE};
                }
                case 24665195: {
                    return new String[]{"boolean"};
                }
                case 1942574248: {
                    return new String[0];
                }
                case -1321148966: {
                    return new String[]{"@ValueSet.compose.include"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("lockedDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.lockedDate");
            }
            if (name.equals("inactive")) {
                throw new FHIRException("Cannot call addChild on a primitive type ValueSet.inactive");
            }
            if (name.equals("include")) {
                return this.addInclude();
            }
            if (name.equals("exclude")) {
                return this.addExclude();
            }
            return super.addChild(name);
        }

        @Override
        public ValueSetComposeComponent copy() {
            ValueSetComposeComponent dst = new ValueSetComposeComponent();
            this.copyValues(dst);
            dst.lockedDate = this.lockedDate == null ? null : this.lockedDate.copy();
            BooleanType booleanType = dst.inactive = this.inactive == null ? null : this.inactive.copy();
            if (this.include != null) {
                dst.include = new ArrayList<ConceptSetComponent>();
                for (ConceptSetComponent i : this.include) {
                    dst.include.add(i.copy());
                }
            }
            if (this.exclude != null) {
                dst.exclude = new ArrayList<ConceptSetComponent>();
                for (ConceptSetComponent i : this.exclude) {
                    dst.exclude.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetComposeComponent)) {
                return false;
            }
            ValueSetComposeComponent o = (ValueSetComposeComponent)other_;
            return ValueSetComposeComponent.compareDeep(this.lockedDate, o.lockedDate, true) && ValueSetComposeComponent.compareDeep(this.inactive, o.inactive, true) && ValueSetComposeComponent.compareDeep(this.include, o.include, true) && ValueSetComposeComponent.compareDeep(this.exclude, o.exclude, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ValueSetComposeComponent)) {
                return false;
            }
            ValueSetComposeComponent o = (ValueSetComposeComponent)other_;
            return ValueSetComposeComponent.compareValues(this.lockedDate, o.lockedDate, true) && ValueSetComposeComponent.compareValues(this.inactive, o.inactive, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.lockedDate, this.inactive, this.include, this.exclude});
        }

        @Override
        public String fhirType() {
            return "ValueSet.compose";
        }
    }

    public static class FilterOperatorEnumFactory
    implements EnumFactory<FilterOperator> {
        @Override
        public FilterOperator fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("=".equals(codeString)) {
                return FilterOperator.EQUAL;
            }
            if ("is-a".equals(codeString)) {
                return FilterOperator.ISA;
            }
            if ("descendent-of".equals(codeString)) {
                return FilterOperator.DESCENDENTOF;
            }
            if ("is-not-a".equals(codeString)) {
                return FilterOperator.ISNOTA;
            }
            if ("regex".equals(codeString)) {
                return FilterOperator.REGEX;
            }
            if ("in".equals(codeString)) {
                return FilterOperator.IN;
            }
            if ("not-in".equals(codeString)) {
                return FilterOperator.NOTIN;
            }
            if ("generalizes".equals(codeString)) {
                return FilterOperator.GENERALIZES;
            }
            if ("exists".equals(codeString)) {
                return FilterOperator.EXISTS;
            }
            throw new IllegalArgumentException("Unknown FilterOperator code '" + codeString + "'");
        }

        public Enumeration<FilterOperator> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<FilterOperator>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("=".equals(codeString)) {
                return new Enumeration<FilterOperator>(this, FilterOperator.EQUAL);
            }
            if ("is-a".equals(codeString)) {
                return new Enumeration<FilterOperator>(this, FilterOperator.ISA);
            }
            if ("descendent-of".equals(codeString)) {
                return new Enumeration<FilterOperator>(this, FilterOperator.DESCENDENTOF);
            }
            if ("is-not-a".equals(codeString)) {
                return new Enumeration<FilterOperator>(this, FilterOperator.ISNOTA);
            }
            if ("regex".equals(codeString)) {
                return new Enumeration<FilterOperator>(this, FilterOperator.REGEX);
            }
            if ("in".equals(codeString)) {
                return new Enumeration<FilterOperator>(this, FilterOperator.IN);
            }
            if ("not-in".equals(codeString)) {
                return new Enumeration<FilterOperator>(this, FilterOperator.NOTIN);
            }
            if ("generalizes".equals(codeString)) {
                return new Enumeration<FilterOperator>(this, FilterOperator.GENERALIZES);
            }
            if ("exists".equals(codeString)) {
                return new Enumeration<FilterOperator>(this, FilterOperator.EXISTS);
            }
            throw new FHIRException("Unknown FilterOperator code '" + codeString + "'");
        }

        @Override
        public String toCode(FilterOperator code) {
            if (code == FilterOperator.EQUAL) {
                return "=";
            }
            if (code == FilterOperator.ISA) {
                return "is-a";
            }
            if (code == FilterOperator.DESCENDENTOF) {
                return "descendent-of";
            }
            if (code == FilterOperator.ISNOTA) {
                return "is-not-a";
            }
            if (code == FilterOperator.REGEX) {
                return "regex";
            }
            if (code == FilterOperator.IN) {
                return "in";
            }
            if (code == FilterOperator.NOTIN) {
                return "not-in";
            }
            if (code == FilterOperator.GENERALIZES) {
                return "generalizes";
            }
            if (code == FilterOperator.EXISTS) {
                return "exists";
            }
            return "?";
        }

        @Override
        public String toSystem(FilterOperator code) {
            return code.getSystem();
        }
    }

    public static enum FilterOperator {
        EQUAL,
        ISA,
        DESCENDENTOF,
        ISNOTA,
        REGEX,
        IN,
        NOTIN,
        GENERALIZES,
        EXISTS,
        NULL;


        public static FilterOperator fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("=".equals(codeString)) {
                return EQUAL;
            }
            if ("is-a".equals(codeString)) {
                return ISA;
            }
            if ("descendent-of".equals(codeString)) {
                return DESCENDENTOF;
            }
            if ("is-not-a".equals(codeString)) {
                return ISNOTA;
            }
            if ("regex".equals(codeString)) {
                return REGEX;
            }
            if ("in".equals(codeString)) {
                return IN;
            }
            if ("not-in".equals(codeString)) {
                return NOTIN;
            }
            if ("generalizes".equals(codeString)) {
                return GENERALIZES;
            }
            if ("exists".equals(codeString)) {
                return EXISTS;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown FilterOperator code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EQUAL: {
                    return "=";
                }
                case ISA: {
                    return "is-a";
                }
                case DESCENDENTOF: {
                    return "descendent-of";
                }
                case ISNOTA: {
                    return "is-not-a";
                }
                case REGEX: {
                    return "regex";
                }
                case IN: {
                    return "in";
                }
                case NOTIN: {
                    return "not-in";
                }
                case GENERALIZES: {
                    return "generalizes";
                }
                case EXISTS: {
                    return "exists";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EQUAL: {
                    return "http://hl7.org/fhir/filter-operator";
                }
                case ISA: {
                    return "http://hl7.org/fhir/filter-operator";
                }
                case DESCENDENTOF: {
                    return "http://hl7.org/fhir/filter-operator";
                }
                case ISNOTA: {
                    return "http://hl7.org/fhir/filter-operator";
                }
                case REGEX: {
                    return "http://hl7.org/fhir/filter-operator";
                }
                case IN: {
                    return "http://hl7.org/fhir/filter-operator";
                }
                case NOTIN: {
                    return "http://hl7.org/fhir/filter-operator";
                }
                case GENERALIZES: {
                    return "http://hl7.org/fhir/filter-operator";
                }
                case EXISTS: {
                    return "http://hl7.org/fhir/filter-operator";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EQUAL: {
                    return "The specified property of the code equals the provided value.";
                }
                case ISA: {
                    return "Includes all concept ids that have a transitive is-a relationship with the concept Id provided as the value, including the provided concept itself (include descendant codes and self).";
                }
                case DESCENDENTOF: {
                    return "Includes all concept ids that have a transitive is-a relationship with the concept Id provided as the value, excluding the provided concept itself i.e. include descendant codes only).";
                }
                case ISNOTA: {
                    return "The specified property of the code does not have an is-a relationship with the provided value.";
                }
                case REGEX: {
                    return "The specified property of the code  matches the regex specified in the provided value.";
                }
                case IN: {
                    return "The specified property of the code is in the set of codes or concepts specified in the provided value (comma separated list).";
                }
                case NOTIN: {
                    return "The specified property of the code is not in the set of codes or concepts specified in the provided value (comma separated list).";
                }
                case GENERALIZES: {
                    return "Includes all concept ids that have a transitive is-a relationship from the concept Id provided as the value, including the provided concept itself (i.e. include ancestor codes and self).";
                }
                case EXISTS: {
                    return "The specified property of the code has at least one value (if the specified value is true; if the specified value is false, then matches when the specified property of the code has no values).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EQUAL: {
                    return "Equals";
                }
                case ISA: {
                    return "Is A (by subsumption)";
                }
                case DESCENDENTOF: {
                    return "Descendent Of (by subsumption)";
                }
                case ISNOTA: {
                    return "Not (Is A) (by subsumption)";
                }
                case REGEX: {
                    return "Regular Expression";
                }
                case IN: {
                    return "In Set";
                }
                case NOTIN: {
                    return "Not in Set";
                }
                case GENERALIZES: {
                    return "Generalizes (by Subsumption)";
                }
                case EXISTS: {
                    return "Exists";
                }
            }
            return "?";
        }
    }
}

