/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AllergyintoleranceVerification {
    UNCONFIRMED,
    PRESUMED,
    CONFIRMED,
    REFUTED,
    ENTEREDINERROR,
    NULL;


    public static AllergyintoleranceVerification fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("unconfirmed".equals(codeString)) {
            return UNCONFIRMED;
        }
        if ("presumed".equals(codeString)) {
            return PRESUMED;
        }
        if ("confirmed".equals(codeString)) {
            return CONFIRMED;
        }
        if ("refuted".equals(codeString)) {
            return REFUTED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown AllergyintoleranceVerification code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case UNCONFIRMED: {
                return "unconfirmed";
            }
            case PRESUMED: {
                return "presumed";
            }
            case CONFIRMED: {
                return "confirmed";
            }
            case REFUTED: {
                return "refuted";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification";
    }

    public String getDefinition() {
        switch (this) {
            case UNCONFIRMED: {
                return "The propensity for a reaction to the identified substance has not been objectively verified.";
            }
            case PRESUMED: {
                return "The available clinical information supports a high liklihood of the propensity for a reaction to the identified substance.";
            }
            case CONFIRMED: {
                return "The propensity for a reaction to the identified substance has been objectively verified (which may include clinical evidence by testing, rechallenge, or observation).";
            }
            case REFUTED: {
                return "A propensity for a reaction to the identified substance has been disputed or disproven with a sufficient level of clinical certainty to justify invalidating the assertion. This might or might not include testing or rechallenge.";
            }
            case ENTEREDINERROR: {
                return "The statement was entered in error and is not valid.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case UNCONFIRMED: {
                return "Unconfirmed";
            }
            case PRESUMED: {
                return "Presumed";
            }
            case CONFIRMED: {
                return "Confirmed";
            }
            case REFUTED: {
                return "Refuted";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
        }
        return "?";
    }
}

