/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum BenefitUnit {
    INDIVIDUAL,
    FAMILY,
    NULL;


    public static BenefitUnit fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("individual".equals(codeString)) {
            return INDIVIDUAL;
        }
        if ("family".equals(codeString)) {
            return FAMILY;
        }
        throw new FHIRException("Unknown BenefitUnit code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INDIVIDUAL: {
                return "individual";
            }
            case FAMILY: {
                return "family";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/benefit-unit";
    }

    public String getDefinition() {
        switch (this) {
            case INDIVIDUAL: {
                return "A single individual";
            }
            case FAMILY: {
                return "A family, typically includes self, spouse(s) and children to a defined age";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INDIVIDUAL: {
                return "Individual";
            }
            case FAMILY: {
                return "Family";
            }
        }
        return "?";
    }
}

