/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractAssettype {
    PARTICIPATION,
    NULL;


    public static ContractAssettype fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("participation".equals(codeString)) {
            return PARTICIPATION;
        }
        throw new FHIRException("Unknown ContractAssettype code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PARTICIPATION: {
                return "participation";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contract-asset-type";
    }

    public String getDefinition() {
        switch (this) {
            case PARTICIPATION: {
                return "To be completed";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PARTICIPATION: {
                return "Participation";
            }
        }
        return "?";
    }
}

