/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EligibilityrequestPurpose {
    AUTHREQUIREMENTS,
    BENEFITS,
    DISCOVERY,
    VALIDATION,
    NULL;


    public static EligibilityrequestPurpose fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("auth-requirements".equals(codeString)) {
            return AUTHREQUIREMENTS;
        }
        if ("benefits".equals(codeString)) {
            return BENEFITS;
        }
        if ("discovery".equals(codeString)) {
            return DISCOVERY;
        }
        if ("validation".equals(codeString)) {
            return VALIDATION;
        }
        throw new FHIRException("Unknown EligibilityrequestPurpose code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AUTHREQUIREMENTS: {
                return "auth-requirements";
            }
            case BENEFITS: {
                return "benefits";
            }
            case DISCOVERY: {
                return "discovery";
            }
            case VALIDATION: {
                return "validation";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/eligibilityrequest-purpose";
    }

    public String getDefinition() {
        switch (this) {
            case AUTHREQUIREMENTS: {
                return "The prior authorization requirements for the listed, or discovered if specified, converages for the categories of service and/or specifed biling codes are requested.";
            }
            case BENEFITS: {
                return "The plan benefits and optionally benefits consumed  for the listed, or discovered if specified, converages are requested.";
            }
            case DISCOVERY: {
                return "The insurer is requested to report on any coverages which they are aware of in addition to any specifed.";
            }
            case VALIDATION: {
                return "A check that the specified coverages are in-force is requested.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AUTHREQUIREMENTS: {
                return "Coverage auth-requirements";
            }
            case BENEFITS: {
                return "Coverage benefits";
            }
            case DISCOVERY: {
                return "Coverage Discovery";
            }
            case VALIDATION: {
                return "Coverage Validation";
            }
        }
        return "?";
    }
}

