/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EtsiSignatureType {
    PROOFOFORIGIN,
    PROOFOFRECEIPT,
    PROOFOFDELIVERY,
    PROOFOFSENDER,
    PROOFOFAPPROVAL,
    PROOFOFCREATION,
    NULL;


    public static EtsiSignatureType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ProofOfOrigin".equals(codeString)) {
            return PROOFOFORIGIN;
        }
        if ("ProofOfReceipt".equals(codeString)) {
            return PROOFOFRECEIPT;
        }
        if ("ProofOfDelivery".equals(codeString)) {
            return PROOFOFDELIVERY;
        }
        if ("ProofOfSender".equals(codeString)) {
            return PROOFOFSENDER;
        }
        if ("ProofOfapproval".equals(codeString)) {
            return PROOFOFAPPROVAL;
        }
        if ("ProofOfCreation".equals(codeString)) {
            return PROOFOFCREATION;
        }
        throw new FHIRException("Unknown EtsiSignatureType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROOFOFORIGIN: {
                return "ProofOfOrigin";
            }
            case PROOFOFRECEIPT: {
                return "ProofOfReceipt";
            }
            case PROOFOFDELIVERY: {
                return "ProofOfDelivery";
            }
            case PROOFOFSENDER: {
                return "ProofOfSender";
            }
            case PROOFOFAPPROVAL: {
                return "ProofOfapproval";
            }
            case PROOFOFCREATION: {
                return "ProofOfCreation";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://uri.etsi.org/01903/v1.2.2";
    }

    public String getDefinition() {
        switch (this) {
            case PROOFOFORIGIN: {
                return "indicates that the signer recognizes to have created, approved and sent the signed data object.";
            }
            case PROOFOFRECEIPT: {
                return "indicates that signer recognizes to have received the content of the signed data object.";
            }
            case PROOFOFDELIVERY: {
                return "indicates that the TSP providing that indication has delivered a signed data object in a local store accessible to the recipient of the signed data object.";
            }
            case PROOFOFSENDER: {
                return "indicates that the entity providing that indication has sent the signed data object (but not necessarily created it).";
            }
            case PROOFOFAPPROVAL: {
                return "indicates that the signer has approved the content of the signed data object.";
            }
            case PROOFOFCREATION: {
                return "indicates that the signer has created the signed data object (but not necessarily approved, nor sent it).";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROOFOFORIGIN: {
                return "Proof of origin";
            }
            case PROOFOFRECEIPT: {
                return "Proof of receipt";
            }
            case PROOFOFDELIVERY: {
                return "Proof of delivery";
            }
            case PROOFOFSENDER: {
                return "Proof of sender";
            }
            case PROOFOFAPPROVAL: {
                return "Proof of approval";
            }
            case PROOFOFCREATION: {
                return "Proof of creation";
            }
        }
        return "?";
    }
}

