/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.EtsiSignatureType;

public class EtsiSignatureTypeEnumFactory
implements EnumFactory<EtsiSignatureType> {
    @Override
    public EtsiSignatureType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ProofOfOrigin".equals(codeString)) {
            return EtsiSignatureType.PROOFOFORIGIN;
        }
        if ("ProofOfReceipt".equals(codeString)) {
            return EtsiSignatureType.PROOFOFRECEIPT;
        }
        if ("ProofOfDelivery".equals(codeString)) {
            return EtsiSignatureType.PROOFOFDELIVERY;
        }
        if ("ProofOfSender".equals(codeString)) {
            return EtsiSignatureType.PROOFOFSENDER;
        }
        if ("ProofOfapproval".equals(codeString)) {
            return EtsiSignatureType.PROOFOFAPPROVAL;
        }
        if ("ProofOfCreation".equals(codeString)) {
            return EtsiSignatureType.PROOFOFCREATION;
        }
        throw new IllegalArgumentException("Unknown EtsiSignatureType code '" + codeString + "'");
    }

    @Override
    public String toCode(EtsiSignatureType code) {
        if (code == EtsiSignatureType.PROOFOFORIGIN) {
            return "ProofOfOrigin";
        }
        if (code == EtsiSignatureType.PROOFOFRECEIPT) {
            return "ProofOfReceipt";
        }
        if (code == EtsiSignatureType.PROOFOFDELIVERY) {
            return "ProofOfDelivery";
        }
        if (code == EtsiSignatureType.PROOFOFSENDER) {
            return "ProofOfSender";
        }
        if (code == EtsiSignatureType.PROOFOFAPPROVAL) {
            return "ProofOfapproval";
        }
        if (code == EtsiSignatureType.PROOFOFCREATION) {
            return "ProofOfCreation";
        }
        return "?";
    }

    @Override
    public String toSystem(EtsiSignatureType code) {
        return code.getSystem();
    }
}

