/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.ExtensionContextType;

public class ExtensionContextTypeEnumFactory
implements EnumFactory<ExtensionContextType> {
    @Override
    public ExtensionContextType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("fhirpath".equals(codeString)) {
            return ExtensionContextType.FHIRPATH;
        }
        if ("element".equals(codeString)) {
            return ExtensionContextType.ELEMENT;
        }
        if ("extension".equals(codeString)) {
            return ExtensionContextType.EXTENSION;
        }
        throw new IllegalArgumentException("Unknown ExtensionContextType code '" + codeString + "'");
    }

    @Override
    public String toCode(ExtensionContextType code) {
        if (code == ExtensionContextType.FHIRPATH) {
            return "fhirpath";
        }
        if (code == ExtensionContextType.ELEMENT) {
            return "element";
        }
        if (code == ExtensionContextType.EXTENSION) {
            return "extension";
        }
        return "?";
    }

    @Override
    public String toSystem(ExtensionContextType code) {
        return code.getSystem();
    }
}

