/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.FmStatus;

public class FmStatusEnumFactory
implements EnumFactory<FmStatus> {
    @Override
    public FmStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return FmStatus.ACTIVE;
        }
        if ("cancelled".equals(codeString)) {
            return FmStatus.CANCELLED;
        }
        if ("draft".equals(codeString)) {
            return FmStatus.DRAFT;
        }
        if ("entered-in-error".equals(codeString)) {
            return FmStatus.ENTEREDINERROR;
        }
        throw new IllegalArgumentException("Unknown FmStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(FmStatus code) {
        if (code == FmStatus.ACTIVE) {
            return "active";
        }
        if (code == FmStatus.CANCELLED) {
            return "cancelled";
        }
        if (code == FmStatus.DRAFT) {
            return "draft";
        }
        if (code == FmStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        return "?";
    }

    @Override
    public String toSystem(FmStatus code) {
        return code.getSystem();
    }
}

