/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.GoalStatusReason;

public class GoalStatusReasonEnumFactory
implements EnumFactory<GoalStatusReason> {
    @Override
    public GoalStatusReason fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("surgery".equals(codeString)) {
            return GoalStatusReason.SURGERY;
        }
        if ("life-event".equals(codeString)) {
            return GoalStatusReason.LIFEEVENT;
        }
        if ("replaced".equals(codeString)) {
            return GoalStatusReason.REPLACED;
        }
        if ("patient-request".equals(codeString)) {
            return GoalStatusReason.PATIENTREQUEST;
        }
        if ("temp-not-attainable".equals(codeString)) {
            return GoalStatusReason.TEMPNOTATTAINABLE;
        }
        if ("permanent-not-attainable".equals(codeString)) {
            return GoalStatusReason.PERMANENTNOTATTAINABLE;
        }
        if ("financial-barrier".equals(codeString)) {
            return GoalStatusReason.FINANCIALBARRIER;
        }
        if ("lack-of-transportation".equals(codeString)) {
            return GoalStatusReason.LACKOFTRANSPORTATION;
        }
        if ("lack-of-social-support".equals(codeString)) {
            return GoalStatusReason.LACKOFSOCIALSUPPORT;
        }
        throw new IllegalArgumentException("Unknown GoalStatusReason code '" + codeString + "'");
    }

    @Override
    public String toCode(GoalStatusReason code) {
        if (code == GoalStatusReason.SURGERY) {
            return "surgery";
        }
        if (code == GoalStatusReason.LIFEEVENT) {
            return "life-event";
        }
        if (code == GoalStatusReason.REPLACED) {
            return "replaced";
        }
        if (code == GoalStatusReason.PATIENTREQUEST) {
            return "patient-request";
        }
        if (code == GoalStatusReason.TEMPNOTATTAINABLE) {
            return "temp-not-attainable";
        }
        if (code == GoalStatusReason.PERMANENTNOTATTAINABLE) {
            return "permanent-not-attainable";
        }
        if (code == GoalStatusReason.FINANCIALBARRIER) {
            return "financial-barrier";
        }
        if (code == GoalStatusReason.LACKOFTRANSPORTATION) {
            return "lack-of-transportation";
        }
        if (code == GoalStatusReason.LACKOFSOCIALSUPPORT) {
            return "lack-of-social-support";
        }
        return "?";
    }

    @Override
    public String toSystem(GoalStatusReason code) {
        return code.getSystem();
    }
}

