/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.GroupMeasure;

public class GroupMeasureEnumFactory
implements EnumFactory<GroupMeasure> {
    @Override
    public GroupMeasure fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("mean".equals(codeString)) {
            return GroupMeasure.MEAN;
        }
        if ("median".equals(codeString)) {
            return GroupMeasure.MEDIAN;
        }
        if ("mean-of-mean".equals(codeString)) {
            return GroupMeasure.MEANOFMEAN;
        }
        if ("mean-of-median".equals(codeString)) {
            return GroupMeasure.MEANOFMEDIAN;
        }
        if ("median-of-mean".equals(codeString)) {
            return GroupMeasure.MEDIANOFMEAN;
        }
        if ("median-of-median".equals(codeString)) {
            return GroupMeasure.MEDIANOFMEDIAN;
        }
        throw new IllegalArgumentException("Unknown GroupMeasure code '" + codeString + "'");
    }

    @Override
    public String toCode(GroupMeasure code) {
        if (code == GroupMeasure.MEAN) {
            return "mean";
        }
        if (code == GroupMeasure.MEDIAN) {
            return "median";
        }
        if (code == GroupMeasure.MEANOFMEAN) {
            return "mean-of-mean";
        }
        if (code == GroupMeasure.MEANOFMEDIAN) {
            return "mean-of-median";
        }
        if (code == GroupMeasure.MEDIANOFMEAN) {
            return "median-of-mean";
        }
        if (code == GroupMeasure.MEDIANOFMEDIAN) {
            return "median-of-median";
        }
        return "?";
    }

    @Override
    public String toSystem(GroupMeasure code) {
        return code.getSystem();
    }
}

